package org.openapijsonschematools.client.components.schemas
import org.openapijsonschematools.client.configurations.JsonSchemaKeyword
import org.openapijsonschematools.client.configurations.SchemaConfiguration
import org.openapijsonschematools.client.exceptions.ValidationException
import org.openapijsonschematools.client.schemas.IntJsonSchema
import org.openapijsonschematools.client.schemas.StringJsonSchema
import org.openapijsonschematools.client.schemas.validation.FrozenList
import org.openapijsonschematools.client.schemas.validation.JsonSchema
import org.openapijsonschematools.client.schemas.validation.ListSchemaValidator
import org.openapijsonschematools.client.schemas.validation.PathToSchemasMap
import org.openapijsonschematools.client.schemas.validation.ValidationMetadata

class PrefixitemsValidationAdjustsTheStartingIndexForItems {
    // nest classes so all schemas and input/output classes can be public
    
    
    class Items : IntJsonSchema.IntJsonSchema1() {
        companion object {
            @Volatile
            private var instance: Items? = null
    
            fun getInstance() =
                instance ?: synchronized(this) {
                    instance ?: Items().also { instance = it }
                }
        }
    }
    
    
    class PrefixitemsValidationAdjustsTheStartingIndexForItemsList(m: FrozenList<Any>) : FrozenList<Any>(m) {
        companion object {
            @Throws(ValidationException::class)
            fun of(arg: List<Any>, configuration: SchemaConfiguration?): PrefixitemsValidationAdjustsTheStartingIndexForItemsList {
                return PrefixitemsValidationAdjustsTheStartingIndexForItems1.getInstance().validate(arg, configuration)
            }
        }
    }
    
    class PrefixitemsValidationAdjustsTheStartingIndexForItemsListBuilder {
        // class to build List<Any>
        private val list: MutableList<Any>
    
        init {
            this.list = ArrayList()
        }
    
        
        fun add(item: Int): PrefixitemsValidationAdjustsTheStartingIndexForItemsListBuilder {
            list.add(item)
            return this
        }
        
        fun add(item: Float): PrefixitemsValidationAdjustsTheStartingIndexForItemsListBuilder {
            list.add(item)
            return this
        }
        
        fun add(item: Long): PrefixitemsValidationAdjustsTheStartingIndexForItemsListBuilder {
            list.add(item)
            return this
        }
        
        fun add(item: Double): PrefixitemsValidationAdjustsTheStartingIndexForItemsListBuilder {
            list.add(item)
            return this
        }
        
        fun add(item: String): PrefixitemsValidationAdjustsTheStartingIndexForItemsListBuilder {
            list.add(item)
            return this
        }
    
        fun build(): List<Any> {
            return list
        }
    }
    
    
    class Schema0 : StringJsonSchema.StringJsonSchema1() {
        companion object {
            @Volatile
            private var instance: Schema0? = null
    
            fun getInstance() =
                instance ?: synchronized(this) {
                    instance ?: Schema0().also { instance = it }
                }
        }
    }
    
    
    sealed interface PrefixitemsValidationAdjustsTheStartingIndexForItems1Boxed {
        fun getData(): Any?
    }
    
    data class PrefixitemsValidationAdjustsTheStartingIndexForItems1BoxedList(val data: PrefixitemsValidationAdjustsTheStartingIndexForItemsList) : PrefixitemsValidationAdjustsTheStartingIndexForItems1Boxed {
        override fun getData(): Any? {
            return data
        }
    }
    
    
    
    class PrefixitemsValidationAdjustsTheStartingIndexForItems1 private constructor(): JsonSchema<PrefixitemsValidationAdjustsTheStartingIndexForItems1Boxed>(
        type = setOf(List::class.java),
        items = Items::class.java,
        prefixItems = listOf(
            Schema0::class.java
        ),
    ), ListSchemaValidator<PrefixitemsValidationAdjustsTheStartingIndexForItemsList, PrefixitemsValidationAdjustsTheStartingIndexForItems1BoxedList> {
        /*
        NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
        Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
    
        Do not edit the class manually.
        */
    
        companion object {
            @Volatile
            private var instance: PrefixitemsValidationAdjustsTheStartingIndexForItems1? = null
    
            fun getInstance() =
                instance ?: synchronized(this) {
                    instance ?: PrefixitemsValidationAdjustsTheStartingIndexForItems1().also { instance = it }
                }
        }
        
        override fun getNewInstance(arg: List<*>, pathToItem: List<Any>, pathToSchemas: PathToSchemasMap): PrefixitemsValidationAdjustsTheStartingIndexForItemsList {
            val items: MutableList<Any> = ArrayList()
            var i: Int = 0
            for (item: Any? in arg) {
                val itemPathToItem: List<Any> = pathToItem + i
                val schemas: LinkedHashMap<JsonSchema<*>, Nothing?>? = pathToSchemas.get(itemPathToItem)
                if (schemas == null) {
                    throw RuntimeException("Validation result is invalid, schemas must exist for a pathToItem")
                }
                val itemSchema: JsonSchema<*> = schemas.entries.iterator().next().key
                val itemInstance: Any? = itemSchema.getNewInstance(item, itemPathToItem, pathToSchemas)
                if (!(itemInstance is Any)) {
                    throw RuntimeException("Invalid instantiated value")
                }
                items.add(itemInstance)
                i += 1
            }
            val newInstanceItems: FrozenList<Any> = FrozenList(items)
            return PrefixitemsValidationAdjustsTheStartingIndexForItemsList(newInstanceItems)
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: List<*>, configuration: SchemaConfiguration?): PrefixitemsValidationAdjustsTheStartingIndexForItemsList {
            val pathSet: MutableSet<List<Any>> = HashSet()
            val pathToItem = listOf<Any>("args[0")
            val castArg = castToAllowedTypes(arg, pathToItem, pathSet)
            val usedConfiguration = configuration ?: SchemaConfiguration()
            val validationMetadata = ValidationMetadata(pathToItem, usedConfiguration, PathToSchemasMap(), LinkedHashSet())
            val pathToSchemasMap = getPathToSchemas(this, castArg, validationMetadata, pathSet)
            return getNewInstance(castArg, validationMetadata.pathToItem, pathToSchemasMap)
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: Any?, configuration: SchemaConfiguration?): Any? {
            if (arg is List<*>) {
                return validate(arg, configuration)
            }
            throw ValidationException("Invalid input type="+getClass(arg)+". It can't be validated by this schema")
        }        
        override fun getNewInstance(arg: Any?, pathToItem: List<Any>, pathToSchemas: PathToSchemasMap): Any? {
            if (arg is List<*>) {
                return getNewInstance(arg, pathToItem, pathToSchemas)
            }
            throw RuntimeException("Invalid input type="+getClass(arg)+". It can't be instantiated by this schema")
        }
        @Throws(ValidationException::class)
        override fun validateAndBox(arg: List<*>, configuration: SchemaConfiguration?): PrefixitemsValidationAdjustsTheStartingIndexForItems1BoxedList {
            return PrefixitemsValidationAdjustsTheStartingIndexForItems1BoxedList(validate(arg, configuration))
        }
        @Throws(ValidationException::class)
        override fun validateAndBox(arg: Any?, configuration: SchemaConfiguration?): PrefixitemsValidationAdjustsTheStartingIndexForItems1Boxed {
            if (arg is List<*>) {
                return validateAndBox(arg, configuration)
            }
            throw ValidationException("Invalid input type="+getClass(arg)+". It can't be validated by this schema")
        }
    }
}
