package org.openapijsonschematools.client.components.schemas
import org.openapijsonschematools.client.configurations.JsonSchemaKeyword
import org.openapijsonschematools.client.configurations.SchemaConfiguration
import org.openapijsonschematools.client.exceptions.ValidationException
import org.openapijsonschematools.client.schemas.NullJsonSchema
import org.openapijsonschematools.client.schemas.validation.FrozenList
import org.openapijsonschematools.client.schemas.validation.JsonSchema
import org.openapijsonschematools.client.schemas.validation.ListSchemaValidator
import org.openapijsonschematools.client.schemas.validation.PathToSchemasMap
import org.openapijsonschematools.client.schemas.validation.ValidationMetadata

class ItemsWithNullInstanceElements {
    // nest classes so all schemas and input/output classes can be public
    
    
    class Items : NullJsonSchema.NullJsonSchema1() {
        companion object {
            @Volatile
            private var instance: Items? = null
    
            fun getInstance() =
                instance ?: synchronized(this) {
                    instance ?: Items().also { instance = it }
                }
        }
    }
    
    
    class ItemsWithNullInstanceElementsList(m: FrozenList<Nothing?>) : FrozenList<Nothing?>(m) {
        companion object {
            @Throws(ValidationException::class)
            fun of(arg: List<Nothing?>, configuration: SchemaConfiguration?): ItemsWithNullInstanceElementsList {
                return ItemsWithNullInstanceElements1.getInstance().validate(arg, configuration)
            }
        }
    }
    
    class ItemsWithNullInstanceElementsListBuilder {
        // class to build List<Nothing?>
        private val list: MutableList<Nothing?>
    
        init {
            this.list = ArrayList()
        }
    
        
        fun add(item: Nothing?): ItemsWithNullInstanceElementsListBuilder {
            list.add(null)
            return this
        }
    
        fun build(): List<Nothing?> {
            return list
        }
    }
    
    
    sealed interface ItemsWithNullInstanceElements1Boxed {
        fun getData(): Any?
    }
    
    data class ItemsWithNullInstanceElements1BoxedList(val data: ItemsWithNullInstanceElementsList) : ItemsWithNullInstanceElements1Boxed {
        override fun getData(): Any? {
            return data
        }
    }
    
    
    
    class ItemsWithNullInstanceElements1 private constructor(): JsonSchema<ItemsWithNullInstanceElements1Boxed>(
        type = setOf(List::class.java),
        items = Items::class.java,
    ), ListSchemaValidator<ItemsWithNullInstanceElementsList, ItemsWithNullInstanceElements1BoxedList> {
        /*
        NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
        Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
    
        Do not edit the class manually.
        */
    
        companion object {
            @Volatile
            private var instance: ItemsWithNullInstanceElements1? = null
    
            fun getInstance() =
                instance ?: synchronized(this) {
                    instance ?: ItemsWithNullInstanceElements1().also { instance = it }
                }
        }
        
        override fun getNewInstance(arg: List<*>, pathToItem: List<Any>, pathToSchemas: PathToSchemasMap): ItemsWithNullInstanceElementsList {
            val items: MutableList<Nothing?> = ArrayList()
            var i: Int = 0
            for (item: Any? in arg) {
                val itemPathToItem: List<Any> = pathToItem + i
                val schemas: LinkedHashMap<JsonSchema<*>, Nothing?>? = pathToSchemas.get(itemPathToItem)
                if (schemas == null) {
                    throw RuntimeException("Validation result is invalid, schemas must exist for a pathToItem")
                }
                val itemSchema: JsonSchema<*> = schemas.entries.iterator().next().key
                val itemInstance: Any? = itemSchema.getNewInstance(item, itemPathToItem, pathToSchemas)
                if (!(itemInstance == null || itemInstance is Nothing?)) {
                    throw RuntimeException("Invalid instantiated value")
                }
                items.add(itemInstance)
                i += 1
            }
            val newInstanceItems: FrozenList<Nothing?> = FrozenList(items)
            return ItemsWithNullInstanceElementsList(newInstanceItems)
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: List<*>, configuration: SchemaConfiguration?): ItemsWithNullInstanceElementsList {
            val pathSet: MutableSet<List<Any>> = HashSet()
            val pathToItem = listOf<Any>("args[0")
            val castArg = castToAllowedTypes(arg, pathToItem, pathSet)
            val usedConfiguration = configuration ?: SchemaConfiguration()
            val validationMetadata = ValidationMetadata(pathToItem, usedConfiguration, PathToSchemasMap(), LinkedHashSet())
            val pathToSchemasMap = getPathToSchemas(this, castArg, validationMetadata, pathSet)
            return getNewInstance(castArg, validationMetadata.pathToItem, pathToSchemasMap)
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: Any?, configuration: SchemaConfiguration?): Any? {
            if (arg is List<*>) {
                return validate(arg, configuration)
            }
            throw ValidationException("Invalid input type="+getClass(arg)+". It can't be validated by this schema")
        }        
        override fun getNewInstance(arg: Any?, pathToItem: List<Any>, pathToSchemas: PathToSchemasMap): Any? {
            if (arg is List<*>) {
                return getNewInstance(arg, pathToItem, pathToSchemas)
            }
            throw RuntimeException("Invalid input type="+getClass(arg)+". It can't be instantiated by this schema")
        }
        @Throws(ValidationException::class)
        override fun validateAndBox(arg: List<*>, configuration: SchemaConfiguration?): ItemsWithNullInstanceElements1BoxedList {
            return ItemsWithNullInstanceElements1BoxedList(validate(arg, configuration))
        }
        @Throws(ValidationException::class)
        override fun validateAndBox(arg: Any?, configuration: SchemaConfiguration?): ItemsWithNullInstanceElements1Boxed {
            if (arg is List<*>) {
                return validateAndBox(arg, configuration)
            }
            throw ValidationException("Invalid input type="+getClass(arg)+". It can't be validated by this schema")
        }
    }
}
