package org.openapijsonschematools.client.components.schemas
import org.openapijsonschematools.client.configurations.JsonSchemaKeyword
import org.openapijsonschematools.client.configurations.SchemaConfiguration
import org.openapijsonschematools.client.exceptions.ValidationException
import org.openapijsonschematools.client.schemas.validation.BooleanEnumValidator
import org.openapijsonschematools.client.schemas.validation.BooleanSchemaValidator
import org.openapijsonschematools.client.schemas.validation.BooleanValueMethod
import org.openapijsonschematools.client.schemas.validation.JsonSchema
import org.openapijsonschematools.client.schemas.validation.PathToSchemasMap
import org.openapijsonschematools.client.schemas.validation.ValidationMetadata

class EnumWithFalseDoesNotMatch0 {
    // nest classes so all schemas and input/output classes can be public
    
    enum class BooleanEnumWithFalseDoesNotMatch0Enums(private val value: Boolean): BooleanValueMethod {
        FALSE(false);
    
        override fun value(): Boolean {
            return this.value
        }
    }
    
    
    sealed interface EnumWithFalseDoesNotMatch01Boxed {
        fun getData(): Any?
    }
    
    data class EnumWithFalseDoesNotMatch01BoxedBoolean(val data: Boolean): EnumWithFalseDoesNotMatch01Boxed {
        override fun getData(): Any? {
            return data
        }
    }
    
    
    
    class EnumWithFalseDoesNotMatch01 private constructor(): JsonSchema<EnumWithFalseDoesNotMatch01Boxed>(
        type = setOf(Boolean::class.java),
        enumValues = setOf(
            false
        ),
    ), BooleanSchemaValidator<EnumWithFalseDoesNotMatch01BoxedBoolean>, BooleanEnumValidator<BooleanEnumWithFalseDoesNotMatch0Enums> {
        /*
        NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
        Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
    
        Do not edit the class manually.
        */
    
        companion object {
            @Volatile
            private var instance: EnumWithFalseDoesNotMatch01? = null
    
            fun getInstance() =
                instance ?: synchronized(this) {
                    instance ?: EnumWithFalseDoesNotMatch01().also { instance = it }
                }
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: Boolean, configuration: SchemaConfiguration?): Boolean {
            val pathSet: MutableSet<List<Any>> = HashSet()
            val pathToItem = listOf<Any>("args[0")
            val castArg = castToAllowedTypes(arg, pathToItem, pathSet)
            val usedConfiguration = configuration ?: SchemaConfiguration()
            val validationMetadata = ValidationMetadata(pathToItem, usedConfiguration, PathToSchemasMap(), LinkedHashSet())
            getPathToSchemas(this, castArg, validationMetadata, pathSet)
            return castArg
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: BooleanEnumWithFalseDoesNotMatch0Enums, configuration: SchemaConfiguration?): Boolean {
            return validate(arg.value(), configuration)
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: Any?, configuration: SchemaConfiguration?): Any? {
            if (arg is Boolean) {
                return validate(arg, configuration)
            }
            throw ValidationException("Invalid input type="+getClass(arg)+". It can't be validated by this schema")
        }        
        override fun getNewInstance(arg: Any?, pathToItem: List<Any>, pathToSchemas: PathToSchemasMap): Any? {
            if (arg is Boolean) {
                return arg
            }
            throw RuntimeException("Invalid input type="+getClass(arg)+". It can't be instantiated by this schema")
        }
        @Throws(ValidationException::class)
        override fun validateAndBox(arg: Boolean, configuration: SchemaConfiguration?): EnumWithFalseDoesNotMatch01BoxedBoolean {
            return EnumWithFalseDoesNotMatch01BoxedBoolean(validate(arg, configuration))
        }
        @Throws(ValidationException::class)
        override fun validateAndBox(arg: Any?, configuration: SchemaConfiguration?): EnumWithFalseDoesNotMatch01Boxed {
            if (arg is Boolean) {
                return validateAndBox(arg, configuration)
            }
            throw ValidationException("Invalid input type="+getClass(arg)+". It can't be validated by this schema")
        }
    }
}
