package org.openapijsonschematools.client.components.schemas
import org.openapijsonschematools.client.configurations.JsonSchemaKeyword
import org.openapijsonschematools.client.configurations.SchemaConfiguration
import org.openapijsonschematools.client.exceptions.ValidationException
import org.openapijsonschematools.client.schemas.validation.JsonSchema
import org.openapijsonschematools.client.schemas.validation.PathToSchemasMap
import org.openapijsonschematools.client.schemas.validation.StringEnumValidator
import org.openapijsonschematools.client.schemas.validation.StringSchemaValidator
import org.openapijsonschematools.client.schemas.validation.StringValueMethod
import org.openapijsonschematools.client.schemas.validation.ValidationMetadata

class EnumWithEscapedCharacters {
    // nest classes so all schemas and input/output classes can be public
    
    enum class StringEnumWithEscapedCharactersEnums(private val value: String): StringValueMethod {
        FOO_LINE_FEED_LF_BAR("foo\nbar"),
        FOO_CARRIAGE_RETURN_CR_BAR("foo\rbar");
    
        override fun value(): String {
            return this.value
        }
    }
    
    
    sealed interface EnumWithEscapedCharacters1Boxed {
        fun getData(): Any?
    }
    
    data class EnumWithEscapedCharacters1BoxedString(val data: String) : EnumWithEscapedCharacters1Boxed {
        override fun getData(): Any? {
            return data
        }
    }
    
    
    
    class EnumWithEscapedCharacters1 private constructor(): JsonSchema<EnumWithEscapedCharacters1Boxed>(
        type = setOf(
            String::class.java
        ),
        enumValues = setOf(
            "foo\nbar",
            "foo\rbar"
        ),
    ), StringSchemaValidator<EnumWithEscapedCharacters1BoxedString>, StringEnumValidator<StringEnumWithEscapedCharactersEnums> {
        /*
        NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
        Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
    
        Do not edit the class manually.
        */
    
        companion object {
            @Volatile
            private var instance: EnumWithEscapedCharacters1? = null
    
            fun getInstance() =
                instance ?: synchronized(this) {
                    instance ?: EnumWithEscapedCharacters1().also { instance = it }
                }
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: String, configuration: SchemaConfiguration?): String {
            val pathSet: MutableSet<List<Any>> = HashSet()
            val pathToItem = listOf<Any>("args[0")
            val castArg = castToAllowedTypes(arg, pathToItem, pathSet)
            val usedConfiguration = configuration ?: SchemaConfiguration()
            val validationMetadata = ValidationMetadata(pathToItem, usedConfiguration, PathToSchemasMap(), LinkedHashSet())
            getPathToSchemas(this, castArg, validationMetadata, pathSet)
            return castArg
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: StringEnumWithEscapedCharactersEnums, configuration: SchemaConfiguration?): String {
            return validate(arg.value(), configuration)
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: Any?, configuration: SchemaConfiguration?): Any? {
            if (arg is String) {
                return validate(arg, configuration)
            }
            throw ValidationException("Invalid input type="+getClass(arg)+". It can't be validated by this schema")
        }        
        override fun getNewInstance(arg: Any?, pathToItem: List<Any>, pathToSchemas: PathToSchemasMap): Any? {
            if (arg is String) {
                return arg
            }
            throw RuntimeException("Invalid input type="+getClass(arg)+". It can't be instantiated by this schema")
        }
        @Throws(ValidationException::class)
        override fun validateAndBox(arg: String, configuration: SchemaConfiguration?): EnumWithEscapedCharacters1BoxedString {
            return EnumWithEscapedCharacters1BoxedString(validate(arg, configuration))
        }
        @Throws(ValidationException::class)
        override fun validateAndBox(arg: Any?, configuration: SchemaConfiguration?): EnumWithEscapedCharacters1Boxed {
            if (arg is String) {
                return validateAndBox(arg, configuration)
            }
            throw ValidationException("Invalid input type="+getClass(arg)+". It can't be validated by this schema")
        }
    }
}
