package org.openapijsonschematools.client.components.schemas
import java.math.BigDecimal
import org.openapijsonschematools.client.configurations.JsonSchemaKeyword
import org.openapijsonschematools.client.configurations.SchemaConfiguration
import org.openapijsonschematools.client.exceptions.ValidationException
import org.openapijsonschematools.client.schemas.validation.DoubleEnumValidator
import org.openapijsonschematools.client.schemas.validation.DoubleValueMethod
import org.openapijsonschematools.client.schemas.validation.FloatEnumValidator
import org.openapijsonschematools.client.schemas.validation.FloatValueMethod
import org.openapijsonschematools.client.schemas.validation.IntegerEnumValidator
import org.openapijsonschematools.client.schemas.validation.IntegerValueMethod
import org.openapijsonschematools.client.schemas.validation.JsonSchema
import org.openapijsonschematools.client.schemas.validation.LongEnumValidator
import org.openapijsonschematools.client.schemas.validation.LongValueMethod
import org.openapijsonschematools.client.schemas.validation.NumberSchemaValidator
import org.openapijsonschematools.client.schemas.validation.PathToSchemasMap
import org.openapijsonschematools.client.schemas.validation.ValidationMetadata

class EnumWith0DoesNotMatchFalse {
    // nest classes so all schemas and input/output classes can be public
    
    enum class IntegerEnumWith0DoesNotMatchFalseEnums(private val value: Int): IntegerValueMethod {
        POSITIVE_0(0);
    
        override fun value(): Int {
            return this.value
        }
    }
    
    enum class LongEnumWith0DoesNotMatchFalseEnums(private val value: Long): LongValueMethod {
        POSITIVE_0(0L);
    
        override fun value(): Long {
            return this.value
        }
    }
    
    enum class FloatEnumWith0DoesNotMatchFalseEnums(private val value: Float): FloatValueMethod {
        POSITIVE_0(0.0f);
    
        override fun value(): Float {
            return this.value
        }
    }
    
    enum class DoubleEnumWith0DoesNotMatchFalseEnums(private val value: Double): DoubleValueMethod {
        POSITIVE_0(0.0);
    
        override fun value(): Double {
            return this.value
        }
    }
    
    
    sealed interface EnumWith0DoesNotMatchFalse1Boxed {
        fun getData(): Any?
    }
    
    data class EnumWith0DoesNotMatchFalse1BoxedNumber(val data: Number) : EnumWith0DoesNotMatchFalse1Boxed {
        override fun getData(): Any? {
            return data
        }
    }
    
    
    
    class EnumWith0DoesNotMatchFalse1 private constructor(): JsonSchema<EnumWith0DoesNotMatchFalse1Boxed>(
        type = setOf(
            Int::class.java,
            Long::class.java,
            Float::class.java,
            Double::class.java
        ),
        enumValues = setOf(
            BigDecimal("0")
        ),
    ), IntegerEnumValidator<IntegerEnumWith0DoesNotMatchFalseEnums>, LongEnumValidator<LongEnumWith0DoesNotMatchFalseEnums>, FloatEnumValidator<FloatEnumWith0DoesNotMatchFalseEnums>, DoubleEnumValidator<DoubleEnumWith0DoesNotMatchFalseEnums>, NumberSchemaValidator<EnumWith0DoesNotMatchFalse1BoxedNumber> {
        /*
        NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
        Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
    
        Do not edit the class manually.
        */
    
        companion object {
            @Volatile
            private var instance: EnumWith0DoesNotMatchFalse1? = null
    
            fun getInstance() =
                instance ?: synchronized(this) {
                    instance ?: EnumWith0DoesNotMatchFalse1().also { instance = it }
                }
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: Number, configuration: SchemaConfiguration?): Number {
            val pathSet: MutableSet<List<Any>> = HashSet()
            val pathToItem = listOf<Any>("args[0")
            val castArg = castToAllowedTypes(arg, pathToItem, pathSet)
            val usedConfiguration = configuration ?: SchemaConfiguration()
            val validationMetadata = ValidationMetadata(pathToItem, usedConfiguration, PathToSchemasMap(), LinkedHashSet())
            val pathToSchemasMap = getPathToSchemas(this, castArg, validationMetadata, pathSet)
            return castArg
        }
        
        @Throws(ValidationException::class)
        fun validate(arg: Int, configuration: SchemaConfiguration?): Int {
            return validate(arg as Number, configuration) as Int
        }
        
        @Throws(ValidationException::class)
        fun validate(arg: Long, configuration: SchemaConfiguration?): Long {
            return validate(arg as Number, configuration) as Long
        }
        
        @Throws(ValidationException::class)
        fun validate(arg: Float, configuration: SchemaConfiguration?): Float {
            return validate(arg as Number, configuration) as Float
        }
        
        @Throws(ValidationException::class)
        fun validate(arg: Double, configuration: SchemaConfiguration?): Double {
            return validate(arg as Number, configuration) as Double
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: IntegerEnumWith0DoesNotMatchFalseEnums, configuration: SchemaConfiguration?): Int {
            return validate(arg.value() as Number, configuration) as Int
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: LongEnumWith0DoesNotMatchFalseEnums, configuration: SchemaConfiguration?): Long {
            return validate(arg.value() as Number, configuration) as Long
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: FloatEnumWith0DoesNotMatchFalseEnums, configuration: SchemaConfiguration?): Float {
            return validate(arg.value() as Number, configuration) as Float
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: DoubleEnumWith0DoesNotMatchFalseEnums, configuration: SchemaConfiguration?): Double {
            return validate(arg.value() as Number, configuration) as Double
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: Any?, configuration: SchemaConfiguration?): Any? {
            if (arg is Number) {
                return validate(arg, configuration)
            }
            throw ValidationException("Invalid input type="+getClass(arg)+". It can't be validated by this schema")
        }        
        override fun getNewInstance(arg: Any?, pathToItem: List<Any>, pathToSchemas: PathToSchemasMap): Any? {
            if (arg is Number) {
                return arg
            }
            throw RuntimeException("Invalid input type="+getClass(arg)+". It can't be instantiated by this schema")
        }
        @Throws(ValidationException::class)
        override fun validateAndBox(arg: Number, configuration: SchemaConfiguration?): EnumWith0DoesNotMatchFalse1BoxedNumber {
            return EnumWith0DoesNotMatchFalse1BoxedNumber(validate(arg, configuration))
        }
        @Throws(ValidationException::class)
        override fun validateAndBox(arg: Any?, configuration: SchemaConfiguration?): EnumWith0DoesNotMatchFalse1Boxed {
            if (arg is Number) {
                return validateAndBox(arg, configuration)
            }
            throw ValidationException("Invalid input type="+getClass(arg)+". It can't be validated by this schema")
        }
    }
}
