package org.openapijsonschematools.client.components.schemas;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.openapijsonschematools.client.configurations.JsonSchemaKeywordFlags;
import org.openapijsonschematools.client.configurations.SchemaConfiguration;
import org.openapijsonschematools.client.exceptions.ValidationException;
import org.openapijsonschematools.client.schemas.IntJsonSchema;
import org.openapijsonschematools.client.schemas.StringJsonSchema;
import org.openapijsonschematools.client.schemas.validation.FrozenList;
import org.openapijsonschematools.client.schemas.validation.JsonSchema;
import org.openapijsonschematools.client.schemas.validation.JsonSchemaInfo;
import org.openapijsonschematools.client.schemas.validation.ListSchemaValidator;
import org.openapijsonschematools.client.schemas.validation.PathToSchemasMap;
import org.openapijsonschematools.client.schemas.validation.ValidationMetadata;

public class PrefixitemsValidationAdjustsTheStartingIndexForItems {
    // nest classes so all schemas and input/output classes can be public
    
    
    public static class Items extends IntJsonSchema.IntJsonSchema1 {
        private static @Nullable Items instance = null;
        public static Items getInstance() {
            if (instance == null) {
                instance = new Items();
            }
            return instance;
        }
    }
    
    
    public static class PrefixitemsValidationAdjustsTheStartingIndexForItemsList extends FrozenList<Object> {
        protected PrefixitemsValidationAdjustsTheStartingIndexForItemsList(FrozenList<Object> m) {
            super(m);
        }
        public static PrefixitemsValidationAdjustsTheStartingIndexForItemsList of(List<Object> arg, SchemaConfiguration configuration) throws ValidationException {
            return PrefixitemsValidationAdjustsTheStartingIndexForItems1.getInstance().validate(arg, configuration);
        }
    }
    
    public static class PrefixitemsValidationAdjustsTheStartingIndexForItemsListBuilder {
        // class to build List<Object>
        private final List<Object> list;
    
        public PrefixitemsValidationAdjustsTheStartingIndexForItemsListBuilder() {
            list = new ArrayList<>();
        }
    
        public PrefixitemsValidationAdjustsTheStartingIndexForItemsListBuilder(List<Object> list) {
            this.list = list;
        }
        
        public PrefixitemsValidationAdjustsTheStartingIndexForItemsListBuilder add(int item) {
            list.add(item);
            return this;
        }
        
        public PrefixitemsValidationAdjustsTheStartingIndexForItemsListBuilder add(float item) {
            list.add(item);
            return this;
        }
        
        public PrefixitemsValidationAdjustsTheStartingIndexForItemsListBuilder add(long item) {
            list.add(item);
            return this;
        }
        
        public PrefixitemsValidationAdjustsTheStartingIndexForItemsListBuilder add(double item) {
            list.add(item);
            return this;
        }
        
        public PrefixitemsValidationAdjustsTheStartingIndexForItemsListBuilder add(String item) {
            list.add(item);
            return this;
        }
    
        public List<Object> build() {
            return list;
        }
    }
    
    
    public static class Schema0 extends StringJsonSchema.StringJsonSchema1 {
        private static @Nullable Schema0 instance = null;
        public static Schema0 getInstance() {
            if (instance == null) {
                instance = new Schema0();
            }
            return instance;
        }
    }
    
    
    public sealed interface PrefixitemsValidationAdjustsTheStartingIndexForItems1Boxed permits PrefixitemsValidationAdjustsTheStartingIndexForItems1BoxedList {
        @Nullable Object getData();
    }
    
    public record PrefixitemsValidationAdjustsTheStartingIndexForItems1BoxedList(PrefixitemsValidationAdjustsTheStartingIndexForItemsList data) implements PrefixitemsValidationAdjustsTheStartingIndexForItems1Boxed {
        @Override
        public @Nullable Object getData() {
            return data;
        }
    }
    
    
    
    public static class PrefixitemsValidationAdjustsTheStartingIndexForItems1 extends JsonSchema<PrefixitemsValidationAdjustsTheStartingIndexForItems1Boxed> implements ListSchemaValidator<PrefixitemsValidationAdjustsTheStartingIndexForItemsList, PrefixitemsValidationAdjustsTheStartingIndexForItems1BoxedList> {
        /*
        NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
        Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
    
        Do not edit the class manually.
        */
        private static @Nullable PrefixitemsValidationAdjustsTheStartingIndexForItems1 instance = null;
    
        protected PrefixitemsValidationAdjustsTheStartingIndexForItems1() {
            super(new JsonSchemaInfo()
                .type(Set.of(List.class))
                .items(Items.class)
                .prefixItems(List.of(
                    Schema0.class
                ))
            );
        }
    
        public static PrefixitemsValidationAdjustsTheStartingIndexForItems1 getInstance() {
            if (instance == null) {
                instance = new PrefixitemsValidationAdjustsTheStartingIndexForItems1();
            }
            return instance;
        }
        
        @Override
        public PrefixitemsValidationAdjustsTheStartingIndexForItemsList getNewInstance(List<?> arg, List<Object> pathToItem, PathToSchemasMap pathToSchemas) {
            List<Object> items = new ArrayList<>();
            int i = 0;
            for (Object item: arg) {
                List<Object> itemPathToItem = new ArrayList<>(pathToItem);
                itemPathToItem.add(i);
                LinkedHashMap<JsonSchema<?>, Void> schemas = pathToSchemas.get(itemPathToItem);
                if (schemas == null) {
                    throw new RuntimeException("Validation result is invalid, schemas must exist for a pathToItem");
                }
                JsonSchema<?> itemSchema = schemas.entrySet().iterator().next().getKey();
                @Nullable Object itemInstance = itemSchema.getNewInstance(item, itemPathToItem, pathToSchemas);
                if (!(itemInstance instanceof Object)) {
                    throw new RuntimeException("Invalid instantiated value");
                }
                items.add((Object) itemInstance);
                i += 1;
            }
            FrozenList<Object> newInstanceItems = new FrozenList<>(items);
            return new PrefixitemsValidationAdjustsTheStartingIndexForItemsList(newInstanceItems);
        }
        
        public PrefixitemsValidationAdjustsTheStartingIndexForItemsList validate(List<?> arg, SchemaConfiguration configuration) throws ValidationException {
            Set<List<Object>> pathSet = new HashSet<>();
            List<Object> pathToItem = List.of("args[0");
            List<?> castArg = castToAllowedTypes(arg, pathToItem, pathSet);
            SchemaConfiguration usedConfiguration = Objects.requireNonNullElseGet(configuration, () -> new SchemaConfiguration(new JsonSchemaKeywordFlags.Builder().build()));
            ValidationMetadata validationMetadata = new ValidationMetadata(pathToItem, usedConfiguration, new PathToSchemasMap(), new LinkedHashSet<>());
            PathToSchemasMap pathToSchemasMap = getPathToSchemas(this, castArg, validationMetadata, pathSet);
            return getNewInstance(castArg, validationMetadata.pathToItem(), pathToSchemasMap);
        }
        
        @Override
        public @Nullable Object validate(@Nullable Object arg, SchemaConfiguration configuration) throws ValidationException {
            if (arg instanceof List) {
                return validate((List<?>) arg, configuration);
            }
            throw new ValidationException("Invalid input type="+getClass(arg)+". It can't be validated by this schema");
        }        
        @Override
        public @Nullable Object getNewInstance(@Nullable Object arg, List<Object> pathToItem, PathToSchemasMap pathToSchemas) {
            if (arg instanceof List) {
                return getNewInstance((List<?>) arg, pathToItem, pathToSchemas);
            }
            throw new RuntimeException("Invalid input type="+getClass(arg)+". It can't be instantiated by this schema");
        }
        @Override
        public PrefixitemsValidationAdjustsTheStartingIndexForItems1BoxedList validateAndBox(List<?> arg, SchemaConfiguration configuration) throws ValidationException {
            return new PrefixitemsValidationAdjustsTheStartingIndexForItems1BoxedList(validate(arg, configuration));
        }
        @Override
        public PrefixitemsValidationAdjustsTheStartingIndexForItems1Boxed validateAndBox(@Nullable Object arg, SchemaConfiguration configuration) throws ValidationException {
            if (arg instanceof List<?> castArg) {
                return validateAndBox(castArg, configuration);
            }
            throw new ValidationException("Invalid input type="+getClass(arg)+". It can't be validated by this schema");
        }
    }
}
