package org.openapijsonschematools.client.components.schemas;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.openapijsonschematools.client.configurations.JsonSchemaKeywordFlags;
import org.openapijsonschematools.client.configurations.SchemaConfiguration;
import org.openapijsonschematools.client.exceptions.ValidationException;
import org.openapijsonschematools.client.schemas.SetMaker;
import org.openapijsonschematools.client.schemas.validation.BooleanEnumValidator;
import org.openapijsonschematools.client.schemas.validation.BooleanSchemaValidator;
import org.openapijsonschematools.client.schemas.validation.BooleanValueMethod;
import org.openapijsonschematools.client.schemas.validation.JsonSchema;
import org.openapijsonschematools.client.schemas.validation.JsonSchemaInfo;
import org.openapijsonschematools.client.schemas.validation.PathToSchemasMap;
import org.openapijsonschematools.client.schemas.validation.ValidationMetadata;

public class EnumWithFalseDoesNotMatch0 {
    // nest classes so all schemas and input/output classes can be public
    
    public enum BooleanEnumWithFalseDoesNotMatch0Enums implements BooleanValueMethod {
        FALSE(false);
        private final boolean value;
    
        BooleanEnumWithFalseDoesNotMatch0Enums(boolean value) {
            this.value = value;
        }
        public boolean value() {
            return this.value;
        }
    }
    
    
    public sealed interface EnumWithFalseDoesNotMatch01Boxed permits EnumWithFalseDoesNotMatch01BoxedBoolean {
        @Nullable Object getData();
    }
    
    public record EnumWithFalseDoesNotMatch01BoxedBoolean(boolean data) implements EnumWithFalseDoesNotMatch01Boxed {
        @Override
        public @Nullable Object getData() {
            return data;
        }
    }
    
    
    
    public static class EnumWithFalseDoesNotMatch01 extends JsonSchema<EnumWithFalseDoesNotMatch01Boxed> implements BooleanSchemaValidator<EnumWithFalseDoesNotMatch01BoxedBoolean>, BooleanEnumValidator<BooleanEnumWithFalseDoesNotMatch0Enums> {
        /*
        NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
        Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
    
        Do not edit the class manually.
        */
        private static @Nullable EnumWithFalseDoesNotMatch01 instance = null;
    
        protected EnumWithFalseDoesNotMatch01() {
            super(new JsonSchemaInfo()
                .type(Set.of(Boolean.class))
                .enumValues(SetMaker.makeSet(
                    false
                ))
            );
        }
    
        public static EnumWithFalseDoesNotMatch01 getInstance() {
            if (instance == null) {
                instance = new EnumWithFalseDoesNotMatch01();
            }
            return instance;
        }
        
        @Override
        public boolean validate(boolean arg, SchemaConfiguration configuration) throws ValidationException {
            Set<List<Object>> pathSet = new HashSet<>();
            List<Object> pathToItem = List.of("args[0");
            boolean castArg = castToAllowedTypes(arg, pathToItem, pathSet);
            SchemaConfiguration usedConfiguration = Objects.requireNonNullElseGet(configuration, () -> new SchemaConfiguration(new JsonSchemaKeywordFlags.Builder().build()));
            ValidationMetadata validationMetadata = new ValidationMetadata(pathToItem, usedConfiguration, new PathToSchemasMap(), new LinkedHashSet<>());
            getPathToSchemas(this, castArg, validationMetadata, pathSet);
            return castArg;
        }
        
        @Override
        public boolean validate(BooleanEnumWithFalseDoesNotMatch0Enums arg,SchemaConfiguration configuration) throws ValidationException {
            return validate(arg.value(), configuration);
        }
        
        @Override
        public @Nullable Object validate(@Nullable Object arg, SchemaConfiguration configuration) throws ValidationException {
            if (arg instanceof Boolean) {
                boolean boolArg = (Boolean) arg;
                return validate(boolArg, configuration);
            }
            throw new ValidationException("Invalid input type="+getClass(arg)+". It can't be validated by this schema");
        }        
        @Override
        public @Nullable Object getNewInstance(@Nullable Object arg, List<Object> pathToItem, PathToSchemasMap pathToSchemas) {
            if (arg instanceof Boolean) {
                boolean boolArg = (Boolean) arg;
                return getNewInstance(boolArg, pathToItem, pathToSchemas);
            }
            throw new RuntimeException("Invalid input type="+getClass(arg)+". It can't be instantiated by this schema");
        }
        @Override
        public EnumWithFalseDoesNotMatch01BoxedBoolean validateAndBox(boolean arg, SchemaConfiguration configuration) throws ValidationException {
            return new EnumWithFalseDoesNotMatch01BoxedBoolean(validate(arg, configuration));
        }
        @Override
        public EnumWithFalseDoesNotMatch01Boxed validateAndBox(@Nullable Object arg, SchemaConfiguration configuration) throws ValidationException {
            if (arg instanceof Boolean booleanArg) {
                boolean castArg = booleanArg;
                return validateAndBox(castArg, configuration);
            }
            throw new ValidationException("Invalid input type="+getClass(arg)+". It can't be validated by this schema");
        }
    }
}
