# unit-test-api
sample spec for testing openapi functionality, built from json schema tests for draft2020-12

This Java package is automatically generated by the [OpenAPI JSON Schema Generator](https://github.com/openapi-json-schema-tools/openapi-json-schema-generator) project:

- OpenAPI document version: 0.0.1
- Java Package version: 0.0.1
- OpenAPI JSON Schema Generator, Generator: JavaClientGenerator

## Requirements

1. Java 17
2. Maven

## Installation

To install the API client library to your local Maven repository, simply execute:

```shell
mvn clean install
```

To deploy it to a remote Maven repository instead, configure the settings of the repository and execute:

```shell
mvn clean deploy
```

Refer to the [OSSRH Guide](http://central.sonatype.org/pages/ossrh-guide.html) for more information.

### Maven users

Add this dependency to your project's POM:

```xml
<dependency>
  <groupId>org.openapijsonschematools</groupId>
  <artifactId>unit-test-api</artifactId>
  <version>0.0.1</version>
  <scope>compile</scope>
</dependency>
```


## Usage Notes
### Validation, Immutability, and Data Type
This Java code validates data to schema classes and return back an immutable instance containing the data. This ensure that
- valid data cannot be mutated and become invalid to a set of schemas
  - the one exception is that files are not immutable, so schema instances storing/sending/receiving files are not immutable

Here is the mapping from json schema types to Java types:

| Json Schema Type | Java Base Class |
| ---------------- | --------------- |
| object           | FrozenMap (Map) |
| array            | FrozenList (List) |
| string           | String |
| number           | Number (int, long, float, double) |
| integer          | int, long, float, double (with values equal to integers) |
| boolean          | boolean |
| null             | Void (null) |
| AnyType (unset)  | @Nullable Object |

### Storage of Json Schema Definition in Java JsonSchema Classes
In openapi v3.0.3 there are ~ 28 json schema keywords. Almost all of them can apply if
type is unset. I have chosen to separate the storage of
- json schema definition info
- output classes for validated Map (json schema type object) payloads
- output classes for validated List (json schema type array) payloads

<details>
  <summary>Reason</summary>

This json schema data is stored in each class that is written for a schema, in a component or
other openapi document location. This class is only responsible for storing schema info.
Output classes like those that store map payloads are written separately and are
returned by the JsonSchema.validate method when that method is passed in Map input.
This prevents payload property access methods from
colliding with json schema definition.
</details>

### Json Schema Type Object
Most component schemas (models) are probably of type object. Which is a map data structure.
Json schema allows string keys in this map, which means schema properties can have key names that are
invalid Java variable names. Names like:
- "hi-there"
- "1variable"
- "@now"
- " "
- "from"

To allow these use cases to work, FrozenMap (which extends AbstractMap) is used as the base class of type object schemas.
This means that one can use normal Map methods on instances of these classes.

<details>
  <summary>Other Details</summary>

- getters are written for validly named required and optional properties
- null is only allowed in as a value if type: "null" was included or nullable: true was set
  - because null is an allowed property value, it is not used to represent an unset property state
- if an optional property is requested and it does not exist in the Map, an UnsetPropertyException is thrown
</details>

### Json Schema Type + Format, Validated Data Storage
N schemas can be validated on the same payload.
To allow multiple schemas to validate, the data must be stored using one base class whether or not
a json schema format constraint exists in the schema.

In json schema, type: number with no format validates both integers and floats,
so int and float values are stored for type number.

<details>
  <summary>String + Date Example</summary>

For example the string payload '2023-12-20' is validates to both of these schemas:
1. string only
```
- type: string
```
2. string and date format
```
- type: string
  format: date
```
Because of use cases like this, a LocalDate is allowed as an input to this schema, but the data
is stored as a string.
</details>

## Getting Started

Please follow the [installation procedure](#installation) and then use the JsonSchema classes in
org.openapijsonschematools.client.components.schemas to validate input payloads and instances of validated Map and List
output classes. Json schemas allow multiple types for one schema, so a schema's validate method can have
allowed input and output types.

## Servers
| server_index | Class | Description |
| ------------ | ----- | ----------- |
| 0 | [RootServer0](docs/servers/RootServer0.md) | |

## Endpoints
All URIs are relative to the selected server
- The server is selected by passing in serverInfo + serverIndexInfo into configurations.ApiConfiguration
- The security info is selected by passing in securityInfo + securityIndexInfo into configurations.ApiConfiguration
- serverIndex + securityIndex can also be passed in to endpoint calls, see endpoint documentation

| HTTP request | Methods | Description |
| ------------ | ------- | ----------- |

## Component Schemas
| Class | Description |
| ----- | ----------- |
| [ASchemaGivenForPrefixitems.ASchemaGivenForPrefixitems1](docs/components/schemas/ASchemaGivenForPrefixitems.md#aschemagivenforprefixitems1) | |
| [AdditionalItemsAreAllowedByDefault.AdditionalItemsAreAllowedByDefault1](docs/components/schemas/AdditionalItemsAreAllowedByDefault.md#additionalitemsareallowedbydefault1) | |
| [AdditionalpropertiesAreAllowedByDefault.AdditionalpropertiesAreAllowedByDefault1](docs/components/schemas/AdditionalpropertiesAreAllowedByDefault.md#additionalpropertiesareallowedbydefault1) | |
| [AdditionalpropertiesCanExistByItself.AdditionalpropertiesCanExistByItself1](docs/components/schemas/AdditionalpropertiesCanExistByItself.md#additionalpropertiescanexistbyitself1) | |
| [AdditionalpropertiesDoesNotLookInApplicators.AdditionalpropertiesDoesNotLookInApplicators1](docs/components/schemas/AdditionalpropertiesDoesNotLookInApplicators.md#additionalpropertiesdoesnotlookinapplicators1) | |
| [AdditionalpropertiesWithNullValuedInstanceProperties.AdditionalpropertiesWithNullValuedInstanceProperties1](docs/components/schemas/AdditionalpropertiesWithNullValuedInstanceProperties.md#additionalpropertieswithnullvaluedinstanceproperties1) | |
| [AdditionalpropertiesWithSchema.AdditionalpropertiesWithSchema1](docs/components/schemas/AdditionalpropertiesWithSchema.md#additionalpropertieswithschema1) | |
| [Allof.Allof1](docs/components/schemas/Allof.md#allof1) | |
| [AllofCombinedWithAnyofOneof.AllofCombinedWithAnyofOneof1](docs/components/schemas/AllofCombinedWithAnyofOneof.md#allofcombinedwithanyofoneof1) | |
| [AllofSimpleTypes.AllofSimpleTypes1](docs/components/schemas/AllofSimpleTypes.md#allofsimpletypes1) | |
| [AllofWithBaseSchema.AllofWithBaseSchema1](docs/components/schemas/AllofWithBaseSchema.md#allofwithbaseschema1) | |
| [AllofWithOneEmptySchema.AllofWithOneEmptySchema1](docs/components/schemas/AllofWithOneEmptySchema.md#allofwithoneemptyschema1) | |
| [AllofWithTheFirstEmptySchema.AllofWithTheFirstEmptySchema1](docs/components/schemas/AllofWithTheFirstEmptySchema.md#allofwiththefirstemptyschema1) | |
| [AllofWithTheLastEmptySchema.AllofWithTheLastEmptySchema1](docs/components/schemas/AllofWithTheLastEmptySchema.md#allofwiththelastemptyschema1) | |
| [AllofWithTwoEmptySchemas.AllofWithTwoEmptySchemas1](docs/components/schemas/AllofWithTwoEmptySchemas.md#allofwithtwoemptyschemas1) | |
| [Anyof.Anyof1](docs/components/schemas/Anyof.md#anyof1) | |
| [AnyofComplexTypes.AnyofComplexTypes1](docs/components/schemas/AnyofComplexTypes.md#anyofcomplextypes1) | |
| [AnyofWithBaseSchema.AnyofWithBaseSchema1](docs/components/schemas/AnyofWithBaseSchema.md#anyofwithbaseschema1) | |
| [AnyofWithOneEmptySchema.AnyofWithOneEmptySchema1](docs/components/schemas/AnyofWithOneEmptySchema.md#anyofwithoneemptyschema1) | |
| [ArrayTypeMatchesArrays.ArrayTypeMatchesArrays1](docs/components/schemas/ArrayTypeMatchesArrays.md#arraytypematchesarrays1) | |
| [BooleanTypeMatchesBooleans.BooleanTypeMatchesBooleans1](docs/components/schemas/BooleanTypeMatchesBooleans.md#booleantypematchesbooleans1) | |
| [ByInt.ByInt1](docs/components/schemas/ByInt.md#byint1) | |
| [ByNumber.ByNumber1](docs/components/schemas/ByNumber.md#bynumber1) | |
| [BySmallNumber.BySmallNumber1](docs/components/schemas/BySmallNumber.md#bysmallnumber1) | |
| [ConstNulCharactersInStrings.ConstNulCharactersInStrings1](docs/components/schemas/ConstNulCharactersInStrings.md#constnulcharactersinstrings1) | |
| [ContainsKeywordValidation.ContainsKeywordValidation1](docs/components/schemas/ContainsKeywordValidation.md#containskeywordvalidation1) | |
| [ContainsWithNullInstanceElements.ContainsWithNullInstanceElements1](docs/components/schemas/ContainsWithNullInstanceElements.md#containswithnullinstanceelements1) | |
| [DateFormat.DateFormat1](docs/components/schemas/DateFormat.md#dateformat1) | |
| [DateTimeFormat.DateTimeFormat1](docs/components/schemas/DateTimeFormat.md#datetimeformat1) | |
| [DependentSchemasDependenciesWithEscapedCharacters.DependentSchemasDependenciesWithEscapedCharacters1](docs/components/schemas/DependentSchemasDependenciesWithEscapedCharacters.md#dependentschemasdependencieswithescapedcharacters1) | |
| [DependentSchemasDependentSubschemaIncompatibleWithRoot.DependentSchemasDependentSubschemaIncompatibleWithRoot1](docs/components/schemas/DependentSchemasDependentSubschemaIncompatibleWithRoot.md#dependentschemasdependentsubschemaincompatiblewithroot1) | |
| [DependentSchemasSingleDependency.DependentSchemasSingleDependency1](docs/components/schemas/DependentSchemasSingleDependency.md#dependentschemassingledependency1) | |
| [DurationFormat.DurationFormat1](docs/components/schemas/DurationFormat.md#durationformat1) | |
| [EmailFormat.EmailFormat1](docs/components/schemas/EmailFormat.md#emailformat1) | |
| [EmptyDependents.EmptyDependents1](docs/components/schemas/EmptyDependents.md#emptydependents1) | |
| [EnumWith0DoesNotMatchFalse.EnumWith0DoesNotMatchFalse1](docs/components/schemas/EnumWith0DoesNotMatchFalse.md#enumwith0doesnotmatchfalse1) | |
| [EnumWith1DoesNotMatchTrue.EnumWith1DoesNotMatchTrue1](docs/components/schemas/EnumWith1DoesNotMatchTrue.md#enumwith1doesnotmatchtrue1) | |
| [EnumWithEscapedCharacters.EnumWithEscapedCharacters1](docs/components/schemas/EnumWithEscapedCharacters.md#enumwithescapedcharacters1) | |
| [EnumWithFalseDoesNotMatch0.EnumWithFalseDoesNotMatch01](docs/components/schemas/EnumWithFalseDoesNotMatch0.md#enumwithfalsedoesnotmatch01) | |
| [EnumWithTrueDoesNotMatch1.EnumWithTrueDoesNotMatch11](docs/components/schemas/EnumWithTrueDoesNotMatch1.md#enumwithtruedoesnotmatch11) | |
| [EnumsInProperties.EnumsInProperties1](docs/components/schemas/EnumsInProperties.md#enumsinproperties1) | |
| [ExclusivemaximumValidation.ExclusivemaximumValidation1](docs/components/schemas/ExclusivemaximumValidation.md#exclusivemaximumvalidation1) | |
| [ExclusiveminimumValidation.ExclusiveminimumValidation1](docs/components/schemas/ExclusiveminimumValidation.md#exclusiveminimumvalidation1) | |
| [FloatDivisionInf.FloatDivisionInf1](docs/components/schemas/FloatDivisionInf.md#floatdivisioninf1) | |
| [ForbiddenProperty.ForbiddenProperty1](docs/components/schemas/ForbiddenProperty.md#forbiddenproperty1) | |
| [HostnameFormat.HostnameFormat1](docs/components/schemas/HostnameFormat.md#hostnameformat1) | |
| [IdnEmailFormat.IdnEmailFormat1](docs/components/schemas/IdnEmailFormat.md#idnemailformat1) | |
| [IdnHostnameFormat.IdnHostnameFormat1](docs/components/schemas/IdnHostnameFormat.md#idnhostnameformat1) | |
| [IfAndElseWithoutThen.IfAndElseWithoutThen1](docs/components/schemas/IfAndElseWithoutThen.md#ifandelsewithoutthen1) | |
| [IfAndThenWithoutElse.IfAndThenWithoutElse1](docs/components/schemas/IfAndThenWithoutElse.md#ifandthenwithoutelse1) | |
| [IfAppearsAtTheEndWhenSerializedKeywordProcessingSequence.IfAppearsAtTheEndWhenSerializedKeywordProcessingSequence1](docs/components/schemas/IfAppearsAtTheEndWhenSerializedKeywordProcessingSequence.md#ifappearsattheendwhenserializedkeywordprocessingsequence1) | |
| [IgnoreElseWithoutIf.IgnoreElseWithoutIf1](docs/components/schemas/IgnoreElseWithoutIf.md#ignoreelsewithoutif1) | |
| [IgnoreIfWithoutThenOrElse.IgnoreIfWithoutThenOrElse1](docs/components/schemas/IgnoreIfWithoutThenOrElse.md#ignoreifwithoutthenorelse1) | |
| [IgnoreThenWithoutIf.IgnoreThenWithoutIf1](docs/components/schemas/IgnoreThenWithoutIf.md#ignorethenwithoutif1) | |
| [IntegerTypeMatchesIntegers.IntegerTypeMatchesIntegers1](docs/components/schemas/IntegerTypeMatchesIntegers.md#integertypematchesintegers1) | |
| [Ipv4Format.Ipv4Format1](docs/components/schemas/Ipv4Format.md#ipv4format1) | |
| [Ipv6Format.Ipv6Format1](docs/components/schemas/Ipv6Format.md#ipv6format1) | |
| [IriFormat.IriFormat1](docs/components/schemas/IriFormat.md#iriformat1) | |
| [IriReferenceFormat.IriReferenceFormat1](docs/components/schemas/IriReferenceFormat.md#irireferenceformat1) | |
| [ItemsContains.ItemsContains1](docs/components/schemas/ItemsContains.md#itemscontains1) | |
| [ItemsDoesNotLookInApplicatorsValidCase.ItemsDoesNotLookInApplicatorsValidCase1](docs/components/schemas/ItemsDoesNotLookInApplicatorsValidCase.md#itemsdoesnotlookinapplicatorsvalidcase1) | |
| [ItemsWithNullInstanceElements.ItemsWithNullInstanceElements1](docs/components/schemas/ItemsWithNullInstanceElements.md#itemswithnullinstanceelements1) | |
| [JsonPointerFormat.JsonPointerFormat1](docs/components/schemas/JsonPointerFormat.md#jsonpointerformat1) | |
| [MaxcontainsWithoutContainsIsIgnored.MaxcontainsWithoutContainsIsIgnored1](docs/components/schemas/MaxcontainsWithoutContainsIsIgnored.md#maxcontainswithoutcontainsisignored1) | |
| [MaximumValidation.MaximumValidation1](docs/components/schemas/MaximumValidation.md#maximumvalidation1) | |
| [MaximumValidationWithUnsignedInteger.MaximumValidationWithUnsignedInteger1](docs/components/schemas/MaximumValidationWithUnsignedInteger.md#maximumvalidationwithunsignedinteger1) | |
| [MaxitemsValidation.MaxitemsValidation1](docs/components/schemas/MaxitemsValidation.md#maxitemsvalidation1) | |
| [MaxlengthValidation.MaxlengthValidation1](docs/components/schemas/MaxlengthValidation.md#maxlengthvalidation1) | |
| [Maxproperties0MeansTheObjectIsEmpty.Maxproperties0MeansTheObjectIsEmpty1](docs/components/schemas/Maxproperties0MeansTheObjectIsEmpty.md#maxproperties0meanstheobjectisempty1) | |
| [MaxpropertiesValidation.MaxpropertiesValidation1](docs/components/schemas/MaxpropertiesValidation.md#maxpropertiesvalidation1) | |
| [MincontainsWithoutContainsIsIgnored.MincontainsWithoutContainsIsIgnored1](docs/components/schemas/MincontainsWithoutContainsIsIgnored.md#mincontainswithoutcontainsisignored1) | |
| [MinimumValidation.MinimumValidation1](docs/components/schemas/MinimumValidation.md#minimumvalidation1) | |
| [MinimumValidationWithSignedInteger.MinimumValidationWithSignedInteger1](docs/components/schemas/MinimumValidationWithSignedInteger.md#minimumvalidationwithsignedinteger1) | |
| [MinitemsValidation.MinitemsValidation1](docs/components/schemas/MinitemsValidation.md#minitemsvalidation1) | |
| [MinlengthValidation.MinlengthValidation1](docs/components/schemas/MinlengthValidation.md#minlengthvalidation1) | |
| [MinpropertiesValidation.MinpropertiesValidation1](docs/components/schemas/MinpropertiesValidation.md#minpropertiesvalidation1) | |
| [MultipleDependentsRequired.MultipleDependentsRequired1](docs/components/schemas/MultipleDependentsRequired.md#multipledependentsrequired1) | |
| [MultipleSimultaneousPatternpropertiesAreValidated.MultipleSimultaneousPatternpropertiesAreValidated1](docs/components/schemas/MultipleSimultaneousPatternpropertiesAreValidated.md#multiplesimultaneouspatternpropertiesarevalidated1) | |
| [MultipleTypesCanBeSpecifiedInAnArray.MultipleTypesCanBeSpecifiedInAnArray1](docs/components/schemas/MultipleTypesCanBeSpecifiedInAnArray.md#multipletypescanbespecifiedinanarray1) | |
| [NestedAllofToCheckValidationSemantics.NestedAllofToCheckValidationSemantics1](docs/components/schemas/NestedAllofToCheckValidationSemantics.md#nestedalloftocheckvalidationsemantics1) | |
| [NestedAnyofToCheckValidationSemantics.NestedAnyofToCheckValidationSemantics1](docs/components/schemas/NestedAnyofToCheckValidationSemantics.md#nestedanyoftocheckvalidationsemantics1) | |
| [NestedItems.NestedItems1](docs/components/schemas/NestedItems.md#nesteditems1) | |
| [NestedOneofToCheckValidationSemantics.NestedOneofToCheckValidationSemantics1](docs/components/schemas/NestedOneofToCheckValidationSemantics.md#nestedoneoftocheckvalidationsemantics1) | |
| [NonAsciiPatternWithAdditionalproperties.NonAsciiPatternWithAdditionalproperties1](docs/components/schemas/NonAsciiPatternWithAdditionalproperties.md#nonasciipatternwithadditionalproperties1) | |
| [NonInterferenceAcrossCombinedSchemas.NonInterferenceAcrossCombinedSchemas1](docs/components/schemas/NonInterferenceAcrossCombinedSchemas.md#noninterferenceacrosscombinedschemas1) | |
| [Not.Not1](docs/components/schemas/Not.md#not1) | |
| [NotMoreComplexSchema.NotMoreComplexSchema1](docs/components/schemas/NotMoreComplexSchema.md#notmorecomplexschema1) | |
| [NotMultipleTypes.NotMultipleTypes1](docs/components/schemas/NotMultipleTypes.md#notmultipletypes1) | |
| [NulCharactersInStrings.NulCharactersInStrings1](docs/components/schemas/NulCharactersInStrings.md#nulcharactersinstrings1) | |
| [NullTypeMatchesOnlyTheNullObject.NullTypeMatchesOnlyTheNullObject1](docs/components/schemas/NullTypeMatchesOnlyTheNullObject.md#nulltypematchesonlythenullobject1) | |
| [NumberTypeMatchesNumbers.NumberTypeMatchesNumbers1](docs/components/schemas/NumberTypeMatchesNumbers.md#numbertypematchesnumbers1) | |
| [ObjectPropertiesValidation.ObjectPropertiesValidation1](docs/components/schemas/ObjectPropertiesValidation.md#objectpropertiesvalidation1) | |
| [ObjectTypeMatchesObjects.ObjectTypeMatchesObjects1](docs/components/schemas/ObjectTypeMatchesObjects.md#objecttypematchesobjects1) | |
| [Oneof.Oneof1](docs/components/schemas/Oneof.md#oneof1) | |
| [OneofComplexTypes.OneofComplexTypes1](docs/components/schemas/OneofComplexTypes.md#oneofcomplextypes1) | |
| [OneofWithBaseSchema.OneofWithBaseSchema1](docs/components/schemas/OneofWithBaseSchema.md#oneofwithbaseschema1) | |
| [OneofWithEmptySchema.OneofWithEmptySchema1](docs/components/schemas/OneofWithEmptySchema.md#oneofwithemptyschema1) | |
| [OneofWithRequired.OneofWithRequired1](docs/components/schemas/OneofWithRequired.md#oneofwithrequired1) | |
| [PatternIsNotAnchored.PatternIsNotAnchored1](docs/components/schemas/PatternIsNotAnchored.md#patternisnotanchored1) | |
| [PatternValidation.PatternValidation1](docs/components/schemas/PatternValidation.md#patternvalidation1) | |
| [PatternpropertiesValidatesPropertiesMatchingARegex.PatternpropertiesValidatesPropertiesMatchingARegex1](docs/components/schemas/PatternpropertiesValidatesPropertiesMatchingARegex.md#patternpropertiesvalidatespropertiesmatchingaregex1) | |
| [PatternpropertiesWithNullValuedInstanceProperties.PatternpropertiesWithNullValuedInstanceProperties1](docs/components/schemas/PatternpropertiesWithNullValuedInstanceProperties.md#patternpropertieswithnullvaluedinstanceproperties1) | |
| [PrefixitemsValidationAdjustsTheStartingIndexForItems.PrefixitemsValidationAdjustsTheStartingIndexForItems1](docs/components/schemas/PrefixitemsValidationAdjustsTheStartingIndexForItems.md#prefixitemsvalidationadjuststhestartingindexforitems1) | |
| [PrefixitemsWithNullInstanceElements.PrefixitemsWithNullInstanceElements1](docs/components/schemas/PrefixitemsWithNullInstanceElements.md#prefixitemswithnullinstanceelements1) | |
| [PropertiesPatternpropertiesAdditionalpropertiesInteraction.PropertiesPatternpropertiesAdditionalpropertiesInteraction1](docs/components/schemas/PropertiesPatternpropertiesAdditionalpropertiesInteraction.md#propertiespatternpropertiesadditionalpropertiesinteraction1) | |
| [PropertiesWhoseNamesAreJavascriptObjectPropertyNames.PropertiesWhoseNamesAreJavascriptObjectPropertyNames1](docs/components/schemas/PropertiesWhoseNamesAreJavascriptObjectPropertyNames.md#propertieswhosenamesarejavascriptobjectpropertynames1) | |
| [PropertiesWithEscapedCharacters.PropertiesWithEscapedCharacters1](docs/components/schemas/PropertiesWithEscapedCharacters.md#propertieswithescapedcharacters1) | |
| [PropertiesWithNullValuedInstanceProperties.PropertiesWithNullValuedInstanceProperties1](docs/components/schemas/PropertiesWithNullValuedInstanceProperties.md#propertieswithnullvaluedinstanceproperties1) | |
| [PropertyNamedRefThatIsNotAReference.PropertyNamedRefThatIsNotAReference1](docs/components/schemas/PropertyNamedRefThatIsNotAReference.md#propertynamedrefthatisnotareference1) | |
| [PropertynamesValidation.PropertynamesValidation1](docs/components/schemas/PropertynamesValidation.md#propertynamesvalidation1) | |
| [RegexFormat.RegexFormat1](docs/components/schemas/RegexFormat.md#regexformat1) | |
| [RegexesAreNotAnchoredByDefaultAndAreCaseSensitive.RegexesAreNotAnchoredByDefaultAndAreCaseSensitive1](docs/components/schemas/RegexesAreNotAnchoredByDefaultAndAreCaseSensitive.md#regexesarenotanchoredbydefaultandarecasesensitive1) | |
| [RelativeJsonPointerFormat.RelativeJsonPointerFormat1](docs/components/schemas/RelativeJsonPointerFormat.md#relativejsonpointerformat1) | |
| [RequiredDefaultValidation.RequiredDefaultValidation1](docs/components/schemas/RequiredDefaultValidation.md#requireddefaultvalidation1) | |
| [RequiredPropertiesWhoseNamesAreJavascriptObjectPropertyNames.RequiredPropertiesWhoseNamesAreJavascriptObjectPropertyNames1](docs/components/schemas/RequiredPropertiesWhoseNamesAreJavascriptObjectPropertyNames.md#requiredpropertieswhosenamesarejavascriptobjectpropertynames1) | |
| [RequiredValidation.RequiredValidation1](docs/components/schemas/RequiredValidation.md#requiredvalidation1) | |
| [RequiredWithEmptyArray.RequiredWithEmptyArray1](docs/components/schemas/RequiredWithEmptyArray.md#requiredwithemptyarray1) | |
| [RequiredWithEscapedCharacters.RequiredWithEscapedCharacters1](docs/components/schemas/RequiredWithEscapedCharacters.md#requiredwithescapedcharacters1) | |
| [SimpleEnumValidation.SimpleEnumValidation1](docs/components/schemas/SimpleEnumValidation.md#simpleenumvalidation1) | |
| [SingleDependency.SingleDependency1](docs/components/schemas/SingleDependency.md#singledependency1) | |
| [SmallMultipleOfLargeInteger.SmallMultipleOfLargeInteger1](docs/components/schemas/SmallMultipleOfLargeInteger.md#smallmultipleoflargeinteger1) | |
| [StringTypeMatchesStrings.StringTypeMatchesStrings1](docs/components/schemas/StringTypeMatchesStrings.md#stringtypematchesstrings1) | |
| [TimeFormat.TimeFormat1](docs/components/schemas/TimeFormat.md#timeformat1) | |
| [TypeArrayObjectOrNull.TypeArrayObjectOrNull1](docs/components/schemas/TypeArrayObjectOrNull.md#typearrayobjectornull1) | |
| [TypeArrayOrObject.TypeArrayOrObject1](docs/components/schemas/TypeArrayOrObject.md#typearrayorobject1) | |
| [TypeAsArrayWithOneItem.TypeAsArrayWithOneItem1](docs/components/schemas/TypeAsArrayWithOneItem.md#typeasarraywithoneitem1) | |
| [UnevaluateditemsAsSchema.UnevaluateditemsAsSchema1](docs/components/schemas/UnevaluateditemsAsSchema.md#unevaluateditemsasschema1) | |
| [UnevaluateditemsDependsOnMultipleNestedContains.UnevaluateditemsDependsOnMultipleNestedContains1](docs/components/schemas/UnevaluateditemsDependsOnMultipleNestedContains.md#unevaluateditemsdependsonmultiplenestedcontains1) | |
| [UnevaluateditemsWithItems.UnevaluateditemsWithItems1](docs/components/schemas/UnevaluateditemsWithItems.md#unevaluateditemswithitems1) | |
| [UnevaluateditemsWithNullInstanceElements.UnevaluateditemsWithNullInstanceElements1](docs/components/schemas/UnevaluateditemsWithNullInstanceElements.md#unevaluateditemswithnullinstanceelements1) | |
| [UnevaluatedpropertiesNotAffectedByPropertynames.UnevaluatedpropertiesNotAffectedByPropertynames1](docs/components/schemas/UnevaluatedpropertiesNotAffectedByPropertynames.md#unevaluatedpropertiesnotaffectedbypropertynames1) | |
| [UnevaluatedpropertiesSchema.UnevaluatedpropertiesSchema1](docs/components/schemas/UnevaluatedpropertiesSchema.md#unevaluatedpropertiesschema1) | |
| [UnevaluatedpropertiesWithAdjacentAdditionalproperties.UnevaluatedpropertiesWithAdjacentAdditionalproperties1](docs/components/schemas/UnevaluatedpropertiesWithAdjacentAdditionalproperties.md#unevaluatedpropertieswithadjacentadditionalproperties1) | |
| [UnevaluatedpropertiesWithNullValuedInstanceProperties.UnevaluatedpropertiesWithNullValuedInstanceProperties1](docs/components/schemas/UnevaluatedpropertiesWithNullValuedInstanceProperties.md#unevaluatedpropertieswithnullvaluedinstanceproperties1) | |
| [UniqueitemsFalseValidation.UniqueitemsFalseValidation1](docs/components/schemas/UniqueitemsFalseValidation.md#uniqueitemsfalsevalidation1) | |
| [UniqueitemsFalseWithAnArrayOfItems.UniqueitemsFalseWithAnArrayOfItems1](docs/components/schemas/UniqueitemsFalseWithAnArrayOfItems.md#uniqueitemsfalsewithanarrayofitems1) | |
| [UniqueitemsValidation.UniqueitemsValidation1](docs/components/schemas/UniqueitemsValidation.md#uniqueitemsvalidation1) | |
| [UniqueitemsWithAnArrayOfItems.UniqueitemsWithAnArrayOfItems1](docs/components/schemas/UniqueitemsWithAnArrayOfItems.md#uniqueitemswithanarrayofitems1) | |
| [UriFormat.UriFormat1](docs/components/schemas/UriFormat.md#uriformat1) | |
| [UriReferenceFormat.UriReferenceFormat1](docs/components/schemas/UriReferenceFormat.md#urireferenceformat1) | |
| [UriTemplateFormat.UriTemplateFormat1](docs/components/schemas/UriTemplateFormat.md#uritemplateformat1) | |
| [UuidFormat.UuidFormat1](docs/components/schemas/UuidFormat.md#uuidformat1) | |
| [ValidateAgainstCorrectBranchThenVsElse.ValidateAgainstCorrectBranchThenVsElse1](docs/components/schemas/ValidateAgainstCorrectBranchThenVsElse.md#validateagainstcorrectbranchthenvselse1) | |
