# coding: utf-8

"""
    openapi 3.0.3 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft6  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.object_properties_validation import ObjectPropertiesValidation
from unit_test_api.configurations import schema_configuration


class TestObjectPropertiesValidation(unittest.TestCase):
    """ObjectPropertiesValidation unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_ignores_arrays_passes(self):
        # ignores arrays
        ObjectPropertiesValidation.validate(
            [
            ],
            configuration=self.configuration
        )

    def test_ignores_other_non_objects_passes(self):
        # ignores other non-objects
        ObjectPropertiesValidation.validate(
            12,
            configuration=self.configuration
        )

    def test_one_property_invalid_is_invalid_fails(self):
        # one property invalid is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            ObjectPropertiesValidation.validate(
                {
                    "foo":
                        1,
                    "bar":
                        {
                        },
                },
                configuration=self.configuration
            )

    def test_both_properties_present_and_valid_is_valid_passes(self):
        # both properties present and valid is valid
        ObjectPropertiesValidation.validate(
            {
                "foo":
                    1,
                "bar":
                    "baz",
            },
            configuration=self.configuration
        )

    def test_doesn_t_invalidate_other_properties_passes(self):
        # doesn&#x27;t invalidate other properties
        ObjectPropertiesValidation.validate(
            {
                "quux":
                    [
                    ],
            },
            configuration=self.configuration
        )

    def test_both_properties_invalid_is_invalid_fails(self):
        # both properties invalid is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            ObjectPropertiesValidation.validate(
                {
                    "foo":
                        [
                        ],
                    "bar":
                        {
                        },
                },
                configuration=self.configuration
            )


if __name__ == '__main__':
    unittest.main()
