# coding: utf-8

"""
    openapi 3.0.3 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft6  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.number_type_matches_numbers import NumberTypeMatchesNumbers
from unit_test_api.configurations import schema_configuration


class TestNumberTypeMatchesNumbers(unittest.TestCase):
    """NumberTypeMatchesNumbers unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_an_array_is_not_a_number_fails(self):
        # an array is not a number
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            NumberTypeMatchesNumbers.validate(
                [
                ],
                configuration=self.configuration
            )

    def test_null_is_not_a_number_fails(self):
        # null is not a number
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            NumberTypeMatchesNumbers.validate(
                None,
                configuration=self.configuration
            )

    def test_an_object_is_not_a_number_fails(self):
        # an object is not a number
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            NumberTypeMatchesNumbers.validate(
                {
                },
                configuration=self.configuration
            )

    def test_a_boolean_is_not_a_number_fails(self):
        # a boolean is not a number
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            NumberTypeMatchesNumbers.validate(
                True,
                configuration=self.configuration
            )

    def test_a_float_is_a_number_passes(self):
        # a float is a number
        NumberTypeMatchesNumbers.validate(
            1.1,
            configuration=self.configuration
        )

    def test_a_string_is_still_not_a_number_even_if_it_looks_like_one_fails(self):
        # a string is still not a number, even if it looks like one
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            NumberTypeMatchesNumbers.validate(
                "1",
                configuration=self.configuration
            )

    def test_a_string_is_not_a_number_fails(self):
        # a string is not a number
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            NumberTypeMatchesNumbers.validate(
                "foo",
                configuration=self.configuration
            )

    def test_an_integer_is_a_number_passes(self):
        # an integer is a number
        NumberTypeMatchesNumbers.validate(
            1,
            configuration=self.configuration
        )

    def test_a_float_with_zero_fractional_part_is_a_number_and_an_integer_passes(self):
        # a float with zero fractional part is a number (and an integer)
        NumberTypeMatchesNumbers.validate(
            1.0,
            configuration=self.configuration
        )


if __name__ == '__main__':
    unittest.main()
