# coding: utf-8

"""
    openapi 3.0.3 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft6  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.not_more_complex_schema import NotMoreComplexSchema
from unit_test_api.configurations import schema_configuration


class TestNotMoreComplexSchema(unittest.TestCase):
    """NotMoreComplexSchema unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_other_match_passes(self):
        # other match
        NotMoreComplexSchema.validate(
            {
                "foo":
                    1,
            },
            configuration=self.configuration
        )

    def test_mismatch_fails(self):
        # mismatch
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            NotMoreComplexSchema.validate(
                {
                    "foo":
                        "bar",
                },
                configuration=self.configuration
            )

    def test_match_passes(self):
        # match
        NotMoreComplexSchema.validate(
            1,
            configuration=self.configuration
        )


if __name__ == '__main__':
    unittest.main()
