# coding: utf-8

"""
    openapi 3.0.3 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft6  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.maximum_validation_with_unsigned_integer import MaximumValidationWithUnsignedInteger
from unit_test_api.configurations import schema_configuration


class TestMaximumValidationWithUnsignedInteger(unittest.TestCase):
    """MaximumValidationWithUnsignedInteger unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_below_the_maximum_is_invalid_passes(self):
        # below the maximum is invalid
        MaximumValidationWithUnsignedInteger.validate(
            299.97,
            configuration=self.configuration
        )

    def test_above_the_maximum_is_invalid_fails(self):
        # above the maximum is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            MaximumValidationWithUnsignedInteger.validate(
                300.5,
                configuration=self.configuration
            )

    def test_boundary_point_integer_is_valid_passes(self):
        # boundary point integer is valid
        MaximumValidationWithUnsignedInteger.validate(
            300,
            configuration=self.configuration
        )

    def test_boundary_point_float_is_valid_passes(self):
        # boundary point float is valid
        MaximumValidationWithUnsignedInteger.validate(
            300.0,
            configuration=self.configuration
        )


if __name__ == '__main__':
    unittest.main()
