# coding: utf-8

"""
    openapi 3.0.3 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft6  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.invalid_instance_should_not_raise_error_when_float_division_inf import InvalidInstanceShouldNotRaiseErrorWhenFloatDivisionInf
from unit_test_api.configurations import schema_configuration


class TestInvalidInstanceShouldNotRaiseErrorWhenFloatDivisionInf(unittest.TestCase):
    """InvalidInstanceShouldNotRaiseErrorWhenFloatDivisionInf unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_always_invalid_but_naive_implementations_may_raise_an_overflow_error_fails(self):
        # always invalid, but naive implementations may raise an overflow error
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            InvalidInstanceShouldNotRaiseErrorWhenFloatDivisionInf.validate(
                1.0E308,
                configuration=self.configuration
            )

    def test_valid_integer_with_multipleof_float_passes(self):
        # valid integer with multipleOf float
        InvalidInstanceShouldNotRaiseErrorWhenFloatDivisionInf.validate(
            123456789,
            configuration=self.configuration
        )


if __name__ == '__main__':
    unittest.main()
