# coding: utf-8

"""
    openapi 3.0.3 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft6  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.enums_in_properties import EnumsInProperties
from unit_test_api.configurations import schema_configuration


class TestEnumsInProperties(unittest.TestCase):
    """EnumsInProperties unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_missing_optional_property_is_valid_passes(self):
        # missing optional property is valid
        EnumsInProperties.validate(
            {
                "bar":
                    "bar",
            },
            configuration=self.configuration
        )

    def test_wrong_foo_value_fails(self):
        # wrong foo value
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            EnumsInProperties.validate(
                {
                    "foo":
                        "foot",
                    "bar":
                        "bar",
                },
                configuration=self.configuration
            )

    def test_both_properties_are_valid_passes(self):
        # both properties are valid
        EnumsInProperties.validate(
            {
                "foo":
                    "foo",
                "bar":
                    "bar",
            },
            configuration=self.configuration
        )

    def test_wrong_bar_value_fails(self):
        # wrong bar value
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            EnumsInProperties.validate(
                {
                    "foo":
                        "foo",
                    "bar":
                        "bart",
                },
                configuration=self.configuration
            )

    def test_missing_all_properties_is_invalid_fails(self):
        # missing all properties is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            EnumsInProperties.validate(
                {
                },
                configuration=self.configuration
            )

    def test_missing_required_property_is_invalid_fails(self):
        # missing required property is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            EnumsInProperties.validate(
                {
                    "foo":
                        "foo",
                },
                configuration=self.configuration
            )


if __name__ == '__main__':
    unittest.main()
