# coding: utf-8

"""
    openapi 3.0.3 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft6  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.enum_with_true_does_not_match1 import EnumWithTrueDoesNotMatch1
from unit_test_api.configurations import schema_configuration


class TestEnumWithTrueDoesNotMatch1(unittest.TestCase):
    """EnumWithTrueDoesNotMatch1 unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_float_one_is_invalid_fails(self):
        # float one is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            EnumWithTrueDoesNotMatch1.validate(
                1.0,
                configuration=self.configuration
            )

    def test_true_is_valid_passes(self):
        # true is valid
        EnumWithTrueDoesNotMatch1.validate(
            True,
            configuration=self.configuration
        )

    def test_integer_one_is_invalid_fails(self):
        # integer one is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            EnumWithTrueDoesNotMatch1.validate(
                1,
                configuration=self.configuration
            )


if __name__ == '__main__':
    unittest.main()
