# coding: utf-8

"""
    openapi 3.0.3 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft6  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.enum_with_escaped_characters import EnumWithEscapedCharacters
from unit_test_api.configurations import schema_configuration


class TestEnumWithEscapedCharacters(unittest.TestCase):
    """EnumWithEscapedCharacters unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_member2_is_valid_passes(self):
        # member 2 is valid
        EnumWithEscapedCharacters.validate(
            "foo\rbar",
            configuration=self.configuration
        )

    def test_member1_is_valid_passes(self):
        # member 1 is valid
        EnumWithEscapedCharacters.validate(
            "foo\nbar",
            configuration=self.configuration
        )

    def test_another_string_is_invalid_fails(self):
        # another string is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            EnumWithEscapedCharacters.validate(
                "abc",
                configuration=self.configuration
            )


if __name__ == '__main__':
    unittest.main()
