# coding: utf-8

"""
    openapi 3.0.3 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft6  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.by_small_number import BySmallNumber
from unit_test_api.configurations import schema_configuration


class TestBySmallNumber(unittest.TestCase):
    """BySmallNumber unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_000751_is_not_multiple_of00001_fails(self):
        # 0.00751 is not multiple of 0.0001
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            BySmallNumber.validate(
                0.00751,
                configuration=self.configuration
            )

    def test_00075_is_multiple_of00001_passes(self):
        # 0.0075 is multiple of 0.0001
        BySmallNumber.validate(
            0.0075,
            configuration=self.configuration
        )


if __name__ == '__main__':
    unittest.main()
