# coding: utf-8

"""
    openapi 3.0.3 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft6  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.array_type_matches_arrays import ArrayTypeMatchesArrays
from unit_test_api.configurations import schema_configuration


class TestArrayTypeMatchesArrays(unittest.TestCase):
    """ArrayTypeMatchesArrays unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_a_float_is_not_an_array_fails(self):
        # a float is not an array
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            ArrayTypeMatchesArrays.validate(
                1.1,
                configuration=self.configuration
            )

    def test_a_boolean_is_not_an_array_fails(self):
        # a boolean is not an array
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            ArrayTypeMatchesArrays.validate(
                True,
                configuration=self.configuration
            )

    def test_null_is_not_an_array_fails(self):
        # null is not an array
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            ArrayTypeMatchesArrays.validate(
                None,
                configuration=self.configuration
            )

    def test_an_object_is_not_an_array_fails(self):
        # an object is not an array
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            ArrayTypeMatchesArrays.validate(
                {
                },
                configuration=self.configuration
            )

    def test_a_string_is_not_an_array_fails(self):
        # a string is not an array
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            ArrayTypeMatchesArrays.validate(
                "foo",
                configuration=self.configuration
            )

    def test_an_array_is_an_array_passes(self):
        # an array is an array
        ArrayTypeMatchesArrays.validate(
            [
            ],
            configuration=self.configuration
        )

    def test_an_integer_is_not_an_array_fails(self):
        # an integer is not an array
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            ArrayTypeMatchesArrays.validate(
                1,
                configuration=self.configuration
            )


if __name__ == '__main__':
    unittest.main()
