# coding: utf-8

"""
    openapi 3.0.3 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft6  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.allof_combined_with_anyof_oneof import AllofCombinedWithAnyofOneof
from unit_test_api.configurations import schema_configuration


class TestAllofCombinedWithAnyofOneof(unittest.TestCase):
    """AllofCombinedWithAnyofOneof unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_allof_true_anyof_false_oneof_false_fails(self):
        # allOf: true, anyOf: false, oneOf: false
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            AllofCombinedWithAnyofOneof.validate(
                2,
                configuration=self.configuration
            )

    def test_allof_false_anyof_false_oneof_true_fails(self):
        # allOf: false, anyOf: false, oneOf: true
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            AllofCombinedWithAnyofOneof.validate(
                5,
                configuration=self.configuration
            )

    def test_allof_false_anyof_true_oneof_true_fails(self):
        # allOf: false, anyOf: true, oneOf: true
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            AllofCombinedWithAnyofOneof.validate(
                15,
                configuration=self.configuration
            )

    def test_allof_true_anyof_true_oneof_false_fails(self):
        # allOf: true, anyOf: true, oneOf: false
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            AllofCombinedWithAnyofOneof.validate(
                6,
                configuration=self.configuration
            )

    def test_allof_true_anyof_true_oneof_true_passes(self):
        # allOf: true, anyOf: true, oneOf: true
        AllofCombinedWithAnyofOneof.validate(
            30,
            configuration=self.configuration
        )

    def test_allof_true_anyof_false_oneof_true_fails(self):
        # allOf: true, anyOf: false, oneOf: true
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            AllofCombinedWithAnyofOneof.validate(
                10,
                configuration=self.configuration
            )

    def test_allof_false_anyof_true_oneof_false_fails(self):
        # allOf: false, anyOf: true, oneOf: false
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            AllofCombinedWithAnyofOneof.validate(
                3,
                configuration=self.configuration
            )

    def test_allof_false_anyof_false_oneof_false_fails(self):
        # allOf: false, anyOf: false, oneOf: false
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            AllofCombinedWithAnyofOneof.validate(
                1,
                configuration=self.configuration
            )


if __name__ == '__main__':
    unittest.main()
