# Migration from Other Python Generators

When switching from other python client generators you will need to make some changes to your code.

1. This generator uses spec case for all (object) property names and parameter names.
    - So if the spec has a property name like pascalCase, it will use pascalCase rather than camel_case
    - So you will need to update how you input and read properties to use spec case
        - endpoint calls will need to have their input arguments updated
        - schema instance property usage and instantiation will need to be updated
2. Endpoint parameters are stored in dictionaries to prevent collisions (explanation below)
    - So you will need to update how you pass data in to endpoints
        - update your endpoint calls to pass in parameter data in path_params, query_params, header_params etc dict inputs
3. Endpoint responses now include the original response, the deserialized response body, and (todo)the deserialized headers
    - So you will need to update your code to use response.body to access deserialized data
4. All validated class instances are immutable except for ones based on io.File
    - This is because if properties were changed after validation, that validation would no longer apply
    - So no changing values or property values after a class has been instantiated
5. String + Number types with formats
    - String type data is stored as a string and if you need to access types based on its format like date,
    date-time, uuid, number etc then you will need to use schemas accessor functions on the instance
    - type string + format: See schemas.as_date, schemas.as_datetime, schemas.as_decimal, schemas.as_uuid
    - this was done because openapi/json-schema defines constraints. string data may be type string with no format
    keyword in one schema, and include a format constraint in another schema
    - So if you need to access a string format based type, use as_date/as_datetime/as_decimal/as_uuid
6. Property access on AnyType(type unset) or object(dict) schemas
    - Only required keys with valid python names are properties like .someProp and have type hints
    - All optional keys may not exist, properties are defined for them and if they are unset schemas.unset will be returned
    - One can also access optional values with dict_instance['optionalProp'] and KeyError will be raised if it does not exist
7. The location of the api classes has changed
    - Api classes are located in your_package.apis.tags.some_api
    - This change was made to eliminate redundant code generation
    - Legacy generators generated the same endpoint twice if it had > 1 tag on it
    - This generator defines an endpoint in one class, then inherits that class to generate
      apis by tags and by paths
    - This change reduces code and allows quicker run time if you use the path apis
        - path apis are at your_package.apis.paths.some_path
    - Those apis will only load their needed models, which is less to load than all of the resources needed in a tag api
    - So you will need to update your import paths to the api classes

### Why are Leading and Trailing Underscores in some class and method names?
Classes can have arbitrarily named properties set on them
Endpoints can have arbitrary operationId method names set
For those reasons, I use the prefix and suffix _ to greatly reduce the likelihood of collisions
on protected + public classes/methods.

### Object property spec case
This was done because when payloads are ingested, they can be validated against N number of schemas.
If the input signature used a different property name then that has mutated the payload.
So SchemaA and SchemaB must both see the pascalCase spec named variable.
Also it is possible to send in two properties, named pascalCase and camel_case in the same payload.
That use case should work, so spec case is used.

### Parameter spec case
Parameters can be included in different locations including:
- query
- path
- header
- cookie

Any of those parameters could use the same parameter names, so if every parameter
was included as an endpoint parameter in a function signature, they would collide.
For that reason, each of those inputs have been separated out into separate typed dictionaries:
- query_params
- path_params
- header_params
- cookie_params

So when updating your code, you will need to pass endpoint parameters in using those
dictionaries.

### Endpoint responses
Endpoint responses have been enriched to now include more information.
Any response reom an endpoint will now include the following properties:
response: urllib3.HTTPResponse
body: typing.Union[schemas.Unset, typing.Union[str, inf, float, None, schemas.immutabledict, tuple, bytes, schemas.FileIO]]
headers: typing.Union[schemas.Unset, HeaderSchemaDict]
Note: response header deserialization has not yet been added