package org.openapijsonschematools.client.schemas.validation

import org.openapijsonschematools.client.exceptions.ValidationException

class ExclusiveMinimumValidator : KeywordValidator {
    @Throws(ValidationException::class)
    override fun validate(
        data: ValidationData
    ): PathToSchemasMap? {
        val exclusiveMinimum: Number = data.schema.exclusiveMinimum ?: return null
        if (data.arg !is Number) {
            return null
        }
        val msg =
            "Value " + data.arg + " is invalid because it is <= the exclusiveMinimum of " + exclusiveMinimum
        when (data.arg) {
            is Int -> {
                if (data.arg.compareTo(exclusiveMinimum.toInt()) < 1) {
                    throw ValidationException(msg)
                }
            }

            is Long -> {
                if (data.arg.compareTo(exclusiveMinimum.toLong()) < 1) {
                    throw ValidationException(msg)
                }
            }

            is Float -> {
                if (data.arg.compareTo(exclusiveMinimum.toFloat()) < 1) {
                    throw ValidationException(msg)
                }
            }

            is Double -> {
                if (data.arg.compareTo(exclusiveMinimum.toDouble()) < 1) {
                    throw ValidationException(msg)
                }
            }
        }
        return null
    }
}
