package org.openapijsonschematools.client.components.schemas
import org.openapijsonschematools.client.configurations.JsonSchemaKeyword
import org.openapijsonschematools.client.configurations.SchemaConfiguration
import org.openapijsonschematools.client.exceptions.ValidationException
import org.openapijsonschematools.client.schemas.validation.JsonSchema
import org.openapijsonschematools.client.schemas.validation.PathToSchemasMap
import org.openapijsonschematools.client.schemas.validation.StringEnumValidator
import org.openapijsonschematools.client.schemas.validation.StringSchemaValidator
import org.openapijsonschematools.client.schemas.validation.StringValueMethod
import org.openapijsonschematools.client.schemas.validation.ValidationMetadata

class NulCharactersInStrings {
    // nest classes so all schemas and input/output classes can be public
    
    enum class StringNulCharactersInStringsEnums(private val value: String): StringValueMethod {
        HELLO_NULL_THERE("hello\u0000there");
    
        override fun value(): String {
            return this.value
        }
    }
    
    
    sealed interface NulCharactersInStrings1Boxed {
        fun getData(): Any?
    }
    
    data class NulCharactersInStrings1BoxedString(val data: String) : NulCharactersInStrings1Boxed {
        override fun getData(): Any? {
            return data
        }
    }
    
    
    
    class NulCharactersInStrings1 private constructor(): JsonSchema<NulCharactersInStrings1Boxed>(
        type = setOf(
            String::class.java
        ),
        enumValues = setOf(
            "hello\u0000there"
        ),
    ), StringSchemaValidator<NulCharactersInStrings1BoxedString>, StringEnumValidator<StringNulCharactersInStringsEnums> {
        /*
        NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
        Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
    
        Do not edit the class manually.
        */
    
        companion object {
            @Volatile
            private var instance: NulCharactersInStrings1? = null
    
            fun getInstance() =
                instance ?: synchronized(this) {
                    instance ?: NulCharactersInStrings1().also { instance = it }
                }
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: String, configuration: SchemaConfiguration?): String {
            val pathSet: MutableSet<List<Any>> = HashSet()
            val pathToItem = listOf<Any>("args[0")
            val castArg = castToAllowedTypes(arg, pathToItem, pathSet)
            val usedConfiguration = configuration ?: SchemaConfiguration()
            val validationMetadata = ValidationMetadata(pathToItem, usedConfiguration, PathToSchemasMap(), LinkedHashSet())
            getPathToSchemas(this, castArg, validationMetadata, pathSet)
            return castArg
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: StringNulCharactersInStringsEnums, configuration: SchemaConfiguration?): String {
            return validate(arg.value(), configuration)
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: Any?, configuration: SchemaConfiguration?): Any? {
            if (arg is String) {
                return validate(arg, configuration)
            }
            throw ValidationException("Invalid input type="+getClass(arg)+". It can't be validated by this schema")
        }        
        override fun getNewInstance(arg: Any?, pathToItem: List<Any>, pathToSchemas: PathToSchemasMap): Any? {
            if (arg is String) {
                return arg
            }
            throw RuntimeException("Invalid input type="+getClass(arg)+". It can't be instantiated by this schema")
        }
        @Throws(ValidationException::class)
        override fun validateAndBox(arg: String, configuration: SchemaConfiguration?): NulCharactersInStrings1BoxedString {
            return NulCharactersInStrings1BoxedString(validate(arg, configuration))
        }
        @Throws(ValidationException::class)
        override fun validateAndBox(arg: Any?, configuration: SchemaConfiguration?): NulCharactersInStrings1Boxed {
            if (arg is String) {
                return validateAndBox(arg, configuration)
            }
            throw ValidationException("Invalid input type="+getClass(arg)+". It can't be validated by this schema")
        }
    }
}
