package org.openapijsonschematools.client.components.schemas
import org.openapijsonschematools.client.configurations.JsonSchemaKeyword
import org.openapijsonschematools.client.configurations.SchemaConfiguration
import org.openapijsonschematools.client.exceptions.ValidationException
import org.openapijsonschematools.client.schemas.AnyTypeJsonSchema
import org.openapijsonschematools.client.schemas.validation.FrozenList
import org.openapijsonschematools.client.schemas.validation.JsonSchema
import org.openapijsonschematools.client.schemas.validation.ListSchemaValidator
import org.openapijsonschematools.client.schemas.validation.PathToSchemasMap
import org.openapijsonschematools.client.schemas.validation.ValidationMetadata

class ArrayTypeMatchesArrays {
    // nest classes so all schemas and input/output classes can be public
    
    
    class Items : AnyTypeJsonSchema.AnyTypeJsonSchema1() {
        companion object {
            @Volatile
            private var instance: Items? = null
    
            fun getInstance() =
                instance ?: synchronized(this) {
                    instance ?: Items().also { instance = it }
                }
        }
    }
    
    
    class ArrayTypeMatchesArraysList(m: FrozenList<Any?>) : FrozenList<Any?>(m) {
        companion object {
            @Throws(ValidationException::class)
            fun of(arg: List<Any?>, configuration: SchemaConfiguration?): ArrayTypeMatchesArraysList {
                return ArrayTypeMatchesArrays1.getInstance().validate(arg, configuration)
            }
        }
    }
    
    class ArrayTypeMatchesArraysListBuilder {
        // class to build List<Any?>
        private val list: MutableList<Any?>
    
        init {
            this.list = ArrayList()
        }
    
        
        fun add(item: Nothing?): ArrayTypeMatchesArraysListBuilder {
            list.add(null)
            return this
        }
        
        fun add(item: Boolean): ArrayTypeMatchesArraysListBuilder {
            list.add(item)
            return this
        }
        
        fun add(item: String): ArrayTypeMatchesArraysListBuilder {
            list.add(item)
            return this
        }
        
        fun add(item: Int): ArrayTypeMatchesArraysListBuilder {
            list.add(item)
            return this
        }
        
        fun add(item: Float): ArrayTypeMatchesArraysListBuilder {
            list.add(item)
            return this
        }
        
        fun add(item: Long): ArrayTypeMatchesArraysListBuilder {
            list.add(item)
            return this
        }
        
        fun add(item: Double): ArrayTypeMatchesArraysListBuilder {
            list.add(item)
            return this
        }
        
        fun add(item: List<*>): ArrayTypeMatchesArraysListBuilder {
            list.add(item)
            return this
        }
        
        fun add(item: Map<String, Any?>): ArrayTypeMatchesArraysListBuilder {
            list.add(item)
            return this
        }
    
        fun build(): List<Any?> {
            return list
        }
    }
    
    
    sealed interface ArrayTypeMatchesArrays1Boxed {
        fun getData(): Any?
    }
    
    data class ArrayTypeMatchesArrays1BoxedList(val data: ArrayTypeMatchesArraysList) : ArrayTypeMatchesArrays1Boxed {
        override fun getData(): Any? {
            return data
        }
    }
    
    
    
    class ArrayTypeMatchesArrays1 private constructor(): JsonSchema<ArrayTypeMatchesArrays1Boxed>(
        type = setOf(List::class.java),
        items = Items::class.java,
    ), ListSchemaValidator<ArrayTypeMatchesArraysList, ArrayTypeMatchesArrays1BoxedList> {
        /*
        NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
        Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
    
        Do not edit the class manually.
        */
    
        companion object {
            @Volatile
            private var instance: ArrayTypeMatchesArrays1? = null
    
            fun getInstance() =
                instance ?: synchronized(this) {
                    instance ?: ArrayTypeMatchesArrays1().also { instance = it }
                }
        }
        
        override fun getNewInstance(arg: List<*>, pathToItem: List<Any>, pathToSchemas: PathToSchemasMap): ArrayTypeMatchesArraysList {
            val items: MutableList<Any?> = ArrayList()
            var i: Int = 0
            for (item: Any? in arg) {
                val itemPathToItem: List<Any> = pathToItem + i
                val schemas: LinkedHashMap<JsonSchema<*>, Nothing?>? = pathToSchemas.get(itemPathToItem)
                if (schemas == null) {
                    throw RuntimeException("Validation result is invalid, schemas must exist for a pathToItem")
                }
                val itemSchema: JsonSchema<*> = schemas.entries.iterator().next().key
                val itemInstance: Any? = itemSchema.getNewInstance(item, itemPathToItem, pathToSchemas)
                items.add(itemInstance)
                i += 1
            }
            val newInstanceItems: FrozenList<Any?> = FrozenList(items)
            return ArrayTypeMatchesArraysList(newInstanceItems)
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: List<*>, configuration: SchemaConfiguration?): ArrayTypeMatchesArraysList {
            val pathSet: MutableSet<List<Any>> = HashSet()
            val pathToItem = listOf<Any>("args[0")
            val castArg = castToAllowedTypes(arg, pathToItem, pathSet)
            val usedConfiguration = configuration ?: SchemaConfiguration()
            val validationMetadata = ValidationMetadata(pathToItem, usedConfiguration, PathToSchemasMap(), LinkedHashSet())
            val pathToSchemasMap = getPathToSchemas(this, castArg, validationMetadata, pathSet)
            return getNewInstance(castArg, validationMetadata.pathToItem, pathToSchemasMap)
        }
        
        @Throws(ValidationException::class)
        override fun validate(arg: Any?, configuration: SchemaConfiguration?): Any? {
            if (arg is List<*>) {
                return validate(arg, configuration)
            }
            throw ValidationException("Invalid input type="+getClass(arg)+". It can't be validated by this schema")
        }        
        override fun getNewInstance(arg: Any?, pathToItem: List<Any>, pathToSchemas: PathToSchemasMap): Any? {
            if (arg is List<*>) {
                return getNewInstance(arg, pathToItem, pathToSchemas)
            }
            throw RuntimeException("Invalid input type="+getClass(arg)+". It can't be instantiated by this schema")
        }
        @Throws(ValidationException::class)
        override fun validateAndBox(arg: List<*>, configuration: SchemaConfiguration?): ArrayTypeMatchesArrays1BoxedList {
            return ArrayTypeMatchesArrays1BoxedList(validate(arg, configuration))
        }
        @Throws(ValidationException::class)
        override fun validateAndBox(arg: Any?, configuration: SchemaConfiguration?): ArrayTypeMatchesArrays1Boxed {
            if (arg is List<*>) {
                return validateAndBox(arg, configuration)
            }
            throw ValidationException("Invalid input type="+getClass(arg)+". It can't be validated by this schema")
        }
    }
}
