package org.openapijsonschematools.client.components.schemas;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.openapijsonschematools.client.configurations.JsonSchemaKeywordFlags;
import org.openapijsonschematools.client.configurations.SchemaConfiguration;
import org.openapijsonschematools.client.exceptions.ValidationException;
import org.openapijsonschematools.client.schemas.AnyTypeJsonSchema;
import org.openapijsonschematools.client.schemas.validation.FrozenList;
import org.openapijsonschematools.client.schemas.validation.JsonSchema;
import org.openapijsonschematools.client.schemas.validation.JsonSchemaInfo;
import org.openapijsonschematools.client.schemas.validation.ListSchemaValidator;
import org.openapijsonschematools.client.schemas.validation.PathToSchemasMap;
import org.openapijsonschematools.client.schemas.validation.ValidationMetadata;

public class ArrayTypeMatchesArrays {
    // nest classes so all schemas and input/output classes can be public
    
    
    public static class Items extends AnyTypeJsonSchema.AnyTypeJsonSchema1 {
        private static @Nullable Items instance = null;
        public static Items getInstance() {
            if (instance == null) {
                instance = new Items();
            }
            return instance;
        }
    }
    
    
    public static class ArrayTypeMatchesArraysList extends FrozenList<@Nullable Object> {
        protected ArrayTypeMatchesArraysList(FrozenList<@Nullable Object> m) {
            super(m);
        }
        public static ArrayTypeMatchesArraysList of(List<? extends @Nullable Object> arg, SchemaConfiguration configuration) throws ValidationException {
            return ArrayTypeMatchesArrays1.getInstance().validate(arg, configuration);
        }
    }
    
    public static class ArrayTypeMatchesArraysListBuilder {
        // class to build List<@Nullable Object>
        private final List<@Nullable Object> list;
    
        public ArrayTypeMatchesArraysListBuilder() {
            list = new ArrayList<>();
        }
    
        public ArrayTypeMatchesArraysListBuilder(List<@Nullable Object> list) {
            this.list = list;
        }
        
        public ArrayTypeMatchesArraysListBuilder add(Void item) {
            list.add(null);
            return this;
        }
        
        public ArrayTypeMatchesArraysListBuilder add(boolean item) {
            list.add(item);
            return this;
        }
        
        public ArrayTypeMatchesArraysListBuilder add(String item) {
            list.add(item);
            return this;
        }
        
        public ArrayTypeMatchesArraysListBuilder add(int item) {
            list.add(item);
            return this;
        }
        
        public ArrayTypeMatchesArraysListBuilder add(float item) {
            list.add(item);
            return this;
        }
        
        public ArrayTypeMatchesArraysListBuilder add(long item) {
            list.add(item);
            return this;
        }
        
        public ArrayTypeMatchesArraysListBuilder add(double item) {
            list.add(item);
            return this;
        }
        
        public ArrayTypeMatchesArraysListBuilder add(List<?> item) {
            list.add(item);
            return this;
        }
        
        public ArrayTypeMatchesArraysListBuilder add(Map<String, ?> item) {
            list.add(item);
            return this;
        }
    
        public List<@Nullable Object> build() {
            return list;
        }
    }
    
    
    public sealed interface ArrayTypeMatchesArrays1Boxed permits ArrayTypeMatchesArrays1BoxedList {
        @Nullable Object getData();
    }
    
    public record ArrayTypeMatchesArrays1BoxedList(ArrayTypeMatchesArraysList data) implements ArrayTypeMatchesArrays1Boxed {
        @Override
        public @Nullable Object getData() {
            return data;
        }
    }
    
    
    
    public static class ArrayTypeMatchesArrays1 extends JsonSchema<ArrayTypeMatchesArrays1Boxed> implements ListSchemaValidator<ArrayTypeMatchesArraysList, ArrayTypeMatchesArrays1BoxedList> {
        /*
        NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
        Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
    
        Do not edit the class manually.
        */
        private static @Nullable ArrayTypeMatchesArrays1 instance = null;
    
        protected ArrayTypeMatchesArrays1() {
            super(new JsonSchemaInfo()
                .type(Set.of(List.class))
                .items(Items.class)
            );
        }
    
        public static ArrayTypeMatchesArrays1 getInstance() {
            if (instance == null) {
                instance = new ArrayTypeMatchesArrays1();
            }
            return instance;
        }
        
        @Override
        public ArrayTypeMatchesArraysList getNewInstance(List<?> arg, List<Object> pathToItem, PathToSchemasMap pathToSchemas) {
            List<@Nullable Object> items = new ArrayList<>();
            int i = 0;
            for (Object item: arg) {
                List<Object> itemPathToItem = new ArrayList<>(pathToItem);
                itemPathToItem.add(i);
                LinkedHashMap<JsonSchema<?>, Void> schemas = pathToSchemas.get(itemPathToItem);
                if (schemas == null) {
                    throw new RuntimeException("Validation result is invalid, schemas must exist for a pathToItem");
                }
                JsonSchema<?> itemSchema = schemas.entrySet().iterator().next().getKey();
                @Nullable Object itemInstance = itemSchema.getNewInstance(item, itemPathToItem, pathToSchemas);
                items.add(itemInstance);
                i += 1;
            }
            FrozenList<@Nullable Object> newInstanceItems = new FrozenList<>(items);
            return new ArrayTypeMatchesArraysList(newInstanceItems);
        }
        
        public ArrayTypeMatchesArraysList validate(List<?> arg, SchemaConfiguration configuration) throws ValidationException {
            Set<List<Object>> pathSet = new HashSet<>();
            List<Object> pathToItem = List.of("args[0");
            List<?> castArg = castToAllowedTypes(arg, pathToItem, pathSet);
            SchemaConfiguration usedConfiguration = Objects.requireNonNullElseGet(configuration, () -> new SchemaConfiguration(new JsonSchemaKeywordFlags.Builder().build()));
            ValidationMetadata validationMetadata = new ValidationMetadata(pathToItem, usedConfiguration, new PathToSchemasMap(), new LinkedHashSet<>());
            PathToSchemasMap pathToSchemasMap = getPathToSchemas(this, castArg, validationMetadata, pathSet);
            return getNewInstance(castArg, validationMetadata.pathToItem(), pathToSchemasMap);
        }
        
        @Override
        public @Nullable Object validate(@Nullable Object arg, SchemaConfiguration configuration) throws ValidationException {
            if (arg instanceof List) {
                return validate((List<?>) arg, configuration);
            }
            throw new ValidationException("Invalid input type="+getClass(arg)+". It can't be validated by this schema");
        }        
        @Override
        public @Nullable Object getNewInstance(@Nullable Object arg, List<Object> pathToItem, PathToSchemasMap pathToSchemas) {
            if (arg instanceof List) {
                return getNewInstance((List<?>) arg, pathToItem, pathToSchemas);
            }
            throw new RuntimeException("Invalid input type="+getClass(arg)+". It can't be instantiated by this schema");
        }
        @Override
        public ArrayTypeMatchesArrays1BoxedList validateAndBox(List<?> arg, SchemaConfiguration configuration) throws ValidationException {
            return new ArrayTypeMatchesArrays1BoxedList(validate(arg, configuration));
        }
        @Override
        public ArrayTypeMatchesArrays1Boxed validateAndBox(@Nullable Object arg, SchemaConfiguration configuration) throws ValidationException {
            if (arg instanceof List<?> castArg) {
                return validateAndBox(castArg, configuration);
            }
            throw new ValidationException("Invalid input type="+getClass(arg)+". It can't be validated by this schema");
        }
    }
}
