# UniFormerV2

[UniFormerV2: Spatiotemporal Learning by Arming Image ViTs with Video UniFormer](https://arxiv.org/abs/2211.09552)

<!-- [ALGORITHM] -->

## 简介

```BibTeX
@article{Li2022UniFormerV2SL,
  title={UniFormerV2: Spatiotemporal Learning by Arming Image ViTs with Video UniFormer},
  author={Kunchang Li and Yali Wang and Yinan He and Yizhuo Li and Yi Wang and Limin Wang and Y. Qiao},
  journal={ArXiv},
  year={2022},
  volume={abs/2211.09552}
}
```

## 模型库

### Kinetics-400

| 均匀采样帧数 |     分辨率     |        主干网络        |      与训练      | top1 准确率 | top5 准确率 | [参考文献](https://github.com/OpenGVLab/UniFormerV2/blob/main/MODEL_ZOO.md) top1 准确率 | [参考文献](https://github.com/OpenGVLab/UniFormerV2/blob/main/MODEL_ZOO.md) top5 准确率 | mm-Kinetics top1 准确率 | mm-Kinetics top5 准确率 |     测试方案     | FLOPs | 参数量 |                                                        配置文件                                                         |                                                                                                                          ckpt                                                                                                                          |                                                                                                                 log                                                                                                                 |
| :----------: | :------------: | :--------------------: | :--------------: | :---------: | :---------: | :-------------------------------------------------------------------------------------: | :-------------------------------------------------------------------------------------: | :---------------------: | :---------------------: | :--------------: | :---: | :----: | :---------------------------------------------------------------------------------------------------------------------: | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: | :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|      8       | short-side 320 |    UniFormerV2-B/16    |       clip       |      -      |      -      |                                          84.3                                           |                                          96.4                                           |          84.4           |          96.3           | 4 clips x 3 crop | 0.1T  |  115M  |         [config](/configs/recognition/uniformerv2/uniformerv2-base-p16-res224_clip_8xb32-u8_kinetics400-rgb.py)         |                 [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/uniformerv2-base-p16-res224_clip_8xb32-u8_kinetics400-rgb/uniformerv2-base-p16-res224_clip_8xb32-u8_kinetics400-rgb_20230313-e29fc968.pth)                 |                 [log](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/uniformerv2-base-p16-res224_clip_8xb32-u8_kinetics400-rgb/uniformerv2-base-p16-res224_clip_8xb32-u8_kinetics400-rgb.log)                 |
|      8       | short-side 320 |    UniFormerV2-B/16    | clip-kinetics710 |      -      |      -      |                                          85.6                                           |                                          97.0                                           |          85.8           |          97.1           | 4 clips x 3 crop | 0.1T  |  115M  | [config](/configs/recognition/uniformerv2/uniformerv2-base-p16-res224_clip-kinetics710-pre_8xb32-u8_kinetics400-rgb.py) | [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/uniformerv2-base-p16-res224_clip-kinetics710-pre_8xb32-u8_kinetics400-rgb/uniformerv2-base-p16-res224_clip-kinetics710-pre_8xb32-u8_kinetics400-rgb_20230313-75be0806.pth) | [log](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/uniformerv2-base-p16-res224_clip-kinetics710-pre_8xb32-u8_kinetics400-rgb/uniformerv2-base-p16-res224_clip-kinetics710-pre_8xb32-u8_kinetics400-rgb.log) |
|      8       | short-side 320 |   UniFormerV2-L/14\*   | clip-kinetics710 |    88.7     |    98.1     |                                          88.8                                           |                                          98.1                                           |          88.7           |          98.1           | 4 clips x 3 crop | 0.7T  |  354M  |   [config](/configs/recognition/uniformerv2/uniformerv2-large-p14-res224_clip-kinetics710-pre_u8_kinetics400-rgb.py)    |                                  [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/kinetics400/uniformerv2-large-p14-res224_clip-kinetics710-pre_u8_kinetics400-rgb_20221219-972ea063.pth)                                   |                                                                                                                  -                                                                                                                  |
|      16      | short-side 320 |   UniFormerV2-L/14\*   | clip-kinetics710 |    89.0     |    98.2     |                                          89.1                                           |                                          98.2                                           |          89.0           |          98.2           | 4 clips x 3 crop | 1.3T  |  354M  |   [config](/configs/recognition/uniformerv2/uniformerv2-large-p14-res224_clip-kinetics710-pre_u16_kinetics400-rgb.py)   |                                  [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/kinetics400/uniformerv2-large-p14-res224_clip-kinetics710-pre_u16_kinetics400-rgb_20221219-6dc86d05.pth)                                  |                                                                                                                  -                                                                                                                  |
|      32      | short-side 320 |   UniFormerV2-L/14\*   | clip-kinetics710 |    89.3     |    98.2     |                                          89.3                                           |                                          98.2                                           |          89.4           |          98.2           | 2 clips x 3 crop | 2.7T  |  354M  |   [config](/configs/recognition/uniformerv2/uniformerv2-large-p14-res224_clip-kinetics710-pre_u32_kinetics400-rgb.py)   |                                  [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/kinetics400/uniformerv2-large-p14-res224_clip-kinetics710-pre_u32_kinetics400-rgb_20221219-56a46f64.pth)                                  |                                                                                                                  -                                                                                                                  |
|      32      | short-side 320 | UniFormerV2-L/14@336\* | clip-kinetics710 |    89.5     |    98.4     |                                          89.7                                           |                                          98.3                                           |          89.5           |          98.4           | 2 clips x 3 crop | 6.3T  |  354M  |   [config](/configs/recognition/uniformerv2/uniformerv2-large-p14-res336_clip-kinetics710-pre_u32_kinetics400-rgb.py)   |                                  [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/kinetics400/uniformerv2-large-p14-res336_clip-kinetics710-pre_u32_kinetics400-rgb_20221219-1dd7650f.pth)                                  |                                                                                                                  -                                                                                                                  |

### Kinetics-600

| 均匀采样帧数 | 分辨率 |        主干网络        |      预训练      | top1 准确率 | top5 准确率 | [参考文献](https://github.com/OpenGVLab/UniFormerV2/blob/main/MODEL_ZOO.md) top1 准确率 | [参考文献](https://github.com/OpenGVLab/UniFormerV2/blob/main/MODEL_ZOO.md) top5 准确率 | mm-Kinetics top1 准确率 | mm-Kinetics top5 准确率 |     测试方案     | FLOPs | 参数量 |                                                        配置文件                                                         |                                                                                                                          ckpt                                                                                                                          |                                                                                                                 log                                                                                                                 |
| :----------: | :----: | :--------------------: | :--------------: | :---------: | :---------: | :-------------------------------------------------------------------------------------: | :-------------------------------------------------------------------------------------: | :---------------------: | :---------------------: | :--------------: | :---: | :----: | :---------------------------------------------------------------------------------------------------------------------: | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: | :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|      8       |  Raw   |    UniFormerV2-B/16    | clip-kinetics710 |      -      |      -      |                                          86.1                                           |                                          97.2                                           |          86.4           |          97.3           | 4 clips x 3 crop | 0.1T  |  115M  | [config](/configs/recognition/uniformerv2/uniformerv2-base-p16-res224_clip-kinetics710-pre_8xb32-u8_kinetics600-rgb.py) | [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/uniformerv2-base-p16-res224_clip-kinetics710-pre_8xb32-u8_kinetics600-rgb/uniformerv2-base-p16-res224_clip-kinetics710-pre_8xb32-u8_kinetics600-rgb_20230313-544f06f0.pth) | [log](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/uniformerv2-base-p16-res224_clip-kinetics710-pre_8xb32-u8_kinetics600-rgb/uniformerv2-base-p16-res224_clip-kinetics710-pre_8xb32-u8_kinetics600-rgb.log) |
|      8       |  Raw   |   UniFormerV2-L/14\*   | clip-kinetics710 |    89.0     |    98.3     |                                          89.0                                           |                                          98.2                                           |          87.5           |          98.0           | 4 clips x 3 crop | 0.7T  |  354M  |   [config](/configs/recognition/uniformerv2/uniformerv2-large-p14-res224_clip-kinetics710-pre_u8_kinetics600-rgb.py)    |                                  [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/kinetics600/uniformerv2-large-p14-res224_clip-kinetics710-pre_u8_kinetics600-rgb_20221219-cf88e4c2.pth)                                   |                                                                                                                  -                                                                                                                  |
|      16      |  Raw   |   UniFormerV2-L/14\*   | clip-kinetics710 |    89.4     |    98.3     |                                          89.4                                           |                                          98.3                                           |          87.8           |          98.0           | 4 clips x 3 crop | 1.3T  |  354M  |   [config](/configs/recognition/uniformerv2/uniformerv2-large-p14-res224_clip-kinetics710-pre_u16_kinetics600-rgb.py)   |                                  [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/kinetics600/uniformerv2-large-p14-res224_clip-kinetics710-pre_u16_kinetics600-rgb_20221219-38ff0e3e.pth)                                  |                                                                                                                  -                                                                                                                  |
|      32      |  Raw   |   UniFormerV2-L/14\*   | clip-kinetics710 |    89.2     |    98.3     |                                          89.5                                           |                                          98.3                                           |          87.7           |          98.1           | 2 clips x 3 crop | 2.7T  |  354M  |   [config](/configs/recognition/uniformerv2/uniformerv2-large-p14-res224_clip-kinetics710-pre_u32_kinetics600-rgb.py)   |                                  [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/kinetics600/uniformerv2-large-p14-res224_clip-kinetics710-pre_u32_kinetics600-rgb_20221219-d450d071.pth)                                  |                                                                                                                  -                                                                                                                  |
|      32      |  Raw   | UniFormerV2-L/14@336\* | clip-kinetics710 |    89.8     |    98.5     |                                          89.9                                           |                                          98.5                                           |          88.8           |          98.3           | 2 clips x 3 crop | 6.3T  |  354M  |   [config](/configs/recognition/uniformerv2/uniformerv2-large-p14-res336_clip-kinetics710-pre_u32_kinetics600-rgb.py)   |                                  [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/kinetics600/uniformerv2-large-p14-res336_clip-kinetics710-pre_u32_kinetics600-rgb_20221219-f984f5d2.pth)                                  |                                                                                                                  -                                                                                                                  |

### Kinetics-700

| 均匀采样帧数 | 分辨率 |        主干网络        |      预训练      | top1 准确率 | top5 准确率 | [参考文献](https://github.com/OpenGVLab/UniFormerV2/blob/main/MODEL_ZOO.md) top1 准确率 | [参考文献](https://github.com/OpenGVLab/UniFormerV2/blob/main/MODEL_ZOO.md) top5 准确率 | mm-Kinetics top1 准确率 | mm-Kinetics top5 准确率 |     测试方案     | FLOPs | 参数量 |                                                        配置文件                                                         |                                                                                                                          ckpt                                                                                                                          |                                                                                                                 log                                                                                                                 |
| :----------: | :----: | :--------------------: | :--------------: | :---------: | :---------: | :-------------------------------------------------------------------------------------: | :-------------------------------------------------------------------------------------: | :---------------------: | :---------------------: | :--------------: | :---: | :----: | :---------------------------------------------------------------------------------------------------------------------: | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: | :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|      8       |  Raw   |    UniFormerV2-B/16    |       clip       |      -      |      -      |                                          75.8                                           |                                          92.8                                           |          75.9           |          92.9           | 4 clips x 3 crop | 0.1T  |  115M  | [config](/configs/recognition/uniformerv2/uniformerv2-base-p16-res224_clip-kinetics710-pre_8xb32-u8_kinetics700-rgb.py) |                 [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/uniformerv2-base-p16-res224_clip_8xb32-u8_kinetics700-rgb/uniformerv2-base-p16-res224_clip_8xb32-u8_kinetics700-rgb_20230313-f02e48ad.pth)                 |                 [log](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/uniformerv2-base-p16-res224_clip_8xb32-u8_kinetics700-rgb/uniformerv2-base-p16-res224_clip_8xb32-u8_kinetics700-rgb.log)                 |
|      8       |  Raw   |    UniFormerV2-B/16    | clip-kinetics710 |      -      |      -      |                                          76.3                                           |                                          92.7                                           |          76.3           |          92.9           | 4 clips x 3 crop | 0.1T  |  115M  | [config](/configs/recognition/uniformerv2/uniformerv2-base-p16-res224_clip-kinetics710-pre_8xb32-u8_kinetics700-rgb.py) | [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/uniformerv2-base-p16-res224_clip-kinetics710-pre_8xb32-u8_kinetics700-rgb/uniformerv2-base-p16-res224_clip-kinetics710-pre_8xb32-u8_kinetics700-rgb_20230313-69070837.pth) | [log](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/uniformerv2-base-p16-res224_clip-kinetics710-pre_8xb32-u8_kinetics700-rgb/uniformerv2-base-p16-res224_clip-kinetics710-pre_8xb32-u8_kinetics700-rgb.log) |
|      8       |  Raw   |   UniFormerV2-L/14\*   | clip-kinetics710 |    80.8     |    95.2     |                                          80.8                                           |                                          95.4                                           |          79.4           |          94.8           | 4 clips x 3 crop | 0.7T  |  354M  |   [config](/configs/recognition/uniformerv2/uniformerv2-large-p14-res224_clip-kinetics710-pre_u8_kinetics700-rgb.py)    |                                  [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/kinetics700/uniformerv2-large-p14-res224_clip-kinetics710-pre_u8_kinetics700-rgb_20221219-bfb9f401.pth)                                   |                                                                                                                  -                                                                                                                  |
|      16      |  Raw   |   UniFormerV2-L/14\*   | clip-kinetics710 |    81.2     |    95.6     |                                          81.2                                           |                                          95.6                                           |          79.2           |          95.0           | 4 clips x 3 crop | 1.3T  |  354M  |   [config](/configs/recognition/uniformerv2/uniformerv2-large-p14-res224_clip-kinetics710-pre_u16_kinetics700-rgb.py)   |                                  [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/kinetics700/uniformerv2-large-p14-res224_clip-kinetics710-pre_u16_kinetics700-rgb_20221219-745209d2.pth)                                  |                                                                                                                  -                                                                                                                  |
|      32      |  Raw   |   UniFormerV2-L/14\*   | clip-kinetics710 |    81.4     |    95.7     |                                          81.5                                           |                                          95.7                                           |          79.8           |          95.3           | 2 clips x 3 crop | 2.7T  |  354M  |   [config](/configs/recognition/uniformerv2/uniformerv2-large-p14-res224_clip-kinetics710-pre_u32_kinetics700-rgb.py)   |                                  [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/kinetics700/uniformerv2-large-p14-res224_clip-kinetics710-pre_u32_kinetics700-rgb_20221219-eebe7056.pth)                                  |                                                                                                                  -                                                                                                                  |
|      32      |  Raw   | UniFormerV2-L/14@336\* | clip-kinetics710 |    82.1     |    96.0     |                                          82.1                                           |                                          96.1                                           |          80.6           |          95.6           | 2 clips x 3 crop | 6.3T  |  354M  |   [config](/configs/recognition/uniformerv2/uniformerv2-large-p14-res336_clip-kinetics710-pre_u32_kinetics700-rgb.py)   |                                  [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/kinetics700/uniformerv2-large-p14-res336_clip-kinetics710-pre_u32_kinetics700-rgb_20221219-95cf9046.pth)                                  |                                                                                                                  -                                                                                                                  |

### MiTv1

| 均匀采样帧数 | 分辨率 |        主干网络        |            预训练            | top1 准确率 | top5 准确率 | [参考文献](https://github.com/OpenGVLab/UniFormerV2/blob/main/MODEL_ZOO.md) top1 准确率 | [参考文献](https://github.com/OpenGVLab/UniFormerV2/blob/main/MODEL_ZOO.md) top5 准确率 |     测试方案     | FLOPs | 参数量 |                                                              config                                                              |                                                                                                                                   ckpt                                                                                                                                   |                                                                                                                          log                                                                                                                          |
| :----------: | :----: | :--------------------: | :--------------------------: | :---------: | :---------: | :-------------------------------------------------------------------------------------: | :-------------------------------------------------------------------------------------: | :--------------: | :---: | :----: | :------------------------------------------------------------------------------------------------------------------------------: | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: | :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|      8       |  Raw   |    UniFormerV2-B/16    | clip-kinetics710-kinetics400 |    42.3     |    71.5     |                                          42.6                                           |                                          71.7                                           | 4 clips x 3 crop | 0.1T  |  115M  | [config](/configs/recognition/uniformerv2/uniformerv2-base-p16-res224_clip-kinetics710-kinetics-k400-pre_16xb32-u8_mitv1-rgb.py) | [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/uniformerv2-base-p16-res224_clip-kinetics710-kinetics-k400-pre_16xb32-u8_mitv1-rgb/uniformerv2-base-p16-res224_clip-kinetics710-kinetics-k400-pre_16xb32-u8_mitv1-rgb_20230313-a6f4a567.pth) | [log](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/uniformerv2-base-p16-res224_clip-kinetics710-kinetics-k400-pre_16xb32-u8_mitv1-rgb/uniformerv2-base-p16-res224_clip-kinetics710-kinetics-k400-pre_16xb32-u8_mitv1-rgb.log) |
|      8       |  Raw   |   UniFormerV2-L/14\*   | clip-kinetics710-kinetics400 |    47.0     |    76.1     |                                          47.0                                           |                                          76.1                                           | 4 clips x 3 crop | 0.7T  |  354M  |    [config](/configs/recognition/uniformerv2/uniformerv2-large-p16-res224_clip-kinetics710-kinetics-k400-pre_u8_mitv1-rgb.py)    |                                          [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/mitv1/uniformerv2-large-p16-res224_clip-kinetics710-kinetics-k400-pre_u8_mitv1-rgb_20221219-882c0598.pth)                                           |                                                                                                                           -                                                                                                                           |
|      8       |  Raw   | UniFormerV2-L/14@336\* | clip-kinetics710-kinetics400 |    47.7     |    76.8     |                                          47.8                                           |                                          76.0                                           | 4 clips x 3 crop | 1.6T  |  354M  |    [config](/configs/recognition/uniformerv2/uniformerv2-large-p16-res336_clip-kinetics710-kinetics-k400-pre_u8_mitv1-rgb.py)    |                                          [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/mitv1/uniformerv2-large-p16-res336_clip-kinetics710-kinetics-k400-pre_u8_mitv1-rgb_20221219-9020986e.pth)                                           |                                                                                                                           -                                                                                                                           |

### Kinetics-710

| 均匀采样帧数 | 分辨率 |        主干网络        | 预训练 | top1 准确率 | top5 准确率 |                    config                     |                     ckpt                     |                     log                     |
| :----------: | :----: | :--------------------: | :----: | :---------: | :---------: | :-------------------------------------------: | :------------------------------------------: | :-----------------------------------------: |
|      8       |  Raw   |   UniFormerV2-B/16\*   |  clip  |    78.9     |    94.2     | [config](/configs/recognition/uniformerv2/uniformerv2-base-p16-res224_clip-pre_u8_kinetics710-rgb.py) | [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/uniformerv2-base-p16-res224_clip-pre_u8_kinetics710-rgb/uniformerv2-base-p16-res224_clip-pre_u8_kinetics710-rgb_20230612-63cdbad9.pth) | [log](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/uniformerv2-base-p16-res224_clip-pre_u8_kinetics710-rgb/uniformerv2-base-p16-res224_clip-pre_u8_kinetics710-rgb.log) |
|      8       |  Raw   |   UniFormerV2-L/14\*   |  clip  |      -      |      -      | [config](/configs/recognition/uniformerv2/uniformerv2-large-p14-res224_clip-pre_u8_kinetics710-rgb.py) | [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/kinetics710/uniformerv2-large-p14-res224_clip-pre_u8_kinetics710-rgb_20230612-d002a407.pth) |                      -                      |
|      8       |  Raw   | UniFormerV2-L/14@336\* |  clip  |      -      |      -      | [config](/configs/recognition/uniformerv2/uniformerv2-large-p14-res336_clip-pre_u8_kinetics710-rgb.py) | [ckpt](https://download.openmmlab.com/mmaction/v1.0/recognition/uniformerv2/kinetics710/uniformerv2-large-p14-res336_clip-pre_u8_kinetics710-rgb_20230612-d723ddc1.pth) |                      -                      |

以上带有 * 的模型是迁移自[UniFormerV2仓库](https://github.com/OpenGVLab/UniFormerV2/blob/main/MODEL_ZOO.md)，并在我们的数据上进行了测试。由于算力限制，我们仅支持基础模型（即 UniFormerV2-B/16）训练配置的可靠性。

1. "参考文献"列中的数值是原始仓库的结果。
2. `top1/5准确率` 中的数值是在与原始仓库相同的数据上进行测试得到的，并且分类器-标签映射与 [UniFormerV2](https://drive.google.com/drive/folders/17VB-XdF3Kfr9ORmnGyXCxTMs86n0L4QL)一致。
3. "mm-Kinetics" 列中的数值是在 MMAction2 持有的 Kinetics 数据集上进行的测试结果，其他 MMAction2 模型也使用了该数据集。由于各个版本的 Kinetics 数据集之间存在差异，`top1/5准确率` 和 `mm-Kinetics top1/5准确率` 之间存在一些差异。为了与其他模型进行公平比较，我们在这里报告了两个结果。请注意，我们只报告推断结果，因为 UniFormer 和其他模型的训练集不同，所以该结果低于在作者版本上测试的结果。
4. 由于 Kinetics-400/600/700 的原始模型采用了不同的[标签文件](https://drive.google.com/drive/folders/17VB-XdF3Kfr9ORmnGyXCxTMs86n0L4QL)，我们根据标签名称简单映射权重。Kinetics-400/600/700的新标签映射可以在[这里](/tools/data/kinetics)找到。
5. 由于 [SlowFast](https://github.com/facebookresearch/SlowFast)和 MMAction2 之间存在一些差异，它们的性能之间存在一些差距。
6. 我们使用Kinetics-710进行预训练，这有助于提高其他数据集的性能。你可以在[论文](https://arxiv.org/abs/2211.09552)中找到更多细节。我们还根据 Kinetics-710 的模型权重进行了权重映射，你可以在[这里](/tools/data/kinetics710/label_map_k710.txt)找到标签映射。

有关数据准备的更多详细信息，可以参考以下链接：

- [准备 Kinetics 数据集](/tools/data/kinetics/README_zh-CN.md)
- [准备 MIT 数据集](/tools/data/mit/README_zh-CN.md)

## 如何测试

您可以使用以下命令来测试模型：

```shell
python tools/test.py ${CONFIG_FILE} ${CHECKPOINT_FILE} [optional arguments]
```

示例：在 Kinetics-400 数据集上测试 UniFormerV2-B/16 模型，并将结果转储到一个pkl文件中。

```shell
python tools/test.py configs/recognition/uniformerv2/uniformerv2-base-p16-res224_clip-kinetics710-pre_u8_kinetics400-rgb.py \
    checkpoints/SOME_CHECKPOINT.pth --dump result.pkl
```

有关更多详细信息，请参考[训练和测试教程](/docs/zh_cn/user_guides/train_test.md)中的**测试**部分。
