# 设计

## 原则

### 使用消息结构对象转发

由于各分路 io 的读写能力不一致，如果使用类似零拷贝的方式直接将不同 io 中的
数据流对考，很容易因某个 io 的瓶颈而影响全局。

因此，我们需要把数据流读取出来，变成消息结构，利用 golang 的 channel 机制，
快速路由消息到各自去路。

### 利用 golang 的 goroutine 优点，并行处理消息流。

以免一个慢的消息流影响了所有消息流的速度。

如果发现一个消息接收端消化速率太慢，通知对端等待发送。

### 支持速率控制

如果某个 io 速率太慢（带缓冲的 channel 已满），或速率过快，可以：

1. 标记该 channel 为暂停
2. 通知对端少等再读
3. 通过 goroutine 延时插入此次消息
