import * as assert from "assert"
import * as fs from "fs"
import * as path from "path"

import { Oni } from "./Oni"
//
// tslint:disable:no-console

const findProcess = require("find-process") // tslint:disable-line

// Sometimes, on the automation machines, Oni will still be running
// when starting the test. It will fail if there is an existing instance
// running, so we need to make sure to finish it.
export const ensureProcessNotRunning = async (processName: string) => {
    let attempts = 1
    const maxAttempts = 5

    while (attempts < maxAttempts) {
        console.log(`${attempts}/${maxAttempts} Active Processes:`)

        const targetProcessGone = await tryToKillProcess(processName)

        if (targetProcessGone) {
            console.log(`All ${processName} processes gone!`)
            return
        }

        attempts++
    }
}

const tryToKillProcess = async (processName: string): Promise<boolean> => {
    const targetProcesses = await findProcess("name", processName)

    targetProcesses.forEach(processInfo => {
        console.log(` - Name: ${processInfo.name} PID: ${processInfo.pid}`)
    })

    const isValidTargetProcess = processInfo =>
        processInfo.name.toLowerCase().indexOf(processName) >= 0
    const filteredProcesses = targetProcesses.filter(isValidTargetProcess)

    console.log(`- Found ${filteredProcesses.length} processes with name:  ${processName}`)

    if (filteredProcesses.length === 0) {
        console.log(`No ${processName} processes found - leaving.`)
        return true
    }

    filteredProcesses.forEach(processInfo => {
        console.log("Attempting to kill pid: " + processInfo.pid)
        // Sometimes, there can be a race condition here. For example,
        // the process may have closed between when we queried above
        // and when we try to kill it. So we'll wrap it in a try/catch.
        try {
            process.kill(processInfo.pid)
        } catch (ex) {
            console.warn(ex)
        }
    })

    return false
}
