import * as fs from "fs"

import * as Oni from "oni-api"

import * as path from "path"

import { Assertor } from "./Assert"
import { useTempWorkspace, waitForCommand } from "./Common"

export const test = async (oni: Oni.Plugin.Api) => {
    const assert = new Assertor("QuickOpen", oni)
    await oni.automation.waitForEditors()
    await oni.automation.waitFor(() => oni.plugins.loaded)
    const instance = oni.plugins.getPlugin("oni-plugin-quickopen")
    assert.defined(instance, "plugin instance")

    await useTempWorkspace(oni)

    // Start
    console.info(`QuickOpen: Open and close the menu`) // tslint:disable-line no-console
    oni.commands.executeCommand("quickOpen.searchFileByPath")
    await oni.automation.waitFor(() => oni.menu.isMenuOpen())

    await waitForCommand("menu.close", oni)
    oni.commands.executeCommand("menu.close")
    await oni.automation.waitFor(() => !oni.menu.isMenuOpen())
    await oni.automation.sleep(100)
    // End

    // Start
    console.info(`QuickOpen: File search`) // tslint:disable-line no-console
    await waitForCommand("quickOpen.searchFileByPath", oni)
    oni.commands.executeCommand("quickOpen.searchFileByPath")
    await oni.automation.waitFor(() => oni.menu.isMenuOpen())

    const anyOni = oni as any
    await oni.automation.sleep(1000)
    anyOni.automation.sendKeysV2("file.ts")
    await oni.automation.sleep(2000)
    anyOni.automation.sendKeysV2("<CR>")
    const editor = oni.editors.activeEditor
    await assert.waitFor(() => editor.activeBuffer.filePath, (fp: string) => fp.endsWith("File.ts"))
    // End
}
