# Contribute

## Introduction

First, thank you for considering contributing to oni! It's people like you that make the open source community such a great community! 😊

We welcome any type of contribution, not only code. You can help with

*   **QA**: file bug reports, the more details you can give the better (e.g. screenshots with the console open)
*   **Marketing**: writing blog posts, howto's, printing stickers, ...
*   **Community**: presenting the project at meetups, organizing a dedicated meetup for the local community, ...
*   **Code**: take a look at the [open issues](issues). Even if you can't write code, commenting on them, showing that you care about a given issue matters. It helps us triage them.
*   **Money**: we welcome financial contributions in full transparency on our [open collective](https://opencollective.com/oni).

## Your First Contribution

Working on your first Pull Request? You can learn how from this _free_ series, [How to Contribute to an Open Source Project on GitHub](https://egghead.io/series/how-to-contribute-to-an-open-source-project-on-github).

## Submitting code

Any code change should be submitted as a pull request. The description should explain what the code does and give steps to execute it. The pull request should also contain tests. We welcome and appreciate pull requests!

## Code review guidelines

*   Keep PRs **small and scoped**. The bigger the pull request, the longer it will take to review and merge. Break down large pull requests into smaller incremental chunks - this will help catch issues earlier and be easier on both you and the maintainer.
*   Following from the previous bullet point, **do not include unrelated changes in a PR**. It can be tempting to include extra styling changes or additional functionality, but these should be added as separate PRs.
*   Think of each PR as **improving the quality of the codebase**. Codebases tend towards entropy and disorder unless actively managed - make sure that your change moves the quality needle in the right direction. This can take a variety of forms, including adding test coverage, reducing coupling, etc. _As we are a small team moving fast, we cannot afford to accumulate technical debt._
*   If there is ambiguity in terms of design, architecture, or implementation, it's best to get **feedback before implementing**, to save both you and the maintainer time. If you're not sure, feel free to ask!
*   For your first few PRs, **don't try and change the world** - pick some small issues and get familiar with the codebase. Then, work your way up to bigger issues - this will set you up for success.

PRs require approval from one other person, either a maintainer or a contributor. Keep in mind that when you approve code, you are accountable for it, too! Reviewers are the gatekeepers of quality and ensuring adherence to the guidelines above.

## Financial contributions

We also welcome financial contributions in full transparency on our [open collective](https://opencollective.com/oni).
Anyone can file an expense. If the expense makes sense for the development of the community, it will be "merged" in the ledger of our open collective by the core contributors and the person who filed the expense will be reimbursed.

### Bounties

The primary allotment of our [open collective](https://opencollective.com/oni) budget is dedicated to bounties. Developing features and fixing bugs is a lot of work, and those go directly to the developers doing this work via bounties. It is the role of the _maintainer_ to set bounties and clear completion criteria. Issues that have a bounty associated with them will have a `bounty` label as well as an amount, ie, `bounty-50` means a $50 bounty.

*   Guidelines:
    *   The fix for the bug/feature/issue _MUST_ be complete and _MUST_ be covered by tests to be eligible for a bounty.
    *   Any associated documentation relevant to the bug/feature _MUST_ be updated.
    *   If you begin working on an issue with an associated bounty, open a PR with "WIP" and the bug number in the title, as well as reference the issue #. This is important to reduce duplicate work.

#### Claiming a bounty

*   Upon completion of an issue with an associated bounty, bounties are payable by [Submitting an Expense](https://opencollective.com/oni/expenses/new) on our [OpenCollective](https://opencollective.com/oni). Note that OpenCollective requires a PDF or Photo of an expense form for an expense claim to be accepted - more information, including an example expense form can be found [here](https://opencollective.com/faq#expense). Check out our [expenses](https://opencollective.com/oni/expenses#) page for an example.
*   A collaborator will approve the expense once we have verified it meets the criteria outlined above (complete fix, covered by tests, associated documentation updated)

If you questions about the guidelines, please don't hesitate to contact the maintainer.

## Roles

There are various roles and responsibilities in managing an open-source project. Users that are active and have a positive impact on the project and community will be recognized and have the option of assuming additional responsibilities.

*   **Maintainer** - A maintainer communicates goals and drives the vision for the project. The maintainer is responsible for breaking down hurdles and supporting contributors. In addition, the maintainer triages issues, produces releases, assigns bounties, and establishes completion criteria. Today, there is one maintainer, but that isn't a strict requirement.
*   **Collaborator** - A collaborator is an established member of the project that is recognized for their impact and contributions. They can triage and close issues, approve PRs from other contributors / collaborators, and can approve expenses on our [open collective](https://opencollective.com/oni)
*   **Contributor** - A contributor is a developer that has submitted a successful PR for the project.

### Becoming a collaborator

A collaborator is a contributor who has been recognized for the impact they've had on the project, over a sustained period of time. In general, this means the following:

*   **Supporting the community** - helping others in issues and chat, supporting new developers, creating a positive and supportive environment.
*   **Technical impact** - involvement in a core technical piece of the editor, or a broad impact on the ecosystem.
*   **Positive and collaborative mindset** - creating good vibes, willingness to give and receive constructive feedback, being a team player.

## Questions

If you have any questions, create an [issue](issue) (protip: do a quick search first to see if someone else didn't ask the same question before!).
You can also reach us at hello@oni.opencollective.com.

## Credits

### Contributors

Thank you to all the people who have already contributed to oni!
<a href="graphs/contributors"><img src="https://opencollective.com/oni/contributors.svg?width=890" /></a>

### Backers

Thank you to all our backers! [[Become a backer](https://opencollective.com/oni#backer)]

<a href="https://opencollective.com/oni#backers" target="_blank"><img src="https://opencollective.com/oni/backers.svg?width=890"></a>

### Sponsors

Thank you to all our sponsors! (please ask your company to also support this open source project by [becoming a sponsor](https://opencollective.com/oni#sponsor))

<a href="https://opencollective.com/oni/sponsor/0/website" target="_blank"><img src="https://opencollective.com/oni/sponsor/0/avatar.svg"></a>
<a href="https://opencollective.com/oni/sponsor/1/website" target="_blank"><img src="https://opencollective.com/oni/sponsor/1/avatar.svg"></a>
<a href="https://opencollective.com/oni/sponsor/2/website" target="_blank"><img src="https://opencollective.com/oni/sponsor/2/avatar.svg"></a>
<a href="https://opencollective.com/oni/sponsor/3/website" target="_blank"><img src="https://opencollective.com/oni/sponsor/3/avatar.svg"></a>
<a href="https://opencollective.com/oni/sponsor/4/website" target="_blank"><img src="https://opencollective.com/oni/sponsor/4/avatar.svg"></a>
<a href="https://opencollective.com/oni/sponsor/5/website" target="_blank"><img src="https://opencollective.com/oni/sponsor/5/avatar.svg"></a>
<a href="https://opencollective.com/oni/sponsor/6/website" target="_blank"><img src="https://opencollective.com/oni/sponsor/6/avatar.svg"></a>
<a href="https://opencollective.com/oni/sponsor/7/website" target="_blank"><img src="https://opencollective.com/oni/sponsor/7/avatar.svg"></a>
<a href="https://opencollective.com/oni/sponsor/8/website" target="_blank"><img src="https://opencollective.com/oni/sponsor/8/avatar.svg"></a>
<a href="https://opencollective.com/oni/sponsor/9/website" target="_blank"><img src="https://opencollective.com/oni/sponsor/9/avatar.svg"></a>

<!-- This `CONTRIBUTING.md` is based on @nayafia's template https://github.com/nayafia/contributing-template -->
