# Awesome [Astro](https://twitter.com/astrodotbuild)
Curated resources on __building sites with Astro__, a brand new way to build static and server rendered sites, with cross-framework components, styling and reactive store support. If you appreciate the content 📖, support projects visibility, give 👍| ⭐| 👏.

Astro is _super duper new_, improving, and becoming more expressive + powerful, but few of the APIs are still evolving. This page aspires to collect all the valauble references out there, and be a useful go-to resource when astro hits it's first stable version.

__[Official Docs](https://docs.astro.build)__ | [Launch a new project](https://astro.new/) , or use [Code Sandbox](https://codesandbox.io/p/github/codesandbox/codesandbox-template-astro/main?file=%2FREADME.md)

## ✍️ Blogs
Look for __NEW__ against the post titles to find the blogs published after Astro 1.0
- [Introducing Astro: Ship Less JavaScript](https://astro.build/blog/introducing-astro) - [Fred K. Schott](https://twitter.com/FredKSchott)
- [A Look at Building with Astro](https://css-tricks.com/a-look-at-building-with-astro/) - [Chris Coyier](https://twitter.com/chriscoyier)
- [Thoughts on Astro](https://css-tricks.com/newsletter/255-thoughts-on-astro/) - [Chris Coyier](https://twitter.com/chriscoyier)
- [Our experience with Astro](https://divriots.com/blog/our-experience-with-astro/) - [Georges](https://twitter.com/georges_gomes)
- Astro with [Netlify CMS](https://navillus.dev/blog/astro-plus-netlify-cms), [Forestry CMS](https://navillus.dev/blog/astro-plus-forestry)([re-visited](https://navillus.dev/blog/astro-plus-forestry-revisited)), and [Snipcart](https://navillus.dev/blog/astro-plus-snipcart) - [Navillus](https://navillus.dev/)
- [How to Use Astro to Build React Apps without JavaScript](https://spacejelly.dev/posts/how-to-use-astro-to-build-react-apps-without-javascript/) - [Colby Fayock](https://twitter.com/colbyfayock)
- [Build wicked fast sites with Astro: An Introduction](https://www.netlify.com/blog/2021/07/08/build-wicked-fast-sites-with-astro-an-introduction/) - [Cassidy Williams](https://twitter.com/cassidoo)
- [A first look at Astro, astronomical results](https://daily-dev-tips.com/posts/a-first-look-at-astra-astronomical-results/)
- [Why Astro matters](https://dev.to/endymion1818/why-astro-matters-55nj)
- [SvelteKit to Astro](https://navillus.dev/blog/converting-navillus-to-astro)
- [Getting Started With Astro — The Innovative Static Site Generator](https://javascript.plainenglish.io/astro-cec429f049d)
- [Astro Will Become Your Favorite Static Site Generator](https://javascript.plainenglish.io/astro-906b03f63ab8)
- [Build a Recipe collection website with Astro](https://daily-dev-tips.com/posts/astro-recipe-collection-website-part-1-setup-collections) - Parts &rarr; [1](https://daily-dev-tips.com/posts/astro-recipe-collection-website-part-1-setup-collections/) - [2](https://daily-dev-tips.com/posts/astro-recipe-collection-website-part-2-homepage-rendering/) - [3](https://daily-dev-tips.com/posts/astro-recipe-collection-website-part-3-category-filter-pages/) - [4](https://daily-dev-tips.com/posts/astro-recipe-collection-website-part-4-styling-the-website/) - [5](https://daily-dev-tips.com/posts/astro-recipe-collection-website-part-5-hosting-on-netlify/)
- [Astro: Build faster apps with less JavaScript](https://blog.logrocket.com/astro-build-faster-apps-less-javascript/)
- [Series - Learn Astro while building Ink - Get Up & Running](https://aalam.in/blog/astro-get-up-and-running) 
- [Series - Learn Astro while building Ink - Astro and Site Structure](https://aalam.in/blog/astro-and-site-strcuture) 
- [Series - Learn Astro while building Ink - Astro and Data](https://aalam.in/blog/astro-and-data) 
- [Series - Learn Astro while building Ink - Astro and Interactivity](https://aalam.in/blog/astro-and-interactivity) 
- [Series - Learn Astro while building Ink - Astro and Dynamic Pages](https://aalam.in/blog/astro-and-dynamic-pages)
- [Getting started with Astro](https://rodneylab.com/getting-started-astro/)
- [Migrating from SvelteKit to Astro](https://byteofdev.com/posts/sveltekit-to-astro/)
- [Personal website with Astro, Tailwind CSS, and Nx](https://leosvel.dev/blog/creating-my-personal-website-with-astro-tailwindcss-and-nx/)
- [Astro on Cloudflare Workers](https://dev.to/thepassle/astro-on-cloudflare-workers-2ng7)
- [The case about Astro](https://okupter.com/blog/the-case-about-astro/)
- [Explore the Benefits of Astro.js by Building a Quick App](https://prismic.io/blog/astro-js-tutorial) __NEW__
- [Experiments with Astro and the Shared Element Transition API](https://www.maxiferreira.com/blog/astro-page-transitions/) __NEW__
- [Building serverless applications with Fauna + GraphQL + Astro](https://bholmes.dev/blog/serverless-apps-fauna-gql-astro/) __NEW__
- [Learn how to install Astro with Tailwind CSS and Flowbite](https://flowbite.com/docs/getting-started/astro/) __NEW__
- [Automatic article suggestions in Astro](https://www.nmattia.com/posts/2023-02-25-astro-suggestions/) __NEW__
- [Learn Astro by creating your web portfolio (Spanish)](https://www.webreactiva.com/bootcamp/astro) __NEW__
- [Animated SVGs - The Ultimate Web Format](https://aminoffz.github.io/blog/blog/animated-svgs/) __NEW__
- [An introduction to Astro's content system](https://kristianfreeman.com/an-introduction-to-astros-content-system/) __NEW__


## 📹 Videos/Screencasts/Twitch
- [Astro just Launched.... Could it be the ultimate web framework?](https://www.youtube.com/watch?v=gxBkghlglTg)
- [Brad Traversy's Astro Crash Course](https://www.youtube.com/watch?v=Oi9z5gfIHJs)
- [What’s New in Astro v1?](https://www.learnwithjason.dev/what-s-new-in-astro-v1)
- [I Try Astro For the First Time!](https://www.youtube.com/watch?v=2H9T1-H5V3M)
- [Astro and Svelte](https://www.youtube.com/watch?v=iYKKg-50Gm4)
- [Modern Websites with CSS Cascade Layers and Astro](https://www.twitch.tv/videos/1563918235)
- [The Next Wave of Web Frameworks is BYOJS](https://portal.gitnation.org/contents/the-next-wave-of-web-frameworks-is-byojs)
- [Taking Astro for a ride - portfolio edition](https://www.youtube.com/watch?v=QkY_rZpjEew)

Pre 1.0
- [Ship Less JavaScript with Astro](https://www.learnwithjason.dev/ship-less-javascript-with-astro) - __Fredd K. Schott__ & __Jason Lengstorf__
- [Speakeasy JS – Astro: A New Architecture for the Modern Web](https://www.youtube.com/watch?v=mgkwZqVkrwo) - __Fred K. Schott__ (YouTube - Speakeasy JS)
- [Astro in 100 Seconds](https://www.youtube.com/watch?v=dsTXcSeAZq8) - __Jeff Delaney__ (Fireship)
- [Yapping About Astro](https://www.youtube.com/watch?v=3jPaidbpUIA) - __Chris Coyier__ (CSS Tricks)
- [Astro FTW! Vue and React can work together in the same app](https://www.youtube.com/watch?v=sUrxtZA2sA0) - __Jamstack Fridays__
- [Learning Astro with Nate Moore](https://www.youtube.com/watch?v=def9EgQzRUw) - __Nate Moore__ (YouTube - React Wednesdays)
- [Ship less JS with Astro](https://courses.jamstack.training/p/ship-less-javascript-with-astro) - __Jamstack Training__
- [Create template layouts for your HTML with Astro SSG](https://www.youtube.com/watch?v=o7iQAF2EvUU) - __Kevin Powell__
- [Build faster websites with Astro](https://www.youtube.com/watch?v=x3hiyWikdrE)
- [Add comments with Airtable and Netlify](https://www.youtube.com/watch?v=IEpP05XSwWE)
- [Grow Community Through Open Source | Fred K. Schott of Astro| The Secret Sauce](https://www.youtube.com/watch?v=IjujjSU_cOA)

## 🧶 Condensed Thought-pieces (Twitter Threads)
- [__Georges__ on Astro](https://twitter.com/georges_gomes/status/1380801812656226304) as a meta web framework
- [__Nate Moore__ on Incremental Framework adoption](https://twitter.com/astrodotbuild/status/1414283562795208707), [Solid.js](https://www.solidjs.com/) support, and a future without `import React from 'react'` for components.
- [__Matthew Phillips__ on Astro for Web Components](https://twitter.com/matthewcp/status/1411050609105637377), [lit](https://twitter.com/matthewcp/status/1407826230129332228) and server-rendered custom elements
- [__Matthew Phillips__ on Astro Loading](https://twitter.com/matthewcp/status/1414957982652243970)
- [__Nate Moore__ on baseline JS bundle size](https://twitter.com/n_moore/status/1415067187446960129)
- [Build a landing page in 30 seconds](https://twitter.com/astrodotbuild/status/1565438744500502528)
- [Client-side routing experience with Shared Element Transitions API](https://twitter.com/charca/status/1562933467104440321)


## ℹ️ Repositories/Starter Kits/Components
- [Astro-react-vue-demo](https://github.com/cassidoo/astro-react-vue-demo)
- [Astro-netlify-starter](https://github.com/cassidoo/astro-netlify-starter)
- [Astro Ink](https://github.com/one-aalam/astro-ink) - Crisp, minimal, personal blog theme for Astro
- [Astro Me](https://github.com/one-aalam/astro-me) - Crisp, minimal, personal portfolio theme for Astro
- [Astro Starter Kit](https://github.com/one-aalam/astro-starter-kit)
- [Astro Static Tweet](https://github.com/rebelchris/astro-static-tweet)
- [Astro Translation Example](https://github.com/tylergaw/astro-example-i18next)
- [Astro Ghost CMS Starter](https://github.com/PhilDL/astro-starter-ghost) - A Ghost CMS starter for Astro
- [Astro Theme - Creek](https://github.com/robertguss/Astro-Theme-Creek) - A Blog theme for Astro
- [Astro Theme - Odessey](https://github.com/littlesticksdev/odyssey-theme) - A marketing website theme built with Astro and carefully crafted for startups and businesses
- [Astro Theme - Sarissa Blog](https://github.com/iozcelik/SarissaBlogAstroStarter) - A responsive blog theme for Astro
- [Astro Theme - Cactus](https://github.com/chrismwilliams/astro-theme-cactus) - Simple, opinionated starter built with the Astro framework for blog or website
- [Astro Theme - AstroWind](https://github.com/onwidget/astrowind) - Started template to make a website using Astro and Tailwind CSS.
- [Astro Theme - Bigspring Light Astro](https://statichunt.com/themes/astro-bigspring-light) - Astro Business theme using Astro and Tailwind CSS.
- [Astro TAP Stack](https://github.com/codiume/the-tap-stack) - Opinionated astro starter kit (Typescript & Tailwind + Astro + Prisma & Planet scale)
- [Astro Deno Starter](https://github.com/reggi/astro-deno-starter)
- [Astro + Supabase + Vercel](https://github.com/magnuswahlstrand/astro-supabase-vercel)
- [Astro + Snipcart](https://github.com/lloydjatkinson/astro-snipcart)
- [Astro-MFE-Demo](https://github.com/itmaginationdemos/astro-multiframework-demo) - Showcasing how to set up a microfrontend running on Astro.
- [Refo](https://github.com/kireerik/refo) - A static site and resume example with styled components.
- [Astro Blog Starter with Netlify CMS](https://github.com/delucis/astro-netlify-cms-starter) - Template based on the Astro blog starter kit + Astro Netlify CMS integration.
- [Catonaut](https://github.com/AminoffZ/catonaut) - Browser extension template using Astro and Bun.
- [Astro Saas](https://astrosaas.vercel.app/) - SaaS website tempalte built with Astro and Tailwind CSS.
- [AstroMax](https://astromax.vercel.app/) - Brutalist landing page tempalte built with Astro and Tailwind CSS.
- [SwissFolio](https://swissfolio.vercel.app/) - A Swiss style landing page template for personal use built with Astro and Tailwind CSS.
- [Minimal Studio](https://minimalstudio.vercel.app/) - An minimal landing page template for agencies, studios or freelancers built with Astro and Tailwind CSS.
- [Gurido](https://gurido.vercel.app/) A super cool, playfull and modern landing page template for agencies, studios or freelancers built with Astro and Tailwind CSS.
- [MicroBlog](https://microblog-theta.vercel.app/) - An elegant blog website template built with Astro, Tailwind CSS and MDX.
- [Quick Store](https://quickstorre.vercel.app/) - A minimal dark theme landing page to sell digital products.

## Astro Packages/Libraries
- [Astro SEO](https://github.com/jonasmerlin/astro-seo) - Better SEO with Astro
- [Astro Stylesheet Component](https://www.npmjs.com/package/astro-stylesheet) - Abstract the monotony of adding stylesheets to any Astro project
- [Astro Command](https://www.npmjs.com/package/astro-command) - Statically render commands and build components in any language
- [Astro Pandoc](https://github.com/trashhalo/astro-pandoc) - Pandoc rendering for Astro
- [Astro SPA](https://www.npmjs.com/package/astro-spa) - The SPA library for Astro that will turn your website into a Single Page Application
- [Astro Icon](https://github.com/natemoo-re/astro-icon) - Straight-forward Icon component for Astro
- [Astro ImageTools](https://github.com/RafidMuhymin/astro-imagetools) - Image Optimization tools for the Astro JS framework
- [Accessible Astro Components](https://www.npmjs.com/package/accessible-astro-components)
- [Astro Eleventy Image](https://github.com/Princesseuh/astro-eleventy-img)
- [Astro Forms](https://github.com/jackmerrill/AstroForms) - Forms in Astro made easy
- [Astro Auto-import](https://github.com/delucis/astro-auto-import) - Auto-import components in Astro projects
- [Astro Collection](https://github.com/JulianCataldo/astro) - An Astro components and configurations collection
- [Astro Link](https://www.npmjs.com/package/astro-link) - Detects external / anchor / same domain / mail / telephone href, and apply optimizations accordingly
- [Sarissa Pagination](https://github.com/iozcelik/SarissaPagination) - Add page number buttons for pagination. Automatically add and disable numbers as current page number.
- [Astro Google Fonts Optimizer](https://github.com/sebholstein/astro-google-fonts-optimizer) - An Astro integration to optimize the Google Fonts loading performance
- [Astro SEO Meta](https://github.com/codiume/astro-seo-meta) - Astro component to add tags that are relevant for search engine optimization (SEO) to your pages.
- [Astro Heroicons](https://www.npmjs.com/package/astro-heroicons) - Heroicons as Astro components
- [Astroad](https://github.com/mooxl/astroad) - A pre-configured setup for easy website development with Astro and Payload CMS using Docker.
- [Astro Social Share](https://github.com/silent1mezzo/astro-social-share) - Social media share buttons for your Astro site
- [Astro Gist](https://github.com/kotosha-real/astro-gist) - Astro component to easily add GitHub gists to your blog
- [Astro Breadcrumbs](https://github.com/felix-berlin/astro-breadcrumbs) - Well configurable breadcrumb component for Astro. Create breadcrumbs completely dynamically or specify exactly how they should look.

## Astro Integrations
- [Astro Content](https://github.com/JulianCataldo/astro-content) - A text based, structured content manager, for edition and consumption — AstroJS Integration
- [@storyblok/astro](https://github.com/storyblok/storyblok-astro) - Astro module for the Storyblok, Headless CMS
- [@unocss/astro](https://github.com/unocss/unocss/tree/main/packages/astro) - The UnoCSS integration for Astro
- [@yeskunall/umami](https://github.com/yeskunall/astro-umami) - Add Umami Analytics to your website
- [Google Font Optimizer](https://github.com/sebholstein/astro-google-fonts-optimizer) - An Astro integration to optimize the Google Fonts loading performance
- [Astro Firebase](https://github.com/thepassle/astro-firebase) - Deploy your server-side rendered (SSR) Astro app to Firebase
- [Astro Font Picker](https://github.com/randombits-dev/astro-font-picker) - A Dev Toolbar Integration that lets you try out different fonts on your website
- [ParaglideJS](https://inlang.com/m/iljlwzfs/library-inlang-paraglideJsAdapterAstro) - A tiny, type-safe i18n integration that only ships messages used on islands to the client.

## Built with Astro
- https://astro.build/showcase/ (__Official Showcase Directory__)
- [Designcember](https://designcember.com/#3rd)
- [Serverless(CSS Tricks)](https://serverless.css-tricks.com/)
- [Trivago - Tech Blog](https://tech.trivago.com/)
- [Rokt](https://www.rokt.com/)
- [Backlight](https://backlight.dev/)
- [Apparently.cz](https://apparently.cz)
- [Replicant.band](https://replicant.band/)
- [animerdesateliers.com](https://animerdesateliers.com/)
- [reindeere.ca](https://reindeere.ca/)
- [Opensauced](https://hot.opensauced.pizza/)
- [T3 Tools](https://t3.gg/)
- [Easybank Landing Page](https://markteekman.github.io/easybank-landing-page/)([source](https://github.com/markteekman/easybank-landing-page))
- [Humnutrition](https://www.humnutrition.com/)
- [leosvel.dev](https://leosvel.dev)
- [eriksolsen.com](https://eriksolsen.com/)
- [hexarolls.com](https://hexarolls.com/)
- [jadezak.com](https://jadezak.com/)
- [Overlayed](https://overlayed.dev)
- [okikio.dev](https://okikio.dev)
- [bowling-reference.com](https://bowling-reference.com)
- [component-party.dev](https://component-party.dev/)
- [linkhub.online](https://linkhub.online/) ([Source](https://twitter.com/lnkhub/status/1545522582211936256))
- [firefla.me](https://www.firefla.me/)
- [jmae.xyz](https://jmae.xyz/work/)
- [meteor10](https://meteor10.sachagreif.com/)
- [Astro Hackathon Showcase](https://hackathon-1-0-projects.vercel.app/)
- [andri.dk/](https://andri.dk/)
- [alchemycodelab.com](https://www.alchemycodelab.com/)
- [petar.radojevic.rs](https://petar.radojevic.rs/en)
- [coolify.io](https://coolify.io/)
- [zapp.run](https://zapp.run/)
- [openspartan.com/](https://www.openspartan.com)
- [aidankinzett.com](https://aidankinzett.com) ([Source](https://github.com/aidankinzett/astro-blog))
- [ukuvota.world](https://ukuvota.world) ([Source](https://github.com/waotzi/ukuvota))
- [Oengi.com](https://oengi.com/)
- [running.supply](https://running.supply/)
