// libmp3lame.js - port of libmp3lame to JavaScript using emscripten
// by Andreas Krennmair <ak@synflood.at>

var Lame = (function() {

// Note: Some Emscripten settings will significantly limit the speed of the generated code.
// Note: Some Emscripten settings may limit the speed of the generated code.
try {
  this['Module'] = Module;
} catch(e) {
  this['Module'] = Module = {};
}

// The environment setup code below is customized to use Module.
// *** Environment setup code ***
var ENVIRONMENT_IS_NODE = typeof process === 'object' && typeof require === 'function';
var ENVIRONMENT_IS_WEB = typeof window === 'object';
var ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
var ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;

if (ENVIRONMENT_IS_NODE) {
  // Expose functionality in the same simple way that the shells work
  // Note that we pollute the global namespace here, otherwise we break in node
  Module['print'] = function(x) {
    process['stdout'].write(x + '\n');
  };
  Module['printErr'] = function(x) {
    process['stderr'].write(x + '\n');
  };

  var nodeFS = require('fs');
  var nodePath = require('path');

  Module['read'] = function(filename) {
    filename = nodePath['normalize'](filename);
    var ret = nodeFS['readFileSync'](filename).toString();
    // The path is absolute if the normalized version is the same as the resolved.
    if (!ret && filename != nodePath['resolve'](filename)) {
      filename = path.join(__dirname, '..', 'src', filename);
      ret = nodeFS['readFileSync'](filename).toString();
    }
    return ret;
  };

  Module['load'] = function(f) {
    globalEval(read(f));
  };

  if (!Module['arguments']) {
    Module['arguments'] = process['argv'].slice(2);
  }
}

if (ENVIRONMENT_IS_SHELL) {
  Module['print'] = print;
  if (typeof printErr != 'undefined') Module['printErr'] = printErr; // not present in v8 or older sm

  // Polyfill over SpiderMonkey/V8 differences
  if (typeof read != 'undefined') {
    Module['read'] = read;
  } else {
    Module['read'] = function(f) { snarf(f) };
  }

  if (!Module['arguments']) {
    if (typeof scriptArgs != 'undefined') {
      Module['arguments'] = scriptArgs;
    } else if (typeof arguments != 'undefined') {
      Module['arguments'] = arguments;
    }
  }
}

if (ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_WORKER) {
  if (!Module['print']) {
    Module['print'] = function(x) {
      console.log(x);
    };
  }

  if (!Module['printErr']) {
    Module['printErr'] = function(x) {
      console.log(x);
    };
  }
}

if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
  Module['read'] = function(url) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url, false);
    xhr.send(null);
    return xhr.responseText;
  };

  if (!Module['arguments']) {
    if (typeof arguments != 'undefined') {
      Module['arguments'] = arguments;
    }
  }
}

if (ENVIRONMENT_IS_WORKER) {
  // We can do very little here...
  var TRY_USE_DUMP = false;
  if (!Module['print']) {
    Module['print'] = (TRY_USE_DUMP && (typeof(dump) !== "undefined") ? (function(x) {
      dump(x);
    }) : (function(x) {
      // self.postMessage(x); // enable this if you want stdout to be sent as messages
    }));
  }

  Module['load'] = importScripts;
}

if (!ENVIRONMENT_IS_WORKER && !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_SHELL) {
  // Unreachable because SHELL is dependant on the others
  throw 'Unknown runtime environment. Where are we?';
}

function globalEval(x) {
  eval.call(null, x);
}
if (!Module['load'] == 'undefined' && Module['read']) {
  Module['load'] = function(f) {
    globalEval(Module['read'](f));
  };
}
if (!Module['print']) {
  Module['print'] = function(){};
}
if (!Module['printErr']) {
  Module['printErr'] = Module['print'];
}
if (!Module['arguments']) {
  Module['arguments'] = [];
}
// *** Environment setup code ***

// Closure helpers
Module.print = Module['print'];
Module.printErr = Module['printErr'];

// Callbacks
if (!Module['preRun']) Module['preRun'] = [];
if (!Module['postRun']) Module['postRun'] = [];

  
// === Auto-generated preamble library stuff ===

//========================================
// Runtime code shared with compiler
//========================================

var Runtime = {
  stackSave: function () {
    return STACKTOP;
  },
  stackRestore: function (stackTop) {
    STACKTOP = stackTop;
  },
  forceAlign: function (target, quantum) {
    quantum = quantum || 4;
    if (quantum == 1) return target;
    if (isNumber(target) && isNumber(quantum)) {
      return Math.ceil(target/quantum)*quantum;
    } else if (isNumber(quantum) && isPowerOfTwo(quantum)) {
      var logg = log2(quantum);
      return '((((' +target + ')+' + (quantum-1) + ')>>' + logg + ')<<' + logg + ')';
    }
    return 'Math.ceil((' + target + ')/' + quantum + ')*' + quantum;
  },
  isNumberType: function (type) {
    return type in Runtime.INT_TYPES || type in Runtime.FLOAT_TYPES;
  },
  isPointerType: function isPointerType(type) {
  return type[type.length-1] == '*';
},
  isStructType: function isStructType(type) {
  if (isPointerType(type)) return false;
  if (/^\[\d+\ x\ (.*)\]/.test(type)) return true; // [15 x ?] blocks. Like structs
  if (/<?{ ?[^}]* ?}>?/.test(type)) return true; // { i32, i8 } etc. - anonymous struct types
  // See comment in isStructPointerType()
  return type[0] == '%';
},
  INT_TYPES: {"i1":0,"i8":0,"i16":0,"i32":0,"i64":0},
  FLOAT_TYPES: {"float":0,"double":0},
  BITSHIFT64_SHL: 0,
  BITSHIFT64_ASHR: 1,
  BITSHIFT64_LSHR: 2,
  bitshift64: function (low, high, op, bits) {
    var ret;
    var ander = Math.pow(2, bits)-1;
    if (bits < 32) {
      switch (op) {
        case Runtime.BITSHIFT64_SHL:
          ret = [low << bits, (high << bits) | ((low&(ander << (32 - bits))) >>> (32 - bits))];
          break;
        case Runtime.BITSHIFT64_ASHR:
          ret = [(((low >>> bits ) | ((high&ander) << (32 - bits))) >> 0) >>> 0, (high >> bits) >>> 0];
          break;
        case Runtime.BITSHIFT64_LSHR:
          ret = [((low >>> bits) | ((high&ander) << (32 - bits))) >>> 0, high >>> bits];
          break;
      }
    } else if (bits == 32) {
      switch (op) {
        case Runtime.BITSHIFT64_SHL:
          ret = [0, low];
          break;
        case Runtime.BITSHIFT64_ASHR:
          ret = [high, (high|0) < 0 ? ander : 0];
          break;
        case Runtime.BITSHIFT64_LSHR:
          ret = [high, 0];
          break;
      }
    } else { // bits > 32
      switch (op) {
        case Runtime.BITSHIFT64_SHL:
          ret = [0, low << (bits - 32)];
          break;
        case Runtime.BITSHIFT64_ASHR:
          ret = [(high >> (bits - 32)) >>> 0, (high|0) < 0 ? ander : 0];
          break;
        case Runtime.BITSHIFT64_LSHR:
          ret = [high >>>  (bits - 32) , 0];
          break;
      }
    }
    HEAP32[tempDoublePtr>>2] = ret[0]; // cannot use utility functions since we are in runtime itself
    HEAP32[tempDoublePtr+4>>2] = ret[1];
  },
  or64: function (x, y) {
    var l = (x | 0) | (y | 0);
    var h = (Math.round(x / 4294967296) | Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  and64: function (x, y) {
    var l = (x | 0) & (y | 0);
    var h = (Math.round(x / 4294967296) & Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  xor64: function (x, y) {
    var l = (x | 0) ^ (y | 0);
    var h = (Math.round(x / 4294967296) ^ Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  getNativeTypeSize: function (type, quantumSize) {
    if (Runtime.QUANTUM_SIZE == 1) return 1;
    var size = {
      '%i1': 1,
      '%i8': 1,
      '%i16': 2,
      '%i32': 4,
      '%i64': 8,
      "%float": 4,
      "%double": 8
    }['%'+type]; // add '%' since float and double confuse Closure compiler as keys, and also spidermonkey as a compiler will remove 's from '_i8' etc
    if (!size) {
      if (type.charAt(type.length-1) == '*') {
        size = Runtime.QUANTUM_SIZE; // A pointer
      } else if (type[0] == 'i') {
        var bits = parseInt(type.substr(1));
        assert(bits % 8 == 0);
        size = bits/8;
      }
    }
    return size;
  },
  getNativeFieldSize: function (type) {
    return Math.max(Runtime.getNativeTypeSize(type), Runtime.QUANTUM_SIZE);
  },
  dedup: function dedup(items, ident) {
  var seen = {};
  if (ident) {
    return items.filter(function(item) {
      if (seen[item[ident]]) return false;
      seen[item[ident]] = true;
      return true;
    });
  } else {
    return items.filter(function(item) {
      if (seen[item]) return false;
      seen[item] = true;
      return true;
    });
  }
},
  set: function set() {
  var args = typeof arguments[0] === 'object' ? arguments[0] : arguments;
  var ret = {};
  for (var i = 0; i < args.length; i++) {
    ret[args[i]] = 0;
  }
  return ret;
},
  calculateStructAlignment: function calculateStructAlignment(type) {
    type.flatSize = 0;
    type.alignSize = 0;
    var diffs = [];
    var prev = -1;
    type.flatIndexes = type.fields.map(function(field) {
      var size, alignSize;
      if (Runtime.isNumberType(field) || Runtime.isPointerType(field)) {
        size = Runtime.getNativeTypeSize(field); // pack char; char; in structs, also char[X]s.
        alignSize = size;
      } else if (Runtime.isStructType(field)) {
        size = Types.types[field].flatSize;
        alignSize = Types.types[field].alignSize;
      } else {
        throw 'Unclear type in struct: ' + field + ', in ' + type.name_ + ' :: ' + dump(Types.types[type.name_]);
      }
      alignSize = type.packed ? 1 : Math.min(alignSize, Runtime.QUANTUM_SIZE);
      type.alignSize = Math.max(type.alignSize, alignSize);
      var curr = Runtime.alignMemory(type.flatSize, alignSize); // if necessary, place this on aligned memory
      type.flatSize = curr + size;
      if (prev >= 0) {
        diffs.push(curr-prev);
      }
      prev = curr;
      return curr;
    });
    type.flatSize = Runtime.alignMemory(type.flatSize, type.alignSize);
    if (diffs.length == 0) {
      type.flatFactor = type.flatSize;
    } else if (Runtime.dedup(diffs).length == 1) {
      type.flatFactor = diffs[0];
    }
    type.needsFlattening = (type.flatFactor != 1);
    return type.flatIndexes;
  },
  generateStructInfo: function (struct, typeName, offset) {
    var type, alignment;
    if (typeName) {
      offset = offset || 0;
      type = (typeof Types === 'undefined' ? Runtime.typeInfo : Types.types)[typeName];
      if (!type) return null;
      if (type.fields.length != struct.length) {
        printErr('Number of named fields must match the type for ' + typeName + ': possibly duplicate struct names. Cannot return structInfo');
        return null;
      }
      alignment = type.flatIndexes;
    } else {
      var type = { fields: struct.map(function(item) { return item[0] }) };
      alignment = Runtime.calculateStructAlignment(type);
    }
    var ret = {
      __size__: type.flatSize
    };
    if (typeName) {
      struct.forEach(function(item, i) {
        if (typeof item === 'string') {
          ret[item] = alignment[i] + offset;
        } else {
          // embedded struct
          var key;
          for (var k in item) key = k;
          ret[key] = Runtime.generateStructInfo(item[key], type.fields[i], alignment[i]);
        }
      });
    } else {
      struct.forEach(function(item, i) {
        ret[item[1]] = alignment[i];
      });
    }
    return ret;
  },
  dynCall: function (sig, ptr, args) {
    if (args && args.length) {
      return FUNCTION_TABLE[ptr].apply(null, args);
    } else {
      return FUNCTION_TABLE[ptr]();
    }
  },
  addFunction: function (func, sig) {
    assert(sig);
    var table = FUNCTION_TABLE; // TODO: support asm
    var ret = table.length;
    table.push(func);
    table.push(0);
    return ret;
  },
  warnOnce: function (text) {
    if (!Runtime.warnOnce.shown) Runtime.warnOnce.shown = {};
    if (!Runtime.warnOnce.shown[text]) {
      Runtime.warnOnce.shown[text] = 1;
      Module.printErr(text);
    }
  },
  funcWrappers: {},
  getFuncWrapper: function (func, sig) {
    assert(sig);
    if (!Runtime.funcWrappers[func]) {
      Runtime.funcWrappers[func] = function() {
        Runtime.dynCall(sig, func, arguments);
      };
    }
    return Runtime.funcWrappers[func];
  },
  UTF8Processor: function () {
    var buffer = [];
    var needed = 0;
    this.processCChar = function (code) {
      code = code & 0xff;
      if (needed) {
        buffer.push(code);
        needed--;
      }
      if (buffer.length == 0) {
        if (code < 128) return String.fromCharCode(code);
        buffer.push(code);
        if (code > 191 && code < 224) {
          needed = 1;
        } else {
          needed = 2;
        }
        return '';
      }
      if (needed > 0) return '';
      var c1 = buffer[0];
      var c2 = buffer[1];
      var c3 = buffer[2];
      var ret;
      if (c1 > 191 && c1 < 224) {
        ret = String.fromCharCode(((c1 & 31) << 6) | (c2 & 63));
      } else {
        ret = String.fromCharCode(((c1 & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
      }
      buffer.length = 0;
      return ret;
    }
    this.processJSString = function(string) {
      string = unescape(encodeURIComponent(string));
      var ret = [];
      for (var i = 0; i < string.length; i++) {
        ret.push(string.charCodeAt(i));
      }
      return ret;
    }
  },
  stackAlloc: function stackAlloc(size) { var ret = STACKTOP;STACKTOP = (STACKTOP + size)|0;STACKTOP = ((((STACKTOP)+3)>>2)<<2); return ret; },
  staticAlloc: function staticAlloc(size) { var ret = STATICTOP;STATICTOP = (STATICTOP + size)|0;STATICTOP = ((((STATICTOP)+3)>>2)<<2); if (STATICTOP >= TOTAL_MEMORY) enlargeMemory();; return ret; },
  alignMemory: function alignMemory(size,quantum) { var ret = size = Math.ceil((size)/(quantum ? quantum : 4))*(quantum ? quantum : 4); return ret; },
  makeBigInt: function makeBigInt(low,high,unsigned) { var ret = (unsigned ? (((low)>>>0)+(((high)>>>0)*4294967296)) : (((low)>>>0)+(((high)|0)*4294967296))); return ret; },
  QUANTUM_SIZE: 4,
  __dummy__: 0
}




var CorrectionsMonitor = {
  MAX_ALLOWED: 0, // XXX
  corrections: 0,
  sigs: {},

  note: function(type, succeed, sig) {
    if (!succeed) {
      this.corrections++;
      if (this.corrections >= this.MAX_ALLOWED) abort('\n\nToo many corrections!');
    }
  },

  print: function() {
  }
};





//========================================
// Runtime essentials
//========================================

var __THREW__ = 0; // Used in checking for thrown exceptions.
var setjmpId = 1; // Used in setjmp/longjmp
var setjmpLabels = {};

var ABORT = false;

var undef = 0;
// tempInt is used for 32-bit signed values or smaller. tempBigInt is used
// for 32-bit unsigned values or more than 32 bits. TODO: audit all uses of tempInt
var tempValue, tempInt, tempBigInt, tempInt2, tempBigInt2, tempPair, tempBigIntI, tempBigIntR, tempBigIntS, tempBigIntP, tempBigIntD;
var tempI64, tempI64b;
var tempRet0, tempRet1, tempRet2, tempRet3, tempRet4, tempRet5, tempRet6, tempRet7, tempRet8, tempRet9;

function abort(text) {
  Module.print(text + ':\n' + (new Error).stack);
  ABORT = true;
  throw "Assertion: " + text;
}

function assert(condition, text) {
  if (!condition) {
    abort('Assertion failed: ' + text);
  }
}

var globalScope = this;

// C calling interface. A convenient way to call C functions (in C files, or
// defined with extern "C").
//
// Note: LLVM optimizations can inline and remove functions, after which you will not be
//       able to call them. Closure can also do so. To avoid that, add your function to
//       the exports using something like
//
//         -s EXPORTED_FUNCTIONS='["_main", "_myfunc"]'
//
// @param ident      The name of the C function (note that C++ functions will be name-mangled - use extern "C")
// @param returnType The return type of the function, one of the JS types 'number', 'string' or 'array' (use 'number' for any C pointer, and
//                   'array' for JavaScript arrays and typed arrays).
// @param argTypes   An array of the types of arguments for the function (if there are no arguments, this can be ommitted). Types are as in returnType,
//                   except that 'array' is not possible (there is no way for us to know the length of the array)
// @param args       An array of the arguments to the function, as native JS values (as in returnType)
//                   Note that string arguments will be stored on the stack (the JS string will become a C string on the stack).
// @return           The return value, as a native JS value (as in returnType)
function ccall(ident, returnType, argTypes, args) {
  return ccallFunc(getCFunc(ident), returnType, argTypes, args);
}
Module["ccall"] = ccall;

// Returns the C function with a specified identifier (for C++, you need to do manual name mangling)
function getCFunc(ident) {
  try {
    var func = eval('_' + ident);
  } catch(e) {
    try {
      func = globalScope['Module']['_' + ident]; // closure exported function
    } catch(e) {}
  }
  assert(func, 'Cannot call unknown function ' + ident + ' (perhaps LLVM optimizations or closure removed it?)');
  return func;
}

// Internal function that does a C call using a function, not an identifier
function ccallFunc(func, returnType, argTypes, args) {
  var stack = 0;
  function toC(value, type) {
    if (type == 'string') {
      if (value === null || value === undefined || value === 0) return 0; // null string
      if (!stack) stack = Runtime.stackSave();
      var ret = Runtime.stackAlloc(value.length+1);
      writeStringToMemory(value, ret);
      return ret;
    } else if (type == 'array') {
      if (!stack) stack = Runtime.stackSave();
      var ret = Runtime.stackAlloc(value.length);
      writeArrayToMemory(value, ret);
      return ret;
    }
    return value;
  }
  function fromC(value, type) {
    if (type == 'string') {
      return Pointer_stringify(value);
    }
    assert(type != 'array');
    return value;
  }
  var i = 0;
  var cArgs = args ? args.map(function(arg) {
    return toC(arg, argTypes[i++]);
  }) : [];
  var ret = fromC(func.apply(null, cArgs), returnType);
  if (stack) Runtime.stackRestore(stack);
  return ret;
}

// Returns a native JS wrapper for a C function. This is similar to ccall, but
// returns a function you can call repeatedly in a normal way. For example:
//
//   var my_function = cwrap('my_c_function', 'number', ['number', 'number']);
//   alert(my_function(5, 22));
//   alert(my_function(99, 12));
//
function cwrap(ident, returnType, argTypes) {
  var func = getCFunc(ident);
  return function() {
    return ccallFunc(func, returnType, argTypes, Array.prototype.slice.call(arguments));
  }
}
Module["cwrap"] = cwrap;

// Sets a value in memory in a dynamic way at run-time. Uses the
// type data. This is the same as makeSetValue, except that
// makeSetValue is done at compile-time and generates the needed
// code then, whereas this function picks the right code at
// run-time.
// Note that setValue and getValue only do *aligned* writes and reads!
// Note that ccall uses JS types as for defining types, while setValue and
// getValue need LLVM types ('i8', 'i32') - this is a lower-level operation
function setValue(ptr, value, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': HEAP8[(ptr)]=value; break;
      case 'i8': HEAP8[(ptr)]=value; break;
      case 'i16': HEAP16[((ptr)>>1)]=value; break;
      case 'i32': HEAP32[((ptr)>>2)]=value; break;
      case 'i64': (tempI64 = [value>>>0,Math.min(Math.floor((value)/4294967296), 4294967295)>>>0],HEAP32[((ptr)>>2)]=tempI64[0],HEAP32[(((ptr)+(4))>>2)]=tempI64[1]); break;
      case 'float': HEAPF32[((ptr)>>2)]=value; break;
      case 'double': (HEAPF64[(tempDoublePtr)>>3]=value,HEAP32[((ptr)>>2)]=HEAP32[((tempDoublePtr)>>2)],HEAP32[(((ptr)+(4))>>2)]=HEAP32[(((tempDoublePtr)+(4))>>2)]); break;
      default: abort('invalid type for setValue: ' + type);
    }
}
Module['setValue'] = setValue;

// Parallel to setValue.
function getValue(ptr, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': return HEAP8[(ptr)];
      case 'i8': return HEAP8[(ptr)];
      case 'i16': return HEAP16[((ptr)>>1)];
      case 'i32': return HEAP32[((ptr)>>2)];
      case 'i64': return HEAP32[((ptr)>>2)];
      case 'float': return HEAPF32[((ptr)>>2)];
      case 'double': return (HEAP32[((tempDoublePtr)>>2)]=HEAP32[((ptr)>>2)],HEAP32[(((tempDoublePtr)+(4))>>2)]=HEAP32[(((ptr)+(4))>>2)],HEAPF64[(tempDoublePtr)>>3]);
      default: abort('invalid type for setValue: ' + type);
    }
  return null;
}
Module['getValue'] = getValue;

var ALLOC_NORMAL = 0; // Tries to use _malloc()
var ALLOC_STACK = 1; // Lives for the duration of the current function call
var ALLOC_STATIC = 2; // Cannot be freed
var ALLOC_NONE = 3; // Do not allocate
Module['ALLOC_NORMAL'] = ALLOC_NORMAL;
Module['ALLOC_STACK'] = ALLOC_STACK;
Module['ALLOC_STATIC'] = ALLOC_STATIC;
Module['ALLOC_NONE'] = ALLOC_NONE;

// Simple unoptimized memset - necessary during startup
var _memset = function(ptr, value, num) {
  var stop = ptr + num;
  while (ptr < stop) {
    HEAP8[(ptr++)]=value;
  }
}

// allocate(): This is for internal use. You can use it yourself as well, but the interface
//             is a little tricky (see docs right below). The reason is that it is optimized
//             for multiple syntaxes to save space in generated code. So you should
//             normally not use allocate(), and instead allocate memory using _malloc(),
//             initialize it with setValue(), and so forth.
// @slab: An array of data, or a number. If a number, then the size of the block to allocate,
//        in *bytes* (note that this is sometimes confusing: the next parameter does not
//        affect this!)
// @types: Either an array of types, one for each byte (or 0 if no type at that position),
//         or a single type which is used for the entire block. This only matters if there
//         is initial data - if @slab is a number, then this does not matter at all and is
//         ignored.
// @allocator: How to allocate memory, see ALLOC_*
function allocate(slab, types, allocator, ptr) {
  var zeroinit, size;
  if (typeof slab === 'number') {
    zeroinit = true;
    size = slab;
  } else {
    zeroinit = false;
    size = slab.length;
  }

  var singleType = typeof types === 'string' ? types : null;

  var ret;
  if (allocator == ALLOC_NONE) {
    ret = ptr;
  } else {
    ret = [_malloc, Runtime.stackAlloc, Runtime.staticAlloc][allocator === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length));
  }

  if (zeroinit) {
    _memset(ret, 0, size);
    return ret;
  }

  if (singleType === 'i8') {
    HEAPU8.set(new Uint8Array(slab), ret);
    return ret;
  }

  var i = 0, type;
  while (i < size) {
    var curr = slab[i];

    if (typeof curr === 'function') {
      curr = Runtime.getFunctionIndex(curr);
    }

    type = singleType || types[i];
    if (type === 0) {
      i++;
      continue;
    }

    if (type == 'i64') type = 'i32'; // special case: we have one i32 here, and one i32 later

    setValue(ret+i, curr, type);
    i += Runtime.getNativeTypeSize(type);
  }

  return ret;
}
Module['allocate'] = allocate;

function Pointer_stringify(ptr, /* optional */ length) {
  var utf8 = new Runtime.UTF8Processor();
  var nullTerminated = typeof(length) == "undefined";
  var ret = "";
  var i = 0;
  var t;
  while (1) {
    t = HEAPU8[((ptr)+(i))];
    if (nullTerminated && t == 0) break;
    ret += utf8.processCChar(t);
    i += 1;
    if (!nullTerminated && i == length) break;
  }
  return ret;
}
Module['Pointer_stringify'] = Pointer_stringify;

function Array_stringify(array) {
  var ret = "";
  for (var i = 0; i < array.length; i++) {
    ret += String.fromCharCode(array[i]);
  }
  return ret;
}
Module['Array_stringify'] = Array_stringify;

// Memory management

var PAGE_SIZE = 4096;
function alignMemoryPage(x) {
  return ((x+4095)>>12)<<12;
}

var HEAP;
var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;

var STACK_ROOT, STACKTOP, STACK_MAX;
var STATICTOP;
function enlargeMemory() {
  abort('Cannot enlarge memory arrays. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value, (2) compile with ALLOW_MEMORY_GROWTH which adjusts the size at runtime but prevents some optimizations, or (3) set Module.TOTAL_MEMORY before the program runs.');
}

var TOTAL_STACK = Module['TOTAL_STACK'] || 5242880;
var TOTAL_MEMORY = Module['TOTAL_MEMORY'] || 16777216;
var FAST_MEMORY = Module['FAST_MEMORY'] || 2097152;

// Initialize the runtime's memory
// check for full engine support (use string 'subarray' to avoid closure compiler confusion)
  assert(!!Int32Array && !!Float64Array && !!(new Int32Array(1)['subarray']) && !!(new Int32Array(1)['set']),
         'Cannot fallback to non-typed array case: Code is too specialized');

  var buffer = new ArrayBuffer(TOTAL_MEMORY);
  HEAP8 = new Int8Array(buffer);
  HEAP16 = new Int16Array(buffer);
  HEAP32 = new Int32Array(buffer);
  HEAPU8 = new Uint8Array(buffer);
  HEAPU16 = new Uint16Array(buffer);
  HEAPU32 = new Uint32Array(buffer);
  HEAPF32 = new Float32Array(buffer);
  HEAPF64 = new Float64Array(buffer);

  // Endianness check (note: assumes compiler arch was little-endian)
  HEAP32[0] = 255;
  assert(HEAPU8[0] === 255 && HEAPU8[3] === 0, 'Typed arrays 2 must be run on a little-endian system');

Module['HEAP'] = HEAP;
Module['HEAP8'] = HEAP8;
Module['HEAP16'] = HEAP16;
Module['HEAP32'] = HEAP32;
Module['HEAPU8'] = HEAPU8;
Module['HEAPU16'] = HEAPU16;
Module['HEAPU32'] = HEAPU32;
Module['HEAPF32'] = HEAPF32;
Module['HEAPF64'] = HEAPF64;

STACK_ROOT = STACKTOP = Runtime.alignMemory(1);
STACK_MAX = TOTAL_STACK; // we lose a little stack here, but TOTAL_STACK is nice and round so use that as the max

var tempDoublePtr = Runtime.alignMemory(allocate(12, 'i8', ALLOC_STACK), 8);
assert(tempDoublePtr % 8 == 0);
function copyTempFloat(ptr) { // functions, because inlining this code is increases code size too much
  HEAP8[tempDoublePtr] = HEAP8[ptr];
  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];
  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];
  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];
}
function copyTempDouble(ptr) {
  HEAP8[tempDoublePtr] = HEAP8[ptr];
  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];
  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];
  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];
  HEAP8[tempDoublePtr+4] = HEAP8[ptr+4];
  HEAP8[tempDoublePtr+5] = HEAP8[ptr+5];
  HEAP8[tempDoublePtr+6] = HEAP8[ptr+6];
  HEAP8[tempDoublePtr+7] = HEAP8[ptr+7];
}

STATICTOP = STACK_MAX;
assert(STATICTOP < TOTAL_MEMORY); // Stack must fit in TOTAL_MEMORY; allocations from here on may enlarge TOTAL_MEMORY

var nullString = allocate(intArrayFromString('(null)'), 'i8', ALLOC_STACK);

function callRuntimeCallbacks(callbacks) {
  while(callbacks.length > 0) {
    var callback = callbacks.shift();
    var func = callback.func;
    if (typeof func === 'number') {
      if (callback.arg === undefined) {
        Runtime.dynCall('v', func);
      } else {
        Runtime.dynCall('vi', func, [callback.arg]);
      }
    } else {
      func(callback.arg === undefined ? null : callback.arg);
    }
  }
}

var __ATINIT__ = []; // functions called during startup
var __ATMAIN__ = []; // functions called when main() is to be run
var __ATEXIT__ = []; // functions called during shutdown

function initRuntime() {
  callRuntimeCallbacks(__ATINIT__);
}
function preMain() {
  callRuntimeCallbacks(__ATMAIN__);
}
function exitRuntime() {
  callRuntimeCallbacks(__ATEXIT__);

  // Print summary of correction activity
  CorrectionsMonitor.print();
}

// Tools

// This processes a JS string into a C-line array of numbers, 0-terminated.
// For LLVM-originating strings, see parser.js:parseLLVMString function
function intArrayFromString(stringy, dontAddNull, length /* optional */) {
  var ret = (new Runtime.UTF8Processor()).processJSString(stringy);
  if (length) {
    ret.length = length;
  }
  if (!dontAddNull) {
    ret.push(0);
  }
  return ret;
}
Module['intArrayFromString'] = intArrayFromString;

function intArrayToString(array) {
  var ret = [];
  for (var i = 0; i < array.length; i++) {
    var chr = array[i];
    if (chr > 0xFF) {
      chr &= 0xFF;
    }
    ret.push(String.fromCharCode(chr));
  }
  return ret.join('');
}
Module['intArrayToString'] = intArrayToString;

// Write a Javascript array to somewhere in the heap
function writeStringToMemory(string, buffer, dontAddNull) {
  var array = intArrayFromString(string, dontAddNull);
  var i = 0;
  while (i < array.length) {
    var chr = array[i];
    HEAP8[((buffer)+(i))]=chr
    i = i + 1;
  }
}
Module['writeStringToMemory'] = writeStringToMemory;

function writeArrayToMemory(array, buffer) {
  for (var i = 0; i < array.length; i++) {
    HEAP8[((buffer)+(i))]=array[i];
  }
}
Module['writeArrayToMemory'] = writeArrayToMemory;

function unSign(value, bits, ignore, sig) {
  if (value >= 0) {
    return value;
  }
  return bits <= 32 ? 2*Math.abs(1 << (bits-1)) + value // Need some trickery, since if bits == 32, we are right at the limit of the bits JS uses in bitshifts
                    : Math.pow(2, bits)         + value;
  // TODO: clean up previous line
}
function reSign(value, bits, ignore, sig) {
  if (value <= 0) {
    return value;
  }
  var half = bits <= 32 ? Math.abs(1 << (bits-1)) // abs is needed if bits == 32
                        : Math.pow(2, bits-1);
  if (value >= half && (bits <= 32 || value > half)) { // for huge values, we can hit the precision limit and always get true here. so don't do that
                                                       // but, in general there is no perfect solution here. With 64-bit ints, we get rounding and errors
                                                       // TODO: In i64 mode 1, resign the two parts separately and safely
    value = -2*half + value; // Cannot bitshift half, as it may be at the limit of the bits JS uses in bitshifts
  }
  return value;
}

// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// PRE_RUN_ADDITIONS (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies = 0;
var runDependencyTracking = {};
var calledRun = false;
var runDependencyWatcher = null;
function addRunDependency(id) {
  runDependencies++;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (id) {
    assert(!runDependencyTracking[id]);
    runDependencyTracking[id] = 1;
    if (runDependencyWatcher === null && typeof setInterval !== 'undefined') {
      // Check for missing dependencies every few seconds
      runDependencyWatcher = setInterval(function() {
        var shown = false;
        for (var dep in runDependencyTracking) {
          if (!shown) {
            shown = true;
            Module.printErr('still waiting on run dependencies:');
          }
          Module.printErr('dependency: ' + dep);
        }
        if (shown) {
          Module.printErr('(end of list)');
        }
      }, 6000);
    }
  } else {
    Module.printErr('warning: run dependency added without ID');
  }
}
Module['addRunDependency'] = addRunDependency;
function removeRunDependency(id) {
  runDependencies--;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (id) {
    assert(runDependencyTracking[id]);
    delete runDependencyTracking[id];
  } else {
    Module.printErr('warning: run dependency removed without ID');
  }
  if (runDependencies == 0) {
    if (runDependencyWatcher !== null) {
      clearInterval(runDependencyWatcher);
      runDependencyWatcher = null;
    } 
    // If run has never been called, and we should call run (INVOKE_RUN is true, and Module.noInitialRun is not false)
    if (!calledRun && shouldRunNow) run();
  }
}
Module['removeRunDependency'] = removeRunDependency;

Module["preloadedImages"] = {}; // maps url to image data
Module["preloadedAudios"] = {}; // maps url to audio data

// === Body ===



assert(STATICTOP == STACK_MAX); assert(STACK_MAX == TOTAL_STACK);

STATICTOP += 146184;

assert(STATICTOP < TOTAL_MEMORY);








var _tabsel_123;








































var _stderr;
















































var _freqs;

























































































































































































































































































var __ZTVSt9exception;


var __ZTVN10__cxxabiv120__si_class_type_infoE;


var __ZTISt9exception;









var __ZNSt9bad_allocC1Ev;
var __ZNSt9bad_allocD1Ev;
var __ZNSt20bad_array_new_lengthC1Ev;
var __ZNSt20bad_array_new_lengthD1Ev;
var __ZNSt20bad_array_new_lengthD2Ev;
allocate(512, "i8", ALLOC_NONE, 5242880);
allocate(4096, "i8", ALLOC_NONE, 5243392);
allocate([0,27,134,42,204,204,52,43,33,78,132,43,252,247,157,43,88,156,166,43,252,247,157,43,33,78,132,43,204,204,52,43,0,27,134,42,83,248,191,44,254,169,171,44,146,50,149,44,159,129,122,44,239,29,73,44,62,186,23,44,116,173,207,43,133,159,107,43,183,89,146,42,83,248,191,172,254,169,171,172,146,50,149,172,159,129,122,172,239,29,73,172,62,186,23,172,116,173,207,171,133,159,107,171,183,89,146,170,0,27,134,170,204,204,52,171,33,78,132,171,252,247,157,171,88,156,166,171,252,247,157,171,33,78,132,171,204,204,52,171,0,27,134,170,0,27,134,42,204,204,52,43,33,78,132,43,252,247,157,43,88,156,166,43,252,247,157,43,33,78,132,43,204,204,52,43,0,27,134,42,83,248,191,44,254,169,171,44,146,50,149,44,159,129,122,44,239,29,73,44,62,186,23,44,116,173,207,43,133,159,107,43,183,89,146,42,37,39,192,172,51,37,173,172,234,209,152,172,227,84,131,172,249,175,89,172,11,14,43,172,102,34,244,171,201,49,137,171,74,123,157,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,144,128,170,174,79,227,170,5,174,113,170,234,207,6,62,205,19,212,62,139,111,68,63,255,175,139,63,23,208,166,63,117,235,200,63,190,226,245,63,122,130,26,64,105,251,74,64,185,87,144,64,107,16,243,64,233,58,183,65,92,28,124,63,187,141,36,63,68,29,175,62,178,143,112,63,212,208,49,190,125,27,68,191,215,179,93,63,0,0,0,63,254,181,3,191,218,134,241,190,2,115,160,190,116,71,58,190,29,176,193,189,135,203,39,189,29,161,104,188,70,123,114,187,168,132,91,63,216,185,97,63,221,26,115,63,129,186,123,63,65,218,126,63,253,200,127,63,101,249,127,63,141,255,127,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,144,128,42,174,79,227,42,5,174,113,42,37,39,192,44,51,37,173,44,234,209,152,44,227,84,131,44,249,175,89,44,11,14,43,44,102,34,244,43,201,49,137,43,74,123,157,42,83,248,191,172,254,169,171,172,146,50,149,172,159,129,122,172,239,29,73,172,62,186,23,172,116,173,207,171,133,159,107,171,183,89,146,170,0,27,134,170,204,204,52,171,33,78,132,171,252,247,157,171,88,156,166,171,252,247,157,171,33,78,132,171,204,204,52,171,0,27,134,170], "i8", ALLOC_NONE, 5247488);
allocate([137,158,227,63,229,83,236,63,167,94,245,63,155,20,249,63,14,217,252,63,123,143,234,63,218,151,217,63,226,132,191,63,124,145,168,63,0,0,128,63], "i8", ALLOC_NONE, 5248064);
allocate([43,152,159,163,27,134,139,188,168,241,120,163,7,62,43,61,81,63,155,164,158,120,179,189,139,51,14,164,232,209,62,62,176,169,254,164,226,172,32,191], "i8", ALLOC_NONE, 5248104);
allocate([0,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,102,102,166,64,0,0,250,66,102,102,134,192,154,153,201,192,154,153,153,64,0,0,128,63,0,0,0,0,0,0,0,0,2,0,0,0,21,0,0,0,236,81,120,63,0,0,160,64,0,0,200,66,1,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,154,153,169,64,0,0,250,66,102,102,102,192,51,51,179,192,0,0,144,64,0,0,192,63,0,0,0,0,0,0,0,0,2,0,0,0,21,0,0,0,205,204,172,63,0,0,160,64,0,0,200,66,2,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,51,51,179,64,0,0,250,66,205,204,12,192,0,0,96,192,51,51,51,64,0,0,0,64,0,0,0,0,0,0,0,0,2,0,0,0,21,0,0,0,82,184,190,63,0,0,160,64,0,0,200,66,3,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,154,153,185,64,0,0,2,67,102,102,230,191,51,51,51,192,102,102,38,64,0,0,64,64,0,0,128,192,0,0,0,0,2,0,0,0,20,0,0,0,133,235,209,63,0,0,160,64,0,0,200,66,4,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,0,0,192,64,0,0,7,67,51,51,51,191,205,204,140,191,205,204,140,63,0,0,96,64,0,0,0,193,0,0,0,0,2,0,0,0,0,0,0,0,184,30,229,63,0,0,160,64,0,0,200,66,5,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,205,204,204,64,0,0,12,67,0,0,0,63,205,204,204,62,0,0,240,192,0,0,128,64,0,0,64,193,23,183,81,57,0,0,0,0,0,0,0,0,154,153,249,63,0,0,160,64,0,0,200,66,6,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,51,51,211,64,0,0,17,67,31,133,43,63,102,102,38,63,51,51,107,193,0,0,208,64,0,0,152,193,23,183,209,57,0,0,0,0,0,0,0,0,51,51,19,64,0,0,160,64,0,0,200,66,7,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,51,51,211,64,0,0,17,67,205,204,76,63,0,0,64,63,154,153,157,193,0,0,0,65,0,0,176,193,82,73,29,58,0,0,0,0,0,0,0,0,205,204,44,64,0,0,160,64,0,0,200,66,8,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,51,51,211,64,0,0,17,67,154,153,153,63,51,51,147,63,0,0,220,193,0,0,32,65,0,0,184,193,52,128,55,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,64,0,0,200,66,9,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,51,51,211,64,0,0,17,67,205,204,204,63,205,204,204,63,0,0,16,194,0,0,48,65,0,0,200,193,23,183,81,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,64,0,0,200,66,10,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,51,51,211,64,0,0,17,67,0,0,0,64,0,0,0,64,0,0,16,194,0,0,64,65,0,0,200,193,23,183,81,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,64,0,0,200,66], "i8", ALLOC_NONE, 5248144);
allocate([0,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,102,102,134,64,0,0,200,65,154,153,217,192,154,153,217,192,51,51,227,64,0,0,128,63,0,0,0,0,0,0,0,0,2,0,0,0,31,0,0,0,0,0,128,63,0,0,160,64,0,0,200,66,1,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,102,102,134,64,0,0,200,65,154,153,153,192,154,153,153,192,205,204,172,64,51,51,179,63,0,0,128,191,0,0,0,0,2,0,0,0,27,0,0,0,178,157,143,63,0,0,160,64,0,0,196,66,2,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,102,102,134,64,0,0,200,65,102,102,38,192,102,102,38,192,205,204,108,64,0,0,0,64,0,0,64,192,0,0,0,0,2,0,0,0,23,0,0,0,47,221,164,63,0,0,160,64,0,0,194,66,3,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,102,102,134,64,0,0,200,65,205,204,204,191,205,204,204,191,0,0,0,64,0,0,0,64,0,0,160,192,0,0,0,0,2,0,0,0,18,0,0,0,223,79,189,63,0,0,160,64,0,0,192,66,4,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,102,102,134,64,0,0,200,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,193,0,0,0,0,2,0,0,0,12,0,0,0,16,88,217,63,0,0,160,64,0,0,190,66,5,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,102,102,134,64,0,0,200,65,102,102,166,63,102,102,166,63,0,0,192,192,0,0,96,64,0,0,48,193,0,0,0,0,2,0,0,0,8,0,0,0,154,153,249,63,0,0,160,64,102,102,188,66,6,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,0,0,144,64,0,0,200,66,205,204,12,64,51,51,19,64,0,0,64,193,0,0,192,64,0,0,96,193,0,0,0,0,2,0,0,0,4,0,0,0,199,75,15,64,0,0,64,64,205,204,187,66,7,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,154,153,153,64,0,0,72,67,205,204,44,64,205,204,44,64,0,0,144,193,0,0,16,65,0,0,136,193,0,0,0,0,2,0,0,0,0,0,0,0,225,122,36,64,0,0,128,63,51,51,187,66,8,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,154,153,169,64,0,0,150,67,51,51,51,64,51,51,51,64,0,0,168,193,0,0,32,65,0,0,184,193,23,183,81,57,0,0,0,0,0,0,0,0,47,221,60,64,0,0,0,0,154,153,186,66,9,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,51,51,211,64,0,0,150,67,51,51,51,64,51,51,51,64,0,0,184,193,0,0,48,65,0,0,200,193,82,73,29,58,0,0,0,0,0,0,0,0,254,212,88,64,0,0,0,0,154,153,186,66,10,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,0,0,200,65,0,0,150,67,51,51,51,64,51,51,51,64,0,0,200,193,0,0,64,65,0,0,216,193,10,215,35,59,0,0,0,0,0,0,0,0,0,0,96,64,0,0,0,0,154,153,186,66], "i8", ALLOC_NONE, 5248892);
allocate([3,0,1,0,4,0,4,0,6,0,7,0,8,0,8,0,4,0,4,0,4,0,5,0,6,0,8,0,7,0,9,0,5,0,7,0,6,0,8,0,7,0,9,0,8,0,10,0,7,0,8,0,7,0,8,0,8,0,9,0,9,0,10,0], "i8", ALLOC_NONE, 5249640);
allocate([2,0,1,0,3,0,4,0,7,0,7,0,4,0,4,0,4,0,5,0,7,0,7,0,6,0,6,0,7,0,7,0,8,0,8,0], "i8", ALLOC_NONE, 5249704);
allocate([2,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255], "i8", ALLOC_NONE, 5249740);
allocate([0,0,128,63,54,89,75,63,152,134,33,63,152,134,33,63,152,134,33,63,152,134,33,63,152,134,33,63,250,155,128,62,153,158,240,61], "i8", ALLOC_NONE, 5249776);
allocate([3,4,6,7,9,10,4,5,6,7,8,10,5,6,7,8,9,10,7,7,8,9,9,10,8,8,9,9,10,11,9,9,10,10,11,11] /* \03\04\06\07\09\0A\0 */, "i8", ALLOC_NONE, 5249812);
allocate([7,0,5,0,9,0,14,0,15,0,7,0,6,0,4,0,5,0,5,0,6,0,7,0,7,0,6,0,8,0,8,0,8,0,5,0,15,0,6,0,9,0,10,0,5,0,1,0,11,0,7,0,9,0,6,0,4,0,1,0,14,0,4,0,6,0,2,0,6,0,0,0], "i8", ALLOC_NONE, 5249848);
allocate([2,4,7,9,9,10,4,4,6,10,10,10,7,6,8,10,10,11,9,10,10,11,11,12,9,9,10,11,12,12,10,10,11,11,13,13] /* \02\04\07\09\09\0A\0 */, "i8", ALLOC_NONE, 5249920);
allocate([3,0,4,0,6,0,18,0,12,0,5,0,5,0,1,0,2,0,16,0,9,0,3,0,7,0,3,0,5,0,14,0,7,0,3,0,19,0,17,0,15,0,13,0,10,0,4,0,13,0,5,0,8,0,11,0,5,0,1,0,12,0,4,0,4,0,1,0,1,0,0,0], "i8", ALLOC_NONE, 5249956);
allocate([1,4,7,9,9,10,4,6,8,9,9,10,7,7,9,10,10,11,8,9,10,11,11,11,8,9,10,11,11,12,9,10,11,12,12,12] /* \01\04\07\09\09\0A\0 */, "i8", ALLOC_NONE, 5250028);
allocate([1,0,2,0,10,0,19,0,16,0,10,0,3,0,3,0,7,0,10,0,5,0,3,0,11,0,4,0,13,0,17,0,8,0,4,0,12,0,11,0,18,0,15,0,11,0,2,0,7,0,6,0,9,0,14,0,3,0,1,0,6,0,4,0,5,0,3,0,2,0,0,0], "i8", ALLOC_NONE, 5250064);
allocate([3,4,6,8,4,4,6,7,5,6,7,8,7,7,8,9] /* \03\04\06\08\04\04\0 */, "i8", ALLOC_NONE, 5250136);
allocate([7,0,3,0,5,0,1,0,6,0,2,0,3,0,2,0,5,0,4,0,4,0,1,0,3,0,3,0,2,0,0,0], "i8", ALLOC_NONE, 5250152);
allocate([1,4,7,8,4,5,8,9,7,8,9,10,8,8,9,10] /* \01\04\07\08\04\05\0 */, "i8", ALLOC_NONE, 5250184);
allocate([1,0,2,0,6,0,5,0,3,0,1,0,4,0,4,0,7,0,5,0,7,0,1,0,6,0,1,0,1,0,0,0], "i8", ALLOC_NONE, 5250200);
allocate([2,3,7,4,4,7,6,7,8] /* \02\03\07\04\04\07\0 */, "i8", ALLOC_NONE, 5250232);
allocate([3,0,2,0,1,0,1,0,1,0,1,0,3,0,2,0,0,0], "i8", ALLOC_NONE, 5250244);
allocate([4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8] /* \04\05\05\06\05\06\0 */, "i8", ALLOC_NONE, 5250264);
allocate([15,0,28,0,26,0,48,0,22,0,40,0,36,0,64,0,14,0,24,0,20,0,32,0,12,0,16,0,8,0,0,0], "i8", ALLOC_NONE, 5250280);
allocate([1,5,5,7,5,8,7,9,5,7,7,9,7,9,9,10] /* \01\05\05\07\05\08\0 */, "i8", ALLOC_NONE, 5250312);
allocate([1,0,10,0,8,0,20,0,12,0,20,0,16,0,32,0,14,0,12,0,24,0,0,0,28,0,16,0,24,0,16,0], "i8", ALLOC_NONE, 5250328);
allocate([1,4,7,4,5,7,6,7,8] /* \01\04\07\04\05\07\0 */, "i8", ALLOC_NONE, 5250360);
allocate([1,0,2,0,1,0,3,0,1,0,1,0,3,0,2,0,0,0], "i8", ALLOC_NONE, 5250372);
allocate([4,5,7,8,9,10,10,11,11,12,12,12,12,12,13,10,5,6,7,8,9,10,10,11,11,11,12,12,12,12,12,10,7,7,8,9,9,10,10,11,11,11,11,12,12,12,13,9,8,8,9,9,10,10,10,11,11,11,11,12,12,12,12,9,9,9,9,10,10,10,10,11,11,11,12,12,12,12,13,9,10,9,10,10,10,10,11,11,11,11,12,12,12,12,12,9,10,10,10,10,10,11,11,11,11,12,12,12,12,12,13,9,11,10,10,10,11,11,11,11,12,12,12,12,12,13,13,10,11,11,11,11,11,11,11,11,11,12,12,12,12,13,13,10,11,11,11,11,11,11,11,12,12,12,12,12,13,13,13,10,12,11,11,11,11,12,12,12,12,12,12,13,13,13,13,10,12,12,11,11,11,12,12,12,12,12,12,13,13,13,13,10,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,10,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,10,13,12,12,12,12,12,12,13,13,13,13,13,13,13,13,10,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,6] /* \04\05\07\08\09\0A\0 */, "i8", ALLOC_NONE, 5250392);
allocate([15,0,13,0,46,0,80,0,146,0,6,1,248,0,178,1,170,1,157,2,141,2,137,2,109,2,5,2,8,4,88,0,14,0,12,0,21,0,38,0,71,0,130,0,122,0,216,0,209,0,198,0,71,1,89,1,63,1,41,1,23,1,42,0,47,0,22,0,41,0,74,0,68,0,128,0,120,0,221,0,207,0,194,0,182,0,84,1,59,1,39,1,29,2,18,0,81,0,39,0,75,0,70,0,134,0,125,0,116,0,220,0,204,0,190,0,178,0,69,1,55,1,37,1,15,1,16,0,147,0,72,0,69,0,135,0,127,0,118,0,112,0,210,0,200,0,188,0,96,1,67,1,50,1,29,1,28,2,14,0,7,1,66,0,129,0,126,0,119,0,114,0,214,0,202,0,192,0,180,0,85,1,61,1,45,1,25,1,6,1,12,0,249,0,123,0,121,0,117,0,113,0,215,0,206,0,195,0,185,0,91,1,74,1,52,1,35,1,16,1,8,2,10,0,179,1,115,0,111,0,109,0,211,0,203,0,196,0,187,0,97,1,76,1,57,1,42,1,27,1,19,2,125,1,17,0,171,1,212,0,208,0,205,0,201,0,193,0,186,0,177,0,169,0,64,1,47,1,30,1,12,1,2,2,121,1,16,0,79,1,199,0,197,0,191,0,189,0,181,0,174,0,77,1,65,1,49,1,33,1,19,1,9,2,123,1,115,1,11,0,156,2,184,0,183,0,179,0,175,0,88,1,75,1,58,1,48,1,34,1,21,1,18,2,127,1,117,1,110,1,10,0,140,2,90,1,171,0,168,0,164,0,62,1,53,1,43,1,31,1,20,1,7,1,1,2,119,1,112,1,106,1,6,0,136,2,66,1,60,1,56,1,51,1,46,1,36,1,28,1,13,1,5,1,0,2,120,1,114,1,108,1,103,1,4,0,108,2,44,1,40,1,38,1,32,1,26,1,17,1,10,1,3,2,124,1,118,1,113,1,109,1,105,1,101,1,2,0,9,4,24,1,22,1,18,1,11,1,8,1,3,1,126,1,122,1,116,1,111,1,107,1,104,1,102,1,100,1,0,0,43,0,20,0,19,0,17,0,15,0,13,0,11,0,9,0,7,0,6,0,4,0,7,0,5,0,3,0,1,0,3,0], "i8", ALLOC_NONE, 5250648);
allocate([1,4,3,5] /* \01\04\03\05 */, "i8", ALLOC_NONE, 5251160);
allocate([1,0,1,0,1,0,0,0], "i8", ALLOC_NONE, 5251164);
allocate([1,5,7,9,10,10,11,11,12,12,12,13,13,13,14,10,4,6,8,9,10,11,11,11,12,12,12,13,14,13,14,10,7,8,9,10,11,11,12,12,13,12,13,13,13,14,14,11,9,9,10,11,11,12,12,12,13,13,14,14,14,15,15,12,10,10,11,11,12,12,13,13,13,14,14,14,15,15,15,11,10,10,11,11,12,13,13,14,13,14,14,15,15,15,16,12,11,11,11,12,13,13,13,13,14,14,14,14,15,15,16,12,11,11,12,12,13,13,13,14,14,15,15,15,15,17,17,12,11,12,12,13,13,13,14,14,15,15,15,15,16,16,16,12,12,12,12,13,13,14,14,15,15,15,15,16,15,16,15,13,12,13,12,13,14,14,14,14,15,16,16,16,17,17,16,12,13,13,13,13,14,14,15,16,16,16,16,16,16,15,16,13,13,14,14,14,14,15,15,15,15,17,16,16,16,16,18,13,15,14,14,14,15,15,16,16,16,18,17,17,17,19,17,13,14,15,13,14,16,16,15,16,16,17,18,17,19,17,16,13,10,10,10,11,11,12,12,12,13,13,13,13,13,13,13,10] /* \01\05\07\09\0A\0A\0 */, "i8", ALLOC_NONE, 5251172);
allocate([1,5,7,9,10,10,11,11,12,12,12,13,13,13,14,11,4,6,8,9,10,11,11,11,12,12,12,13,14,13,14,11,7,8,9,10,11,11,12,12,13,12,13,13,13,14,14,12,9,9,10,11,11,12,12,12,13,13,14,14,14,15,15,13,10,10,11,11,12,12,13,13,13,14,14,14,15,15,15,12,10,10,11,11,12,13,13,14,13,14,14,15,15,15,16,13,11,11,11,12,13,13,13,13,14,14,14,14,15,15,16,13,11,11,12,12,13,13,13,14,14,15,15,15,15,17,17,13,11,12,12,13,13,13,14,14,15,15,15,15,16,16,16,13,12,12,12,13,13,14,14,15,15,15,15,16,15,16,15,14,12,13,12,13,14,14,14,14,15,16,16,16,17,17,16,13,13,13,13,13,14,14,15,16,16,16,16,16,16,15,16,14,13,14,14,14,14,15,15,15,15,17,16,16,16,16,18,14,15,14,14,14,15,15,16,16,16,18,17,17,17,19,17,14,14,15,13,14,16,16,15,16,16,17,18,17,19,17,16,14,11,11,11,12,12,13,13,13,14,14,14,14,14,14,14,12] /* \01\05\07\09\0A\0A\0 */, "i8", ALLOC_NONE, 5251428);
allocate([1,0,5,0,14,0,44,0,74,0,63,0,110,0,93,0,172,0,149,0,138,0,242,0,225,0,195,0,120,1,17,0,3,0,4,0,12,0,20,0,35,0,62,0,53,0,47,0,83,0,75,0,68,0,119,0,201,0,107,0,207,0,9,0,15,0,13,0,23,0,38,0,67,0,58,0,103,0,90,0,161,0,72,0,127,0,117,0,110,0,209,0,206,0,16,0,45,0,21,0,39,0,69,0,64,0,114,0,99,0,87,0,158,0,140,0,252,0,212,0,199,0,131,1,109,1,26,0,75,0,36,0,68,0,65,0,115,0,101,0,179,0,164,0,155,0,8,1,246,0,226,0,139,1,126,1,106,1,9,0,66,0,30,0,59,0,56,0,102,0,185,0,173,0,9,1,142,0,253,0,232,0,144,1,132,1,122,1,189,1,16,0,111,0,54,0,52,0,100,0,184,0,178,0,160,0,133,0,1,1,244,0,228,0,217,0,129,1,110,1,203,2,10,0,98,0,48,0,91,0,88,0,165,0,157,0,148,0,5,1,248,0,151,1,141,1,116,1,124,1,121,3,116,3,8,0,85,0,84,0,81,0,159,0,156,0,143,0,4,1,249,0,171,1,145,1,136,1,127,1,215,2,201,2,196,2,7,0,154,0,76,0,73,0,141,0,131,0,0,1,245,0,170,1,150,1,138,1,128,1,223,2,103,1,198,2,96,1,11,0,139,0,129,0,67,0,125,0,247,0,233,0,229,0,219,0,137,1,231,2,225,2,208,2,117,3,114,3,183,1,4,0,243,0,120,0,118,0,115,0,227,0,223,0,140,1,234,2,230,2,224,2,209,2,200,2,194,2,223,0,180,1,6,0,202,0,224,0,222,0,218,0,216,0,133,1,130,1,125,1,108,1,120,3,187,1,195,2,184,1,181,1,192,6,4,0,235,2,211,0,210,0,208,0,114,1,123,1,222,2,211,2,202,2,199,6,115,3,109,3,108,3,131,13,97,3,2,0,121,1,113,1,102,0,187,0,214,2,210,2,102,1,199,2,197,2,98,3,198,6,103,3,130,13,102,3,178,1,0,0,12,0,10,0,7,0,11,0,10,0,17,0,11,0,9,0,13,0,12,0,10,0,7,0,5,0,3,0,1,0,3,0], "i8", ALLOC_NONE, 5251684);
allocate([3,5,6,8,8,9,10,10,10,11,11,12,12,12,13,14,5,5,7,8,9,9,10,10,10,11,11,12,12,12,13,13,6,7,7,8,9,9,10,10,10,11,11,12,12,13,13,13,7,8,8,9,9,10,10,11,11,11,12,12,12,13,13,13,8,8,9,9,10,10,11,11,11,11,12,12,12,13,13,13,9,9,9,10,10,10,11,11,11,11,12,12,13,13,13,14,10,9,10,10,10,11,11,11,11,12,12,12,13,13,14,14,10,10,10,11,11,11,11,12,12,12,12,12,13,13,13,14,10,10,10,11,11,11,11,12,12,12,12,13,13,14,14,14,10,10,11,11,11,11,12,12,12,13,13,13,13,14,14,14,11,11,11,11,12,12,12,12,12,13,13,13,13,14,15,14,11,11,11,11,12,12,12,12,13,13,13,13,14,14,14,15,12,12,11,12,12,12,13,13,13,13,13,13,14,14,15,15,12,12,12,12,12,13,13,13,13,14,14,14,14,14,15,15,13,13,13,13,13,13,13,13,14,14,14,14,15,15,14,15,13,13,13,13,13,13,13,14,14,14,14,14,15,15,15,15] /* \03\05\06\08\08\09\0 */, "i8", ALLOC_NONE, 5252196);
allocate([7,0,12,0,18,0,53,0,47,0,76,0,124,0,108,0,89,0,123,0,108,0,119,0,107,0,81,0,122,0,63,0,13,0,5,0,16,0,27,0,46,0,36,0,61,0,51,0,42,0,70,0,52,0,83,0,65,0,41,0,59,0,36,0,19,0,17,0,15,0,24,0,41,0,34,0,59,0,48,0,40,0,64,0,50,0,78,0,62,0,80,0,56,0,33,0,29,0,28,0,25,0,43,0,39,0,63,0,55,0,93,0,76,0,59,0,93,0,72,0,54,0,75,0,50,0,29,0,52,0,22,0,42,0,40,0,67,0,57,0,95,0,79,0,72,0,57,0,89,0,69,0,49,0,66,0,46,0,27,0,77,0,37,0,35,0,66,0,58,0,52,0,91,0,74,0,62,0,48,0,79,0,63,0,90,0,62,0,40,0,38,0,125,0,32,0,60,0,56,0,50,0,92,0,78,0,65,0,55,0,87,0,71,0,51,0,73,0,51,0,70,0,30,0,109,0,53,0,49,0,94,0,88,0,75,0,66,0,122,0,91,0,73,0,56,0,42,0,64,0,44,0,21,0,25,0,90,0,43,0,41,0,77,0,73,0,63,0,56,0,92,0,77,0,66,0,47,0,67,0,48,0,53,0,36,0,20,0,71,0,34,0,67,0,60,0,58,0,49,0,88,0,76,0,67,0,106,0,71,0,54,0,38,0,39,0,23,0,15,0,109,0,53,0,51,0,47,0,90,0,82,0,58,0,57,0,48,0,72,0,57,0,41,0,23,0,27,0,62,0,9,0,86,0,42,0,40,0,37,0,70,0,64,0,52,0,43,0,70,0,55,0,42,0,25,0,29,0,18,0,11,0,11,0,118,0,68,0,30,0,55,0,50,0,46,0,74,0,65,0,49,0,39,0,24,0,16,0,22,0,13,0,14,0,7,0,91,0,44,0,39,0,38,0,34,0,63,0,52,0,45,0,31,0,52,0,28,0,19,0,14,0,8,0,9,0,3,0,123,0,60,0,58,0,53,0,47,0,43,0,32,0,22,0,37,0,24,0,17,0,12,0,15,0,10,0,2,0,1,0,71,0,37,0,34,0,30,0,28,0,20,0,17,0,26,0,21,0,16,0,10,0,6,0,8,0,6,0,2,0,0,0], "i8", ALLOC_NONE, 5252452);
allocate([1,5,7,8,9,10,10,11,10,11,12,12,13,13,14,14,4,6,8,9,10,10,11,11,11,11,12,12,13,14,14,14,7,8,9,10,11,11,12,12,11,12,12,13,13,14,15,15,8,9,10,11,11,12,12,12,12,13,13,13,13,14,15,15,9,9,11,11,12,12,13,13,12,13,13,14,14,15,15,16,10,10,11,12,12,12,13,13,13,13,14,13,15,15,16,16,10,11,12,12,13,13,13,13,13,14,14,14,15,15,16,16,11,11,12,13,13,13,14,14,14,14,15,15,15,16,18,18,10,10,11,12,12,13,13,14,14,14,14,15,15,16,17,17,11,11,12,12,13,13,13,15,14,15,15,16,16,16,18,17,11,12,12,13,13,14,14,15,14,15,16,15,16,17,18,19,12,12,12,13,14,14,14,14,15,15,15,16,17,17,17,18,12,13,13,14,14,15,14,15,16,16,17,17,17,18,18,18,13,13,14,15,15,15,16,16,16,16,16,17,18,17,18,18,14,14,14,15,15,15,17,16,16,19,17,17,17,19,18,18,13,14,15,16,16,16,17,16,17,17,18,18,21,20,21,18] /* \01\05\07\08\09\0A\0 */, "i8", ALLOC_NONE, 5252964);
allocate([1,0,5,0,14,0,21,0,34,0,51,0,46,0,71,0,42,0,52,0,68,0,52,0,67,0,44,0,43,0,19,0,3,0,4,0,12,0,19,0,31,0,26,0,44,0,33,0,31,0,24,0,32,0,24,0,31,0,35,0,22,0,14,0,15,0,13,0,23,0,36,0,59,0,49,0,77,0,65,0,29,0,40,0,30,0,40,0,27,0,33,0,42,0,16,0,22,0,20,0,37,0,61,0,56,0,79,0,73,0,64,0,43,0,76,0,56,0,37,0,26,0,31,0,25,0,14,0,35,0,16,0,60,0,57,0,97,0,75,0,114,0,91,0,54,0,73,0,55,0,41,0,48,0,53,0,23,0,24,0,58,0,27,0,50,0,96,0,76,0,70,0,93,0,84,0,77,0,58,0,79,0,29,0,74,0,49,0,41,0,17,0,47,0,45,0,78,0,74,0,115,0,94,0,90,0,79,0,69,0,83,0,71,0,50,0,59,0,38,0,36,0,15,0,72,0,34,0,56,0,95,0,92,0,85,0,91,0,90,0,86,0,73,0,77,0,65,0,51,0,44,0,43,0,42,0,43,0,20,0,30,0,44,0,55,0,78,0,72,0,87,0,78,0,61,0,46,0,54,0,37,0,30,0,20,0,16,0,53,0,25,0,41,0,37,0,44,0,59,0,54,0,81,0,66,0,76,0,57,0,54,0,37,0,18,0,39,0,11,0,35,0,33,0,31,0,57,0,42,0,82,0,72,0,80,0,47,0,58,0,55,0,21,0,22,0,26,0,38,0,22,0,53,0,25,0,23,0,38,0,70,0,60,0,51,0,36,0,55,0,26,0,34,0,23,0,27,0,14,0,9,0,7,0,34,0,32,0,28,0,39,0,49,0,75,0,30,0,52,0,48,0,40,0,52,0,28,0,18,0,17,0,9,0,5,0,45,0,21,0,34,0,64,0,56,0,50,0,49,0,45,0,31,0,19,0,12,0,15,0,10,0,7,0,6,0,3,0,48,0,23,0,20,0,39,0,36,0,35,0,53,0,21,0,16,0,23,0,13,0,10,0,6,0,1,0,4,0,2,0,16,0,15,0,17,0,27,0,25,0,20,0,29,0,11,0,17,0,12,0,16,0,8,0,1,0,1,0,0,0,1,0], "i8", ALLOC_NONE, 5253220);
allocate([4,4,6,8,9,10,10,10,4,5,6,7,9,9,10,10,6,6,7,8,9,10,9,10,7,7,8,8,9,10,10,10,8,8,9,9,10,10,10,11,9,9,10,10,10,11,10,11,9,9,9,10,10,11,11,12,10,10,10,11,11,11,11,12] /* \04\04\06\08\09\0A\0 */, "i8", ALLOC_NONE, 5253732);
allocate([9,0,6,0,16,0,33,0,41,0,39,0,38,0,26,0,7,0,5,0,6,0,9,0,23,0,16,0,26,0,11,0,17,0,7,0,11,0,14,0,21,0,30,0,10,0,7,0,17,0,10,0,15,0,12,0,18,0,28,0,14,0,5,0,32,0,13,0,22,0,19,0,18,0,16,0,9,0,5,0,40,0,17,0,31,0,29,0,17,0,13,0,4,0,2,0,27,0,12,0,11,0,15,0,10,0,7,0,4,0,1,0,27,0,12,0,8,0,12,0,6,0,3,0,1,0,0,0], "i8", ALLOC_NONE, 5253796);
allocate([2,4,6,8,9,10,9,10,4,5,6,8,10,10,9,10,6,7,8,9,10,11,10,10,8,8,9,11,10,12,10,11,9,10,10,11,11,12,11,12,9,10,11,12,12,13,12,13,9,9,9,10,11,12,12,12,9,9,10,11,12,12,12,12] /* \02\04\06\08\09\0A\0 */, "i8", ALLOC_NONE, 5253924);
allocate([3,0,4,0,10,0,24,0,34,0,33,0,21,0,15,0,5,0,3,0,4,0,10,0,32,0,17,0,11,0,10,0,11,0,7,0,13,0,18,0,30,0,31,0,20,0,5,0,25,0,11,0,19,0,59,0,27,0,18,0,12,0,5,0,35,0,33,0,31,0,58,0,30,0,16,0,7,0,5,0,28,0,26,0,32,0,19,0,17,0,15,0,8,0,14,0,14,0,12,0,9,0,13,0,14,0,9,0,4,0,1,0,11,0,4,0,6,0,6,0,6,0,3,0,2,0,0,0], "i8", ALLOC_NONE, 5253988);
allocate([1,4,7,9,10,10,10,11,4,6,8,9,10,11,10,10,7,8,9,10,11,12,11,11,8,9,10,11,12,12,11,12,9,10,11,12,12,12,12,12,10,11,12,12,13,13,12,13,9,10,11,12,12,12,13,13,10,10,11,12,12,13,13,13] /* \01\04\07\09\0A\0A\0 */, "i8", ALLOC_NONE, 5254116);
allocate([1,0,2,0,10,0,23,0,35,0,30,0,12,0,17,0,3,0,3,0,8,0,12,0,18,0,21,0,12,0,7,0,11,0,9,0,15,0,21,0,32,0,40,0,19,0,6,0,14,0,13,0,22,0,34,0,46,0,23,0,18,0,7,0,20,0,19,0,33,0,47,0,27,0,22,0,9,0,3,0,31,0,22,0,41,0,26,0,21,0,20,0,5,0,3,0,14,0,13,0,10,0,11,0,16,0,6,0,5,0,1,0,9,0,8,0,7,0,8,0,4,0,4,0,2,0,0,0], "i8", ALLOC_NONE, 5254180);
allocate([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,3,0,0,0,4,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,5,0,0,0,4,0,0,0,5,0,0,0,4,0,0,0,6,0,0,0,5,0,0,0,6,0,0,0,5,0,0,0,6,0,0,0,5,0,0,0,7,0,0,0,6,0,0,0,7,0,0,0,6,0,0,0,7,0,0,0], "i8", ALLOC_NONE, 5254308);
allocate([0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,3,0,0,0], "i8", ALLOC_NONE, 5254492);
allocate([1,0,0,0,2,0,0,0,4,0,0,0,8,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,8,0,0,0,2,0,0,0,4,0,0,0,8,0,0,0,2,0,0,0,4,0,0,0,8,0,0,0,4,0,0,0,8,0,0,0], "i8", ALLOC_NONE, 5254556);
allocate([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0], "i8", ALLOC_NONE, 5254620);
allocate([1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,8,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,16,0,0,0,16,0,0,0], "i8", ALLOC_NONE, 5254684);
allocate([0,0,0,0,6,0,0,0,12,0,0,0,18,0,0,0,24,0,0,0,30,0,0,0,36,0,0,0,44,0,0,0,54,0,0,0,66,0,0,0,80,0,0,0,96,0,0,0,116,0,0,0,140,0,0,0,168,0,0,0,200,0,0,0,238,0,0,0,28,1,0,0,80,1,0,0,140,1,0,0,208,1,0,0,10,2,0,0,64,2,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,18,0,0,0,24,0,0,0,32,0,0,0,42,0,0,0,56,0,0,0,74,0,0,0,100,0,0,0,132,0,0,0,174,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,12,0,0,0,18,0,0,0,24,0,0,0,30,0,0,0,36,0,0,0,44,0,0,0,54,0,0,0,66,0,0,0,80,0,0,0,96,0,0,0,114,0,0,0,136,0,0,0,162,0,0,0,194,0,0,0,232,0,0,0,22,1,0,0,76,1,0,0,138,1,0,0,208,1,0,0,28,2,0,0,64,2,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,18,0,0,0,26,0,0,0,36,0,0,0,48,0,0,0,62,0,0,0,80,0,0,0,104,0,0,0,136,0,0,0,180,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,12,0,0,0,18,0,0,0,24,0,0,0,30,0,0,0,36,0,0,0,44,0,0,0,54,0,0,0,66,0,0,0,80,0,0,0,96,0,0,0,116,0,0,0,140,0,0,0,168,0,0,0,200,0,0,0,238,0,0,0,28,1,0,0,80,1,0,0,140,1,0,0,208,1,0,0,10,2,0,0,64,2,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,18,0,0,0,26,0,0,0,36,0,0,0,48,0,0,0,62,0,0,0,80,0,0,0,104,0,0,0,134,0,0,0,174,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,16,0,0,0,20,0,0,0,24,0,0,0,30,0,0,0,36,0,0,0,44,0,0,0,52,0,0,0,62,0,0,0,74,0,0,0,90,0,0,0,110,0,0,0,134,0,0,0,162,0,0,0,196,0,0,0,238,0,0,0,32,1,0,0,86,1,0,0,162,1,0,0,64,2,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,16,0,0,0,22,0,0,0,30,0,0,0,40,0,0,0,52,0,0,0,66,0,0,0,84,0,0,0,106,0,0,0,136,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,16,0,0,0,20,0,0,0,24,0,0,0,30,0,0,0,36,0,0,0,42,0,0,0,50,0,0,0,60,0,0,0,72,0,0,0,88,0,0,0,106,0,0,0,128,0,0,0,156,0,0,0,190,0,0,0,230,0,0,0,20,1,0,0,74,1,0,0,128,1,0,0,64,2,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,16,0,0,0,22,0,0,0,28,0,0,0,38,0,0,0,50,0,0,0,64,0,0,0,80,0,0,0,100,0,0,0,126,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,16,0,0,0,20,0,0,0,24,0,0,0,30,0,0,0,36,0,0,0,44,0,0,0,54,0,0,0,66,0,0,0,82,0,0,0,102,0,0,0,126,0,0,0,156,0,0,0,194,0,0,0,240,0,0,0,40,1,0,0,108,1,0,0,192,1,0,0,38,2,0,0,64,2,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,16,0,0,0,22,0,0,0,30,0,0,0,42,0,0,0,58,0,0,0,78,0,0,0,104,0,0,0,138,0,0,0,180,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,12,0,0,0,18,0,0,0,24,0,0,0,30,0,0,0,36,0,0,0,44,0,0,0,54,0,0,0,66,0,0,0,80,0,0,0,96,0,0,0,116,0,0,0,140,0,0,0,168,0,0,0,200,0,0,0,238,0,0,0,28,1,0,0,80,1,0,0,140,1,0,0,208,1,0,0,10,2,0,0,64,2,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,18,0,0,0,26,0,0,0,36,0,0,0,48,0,0,0,62,0,0,0,80,0,0,0,104,0,0,0,134,0,0,0,174,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,12,0,0,0,18,0,0,0,24,0,0,0,30,0,0,0,36,0,0,0,44,0,0,0,54,0,0,0,66,0,0,0,80,0,0,0,96,0,0,0,116,0,0,0,140,0,0,0,168,0,0,0,200,0,0,0,238,0,0,0,28,1,0,0,80,1,0,0,140,1,0,0,208,1,0,0,10,2,0,0,64,2,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,18,0,0,0,26,0,0,0,36,0,0,0,48,0,0,0,62,0,0,0,80,0,0,0,104,0,0,0,134,0,0,0,174,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,24,0,0,0,36,0,0,0,48,0,0,0,60,0,0,0,72,0,0,0,88,0,0,0,108,0,0,0,132,0,0,0,160,0,0,0,192,0,0,0,232,0,0,0,24,1,0,0,80,1,0,0,144,1,0,0,220,1,0,0,54,2,0,0,56,2,0,0,58,2,0,0,60,2,0,0,62,2,0,0,64,2,0,0,0,0,0,0,8,0,0,0,16,0,0,0,24,0,0,0,36,0,0,0,52,0,0,0,72,0,0,0,96,0,0,0,124,0,0,0,160,0,0,0,162,0,0,0,164,0,0,0,166,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_NONE, 5254748);
allocate([0,0,0,0,6,0,0,0,11,0,0,0,16,0,0,0,21,0,0,0], "i8", ALLOC_NONE, 5256584);
allocate([0,0,0,0,18,0,0,0,36,0,0,0,54,0,0,0,54,0,0,0,36,0,0,0,54,0,0,0,72,0,0,0,54,0,0,0,72,0,0,0,90,0,0,0,72,0,0,0,90,0,0,0,108,0,0,0,108,0,0,0,126,0,0,0], "i8", ALLOC_NONE, 5256604);
allocate([0,0,0,0,18,0,0,0,36,0,0,0,54,0,0,0,51,0,0,0,35,0,0,0,53,0,0,0,71,0,0,0,52,0,0,0,70,0,0,0,88,0,0,0,69,0,0,0,87,0,0,0,105,0,0,0,104,0,0,0,122,0,0,0], "i8", ALLOC_NONE, 5256668);
allocate([0,0,0,0,10,0,0,0,20,0,0,0,30,0,0,0,33,0,0,0,21,0,0,0,31,0,0,0,41,0,0,0,32,0,0,0,42,0,0,0,52,0,0,0,43,0,0,0,53,0,0,0,63,0,0,0,64,0,0,0,74,0,0,0], "i8", ALLOC_NONE, 5256732);
allocate([34,86,0,0,192,93,0,0,128,62,0,0,255,255,255,255,68,172,0,0,128,187,0,0,0,125,0,0,255,255,255,255,17,43,0,0,224,46,0,0,64,31,0,0,255,255,255,255], "i8", ALLOC_NONE, 5256796);
allocate([0,128,64,192,32,160,96,224,16,144,80,208,48,176,112,240,8,136,72,200,40,168,104,232,24,152,88,216,56,184,120,248,4,132,68,196,36,164,100,228,20,148,84,212,52,180,116,244,12,140,76,204,44,172,108,236,28,156,92,220,60,188,124,252,2,130,66,194,34,162,98,226,18,146,82,210,50,178,114,242,10,138,74,202,42,170,106,234,26,154,90,218,58,186,122,250,6,134,70,198,38,166,102,230,22,150,86,214,54,182,118,246,14,142,78,206,46,174,110,238,30,158,94,222,62,190,126,254] /* \00\80@\C0 \A0`\E0\1 */, "i8", ALLOC_NONE, 5256844);
allocate([205,204,236,192,205,204,236,192,205,204,236,192,0,0,24,193,205,204,236,192,51,51,195,192,0,0,176,192,102,102,150,192,102,102,150,192,102,102,150,192,102,102,150,192], "i8", ALLOC_NONE, 5256972);
allocate([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,2,0,0,0,0,0,0,0], "i8", ALLOC_NONE, 5257016);
allocate(32832, "i8", ALLOC_NONE, 5257104);
allocate(1496, "i8", ALLOC_NONE, 5289936);
allocate([205,204,60,65,154,153,89,65,154,153,137,65,0,0,0,66,0,0,58,66,51,51,77,66,0,0,102,66,51,51,134,66,0,0,143,66,51,51,169,66,51,51,195,66,0,0,2,67], "i8", ALLOC_NONE, 5291432);
allocate([154,153,217,64,154,153,185,64,154,153,185,64,205,204,204,64,0,0,208,64,102,102,30,65,154,153,65,65,102,102,102,65,0,0,112,65,51,51,151,65,205,204,172,65,51,51,215,65,205,204,8,66,205,204,32,66,51,51,59,66,0,0,98,66,205,204,114,66,205,204,147,66,102,102,171,66,205,204,186,66,51,51,252,66], "i8", ALLOC_NONE, 5291480);
allocate([0,0,0,0,1,0,0,0,16,0,0,0,17,0,0,0,8,0,0,0,9,0,0,0,24,0,0,0,25,0,0,0,4,0,0,0,5,0,0,0,20,0,0,0,21,0,0,0,12,0,0,0,13,0,0,0,28,0,0,0,29,0,0,0,2,0,0,0,3,0,0,0,18,0,0,0,19,0,0,0,10,0,0,0,11,0,0,0,26,0,0,0,27,0,0,0,6,0,0,0,7,0,0,0,22,0,0,0,23,0,0,0,14,0,0,0,15,0,0,0,30,0,0,0,31,0,0,0], "i8", ALLOC_NONE, 5291564);
allocate([8,0,0,0,208,7,0,0,16,0,0,0,116,14,0,0,24,0,0,0,60,15,0,0,32,0,0,0,124,21,0,0,40,0,0,0,88,27,0,0,48,0,0,0,76,29,0,0,56,0,0,0,16,39,0,0,64,0,0,0,248,42,0,0,80,0,0,0,188,52,0,0,96,0,0,0,252,58,0,0,112,0,0,0,240,60,0,0,128,0,0,0,104,66,0,0,160,0,0,0,92,68,0,0,192,0,0,0,168,72,0,0,224,0,0,0,200,75,0,0,0,1,0,0,244,76,0,0,64,1,0,0,20,80,0,0], "i8", ALLOC_NONE, 5291692);
allocate([6,0,0,0,5,0,0,0,5,0,0,0,5,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,6,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,6,0,0,0,5,0,0,0,7,0,0,0,3,0,0,0,9,0,0,0,9,0,0,0,12,0,0,0,6,0,0,0,6,0,0,0,9,0,0,0,12,0,0,0,6,0,0,0,11,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,0,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,0,0,0,0,6,0,0,0,15,0,0,0,12,0,0,0,0,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,3,0,0,0,12,0,0,0,9,0,0,0,9,0,0,0,6,0,0,0,6,0,0,0,12,0,0,0,9,0,0,0,6,0,0,0,8,0,0,0,8,0,0,0,5,0,0,0,0,0,0,0,15,0,0,0,12,0,0,0,9,0,0,0,0,0,0,0,6,0,0,0,18,0,0,0,9,0,0,0,0,0,0,0], "i8", ALLOC_NONE, 5291828);
allocate([8,0,0,0,16,0,0,0,24,0,0,0,32,0,0,0,40,0,0,0,48,0,0,0,56,0,0,0,64,0,0,0,80,0,0,0,96,0,0,0,112,0,0,0,128,0,0,0,160,0,0,0,192,0,0,0,224,0,0,0,0,1,0,0,64,1,0,0], "i8", ALLOC_NONE, 5292116);
allocate([0,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0], "i8", ALLOC_NONE, 5292184);
allocate(24, "i8", ALLOC_NONE, 5292248);
allocate(22000, "i8", ALLOC_NONE, 5292272);
allocate([15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0] /* \0F\0F\0F\0F\0F\0F\0 */, "i8", ALLOC_NONE, 5314272);
allocate([15,0,0,0,15,0,0,0,7,0,0,0,7,0,0,0,15,0,0,0,15,0,0,0,7,0,0,0,0,0,0,0,7,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,31,0,0,0,31,0,0,0,0,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,0,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_NONE, 5314312);
allocate([7,7,7,7,7,7,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0] /* \07\07\07\07\07\07\0 */, "i8", ALLOC_NONE, 5314408);
allocate([15,15,15,15,15,15,15,15,15,15,15,7,7,7,7,7,7,7,7,7,7,0] /* \0F\0F\0F\0F\0F\0F\0 */, "i8", ALLOC_NONE, 5314432);
allocate(4, "i8", ALLOC_NONE, 5314456);
allocate(4, "i8", ALLOC_NONE, 5314460);
allocate(2052, "i8", ALLOC_NONE, 5314464);
allocate([4,0,1,0,5,0,5,0,7,0,7,0,8,0,9,0,9,0,10,0,10,0,10,0,10,0,11,0,11,0,11,0,11,0,12,0,12,0,12,0,12,0,12,0,12,0,13,0,12,0,13,0,12,0,13,0,13,0,14,0,10,0,10,0,5,0,4,0,6,0,6,0,7,0,8,0,8,0,9,0,9,0,10,0,10,0,11,0,10,0,11,0,11,0,11,0,11,0,12,0,11,0,12,0,12,0,12,0,12,0,13,0,12,0,14,0,12,0,13,0,12,0,14,0,10,0,10,0,7,0,7,0,7,0,8,0,8,0,9,0,9,0,10,0,9,0,11,0,10,0,11,0,10,0,12,0,11,0,12,0,11,0,13,0,11,0,12,0,11,0,13,0,12,0,13,0,12,0,13,0,12,0,14,0,13,0,14,0,9,0,11,0,8,0,9,0,8,0,9,0,9,0,10,0,9,0,11,0,10,0,11,0,10,0,12,0,10,0,12,0,11,0,12,0,11,0,13,0,11,0,13,0,11,0,14,0,12,0,14,0,12,0,14,0,12,0,15,0,12,0,15,0,9,0,12,0,9,0,10,0,9,0,10,0,9,0,11,0,10,0,11,0,10,0,12,0,10,0,12,0,10,0,13,0,11,0,13,0,11,0,13,0,11,0,14,0,12,0,14,0,12,0,14,0,12,0,15,0,12,0,15,0,13,0,15,0,9,0,11,0,10,0,10,0,9,0,10,0,10,0,11,0,10,0,11,0,10,0,12,0,10,0,13,0,11,0,13,0,11,0,14,0,11,0,13,0,11,0,14,0,12,0,14,0,12,0,15,0,12,0,15,0,12,0,15,0,12,0,16,0,9,0,12,0,10,0,11,0,10,0,11,0,10,0,11,0,10,0,12,0,10,0,13,0,11,0,13,0,11,0,13,0,11,0,13,0,11,0,14,0,12,0,14,0,12,0,14,0,12,0,14,0,12,0,15,0,12,0,15,0,13,0,16,0,9,0,12,0,11,0,11,0,10,0,11,0,10,0,12,0,10,0,12,0,11,0,13,0,11,0,13,0,11,0,13,0,11,0,14,0,12,0,14,0,12,0,15,0,12,0,15,0,12,0,15,0,12,0,15,0,13,0,17,0,13,0,17,0,10,0,12,0,11,0,11,0,11,0,12,0,11,0,12,0,11,0,13,0,11,0,13,0,11,0,13,0,11,0,14,0,11,0,14,0,11,0,15,0,12,0,15,0,12,0,15,0,12,0,15,0,12,0,16,0,13,0,16,0,13,0,16,0,10,0,12,0,11,0,12,0,11,0,12,0,11,0,12,0,11,0,13,0,11,0,13,0,11,0,14,0,11,0,14,0,12,0,15,0,12,0,15,0,12,0,15,0,12,0,15,0,12,0,16,0,13,0,15,0,13,0,16,0,13,0,15,0,10,0,13,0,12,0,12,0,11,0,13,0,11,0,12,0,11,0,13,0,11,0,14,0,12,0,14,0,12,0,14,0,12,0,14,0,12,0,15,0,12,0,16,0,12,0,16,0,13,0,16,0,13,0,17,0,13,0,17,0,13,0,16,0,10,0,12,0,12,0,13,0,12,0,13,0,11,0,13,0,11,0,13,0,11,0,14,0,12,0,14,0,12,0,15,0,12,0,16,0,12,0,16,0,12,0,16,0,12,0,16,0,13,0,16,0,13,0,16,0,13,0,15,0,13,0,16,0,10,0,13,0,12,0,13,0,12,0,14,0,12,0,14,0,12,0,14,0,12,0,14,0,12,0,15,0,12,0,15,0,12,0,15,0,12,0,15,0,12,0,17,0,13,0,16,0,13,0,16,0,13,0,16,0,13,0,16,0,13,0,18,0,10,0,13,0,12,0,15,0,12,0,14,0,12,0,14,0,12,0,14,0,12,0,15,0,12,0,15,0,12,0,16,0,12,0,16,0,13,0,16,0,13,0,18,0,13,0,17,0,13,0,17,0,13,0,17,0,13,0,19,0,13,0,17,0,10,0,13,0,13,0,14,0,12,0,15,0,12,0,13,0,12,0,14,0,12,0,16,0,12,0,16,0,12,0,15,0,13,0,16,0,13,0,16,0,13,0,17,0,13,0,18,0,13,0,17,0,13,0,19,0,13,0,17,0,13,0,16,0,10,0,13,0,9,0,10,0,9,0,10,0,9,0,10,0,9,0,11,0,9,0,11,0,9,0,12,0,9,0,12,0,9,0,12,0,9,0,13,0,9,0,13,0,9,0,13,0,10,0,13,0,10,0,13,0,10,0,13,0,10,0,13,0,6,0,10,0], "i8", ALLOC_NONE, 5316516);
allocate([44,76,0,0,56,74,0,0,68,72,0,0,80,70,0,0,92,68,0,0,116,64,0,0,140,60,0,0,164,56,0,0,212,48,0,0,28,37,0,0,110,15,0,0], "i8", ALLOC_NONE, 5317540);
allocate([192,93,0,0,44,76,0,0,68,72,0,0,80,70,0,0,92,68,0,0,104,66,0,0,116,64,0,0,240,60,0,0,96,59,0,0,62,28,0,0,110,15,0,0], "i8", ALLOC_NONE, 5317584);
allocate([44,76,0,0,56,74,0,0,168,72,0,0,80,70,0,0,92,68,0,0,128,62,0,0,240,60,0,0,52,58,0,0,212,48,0,0,16,39,0,0,110,15,0,0], "i8", ALLOC_NONE, 5317628);
allocate([128,187,0,0,0,0,0,0,0,0,208,64,0,0,0,0,0,0,208,64,148,92,0,0,68,172,0,0,0,0,0,0,0,0,208,64,0,0,0,0,0,0,208,64,20,85,0,0,0,125,0,0,0,0,208,64,0,0,0,65,102,102,166,64,0,0,208,64,184,61,0,0,192,93,0,0,0,0,0,65,0,0,8,65,102,102,166,64,0,0,192,64,74,46,0,0,34,86,0,0,0,0,8,65,246,40,16,65,102,102,166,64,0,0,208,64,140,42,0,0,128,62,0,0,246,40,16,65,102,102,22,65,205,204,156,64,0,0,208,64,223,30,0,0,224,46,0,0,102,102,22,65,154,153,25,65,0,0,144,64,0,0,192,64,40,23,0,0,17,43,0,0,154,153,25,65,102,102,30,65,51,51,163,64,0,0,208,64,70,21,0,0,64,31,0,0,102,102,30,65,0,0,32,65,205,204,156,64,0,0,208,64,112,15,0,0], "i8", ALLOC_NONE, 5317672);
allocate([102,102,182,64,0,0,208,64,154,153,233,64,51,51,3,65,0,0,32,65,102,102,62,65,0,0,80,65,0,0,96,65,0,0,112,65,0,0,132,65], "i8", ALLOC_NONE, 5317888);
allocate([0,0,0,63,0,0,0,63], "i8", ALLOC_NONE, 5317928);
allocate([84,224,212,189,89,191,65,190,248,108,93,190,47,168,31,190,254,195,51,36,70,124,111,62,48,42,1,63,72,191,65,63,70,124,111,63], "i8", ALLOC_NONE, 5317936);
allocate(8192, "i8", ALLOC_NONE, 5317972);
allocate(1028, "i8", ALLOC_NONE, 5326164);
allocate(4, "i8", ALLOC_NONE, 5327192);
allocate([1,0,0,0,2,0,0,0,5,0,0,0,7,0,0,0,7,0,0,0,10,0,0,0,10,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0], "i8", ALLOC_NONE, 5327196);
allocate([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,63,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,255,3,0,0,0,0,0,0,0,0,0,0,13,0,0,0,255,31,0,0,0,0,0,0,0,0,0,0,4,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,31,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,63,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,127,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,255,1,0,0,0,0,0,0,0,0,0,0,11,0,0,0,255,7,0,0,0,0,0,0,0,0,0,0,13,0,0,0,255,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_NONE, 5327256);
allocate(9216, "i8", ALLOC_NONE, 5327800);
allocate(8192, "i8", ALLOC_NONE, 5337016);
allocate(592, "i8", ALLOC_NONE, 5345208);
allocate([123,0,0,0,34,0,0,0,74,0,0,0,73,0,0,0,99,0,0,0,20,0,0,0,40,0,0,0,26,0,0,0,145,0,0,0,90,0,0,0,116,0,0,0,41,0,0,0,135,0,0,0,85,0,0,0,96,0,0,0,138,0,0,0,89,0,0,0,0,0,0,0,107,0,0,0,132,0,0,0,65,0,0,0,88,0,0,0,104,0,0,0,102,0,0,0,97,0,0,0,136,0,0,0,61,0,0,0,141,0,0,0,32,0,0,0,1,0,0,0,112,0,0,0,128,0,0,0,57,0,0,0,140,0,0,0,2,0,0,0,139,0,0,0,58,0,0,0,3,0,0,0,125,0,0,0,50,0,0,0,22,0,0,0,4,0,0,0,55,0,0,0,127,0,0,0,122,0,0,0,120,0,0,0,98,0,0,0,52,0,0,0,48,0,0,0,54,0,0,0,124,0,0,0,25,0,0,0,84,0,0,0,80,0,0,0,115,0,0,0,81,0,0,0,119,0,0,0,5,0,0,0,30,0,0,0,36,0,0,0,59,0,0,0,126,0,0,0,38,0,0,0,49,0,0,0,91,0,0,0,6,0,0,0,129,0,0,0,79,0,0,0,137,0,0,0,7,0,0,0,35,0,0,0,100,0,0,0,131,0,0,0,19,0,0,0,33,0,0,0,46,0,0,0,47,0,0,0,8,0,0,0,29,0,0,0,146,0,0,0,63,0,0,0,86,0,0,0,71,0,0,0,45,0,0,0,142,0,0,0,9,0,0,0,77,0,0,0,82,0,0,0,64,0,0,0,133,0,0,0,10,0,0,0,66,0,0,0,39,0,0,0,11,0,0,0,103,0,0,0,12,0,0,0,75,0,0,0,134,0,0,0,13,0,0,0,53,0,0,0,62,0,0,0,109,0,0,0,117,0,0,0,23,0,0,0,108,0,0,0,92,0,0,0,67,0,0,0,93,0,0,0,43,0,0,0,121,0,0,0,15,0,0,0,68,0,0,0,14,0,0,0,16,0,0,0,76,0,0,0,87,0,0,0,118,0,0,0,17,0,0,0,78,0,0,0,143,0,0,0,114,0,0,0,110,0,0,0,69,0,0,0,21,0,0,0,111,0,0,0,95,0,0,0,105,0,0,0,42,0,0,0,37,0,0,0,24,0,0,0,56,0,0,0,44,0,0,0,101,0,0,0,83,0,0,0,94,0,0,0,106,0,0,0,147,0,0,0,113,0,0,0,18,0,0,0,51,0,0,0,130,0,0,0,144,0,0,0,60,0,0,0,70,0,0,0,31,0,0,0,72,0,0,0,27,0,0,0,28,0,0,0], "i8", ALLOC_NONE, 5345800);
allocate([121,207,23,190,138,59,1,66,164,51,148,67,155,200,92,68,202,167,45,70,175,40,132,68,192,222,152,67,129,155,246,65,199,156,118,64,77,183,109,66,194,101,49,68,74,15,165,69,82,45,182,197,71,104,76,196,73,213,153,194,66,4,147,192,94,6,104,63,54,189,72,62,3,97,30,190,44,76,9,66,68,231,150,67,96,102,76,68,47,215,52,70,17,168,147,68,117,204,160,67,46,219,249,65,68,124,109,64,146,154,86,66,183,10,43,68,136,68,163,69,35,243,198,197,129,62,99,196,80,169,179,194,43,42,173,192,1,24,82,63,194,197,199,62,223,144,36,190,144,150,16,66,32,15,152,67,140,47,55,68,113,86,59,70,101,128,162,68,120,164,167,67,193,231,251,65,149,237,87,64,209,237,60,66,46,47,35,68,80,99,160,69,178,232,215,197,240,127,122,196,100,62,207,194,121,91,195,192,207,220,61,63,49,160,20,63,61,91,42,190,177,1,23,66,106,129,151,67,98,254,28,68,14,27,65,70,229,136,176,68,246,95,173,67,75,201,252,65,52,59,74,64,173,80,34,66,178,10,26,68,170,126,156,69,83,240,232,197,121,249,136,196,253,124,236,194,231,48,218,192,193,13,43,63,21,239,67,63,139,188,47,190,75,118,28,66,177,43,149,67,81,195,251,67,92,30,70,70,161,146,189,68,23,254,177,67,116,41,251,65,165,166,58,64,77,48,7,66,62,185,15,68,225,169,151,69,144,236,249,197,102,184,148,196,253,164,5,195,130,12,247,192,196,112,25,63,234,90,113,63,120,177,52,190,11,224,32,66,197,255,144,67,75,169,179,67,9,89,74,70,63,131,201,68,227,108,181,67,12,94,248,65,73,159,52,64,49,233,215,65,148,121,4,68,250,250,145,69,153,95,5,198,224,82,160,196,230,149,21,195,193,75,10,193,185,213,8,63,218,57,142,63,244,54,185,190,93,45,36,66,238,197,138,67,123,163,67,67,193,197,77,70,150,52,212,68,118,180,183,67,208,116,244,65,169,3,34,64,173,143,160,65,68,192,240,67,195,135,139,69,122,165,13,198,28,180,171,196,130,42,38,195,136,83,25,193,112,40,242,62,153,103,162,63,55,74,189,190,167,146,37,66,148,165,130,67,182,247,78,65,135,96,80,70,71,144,221,68,247,225,184,67,182,2,238,65,153,191,25,64,113,224,84,65,226,71,215,67,116,104,132,69,186,183,21,198,32,182,182,196,153,32,55,195,248,124,43,193,205,19,212,62,243,4,181,63,187,232,192,190,91,122,38,66,227,13,113,67,88,242,59,195,65,40,82,70,237,132,229,68,213,190,184,67,201,3,232,65,16,147,4,64,105,242,216,64,110,227,188,67,47,102,121,69,214,134,29,198,81,62,193,196,85,96,72,195,235,212,61,193,80,50,183,62,3,228,197,63,71,16,196,190,73,155,36,66,18,122,88,67,23,20,203,195,140,28,83,70,216,249,235,68,185,166,183,67,247,22,225,65,11,250,244,63,71,16,196,62,69,237,161,67,91,2,105,69,239,4,37,198,124,38,203,196,16,160,89,195,54,63,80,193,66,80,155,62,49,219,212,63,46,15,21,191,242,108,33,66,98,51,60,67,83,17,32,196,220,60,83,70,70,243,240,68,238,104,181,67,38,192,215,65,112,137,223,63,88,12,180,192,157,166,134,67,47,214,87,69,149,32,44,198,6,85,212,196,16,196,106,195,193,157,98,193,212,63,128,62,152,197,225,63,57,182,22,191,234,239,28,66,206,194,27,67,244,79,94,196,226,141,82,70,182,97,244,68,249,56,178,67,221,40,207,65,124,229,200,63,57,233,50,193,16,207,86,67,160,18,70,69,73,205,50,198,21,165,220,196,104,176,123,195,1,246,119,193,175,175,75,62,94,131,236,63,230,143,74,191,36,147,21,66,35,102,239,66,16,227,143,196,201,17,81,70,166,76,246,68,130,2,174,67,22,218,197,65,28,72,177,63,12,95,131,193,224,12,33,67,81,229,51,69,247,251,56,198,140,255,227,196,139,36,134,195,184,137,134,193,100,229,23,62,11,250,244,63,223,202,75,191,201,237,12,66,223,9,160,66,174,0,178,196,45,207,78,70,187,185,246,68,213,254,168,67,51,80,186,65,197,91,178,63,32,204,168,193,139,247,216,66,54,123,33,69,232,158,62,198,230,72,234,196,148,31,142,195,218,232,144,193,220,181,201,61,190,20,251,63,15,177,127,191,152,64,2,66,94,213,19,66,106,66,213,196,38,205,75,70,66,172,245,68,70,55,163,67,112,102,177,65,251,108,153,63,81,248,202,193,231,35,102,66,180,6,15,69,179,170,67,198,226,90,239,196,151,161,149,195,66,6,155,193,60,57,73,61,109,196,254,63,54,211,37,70,68,177,165,69,175,113,104,68,69,51,54,68,128,12,144,67,180,213,129,66,2,0,241,65,34,63,131,64,49,19,72,70,167,49,243,68,86,182,156,67,170,105,166,65,251,100,249,68,112,3,16,65,17,158,233,193], "i8", ALLOC_NONE, 5346392);
allocate([0,0,0,0,128,1,0,0,128,4,0,0,128,4,0,0,0,0,0,0,128,1,0,0,128,4,0,0,64,2,0,0], "i8", ALLOC_NONE, 5347532);
allocate([0,0,0,0,193,192,0,0,129,193,0,0,64,1,0,0,1,195,0,0,192,3,0,0,128,2,0,0,65,194,0,0,1,198,0,0,192,6,0,0,128,7,0,0,65,199,0,0,0,5,0,0,193,197,0,0,129,196,0,0,64,4,0,0,1,204,0,0,192,12,0,0,128,13,0,0,65,205,0,0,0,15,0,0,193,207,0,0,129,206,0,0,64,14,0,0,0,10,0,0,193,202,0,0,129,203,0,0,64,11,0,0,1,201,0,0,192,9,0,0,128,8,0,0,65,200,0,0,1,216,0,0,192,24,0,0,128,25,0,0,65,217,0,0,0,27,0,0,193,219,0,0,129,218,0,0,64,26,0,0,0,30,0,0,193,222,0,0,129,223,0,0,64,31,0,0,1,221,0,0,192,29,0,0,128,28,0,0,65,220,0,0,0,20,0,0,193,212,0,0,129,213,0,0,64,21,0,0,1,215,0,0,192,23,0,0,128,22,0,0,65,214,0,0,1,210,0,0,192,18,0,0,128,19,0,0,65,211,0,0,0,17,0,0,193,209,0,0,129,208,0,0,64,16,0,0,1,240,0,0,192,48,0,0,128,49,0,0,65,241,0,0,0,51,0,0,193,243,0,0,129,242,0,0,64,50,0,0,0,54,0,0,193,246,0,0,129,247,0,0,64,55,0,0,1,245,0,0,192,53,0,0,128,52,0,0,65,244,0,0,0,60,0,0,193,252,0,0,129,253,0,0,64,61,0,0,1,255,0,0,192,63,0,0,128,62,0,0,65,254,0,0,1,250,0,0,192,58,0,0,128,59,0,0,65,251,0,0,0,57,0,0,193,249,0,0,129,248,0,0,64,56,0,0,0,40,0,0,193,232,0,0,129,233,0,0,64,41,0,0,1,235,0,0,192,43,0,0,128,42,0,0,65,234,0,0,1,238,0,0,192,46,0,0,128,47,0,0,65,239,0,0,0,45,0,0,193,237,0,0,129,236,0,0,64,44,0,0,1,228,0,0,192,36,0,0,128,37,0,0,65,229,0,0,0,39,0,0,193,231,0,0,129,230,0,0,64,38,0,0,0,34,0,0,193,226,0,0,129,227,0,0,64,35,0,0,1,225,0,0,192,33,0,0,128,32,0,0,65,224,0,0,1,160,0,0,192,96,0,0,128,97,0,0,65,161,0,0,0,99,0,0,193,163,0,0,129,162,0,0,64,98,0,0,0,102,0,0,193,166,0,0,129,167,0,0,64,103,0,0,1,165,0,0,192,101,0,0,128,100,0,0,65,164,0,0,0,108,0,0,193,172,0,0,129,173,0,0,64,109,0,0,1,175,0,0,192,111,0,0,128,110,0,0,65,174,0,0,1,170,0,0,192,106,0,0,128,107,0,0,65,171,0,0,0,105,0,0,193,169,0,0,129,168,0,0,64,104,0,0,0,120,0,0,193,184,0,0,129,185,0,0,64,121,0,0,1,187,0,0,192,123,0,0,128,122,0,0,65,186,0,0,1,190,0,0,192,126,0,0,128,127,0,0,65,191,0,0,0,125,0,0,193,189,0,0,129,188,0,0,64,124,0,0,1,180,0,0,192,116,0,0,128,117,0,0,65,181,0,0,0,119,0,0,193,183,0,0,129,182,0,0,64,118,0,0,0,114,0,0,193,178,0,0,129,179,0,0,64,115,0,0,1,177,0,0,192,113,0,0,128,112,0,0,65,176,0,0,0,80,0,0,193,144,0,0,129,145,0,0,64,81,0,0,1,147,0,0,192,83,0,0,128,82,0,0,65,146,0,0,1,150,0,0,192,86,0,0,128,87,0,0,65,151,0,0,0,85,0,0,193,149,0,0,129,148,0,0,64,84,0,0,1,156,0,0,192,92,0,0,128,93,0,0,65,157,0,0,0,95,0,0,193,159,0,0,129,158,0,0,64,94,0,0,0,90,0,0,193,154,0,0,129,155,0,0,64,91,0,0,1,153,0,0,192,89,0,0,128,88,0,0,65,152,0,0,1,136,0,0,192,72,0,0,128,73,0,0,65,137,0,0,0,75,0,0,193,139,0,0,129,138,0,0,64,74,0,0,0,78,0,0,193,142,0,0,129,143,0,0,64,79,0,0,1,141,0,0,192,77,0,0,128,76,0,0,65,140,0,0,0,68,0,0,193,132,0,0,129,133,0,0,64,69,0,0,1,135,0,0,192,71,0,0,128,70,0,0,65,134,0,0,1,130,0,0,192,66,0,0,128,67,0,0,65,131,0,0,0,65,0,0,193,129,0,0,129,128,0,0,64,64,0,0], "i8", ALLOC_NONE, 5347564);
allocate([28,0,0,0,32,0,0,0,6,0,0,0,6,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0], ["*",0,0,0,"*",0,0,0,"*",0,0,0,"*",0,0,0,"*",0,0,0,"*",0,0,0,"*",0,0,0,"*",0,0,0,"*",0,0,0,"*",0,0,0,"*",0,0,0,"*",0,0,0,"*",0,0,0,"*",0,0,0,"*",0,0,0,"*",0,0,0], ALLOC_NONE, 5348588);
allocate([94,131,108,63,21,239,195,62,109,196,126,63,54,189,200,61,67,236,127,63,176,10,201,60,196,254,127,63,136,15,201,59], "i8", ALLOC_NONE, 5348652);
allocate([0,0,0,0,8,0,0,0,16,0,0,0,24,0,0,0,32,0,0,0,40,0,0,0,48,0,0,0,56,0,0,0,64,0,0,0,80,0,0,0,96,0,0,0,112,0,0,0,128,0,0,0,144,0,0,0,160,0,0,0,255,255,255,255,0,0,0,0,32,0,0,0,40,0,0,0,48,0,0,0,56,0,0,0,64,0,0,0,80,0,0,0,96,0,0,0,112,0,0,0,128,0,0,0,160,0,0,0,192,0,0,0,224,0,0,0,0,1,0,0,64,1,0,0,255,255,255,255,0,0,0,0,8,0,0,0,16,0,0,0,24,0,0,0,32,0,0,0,40,0,0,0,48,0,0,0,56,0,0,0,64,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255], "i8", ALLOC_NONE, 5348684);
allocate([8,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,240,193,0,0,48,65,82,73,157,58,1,0,0,0,16,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,200,193,0,0,48,65,111,18,131,58,1,0,0,0,24,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,160,193,0,0,48,65,111,18,131,58,1,0,0,0,32,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,112,193,0,0,48,65,111,18,131,58,1,0,0,0,40,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,32,193,0,0,48,65,250,237,107,58,1,0,0,0,48,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,32,193,0,0,48,65,250,237,107,58,1,0,0,0,56,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,192,192,0,0,48,65,23,183,81,58,1,0,0,0,64,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,0,192,0,0,48,65,23,183,81,58,1,0,0,0,80,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,0,0,0,0,0,65,52,128,55,58,1,0,0,0,96,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,32,64,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,128,63,0,0,176,64,82,73,29,58,1,0,0,0,112,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,16,64,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,0,64,0,0,144,64,111,18,3,58,1,0,0,0,128,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,154,153,249,63,205,204,204,64,0,0,12,67,51,51,115,63,0,0,0,0,0,0,64,64,0,0,128,64,23,183,81,57,1,0,0,0,160,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,184,30,229,63,0,0,192,64,0,0,7,67,51,51,115,63,0,0,0,192,0,0,160,64,0,0,96,64,0,0,0,0,1,0,0,0,192,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,82,184,190,63,51,51,179,64,0,0,250,66,236,81,120,63,0,0,128,192,0,0,224,64,0,0,64,64,0,0,0,0,0,0,0,0,224,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,0,0,160,63,102,102,166,64,0,0,250,66,72,225,122,63,0,0,192,192,0,0,16,65,0,0,0,64,0,0,0,0,0,0,0,0,0,1,0,0,9,0,0,0,9,0,0,0,1,0,0,0,236,81,120,63,102,102,166,64,0,0,250,66,0,0,128,63,0,0,0,193,0,0,32,65,0,0,128,63,0,0,0,0,0,0,0,0,64,1,0,0,9,0,0,0,9,0,0,0,1,0,0,0,102,102,102,63,102,102,166,64,0,0,250,66,0,0,128,63,0,0,32,193,0,0,64,65,0,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_NONE, 5348876);
allocate(32832, "i8", ALLOC_NONE, 5349760);
allocate([67,101,108,116,105,99,0] /* Celtic\00 */, "i8", ALLOC_NONE, 5382592);
allocate([82,101,118,105,118,97,108,0] /* Revival\00 */, "i8", ALLOC_NONE, 5382600);
allocate([76,97,116,105,110,0] /* Latin\00 */, "i8", ALLOC_NONE, 5382608);
allocate([66,101,98,111,98,0] /* Bebob\00 */, "i8", ALLOC_NONE, 5382616);
allocate([70,97,115,116,32,70,117,115,105,111,110,0] /* Fast Fusion\00 */, "i8", ALLOC_NONE, 5382624);
allocate([83,119,105,110,103,0] /* Swing\00 */, "i8", ALLOC_NONE, 5382636);
allocate([78,97,116,105,111,110,97,108,32,70,111,108,107,0] /* National Folk\00 */, "i8", ALLOC_NONE, 5382644);
allocate([87,97,114,110,105,110,103,58,32,104,105,103,104,112,97,115,115,32,102,105,108,116,101,114,32,100,105,115,97,98,108,101,100,46,32,32,104,105,103,104,112,97,115,115,32,102,114,101,113,117,101,110,99,121,32,116,111,111,32,115,109,97,108,108,10,0] /* Warning: highpass fi */, "i8", ALLOC_NONE, 5382660);
allocate([70,111,108,107,45,82,111,99,107,0] /* Folk-Rock\00 */, "i8", ALLOC_NONE, 5382728);
allocate([83,83,69,0] /* SSE\00 */, "i8", ALLOC_NONE, 5382740);
allocate([69,114,114,111,114,58,32,99,97,110,39,116,32,97,108,108,111,99,97,116,101,32,105,110,95,98,117,102,102,101,114,32,98,117,102,102,101,114,10,0] /* Error: can't allocat */, "i8", ALLOC_NONE, 5382744);
allocate([70,111,108,107,0] /* Folk\00 */, "i8", ALLOC_NONE, 5382784);
allocate([69,114,114,111,114,58,32,99,111,117,108,100,32,110,111,116,32,117,112,100,97,116,101,32,76,65,77,69,32,116,97,103,44,32,102,105,108,101,32,110,111,116,32,114,101,97,100,97,98,108,101,46,10,0] /* Error: could not upd */, "i8", ALLOC_NONE, 5382792);
allocate([72,97,114,100,32,82,111,99,107,0] /* Hard Rock\00 */, "i8", ALLOC_NONE, 5382848);
allocate([76,65,77,69,32,37,115,32,118,101,114,115,105,111,110,32,37,115,32,40,37,115,41,0] /* LAME %s version %s ( */, "i8", ALLOC_NONE, 5382860);
allocate([69,114,114,111,114,58,32,99,111,117,108,100,32,110,111,116,32,117,112,100,97,116,101,32,76,65,77,69,32,116,97,103,44,32,102,105,108,101,32,110,111,116,32,115,101,101,107,97,98,108,101,46,10,0] /* Error: could not upd */, "i8", ALLOC_NONE, 5382884);
allocate([82,111,99,107,32,38,32,82,111,108,108,0] /* Rock & Roll\00 */, "i8", ALLOC_NONE, 5382940);
allocate([69,114,114,111,114,58,32,99,111,117,108,100,32,110,111,116,32,117,112,100,97,116,101,32,76,65,77,69,32,116,97,103,46,10,0] /* Error: could not upd */, "i8", ALLOC_NONE, 5382952);
allocate([77,117,115,105,99,97,108,0] /* Musical\00 */, "i8", ALLOC_NONE, 5382988);
allocate([10,0] /* \0A\00 */, "i8", ALLOC_NONE, 5382996);
allocate([82,101,116,114,111,0] /* Retro\00 */, "i8", ALLOC_NONE, 5383000);
allocate([9,105,110,116,101,114,99,104,97,110,110,101,108,32,109,97,115,107,105,110,103,32,114,97,116,105,111,58,32,37,103,10,0] /* \09interchannel mask */, "i8", ALLOC_NONE, 5383008);
allocate([80,111,108,107,97,0] /* Polka\00 */, "i8", ALLOC_NONE, 5383044);
allocate([9,117,115,105,110,103,32,116,101,109,112,111,114,97,108,32,109,97,115,107,105,110,103,32,101,102,102,101,99,116,58,32,37,115,10,0] /* \09using temporal ma */, "i8", ALLOC_NONE, 5383052);
allocate([65,99,105,100,32,74,97,122,122,0] /* Acid Jazz\00 */, "i8", ALLOC_NONE, 5383088);
allocate([110,111,0] /* no\00 */, "i8", ALLOC_NONE, 5383100);
allocate([65,99,105,100,32,80,117,110,107,0] /* Acid Punk\00 */, "i8", ALLOC_NONE, 5383104);
allocate([121,101,115,0] /* yes\00 */, "i8", ALLOC_NONE, 5383116);
allocate([84,114,105,98,97,108,0] /* Tribal\00 */, "i8", ALLOC_NONE, 5383120);
allocate([9,32,32,32,97,100,106,117,115,116,32,109,97,115,107,105,110,103,32,98,97,115,115,61,37,103,32,100,66,44,32,97,108,116,111,61,37,103,32,100,66,44,32,116,114,101,98,108,101,61,37,103,32,100,66,44,32,115,102,98,50,49,61,37,103,32,100,66,10,0] /* \09   adjust masking */, "i8", ALLOC_NONE, 5383128);
allocate([76,111,45,70,105,0] /* Lo-Fi\00 */, "i8", ALLOC_NONE, 5383200);
allocate([37,108,117,0] /* %lu\00 */, "i8", ALLOC_NONE, 5383208);
allocate([9,101,120,112,101,114,105,109,101,110,116,97,108,32,112,115,121,32,116,117,110,105,110,103,115,32,98,121,32,78,97,111,107,105,32,83,104,105,98,97,116,97,10,0] /* \09experimental psy  */, "i8", ALLOC_NONE, 5383212);
allocate([84,114,97,105,108,101,114,0] /* Trailer\00 */, "i8", ALLOC_NONE, 5383256);
allocate([9,32,94,32,97,100,106,117,115,116,32,115,101,110,115,105,116,105,118,105,116,121,32,112,111,119,101,114,58,32,37,102,10,0] /* \09 ^ adjust sensiti */, "i8", ALLOC_NONE, 5383264);
allocate([83,104,111,119,116,117,110,101,115,0] /* Showtunes\00 */, "i8", ALLOC_NONE, 5383300);
allocate([80,78,71,0] /* PNG\00 */, "i8", ALLOC_NONE, 5383312);
allocate([9,32,94,32,97,100,106,117,115,116,32,116,121,112,101,58,32,37,100,10,0] /* \09 ^ adjust type: % */, "i8", ALLOC_NONE, 5383316);
allocate([82,97,118,101,0] /* Rave\00 */, "i8", ALLOC_NONE, 5383340);
allocate([9,32,94,32,108,101,118,101,108,32,97,100,106,117,115,116,101,109,101,110,116,58,32,37,103,32,100,66,10,0] /* \09 ^ level adjustem */, "i8", ALLOC_NONE, 5383348);
allocate([80,115,121,99,104,101,100,101,108,105,99,0] /* Psychedelic\00 */, "i8", ALLOC_NONE, 5383380);
allocate([32,40,111,110,108,121,32,102,111,114,32,116,121,112,101,32,52,41,0] /*  (only for type 4)\0 */, "i8", ALLOC_NONE, 5383392);
allocate([78,101,119,32,87,97,118,101,0] /* New Wave\00 */, "i8", ALLOC_NONE, 5383412);
allocate([9,32,94,32,115,104,97,112,101,58,32,37,103,37,115,10,0] /* \09 ^ shape: %g%s\0A */, "i8", ALLOC_NONE, 5383424);
allocate([67,97,98,97,114,101,116,0] /* Cabaret\00 */, "i8", ALLOC_NONE, 5383444);
allocate([9,32,94,32,116,121,112,101,58,32,37,100,10,0] /* \09 ^ type: %d\0A\00 */, "i8", ALLOC_NONE, 5383452);
allocate([78,97,116,105,118,101,32,85,83,0] /* Native US\00 */, "i8", ALLOC_NONE, 5383468);
allocate([9,65,84,72,58,32,37,115,10,0] /* \09ATH: %s\0A\00 */, "i8", ALLOC_NONE, 5383480);
allocate([74,117,110,103,108,101,0] /* Jungle\00 */, "i8", ALLOC_NONE, 5383492);
allocate([110,111,116,32,117,115,101,100,0] /* not used\00 */, "i8", ALLOC_NONE, 5383500);
allocate([80,111,112,47,70,117,110,107,0] /* Pop/Funk\00 */, "i8", ALLOC_NONE, 5383512);
allocate([116,104,101,32,111,110,108,121,32,109,97,115,107,105,110,103,0] /* the only masking\00 */, "i8", ALLOC_NONE, 5383524);
allocate([67,104,114,105,115,116,105,97,110,32,82,97,112,0] /* Christian Rap\00 */, "i8", ALLOC_NONE, 5383544);
allocate([51,68,78,111,119,33,0] /* 3DNow!\00 */, "i8", ALLOC_NONE, 5383560);
allocate([37,100,0] /* %d\00 */, "i8", ALLOC_NONE, 5383568);
allocate([116,104,101,32,111,110,108,121,32,109,97,115,107,105,110,103,32,102,111,114,32,115,104,111,114,116,32,98,108,111,99,107,115,0] /* the only masking for */, "i8", ALLOC_NONE, 5383572);
allocate([84,111,112,32,52,48,0] /* Top 40\00 */, "i8", ALLOC_NONE, 5383608);
allocate([117,115,105,110,103,0] /* using\00 */, "i8", ALLOC_NONE, 5383616);
allocate([71,97,110,103,115,116,97,0] /* Gangsta\00 */, "i8", ALLOC_NONE, 5383624);
allocate([69,114,114,111,114,58,32,77,65,88,95,72,69,65,68,69,82,95,66,85,70,32,116,111,111,32,115,109,97,108,108,32,105,110,32,98,105,116,115,116,114,101,97,109,46,99,32,10,0] /* Error: MAX_HEADER_BU */, "i8", ALLOC_NONE, 5383632);
allocate([9,32,94,32,115,116,111,112,112,105,110,103,58,32,37,100,10,0] /* \09 ^ stopping: %d\0 */, "i8", ALLOC_NONE, 5383684);
allocate([67,117,108,116,0] /* Cult\00 */, "i8", ALLOC_NONE, 5383704);
allocate([9,32,94,32,97,109,112,108,105,102,105,99,97,116,105,111,110,58,32,37,100,10,0] /* \09 ^ amplification: */, "i8", ALLOC_NONE, 5383712);
allocate([67,111,109,101,100,121,0] /* Comedy\00 */, "i8", ALLOC_NONE, 5383736);
allocate([9,110,111,105,115,101,32,115,104,97,112,105,110,103,58,32,37,100,10,0] /* \09noise shaping: %d */, "i8", ALLOC_NONE, 5383744);
allocate([83,111,117,116,104,101,114,110,32,82,111,99,107,0] /* Southern Rock\00 */, "i8", ALLOC_NONE, 5383764);
allocate([9,32,94,32,99,111,109,112,97,114,105,115,111,110,32,115,104,111,114,116,32,98,108,111,99,107,115,58,32,37,100,10,0] /* \09 ^ comparison sho */, "i8", ALLOC_NONE, 5383780);
allocate([68,114,101,97,109,0] /* Dream\00 */, "i8", ALLOC_NONE, 5383816);
allocate([9,113,117,97,110,116,105,122,97,116,105,111,110,32,99,111,109,112,97,114,105,115,111,110,58,32,37,100,10,0] /* \09quantization comp */, "i8", ALLOC_NONE, 5383824);
allocate([69,117,114,111,100,97,110,99,101,0] /* Eurodance\00 */, "i8", ALLOC_NONE, 5383856);
allocate([51,50,98,105,116,115,0] /* 32bits\00 */, "i8", ALLOC_NONE, 5383868);
allocate([9,97,100,106,117,115,116,32,109,97,115,107,105,110,103,32,115,104,111,114,116,58,32,37,103,32,100,66,10,0] /* \09adjust masking sh */, "i8", ALLOC_NONE, 5383876);
allocate([80,111,112,45,70,111,108,107,0] /* Pop-Folk\00 */, "i8", ALLOC_NONE, 5383908);
allocate([9,97,100,106,117,115,116,32,109,97,115,107,105,110,103,58,32,37,103,32,100,66,10,0] /* \09adjust masking: % */, "i8", ALLOC_NONE, 5383920);
allocate([69,108,101,99,116,114,111,110,105,99,0] /* Electronic\00 */, "i8", ALLOC_NONE, 5383944);
allocate([9,115,117,98,98,108,111,99,107,32,103,97,105,110,58,32,37,100,10,0] /* \09subblock gain: %d */, "i8", ALLOC_NONE, 5383956);
allocate([84,101,99,104,110,111,45,73,110,100,117,115,116,114,105,97,108,0] /* Techno-Industrial\00 */, "i8", ALLOC_NONE, 5383976);
allocate([105,109,97,103,101,47,103,105,102,0] /* image/gif\00 */, "i8", ALLOC_NONE, 5383996);
allocate([9,117,115,105,110,103,32,115,104,111,114,116,32,98,108,111,99,107,115,58,32,37,115,10,0] /* \09using short block */, "i8", ALLOC_NONE, 5384008);
allocate([68,97,114,107,119,97,118,101,0] /* Darkwave\00 */, "i8", ALLOC_NONE, 5384036);
allocate([102,111,114,99,101,100,0] /* forced\00 */, "i8", ALLOC_NONE, 5384048);
allocate([71,111,116,104,105,99,0] /* Gothic\00 */, "i8", ALLOC_NONE, 5384056);
allocate([32,49,37,37,32,32,98,117,103,32,105,110,32,76,65,77,69,32,101,110,99,111,100,105,110,103,32,108,105,98,114,97,114,121,0] /*  1%%  bug in LAME en */, "i8", ALLOC_NONE, 5384064);
allocate([100,105,115,112,101,110,115,101,100,0] /* dispensed\00 */, "i8", ALLOC_NONE, 5384100);
allocate([69,116,104,110,105,99,0] /* Ethnic\00 */, "i8", ALLOC_NONE, 5384112);
allocate([99,104,97,110,110,101,108,32,99,111,117,112,108,101,100,0] /* channel coupled\00 */, "i8", ALLOC_NONE, 5384120);
allocate([73,110,115,116,114,117,109,101,110,116,97,108,32,82,111,99,107,0] /* Instrumental Rock\00 */, "i8", ALLOC_NONE, 5384136);
allocate([97,108,108,111,119,101,100,0] /* allowed\00 */, "i8", ALLOC_NONE, 5384156);
allocate([73,110,115,116,114,117,109,101,110,116,97,108,32,80,111,112,0] /* Instrumental Pop\00 */, "i8", ALLOC_NONE, 5384164);
allocate([10,112,115,121,99,104,111,97,99,111,117,115,116,105,99,58,10,10,0] /* \0Apsychoacoustic:\0 */, "i8", ALLOC_NONE, 5384184);
allocate([77,101,100,105,116,97,116,105,118,101,0] /* Meditative\00 */, "i8", ALLOC_NONE, 5384204);
allocate([9,117,115,105,110,103,32,76,65,77,69,32,84,97,103,10,0] /* \09using LAME Tag\0A */, "i8", ALLOC_NONE, 5384216);
allocate([83,112,97,99,101,0] /* Space\00 */, "i8", ALLOC_NONE, 5384236);
allocate(1, "i8", ALLOC_NONE, 5384244);
allocate([9,32,63,63,32,111,111,112,115,44,32,115,111,109,101,32,110,101,119,32,111,110,101,32,63,63,32,10,0] /* \09 ?? oops, some ne */, "i8", ALLOC_NONE, 5384248);
allocate([80,117,110,107,0] /* Punk\00 */, "i8", ALLOC_NONE, 5384280);
allocate([9,118,97,114,105,97,98,108,101,32,98,105,116,114,97,116,101,32,45,32,86,66,82,32,109,116,114,104,32,37,115,10,0] /* \09variable bitrate  */, "i8", ALLOC_NONE, 5384288);
allocate([83,111,117,108,0] /* Soul\00 */, "i8", ALLOC_NONE, 5384324);
allocate([9,118,97,114,105,97,98,108,101,32,98,105,116,114,97,116,101,32,45,32,86,66,82,32,109,116,32,37,115,10,0] /* \09variable bitrate  */, "i8", ALLOC_NONE, 5384332);
allocate([66,97,115,115,0] /* Bass\00 */, "i8", ALLOC_NONE, 5384364);
allocate([77,77,88,0] /* MMX\00 */, "i8", ALLOC_NONE, 5384372);
allocate([105,109,97,103,101,47,112,110,103,0] /* image/png\00 */, "i8", ALLOC_NONE, 5384376);
allocate([9,118,97,114,105,97,98,108,101,32,98,105,116,114,97,116,101,32,45,32,86,66,82,32,114,104,32,37,115,10,0] /* \09variable bitrate  */, "i8", ALLOC_NONE, 5384388);
allocate([65,108,116,101,114,110,97,116,105,118,101,32,82,111,99,107,0] /* Alternative Rock\00 */, "i8", ALLOC_NONE, 5384420);
allocate([9,118,97,114,105,97,98,108,101,32,98,105,116,114,97,116,101,32,45,32,65,66,82,32,37,115,10,0] /* \09variable bitrate  */, "i8", ALLOC_NONE, 5384440);
allocate([78,111,105,115,101,0] /* Noise\00 */, "i8", ALLOC_NONE, 5384468);
allocate([32,57,37,37,32,32,89,111,117,114,32,115,121,115,116,101,109,32,105,115,32,111,118,101,114,99,108,111,99,107,101,100,0] /*  9%%  Your system is */, "i8", ALLOC_NONE, 5384476);
allocate([9,99,111,110,115,116,97,110,116,32,98,105,116,114,97,116,101,32,45,32,67,66,82,32,37,115,10,0] /* \09constant bitrate  */, "i8", ALLOC_NONE, 5384512);
allocate([71,111,115,112,101,108,0] /* Gospel\00 */, "i8", ALLOC_NONE, 5384540);
allocate([40,102,114,101,101,32,102,111,114,109,97,116,41,0] /* (free format)\00 */, "i8", ALLOC_NONE, 5384548);
allocate([83,111,117,110,100,32,67,108,105,112,0] /* Sound Clip\00 */, "i8", ALLOC_NONE, 5384564);
allocate([109,97,120,32,115,121,115,116,101,109,32,98,121,116,101,115,32,61,32,37,49,48,108,117,10,0] /* max system bytes = % */, "i8", ALLOC_NONE, 5384576);
allocate([40,100,101,102,97,117,108,116,41,0] /* (default)\00 */, "i8", ALLOC_NONE, 5384604);
allocate([71,97,109,101,0] /* Game\00 */, "i8", ALLOC_NONE, 5384616);
allocate([9,112,97,100,100,105,110,103,58,32,37,115,10,0] /* \09padding: %s\0A\00 */, "i8", ALLOC_NONE, 5384624);
allocate([72,111,117,115,101,0] /* House\00 */, "i8", ALLOC_NONE, 5384640);
allocate([51,46,57,57,46,53,0] /* 3.99.5\00 */, "i8", ALLOC_NONE, 5384648);
allocate([97,108,108,0] /* all\00 */, "i8", ALLOC_NONE, 5384656);
allocate([65,99,105,100,0] /* Acid\00 */, "i8", ALLOC_NONE, 5384660);
allocate([104,116,116,112,58,47,47,108,97,109,101,46,115,102,46,110,101,116,0] /* http://lame.sf.net\0 */, "i8", ALLOC_NONE, 5384668);
allocate([69,114,114,111,114,58,32,99,97,110,39,116,32,97,108,108,111,99,97,116,101,32,86,98,114,70,114,97,109,101,115,32,98,117,102,102,101,114,10,0] /* Error: can't allocat */, "i8", ALLOC_NONE, 5384688);
allocate([111,102,102,0] /* off\00 */, "i8", ALLOC_NONE, 5384728);
allocate([73,78,84,69,82,78,65,76,32,69,82,82,79,82,32,73,78,32,86,66,82,32,78,69,87,32,67,79,68,69,32,40,49,51,49,51,41,44,32,112,108,101,97,115,101,32,115,101,110,100,32,98,117,103,32,114,101,112,111,114,116,10,109,97,120,98,105,116,115,61,37,100,32,117,115,101,100,98,105,116,115,61,37,100,10,0] /* INTERNAL ERROR IN VB */, "i8", ALLOC_NONE, 5384732);
allocate([73,110,115,116,114,117,109,101,110,116,97,108,0] /* Instrumental\00 */, "i8", ALLOC_NONE, 5384820);
allocate([9,37,100,32,99,104,97,110,110,101,108,32,45,32,37,115,10,0] /* \09%d channel - %s\0 */, "i8", ALLOC_NONE, 5384836);
allocate([67,108,97,115,115,105,99,97,108,0] /* Classical\00 */, "i8", ALLOC_NONE, 5384856);
allocate([117,110,107,110,111,119,110,32,40,101,114,114,111,114,41,0] /* unknown (error)\00 */, "i8", ALLOC_NONE, 5384868);
allocate([84,114,97,110,99,101,0] /* Trance\00 */, "i8", ALLOC_NONE, 5384884);
allocate([44,32,0] /* , \00 */, "i8", ALLOC_NONE, 5384892);
allocate([105,109,97,103,101,47,106,112,101,103,0] /* image/jpeg\00 */, "i8", ALLOC_NONE, 5384896);
allocate([110,111,116,32,115,101,116,32,40,101,114,114,111,114,41,0] /* not set (error)\00 */, "i8", ALLOC_NONE, 5384908);
allocate([70,117,115,105,111,110,0] /* Fusion\00 */, "i8", ALLOC_NONE, 5384924);
allocate([109,111,110,111,0] /* mono\00 */, "i8", ALLOC_NONE, 5384932);
allocate([74,97,122,122,43,70,117,110,107,0] /* Jazz+Funk\00 */, "i8", ALLOC_NONE, 5384940);
allocate([57,48,37,37,32,32,76,65,77,69,32,99,111,109,112,105,108,101,100,32,119,105,116,104,32,98,117,103,103,121,32,118,101,114,115,105,111,110,32,111,102,32,103,99,99,32,117,115,105,110,103,32,97,100,118,97,110,99,101,100,32,111,112,116,105,109,105,122,97,116,105,111,110,115,0] /* 90%%  LAME compiled  */, "i8", ALLOC_NONE, 5384952);
allocate([100,117,97,108,32,99,104,97,110,110,101,108,0] /* dual channel\00 */, "i8", ALLOC_NONE, 5385028);
allocate([86,111,99,97,108,0] /* Vocal\00 */, "i8", ALLOC_NONE, 5385044);
allocate([105,110,116,101,110,115,105,116,121,32,115,116,101,114,101,111,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,32,121,101,116,10,0] /* intensity stereo not */, "i8", ALLOC_NONE, 5385052);
allocate([115,116,101,114,101,111,0] /* stereo\00 */, "i8", ALLOC_NONE, 5385092);
allocate([84,114,105,112,45,72,111,112,0] /* Trip-Hop\00 */, "i8", ALLOC_NONE, 5385100);
allocate([106,111,105,110,116,32,115,116,101,114,101,111,0] /* joint stereo\00 */, "i8", ALLOC_NONE, 5385112);
allocate([65,109,98,105,101,110,116,0] /* Ambient\00 */, "i8", ALLOC_NONE, 5385128);
allocate([9,77,80,69,71,45,37,115,32,76,97,121,101,114,32,51,10,0] /* \09MPEG-%s Layer 3\0 */, "i8", ALLOC_NONE, 5385136);
allocate([69,117,114,111,45,84,101,99,104,110,111,0] /* Euro-Techno\00 */, "i8", ALLOC_NONE, 5385156);
allocate([63,0] /* ?\00 */, "i8", ALLOC_NONE, 5385168);
allocate([83,111,117,110,100,116,114,97,99,107,0] /* Soundtrack\00 */, "i8", ALLOC_NONE, 5385172);
allocate([115,116,100,58,58,98,97,100,95,97,108,108,111,99,0] /* std::bad_alloc\00 */, "i8", ALLOC_NONE, 5385184);
allocate([49,46,48,0] /* 1.0\00 */, "i8", ALLOC_NONE, 5385200);
allocate([50,0] /* 2\00 */, "i8", ALLOC_NONE, 5385204);
allocate([80,114,97,110,107,115,0] /* Pranks\00 */, "i8", ALLOC_NONE, 5385208);
allocate([49,0] /* 1\00 */, "i8", ALLOC_NONE, 5385216);
allocate([68,101,97,116,104,32,77,101,116,97,108,0] /* Death Metal\00 */, "i8", ALLOC_NONE, 5385220);
allocate([50,46,53,0] /* 2.5\00 */, "i8", ALLOC_NONE, 5385232);
allocate([83,107,97,0] /* Ska\00 */, "i8", ALLOC_NONE, 5385236);
allocate([10,115,116,114,101,97,109,32,102,111,114,109,97,116,58,10,10,0] /* \0Astream format:\0A */, "i8", ALLOC_NONE, 5385240);
allocate(1, "i8", ALLOC_NONE, 5385260);
allocate([65,108,116,101,114,110,97,116,105,118,101,0] /* Alternative\00 */, "i8", ALLOC_NONE, 5385264);
allocate([9,46,46,46,10,0] /* \09...\0A\00 */, "i8", ALLOC_NONE, 5385276);
allocate([73,110,100,117,115,116,114,105,97,108,0] /* Industrial\00 */, "i8", ALLOC_NONE, 5385284);
allocate([84,104,105,115,32,105,115,32,97,32,102,97,116,97,108,32,101,114,114,111,114,46,32,32,73,116,32,104,97,115,32,115,101,118,101,114,97,108,32,112,111,115,115,105,98,108,101,32,99,97,117,115,101,115,58,0] /* This is a fatal erro */, "i8", ALLOC_NONE, 5385296);
allocate([9,101,120,112,101,114,105,109,101,110,116,97,108,32,89,61,37,100,10,0] /* \09experimental Y=%d */, "i8", ALLOC_NONE, 5385352);
allocate([84,101,99,104,110,111,0] /* Techno\00 */, "i8", ALLOC_NONE, 5385372);
allocate([9,104,117,102,102,109,97,110,32,115,101,97,114,99,104,58,32,37,115,10,0] /* \09huffman search: % */, "i8", ALLOC_NONE, 5385380);
allocate([82,111,99,107,0] /* Rock\00 */, "i8", ALLOC_NONE, 5385404);
allocate([98,101,115,116,32,40,105,110,115,105,100,101,32,108,111,111,112,44,32,115,108,111,119,41,0] /* best (inside loop, s */, "i8", ALLOC_NONE, 5385412);
allocate([82,101,103,103,97,101,0] /* Reggae\00 */, "i8", ALLOC_NONE, 5385440);
allocate([73,78,84,69,82,78,65,76,32,69,82,82,79,82,32,73,78,32,86,66,82,32,78,69,87,32,67,79,68,69,44,32,112,108,101,97,115,101,32,115,101,110,100,32,98,117,103,32,114,101,112,111,114,116,10,0] /* INTERNAL ERROR IN VB */, "i8", ALLOC_NONE, 5385448);
allocate([98,101,115,116,32,40,111,117,116,115,105,100,101,32,108,111,111,112,41,0] /* best (outside loop)\ */, "i8", ALLOC_NONE, 5385504);
allocate([82,97,112,0] /* Rap\00 */, "i8", ALLOC_NONE, 5385524);
allocate([110,111,114,109,97,108,0] /* normal\00 */, "i8", ALLOC_NONE, 5385528);
allocate([82,38,66,0] /* R&B\00 */, "i8", ALLOC_NONE, 5385536);
allocate([105,110,32,117,115,101,32,98,121,116,101,115,32,32,32,32,32,61,32,37,49,48,108,117,10,0] /* in use bytes     = % */, "i8", ALLOC_NONE, 5385540);
allocate([76,65,77,69,51,46,57,57,114,0] /* LAME3.99r\00 */, "i8", ALLOC_NONE, 5385568);
allocate([9,99,104,49,32,40,114,105,103,104,116,41,32,115,99,97,108,105,110,103,58,32,37,103,10,0] /* \09ch1 (right) scali */, "i8", ALLOC_NONE, 5385580);
allocate([80,111,112,0] /* Pop\00 */, "i8", ALLOC_NONE, 5385608);
allocate([9,99,104,48,32,40,108,101,102,116,41,32,115,99,97,108,105,110,103,58,32,37,103,10,0] /* \09ch0 (left) scalin */, "i8", ALLOC_NONE, 5385612);
allocate([79,116,104,101,114,0] /* Other\00 */, "i8", ALLOC_NONE, 5385640);
allocate([9,115,99,97,108,105,110,103,58,32,37,103,10,0] /* \09scaling: %g\0A\00 */, "i8", ALLOC_NONE, 5385648);
allocate([79,108,100,105,101,115,0] /* Oldies\00 */, "i8", ALLOC_NONE, 5385664);
allocate([10,109,105,115,99,58,10,10,0] /* \0Amisc:\0A\0A\00 */, "i8", ALLOC_NONE, 5385672);
allocate([88,88,88,0] /* XXX\00 */, "i8", ALLOC_NONE, 5385684);
allocate([78,101,119,32,65,103,101,0] /* New Age\00 */, "i8", ALLOC_NONE, 5385688);
allocate(1, "i8", ALLOC_NONE, 5385696);
allocate([77,101,116,97,108,0] /* Metal\00 */, "i8", ALLOC_NONE, 5385700);
allocate([98,105,116,32,114,101,115,101,114,118,111,105,114,32,101,114,114,111,114,58,32,10,108,51,95,115,105,100,101,45,62,109,97,105,110,95,100,97,116,97,95,98,101,103,105,110,58,32,37,105,32,10,82,101,115,118,111,105,114,32,115,105,122,101,58,32,32,32,32,32,32,32,32,32,32,32,32,32,37,105,32,10,114,101,115,118,32,100,114,97,105,110,32,40,112,111,115,116,41,32,32,32,32,32,32,32,32,32,37,105,32,10,114,101,115,118,32,100,114,97,105,110,32,40,112,114,101,41,32,32,32,32,32,32,32,32,32,32,37,105,32,10,104,101,97,100,101,114,32,97,110,100,32,115,105,100,101,105,110,102,111,58,32,32,32,32,32,32,37,105,32,10,100,97,116,97,32,98,105,116,115,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,37,105,32,10,116,111,116,97,108,32,98,105,116,115,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,37,105,32,40,114,101,109,97,105,110,100,101,114,58,32,37,105,41,32,10,98,105,116,115,112,101,114,102,114,97,109,101,58,32,32,32,32,32,32,32,32,32,32,32,32,32,37,105,32,10,0] /* bit reservoir error: */, "i8", ALLOC_NONE, 5385708);
allocate([87,97,114,110,105,110,103,58,32,109,97,110,121,32,100,101,99,111,100,101,114,115,32,99,97,110,110,111,116,32,104,97,110,100,108,101,32,102,114,101,101,32,102,111,114,109,97,116,32,98,105,116,114,97,116,101,115,32,62,51,50,48,32,107,98,112,115,32,40,115,101,101,32,100,111,99,117,109,101,110,116,97,116,105,111,110,41,10,0] /* Warning: many decode */, "i8", ALLOC_NONE, 5385988);
allocate([74,97,122,122,0] /* Jazz\00 */, "i8", ALLOC_NONE, 5386080);
allocate([71,73,70,56,0] /* GIF8\00 */, "i8", ALLOC_NONE, 5386088);
allocate([87,97,114,110,105,110,103,58,32,109,97,110,121,32,100,101,99,111,100,101,114,115,32,99,97,110,110,111,116,32,104,97,110,100,108,101,32,102,114,101,101,32,102,111,114,109,97,116,32,98,105,116,115,116,114,101,97,109,115,10,0] /* Warning: many decode */, "i8", ALLOC_NONE, 5386096);
allocate([72,105,112,45,72,111,112,0] /* Hip-Hop\00 */, "i8", ALLOC_NONE, 5386160);
allocate([112,111,108,121,112,104,97,115,101,32,108,111,119,112,97,115,115,32,102,105,108,116,101,114,32,100,105,115,97,98,108,101,100,10,0] /* polyphase lowpass fi */, "i8", ALLOC_NONE, 5386168);
allocate([71,114,117,110,103,101,0] /* Grunge\00 */, "i8", ALLOC_NONE, 5386204);
allocate([85,115,105,110,103,32,112,111,108,121,112,104,97,115,101,32,108,111,119,112,97,115,115,32,102,105,108,116,101,114,44,32,116,114,97,110,115,105,116,105,111,110,32,98,97,110,100,58,32,37,53,46,48,102,32,72,122,32,45,32,37,53,46,48,102,32,72,122,10,0] /* Using polyphase lowp */, "i8", ALLOC_NONE, 5386212);
allocate([70,117,110,107,0] /* Funk\00 */, "i8", ALLOC_NONE, 5386284);
allocate([76,65,77,69,32,37,115,32,37,115,32,40,37,115,41,10,0] /* LAME %s %s (%s)\0A\0 */, "i8", ALLOC_NONE, 5386292);
allocate([83,121,110,116,104,80,111,112,0] /* SynthPop\00 */, "i8", ALLOC_NONE, 5386312);
allocate([74,80,111,112,0] /* JPop\00 */, "i8", ALLOC_NONE, 5386324);
allocate([65,110,105,109,101,0] /* Anime\00 */, "i8", ALLOC_NONE, 5386332);
allocate([84,104,114,97,115,104,32,77,101,116,97,108,0] /* Thrash Metal\00 */, "i8", ALLOC_NONE, 5386340);
allocate([83,97,108,115,97,0] /* Salsa\00 */, "i8", ALLOC_NONE, 5386356);
allocate([77,101,114,101,110,103,117,101,0] /* Merengue\00 */, "i8", ALLOC_NONE, 5386364);
allocate([67,104,114,105,115,116,105,97,110,32,82,111,99,107,0] /* Christian Rock\00 */, "i8", ALLOC_NONE, 5386376);
allocate([85,115,105,110,103,32,112,111,108,121,112,104,97,115,101,32,104,105,103,104,112,97,115,115,32,102,105,108,116,101,114,44,32,116,114,97,110,115,105,116,105,111,110,32,98,97,110,100,58,32,37,53,46,48,102,32,72,122,32,45,32,37,53,46,48,102,32,72,122,10,0] /* Using polyphase high */, "i8", ALLOC_NONE, 5386392);
allocate([67,111,110,116,101,109,112,111,114,97,114,121,32,67,104,114,105,115,116,105,97,110,0] /* Contemporary Christi */, "i8", ALLOC_NONE, 5386464);
allocate([67,114,111,115,115,111,118,101,114,0] /* Crossover\00 */, "i8", ALLOC_NONE, 5386488);
allocate([68,105,115,99,111,0] /* Disco\00 */, "i8", ALLOC_NONE, 5386500);
allocate([66,108,97,99,107,32,77,101,116,97,108,0] /* Black Metal\00 */, "i8", ALLOC_NONE, 5386508);
allocate([72,101,97,118,121,32,77,101,116,97,108,0] /* Heavy Metal\00 */, "i8", ALLOC_NONE, 5386520);
allocate([115,121,115,116,101,109,32,98,121,116,101,115,32,32,32,32,32,61,32,37,49,48,108,117,10,0] /* system bytes     = % */, "i8", ALLOC_NONE, 5386532);
allocate([67,104,114,105,115,116,105,97,110,32,71,97,110,103,115,116,97,0] /* Christian Gangsta\00 */, "i8", ALLOC_NONE, 5386560);
allocate([66,101,97,116,0] /* Beat\00 */, "i8", ALLOC_NONE, 5386580);
allocate([76,65,77,69,51,46,57,57,114,53,0] /* LAME3.99r5\00 */, "i8", ALLOC_NONE, 5386588);
allocate([80,111,108,115,107,32,80,117,110,107,0] /* Polsk Punk\00 */, "i8", ALLOC_NONE, 5386600);
allocate([98,97,100,95,97,114,114,97,121,95,110,101,119,95,108,101,110,103,116,104,0] /* bad_array_new_length */, "i8", ALLOC_NONE, 5386612);
allocate([73,68,51,0] /* ID3\00 */, "i8", ALLOC_NONE, 5386636);
allocate([73,78,84,69,82,78,65,76,32,69,82,82,79,82,32,73,78,32,86,66,82,32,78,69,87,32,67,79,68,69,32,40,57,56,54,41,44,32,112,108,101,97,115,101,32,115,101,110,100,32,98,117,103,32,114,101,112,111,114,116,10,0] /* INTERNAL ERROR IN VB */, "i8", ALLOC_NONE, 5386640);
allocate([78,101,103,101,114,112,117,110,107,0] /* Negerpunk\00 */, "i8", ALLOC_NONE, 5386704);
allocate([66,114,105,116,80,111,112,0] /* BritPop\00 */, "i8", ALLOC_NONE, 5386716);
allocate([73,110,100,105,101,0] /* Indie\00 */, "i8", ALLOC_NONE, 5386724);
allocate([82,101,115,97,109,112,108,105,110,103,58,32,32,105,110,112,117,116,32,37,103,32,107,72,122,32,32,111,117,116,112,117,116,32,37,103,32,107,72,122,10,0] /* Resampling:  input % */, "i8", ALLOC_NONE, 5386732);
allocate([84,101,114,114,111,114,0] /* Terror\00 */, "i8", ALLOC_NONE, 5386776);
allocate([72,97,114,100,99,111,114,101,0] /* Hardcore\00 */, "i8", ALLOC_NONE, 5386784);
allocate([68,97,110,99,101,0] /* Dance\00 */, "i8", ALLOC_NONE, 5386796);
allocate([67,108,117,98,45,72,111,117,115,101,0] /* Club-House\00 */, "i8", ALLOC_NONE, 5386804);
allocate([68,114,117,109,32,38,32,66,97,115,115,0] /* Drum & Bass\00 */, "i8", ALLOC_NONE, 5386816);
allocate([71,111,97,0] /* Goa\00 */, "i8", ALLOC_NONE, 5386828);
allocate([68,97,110,99,101,32,72,97,108,108,0] /* Dance Hall\00 */, "i8", ALLOC_NONE, 5386832);
allocate([69,117,114,111,45,72,111,117,115,101,0] /* Euro-House\00 */, "i8", ALLOC_NONE, 5386844);
allocate([65,32,67,97,112,112,101,108,108,97,0] /* A Cappella\00 */, "i8", ALLOC_NONE, 5386856);
allocate([68,114,117,109,32,83,111,108,111,0] /* Drum Solo\00 */, "i8", ALLOC_NONE, 5386868);
allocate([80,117,110,107,32,82,111,99,107,0] /* Punk Rock\00 */, "i8", ALLOC_NONE, 5386880);
allocate([65,117,116,111,99,111,110,118,101,114,116,105,110,103,32,102,114,111,109,32,115,116,101,114,101,111,32,116,111,32,109,111,110,111,46,32,83,101,116,116,105,110,103,32,101,110,99,111,100,105,110,103,32,116,111,32,109,111,110,111,32,109,111,100,101,46,10,0] /* Autoconverting from  */, "i8", ALLOC_NONE, 5386892);
allocate([68,117,101,116,0] /* Duet\00 */, "i8", ALLOC_NONE, 5386960);
allocate([70,114,101,101,115,116,121,108,101,0] /* Freestyle\00 */, "i8", ALLOC_NONE, 5386968);
allocate([67,111,117,110,116,114,121,0] /* Country\00 */, "i8", ALLOC_NONE, 5386980);
allocate([82,104,121,116,104,109,105,99,32,83,111,117,108,0] /* Rhythmic Soul\00 */, "i8", ALLOC_NONE, 5386988);
allocate([80,111,119,101,114,32,66,97,108,108,97,100,0] /* Power Ballad\00 */, "i8", ALLOC_NONE, 5387004);
allocate([66,97,108,108,97,100,0] /* Ballad\00 */, "i8", ALLOC_NONE, 5387020);
allocate([70,111,108,107,108,111,114,101,0] /* Folklore\00 */, "i8", ALLOC_NONE, 5387028);
allocate([83,97,109,98,97,0] /* Samba\00 */, "i8", ALLOC_NONE, 5387040);
allocate([84,97,110,103,111,0] /* Tango\00 */, "i8", ALLOC_NONE, 5387048);
allocate([67,108,117,98,0] /* Club\00 */, "i8", ALLOC_NONE, 5387056);
allocate([83,108,111,119,32,74,97,109,0] /* Slow Jam\00 */, "i8", ALLOC_NONE, 5387064);
allocate([67,80,85,32,102,101,97,116,117,114,101,115,58,32,37,115,10,0] /* CPU features: %s\0A\ */, "i8", ALLOC_NONE, 5387076);
allocate([83,97,116,105,114,101,0] /* Satire\00 */, "i8", ALLOC_NONE, 5387096);
allocate([80,111,114,110,32,71,114,111,111,118,101,0] /* Porn Groove\00 */, "i8", ALLOC_NONE, 5387104);
allocate([67,108,97,115,115,105,99,32,82,111,99,107,0] /* Classic Rock\00 */, "i8", ALLOC_NONE, 5387116);
allocate([80,114,105,109,117,115,0] /* Primus\00 */, "i8", ALLOC_NONE, 5387132);
allocate([66,111,111,116,121,32,66,97,115,115,0] /* Booty Bass\00 */, "i8", ALLOC_NONE, 5387140);
allocate([83,121,109,112,104,111,110,121,0] /* Symphony\00 */, "i8", ALLOC_NONE, 5387152);
allocate([83,111,110,97,116,97,0] /* Sonata\00 */, "i8", ALLOC_NONE, 5387164);
allocate([67,104,97,109,98,101,114,32,77,117,115,105,99,0] /* Chamber Music\00 */, "i8", ALLOC_NONE, 5387172);
allocate([79,112,101,114,97,0] /* Opera\00 */, "i8", ALLOC_NONE, 5387188);
allocate([67,104,97,110,115,111,110,0] /* Chanson\00 */, "i8", ALLOC_NONE, 5387196);
allocate([83,112,101,101,99,104,0] /* Speech\00 */, "i8", ALLOC_NONE, 5387204);
allocate([83,83,69,50,0] /* SSE2\00 */, "i8", ALLOC_NONE, 5387212);
allocate([72,117,109,111,117,114,0] /* Humour\00 */, "i8", ALLOC_NONE, 5387220);
allocate([65,99,111,117,115,116,105,99,0] /* Acoustic\00 */, "i8", ALLOC_NONE, 5387228);
allocate([66,108,117,101,115,0] /* Blues\00 */, "i8", ALLOC_NONE, 5387240);
allocate([69,97,115,121,32,76,105,115,116,101,110,105,110,103,0] /* Easy Listening\00 */, "i8", ALLOC_NONE, 5387248);
allocate([67,104,111,114,117,115,0] /* Chorus\00 */, "i8", ALLOC_NONE, 5387264);
allocate([66,105,103,32,66,97,110,100,0] /* Big Band\00 */, "i8", ALLOC_NONE, 5387272);
allocate([83,108,111,119,32,82,111,99,107,0] /* Slow Rock\00 */, "i8", ALLOC_NONE, 5387284);
allocate([83,121,109,112,104,111,110,105,99,32,82,111,99,107,0] /* Symphonic Rock\00 */, "i8", ALLOC_NONE, 5387296);
allocate([80,115,121,99,104,101,100,101,108,105,99,32,82,111,99,107,0] /* Psychedelic Rock\00 */, "i8", ALLOC_NONE, 5387312);
allocate([80,114,111,103,114,101,115,115,105,118,101,32,82,111,99,107,0] /* Progressive Rock\00 */, "i8", ALLOC_NONE, 5387332);
allocate([71,111,116,104,105,99,32,82,111,99,107,0] /* Gothic Rock\00 */, "i8", ALLOC_NONE, 5387352);
allocate([65,118,97,110,116,103,97,114,100,101,0] /* Avantgarde\00 */, "i8", ALLOC_NONE, 5387364);
allocate([66,108,117,101,103,114,97,115,115,0] /* Bluegrass\00 */, "i8", ALLOC_NONE, 5387376);
allocate([76,65,77,69,32,118,101,114,115,105,111,110,32,37,115,32,40,37,115,41,0] /* LAME version %s (%s) */, "i8", ALLOC_NONE, 5387388);
allocate([73,110,116,101,114,110,97,108,32,98,117,102,102,101,114,32,105,110,99,111,110,115,105,115,116,101,110,99,121,46,32,102,108,117,115,104,98,105,116,115,32,60,62,32,82,101,115,118,83,105,122,101,0] /* Internal buffer inco */, "i8", ALLOC_NONE, 5387412);
allocate([115,116,114,97,110,103,101,32,101,114,114,111,114,32,102,108,117,115,104,105,110,103,32,98,117,102,102,101,114,32,46,46,46,32,10,0] /* strange error flushi */, "i8", ALLOC_NONE, 5387468);
allocate(468, "i8", ALLOC_NONE, 5387504);
allocate([0,0,0,0,32,55,82,0,0,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_NONE, 5387972);
allocate(1, "i8", ALLOC_NONE, 5387992);
allocate([0,0,0,0,44,55,82,0,0,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_NONE, 5387996);
allocate(1, "i8", ALLOC_NONE, 5388016);
allocate([83,116,57,98,97,100,95,97,108,108,111,99,0] /* St9bad_alloc\00 */, "i8", ALLOC_NONE, 5388020);
allocate([83,116,50,48,98,97,100,95,97,114,114,97,121,95,110,101,119,95,108,101,110,103,116,104,0] /* St20bad_array_new_le */, "i8", ALLOC_NONE, 5388036);
allocate(12, "i8", ALLOC_NONE, 5388064);
allocate([0,0,0,0,0,0,0,0,32,55,82,0], "i8", ALLOC_NONE, 5388076);
allocate(1, "i8", ALLOC_NONE, 5388088);
allocate(4, "i8", ALLOC_NONE, 5388092);
allocate([1,30,0,0,1,30,0,0], "i8", ALLOC_NONE, 5388096);
allocate([0,16,0,0,0,16,0,0,0,16,0,0,0,16,0,0], "i8", ALLOC_NONE, 5388104);
allocate([1,5,3,2,4,0,3] /* \01\05\03\02\04\00\0 */, "i8", ALLOC_NONE, 5388120);
allocate([221,1,30,61,115,47,118,192,47,250,176,188,158,20,250,64,153,188,161,186,158,119,53,193,81,220,194,184,116,225,80,65,83,153,135,188,1,154,68,193,129,18,177,60,29,186,23,65,225,231,169,188,42,236,187,192,86,189,194,59,84,76,48,64,23,210,72,59,21,174,94,191,117,48,252,56,166,136,14,62,45,12,61,59,187,242,93,61,21,159,94,192,66,120,238,188,39,159,203,64,116,13,11,188,159,194,8,193,122,116,11,188,136,161,23,65,15,206,8,188,48,10,13,193,54,239,183,60,24,84,219,64,42,177,212,188,119,161,140,192,227,27,133,60,46,141,12,64,204,220,29,187,91,68,64,191,179,14,221,59,38,166,6,62,18,27,246,186,98,72,30,62,88,65,24,192,146,25,191,189,204,80,54,64,198,233,127,189,83,84,41,192,195,60,177,60,160,42,15,64,141,230,100,189,27,243,213,191,107,217,67,61,72,195,128,63,221,177,17,59,30,72,235,190,198,2,2,61,96,182,39,62,140,213,99,188,41,29,78,189,32,117,213,59,250,86,192,60,8,103,16,188,195,30,155,62,254,109,206,191,55,145,103,190,17,54,138,63,79,222,175,189,44,92,131,190,5,120,6,61,113,172,38,190,93,7,22,188,128,210,103,190,162,171,193,188,106,76,200,62,186,131,191,187,206,177,98,190,217,136,128,61,99,84,56,61,14,238,10,183,195,81,164,60,229,233,6,59,220,52,70,59,209,172,241,188,164,63,172,62,202,209,191,191,12,238,130,190,224,157,95,63,198,63,242,189,120,245,249,61,39,37,244,61,171,200,78,191,74,115,160,189,61,4,245,62,155,0,154,187,253,11,255,189,221,42,193,187,240,154,38,189,226,118,106,61,225,172,170,61,116,82,8,60,208,143,45,189,111,248,133,188,144,228,243,60,148,49,144,188,83,247,229,62,31,210,32,191,69,246,18,190,75,222,151,62,236,79,105,190,172,192,190,190,13,131,104,188,76,24,12,59,175,11,39,61,83,49,215,190,21,234,253,189,13,83,99,62,22,214,39,61,196,1,201,59,137,153,214,61,247,48,138,61,143,176,152,188,61,242,108,61,134,205,2,189,7,1,4,61,132,146,177,59,35,242,16,63,249,36,134,191,99,48,65,191,195,71,149,62,202,81,38,62,41,63,137,190,8,118,43,62,71,89,6,60,108,141,65,190,36,174,230,62,232,94,158,62,59,32,169,190,83,31,141,190,179,5,138,61,91,28,212,59,139,246,67,189,211,25,177,61,92,87,134,60,98,50,27,189,45,15,148,60,22,191,192,187,190,188,20,63,131,166,2,191,181,32,8,191,54,36,163,190,218,83,18,190,249,108,79,190,122,105,51,62,249,208,22,62,32,205,194,60,1,112,199,62,138,81,31,62,88,186,110,190,236,195,129,190,127,224,86,189,85,103,133,60,212,73,205,188,47,187,141,61,242,19,200,60,237,111,24,189,6,255,148,60,149,162,245,187,69,87,9,63,94,65,128,190,239,223,215,190,42,39,221,190,85,217,52,187,98,70,12,189,146,207,46,61,213,159,63,189,79,51,209,189,227,53,135,62,214,104,21,62,42,194,26,62,27,131,201,188,75,199,51,190,101,108,229,189,100,191,64,190,139,76,38,189,16,94,96,61,204,36,68,61,80,177,64,61,130,177,181,188], "i8", ALLOC_NONE, 5388128);
allocate([98,120,124,63,40,114,252,191,98,120,252,191,59,253,120,63,98,120,124,63,19,41,124,63,180,33,252,191,19,41,252,191,229,96,120,63,19,41,124,63,66,185,122,63,86,171,250,191,66,185,250,191,92,142,117,63,66,185,122,63,120,174,121,63,129,154,249,191,120,174,249,191,222,132,115,63,120,174,121,63,91,33,121,63,194,9,249,191,91,33,249,191,234,113,114,63,91,33,121,63,110,236,118,63,58,195,246,191,110,236,246,191,69,43,110,63,110,236,118,63,141,200,117,63,87,148,245,191,141,200,245,191,134,249,107,63,141,200,117,63,202,100,117,63,133,44,245,191,202,100,245,191,31,58,107,63,202,100,117,63,138,43,114,63,214,203,241,191,138,43,242,191,124,22,101,63,138,43,114,63], "i8", ALLOC_NONE, 5388884);
HEAP32[((5327280)>>2)]=((5251164)|0);
HEAP32[((5327284)>>2)]=((5251160)|0);
HEAP32[((5327296)>>2)]=((5250372)|0);
HEAP32[((5327300)>>2)]=((5250360)|0);
HEAP32[((5327312)>>2)]=((5250244)|0);
HEAP32[((5327316)>>2)]=((5250232)|0);
HEAP32[((5327344)>>2)]=((5250200)|0);
HEAP32[((5327348)>>2)]=((5250184)|0);
HEAP32[((5327360)>>2)]=((5250152)|0);
HEAP32[((5327364)>>2)]=((5250136)|0);
HEAP32[((5327376)>>2)]=((5250064)|0);
HEAP32[((5327380)>>2)]=((5250028)|0);
HEAP32[((5327392)>>2)]=((5249956)|0);
HEAP32[((5327396)>>2)]=((5249920)|0);
HEAP32[((5327408)>>2)]=((5249848)|0);
HEAP32[((5327412)>>2)]=((5249812)|0);
HEAP32[((5327424)>>2)]=((5254180)|0);
HEAP32[((5327428)>>2)]=((5254116)|0);
HEAP32[((5327440)>>2)]=((5253988)|0);
HEAP32[((5327444)>>2)]=((5253924)|0);
HEAP32[((5327456)>>2)]=((5253796)|0);
HEAP32[((5327460)>>2)]=((5253732)|0);
HEAP32[((5327472)>>2)]=((5253220)|0);
HEAP32[((5327476)>>2)]=((5252964)|0);
HEAP32[((5327492)>>2)]=((5251428)|0);
HEAP32[((5327504)>>2)]=((5252452)|0);
HEAP32[((5327508)>>2)]=((5252196)|0);
HEAP32[((5327520)>>2)]=((5251684)|0);
HEAP32[((5327524)>>2)]=((5251172)|0);
HEAP32[((5327536)>>2)]=((5251684)|0);
HEAP32[((5327540)>>2)]=((5251172)|0);
HEAP32[((5327552)>>2)]=((5251684)|0);
HEAP32[((5327556)>>2)]=((5251172)|0);
HEAP32[((5327568)>>2)]=((5251684)|0);
HEAP32[((5327572)>>2)]=((5251172)|0);
HEAP32[((5327584)>>2)]=((5251684)|0);
HEAP32[((5327588)>>2)]=((5251172)|0);
HEAP32[((5327600)>>2)]=((5251684)|0);
HEAP32[((5327604)>>2)]=((5251172)|0);
HEAP32[((5327616)>>2)]=((5251684)|0);
HEAP32[((5327620)>>2)]=((5251172)|0);
HEAP32[((5327632)>>2)]=((5251684)|0);
HEAP32[((5327636)>>2)]=((5251172)|0);
HEAP32[((5327648)>>2)]=((5250648)|0);
HEAP32[((5327652)>>2)]=((5250392)|0);
HEAP32[((5327664)>>2)]=((5250648)|0);
HEAP32[((5327668)>>2)]=((5250392)|0);
HEAP32[((5327680)>>2)]=((5250648)|0);
HEAP32[((5327684)>>2)]=((5250392)|0);
HEAP32[((5327696)>>2)]=((5250648)|0);
HEAP32[((5327700)>>2)]=((5250392)|0);
HEAP32[((5327712)>>2)]=((5250648)|0);
HEAP32[((5327716)>>2)]=((5250392)|0);
HEAP32[((5327728)>>2)]=((5250648)|0);
HEAP32[((5327732)>>2)]=((5250392)|0);
HEAP32[((5327744)>>2)]=((5250648)|0);
HEAP32[((5327748)>>2)]=((5250392)|0);
HEAP32[((5327760)>>2)]=((5250648)|0);
HEAP32[((5327764)>>2)]=((5250392)|0);
HEAP32[((5327776)>>2)]=((5250328)|0);
HEAP32[((5327780)>>2)]=((5250312)|0);
HEAP32[((5327792)>>2)]=((5250280)|0);
HEAP32[((5327796)>>2)]=((5250264)|0);
HEAP32[((5345208)>>2)]=((5387240)|0);
HEAP32[((5345212)>>2)]=((5387116)|0);
HEAP32[((5345216)>>2)]=((5386980)|0);
HEAP32[((5345220)>>2)]=((5386796)|0);
HEAP32[((5345224)>>2)]=((5386500)|0);
HEAP32[((5345228)>>2)]=((5386284)|0);
HEAP32[((5345232)>>2)]=((5386204)|0);
HEAP32[((5345236)>>2)]=((5386160)|0);
HEAP32[((5345240)>>2)]=((5386080)|0);
HEAP32[((5345244)>>2)]=((5385700)|0);
HEAP32[((5345248)>>2)]=((5385688)|0);
HEAP32[((5345252)>>2)]=((5385664)|0);
HEAP32[((5345256)>>2)]=((5385640)|0);
HEAP32[((5345260)>>2)]=((5385608)|0);
HEAP32[((5345264)>>2)]=((5385536)|0);
HEAP32[((5345268)>>2)]=((5385524)|0);
HEAP32[((5345272)>>2)]=((5385440)|0);
HEAP32[((5345276)>>2)]=((5385404)|0);
HEAP32[((5345280)>>2)]=((5385372)|0);
HEAP32[((5345284)>>2)]=((5385284)|0);
HEAP32[((5345288)>>2)]=((5385264)|0);
HEAP32[((5345292)>>2)]=((5385236)|0);
HEAP32[((5345296)>>2)]=((5385220)|0);
HEAP32[((5345300)>>2)]=((5385208)|0);
HEAP32[((5345304)>>2)]=((5385172)|0);
HEAP32[((5345308)>>2)]=((5385156)|0);
HEAP32[((5345312)>>2)]=((5385128)|0);
HEAP32[((5345316)>>2)]=((5385100)|0);
HEAP32[((5345320)>>2)]=((5385044)|0);
HEAP32[((5345324)>>2)]=((5384940)|0);
HEAP32[((5345328)>>2)]=((5384924)|0);
HEAP32[((5345332)>>2)]=((5384884)|0);
HEAP32[((5345336)>>2)]=((5384856)|0);
HEAP32[((5345340)>>2)]=((5384820)|0);
HEAP32[((5345344)>>2)]=((5384660)|0);
HEAP32[((5345348)>>2)]=((5384640)|0);
HEAP32[((5345352)>>2)]=((5384616)|0);
HEAP32[((5345356)>>2)]=((5384564)|0);
HEAP32[((5345360)>>2)]=((5384540)|0);
HEAP32[((5345364)>>2)]=((5384468)|0);
HEAP32[((5345368)>>2)]=((5384420)|0);
HEAP32[((5345372)>>2)]=((5384364)|0);
HEAP32[((5345376)>>2)]=((5384324)|0);
HEAP32[((5345380)>>2)]=((5384280)|0);
HEAP32[((5345384)>>2)]=((5384236)|0);
HEAP32[((5345388)>>2)]=((5384204)|0);
HEAP32[((5345392)>>2)]=((5384164)|0);
HEAP32[((5345396)>>2)]=((5384136)|0);
HEAP32[((5345400)>>2)]=((5384112)|0);
HEAP32[((5345404)>>2)]=((5384056)|0);
HEAP32[((5345408)>>2)]=((5384036)|0);
HEAP32[((5345412)>>2)]=((5383976)|0);
HEAP32[((5345416)>>2)]=((5383944)|0);
HEAP32[((5345420)>>2)]=((5383908)|0);
HEAP32[((5345424)>>2)]=((5383856)|0);
HEAP32[((5345428)>>2)]=((5383816)|0);
HEAP32[((5345432)>>2)]=((5383764)|0);
HEAP32[((5345436)>>2)]=((5383736)|0);
HEAP32[((5345440)>>2)]=((5383704)|0);
HEAP32[((5345444)>>2)]=((5383624)|0);
HEAP32[((5345448)>>2)]=((5383608)|0);
HEAP32[((5345452)>>2)]=((5383544)|0);
HEAP32[((5345456)>>2)]=((5383512)|0);
HEAP32[((5345460)>>2)]=((5383492)|0);
HEAP32[((5345464)>>2)]=((5383468)|0);
HEAP32[((5345468)>>2)]=((5383444)|0);
HEAP32[((5345472)>>2)]=((5383412)|0);
HEAP32[((5345476)>>2)]=((5383380)|0);
HEAP32[((5345480)>>2)]=((5383340)|0);
HEAP32[((5345484)>>2)]=((5383300)|0);
HEAP32[((5345488)>>2)]=((5383256)|0);
HEAP32[((5345492)>>2)]=((5383200)|0);
HEAP32[((5345496)>>2)]=((5383120)|0);
HEAP32[((5345500)>>2)]=((5383104)|0);
HEAP32[((5345504)>>2)]=((5383088)|0);
HEAP32[((5345508)>>2)]=((5383044)|0);
HEAP32[((5345512)>>2)]=((5383000)|0);
HEAP32[((5345516)>>2)]=((5382988)|0);
HEAP32[((5345520)>>2)]=((5382940)|0);
HEAP32[((5345524)>>2)]=((5382848)|0);
HEAP32[((5345528)>>2)]=((5382784)|0);
HEAP32[((5345532)>>2)]=((5382728)|0);
HEAP32[((5345536)>>2)]=((5382644)|0);
HEAP32[((5345540)>>2)]=((5382636)|0);
HEAP32[((5345544)>>2)]=((5382624)|0);
HEAP32[((5345548)>>2)]=((5382616)|0);
HEAP32[((5345552)>>2)]=((5382608)|0);
HEAP32[((5345556)>>2)]=((5382600)|0);
HEAP32[((5345560)>>2)]=((5382592)|0);
HEAP32[((5345564)>>2)]=((5387376)|0);
HEAP32[((5345568)>>2)]=((5387364)|0);
HEAP32[((5345572)>>2)]=((5387352)|0);
HEAP32[((5345576)>>2)]=((5387332)|0);
HEAP32[((5345580)>>2)]=((5387312)|0);
HEAP32[((5345584)>>2)]=((5387296)|0);
HEAP32[((5345588)>>2)]=((5387284)|0);
HEAP32[((5345592)>>2)]=((5387272)|0);
HEAP32[((5345596)>>2)]=((5387264)|0);
HEAP32[((5345600)>>2)]=((5387248)|0);
HEAP32[((5345604)>>2)]=((5387228)|0);
HEAP32[((5345608)>>2)]=((5387220)|0);
HEAP32[((5345612)>>2)]=((5387204)|0);
HEAP32[((5345616)>>2)]=((5387196)|0);
HEAP32[((5345620)>>2)]=((5387188)|0);
HEAP32[((5345624)>>2)]=((5387172)|0);
HEAP32[((5345628)>>2)]=((5387164)|0);
HEAP32[((5345632)>>2)]=((5387152)|0);
HEAP32[((5345636)>>2)]=((5387140)|0);
HEAP32[((5345640)>>2)]=((5387132)|0);
HEAP32[((5345644)>>2)]=((5387104)|0);
HEAP32[((5345648)>>2)]=((5387096)|0);
HEAP32[((5345652)>>2)]=((5387064)|0);
HEAP32[((5345656)>>2)]=((5387056)|0);
HEAP32[((5345660)>>2)]=((5387048)|0);
HEAP32[((5345664)>>2)]=((5387040)|0);
HEAP32[((5345668)>>2)]=((5387028)|0);
HEAP32[((5345672)>>2)]=((5387020)|0);
HEAP32[((5345676)>>2)]=((5387004)|0);
HEAP32[((5345680)>>2)]=((5386988)|0);
HEAP32[((5345684)>>2)]=((5386968)|0);
HEAP32[((5345688)>>2)]=((5386960)|0);
HEAP32[((5345692)>>2)]=((5386880)|0);
HEAP32[((5345696)>>2)]=((5386868)|0);
HEAP32[((5345700)>>2)]=((5386856)|0);
HEAP32[((5345704)>>2)]=((5386844)|0);
HEAP32[((5345708)>>2)]=((5386832)|0);
HEAP32[((5345712)>>2)]=((5386828)|0);
HEAP32[((5345716)>>2)]=((5386816)|0);
HEAP32[((5345720)>>2)]=((5386804)|0);
HEAP32[((5345724)>>2)]=((5386784)|0);
HEAP32[((5345728)>>2)]=((5386776)|0);
HEAP32[((5345732)>>2)]=((5386724)|0);
HEAP32[((5345736)>>2)]=((5386716)|0);
HEAP32[((5345740)>>2)]=((5386704)|0);
HEAP32[((5345744)>>2)]=((5386600)|0);
HEAP32[((5345748)>>2)]=((5386580)|0);
HEAP32[((5345752)>>2)]=((5386560)|0);
HEAP32[((5345756)>>2)]=((5386520)|0);
HEAP32[((5345760)>>2)]=((5386508)|0);
HEAP32[((5345764)>>2)]=((5386488)|0);
HEAP32[((5345768)>>2)]=((5386464)|0);
HEAP32[((5345772)>>2)]=((5386376)|0);
HEAP32[((5345776)>>2)]=((5386364)|0);
HEAP32[((5345780)>>2)]=((5386356)|0);
HEAP32[((5345784)>>2)]=((5386340)|0);
HEAP32[((5345788)>>2)]=((5386332)|0);
HEAP32[((5345792)>>2)]=((5386324)|0);
HEAP32[((5345796)>>2)]=((5386312)|0);
HEAP32[((5387980)>>2)]=(30);
HEAP32[((5387984)>>2)]=(12);
HEAP32[((5387988)>>2)]=(24);
HEAP32[((5388004)>>2)]=(30);
HEAP32[((5388008)>>2)]=(2);
HEAP32[((5388012)>>2)]=(44);
__ZTVN10__cxxabiv120__si_class_type_infoE=allocate([2,0,0,0], "i8", ALLOC_STATIC);
HEAP32[((5388064)>>2)]=(((__ZTVN10__cxxabiv120__si_class_type_infoE+8)|0));
HEAP32[((5388068)>>2)]=((5388020)|0);
HEAP32[((5388072)>>2)]=__ZTISt9exception;
HEAP32[((5388076)>>2)]=(((__ZTVN10__cxxabiv120__si_class_type_infoE+8)|0));
HEAP32[((5388080)>>2)]=((5388036)|0);
__ZNSt9bad_allocC1Ev = 10;
__ZNSt9bad_allocD1Ev = 30;
__ZNSt20bad_array_new_lengthC1Ev = 40;
__ZNSt20bad_array_new_lengthD1Ev = (30);
__ZNSt20bad_array_new_lengthD2Ev = (30);

  
  function _memcpy(dest, src, num) {
      dest = dest|0; src = src|0; num = num|0;
      var ret = 0;
      ret = dest|0;
      if ((dest&3) == (src&3)) {
        while (dest & 3) {
          if ((num|0) == 0) return ret|0;
          HEAP8[(dest)]=HEAP8[(src)];
          dest = (dest+1)|0;
          src = (src+1)|0;
          num = (num-1)|0;
        }
        while ((num|0) >= 4) {
          HEAP32[((dest)>>2)]=HEAP32[((src)>>2)];
          dest = (dest+4)|0;
          src = (src+4)|0;
          num = (num-4)|0;
        }
      }
      while ((num|0) > 0) {
        HEAP8[(dest)]=HEAP8[(src)];
        dest = (dest+1)|0;
        src = (src+1)|0;
        num = (num-1)|0;
      }
      return ret|0;
    }var _llvm_memcpy_p0i8_p0i8_i32;

  
  function _memset(ptr, value, num) {
      ptr = ptr|0; value = value|0; num = num|0;
      var stop = 0, value4 = 0, stop4 = 0, unaligned = 0;
      stop = (ptr + num)|0;
      if (num|0 >= 20) {
        // This is unaligned, but quite large, so work hard to get to aligned settings
        unaligned = ptr & 3;
        value4 = value | (value << 8) | (value << 16) | (value << 24);
        stop4 = stop & ~3;
        if (unaligned) {
          unaligned = (ptr + 4 - unaligned)|0;
          while ((ptr|0) < (unaligned|0)) { // no need to check for stop, since we have large num
            HEAP8[(ptr)]=value;
            ptr = (ptr+1)|0;
          }
        }
        while ((ptr|0) < (stop4|0)) {
          HEAP32[((ptr)>>2)]=value4;
          ptr = (ptr+4)|0;
        }
      }
      while ((ptr|0) < (stop|0)) {
        HEAP8[(ptr)]=value;
        ptr = (ptr+1)|0;
      }
    }var _llvm_memset_p0i8_i32;

  function _strlen(ptr) {
      ptr = ptr|0;
      var curr = 0;
      curr = ptr;
      while (HEAP8[(curr)]|0 != 0) {
        curr = (curr + 1)|0;
      }
      return (curr - ptr)|0;
    }

  var _cos=Math.cos;

  function _log10(x) {
      return Math.log(x) / Math.LN10;
    }

  
  function _memmove(dest, src, num) {
      dest = dest|0; src = src|0; num = num|0;
      if (((src|0) < (dest|0)) & ((dest|0) < ((src + num)|0))) {
        // Unlikely case: Copy backwards in a safe manner
        src = (src + num)|0;
        dest = (dest + num)|0;
        while ((num|0) > 0) {
          dest = (dest - 1)|0;
          src = (src - 1)|0;
          num = (num - 1)|0;
          HEAP8[(dest)]=HEAP8[(src)];
        }
      } else {
        _memcpy(dest, src, num);
      }
    }var _llvm_memmove_p0i8_p0i8_i32;

  var _ceil=Math.ceil;

  function _strncmp(px, py, n) {
      var i = 0;
      while (i < n) {
        var x = HEAPU8[((px)+(i))];
        var y = HEAPU8[((py)+(i))];
        if (x == y && x == 0) return 0;
        if (x == 0) return -1;
        if (y == 0) return 1;
        if (x == y) {
          i ++;
          continue;
        } else {
          return x > y ? 1 : -1;
        }
      }
      return 0;
    }

  
  
  
  function _isspace(chr) {
      return chr in { 32: 0, 9: 0, 10: 0, 11: 0, 12: 0, 13: 0 };
    }
  
  function ___setErrNo(value) {
      // For convenient setting and returning of errno.
      if (!___setErrNo.ret) ___setErrNo.ret = allocate([0], 'i32', ALLOC_STATIC);
      HEAP32[((___setErrNo.ret)>>2)]=value
      return value;
    }
  
  var ERRNO_CODES={E2BIG:7,EACCES:13,EADDRINUSE:98,EADDRNOTAVAIL:99,EAFNOSUPPORT:97,EAGAIN:11,EALREADY:114,EBADF:9,EBADMSG:74,EBUSY:16,ECANCELED:125,ECHILD:10,ECONNABORTED:103,ECONNREFUSED:111,ECONNRESET:104,EDEADLK:35,EDESTADDRREQ:89,EDOM:33,EDQUOT:122,EEXIST:17,EFAULT:14,EFBIG:27,EHOSTUNREACH:113,EIDRM:43,EILSEQ:84,EINPROGRESS:115,EINTR:4,EINVAL:22,EIO:5,EISCONN:106,EISDIR:21,ELOOP:40,EMFILE:24,EMLINK:31,EMSGSIZE:90,EMULTIHOP:72,ENAMETOOLONG:36,ENETDOWN:100,ENETRESET:102,ENETUNREACH:101,ENFILE:23,ENOBUFS:105,ENODATA:61,ENODEV:19,ENOENT:2,ENOEXEC:8,ENOLCK:37,ENOLINK:67,ENOMEM:12,ENOMSG:42,ENOPROTOOPT:92,ENOSPC:28,ENOSR:63,ENOSTR:60,ENOSYS:38,ENOTCONN:107,ENOTDIR:20,ENOTEMPTY:39,ENOTRECOVERABLE:131,ENOTSOCK:88,ENOTSUP:95,ENOTTY:25,ENXIO:6,EOVERFLOW:75,EOWNERDEAD:130,EPERM:1,EPIPE:32,EPROTO:71,EPROTONOSUPPORT:93,EPROTOTYPE:91,ERANGE:34,EROFS:30,ESPIPE:29,ESRCH:3,ESTALE:116,ETIME:62,ETIMEDOUT:110,ETXTBSY:26,EWOULDBLOCK:11,EXDEV:18};function __parseInt(str, endptr, base, min, max, bits, unsign) {
      // Skip space.
      while (_isspace(HEAP8[(str)])) str++;
  
      // Check for a plus/minus sign.
      var multiplier = 1;
      if (HEAP8[(str)] == '-'.charCodeAt(0)) {
        multiplier = -1;
        str++;
      } else if (HEAP8[(str)] == '+'.charCodeAt(0)) {
        str++;
      }
  
      // Find base.
      var finalBase = base;
      if (!finalBase) {
        if (HEAP8[(str)] == '0'.charCodeAt(0)) {
          if (HEAP8[(str+1)] == 'x'.charCodeAt(0) ||
              HEAP8[(str+1)] == 'X'.charCodeAt(0)) {
            finalBase = 16;
            str += 2;
          } else {
            finalBase = 8;
            str++;
          }
        }
      }
      if (!finalBase) finalBase = 10;
  
      // Get digits.
      var chr;
      var ret = 0;
      while ((chr = HEAP8[(str)]) != 0) {
        var digit = parseInt(String.fromCharCode(chr), finalBase);
        if (isNaN(digit)) {
          break;
        } else {
          ret = ret * finalBase + digit;
          str++;
        }
      }
  
      // Apply sign.
      ret *= multiplier;
  
      // Set end pointer.
      if (endptr) {
        HEAP32[((endptr)>>2)]=str
      }
  
      // Unsign if needed.
      if (unsign) {
        if (Math.abs(ret) > max) {
          ret = max;
          ___setErrNo(ERRNO_CODES.ERANGE);
        } else {
          ret = unSign(ret, bits);
        }
      }
  
      // Validate range.
      if (ret > max || ret < min) {
        ret = ret > max ? max : min;
        ___setErrNo(ERRNO_CODES.ERANGE);
      }
  
      if (bits == 64) {
        return (tempRet0 = Math.min(Math.floor((ret)/4294967296), 4294967295)>>>0,ret>>>0);
      }
  
      return ret;
    }function _strtol(str, endptr, base) {
      return __parseInt(str, endptr, base, -2147483648, 2147483647, 32);  // LONG_MIN, LONG_MAX.
    }function _atoi(ptr) {
      return _strtol(ptr, null, 10);
    }

  function _strchr(ptr, chr) {
      ptr--;
      do {
        ptr++;
        var val = HEAP8[(ptr)];
        if (val == chr) return ptr;
      } while (val);
      return 0;
    }

  
  
  function __formatString(format, varargs) {
      var textIndex = format;
      var argIndex = 0;
      function getNextArg(type) {
        // NOTE: Explicitly ignoring type safety. Otherwise this fails:
        //       int x = 4; printf("%c\n", (char)x);
        var ret;
        if (type === 'double') {
          ret = (HEAP32[((tempDoublePtr)>>2)]=HEAP32[(((varargs)+(argIndex))>>2)],HEAP32[(((tempDoublePtr)+(4))>>2)]=HEAP32[(((varargs)+((argIndex)+(4)))>>2)],HEAPF64[(tempDoublePtr)>>3]);
        } else if (type == 'i64') {
          ret = [HEAP32[(((varargs)+(argIndex))>>2)],
                 HEAP32[(((varargs)+(argIndex+4))>>2)]];
        } else {
          type = 'i32'; // varargs are always i32, i64, or double
          ret = HEAP32[(((varargs)+(argIndex))>>2)];
        }
        argIndex += Runtime.getNativeFieldSize(type);
        return ret;
      }
  
      var ret = [];
      var curr, next, currArg;
      while(1) {
        var startTextIndex = textIndex;
        curr = HEAP8[(textIndex)];
        if (curr === 0) break;
        next = HEAP8[(textIndex+1)];
        if (curr == '%'.charCodeAt(0)) {
          // Handle flags.
          var flagAlwaysSigned = false;
          var flagLeftAlign = false;
          var flagAlternative = false;
          var flagZeroPad = false;
          flagsLoop: while (1) {
            switch (next) {
              case '+'.charCodeAt(0):
                flagAlwaysSigned = true;
                break;
              case '-'.charCodeAt(0):
                flagLeftAlign = true;
                break;
              case '#'.charCodeAt(0):
                flagAlternative = true;
                break;
              case '0'.charCodeAt(0):
                if (flagZeroPad) {
                  break flagsLoop;
                } else {
                  flagZeroPad = true;
                  break;
                }
              default:
                break flagsLoop;
            }
            textIndex++;
            next = HEAP8[(textIndex+1)];
          }
  
          // Handle width.
          var width = 0;
          if (next == '*'.charCodeAt(0)) {
            width = getNextArg('i32');
            textIndex++;
            next = HEAP8[(textIndex+1)];
          } else {
            while (next >= '0'.charCodeAt(0) && next <= '9'.charCodeAt(0)) {
              width = width * 10 + (next - '0'.charCodeAt(0));
              textIndex++;
              next = HEAP8[(textIndex+1)];
            }
          }
  
          // Handle precision.
          var precisionSet = false;
          if (next == '.'.charCodeAt(0)) {
            var precision = 0;
            precisionSet = true;
            textIndex++;
            next = HEAP8[(textIndex+1)];
            if (next == '*'.charCodeAt(0)) {
              precision = getNextArg('i32');
              textIndex++;
            } else {
              while(1) {
                var precisionChr = HEAP8[(textIndex+1)];
                if (precisionChr < '0'.charCodeAt(0) ||
                    precisionChr > '9'.charCodeAt(0)) break;
                precision = precision * 10 + (precisionChr - '0'.charCodeAt(0));
                textIndex++;
              }
            }
            next = HEAP8[(textIndex+1)];
          } else {
            var precision = 6; // Standard default.
          }
  
          // Handle integer sizes. WARNING: These assume a 32-bit architecture!
          var argSize;
          switch (String.fromCharCode(next)) {
            case 'h':
              var nextNext = HEAP8[(textIndex+2)];
              if (nextNext == 'h'.charCodeAt(0)) {
                textIndex++;
                argSize = 1; // char (actually i32 in varargs)
              } else {
                argSize = 2; // short (actually i32 in varargs)
              }
              break;
            case 'l':
              var nextNext = HEAP8[(textIndex+2)];
              if (nextNext == 'l'.charCodeAt(0)) {
                textIndex++;
                argSize = 8; // long long
              } else {
                argSize = 4; // long
              }
              break;
            case 'L': // long long
            case 'q': // int64_t
            case 'j': // intmax_t
              argSize = 8;
              break;
            case 'z': // size_t
            case 't': // ptrdiff_t
            case 'I': // signed ptrdiff_t or unsigned size_t
              argSize = 4;
              break;
            default:
              argSize = null;
          }
          if (argSize) textIndex++;
          next = HEAP8[(textIndex+1)];
  
          // Handle type specifier.
          if (['d', 'i', 'u', 'o', 'x', 'X', 'p'].indexOf(String.fromCharCode(next)) != -1) {
            // Integer.
            var signed = next == 'd'.charCodeAt(0) || next == 'i'.charCodeAt(0);
            argSize = argSize || 4;
            var currArg = getNextArg('i' + (argSize * 8));
            var origArg = currArg;
            var argText;
            // Flatten i64-1 [low, high] into a (slightly rounded) double
            if (argSize == 8) {
              currArg = Runtime.makeBigInt(currArg[0], currArg[1], next == 'u'.charCodeAt(0));
            }
            // Truncate to requested size.
            if (argSize <= 4) {
              var limit = Math.pow(256, argSize) - 1;
              currArg = (signed ? reSign : unSign)(currArg & limit, argSize * 8);
            }
            // Format the number.
            var currAbsArg = Math.abs(currArg);
            var prefix = '';
            if (next == 'd'.charCodeAt(0) || next == 'i'.charCodeAt(0)) {
              if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], null); else
              argText = reSign(currArg, 8 * argSize, 1).toString(10);
            } else if (next == 'u'.charCodeAt(0)) {
              if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], true); else
              argText = unSign(currArg, 8 * argSize, 1).toString(10);
              currArg = Math.abs(currArg);
            } else if (next == 'o'.charCodeAt(0)) {
              argText = (flagAlternative ? '0' : '') + currAbsArg.toString(8);
            } else if (next == 'x'.charCodeAt(0) || next == 'X'.charCodeAt(0)) {
              prefix = flagAlternative ? '0x' : '';
              if (argSize == 8 && i64Math) argText = (origArg[1]>>>0).toString(16) + (origArg[0]>>>0).toString(16); else
              if (currArg < 0) {
                // Represent negative numbers in hex as 2's complement.
                currArg = -currArg;
                argText = (currAbsArg - 1).toString(16);
                var buffer = [];
                for (var i = 0; i < argText.length; i++) {
                  buffer.push((0xF - parseInt(argText[i], 16)).toString(16));
                }
                argText = buffer.join('');
                while (argText.length < argSize * 2) argText = 'f' + argText;
              } else {
                argText = currAbsArg.toString(16);
              }
              if (next == 'X'.charCodeAt(0)) {
                prefix = prefix.toUpperCase();
                argText = argText.toUpperCase();
              }
            } else if (next == 'p'.charCodeAt(0)) {
              if (currAbsArg === 0) {
                argText = '(nil)';
              } else {
                prefix = '0x';
                argText = currAbsArg.toString(16);
              }
            }
            if (precisionSet) {
              while (argText.length < precision) {
                argText = '0' + argText;
              }
            }
  
            // Add sign if needed
            if (flagAlwaysSigned) {
              if (currArg < 0) {
                prefix = '-' + prefix;
              } else {
                prefix = '+' + prefix;
              }
            }
  
            // Add padding.
            while (prefix.length + argText.length < width) {
              if (flagLeftAlign) {
                argText += ' ';
              } else {
                if (flagZeroPad) {
                  argText = '0' + argText;
                } else {
                  prefix = ' ' + prefix;
                }
              }
            }
  
            // Insert the result into the buffer.
            argText = prefix + argText;
            argText.split('').forEach(function(chr) {
              ret.push(chr.charCodeAt(0));
            });
          } else if (['f', 'F', 'e', 'E', 'g', 'G'].indexOf(String.fromCharCode(next)) != -1) {
            // Float.
            var currArg = getNextArg('double');
            var argText;
  
            if (isNaN(currArg)) {
              argText = 'nan';
              flagZeroPad = false;
            } else if (!isFinite(currArg)) {
              argText = (currArg < 0 ? '-' : '') + 'inf';
              flagZeroPad = false;
            } else {
              var isGeneral = false;
              var effectivePrecision = Math.min(precision, 20);
  
              // Convert g/G to f/F or e/E, as per:
              // http://pubs.opengroup.org/onlinepubs/9699919799/functions/printf.html
              if (next == 'g'.charCodeAt(0) || next == 'G'.charCodeAt(0)) {
                isGeneral = true;
                precision = precision || 1;
                var exponent = parseInt(currArg.toExponential(effectivePrecision).split('e')[1], 10);
                if (precision > exponent && exponent >= -4) {
                  next = ((next == 'g'.charCodeAt(0)) ? 'f' : 'F').charCodeAt(0);
                  precision -= exponent + 1;
                } else {
                  next = ((next == 'g'.charCodeAt(0)) ? 'e' : 'E').charCodeAt(0);
                  precision--;
                }
                effectivePrecision = Math.min(precision, 20);
              }
  
              if (next == 'e'.charCodeAt(0) || next == 'E'.charCodeAt(0)) {
                argText = currArg.toExponential(effectivePrecision);
                // Make sure the exponent has at least 2 digits.
                if (/[eE][-+]\d$/.test(argText)) {
                  argText = argText.slice(0, -1) + '0' + argText.slice(-1);
                }
              } else if (next == 'f'.charCodeAt(0) || next == 'F'.charCodeAt(0)) {
                argText = currArg.toFixed(effectivePrecision);
              }
  
              var parts = argText.split('e');
              if (isGeneral && !flagAlternative) {
                // Discard trailing zeros and periods.
                while (parts[0].length > 1 && parts[0].indexOf('.') != -1 &&
                       (parts[0].slice(-1) == '0' || parts[0].slice(-1) == '.')) {
                  parts[0] = parts[0].slice(0, -1);
                }
              } else {
                // Make sure we have a period in alternative mode.
                if (flagAlternative && argText.indexOf('.') == -1) parts[0] += '.';
                // Zero pad until required precision.
                while (precision > effectivePrecision++) parts[0] += '0';
              }
              argText = parts[0] + (parts.length > 1 ? 'e' + parts[1] : '');
  
              // Capitalize 'E' if needed.
              if (next == 'E'.charCodeAt(0)) argText = argText.toUpperCase();
  
              // Add sign.
              if (flagAlwaysSigned && currArg >= 0) {
                argText = '+' + argText;
              }
            }
  
            // Add padding.
            while (argText.length < width) {
              if (flagLeftAlign) {
                argText += ' ';
              } else {
                if (flagZeroPad && (argText[0] == '-' || argText[0] == '+')) {
                  argText = argText[0] + '0' + argText.slice(1);
                } else {
                  argText = (flagZeroPad ? '0' : ' ') + argText;
                }
              }
            }
  
            // Adjust case.
            if (next < 'a'.charCodeAt(0)) argText = argText.toUpperCase();
  
            // Insert the result into the buffer.
            argText.split('').forEach(function(chr) {
              ret.push(chr.charCodeAt(0));
            });
          } else if (next == 's'.charCodeAt(0)) {
            // String.
            var arg = getNextArg('i8*') || nullString;
            var argLength = _strlen(arg);
            if (precisionSet) argLength = Math.min(argLength, precision);
            if (!flagLeftAlign) {
              while (argLength < width--) {
                ret.push(' '.charCodeAt(0));
              }
            }
            for (var i = 0; i < argLength; i++) {
              ret.push(HEAPU8[(arg++)]);
            }
            if (flagLeftAlign) {
              while (argLength < width--) {
                ret.push(' '.charCodeAt(0));
              }
            }
          } else if (next == 'c'.charCodeAt(0)) {
            // Character.
            if (flagLeftAlign) ret.push(getNextArg('i8'));
            while (--width > 0) {
              ret.push(' '.charCodeAt(0));
            }
            if (!flagLeftAlign) ret.push(getNextArg('i8'));
          } else if (next == 'n'.charCodeAt(0)) {
            // Write the length written so far to the next parameter.
            var ptr = getNextArg('i32*');
            HEAP32[((ptr)>>2)]=ret.length
          } else if (next == '%'.charCodeAt(0)) {
            // Literal percent sign.
            ret.push(curr);
          } else {
            // Unknown specifiers remain untouched.
            for (var i = startTextIndex; i < textIndex + 2; i++) {
              ret.push(HEAP8[(i)]);
            }
          }
          textIndex += 2;
          // TODO: Support a/A (hex float) and m (last error) specifiers.
          // TODO: Support %1${specifier} for arg selection.
        } else {
          ret.push(curr);
          textIndex += 1;
        }
      }
      return ret;
    }function _snprintf(s, n, format, varargs) {
      // int snprintf(char *restrict s, size_t n, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      var result = __formatString(format, varargs);
      var limit = (n === undefined) ? result.length
                                    : Math.min(result.length, Math.max(n - 1, 0));
      if (s < 0) {
        s = -s;
        var buf = _malloc(limit+1);
        HEAP32[((s)>>2)]=buf;
        s = buf;
      }
      for (var i = 0; i < limit; i++) {
        HEAP8[((s)+(i))]=result[i];
      }
      if (limit < n || (n === undefined)) HEAP8[((s)+(i))]=0;
      return result.length;
    }function _sprintf(s, format, varargs) {
      // int sprintf(char *restrict s, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      return _snprintf(s, undefined, format, varargs);
    }


  function _toupper(chr) {
      if (chr >= 'a'.charCodeAt(0) && chr <= 'z'.charCodeAt(0)) {
        return chr - 'a'.charCodeAt(0) + 'A'.charCodeAt(0);
      } else {
        return chr;
      }
    }

  function _tolower(chr) {
      if (chr >= 'A'.charCodeAt(0) && chr <= 'Z'.charCodeAt(0)) {
        return chr - 'A'.charCodeAt(0) + 'a'.charCodeAt(0);
      } else {
        return chr;
      }
    }

  var _fabs=Math.abs;

  var _llvm_pow_f64=Math.pow;

  var _llvm_pow_f32=Math.pow;

  
  
  var _stdin=allocate(1, "i32*", ALLOC_STACK);
  
  var _stdout=allocate(1, "i32*", ALLOC_STACK);
  
  var _stderr=allocate(1, "i32*", ALLOC_STACK);
  
  var __impure_ptr=allocate(1, "i32*", ALLOC_STACK);var FS={currentPath:"/",nextInode:2,streams:[null],ignorePermissions:true,joinPath:function (parts, forceRelative) {
        var ret = parts[0];
        for (var i = 1; i < parts.length; i++) {
          if (ret[ret.length-1] != '/') ret += '/';
          ret += parts[i];
        }
        if (forceRelative && ret[0] == '/') ret = ret.substr(1);
        return ret;
      },absolutePath:function (relative, base) {
        if (typeof relative !== 'string') return null;
        if (base === undefined) base = FS.currentPath;
        if (relative && relative[0] == '/') base = '';
        var full = base + '/' + relative;
        var parts = full.split('/').reverse();
        var absolute = [''];
        while (parts.length) {
          var part = parts.pop();
          if (part == '' || part == '.') {
            // Nothing.
          } else if (part == '..') {
            if (absolute.length > 1) absolute.pop();
          } else {
            absolute.push(part);
          }
        }
        return absolute.length == 1 ? '/' : absolute.join('/');
      },analyzePath:function (path, dontResolveLastLink, linksVisited) {
        var ret = {
          isRoot: false,
          exists: false,
          error: 0,
          name: null,
          path: null,
          object: null,
          parentExists: false,
          parentPath: null,
          parentObject: null
        };
        path = FS.absolutePath(path);
        if (path == '/') {
          ret.isRoot = true;
          ret.exists = ret.parentExists = true;
          ret.name = '/';
          ret.path = ret.parentPath = '/';
          ret.object = ret.parentObject = FS.root;
        } else if (path !== null) {
          linksVisited = linksVisited || 0;
          path = path.slice(1).split('/');
          var current = FS.root;
          var traversed = [''];
          while (path.length) {
            if (path.length == 1 && current.isFolder) {
              ret.parentExists = true;
              ret.parentPath = traversed.length == 1 ? '/' : traversed.join('/');
              ret.parentObject = current;
              ret.name = path[0];
            }
            var target = path.shift();
            if (!current.isFolder) {
              ret.error = ERRNO_CODES.ENOTDIR;
              break;
            } else if (!current.read) {
              ret.error = ERRNO_CODES.EACCES;
              break;
            } else if (!current.contents.hasOwnProperty(target)) {
              ret.error = ERRNO_CODES.ENOENT;
              break;
            }
            current = current.contents[target];
            if (current.link && !(dontResolveLastLink && path.length == 0)) {
              if (linksVisited > 40) { // Usual Linux SYMLOOP_MAX.
                ret.error = ERRNO_CODES.ELOOP;
                break;
              }
              var link = FS.absolutePath(current.link, traversed.join('/'));
              ret = FS.analyzePath([link].concat(path).join('/'),
                                   dontResolveLastLink, linksVisited + 1);
              return ret;
            }
            traversed.push(target);
            if (path.length == 0) {
              ret.exists = true;
              ret.path = traversed.join('/');
              ret.object = current;
            }
          }
        }
        return ret;
      },findObject:function (path, dontResolveLastLink) {
        FS.ensureRoot();
        var ret = FS.analyzePath(path, dontResolveLastLink);
        if (ret.exists) {
          return ret.object;
        } else {
          ___setErrNo(ret.error);
          return null;
        }
      },createObject:function (parent, name, properties, canRead, canWrite) {
        if (!parent) parent = '/';
        if (typeof parent === 'string') parent = FS.findObject(parent);
  
        if (!parent) {
          ___setErrNo(ERRNO_CODES.EACCES);
          throw new Error('Parent path must exist.');
        }
        if (!parent.isFolder) {
          ___setErrNo(ERRNO_CODES.ENOTDIR);
          throw new Error('Parent must be a folder.');
        }
        if (!parent.write && !FS.ignorePermissions) {
          ___setErrNo(ERRNO_CODES.EACCES);
          throw new Error('Parent folder must be writeable.');
        }
        if (!name || name == '.' || name == '..') {
          ___setErrNo(ERRNO_CODES.ENOENT);
          throw new Error('Name must not be empty.');
        }
        if (parent.contents.hasOwnProperty(name)) {
          ___setErrNo(ERRNO_CODES.EEXIST);
          throw new Error("Can't overwrite object.");
        }
  
        parent.contents[name] = {
          read: canRead === undefined ? true : canRead,
          write: canWrite === undefined ? false : canWrite,
          timestamp: Date.now(),
          inodeNumber: FS.nextInode++
        };
        for (var key in properties) {
          if (properties.hasOwnProperty(key)) {
            parent.contents[name][key] = properties[key];
          }
        }
  
        return parent.contents[name];
      },createFolder:function (parent, name, canRead, canWrite) {
        var properties = {isFolder: true, isDevice: false, contents: {}};
        return FS.createObject(parent, name, properties, canRead, canWrite);
      },createPath:function (parent, path, canRead, canWrite) {
        var current = FS.findObject(parent);
        if (current === null) throw new Error('Invalid parent.');
        path = path.split('/').reverse();
        while (path.length) {
          var part = path.pop();
          if (!part) continue;
          if (!current.contents.hasOwnProperty(part)) {
            FS.createFolder(current, part, canRead, canWrite);
          }
          current = current.contents[part];
        }
        return current;
      },createFile:function (parent, name, properties, canRead, canWrite) {
        properties.isFolder = false;
        return FS.createObject(parent, name, properties, canRead, canWrite);
      },createDataFile:function (parent, name, data, canRead, canWrite) {
        if (typeof data === 'string') {
          var dataArray = new Array(data.length);
          for (var i = 0, len = data.length; i < len; ++i) dataArray[i] = data.charCodeAt(i);
          data = dataArray;
        }
        var properties = {
          isDevice: false,
          contents: data.subarray ? data.subarray(0) : data // as an optimization, create a new array wrapper (not buffer) here, to help JS engines understand this object
        };
        return FS.createFile(parent, name, properties, canRead, canWrite);
      },createLazyFile:function (parent, name, url, canRead, canWrite) {
  
        if (typeof XMLHttpRequest !== 'undefined') {
          if (!ENVIRONMENT_IS_WORKER) throw 'Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc';
          // Lazy chunked Uint8Array (implements get and length from Uint8Array). Actual getting is abstracted away for eventual reuse.
          var LazyUint8Array = function(chunkSize, length) {
            this.length = length;
            this.chunkSize = chunkSize;
            this.chunks = []; // Loaded chunks. Index is the chunk number
          }
          LazyUint8Array.prototype.get = function(idx) {
            if (idx > this.length-1 || idx < 0) {
              return undefined;
            }
            var chunkOffset = idx % chunkSize;
            var chunkNum = Math.floor(idx / chunkSize);
            return this.getter(chunkNum)[chunkOffset];
          }
          LazyUint8Array.prototype.setDataGetter = function(getter) {
            this.getter = getter;
          }
    
          // Find length
          var xhr = new XMLHttpRequest();
          xhr.open('HEAD', url, false);
          xhr.send(null);
          if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
          var datalength = Number(xhr.getResponseHeader("Content-length"));
          var header;
          var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
          var chunkSize = 1024*1024; // Chunk size in bytes
          if (!hasByteServing) chunkSize = datalength;
    
          // Function to get a range from the remote URL.
          var doXHR = (function(from, to) {
            if (from > to) throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
            if (to > datalength-1) throw new Error("only " + datalength + " bytes available! programmer error!");
    
            // TODO: Use mozResponseArrayBuffer, responseStream, etc. if available.
            var xhr = new XMLHttpRequest();
            xhr.open('GET', url, false);
            if (datalength !== chunkSize) xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);
    
            // Some hints to the browser that we want binary data.
            if (typeof Uint8Array != 'undefined') xhr.responseType = 'arraybuffer';
            if (xhr.overrideMimeType) {
              xhr.overrideMimeType('text/plain; charset=x-user-defined');
            }
    
            xhr.send(null);
            if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
            if (xhr.response !== undefined) {
              return new Uint8Array(xhr.response || []);
            } else {
              return intArrayFromString(xhr.responseText || '', true);
            }
          });
    
          var lazyArray = new LazyUint8Array(chunkSize, datalength);
          lazyArray.setDataGetter(function(chunkNum) {
            var start = chunkNum * lazyArray.chunkSize;
            var end = (chunkNum+1) * lazyArray.chunkSize - 1; // including this byte
            end = Math.min(end, datalength-1); // if datalength-1 is selected, this is the last block
            if (typeof(lazyArray.chunks[chunkNum]) === "undefined") {
              lazyArray.chunks[chunkNum] = doXHR(start, end);
            }
            if (typeof(lazyArray.chunks[chunkNum]) === "undefined") throw new Error("doXHR failed!");
            return lazyArray.chunks[chunkNum];
          });
          var properties = { isDevice: false, contents: lazyArray };
        } else {
          var properties = { isDevice: false, url: url };
        }
  
        return FS.createFile(parent, name, properties, canRead, canWrite);
      },createPreloadedFile:function (parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile) {
        Browser.ensureObjects();
        var fullname = FS.joinPath([parent, name], true);
        function processData(byteArray) {
          function finish(byteArray) {
            if (!dontCreateFile) {
              FS.createDataFile(parent, name, byteArray, canRead, canWrite);
            }
            if (onload) onload();
            removeRunDependency('cp ' + fullname);
          }
          var handled = false;
          Module['preloadPlugins'].forEach(function(plugin) {
            if (handled) return;
            if (plugin['canHandle'](fullname)) {
              plugin['handle'](byteArray, fullname, finish, function() {
                if (onerror) onerror();
                removeRunDependency('cp ' + fullname);
              });
              handled = true;
            }
          });
          if (!handled) finish(byteArray);
        }
        addRunDependency('cp ' + fullname);
        if (typeof url == 'string') {
          Browser.asyncLoad(url, function(byteArray) {
            processData(byteArray);
          }, onerror);
        } else {
          processData(url);
        }
      },createLink:function (parent, name, target, canRead, canWrite) {
        var properties = {isDevice: false, link: target};
        return FS.createFile(parent, name, properties, canRead, canWrite);
      },createDevice:function (parent, name, input, output) {
        if (!(input || output)) {
          throw new Error('A device must have at least one callback defined.');
        }
        var ops = {isDevice: true, input: input, output: output};
        return FS.createFile(parent, name, ops, Boolean(input), Boolean(output));
      },forceLoadFile:function (obj) {
        if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
        var success = true;
        if (typeof XMLHttpRequest !== 'undefined') {
          throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
        } else if (Module['read']) {
          // Command-line.
          try {
            // WARNING: Can't read binary files in V8's d8 or tracemonkey's js, as
            //          read() will try to parse UTF8.
            obj.contents = intArrayFromString(Module['read'](obj.url), true);
          } catch (e) {
            success = false;
          }
        } else {
          throw new Error('Cannot load without read() or XMLHttpRequest.');
        }
        if (!success) ___setErrNo(ERRNO_CODES.EIO);
        return success;
      },ensureRoot:function () {
        if (FS.root) return;
        // The main file system tree. All the contents are inside this.
        FS.root = {
          read: true,
          write: true,
          isFolder: true,
          isDevice: false,
          timestamp: Date.now(),
          inodeNumber: 1,
          contents: {}
        };
      },init:function (input, output, error) {
        // Make sure we initialize only once.
        assert(!FS.init.initialized, 'FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)');
        FS.init.initialized = true;
  
        FS.ensureRoot();
  
        // Allow Module.stdin etc. to provide defaults, if none explicitly passed to us here
        input = input || Module['stdin'];
        output = output || Module['stdout'];
        error = error || Module['stderr'];
  
        // Default handlers.
        var stdinOverridden = true, stdoutOverridden = true, stderrOverridden = true;
        if (!input) {
          stdinOverridden = false;
          input = function() {
            if (!input.cache || !input.cache.length) {
              var result;
              if (typeof window != 'undefined' &&
                  typeof window.prompt == 'function') {
                // Browser.
                result = window.prompt('Input: ');
                if (result === null) result = String.fromCharCode(0); // cancel ==> EOF
              } else if (typeof readline == 'function') {
                // Command line.
                result = readline();
              }
              if (!result) result = '';
              input.cache = intArrayFromString(result + '\n', true);
            }
            return input.cache.shift();
          };
        }
        var utf8 = new Runtime.UTF8Processor();
        function simpleOutput(val) {
          if (val === null || val === '\n'.charCodeAt(0)) {
            output.printer(output.buffer.join(''));
            output.buffer = [];
          } else {
            output.buffer.push(utf8.processCChar(val));
          }
        }
        if (!output) {
          stdoutOverridden = false;
          output = simpleOutput;
        }
        if (!output.printer) output.printer = Module['print'];
        if (!output.buffer) output.buffer = [];
        if (!error) {
          stderrOverridden = false;
          error = simpleOutput;
        }
        if (!error.printer) error.printer = Module['print'];
        if (!error.buffer) error.buffer = [];
  
        // Create the temporary folder, if not already created
        try {
          FS.createFolder('/', 'tmp', true, true);
        } catch(e) {}
  
        // Create the I/O devices.
        var devFolder = FS.createFolder('/', 'dev', true, true);
        var stdin = FS.createDevice(devFolder, 'stdin', input);
        var stdout = FS.createDevice(devFolder, 'stdout', null, output);
        var stderr = FS.createDevice(devFolder, 'stderr', null, error);
        FS.createDevice(devFolder, 'tty', input, output);
  
        // Create default streams.
        FS.streams[1] = {
          path: '/dev/stdin',
          object: stdin,
          position: 0,
          isRead: true,
          isWrite: false,
          isAppend: false,
          isTerminal: !stdinOverridden,
          error: false,
          eof: false,
          ungotten: []
        };
        FS.streams[2] = {
          path: '/dev/stdout',
          object: stdout,
          position: 0,
          isRead: false,
          isWrite: true,
          isAppend: false,
          isTerminal: !stdoutOverridden,
          error: false,
          eof: false,
          ungotten: []
        };
        FS.streams[3] = {
          path: '/dev/stderr',
          object: stderr,
          position: 0,
          isRead: false,
          isWrite: true,
          isAppend: false,
          isTerminal: !stderrOverridden,
          error: false,
          eof: false,
          ungotten: []
        };
        assert(Math.max(_stdin, _stdout, _stderr) < 128); // make sure these are low, we flatten arrays with these
        HEAP32[((_stdin)>>2)]=1;
        HEAP32[((_stdout)>>2)]=2;
        HEAP32[((_stderr)>>2)]=3;
  
        // Other system paths
        FS.createPath('/', 'dev/shm/tmp', true, true); // temp files
  
        // Newlib initialization
        for (var i = FS.streams.length; i < Math.max(_stdin, _stdout, _stderr) + 4; i++) {
          FS.streams[i] = null; // Make sure to keep FS.streams dense
        }
        FS.streams[_stdin] = FS.streams[1];
        FS.streams[_stdout] = FS.streams[2];
        FS.streams[_stderr] = FS.streams[3];
        allocate([ allocate(
          [0, 0, 0, 0, _stdin, 0, 0, 0, _stdout, 0, 0, 0, _stderr, 0, 0, 0],
          'void*', ALLOC_STATIC) ], 'void*', ALLOC_NONE, __impure_ptr);
      },quit:function () {
        if (!FS.init.initialized) return;
        // Flush any partially-printed lines in stdout and stderr. Careful, they may have been closed
        if (FS.streams[2] && FS.streams[2].object.output.buffer.length > 0) FS.streams[2].object.output('\n'.charCodeAt(0));
        if (FS.streams[3] && FS.streams[3].object.output.buffer.length > 0) FS.streams[3].object.output('\n'.charCodeAt(0));
      },standardizePath:function (path) {
        if (path.substr(0, 2) == './') path = path.substr(2);
        return path;
      },deleteFile:function (path) {
        path = FS.analyzePath(path);
        if (!path.parentExists || !path.exists) {
          throw 'Invalid path ' + path;
        }
        delete path.parentObject.contents[path.name];
      }};
  
  function _lseek(fildes, offset, whence) {
      // off_t lseek(int fildes, off_t offset, int whence);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/lseek.html
      if (FS.streams[fildes] && !FS.streams[fildes].object.isDevice) {
        var stream = FS.streams[fildes];
        var position = offset;
        if (whence === 1) {  // SEEK_CUR.
          position += stream.position;
        } else if (whence === 2) {  // SEEK_END.
          position += stream.object.contents.length;
        }
        if (position < 0) {
          ___setErrNo(ERRNO_CODES.EINVAL);
          return -1;
        } else {
          stream.ungotten = [];
          stream.position = position;
          return position;
        }
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
    }function _fseek(stream, offset, whence) {
      // int fseek(FILE *stream, long offset, int whence);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fseek.html
      var ret = _lseek(stream, offset, whence);
      if (ret == -1) {
        return -1;
      } else {
        FS.streams[stream].eof = false;
        return 0;
      }
    }

  var _floor=Math.floor;

  function _strcat(pdest, psrc) {
      var len = _strlen(pdest);
      var i = 0;
      do {
        HEAP8[(pdest+len+i)]=HEAP8[(psrc+i)];
        i ++;
      } while (HEAP8[((psrc)+(i-1))] != 0);
      return pdest;
    }
var _ExitMP3; // stub for _ExitMP3
var _InitMP3; // stub for _InitMP3
var _decodeMP3; // stub for _decodeMP3
var _decodeMP3_unclipped; // stub for _decodeMP3_unclipped

  var _log=Math.log;

  var _exp=Math.exp;

  var _sqrt=Math.sqrt;

  
  function __exit(status) {
      // void _exit(int status);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/exit.html
  
  
      exitRuntime();
      ABORT = true;
  
      throw 'exit(' + status + ') called, at ' + new Error().stack;
    }function _exit(status) {
      __exit(status);
    }

  function _qsort(base, num, size, cmp) {
      if (num == 0 || size == 0) return;
      // forward calls to the JavaScript sort method
      // first, sort the items logically
      var comparator = function(x, y) {
        return Runtime.dynCall('iii', cmp, [x, y]);
      }
      var keys = [];
      for (var i = 0; i < num; i++) keys.push(i);
      keys.sort(function(a, b) {
        return comparator(base+a*size, base+b*size);
      });
      // apply the sort
      var temp = _malloc(num*size);
      _memcpy(temp, base, num*size);
      for (var i = 0; i < num; i++) {
        if (keys[i] == i) continue; // already in place
        _memcpy(base+i*size, temp+keys[i]*size, size);
      }
      _free(temp);
    }

  var _atan=Math.atan;

  
  
  
  
  function _pwrite(fildes, buf, nbyte, offset) {
      // ssize_t pwrite(int fildes, const void *buf, size_t nbyte, off_t offset);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.streams[fildes];
      if (!stream || stream.object.isDevice) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      } else if (!stream.isWrite) {
        ___setErrNo(ERRNO_CODES.EACCES);
        return -1;
      } else if (stream.object.isFolder) {
        ___setErrNo(ERRNO_CODES.EISDIR);
        return -1;
      } else if (nbyte < 0 || offset < 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      } else {
        var contents = stream.object.contents;
        while (contents.length < offset) contents.push(0);
        for (var i = 0; i < nbyte; i++) {
          contents[offset + i] = HEAPU8[((buf)+(i))];
        }
        stream.object.timestamp = Date.now();
        return i;
      }
    }function _write(fildes, buf, nbyte) {
      // ssize_t write(int fildes, const void *buf, size_t nbyte);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.streams[fildes];
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      } else if (!stream.isWrite) {
        ___setErrNo(ERRNO_CODES.EACCES);
        return -1;
      } else if (nbyte < 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      } else {
        if (stream.object.isDevice) {
          if (stream.object.output) {
            for (var i = 0; i < nbyte; i++) {
              try {
                stream.object.output(HEAP8[((buf)+(i))]);
              } catch (e) {
                ___setErrNo(ERRNO_CODES.EIO);
                return -1;
              }
            }
            stream.object.timestamp = Date.now();
            return i;
          } else {
            ___setErrNo(ERRNO_CODES.ENXIO);
            return -1;
          }
        } else {
          var bytesWritten = _pwrite(fildes, buf, nbyte, stream.position);
          if (bytesWritten != -1) stream.position += bytesWritten;
          return bytesWritten;
        }
      }
    }function _fwrite(ptr, size, nitems, stream) {
      // size_t fwrite(const void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fwrite.html
      var bytesToWrite = nitems * size;
      if (bytesToWrite == 0) return 0;
      var bytesWritten = _write(stream, ptr, bytesToWrite);
      if (bytesWritten == -1) {
        if (FS.streams[stream]) FS.streams[stream].error = true;
        return 0;
      } else {
        return Math.floor(bytesWritten / size);
      }
    }function _fprintf(stream, format, varargs) {
      // int fprintf(FILE *restrict stream, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      var result = __formatString(format, varargs);
      var stack = Runtime.stackSave();
      var ret = _fwrite(allocate(result, 'i8', ALLOC_STACK), 1, result.length, stream);
      Runtime.stackRestore(stack);
      return ret;
    }var _vfprintf;

  function _fflush(stream) {
      // int fflush(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fflush.html
      var flush = function(filedes) {
        // Right now we write all data directly, except for output devices.
        if (FS.streams[filedes] && FS.streams[filedes].object.output) {
          if (!FS.streams[filedes].isTerminal) { // don't flush terminals, it would cause a \n to also appear
            FS.streams[filedes].object.output(null);
          }
        }
      };
      try {
        if (stream === 0) {
          for (var i = 0; i < FS.streams.length; i++) if (FS.streams[i]) flush(i);
        } else {
          flush(stream);
        }
        return 0;
      } catch (e) {
        ___setErrNo(ERRNO_CODES.EIO);
        return -1;
      }
    }
var _llvm_va_start; // stub for _llvm_va_start

  function _llvm_va_end() {}

  var _sin=Math.sin;

  var _fabsf=Math.abs;

  var _log10f;

  function _ftell(stream) {
      // long ftell(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/ftell.html
      if (FS.streams[stream]) {
        stream = FS.streams[stream];
        if (stream.object.isDevice) {
          ___setErrNo(ERRNO_CODES.ESPIPE);
          return -1;
        } else {
          return stream.position;
        }
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
    }


  
  
  function _pread(fildes, buf, nbyte, offset) {
      // ssize_t pread(int fildes, void *buf, size_t nbyte, off_t offset);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/read.html
      var stream = FS.streams[fildes];
      if (!stream || stream.object.isDevice) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      } else if (!stream.isRead) {
        ___setErrNo(ERRNO_CODES.EACCES);
        return -1;
      } else if (stream.object.isFolder) {
        ___setErrNo(ERRNO_CODES.EISDIR);
        return -1;
      } else if (nbyte < 0 || offset < 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      } else {
        var bytesRead = 0;
        while (stream.ungotten.length && nbyte > 0) {
          HEAP8[(buf++)]=stream.ungotten.pop()
          nbyte--;
          bytesRead++;
        }
        var contents = stream.object.contents;
        var size = Math.min(contents.length - offset, nbyte);
        if (contents.subarray || contents.slice) { // typed array or normal array
          for (var i = 0; i < size; i++) {
            HEAP8[((buf)+(i))]=contents[offset + i]
          }
        } else {
          for (var i = 0; i < size; i++) { // LazyUint8Array from sync binary XHR
            HEAP8[((buf)+(i))]=contents.get(offset + i)
          }
        }
        bytesRead += size;
        return bytesRead;
      }
    }function _read(fildes, buf, nbyte) {
      // ssize_t read(int fildes, void *buf, size_t nbyte);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/read.html
      var stream = FS.streams[fildes];
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      } else if (!stream.isRead) {
        ___setErrNo(ERRNO_CODES.EACCES);
        return -1;
      } else if (nbyte < 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      } else {
        var bytesRead;
        if (stream.object.isDevice) {
          if (stream.object.input) {
            bytesRead = 0;
            while (stream.ungotten.length && nbyte > 0) {
              HEAP8[(buf++)]=stream.ungotten.pop()
              nbyte--;
              bytesRead++;
            }
            for (var i = 0; i < nbyte; i++) {
              try {
                var result = stream.object.input();
              } catch (e) {
                ___setErrNo(ERRNO_CODES.EIO);
                return -1;
              }
              if (result === null || result === undefined) break;
              bytesRead++;
              HEAP8[((buf)+(i))]=result
            }
            return bytesRead;
          } else {
            ___setErrNo(ERRNO_CODES.ENXIO);
            return -1;
          }
        } else {
          var ungotSize = stream.ungotten.length;
          bytesRead = _pread(fildes, buf, nbyte, stream.position);
          if (bytesRead != -1) {
            stream.position += (stream.ungotten.length - ungotSize) + bytesRead;
          }
          return bytesRead;
        }
      }
    }function _fread(ptr, size, nitems, stream) {
      // size_t fread(void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fread.html
      var bytesToRead = nitems * size;
      if (bytesToRead == 0) return 0;
      var bytesRead = _read(stream, ptr, bytesToRead);
      var streamObj = FS.streams[stream];
      if (bytesRead == -1) {
        if (streamObj) streamObj.error = true;
        return 0;
      } else {
        if (bytesRead < bytesToRead) streamObj.eof = true;
        return Math.floor(bytesRead / size);
      }
    }

  function _abort() {
      ABORT = true;
      throw 'abort() at ' + (new Error().stack);
    }


  function _sysconf(name) {
      // long sysconf(int name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/sysconf.html
      switch(name) {
        case 8: return PAGE_SIZE;
        case 54:
        case 56:
        case 21:
        case 61:
        case 63:
        case 22:
        case 67:
        case 23:
        case 24:
        case 25:
        case 26:
        case 27:
        case 69:
        case 28:
        case 101:
        case 70:
        case 71:
        case 29:
        case 30:
        case 199:
        case 75:
        case 76:
        case 32:
        case 43:
        case 44:
        case 80:
        case 46:
        case 47:
        case 45:
        case 48:
        case 49:
        case 42:
        case 82:
        case 33:
        case 7:
        case 108:
        case 109:
        case 107:
        case 112:
        case 119:
        case 121:
          return 200809;
        case 13:
        case 104:
        case 94:
        case 95:
        case 34:
        case 35:
        case 77:
        case 81:
        case 83:
        case 84:
        case 85:
        case 86:
        case 87:
        case 88:
        case 89:
        case 90:
        case 91:
        case 94:
        case 95:
        case 110:
        case 111:
        case 113:
        case 114:
        case 115:
        case 116:
        case 117:
        case 118:
        case 120:
        case 40:
        case 16:
        case 79:
        case 19:
          return -1;
        case 92:
        case 93:
        case 5:
        case 72:
        case 6:
        case 74:
        case 92:
        case 93:
        case 96:
        case 97:
        case 98:
        case 99:
        case 102:
        case 103:
        case 105:
          return 1;
        case 38:
        case 66:
        case 50:
        case 51:
        case 4:
          return 1024;
        case 15:
        case 64:
        case 41:
          return 32;
        case 55:
        case 37:
        case 17:
          return 2147483647;
        case 18:
        case 1:
          return 47839;
        case 59:
        case 57:
          return 99;
        case 68:
        case 58:
          return 2048;
        case 0: return 2097152;
        case 3: return 65536;
        case 14: return 32768;
        case 73: return 32767;
        case 39: return 16384;
        case 60: return 1000;
        case 106: return 700;
        case 52: return 256;
        case 62: return 255;
        case 2: return 100;
        case 65: return 64;
        case 36: return 20;
        case 100: return 16;
        case 20: return 6;
        case 53: return 4;
      }
      ___setErrNo(ERRNO_CODES.EINVAL);
      return -1;
    }

  function _time(ptr) {
      var ret = Math.floor(Date.now()/1000);
      if (ptr) {
        HEAP32[((ptr)>>2)]=ret
      }
      return ret;
    }

  
  function ___errno_location() {
      return ___setErrNo.ret;
    }var ___errno;

  function _sbrk(bytes) {
      // Implement a Linux-like 'memory area' for our 'process'.
      // Changes the size of the memory area by |bytes|; returns the
      // address of the previous top ('break') of the memory area
  
      // We need to make sure no one else allocates unfreeable memory!
      // We must control this entirely. So we don't even need to do
      // unfreeable allocations - the HEAP is ours, from STATICTOP up.
      // TODO: We could in theory slice off the top of the HEAP when
      //       sbrk gets a negative increment in |bytes|...
      var self = _sbrk;
      if (!self.called) {
        STATICTOP = alignMemoryPage(STATICTOP); // make sure we start out aligned
        self.called = true;
        _sbrk.DYNAMIC_START = STATICTOP;
      }
      var ret = STATICTOP;
      if (bytes != 0) Runtime.staticAlloc(bytes);
      return ret;  // Previous break location.
    }

  function ___gxx_personality_v0() {
    }

  function ___cxa_allocate_exception(size) {
      return _malloc(size);
    }

  
  function _llvm_eh_exception() {
      return HEAP32[((_llvm_eh_exception.buf)>>2)];
    }
  
  function __ZSt18uncaught_exceptionv() { // std::uncaught_exception()
      return !!__ZSt18uncaught_exceptionv.uncaught_exception;
    }
  
  
  
  function ___cxa_is_number_type(type) {
      var isNumber = false;
      try { if (type == __ZTIi) isNumber = true } catch(e){}
      try { if (type == __ZTIj) isNumber = true } catch(e){}
      try { if (type == __ZTIl) isNumber = true } catch(e){}
      try { if (type == __ZTIm) isNumber = true } catch(e){}
      try { if (type == __ZTIx) isNumber = true } catch(e){}
      try { if (type == __ZTIy) isNumber = true } catch(e){}
      try { if (type == __ZTIf) isNumber = true } catch(e){}
      try { if (type == __ZTId) isNumber = true } catch(e){}
      try { if (type == __ZTIe) isNumber = true } catch(e){}
      try { if (type == __ZTIc) isNumber = true } catch(e){}
      try { if (type == __ZTIa) isNumber = true } catch(e){}
      try { if (type == __ZTIh) isNumber = true } catch(e){}
      try { if (type == __ZTIs) isNumber = true } catch(e){}
      try { if (type == __ZTIt) isNumber = true } catch(e){}
      return isNumber;
    }function ___cxa_does_inherit(definiteType, possibilityType, possibility) {
      if (possibility == 0) return false;
      if (possibilityType == 0 || possibilityType == definiteType)
        return true;
      var possibility_type_info;
      if (___cxa_is_number_type(possibilityType)) {
        possibility_type_info = possibilityType;
      } else {
        var possibility_type_infoAddr = HEAP32[((possibilityType)>>2)] - 8;
        possibility_type_info = HEAP32[((possibility_type_infoAddr)>>2)];
      }
      switch (possibility_type_info) {
      case 0: // possibility is a pointer
        // See if definite type is a pointer
        var definite_type_infoAddr = HEAP32[((definiteType)>>2)] - 8;
        var definite_type_info = HEAP32[((definite_type_infoAddr)>>2)];
        if (definite_type_info == 0) {
          // Also a pointer; compare base types of pointers
          var defPointerBaseAddr = definiteType+8;
          var defPointerBaseType = HEAP32[((defPointerBaseAddr)>>2)];
          var possPointerBaseAddr = possibilityType+8;
          var possPointerBaseType = HEAP32[((possPointerBaseAddr)>>2)];
          return ___cxa_does_inherit(defPointerBaseType, possPointerBaseType, possibility);
        } else
          return false; // one pointer and one non-pointer
      case 1: // class with no base class
        return false;
      case 2: // class with base class
        var parentTypeAddr = possibilityType + 8;
        var parentType = HEAP32[((parentTypeAddr)>>2)];
        return ___cxa_does_inherit(definiteType, parentType, possibility);
      default:
        return false; // some unencountered type
      }
    }function ___cxa_find_matching_catch(thrown, throwntype, typeArray) {
      // If throwntype is a pointer, this means a pointer has been
      // thrown. When a pointer is thrown, actually what's thrown
      // is a pointer to the pointer. We'll dereference it.
      if (throwntype != 0 && !___cxa_is_number_type(throwntype)) {
        var throwntypeInfoAddr= HEAP32[((throwntype)>>2)] - 8;
        var throwntypeInfo= HEAP32[((throwntypeInfoAddr)>>2)];
        if (throwntypeInfo == 0)
          thrown = HEAP32[((thrown)>>2)];
      }
      // The different catch blocks are denoted by different types.
      // Due to inheritance, those types may not precisely match the
      // type of the thrown object. Find one which matches, and
      // return the type of the catch block which should be called.
      for (var i = 0; i < typeArray.length; i++) {
        if (___cxa_does_inherit(typeArray[i], throwntype, thrown))
          return (tempRet0 = typeArray[i],thrown);
      }
      // Shouldn't happen unless we have bogus data in typeArray
      // or encounter a type for which emscripten doesn't have suitable
      // typeinfo defined. Best-efforts match just in case.
      return (tempRet0 = throwntype,thrown);
    }function ___cxa_throw(ptr, type, destructor) {
      if (!___cxa_throw.initialized) {
        try {
          HEAP32[((__ZTVN10__cxxabiv119__pointer_type_infoE)>>2)]=0; // Workaround for libcxxabi integration bug
        } catch(e){}
        try {
          HEAP32[((__ZTVN10__cxxabiv117__class_type_infoE)>>2)]=1; // Workaround for libcxxabi integration bug
        } catch(e){}
        try {
          HEAP32[((__ZTVN10__cxxabiv120__si_class_type_infoE)>>2)]=2; // Workaround for libcxxabi integration bug
        } catch(e){}
        ___cxa_throw.initialized = true;
      }
      HEAP32[((_llvm_eh_exception.buf)>>2)]=ptr
      HEAP32[(((_llvm_eh_exception.buf)+(4))>>2)]=type
      HEAP32[(((_llvm_eh_exception.buf)+(8))>>2)]=destructor
      if (!("uncaught_exception" in __ZSt18uncaught_exceptionv)) {
        __ZSt18uncaught_exceptionv.uncaught_exception = 1;
      } else {
        __ZSt18uncaught_exceptionv.uncaught_exception++;
      }
      throw ptr + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";;
    }

  function ___cxa_call_unexpected(exception) {
      ABORT = true;
      throw exception;
    }

  function ___cxa_begin_catch(ptr) {
      __ZSt18uncaught_exceptionv.uncaught_exception--;
      return ptr;
    }

  
  function ___cxa_free_exception(ptr) {
      return _free(ptr);
    }function ___cxa_end_catch() {
      if (___cxa_end_catch.rethrown) {
        ___cxa_end_catch.rethrown = false;
        return;
      }
      // Clear state flag.
      __THREW__ = 0;
      // Clear type.
      HEAP32[(((_llvm_eh_exception.buf)+(4))>>2)]=0
      // Call destructor if one is registered then clear it.
      var ptr = HEAP32[((_llvm_eh_exception.buf)>>2)];
      var destructor = HEAP32[(((_llvm_eh_exception.buf)+(8))>>2)];
      if (destructor) {
        Runtime.dynCall('vi', destructor, [ptr]);
        HEAP32[(((_llvm_eh_exception.buf)+(8))>>2)]=0
      }
      // Free ptr if it isn't null.
      if (ptr) {
        ___cxa_free_exception(ptr);
        HEAP32[((_llvm_eh_exception.buf)>>2)]=0
      }
    }

  function __ZNSt9exceptionD2Ev(){}

  function _llvm_bswap_i16(x) {
      return ((x&0xff)<<8) | ((x>>8)&0xff);
    }

  var _llvm_memset_p0i8_i64;

  function _exp2(x) {
      return Math.pow(2, x);
    }

  var _floorf=Math.floor;





  var Browser={mainLoop:{scheduler:null,shouldPause:false,paused:false,queue:[],pause:function () {
          Browser.mainLoop.shouldPause = true;
        },resume:function () {
          if (Browser.mainLoop.paused) {
            Browser.mainLoop.paused = false;
            Browser.mainLoop.scheduler();
          }
          Browser.mainLoop.shouldPause = false;
        },updateStatus:function () {
          if (Module['setStatus']) {
            var message = Module['statusMessage'] || 'Please wait...';
            var remaining = Browser.mainLoop.remainingBlockers;
            var expected = Browser.mainLoop.expectedBlockers;
            if (remaining) {
              if (remaining < expected) {
                Module['setStatus'](message + ' (' + (expected - remaining) + '/' + expected + ')');
              } else {
                Module['setStatus'](message);
              }
            } else {
              Module['setStatus']('');
            }
          }
        }},pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],ensureObjects:function () {
        if (Browser.ensured) return;
        Browser.ensured = true;
        try {
          new Blob();
          Browser.hasBlobConstructor = true;
        } catch(e) {
          Browser.hasBlobConstructor = false;
          console.log("warning: no blob constructor, cannot create blobs with mimetypes");
        }
        Browser.BlobBuilder = typeof MozBlobBuilder != "undefined" ? MozBlobBuilder : (typeof WebKitBlobBuilder != "undefined" ? WebKitBlobBuilder : (!Browser.hasBlobConstructor ? console.log("warning: no BlobBuilder") : null));
        Browser.URLObject = typeof window != "undefined" ? (window.URL ? window.URL : window.webkitURL) : console.log("warning: cannot create object URLs");
  
        // Support for plugins that can process preloaded files. You can add more of these to
        // your app by creating and appending to Module.preloadPlugins.
        //
        // Each plugin is asked if it can handle a file based on the file's name. If it can,
        // it is given the file's raw data. When it is done, it calls a callback with the file's
        // (possibly modified) data. For example, a plugin might decompress a file, or it
        // might create some side data structure for use later (like an Image element, etc.).
  
        function getMimetype(name) {
          return {
            'jpg': 'image/jpeg',
            'png': 'image/png',
            'bmp': 'image/bmp',
            'ogg': 'audio/ogg',
            'wav': 'audio/wav',
            'mp3': 'audio/mpeg'
          }[name.substr(-3)];
          return ret;
        }
  
        if (!Module["preloadPlugins"]) Module["preloadPlugins"] = [];
  
        var imagePlugin = {};
        imagePlugin['canHandle'] = function(name) {
          return name.substr(-4) in { '.jpg': 1, '.png': 1, '.bmp': 1 };
        };
        imagePlugin['handle'] = function(byteArray, name, onload, onerror) {
          var b = null;
          if (Browser.hasBlobConstructor) {
            try {
              b = new Blob([byteArray], { type: getMimetype(name) });
            } catch(e) {
              Runtime.warnOnce('Blob constructor present but fails: ' + e + '; falling back to blob builder');
            }
          }
          if (!b) {
            var bb = new Browser.BlobBuilder();
            bb.append((new Uint8Array(byteArray)).buffer); // we need to pass a buffer, and must copy the array to get the right data range
            b = bb.getBlob();
          }
          var url = Browser.URLObject.createObjectURL(b);
          var img = new Image();
          img.onload = function() {
            assert(img.complete, 'Image ' + name + ' could not be decoded');
            var canvas = document.createElement('canvas');
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext('2d');
            ctx.drawImage(img, 0, 0);
            Module["preloadedImages"][name] = canvas;
            Browser.URLObject.revokeObjectURL(url);
            if (onload) onload(byteArray);
          };
          img.onerror = function(event) {
            console.log('Image ' + url + ' could not be decoded');
            if (onerror) onerror();
          };
          img.src = url;
        };
        Module['preloadPlugins'].push(imagePlugin);
  
        var audioPlugin = {};
        audioPlugin['canHandle'] = function(name) {
          return name.substr(-4) in { '.ogg': 1, '.wav': 1, '.mp3': 1 };
        };
        audioPlugin['handle'] = function(byteArray, name, onload, onerror) {
          var done = false;
          function finish(audio) {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = audio;
            if (onload) onload(byteArray);
          }
          function fail() {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = new Audio(); // empty shim
            if (onerror) onerror();
          }
          if (Browser.hasBlobConstructor) {
            try {
              var b = new Blob([byteArray], { type: getMimetype(name) });
            } catch(e) {
              return fail();
            }
            var url = Browser.URLObject.createObjectURL(b); // XXX we never revoke this!
            var audio = new Audio();
            audio.addEventListener('canplaythrough', function() { finish(audio) }, false); // use addEventListener due to chromium bug 124926
            audio.onerror = function(event) {
              if (done) return;
              console.log('warning: browser could not fully decode audio ' + name + ', trying slower base64 approach');
              function encode64(data) {
                var BASE = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
                var PAD = '=';
                var ret = '';
                var leftchar = 0;
                var leftbits = 0;
                for (var i = 0; i < data.length; i++) {
                  leftchar = (leftchar << 8) | data[i];
                  leftbits += 8;
                  while (leftbits >= 6) {
                    var curr = (leftchar >> (leftbits-6)) & 0x3f;
                    leftbits -= 6;
                    ret += BASE[curr];
                  }
                }
                if (leftbits == 2) {
                  ret += BASE[(leftchar&3) << 4];
                  ret += PAD + PAD;
                } else if (leftbits == 4) {
                  ret += BASE[(leftchar&0xf) << 2];
                  ret += PAD;
                }
                return ret;
              }
              audio.src = 'data:audio/x-' + name.substr(-3) + ';base64,' + encode64(byteArray);
              finish(audio); // we don't wait for confirmation this worked - but it's worth trying
            };
            audio.src = url;
            // workaround for chrome bug 124926 - we do not always get oncanplaythrough or onerror
            setTimeout(function() {
              finish(audio); // try to use it even though it is not necessarily ready to play
            }, 10000);
          } else {
            return fail();
          }
        };
        Module['preloadPlugins'].push(audioPlugin);
      },createContext:function (canvas, useWebGL, setInModule) {
        try {
          var ctx = canvas.getContext(useWebGL ? 'experimental-webgl' : '2d');
          if (!ctx) throw ':(';
        } catch (e) {
          Module.print('Could not create canvas - ' + e);
          return null;
        }
        if (useWebGL) {
          // Set the background of the WebGL canvas to black
          canvas.style.backgroundColor = "black";
  
          // Warn on context loss
          canvas.addEventListener('webglcontextlost', function(event) {
            alert('WebGL context lost. You will need to reload the page.');
          }, false);
        }
        if (setInModule) {
          Module.ctx = ctx;
          Module.useWebGL = useWebGL;
          Browser.moduleContextCreatedCallbacks.forEach(function(callback) { callback() });
        }
        return ctx;
      },requestFullScreen:function () {
        var canvas = Module['canvas'];
        function fullScreenChange() {
          var isFullScreen = false;
          if ((document['webkitFullScreenElement'] || document['webkitFullscreenElement'] ||
               document['mozFullScreenElement'] || document['mozFullscreenElement'] ||
               document['fullScreenElement'] || document['fullscreenElement']) === canvas) {
            canvas.requestPointerLock = canvas['requestPointerLock'] ||
                                        canvas['mozRequestPointerLock'] ||
                                        canvas['webkitRequestPointerLock'];
            canvas.requestPointerLock();
            isFullScreen = true;
          }
          if (Module['onFullScreen']) Module['onFullScreen'](isFullScreen);
        }
  
        document.addEventListener('fullscreenchange', fullScreenChange, false);
        document.addEventListener('mozfullscreenchange', fullScreenChange, false);
        document.addEventListener('webkitfullscreenchange', fullScreenChange, false);
  
        function pointerLockChange() {
          Browser.pointerLock = document['pointerLockElement'] === canvas ||
                                document['mozPointerLockElement'] === canvas ||
                                document['webkitPointerLockElement'] === canvas;
        }
  
        document.addEventListener('pointerlockchange', pointerLockChange, false);
        document.addEventListener('mozpointerlockchange', pointerLockChange, false);
        document.addEventListener('webkitpointerlockchange', pointerLockChange, false);
  
        canvas.requestFullScreen = canvas['requestFullScreen'] ||
                                   canvas['mozRequestFullScreen'] ||
                                   (canvas['webkitRequestFullScreen'] ? function() { canvas['webkitRequestFullScreen'](Element['ALLOW_KEYBOARD_INPUT']) } : null);
        canvas.requestFullScreen(); 
      },requestAnimationFrame:function (func) {
        if (!window.requestAnimationFrame) {
          window.requestAnimationFrame = window['requestAnimationFrame'] ||
                                         window['mozRequestAnimationFrame'] ||
                                         window['webkitRequestAnimationFrame'] ||
                                         window['msRequestAnimationFrame'] ||
                                         window['oRequestAnimationFrame'] ||
                                         window['setTimeout'];
        }
        window.requestAnimationFrame(func);
      },getMovementX:function (event) {
        return event['movementX'] ||
               event['mozMovementX'] ||
               event['webkitMovementX'] ||
               0;
      },getMovementY:function (event) {
        return event['movementY'] ||
               event['mozMovementY'] ||
               event['webkitMovementY'] ||
               0;
      },xhrLoad:function (url, onload, onerror) {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, true);
        xhr.responseType = 'arraybuffer';
        xhr.onload = function() {
          if (xhr.status == 200) {
            onload(xhr.response);
          } else {
            onerror();
          }
        };
        xhr.onerror = onerror;
        xhr.send(null);
      },asyncLoad:function (url, onload, onerror, noRunDep) {
        Browser.xhrLoad(url, function(arrayBuffer) {
          assert(arrayBuffer, 'Loading data file "' + url + '" failed (no arrayBuffer).');
          onload(new Uint8Array(arrayBuffer));
          if (!noRunDep) removeRunDependency('al ' + url);
        }, function(event) {
          if (onerror) {
            onerror();
          } else {
            throw 'Loading data file "' + url + '" failed.';
          }
        });
        if (!noRunDep) addRunDependency('al ' + url);
      },resizeListeners:[],updateResizeListeners:function () {
        var canvas = Module['canvas'];
        Browser.resizeListeners.forEach(function(listener) {
          listener(canvas.width, canvas.height);
        });
      },setCanvasSize:function (width, height, noUpdates) {
        var canvas = Module['canvas'];
        canvas.width = width;
        canvas.height = height;
        if (!noUpdates) Browser.updateResizeListeners();
      }};
___setErrNo(0);
__ATINIT__.unshift({ func: function() { if (!Module["noFSInit"] && !FS.init.initialized) FS.init() } });__ATMAIN__.push({ func: function() { FS.ignorePermissions = false } });__ATEXIT__.push({ func: function() { FS.quit() } });Module["FS_createFolder"] = FS.createFolder;Module["FS_createPath"] = FS.createPath;Module["FS_createDataFile"] = FS.createDataFile;Module["FS_createPreloadedFile"] = FS.createPreloadedFile;Module["FS_createLazyFile"] = FS.createLazyFile;Module["FS_createLink"] = FS.createLink;Module["FS_createDevice"] = FS.createDevice;
_llvm_eh_exception.buf = allocate(12, "void*", ALLOC_STATIC);
Module["requestFullScreen"] = function() { Browser.requestFullScreen() };
  Module["requestAnimationFrame"] = function(func) { Browser.requestAnimationFrame(func) };
  Module["pauseMainLoop"] = function() { Browser.mainLoop.pause() };
  Module["resumeMainLoop"] = function() { Browser.mainLoop.resume() };
  


var FUNCTION_TABLE = [0,0,__ZNSt20bad_array_new_lengthD0Ev,0,_ABR_iteration_loop,0,_count_bit_noESC_from2,0,_count_bit_noESC_from3,0,__ZNSt9bad_allocC2Ev,0,__ZNSt9bad_allocD0Ev,0,_VBR_old_iteration_loop,0,_find_scalefac_x34,0,_floatcompare,0,_VBR_new_iteration_loop,0,_long_block_constrain,0,__ZNKSt9bad_alloc4whatEv,0,_CBR_iteration_loop,0,_count_bit_null,0,__ZNSt9bad_allocD2Ev,0,_count_bit_noESC,0,_short_block_constrain,0,_guess_scalefac_x34,0,_choose_table_nonMMX,0,__ZNSt20bad_array_new_lengthC2Ev,0,_decodeMP3_unclipped,0,__ZNKSt20bad_array_new_length4whatEv,0,_decodeMP3,0,_init_xrpow_core_c,0,_fht,0,_lame_report_def,0];

function _CRC_update($value, $crc) {
  var $2 = $crc << 1;
  var $8 = ((($2 ^ $value << 9) & 65536 | 0) == 0 ? $2 : $2 ^ 32773) << 1;
  var $14 = ((($8 ^ $value << 10) & 65536 | 0) == 0 ? $8 : $8 ^ 32773) << 1;
  var $20 = ((($14 ^ $value << 11) & 65536 | 0) == 0 ? $14 : $14 ^ 32773) << 1;
  var $26 = ((($20 ^ $value << 12) & 65536 | 0) == 0 ? $20 : $20 ^ 32773) << 1;
  var $32 = ((($26 ^ $value << 13) & 65536 | 0) == 0 ? $26 : $26 ^ 32773) << 1;
  var $38 = ((($32 ^ $value << 14) & 65536 | 0) == 0 ? $32 : $32 ^ 32773) << 1;
  var $44 = ((($38 ^ $value << 15) & 65536 | 0) == 0 ? $38 : $38 ^ 32773) << 1;
  return (($44 ^ $value << 16) & 65536 | 0) == 0 ? $44 : $44 ^ 32773;
}
_CRC_update["X"] = 1;
function _calcFrameLength($cfg, $kbps, $pad) {
  return ((((HEAP32[$cfg >> 2] * 72e3 & -1) + 72e3) * $kbps & -1 | 0) / (HEAP32[$cfg + 48 >> 2] | 0) & -1) + $pad << 3;
}
function _putbits_noheaders($gfc, $val) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 284 | 0;
    var $2 = $gfc + 300 | 0;
    var $3 = $gfc + 296 | 0;
    var $4 = $1 | 0;
    var $5 = $gfc + 296 | 0;
    var $6 = $1 | 0;
    var $7 = $gfc + 292 | 0;
    var $_01 = 8;
    label = 3;
    break;
   case 3:
    var $_01;
    var $9 = HEAP32[$2 >> 2];
    var $10 = ($9 | 0) == 0;
    if ($10) {
      label = 4;
      break;
    } else {
      label = 5;
      break;
    }
   case 4:
    HEAP32[$2 >> 2] = 8;
    var $12 = HEAP32[$3 >> 2];
    var $13 = $12 + 1 | 0;
    HEAP32[$3 >> 2] = $13;
    var $14 = HEAP32[$4 >> 2];
    var $15 = $14 + $13 | 0;
    HEAP8[$15] = 0;
    label = 5;
    break;
   case 5:
    var $17 = HEAP32[$2 >> 2];
    var $18 = ($_01 | 0) < ($17 | 0);
    var $_0_ = $18 ? $_01 : $17;
    var $19 = $_01 - $_0_ | 0;
    var $20 = $17 - $_0_ | 0;
    HEAP32[$2 >> 2] = $20;
    var $21 = $val >> $19;
    var $22 = $21 << $20;
    var $23 = HEAP32[$5 >> 2];
    var $24 = HEAP32[$6 >> 2];
    var $25 = $24 + $23 | 0;
    var $26 = HEAP8[$25];
    var $27 = $26 & 255;
    var $28 = $22 | $27;
    var $29 = $28 & 255;
    HEAP8[$25] = $29;
    var $30 = HEAP32[$7 >> 2];
    var $31 = $30 + $_0_ | 0;
    HEAP32[$7 >> 2] = $31;
    var $32 = ($19 | 0) > 0;
    if ($32) {
      var $_01 = $19;
      label = 3;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    return;
  }
}
function _getframebits($gfc) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 16 | 0;
    var $2 = $gfc + 84740 | 0;
    var $3 = HEAP32[$2 >> 2];
    var $4 = ($3 | 0) == 0;
    if ($4) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $6 = $1 | 0;
    var $7 = HEAP32[$6 >> 2];
    var $8 = 5348684 + ($7 << 6) + ($3 << 2) | 0;
    var $bit_rate_0_in = $8;
    label = 5;
    break;
   case 4:
    var $10 = $gfc + 120 | 0;
    var $bit_rate_0_in = $10;
    label = 5;
    break;
   case 5:
    var $bit_rate_0_in;
    var $bit_rate_0 = HEAP32[$bit_rate_0_in >> 2];
    var $12 = $gfc + 84748 | 0;
    var $13 = HEAP32[$12 >> 2];
    var $14 = _calcFrameLength($1, $bit_rate_0, $13);
    return $14;
  }
}
function _get_max_frame_buffer_size_by_constraint($cfg, $constraint) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $cfg + 104 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($2 | 0) > 320;
    if ($3) {
      label = 3;
      break;
    } else {
      label = 6;
      break;
    }
   case 3:
    var $5 = ($constraint | 0) == 1;
    if ($5) {
      label = 4;
      break;
    } else {
      label = 5;
      break;
    }
   case 4:
    var $7 = _calcFrameLength($cfg, $2, 0);
    var $maxmp3buf_0 = $7;
    label = 12;
    break;
   case 5:
    var $9 = $cfg | 0;
    var $10 = HEAP32[$9 >> 2];
    var $11 = $10 * 7680 & -1;
    var $12 = $11 + 7680 | 0;
    var $maxmp3buf_0 = $12;
    label = 12;
    break;
   case 6:
    var $14 = $cfg + 48 | 0;
    var $15 = HEAP32[$14 >> 2];
    var $16 = ($15 | 0) < 16e3;
    var $17 = $cfg | 0;
    var $18 = HEAP32[$17 >> 2];
    if ($16) {
      label = 7;
      break;
    } else {
      label = 8;
      break;
    }
   case 7:
    var $20 = 5348716 + ($18 << 6) | 0;
    var $max_kbps_0_in = $20;
    label = 9;
    break;
   case 8:
    var $22 = 5348740 + ($18 << 6) | 0;
    var $max_kbps_0_in = $22;
    label = 9;
    break;
   case 9:
    var $max_kbps_0_in;
    if (($constraint | 0) == 1) {
      label = 10;
      break;
    } else if (($constraint | 0) == 2) {
      label = 11;
      break;
    } else {
      var $maxmp3buf_0 = 11520;
      label = 12;
      break;
    }
   case 10:
    var $max_kbps_0 = HEAP32[$max_kbps_0_in >> 2];
    var $25 = _calcFrameLength($cfg, $max_kbps_0, 0);
    var $maxmp3buf_0 = $25;
    label = 12;
    break;
   case 11:
    var $27 = HEAP32[$17 >> 2];
    var $28 = $27 * 7680 & -1;
    var $29 = $28 + 7680 | 0;
    var $maxmp3buf_0 = $29;
    label = 12;
    break;
   case 12:
    var $maxmp3buf_0;
    return $maxmp3buf_0;
  }
}
function _CRC_writeheader($gfc, $header) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $header + 2 | 0;
    var $2 = HEAP8[$1];
    var $3 = $2 & 255;
    var $4 = _CRC_update($3, 65535);
    var $5 = $header + 3 | 0;
    var $6 = HEAP8[$5];
    var $7 = $6 & 255;
    var $8 = _CRC_update($7, $4);
    var $9 = $gfc + 24 | 0;
    var $10 = HEAP32[$9 >> 2];
    var $11 = ($10 | 0) > 6;
    if ($11) {
      label = 3;
      break;
    } else {
      var $crc_0_lcssa = $8;
      label = 5;
      break;
    }
   case 3:
    var $12 = HEAP32[$9 >> 2];
    var $crc_012 = $8;
    var $i_013 = 6;
    label = 4;
    break;
   case 4:
    var $i_013;
    var $crc_012;
    var $14 = $header + $i_013 | 0;
    var $15 = HEAP8[$14];
    var $16 = $15 & 255;
    var $17 = _CRC_update($16, $crc_012);
    var $18 = $i_013 + 1 | 0;
    var $19 = ($18 | 0) < ($12 | 0);
    if ($19) {
      var $crc_012 = $17;
      var $i_013 = $18;
      label = 4;
      break;
    } else {
      var $crc_0_lcssa = $17;
      label = 5;
      break;
    }
   case 5:
    var $crc_0_lcssa;
    var $20 = $crc_0_lcssa >>> 8;
    var $21 = $20 & 255;
    var $22 = $header + 4 | 0;
    HEAP8[$22] = $21;
    var $23 = $crc_0_lcssa & 255;
    var $24 = $header + 5 | 0;
    HEAP8[$24] = $23;
    return;
  }
}
function _compute_flushbits($gfc, $total_bytes_output) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 52128 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $gfc + 52124 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = $4 - 1 | 0;
    var $6 = ($4 | 0) == 0;
    var $_ = $6 ? 255 : $5;
    var $7 = $gfc + 39836 + $_ * 48 | 0;
    var $8 = HEAP32[$7 >> 2];
    var $9 = $gfc + 292 | 0;
    var $10 = HEAP32[$9 >> 2];
    var $11 = $8 - $10 | 0;
    HEAP32[$total_bytes_output >> 2] = $11;
    var $12 = ($11 | 0) > -1;
    if ($12) {
      label = 3;
      break;
    } else {
      var $flushbits_0 = $11;
      label = 4;
      break;
    }
   case 3:
    var $14 = 1 - $2 | 0;
    var $15 = $14 + $_ | 0;
    var $16 = ($_ | 0) < ($2 | 0);
    var $17 = $15 + 256 | 0;
    var $remaining_headers_0 = $16 ? $17 : $15;
    var $18 = $remaining_headers_0 << 3;
    var $19 = $gfc + 24 | 0;
    var $20 = HEAP32[$19 >> 2];
    var $21 = $18 * $20 & -1;
    var $22 = $11 - $21 | 0;
    var $flushbits_0 = $22;
    label = 4;
    break;
   case 4:
    var $flushbits_0;
    var $24 = _getframebits($gfc);
    var $25 = $24 + $flushbits_0 | 0;
    var $26 = HEAP32[$total_bytes_output >> 2];
    var $27 = $26 + $24 | 0;
    var $28 = $27 & 7;
    var $29 = ($27 | 0) / 8 & -1;
    var $not_ = ($28 | 0) != 0;
    var $30 = $not_ & 1;
    var $storemerge = $30 + $29 | 0;
    HEAP32[$total_bytes_output >> 2] = $storemerge;
    var $31 = $gfc + 296 | 0;
    var $32 = HEAP32[$31 >> 2];
    var $33 = $32 + 1 | 0;
    var $34 = $33 + $storemerge | 0;
    HEAP32[$total_bytes_output >> 2] = $34;
    var $35 = ($25 | 0) < 0;
    if ($35) {
      label = 5;
      break;
    } else {
      label = 6;
      break;
    }
   case 5:
    _lame_errorf($gfc, 5387468, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    label = 6;
    break;
   case 6:
    STACKTOP = __stackBase__;
    return $25;
  }
}
function _flush_bitstream($gfc) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 4 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $nbytes = __stackBase__;
    var $1 = _compute_flushbits($gfc, $nbytes);
    var $2 = ($1 | 0) < 0;
    if ($2) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    _drain_into_ancillary($gfc, $1);
    var $4 = $gfc + 52136 | 0;
    HEAP32[$4 >> 2] = 0;
    var $5 = $gfc + 21312 | 0;
    HEAP32[$5 >> 2] = 0;
    label = 4;
    break;
   case 4:
    STACKTOP = __stackBase__;
    return;
  }
}
function _drain_into_ancillary($gfc, $remainingBits) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($remainingBits | 0) > 7;
    if ($1) {
      label = 6;
      break;
    } else {
      var $_5_ph = $remainingBits;
      label = 4;
      break;
    }
   case 3:
    var $2 = $22 - 32 | 0;
    var $_5_ph = $2;
    label = 4;
    break;
   case 4:
    var $_5_ph;
    var $3 = ($_5_ph | 0) > 0;
    if ($3) {
      label = 5;
      break;
    } else {
      label = 13;
      break;
    }
   case 5:
    var $4 = $gfc + 52132 | 0;
    var $5 = $gfc + 144 | 0;
    var $_530 = $_5_ph;
    label = 12;
    break;
   case 6:
    _putbits2($gfc, 76, 8);
    var $7 = $remainingBits - 8 | 0;
    var $8 = ($7 | 0) > 7;
    if ($8) {
      label = 7;
      break;
    } else {
      var $_5_ph = $7;
      label = 4;
      break;
    }
   case 7:
    _putbits2($gfc, 65, 8);
    var $10 = $remainingBits - 16 | 0;
    var $11 = ($10 | 0) > 7;
    if ($11) {
      label = 8;
      break;
    } else {
      var $_5_ph = $10;
      label = 4;
      break;
    }
   case 8:
    _putbits2($gfc, 77, 8);
    var $12 = $remainingBits - 24 | 0;
    var $13 = ($12 | 0) > 7;
    if ($13) {
      label = 9;
      break;
    } else {
      var $_5_ph = $12;
      label = 4;
      break;
    }
   case 9:
    _putbits2($gfc, 69, 8);
    var $15 = $remainingBits - 32 | 0;
    var $16 = ($15 | 0) > 31;
    if ($16) {
      label = 10;
      break;
    } else {
      var $_5_ph = $15;
      label = 4;
      break;
    }
   case 10:
    var $17 = $remainingBits - 40 | 0;
    var $18 = $17 >>> 3;
    var $19 = $18 ^ -1;
    var $20 = $19 >>> 0 > 4294967290;
    var $umax = $20 ? $19 : -6;
    var $21 = $umax << 3;
    var $22 = $21 + $remainingBits | 0;
    var $23 = -$umax | 0;
    var $i_031 = 0;
    label = 11;
    break;
   case 11:
    var $i_031;
    var $25 = $i_031 + 5384648 | 0;
    var $26 = HEAP8[$25];
    var $27 = $26 << 24 >> 24;
    _putbits2($gfc, $27, 8);
    var $28 = $i_031 + 1 | 0;
    var $exitcond = ($28 | 0) == ($23 | 0);
    if ($exitcond) {
      label = 3;
      break;
    } else {
      var $i_031 = $28;
      label = 11;
      break;
    }
   case 12:
    var $_530;
    var $29 = HEAP32[$4 >> 2];
    _putbits2($gfc, $29, 1);
    var $30 = HEAP32[$5 >> 2];
    var $31 = ($30 | 0) == 0;
    var $32 = $31 & 1;
    var $33 = HEAP32[$4 >> 2];
    var $34 = $32 ^ $33;
    HEAP32[$4 >> 2] = $34;
    var $35 = $_530 - 1 | 0;
    var $36 = ($35 | 0) > 0;
    if ($36) {
      var $_530 = $35;
      label = 12;
      break;
    } else {
      label = 13;
      break;
    }
   case 13:
    return;
  }
}
_drain_into_ancillary["X"] = 1;
function _add_dummy_byte($gfc, $val, $n) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($n | 0) == 0;
    if ($1) {
      label = 7;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $2 = $val & 255;
    var $_in = $n;
    label = 5;
    break;
   case 4:
    var $3 = $_in - 1 | 0;
    var $4 = ($3 | 0) == 0;
    if ($4) {
      label = 7;
      break;
    } else {
      var $_in = $3;
      label = 5;
      break;
    }
   case 5:
    var $_in;
    _putbits_noheaders($gfc, $2);
    var $i_06 = 0;
    label = 6;
    break;
   case 6:
    var $i_06;
    var $7 = $gfc + 39836 + $i_06 * 48 | 0;
    var $8 = HEAP32[$7 >> 2];
    var $9 = $8 + 8 | 0;
    HEAP32[$7 >> 2] = $9;
    var $10 = $i_06 + 1 | 0;
    var $exitcond = ($10 | 0) == 256;
    if ($exitcond) {
      label = 4;
      break;
    } else {
      var $i_06 = $10;
      label = 6;
      break;
    }
   case 7:
    return;
  }
}
function _format_bitstream($gfc) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 4 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $nbytes = __stackBase__;
    var $1 = _getframebits($gfc);
    var $2 = $gfc + 21320 | 0;
    var $3 = HEAP32[$2 >> 2];
    _drain_into_ancillary($gfc, $3);
    _encodeSideInfo2($gfc, $1);
    var $4 = $gfc + 24 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = $5 << 3;
    var $7 = _writeMainData($gfc);
    var $8 = $6 + $7 | 0;
    var $9 = $gfc + 21324 | 0;
    var $10 = HEAP32[$9 >> 2];
    _drain_into_ancillary($gfc, $10);
    var $11 = HEAP32[$9 >> 2];
    var $12 = $8 + $11 | 0;
    var $13 = $1 - $12 | 0;
    var $14 = ($13 | 0) / 8 & -1;
    var $15 = $gfc + 21312 | 0;
    var $16 = HEAP32[$15 >> 2];
    var $17 = $16 + $14 | 0;
    HEAP32[$15 >> 2] = $17;
    var $18 = _compute_flushbits($gfc, $nbytes);
    var $19 = $gfc + 52136 | 0;
    var $20 = HEAP32[$19 >> 2];
    var $21 = ($18 | 0) == ($20 | 0);
    if ($21) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    _lame_errorf($gfc, 5387412, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    label = 4;
    break;
   case 4:
    var $24 = HEAP32[$15 >> 2];
    var $25 = $24 << 3;
    var $26 = HEAP32[$19 >> 2];
    var $27 = ($25 | 0) == ($26 | 0);
    if ($27) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $29 = HEAP32[$9 >> 2];
    var $30 = HEAP32[$2 >> 2];
    var $31 = HEAP32[$4 >> 2];
    var $32 = $31 << 3;
    var $33 = $12 - $29 | 0;
    var $34 = $33 - $32 | 0;
    var $35 = ($12 | 0) % 8;
    _lame_errorf($gfc, 5385708, (tempInt = STACKTOP, STACKTOP = STACKTOP + 36 | 0, HEAP32[tempInt >> 2] = $25, HEAP32[tempInt + 4 >> 2] = $26, HEAP32[tempInt + 8 >> 2] = $29, HEAP32[tempInt + 12 >> 2] = $30, HEAP32[tempInt + 16 >> 2] = $32, HEAP32[tempInt + 20 >> 2] = $34, HEAP32[tempInt + 24 >> 2] = $12, HEAP32[tempInt + 28 >> 2] = $35, HEAP32[tempInt + 32 >> 2] = $1, tempInt));
    _lame_errorf($gfc, 5385296, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    _lame_errorf($gfc, 5384952, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    _lame_errorf($gfc, 5384476, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    _lame_errorf($gfc, 5384064, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    var $36 = HEAP32[$15 >> 2];
    var $37 = $36 << 3;
    HEAP32[$19 >> 2] = $37;
    label = 6;
    break;
   case 6:
    var $39 = $gfc + 292 | 0;
    var $40 = HEAP32[$39 >> 2];
    var $41 = ($40 | 0) > 1e9;
    if ($41) {
      label = 7;
      break;
    } else {
      label = 10;
      break;
    }
   case 7:
    var $42 = HEAP32[$39 >> 2];
    var $i_042 = 0;
    label = 8;
    break;
   case 8:
    var $i_042;
    var $44 = $gfc + 39836 + $i_042 * 48 | 0;
    var $45 = HEAP32[$44 >> 2];
    var $46 = $45 - $42 | 0;
    HEAP32[$44 >> 2] = $46;
    var $47 = $i_042 + 1 | 0;
    var $exitcond = ($47 | 0) == 256;
    if ($exitcond) {
      label = 9;
      break;
    } else {
      var $i_042 = $47;
      label = 8;
      break;
    }
   case 9:
    HEAP32[$39 >> 2] = 0;
    label = 10;
    break;
   case 10:
    STACKTOP = __stackBase__;
    return 0;
  }
}
_format_bitstream["X"] = 1;
function _encodeSideInfo2($gfc, $bitsPerFrame) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 52124 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $gfc + 39836 + $2 * 48 + 4 | 0;
    HEAP32[$3 >> 2] = 0;
    var $4 = HEAP32[$1 >> 2];
    var $5 = $gfc + 39836 + $4 * 48 + 8 | 0;
    var $6 = $gfc + 24 | 0;
    var $7 = HEAP32[$6 >> 2];
    _memset($5, 0, $7);
    var $8 = $gfc + 64 | 0;
    var $9 = HEAP32[$8 >> 2];
    var $10 = ($9 | 0) < 16e3;
    if ($10) {
      label = 3;
      break;
    } else {
      label = 4;
      break;
    }
   case 3:
    _writeheader($gfc, 4094, 12);
    label = 5;
    break;
   case 4:
    _writeheader($gfc, 4095, 12);
    label = 5;
    break;
   case 5:
    var $14 = $gfc + 16 | 0;
    var $15 = HEAP32[$14 >> 2];
    _writeheader($gfc, $15, 1);
    _writeheader($gfc, 1, 2);
    var $16 = $gfc + 160 | 0;
    var $17 = HEAP32[$16 >> 2];
    var $18 = ($17 | 0) == 0;
    var $19 = $18 & 1;
    _writeheader($gfc, $19, 1);
    var $20 = $gfc + 84740 | 0;
    var $21 = HEAP32[$20 >> 2];
    _writeheader($gfc, $21, 4);
    var $22 = $gfc + 20 | 0;
    var $23 = HEAP32[$22 >> 2];
    _writeheader($gfc, $23, 2);
    var $24 = $gfc + 84748 | 0;
    var $25 = HEAP32[$24 >> 2];
    _writeheader($gfc, $25, 1);
    var $26 = $gfc + 172 | 0;
    var $27 = HEAP32[$26 >> 2];
    _writeheader($gfc, $27, 1);
    var $28 = $gfc + 180 | 0;
    var $29 = HEAP32[$28 >> 2];
    _writeheader($gfc, $29, 2);
    var $30 = $gfc + 84752 | 0;
    var $31 = HEAP32[$30 >> 2];
    _writeheader($gfc, $31, 2);
    var $32 = $gfc + 164 | 0;
    var $33 = HEAP32[$32 >> 2];
    _writeheader($gfc, $33, 1);
    var $34 = $gfc + 168 | 0;
    var $35 = HEAP32[$34 >> 2];
    _writeheader($gfc, $35, 1);
    var $36 = $gfc + 176 | 0;
    var $37 = HEAP32[$36 >> 2];
    _writeheader($gfc, $37, 2);
    var $38 = HEAP32[$16 >> 2];
    var $39 = ($38 | 0) == 0;
    if ($39) {
      label = 7;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    _writeheader($gfc, 0, 16);
    label = 7;
    break;
   case 7:
    var $42 = HEAP32[$14 >> 2];
    var $43 = ($42 | 0) == 1;
    var $44 = $gfc + 21312 | 0;
    var $45 = HEAP32[$44 >> 2];
    if ($43) {
      label = 8;
      break;
    } else {
      label = 30;
      break;
    }
   case 8:
    _writeheader($gfc, $45, 9);
    var $47 = $gfc + 72 | 0;
    var $48 = HEAP32[$47 >> 2];
    var $49 = ($48 | 0) == 2;
    var $50 = $gfc + 21316 | 0;
    var $51 = HEAP32[$50 >> 2];
    if ($49) {
      label = 9;
      break;
    } else {
      label = 10;
      break;
    }
   case 9:
    _writeheader($gfc, $51, 3);
    label = 11;
    break;
   case 10:
    _writeheader($gfc, $51, 5);
    label = 11;
    break;
   case 11:
    var $54 = HEAP32[$47 >> 2];
    var $55 = ($54 | 0) > 0;
    if ($55) {
      var $ch_0181 = 0;
      label = 12;
      break;
    } else {
      var $gr_0176 = 0;
      var $67 = $54;
      label = 14;
      break;
    }
   case 12:
    var $ch_0181;
    var $56 = $gfc + 21328 + ($ch_0181 << 4) | 0;
    var $57 = HEAP32[$56 >> 2];
    _writeheader($gfc, $57, 1);
    var $58 = $gfc + 21328 + ($ch_0181 << 4) + 4 | 0;
    var $59 = HEAP32[$58 >> 2];
    _writeheader($gfc, $59, 1);
    var $60 = $gfc + 21328 + ($ch_0181 << 4) + 8 | 0;
    var $61 = HEAP32[$60 >> 2];
    _writeheader($gfc, $61, 1);
    var $62 = $gfc + 21328 + ($ch_0181 << 4) + 12 | 0;
    var $63 = HEAP32[$62 >> 2];
    _writeheader($gfc, $63, 1);
    var $64 = $ch_0181 + 1 | 0;
    var $65 = HEAP32[$47 >> 2];
    var $66 = ($64 | 0) < ($65 | 0);
    if ($66) {
      var $ch_0181 = $64;
      label = 12;
      break;
    } else {
      var $gr_0176 = 0;
      var $67 = $65;
      label = 14;
      break;
    }
   case 13:
    var $_pr = HEAP32[$47 >> 2];
    var $gr_0176 = $139;
    var $67 = $_pr;
    label = 14;
    break;
   case 14:
    var $67;
    var $gr_0176;
    var $68 = ($67 | 0) > 0;
    if ($68) {
      var $ch_1173 = 0;
      label = 15;
      break;
    } else {
      label = 29;
      break;
    }
   case 15:
    var $ch_1173;
    var $69 = $gfc + 304 + $gr_0176 * 10504 + $ch_1173 * 5252 + 4768 | 0;
    var $70 = HEAP32[$69 >> 2];
    var $71 = $gfc + 304 + $gr_0176 * 10504 + $ch_1173 * 5252 + 4844 | 0;
    var $72 = HEAP32[$71 >> 2];
    var $73 = $72 + $70 | 0;
    _writeheader($gfc, $73, 12);
    var $74 = $gfc + 304 + $gr_0176 * 10504 + $ch_1173 * 5252 + 4772 | 0;
    var $75 = HEAP32[$74 >> 2];
    var $76 = ($75 | 0) / 2 & -1;
    _writeheader($gfc, $76, 9);
    var $77 = $gfc + 304 + $gr_0176 * 10504 + $ch_1173 * 5252 + 4780 | 0;
    var $78 = HEAP32[$77 >> 2];
    _writeheader($gfc, $78, 8);
    var $79 = $gfc + 304 + $gr_0176 * 10504 + $ch_1173 * 5252 + 4784 | 0;
    var $80 = HEAP32[$79 >> 2];
    _writeheader($gfc, $80, 4);
    var $81 = $gfc + 304 + $gr_0176 * 10504 + $ch_1173 * 5252 + 4788 | 0;
    var $82 = HEAP32[$81 >> 2];
    var $83 = ($82 | 0) == 0;
    if ($83) {
      label = 21;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    _writeheader($gfc, 1, 1);
    var $85 = HEAP32[$81 >> 2];
    _writeheader($gfc, $85, 2);
    var $86 = $gfc + 304 + $gr_0176 * 10504 + $ch_1173 * 5252 + 4792 | 0;
    var $87 = HEAP32[$86 >> 2];
    _writeheader($gfc, $87, 1);
    var $88 = $gfc + 304 + $gr_0176 * 10504 + $ch_1173 * 5252 + 4796 | 0;
    var $89 = HEAP32[$88 >> 2];
    var $90 = ($89 | 0) == 14;
    if ($90) {
      label = 17;
      break;
    } else {
      label = 18;
      break;
    }
   case 17:
    HEAP32[$88 >> 2] = 16;
    label = 18;
    break;
   case 18:
    var $93 = HEAP32[$88 >> 2];
    _writeheader($gfc, $93, 5);
    var $94 = $gfc + 304 + $gr_0176 * 10504 + $ch_1173 * 5252 + 4800 | 0;
    var $95 = HEAP32[$94 >> 2];
    var $96 = ($95 | 0) == 14;
    if ($96) {
      label = 19;
      break;
    } else {
      label = 20;
      break;
    }
   case 19:
    HEAP32[$94 >> 2] = 16;
    label = 20;
    break;
   case 20:
    var $99 = HEAP32[$94 >> 2];
    _writeheader($gfc, $99, 5);
    var $100 = $gfc + 304 + $gr_0176 * 10504 + $ch_1173 * 5252 + 4808 | 0;
    var $101 = HEAP32[$100 >> 2];
    _writeheader($gfc, $101, 3);
    var $102 = $gfc + 304 + $gr_0176 * 10504 + $ch_1173 * 5252 + 4812 | 0;
    var $103 = HEAP32[$102 >> 2];
    _writeheader($gfc, $103, 3);
    var $104 = $gfc + 304 + $gr_0176 * 10504 + $ch_1173 * 5252 + 4816 | 0;
    var $105 = HEAP32[$104 >> 2];
    _writeheader($gfc, $105, 3);
    label = 28;
    break;
   case 21:
    _writeheader($gfc, 0, 1);
    var $107 = $gfc + 304 + $gr_0176 * 10504 + $ch_1173 * 5252 + 4796 | 0;
    var $108 = HEAP32[$107 >> 2];
    var $109 = ($108 | 0) == 14;
    if ($109) {
      label = 22;
      break;
    } else {
      label = 23;
      break;
    }
   case 22:
    HEAP32[$107 >> 2] = 16;
    label = 23;
    break;
   case 23:
    var $112 = HEAP32[$107 >> 2];
    _writeheader($gfc, $112, 5);
    var $113 = $gfc + 304 + $gr_0176 * 10504 + $ch_1173 * 5252 + 4800 | 0;
    var $114 = HEAP32[$113 >> 2];
    var $115 = ($114 | 0) == 14;
    if ($115) {
      label = 24;
      break;
    } else {
      label = 25;
      break;
    }
   case 24:
    HEAP32[$113 >> 2] = 16;
    label = 25;
    break;
   case 25:
    var $118 = HEAP32[$113 >> 2];
    _writeheader($gfc, $118, 5);
    var $119 = $gfc + 304 + $gr_0176 * 10504 + $ch_1173 * 5252 + 4804 | 0;
    var $120 = HEAP32[$119 >> 2];
    var $121 = ($120 | 0) == 14;
    if ($121) {
      label = 26;
      break;
    } else {
      label = 27;
      break;
    }
   case 26:
    HEAP32[$119 >> 2] = 16;
    label = 27;
    break;
   case 27:
    var $124 = HEAP32[$119 >> 2];
    _writeheader($gfc, $124, 5);
    var $125 = $gfc + 304 + $gr_0176 * 10504 + $ch_1173 * 5252 + 4824 | 0;
    var $126 = HEAP32[$125 >> 2];
    _writeheader($gfc, $126, 4);
    var $127 = $gfc + 304 + $gr_0176 * 10504 + $ch_1173 * 5252 + 4828 | 0;
    var $128 = HEAP32[$127 >> 2];
    _writeheader($gfc, $128, 3);
    label = 28;
    break;
   case 28:
    var $130 = $gfc + 304 + $gr_0176 * 10504 + $ch_1173 * 5252 + 4832 | 0;
    var $131 = HEAP32[$130 >> 2];
    _writeheader($gfc, $131, 1);
    var $132 = $gfc + 304 + $gr_0176 * 10504 + $ch_1173 * 5252 + 4836 | 0;
    var $133 = HEAP32[$132 >> 2];
    _writeheader($gfc, $133, 1);
    var $134 = $gfc + 304 + $gr_0176 * 10504 + $ch_1173 * 5252 + 4840 | 0;
    var $135 = HEAP32[$134 >> 2];
    _writeheader($gfc, $135, 1);
    var $136 = $ch_1173 + 1 | 0;
    var $137 = HEAP32[$47 >> 2];
    var $138 = ($136 | 0) < ($137 | 0);
    if ($138) {
      var $ch_1173 = $136;
      label = 15;
      break;
    } else {
      label = 29;
      break;
    }
   case 29:
    var $139 = $gr_0176 + 1 | 0;
    var $exitcond = ($139 | 0) == 2;
    if ($exitcond) {
      label = 45;
      break;
    } else {
      label = 13;
      break;
    }
   case 30:
    _writeheader($gfc, $45, 8);
    var $141 = $gfc + 21316 | 0;
    var $142 = HEAP32[$141 >> 2];
    var $143 = $gfc + 72 | 0;
    var $144 = HEAP32[$143 >> 2];
    _writeheader($gfc, $142, $144);
    var $145 = HEAP32[$143 >> 2];
    var $146 = ($145 | 0) > 0;
    if ($146) {
      var $ch_2183 = 0;
      label = 31;
      break;
    } else {
      label = 45;
      break;
    }
   case 31:
    var $ch_2183;
    var $147 = $gfc + 304 + $ch_2183 * 5252 + 4768 | 0;
    var $148 = HEAP32[$147 >> 2];
    var $149 = $gfc + 304 + $ch_2183 * 5252 + 4844 | 0;
    var $150 = HEAP32[$149 >> 2];
    var $151 = $150 + $148 | 0;
    _writeheader($gfc, $151, 12);
    var $152 = $gfc + 304 + $ch_2183 * 5252 + 4772 | 0;
    var $153 = HEAP32[$152 >> 2];
    var $154 = ($153 | 0) / 2 & -1;
    _writeheader($gfc, $154, 9);
    var $155 = $gfc + 304 + $ch_2183 * 5252 + 4780 | 0;
    var $156 = HEAP32[$155 >> 2];
    _writeheader($gfc, $156, 8);
    var $157 = $gfc + 304 + $ch_2183 * 5252 + 4784 | 0;
    var $158 = HEAP32[$157 >> 2];
    _writeheader($gfc, $158, 9);
    var $159 = $gfc + 304 + $ch_2183 * 5252 + 4788 | 0;
    var $160 = HEAP32[$159 >> 2];
    var $161 = ($160 | 0) == 0;
    if ($161) {
      label = 37;
      break;
    } else {
      label = 32;
      break;
    }
   case 32:
    _writeheader($gfc, 1, 1);
    var $163 = HEAP32[$159 >> 2];
    _writeheader($gfc, $163, 2);
    var $164 = $gfc + 304 + $ch_2183 * 5252 + 4792 | 0;
    var $165 = HEAP32[$164 >> 2];
    _writeheader($gfc, $165, 1);
    var $166 = $gfc + 304 + $ch_2183 * 5252 + 4796 | 0;
    var $167 = HEAP32[$166 >> 2];
    var $168 = ($167 | 0) == 14;
    if ($168) {
      label = 33;
      break;
    } else {
      label = 34;
      break;
    }
   case 33:
    HEAP32[$166 >> 2] = 16;
    label = 34;
    break;
   case 34:
    var $171 = HEAP32[$166 >> 2];
    _writeheader($gfc, $171, 5);
    var $172 = $gfc + 304 + $ch_2183 * 5252 + 4800 | 0;
    var $173 = HEAP32[$172 >> 2];
    var $174 = ($173 | 0) == 14;
    if ($174) {
      label = 35;
      break;
    } else {
      label = 36;
      break;
    }
   case 35:
    HEAP32[$172 >> 2] = 16;
    label = 36;
    break;
   case 36:
    var $177 = HEAP32[$172 >> 2];
    _writeheader($gfc, $177, 5);
    var $178 = $gfc + 304 + $ch_2183 * 5252 + 4808 | 0;
    var $179 = HEAP32[$178 >> 2];
    _writeheader($gfc, $179, 3);
    var $180 = $gfc + 304 + $ch_2183 * 5252 + 4812 | 0;
    var $181 = HEAP32[$180 >> 2];
    _writeheader($gfc, $181, 3);
    var $182 = $gfc + 304 + $ch_2183 * 5252 + 4816 | 0;
    var $183 = HEAP32[$182 >> 2];
    _writeheader($gfc, $183, 3);
    label = 44;
    break;
   case 37:
    _writeheader($gfc, 0, 1);
    var $185 = $gfc + 304 + $ch_2183 * 5252 + 4796 | 0;
    var $186 = HEAP32[$185 >> 2];
    var $187 = ($186 | 0) == 14;
    if ($187) {
      label = 38;
      break;
    } else {
      label = 39;
      break;
    }
   case 38:
    HEAP32[$185 >> 2] = 16;
    label = 39;
    break;
   case 39:
    var $190 = HEAP32[$185 >> 2];
    _writeheader($gfc, $190, 5);
    var $191 = $gfc + 304 + $ch_2183 * 5252 + 4800 | 0;
    var $192 = HEAP32[$191 >> 2];
    var $193 = ($192 | 0) == 14;
    if ($193) {
      label = 40;
      break;
    } else {
      label = 41;
      break;
    }
   case 40:
    HEAP32[$191 >> 2] = 16;
    label = 41;
    break;
   case 41:
    var $196 = HEAP32[$191 >> 2];
    _writeheader($gfc, $196, 5);
    var $197 = $gfc + 304 + $ch_2183 * 5252 + 4804 | 0;
    var $198 = HEAP32[$197 >> 2];
    var $199 = ($198 | 0) == 14;
    if ($199) {
      label = 42;
      break;
    } else {
      label = 43;
      break;
    }
   case 42:
    HEAP32[$197 >> 2] = 16;
    label = 43;
    break;
   case 43:
    var $202 = HEAP32[$197 >> 2];
    _writeheader($gfc, $202, 5);
    var $203 = $gfc + 304 + $ch_2183 * 5252 + 4824 | 0;
    var $204 = HEAP32[$203 >> 2];
    _writeheader($gfc, $204, 4);
    var $205 = $gfc + 304 + $ch_2183 * 5252 + 4828 | 0;
    var $206 = HEAP32[$205 >> 2];
    _writeheader($gfc, $206, 3);
    label = 44;
    break;
   case 44:
    var $208 = $gfc + 304 + $ch_2183 * 5252 + 4836 | 0;
    var $209 = HEAP32[$208 >> 2];
    _writeheader($gfc, $209, 1);
    var $210 = $gfc + 304 + $ch_2183 * 5252 + 4840 | 0;
    var $211 = HEAP32[$210 >> 2];
    _writeheader($gfc, $211, 1);
    var $212 = $ch_2183 + 1 | 0;
    var $213 = HEAP32[$143 >> 2];
    var $214 = ($212 | 0) < ($213 | 0);
    if ($214) {
      var $ch_2183 = $212;
      label = 31;
      break;
    } else {
      label = 45;
      break;
    }
   case 45:
    var $215 = HEAP32[$16 >> 2];
    var $216 = ($215 | 0) == 0;
    if ($216) {
      label = 47;
      break;
    } else {
      label = 46;
      break;
    }
   case 46:
    var $218 = HEAP32[$1 >> 2];
    var $219 = $gfc + 39836 + $218 * 48 + 8 | 0;
    _CRC_writeheader($gfc, $219);
    label = 47;
    break;
   case 47:
    var $221 = HEAP32[$1 >> 2];
    var $222 = $221 + 1 | 0;
    var $223 = $222 & 255;
    HEAP32[$1 >> 2] = $223;
    var $224 = $gfc + 39836 + $221 * 48 | 0;
    var $225 = HEAP32[$224 >> 2];
    var $226 = $225 + $bitsPerFrame | 0;
    var $227 = $gfc + 39836 + $223 * 48 | 0;
    HEAP32[$227 >> 2] = $226;
    var $228 = HEAP32[$1 >> 2];
    var $229 = $gfc + 52128 | 0;
    var $230 = HEAP32[$229 >> 2];
    var $231 = ($228 | 0) == ($230 | 0);
    if ($231) {
      label = 48;
      break;
    } else {
      label = 49;
      break;
    }
   case 48:
    _lame_errorf($gfc, 5383632, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    label = 49;
    break;
   case 49:
    STACKTOP = __stackBase__;
    return;
  }
}
_encodeSideInfo2["X"] = 1;
function _writeheader($gfc, $val, $j) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 52124 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $gfc + 39836 + $2 * 48 + 4 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($j | 0) > 0;
    if ($5) {
      var $ptr_019 = $4;
      var $_020 = $j;
      label = 3;
      break;
    } else {
      var $ptr_0_lcssa = $4;
      label = 4;
      break;
    }
   case 3:
    var $_020;
    var $ptr_019;
    var $6 = $ptr_019 & 7;
    var $7 = 8 - $6 | 0;
    var $8 = ($_020 | 0) < ($7 | 0);
    var $_0_ = $8 ? $_020 : $7;
    var $9 = $_020 - $_0_ | 0;
    var $10 = $val >> $9;
    var $11 = $7 - $_0_ | 0;
    var $12 = $10 << $11;
    var $13 = $ptr_019 >> 3;
    var $14 = HEAP32[$1 >> 2];
    var $15 = $gfc + 39836 + $14 * 48 + 8 + $13 | 0;
    var $16 = HEAP8[$15];
    var $17 = $16 & 255;
    var $18 = $17 | $12;
    var $19 = $18 & 255;
    HEAP8[$15] = $19;
    var $20 = $_0_ + $ptr_019 | 0;
    var $21 = ($9 | 0) > 0;
    if ($21) {
      var $ptr_019 = $20;
      var $_020 = $9;
      label = 3;
      break;
    } else {
      var $ptr_0_lcssa = $20;
      label = 4;
      break;
    }
   case 4:
    var $ptr_0_lcssa;
    var $22 = HEAP32[$1 >> 2];
    var $23 = $gfc + 39836 + $22 * 48 + 4 | 0;
    HEAP32[$23 >> 2] = $ptr_0_lcssa;
    return;
  }
}
function _writeMainData($gfc) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 16 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($2 | 0) == 1;
    var $4 = $gfc + 72 | 0;
    if ($3) {
      var $tot_bits_0113 = 0;
      var $gr_0114 = 0;
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $5 = HEAP32[$4 >> 2];
    var $6 = ($5 | 0) > 0;
    if ($6) {
      var $tot_bits_2142 = 0;
      var $ch_1143 = 0;
      label = 18;
      break;
    } else {
      var $tot_bits_3 = 0;
      label = 30;
      break;
    }
   case 4:
    var $gr_0114;
    var $tot_bits_0113;
    var $7 = HEAP32[$4 >> 2];
    var $8 = ($7 | 0) > 0;
    if ($8) {
      var $tot_bits_1104 = $tot_bits_0113;
      var $ch_0105 = 0;
      label = 5;
      break;
    } else {
      var $tot_bits_1_lcssa = $tot_bits_0113;
      label = 17;
      break;
    }
   case 5:
    var $ch_0105;
    var $tot_bits_1104;
    var $9 = $gfc + 304 + $gr_0114 * 10504 + $ch_0105 * 5252 | 0;
    var $10 = $gfc + 304 + $gr_0114 * 10504 + $ch_0105 * 5252 + 4784 | 0;
    var $11 = HEAP32[$10 >> 2];
    var $12 = 5254620 + ($11 << 2) | 0;
    var $13 = HEAP32[$12 >> 2];
    var $14 = 5254492 + ($11 << 2) | 0;
    var $15 = HEAP32[$14 >> 2];
    var $16 = $gfc + 304 + $gr_0114 * 10504 + $ch_0105 * 5252 + 4868 | 0;
    var $17 = HEAP32[$16 >> 2];
    var $18 = ($17 | 0) > 0;
    if ($18) {
      var $data_bits_097 = 0;
      var $sfb_098 = 0;
      label = 6;
      break;
    } else {
      var $data_bits_0_lcssa = 0;
      var $sfb_0_lcssa = 0;
      label = 9;
      break;
    }
   case 6:
    var $sfb_098;
    var $data_bits_097;
    var $19 = $gfc + 304 + $gr_0114 * 10504 + $ch_0105 * 5252 + 4608 + ($sfb_098 << 2) | 0;
    var $20 = HEAP32[$19 >> 2];
    var $21 = ($20 | 0) == -1;
    if ($21) {
      var $data_bits_1 = $data_bits_097;
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    _putbits2($gfc, $20, $13);
    var $23 = $data_bits_097 + $13 | 0;
    var $data_bits_1 = $23;
    label = 8;
    break;
   case 8:
    var $data_bits_1;
    var $25 = $sfb_098 + 1 | 0;
    var $26 = HEAP32[$16 >> 2];
    var $27 = ($25 | 0) < ($26 | 0);
    if ($27) {
      var $data_bits_097 = $data_bits_1;
      var $sfb_098 = $25;
      label = 6;
      break;
    } else {
      var $data_bits_0_lcssa = $data_bits_1;
      var $sfb_0_lcssa = $25;
      label = 9;
      break;
    }
   case 9:
    var $sfb_0_lcssa;
    var $data_bits_0_lcssa;
    var $28 = $gfc + 304 + $gr_0114 * 10504 + $ch_0105 * 5252 + 4860 | 0;
    var $29 = HEAP32[$28 >> 2];
    var $30 = ($sfb_0_lcssa | 0) < ($29 | 0);
    if ($30) {
      var $data_bits_2100 = $data_bits_0_lcssa;
      var $sfb_1101 = $sfb_0_lcssa;
      label = 10;
      break;
    } else {
      var $data_bits_2_lcssa = $data_bits_0_lcssa;
      label = 13;
      break;
    }
   case 10:
    var $sfb_1101;
    var $data_bits_2100;
    var $31 = $gfc + 304 + $gr_0114 * 10504 + $ch_0105 * 5252 + 4608 + ($sfb_1101 << 2) | 0;
    var $32 = HEAP32[$31 >> 2];
    var $33 = ($32 | 0) == -1;
    if ($33) {
      var $data_bits_3 = $data_bits_2100;
      label = 12;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    _putbits2($gfc, $32, $15);
    var $35 = $data_bits_2100 + $15 | 0;
    var $data_bits_3 = $35;
    label = 12;
    break;
   case 12:
    var $data_bits_3;
    var $37 = $sfb_1101 + 1 | 0;
    var $38 = HEAP32[$28 >> 2];
    var $39 = ($37 | 0) < ($38 | 0);
    if ($39) {
      var $data_bits_2100 = $data_bits_3;
      var $sfb_1101 = $37;
      label = 10;
      break;
    } else {
      var $data_bits_2_lcssa = $data_bits_3;
      label = 13;
      break;
    }
   case 13:
    var $data_bits_2_lcssa;
    var $40 = $gfc + 304 + $gr_0114 * 10504 + $ch_0105 * 5252 + 4788 | 0;
    var $41 = HEAP32[$40 >> 2];
    var $42 = ($41 | 0) == 2;
    if ($42) {
      label = 14;
      break;
    } else {
      label = 15;
      break;
    }
   case 14:
    var $44 = _ShortHuffmancodebits($gfc, $9);
    var $_pn = $44;
    label = 16;
    break;
   case 15:
    var $46 = _LongHuffmancodebits($gfc, $9);
    var $_pn = $46;
    label = 16;
    break;
   case 16:
    var $_pn;
    var $48 = _huffman_coder_count1($gfc, $9);
    var $data_bits_4 = $data_bits_2_lcssa + $tot_bits_1104 | 0;
    var $49 = $data_bits_4 + $_pn | 0;
    var $50 = $49 + $48 | 0;
    var $51 = $ch_0105 + 1 | 0;
    var $52 = HEAP32[$4 >> 2];
    var $53 = ($51 | 0) < ($52 | 0);
    if ($53) {
      var $tot_bits_1104 = $50;
      var $ch_0105 = $51;
      label = 5;
      break;
    } else {
      var $tot_bits_1_lcssa = $50;
      label = 17;
      break;
    }
   case 17:
    var $tot_bits_1_lcssa;
    var $54 = $gr_0114 + 1 | 0;
    var $exitcond = ($54 | 0) == 2;
    if ($exitcond) {
      var $tot_bits_3 = $tot_bits_1_lcssa;
      label = 30;
      break;
    } else {
      var $tot_bits_0113 = $tot_bits_1_lcssa;
      var $gr_0114 = $54;
      label = 4;
      break;
    }
   case 18:
    var $ch_1143;
    var $tot_bits_2142;
    var $55 = $gfc + 304 + $ch_1143 * 5252 | 0;
    var $56 = $gfc + 304 + $ch_1143 * 5252 + 4788 | 0;
    var $57 = HEAP32[$56 >> 2];
    var $58 = ($57 | 0) == 2;
    var $59 = $gfc + 304 + $ch_1143 * 5252 + 5188 | 0;
    if ($58) {
      var $sfb_partition_0137 = 0;
      var $scale_bits_0138 = 0;
      var $sfb_2139 = 0;
      label = 19;
      break;
    } else {
      label = 25;
      break;
    }
   case 19:
    var $sfb_2139;
    var $scale_bits_0138;
    var $sfb_partition_0137;
    var $60 = HEAP32[$59 >> 2];
    var $61 = $60 + ($sfb_partition_0137 << 2) | 0;
    var $62 = HEAP32[$61 >> 2];
    var $63 = ($62 | 0) / 3 & -1;
    var $64 = $gfc + 304 + $ch_1143 * 5252 + 5192 + ($sfb_partition_0137 << 2) | 0;
    var $65 = HEAP32[$64 >> 2];
    var $66 = ($62 | 0) > 2;
    if ($66) {
      label = 20;
      break;
    } else {
      var $scale_bits_1_lcssa = $scale_bits_0138;
      var $sfb_3_lcssa = $sfb_2139;
      label = 23;
      break;
    }
   case 20:
    var $67 = $65 * 3 & -1;
    var $68 = ($63 | 0) > 1;
    var $smax = $68 ? $63 : 1;
    var $69 = $67 * $smax & -1;
    var $i_0128 = 0;
    var $sfb_3130 = $sfb_2139;
    label = 21;
    break;
   case 21:
    var $sfb_3130;
    var $i_0128;
    var $71 = $sfb_3130 * 3 & -1;
    var $72 = $gfc + 304 + $ch_1143 * 5252 + 4608 + ($71 << 2) | 0;
    var $73 = HEAP32[$72 >> 2];
    var $74 = ($73 | 0) > 0;
    var $_ = $74 ? $73 : 0;
    _putbits2($gfc, $_, $65);
    var $75 = $71 + 1 | 0;
    var $76 = $gfc + 304 + $ch_1143 * 5252 + 4608 + ($75 << 2) | 0;
    var $77 = HEAP32[$76 >> 2];
    var $78 = ($77 | 0) > 0;
    var $79 = $78 ? $77 : 0;
    _putbits2($gfc, $79, $65);
    var $80 = $71 + 2 | 0;
    var $81 = $gfc + 304 + $ch_1143 * 5252 + 4608 + ($80 << 2) | 0;
    var $82 = HEAP32[$81 >> 2];
    var $83 = ($82 | 0) > 0;
    var $_95 = $83 ? $82 : 0;
    _putbits2($gfc, $_95, $65);
    var $84 = $i_0128 + 1 | 0;
    var $85 = $sfb_3130 + 1 | 0;
    var $86 = ($84 | 0) < ($63 | 0);
    if ($86) {
      var $i_0128 = $84;
      var $sfb_3130 = $85;
      label = 21;
      break;
    } else {
      label = 22;
      break;
    }
   case 22:
    var $87 = $sfb_2139 + $smax | 0;
    var $88 = $scale_bits_0138 + $69 | 0;
    var $scale_bits_1_lcssa = $88;
    var $sfb_3_lcssa = $87;
    label = 23;
    break;
   case 23:
    var $sfb_3_lcssa;
    var $scale_bits_1_lcssa;
    var $90 = $sfb_partition_0137 + 1 | 0;
    var $exitcond154 = ($90 | 0) == 4;
    if ($exitcond154) {
      label = 24;
      break;
    } else {
      var $sfb_partition_0137 = $90;
      var $scale_bits_0138 = $scale_bits_1_lcssa;
      var $sfb_2139 = $sfb_3_lcssa;
      label = 19;
      break;
    }
   case 24:
    var $92 = _ShortHuffmancodebits($gfc, $55);
    var $data_bits_5 = $92;
    var $scale_bits_4 = $scale_bits_1_lcssa;
    label = 29;
    break;
   case 25:
    var $94 = HEAP32[$59 >> 2];
    var $95 = HEAP32[$94 >> 2];
    var $96 = $gfc + 304 + $ch_1143 * 5252 + 5192 | 0;
    var $97 = HEAP32[$96 >> 2];
    var $98 = ($95 | 0) > 0;
    if ($98) {
      label = 26;
      break;
    } else {
      var $scale_bits_3_lcssa = 0;
      var $sfb_5_lcssa = 0;
      label = 28;
      break;
    }
   case 26:
    var $99 = $97 * $95 & -1;
    var $i_1116 = 0;
    var $sfb_5118 = 0;
    label = 27;
    break;
   case 27:
    var $sfb_5118;
    var $i_1116;
    var $101 = $gfc + 304 + $ch_1143 * 5252 + 4608 + ($sfb_5118 << 2) | 0;
    var $102 = HEAP32[$101 >> 2];
    var $103 = ($102 | 0) > 0;
    var $_96 = $103 ? $102 : 0;
    _putbits2($gfc, $_96, $97);
    var $104 = $i_1116 + 1 | 0;
    var $105 = $sfb_5118 + 1 | 0;
    var $exitcond150 = ($104 | 0) == ($95 | 0);
    if ($exitcond150) {
      var $scale_bits_3_lcssa = $99;
      var $sfb_5_lcssa = $95;
      label = 28;
      break;
    } else {
      var $i_1116 = $104;
      var $sfb_5118 = $105;
      label = 27;
      break;
    }
   case 28:
    var $sfb_5_lcssa;
    var $scale_bits_3_lcssa;
    var $106 = HEAP32[$59 >> 2];
    var $107 = $106 + 4 | 0;
    var $108 = HEAP32[$107 >> 2];
    var $109 = $gfc + 304 + $ch_1143 * 5252 + 5196 | 0;
    var $110 = HEAP32[$109 >> 2];
    var $111 = ($108 | 0) > 0;
    if ($111) {
      label = 31;
      break;
    } else {
      var $scale_bits_3_lcssa_1 = $scale_bits_3_lcssa;
      var $sfb_5_lcssa_1 = $sfb_5_lcssa;
      label = 34;
      break;
    }
   case 29:
    var $scale_bits_4;
    var $data_bits_5;
    var $113 = _huffman_coder_count1($gfc, $55);
    var $114 = $scale_bits_4 + $tot_bits_2142 | 0;
    var $115 = $114 + $data_bits_5 | 0;
    var $116 = $115 + $113 | 0;
    var $117 = $ch_1143 + 1 | 0;
    var $118 = HEAP32[$4 >> 2];
    var $119 = ($117 | 0) < ($118 | 0);
    if ($119) {
      var $tot_bits_2142 = $116;
      var $ch_1143 = $117;
      label = 18;
      break;
    } else {
      var $tot_bits_3 = $116;
      label = 30;
      break;
    }
   case 30:
    var $tot_bits_3;
    return $tot_bits_3;
   case 31:
    var $120 = $110 * $108 & -1;
    var $i_1116_1 = 0;
    var $sfb_5118_1 = $sfb_5_lcssa;
    label = 32;
    break;
   case 32:
    var $sfb_5118_1;
    var $i_1116_1;
    var $122 = $gfc + 304 + $ch_1143 * 5252 + 4608 + ($sfb_5118_1 << 2) | 0;
    var $123 = HEAP32[$122 >> 2];
    var $124 = ($123 | 0) > 0;
    var $_96_1 = $124 ? $123 : 0;
    _putbits2($gfc, $_96_1, $110);
    var $125 = $i_1116_1 + 1 | 0;
    var $126 = $sfb_5118_1 + 1 | 0;
    var $exitcond150_1 = ($125 | 0) == ($108 | 0);
    if ($exitcond150_1) {
      label = 33;
      break;
    } else {
      var $i_1116_1 = $125;
      var $sfb_5118_1 = $126;
      label = 32;
      break;
    }
   case 33:
    var $127 = $sfb_5_lcssa + $108 | 0;
    var $128 = $scale_bits_3_lcssa + $120 | 0;
    var $scale_bits_3_lcssa_1 = $128;
    var $sfb_5_lcssa_1 = $127;
    label = 34;
    break;
   case 34:
    var $sfb_5_lcssa_1;
    var $scale_bits_3_lcssa_1;
    var $130 = HEAP32[$59 >> 2];
    var $131 = $130 + 8 | 0;
    var $132 = HEAP32[$131 >> 2];
    var $133 = $gfc + 304 + $ch_1143 * 5252 + 5200 | 0;
    var $134 = HEAP32[$133 >> 2];
    var $135 = ($132 | 0) > 0;
    if ($135) {
      label = 35;
      break;
    } else {
      var $scale_bits_3_lcssa_2 = $scale_bits_3_lcssa_1;
      var $sfb_5_lcssa_2 = $sfb_5_lcssa_1;
      label = 38;
      break;
    }
   case 35:
    var $136 = $134 * $132 & -1;
    var $i_1116_2 = 0;
    var $sfb_5118_2 = $sfb_5_lcssa_1;
    label = 36;
    break;
   case 36:
    var $sfb_5118_2;
    var $i_1116_2;
    var $138 = $gfc + 304 + $ch_1143 * 5252 + 4608 + ($sfb_5118_2 << 2) | 0;
    var $139 = HEAP32[$138 >> 2];
    var $140 = ($139 | 0) > 0;
    var $_96_2 = $140 ? $139 : 0;
    _putbits2($gfc, $_96_2, $134);
    var $141 = $i_1116_2 + 1 | 0;
    var $142 = $sfb_5118_2 + 1 | 0;
    var $exitcond150_2 = ($141 | 0) == ($132 | 0);
    if ($exitcond150_2) {
      label = 37;
      break;
    } else {
      var $i_1116_2 = $141;
      var $sfb_5118_2 = $142;
      label = 36;
      break;
    }
   case 37:
    var $143 = $sfb_5_lcssa_1 + $132 | 0;
    var $144 = $scale_bits_3_lcssa_1 + $136 | 0;
    var $scale_bits_3_lcssa_2 = $144;
    var $sfb_5_lcssa_2 = $143;
    label = 38;
    break;
   case 38:
    var $sfb_5_lcssa_2;
    var $scale_bits_3_lcssa_2;
    var $146 = HEAP32[$59 >> 2];
    var $147 = $146 + 12 | 0;
    var $148 = HEAP32[$147 >> 2];
    var $149 = $gfc + 304 + $ch_1143 * 5252 + 5204 | 0;
    var $150 = HEAP32[$149 >> 2];
    var $151 = ($148 | 0) > 0;
    if ($151) {
      label = 39;
      break;
    } else {
      var $scale_bits_3_lcssa_3 = $scale_bits_3_lcssa_2;
      label = 42;
      break;
    }
   case 39:
    var $152 = $150 * $148 & -1;
    var $i_1116_3 = 0;
    var $sfb_5118_3 = $sfb_5_lcssa_2;
    label = 40;
    break;
   case 40:
    var $sfb_5118_3;
    var $i_1116_3;
    var $154 = $gfc + 304 + $ch_1143 * 5252 + 4608 + ($sfb_5118_3 << 2) | 0;
    var $155 = HEAP32[$154 >> 2];
    var $156 = ($155 | 0) > 0;
    var $_96_3 = $156 ? $155 : 0;
    _putbits2($gfc, $_96_3, $150);
    var $157 = $i_1116_3 + 1 | 0;
    var $158 = $sfb_5118_3 + 1 | 0;
    var $exitcond150_3 = ($157 | 0) == ($148 | 0);
    if ($exitcond150_3) {
      label = 41;
      break;
    } else {
      var $i_1116_3 = $157;
      var $sfb_5118_3 = $158;
      label = 40;
      break;
    }
   case 41:
    var $159 = $scale_bits_3_lcssa_2 + $152 | 0;
    var $scale_bits_3_lcssa_3 = $159;
    label = 42;
    break;
   case 42:
    var $scale_bits_3_lcssa_3;
    var $161 = _LongHuffmancodebits($gfc, $55);
    var $data_bits_5 = $161;
    var $scale_bits_4 = $scale_bits_3_lcssa_3;
    label = 29;
    break;
  }
}
_writeMainData["X"] = 1;
function _copy_buffer($gfc, $buffer, $size, $mp3data) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = _do_copy_buffer($gfc, $buffer, $size);
    var $2 = ($1 | 0) < 1;
    var $3 = ($mp3data | 0) == 0;
    var $or_cond = $2 | $3;
    if ($or_cond) {
      var $_0 = $1;
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $5 = $gfc + 85748 | 0;
    _UpdateMusicCRC($5, $buffer, $1);
    var $6 = $gfc + 85784 | 0;
    var $7 = HEAP32[$6 >> 2];
    var $8 = $7 + $1 | 0;
    HEAP32[$6 >> 2] = $8;
    var $9 = _do_gain_analysis($gfc, $buffer, $1);
    var $_0 = $9;
    label = 4;
    break;
   case 4:
    var $_0;
    return $_0;
  }
}
function _do_copy_buffer($gfc, $buffer, $size) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 296 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $2 + 1 | 0;
    var $4 = ($2 | 0) < 0;
    if ($4) {
      var $_0 = 0;
      label = 5;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $6 = ($size | 0) != 0;
    var $7 = ($3 | 0) > ($size | 0);
    var $or_cond = $6 & $7;
    if ($or_cond) {
      var $_0 = -1;
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $9 = $gfc + 284 | 0;
    var $10 = HEAP32[$9 >> 2];
    _memcpy($buffer, $10, $3);
    HEAP32[$1 >> 2] = -1;
    var $11 = $gfc + 300 | 0;
    HEAP32[$11 >> 2] = 0;
    var $_0 = $3;
    label = 5;
    break;
   case 5:
    var $_0;
    return $_0;
  }
}
function _do_gain_analysis($gfc, $buffer, $minimum) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 9216 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $pcm_buf = __stackBase__;
    var $1 = $gfc + 136 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($2 | 0) == 0;
    if ($3) {
      var $_0 = $minimum;
      label = 21;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $4 = $gfc + 85672 | 0;
    var $5 = $gfc + 85804 | 0;
    var $6 = $pcm_buf | 0;
    var $7 = $pcm_buf + 4608 | 0;
    var $8 = $gfc + 132 | 0;
    var $9 = $gfc + 128 | 0;
    var $10 = $gfc + 72 | 0;
    var $11 = $gfc + 72 | 0;
    var $12 = $gfc + 85680 | 0;
    var $13 = $gfc + 85680 | 0;
    var $mp3_in_039 = $minimum;
    label = 4;
    break;
   case 4:
    var $mp3_in_039;
    var $15 = HEAP32[$5 >> 2];
    var $16 = _hip_decode1_unclipped($15, $buffer, $mp3_in_039, $6, $7);
    var $17 = ($16 | 0) == -1;
    var $_ = $17 ? 0 : $16;
    var $18 = ($_ | 0) > 0;
    if ($18) {
      label = 5;
      break;
    } else {
      label = 20;
      break;
    }
   case 5:
    var $20 = HEAP32[$8 >> 2];
    var $21 = ($20 | 0) == 0;
    if ($21) {
      label = 18;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    var $22 = ($_ | 0) > 0;
    if ($22) {
      var $i_033 = 0;
      label = 7;
      break;
    } else {
      label = 12;
      break;
    }
   case 7:
    var $i_033;
    var $23 = $pcm_buf + ($i_033 << 2) | 0;
    var $24 = HEAPF32[$23 >> 2];
    var $25 = HEAPF32[$13 >> 2];
    var $26 = $24 > $25;
    if ($26) {
      label = 8;
      break;
    } else {
      label = 9;
      break;
    }
   case 8:
    HEAPF32[$13 >> 2] = $24;
    label = 11;
    break;
   case 9:
    var $29 = -$24;
    var $30 = $25 < $29;
    if ($30) {
      label = 10;
      break;
    } else {
      label = 11;
      break;
    }
   case 10:
    HEAPF32[$13 >> 2] = $29;
    label = 11;
    break;
   case 11:
    var $33 = $i_033 + 1 | 0;
    var $exitcond = ($33 | 0) == ($_ | 0);
    if ($exitcond) {
      label = 12;
      break;
    } else {
      var $i_033 = $33;
      label = 7;
      break;
    }
   case 12:
    var $34 = HEAP32[$11 >> 2];
    var $35 = ($34 | 0) > 1;
    var $36 = ($_ | 0) > 0;
    var $or_cond = $35 & $36;
    if ($or_cond) {
      var $i_135 = 0;
      label = 13;
      break;
    } else {
      label = 18;
      break;
    }
   case 13:
    var $i_135;
    var $37 = $pcm_buf + 4608 + ($i_135 << 2) | 0;
    var $38 = HEAPF32[$37 >> 2];
    var $39 = HEAPF32[$12 >> 2];
    var $40 = $38 > $39;
    if ($40) {
      label = 14;
      break;
    } else {
      label = 15;
      break;
    }
   case 14:
    HEAPF32[$12 >> 2] = $38;
    label = 17;
    break;
   case 15:
    var $43 = -$38;
    var $44 = $39 < $43;
    if ($44) {
      label = 16;
      break;
    } else {
      label = 17;
      break;
    }
   case 16:
    HEAPF32[$12 >> 2] = $43;
    label = 17;
    break;
   case 17:
    var $47 = $i_135 + 1 | 0;
    var $exitcond40 = ($47 | 0) == ($_ | 0);
    if ($exitcond40) {
      label = 18;
      break;
    } else {
      var $i_135 = $47;
      label = 13;
      break;
    }
   case 18:
    var $48 = HEAP32[$9 >> 2];
    var $49 = ($48 | 0) == 0;
    if ($49) {
      label = 20;
      break;
    } else {
      label = 19;
      break;
    }
   case 19:
    var $51 = HEAP32[$4 >> 2];
    var $52 = HEAP32[$10 >> 2];
    var $53 = _AnalyzeSamples($51, $6, $7, $_, $52);
    var $54 = ($53 | 0) == 0;
    if ($54) {
      var $_0 = -6;
      label = 21;
      break;
    } else {
      label = 20;
      break;
    }
   case 20:
    var $55 = ($_ | 0) == 0;
    if ($55) {
      var $_0 = $minimum;
      label = 21;
      break;
    } else {
      var $mp3_in_039 = 0;
      label = 4;
      break;
    }
   case 21:
    var $_0;
    STACKTOP = __stackBase__;
    return $_0;
  }
}
_do_gain_analysis["X"] = 1;
function _init_bit_stream_w($gfc) {
  HEAP32[$gfc + 52128 >> 2] = 0;
  HEAP32[$gfc + 52124 >> 2] = 0;
  HEAP32[$gfc + 39836 >> 2] = 0;
  HEAP32[$gfc + 284 >> 2] = _malloc(147456);
  HEAP32[$gfc + 288 >> 2] = 147456;
  HEAP32[$gfc + 296 >> 2] = -1;
  HEAP32[$gfc + 300 >> 2] = 0;
  HEAP32[$gfc + 292 >> 2] = 0;
  return;
}
function _putbits2($gfc, $val, $j) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 284 | 0;
    var $2 = ($j | 0) > 0;
    if ($2) {
      label = 3;
      break;
    } else {
      label = 9;
      break;
    }
   case 3:
    var $3 = $gfc + 300 | 0;
    var $4 = $gfc + 296 | 0;
    var $5 = $gfc + 52128 | 0;
    var $6 = $gfc + 292 | 0;
    var $7 = $1 | 0;
    var $8 = $gfc + 296 | 0;
    var $9 = $1 | 0;
    var $10 = $gfc + 292 | 0;
    var $_024 = $j;
    label = 4;
    break;
   case 4:
    var $_024;
    var $12 = HEAP32[$3 >> 2];
    var $13 = ($12 | 0) == 0;
    if ($13) {
      label = 5;
      break;
    } else {
      label = 8;
      break;
    }
   case 5:
    HEAP32[$3 >> 2] = 8;
    var $15 = HEAP32[$4 >> 2];
    var $16 = $15 + 1 | 0;
    HEAP32[$4 >> 2] = $16;
    var $17 = HEAP32[$5 >> 2];
    var $18 = $gfc + 39836 + $17 * 48 | 0;
    var $19 = HEAP32[$18 >> 2];
    var $20 = HEAP32[$6 >> 2];
    var $21 = ($19 | 0) == ($20 | 0);
    if ($21) {
      label = 6;
      break;
    } else {
      label = 7;
      break;
    }
   case 6:
    _putheader_bits($gfc);
    label = 7;
    break;
   case 7:
    var $24 = HEAP32[$4 >> 2];
    var $25 = HEAP32[$7 >> 2];
    var $26 = $25 + $24 | 0;
    HEAP8[$26] = 0;
    label = 8;
    break;
   case 8:
    var $28 = HEAP32[$3 >> 2];
    var $29 = ($_024 | 0) < ($28 | 0);
    var $_0_ = $29 ? $_024 : $28;
    var $30 = $_024 - $_0_ | 0;
    var $31 = $28 - $_0_ | 0;
    HEAP32[$3 >> 2] = $31;
    var $32 = $val >> $30;
    var $33 = $32 << $31;
    var $34 = HEAP32[$8 >> 2];
    var $35 = HEAP32[$9 >> 2];
    var $36 = $35 + $34 | 0;
    var $37 = HEAP8[$36];
    var $38 = $37 & 255;
    var $39 = $33 | $38;
    var $40 = $39 & 255;
    HEAP8[$36] = $40;
    var $41 = HEAP32[$10 >> 2];
    var $42 = $41 + $_0_ | 0;
    HEAP32[$10 >> 2] = $42;
    var $43 = ($30 | 0) > 0;
    if ($43) {
      var $_024 = $30;
      label = 4;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    return;
  }
}
_putbits2["X"] = 1;
function _ShortHuffmancodebits($gfc, $gi) {
  var $3 = HEAP32[$gfc + 21464 >> 2] * 3 & -1;
  var $4 = $gi + 4772 | 0;
  var $5 = HEAP32[$4 >> 2];
  var $_ = ($3 | 0) > ($5 | 0) ? $5 : $3;
  var $9 = _Huffmancode($gfc, HEAP32[$gi + 4796 >> 2], 0, $_, $gi);
  return _Huffmancode($gfc, HEAP32[$gi + 4800 >> 2], $_, HEAP32[$4 >> 2], $gi) + $9 | 0;
}
function _LongHuffmancodebits($gfc, $gi) {
  var $2 = HEAP32[$gi + 4772 >> 2];
  var $4 = HEAP32[$gi + 4824 >> 2];
  var $7 = HEAP32[$gfc + 21360 + ($4 + 1 << 2) >> 2];
  var $13 = HEAP32[$gfc + 21360 + ($4 + 2 + HEAP32[$gi + 4828 >> 2] << 2) >> 2];
  var $_ = ($7 | 0) > ($2 | 0) ? $2 : $7;
  var $region2Start_0 = ($13 | 0) > ($2 | 0) ? $2 : $13;
  var $18 = _Huffmancode($gfc, HEAP32[$gi + 4796 >> 2], 0, $_, $gi);
  var $22 = _Huffmancode($gfc, HEAP32[$gi + 4800 >> 2], $_, $region2Start_0, $gi) + $18 | 0;
  return $22 + _Huffmancode($gfc, HEAP32[$gi + 4804 >> 2], $region2Start_0, $2, $gi) | 0;
}
function _huffman_coder_count1($gfc, $gi) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gi + 4840 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $2 + 32 | 0;
    var $4 = $gi + 4772 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = $gi + 4776 | 0;
    var $7 = HEAP32[$6 >> 2];
    var $8 = $7 - $5 | 0;
    var $9 = ($8 | 0) > 3;
    if ($9) {
      label = 3;
      break;
    } else {
      var $bits_0_lcssa = 0;
      label = 17;
      break;
    }
   case 3:
    var $10 = ($8 | 0) / 4 & -1;
    var $11 = $gi + ($5 << 2) | 0;
    var $12 = $gi + 2304 + ($5 << 2) | 0;
    var $13 = 5327264 + ($3 << 4) | 0;
    var $14 = HEAP32[$13 >> 2];
    var $15 = 5327268 + ($3 << 4) | 0;
    var $16 = HEAP32[$15 >> 2];
    var $i_036 = $10;
    var $bits_037 = 0;
    var $ix_038 = $12;
    var $xr_039 = $11;
    label = 4;
    break;
   case 4:
    var $xr_039;
    var $ix_038;
    var $bits_037;
    var $i_036;
    var $18 = HEAP32[$ix_038 >> 2];
    var $19 = ($18 | 0) == 0;
    if ($19) {
      var $p_0 = 0;
      var $huffbits_0 = 0;
      label = 7;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $21 = HEAPF32[$xr_039 >> 2];
    var $22 = $21 < 0;
    if ($22) {
      label = 6;
      break;
    } else {
      var $p_0 = 8;
      var $huffbits_0 = 0;
      label = 7;
      break;
    }
   case 6:
    var $p_0 = 8;
    var $huffbits_0 = 1;
    label = 7;
    break;
   case 7:
    var $huffbits_0;
    var $p_0;
    var $25 = $ix_038 + 4 | 0;
    var $26 = HEAP32[$25 >> 2];
    var $27 = ($26 | 0) == 0;
    if ($27) {
      var $p_1 = $p_0;
      var $huffbits_1 = $huffbits_0;
      label = 10;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    var $29 = $p_0 | 4;
    var $30 = $huffbits_0 << 1;
    var $31 = $xr_039 + 4 | 0;
    var $32 = HEAPF32[$31 >> 2];
    var $33 = $32 < 0;
    if ($33) {
      label = 9;
      break;
    } else {
      var $p_1 = $29;
      var $huffbits_1 = $30;
      label = 10;
      break;
    }
   case 9:
    var $35 = $30 | 1;
    var $p_1 = $29;
    var $huffbits_1 = $35;
    label = 10;
    break;
   case 10:
    var $huffbits_1;
    var $p_1;
    var $37 = $ix_038 + 8 | 0;
    var $38 = HEAP32[$37 >> 2];
    var $39 = ($38 | 0) == 0;
    if ($39) {
      var $p_2 = $p_1;
      var $huffbits_2 = $huffbits_1;
      label = 13;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    var $41 = $p_1 + 2 | 0;
    var $42 = $huffbits_1 << 1;
    var $43 = $xr_039 + 8 | 0;
    var $44 = HEAPF32[$43 >> 2];
    var $45 = $44 < 0;
    if ($45) {
      label = 12;
      break;
    } else {
      var $p_2 = $41;
      var $huffbits_2 = $42;
      label = 13;
      break;
    }
   case 12:
    var $47 = $42 | 1;
    var $p_2 = $41;
    var $huffbits_2 = $47;
    label = 13;
    break;
   case 13:
    var $huffbits_2;
    var $p_2;
    var $49 = $ix_038 + 12 | 0;
    var $50 = HEAP32[$49 >> 2];
    var $51 = ($50 | 0) == 0;
    if ($51) {
      var $p_3 = $p_2;
      var $huffbits_3 = $huffbits_2;
      label = 16;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    var $53 = $p_2 + 1 | 0;
    var $54 = $huffbits_2 << 1;
    var $55 = $xr_039 + 12 | 0;
    var $56 = HEAPF32[$55 >> 2];
    var $57 = $56 < 0;
    if ($57) {
      label = 15;
      break;
    } else {
      var $p_3 = $53;
      var $huffbits_3 = $54;
      label = 16;
      break;
    }
   case 15:
    var $59 = $54 | 1;
    var $p_3 = $53;
    var $huffbits_3 = $59;
    label = 16;
    break;
   case 16:
    var $huffbits_3;
    var $p_3;
    var $61 = $ix_038 + 16 | 0;
    var $62 = $xr_039 + 16 | 0;
    var $63 = $14 + ($p_3 << 1) | 0;
    var $64 = HEAP16[$63 >> 1];
    var $65 = $64 & 65535;
    var $66 = $65 + $huffbits_3 | 0;
    var $67 = $16 + $p_3 | 0;
    var $68 = HEAP8[$67];
    var $69 = $68 & 255;
    _putbits2($gfc, $66, $69);
    var $70 = $16 + $p_3 | 0;
    var $71 = HEAP8[$70];
    var $72 = $71 & 255;
    var $73 = $72 + $bits_037 | 0;
    var $74 = $i_036 - 1 | 0;
    var $75 = ($74 | 0) > 0;
    if ($75) {
      var $i_036 = $74;
      var $bits_037 = $73;
      var $ix_038 = $61;
      var $xr_039 = $62;
      label = 4;
      break;
    } else {
      var $bits_0_lcssa = $73;
      label = 17;
      break;
    }
   case 17:
    var $bits_0_lcssa;
    return $bits_0_lcssa;
  }
}
_huffman_coder_count1["X"] = 1;
function _Huffmancode($gfc, $tableindex, $start, $end, $gi) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = 5327256 + ($tableindex << 4) | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($tableindex | 0) != 0;
    var $4 = ($start | 0) < ($end | 0);
    var $or_cond = $3 & $4;
    if ($or_cond) {
      label = 3;
      break;
    } else {
      var $_0 = 0;
      label = 14;
      break;
    }
   case 3:
    var $5 = HEAP32[$1 >> 2];
    var $6 = $tableindex >>> 0 > 15;
    var $7 = $2 & 65535;
    var $8 = 5327268 + ($tableindex << 4) | 0;
    var $9 = HEAP32[$8 >> 2];
    var $10 = 5327264 + ($tableindex << 4) | 0;
    var $11 = HEAP32[$10 >> 2];
    var $bits_055 = 0;
    var $i_056 = $start;
    label = 4;
    break;
   case 4:
    var $i_056;
    var $bits_055;
    var $13 = $gi + 2304 + ($i_056 << 2) | 0;
    var $14 = HEAP32[$13 >> 2];
    var $15 = $i_056 + 1 | 0;
    var $16 = $gi + 2304 + ($15 << 2) | 0;
    var $17 = HEAP32[$16 >> 2];
    var $18 = ($14 | 0) == 0;
    if ($18) {
      var $ext_1 = 0;
      var $cbits_0 = 0;
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $20 = $gi + ($i_056 << 2) | 0;
    var $21 = HEAPF32[$20 >> 2];
    var $22 = $21 < 0;
    var $ext_0 = $22 & 1;
    var $ext_1 = $ext_0;
    var $cbits_0 = -1;
    label = 6;
    break;
   case 6:
    var $cbits_0;
    var $ext_1;
    if ($6) {
      label = 7;
      break;
    } else {
      var $x1_1 = $14;
      var $ext_4 = $ext_1;
      var $xlen_0 = $5;
      var $xbits_2 = 0;
      label = 11;
      break;
    }
   case 7:
    var $25 = $14 >>> 0 > 14;
    if ($25) {
      label = 8;
      break;
    } else {
      var $x1_0 = $14;
      var $ext_2 = $ext_1;
      var $xbits_0 = 0;
      label = 9;
      break;
    }
   case 8:
    var $27 = $14 << 1;
    var $28 = $27 + 131042 | 0;
    var $29 = $28 & 131070;
    var $30 = $ext_1 | $29;
    var $x1_0 = 15;
    var $ext_2 = $30;
    var $xbits_0 = $7;
    label = 9;
    break;
   case 9:
    var $xbits_0;
    var $ext_2;
    var $x1_0;
    var $32 = $17 >>> 0 > 14;
    if ($32) {
      label = 10;
      break;
    } else {
      var $x1_1 = $x1_0;
      var $ext_4 = $ext_2;
      var $xlen_0 = 16;
      var $xbits_2 = $xbits_0;
      label = 11;
      break;
    }
   case 10:
    var $33 = $17 + 65521 | 0;
    var $34 = $ext_2 << $2;
    var $35 = $33 & 65535;
    var $36 = $34 | $35;
    var $37 = $xbits_0 & 65535;
    var $38 = $37 + $2 | 0;
    var $39 = $38 & 65535;
    var $xbits_246 = $39;
    var $xlen_048 = 16;
    var $ext_450 = $36;
    var $x1_151 = $x1_0;
    var $x2_153 = 15;
    label = 12;
    break;
   case 11:
    var $xbits_2;
    var $xlen_0;
    var $ext_4;
    var $x1_1;
    var $41 = ($17 | 0) == 0;
    if ($41) {
      var $ext_6 = $ext_4;
      var $cbits_1 = $cbits_0;
      var $xbits_247 = $xbits_2;
      var $xlen_049 = $xlen_0;
      var $x1_152 = $x1_1;
      var $x2_154 = 0;
      label = 13;
      break;
    } else {
      var $xbits_246 = $xbits_2;
      var $xlen_048 = $xlen_0;
      var $ext_450 = $ext_4;
      var $x1_151 = $x1_1;
      var $x2_153 = $17;
      label = 12;
      break;
    }
   case 12:
    var $x2_153;
    var $x1_151;
    var $ext_450;
    var $xlen_048;
    var $xbits_246;
    var $43 = $ext_450 << 1;
    var $44 = $gi + ($15 << 2) | 0;
    var $45 = HEAPF32[$44 >> 2];
    var $46 = $45 < 0;
    var $47 = $46 & 1;
    var $ext_5 = $47 | $43;
    var $48 = $cbits_0 - 1 & 65535;
    var $ext_6 = $ext_5;
    var $cbits_1 = $48;
    var $xbits_247 = $xbits_246;
    var $xlen_049 = $xlen_048;
    var $x1_152 = $x1_151;
    var $x2_154 = $x2_153;
    label = 13;
    break;
   case 13:
    var $x2_154;
    var $x1_152;
    var $xlen_049;
    var $xbits_247;
    var $cbits_1;
    var $ext_6;
    var $50 = $xlen_049 * $x1_152 & -1;
    var $51 = $50 + $x2_154 | 0;
    var $52 = $xbits_247 - $cbits_1 & 65535;
    var $53 = $9 + $51 | 0;
    var $54 = HEAP8[$53];
    var $55 = $54 & 255;
    var $56 = $55 + $cbits_1 & 65535;
    var $57 = $11 + ($51 << 1) | 0;
    var $58 = HEAP16[$57 >> 1];
    var $59 = $58 & 65535;
    var $60 = $56 << 16 >> 16;
    _putbits2($gfc, $59, $60);
    var $61 = $52 & 65535;
    _putbits2($gfc, $ext_6, $61);
    var $62 = $61 + $bits_055 | 0;
    var $63 = $62 + $60 | 0;
    var $64 = $i_056 + 2 | 0;
    var $65 = ($64 | 0) < ($end | 0);
    if ($65) {
      var $bits_055 = $63;
      var $i_056 = $64;
      label = 4;
      break;
    } else {
      var $_0 = $63;
      label = 14;
      break;
    }
   case 14:
    var $_0;
    return $_0;
  }
}
_Huffmancode["X"] = 1;
function _putheader_bits($gfc) {
  var $1 = $gfc + 296 | 0;
  var $6 = $gfc + 52128 | 0;
  var $9 = $gfc + 24 | 0;
  _memcpy(HEAP32[$gfc + 284 >> 2] + HEAP32[$1 >> 2] | 0, $gfc + 39836 + HEAP32[$6 >> 2] * 48 + 8 | 0, HEAP32[$9 >> 2]);
  HEAP32[$1 >> 2] = HEAP32[$1 >> 2] + HEAP32[$9 >> 2] | 0;
  var $16 = $gfc + 292 | 0;
  HEAP32[$16 >> 2] = HEAP32[$16 >> 2] + (HEAP32[$9 >> 2] << 3) | 0;
  HEAP32[$6 >> 2] = HEAP32[$6 >> 2] + 1 & 255;
  return;
}
function _adjust_ATH($gfc) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 85792 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $2 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) == 0;
    if ($5) {
      label = 3;
      break;
    } else {
      label = 4;
      break;
    }
   case 3:
    var $7 = $2 + 8 | 0;
    HEAPF32[$7 >> 2] = 1;
    label = 22;
    break;
   case 4:
    var $9 = $gfc + 27804 | 0;
    var $10 = HEAPF32[$9 >> 2];
    var $11 = $gfc + 27812 | 0;
    var $12 = HEAPF32[$11 >> 2];
    var $13 = $gfc + 72 | 0;
    var $14 = HEAP32[$13 >> 2];
    var $15 = ($14 | 0) == 2;
    if ($15) {
      label = 5;
      break;
    } else {
      var $_pn43 = $12;
      var $_pn = $10;
      label = 6;
      break;
    }
   case 5:
    var $17 = $gfc + 27808 | 0;
    var $18 = HEAPF32[$17 >> 2];
    var $19 = $gfc + 27816 | 0;
    var $20 = HEAPF32[$19 >> 2];
    var $_pn43 = $20;
    var $_pn = $18;
    label = 6;
    break;
   case 6:
    var $_pn;
    var $_pn43;
    var $gr2_max_0 = $12 + $_pn43;
    var $max_pow_0 = $10 + $_pn;
    var $22 = $gfc + 76 | 0;
    var $23 = HEAP32[$22 >> 2];
    var $24 = ($23 | 0) == 2;
    if ($24) {
      label = 7;
      break;
    } else {
      var $max_pow_1 = $max_pow_0;
      label = 8;
      break;
    }
   case 7:
    var $26 = $max_pow_0 > $gr2_max_0;
    var $27 = $26 ? $max_pow_0 : $gr2_max_0;
    var $max_pow_1 = $27;
    label = 8;
    break;
   case 8:
    var $max_pow_1;
    var $29 = $max_pow_1 * .5;
    var $30 = HEAP32[$1 >> 2];
    var $31 = $30 + 4 | 0;
    var $32 = HEAPF32[$31 >> 2];
    var $33 = $29 * $32;
    var $34 = $33 > .03125;
    if ($34) {
      label = 9;
      break;
    } else {
      label = 14;
      break;
    }
   case 9:
    var $36 = $30 + 8 | 0;
    var $37 = HEAPF32[$36 >> 2];
    var $38 = $37 < 1;
    if ($38) {
      label = 11;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    HEAPF32[$36 >> 2] = 1;
    label = 13;
    break;
   case 11:
    var $41 = $30 + 12 | 0;
    var $42 = HEAPF32[$41 >> 2];
    var $43 = $37 < $42;
    if ($43) {
      label = 12;
      break;
    } else {
      label = 13;
      break;
    }
   case 12:
    HEAPF32[$36 >> 2] = $42;
    label = 13;
    break;
   case 13:
    var $46 = HEAP32[$1 >> 2];
    var $47 = $46 + 12 | 0;
    HEAPF32[$47 >> 2] = 1;
    label = 22;
    break;
   case 14:
    var $49 = $33;
    var $50 = $49 * 31.98;
    var $51 = $50 + 625e-6;
    var $52 = $51;
    var $53 = $30 + 8 | 0;
    var $54 = HEAPF32[$53 >> 2];
    var $55 = $54 < $52;
    if ($55) {
      label = 17;
      break;
    } else {
      label = 15;
      break;
    }
   case 15:
    var $57 = $52;
    var $58 = $57 * .075;
    var $59 = $58 + .925;
    var $60 = $54;
    var $61 = $59 * $60;
    var $62 = $61;
    HEAPF32[$53 >> 2] = $62;
    var $63 = HEAP32[$1 >> 2];
    var $64 = $63 + 8 | 0;
    var $65 = HEAPF32[$64 >> 2];
    var $66 = $65 < $52;
    if ($66) {
      label = 16;
      break;
    } else {
      label = 21;
      break;
    }
   case 16:
    HEAPF32[$64 >> 2] = $52;
    label = 21;
    break;
   case 17:
    var $69 = $30 + 12 | 0;
    var $70 = HEAPF32[$69 >> 2];
    var $71 = $70 < $52;
    if ($71) {
      label = 19;
      break;
    } else {
      label = 18;
      break;
    }
   case 18:
    HEAPF32[$53 >> 2] = $52;
    label = 21;
    break;
   case 19:
    var $74 = $54 < $70;
    if ($74) {
      label = 20;
      break;
    } else {
      label = 21;
      break;
    }
   case 20:
    HEAPF32[$53 >> 2] = $70;
    label = 21;
    break;
   case 21:
    var $77 = HEAP32[$1 >> 2];
    var $78 = $77 + 12 | 0;
    HEAPF32[$78 >> 2] = $52;
    label = 22;
    break;
   case 22:
    return;
  }
}
_adjust_ATH["X"] = 1;
function _updateStats($gfc) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 84740 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $gfc + 84036 + $2 * 20 + 16 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = $4 + 1 | 0;
    HEAP32[$3 >> 2] = $5;
    var $6 = $gfc + 84352 | 0;
    var $7 = HEAP32[$6 >> 2];
    var $8 = $7 + 1 | 0;
    HEAP32[$6 >> 2] = $8;
    var $9 = $gfc + 72 | 0;
    var $10 = HEAP32[$9 >> 2];
    var $11 = ($10 | 0) == 2;
    if ($11) {
      label = 3;
      break;
    } else {
      label = 4;
      break;
    }
   case 3:
    var $13 = $gfc + 84752 | 0;
    var $14 = HEAP32[$13 >> 2];
    var $15 = HEAP32[$1 >> 2];
    var $16 = $gfc + 84036 + $15 * 20 + ($14 << 2) | 0;
    var $17 = HEAP32[$16 >> 2];
    var $18 = $17 + 1 | 0;
    HEAP32[$16 >> 2] = $18;
    var $19 = HEAP32[$13 >> 2];
    var $20 = $gfc + 84336 + ($19 << 2) | 0;
    var $21 = HEAP32[$20 >> 2];
    var $22 = $21 + 1 | 0;
    HEAP32[$20 >> 2] = $22;
    label = 4;
    break;
   case 4:
    var $23 = $gfc + 76 | 0;
    var $24 = HEAP32[$23 >> 2];
    var $25 = ($24 | 0) > 0;
    if ($25) {
      label = 5;
      break;
    } else {
      label = 9;
      break;
    }
   case 5:
    var $26 = $gfc + 84736 | 0;
    var $gr_028 = 0;
    label = 6;
    break;
   case 6:
    var $gr_028;
    var $27 = HEAP32[$9 >> 2];
    var $28 = ($27 | 0) > 0;
    if ($28) {
      var $ch_026 = 0;
      label = 7;
      break;
    } else {
      label = 8;
      break;
    }
   case 7:
    var $ch_026;
    var $29 = $gfc + 304 + $gr_028 * 10504 + $ch_026 * 5252 + 4788 | 0;
    var $30 = HEAP32[$29 >> 2];
    var $31 = $gfc + 304 + $gr_028 * 10504 + $ch_026 * 5252 + 4792 | 0;
    var $32 = HEAP32[$31 >> 2];
    var $33 = ($32 | 0) == 0;
    var $_ = $33 ? $30 : 4;
    var $34 = HEAP32[$1 >> 2];
    var $35 = $gfc + 84356 + $34 * 24 + ($_ << 2) | 0;
    var $36 = HEAP32[$35 >> 2];
    var $37 = $36 + 1 | 0;
    HEAP32[$35 >> 2] = $37;
    var $38 = HEAP32[$1 >> 2];
    var $39 = $gfc + 84356 + $38 * 24 + 20 | 0;
    var $40 = HEAP32[$39 >> 2];
    var $41 = $40 + 1 | 0;
    HEAP32[$39 >> 2] = $41;
    var $42 = $gfc + 84716 + ($_ << 2) | 0;
    var $43 = HEAP32[$42 >> 2];
    var $44 = $43 + 1 | 0;
    HEAP32[$42 >> 2] = $44;
    var $45 = HEAP32[$26 >> 2];
    var $46 = $45 + 1 | 0;
    HEAP32[$26 >> 2] = $46;
    var $47 = $ch_026 + 1 | 0;
    var $48 = HEAP32[$9 >> 2];
    var $49 = ($47 | 0) < ($48 | 0);
    if ($49) {
      var $ch_026 = $47;
      label = 7;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    var $50 = $gr_028 + 1 | 0;
    var $51 = HEAP32[$23 >> 2];
    var $52 = ($50 | 0) < ($51 | 0);
    if ($52) {
      var $gr_028 = $50;
      label = 6;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    return;
  }
}
_updateStats["X"] = 1;
function _lame_encode_mp3_frame($gfc, $inbuf_l, $inbuf_r, $mp3buf, $mp3buf_size) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 4e3 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $masking_LR = __stackBase__;
    var $masking_MS = __stackBase__ + 1952;
    var $inbuf = __stackBase__ + 3904;
    var $tot_ener = __stackBase__ + 3912;
    var $ms_ener_ratio = __stackBase__ + 3944;
    var $pe = __stackBase__ + 3952;
    var $pe_MS = __stackBase__ + 3968;
    var $bufp = __stackBase__ + 3984;
    var $blocktype = __stackBase__ + 3992;
    var $1 = $ms_ener_ratio;
    var $$etemp$0$0 = 1056964608;
    var $$etemp$0$1 = 1056964608;
    var $st$12$0 = $1 | 0;
    HEAP32[$st$12$0 >> 2] = $$etemp$0$0;
    var $st$12$1 = $1 + 4 | 0;
    HEAP32[$st$12$1 >> 2] = $$etemp$0$1;
    var $2 = $pe;
    HEAP32[$2 >> 2] = 0;
    HEAP32[$2 + 4 >> 2] = 0;
    HEAP32[$2 + 8 >> 2] = 0;
    HEAP32[$2 + 12 >> 2] = 0;
    var $3 = $pe_MS;
    HEAP32[$3 >> 2] = 0;
    HEAP32[$3 + 4 >> 2] = 0;
    HEAP32[$3 + 8 >> 2] = 0;
    HEAP32[$3 + 12 >> 2] = 0;
    var $4 = $inbuf | 0;
    HEAP32[$4 >> 2] = $inbuf_l;
    var $5 = $inbuf + 4 | 0;
    HEAP32[$5 >> 2] = $inbuf_r;
    var $6 = $gfc + 4 | 0;
    var $7 = HEAP32[$6 >> 2];
    var $8 = ($7 | 0) == 0;
    if ($8) {
      label = 3;
      break;
    } else {
      label = 4;
      break;
    }
   case 3:
    _lame_encode_frame_init($gfc, $4);
    label = 4;
    break;
   case 4:
    var $11 = $gfc + 84748 | 0;
    HEAP32[$11 >> 2] = 0;
    var $12 = $gfc + 39828 | 0;
    var $13 = HEAP32[$12 >> 2];
    var $14 = $gfc + 39832 | 0;
    var $15 = HEAP32[$14 >> 2];
    var $16 = $15 - $13 | 0;
    HEAP32[$14 >> 2] = $16;
    var $17 = ($16 | 0) < 0;
    if ($17) {
      label = 5;
      break;
    } else {
      label = 6;
      break;
    }
   case 5:
    var $19 = $gfc + 64 | 0;
    var $20 = HEAP32[$19 >> 2];
    var $21 = $20 + $16 | 0;
    HEAP32[$14 >> 2] = $21;
    HEAP32[$11 >> 2] = 1;
    label = 6;
    break;
   case 6:
    var $23 = $bufp;
    var $$etemp$1$0 = 0;
    var $$etemp$1$1 = 0;
    var $st$3$0 = $23 | 0;
    HEAP32[$st$3$0 >> 2] = $$etemp$1$0;
    var $st$3$1 = $23 + 4 | 0;
    HEAP32[$st$3$1 >> 2] = $$etemp$1$1;
    var $24 = $gfc + 76 | 0;
    var $25 = HEAP32[$24 >> 2];
    var $26 = ($25 | 0) > 0;
    if ($26) {
      label = 7;
      break;
    } else {
      label = 17;
      break;
    }
   case 7:
    var $27 = $gfc + 72 | 0;
    var $28 = $bufp | 0;
    var $29 = $masking_LR | 0;
    var $30 = $masking_MS | 0;
    var $31 = $blocktype | 0;
    var $32 = $gfc + 180 | 0;
    var $gr_0240 = 0;
    label = 8;
    break;
   case 8:
    var $gr_0240;
    var $33 = HEAP32[$27 >> 2];
    var $34 = ($33 | 0) > 0;
    if ($34) {
      label = 9;
      break;
    } else {
      label = 11;
      break;
    }
   case 9:
    var $35 = $gr_0240 * 576 & -1;
    var $36 = $35 + 304 | 0;
    var $37 = HEAP32[$27 >> 2];
    var $ch_0231 = 0;
    label = 10;
    break;
   case 10:
    var $ch_0231;
    var $39 = $inbuf + ($ch_0231 << 2) | 0;
    var $40 = HEAP32[$39 >> 2];
    var $41 = $40 + ($36 << 2) | 0;
    var $42 = $bufp + ($ch_0231 << 2) | 0;
    HEAP32[$42 >> 2] = $41;
    var $43 = $ch_0231 + 1 | 0;
    var $44 = ($43 | 0) < ($37 | 0);
    if ($44) {
      var $ch_0231 = $43;
      label = 10;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    var $45 = $pe + ($gr_0240 << 3) | 0;
    var $46 = $pe_MS + ($gr_0240 << 3) | 0;
    var $47 = $tot_ener + ($gr_0240 << 4) | 0;
    var $48 = _L3psycho_anal_vbr($gfc, $28, $gr_0240, $29, $30, $45, $46, $47, $31);
    var $49 = HEAP32[$32 >> 2];
    var $50 = ($49 | 0) == 1;
    if ($50) {
      label = 12;
      break;
    } else {
      label = 14;
      break;
    }
   case 12:
    var $52 = $tot_ener + ($gr_0240 << 4) + 8 | 0;
    var $53 = HEAPF32[$52 >> 2];
    var $54 = $tot_ener + ($gr_0240 << 4) + 12 | 0;
    var $55 = HEAPF32[$54 >> 2];
    var $56 = $53 + $55;
    var $57 = $ms_ener_ratio + ($gr_0240 << 2) | 0;
    HEAPF32[$57 >> 2] = $56;
    var $58 = $56 > 0;
    if ($58) {
      label = 13;
      break;
    } else {
      label = 14;
      break;
    }
   case 13:
    var $60 = HEAPF32[$54 >> 2];
    var $61 = $60 / $56;
    HEAPF32[$57 >> 2] = $61;
    label = 14;
    break;
   case 14:
    var $62 = HEAP32[$27 >> 2];
    var $63 = ($62 | 0) > 0;
    if ($63) {
      var $ch_1236 = 0;
      label = 15;
      break;
    } else {
      label = 16;
      break;
    }
   case 15:
    var $ch_1236;
    var $64 = $blocktype + ($ch_1236 << 2) | 0;
    var $65 = HEAP32[$64 >> 2];
    var $66 = $gfc + 304 + $gr_0240 * 10504 + $ch_1236 * 5252 + 4788 | 0;
    HEAP32[$66 >> 2] = $65;
    var $67 = $gfc + 304 + $gr_0240 * 10504 + $ch_1236 * 5252 + 4792 | 0;
    HEAP32[$67 >> 2] = 0;
    var $68 = $ch_1236 + 1 | 0;
    var $69 = HEAP32[$27 >> 2];
    var $70 = ($68 | 0) < ($69 | 0);
    if ($70) {
      var $ch_1236 = $68;
      label = 15;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    var $71 = $gr_0240 + 1 | 0;
    var $72 = HEAP32[$24 >> 2];
    var $73 = ($71 | 0) < ($72 | 0);
    if ($73) {
      var $gr_0240 = $71;
      label = 8;
      break;
    } else {
      label = 17;
      break;
    }
   case 17:
    _adjust_ATH($gfc);
    var $74 = HEAP32[$4 >> 2];
    var $75 = HEAP32[$5 >> 2];
    _mdct_sub48($gfc, $74, $75);
    var $76 = $gfc + 84752 | 0;
    HEAP32[$76 >> 2] = 0;
    var $77 = $gfc + 80 | 0;
    var $78 = HEAP32[$77 >> 2];
    var $79 = ($78 | 0) == 0;
    if ($79) {
      label = 19;
      break;
    } else {
      label = 18;
      break;
    }
   case 18:
    HEAP32[$76 >> 2] = 2;
    label = 30;
    break;
   case 19:
    var $82 = $gfc + 180 | 0;
    var $83 = HEAP32[$82 >> 2];
    var $84 = ($83 | 0) == 1;
    if ($84) {
      label = 20;
      break;
    } else {
      label = 30;
      break;
    }
   case 20:
    var $85 = HEAP32[$24 >> 2];
    var $86 = ($85 | 0) > 0;
    if ($86) {
      label = 21;
      break;
    } else {
      var $_lcssa252 = $85;
      label = 27;
      break;
    }
   case 21:
    var $87 = $gfc + 72 | 0;
    var $88 = HEAP32[$87 >> 2];
    var $89 = ($88 | 0) > 0;
    var $90 = HEAP32[$24 >> 2];
    var $gr_1221 = 0;
    var $sum_pe_MS_0223 = 0;
    var $sum_pe_LR_0224 = 0;
    label = 22;
    break;
   case 22:
    var $sum_pe_LR_0224;
    var $sum_pe_MS_0223;
    var $gr_1221;
    if ($89) {
      label = 23;
      break;
    } else {
      var $sum_pe_MS_1_lcssa = $sum_pe_MS_0223;
      var $sum_pe_LR_1_lcssa = $sum_pe_LR_0224;
      label = 25;
      break;
    }
   case 23:
    var $91 = HEAP32[$87 >> 2];
    var $ch_2213 = 0;
    var $sum_pe_MS_1214 = $sum_pe_MS_0223;
    var $sum_pe_LR_1215 = $sum_pe_LR_0224;
    label = 24;
    break;
   case 24:
    var $sum_pe_LR_1215;
    var $sum_pe_MS_1214;
    var $ch_2213;
    var $93 = $pe_MS + ($gr_1221 << 3) + ($ch_2213 << 2) | 0;
    var $94 = HEAPF32[$93 >> 2];
    var $95 = $sum_pe_MS_1214 + $94;
    var $96 = $pe + ($gr_1221 << 3) + ($ch_2213 << 2) | 0;
    var $97 = HEAPF32[$96 >> 2];
    var $98 = $sum_pe_LR_1215 + $97;
    var $99 = $ch_2213 + 1 | 0;
    var $100 = ($99 | 0) < ($91 | 0);
    if ($100) {
      var $ch_2213 = $99;
      var $sum_pe_MS_1214 = $95;
      var $sum_pe_LR_1215 = $98;
      label = 24;
      break;
    } else {
      var $sum_pe_MS_1_lcssa = $95;
      var $sum_pe_LR_1_lcssa = $98;
      label = 25;
      break;
    }
   case 25:
    var $sum_pe_LR_1_lcssa;
    var $sum_pe_MS_1_lcssa;
    var $101 = $gr_1221 + 1 | 0;
    var $102 = ($101 | 0) < ($90 | 0);
    if ($102) {
      var $gr_1221 = $101;
      var $sum_pe_MS_0223 = $sum_pe_MS_1_lcssa;
      var $sum_pe_LR_0224 = $sum_pe_LR_1_lcssa;
      label = 22;
      break;
    } else {
      label = 26;
      break;
    }
   case 26:
    var $103 = $sum_pe_MS_1_lcssa > $sum_pe_LR_1_lcssa;
    if ($103) {
      label = 30;
      break;
    } else {
      var $_lcssa252 = $90;
      label = 27;
      break;
    }
   case 27:
    var $_lcssa252;
    var $104 = $_lcssa252 - 1 | 0;
    var $105 = $gfc + 5092 | 0;
    var $106 = HEAP32[$105 >> 2];
    var $107 = $gfc + 10344 | 0;
    var $108 = HEAP32[$107 >> 2];
    var $109 = ($106 | 0) == ($108 | 0);
    if ($109) {
      label = 28;
      break;
    } else {
      label = 30;
      break;
    }
   case 28:
    var $111 = $gfc + 304 + $104 * 10504 + 4788 | 0;
    var $112 = HEAP32[$111 >> 2];
    var $113 = $gfc + 304 + $104 * 10504 + 10040 | 0;
    var $114 = HEAP32[$113 >> 2];
    var $115 = ($112 | 0) == ($114 | 0);
    if ($115) {
      label = 29;
      break;
    } else {
      label = 30;
      break;
    }
   case 29:
    HEAP32[$76 >> 2] = 2;
    label = 30;
    break;
   case 30:
    var $118 = HEAP32[$76 >> 2];
    var $119 = ($118 | 0) == 2;
    var $masking_MS_sink = $119 ? $masking_MS : $masking_LR;
    var $pe_MS_sink = $119 ? $pe_MS : $pe;
    var $120 = $masking_MS_sink | 0;
    var $121 = $pe_MS_sink | 0;
    var $122 = $gfc + 140 | 0;
    var $123 = HEAP32[$122 >> 2];
    var $124 = ($123 | 0) == 0;
    if ($124) {
      label = 40;
      break;
    } else {
      label = 31;
      break;
    }
   case 31:
    var $126 = $gfc + 85800 | 0;
    var $127 = HEAP32[$126 >> 2];
    var $128 = ($127 | 0) == 0;
    if ($128) {
      label = 40;
      break;
    } else {
      label = 32;
      break;
    }
   case 32:
    var $129 = HEAP32[$24 >> 2];
    var $130 = ($129 | 0) > 0;
    if ($130) {
      label = 33;
      break;
    } else {
      label = 40;
      break;
    }
   case 33:
    var $131 = $gfc + 72 | 0;
    var $gr_2210 = 0;
    label = 34;
    break;
   case 34:
    var $gr_2210;
    var $132 = HEAP32[$131 >> 2];
    var $133 = ($132 | 0) > 0;
    if ($133) {
      label = 35;
      break;
    } else {
      label = 39;
      break;
    }
   case 35:
    var $134 = $ms_ener_ratio + ($gr_2210 << 2) | 0;
    var $ch_3205 = 0;
    label = 36;
    break;
   case 36:
    var $ch_3205;
    var $136 = HEAP32[$126 >> 2];
    var $137 = $136 + 90900 + ($gr_2210 << 3) | 0;
    HEAPF64[tempDoublePtr >> 3] = 0, HEAP32[$137 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$137 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    var $138 = HEAPF32[$134 >> 2];
    var $139 = $138;
    var $140 = HEAP32[$126 >> 2];
    var $141 = $140 + 90916 + ($gr_2210 << 3) | 0;
    HEAPF64[tempDoublePtr >> 3] = $139, HEAP32[$141 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$141 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    var $142 = $gfc + 304 + $gr_2210 * 10504 + $ch_3205 * 5252 + 4788 | 0;
    var $143 = HEAP32[$142 >> 2];
    var $144 = HEAP32[$126 >> 2];
    var $145 = $144 + 203284 + ($gr_2210 << 3) + ($ch_3205 << 2) | 0;
    HEAP32[$145 >> 2] = $143;
    var $146 = $pe_MS_sink + ($gr_2210 << 3) + ($ch_3205 << 2) | 0;
    var $147 = HEAPF32[$146 >> 2];
    var $148 = $147;
    var $149 = HEAP32[$126 >> 2];
    var $150 = $149 + 189236 + ($gr_2210 << 5) + ($ch_3205 << 3) | 0;
    HEAPF64[tempDoublePtr >> 3] = $148, HEAP32[$150 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$150 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    var $151 = HEAP32[$126 >> 2];
    var $152 = $151 + 54036 + $gr_2210 * 9216 + $ch_3205 * 4608 | 0;
    var $153 = $152;
    var $154 = $gfc + 304 + $gr_2210 * 10504 + $ch_3205 * 5252 | 0;
    var $155 = $154;
    for (var $$src = $155 >> 2, $$dest = $153 >> 2, $$stop = $$src + 576; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    var $156 = HEAP32[$76 >> 2];
    var $157 = ($156 | 0) == 2;
    if ($157) {
      label = 37;
      break;
    } else {
      label = 38;
      break;
    }
   case 37:
    var $159 = $ch_3205 + 2 | 0;
    var $160 = HEAP32[$126 >> 2];
    var $161 = $160 + 197140 + ($gr_2210 << 5) + ($159 << 3) | 0;
    var $162 = (HEAP32[tempDoublePtr >> 2] = HEAP32[$161 >> 2], HEAP32[tempDoublePtr + 4 >> 2] = HEAP32[$161 + 4 >> 2], HEAPF64[tempDoublePtr >> 3]);
    var $163 = $160 + 197140 + ($gr_2210 << 5) + ($ch_3205 << 3) | 0;
    HEAPF64[tempDoublePtr >> 3] = $162, HEAP32[$163 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$163 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    var $164 = HEAP32[$126 >> 2];
    var $165 = $164 + 123700 + ($gr_2210 << 15) + ($ch_3205 << 13) | 0;
    var $166 = $165;
    var $167 = $164 + 123700 + ($gr_2210 << 15) + ($159 << 13) | 0;
    var $168 = $167;
    for (var $$src = $168 >> 2, $$dest = $166 >> 2, $$stop = $$src + 2048; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    label = 38;
    break;
   case 38:
    var $170 = $ch_3205 + 1 | 0;
    var $171 = HEAP32[$131 >> 2];
    var $172 = ($170 | 0) < ($171 | 0);
    if ($172) {
      var $ch_3205 = $170;
      label = 36;
      break;
    } else {
      label = 39;
      break;
    }
   case 39:
    var $173 = $gr_2210 + 1 | 0;
    var $174 = HEAP32[$24 >> 2];
    var $175 = ($173 | 0) < ($174 | 0);
    if ($175) {
      var $gr_2210 = $173;
      label = 34;
      break;
    } else {
      label = 40;
      break;
    }
   case 40:
    var $176 = $gfc + 104 | 0;
    var $177 = HEAP32[$176 >> 2];
    if (($177 | 0) == 0 | ($177 | 0) == 3) {
      label = 42;
      break;
    } else {
      label = 53;
      break;
    }
   case 41:
    var $178 = $gfc + 72 | 0;
    var $179 = HEAP32[$178 >> 2];
    var $180 = ($179 | 0) > 0;
    var $181 = HEAP32[$24 >> 2];
    var $gr_3197 = 0;
    var $f_0199 = 0;
    label = 43;
    break;
   case 42:
    var $182 = $gfc + 39756 | 0;
    var $183 = HEAPF32[$182 >> 2];
    var $184 = $gfc + 39752 | 0;
    HEAPF32[$184 >> 2] = $183;
    var $185 = $gfc + 39760 | 0;
    var $186 = HEAPF32[$185 >> 2];
    var $187 = $gfc + 39756 | 0;
    HEAPF32[$187 >> 2] = $186;
    var $188 = $gfc + 39764 | 0;
    var $189 = HEAPF32[$188 >> 2];
    var $190 = $gfc + 39760 | 0;
    HEAPF32[$190 >> 2] = $189;
    var $191 = $gfc + 39768 | 0;
    var $192 = HEAPF32[$191 >> 2];
    var $193 = $gfc + 39764 | 0;
    HEAPF32[$193 >> 2] = $192;
    var $194 = $gfc + 39772 | 0;
    var $195 = HEAPF32[$194 >> 2];
    var $196 = $gfc + 39768 | 0;
    HEAPF32[$196 >> 2] = $195;
    var $197 = $gfc + 39776 | 0;
    var $198 = HEAPF32[$197 >> 2];
    var $199 = $gfc + 39772 | 0;
    HEAPF32[$199 >> 2] = $198;
    var $200 = $gfc + 39780 | 0;
    var $201 = HEAPF32[$200 >> 2];
    var $202 = $gfc + 39776 | 0;
    HEAPF32[$202 >> 2] = $201;
    var $203 = $gfc + 39784 | 0;
    var $204 = HEAPF32[$203 >> 2];
    var $205 = $gfc + 39780 | 0;
    HEAPF32[$205 >> 2] = $204;
    var $206 = $gfc + 39788 | 0;
    var $207 = HEAPF32[$206 >> 2];
    var $208 = $gfc + 39784 | 0;
    HEAPF32[$208 >> 2] = $207;
    var $209 = $gfc + 39792 | 0;
    var $210 = HEAPF32[$209 >> 2];
    var $211 = $gfc + 39788 | 0;
    HEAPF32[$211 >> 2] = $210;
    var $212 = $gfc + 39796 | 0;
    var $213 = HEAPF32[$212 >> 2];
    var $214 = $gfc + 39792 | 0;
    HEAPF32[$214 >> 2] = $213;
    var $215 = $gfc + 39800 | 0;
    var $216 = HEAPF32[$215 >> 2];
    var $217 = $gfc + 39796 | 0;
    HEAPF32[$217 >> 2] = $216;
    var $218 = $gfc + 39804 | 0;
    var $219 = HEAPF32[$218 >> 2];
    var $220 = $gfc + 39800 | 0;
    HEAPF32[$220 >> 2] = $219;
    var $221 = $gfc + 39808 | 0;
    var $222 = HEAPF32[$221 >> 2];
    var $223 = $gfc + 39804 | 0;
    HEAPF32[$223 >> 2] = $222;
    var $224 = $gfc + 39812 | 0;
    var $225 = HEAPF32[$224 >> 2];
    var $226 = $gfc + 39808 | 0;
    HEAPF32[$226 >> 2] = $225;
    var $227 = $gfc + 39816 | 0;
    var $228 = HEAPF32[$227 >> 2];
    var $229 = $gfc + 39812 | 0;
    HEAPF32[$229 >> 2] = $228;
    var $230 = $gfc + 39820 | 0;
    var $231 = HEAPF32[$230 >> 2];
    var $232 = $gfc + 39816 | 0;
    HEAPF32[$232 >> 2] = $231;
    var $233 = $gfc + 39824 | 0;
    var $234 = HEAPF32[$233 >> 2];
    var $235 = $gfc + 39820 | 0;
    HEAPF32[$235 >> 2] = $234;
    var $236 = HEAP32[$24 >> 2];
    var $237 = ($236 | 0) > 0;
    if ($237) {
      label = 41;
      break;
    } else {
      var $f_0_lcssa = 0;
      label = 47;
      break;
    }
   case 43:
    var $f_0199;
    var $gr_3197;
    if ($180) {
      label = 44;
      break;
    } else {
      var $f_1_lcssa = $f_0199;
      label = 46;
      break;
    }
   case 44:
    var $238 = HEAP32[$178 >> 2];
    var $ch_4192 = 0;
    var $f_1193 = $f_0199;
    label = 45;
    break;
   case 45:
    var $f_1193;
    var $ch_4192;
    var $240 = $pe_MS_sink + ($gr_3197 << 3) + ($ch_4192 << 2) | 0;
    var $241 = HEAPF32[$240 >> 2];
    var $242 = $f_1193 + $241;
    var $243 = $ch_4192 + 1 | 0;
    var $244 = ($243 | 0) < ($238 | 0);
    if ($244) {
      var $ch_4192 = $243;
      var $f_1193 = $242;
      label = 45;
      break;
    } else {
      var $f_1_lcssa = $242;
      label = 46;
      break;
    }
   case 46:
    var $f_1_lcssa;
    var $245 = $gr_3197 + 1 | 0;
    var $246 = ($245 | 0) < ($181 | 0);
    if ($246) {
      var $gr_3197 = $245;
      var $f_0199 = $f_1_lcssa;
      label = 43;
      break;
    } else {
      var $f_0_lcssa = $f_1_lcssa;
      label = 47;
      break;
    }
   case 47:
    var $f_0_lcssa;
    var $248 = $gfc + 39824 | 0;
    HEAPF32[$248 >> 2] = $f_0_lcssa;
    var $249 = $gfc + 39788 | 0;
    var $250 = HEAPF32[$249 >> 2];
    var $251 = $gfc + 39752 | 0;
    var $252 = HEAPF32[$251 >> 2];
    var $253 = $252 + $f_0_lcssa;
    var $254 = $253 * -.10394349694252014;
    var $255 = $250 + $254;
    var $256 = $gfc + 39756 | 0;
    var $257 = HEAPF32[$256 >> 2];
    var $258 = $gfc + 39820 | 0;
    var $259 = HEAPF32[$258 >> 2];
    var $260 = $257 + $259;
    var $261 = $260 * -.18920649588108063;
    var $262 = $255 + $261;
    var $263 = $gfc + 39760 | 0;
    var $264 = HEAPF32[$263 >> 2];
    var $265 = $gfc + 39816 | 0;
    var $266 = HEAPF32[$265 >> 2];
    var $267 = $264 + $266;
    var $268 = $267 * -.21623599529266357;
    var $269 = $262 + $268;
    var $270 = $gfc + 39764 | 0;
    var $271 = HEAPF32[$270 >> 2];
    var $272 = $gfc + 39812 | 0;
    var $273 = HEAPF32[$272 >> 2];
    var $274 = $271 + $273;
    var $275 = $274 * -.1559150069952011;
    var $276 = $269 + $275;
    var $277 = $gfc + 39768 | 0;
    var $278 = HEAPF32[$277 >> 2];
    var $279 = $gfc + 39808 | 0;
    var $280 = HEAPF32[$279 >> 2];
    var $281 = $278 + $280;
    var $282 = $281 * 3.8980449615198e-17;
    var $283 = $276 + $282;
    var $284 = $gfc + 39772 | 0;
    var $285 = HEAPF32[$284 >> 2];
    var $286 = $gfc + 39804 | 0;
    var $287 = HEAPF32[$286 >> 2];
    var $288 = $285 + $287;
    var $289 = $288 * .23387250304222107;
    var $290 = $283 + $289;
    var $291 = $gfc + 39776 | 0;
    var $292 = HEAPF32[$291 >> 2];
    var $293 = $gfc + 39800 | 0;
    var $294 = HEAPF32[$293 >> 2];
    var $295 = $292 + $294;
    var $296 = $295 * .5045499801635742;
    var $297 = $290 + $296;
    var $298 = $gfc + 39780 | 0;
    var $299 = HEAPF32[$298 >> 2];
    var $300 = $gfc + 39796 | 0;
    var $301 = HEAPF32[$300 >> 2];
    var $302 = $299 + $301;
    var $303 = $302 * .7568249702453613;
    var $304 = $297 + $303;
    var $305 = $gfc + 39784 | 0;
    var $306 = HEAPF32[$305 >> 2];
    var $307 = $gfc + 39792 | 0;
    var $308 = HEAPF32[$307 >> 2];
    var $309 = $306 + $308;
    var $310 = $309 * .9354900121688843;
    var $311 = $304 + $310;
    var $312 = HEAP32[$24 >> 2];
    var $313 = $312 * 3350 & -1;
    var $314 = $gfc + 72 | 0;
    var $315 = HEAP32[$314 >> 2];
    var $316 = $313 * $315 & -1;
    var $317 = $316 | 0;
    var $318 = $317 / $311;
    var $319 = HEAP32[$24 >> 2];
    var $320 = ($319 | 0) > 0;
    if ($320) {
      label = 48;
      break;
    } else {
      label = 53;
      break;
    }
   case 48:
    var $321 = HEAP32[$314 >> 2];
    var $322 = ($321 | 0) > 0;
    var $323 = HEAP32[$24 >> 2];
    var $gr_4187 = 0;
    label = 49;
    break;
   case 49:
    var $gr_4187;
    if ($322) {
      label = 50;
      break;
    } else {
      label = 52;
      break;
    }
   case 50:
    var $324 = HEAP32[$314 >> 2];
    var $ch_5184 = 0;
    label = 51;
    break;
   case 51:
    var $ch_5184;
    var $326 = $pe_MS_sink + ($gr_4187 << 3) + ($ch_5184 << 2) | 0;
    var $327 = HEAPF32[$326 >> 2];
    var $328 = $318 * $327;
    HEAPF32[$326 >> 2] = $328;
    var $329 = $ch_5184 + 1 | 0;
    var $330 = ($329 | 0) < ($324 | 0);
    if ($330) {
      var $ch_5184 = $329;
      label = 51;
      break;
    } else {
      label = 52;
      break;
    }
   case 52:
    var $331 = $gr_4187 + 1 | 0;
    var $332 = ($331 | 0) < ($323 | 0);
    if ($332) {
      var $gr_4187 = $331;
      label = 49;
      break;
    } else {
      label = 53;
      break;
    }
   case 53:
    var $333 = $gfc + 85808 | 0;
    var $334 = HEAP32[$333 >> 2];
    var $335 = $ms_ener_ratio | 0;
    FUNCTION_TABLE[$334]($gfc, $121, $335, $120);
    var $336 = _format_bitstream($gfc);
    var $337 = _copy_buffer($gfc, $mp3buf, $mp3buf_size, 1);
    var $338 = $gfc + 156 | 0;
    var $339 = HEAP32[$338 >> 2];
    var $340 = ($339 | 0) == 0;
    if ($340) {
      label = 55;
      break;
    } else {
      label = 54;
      break;
    }
   case 54:
    _AddVbrFrame($gfc);
    label = 55;
    break;
   case 55:
    var $343 = HEAP32[$122 >> 2];
    var $344 = ($343 | 0) == 0;
    if ($344) {
      label = 64;
      break;
    } else {
      label = 56;
      break;
    }
   case 56:
    var $346 = $gfc + 85800 | 0;
    var $347 = HEAP32[$346 >> 2];
    var $348 = ($347 | 0) == 0;
    if ($348) {
      label = 64;
      break;
    } else {
      label = 57;
      break;
    }
   case 57:
    var $350 = HEAP32[$24 >> 2];
    var $351 = $350 * 576 & -1;
    var $352 = $gfc + 72 | 0;
    var $353 = HEAP32[$352 >> 2];
    var $354 = ($353 | 0) > 0;
    if ($354) {
      var $ch_6182 = 0;
      label = 58;
      break;
    } else {
      label = 63;
      break;
    }
   case 58:
    var $ch_6182;
    var $j_0180 = 0;
    label = 59;
    break;
   case 59:
    var $j_0180;
    var $356 = $j_0180 + $351 | 0;
    var $357 = HEAP32[$346 >> 2];
    var $358 = $357 + 20 + $ch_6182 * 12800 + ($356 << 3) | 0;
    var $359 = (HEAP32[tempDoublePtr >> 2] = HEAP32[$358 >> 2], HEAP32[tempDoublePtr + 4 >> 2] = HEAP32[$358 + 4 >> 2], HEAPF64[tempDoublePtr >> 3]);
    var $360 = $357 + 20 + $ch_6182 * 12800 + ($j_0180 << 3) | 0;
    HEAPF64[tempDoublePtr >> 3] = $359, HEAP32[$360 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$360 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    var $361 = $j_0180 + 1 | 0;
    var $exitcond = ($361 | 0) == 272;
    if ($exitcond) {
      label = 60;
      break;
    } else {
      var $j_0180 = $361;
      label = 59;
      break;
    }
   case 60:
    var $362 = $inbuf + ($ch_6182 << 2) | 0;
    var $363 = HEAP32[$362 >> 2];
    var $j_1181 = 272;
    label = 61;
    break;
   case 61:
    var $j_1181;
    var $365 = $j_1181 - 272 | 0;
    var $366 = $363 + ($365 << 2) | 0;
    var $367 = HEAPF32[$366 >> 2];
    var $368 = $367;
    var $369 = HEAP32[$346 >> 2];
    var $370 = $369 + 20 + $ch_6182 * 12800 + ($j_1181 << 3) | 0;
    HEAPF64[tempDoublePtr >> 3] = $368, HEAP32[$370 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$370 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    var $371 = $j_1181 + 1 | 0;
    var $exitcond244 = ($371 | 0) == 1600;
    if ($exitcond244) {
      label = 62;
      break;
    } else {
      var $j_1181 = $371;
      label = 61;
      break;
    }
   case 62:
    var $373 = $ch_6182 + 1 | 0;
    var $374 = HEAP32[$352 >> 2];
    var $375 = ($373 | 0) < ($374 | 0);
    if ($375) {
      var $ch_6182 = $373;
      label = 58;
      break;
    } else {
      label = 63;
      break;
    }
   case 63:
    var $376 = $gfc + 84904 | 0;
    HEAPF32[$376 >> 2] = 1;
    _set_frame_pinfo($gfc, $120);
    label = 64;
    break;
   case 64:
    var $378 = $gfc + 84744 | 0;
    var $379 = HEAP32[$378 >> 2];
    var $380 = $379 + 1 | 0;
    HEAP32[$378 >> 2] = $380;
    _updateStats($gfc);
    STACKTOP = __stackBase__;
    return $337;
  }
}
_lame_encode_mp3_frame["X"] = 1;
function _lame_encode_frame_init($gfc, $inbuf) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 16112 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $primebuff0 = __stackBase__;
    var $primebuff1 = __stackBase__ + 8056;
    var $1 = $gfc + 4 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($2 | 0) == 0;
    if ($3) {
      label = 3;
      break;
    } else {
      label = 19;
      break;
    }
   case 3:
    var $5 = $gfc + 76 | 0;
    var $6 = HEAP32[$5 >> 2];
    var $7 = $6 * 576 & -1;
    HEAP32[$1 >> 2] = 1;
    var $8 = $primebuff0;
    for (var $$dest = $8 >> 2, $$stop = $$dest + 2014; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $9 = $primebuff1;
    for (var $$dest = $9 >> 2, $$stop = $$dest + 2014; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $10 = HEAP32[$5 >> 2];
    var $11 = $10 * 576 & -1;
    var $12 = $11 + 862 | 0;
    var $13 = ($12 | 0) > 0;
    if ($13) {
      label = 4;
      break;
    } else {
      var $20 = $10;
      label = 6;
      break;
    }
   case 4:
    var $14 = $gfc + 72 | 0;
    var $15 = HEAP32[$5 >> 2];
    var $16 = $15 * 576 & -1;
    var $17 = $16 + 862 | 0;
    var $18 = $gfc + 72 | 0;
    var $19 = $inbuf + 4 | 0;
    var $i_029 = 0;
    var $j_030 = 0;
    label = 8;
    break;
   case 5:
    var $_pr = HEAP32[$5 >> 2];
    var $20 = $_pr;
    label = 6;
    break;
   case 6:
    var $20;
    var $21 = ($20 | 0) > 0;
    if ($21) {
      label = 7;
      break;
    } else {
      label = 18;
      break;
    }
   case 7:
    var $22 = $gfc + 72 | 0;
    var $gr_026 = 0;
    label = 15;
    break;
   case 8:
    var $j_030;
    var $i_029;
    var $24 = ($i_029 | 0) < ($7 | 0);
    if ($24) {
      label = 9;
      break;
    } else {
      label = 11;
      break;
    }
   case 9:
    var $26 = $primebuff0 + ($i_029 << 2) | 0;
    HEAPF32[$26 >> 2] = 0;
    var $27 = HEAP32[$14 >> 2];
    var $28 = ($27 | 0) == 2;
    if ($28) {
      label = 10;
      break;
    } else {
      var $j_1 = $j_030;
      label = 14;
      break;
    }
   case 10:
    var $30 = $primebuff1 + ($i_029 << 2) | 0;
    HEAPF32[$30 >> 2] = 0;
    var $j_1 = $j_030;
    label = 14;
    break;
   case 11:
    var $32 = HEAP32[$inbuf >> 2];
    var $33 = $32 + ($j_030 << 2) | 0;
    var $34 = HEAPF32[$33 >> 2];
    var $35 = $primebuff0 + ($i_029 << 2) | 0;
    HEAPF32[$35 >> 2] = $34;
    var $36 = HEAP32[$18 >> 2];
    var $37 = ($36 | 0) == 2;
    if ($37) {
      label = 12;
      break;
    } else {
      label = 13;
      break;
    }
   case 12:
    var $39 = HEAP32[$19 >> 2];
    var $40 = $39 + ($j_030 << 2) | 0;
    var $41 = HEAPF32[$40 >> 2];
    var $42 = $primebuff1 + ($i_029 << 2) | 0;
    HEAPF32[$42 >> 2] = $41;
    label = 13;
    break;
   case 13:
    var $44 = $j_030 + 1 | 0;
    var $j_1 = $44;
    label = 14;
    break;
   case 14:
    var $j_1;
    var $46 = $i_029 + 1 | 0;
    var $47 = ($46 | 0) < ($17 | 0);
    if ($47) {
      var $i_029 = $46;
      var $j_030 = $j_1;
      label = 8;
      break;
    } else {
      label = 5;
      break;
    }
   case 15:
    var $gr_026;
    var $48 = HEAP32[$22 >> 2];
    var $49 = ($48 | 0) > 0;
    if ($49) {
      var $ch_024 = 0;
      label = 16;
      break;
    } else {
      label = 17;
      break;
    }
   case 16:
    var $ch_024;
    var $50 = $gfc + 304 + $gr_026 * 10504 + $ch_024 * 5252 + 4788 | 0;
    HEAP32[$50 >> 2] = 2;
    var $51 = $ch_024 + 1 | 0;
    var $52 = HEAP32[$22 >> 2];
    var $53 = ($51 | 0) < ($52 | 0);
    if ($53) {
      var $ch_024 = $51;
      label = 16;
      break;
    } else {
      label = 17;
      break;
    }
   case 17:
    var $54 = $gr_026 + 1 | 0;
    var $55 = HEAP32[$5 >> 2];
    var $56 = ($54 | 0) < ($55 | 0);
    if ($56) {
      var $gr_026 = $54;
      label = 15;
      break;
    } else {
      label = 18;
      break;
    }
   case 18:
    var $57 = $primebuff0 | 0;
    var $58 = $primebuff1 | 0;
    _mdct_sub48($gfc, $57, $58);
    label = 19;
    break;
   case 19:
    STACKTOP = __stackBase__;
    return;
  }
}
_lame_encode_frame_init["X"] = 1;
function _fht($fz, $n) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $n << 1;
    var $2 = $fz + ($1 << 2) | 0;
    var $tri_0 = 5348652;
    var $k4_0 = 4;
    label = 3;
    break;
   case 3:
    var $k4_0;
    var $tri_0;
    var $4 = $k4_0 >> 1;
    var $5 = $k4_0 << 1;
    var $6 = $5 + $k4_0 | 0;
    var $7 = $k4_0 << 2;
    var $8 = $fz + ($4 << 2) | 0;
    var $fi_0 = $fz;
    var $gi_0 = $8;
    label = 4;
    break;
   case 4:
    var $gi_0;
    var $fi_0;
    var $10 = HEAPF32[$fi_0 >> 2];
    var $11 = $fi_0 + ($k4_0 << 2) | 0;
    var $12 = HEAPF32[$11 >> 2];
    var $13 = $10 - $12;
    var $14 = $10 + $12;
    var $15 = $fi_0 + ($5 << 2) | 0;
    var $16 = HEAPF32[$15 >> 2];
    var $17 = $fi_0 + ($6 << 2) | 0;
    var $18 = HEAPF32[$17 >> 2];
    var $19 = $16 - $18;
    var $20 = $16 + $18;
    var $21 = $14 - $20;
    HEAPF32[$15 >> 2] = $21;
    var $22 = $14 + $20;
    HEAPF32[$fi_0 >> 2] = $22;
    var $23 = $13 - $19;
    HEAPF32[$17 >> 2] = $23;
    var $24 = $13 + $19;
    HEAPF32[$11 >> 2] = $24;
    var $25 = HEAPF32[$gi_0 >> 2];
    var $26 = $gi_0 + ($k4_0 << 2) | 0;
    var $27 = HEAPF32[$26 >> 2];
    var $28 = $25 - $27;
    var $29 = $25 + $27;
    var $30 = $gi_0 + ($6 << 2) | 0;
    var $31 = HEAPF32[$30 >> 2];
    var $32 = $31;
    var $33 = $32 * 1.4142135623730951;
    var $34 = $33;
    var $35 = $gi_0 + ($5 << 2) | 0;
    var $36 = HEAPF32[$35 >> 2];
    var $37 = $36;
    var $38 = $37 * 1.4142135623730951;
    var $39 = $38;
    var $40 = $29 - $39;
    HEAPF32[$35 >> 2] = $40;
    var $41 = $29 + $39;
    HEAPF32[$gi_0 >> 2] = $41;
    var $42 = $28 - $34;
    HEAPF32[$30 >> 2] = $42;
    var $43 = $28 + $34;
    HEAPF32[$26 >> 2] = $43;
    var $44 = $gi_0 + ($7 << 2) | 0;
    var $45 = $fi_0 + ($7 << 2) | 0;
    var $46 = $45 >>> 0 < $2 >>> 0;
    if ($46) {
      var $fi_0 = $45;
      var $gi_0 = $44;
      label = 4;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $48 = $tri_0 + 4 | 0;
    var $49 = ($k4_0 | 0) > 2;
    if ($49) {
      label = 6;
      break;
    } else {
      label = 10;
      break;
    }
   case 6:
    var $50 = HEAPF32[$48 >> 2];
    var $51 = HEAPF32[$tri_0 >> 2];
    var $i_0166 = 1;
    var $c1_0167 = $51;
    var $s1_0168 = $50;
    label = 7;
    break;
   case 7:
    var $s1_0168;
    var $c1_0167;
    var $i_0166;
    var $53 = $s1_0168 * 2;
    var $54 = $s1_0168 * $53;
    var $55 = 1 - $54;
    var $56 = $c1_0167 * $53;
    var $57 = $fz + ($i_0166 << 2) | 0;
    var $_sum = $k4_0 - $i_0166 | 0;
    var $58 = $fz + ($_sum << 2) | 0;
    var $fi_1 = $57;
    var $gi_1 = $58;
    label = 8;
    break;
   case 8:
    var $gi_1;
    var $fi_1;
    var $60 = $fi_1 + ($k4_0 << 2) | 0;
    var $61 = HEAPF32[$60 >> 2];
    var $62 = $56 * $61;
    var $63 = $gi_1 + ($k4_0 << 2) | 0;
    var $64 = HEAPF32[$63 >> 2];
    var $65 = $55 * $64;
    var $66 = $62 - $65;
    var $67 = $55 * $61;
    var $68 = $56 * $64;
    var $69 = $67 + $68;
    var $70 = HEAPF32[$fi_1 >> 2];
    var $71 = $70 - $69;
    var $72 = $70 + $69;
    var $73 = HEAPF32[$gi_1 >> 2];
    var $74 = $73 - $66;
    var $75 = $73 + $66;
    var $76 = $fi_1 + ($6 << 2) | 0;
    var $77 = HEAPF32[$76 >> 2];
    var $78 = $56 * $77;
    var $79 = $gi_1 + ($6 << 2) | 0;
    var $80 = HEAPF32[$79 >> 2];
    var $81 = $55 * $80;
    var $82 = $78 - $81;
    var $83 = $55 * $77;
    var $84 = $56 * $80;
    var $85 = $83 + $84;
    var $86 = $fi_1 + ($5 << 2) | 0;
    var $87 = HEAPF32[$86 >> 2];
    var $88 = $87 - $85;
    var $89 = $87 + $85;
    var $90 = $gi_1 + ($5 << 2) | 0;
    var $91 = HEAPF32[$90 >> 2];
    var $92 = $91 - $82;
    var $93 = $91 + $82;
    var $94 = $s1_0168 * $89;
    var $95 = $c1_0167 * $92;
    var $96 = $94 - $95;
    var $97 = $c1_0167 * $89;
    var $98 = $s1_0168 * $92;
    var $99 = $97 + $98;
    var $100 = $72 - $99;
    HEAPF32[$86 >> 2] = $100;
    var $101 = $72 + $99;
    HEAPF32[$fi_1 >> 2] = $101;
    var $102 = $74 - $96;
    HEAPF32[$79 >> 2] = $102;
    var $103 = $74 + $96;
    HEAPF32[$63 >> 2] = $103;
    var $104 = $c1_0167 * $93;
    var $105 = $s1_0168 * $88;
    var $106 = $104 - $105;
    var $107 = $s1_0168 * $93;
    var $108 = $c1_0167 * $88;
    var $109 = $107 + $108;
    var $110 = $75 - $109;
    HEAPF32[$90 >> 2] = $110;
    var $111 = $75 + $109;
    HEAPF32[$gi_1 >> 2] = $111;
    var $112 = $71 - $106;
    HEAPF32[$76 >> 2] = $112;
    var $113 = $71 + $106;
    HEAPF32[$60 >> 2] = $113;
    var $114 = $gi_1 + ($7 << 2) | 0;
    var $115 = $fi_1 + ($7 << 2) | 0;
    var $116 = $115 >>> 0 < $2 >>> 0;
    if ($116) {
      var $fi_1 = $115;
      var $gi_1 = $114;
      label = 8;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    var $118 = HEAPF32[$tri_0 >> 2];
    var $119 = $c1_0167 * $118;
    var $120 = HEAPF32[$48 >> 2];
    var $121 = $s1_0168 * $120;
    var $122 = $119 - $121;
    var $123 = $c1_0167 * $120;
    var $124 = $s1_0168 * $118;
    var $125 = $124 + $123;
    var $126 = $i_0166 + 1 | 0;
    var $127 = ($126 | 0) < ($4 | 0);
    if ($127) {
      var $i_0166 = $126;
      var $c1_0167 = $122;
      var $s1_0168 = $125;
      label = 7;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    var $128 = $tri_0 + 8 | 0;
    var $129 = ($7 | 0) < ($1 | 0);
    if ($129) {
      var $tri_0 = $128;
      var $k4_0 = $7;
      label = 3;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    return;
  }
}
_fht["X"] = 1;
function _fft_short($gfc, $x_real, $chn, $buffer) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $buffer + ($chn << 2) | 0;
    var $2 = $gfc + 85816 | 0;
    var $b_080 = 0;
    var $indvars_iv = $x_real;
    label = 3;
    break;
   case 3:
    var $indvars_iv;
    var $b_080;
    var $4 = $x_real + ($b_080 << 10) + 512 | 0;
    var $5 = $b_080 + 1 | 0;
    var $sext = $5 * 12582912 & -1;
    var $6 = $sext >> 16;
    var $j_0 = 31;
    var $x_0 = $4;
    label = 4;
    break;
   case 4:
    var $x_0;
    var $j_0;
    var $8 = $j_0 << 2;
    var $9 = $8 + 5256844 | 0;
    var $10 = HEAP8[$9];
    var $11 = $10 & 255;
    var $12 = 5242880 + ($11 << 2) | 0;
    var $13 = HEAPF32[$12 >> 2];
    var $14 = $11 + $6 | 0;
    var $15 = HEAP32[$1 >> 2];
    var $16 = $15 + ($14 << 2) | 0;
    var $17 = HEAPF32[$16 >> 2];
    var $18 = $13 * $17;
    var $19 = 127 - $11 | 0;
    var $20 = 5242880 + ($19 << 2) | 0;
    var $21 = HEAPF32[$20 >> 2];
    var $22 = $14 + 128 | 0;
    var $23 = $15 + ($22 << 2) | 0;
    var $24 = HEAPF32[$23 >> 2];
    var $25 = $21 * $24;
    var $26 = $18 - $25;
    var $27 = $18 + $25;
    var $28 = $11 + 64 | 0;
    var $29 = 5242880 + ($28 << 2) | 0;
    var $30 = HEAPF32[$29 >> 2];
    var $31 = $14 + 64 | 0;
    var $32 = $15 + ($31 << 2) | 0;
    var $33 = HEAPF32[$32 >> 2];
    var $34 = $30 * $33;
    var $35 = 63 - $11 | 0;
    var $36 = 5242880 + ($35 << 2) | 0;
    var $37 = HEAPF32[$36 >> 2];
    var $38 = $14 + 192 | 0;
    var $39 = $15 + ($38 << 2) | 0;
    var $40 = HEAPF32[$39 >> 2];
    var $41 = $37 * $40;
    var $42 = $34 - $41;
    var $43 = $34 + $41;
    var $44 = $x_0 - 16 | 0;
    var $45 = $27 + $43;
    HEAPF32[$44 >> 2] = $45;
    var $46 = $27 - $43;
    var $47 = $x_0 - 8 | 0;
    HEAPF32[$47 >> 2] = $46;
    var $48 = $26 + $42;
    var $49 = $x_0 - 12 | 0;
    HEAPF32[$49 >> 2] = $48;
    var $50 = $26 - $42;
    var $51 = $x_0 - 4 | 0;
    HEAPF32[$51 >> 2] = $50;
    var $52 = $11 + 1 | 0;
    var $53 = 5242880 + ($52 << 2) | 0;
    var $54 = HEAPF32[$53 >> 2];
    var $55 = $14 + 1 | 0;
    var $56 = HEAP32[$1 >> 2];
    var $57 = $56 + ($55 << 2) | 0;
    var $58 = HEAPF32[$57 >> 2];
    var $59 = $54 * $58;
    var $60 = 126 - $11 | 0;
    var $61 = 5242880 + ($60 << 2) | 0;
    var $62 = HEAPF32[$61 >> 2];
    var $63 = $14 + 129 | 0;
    var $64 = $56 + ($63 << 2) | 0;
    var $65 = HEAPF32[$64 >> 2];
    var $66 = $62 * $65;
    var $67 = $59 - $66;
    var $68 = $59 + $66;
    var $69 = $11 + 65 | 0;
    var $70 = 5242880 + ($69 << 2) | 0;
    var $71 = HEAPF32[$70 >> 2];
    var $72 = $14 + 65 | 0;
    var $73 = $56 + ($72 << 2) | 0;
    var $74 = HEAPF32[$73 >> 2];
    var $75 = $71 * $74;
    var $76 = 62 - $11 | 0;
    var $77 = 5242880 + ($76 << 2) | 0;
    var $78 = HEAPF32[$77 >> 2];
    var $79 = $14 + 193 | 0;
    var $80 = $56 + ($79 << 2) | 0;
    var $81 = HEAPF32[$80 >> 2];
    var $82 = $78 * $81;
    var $83 = $75 - $82;
    var $84 = $75 + $82;
    var $85 = $68 + $84;
    var $86 = $x_0 + 496 | 0;
    HEAPF32[$86 >> 2] = $85;
    var $87 = $68 - $84;
    var $88 = $x_0 + 504 | 0;
    HEAPF32[$88 >> 2] = $87;
    var $89 = $67 + $83;
    var $90 = $x_0 + 500 | 0;
    HEAPF32[$90 >> 2] = $89;
    var $91 = $67 - $83;
    var $92 = $x_0 + 508 | 0;
    HEAPF32[$92 >> 2] = $91;
    var $93 = $j_0 - 1 | 0;
    var $94 = ($j_0 | 0) > 0;
    if ($94) {
      var $j_0 = $93;
      var $x_0 = $44;
      label = 4;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $indvars_iv81 = $indvars_iv | 0;
    var $96 = HEAP32[$2 >> 2];
    FUNCTION_TABLE[$96]($indvars_iv81, 128);
    var $scevgep = $indvars_iv + 1024 | 0;
    var $97 = $scevgep;
    var $exitcond = ($5 | 0) == 3;
    if ($exitcond) {
      label = 6;
      break;
    } else {
      var $b_080 = $5;
      var $indvars_iv = $97;
      label = 3;
      break;
    }
   case 6:
    return;
  }
}
_fft_short["X"] = 1;
function _fft_long($gfc, $x, $chn, $buffer) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $x + 2048 | 0;
    var $2 = $buffer + ($chn << 2) | 0;
    var $_0 = $1;
    var $jj_0 = 127;
    label = 3;
    break;
   case 3:
    var $jj_0;
    var $_0;
    var $4 = $jj_0 + 5256844 | 0;
    var $5 = HEAP8[$4];
    var $6 = $5 & 255;
    var $7 = 5243392 + ($6 << 2) | 0;
    var $8 = HEAPF32[$7 >> 2];
    var $9 = HEAP32[$2 >> 2];
    var $10 = $9 + ($6 << 2) | 0;
    var $11 = HEAPF32[$10 >> 2];
    var $12 = $8 * $11;
    var $13 = $6 | 512;
    var $14 = 5243392 + ($13 << 2) | 0;
    var $15 = HEAPF32[$14 >> 2];
    var $16 = $9 + ($13 << 2) | 0;
    var $17 = HEAPF32[$16 >> 2];
    var $18 = $15 * $17;
    var $19 = $12 - $18;
    var $20 = $12 + $18;
    var $21 = $6 | 256;
    var $22 = 5243392 + ($21 << 2) | 0;
    var $23 = HEAPF32[$22 >> 2];
    var $24 = $9 + ($21 << 2) | 0;
    var $25 = HEAPF32[$24 >> 2];
    var $26 = $23 * $25;
    var $27 = $6 | 768;
    var $28 = 5243392 + ($27 << 2) | 0;
    var $29 = HEAPF32[$28 >> 2];
    var $30 = $9 + ($27 << 2) | 0;
    var $31 = HEAPF32[$30 >> 2];
    var $32 = $29 * $31;
    var $33 = $26 - $32;
    var $34 = $26 + $32;
    var $35 = $_0 - 16 | 0;
    var $36 = $20 + $34;
    HEAPF32[$35 >> 2] = $36;
    var $37 = $20 - $34;
    var $38 = $_0 - 8 | 0;
    HEAPF32[$38 >> 2] = $37;
    var $39 = $19 + $33;
    var $40 = $_0 - 12 | 0;
    HEAPF32[$40 >> 2] = $39;
    var $41 = $19 - $33;
    var $42 = $_0 - 4 | 0;
    HEAPF32[$42 >> 2] = $41;
    var $43 = $6 + 1 | 0;
    var $44 = 5243392 + ($43 << 2) | 0;
    var $45 = HEAPF32[$44 >> 2];
    var $46 = HEAP32[$2 >> 2];
    var $47 = $46 + ($43 << 2) | 0;
    var $48 = HEAPF32[$47 >> 2];
    var $49 = $45 * $48;
    var $50 = $6 + 513 | 0;
    var $51 = 5243392 + ($50 << 2) | 0;
    var $52 = HEAPF32[$51 >> 2];
    var $53 = $46 + ($50 << 2) | 0;
    var $54 = HEAPF32[$53 >> 2];
    var $55 = $52 * $54;
    var $56 = $49 - $55;
    var $57 = $49 + $55;
    var $58 = $6 + 257 | 0;
    var $59 = 5243392 + ($58 << 2) | 0;
    var $60 = HEAPF32[$59 >> 2];
    var $61 = $46 + ($58 << 2) | 0;
    var $62 = HEAPF32[$61 >> 2];
    var $63 = $60 * $62;
    var $64 = $6 + 769 | 0;
    var $65 = 5243392 + ($64 << 2) | 0;
    var $66 = HEAPF32[$65 >> 2];
    var $67 = $46 + ($64 << 2) | 0;
    var $68 = HEAPF32[$67 >> 2];
    var $69 = $66 * $68;
    var $70 = $63 - $69;
    var $71 = $63 + $69;
    var $72 = $57 + $71;
    var $73 = $_0 + 2032 | 0;
    HEAPF32[$73 >> 2] = $72;
    var $74 = $57 - $71;
    var $75 = $_0 + 2040 | 0;
    HEAPF32[$75 >> 2] = $74;
    var $76 = $56 + $70;
    var $77 = $_0 + 2036 | 0;
    HEAPF32[$77 >> 2] = $76;
    var $78 = $56 - $70;
    var $79 = $_0 + 2044 | 0;
    HEAPF32[$79 >> 2] = $78;
    var $80 = $jj_0 - 1 | 0;
    var $81 = ($jj_0 | 0) > 0;
    if ($81) {
      var $_0 = $35;
      var $jj_0 = $80;
      label = 3;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $83 = $gfc + 85816 | 0;
    var $84 = HEAP32[$83 >> 2];
    FUNCTION_TABLE[$84]($x, 512);
    return;
  }
}
_fft_long["X"] = 1;
function _init_fft($gfc) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $i_010 = 0;
    label = 3;
    break;
   case 3:
    var $i_010;
    var $2 = $i_010 | 0;
    var $3 = $2 + .5;
    var $4 = $3 * 6.283185307179586;
    var $5 = $4 * .0009765625;
    var $6 = Math.cos($5);
    var $7 = $6 * .5;
    var $8 = .42 - $7;
    var $9 = $3 * 12.566370614359172;
    var $10 = $9 * .0009765625;
    var $11 = Math.cos($10);
    var $12 = $11 * .08;
    var $13 = $8 + $12;
    var $14 = $13;
    var $15 = 5243392 + ($i_010 << 2) | 0;
    HEAPF32[$15 >> 2] = $14;
    var $16 = $i_010 + 1 | 0;
    var $exitcond11 = ($16 | 0) == 1024;
    if ($exitcond11) {
      var $i_19 = 0;
      label = 4;
      break;
    } else {
      var $i_010 = $16;
      label = 3;
      break;
    }
   case 4:
    var $i_19;
    var $17 = $i_19 | 0;
    var $18 = $17 + .5;
    var $19 = $18 * 6.283185307179586;
    var $20 = $19 * .00390625;
    var $21 = Math.cos($20);
    var $22 = 1 - $21;
    var $23 = $22 * .5;
    var $24 = $23;
    var $25 = 5242880 + ($i_19 << 2) | 0;
    HEAPF32[$25 >> 2] = $24;
    var $26 = $i_19 + 1 | 0;
    var $exitcond = ($26 | 0) == 128;
    if ($exitcond) {
      label = 5;
      break;
    } else {
      var $i_19 = $26;
      label = 4;
      break;
    }
   case 5:
    var $28 = $gfc + 85816 | 0;
    HEAP32[$28 >> 2] = 50;
    return;
  }
}
function _InitGainAnalysis($rgData, $samplefreq) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = _ResetSampleFrequency($rgData, $samplefreq);
    var $2 = ($1 | 0) == 1;
    if ($2) {
      label = 3;
      break;
    } else {
      var $_0 = 0;
      label = 4;
      break;
    }
   case 3:
    var $4 = $rgData + 40 | 0;
    var $5 = $rgData + 80 | 0;
    HEAP32[$5 >> 2] = $4;
    var $6 = $rgData + 19420 | 0;
    var $7 = $rgData + 19460 | 0;
    HEAP32[$7 >> 2] = $6;
    var $8 = $rgData + 124 | 0;
    var $9 = $rgData + 9728 | 0;
    HEAP32[$9 >> 2] = $8;
    var $10 = $rgData + 19504 | 0;
    var $11 = $rgData + 29108 | 0;
    HEAP32[$11 >> 2] = $10;
    var $12 = $rgData + 9772 | 0;
    var $13 = $rgData + 19376 | 0;
    HEAP32[$13 >> 2] = $12;
    var $14 = $rgData + 29152 | 0;
    var $15 = $rgData + 38756 | 0;
    HEAP32[$15 >> 2] = $14;
    var $16 = $rgData + 86792 | 0;
    var $17 = $16;
    for (var $$dest = $17 >> 2, $$stop = $$dest + 12e3; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $_0 = 1;
    label = 4;
    break;
   case 4:
    var $_0;
    return $_0;
  }
}
function _ResetSampleFrequency($rgData, $samplefreq) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $rgData + 29112 | 0;
    var $2 = $rgData + 19464 | 0;
    var $3 = $rgData + 19380 | 0;
    var $4 = $rgData + 9732 | 0;
    var $5 = $rgData + 84 | 0;
    var $6 = $rgData;
    for (var $$dest = $6 >> 2, $$stop = $$dest + 10; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $7 = $5;
    for (var $$dest = $7 >> 2, $$stop = $$dest + 10; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $8 = $4;
    for (var $$dest = $8 >> 2, $$stop = $$dest + 10; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $9 = $3;
    for (var $$dest = $9 >> 2, $$stop = $$dest + 10; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $10 = $2;
    for (var $$dest = $10 >> 2, $$stop = $$dest + 10; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $11 = $1;
    for (var $$dest = $11 >> 2, $$stop = $$dest + 10; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    if (($samplefreq | 0) == 48e3) {
      label = 3;
      break;
    } else if (($samplefreq | 0) == 44100) {
      label = 4;
      break;
    } else if (($samplefreq | 0) == 32e3) {
      label = 5;
      break;
    } else if (($samplefreq | 0) == 24e3) {
      label = 6;
      break;
    } else if (($samplefreq | 0) == 22050) {
      label = 7;
      break;
    } else if (($samplefreq | 0) == 16e3) {
      label = 8;
      break;
    } else if (($samplefreq | 0) == 12e3) {
      label = 9;
      break;
    } else if (($samplefreq | 0) == 11025) {
      label = 10;
      break;
    } else if (($samplefreq | 0) == 8e3) {
      label = 11;
      break;
    } else {
      var $_0 = 0;
      label = 13;
      break;
    }
   case 3:
    var $13 = $rgData + 38784 | 0;
    HEAP32[$13 >> 2] = 0;
    label = 12;
    break;
   case 4:
    var $15 = $rgData + 38784 | 0;
    HEAP32[$15 >> 2] = 1;
    label = 12;
    break;
   case 5:
    var $17 = $rgData + 38784 | 0;
    HEAP32[$17 >> 2] = 2;
    label = 12;
    break;
   case 6:
    var $19 = $rgData + 38784 | 0;
    HEAP32[$19 >> 2] = 3;
    label = 12;
    break;
   case 7:
    var $21 = $rgData + 38784 | 0;
    HEAP32[$21 >> 2] = 4;
    label = 12;
    break;
   case 8:
    var $23 = $rgData + 38784 | 0;
    HEAP32[$23 >> 2] = 5;
    label = 12;
    break;
   case 9:
    var $25 = $rgData + 38784 | 0;
    HEAP32[$25 >> 2] = 6;
    label = 12;
    break;
   case 10:
    var $27 = $rgData + 38784 | 0;
    HEAP32[$27 >> 2] = 7;
    label = 12;
    break;
   case 11:
    var $29 = $rgData + 38784 | 0;
    HEAP32[$29 >> 2] = 8;
    label = 12;
    break;
   case 12:
    var $31 = $samplefreq + 19 | 0;
    var $32 = ($31 | 0) / 20 & -1;
    var $33 = $rgData + 38760 | 0;
    HEAP32[$33 >> 2] = $32;
    var $34 = $rgData + 38764 | 0;
    var $35 = $rgData + 38792 | 0;
    var $36 = $35;
    for (var $$dest = $36 >> 2, $$stop = $$dest + 12e3; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $37 = $34;
    HEAP32[$37 >> 2] = 0;
    HEAP32[$37 + 4 >> 2] = 0;
    HEAP32[$37 + 8 >> 2] = 0;
    HEAP32[$37 + 12 >> 2] = 0;
    HEAP32[$37 + 16 >> 2] = 0;
    var $_0 = 1;
    label = 13;
    break;
   case 13:
    var $_0;
    return $_0;
  }
}
_ResetSampleFrequency["X"] = 1;
function _AnalyzeSamples($rgData, $left_samples, $right_samples, $num_samples, $num_channels) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($num_samples | 0) == 0;
    if ($1) {
      var $_0 = 1;
      label = 27;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    if (($num_channels | 0) == 1) {
      label = 4;
      break;
    } else if (($num_channels | 0) == 2) {
      var $_0134 = $right_samples;
      label = 5;
      break;
    } else {
      var $_0 = 0;
      label = 27;
      break;
    }
   case 4:
    var $_0134 = $left_samples;
    label = 5;
    break;
   case 5:
    var $_0134;
    var $5 = $num_samples >>> 0 < 10;
    var $6 = $rgData + 40 | 0;
    var $7 = $6;
    var $8 = $left_samples;
    if ($5) {
      label = 6;
      break;
    } else {
      label = 7;
      break;
    }
   case 6:
    var $10 = $num_samples << 2;
    _memcpy($7, $8, $10);
    var $11 = $rgData + 19420 | 0;
    var $12 = $11;
    var $13 = $_0134;
    _memcpy($12, $13, $10);
    label = 8;
    break;
   case 7:
    for (var $$src = $8 >> 2, $$dest = $7 >> 2, $$stop = $$src + 10; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    var $15 = $rgData + 19420 | 0;
    var $16 = $15;
    var $17 = $_0134;
    for (var $$src = $17 >> 2, $$dest = $16 >> 2, $$stop = $$src + 10; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    label = 8;
    break;
   case 8:
    var $18 = $rgData + 38760 | 0;
    var $19 = $rgData + 38764 | 0;
    var $20 = $rgData + 80 | 0;
    var $21 = $rgData + 19460 | 0;
    var $22 = $rgData + 9728 | 0;
    var $23 = $rgData + 38784 | 0;
    var $24 = $rgData + 29108 | 0;
    var $25 = $rgData + 19376 | 0;
    var $26 = $rgData + 38756 | 0;
    var $27 = $rgData + 38768 | 0;
    var $28 = $rgData + 38776 | 0;
    var $29 = $rgData + 9732 | 0;
    var $30 = $29;
    var $31 = $rgData + 29112 | 0;
    var $32 = $31;
    var $33 = $rgData + 84 | 0;
    var $34 = $33;
    var $35 = $rgData + 19464 | 0;
    var $36 = $35;
    var $37 = $rgData + 38768 | 0;
    var $38 = $rgData + 38776 | 0;
    var $39 = $rgData + 38768 | 0;
    var $40 = $rgData + 38776 | 0;
    var $cursamplepos_0 = 0;
    var $batchsamples_0 = $num_samples;
    label = 9;
    break;
   case 9:
    var $batchsamples_0;
    var $cursamplepos_0;
    var $42 = ($batchsamples_0 | 0) > 0;
    if ($42) {
      label = 10;
      break;
    } else {
      label = 24;
      break;
    }
   case 10:
    var $44 = HEAP32[$18 >> 2];
    var $45 = HEAP32[$19 >> 2];
    var $46 = $44 - $45 | 0;
    var $47 = ($batchsamples_0 | 0) > ($46 | 0);
    var $_batchsamples_0 = $47 ? $46 : $batchsamples_0;
    var $48 = ($cursamplepos_0 | 0) < 10;
    if ($48) {
      label = 11;
      break;
    } else {
      var $cursamples_0 = $_batchsamples_0;
      var $_0134_pn = $_0134;
      var $left_samples_pn = $left_samples;
      label = 12;
      break;
    }
   case 11:
    var $50 = HEAP32[$20 >> 2];
    var $51 = HEAP32[$21 >> 2];
    var $52 = 10 - $cursamplepos_0 | 0;
    var $53 = ($_batchsamples_0 | 0) > ($52 | 0);
    var $__batchsamples_0 = $53 ? $52 : $_batchsamples_0;
    var $cursamples_0 = $__batchsamples_0;
    var $_0134_pn = $51;
    var $left_samples_pn = $50;
    label = 12;
    break;
   case 12:
    var $left_samples_pn;
    var $_0134_pn;
    var $cursamples_0;
    var $curright_0 = $_0134_pn + ($cursamplepos_0 << 2) | 0;
    var $curleft_0 = $left_samples_pn + ($cursamplepos_0 << 2) | 0;
    var $55 = HEAP32[$22 >> 2];
    var $56 = HEAP32[$19 >> 2];
    var $57 = $55 + ($56 << 2) | 0;
    var $58 = HEAP32[$23 >> 2];
    var $59 = 5388128 + $58 * 84 | 0;
    _filterYule($curleft_0, $57, $cursamples_0, $59);
    var $60 = HEAP32[$24 >> 2];
    var $61 = HEAP32[$19 >> 2];
    var $62 = $60 + ($61 << 2) | 0;
    var $63 = HEAP32[$23 >> 2];
    var $64 = 5388128 + $63 * 84 | 0;
    _filterYule($curright_0, $62, $cursamples_0, $64);
    var $65 = HEAP32[$22 >> 2];
    var $66 = HEAP32[$19 >> 2];
    var $67 = $65 + ($66 << 2) | 0;
    var $68 = HEAP32[$25 >> 2];
    var $69 = $68 + ($66 << 2) | 0;
    var $70 = HEAP32[$23 >> 2];
    var $71 = 5388884 + $70 * 20 | 0;
    _filterButter($67, $69, $cursamples_0, $71);
    var $72 = HEAP32[$24 >> 2];
    var $73 = HEAP32[$19 >> 2];
    var $74 = $72 + ($73 << 2) | 0;
    var $75 = HEAP32[$26 >> 2];
    var $76 = $75 + ($73 << 2) | 0;
    var $77 = HEAP32[$23 >> 2];
    var $78 = 5388884 + $77 * 20 | 0;
    _filterButter($74, $76, $cursamples_0, $78);
    var $79 = HEAP32[$25 >> 2];
    var $80 = HEAP32[$19 >> 2];
    var $81 = $79 + ($80 << 2) | 0;
    var $82 = HEAP32[$26 >> 2];
    var $83 = $82 + ($80 << 2) | 0;
    var $84 = ($cursamples_0 | 0) % 8;
    var $85 = ($84 | 0) == 0;
    if ($85) {
      var $curleft_1_lcssa = $81;
      var $curright_1_lcssa = $83;
      label = 16;
      break;
    } else {
      label = 13;
      break;
    }
   case 13:
    var $86 = $80 + $84 | 0;
    var $scevgep = $82 + ($86 << 2) | 0;
    var $curleft_1138 = $81;
    var $curright_1139 = $83;
    var $i_0140 = $84;
    label = 14;
    break;
   case 14:
    var $i_0140;
    var $curright_1139;
    var $curleft_1138;
    var $88 = $i_0140 - 1 | 0;
    var $89 = $curleft_1138 + 4 | 0;
    var $90 = HEAPF32[$curleft_1138 >> 2];
    var $91 = $90;
    var $92 = _fsqr($91);
    var $93 = (HEAP32[tempDoublePtr >> 2] = HEAP32[$39 >> 2], HEAP32[tempDoublePtr + 4 >> 2] = HEAP32[$39 + 4 >> 2], HEAPF64[tempDoublePtr >> 3]);
    var $94 = $92 + $93;
    HEAPF64[tempDoublePtr >> 3] = $94, HEAP32[$39 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$39 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    var $95 = $curright_1139 + 4 | 0;
    var $96 = HEAPF32[$curright_1139 >> 2];
    var $97 = $96;
    var $98 = _fsqr($97);
    var $99 = (HEAP32[tempDoublePtr >> 2] = HEAP32[$40 >> 2], HEAP32[tempDoublePtr + 4 >> 2] = HEAP32[$40 + 4 >> 2], HEAPF64[tempDoublePtr >> 3]);
    var $100 = $98 + $99;
    HEAPF64[tempDoublePtr >> 3] = $100, HEAP32[$40 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$40 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    var $101 = ($88 | 0) == 0;
    if ($101) {
      label = 15;
      break;
    } else {
      var $curleft_1138 = $89;
      var $curright_1139 = $95;
      var $i_0140 = $88;
      label = 14;
      break;
    }
   case 15:
    var $scevgep149 = $79 + ($86 << 2) | 0;
    var $curleft_1_lcssa = $scevgep149;
    var $curright_1_lcssa = $scevgep;
    label = 16;
    break;
   case 16:
    var $curright_1_lcssa;
    var $curleft_1_lcssa;
    var $cursamples_0_off = $cursamples_0 + 7 | 0;
    var $103 = $cursamples_0_off >>> 0 < 15;
    if ($103) {
      label = 19;
      break;
    } else {
      label = 17;
      break;
    }
   case 17:
    var $104 = ($cursamples_0 | 0) / 8 & -1;
    var $curleft_2142 = $curleft_1_lcssa;
    var $curright_2143 = $curright_1_lcssa;
    var $i_1144 = $104;
    label = 18;
    break;
   case 18:
    var $i_1144;
    var $curright_2143;
    var $curleft_2142;
    var $106 = $i_1144 - 1 | 0;
    var $107 = HEAPF32[$curleft_2142 >> 2];
    var $108 = $107;
    var $109 = _fsqr($108);
    var $110 = $curleft_2142 + 4 | 0;
    var $111 = HEAPF32[$110 >> 2];
    var $112 = $111;
    var $113 = _fsqr($112);
    var $114 = $109 + $113;
    var $115 = $curleft_2142 + 8 | 0;
    var $116 = HEAPF32[$115 >> 2];
    var $117 = $116;
    var $118 = _fsqr($117);
    var $119 = $114 + $118;
    var $120 = $curleft_2142 + 12 | 0;
    var $121 = HEAPF32[$120 >> 2];
    var $122 = $121;
    var $123 = _fsqr($122);
    var $124 = $119 + $123;
    var $125 = $curleft_2142 + 16 | 0;
    var $126 = HEAPF32[$125 >> 2];
    var $127 = $126;
    var $128 = _fsqr($127);
    var $129 = $124 + $128;
    var $130 = $curleft_2142 + 20 | 0;
    var $131 = HEAPF32[$130 >> 2];
    var $132 = $131;
    var $133 = _fsqr($132);
    var $134 = $129 + $133;
    var $135 = $curleft_2142 + 24 | 0;
    var $136 = HEAPF32[$135 >> 2];
    var $137 = $136;
    var $138 = _fsqr($137);
    var $139 = $134 + $138;
    var $140 = $curleft_2142 + 28 | 0;
    var $141 = HEAPF32[$140 >> 2];
    var $142 = $141;
    var $143 = _fsqr($142);
    var $144 = $139 + $143;
    var $145 = (HEAP32[tempDoublePtr >> 2] = HEAP32[$37 >> 2], HEAP32[tempDoublePtr + 4 >> 2] = HEAP32[$37 + 4 >> 2], HEAPF64[tempDoublePtr >> 3]);
    var $146 = $145 + $144;
    HEAPF64[tempDoublePtr >> 3] = $146, HEAP32[$37 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$37 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    var $147 = $curleft_2142 + 32 | 0;
    var $148 = HEAPF32[$curright_2143 >> 2];
    var $149 = $148;
    var $150 = _fsqr($149);
    var $151 = $curright_2143 + 4 | 0;
    var $152 = HEAPF32[$151 >> 2];
    var $153 = $152;
    var $154 = _fsqr($153);
    var $155 = $150 + $154;
    var $156 = $curright_2143 + 8 | 0;
    var $157 = HEAPF32[$156 >> 2];
    var $158 = $157;
    var $159 = _fsqr($158);
    var $160 = $155 + $159;
    var $161 = $curright_2143 + 12 | 0;
    var $162 = HEAPF32[$161 >> 2];
    var $163 = $162;
    var $164 = _fsqr($163);
    var $165 = $160 + $164;
    var $166 = $curright_2143 + 16 | 0;
    var $167 = HEAPF32[$166 >> 2];
    var $168 = $167;
    var $169 = _fsqr($168);
    var $170 = $165 + $169;
    var $171 = $curright_2143 + 20 | 0;
    var $172 = HEAPF32[$171 >> 2];
    var $173 = $172;
    var $174 = _fsqr($173);
    var $175 = $170 + $174;
    var $176 = $curright_2143 + 24 | 0;
    var $177 = HEAPF32[$176 >> 2];
    var $178 = $177;
    var $179 = _fsqr($178);
    var $180 = $175 + $179;
    var $181 = $curright_2143 + 28 | 0;
    var $182 = HEAPF32[$181 >> 2];
    var $183 = $182;
    var $184 = _fsqr($183);
    var $185 = $180 + $184;
    var $186 = (HEAP32[tempDoublePtr >> 2] = HEAP32[$38 >> 2], HEAP32[tempDoublePtr + 4 >> 2] = HEAP32[$38 + 4 >> 2], HEAPF64[tempDoublePtr >> 3]);
    var $187 = $186 + $185;
    HEAPF64[tempDoublePtr >> 3] = $187, HEAP32[$38 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$38 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    var $188 = $curright_2143 + 32 | 0;
    var $189 = ($106 | 0) == 0;
    if ($189) {
      label = 19;
      break;
    } else {
      var $curleft_2142 = $147;
      var $curright_2143 = $188;
      var $i_1144 = $106;
      label = 18;
      break;
    }
   case 19:
    var $190 = $batchsamples_0 - $cursamples_0 | 0;
    var $191 = $cursamples_0 + $cursamplepos_0 | 0;
    var $192 = HEAP32[$19 >> 2];
    var $193 = $192 + $cursamples_0 | 0;
    HEAP32[$19 >> 2] = $193;
    var $194 = HEAP32[$18 >> 2];
    var $195 = ($193 | 0) == ($194 | 0);
    if ($195) {
      label = 20;
      break;
    } else {
      label = 23;
      break;
    }
   case 20:
    var $197 = (HEAP32[tempDoublePtr >> 2] = HEAP32[$27 >> 2], HEAP32[tempDoublePtr + 4 >> 2] = HEAP32[$27 + 4 >> 2], HEAPF64[tempDoublePtr >> 3]);
    var $198 = (HEAP32[tempDoublePtr >> 2] = HEAP32[$28 >> 2], HEAP32[tempDoublePtr + 4 >> 2] = HEAP32[$28 + 4 >> 2], HEAPF64[tempDoublePtr >> 3]);
    var $199 = $197 + $198;
    var $200 = $193 | 0;
    var $201 = $199 / $200;
    var $202 = $201 * .5;
    var $203 = $202 + 1e-37;
    var $204 = _log10($203);
    var $205 = $204 * 1e3;
    var $206 = $205 > 0;
    if ($206) {
      label = 21;
      break;
    } else {
      var $210 = 0;
      label = 22;
      break;
    }
   case 21:
    var $208 = $205 >= 0 ? Math.floor($205) : Math.ceil($205);
    var $210 = $208;
    label = 22;
    break;
   case 22:
    var $210;
    var $211 = $210 >>> 0 > 11999;
    var $_ = $211 ? 11999 : $210;
    var $212 = $rgData + 38792 + ($_ << 2) | 0;
    var $213 = HEAP32[$212 >> 2];
    var $214 = $213 + 1 | 0;
    HEAP32[$212 >> 2] = $214;
    var $215 = $27;
    HEAP32[$215 >> 2] = 0;
    HEAP32[$215 + 4 >> 2] = 0;
    HEAP32[$215 + 8 >> 2] = 0;
    HEAP32[$215 + 12 >> 2] = 0;
    var $216 = HEAP32[$19 >> 2];
    var $217 = $rgData + 9732 + ($216 << 2) | 0;
    var $218 = $217;
    _memmove($30, $218, 40, 4, 0);
    var $219 = HEAP32[$19 >> 2];
    var $220 = $rgData + 29112 + ($219 << 2) | 0;
    var $221 = $220;
    _memmove($32, $221, 40, 4, 0);
    var $222 = HEAP32[$19 >> 2];
    var $223 = $rgData + 84 + ($222 << 2) | 0;
    var $224 = $223;
    _memmove($34, $224, 40, 4, 0);
    var $225 = HEAP32[$19 >> 2];
    var $226 = $rgData + 19464 + ($225 << 2) | 0;
    var $227 = $226;
    _memmove($36, $227, 40, 4, 0);
    HEAP32[$19 >> 2] = 0;
    label = 23;
    break;
   case 23:
    var $229 = HEAP32[$19 >> 2];
    var $230 = HEAP32[$18 >> 2];
    var $231 = ($229 | 0) > ($230 | 0);
    if ($231) {
      var $_0 = 0;
      label = 27;
      break;
    } else {
      var $cursamplepos_0 = $191;
      var $batchsamples_0 = $190;
      label = 9;
      break;
    }
   case 24:
    var $233 = $rgData;
    if ($5) {
      label = 25;
      break;
    } else {
      label = 26;
      break;
    }
   case 25:
    var $235 = $rgData + ($num_samples << 2) | 0;
    var $236 = $235;
    var $237 = 10 - $num_samples | 0;
    var $238 = $237 << 2;
    _memmove($233, $236, $238, 4, 0);
    var $239 = $rgData + 19380 | 0;
    var $240 = $239;
    var $241 = $rgData + 19380 + ($num_samples << 2) | 0;
    var $242 = $241;
    _memmove($240, $242, $238, 4, 0);
    var $243 = $rgData + ($237 << 2) | 0;
    var $244 = $243;
    var $245 = $num_samples << 2;
    _memcpy($244, $8, $245);
    var $246 = $rgData + 19380 + ($237 << 2) | 0;
    var $247 = $246;
    var $248 = $_0134;
    _memcpy($247, $248, $245);
    var $_0 = 1;
    label = 27;
    break;
   case 26:
    var $_sum = $num_samples - 10 | 0;
    var $250 = $left_samples + ($_sum << 2) | 0;
    var $251 = $250;
    for (var $$src = $251 >> 2, $$dest = $233 >> 2, $$stop = $$src + 10; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    var $252 = $rgData + 19380 | 0;
    var $253 = $252;
    var $254 = $_0134 + ($_sum << 2) | 0;
    var $255 = $254;
    for (var $$src = $255 >> 2, $$dest = $253 >> 2, $$stop = $$src + 10; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    var $_0 = 1;
    label = 27;
    break;
   case 27:
    var $_0;
    return $_0;
  }
}
_AnalyzeSamples["X"] = 1;
function _hasUcs2ByteOrderMarker($bom) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    if ($bom << 16 >> 16 == -2 | $bom << 16 >> 16 == -257) {
      var $_0 = 1;
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $_0 = 0;
    label = 4;
    break;
   case 4:
    var $_0;
    return $_0;
  }
}
function _fsqr($d) {
  return $d * $d;
}
function _filterYule($input, $output, $nSamples, $kernel) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($nSamples | 0) == 0;
    if ($1) {
      label = 5;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $2 = $kernel + 4 | 0;
    var $3 = $kernel + 8 | 0;
    var $4 = $kernel + 12 | 0;
    var $5 = $kernel + 16 | 0;
    var $6 = $kernel + 20 | 0;
    var $7 = $kernel + 24 | 0;
    var $8 = $kernel + 28 | 0;
    var $9 = $kernel + 32 | 0;
    var $10 = $kernel + 36 | 0;
    var $11 = $kernel + 40 | 0;
    var $12 = $kernel + 44 | 0;
    var $13 = $kernel + 48 | 0;
    var $14 = $kernel + 52 | 0;
    var $15 = $kernel + 56 | 0;
    var $16 = $kernel + 60 | 0;
    var $17 = $kernel + 64 | 0;
    var $18 = $kernel + 68 | 0;
    var $19 = $kernel + 72 | 0;
    var $20 = $kernel + 76 | 0;
    var $21 = $kernel + 80 | 0;
    var $_04748 = $output;
    var $_04649 = $nSamples;
    var $_050 = $input;
    label = 4;
    break;
   case 4:
    var $_050;
    var $_04649;
    var $_04748;
    var $23 = $_04649 - 1 | 0;
    var $24 = HEAPF32[$_050 >> 2];
    var $25 = HEAPF32[$kernel >> 2];
    var $26 = $24 * $25;
    var $27 = $26;
    var $28 = $27 + 1e-10;
    var $29 = $_04748 - 4 | 0;
    var $30 = HEAPF32[$29 >> 2];
    var $31 = HEAPF32[$2 >> 2];
    var $32 = $30 * $31;
    var $33 = $32;
    var $34 = $28 - $33;
    var $35 = $_050 - 4 | 0;
    var $36 = HEAPF32[$35 >> 2];
    var $37 = HEAPF32[$3 >> 2];
    var $38 = $36 * $37;
    var $39 = $38;
    var $40 = $34 + $39;
    var $41 = $_04748 - 8 | 0;
    var $42 = HEAPF32[$41 >> 2];
    var $43 = HEAPF32[$4 >> 2];
    var $44 = $42 * $43;
    var $45 = $44;
    var $46 = $40 - $45;
    var $47 = $_050 - 8 | 0;
    var $48 = HEAPF32[$47 >> 2];
    var $49 = HEAPF32[$5 >> 2];
    var $50 = $48 * $49;
    var $51 = $50;
    var $52 = $46 + $51;
    var $53 = $_04748 - 12 | 0;
    var $54 = HEAPF32[$53 >> 2];
    var $55 = HEAPF32[$6 >> 2];
    var $56 = $54 * $55;
    var $57 = $56;
    var $58 = $52 - $57;
    var $59 = $_050 - 12 | 0;
    var $60 = HEAPF32[$59 >> 2];
    var $61 = HEAPF32[$7 >> 2];
    var $62 = $60 * $61;
    var $63 = $62;
    var $64 = $58 + $63;
    var $65 = $_04748 - 16 | 0;
    var $66 = HEAPF32[$65 >> 2];
    var $67 = HEAPF32[$8 >> 2];
    var $68 = $66 * $67;
    var $69 = $68;
    var $70 = $64 - $69;
    var $71 = $_050 - 16 | 0;
    var $72 = HEAPF32[$71 >> 2];
    var $73 = HEAPF32[$9 >> 2];
    var $74 = $72 * $73;
    var $75 = $74;
    var $76 = $70 + $75;
    var $77 = $_04748 - 20 | 0;
    var $78 = HEAPF32[$77 >> 2];
    var $79 = HEAPF32[$10 >> 2];
    var $80 = $78 * $79;
    var $81 = $80;
    var $82 = $76 - $81;
    var $83 = $_050 - 20 | 0;
    var $84 = HEAPF32[$83 >> 2];
    var $85 = HEAPF32[$11 >> 2];
    var $86 = $84 * $85;
    var $87 = $86;
    var $88 = $82 + $87;
    var $89 = $_04748 - 24 | 0;
    var $90 = HEAPF32[$89 >> 2];
    var $91 = HEAPF32[$12 >> 2];
    var $92 = $90 * $91;
    var $93 = $92;
    var $94 = $88 - $93;
    var $95 = $_050 - 24 | 0;
    var $96 = HEAPF32[$95 >> 2];
    var $97 = HEAPF32[$13 >> 2];
    var $98 = $96 * $97;
    var $99 = $98;
    var $100 = $94 + $99;
    var $101 = $_04748 - 28 | 0;
    var $102 = HEAPF32[$101 >> 2];
    var $103 = HEAPF32[$14 >> 2];
    var $104 = $102 * $103;
    var $105 = $104;
    var $106 = $100 - $105;
    var $107 = $_050 - 28 | 0;
    var $108 = HEAPF32[$107 >> 2];
    var $109 = HEAPF32[$15 >> 2];
    var $110 = $108 * $109;
    var $111 = $110;
    var $112 = $106 + $111;
    var $113 = $_04748 - 32 | 0;
    var $114 = HEAPF32[$113 >> 2];
    var $115 = HEAPF32[$16 >> 2];
    var $116 = $114 * $115;
    var $117 = $116;
    var $118 = $112 - $117;
    var $119 = $_050 - 32 | 0;
    var $120 = HEAPF32[$119 >> 2];
    var $121 = HEAPF32[$17 >> 2];
    var $122 = $120 * $121;
    var $123 = $122;
    var $124 = $118 + $123;
    var $125 = $_04748 - 36 | 0;
    var $126 = HEAPF32[$125 >> 2];
    var $127 = HEAPF32[$18 >> 2];
    var $128 = $126 * $127;
    var $129 = $128;
    var $130 = $124 - $129;
    var $131 = $_050 - 36 | 0;
    var $132 = HEAPF32[$131 >> 2];
    var $133 = HEAPF32[$19 >> 2];
    var $134 = $132 * $133;
    var $135 = $134;
    var $136 = $130 + $135;
    var $137 = $_04748 - 40 | 0;
    var $138 = HEAPF32[$137 >> 2];
    var $139 = HEAPF32[$20 >> 2];
    var $140 = $138 * $139;
    var $141 = $140;
    var $142 = $136 - $141;
    var $143 = $_050 - 40 | 0;
    var $144 = HEAPF32[$143 >> 2];
    var $145 = HEAPF32[$21 >> 2];
    var $146 = $144 * $145;
    var $147 = $146;
    var $148 = $142 + $147;
    var $149 = $148;
    HEAPF32[$_04748 >> 2] = $149;
    var $150 = $_04748 + 4 | 0;
    var $151 = $_050 + 4 | 0;
    var $152 = ($23 | 0) == 0;
    if ($152) {
      label = 5;
      break;
    } else {
      var $_04748 = $150;
      var $_04649 = $23;
      var $_050 = $151;
      label = 4;
      break;
    }
   case 5:
    return;
  }
}
_filterYule["X"] = 1;
function _filterButter($input, $output, $nSamples, $kernel) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($nSamples | 0) == 0;
    if ($1) {
      label = 5;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $2 = $kernel + 4 | 0;
    var $3 = $kernel + 8 | 0;
    var $4 = $kernel + 12 | 0;
    var $5 = $kernel + 16 | 0;
    var $_01516 = $output;
    var $_01417 = $nSamples;
    var $_018 = $input;
    label = 4;
    break;
   case 4:
    var $_018;
    var $_01417;
    var $_01516;
    var $7 = $_01417 - 1 | 0;
    var $8 = HEAPF32[$_018 >> 2];
    var $9 = HEAPF32[$kernel >> 2];
    var $10 = $8 * $9;
    var $11 = $_01516 - 4 | 0;
    var $12 = HEAPF32[$11 >> 2];
    var $13 = HEAPF32[$2 >> 2];
    var $14 = $12 * $13;
    var $15 = $10 - $14;
    var $16 = $_018 - 4 | 0;
    var $17 = HEAPF32[$16 >> 2];
    var $18 = HEAPF32[$3 >> 2];
    var $19 = $17 * $18;
    var $20 = $15 + $19;
    var $21 = $_01516 - 8 | 0;
    var $22 = HEAPF32[$21 >> 2];
    var $23 = HEAPF32[$4 >> 2];
    var $24 = $22 * $23;
    var $25 = $20 - $24;
    var $26 = $_018 - 8 | 0;
    var $27 = HEAPF32[$26 >> 2];
    var $28 = HEAPF32[$5 >> 2];
    var $29 = $27 * $28;
    var $30 = $25 + $29;
    HEAPF32[$_01516 >> 2] = $30;
    var $31 = $_01516 + 4 | 0;
    var $32 = $_018 + 4 | 0;
    var $33 = ($7 | 0) == 0;
    if ($33) {
      label = 5;
      break;
    } else {
      var $_01516 = $31;
      var $_01417 = $7;
      var $_018 = $32;
      label = 4;
      break;
    }
   case 5:
    return;
  }
}
function _id3tag_add_v2($gfp) {
  var $3 = HEAP32[$gfp + 288 >> 2] + 85692 | 0;
  HEAP32[$3 >> 2] = HEAP32[$3 >> 2] & -7 | 2;
  return;
}
function _id3tag_v1_only($gfp) {
  var $3 = HEAP32[$gfp + 288 >> 2] + 85692 | 0;
  HEAP32[$3 >> 2] = HEAP32[$3 >> 2] & -15 | 4;
  return;
}
function _id3tag_v2_only($gfp) {
  var $3 = HEAP32[$gfp + 288 >> 2] + 85692 | 0;
  HEAP32[$3 >> 2] = HEAP32[$3 >> 2] & -13 | 8;
  return;
}
function _id3tag_space_v1($gfp) {
  var $3 = HEAP32[$gfp + 288 >> 2] + 85692 | 0;
  HEAP32[$3 >> 2] = HEAP32[$3 >> 2] & -25 | 16;
  return;
}
function _id3tag_set_pad($gfp, $n) {
  var $2 = HEAP32[$gfp + 288 >> 2];
  var $3 = $2 + 85692 | 0;
  HEAP32[$3 >> 2] = HEAP32[$3 >> 2] & -39 | 34;
  HEAP32[$2 + 85732 >> 2] = $n;
  return;
}
function _toID3v2TagId($s) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($s | 0) == 0;
    if ($1) {
      var $_0 = 0;
      label = 6;
      break;
    } else {
      var $i_0 = 0;
      var $x_0 = 0;
      label = 3;
      break;
    }
   case 3:
    var $x_0;
    var $i_0;
    var $2 = $i_0 >>> 0 < 4;
    if ($2) {
      label = 4;
      break;
    } else {
      var $_0 = $x_0;
      label = 6;
      break;
    }
   case 4:
    var $4 = $s + $i_0 | 0;
    var $5 = HEAP8[$4];
    var $6 = $5 << 24 >> 24 == 0;
    if ($6) {
      var $_0 = $x_0;
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $8 = $5 & 255;
    var $9 = $x_0 << 8;
    var $10 = $8 | $9;
    var $_off = $5 - 65 & 255;
    var $11 = ($_off & 255) > 25;
    var $_off14 = $5 - 48 & 255;
    var $12 = ($_off14 & 255) > 9;
    var $or_cond = $11 & $12;
    var $13 = $i_0 + 1 | 0;
    if ($or_cond) {
      var $_0 = 0;
      label = 6;
      break;
    } else {
      var $i_0 = $13;
      var $x_0 = $10;
      label = 3;
      break;
    }
   case 6:
    var $_0;
    return $_0;
  }
}
function _GetTitleGain($rgData) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $rgData + 38792 | 0;
    var $2 = _analyzeResult($1);
    var $i_026 = 0;
    label = 3;
    break;
   case 3:
    var $i_026;
    var $4 = $rgData + 38792 + ($i_026 << 2) | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = $rgData + 86792 + ($i_026 << 2) | 0;
    var $7 = HEAP32[$6 >> 2];
    var $8 = $7 + $5 | 0;
    HEAP32[$6 >> 2] = $8;
    HEAP32[$4 >> 2] = 0;
    var $9 = $i_026 + 1 | 0;
    var $exitcond = ($9 | 0) == 12e3;
    if ($exitcond) {
      label = 4;
      break;
    } else {
      var $i_026 = $9;
      label = 3;
      break;
    }
   case 4:
    var $10 = $rgData + 29112 | 0;
    var $11 = $rgData + 19464 | 0;
    var $12 = $rgData + 19380 | 0;
    var $13 = $rgData + 9732 | 0;
    var $14 = $rgData + 84 | 0;
    var $15 = $rgData + 38764 | 0;
    var $16 = $rgData;
    for (var $$dest = $16 >> 2, $$stop = $$dest + 10; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $17 = $14;
    for (var $$dest = $17 >> 2, $$stop = $$dest + 10; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $18 = $13;
    for (var $$dest = $18 >> 2, $$stop = $$dest + 10; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $19 = $12;
    for (var $$dest = $19 >> 2, $$stop = $$dest + 10; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $20 = $11;
    for (var $$dest = $20 >> 2, $$stop = $$dest + 10; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $21 = $10;
    for (var $$dest = $21 >> 2, $$stop = $$dest + 10; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $22 = $15;
    HEAP32[$22 >> 2] = 0;
    HEAP32[$22 + 4 >> 2] = 0;
    HEAP32[$22 + 8 >> 2] = 0;
    HEAP32[$22 + 12 >> 2] = 0;
    HEAP32[$22 + 16 >> 2] = 0;
    return $2;
  }
}
function _analyzeResult($Array) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $elems_01 = 0;
    var $i_02 = 0;
    label = 3;
    break;
   case 3:
    var $i_02;
    var $elems_01;
    var $2 = $Array + ($i_02 << 2) | 0;
    var $3 = HEAP32[$2 >> 2];
    var $4 = $3 + $elems_01 | 0;
    var $5 = $i_02 + 1 | 0;
    var $exitcond = ($5 | 0) == 12e3;
    if ($exitcond) {
      label = 4;
      break;
    } else {
      var $elems_01 = $4;
      var $i_02 = $5;
      label = 3;
      break;
    }
   case 4:
    var $7 = ($4 | 0) == 0;
    if ($7) {
      var $_0 = -24601;
      label = 9;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $9 = $4 >>> 0;
    var $10 = $9 * .050000000000000044;
    var $11 = Math.ceil($10);
    var $12 = $11 >= 0 ? Math.floor($11) : Math.ceil($11);
    var $i_1 = 12e3;
    var $sum_0 = 0;
    label = 6;
    break;
   case 6:
    var $sum_0;
    var $i_1;
    var $14 = $i_1 - 1 | 0;
    var $15 = ($i_1 | 0) == 0;
    if ($15) {
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    var $17 = $Array + ($14 << 2) | 0;
    var $18 = HEAP32[$17 >> 2];
    var $19 = $18 + $sum_0 | 0;
    var $20 = $19 >>> 0 < $12 >>> 0;
    if ($20) {
      var $i_1 = $14;
      var $sum_0 = $19;
      label = 6;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    var $22 = $14 >>> 0;
    var $23 = $22 / 100;
    var $24 = 64.81999969482422 - $23;
    var $_0 = $24;
    label = 9;
    break;
   case 9:
    var $_0;
    return $_0;
  }
}
function _id3tag_genre_list($handler, $cookie) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($handler | 0) == 0;
    if ($1) {
      label = 4;
      break;
    } else {
      var $i_07 = 0;
      label = 3;
      break;
    }
   case 3:
    var $i_07;
    var $2 = 5345800 + ($i_07 << 2) | 0;
    var $3 = HEAP32[$2 >> 2];
    var $4 = 5345208 + ($3 << 2) | 0;
    var $5 = HEAP32[$4 >> 2];
    FUNCTION_TABLE[$handler]($3, $5, $cookie);
    var $6 = $i_07 + 1 | 0;
    var $exitcond = ($6 | 0) == 148;
    if ($exitcond) {
      label = 4;
      break;
    } else {
      var $i_07 = $6;
      label = 3;
      break;
    }
   case 4:
    return;
  }
}
function _id3tag_init($gfp) {
  var $2 = HEAP32[$gfp + 288 >> 2];
  _free_id3tag($2);
  var $4 = $2 + 85692 | 0;
  for (var $$dest = $4 >> 2, $$stop = $$dest + 14; $$dest < $$stop; $$dest++) {
    HEAP32[$$dest] = 0;
  }
  HEAP32[$2 + 85720 >> 2] = 255;
  HEAP32[$2 + 85732 >> 2] = 128;
  _id3v2AddLameVersion($gfp);
  return;
}
function _id3v2AddLameVersion($gfp) {
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 1024 | 0;
  var $1 = __stackBase__ | 0;
  _sprintf($1, 5382860, (tempInt = STACKTOP, STACKTOP = STACKTOP + 12 | 0, HEAP32[tempInt >> 2] = 5383868, HEAP32[tempInt + 4 >> 2] = 5384648, HEAP32[tempInt + 8 >> 2] = 5384668, tempInt));
  _copyV1ToV2($gfp, 1414746949, $1);
  STACKTOP = __stackBase__;
  return;
}
function _id3tag_pad_v2($gfp) {
  _id3tag_set_pad($gfp, 128);
  return;
}
function _id3tag_set_albumart($gfp, $image, $size) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfp + 288 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $size >>> 0 > 2;
    if ($3) {
      label = 3;
      break;
    } else {
      var $_0 = -1;
      label = 15;
      break;
    }
   case 3:
    var $5 = HEAP8[$image];
    var $6 = $5 << 24 >> 24 == -1;
    if ($6) {
      label = 4;
      break;
    } else {
      label = 5;
      break;
    }
   case 4:
    var $8 = $image + 1 | 0;
    var $9 = HEAP8[$8];
    var $10 = $9 << 24 >> 24 == -40;
    if ($10) {
      var $mimetype_0 = 1;
      label = 10;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $12 = $size >>> 0 > 4;
    if ($12) {
      label = 6;
      break;
    } else {
      var $_0 = -1;
      label = 15;
      break;
    }
   case 6:
    var $14 = HEAP8[$image];
    var $15 = $14 << 24 >> 24 == -119;
    if ($15) {
      label = 7;
      break;
    } else {
      label = 9;
      break;
    }
   case 7:
    var $17 = $image + 1 | 0;
    var $18 = _strncmp($17, 5383312, 3);
    var $19 = ($18 | 0) == 0;
    if ($19) {
      var $mimetype_0 = 2;
      label = 10;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    if ($12) {
      label = 9;
      break;
    } else {
      var $_0 = -1;
      label = 15;
      break;
    }
   case 9:
    var $21 = _strncmp($image, 5386088, 4);
    var $22 = ($21 | 0) == 0;
    if ($22) {
      var $mimetype_0 = 3;
      label = 10;
      break;
    } else {
      var $_0 = -1;
      label = 15;
      break;
    }
   case 10:
    var $mimetype_0;
    var $24 = $2 + 85724 | 0;
    var $25 = HEAP32[$24 >> 2];
    var $26 = ($25 | 0) == 0;
    if ($26) {
      label = 12;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    _free($25);
    HEAP32[$24 >> 2] = 0;
    var $28 = $2 + 85728 | 0;
    HEAP32[$28 >> 2] = 0;
    var $29 = $2 + 85736 | 0;
    HEAP32[$29 >> 2] = 0;
    label = 12;
    break;
   case 12:
    var $31 = ($size | 0) == 0;
    if ($31) {
      var $_0 = 0;
      label = 15;
      break;
    } else {
      label = 13;
      break;
    }
   case 13:
    var $33 = _calloc($size, 1);
    HEAP32[$24 >> 2] = $33;
    var $34 = ($33 | 0) == 0;
    if ($34) {
      var $_0 = 0;
      label = 15;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    _memcpy($33, $image, $size);
    var $36 = $2 + 85728 | 0;
    HEAP32[$36 >> 2] = $size;
    var $37 = $2 + 85736 | 0;
    HEAP32[$37 >> 2] = $mimetype_0;
    var $38 = $2 + 85692 | 0;
    var $39 = HEAP32[$38 >> 2];
    var $40 = $39 | 1;
    HEAP32[$38 >> 2] = $40;
    _id3tag_add_v2($gfp);
    var $_0 = 0;
    label = 15;
    break;
   case 15:
    var $_0;
    return $_0;
  }
}
_id3tag_set_albumart["X"] = 1;
function _id3tag_set_textinfo_utf16($gfp, $id, $text) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = _toID3v2TagId($id);
    var $2 = ($1 | 0) == 0;
    if ($2) {
      var $_0 = -1;
      label = 14;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $4 = ($text | 0) == 0;
    if ($4) {
      var $_0 = 0;
      label = 14;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $6 = HEAP16[$text >> 1];
    var $7 = _hasUcs2ByteOrderMarker($6);
    var $8 = ($7 | 0) == 0;
    if ($8) {
      var $_0 = -3;
      label = 14;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    if (($1 | 0) == 1465407576 | ($1 | 0) == 1415075928 | ($1 | 0) == 1129270605) {
      label = 6;
      break;
    } else if (($1 | 0) == 1413697358) {
      label = 7;
      break;
    } else if (($1 | 0) == 1346589524) {
      label = 8;
      break;
    } else if (($1 | 0) == 1431520594) {
      label = 9;
      break;
    } else if (($1 | 0) == 1464223044) {
      label = 10;
      break;
    } else {
      label = 11;
      break;
    }
   case 6:
    var $11 = _id3tag_set_userinfo_ucs2($gfp, $1, $text);
    var $_0 = $11;
    label = 14;
    break;
   case 7:
    var $13 = _id3tag_set_genre_utf16($gfp, $text);
    var $_0 = $13;
    label = 14;
    break;
   case 8:
    var $15 = _id3v2_add_ucs2($gfp, $1, 0, 0, $text);
    var $_0 = $15;
    label = 14;
    break;
   case 9:
    var $17 = _id3v2_add_ucs2($gfp, $1, 5385684, $text, 0);
    var $_0 = $17;
    label = 14;
    break;
   case 10:
    var $19 = _id3v2_add_ucs2($gfp, $1, 0, $text, 0);
    var $_0 = $19;
    label = 14;
    break;
   case 11:
    var $21 = _isFrameIdMatching($1, 1409286144);
    var $22 = ($21 | 0) == 0;
    if ($22) {
      label = 12;
      break;
    } else {
      label = 13;
      break;
    }
   case 12:
    var $24 = _isFrameIdMatching($1, 1459617792);
    var $25 = ($24 | 0) == 0;
    if ($25) {
      var $_0 = -255;
      label = 14;
      break;
    } else {
      label = 13;
      break;
    }
   case 13:
    var $27 = _id3v2_add_ucs2($gfp, $1, 0, 0, $text);
    var $_0 = $27;
    label = 14;
    break;
   case 14:
    var $_0;
    return $_0;
  }
}
function _id3tag_set_userinfo_ucs2($gfp, $id, $fieldvalue) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 8 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $dsc = __stackBase__;
    var $val = __stackBase__ + 4;
    var $1 = _fromLatin1Char($fieldvalue);
    var $2 = _local_ucs2_pos($fieldvalue, $1);
    var $3 = ($2 | 0) > -1;
    if ($3) {
      label = 3;
      break;
    } else {
      var $rc_0 = -7;
      label = 4;
      break;
    }
   case 3:
    var $5 = _local_ucs2_strlen($fieldvalue);
    HEAP32[$dsc >> 2] = 0;
    HEAP32[$val >> 2] = 0;
    _local_ucs2_substr($dsc, $fieldvalue, 0, $2);
    var $6 = $2 + 1 | 0;
    _local_ucs2_substr($val, $fieldvalue, $6, $5);
    var $7 = HEAP32[$dsc >> 2];
    var $8 = HEAP32[$val >> 2];
    var $9 = _id3v2_add_ucs2($gfp, $id, 5385684, $7, $8);
    var $10 = HEAP32[$dsc >> 2];
    var $11 = $10;
    _free($11);
    var $12 = HEAP32[$val >> 2];
    var $13 = $12;
    _free($13);
    var $rc_0 = $9;
    label = 4;
    break;
   case 4:
    var $rc_0;
    STACKTOP = __stackBase__;
    return $rc_0;
  }
}
function _id3tag_set_genre_utf16($gfp, $text) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfp + 288 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($text | 0) == 0;
    if ($3) {
      var $_0 = -3;
      label = 10;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $5 = HEAP16[$text >> 1];
    var $6 = _hasUcs2ByteOrderMarker($5);
    var $7 = ($6 | 0) == 0;
    if ($7) {
      var $_0 = -3;
      label = 10;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $9 = _maybeLatin1($text);
    var $10 = ($9 | 0) == 0;
    if ($10) {
      label = 8;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $12 = _local_strdup_utf16_to_latin1($text);
    var $13 = _lookupGenre($12);
    _free($12);
    var $14 = ($13 | 0) == -1;
    if ($14) {
      var $_0 = -1;
      label = 10;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    var $16 = ($13 | 0) > -1;
    if ($16) {
      label = 7;
      break;
    } else {
      label = 8;
      break;
    }
   case 7:
    var $18 = $2 + 85692 | 0;
    var $19 = HEAP32[$18 >> 2];
    var $20 = $19 | 1;
    HEAP32[$18 >> 2] = $20;
    var $21 = $2 + 85720 | 0;
    HEAP32[$21 >> 2] = $13;
    var $22 = 5345208 + ($13 << 2) | 0;
    var $23 = HEAP32[$22 >> 2];
    _copyV1ToV2($gfp, 1413697358, $23);
    var $_0 = 0;
    label = 10;
    break;
   case 8:
    var $25 = _id3v2_add_ucs2($gfp, 1413697358, 0, 0, $text);
    var $26 = ($25 | 0) == 0;
    if ($26) {
      label = 9;
      break;
    } else {
      var $_0 = $25;
      label = 10;
      break;
    }
   case 9:
    var $28 = $2 + 85692 | 0;
    var $29 = HEAP32[$28 >> 2];
    var $30 = $29 | 1;
    HEAP32[$28 >> 2] = $30;
    var $31 = $2 + 85720 | 0;
    HEAP32[$31 >> 2] = 12;
    var $_0 = 0;
    label = 10;
    break;
   case 10:
    var $_0;
    return $_0;
  }
}
function _id3v2_add_ucs2($gfp, $frame_id, $lang, $desc, $text) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($gfp | 0) == 0;
    if ($1) {
      var $_0 = -255;
      label = 13;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $gfp + 288 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) == 0;
    if ($5) {
      var $_0 = -255;
      label = 13;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $7 = $4 + 85692 | 0;
    var $8 = _findNode($7, $frame_id, 0);
    var $9 = _isMultiFrame($frame_id);
    var $10 = ($9 | 0) == 0;
    if ($10) {
      var $node_1 = $8;
      label = 9;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $11 = ($8 | 0) == 0;
    if ($11) {
      label = 10;
      break;
    } else {
      var $node_032 = $8;
      label = 6;
      break;
    }
   case 6:
    var $node_032;
    var $12 = $node_032 + 8 | 0;
    var $13 = _isSameLang($12, $lang);
    var $14 = ($13 | 0) == 0;
    if ($14) {
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    var $16 = _isSameDescriptorUcs2($node_032, $desc);
    var $17 = ($16 | 0) == 0;
    if ($17) {
      label = 8;
      break;
    } else {
      var $node_1 = $node_032;
      label = 9;
      break;
    }
   case 8:
    var $19 = _findNode($7, $frame_id, $node_032);
    var $20 = ($19 | 0) == 0;
    if ($20) {
      label = 10;
      break;
    } else {
      var $node_032 = $19;
      label = 6;
      break;
    }
   case 9:
    var $node_1;
    var $21 = ($node_1 | 0) == 0;
    if ($21) {
      label = 10;
      break;
    } else {
      var $node_2 = $node_1;
      label = 12;
      break;
    }
   case 10:
    var $22 = _calloc(1, 36);
    var $23 = $22;
    var $24 = ($22 | 0) == 0;
    if ($24) {
      var $_0 = -254;
      label = 13;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    _appendNode($7, $23);
    var $node_2 = $23;
    label = 12;
    break;
   case 12:
    var $node_2;
    var $27 = $node_2 + 4 | 0;
    HEAP32[$27 >> 2] = $frame_id;
    var $28 = $node_2 + 8 | 0;
    _setLang($28, $lang);
    var $29 = $node_2 + 12 | 0;
    var $30 = $29;
    var $31 = _local_ucs2_strdup($30, $desc);
    var $32 = $node_2 + 16 | 0;
    HEAP32[$32 >> 2] = $31;
    var $33 = $node_2 + 20 | 0;
    HEAP32[$33 >> 2] = 1;
    var $34 = $node_2 + 24 | 0;
    var $35 = $34;
    var $36 = _local_ucs2_strdup($35, $text);
    var $37 = $node_2 + 28 | 0;
    HEAP32[$37 >> 2] = $36;
    var $38 = $node_2 + 32 | 0;
    HEAP32[$38 >> 2] = 1;
    var $39 = $7 | 0;
    var $40 = HEAP32[$39 >> 2];
    var $41 = $40 | 3;
    HEAP32[$39 >> 2] = $41;
    var $_0 = 0;
    label = 13;
    break;
   case 13:
    var $_0;
    return $_0;
  }
}
_id3v2_add_ucs2["X"] = 1;
function _isFrameIdMatching($id, $mask) {
  return (_frame_id_matches($id, $mask) | 0) == 0 & 1;
}
function _id3tag_set_textinfo_ucs2($gfp, $id, $text) {
  return _id3tag_set_textinfo_utf16($gfp, $id, $text);
}
function _id3tag_set_textinfo_latin1($gfp, $id, $text) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = _toID3v2TagId($id);
    var $2 = ($1 | 0) == 0;
    if ($2) {
      var $_0 = -1;
      label = 13;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $4 = ($text | 0) == 0;
    if ($4) {
      var $_0 = 0;
      label = 13;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    if (($1 | 0) == 1465407576 | ($1 | 0) == 1415075928 | ($1 | 0) == 1129270605) {
      label = 5;
      break;
    } else if (($1 | 0) == 1413697358) {
      label = 6;
      break;
    } else if (($1 | 0) == 1346589524) {
      label = 7;
      break;
    } else if (($1 | 0) == 1431520594) {
      label = 8;
      break;
    } else if (($1 | 0) == 1464223044) {
      label = 9;
      break;
    } else {
      label = 10;
      break;
    }
   case 5:
    var $7 = _id3tag_set_userinfo_latin1($gfp, $1, $text);
    var $_0 = $7;
    label = 13;
    break;
   case 6:
    var $9 = _id3tag_set_genre($gfp, $text);
    var $_0 = $9;
    label = 13;
    break;
   case 7:
    var $11 = _id3v2_add_latin1($gfp, $1, 0, 0, $text);
    var $_0 = $11;
    label = 13;
    break;
   case 8:
    var $13 = _id3v2_add_latin1($gfp, $1, 5385684, $text, 0);
    var $_0 = $13;
    label = 13;
    break;
   case 9:
    var $15 = _id3v2_add_latin1($gfp, $1, 0, $text, 0);
    var $_0 = $15;
    label = 13;
    break;
   case 10:
    var $17 = _isFrameIdMatching($1, 1409286144);
    var $18 = ($17 | 0) == 0;
    if ($18) {
      label = 11;
      break;
    } else {
      label = 12;
      break;
    }
   case 11:
    var $20 = _isFrameIdMatching($1, 1459617792);
    var $21 = ($20 | 0) == 0;
    if ($21) {
      var $_0 = -255;
      label = 13;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    var $23 = _id3v2_add_latin1($gfp, $1, 0, 0, $text);
    var $_0 = $23;
    label = 13;
    break;
   case 13:
    var $_0;
    return $_0;
  }
}
function _id3tag_set_userinfo_latin1($gfp, $id, $fieldvalue) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 4 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $dup = __stackBase__;
    var $1 = _local_char_pos($fieldvalue);
    var $2 = ($1 | 0) > -1;
    if ($2) {
      label = 3;
      break;
    } else {
      var $rc_0 = -7;
      label = 4;
      break;
    }
   case 3:
    HEAP32[$dup >> 2] = 0;
    var $4 = _local_strdup($dup, $fieldvalue);
    var $5 = HEAP32[$dup >> 2];
    var $6 = $5 + $1 | 0;
    HEAP8[$6] = 0;
    var $7 = HEAP32[$dup >> 2];
    var $_sum = $1 + 1 | 0;
    var $8 = $7 + $_sum | 0;
    var $9 = _id3v2_add_latin1($gfp, $id, 5385684, $7, $8);
    var $10 = HEAP32[$dup >> 2];
    _free($10);
    var $rc_0 = $9;
    label = 4;
    break;
   case 4:
    var $rc_0;
    STACKTOP = __stackBase__;
    return $rc_0;
  }
}
function _id3tag_set_genre($gfp, $genre) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfp + 288 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($genre | 0) == 0;
    if ($3) {
      var $_0 = 0;
      label = 9;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $5 = HEAP8[$genre];
    var $6 = $5 << 24 >> 24 == 0;
    if ($6) {
      var $_0 = 0;
      label = 9;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $8 = _lookupGenre($genre);
    var $9 = ($8 | 0) == -1;
    if ($9) {
      var $_0 = -1;
      label = 9;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $11 = $2 + 85692 | 0;
    var $12 = HEAP32[$11 >> 2];
    var $13 = $12 | 1;
    HEAP32[$11 >> 2] = $13;
    var $14 = ($8 | 0) > -1;
    var $15 = $2 + 85720 | 0;
    if ($14) {
      label = 6;
      break;
    } else {
      label = 7;
      break;
    }
   case 6:
    HEAP32[$15 >> 2] = $8;
    var $17 = 5345208 + ($8 << 2) | 0;
    var $18 = HEAP32[$17 >> 2];
    var $_014 = $18;
    label = 8;
    break;
   case 7:
    HEAP32[$15 >> 2] = 12;
    var $20 = HEAP32[$11 >> 2];
    var $21 = $20 | 2;
    HEAP32[$11 >> 2] = $21;
    var $_014 = $genre;
    label = 8;
    break;
   case 8:
    var $_014;
    _copyV1ToV2($gfp, 1413697358, $_014);
    var $_0 = 0;
    label = 9;
    break;
   case 9:
    var $_0;
    return $_0;
  }
}
function _id3v2_add_latin1($gfp, $frame_id, $lang, $desc, $text) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($gfp | 0) == 0;
    if ($1) {
      var $_0 = -255;
      label = 13;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $gfp + 288 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) == 0;
    if ($5) {
      var $_0 = -255;
      label = 13;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $7 = $4 + 85692 | 0;
    var $8 = _findNode($7, $frame_id, 0);
    var $9 = _isMultiFrame($frame_id);
    var $10 = ($9 | 0) == 0;
    if ($10) {
      var $node_1 = $8;
      label = 9;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $11 = ($8 | 0) == 0;
    if ($11) {
      label = 10;
      break;
    } else {
      var $node_032 = $8;
      label = 6;
      break;
    }
   case 6:
    var $node_032;
    var $12 = $node_032 + 8 | 0;
    var $13 = _isSameLang($12, $lang);
    var $14 = ($13 | 0) == 0;
    if ($14) {
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    var $16 = _isSameDescriptor($node_032, $desc);
    var $17 = ($16 | 0) == 0;
    if ($17) {
      label = 8;
      break;
    } else {
      var $node_1 = $node_032;
      label = 9;
      break;
    }
   case 8:
    var $19 = _findNode($7, $frame_id, $node_032);
    var $20 = ($19 | 0) == 0;
    if ($20) {
      label = 10;
      break;
    } else {
      var $node_032 = $19;
      label = 6;
      break;
    }
   case 9:
    var $node_1;
    var $21 = ($node_1 | 0) == 0;
    if ($21) {
      label = 10;
      break;
    } else {
      var $node_2 = $node_1;
      label = 12;
      break;
    }
   case 10:
    var $22 = _calloc(1, 36);
    var $23 = $22;
    var $24 = ($22 | 0) == 0;
    if ($24) {
      var $_0 = -254;
      label = 13;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    _appendNode($7, $23);
    var $node_2 = $23;
    label = 12;
    break;
   case 12:
    var $node_2;
    var $27 = $node_2 + 4 | 0;
    HEAP32[$27 >> 2] = $frame_id;
    var $28 = $node_2 + 8 | 0;
    _setLang($28, $lang);
    var $29 = $node_2 + 12 | 0;
    var $30 = _local_strdup($29, $desc);
    var $31 = $node_2 + 16 | 0;
    HEAP32[$31 >> 2] = $30;
    var $32 = $node_2 + 20 | 0;
    HEAP32[$32 >> 2] = 0;
    var $33 = $node_2 + 24 | 0;
    var $34 = _local_strdup($33, $text);
    var $35 = $node_2 + 28 | 0;
    HEAP32[$35 >> 2] = $34;
    var $36 = $node_2 + 32 | 0;
    HEAP32[$36 >> 2] = 0;
    var $37 = $7 | 0;
    var $38 = HEAP32[$37 >> 2];
    var $39 = $38 | 3;
    HEAP32[$37 >> 2] = $39;
    var $_0 = 0;
    label = 13;
    break;
   case 13:
    var $_0;
    return $_0;
  }
}
_id3v2_add_latin1["X"] = 1;
function _id3tag_set_comment_latin1($gfp, $lang, $desc, $text) {
  return _id3v2_add_latin1($gfp, 1129270605, $lang, $desc, $text);
}
function _id3tag_set_comment_utf16($gfp, $lang, $desc, $text) {
  return _id3v2_add_ucs2($gfp, 1129270605, $lang, $desc, $text);
}
function _id3tag_set_comment_ucs2($gfp, $lang, $desc, $text) {
  return _id3tag_set_comment_utf16($gfp, $lang, $desc, $text);
}
function _local_ucs2_strlen($s) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($s | 0) == 0;
    if ($1) {
      var $n_1 = 0;
      label = 5;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $2 = HEAP16[$s >> 1];
    var $3 = $2 << 16 >> 16 == 0;
    if ($3) {
      var $n_1 = 0;
      label = 5;
      break;
    } else {
      var $_03 = $s;
      var $n_04 = 0;
      label = 4;
      break;
    }
   case 4:
    var $n_04;
    var $_03;
    var $4 = $_03 + 2 | 0;
    var $5 = $n_04 + 1 | 0;
    var $6 = HEAP16[$4 >> 1];
    var $7 = $6 << 16 >> 16 == 0;
    if ($7) {
      var $n_1 = $5;
      label = 5;
      break;
    } else {
      var $_03 = $4;
      var $n_04 = $5;
      label = 4;
      break;
    }
   case 5:
    var $n_1;
    return $n_1;
  }
}
function _test_tag_spec_flags($gfc, $tst) {
  return (HEAP32[$gfc + 85692 >> 2] & $tst | 0) != 0 & 1;
}
function _sizeOfCommentNode($node) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($node | 0) == 0;
    if ($1) {
      var $n_1 = 0;
      label = 9;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $node + 20 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $cond = ($4 | 0) == 1;
    var $5 = $node + 16 | 0;
    var $6 = HEAP32[$5 >> 2];
    if ($cond) {
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $8 = $6 + 15 | 0;
    var $n_0 = $8;
    label = 6;
    break;
   case 5:
    var $10 = $6 << 1;
    var $11 = $10 + 16 | 0;
    var $n_0 = $11;
    label = 6;
    break;
   case 6:
    var $n_0;
    var $13 = $node + 32 | 0;
    var $14 = HEAP32[$13 >> 2];
    var $cond1 = ($14 | 0) == 1;
    var $15 = $node + 28 | 0;
    var $16 = HEAP32[$15 >> 2];
    if ($cond1) {
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    var $18 = $16 + $n_0 | 0;
    var $n_1 = $18;
    label = 9;
    break;
   case 8:
    var $20 = $16 << 1;
    var $21 = $20 + $n_0 | 0;
    var $n_1 = $21;
    label = 9;
    break;
   case 9:
    var $n_1;
    return $n_1;
  }
}
function _id3tag_set_title($gfp, $title) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($gfp | 0) == 0;
    if ($1) {
      label = 6;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $gfp + 288 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) == 0;
    var $6 = ($title | 0) == 0;
    var $or_cond = $5 | $6;
    if ($or_cond) {
      label = 6;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $8 = HEAP8[$title];
    var $9 = $8 << 24 >> 24 == 0;
    if ($9) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $11 = $4 + 85700 | 0;
    var $12 = _local_strdup($11, $title);
    var $13 = $4 + 85692 | 0;
    var $14 = HEAP32[$13 >> 2];
    var $15 = $14 | 1;
    HEAP32[$13 >> 2] = $15;
    _copyV1ToV2($gfp, 1414091826, $title);
    label = 6;
    break;
   case 6:
    return;
  }
}
function _local_strdup($dst, $src) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($dst | 0) == 0;
    if ($1) {
      var $_0 = 0;
      label = 8;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = HEAP32[$dst >> 2];
    _free($3);
    HEAP32[$dst >> 2] = 0;
    var $4 = ($src | 0) == 0;
    if ($4) {
      var $_0 = 0;
      label = 8;
      break;
    } else {
      var $n_0 = 0;
      label = 4;
      break;
    }
   case 4:
    var $n_0;
    var $5 = $src + $n_0 | 0;
    var $6 = HEAP8[$5];
    var $7 = $6 << 24 >> 24 == 0;
    var $8 = $n_0 + 1 | 0;
    if ($7) {
      label = 5;
      break;
    } else {
      var $n_0 = $8;
      label = 4;
      break;
    }
   case 5:
    var $10 = ($n_0 | 0) == 0;
    if ($10) {
      var $_0 = 0;
      label = 8;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    var $12 = $n_0 + 1 | 0;
    var $13 = _calloc($12, 1);
    HEAP32[$dst >> 2] = $13;
    var $14 = ($13 | 0) == 0;
    if ($14) {
      var $_0 = 0;
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    _memcpy($13, $src, $n_0);
    var $16 = HEAP32[$dst >> 2];
    var $17 = $16 + $n_0 | 0;
    HEAP8[$17] = 0;
    var $_0 = $n_0;
    label = 8;
    break;
   case 8:
    var $_0;
    return $_0;
  }
}
function _copyV1ToV2($gfp, $frame_id, $s) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($gfp | 0) == 0;
    if ($1) {
      label = 5;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $gfp + 288 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) == 0;
    if ($5) {
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $7 = $4 + 85692 | 0;
    var $8 = HEAP32[$7 >> 2];
    var $9 = _id3v2_add_latin1($gfp, $frame_id, 5385684, 0, $s);
    HEAP32[$7 >> 2] = $8;
    label = 5;
    break;
   case 5:
    return;
  }
}
function _id3tag_set_artist($gfp, $artist) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($gfp | 0) == 0;
    if ($1) {
      label = 6;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $gfp + 288 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) == 0;
    var $6 = ($artist | 0) == 0;
    var $or_cond = $5 | $6;
    if ($or_cond) {
      label = 6;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $8 = HEAP8[$artist];
    var $9 = $8 << 24 >> 24 == 0;
    if ($9) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $11 = $4 + 85704 | 0;
    var $12 = _local_strdup($11, $artist);
    var $13 = $4 + 85692 | 0;
    var $14 = HEAP32[$13 >> 2];
    var $15 = $14 | 1;
    HEAP32[$13 >> 2] = $15;
    _copyV1ToV2($gfp, 1414546737, $artist);
    label = 6;
    break;
   case 6:
    return;
  }
}
function _id3tag_set_album($gfp, $album) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($gfp | 0) == 0;
    if ($1) {
      label = 6;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $gfp + 288 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) == 0;
    var $6 = ($album | 0) == 0;
    var $or_cond = $5 | $6;
    if ($or_cond) {
      label = 6;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $8 = HEAP8[$album];
    var $9 = $8 << 24 >> 24 == 0;
    if ($9) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $11 = $4 + 85708 | 0;
    var $12 = _local_strdup($11, $album);
    var $13 = $4 + 85692 | 0;
    var $14 = HEAP32[$13 >> 2];
    var $15 = $14 | 1;
    HEAP32[$13 >> 2] = $15;
    _copyV1ToV2($gfp, 1413565506, $album);
    label = 6;
    break;
   case 6:
    return;
  }
}
function _id3tag_set_year($gfp, $year) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($gfp | 0) == 0;
    if ($1) {
      label = 8;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $gfp + 288 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) == 0;
    var $6 = ($year | 0) == 0;
    var $or_cond = $5 | $6;
    if ($or_cond) {
      label = 8;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $8 = HEAP8[$year];
    var $9 = $8 << 24 >> 24 == 0;
    if ($9) {
      label = 8;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $11 = _atoi($year);
    var $12 = ($11 | 0) < 0;
    var $_ = $12 ? 0 : $11;
    var $13 = ($_ | 0) > 9999;
    var $num_1 = $13 ? 9999 : $_;
    var $14 = ($num_1 | 0) == 0;
    if ($14) {
      label = 7;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    var $16 = $4 + 85696 | 0;
    HEAP32[$16 >> 2] = $num_1;
    var $17 = $4 + 85692 | 0;
    var $18 = HEAP32[$17 >> 2];
    var $19 = $18 | 1;
    HEAP32[$17 >> 2] = $19;
    label = 7;
    break;
   case 7:
    _copyV1ToV2($gfp, 1415136594, $year);
    label = 8;
    break;
   case 8:
    return;
  }
}
function _id3tag_set_comment($gfp, $comment) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($gfp | 0) == 0;
    if ($1) {
      label = 6;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $gfp + 288 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) == 0;
    var $6 = ($comment | 0) == 0;
    var $or_cond = $5 | $6;
    if ($or_cond) {
      label = 6;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $8 = HEAP8[$comment];
    var $9 = $8 << 24 >> 24 == 0;
    if ($9) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $11 = $4 + 85712 | 0;
    var $12 = _local_strdup($11, $comment);
    var $13 = $4 + 85692 | 0;
    var $14 = HEAP32[$13 >> 2];
    var $15 = $14 | 1;
    HEAP32[$13 >> 2] = $15;
    var $16 = _id3v2_add_latin1($gfp, 1129270605, 5385684, 5385260, $comment);
    HEAP32[$13 >> 2] = $15;
    label = 6;
    break;
   case 6:
    return;
  }
}
function _id3tag_set_track($gfp, $track) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($gfp | 0) == 0;
    if ($1) {
      var $ret_1 = 0;
      label = 13;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $gfp + 288 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) == 0;
    var $6 = ($track | 0) == 0;
    var $or_cond = $5 | $6;
    if ($or_cond) {
      var $ret_1 = 0;
      label = 13;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $8 = HEAP8[$track];
    var $9 = $8 << 24 >> 24 == 0;
    if ($9) {
      var $ret_1 = 0;
      label = 13;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $11 = _atoi($track);
    var $_off = $11 - 1 | 0;
    var $12 = $_off >>> 0 > 254;
    if ($12) {
      label = 6;
      break;
    } else {
      label = 7;
      break;
    }
   case 6:
    var $13 = $4 + 85692 | 0;
    var $14 = HEAP32[$13 >> 2];
    var $15 = $14 | 3;
    HEAP32[$13 >> 2] = $15;
    var $ret_019 = -1;
    label = 9;
    break;
   case 7:
    var $17 = ($11 | 0) == 0;
    if ($17) {
      var $ret_019 = 0;
      label = 9;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    var $19 = $4 + 85716 | 0;
    HEAP32[$19 >> 2] = $11;
    var $20 = $4 + 85692 | 0;
    var $21 = HEAP32[$20 >> 2];
    var $22 = $21 | 1;
    HEAP32[$20 >> 2] = $22;
    var $ret_019 = 0;
    label = 9;
    break;
   case 9:
    var $ret_019;
    var $24 = _strchr($track, 47);
    var $25 = ($24 | 0) == 0;
    if ($25) {
      label = 12;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    var $27 = HEAP8[$24];
    var $28 = $27 << 24 >> 24 == 0;
    if ($28) {
      label = 12;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    var $30 = $4 + 85692 | 0;
    var $31 = HEAP32[$30 >> 2];
    var $32 = $31 | 3;
    HEAP32[$30 >> 2] = $32;
    label = 12;
    break;
   case 12:
    _copyV1ToV2($gfp, 1414677323, $track);
    var $ret_1 = $ret_019;
    label = 13;
    break;
   case 13:
    var $ret_1;
    return $ret_1;
  }
}
function _lookupGenre($genre) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 4 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $str = __stackBase__;
    var $1 = _strtol($genre, $str, 10);
    var $2 = HEAP32[$str >> 2];
    var $3 = HEAP8[$2];
    var $4 = $3 << 24 >> 24 == 0;
    if ($4) {
      label = 5;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $6 = _searchGenre($genre);
    var $7 = ($6 | 0) == 148;
    if ($7) {
      label = 4;
      break;
    } else {
      var $num_1 = $6;
      label = 6;
      break;
    }
   case 4:
    var $9 = _sloppySearchGenre($genre);
    var $10 = ($9 | 0) == 148;
    if ($10) {
      var $_0 = -2;
      label = 7;
      break;
    } else {
      var $num_1 = $9;
      label = 6;
      break;
    }
   case 5:
    var $12 = $1 >>> 0 > 147;
    if ($12) {
      var $_0 = -1;
      label = 7;
      break;
    } else {
      var $num_1 = $1;
      label = 6;
      break;
    }
   case 6:
    var $num_1;
    var $_0 = $num_1;
    label = 7;
    break;
   case 7:
    var $_0;
    STACKTOP = __stackBase__;
    return $_0;
  }
}
function _id3tag_set_fieldvalue($gfp, $fieldvalue) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($fieldvalue | 0) == 0;
    if ($1) {
      var $_0 = 0;
      label = 7;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = HEAP8[$fieldvalue];
    var $4 = $3 << 24 >> 24 == 0;
    if ($4) {
      var $_0 = 0;
      label = 7;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $6 = _strlen($fieldvalue);
    var $7 = $6 >>> 0 < 5;
    if ($7) {
      var $_0 = -1;
      label = 7;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $9 = $fieldvalue + 4 | 0;
    var $10 = HEAP8[$9];
    var $11 = $10 << 24 >> 24 == 61;
    if ($11) {
      label = 6;
      break;
    } else {
      var $_0 = -1;
      label = 7;
      break;
    }
   case 6:
    var $13 = $fieldvalue + 5 | 0;
    var $14 = _id3tag_set_textinfo_latin1($gfp, $fieldvalue, $13);
    var $_0 = $14;
    label = 7;
    break;
   case 7:
    var $_0;
    return $_0;
  }
}
function _id3tag_set_fieldvalue_utf16($gfp, $fieldvalue) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 12 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $fid = __stackBase__;
    var $txt = __stackBase__ + 8;
    var $1 = ($fieldvalue | 0) == 0;
    if ($1) {
      var $_0 = -1;
      label = 8;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = HEAP16[$fieldvalue >> 1];
    var $4 = $3 << 16 >> 16 == 0;
    if ($4) {
      var $_0 = -1;
      label = 8;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $6 = _hasUcs2ByteOrderMarker($3);
    var $7 = _fromLatin1Char($fieldvalue);
    var $8 = $fid | 0;
    HEAP8[$8] = 0;
    HEAP8[$8 + 1] = 0;
    HEAP8[$8 + 2] = 0;
    HEAP8[$8 + 3] = 0;
    HEAP8[$8 + 4] = 0;
    var $9 = _toID3v2TagId_ucs2($fieldvalue);
    var $10 = _local_ucs2_strlen($fieldvalue);
    var $11 = $6 + 5 | 0;
    var $12 = $10 >>> 0 < $11 >>> 0;
    if ($12) {
      var $_0 = -1;
      label = 8;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $14 = $6 + 4 | 0;
    var $15 = $fieldvalue + ($14 << 1) | 0;
    var $16 = HEAP16[$15 >> 1];
    var $17 = $16 << 16 >> 16 == $7 << 16 >> 16;
    if ($17) {
      label = 6;
      break;
    } else {
      var $_0 = -1;
      label = 8;
      break;
    }
   case 6:
    var $19 = $9 >>> 24;
    var $20 = $19 & 255;
    HEAP8[$8] = $20;
    var $21 = $9 >>> 16;
    var $22 = $21 & 255;
    var $23 = $fid + 1 | 0;
    HEAP8[$23] = $22;
    var $24 = $9 >>> 8;
    var $25 = $24 & 255;
    var $26 = $fid + 2 | 0;
    HEAP8[$26] = $25;
    var $27 = $9 & 255;
    var $28 = $fid + 3 | 0;
    HEAP8[$28] = $27;
    var $29 = ($9 | 0) == 0;
    if ($29) {
      var $_0 = -1;
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    HEAP32[$txt >> 2] = 0;
    var $31 = _local_ucs2_strlen($fieldvalue);
    _local_ucs2_substr($txt, $fieldvalue, $11, $31);
    var $32 = HEAP32[$txt >> 2];
    var $33 = _id3tag_set_textinfo_utf16($gfp, $8, $32);
    var $34 = HEAP32[$txt >> 2];
    var $35 = $34;
    _free($35);
    var $_0 = $33;
    label = 8;
    break;
   case 8:
    var $_0;
    STACKTOP = __stackBase__;
    return $_0;
  }
}
function _fromLatin1Char($s) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = HEAP16[$s >> 1];
    var $2 = $1 << 16 >> 16 == -2;
    if ($2) {
      label = 3;
      break;
    } else {
      var $_0 = 61;
      label = 4;
      break;
    }
   case 3:
    var $4 = _swap_bytes(61);
    var $_0 = $4;
    label = 4;
    break;
   case 4:
    var $_0;
    return $_0;
  }
}
function _toID3v2TagId_ucs2($s) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($s | 0) == 0;
    if ($1) {
      var $_0 = 0;
      label = 6;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = HEAP16[$s >> 1];
    var $4 = _hasUcs2ByteOrderMarker($3);
    var $5 = ($4 | 0) == 0;
    var $6 = $s + 2 | 0;
    var $s_ = $5 ? $s : $6;
    var $7 = HEAP16[$s_ >> 1];
    var $8 = $7 << 16 >> 16 == 0;
    if ($8) {
      var $_0 = 0;
      label = 6;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $10 = _toLittleEndian($3, $7);
    var $_off = $10 - 65 & 65535;
    var $11 = ($_off & 65535) > 25;
    var $_off18 = $10 - 48 & 65535;
    var $12 = ($_off18 & 65535) > 9;
    var $or_cond = $11 & $12;
    if ($or_cond) {
      var $_0 = 0;
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $14 = $10 & 65535;
    var $15 = $s_ + 2 | 0;
    var $16 = HEAP16[$15 >> 1];
    var $17 = $16 << 16 >> 16 == 0;
    if ($17) {
      var $_0 = $14;
      label = 6;
      break;
    } else {
      label = 7;
      break;
    }
   case 6:
    var $_0;
    return $_0;
   case 7:
    var $19 = _toLittleEndian($3, $16);
    var $_off_1 = $19 - 65 & 65535;
    var $20 = ($_off_1 & 65535) > 25;
    var $_off18_1 = $19 - 48 & 65535;
    var $21 = ($_off18_1 & 65535) > 9;
    var $or_cond_1 = $20 & $21;
    if ($or_cond_1) {
      var $_0 = 0;
      label = 6;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    var $23 = $19 & 65535;
    var $24 = $14 << 8;
    var $25 = $23 | $24;
    var $26 = $s_ + 4 | 0;
    var $27 = HEAP16[$26 >> 1];
    var $28 = $27 << 16 >> 16 == 0;
    if ($28) {
      var $_0 = $25;
      label = 6;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    var $30 = _toLittleEndian($3, $27);
    var $_off_2 = $30 - 65 & 65535;
    var $31 = ($_off_2 & 65535) > 25;
    var $_off18_2 = $30 - 48 & 65535;
    var $32 = ($_off18_2 & 65535) > 9;
    var $or_cond_2 = $31 & $32;
    if ($or_cond_2) {
      var $_0 = 0;
      label = 6;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    var $34 = $30 & 65535;
    var $35 = $25 << 8;
    var $36 = $34 | $35;
    var $37 = $s_ + 6 | 0;
    var $38 = HEAP16[$37 >> 1];
    var $39 = $38 << 16 >> 16 == 0;
    if ($39) {
      var $_0 = $36;
      label = 6;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    var $41 = _toLittleEndian($3, $38);
    var $_off_3 = $41 - 65 & 65535;
    var $42 = ($_off_3 & 65535) > 25;
    var $_off18_3 = $41 - 48 & 65535;
    var $43 = ($_off18_3 & 65535) > 9;
    var $or_cond_3 = $42 & $43;
    if ($or_cond_3) {
      var $_0 = 0;
      label = 6;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    var $45 = $41 & 65535;
    var $46 = $36 << 8;
    var $47 = $45 | $46;
    var $_0 = $47;
    label = 6;
    break;
  }
}
_toID3v2TagId_ucs2["X"] = 1;
function _local_ucs2_substr($dst, $src, $start, $end) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $start >>> 0 < $end >>> 0;
    if ($1) {
      label = 3;
      break;
    } else {
      var $5 = 2;
      label = 4;
      break;
    }
   case 3:
    var $3 = 2 - $start | 0;
    var $phitmp = $3 + $end | 0;
    var $5 = $phitmp;
    label = 4;
    break;
   case 4:
    var $5;
    var $6 = _calloc($5, 2);
    var $7 = $6;
    HEAP32[$dst >> 2] = $7;
    var $8 = ($6 | 0) == 0;
    var $9 = ($src | 0) == 0;
    var $or_cond = $8 | $9;
    if ($or_cond) {
      label = 11;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $11 = HEAP16[$src >> 1];
    var $12 = _hasUcs2ByteOrderMarker($11);
    var $13 = ($12 | 0) == 0;
    if ($13) {
      var $n_0_ph = 0;
      var $_022_ph = $start;
      label = 7;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    HEAP16[$7 >> 1] = $11;
    var $15 = ($start | 0) == 0;
    var $16 = $15 & 1;
    var $_start = $16 + $start | 0;
    var $n_0_ph = 1;
    var $_022_ph = $_start;
    label = 7;
    break;
   case 7:
    var $_022_ph;
    var $n_0_ph;
    var $17 = $_022_ph >>> 0 < $end >>> 0;
    if ($17) {
      label = 8;
      break;
    } else {
      var $n_0_lcssa = $n_0_ph;
      label = 10;
      break;
    }
   case 8:
    var $18 = $n_0_ph + $end | 0;
    var $19 = $18 - $_022_ph | 0;
    var $_0221 = $_022_ph;
    var $n_02 = $n_0_ph;
    label = 9;
    break;
   case 9:
    var $n_02;
    var $_0221;
    var $21 = $_0221 + 1 | 0;
    var $22 = $src + ($_0221 << 1) | 0;
    var $23 = HEAP16[$22 >> 1];
    var $24 = $n_02 + 1 | 0;
    var $25 = $7 + ($n_02 << 1) | 0;
    HEAP16[$25 >> 1] = $23;
    var $exitcond = ($24 | 0) == ($19 | 0);
    if ($exitcond) {
      var $n_0_lcssa = $19;
      label = 10;
      break;
    } else {
      var $_0221 = $21;
      var $n_02 = $24;
      label = 9;
      break;
    }
   case 10:
    var $n_0_lcssa;
    var $26 = $7 + ($n_0_lcssa << 1) | 0;
    HEAP16[$26 >> 1] = 0;
    label = 11;
    break;
   case 11:
    return;
  }
}
function _id3tag_set_fieldvalue_ucs2($gfp, $fieldvalue) {
  return _id3tag_set_fieldvalue_utf16($gfp, $fieldvalue);
}
function _lame_get_id3v2_tag($gfp, $buffer, $size) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($gfp | 0) == 0;
    if ($1) {
      var $_0 = 0;
      label = 44;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $gfp + 288 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) == 0;
    if ($5) {
      var $_0 = 0;
      label = 44;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $7 = _test_tag_spec_flags($4, 4);
    var $8 = ($7 | 0) == 0;
    if ($8) {
      label = 5;
      break;
    } else {
      var $_0 = 0;
      label = 44;
      break;
    }
   case 5:
    var $10 = _test_tag_spec_flags($4, 10);
    var $11 = $4 + 85700 | 0;
    var $12 = HEAP32[$11 >> 2];
    var $13 = ($12 | 0) == 0;
    if ($13) {
      var $17 = 0;
      label = 7;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    var $15 = _strlen($12);
    var $17 = $15;
    label = 7;
    break;
   case 7:
    var $17;
    var $18 = $4 + 85704 | 0;
    var $19 = HEAP32[$18 >> 2];
    var $20 = ($19 | 0) == 0;
    if ($20) {
      var $24 = 0;
      label = 9;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    var $22 = _strlen($19);
    var $24 = $22;
    label = 9;
    break;
   case 9:
    var $24;
    var $25 = $4 + 85708 | 0;
    var $26 = HEAP32[$25 >> 2];
    var $27 = ($26 | 0) == 0;
    if ($27) {
      var $31 = 0;
      label = 11;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    var $29 = _strlen($26);
    var $31 = $29;
    label = 11;
    break;
   case 11:
    var $31;
    var $32 = $4 + 85712 | 0;
    var $33 = HEAP32[$32 >> 2];
    var $34 = ($33 | 0) == 0;
    if ($34) {
      var $38 = 0;
      label = 13;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    var $36 = _strlen($33);
    var $38 = $36;
    label = 13;
    break;
   case 13:
    var $38;
    var $39 = $17 >>> 0 > 30;
    var $40 = $24 >>> 0 > 30;
    var $or_cond = $39 | $40;
    var $41 = $31 >>> 0 > 30;
    var $or_cond78 = $or_cond | $41;
    var $42 = $38 >>> 0 > 30;
    var $or_cond79 = $or_cond78 | $42;
    if ($or_cond79) {
      label = 15;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    var $44 = $4 + 85716 | 0;
    var $45 = HEAP32[$44 >> 2];
    var $notlhs = ($45 | 0) == 0;
    var $notrhs = $38 >>> 0 < 29;
    var $or_cond80_not = $notrhs | $notlhs;
    var $46 = ($10 | 0) == 0;
    var $or_cond84 = $or_cond80_not & $46;
    if ($or_cond84) {
      var $_0 = 0;
      label = 44;
      break;
    } else {
      label = 15;
      break;
    }
   case 15:
    var $47 = $gfp + 4 | 0;
    var $48 = HEAP32[$47 >> 2];
    var $49 = ($48 | 0) == -1;
    if ($49) {
      label = 17;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    var $51 = $48 >>> 0;
    _id3v2AddAudioDuration($gfp, $51);
    label = 17;
    break;
   case 17:
    var $53 = $4 + 85724 | 0;
    var $54 = HEAP32[$53 >> 2];
    var $55 = ($54 | 0) == 0;
    if ($55) {
      var $albumart_mime_1 = 0;
      var $tag_size_0 = 10;
      label = 23;
      break;
    } else {
      label = 18;
      break;
    }
   case 18:
    var $57 = $4 + 85728 | 0;
    var $58 = HEAP32[$57 >> 2];
    var $59 = ($58 | 0) == 0;
    if ($59) {
      var $albumart_mime_1 = 0;
      var $tag_size_0 = 10;
      label = 23;
      break;
    } else {
      label = 19;
      break;
    }
   case 19:
    var $61 = $4 + 85736 | 0;
    var $62 = HEAP32[$61 >> 2];
    if (($62 | 0) == 2) {
      label = 20;
      break;
    } else if (($62 | 0) == 3) {
      label = 21;
      break;
    } else if (($62 | 0) == 1) {
      var $albumart_mime_0_ph = 5384896;
      label = 22;
      break;
    } else {
      var $albumart_mime_1 = 0;
      var $tag_size_0 = 10;
      label = 23;
      break;
    }
   case 20:
    var $albumart_mime_0_ph = 5384376;
    label = 22;
    break;
   case 21:
    var $albumart_mime_0_ph = 5383996;
    label = 22;
    break;
   case 22:
    var $albumart_mime_0_ph;
    var $66 = _strlen($albumart_mime_0_ph);
    var $67 = HEAP32[$57 >> 2];
    var $68 = $66 + 24 | 0;
    var $69 = $68 + $67 | 0;
    var $albumart_mime_1 = $albumart_mime_0_ph;
    var $tag_size_0 = $69;
    label = 23;
    break;
   case 23:
    var $tag_size_0;
    var $albumart_mime_1;
    var $70 = $4 + 85740 | 0;
    var $71 = HEAP32[$70 >> 2];
    var $72 = ($71 | 0) == 0;
    if ($72) {
      var $tag_size_3 = $tag_size_0;
      label = 30;
      break;
    } else {
      var $tag_size_189 = $tag_size_0;
      var $node_090 = $71;
      label = 24;
      break;
    }
   case 24:
    var $node_090;
    var $tag_size_189;
    var $73 = $node_090 + 4 | 0;
    var $74 = HEAP32[$73 >> 2];
    if (($74 | 0) == 1129270605 | ($74 | 0) == 1431520594) {
      label = 25;
      break;
    } else {
      label = 26;
      break;
    }
   case 25:
    var $76 = _sizeOfCommentNode($node_090);
    var $_pn = $76;
    label = 29;
    break;
   case 26:
    var $78 = _isFrameIdMatching($74, 1459617792);
    var $79 = ($78 | 0) == 0;
    if ($79) {
      label = 28;
      break;
    } else {
      label = 27;
      break;
    }
   case 27:
    var $81 = _sizeOfWxxxNode($node_090);
    var $_pn = $81;
    label = 29;
    break;
   case 28:
    var $83 = _sizeOfNode($node_090);
    var $_pn = $83;
    label = 29;
    break;
   case 29:
    var $_pn;
    var $tag_size_2 = $_pn + $tag_size_189 | 0;
    var $85 = $node_090 | 0;
    var $86 = HEAP32[$85 >> 2];
    var $87 = ($86 | 0) == 0;
    if ($87) {
      var $tag_size_3 = $tag_size_2;
      label = 30;
      break;
    } else {
      var $tag_size_189 = $tag_size_2;
      var $node_090 = $86;
      label = 24;
      break;
    }
   case 30:
    var $tag_size_3;
    var $88 = _test_tag_spec_flags($4, 32);
    var $89 = ($88 | 0) == 0;
    if ($89) {
      var $tag_size_4 = $tag_size_3;
      label = 32;
      break;
    } else {
      label = 31;
      break;
    }
   case 31:
    var $91 = $4 + 85732 | 0;
    var $92 = HEAP32[$91 >> 2];
    var $93 = $92 + $tag_size_3 | 0;
    var $tag_size_4 = $93;
    label = 32;
    break;
   case 32:
    var $tag_size_4;
    var $95 = $tag_size_4 >>> 0 > $size >>> 0;
    if ($95) {
      var $_0 = $tag_size_4;
      label = 44;
      break;
    } else {
      label = 33;
      break;
    }
   case 33:
    var $97 = ($buffer | 0) == 0;
    if ($97) {
      var $_0 = 0;
      label = 44;
      break;
    } else {
      label = 34;
      break;
    }
   case 34:
    var $99 = $buffer + 1 | 0;
    HEAP8[$buffer] = 73;
    var $100 = $buffer + 2 | 0;
    HEAP8[$99] = 68;
    var $101 = $buffer + 3 | 0;
    HEAP8[$100] = 51;
    var $102 = $buffer + 4 | 0;
    HEAP8[$101] = 3;
    var $103 = $buffer + 5 | 0;
    HEAP8[$102] = 0;
    var $104 = $buffer + 6 | 0;
    HEAP8[$103] = 0;
    var $105 = $tag_size_4 - 10 | 0;
    var $106 = $105 >>> 21;
    var $_tr = $106 & 255;
    var $107 = $_tr & 127;
    var $108 = $buffer + 7 | 0;
    HEAP8[$104] = $107;
    var $109 = $105 >>> 14;
    var $_tr75 = $109 & 255;
    var $110 = $_tr75 & 127;
    var $111 = $buffer + 8 | 0;
    HEAP8[$108] = $110;
    var $112 = $105 >>> 7;
    var $_tr76 = $112 & 255;
    var $113 = $_tr76 & 127;
    var $114 = $buffer + 9 | 0;
    HEAP8[$111] = $113;
    var $_tr77 = $105 & 255;
    var $115 = $_tr77 & 127;
    var $116 = $buffer + 10 | 0;
    HEAP8[$114] = $115;
    var $117 = HEAP32[$70 >> 2];
    var $118 = ($117 | 0) == 0;
    if ($118) {
      var $p_2 = $116;
      label = 41;
      break;
    } else {
      var $p_085 = $116;
      var $node2_086 = $117;
      label = 35;
      break;
    }
   case 35:
    var $node2_086;
    var $p_085;
    var $119 = $node2_086 + 4 | 0;
    var $120 = HEAP32[$119 >> 2];
    if (($120 | 0) == 1129270605 | ($120 | 0) == 1431520594) {
      label = 36;
      break;
    } else {
      label = 37;
      break;
    }
   case 36:
    var $122 = _set_frame_comment($p_085, $node2_086);
    var $p_1 = $122;
    label = 40;
    break;
   case 37:
    var $124 = _isFrameIdMatching($120, 1459617792);
    var $125 = ($124 | 0) == 0;
    if ($125) {
      label = 39;
      break;
    } else {
      label = 38;
      break;
    }
   case 38:
    var $127 = _set_frame_wxxx($p_085, $node2_086);
    var $p_1 = $127;
    label = 40;
    break;
   case 39:
    var $129 = _set_frame_custom2($p_085, $node2_086);
    var $p_1 = $129;
    label = 40;
    break;
   case 40:
    var $p_1;
    var $131 = $node2_086 | 0;
    var $132 = HEAP32[$131 >> 2];
    var $133 = ($132 | 0) == 0;
    if ($133) {
      var $p_2 = $p_1;
      label = 41;
      break;
    } else {
      var $p_085 = $p_1;
      var $node2_086 = $132;
      label = 35;
      break;
    }
   case 41:
    var $p_2;
    var $134 = ($albumart_mime_1 | 0) == 0;
    if ($134) {
      var $p_3 = $p_2;
      label = 43;
      break;
    } else {
      label = 42;
      break;
    }
   case 42:
    var $136 = HEAP32[$53 >> 2];
    var $137 = $4 + 85728 | 0;
    var $138 = HEAP32[$137 >> 2];
    var $139 = _set_frame_apic($p_2, $albumart_mime_1, $136, $138);
    var $p_3 = $139;
    label = 43;
    break;
   case 43:
    var $p_3;
    var $141 = $p_3;
    var $142 = $buffer;
    var $143 = $tag_size_4 + $142 | 0;
    var $144 = $143 - $141 | 0;
    _memset($p_3, 0, $144);
    var $_0 = $tag_size_4;
    label = 44;
    break;
   case 44:
    var $_0;
    return $_0;
  }
}
_lame_get_id3v2_tag["X"] = 1;
function _id3v2AddAudioDuration($gfp, $ms) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 1024 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $buffer = __stackBase__;
    var $1 = $gfp + 288 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $ms * 1e3;
    var $4 = $2 + 60 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = $5 | 0;
    var $7 = $3 / $6;
    var $8 = $7 > 4294967295;
    if ($8) {
      var $playlength_ms_0 = -1;
      label = 5;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $10 = $7 < 0;
    if ($10) {
      var $playlength_ms_0 = 0;
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $12 = $7 >= 0 ? Math.floor($7) : Math.ceil($7);
    var $playlength_ms_0 = $12;
    label = 5;
    break;
   case 5:
    var $playlength_ms_0;
    var $14 = $buffer | 0;
    var $15 = _sprintf($14, 5383208, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $playlength_ms_0, tempInt));
    _copyV1ToV2($gfp, 1414284622, $14);
    STACKTOP = __stackBase__;
    return;
  }
}
function _isMultiFrame($frame_id) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    if (($frame_id | 0) == 1415075928 | ($frame_id | 0) == 1465407576 | ($frame_id | 0) == 1129270605 | ($frame_id | 0) == 1398361172 | ($frame_id | 0) == 1095780675 | ($frame_id | 0) == 1195724610 | ($frame_id | 0) == 1346588244 | ($frame_id | 0) == 1095061059 | ($frame_id | 0) == 1279872587 | ($frame_id | 0) == 1162756946 | ($frame_id | 0) == 1196575044 | ($frame_id | 0) == 1347570006) {
      var $_0 = 1;
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $_0 = 0;
    label = 4;
    break;
   case 4:
    var $_0;
    return $_0;
  }
}
function _sizeOfWxxxNode($node) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($node | 0) == 0;
    if ($1) {
      var $n_1 = 0;
      label = 11;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $node + 16 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) == 0;
    if ($5) {
      var $n_0 = 10;
      label = 7;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $7 = $node + 20 | 0;
    var $8 = HEAP32[$7 >> 2];
    var $cond = ($8 | 0) == 1;
    if ($cond) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $10 = $4 + 12 | 0;
    var $n_0 = $10;
    label = 7;
    break;
   case 6:
    var $12 = $4 << 1;
    var $13 = $12 + 13 | 0;
    var $n_0 = $13;
    label = 7;
    break;
   case 7:
    var $n_0;
    var $15 = $node + 28 | 0;
    var $16 = HEAP32[$15 >> 2];
    var $17 = ($16 | 0) == 0;
    if ($17) {
      var $n_1 = $n_0;
      label = 11;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    var $19 = $node + 32 | 0;
    var $20 = HEAP32[$19 >> 2];
    var $cond1 = ($20 | 0) == 1;
    if ($cond1) {
      label = 10;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    var $22 = $16 + $n_0 | 0;
    var $n_1 = $22;
    label = 11;
    break;
   case 10:
    var $24 = $n_0 - 1 | 0;
    var $25 = $24 + $16 | 0;
    var $n_1 = $25;
    label = 11;
    break;
   case 11:
    var $n_1;
    return $n_1;
  }
}
function _sizeOfNode($node) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($node | 0) == 0;
    if ($1) {
      var $n_2 = 0;
      label = 8;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $node + 32 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $cond = ($4 | 0) == 1;
    var $5 = $node + 16 | 0;
    var $6 = HEAP32[$5 >> 2];
    var $7 = ($6 | 0) != 0;
    if ($cond) {
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $9 = $6 + 12 | 0;
    var $_ = $7 ? $9 : 11;
    var $10 = $node + 28 | 0;
    var $11 = HEAP32[$10 >> 2];
    var $12 = $11 + $_ | 0;
    var $n_2 = $12;
    label = 8;
    break;
   case 5:
    if ($7) {
      label = 6;
      break;
    } else {
      var $n_1 = 11;
      label = 7;
      break;
    }
   case 6:
    var $15 = $6 << 1;
    var $16 = $15 + 13 | 0;
    var $n_1 = $16;
    label = 7;
    break;
   case 7:
    var $n_1;
    var $18 = $node + 28 | 0;
    var $19 = HEAP32[$18 >> 2];
    var $20 = $19 << 1;
    var $21 = $20 + $n_1 | 0;
    var $n_2 = $21;
    label = 8;
    break;
   case 8:
    var $n_2;
    return $n_2;
  }
}
function _set_text_field($field, $text, $size, $pad) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($size | 0) == 0;
    if ($1) {
      var $_0_lcssa = $field;
      label = 9;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $2 = $pad & 255;
    var $_09_ph14 = $text;
    var $_0_ph15 = $field;
    var $_in = $size;
    label = 4;
    break;
   case 4:
    var $_in;
    var $_0_ph15;
    var $_09_ph14;
    var $3 = ($_09_ph14 | 0) == 0;
    var $_012 = $_0_ph15;
    var $_in17 = $_in;
    label = 5;
    break;
   case 5:
    var $_in17;
    var $_012;
    var $5 = $_in17 - 1 | 0;
    if ($3) {
      label = 8;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    var $7 = HEAP8[$_09_ph14];
    var $8 = $7 << 24 >> 24 == 0;
    if ($8) {
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    var $9 = $_09_ph14 + 1 | 0;
    var $10 = $_012 + 1 | 0;
    HEAP8[$_012] = $7;
    var $11 = ($5 | 0) == 0;
    if ($11) {
      var $_0_lcssa = $10;
      label = 9;
      break;
    } else {
      var $_09_ph14 = $9;
      var $_0_ph15 = $10;
      var $_in = $5;
      label = 4;
      break;
    }
   case 8:
    var $13 = $_012 + 1 | 0;
    HEAP8[$_012] = $2;
    var $14 = ($5 | 0) == 0;
    if ($14) {
      var $_0_lcssa = $13;
      label = 9;
      break;
    } else {
      var $_012 = $13;
      var $_in17 = $5;
      label = 5;
      break;
    }
   case 9:
    var $_0_lcssa;
    return $_0_lcssa;
  }
}
function _set_4_byte_value($bytes, $value) {
  HEAP8[$bytes + 3 | 0] = $value & 255;
  HEAP8[$bytes + 2 | 0] = $value >>> 8 & 255;
  HEAP8[$bytes + 1 | 0] = $value >>> 16 & 255;
  HEAP8[$bytes] = $value >>> 24 & 255;
  return $bytes + 4 | 0;
}
function _writeChars($frame, $str, $n) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($n | 0) == 0;
    if ($1) {
      var $_05_lcssa = $frame;
      label = 5;
      break;
    } else {
      var $_056 = $frame;
      var $_047 = $str;
      var $_08 = $n;
      label = 3;
      break;
    }
   case 3:
    var $_08;
    var $_047;
    var $_056;
    var $2 = $_08 - 1 | 0;
    var $3 = $_047 + 1 | 0;
    var $4 = HEAP8[$_047];
    var $5 = $_056 + 1 | 0;
    HEAP8[$_056] = $4;
    var $6 = ($2 | 0) == 0;
    if ($6) {
      label = 4;
      break;
    } else {
      var $_056 = $5;
      var $_047 = $3;
      var $_08 = $2;
      label = 3;
      break;
    }
   case 4:
    var $scevgep = $frame + $n | 0;
    var $_05_lcssa = $scevgep;
    label = 5;
    break;
   case 5:
    var $_05_lcssa;
    return $_05_lcssa;
  }
}
function _findNode($tag, $frame_id, $last) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($last | 0) == 0;
    var $2 = $last | 0;
    var $3 = $tag + 48 | 0;
    var $_in = $1 ? $3 : $2;
    var $node_0_in = $_in;
    label = 3;
    break;
   case 3:
    var $node_0_in;
    var $node_0 = HEAP32[$node_0_in >> 2];
    var $5 = ($node_0 | 0) == 0;
    if ($5) {
      var $_0 = 0;
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $7 = $node_0 + 4 | 0;
    var $8 = HEAP32[$7 >> 2];
    var $9 = ($8 | 0) == ($frame_id | 0);
    var $10 = $node_0 | 0;
    if ($9) {
      var $_0 = $node_0;
      label = 5;
      break;
    } else {
      var $node_0_in = $10;
      label = 3;
      break;
    }
   case 5:
    var $_0;
    return $_0;
  }
}
function _set_frame_comment($frame, $node) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = _sizeOfCommentNode($node);
    var $2 = $1 >>> 0 > 10;
    if ($2) {
      label = 3;
      break;
    } else {
      var $_1 = $frame;
      label = 9;
      break;
    }
   case 3:
    var $4 = $node + 4 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = _set_4_byte_value($frame, $5);
    var $7 = $1 - 10 | 0;
    var $8 = _set_4_byte_value($6, $7);
    var $9 = $8 + 1 | 0;
    HEAP8[$8] = 0;
    var $10 = $8 + 2 | 0;
    HEAP8[$9] = 0;
    var $11 = $node + 24 | 0;
    var $12 = $node + 32 | 0;
    var $13 = HEAP32[$12 >> 2];
    var $14 = ($13 | 0) == 1;
    var $15 = $14 & 1;
    var $16 = $8 + 3 | 0;
    HEAP8[$10] = $15;
    var $17 = $node + 8 | 0;
    var $18 = HEAP8[$17];
    var $19 = $8 + 4 | 0;
    HEAP8[$16] = $18;
    var $20 = $node + 9 | 0;
    var $21 = HEAP8[$20];
    var $22 = $8 + 5 | 0;
    HEAP8[$19] = $21;
    var $23 = $node + 10 | 0;
    var $24 = HEAP8[$23];
    var $25 = $8 + 6 | 0;
    HEAP8[$22] = $24;
    var $26 = $node + 12 | 0;
    var $27 = $node + 20 | 0;
    var $28 = HEAP32[$27 >> 2];
    var $29 = ($28 | 0) == 1;
    if ($29) {
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $31 = $26 | 0;
    var $32 = HEAP32[$31 >> 2];
    var $33 = $node + 16 | 0;
    var $34 = HEAP32[$33 >> 2];
    var $35 = _writeChars($25, $32, $34);
    var $36 = $35 + 1 | 0;
    HEAP8[$35] = 0;
    var $_0 = $36;
    label = 6;
    break;
   case 5:
    var $38 = $26;
    var $39 = HEAP32[$38 >> 2];
    var $40 = $node + 16 | 0;
    var $41 = HEAP32[$40 >> 2];
    var $42 = _writeUcs2s($25, $39, $41);
    var $43 = $42 + 1 | 0;
    HEAP8[$42] = 0;
    var $44 = $42 + 2 | 0;
    HEAP8[$43] = 0;
    var $_0 = $44;
    label = 6;
    break;
   case 6:
    var $_0;
    var $46 = HEAP32[$12 >> 2];
    var $47 = ($46 | 0) == 1;
    if ($47) {
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    var $49 = $11 | 0;
    var $50 = HEAP32[$49 >> 2];
    var $51 = $node + 28 | 0;
    var $52 = HEAP32[$51 >> 2];
    var $53 = _writeChars($_0, $50, $52);
    var $_1 = $53;
    label = 9;
    break;
   case 8:
    var $55 = $11;
    var $56 = HEAP32[$55 >> 2];
    var $57 = $node + 28 | 0;
    var $58 = HEAP32[$57 >> 2];
    var $59 = _writeUcs2s($_0, $56, $58);
    var $_1 = $59;
    label = 9;
    break;
   case 9:
    var $_1;
    return $_1;
  }
}
_set_frame_comment["X"] = 1;
function _set_frame_wxxx($frame, $node) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = _sizeOfWxxxNode($node);
    var $2 = $1 >>> 0 > 10;
    if ($2) {
      label = 3;
      break;
    } else {
      var $_1 = $frame;
      label = 10;
      break;
    }
   case 3:
    var $4 = $node + 4 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = _set_4_byte_value($frame, $5);
    var $7 = $1 - 10 | 0;
    var $8 = _set_4_byte_value($6, $7);
    var $9 = $8 + 1 | 0;
    HEAP8[$8] = 0;
    var $10 = $8 + 2 | 0;
    HEAP8[$9] = 0;
    var $11 = $node + 16 | 0;
    var $12 = HEAP32[$11 >> 2];
    var $13 = ($12 | 0) == 0;
    if ($13) {
      var $_0 = $10;
      label = 7;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $15 = $node + 20 | 0;
    var $16 = HEAP32[$15 >> 2];
    var $17 = ($16 | 0) == 1;
    var $18 = $17 & 1;
    var $19 = $8 + 3 | 0;
    HEAP8[$10] = $18;
    var $20 = HEAP32[$15 >> 2];
    var $21 = ($20 | 0) == 1;
    var $22 = $node + 12 | 0;
    if ($21) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $24 = $22 | 0;
    var $25 = HEAP32[$24 >> 2];
    var $26 = HEAP32[$11 >> 2];
    var $27 = _writeChars($19, $25, $26);
    var $28 = $27 + 1 | 0;
    HEAP8[$27] = 0;
    var $_0 = $28;
    label = 7;
    break;
   case 6:
    var $30 = $22;
    var $31 = HEAP32[$30 >> 2];
    var $32 = HEAP32[$11 >> 2];
    var $33 = _writeUcs2s($19, $31, $32);
    var $34 = $33 + 1 | 0;
    HEAP8[$33] = 0;
    var $35 = $33 + 2 | 0;
    HEAP8[$34] = 0;
    var $_0 = $35;
    label = 7;
    break;
   case 7:
    var $_0;
    var $37 = $node + 24 | 0;
    var $38 = $node + 32 | 0;
    var $39 = HEAP32[$38 >> 2];
    var $40 = ($39 | 0) == 1;
    if ($40) {
      label = 9;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    var $42 = $37 | 0;
    var $43 = HEAP32[$42 >> 2];
    var $44 = $node + 28 | 0;
    var $45 = HEAP32[$44 >> 2];
    var $46 = _writeChars($_0, $43, $45);
    var $_1 = $46;
    label = 10;
    break;
   case 9:
    var $48 = $37;
    var $49 = HEAP32[$48 >> 2];
    var $50 = $node + 28 | 0;
    var $51 = HEAP32[$50 >> 2];
    var $52 = _writeLoBytes($_0, $49, $51);
    var $_1 = $52;
    label = 10;
    break;
   case 10:
    var $_1;
    return $_1;
  }
}
_set_frame_wxxx["X"] = 1;
function _set_frame_custom2($frame, $node) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = _sizeOfNode($node);
    var $2 = $1 >>> 0 > 10;
    if ($2) {
      label = 3;
      break;
    } else {
      var $_1 = $frame;
      label = 10;
      break;
    }
   case 3:
    var $4 = $node + 4 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = _set_4_byte_value($frame, $5);
    var $7 = $1 - 10 | 0;
    var $8 = _set_4_byte_value($6, $7);
    var $9 = $8 + 1 | 0;
    HEAP8[$8] = 0;
    var $10 = $8 + 2 | 0;
    HEAP8[$9] = 0;
    var $11 = $node + 24 | 0;
    var $12 = $node + 32 | 0;
    var $13 = HEAP32[$12 >> 2];
    var $14 = ($13 | 0) == 1;
    var $15 = $14 & 1;
    var $16 = $8 + 3 | 0;
    HEAP8[$10] = $15;
    var $17 = $node + 16 | 0;
    var $18 = HEAP32[$17 >> 2];
    var $19 = ($18 | 0) == 0;
    if ($19) {
      var $_0 = $16;
      label = 7;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $21 = $node + 20 | 0;
    var $22 = HEAP32[$21 >> 2];
    var $23 = ($22 | 0) == 1;
    var $24 = $node + 12 | 0;
    if ($23) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $26 = $24 | 0;
    var $27 = HEAP32[$26 >> 2];
    var $28 = _writeChars($16, $27, $18);
    var $29 = $28 + 1 | 0;
    HEAP8[$28] = 0;
    var $_0 = $29;
    label = 7;
    break;
   case 6:
    var $31 = $24;
    var $32 = HEAP32[$31 >> 2];
    var $33 = _writeUcs2s($16, $32, $18);
    var $34 = $33 + 1 | 0;
    HEAP8[$33] = 0;
    var $35 = $33 + 2 | 0;
    HEAP8[$34] = 0;
    var $_0 = $35;
    label = 7;
    break;
   case 7:
    var $_0;
    var $37 = HEAP32[$12 >> 2];
    var $38 = ($37 | 0) == 1;
    if ($38) {
      label = 9;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    var $40 = $11 | 0;
    var $41 = HEAP32[$40 >> 2];
    var $42 = $node + 28 | 0;
    var $43 = HEAP32[$42 >> 2];
    var $44 = _writeChars($_0, $41, $43);
    var $_1 = $44;
    label = 10;
    break;
   case 9:
    var $46 = $11;
    var $47 = HEAP32[$46 >> 2];
    var $48 = $node + 28 | 0;
    var $49 = HEAP32[$48 >> 2];
    var $50 = _writeUcs2s($_0, $47, $49);
    var $_1 = $50;
    label = 10;
    break;
   case 10:
    var $_1;
    return $_1;
  }
}
_set_frame_custom2["X"] = 1;
function _set_frame_apic($frame, $mimetype, $data, $size) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($mimetype | 0) == 0;
    var $2 = ($data | 0) == 0;
    var $or_cond = $1 | $2;
    var $3 = ($size | 0) == 0;
    var $or_cond23 = $or_cond | $3;
    if ($or_cond23) {
      var $_2 = $frame;
      label = 9;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $5 = _set_4_byte_value($frame, 1095780675);
    var $6 = _strlen($mimetype);
    var $7 = $size + 4 | 0;
    var $8 = $7 + $6 | 0;
    var $9 = _set_4_byte_value($5, $8);
    var $10 = $9 + 1 | 0;
    HEAP8[$9] = 0;
    var $11 = $9 + 2 | 0;
    HEAP8[$10] = 0;
    var $12 = $9 + 3 | 0;
    HEAP8[$11] = 0;
    var $13 = HEAP8[$mimetype];
    var $14 = $13 << 24 >> 24 == 0;
    if ($14) {
      var $_022_lcssa = $12;
      label = 5;
      break;
    } else {
      var $_02227 = $12;
      var $_02128 = $mimetype;
      var $15 = $13;
      label = 4;
      break;
    }
   case 4:
    var $15;
    var $_02128;
    var $_02227;
    var $16 = $_02128 + 1 | 0;
    var $17 = $_02227 + 1 | 0;
    HEAP8[$_02227] = $15;
    var $18 = HEAP8[$16];
    var $19 = $18 << 24 >> 24 == 0;
    if ($19) {
      var $_022_lcssa = $17;
      label = 5;
      break;
    } else {
      var $_02227 = $17;
      var $_02128 = $16;
      var $15 = $18;
      label = 4;
      break;
    }
   case 5:
    var $_022_lcssa;
    var $20 = $_022_lcssa + 1 | 0;
    HEAP8[$_022_lcssa] = 0;
    var $21 = $_022_lcssa + 2 | 0;
    HEAP8[$20] = 0;
    var $22 = $_022_lcssa + 3 | 0;
    HEAP8[$21] = 0;
    var $23 = ($size | 0) == 0;
    if ($23) {
      var $_2 = $22;
      label = 9;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    var $24 = $size + 3 | 0;
    var $_124 = $22;
    var $_02025 = $data;
    var $_026 = $size;
    label = 7;
    break;
   case 7:
    var $_026;
    var $_02025;
    var $_124;
    var $26 = $_026 - 1 | 0;
    var $27 = $_02025 + 1 | 0;
    var $28 = HEAP8[$_02025];
    var $29 = $_124 + 1 | 0;
    HEAP8[$_124] = $28;
    var $30 = ($26 | 0) == 0;
    if ($30) {
      label = 8;
      break;
    } else {
      var $_124 = $29;
      var $_02025 = $27;
      var $_026 = $26;
      label = 7;
      break;
    }
   case 8:
    var $scevgep = $_022_lcssa + $24 | 0;
    var $_2 = $scevgep;
    label = 9;
    break;
   case 9:
    var $_2;
    return $_2;
  }
}
_set_frame_apic["X"] = 1;
function _id3tag_write_v2($gfp) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfp + 288 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = _test_tag_spec_flags($2, 4);
    var $4 = ($3 | 0) == 0;
    if ($4) {
      label = 3;
      break;
    } else {
      var $_0 = 0;
      label = 10;
      break;
    }
   case 3:
    var $6 = _test_tag_spec_flags($2, 1);
    var $7 = ($6 | 0) == 0;
    if ($7) {
      var $_0 = 0;
      label = 10;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $9 = _lame_get_id3v2_tag($gfp, 0, 0);
    var $10 = _calloc($9, 1);
    var $11 = ($10 | 0) == 0;
    if ($11) {
      var $_0 = -1;
      label = 10;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $13 = _lame_get_id3v2_tag($gfp, $10, $9);
    var $14 = $13 >>> 0 > $9 >>> 0;
    if ($14) {
      label = 7;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    var $15 = ($13 | 0) == 0;
    if ($15) {
      label = 9;
      break;
    } else {
      var $i_016 = 0;
      label = 8;
      break;
    }
   case 7:
    _free($10);
    var $_0 = -1;
    label = 10;
    break;
   case 8:
    var $i_016;
    var $17 = $10 + $i_016 | 0;
    var $18 = HEAP8[$17];
    _add_dummy_byte($2, $18, 1);
    var $19 = $i_016 + 1 | 0;
    var $exitcond = ($19 | 0) == ($13 | 0);
    if ($exitcond) {
      label = 9;
      break;
    } else {
      var $i_016 = $19;
      label = 8;
      break;
    }
   case 9:
    _free($10);
    var $_0 = $13;
    label = 10;
    break;
   case 10:
    var $_0;
    return $_0;
  }
}
function _lame_get_id3v1_tag($gfp, $buffer, $size) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 8 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $year = __stackBase__;
    var $1 = ($gfp | 0) == 0;
    if ($1) {
      var $_0 = 0;
      label = 10;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $size >>> 0 < 128;
    if ($3) {
      var $_0 = 128;
      label = 10;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $5 = $gfp + 288 | 0;
    var $6 = HEAP32[$5 >> 2];
    var $7 = ($6 | 0) == 0;
    var $8 = ($buffer | 0) == 0;
    var $or_cond = $7 | $8;
    if ($or_cond) {
      var $_0 = 0;
      label = 10;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $10 = _test_tag_spec_flags($6, 8);
    var $11 = ($10 | 0) == 0;
    if ($11) {
      label = 6;
      break;
    } else {
      var $_0 = 0;
      label = 10;
      break;
    }
   case 6:
    var $13 = _test_tag_spec_flags($6, 1);
    var $14 = ($13 | 0) == 0;
    if ($14) {
      var $_0 = 0;
      label = 10;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    var $16 = _test_tag_spec_flags($6, 16);
    var $17 = ($16 | 0) != 0;
    var $18 = $17 ? 32 : 0;
    var $19 = $buffer + 1 | 0;
    HEAP8[$buffer] = 84;
    var $20 = $buffer + 2 | 0;
    HEAP8[$19] = 65;
    var $21 = $buffer + 3 | 0;
    HEAP8[$20] = 71;
    var $22 = $6 + 85700 | 0;
    var $23 = HEAP32[$22 >> 2];
    var $24 = _set_text_field($21, $23, 30, $18);
    var $25 = $6 + 85704 | 0;
    var $26 = HEAP32[$25 >> 2];
    var $27 = _set_text_field($24, $26, 30, $18);
    var $28 = $6 + 85708 | 0;
    var $29 = HEAP32[$28 >> 2];
    var $30 = _set_text_field($27, $29, 30, $18);
    var $31 = $year | 0;
    var $32 = $6 + 85696 | 0;
    var $33 = HEAP32[$32 >> 2];
    var $34 = _sprintf($31, 5383568, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $33, tempInt));
    var $35 = HEAP32[$32 >> 2];
    var $36 = ($35 | 0) != 0;
    var $37 = $36 ? $31 : 0;
    var $38 = _set_text_field($30, $37, 4, $18);
    var $39 = $6 + 85712 | 0;
    var $40 = HEAP32[$39 >> 2];
    var $41 = $6 + 85716 | 0;
    var $42 = HEAP32[$41 >> 2];
    var $43 = ($42 | 0) != 0;
    var $44 = $43 ? 28 : 30;
    var $45 = _set_text_field($38, $40, $44, $18);
    var $46 = HEAP32[$41 >> 2];
    var $47 = ($46 | 0) == 0;
    if ($47) {
      var $p_0 = $45;
      label = 9;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    var $49 = $45 + 1 | 0;
    HEAP8[$45] = 0;
    var $50 = HEAP32[$41 >> 2];
    var $51 = $50 & 255;
    var $52 = $45 + 2 | 0;
    HEAP8[$49] = $51;
    var $p_0 = $52;
    label = 9;
    break;
   case 9:
    var $p_0;
    var $54 = $6 + 85720 | 0;
    var $55 = HEAP32[$54 >> 2];
    var $56 = $55 & 255;
    HEAP8[$p_0] = $56;
    var $_0 = 128;
    label = 10;
    break;
   case 10:
    var $_0;
    STACKTOP = __stackBase__;
    return $_0;
  }
}
_lame_get_id3v1_tag["X"] = 1;
function _id3tag_write_v1($gfp) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 128 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $tag = __stackBase__;
    var $1 = $gfp + 288 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $tag | 0;
    var $4 = _lame_get_id3v1_tag($gfp, $3, 128);
    var $5 = $4 >>> 0 > 128;
    var $6 = ($4 | 0) == 0;
    var $or_cond = $5 | $6;
    if ($or_cond) {
      var $_0 = 0;
      label = 4;
      break;
    } else {
      var $i_08 = 0;
      label = 3;
      break;
    }
   case 3:
    var $i_08;
    var $7 = $tag + $i_08 | 0;
    var $8 = HEAP8[$7];
    _add_dummy_byte($2, $8, 1);
    var $9 = $i_08 + 1 | 0;
    var $exitcond = ($9 | 0) == ($4 | 0);
    if ($exitcond) {
      var $_0 = $4;
      label = 4;
      break;
    } else {
      var $i_08 = $9;
      label = 3;
      break;
    }
   case 4:
    var $_0;
    STACKTOP = __stackBase__;
    return $_0;
  }
}
function _writeUcs2s($frame, $str, $n) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($n | 0) == 0;
    if ($1) {
      var $_1 = $frame;
      label = 6;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $2 = HEAP16[$str >> 1];
    var $3 = $n << 1;
    var $_0910 = $n;
    var $_0811 = $str;
    var $_012 = $frame;
    label = 4;
    break;
   case 4:
    var $_012;
    var $_0811;
    var $_0910;
    var $5 = $_0910 - 1 | 0;
    var $6 = $_0811 + 2 | 0;
    var $7 = HEAP16[$_0811 >> 1];
    var $8 = _toLittleEndian($2, $7);
    var $9 = $8 & 255;
    var $10 = $_012 + 1 | 0;
    HEAP8[$_012] = $9;
    var $11 = ($8 & 65535) >>> 8;
    var $12 = $11 & 255;
    var $13 = $_012 + 2 | 0;
    HEAP8[$10] = $12;
    var $14 = ($5 | 0) == 0;
    if ($14) {
      label = 5;
      break;
    } else {
      var $_0910 = $5;
      var $_0811 = $6;
      var $_012 = $13;
      label = 4;
      break;
    }
   case 5:
    var $scevgep = $frame + $3 | 0;
    var $_1 = $scevgep;
    label = 6;
    break;
   case 6:
    var $_1;
    return $_1;
  }
}
function _toLittleEndian($bom, $c) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $bom << 16 >> 16 == -2;
    if ($1) {
      label = 3;
      break;
    } else {
      var $_0 = $c;
      label = 4;
      break;
    }
   case 3:
    var $3 = _swap_bytes($c);
    var $_0 = $3;
    label = 4;
    break;
   case 4:
    var $_0;
    return $_0;
  }
}
function _swap_bytes($w) {
  return _llvm_bswap_i16($w);
}
function _writeLoBytes($frame, $str, $n) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($n | 0) == 0;
    if ($1) {
      var $_1 = $frame;
      label = 8;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = HEAP16[$str >> 1];
    var $4 = _hasUcs2ByteOrderMarker($3);
    var $5 = ($4 | 0) == 0;
    if ($5) {
      var $_012_ph = $str;
      var $_013_ph = $n;
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $7 = $str + 2 | 0;
    var $8 = $n - 1 | 0;
    var $_012_ph = $7;
    var $_013_ph = $8;
    label = 5;
    break;
   case 5:
    var $_013_ph;
    var $_012_ph;
    var $9 = ($_013_ph | 0) == 0;
    if ($9) {
      var $_1 = $frame;
      label = 8;
      break;
    } else {
      var $_01214 = $_012_ph;
      var $_015 = $frame;
      var $_in = $_013_ph;
      label = 6;
      break;
    }
   case 6:
    var $_in;
    var $_015;
    var $_01214;
    var $10 = $_in - 1 | 0;
    var $11 = $_01214 + 2 | 0;
    var $12 = HEAP16[$_01214 >> 1];
    var $13 = _toLittleEndian($3, $12);
    var $_off = $13 - 32 & 65535;
    var $14 = ($_off & 65535) > 223;
    var $15 = $13 & 255;
    var $storemerge = $14 ? 32 : $15;
    var $_0_be = $_015 + 1 | 0;
    HEAP8[$_015] = $storemerge;
    var $16 = ($10 | 0) == 0;
    if ($16) {
      label = 7;
      break;
    } else {
      var $_01214 = $11;
      var $_015 = $_0_be;
      var $_in = $10;
      label = 6;
      break;
    }
   case 7:
    var $scevgep = $frame + $_013_ph | 0;
    var $_1 = $scevgep;
    label = 8;
    break;
   case 8:
    var $_1;
    return $_1;
  }
}
function _searchGenre($genre) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $i_0 = 0;
    label = 3;
    break;
   case 3:
    var $i_0;
    var $2 = ($i_0 | 0) < 148;
    if ($2) {
      label = 4;
      break;
    } else {
      var $_0 = 148;
      label = 5;
      break;
    }
   case 4:
    var $4 = 5345208 + ($i_0 << 2) | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = _local_strcasecmp($genre, $5);
    var $7 = ($6 | 0) == 0;
    var $8 = $i_0 + 1 | 0;
    if ($7) {
      var $_0 = $i_0;
      label = 5;
      break;
    } else {
      var $i_0 = $8;
      label = 3;
      break;
    }
   case 5:
    var $_0;
    return $_0;
  }
}
function _sloppySearchGenre($genre) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $i_0 = 0;
    label = 3;
    break;
   case 3:
    var $i_0;
    var $2 = ($i_0 | 0) < 148;
    if ($2) {
      label = 4;
      break;
    } else {
      var $_0 = 148;
      label = 5;
      break;
    }
   case 4:
    var $4 = 5345208 + ($i_0 << 2) | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = _sloppyCompared($genre, $5);
    var $7 = ($6 | 0) == 0;
    var $8 = $i_0 + 1 | 0;
    if ($7) {
      var $i_0 = $8;
      label = 3;
      break;
    } else {
      var $_0 = $i_0;
      label = 5;
      break;
    }
   case 5:
    var $_0;
    return $_0;
  }
}
function _sloppyCompared($p, $q) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = _nextUpperAlpha($p, 0);
    var $2 = _nextUpperAlpha($q, 0);
    var $3 = HEAP8[$1];
    var $4 = $3 << 24 >> 24;
    var $5 = _toupper($4);
    var $6 = HEAP8[$2];
    var $7 = $6 << 24 >> 24;
    var $8 = _toupper($7);
    var $sext20 = $5 << 24;
    var $9 = $sext20 >> 24;
    var $sext1721 = $8 << 24;
    var $10 = $sext1721 >> 24;
    var $11 = ($9 | 0) == ($10 | 0);
    if ($11) {
      var $_01522 = $1;
      var $_023 = $2;
      var $cq_024_in = $8;
      var $cp_025_in = $5;
      var $12 = $9;
      label = 3;
      break;
    } else {
      var $_016 = 0;
      label = 8;
      break;
    }
   case 3:
    var $12;
    var $cp_025_in;
    var $cq_024_in;
    var $_023;
    var $_01522;
    var $cq_024 = $cq_024_in & 255;
    var $cp_025 = $cp_025_in & 255;
    var $13 = ($12 | 0) == 0;
    if ($13) {
      var $_016 = 1;
      label = 8;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $15 = $_01522 + 1 | 0;
    var $16 = HEAP8[$15];
    var $17 = $16 << 24 >> 24 == 46;
    if ($17) {
      var $_1 = $_023;
      label = 5;
      break;
    } else {
      var $_2 = $_023;
      label = 7;
      break;
    }
   case 5:
    var $_1;
    var $18 = HEAP8[$_1];
    var $19 = $18 << 24 >> 24 == 0;
    if ($19) {
      var $_2 = $_1;
      label = 7;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    var $21 = $_1 + 1 | 0;
    var $22 = $18 << 24 >> 24 == 32;
    if ($22) {
      var $_2 = $21;
      label = 7;
      break;
    } else {
      var $_1 = $21;
      label = 5;
      break;
    }
   case 7:
    var $_2;
    var $23 = _nextUpperAlpha($_01522, $cp_025);
    var $24 = _nextUpperAlpha($_2, $cq_024);
    var $25 = HEAP8[$23];
    var $26 = $25 << 24 >> 24;
    var $27 = _toupper($26);
    var $28 = HEAP8[$24];
    var $29 = $28 << 24 >> 24;
    var $30 = _toupper($29);
    var $sext = $27 << 24;
    var $31 = $sext >> 24;
    var $sext17 = $30 << 24;
    var $32 = $sext17 >> 24;
    var $33 = ($31 | 0) == ($32 | 0);
    if ($33) {
      var $_01522 = $23;
      var $_023 = $24;
      var $cq_024_in = $30;
      var $cp_025_in = $27;
      var $12 = $31;
      label = 3;
      break;
    } else {
      var $_016 = 0;
      label = 8;
      break;
    }
   case 8:
    var $_016;
    return $_016;
  }
}
_sloppyCompared["X"] = 1;
function _nextUpperAlpha($p, $x) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = HEAP8[$p];
    var $2 = $1 << 24 >> 24;
    var $3 = _toupper($2);
    var $4 = HEAP8[$p];
    var $5 = $4 << 24 >> 24 == 0;
    if ($5) {
      var $_09_lcssa = $p;
      label = 6;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $6 = $x << 24 >> 24;
    var $_0910 = $p;
    var $c_0_in11 = $3;
    label = 4;
    break;
   case 4:
    var $c_0_in11;
    var $_0910;
    var $sext = $c_0_in11 << 24;
    var $sext_off = $sext - 1073741825 | 0;
    var $8 = $sext_off >>> 0 > 452984830;
    var $9 = $sext >> 24;
    var $10 = ($9 | 0) == ($6 | 0);
    var $or_cond = $8 | $10;
    if ($or_cond) {
      label = 5;
      break;
    } else {
      var $_09_lcssa = $_0910;
      label = 6;
      break;
    }
   case 5:
    var $12 = $_0910 + 1 | 0;
    var $13 = HEAP8[$12];
    var $14 = $13 << 24 >> 24;
    var $15 = _toupper($14);
    var $16 = HEAP8[$12];
    var $17 = $16 << 24 >> 24 == 0;
    if ($17) {
      var $_09_lcssa = $12;
      label = 6;
      break;
    } else {
      var $_0910 = $12;
      var $c_0_in11 = $15;
      label = 4;
      break;
    }
   case 6:
    var $_09_lcssa;
    return $_09_lcssa;
  }
}
function _local_strcasecmp($s1, $s2) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $_0 = $s1;
    var $_07 = $s2;
    label = 3;
    break;
   case 3:
    var $_07;
    var $_0;
    var $2 = HEAP8[$_0];
    var $3 = $2 << 24 >> 24;
    var $4 = _tolower($3);
    var $5 = $4 & 255;
    var $6 = HEAP8[$_07];
    var $7 = $6 << 24 >> 24;
    var $8 = _tolower($7);
    var $9 = $5 << 24 >> 24 == 0;
    if ($9) {
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $11 = $_0 + 1 | 0;
    var $12 = $_07 + 1 | 0;
    var $13 = $8 ^ $4;
    var $14 = $13 & 255;
    var $15 = ($14 | 0) == 0;
    if ($15) {
      var $_0 = $11;
      var $_07 = $12;
      label = 3;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $17 = $4 & 255;
    var $18 = $8 & 255;
    var $19 = $17 - $18 | 0;
    return $19;
  }
}
function _frame_id_matches($id, $mask) {
  var $1 = $mask & 255;
  var $2 = $id & 255;
  var $6 = $mask & 65280;
  var $7 = $id & 65280;
  var $11 = $mask & 16711680;
  var $12 = $id & 16711680;
  var $16 = $mask & -16777216;
  var $17 = $id & -16777216;
  return (($16 | 0) == 0 | ($16 | 0) == ($17 | 0) ? 0 : $17) | ((($11 | 0) == 0 | ($11 | 0) == ($12 | 0) ? 0 : $12) | ((($6 | 0) == 0 | ($6 | 0) == ($7 | 0) ? 0 : $7) | (($1 | 0) == 0 | ($1 | 0) == ($2 | 0) ? 0 : $2)));
}
function _isSameDescriptor($node, $dsc) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $node + 20 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($2 | 0) == 1;
    if ($3) {
      label = 3;
      break;
    } else {
      label = 4;
      break;
    }
   case 3:
    var $5 = $node + 16 | 0;
    var $6 = HEAP32[$5 >> 2];
    var $7 = ($6 | 0) == 0;
    if ($7) {
      label = 4;
      break;
    } else {
      var $_0 = 0;
      label = 7;
      break;
    }
   case 4:
    var $8 = $node + 12 | 0;
    var $9 = $node + 16 | 0;
    var $10 = HEAP32[$9 >> 2];
    var $11 = ($dsc | 0) == 0;
    var $i_0 = 0;
    label = 5;
    break;
   case 5:
    var $i_0;
    var $_not = $i_0 >>> 0 >= $10 >>> 0;
    var $brmerge = $_not | $11;
    var $_mux = $_not & 1;
    if ($brmerge) {
      var $_0 = $_mux;
      label = 7;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    var $14 = HEAP32[$8 >> 2];
    var $15 = $14 + $i_0 | 0;
    var $16 = HEAP8[$15];
    var $17 = $dsc + $i_0 | 0;
    var $18 = HEAP8[$17];
    var $19 = $16 << 24 >> 24 == $18 << 24 >> 24;
    var $20 = $i_0 + 1 | 0;
    if ($19) {
      var $i_0 = $20;
      label = 5;
      break;
    } else {
      var $_0 = 0;
      label = 7;
      break;
    }
   case 7:
    var $_0;
    return $_0;
  }
}
function _appendNode($tag, $node) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $tag + 52 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($2 | 0) == 0;
    if ($3) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $5 = $tag + 48 | 0;
    var $6 = HEAP32[$5 >> 2];
    var $7 = ($6 | 0) == 0;
    if ($7) {
      label = 4;
      break;
    } else {
      label = 5;
      break;
    }
   case 4:
    var $9 = $tag + 48 | 0;
    HEAP32[$9 >> 2] = $node;
    label = 6;
    break;
   case 5:
    var $11 = $2 | 0;
    HEAP32[$11 >> 2] = $node;
    label = 6;
    break;
   case 6:
    HEAP32[$1 >> 2] = $node;
    return;
  }
}
function _local_char_pos($str) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($str | 0) == 0;
    if ($1) {
      var $_0 = -1;
      label = 6;
      break;
    } else {
      var $i_02 = 0;
      label = 3;
      break;
    }
   case 3:
    var $i_02;
    var $2 = $str + $i_02 | 0;
    var $3 = HEAP8[$2];
    if ($3 << 24 >> 24 == 61) {
      label = 5;
      break;
    } else if ($3 << 24 >> 24 == 0) {
      var $_0 = -1;
      label = 6;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $5 = $i_02 + 1 | 0;
    var $i_02 = $5;
    label = 3;
    break;
   case 5:
    var $_0 = $i_02;
    label = 6;
    break;
   case 6:
    var $_0;
    return $_0;
  }
}
function _isSameDescriptorUcs2($node, $dsc) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $node + 12 | 0;
    var $2 = $node + 20 | 0;
    var $3 = HEAP32[$2 >> 2];
    var $4 = ($3 | 0) == 1;
    if ($4) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $6 = $node + 16 | 0;
    var $7 = HEAP32[$6 >> 2];
    var $8 = ($7 | 0) == 0;
    if ($8) {
      label = 4;
      break;
    } else {
      var $_0 = 0;
      label = 7;
      break;
    }
   case 4:
    var $9 = $1;
    var $10 = $node + 16 | 0;
    var $11 = HEAP32[$10 >> 2];
    var $12 = ($dsc | 0) == 0;
    var $i_0 = 0;
    label = 5;
    break;
   case 5:
    var $i_0;
    var $_not = $i_0 >>> 0 >= $11 >>> 0;
    var $brmerge = $_not | $12;
    var $_mux = $_not & 1;
    if ($brmerge) {
      var $_0 = $_mux;
      label = 7;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    var $15 = HEAP32[$9 >> 2];
    var $16 = $15 + ($i_0 << 1) | 0;
    var $17 = HEAP16[$16 >> 1];
    var $18 = $dsc + ($i_0 << 1) | 0;
    var $19 = HEAP16[$18 >> 1];
    var $20 = $17 << 16 >> 16 == $19 << 16 >> 16;
    var $21 = $i_0 + 1 | 0;
    if ($20) {
      var $i_0 = $21;
      label = 5;
      break;
    } else {
      var $_0 = 0;
      label = 7;
      break;
    }
   case 7:
    var $_0;
    return $_0;
  }
}
function _local_ucs2_pos($str, $c) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($str | 0) == 0;
    var $i_0 = 0;
    label = 3;
    break;
   case 3:
    var $i_0;
    if ($1) {
      var $_0 = -1;
      label = 6;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $4 = $str + ($i_0 << 1) | 0;
    var $5 = HEAP16[$4 >> 1];
    var $6 = $5 << 16 >> 16 == 0;
    if ($6) {
      var $_0 = -1;
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $8 = $5 << 16 >> 16 == $c << 16 >> 16;
    var $9 = $i_0 + 1 | 0;
    if ($8) {
      var $_0 = $i_0;
      label = 6;
      break;
    } else {
      var $i_0 = $9;
      label = 3;
      break;
    }
   case 6:
    var $_0;
    return $_0;
  }
}
function _is_lame_global_flags_valid($gfp) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($gfp | 0) == 0;
    if ($1) {
      var $_0 = 0;
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $gfp | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) == -487877;
    var $_ = $5 & 1;
    var $_0 = $_;
    label = 4;
    break;
   case 4:
    var $_0;
    return $_0;
  }
}
function _is_lame_internal_flags_valid($gfc) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($gfc | 0) == 0;
    if ($1) {
      var $_0 = 0;
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $gfc | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) == -487877;
    var $_ = $5 & 1;
    var $_0 = $_;
    label = 4;
    break;
   case 4:
    var $_0;
    return $_0;
  }
}
function _isSameLang($l1, $l2) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 4 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $d = __stackBase__;
    var $1 = $d | 0;
    _setLang($1, $l2);
    var $i_0 = 0;
    label = 3;
    break;
   case 3:
    var $i_0;
    var $3 = ($i_0 | 0) < 3;
    if ($3) {
      label = 4;
      break;
    } else {
      var $_0 = 1;
      label = 5;
      break;
    }
   case 4:
    var $5 = $l1 + $i_0 | 0;
    var $6 = HEAP8[$5];
    var $7 = $6 << 24 >> 24;
    var $8 = _tolower($7);
    var $9 = $d + $i_0 | 0;
    var $10 = HEAP8[$9];
    var $11 = $10 << 24 >> 24;
    var $12 = _tolower($11);
    var $sext = $8 << 24;
    var $13 = ($sext | 0) < 536870912;
    var $sext8 = $12 << 24;
    var $14 = ($sext8 | 0) < 536870912;
    var $_op = $8 << 24;
    var $sext9 = $13 ? 536870912 : $_op;
    var $_op11 = $12 << 24;
    var $sext10 = $14 ? 536870912 : $_op11;
    var $15 = ($sext9 | 0) == ($sext10 | 0);
    var $16 = $i_0 + 1 | 0;
    if ($15) {
      var $i_0 = $16;
      label = 3;
      break;
    } else {
      var $_0 = 0;
      label = 5;
      break;
    }
   case 5:
    var $_0;
    STACKTOP = __stackBase__;
    return $_0;
  }
}
function _setLang($dst, $src) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($src | 0) == 0;
    if ($1) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = HEAP8[$src];
    var $4 = $3 << 24 >> 24 == 0;
    if ($4) {
      label = 4;
      break;
    } else {
      var $i_018 = 0;
      var $9 = $3;
      label = 7;
      break;
    }
   case 4:
    HEAP8[$dst] = 88;
    var $6 = $dst + 1 | 0;
    HEAP8[$6] = 88;
    var $7 = $dst + 2 | 0;
    HEAP8[$7] = 88;
    label = 10;
    break;
   case 5:
    var $i_0_lcssa;
    var $8 = ($i_0_lcssa | 0) < 3;
    if ($8) {
      label = 9;
      break;
    } else {
      label = 10;
      break;
    }
   case 6:
    var $_pr = HEAP8[$src];
    var $i_018 = $15;
    var $9 = $_pr;
    label = 7;
    break;
   case 7:
    var $9;
    var $i_018;
    var $10 = $9 << 24 >> 24 == 0;
    if ($10) {
      var $i_0_lcssa = $i_018;
      label = 5;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    var $12 = $src + $i_018 | 0;
    var $13 = HEAP8[$12];
    var $14 = $dst + $i_018 | 0;
    HEAP8[$14] = $13;
    var $15 = $i_018 + 1 | 0;
    var $16 = ($15 | 0) > 2;
    var $or_cond = $16 | $1;
    if ($or_cond) {
      var $i_0_lcssa = $15;
      label = 5;
      break;
    } else {
      label = 6;
      break;
    }
   case 9:
    var $scevgep = $dst + $i_0_lcssa | 0;
    var $17 = 3 - $i_0_lcssa | 0;
    _memset($scevgep, 32, $17);
    label = 10;
    break;
   case 10:
    return;
  }
}
function _local_ucs2_strdup($dst, $src) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($dst | 0) == 0;
    if ($1) {
      var $_0 = 0;
      label = 8;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = HEAP32[$dst >> 2];
    var $4 = $3;
    _free($4);
    HEAP32[$dst >> 2] = 0;
    var $5 = ($src | 0) == 0;
    if ($5) {
      var $_0 = 0;
      label = 8;
      break;
    } else {
      var $n_0 = 0;
      label = 4;
      break;
    }
   case 4:
    var $n_0;
    var $6 = $src + ($n_0 << 1) | 0;
    var $7 = HEAP16[$6 >> 1];
    var $8 = $7 << 16 >> 16 == 0;
    var $9 = $n_0 + 1 | 0;
    if ($8) {
      label = 5;
      break;
    } else {
      var $n_0 = $9;
      label = 4;
      break;
    }
   case 5:
    var $11 = ($n_0 | 0) == 0;
    if ($11) {
      var $_0 = 0;
      label = 8;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    var $13 = $n_0 + 1 | 0;
    var $14 = _calloc($13, 2);
    var $15 = $14;
    HEAP32[$dst >> 2] = $15;
    var $16 = ($14 | 0) == 0;
    if ($16) {
      var $_0 = 0;
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    var $18 = $src;
    var $19 = $n_0 << 1;
    _memcpy($14, $18, $19);
    var $20 = HEAP32[$dst >> 2];
    var $21 = $20 + ($n_0 << 1) | 0;
    HEAP16[$21 >> 1] = 0;
    var $_0 = $n_0;
    label = 8;
    break;
   case 8:
    var $_0;
    return $_0;
  }
}
function _maybeLatin1($text) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($text | 0) == 0;
    if ($1) {
      var $_0 = 1;
      label = 6;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = HEAP16[$text >> 1];
    var $text_pn = $text;
    label = 4;
    break;
   case 4:
    var $text_pn;
    var $_05 = $text_pn + 2 | 0;
    var $5 = HEAP16[$_05 >> 1];
    var $6 = $5 << 16 >> 16 == 0;
    if ($6) {
      var $_0 = 1;
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $8 = _toLittleEndian($3, $5);
    var $9 = ($8 & 65535) > 254;
    if ($9) {
      var $_0 = 0;
      label = 6;
      break;
    } else {
      var $text_pn = $_05;
      label = 4;
      break;
    }
   case 6:
    var $_0;
    return $_0;
  }
}
function _local_strdup_utf16_to_latin1($utf16) {
  var $1 = _local_ucs2_strlen($utf16);
  var $3 = _calloc($1 + 1 | 0, 1);
  _writeLoBytes($3, $utf16, $1);
  return $3;
}
function _lame_init_params($gfp) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 8 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $lowpass = __stackBase__;
    var $1 = $gfp + 288 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $2 + 16 | 0;
    var $4 = $2 | 0;
    HEAP32[$4 >> 2] = 0;
    var $5 = $gfp + 180 | 0;
    var $6 = HEAP32[$5 >> 2];
    var $7 = $2 + 124 | 0;
    HEAP32[$7 >> 2] = $6;
    var $8 = $gfp + 32 | 0;
    var $9 = HEAP32[$8 >> 2];
    var $10 = $2 + 140 | 0;
    HEAP32[$10 >> 2] = $9;
    var $11 = ($9 | 0) == 0;
    if ($11) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $13 = $gfp + 36 | 0;
    HEAP32[$13 >> 2] = 0;
    label = 4;
    break;
   case 4:
    var $15 = $2 + 85800 | 0;
    var $16 = HEAP32[$15 >> 2];
    var $17 = ($16 | 0) == 0;
    if ($17) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $19 = $gfp + 36 | 0;
    HEAP32[$19 >> 2] = 0;
    label = 6;
    break;
   case 6:
    var $21 = $gfp + 272 | 0;
    var $22 = HEAP32[$21 >> 2];
    var $23 = $2 + 85824 | 0;
    HEAP32[$23 >> 2] = $22;
    var $24 = $gfp + 276 | 0;
    var $25 = HEAP32[$24 >> 2];
    var $26 = $2 + 85828 | 0;
    HEAP32[$26 >> 2] = $25;
    var $27 = $gfp + 280 | 0;
    var $28 = HEAP32[$27 >> 2];
    var $29 = $2 + 85832 | 0;
    HEAP32[$29 >> 2] = $28;
    var $30 = $2 + 85752 | 0;
    var $31 = $30;
    var $32 = HEAP32[$31 >> 2];
    var $33 = $32 & -3;
    HEAP32[$31 >> 2] = $33;
    var $34 = $2 + 85752 | 0;
    var $35 = $34;
    var $36 = HEAP32[$35 >> 2];
    var $37 = $36 & -2;
    HEAP32[$35 >> 2] = $37;
    var $38 = $2 + 85752 | 0;
    var $39 = $38;
    var $40 = HEAP32[$39 >> 2];
    var $storemerge608 = $40 & -13;
    HEAP32[$39 >> 2] = $storemerge608;
    var $41 = $2 + 85792 | 0;
    var $42 = HEAP32[$41 >> 2];
    var $43 = ($42 | 0) == 0;
    if ($43) {
      label = 7;
      break;
    } else {
      label = 8;
      break;
    }
   case 7:
    var $45 = _calloc(1, 2772);
    var $46 = $45;
    HEAP32[$41 >> 2] = $46;
    var $47 = ($45 | 0) == 0;
    if ($47) {
      var $_0 = -2;
      label = 202;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    var $48 = $2 + 85672 | 0;
    var $49 = HEAP32[$48 >> 2];
    var $50 = ($49 | 0) == 0;
    if ($50) {
      label = 9;
      break;
    } else {
      label = 11;
      break;
    }
   case 9:
    var $52 = _calloc(1, 134792);
    var $53 = $52;
    HEAP32[$48 >> 2] = $53;
    var $54 = ($52 | 0) == 0;
    if ($54) {
      label = 10;
      break;
    } else {
      label = 11;
      break;
    }
   case 10:
    _freegfc($2);
    HEAP32[$1 >> 2] = 0;
    var $_0 = -2;
    label = 202;
    break;
   case 11:
    var $56 = $gfp + 120 | 0;
    var $57 = HEAP32[$56 >> 2];
    var $58 = $2 + 160 | 0;
    HEAP32[$58 >> 2] = $57;
    var $59 = $gfp + 104 | 0;
    var $60 = HEAP32[$59 >> 2];
    var $61 = $2 + 164 | 0;
    HEAP32[$61 >> 2] = $60;
    var $62 = $gfp + 108 | 0;
    var $63 = HEAP32[$62 >> 2];
    var $64 = $2 + 168 | 0;
    HEAP32[$64 >> 2] = $63;
    var $65 = $gfp + 112 | 0;
    var $66 = HEAP32[$65 >> 2];
    var $67 = $2 + 172 | 0;
    HEAP32[$67 >> 2] = $66;
    var $68 = $gfp + 116 | 0;
    var $69 = HEAP32[$68 >> 2];
    var $70 = $2 + 176 | 0;
    HEAP32[$70 >> 2] = $69;
    var $71 = $gfp + 8 | 0;
    var $72 = HEAP32[$71 >> 2];
    var $73 = $2 + 68 | 0;
    HEAP32[$73 >> 2] = $72;
    var $74 = ($72 | 0) == 1;
    if ($74) {
      label = 12;
      break;
    } else {
      label = 13;
      break;
    }
   case 12:
    var $76 = $gfp + 48 | 0;
    HEAP32[$76 >> 2] = 3;
    label = 13;
    break;
   case 13:
    var $78 = $gfp + 48 | 0;
    var $79 = HEAP32[$78 >> 2];
    var $80 = ($79 | 0) == 3;
    var $81 = $80 ? 1 : 2;
    var $82 = $2 + 72 | 0;
    HEAP32[$82 >> 2] = $81;
    var $83 = HEAP32[$78 >> 2];
    var $84 = ($83 | 0) == 3;
    if ($84) {
      label = 14;
      break;
    } else {
      label = 15;
      break;
    }
   case 14:
    var $86 = $gfp + 52 | 0;
    HEAP32[$86 >> 2] = 0;
    label = 15;
    break;
   case 15:
    var $88 = $gfp + 52 | 0;
    var $89 = HEAP32[$88 >> 2];
    var $90 = $2 + 80 | 0;
    HEAP32[$90 >> 2] = $89;
    var $91 = $gfp + 156 | 0;
    var $92 = HEAP32[$91 >> 2];
    var $93 = ($92 | 0) == 0;
    if ($93) {
      label = 16;
      break;
    } else {
      var $104 = $92;
      label = 20;
      break;
    }
   case 16:
    var $95 = $gfp + 168 | 0;
    var $96 = HEAP32[$95 >> 2];
    var $97 = ($96 | 0) == 128;
    if ($97) {
      label = 19;
      break;
    } else {
      label = 17;
      break;
    }
   case 17:
    var $99 = $gfp + 96 | 0;
    var $100 = HEAP32[$99 >> 2];
    var $101 = ($100 | 0) == 0;
    if ($101) {
      label = 18;
      break;
    } else {
      label = 19;
      break;
    }
   case 18:
    HEAP32[$99 >> 2] = $96;
    label = 19;
    break;
   case 19:
    var $_pr = HEAP32[$91 >> 2];
    var $104 = $_pr;
    label = 20;
    break;
   case 20:
    var $104;
    if (($104 | 0) == 0 | ($104 | 0) == 4 | ($104 | 0) == 1) {
      label = 22;
      break;
    } else {
      label = 21;
      break;
    }
   case 21:
    var $106 = $gfp + 56 | 0;
    HEAP32[$106 >> 2] = 0;
    label = 22;
    break;
   case 22:
    var $108 = $gfp + 56 | 0;
    var $109 = HEAP32[$108 >> 2];
    var $110 = $2 + 152 | 0;
    HEAP32[$110 >> 2] = $109;
    var $111 = HEAP32[$91 >> 2];
    var $112 = ($111 | 0) == 0;
    if ($112) {
      label = 23;
      break;
    } else {
      label = 34;
      break;
    }
   case 23:
    var $114 = $gfp + 96 | 0;
    var $115 = HEAP32[$114 >> 2];
    var $116 = ($115 | 0) == 0;
    if ($116) {
      label = 24;
      break;
    } else {
      label = 28;
      break;
    }
   case 24:
    var $118 = $gfp + 100 | 0;
    var $119 = HEAPF32[$118 >> 2];
    var $120 = $119 == 0;
    if ($120) {
      label = 26;
      break;
    } else {
      label = 25;
      break;
    }
   case 25:
    var $fabsf = Math.abs($119);
    var $122 = $fabsf;
    var $123 = $122 * 9.999999974752427e-7;
    var $124 = $122 > $123;
    if ($124) {
      label = 28;
      break;
    } else {
      label = 27;
      break;
    }
   case 26:
    var $126 = $119 == 0;
    if ($126) {
      label = 27;
      break;
    } else {
      label = 28;
      break;
    }
   case 27:
    HEAPF32[$118 >> 2] = 11.024999618530273;
    label = 28;
    break;
   case 28:
    var $_pr596 = HEAP32[$91 >> 2];
    var $129 = ($_pr596 | 0) == 0;
    if ($129) {
      label = 29;
      break;
    } else {
      label = 34;
      break;
    }
   case 29:
    var $131 = $gfp + 100 | 0;
    var $132 = HEAPF32[$131 >> 2];
    var $133 = $132 > 0;
    if ($133) {
      label = 30;
      break;
    } else {
      label = 34;
      break;
    }
   case 30:
    var $135 = $gfp + 16 | 0;
    var $136 = HEAP32[$135 >> 2];
    var $137 = ($136 | 0) == 0;
    if ($137) {
      label = 31;
      break;
    } else {
      label = 32;
      break;
    }
   case 31:
    var $139 = $gfp + 12 | 0;
    var $140 = HEAP32[$139 >> 2];
    var $141 = $140 | 0;
    var $142 = $141 * .97;
    var $143 = $142 & -1;
    var $144 = _map2MP3Frequency($143);
    HEAP32[$135 >> 2] = $144;
    label = 32;
    break;
   case 32:
    var $146 = HEAP32[$135 >> 2];
    var $147 = $146 << 4;
    var $148 = HEAP32[$82 >> 2];
    var $149 = $147 * $148 & -1;
    var $150 = $149 | 0;
    var $151 = HEAPF32[$131 >> 2];
    var $152 = $151;
    var $153 = $152 * 1e3;
    var $154 = $150 / $153;
    var $155 = $154 & -1;
    var $156 = $gfp + 96 | 0;
    HEAP32[$156 >> 2] = $155;
    var $157 = HEAP32[$135 >> 2];
    var $158 = $3 | 0;
    var $159 = _SmpFrqIndex($157, $158);
    var $160 = $2 + 20 | 0;
    HEAP32[$160 >> 2] = $159;
    var $161 = HEAP32[$110 >> 2];
    var $162 = ($161 | 0) == 0;
    if ($162) {
      label = 33;
      break;
    } else {
      label = 34;
      break;
    }
   case 33:
    var $164 = HEAP32[$156 >> 2];
    var $165 = HEAP32[$158 >> 2];
    var $166 = HEAP32[$135 >> 2];
    var $167 = _FindNearestBitrate($164, $165, $166);
    HEAP32[$156 >> 2] = $167;
    label = 34;
    break;
   case 34:
    var $168 = $gfp + 16 | 0;
    var $169 = HEAP32[$168 >> 2];
    var $170 = ($169 | 0) == 0;
    if ($170) {
      label = 41;
      break;
    } else {
      label = 35;
      break;
    }
   case 35:
    var $172 = ($169 | 0) < 16e3;
    if ($172) {
      label = 36;
      break;
    } else {
      label = 37;
      break;
    }
   case 36:
    var $174 = $gfp + 168 | 0;
    var $175 = HEAP32[$174 >> 2];
    var $176 = ($175 | 0) > 8;
    var $_ = $176 ? $175 : 8;
    var $177 = ($_ | 0) < 64;
    var $178 = $177 ? $_ : 64;
    HEAP32[$174 >> 2] = $178;
    label = 40;
    break;
   case 37:
    var $180 = ($169 | 0) < 32e3;
    var $181 = $gfp + 168 | 0;
    var $182 = HEAP32[$181 >> 2];
    if ($180) {
      label = 38;
      break;
    } else {
      label = 39;
      break;
    }
   case 38:
    var $184 = ($182 | 0) > 8;
    var $_587 = $184 ? $182 : 8;
    var $185 = ($_587 | 0) < 160;
    var $186 = $185 ? $_587 : 160;
    HEAP32[$181 >> 2] = $186;
    label = 40;
    break;
   case 39:
    var $188 = ($182 | 0) > 32;
    var $_588 = $188 ? $182 : 32;
    var $189 = ($_588 | 0) < 320;
    var $190 = $189 ? $_588 : 320;
    HEAP32[$181 >> 2] = $190;
    label = 40;
    break;
   case 40:
    var $_pr599 = HEAP32[$168 >> 2];
    var $192 = ($_pr599 | 0) == 0;
    if ($192) {
      label = 41;
      break;
    } else {
      label = 52;
      break;
    }
   case 41:
    var $193 = HEAP32[$91 >> 2];
    if (($193 | 0) == 1 | ($193 | 0) == 4) {
      label = 42;
      break;
    } else {
      label = 52;
      break;
    }
   case 42:
    var $195 = $gfp + 164 | 0;
    var $196 = HEAP32[$195 >> 2];
    var $197 = $196 | 0;
    var $198 = $gfp + 160 | 0;
    var $199 = HEAPF32[$198 >> 2];
    var $200 = $197 + $199;
    var $201 = $gfp + 12 | 0;
    var $i_0620 = 2;
    label = 43;
    break;
   case 43:
    var $i_0620;
    var $203 = HEAP32[$201 >> 2];
    var $204 = 5317672 + $i_0620 * 24 | 0;
    var $205 = HEAP32[$204 >> 2];
    var $206 = ($203 | 0) == ($205 | 0);
    if ($206) {
      label = 44;
      break;
    } else {
      label = 46;
      break;
    }
   case 44:
    var $208 = 5317676 + $i_0620 * 24 | 0;
    var $209 = HEAPF32[$208 >> 2];
    var $210 = $200 < $209;
    if ($210) {
      label = 45;
      break;
    } else {
      label = 46;
      break;
    }
   case 45:
    var $212 = $200 / $209;
    var $213 = $212;
    var $214 = 5317684 + $i_0620 * 24 | 0;
    var $215 = HEAPF32[$214 >> 2];
    var $216 = $215;
    var $217 = $213 * $216;
    var $218 = $217 & -1;
    HEAP32[$195 >> 2] = $218;
    var $219 = $218 | 0;
    var $220 = $217 - $219;
    var $221 = $220;
    HEAPF32[$198 >> 2] = $221;
    label = 46;
    break;
   case 46:
    var $223 = HEAP32[$201 >> 2];
    var $224 = HEAP32[$204 >> 2];
    var $225 = ($223 | 0) < ($224 | 0);
    if ($225) {
      label = 51;
      break;
    } else {
      label = 47;
      break;
    }
   case 47:
    var $227 = 5317676 + $i_0620 * 24 | 0;
    var $228 = HEAPF32[$227 >> 2];
    var $229 = $228 > $200;
    if ($229) {
      label = 51;
      break;
    } else {
      label = 48;
      break;
    }
   case 48:
    var $231 = 5317680 + $i_0620 * 24 | 0;
    var $232 = HEAPF32[$231 >> 2];
    var $233 = $200 < $232;
    if ($233) {
      label = 49;
      break;
    } else {
      label = 51;
      break;
    }
   case 49:
    var $235 = $232 - $228;
    var $236 = 5317688 + $i_0620 * 24 | 0;
    var $237 = HEAPF32[$236 >> 2];
    var $238 = 5317684 + $i_0620 * 24 | 0;
    var $239 = HEAPF32[$238 >> 2];
    var $240 = $237 - $239;
    var $241 = $200 - $228;
    var $242 = $241 * $240;
    var $243 = $242 / $235;
    var $244 = $239 + $243;
    var $245 = $244;
    var $246 = $244 & -1;
    HEAP32[$195 >> 2] = $246;
    var $247 = $246 | 0;
    var $248 = $245 - $247;
    var $249 = $248;
    HEAPF32[$198 >> 2] = $249;
    var $250 = HEAP32[$204 >> 2];
    HEAP32[$168 >> 2] = $250;
    var $251 = $gfp + 184 | 0;
    var $252 = HEAP32[$251 >> 2];
    var $253 = ($252 | 0) == 0;
    if ($253) {
      label = 50;
      break;
    } else {
      label = 52;
      break;
    }
   case 50:
    HEAP32[$251 >> 2] = -1;
    label = 52;
    break;
   case 51:
    var $256 = $i_0620 + 1 | 0;
    var $257 = ($256 | 0) < 9;
    if ($257) {
      var $i_0620 = $256;
      label = 43;
      break;
    } else {
      label = 52;
      break;
    }
   case 52:
    var $258 = $gfp + 184 | 0;
    var $259 = HEAP32[$258 >> 2];
    var $260 = ($259 | 0) == 0;
    if ($260) {
      label = 53;
      break;
    } else {
      label = 69;
      break;
    }
   case 53:
    HEAPF64[tempDoublePtr >> 3] = 16e3, HEAP32[$lowpass >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$lowpass + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    var $262 = HEAP32[$91 >> 2];
    if (($262 | 0) == 0) {
      label = 54;
      break;
    } else if (($262 | 0) == 3) {
      label = 55;
      break;
    } else if (($262 | 0) == 2) {
      label = 56;
      break;
    } else if (($262 | 0) == 4 | ($262 | 0) == 1) {
      label = 59;
      break;
    } else {
      label = 62;
      break;
    }
   case 54:
    var $264 = $gfp + 96 | 0;
    var $265 = HEAP32[$264 >> 2];
    _optimum_bandwidth($lowpass, $265);
    label = 65;
    break;
   case 55:
    var $267 = $gfp + 168 | 0;
    var $268 = HEAP32[$267 >> 2];
    _optimum_bandwidth($lowpass, $268);
    label = 65;
    break;
   case 56:
    var $270 = $gfp + 164 | 0;
    var $271 = HEAP32[$270 >> 2];
    var $272 = $271 >>> 0 < 10;
    if ($272) {
      label = 57;
      break;
    } else {
      label = 58;
      break;
    }
   case 57:
    var $274 = 5317628 + ($271 << 2) | 0;
    var $275 = HEAP32[$274 >> 2];
    var $276 = $275 | 0;
    var $277 = $271 + 1 | 0;
    var $278 = 5317628 + ($277 << 2) | 0;
    var $279 = HEAP32[$278 >> 2];
    var $280 = $279 | 0;
    var $281 = $gfp + 160 | 0;
    var $282 = HEAPF32[$281 >> 2];
    var $283 = $282;
    var $284 = _linear_int($276, $280, $283);
    HEAPF64[tempDoublePtr >> 3] = $284, HEAP32[$lowpass >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$lowpass + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    label = 65;
    break;
   case 58:
    HEAPF64[tempDoublePtr >> 3] = 19500, HEAP32[$lowpass >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$lowpass + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    label = 65;
    break;
   case 59:
    var $287 = $gfp + 164 | 0;
    var $288 = HEAP32[$287 >> 2];
    var $289 = $288 >>> 0 < 10;
    if ($289) {
      label = 60;
      break;
    } else {
      label = 61;
      break;
    }
   case 60:
    var $291 = 5317584 + ($288 << 2) | 0;
    var $292 = HEAP32[$291 >> 2];
    var $293 = $292 | 0;
    var $294 = $288 + 1 | 0;
    var $295 = 5317584 + ($294 << 2) | 0;
    var $296 = HEAP32[$295 >> 2];
    var $297 = $296 | 0;
    var $298 = $gfp + 160 | 0;
    var $299 = HEAPF32[$298 >> 2];
    var $300 = $299;
    var $301 = _linear_int($293, $297, $300);
    HEAPF64[tempDoublePtr >> 3] = $301, HEAP32[$lowpass >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$lowpass + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    label = 65;
    break;
   case 61:
    HEAPF64[tempDoublePtr >> 3] = 21500, HEAP32[$lowpass >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$lowpass + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    label = 65;
    break;
   case 62:
    var $304 = $gfp + 164 | 0;
    var $305 = HEAP32[$304 >> 2];
    var $306 = $305 >>> 0 < 10;
    if ($306) {
      label = 63;
      break;
    } else {
      label = 64;
      break;
    }
   case 63:
    var $308 = 5317540 + ($305 << 2) | 0;
    var $309 = HEAP32[$308 >> 2];
    var $310 = $309 | 0;
    var $311 = $305 + 1 | 0;
    var $312 = 5317540 + ($311 << 2) | 0;
    var $313 = HEAP32[$312 >> 2];
    var $314 = $313 | 0;
    var $315 = $gfp + 160 | 0;
    var $316 = HEAPF32[$315 >> 2];
    var $317 = $316;
    var $318 = _linear_int($310, $314, $317);
    HEAPF64[tempDoublePtr >> 3] = $318, HEAP32[$lowpass >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$lowpass + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    label = 65;
    break;
   case 64:
    HEAPF64[tempDoublePtr >> 3] = 19500, HEAP32[$lowpass >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$lowpass + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    label = 65;
    break;
   case 65:
    var $321 = HEAP32[$78 >> 2];
    var $322 = ($321 | 0) == 3;
    if ($322) {
      label = 66;
      break;
    } else {
      label = 68;
      break;
    }
   case 66:
    var $324 = HEAP32[$91 >> 2];
    if (($324 | 0) == 0 | ($324 | 0) == 3) {
      label = 67;
      break;
    } else {
      label = 68;
      break;
    }
   case 67:
    var $326 = (HEAP32[tempDoublePtr >> 2] = HEAP32[$lowpass >> 2], HEAP32[tempDoublePtr + 4 >> 2] = HEAP32[$lowpass + 4 >> 2], HEAPF64[tempDoublePtr >> 3]);
    var $327 = $326 * 1.5;
    HEAPF64[tempDoublePtr >> 3] = $327, HEAP32[$lowpass >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$lowpass + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    label = 68;
    break;
   case 68:
    var $329 = (HEAP32[tempDoublePtr >> 2] = HEAP32[$lowpass >> 2], HEAP32[tempDoublePtr + 4 >> 2] = HEAP32[$lowpass + 4 >> 2], HEAPF64[tempDoublePtr >> 3]);
    var $330 = $329 & -1;
    HEAP32[$258 >> 2] = $330;
    label = 69;
    break;
   case 69:
    var $332 = HEAP32[$168 >> 2];
    var $333 = ($332 | 0) == 0;
    if ($333) {
      label = 70;
      break;
    } else {
      label = 73;
      break;
    }
   case 70:
    var $335 = HEAP32[$258 >> 2];
    var $336 = $335 << 1;
    var $337 = $gfp + 12 | 0;
    var $338 = HEAP32[$337 >> 2];
    var $339 = ($336 | 0) > ($338 | 0);
    if ($339) {
      label = 71;
      break;
    } else {
      label = 72;
      break;
    }
   case 71:
    var $341 = ($338 | 0) / 2 & -1;
    HEAP32[$258 >> 2] = $341;
    label = 72;
    break;
   case 72:
    var $343 = HEAP32[$258 >> 2];
    var $344 = HEAP32[$337 >> 2];
    var $345 = _optimum_samplefreq($343, $344);
    HEAP32[$168 >> 2] = $345;
    label = 73;
    break;
   case 73:
    var $347 = HEAP32[$91 >> 2];
    if (($347 | 0) == 1 | ($347 | 0) == 4) {
      label = 74;
      break;
    } else {
      label = 75;
      break;
    }
   case 74:
    var $349 = HEAP32[$258 >> 2];
    var $350 = ($349 | 0) > 24e3;
    var $_591 = $350 ? 24e3 : $349;
    var $storemerge = $_591;
    label = 76;
    break;
   case 75:
    var $352 = HEAP32[$258 >> 2];
    var $353 = ($352 | 0) > 20500;
    var $_592 = $353 ? 20500 : $352;
    var $storemerge = $_592;
    label = 76;
    break;
   case 76:
    var $storemerge;
    var $355 = HEAP32[$168 >> 2];
    var $356 = ($355 | 0) / 2 & -1;
    var $357 = ($356 | 0) < ($storemerge | 0);
    var $_storemerge = $357 ? $356 : $storemerge;
    HEAP32[$258 >> 2] = $_storemerge;
    var $358 = HEAP32[$91 >> 2];
    var $359 = ($358 | 0) == 0;
    if ($359) {
      label = 77;
      break;
    } else {
      var $374 = $358;
      label = 78;
      break;
    }
   case 77:
    var $361 = HEAP32[$168 >> 2];
    var $362 = $361 << 4;
    var $363 = HEAP32[$82 >> 2];
    var $364 = $362 * $363 & -1;
    var $365 = $364 | 0;
    var $366 = $gfp + 96 | 0;
    var $367 = HEAP32[$366 >> 2];
    var $368 = $367 | 0;
    var $369 = $368 * 1e3;
    var $370 = $365 / $369;
    var $371 = $370;
    var $372 = $gfp + 100 | 0;
    HEAPF32[$372 >> 2] = $371;
    var $_pr601 = HEAP32[$91 >> 2];
    var $374 = $_pr601;
    label = 78;
    break;
   case 78:
    var $374;
    var $375 = ($374 | 0) == 3;
    if ($375) {
      label = 79;
      break;
    } else {
      label = 80;
      break;
    }
   case 79:
    var $377 = HEAP32[$168 >> 2];
    var $378 = $377 << 4;
    var $379 = HEAP32[$82 >> 2];
    var $380 = $378 * $379 & -1;
    var $381 = $380 | 0;
    var $382 = $gfp + 168 | 0;
    var $383 = HEAP32[$382 >> 2];
    var $384 = $383 | 0;
    var $385 = $384 * 1e3;
    var $386 = $381 / $385;
    var $387 = $386;
    var $388 = $gfp + 100 | 0;
    HEAPF32[$388 >> 2] = $387;
    label = 80;
    break;
   case 80:
    var $390 = $gfp + 36 | 0;
    var $391 = HEAP32[$390 >> 2];
    var $392 = ($391 | 0) == 0;
    if ($392) {
      label = 81;
      break;
    } else {
      label = 82;
      break;
    }
   case 81:
    var $394 = $gfp + 60 | 0;
    HEAP32[$394 >> 2] = 0;
    var $395 = $gfp + 64 | 0;
    HEAP32[$395 >> 2] = 0;
    var $396 = $2 + 132 | 0;
    HEAP32[$396 >> 2] = 0;
    label = 82;
    break;
   case 82:
    var $398 = $gfp + 60 | 0;
    var $399 = HEAP32[$398 >> 2];
    var $400 = $2 + 128 | 0;
    HEAP32[$400 >> 2] = $399;
    var $401 = $gfp + 64 | 0;
    var $402 = HEAP32[$401 >> 2];
    var $403 = $2 + 136 | 0;
    HEAP32[$403 >> 2] = $402;
    var $404 = ($402 | 0) == 0;
    if ($404) {
      label = 84;
      break;
    } else {
      label = 83;
      break;
    }
   case 83:
    var $406 = $2 + 132 | 0;
    HEAP32[$406 >> 2] = 1;
    label = 84;
    break;
   case 84:
    var $408 = HEAP32[$400 >> 2];
    var $409 = ($408 | 0) == 0;
    if ($409) {
      label = 87;
      break;
    } else {
      label = 85;
      break;
    }
   case 85:
    var $411 = HEAP32[$48 >> 2];
    var $412 = HEAP32[$168 >> 2];
    var $413 = _InitGainAnalysis($411, $412);
    var $414 = ($413 | 0) == 0;
    if ($414) {
      label = 86;
      break;
    } else {
      label = 87;
      break;
    }
   case 86:
    _freegfc($2);
    HEAP32[$1 >> 2] = 0;
    var $_0 = -6;
    label = 202;
    break;
   case 87:
    var $417 = HEAP32[$403 >> 2];
    var $418 = ($417 | 0) == 0;
    if ($418) {
      label = 92;
      break;
    } else {
      label = 88;
      break;
    }
   case 88:
    var $420 = $gfp + 40 | 0;
    var $421 = HEAP32[$420 >> 2];
    var $422 = ($421 | 0) == 0;
    if ($422) {
      label = 89;
      break;
    } else {
      label = 92;
      break;
    }
   case 89:
    var $424 = $2 + 85804 | 0;
    var $425 = HEAP32[$424 >> 2];
    var $426 = ($425 | 0) == 0;
    if ($426) {
      label = 91;
      break;
    } else {
      label = 90;
      break;
    }
   case 90:
    var $428 = _hip_decode_exit($425);
    label = 91;
    break;
   case 91:
    var $430 = _hip_decode_init();
    HEAP32[$424 >> 2] = $430;
    var $431 = HEAP32[$27 >> 2];
    _hip_set_errorf($430, $431);
    var $432 = HEAP32[$424 >> 2];
    var $433 = HEAP32[$24 >> 2];
    _hip_set_debugf($432, $433);
    var $434 = HEAP32[$424 >> 2];
    var $435 = HEAP32[$21 >> 2];
    _hip_set_msgf($434, $435);
    label = 92;
    break;
   case 92:
    var $437 = $gfp + 128 | 0;
    var $438 = HEAP32[$437 >> 2];
    var $439 = $2 + 144 | 0;
    HEAP32[$439 >> 2] = $438;
    var $440 = HEAP32[$258 >> 2];
    var $441 = $2 + 52 | 0;
    HEAP32[$441 >> 2] = $440;
    var $442 = $gfp + 188 | 0;
    var $443 = HEAP32[$442 >> 2];
    var $444 = $2 + 56 | 0;
    HEAP32[$444 >> 2] = $443;
    var $445 = $gfp + 12 | 0;
    var $446 = HEAP32[$445 >> 2];
    var $447 = $2 + 60 | 0;
    HEAP32[$447 >> 2] = $446;
    var $448 = HEAP32[$168 >> 2];
    var $449 = $2 + 64 | 0;
    HEAP32[$449 >> 2] = $448;
    var $450 = ($448 | 0) < 24001;
    var $451 = $450 ? 1 : 2;
    var $452 = $2 + 76 | 0;
    HEAP32[$452 >> 2] = $451;
    var $453 = $2 + 84756 | 0;
    HEAP32[$453 >> 2] = 576;
    var $454 = HEAP32[$91 >> 2];
    if (($454 | 0) == 1 | ($454 | 0) == 2 | ($454 | 0) == 4) {
      label = 93;
      break;
    } else if (($454 | 0) == 3) {
      label = 94;
      break;
    } else {
      label = 95;
      break;
    }
   case 93:
    var $456 = $gfp + 164 | 0;
    var $457 = HEAP32[$456 >> 2];
    var $458 = 5317888 + ($457 << 2) | 0;
    var $459 = HEAPF32[$458 >> 2];
    var $460 = $gfp + 100 | 0;
    HEAPF32[$460 >> 2] = $459;
    label = 96;
    break;
   case 94:
    var $462 = HEAP32[$449 >> 2];
    var $463 = $462 << 4;
    var $464 = HEAP32[$82 >> 2];
    var $465 = $463 * $464 & -1;
    var $466 = $465 | 0;
    var $467 = $gfp + 168 | 0;
    var $468 = HEAP32[$467 >> 2];
    var $469 = $468 | 0;
    var $470 = $469 * 1e3;
    var $471 = $466 / $470;
    var $472 = $471;
    var $473 = $gfp + 100 | 0;
    HEAPF32[$473 >> 2] = $472;
    label = 96;
    break;
   case 95:
    var $475 = HEAP32[$449 >> 2];
    var $476 = $475 << 4;
    var $477 = HEAP32[$82 >> 2];
    var $478 = $476 * $477 & -1;
    var $479 = $478 | 0;
    var $480 = $gfp + 96 | 0;
    var $481 = HEAP32[$480 >> 2];
    var $482 = $481 | 0;
    var $483 = $482 * 1e3;
    var $484 = $479 / $483;
    var $485 = $484;
    var $486 = $gfp + 100 | 0;
    HEAPF32[$486 >> 2] = $485;
    label = 96;
    break;
   case 96:
    var $488 = HEAP32[$78 >> 2];
    var $489 = ($488 | 0) == 4;
    if ($489) {
      label = 97;
      break;
    } else {
      label = 98;
      break;
    }
   case 97:
    HEAP32[$78 >> 2] = 1;
    label = 98;
    break;
   case 98:
    var $492 = HEAP32[$78 >> 2];
    var $493 = $2 + 180 | 0;
    HEAP32[$493 >> 2] = $492;
    var $494 = HEAP32[$444 >> 2];
    var $495 = ($494 | 0) > 0;
    if ($495) {
      label = 99;
      break;
    } else {
      label = 103;
      break;
    }
   case 99:
    var $497 = $494 | 0;
    var $498 = $497 * 2;
    var $499 = $498;
    var $500 = $2 + 256 | 0;
    HEAPF32[$500 >> 2] = $499;
    var $501 = $gfp + 196 | 0;
    var $502 = HEAP32[$501 >> 2];
    var $503 = ($502 | 0) > -1;
    var $504 = HEAP32[$444 >> 2];
    if ($503) {
      label = 100;
      break;
    } else {
      label = 101;
      break;
    }
   case 100:
    var $506 = $504 + $502 | 0;
    var $507 = $506 | 0;
    var $508 = $507 * 2;
    var $509 = $508;
    var $510 = $2 + 260 | 0;
    HEAPF32[$510 >> 2] = $509;
    label = 102;
    break;
   case 101:
    var $512 = $504 | 0;
    var $513 = $512 * 2;
    var $514 = $513;
    var $515 = $2 + 260 | 0;
    HEAPF32[$515 >> 2] = $514;
    label = 102;
    break;
   case 102:
    var $517 = HEAP32[$449 >> 2];
    var $518 = $517 | 0;
    var $519 = HEAPF32[$500 >> 2];
    var $520 = $519 / $518;
    HEAPF32[$500 >> 2] = $520;
    var $521 = HEAP32[$449 >> 2];
    var $522 = $521 | 0;
    var $523 = $2 + 260 | 0;
    var $524 = HEAPF32[$523 >> 2];
    var $525 = $524 / $522;
    HEAPF32[$523 >> 2] = $525;
    label = 104;
    break;
   case 103:
    var $527 = $2 + 256 | 0;
    HEAPF32[$527 >> 2] = 0;
    var $528 = $2 + 260 | 0;
    HEAPF32[$528 >> 2] = 0;
    label = 104;
    break;
   case 104:
    var $530 = $2 + 248 | 0;
    HEAPF32[$530 >> 2] = 0;
    var $531 = $2 + 252 | 0;
    HEAPF32[$531 >> 2] = 0;
    var $532 = HEAP32[$441 >> 2];
    var $533 = ($532 | 0) > 0;
    if ($533) {
      label = 105;
      break;
    } else {
      label = 111;
      break;
    }
   case 105:
    var $535 = HEAP32[$449 >> 2];
    var $536 = ($535 | 0) / 2 & -1;
    var $537 = ($532 | 0) < ($536 | 0);
    if ($537) {
      label = 106;
      break;
    } else {
      label = 111;
      break;
    }
   case 106:
    var $539 = $532 | 0;
    var $540 = $539 * 2;
    var $541 = $540;
    HEAPF32[$531 >> 2] = $541;
    var $542 = $gfp + 192 | 0;
    var $543 = HEAP32[$542 >> 2];
    var $544 = ($543 | 0) > -1;
    var $545 = HEAP32[$441 >> 2];
    if ($544) {
      label = 107;
      break;
    } else {
      label = 109;
      break;
    }
   case 107:
    var $547 = $545 - $543 | 0;
    var $548 = $547 | 0;
    var $549 = $548 * 2;
    var $550 = $549;
    HEAPF32[$530 >> 2] = $550;
    var $551 = $550 < 0;
    if ($551) {
      label = 108;
      break;
    } else {
      label = 110;
      break;
    }
   case 108:
    HEAPF32[$530 >> 2] = 0;
    label = 110;
    break;
   case 109:
    var $554 = $545 | 0;
    var $555 = $554 * 2;
    var $556 = $555;
    HEAPF32[$530 >> 2] = $556;
    label = 110;
    break;
   case 110:
    var $558 = HEAP32[$449 >> 2];
    var $559 = $558 | 0;
    var $560 = HEAPF32[$530 >> 2];
    var $561 = $560 / $559;
    HEAPF32[$530 >> 2] = $561;
    var $562 = HEAP32[$449 >> 2];
    var $563 = $562 | 0;
    var $564 = HEAPF32[$531 >> 2];
    var $565 = $564 / $563;
    HEAPF32[$531 >> 2] = $565;
    label = 111;
    break;
   case 111:
    _lame_init_params_ppflt($2);
    var $567 = HEAP32[$449 >> 2];
    var $568 = $3 | 0;
    var $569 = _SmpFrqIndex($567, $568);
    var $570 = $2 + 20 | 0;
    HEAP32[$570 >> 2] = $569;
    var $571 = ($569 | 0) < 0;
    if ($571) {
      label = 112;
      break;
    } else {
      label = 113;
      break;
    }
   case 112:
    _freegfc($2);
    HEAP32[$1 >> 2] = 0;
    var $_0 = -1;
    label = 202;
    break;
   case 113:
    var $574 = HEAP32[$91 >> 2];
    var $575 = ($574 | 0) == 0;
    if ($575) {
      label = 114;
      break;
    } else {
      label = 118;
      break;
    }
   case 114:
    var $577 = HEAP32[$110 >> 2];
    var $578 = ($577 | 0) == 0;
    if ($578) {
      label = 116;
      break;
    } else {
      label = 115;
      break;
    }
   case 115:
    var $580 = $2 + 84740 | 0;
    HEAP32[$580 >> 2] = 0;
    label = 119;
    break;
   case 116:
    var $582 = $gfp + 96 | 0;
    var $583 = HEAP32[$582 >> 2];
    var $584 = HEAP32[$568 >> 2];
    var $585 = HEAP32[$449 >> 2];
    var $586 = _FindNearestBitrate($583, $584, $585);
    HEAP32[$582 >> 2] = $586;
    var $587 = HEAP32[$568 >> 2];
    var $588 = HEAP32[$449 >> 2];
    var $589 = _BitrateIndex($586, $587, $588);
    var $590 = $2 + 84740 | 0;
    HEAP32[$590 >> 2] = $589;
    var $591 = ($589 | 0) < 1;
    if ($591) {
      label = 117;
      break;
    } else {
      label = 119;
      break;
    }
   case 117:
    _freegfc($2);
    HEAP32[$1 >> 2] = 0;
    var $_0 = -1;
    label = 202;
    break;
   case 118:
    var $594 = $2 + 84740 | 0;
    HEAP32[$594 >> 2] = 1;
    label = 119;
    break;
   case 119:
    _init_bit_stream_w($2);
    var $596 = HEAP32[$570 >> 2];
    var $597 = HEAP32[$568 >> 2];
    var $598 = $597 * 3 & -1;
    var $599 = $598 + $596 | 0;
    var $600 = HEAP32[$449 >> 2];
    var $601 = ($600 | 0) < 16e3;
    var $602 = $601 & 1;
    var $603 = -$602 | 0;
    var $604 = $603 & 6;
    var $605 = $599 + $604 | 0;
    var $i_1616 = 0;
    label = 120;
    break;
   case 120:
    var $i_1616;
    var $607 = 5254748 + $605 * 204 + ($i_1616 << 2) | 0;
    var $608 = HEAP32[$607 >> 2];
    var $609 = $2 + 21360 + ($i_1616 << 2) | 0;
    HEAP32[$609 >> 2] = $608;
    var $610 = $i_1616 + 1 | 0;
    var $exitcond625 = ($610 | 0) == 23;
    if ($exitcond625) {
      label = 121;
      break;
    } else {
      var $i_1616 = $610;
      label = 120;
      break;
    }
   case 121:
    var $612 = $2 + 21448 | 0;
    var $613 = $2 + 21444 | 0;
    var $614 = HEAP32[$613 >> 2];
    var $615 = $2 + 21508 | 0;
    HEAP32[$615 >> 2] = $614;
    var $616 = HEAP32[$612 >> 2];
    var $617 = HEAP32[$613 >> 2];
    var $618 = $616 - $617 | 0;
    var $619 = ($618 | 0) / 6 & -1;
    var $620 = $619 + $617 | 0;
    var $621 = $2 + 21512 | 0;
    HEAP32[$621 >> 2] = $620;
    var $622 = HEAP32[$612 >> 2];
    var $623 = HEAP32[$613 >> 2];
    var $624 = $622 - $623 | 0;
    var $625 = ($624 | 0) / 6 & -1;
    var $626 = $625 << 1;
    var $627 = $626 + $623 | 0;
    var $628 = $2 + 21516 | 0;
    HEAP32[$628 >> 2] = $627;
    var $629 = HEAP32[$612 >> 2];
    var $630 = HEAP32[$613 >> 2];
    var $631 = $629 - $630 | 0;
    var $632 = ($631 | 0) / 6 & -1;
    var $633 = $632 * 3 & -1;
    var $634 = $633 + $630 | 0;
    var $635 = $2 + 21520 | 0;
    HEAP32[$635 >> 2] = $634;
    var $636 = HEAP32[$612 >> 2];
    var $637 = HEAP32[$613 >> 2];
    var $638 = $636 - $637 | 0;
    var $639 = ($638 | 0) / 6 & -1;
    var $640 = $639 << 2;
    var $641 = $640 + $637 | 0;
    var $642 = $2 + 21524 | 0;
    HEAP32[$642 >> 2] = $641;
    var $643 = HEAP32[$612 >> 2];
    var $644 = HEAP32[$613 >> 2];
    var $645 = $643 - $644 | 0;
    var $646 = ($645 | 0) / 6 & -1;
    var $647 = $646 * 5 & -1;
    var $648 = $647 + $644 | 0;
    var $649 = $2 + 21528 | 0;
    HEAP32[$649 >> 2] = $648;
    var $650 = $2 + 21532 | 0;
    HEAP32[$650 >> 2] = 576;
    var $651 = 5254840 + $605 * 204 | 0;
    var $652 = HEAP32[$651 >> 2];
    var $653 = $2 + 21452 | 0;
    HEAP32[$653 >> 2] = $652;
    var $654 = 5254844 + $605 * 204 | 0;
    var $655 = HEAP32[$654 >> 2];
    var $656 = $2 + 21456 | 0;
    HEAP32[$656 >> 2] = $655;
    var $657 = 5254848 + $605 * 204 | 0;
    var $658 = HEAP32[$657 >> 2];
    var $659 = $2 + 21460 | 0;
    HEAP32[$659 >> 2] = $658;
    var $660 = 5254852 + $605 * 204 | 0;
    var $661 = HEAP32[$660 >> 2];
    var $662 = $2 + 21464 | 0;
    HEAP32[$662 >> 2] = $661;
    var $663 = 5254856 + $605 * 204 | 0;
    var $664 = HEAP32[$663 >> 2];
    var $665 = $2 + 21468 | 0;
    HEAP32[$665 >> 2] = $664;
    var $666 = 5254860 + $605 * 204 | 0;
    var $667 = HEAP32[$666 >> 2];
    var $668 = $2 + 21472 | 0;
    HEAP32[$668 >> 2] = $667;
    var $669 = 5254864 + $605 * 204 | 0;
    var $670 = HEAP32[$669 >> 2];
    var $671 = $2 + 21476 | 0;
    HEAP32[$671 >> 2] = $670;
    var $672 = 5254868 + $605 * 204 | 0;
    var $673 = HEAP32[$672 >> 2];
    var $674 = $2 + 21480 | 0;
    HEAP32[$674 >> 2] = $673;
    var $675 = 5254872 + $605 * 204 | 0;
    var $676 = HEAP32[$675 >> 2];
    var $677 = $2 + 21484 | 0;
    HEAP32[$677 >> 2] = $676;
    var $678 = 5254876 + $605 * 204 | 0;
    var $679 = HEAP32[$678 >> 2];
    var $680 = $2 + 21488 | 0;
    HEAP32[$680 >> 2] = $679;
    var $681 = 5254880 + $605 * 204 | 0;
    var $682 = HEAP32[$681 >> 2];
    var $683 = $2 + 21492 | 0;
    HEAP32[$683 >> 2] = $682;
    var $684 = 5254884 + $605 * 204 | 0;
    var $685 = HEAP32[$684 >> 2];
    var $686 = $2 + 21496 | 0;
    HEAP32[$686 >> 2] = $685;
    var $687 = 5254888 + $605 * 204 | 0;
    var $688 = HEAP32[$687 >> 2];
    var $689 = $2 + 21500 | 0;
    HEAP32[$689 >> 2] = $688;
    var $690 = 5254892 + $605 * 204 | 0;
    var $691 = HEAP32[$690 >> 2];
    var $692 = $2 + 21504 | 0;
    HEAP32[$692 >> 2] = $691;
    var $693 = $2 + 21504 | 0;
    var $694 = $2 + 21500 | 0;
    var $695 = HEAP32[$694 >> 2];
    var $696 = $2 + 21536 | 0;
    HEAP32[$696 >> 2] = $695;
    var $697 = HEAP32[$693 >> 2];
    var $698 = HEAP32[$694 >> 2];
    var $699 = $697 - $698 | 0;
    var $700 = ($699 | 0) / 6 & -1;
    var $701 = $700 + $698 | 0;
    var $702 = $2 + 21540 | 0;
    HEAP32[$702 >> 2] = $701;
    var $703 = HEAP32[$693 >> 2];
    var $704 = HEAP32[$694 >> 2];
    var $705 = $703 - $704 | 0;
    var $706 = ($705 | 0) / 6 & -1;
    var $707 = $706 << 1;
    var $708 = $707 + $704 | 0;
    var $709 = $2 + 21544 | 0;
    HEAP32[$709 >> 2] = $708;
    var $710 = HEAP32[$693 >> 2];
    var $711 = HEAP32[$694 >> 2];
    var $712 = $710 - $711 | 0;
    var $713 = ($712 | 0) / 6 & -1;
    var $714 = $713 * 3 & -1;
    var $715 = $714 + $711 | 0;
    var $716 = $2 + 21548 | 0;
    HEAP32[$716 >> 2] = $715;
    var $717 = HEAP32[$693 >> 2];
    var $718 = HEAP32[$694 >> 2];
    var $719 = $717 - $718 | 0;
    var $720 = ($719 | 0) / 6 & -1;
    var $721 = $720 << 2;
    var $722 = $721 + $718 | 0;
    var $723 = $2 + 21552 | 0;
    HEAP32[$723 >> 2] = $722;
    var $724 = HEAP32[$693 >> 2];
    var $725 = HEAP32[$694 >> 2];
    var $726 = $724 - $725 | 0;
    var $727 = ($726 | 0) / 6 & -1;
    var $728 = $727 * 5 & -1;
    var $729 = $728 + $725 | 0;
    var $730 = $2 + 21556 | 0;
    HEAP32[$730 >> 2] = $729;
    var $731 = $2 + 21560 | 0;
    HEAP32[$731 >> 2] = 192;
    var $732 = HEAP32[$452 >> 2];
    var $733 = ($732 | 0) == 2;
    var $734 = HEAP32[$82 >> 2];
    var $735 = ($734 | 0) == 1;
    if ($733) {
      label = 122;
      break;
    } else {
      label = 123;
      break;
    }
   case 122:
    var $737 = $735 ? 21 : 36;
    var $738 = $2 + 24 | 0;
    HEAP32[$738 >> 2] = $737;
    label = 124;
    break;
   case 123:
    var $740 = $735 ? 13 : 21;
    var $741 = $2 + 24 | 0;
    HEAP32[$741 >> 2] = $740;
    label = 124;
    break;
   case 124:
    var $743 = HEAP32[$58 >> 2];
    var $744 = ($743 | 0) == 0;
    if ($744) {
      label = 126;
      break;
    } else {
      label = 125;
      break;
    }
   case 125:
    var $746 = $2 + 24 | 0;
    var $747 = HEAP32[$746 >> 2];
    var $748 = $747 + 2 | 0;
    HEAP32[$746 >> 2] = $748;
    label = 126;
    break;
   case 126:
    HEAP32[$4 >> 2] = -487877;
    var $k_0611 = 0;
    label = 127;
    break;
   case 127:
    var $k_0611;
    var $751 = HEAP32[$452 >> 2];
    var $752 = $751 * 700 & -1;
    var $753 = HEAP32[$82 >> 2];
    var $754 = $752 * $753 & -1;
    var $755 = $754 | 0;
    var $756 = $2 + 39752 + ($k_0611 << 2) | 0;
    HEAPF32[$756 >> 2] = $755;
    var $757 = $k_0611 + 1 | 0;
    var $exitcond = ($757 | 0) == 19;
    if ($exitcond) {
      label = 128;
      break;
    } else {
      var $k_0611 = $757;
      label = 127;
      break;
    }
   case 128:
    var $759 = $gfp + 220 | 0;
    var $760 = HEAP32[$759 >> 2];
    var $761 = ($760 | 0) == -1;
    if ($761) {
      label = 129;
      break;
    } else {
      label = 130;
      break;
    }
   case 129:
    HEAP32[$759 >> 2] = 4;
    label = 130;
    break;
   case 130:
    var $764 = HEAP32[$91 >> 2];
    if (($764 | 0) == 1 | ($764 | 0) == 4) {
      label = 131;
      break;
    } else if (($764 | 0) == 2) {
      label = 145;
      break;
    } else {
      label = 153;
      break;
    }
   case 131:
    var $766 = $gfp + 124 | 0;
    var $767 = HEAP32[$766 >> 2];
    var $768 = ($767 | 0) < 0;
    if ($768) {
      label = 132;
      break;
    } else {
      label = 133;
      break;
    }
   case 132:
    HEAP32[$766 >> 2] = 2;
    label = 133;
    break;
   case 133:
    var $771 = $gfp + 244 | 0;
    var $772 = HEAP32[$771 >> 2];
    var $773 = ($772 | 0) < 0;
    if ($773) {
      label = 134;
      break;
    } else {
      label = 135;
      break;
    }
   case 134:
    HEAP32[$771 >> 2] = 0;
    label = 135;
    break;
   case 135:
    var $776 = $gfp + 164 | 0;
    var $777 = HEAP32[$776 >> 2];
    var $778 = $777 * -10 & -1;
    var $779 = $778 + 500 | 0;
    var $780 = _apply_preset($gfp, $779, 0);
    var $781 = $gfp + 44 | 0;
    var $782 = HEAP32[$781 >> 2];
    var $783 = ($782 | 0) < 0;
    if ($783) {
      label = 136;
      break;
    } else {
      label = 137;
      break;
    }
   case 136:
    HEAP32[$781 >> 2] = 3;
    label = 138;
    break;
   case 137:
    var $785 = ($782 | 0) < 5;
    if ($785) {
      label = 138;
      break;
    } else {
      label = 139;
      break;
    }
   case 138:
    HEAP32[$781 >> 2] = 0;
    label = 141;
    break;
   case 139:
    var $_pr604 = HEAP32[$781 >> 2];
    var $787 = ($_pr604 | 0) > 7;
    if ($787) {
      label = 140;
      break;
    } else {
      label = 141;
      break;
    }
   case 140:
    HEAP32[$781 >> 2] = 7;
    label = 141;
    break;
   case 141:
    var $790 = $gfp + 140 | 0;
    var $791 = HEAP32[$790 >> 2];
    var $792 = ($791 | 0) == 0;
    if ($792) {
      label = 143;
      break;
    } else {
      label = 142;
      break;
    }
   case 142:
    var $794 = $2 + 85088 | 0;
    HEAP32[$794 >> 2] = 0;
    label = 144;
    break;
   case 143:
    var $796 = HEAP32[$449 >> 2];
    var $797 = ($796 | 0) > 44e3;
    var $798 = $797 & 1;
    var $799 = $2 + 85088 | 0;
    HEAP32[$799 >> 2] = $798;
    label = 144;
    break;
   case 144:
    var $801 = $2 + 85808 | 0;
    HEAP32[$801 >> 2] = 20;
    label = 160;
    break;
   case 145:
    var $803 = $gfp + 164 | 0;
    var $804 = HEAP32[$803 >> 2];
    var $805 = $804 * -10 & -1;
    var $806 = $805 + 500 | 0;
    var $807 = _apply_preset($gfp, $806, 0);
    var $808 = $gfp + 140 | 0;
    var $809 = HEAP32[$808 >> 2];
    var $810 = ($809 | 0) == 0;
    if ($810) {
      label = 147;
      break;
    } else {
      label = 146;
      break;
    }
   case 146:
    var $812 = $2 + 85088 | 0;
    HEAP32[$812 >> 2] = 0;
    label = 148;
    break;
   case 147:
    var $814 = HEAP32[$449 >> 2];
    var $815 = ($814 | 0) > 44e3;
    var $816 = $815 & 1;
    var $817 = $2 + 85088 | 0;
    HEAP32[$817 >> 2] = $816;
    label = 148;
    break;
   case 148:
    var $819 = $gfp + 44 | 0;
    var $820 = HEAP32[$819 >> 2];
    var $821 = ($820 | 0) > 6;
    if ($821) {
      label = 149;
      break;
    } else {
      label = 150;
      break;
    }
   case 149:
    HEAP32[$819 >> 2] = 6;
    label = 152;
    break;
   case 150:
    var $823 = ($820 | 0) < 0;
    if ($823) {
      label = 151;
      break;
    } else {
      label = 152;
      break;
    }
   case 151:
    HEAP32[$819 >> 2] = 3;
    label = 152;
    break;
   case 152:
    var $826 = $2 + 85808 | 0;
    HEAP32[$826 >> 2] = 14;
    label = 160;
    break;
   case 153:
    var $828 = $2 + 85088 | 0;
    HEAP32[$828 >> 2] = 0;
    var $829 = $gfp + 44 | 0;
    var $830 = HEAP32[$829 >> 2];
    var $831 = ($830 | 0) < 0;
    if ($831) {
      label = 154;
      break;
    } else {
      label = 155;
      break;
    }
   case 154:
    HEAP32[$829 >> 2] = 3;
    label = 155;
    break;
   case 155:
    var $834 = HEAP32[$91 >> 2];
    var $835 = ($834 | 0) == 0;
    if ($835) {
      label = 156;
      break;
    } else {
      label = 157;
      break;
    }
   case 156:
    var $837 = $gfp + 96 | 0;
    var $838 = HEAP32[$837 >> 2];
    var $839 = _lame_set_VBR_mean_bitrate_kbps($gfp, $838);
    label = 157;
    break;
   case 157:
    var $841 = $gfp + 168 | 0;
    var $842 = HEAP32[$841 >> 2];
    var $843 = _apply_preset($gfp, $842, 0);
    HEAP32[$91 >> 2] = $834;
    var $844 = $2 + 85808 | 0;
    if ($835) {
      label = 158;
      break;
    } else {
      label = 159;
      break;
    }
   case 158:
    HEAP32[$844 >> 2] = 26;
    label = 160;
    break;
   case 159:
    HEAP32[$844 >> 2] = 4;
    label = 160;
    break;
   case 160:
    var $848 = $gfp + 200 | 0;
    var $849 = HEAPF32[$848 >> 2];
    var $850 = $2 + 84908 | 0;
    HEAPF32[$850 >> 2] = $849;
    var $851 = $gfp + 204 | 0;
    var $852 = HEAPF32[$851 >> 2];
    var $853 = $2 + 84912 | 0;
    HEAPF32[$853 >> 2] = $852;
    var $854 = $gfp + 256 | 0;
    var $855 = HEAP32[$854 >> 2];
    var $856 = ($855 | 0) == 0;
    if ($856) {
      label = 162;
      break;
    } else {
      label = 161;
      break;
    }
   case 161:
    var $858 = $gfp + 260 | 0;
    var $859 = HEAPF32[$858 >> 2];
    var $860 = HEAPF32[$850 >> 2];
    var $861 = $859 + $860;
    HEAPF32[$850 >> 2] = $861;
    var $862 = HEAPF32[$858 >> 2];
    var $863 = HEAPF32[$853 >> 2];
    var $864 = $862 + $863;
    HEAPF32[$853 >> 2] = $864;
    label = 162;
    break;
   case 162:
    var $866 = HEAP32[$91 >> 2];
    var $867 = ($866 | 0) == 0;
    if ($867) {
      label = 170;
      break;
    } else {
      label = 163;
      break;
    }
   case 163:
    var $869 = $2 + 112 | 0;
    HEAP32[$869 >> 2] = 1;
    var $870 = $2 + 116 | 0;
    HEAP32[$870 >> 2] = 14;
    var $871 = HEAP32[$449 >> 2];
    var $872 = ($871 | 0) < 16e3;
    if ($872) {
      label = 164;
      break;
    } else {
      label = 165;
      break;
    }
   case 164:
    HEAP32[$870 >> 2] = 8;
    label = 165;
    break;
   case 165:
    var $875 = $gfp + 172 | 0;
    var $876 = HEAP32[$875 >> 2];
    var $877 = ($876 | 0) == 0;
    if ($877) {
      label = 167;
      break;
    } else {
      label = 166;
      break;
    }
   case 166:
    var $879 = HEAP32[$568 >> 2];
    var $880 = HEAP32[$449 >> 2];
    var $881 = _FindNearestBitrate($876, $879, $880);
    HEAP32[$875 >> 2] = $881;
    var $882 = HEAP32[$568 >> 2];
    var $883 = HEAP32[$449 >> 2];
    var $884 = _BitrateIndex($881, $882, $883);
    HEAP32[$869 >> 2] = $884;
    var $885 = ($884 | 0) < 0;
    if ($885) {
      var $_0 = -1;
      label = 202;
      break;
    } else {
      label = 167;
      break;
    }
   case 167:
    var $887 = $gfp + 176 | 0;
    var $888 = HEAP32[$887 >> 2];
    var $889 = ($888 | 0) == 0;
    if ($889) {
      label = 169;
      break;
    } else {
      label = 168;
      break;
    }
   case 168:
    var $891 = HEAP32[$568 >> 2];
    var $892 = HEAP32[$449 >> 2];
    var $893 = _FindNearestBitrate($888, $891, $892);
    HEAP32[$887 >> 2] = $893;
    var $894 = HEAP32[$568 >> 2];
    var $895 = HEAP32[$449 >> 2];
    var $896 = _BitrateIndex($893, $894, $895);
    HEAP32[$870 >> 2] = $896;
    var $897 = ($896 | 0) < 0;
    if ($897) {
      var $_0 = -1;
      label = 202;
      break;
    } else {
      label = 169;
      break;
    }
   case 169:
    var $899 = HEAP32[$869 >> 2];
    var $900 = HEAP32[$568 >> 2];
    var $901 = 5348684 + ($900 << 6) + ($899 << 2) | 0;
    var $902 = HEAP32[$901 >> 2];
    HEAP32[$875 >> 2] = $902;
    var $903 = HEAP32[$870 >> 2];
    var $904 = HEAP32[$568 >> 2];
    var $905 = 5348684 + ($904 << 6) + ($903 << 2) | 0;
    var $906 = HEAP32[$905 >> 2];
    HEAP32[$887 >> 2] = $906;
    var $907 = HEAP32[$870 >> 2];
    var $908 = HEAP32[$568 >> 2];
    var $909 = 5348684 + ($908 << 6) + ($907 << 2) | 0;
    var $910 = HEAP32[$909 >> 2];
    var $911 = $gfp + 168 | 0;
    var $912 = HEAP32[$911 >> 2];
    var $913 = ($910 | 0) < ($912 | 0);
    var $_593 = $913 ? $910 : $912;
    HEAP32[$911 >> 2] = $_593;
    var $914 = HEAP32[$869 >> 2];
    var $915 = HEAP32[$568 >> 2];
    var $916 = 5348684 + ($915 << 6) + ($914 << 2) | 0;
    var $917 = HEAP32[$916 >> 2];
    var $918 = ($917 | 0) > ($_593 | 0);
    var $919 = $918 ? $917 : $_593;
    HEAP32[$911 >> 2] = $919;
    label = 170;
    break;
   case 170:
    var $921 = $gfp + 152 | 0;
    var $922 = HEAP32[$921 >> 2];
    var $923 = $2 + 100 | 0;
    HEAP32[$923 >> 2] = $922;
    var $924 = HEAP32[$390 >> 2];
    var $925 = $2 + 156 | 0;
    HEAP32[$925 >> 2] = $924;
    var $926 = HEAP32[$91 >> 2];
    var $927 = $2 + 104 | 0;
    HEAP32[$927 >> 2] = $926;
    var $928 = $gfp + 80 | 0;
    var $929 = HEAP32[$928 >> 2];
    var $930 = $2 + 85092 | 0;
    HEAP32[$930 >> 2] = $929;
    var $931 = $gfp + 84 | 0;
    var $932 = HEAP32[$931 >> 2];
    var $933 = $2 + 28 | 0;
    HEAP32[$933 >> 2] = $932;
    var $934 = $gfp + 88 | 0;
    var $935 = HEAP32[$934 >> 2];
    var $936 = $2 + 32 | 0;
    HEAP32[$936 >> 2] = $935;
    var $937 = $gfp + 92 | 0;
    var $938 = HEAP32[$937 >> 2];
    var $939 = $2 + 36 | 0;
    HEAP32[$939 >> 2] = $938;
    var $940 = $gfp + 96 | 0;
    var $941 = HEAP32[$940 >> 2];
    var $942 = $2 + 120 | 0;
    HEAP32[$942 >> 2] = $941;
    var $943 = $gfp + 168 | 0;
    var $944 = HEAP32[$943 >> 2];
    var $945 = $2 + 108 | 0;
    HEAP32[$945 >> 2] = $944;
    var $946 = $gfp + 100 | 0;
    var $947 = HEAPF32[$946 >> 2];
    var $948 = $2 + 244 | 0;
    HEAPF32[$948 >> 2] = $947;
    _lame_init_qval($gfp);
    var $949 = $gfp + 232 | 0;
    var $950 = HEAP32[$949 >> 2];
    var $951 = ($950 | 0) < 0;
    var $952 = HEAP32[$41 >> 2];
    var $953 = $952 | 0;
    var $_610 = $951 ? 3 : $950;
    HEAP32[$953 >> 2] = $_610;
    var $954 = $gfp + 236 | 0;
    var $955 = HEAPF32[$954 >> 2];
    var $956 = $955;
    var $957 = $956 / -10;
    var $958 = Math.pow(10, $957);
    var $959 = $958;
    var $960 = HEAP32[$41 >> 2];
    var $961 = $960 + 4 | 0;
    HEAPF32[$961 >> 2] = $959;
    var $962 = $gfp + 240 | 0;
    var $963 = HEAP32[$962 >> 2];
    if (($963 | 0) == -1) {
      label = 171;
      break;
    } else if (($963 | 0) == 0) {
      label = 172;
      break;
    } else {
      label = 174;
      break;
    }
   case 171:
    HEAP32[$962 >> 2] = 0;
    label = 172;
    break;
   case 172:
    var $965 = HEAP32[$493 >> 2];
    var $switch = $965 >>> 0 < 2;
    if ($switch) {
      label = 173;
      break;
    } else {
      label = 174;
      break;
    }
   case 173:
    HEAP32[$962 >> 2] = 1;
    label = 174;
    break;
   case 174:
    var $968 = HEAP32[$962 >> 2];
    var $969 = $2 + 184 | 0;
    HEAP32[$969 >> 2] = $968;
    var $970 = _lame_get_quant_comp($gfp);
    var $971 = ($970 | 0) < 0;
    if ($971) {
      label = 175;
      break;
    } else {
      label = 176;
      break;
    }
   case 175:
    var $973 = _lame_set_quant_comp($gfp, 1);
    label = 176;
    break;
   case 176:
    var $975 = _lame_get_quant_comp_short($gfp);
    var $976 = ($975 | 0) < 0;
    if ($976) {
      label = 177;
      break;
    } else {
      label = 178;
      break;
    }
   case 177:
    var $978 = _lame_set_quant_comp_short($gfp, 0);
    label = 178;
    break;
   case 178:
    var $980 = _lame_get_msfix($gfp);
    var $981 = $980 < 0;
    if ($981) {
      label = 179;
      break;
    } else {
      label = 180;
      break;
    }
   case 179:
    _lame_set_msfix($gfp, 0);
    label = 180;
    break;
   case 180:
    var $984 = _lame_get_exp_nspsytune($gfp);
    var $985 = $984 | 1;
    var $986 = _lame_set_exp_nspsytune($gfp, $985);
    var $987 = HEAP32[$759 >> 2];
    var $988 = ($987 | 0) < 0;
    if ($988) {
      label = 181;
      break;
    } else {
      label = 182;
      break;
    }
   case 181:
    HEAP32[$759 >> 2] = 4;
    label = 182;
    break;
   case 182:
    var $991 = $gfp + 224 | 0;
    var $992 = HEAPF32[$991 >> 2];
    var $993 = $992 < 0;
    if ($993) {
      label = 183;
      break;
    } else {
      label = 184;
      break;
    }
   case 183:
    HEAPF32[$991 >> 2] = 4;
    label = 184;
    break;
   case 184:
    var $996 = $gfp + 248 | 0;
    var $997 = HEAPF32[$996 >> 2];
    var $998 = $997 < 0;
    if ($998) {
      label = 185;
      break;
    } else {
      label = 186;
      break;
    }
   case 185:
    HEAPF32[$996 >> 2] = 0;
    label = 186;
    break;
   case 186:
    var $1001 = $gfp + 244 | 0;
    var $1002 = HEAP32[$1001 >> 2];
    var $1003 = ($1002 | 0) < 0;
    if ($1003) {
      label = 187;
      break;
    } else {
      label = 188;
      break;
    }
   case 187:
    HEAP32[$1001 >> 2] = 1;
    label = 188;
    break;
   case 188:
    var $1006 = HEAPF32[$996 >> 2];
    var $1007 = $2 + 188 | 0;
    HEAPF32[$1007 >> 2] = $1006;
    var $1008 = $gfp + 252 | 0;
    var $1009 = HEAPF32[$1008 >> 2];
    var $1010 = $2 + 192 | 0;
    HEAPF32[$1010 >> 2] = $1009;
    var $1011 = $gfp + 228 | 0;
    var $1012 = HEAPF32[$1011 >> 2];
    var $1013 = -$1012;
    var $1014 = $2 + 196 | 0;
    HEAPF32[$1014 >> 2] = $1013;
    var $1015 = $1013 * .10000000149011612;
    var $1016 = Math.pow(10, $1015);
    var $1017 = $2 + 200 | 0;
    HEAPF32[$1017 >> 2] = $1016;
    var $1018 = HEAPF32[$991 >> 2];
    var $1019 = $2 + 204 | 0;
    HEAPF32[$1019 >> 2] = $1018;
    var $1020 = HEAP32[$759 >> 2];
    var $1021 = $2 + 208 | 0;
    HEAP32[$1021 >> 2] = $1020;
    var $1022 = $gfp + 208 | 0;
    var $1023 = HEAP32[$1022 >> 2];
    var $1024 = $2 + 212 | 0;
    HEAP32[$1024 >> 2] = $1023;
    var $1025 = $gfp + 212 | 0;
    var $1026 = HEAP32[$1025 >> 2];
    var $1027 = $2 + 216 | 0;
    HEAP32[$1027 >> 2] = $1026;
    var $1028 = $gfp + 216 | 0;
    var $1029 = HEAP32[$1028 >> 2];
    var $1030 = $2 + 220 | 0;
    HEAP32[$1030 >> 2] = $1029;
    var $1031 = $gfp + 132 | 0;
    var $1032 = HEAP32[$1031 >> 2];
    var $1033 = $2 + 84 | 0;
    HEAP32[$1033 >> 2] = $1032;
    var $1034 = $gfp + 136 | 0;
    var $1035 = HEAP32[$1034 >> 2];
    var $1036 = $2 + 88 | 0;
    HEAP32[$1036 >> 2] = $1035;
    var $1037 = HEAP32[$1001 >> 2];
    var $1038 = $2 + 92 | 0;
    HEAP32[$1038 >> 2] = $1037;
    var $1039 = $gfp + 148 | 0;
    var $1040 = HEAP32[$1039 >> 2];
    var $1041 = $1040 & 2;
    var $1042 = $2 + 96 | 0;
    HEAP32[$1042 >> 2] = $1041;
    var $1043 = HEAP32[$1039 >> 2];
    var $1044 = $1043 >>> 2;
    var $1045 = $1044 & 63;
    var $1046 = $1045 | 0;
    var $1047 = $2 + 232 | 0;
    var $1048 = $1046 < 32;
    if ($1048) {
      var $storemerge586 = $1046;
      label = 190;
      break;
    } else {
      label = 189;
      break;
    }
   case 189:
    var $1050 = $1046 - 64;
    var $storemerge586 = $1050;
    label = 190;
    break;
   case 190:
    var $storemerge586;
    var $1052 = $storemerge586 * .25;
    HEAPF32[$1047 >> 2] = $1052;
    var $1053 = HEAP32[$1039 >> 2];
    var $1054 = $1053 >>> 8;
    var $1055 = $1054 & 63;
    var $1056 = $1055 | 0;
    var $1057 = $2 + 228 | 0;
    var $1058 = $1056 < 32;
    if ($1058) {
      var $storemerge585 = $1056;
      label = 192;
      break;
    } else {
      label = 191;
      break;
    }
   case 191:
    var $1060 = $1056 - 64;
    var $storemerge585 = $1060;
    label = 192;
    break;
   case 192:
    var $storemerge585;
    var $1062 = $storemerge585 * .25;
    HEAPF32[$1057 >> 2] = $1062;
    var $1063 = HEAP32[$1039 >> 2];
    var $1064 = $1063 >>> 14;
    var $1065 = $1064 & 63;
    var $1066 = $1065 | 0;
    var $1067 = $2 + 236 | 0;
    var $1068 = $1066 < 32;
    if ($1068) {
      var $storemerge584 = $1066;
      label = 194;
      break;
    } else {
      label = 193;
      break;
    }
   case 193:
    var $1070 = $1066 - 64;
    var $storemerge584 = $1070;
    label = 194;
    break;
   case 194:
    var $storemerge584;
    var $1072 = $storemerge584 * .25;
    HEAPF32[$1067 >> 2] = $1072;
    var $1073 = HEAP32[$1039 >> 2];
    var $1074 = $1073 >>> 20;
    var $1075 = $1074 & 63;
    var $1076 = $1075 | 0;
    var $1077 = $2 + 240 | 0;
    var $1078 = $1076 < 32;
    if ($1078) {
      var $storemerge583 = $1076;
      label = 196;
      break;
    } else {
      label = 195;
      break;
    }
   case 195:
    var $1080 = $1076 - 64;
    var $storemerge583 = $1080;
    label = 196;
    break;
   case 196:
    var $storemerge583;
    var $1082 = $storemerge583 * .25;
    var $1083 = HEAPF32[$1067 >> 2];
    var $1084 = $1082 + $1083;
    HEAPF32[$1077 >> 2] = $1084;
    var $1085 = $gfp + 20 | 0;
    var $1086 = HEAPF32[$1085 >> 2];
    var $1087 = 0;
    var $1088 = $gfp + 24 | 0;
    var $1089 = HEAPF32[$1088 >> 2];
    var $1090 = $1086 * $1089;
    var $1091 = $1087 * $1089;
    var $1092 = $gfp + 28 | 0;
    var $1093 = HEAPF32[$1092 >> 2];
    var $1094 = $1087 * $1093;
    var $1095 = $1086 * $1093;
    var $1096 = HEAP32[$73 >> 2];
    var $1097 = ($1096 | 0) == 2;
    if ($1097) {
      label = 197;
      break;
    } else {
      var $m10_sroa_0_0 = $1090;
      var $m10_sroa_1_0 = $1091;
      var $m10_sroa_2_0 = $1094;
      var $m10_sroa_3_0 = $1095;
      label = 199;
      break;
    }
   case 197:
    var $1099 = HEAP32[$82 >> 2];
    var $1100 = ($1099 | 0) == 1;
    if ($1100) {
      label = 198;
      break;
    } else {
      var $m10_sroa_0_0 = $1090;
      var $m10_sroa_1_0 = $1091;
      var $m10_sroa_2_0 = $1094;
      var $m10_sroa_3_0 = $1095;
      label = 199;
      break;
    }
   case 198:
    var $1102 = $1090 + $1094;
    var $1103 = $1102 * .5;
    var $1104 = $1091 + $1095;
    var $1105 = $1104 * .5;
    var $m10_sroa_0_0 = $1103;
    var $m10_sroa_1_0 = $1105;
    var $m10_sroa_2_0 = 0;
    var $m10_sroa_3_0 = 0;
    label = 199;
    break;
   case 199:
    var $m10_sroa_3_0;
    var $m10_sroa_2_0;
    var $m10_sroa_1_0;
    var $m10_sroa_0_0;
    var $1107 = $2 + 264 | 0;
    HEAPF32[$1107 >> 2] = $m10_sroa_0_0;
    var $1108 = $2 + 268 | 0;
    HEAPF32[$1108 >> 2] = $m10_sroa_1_0;
    var $1109 = $2 + 272 | 0;
    HEAPF32[$1109 >> 2] = $m10_sroa_2_0;
    var $1110 = $2 + 276 | 0;
    HEAPF32[$1110 >> 2] = $m10_sroa_3_0;
    var $1111 = $2 + 39828 | 0;
    HEAP32[$1111 >> 2] = 0;
    var $1112 = $2 + 39832 | 0;
    HEAP32[$1112 >> 2] = 0;
    var $1113 = HEAP32[$927 >> 2];
    var $1114 = ($1113 | 0) == 0;
    if ($1114) {
      label = 200;
      break;
    } else {
      label = 201;
      break;
    }
   case 200:
    var $1116 = HEAP32[$568 >> 2];
    var $1117 = $1116 * 72e3 & -1;
    var $1118 = $1117 + 72e3 | 0;
    var $1119 = HEAP32[$942 >> 2];
    var $1120 = $1118 * $1119 & -1;
    var $1121 = HEAP32[$449 >> 2];
    var $1122 = ($1120 | 0) % ($1121 | 0);
    HEAP32[$1111 >> 2] = $1122;
    HEAP32[$1112 >> 2] = $1122;
    label = 201;
    break;
   case 201:
    var $1124 = _lame_init_bitstream($gfp);
    _iteration_init($2);
    var $1125 = _psymodel_init($gfp);
    var $1126 = $gfp + 124 | 0;
    var $1127 = HEAP32[$1126 >> 2];
    var $1128 = _get_max_frame_buffer_size_by_constraint($3, $1127);
    var $1129 = $2 + 148 | 0;
    HEAP32[$1129 >> 2] = $1128;
    var $_0 = 0;
    label = 202;
    break;
   case 202:
    var $_0;
    STACKTOP = __stackBase__;
    return $_0;
  }
}
_lame_init_params["X"] = 1;
function _linear_int($a, $b, $m) {
  return ($b - $a) * $m + $a;
}
function _optimum_samplefreq($lowpassfreq, $input_samplefreq) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($input_samplefreq | 0) > 47999;
    if ($1) {
      var $suggested_samplefreq_0 = 48e3;
      label = 11;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = ($input_samplefreq | 0) > 44099;
    if ($3) {
      var $suggested_samplefreq_0 = 44100;
      label = 11;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $5 = ($input_samplefreq | 0) > 31999;
    if ($5) {
      var $suggested_samplefreq_0 = 32e3;
      label = 11;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $7 = ($input_samplefreq | 0) > 23999;
    if ($7) {
      var $suggested_samplefreq_0 = 24e3;
      label = 11;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    var $9 = ($input_samplefreq | 0) > 22049;
    if ($9) {
      var $suggested_samplefreq_0 = 22050;
      label = 11;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    var $11 = ($input_samplefreq | 0) > 15999;
    if ($11) {
      var $suggested_samplefreq_0 = 16e3;
      label = 11;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    var $13 = ($input_samplefreq | 0) > 11999;
    if ($13) {
      var $suggested_samplefreq_0 = 12e3;
      label = 11;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    var $15 = ($input_samplefreq | 0) > 11024;
    if ($15) {
      var $suggested_samplefreq_0 = 11025;
      label = 11;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    var $17 = ($input_samplefreq | 0) > 7999;
    var $_ = $17 ? 8e3 : 44100;
    var $suggested_samplefreq_0 = $_;
    label = 11;
    break;
   case 11:
    var $suggested_samplefreq_0;
    var $19 = ($lowpassfreq | 0) == -1;
    if ($19) {
      var $_0 = $suggested_samplefreq_0;
      label = 21;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    var $21 = ($lowpassfreq | 0) < 15961;
    var $_suggested_samplefreq_0 = $21 ? 44100 : $suggested_samplefreq_0;
    var $22 = ($lowpassfreq | 0) < 15251;
    var $suggested_samplefreq_2 = $22 ? 32e3 : $_suggested_samplefreq_0;
    var $23 = ($lowpassfreq | 0) < 11221;
    var $_suggested_samplefreq_2 = $23 ? 24e3 : $suggested_samplefreq_2;
    var $24 = ($lowpassfreq | 0) < 9971;
    var $suggested_samplefreq_4 = $24 ? 22050 : $_suggested_samplefreq_2;
    var $25 = ($lowpassfreq | 0) < 7231;
    var $_suggested_samplefreq_4 = $25 ? 16e3 : $suggested_samplefreq_4;
    var $26 = ($lowpassfreq | 0) < 5421;
    var $suggested_samplefreq_6 = $26 ? 12e3 : $_suggested_samplefreq_4;
    var $27 = ($lowpassfreq | 0) < 4511;
    var $_suggested_samplefreq_6 = $27 ? 11025 : $suggested_samplefreq_6;
    var $28 = ($lowpassfreq | 0) < 3971;
    var $suggested_samplefreq_8 = $28 ? 8e3 : $_suggested_samplefreq_6;
    var $29 = ($suggested_samplefreq_8 | 0) > ($input_samplefreq | 0);
    if ($29) {
      label = 13;
      break;
    } else {
      var $_0 = $suggested_samplefreq_8;
      label = 21;
      break;
    }
   case 13:
    var $31 = ($input_samplefreq | 0) > 44100;
    if ($31) {
      var $_0 = 48e3;
      label = 21;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    var $33 = ($input_samplefreq | 0) > 32e3;
    if ($33) {
      var $_0 = 44100;
      label = 21;
      break;
    } else {
      label = 15;
      break;
    }
   case 15:
    var $35 = ($input_samplefreq | 0) > 24e3;
    if ($35) {
      var $_0 = 32e3;
      label = 21;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    var $37 = ($input_samplefreq | 0) > 22050;
    if ($37) {
      var $_0 = 24e3;
      label = 21;
      break;
    } else {
      label = 17;
      break;
    }
   case 17:
    var $39 = ($input_samplefreq | 0) > 16e3;
    if ($39) {
      var $_0 = 22050;
      label = 21;
      break;
    } else {
      label = 18;
      break;
    }
   case 18:
    var $41 = ($input_samplefreq | 0) > 12e3;
    if ($41) {
      var $_0 = 16e3;
      label = 21;
      break;
    } else {
      label = 19;
      break;
    }
   case 19:
    var $43 = ($input_samplefreq | 0) > 11025;
    if ($43) {
      var $_0 = 12e3;
      label = 21;
      break;
    } else {
      label = 20;
      break;
    }
   case 20:
    var $45 = ($input_samplefreq | 0) > 8e3;
    var $_30 = $45 ? 11025 : 8e3;
    var $_0 = $_30;
    label = 21;
    break;
   case 21:
    var $_0;
    return $_0;
  }
}
_optimum_samplefreq["X"] = 1;
function _optimum_bandwidth($lowerlimit, $bitrate) {
  var $5 = HEAP32[5291696 + (_nearestBitrateFullIndex($bitrate & 65535) << 3) >> 2] | 0;
  HEAPF64[tempDoublePtr >> 3] = $5, HEAP32[$lowerlimit >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$lowerlimit + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
  return;
}
function _lame_init_params_ppflt($gfc) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 248 | 0;
    var $2 = HEAPF32[$1 >> 2];
    var $3 = $2 > 0;
    if ($3) {
      label = 3;
      break;
    } else {
      label = 11;
      break;
    }
   case 3:
    var $4 = $gfc + 252 | 0;
    var $5 = HEAPF32[$4 >> 2];
    var $6 = HEAPF32[$1 >> 2];
    var $band_073 = 0;
    var $minband_074 = 999;
    var $lowpass_band_075 = 32;
    label = 4;
    break;
   case 4:
    var $lowpass_band_075;
    var $minband_074;
    var $band_073;
    var $8 = $band_073 | 0;
    var $9 = $8 / 31;
    var $10 = $9;
    var $11 = $10 < $5;
    if ($11) {
      var $lowpass_band_1 = $lowpass_band_075;
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $13 = ($lowpass_band_075 | 0) < ($band_073 | 0);
    var $14 = $13 ? $lowpass_band_075 : $band_073;
    var $lowpass_band_1 = $14;
    label = 6;
    break;
   case 6:
    var $lowpass_band_1;
    var $16 = $6 < $10;
    if ($16) {
      label = 7;
      break;
    } else {
      var $minband_1 = $minband_074;
      label = 9;
      break;
    }
   case 7:
    var $18 = HEAPF32[$4 >> 2];
    var $19 = $10 < $18;
    if ($19) {
      label = 8;
      break;
    } else {
      var $minband_1 = $minband_074;
      label = 9;
      break;
    }
   case 8:
    var $21 = ($minband_074 | 0) < ($band_073 | 0);
    var $22 = $21 ? $minband_074 : $band_073;
    var $minband_1 = $22;
    label = 9;
    break;
   case 9:
    var $minband_1;
    var $24 = $band_073 + 1 | 0;
    var $exitcond77 = ($24 | 0) == 32;
    if ($exitcond77) {
      label = 10;
      break;
    } else {
      var $band_073 = $24;
      var $minband_074 = $minband_1;
      var $lowpass_band_075 = $lowpass_band_1;
      label = 4;
      break;
    }
   case 10:
    var $26 = ($minband_1 | 0) == 999;
    var $lowpass_band_0_minband_0 = $26 ? $lowpass_band_1 : $minband_1;
    var $storemerge_in_in_in = $lowpass_band_0_minband_0 | 0;
    var $storemerge_in_in = $storemerge_in_in_in - .75;
    var $storemerge_in = $storemerge_in_in / 31;
    var $storemerge = $storemerge_in;
    HEAPF32[$1 >> 2] = $storemerge;
    var $27 = $lowpass_band_1 | 0;
    var $28 = $27 / 31;
    var $29 = $28;
    var $30 = $gfc + 252 | 0;
    HEAPF32[$30 >> 2] = $29;
    label = 11;
    break;
   case 11:
    var $32 = $gfc + 260 | 0;
    var $33 = HEAPF32[$32 >> 2];
    var $34 = $33 > 0;
    var $35 = $33;
    var $36 = $35 < .021774193548387097;
    var $or_cond = $34 & $36;
    if ($or_cond) {
      label = 12;
      break;
    } else {
      var $40 = $33;
      label = 13;
      break;
    }
   case 12:
    var $38 = $gfc + 256 | 0;
    HEAPF32[$38 >> 2] = 0;
    HEAPF32[$32 >> 2] = 0;
    _lame_msgf($gfc, 5382660, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    var $_pr = HEAPF32[$32 >> 2];
    var $40 = $_pr;
    label = 13;
    break;
   case 13:
    var $40;
    var $41 = $40 > 0;
    if ($41) {
      label = 14;
      break;
    } else {
      label = 24;
      break;
    }
   case 14:
    var $42 = $gfc + 256 | 0;
    var $43 = HEAPF32[$42 >> 2];
    var $band_169 = 0;
    var $maxband_070 = -1;
    var $highpass_band_071 = -1;
    label = 15;
    break;
   case 15:
    var $highpass_band_071;
    var $maxband_070;
    var $band_169;
    var $45 = $band_169 | 0;
    var $46 = $45 / 31;
    var $47 = $46;
    var $48 = $47 > $43;
    if ($48) {
      var $highpass_band_1 = $highpass_band_071;
      label = 17;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    var $50 = ($highpass_band_071 | 0) > ($band_169 | 0);
    var $51 = $50 ? $highpass_band_071 : $band_169;
    var $highpass_band_1 = $51;
    label = 17;
    break;
   case 17:
    var $highpass_band_1;
    var $53 = $43 < $47;
    if ($53) {
      label = 18;
      break;
    } else {
      var $maxband_1 = $maxband_070;
      label = 20;
      break;
    }
   case 18:
    var $55 = HEAPF32[$32 >> 2];
    var $56 = $47 < $55;
    if ($56) {
      label = 19;
      break;
    } else {
      var $maxband_1 = $maxband_070;
      label = 20;
      break;
    }
   case 19:
    var $58 = ($maxband_070 | 0) > ($band_169 | 0);
    var $59 = $58 ? $maxband_070 : $band_169;
    var $maxband_1 = $59;
    label = 20;
    break;
   case 20:
    var $maxband_1;
    var $61 = $band_169 + 1 | 0;
    var $exitcond76 = ($61 | 0) == 32;
    if ($exitcond76) {
      label = 21;
      break;
    } else {
      var $band_169 = $61;
      var $maxband_070 = $maxband_1;
      var $highpass_band_071 = $highpass_band_1;
      label = 15;
      break;
    }
   case 21:
    var $63 = $highpass_band_1 | 0;
    var $64 = $63 / 31;
    var $65 = $64;
    var $66 = $gfc + 256 | 0;
    HEAPF32[$66 >> 2] = $65;
    var $67 = ($maxband_1 | 0) == -1;
    if ($67) {
      label = 22;
      break;
    } else {
      label = 23;
      break;
    }
   case 22:
    var $69 = $63 + .75;
    var $70 = $69 / 31;
    var $71 = $70;
    HEAPF32[$32 >> 2] = $71;
    label = 24;
    break;
   case 23:
    var $73 = $maxband_1 | 0;
    var $74 = $73 + .75;
    var $75 = $74 / 31;
    var $76 = $75;
    HEAPF32[$32 >> 2] = $76;
    label = 24;
    break;
   case 24:
    var $77 = $gfc + 256 | 0;
    var $78 = $gfc + 252 | 0;
    var $band_267 = 0;
    label = 25;
    break;
   case 25:
    var $band_267;
    var $80 = $band_267 | 0;
    var $81 = $80 / 31;
    var $82 = HEAPF32[$32 >> 2];
    var $83 = HEAPF32[$77 >> 2];
    var $84 = $82 > $83;
    if ($84) {
      label = 26;
      break;
    } else {
      var $fc1_0 = 1;
      label = 27;
      break;
    }
   case 26:
    var $86 = $82 - $81;
    var $87 = $86;
    var $88 = $82 - $83;
    var $89 = $88;
    var $90 = $89 + 1e-20;
    var $91 = $87 / $90;
    var $92 = $91;
    var $93 = _filter_coef($92);
    var $fc1_0 = $93;
    label = 27;
    break;
   case 27:
    var $fc1_0;
    var $95 = HEAPF32[$78 >> 2];
    var $96 = HEAPF32[$1 >> 2];
    var $97 = $95 > $96;
    if ($97) {
      label = 28;
      break;
    } else {
      var $fc2_0 = 1;
      label = 29;
      break;
    }
   case 28:
    var $99 = $81 - $96;
    var $100 = $99;
    var $101 = $95 - $96;
    var $102 = $101;
    var $103 = $102 + 1e-20;
    var $104 = $100 / $103;
    var $105 = $104;
    var $106 = _filter_coef($105);
    var $fc2_0 = $106;
    label = 29;
    break;
   case 29:
    var $fc2_0;
    var $108 = $fc1_0 * $fc2_0;
    var $109 = $gfc + 37036 + ($band_267 << 2) | 0;
    HEAPF32[$109 >> 2] = $108;
    var $110 = $band_267 + 1 | 0;
    var $exitcond = ($110 | 0) == 32;
    if ($exitcond) {
      label = 30;
      break;
    } else {
      var $band_267 = $110;
      label = 25;
      break;
    }
   case 30:
    STACKTOP = __stackBase__;
    return;
  }
}
_lame_init_params_ppflt["X"] = 1;
function _lame_init_qval($gfp) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfp + 288 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $gfp + 44 | 0;
    var $4 = HEAP32[$3 >> 2];
    if (($4 | 0) == 8) {
      label = 4;
      break;
    } else if (($4 | 0) == 7) {
      label = 5;
      break;
    } else if (($4 | 0) == 6) {
      label = 7;
      break;
    } else if (($4 | 0) == 5) {
      label = 12;
      break;
    } else if (($4 | 0) == 4) {
      label = 17;
      break;
    } else if (($4 | 0) == 3) {
      label = 22;
      break;
    } else if (($4 | 0) == 2) {
      label = 27;
      break;
    } else if (($4 | 0) == 1) {
      label = 34;
      break;
    } else if (($4 | 0) == 0) {
      label = 41;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $6 = $2 + 28 | 0;
    HEAP32[$6 >> 2] = 0;
    var $7 = $2 + 36 | 0;
    var $8 = $7;
    HEAP32[$8 >> 2] = 0;
    HEAP32[$8 + 4 >> 2] = 0;
    HEAP32[$8 + 8 >> 2] = 0;
    HEAP32[$8 + 12 >> 2] = 0;
    label = 48;
    break;
   case 4:
    HEAP32[$3 >> 2] = 7;
    label = 5;
    break;
   case 5:
    var $11 = $2 + 28 | 0;
    HEAP32[$11 >> 2] = 0;
    var $12 = $2 + 36 | 0;
    var $13 = $2 + 48 | 0;
    var $14 = $gfp + 156 | 0;
    var $15 = $12;
    HEAP32[$15 >> 2] = 0;
    HEAP32[$15 + 4 >> 2] = 0;
    HEAP32[$15 + 8 >> 2] = 0;
    HEAP32[$15 + 12 >> 2] = 0;
    var $16 = HEAP32[$14 >> 2];
    if (($16 | 0) == 1 | ($16 | 0) == 4) {
      label = 6;
      break;
    } else {
      label = 48;
      break;
    }
   case 6:
    HEAP32[$13 >> 2] = -1;
    label = 48;
    break;
   case 7:
    var $19 = $2 + 28 | 0;
    var $20 = HEAP32[$19 >> 2];
    var $21 = ($20 | 0) == 0;
    if ($21) {
      label = 8;
      break;
    } else {
      label = 9;
      break;
    }
   case 8:
    HEAP32[$19 >> 2] = 1;
    label = 9;
    break;
   case 9:
    var $24 = $2 + 40 | 0;
    HEAP32[$24 >> 2] = 0;
    var $25 = $2 + 44 | 0;
    HEAP32[$25 >> 2] = 0;
    var $26 = $2 + 32 | 0;
    var $27 = HEAP32[$26 >> 2];
    var $28 = ($27 | 0) == -1;
    if ($28) {
      label = 10;
      break;
    } else {
      label = 11;
      break;
    }
   case 10:
    HEAP32[$26 >> 2] = 1;
    label = 11;
    break;
   case 11:
    var $31 = $2 + 36 | 0;
    HEAP32[$31 >> 2] = 0;
    var $32 = $2 + 48 | 0;
    HEAP32[$32 >> 2] = 0;
    label = 48;
    break;
   case 12:
    var $34 = $2 + 28 | 0;
    var $35 = HEAP32[$34 >> 2];
    var $36 = ($35 | 0) == 0;
    if ($36) {
      label = 13;
      break;
    } else {
      label = 14;
      break;
    }
   case 13:
    HEAP32[$34 >> 2] = 1;
    label = 14;
    break;
   case 14:
    var $39 = $2 + 40 | 0;
    HEAP32[$39 >> 2] = 0;
    var $40 = $2 + 44 | 0;
    HEAP32[$40 >> 2] = 0;
    var $41 = $2 + 32 | 0;
    var $42 = HEAP32[$41 >> 2];
    var $43 = ($42 | 0) == -1;
    if ($43) {
      label = 15;
      break;
    } else {
      label = 16;
      break;
    }
   case 15:
    HEAP32[$41 >> 2] = 1;
    label = 16;
    break;
   case 16:
    var $46 = $2 + 36 | 0;
    HEAP32[$46 >> 2] = 0;
    var $47 = $2 + 48 | 0;
    HEAP32[$47 >> 2] = 0;
    label = 48;
    break;
   case 17:
    var $49 = $2 + 28 | 0;
    var $50 = HEAP32[$49 >> 2];
    var $51 = ($50 | 0) == 0;
    if ($51) {
      label = 18;
      break;
    } else {
      label = 19;
      break;
    }
   case 18:
    HEAP32[$49 >> 2] = 1;
    label = 19;
    break;
   case 19:
    var $54 = $2 + 40 | 0;
    HEAP32[$54 >> 2] = 0;
    var $55 = $2 + 44 | 0;
    HEAP32[$55 >> 2] = 0;
    var $56 = $2 + 32 | 0;
    var $57 = HEAP32[$56 >> 2];
    var $58 = ($57 | 0) == -1;
    if ($58) {
      label = 20;
      break;
    } else {
      label = 21;
      break;
    }
   case 20:
    HEAP32[$56 >> 2] = 1;
    label = 21;
    break;
   case 21:
    var $61 = $2 + 36 | 0;
    HEAP32[$61 >> 2] = 1;
    var $62 = $2 + 48 | 0;
    HEAP32[$62 >> 2] = 0;
    label = 48;
    break;
   case 22:
    var $64 = $2 + 28 | 0;
    var $65 = HEAP32[$64 >> 2];
    var $66 = ($65 | 0) == 0;
    if ($66) {
      label = 23;
      break;
    } else {
      label = 24;
      break;
    }
   case 23:
    HEAP32[$64 >> 2] = 1;
    label = 24;
    break;
   case 24:
    var $69 = $2 + 40 | 0;
    HEAP32[$69 >> 2] = 1;
    var $70 = $2 + 44 | 0;
    HEAP32[$70 >> 2] = 1;
    var $71 = $2 + 32 | 0;
    var $72 = HEAP32[$71 >> 2];
    var $73 = ($72 | 0) == -1;
    if ($73) {
      label = 25;
      break;
    } else {
      label = 26;
      break;
    }
   case 25:
    HEAP32[$71 >> 2] = 1;
    label = 26;
    break;
   case 26:
    var $76 = $2 + 36 | 0;
    HEAP32[$76 >> 2] = 1;
    var $77 = $2 + 48 | 0;
    HEAP32[$77 >> 2] = 0;
    label = 48;
    break;
   case 27:
    var $79 = $2 + 28 | 0;
    var $80 = HEAP32[$79 >> 2];
    var $81 = ($80 | 0) == 0;
    if ($81) {
      label = 28;
      break;
    } else {
      label = 29;
      break;
    }
   case 28:
    HEAP32[$79 >> 2] = 1;
    label = 29;
    break;
   case 29:
    var $84 = $2 + 85092 | 0;
    var $85 = HEAP32[$84 >> 2];
    var $86 = ($85 | 0) == 0;
    if ($86) {
      label = 30;
      break;
    } else {
      label = 31;
      break;
    }
   case 30:
    HEAP32[$84 >> 2] = 2;
    label = 31;
    break;
   case 31:
    var $89 = $2 + 40 | 0;
    HEAP32[$89 >> 2] = 1;
    var $90 = $2 + 44 | 0;
    HEAP32[$90 >> 2] = 1;
    var $91 = $2 + 32 | 0;
    var $92 = HEAP32[$91 >> 2];
    var $93 = ($92 | 0) == -1;
    if ($93) {
      label = 32;
      break;
    } else {
      label = 33;
      break;
    }
   case 32:
    HEAP32[$91 >> 2] = 1;
    label = 33;
    break;
   case 33:
    var $96 = $2 + 36 | 0;
    HEAP32[$96 >> 2] = 1;
    var $97 = $2 + 48 | 0;
    HEAP32[$97 >> 2] = 0;
    label = 48;
    break;
   case 34:
    var $99 = $2 + 28 | 0;
    var $100 = HEAP32[$99 >> 2];
    var $101 = ($100 | 0) == 0;
    if ($101) {
      label = 35;
      break;
    } else {
      label = 36;
      break;
    }
   case 35:
    HEAP32[$99 >> 2] = 1;
    label = 36;
    break;
   case 36:
    var $104 = $2 + 85092 | 0;
    var $105 = HEAP32[$104 >> 2];
    var $106 = ($105 | 0) == 0;
    if ($106) {
      label = 37;
      break;
    } else {
      label = 38;
      break;
    }
   case 37:
    HEAP32[$104 >> 2] = 2;
    label = 38;
    break;
   case 38:
    var $109 = $2 + 40 | 0;
    HEAP32[$109 >> 2] = 2;
    var $110 = $2 + 44 | 0;
    HEAP32[$110 >> 2] = 1;
    var $111 = $2 + 32 | 0;
    var $112 = HEAP32[$111 >> 2];
    var $113 = ($112 | 0) == -1;
    if ($113) {
      label = 39;
      break;
    } else {
      label = 40;
      break;
    }
   case 39:
    HEAP32[$111 >> 2] = 1;
    label = 40;
    break;
   case 40:
    var $116 = $2 + 36 | 0;
    HEAP32[$116 >> 2] = 1;
    var $117 = $2 + 48 | 0;
    HEAP32[$117 >> 2] = 0;
    label = 48;
    break;
   case 41:
    var $119 = $2 + 28 | 0;
    var $120 = HEAP32[$119 >> 2];
    var $121 = ($120 | 0) == 0;
    if ($121) {
      label = 42;
      break;
    } else {
      label = 43;
      break;
    }
   case 42:
    HEAP32[$119 >> 2] = 1;
    label = 43;
    break;
   case 43:
    var $124 = $2 + 85092 | 0;
    var $125 = HEAP32[$124 >> 2];
    var $126 = ($125 | 0) == 0;
    if ($126) {
      label = 44;
      break;
    } else {
      label = 45;
      break;
    }
   case 44:
    HEAP32[$124 >> 2] = 2;
    label = 45;
    break;
   case 45:
    var $129 = $2 + 40 | 0;
    HEAP32[$129 >> 2] = 2;
    var $130 = $2 + 44 | 0;
    HEAP32[$130 >> 2] = 1;
    var $131 = $2 + 32 | 0;
    var $132 = HEAP32[$131 >> 2];
    var $133 = ($132 | 0) == -1;
    if ($133) {
      label = 46;
      break;
    } else {
      label = 47;
      break;
    }
   case 46:
    HEAP32[$131 >> 2] = 1;
    label = 47;
    break;
   case 47:
    var $136 = $2 + 36 | 0;
    HEAP32[$136 >> 2] = 1;
    var $137 = $2 + 48 | 0;
    HEAP32[$137 >> 2] = 1;
    label = 48;
    break;
   case 48:
    return;
  }
}
_lame_init_qval["X"] = 1;
function _lame_init_bitstream($gfp) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = _is_lame_global_flags_valid($gfp);
    var $2 = ($1 | 0) == 0;
    if ($2) {
      var $_0 = -3;
      label = 8;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $4 = $gfp + 288 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = ($5 | 0) == 0;
    if ($6) {
      var $_0 = -3;
      label = 8;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $8 = $5 + 84036 | 0;
    var $9 = $5 + 84744 | 0;
    HEAP32[$9 >> 2] = 0;
    var $10 = $gfp + 68 | 0;
    var $11 = HEAP32[$10 >> 2];
    var $12 = ($11 | 0) == 0;
    if ($12) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $14 = _id3tag_write_v2($gfp);
    label = 6;
    break;
   case 6:
    var $16 = $5 + 85680 | 0;
    HEAPF32[$16 >> 2] = 0;
    var $17 = $5 + 156 | 0;
    var $18 = $8;
    for (var $$dest = $18 >> 2, $$stop = $$dest + 176; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $19 = HEAP32[$17 >> 2];
    var $20 = ($19 | 0) == 0;
    if ($20) {
      var $_0 = 0;
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    var $22 = _InitVbrTag($gfp);
    var $_0 = 0;
    label = 8;
    break;
   case 8:
    var $_0;
    return $_0;
  }
}
function _lame_print_config($gfp) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 256 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $text = __stackBase__;
    var $1 = $gfp + 288 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $2 + 16 | 0;
    var $4 = $2 + 64 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = $5 | 0;
    var $7 = $2 + 60 | 0;
    var $8 = HEAP32[$7 >> 2];
    var $9 = $8 | 0;
    _lame_msgf($2, 5386292, (tempInt = STACKTOP, STACKTOP = STACKTOP + 12 | 0, HEAP32[tempInt >> 2] = 5384648, HEAP32[tempInt + 4 >> 2] = 5383868, HEAP32[tempInt + 8 >> 2] = 5384668, tempInt));
    var $10 = $2 + 85752 | 0;
    var $11 = $10;
    var $12 = HEAP32[$11 >> 2];
    var $13 = $12 & 15;
    var $14 = ($13 | 0) == 0;
    if ($14) {
      label = 12;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $16 = $text | 0;
    _memset($16, 0, 256);
    var $17 = HEAP32[$11 >> 2];
    var $18 = $17 & 1;
    var $19 = ($18 | 0) == 0;
    if ($19) {
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    _concatSep($16, 5384372);
    label = 5;
    break;
   case 5:
    var $22 = HEAP32[$11 >> 2];
    var $23 = $22 & 2;
    var $24 = ($23 | 0) == 0;
    if ($24) {
      label = 7;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    _concatSep($16, 5383560);
    label = 7;
    break;
   case 7:
    var $27 = HEAP32[$11 >> 2];
    var $28 = $27 & 4;
    var $29 = ($28 | 0) == 0;
    if ($29) {
      label = 9;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    _concatSep($16, 5382740);
    label = 9;
    break;
   case 9:
    var $32 = HEAP32[$11 >> 2];
    var $33 = $32 & 8;
    var $34 = ($33 | 0) == 0;
    if ($34) {
      label = 11;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    _concatSep($16, 5387212);
    label = 11;
    break;
   case 11:
    _lame_msgf($2, 5387076, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $16, tempInt));
    label = 12;
    break;
   case 12:
    var $38 = $2 + 68 | 0;
    var $39 = HEAP32[$38 >> 2];
    var $40 = ($39 | 0) == 2;
    if ($40) {
      label = 13;
      break;
    } else {
      label = 15;
      break;
    }
   case 13:
    var $42 = $2 + 72 | 0;
    var $43 = HEAP32[$42 >> 2];
    var $44 = ($43 | 0) == 1;
    if ($44) {
      label = 14;
      break;
    } else {
      label = 15;
      break;
    }
   case 14:
    _lame_msgf($2, 5386892, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    label = 15;
    break;
   case 15:
    var $47 = _isResamplingNecessary($3);
    var $48 = ($47 | 0) == 0;
    if ($48) {
      label = 17;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    var $50 = $9 * .001;
    var $51 = $6 * .001;
    _lame_msgf($2, 5386732, (tempInt = STACKTOP, STACKTOP = STACKTOP + 16 | 0, HEAPF64[tempDoublePtr >> 3] = $50, HEAP32[tempInt >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[tempInt + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2], HEAPF64[tempDoublePtr >> 3] = $51, HEAP32[tempInt + 8 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[tempInt + 12 >> 2] = HEAP32[tempDoublePtr + 4 >> 2], tempInt));
    label = 17;
    break;
   case 17:
    var $53 = $2 + 260 | 0;
    var $54 = HEAPF32[$53 >> 2];
    var $55 = $54 > 0;
    if ($55) {
      label = 18;
      break;
    } else {
      label = 19;
      break;
    }
   case 18:
    var $57 = $54;
    var $58 = $2 + 256 | 0;
    var $59 = HEAPF32[$58 >> 2];
    var $60 = $59;
    var $61 = $60 * .5;
    var $62 = $6 * $61;
    var $63 = $57 * .5;
    var $64 = $6 * $63;
    _lame_msgf($2, 5386392, (tempInt = STACKTOP, STACKTOP = STACKTOP + 16 | 0, HEAPF64[tempDoublePtr >> 3] = $62, HEAP32[tempInt >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[tempInt + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2], HEAPF64[tempDoublePtr >> 3] = $64, HEAP32[tempInt + 8 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[tempInt + 12 >> 2] = HEAP32[tempDoublePtr + 4 >> 2], tempInt));
    label = 19;
    break;
   case 19:
    var $66 = $2 + 248 | 0;
    var $67 = HEAPF32[$66 >> 2];
    var $68 = $67 > 0;
    if ($68) {
      label = 21;
      break;
    } else {
      label = 20;
      break;
    }
   case 20:
    var $70 = $2 + 252 | 0;
    var $71 = HEAPF32[$70 >> 2];
    var $72 = $71 > 0;
    if ($72) {
      label = 21;
      break;
    } else {
      label = 22;
      break;
    }
   case 21:
    var $74 = HEAPF32[$66 >> 2];
    var $75 = $74;
    var $76 = $75 * .5;
    var $77 = $6 * $76;
    var $78 = $2 + 252 | 0;
    var $79 = HEAPF32[$78 >> 2];
    var $80 = $79;
    var $81 = $80 * .5;
    var $82 = $6 * $81;
    _lame_msgf($2, 5386212, (tempInt = STACKTOP, STACKTOP = STACKTOP + 16 | 0, HEAPF64[tempDoublePtr >> 3] = $77, HEAP32[tempInt >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[tempInt + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2], HEAPF64[tempDoublePtr >> 3] = $82, HEAP32[tempInt + 8 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[tempInt + 12 >> 2] = HEAP32[tempDoublePtr + 4 >> 2], tempInt));
    label = 23;
    break;
   case 22:
    _lame_msgf($2, 5386168, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    label = 23;
    break;
   case 23:
    var $85 = $2 + 152 | 0;
    var $86 = HEAP32[$85 >> 2];
    var $87 = ($86 | 0) == 0;
    if ($87) {
      label = 26;
      break;
    } else {
      label = 24;
      break;
    }
   case 24:
    _lame_msgf($2, 5386096, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    var $89 = $2 + 120 | 0;
    var $90 = HEAP32[$89 >> 2];
    var $91 = ($90 | 0) > 320;
    if ($91) {
      label = 25;
      break;
    } else {
      label = 26;
      break;
    }
   case 25:
    _lame_msgf($2, 5385988, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    label = 26;
    break;
   case 26:
    STACKTOP = __stackBase__;
    return;
  }
}
_lame_print_config["X"] = 1;
function _concatSep($dest, $str) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = HEAP8[$dest];
    var $2 = $1 << 24 >> 24 == 0;
    if ($2) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $strlen = _strlen($dest);
    var $endptr = $dest + $strlen | 0;
    HEAP8[$endptr] = HEAP8[5384892];
    HEAP8[$endptr + 1] = HEAP8[5384893];
    HEAP8[$endptr + 2] = HEAP8[5384894];
    label = 4;
    break;
   case 4:
    var $5 = _strcat($dest, $str);
    return;
  }
}
function _calcNeeded($cfg) {
  return (HEAP32[$cfg + 60 >> 2] * 576 & -1) + 752 | 0;
}
function _lame_print_internals($gfp) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfp + 288 | 0;
    var $2 = HEAP32[$1 >> 2];
    _lame_msgf($2, 5385672, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    var $3 = $gfp + 20 | 0;
    var $4 = HEAPF32[$3 >> 2];
    var $5 = $4;
    _lame_msgf($2, 5385648, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAPF64[tempDoublePtr >> 3] = $5, HEAP32[tempInt >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[tempInt + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2], tempInt));
    var $6 = $gfp + 24 | 0;
    var $7 = HEAPF32[$6 >> 2];
    var $8 = $7;
    _lame_msgf($2, 5385612, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAPF64[tempDoublePtr >> 3] = $8, HEAP32[tempInt >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[tempInt + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2], tempInt));
    var $9 = $gfp + 28 | 0;
    var $10 = HEAPF32[$9 >> 2];
    var $11 = $10;
    _lame_msgf($2, 5385580, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAPF64[tempDoublePtr >> 3] = $11, HEAP32[tempInt >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[tempInt + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2], tempInt));
    var $12 = $2 + 36 | 0;
    var $13 = HEAP32[$12 >> 2];
    if (($13 | 0) == 1) {
      label = 3;
      break;
    } else if (($13 | 0) == 2) {
      label = 4;
      break;
    } else {
      var $pc_0 = 5385528;
      label = 5;
      break;
    }
   case 3:
    var $pc_0 = 5385504;
    label = 5;
    break;
   case 4:
    var $pc_0 = 5385412;
    label = 5;
    break;
   case 5:
    var $pc_0;
    _lame_msgf($2, 5385380, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $pc_0, tempInt));
    var $17 = $gfp + 140 | 0;
    var $18 = HEAP32[$17 >> 2];
    _lame_msgf($2, 5385352, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $18, tempInt));
    _lame_msgf($2, 5385276, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    _lame_msgf($2, 5385240, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    var $19 = $2 + 16 | 0;
    var $20 = HEAP32[$19 >> 2];
    if (($20 | 0) == 1) {
      label = 6;
      break;
    } else if (($20 | 0) == 2) {
      label = 7;
      break;
    } else if (($20 | 0) == 0) {
      var $pc_1 = 5385232;
      label = 9;
      break;
    } else {
      label = 8;
      break;
    }
   case 6:
    var $pc_1 = 5385216;
    label = 9;
    break;
   case 7:
    var $pc_1 = 5385204;
    label = 9;
    break;
   case 8:
    var $pc_1 = 5385168;
    label = 9;
    break;
   case 9:
    var $pc_1;
    _lame_msgf($2, 5385136, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $pc_1, tempInt));
    var $25 = $2 + 180 | 0;
    var $26 = HEAP32[$25 >> 2];
    if (($26 | 0) == 0) {
      label = 10;
      break;
    } else if (($26 | 0) == 2) {
      label = 11;
      break;
    } else if (($26 | 0) == 3) {
      label = 12;
      break;
    } else if (($26 | 0) == 4) {
      label = 13;
      break;
    } else if (($26 | 0) == 1) {
      var $pc_2 = 5385112;
      label = 15;
      break;
    } else {
      label = 14;
      break;
    }
   case 10:
    var $pc_2 = 5385092;
    label = 15;
    break;
   case 11:
    var $pc_2 = 5385028;
    label = 15;
    break;
   case 12:
    var $pc_2 = 5384932;
    label = 15;
    break;
   case 13:
    var $pc_2 = 5384908;
    label = 15;
    break;
   case 14:
    var $pc_2 = 5384868;
    label = 15;
    break;
   case 15:
    var $pc_2;
    var $33 = $2 + 72 | 0;
    var $34 = HEAP32[$33 >> 2];
    _lame_msgf($2, 5384836, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $34, HEAP32[tempInt + 4 >> 2] = $pc_2, tempInt));
    var $35 = $2 + 104 | 0;
    var $36 = HEAP32[$35 >> 2];
    var $cond = ($36 | 0) == 0;
    var $_ = $cond ? 5384728 : 5384656;
    _lame_msgf($2, 5384624, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $_, tempInt));
    var $37 = HEAP32[$35 >> 2];
    var $38 = ($37 | 0) == 4;
    if ($38) {
      var $pc_490 = 5384604;
      label = 21;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    var $40 = $2 + 152 | 0;
    var $41 = HEAP32[$40 >> 2];
    var $42 = ($41 | 0) == 0;
    var $_88 = $42 ? 5385696 : 5384548;
    var $_pr = HEAP32[$35 >> 2];
    if (($_pr | 0) == 0) {
      label = 17;
      break;
    } else if (($_pr | 0) == 3) {
      label = 18;
      break;
    } else if (($_pr | 0) == 2) {
      label = 19;
      break;
    } else if (($_pr | 0) == 1) {
      label = 20;
      break;
    } else if (($_pr | 0) == 4) {
      var $pc_490 = $_88;
      label = 21;
      break;
    } else {
      label = 22;
      break;
    }
   case 17:
    _lame_msgf($2, 5384512, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $_88, tempInt));
    label = 23;
    break;
   case 18:
    _lame_msgf($2, 5384440, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $_88, tempInt));
    label = 23;
    break;
   case 19:
    _lame_msgf($2, 5384388, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $_88, tempInt));
    label = 23;
    break;
   case 20:
    _lame_msgf($2, 5384332, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $_88, tempInt));
    label = 23;
    break;
   case 21:
    var $pc_490;
    _lame_msgf($2, 5384288, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $pc_490, tempInt));
    label = 23;
    break;
   case 22:
    _lame_msgf($2, 5384248, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    label = 23;
    break;
   case 23:
    var $49 = $2 + 156 | 0;
    var $50 = HEAP32[$49 >> 2];
    var $51 = ($50 | 0) == 0;
    if ($51) {
      label = 25;
      break;
    } else {
      label = 24;
      break;
    }
   case 24:
    _lame_msgf($2, 5384216, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    label = 25;
    break;
   case 25:
    _lame_msgf($2, 5385276, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    _lame_msgf($2, 5384184, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    var $54 = $2 + 184 | 0;
    var $55 = HEAP32[$54 >> 2];
    if (($55 | 0) == 0) {
      label = 26;
      break;
    } else if (($55 | 0) == 1) {
      label = 27;
      break;
    } else if (($55 | 0) == 2) {
      label = 28;
      break;
    } else if (($55 | 0) == 3) {
      label = 29;
      break;
    } else {
      var $pc_5 = 5385168;
      label = 30;
      break;
    }
   case 26:
    var $pc_5 = 5384156;
    label = 30;
    break;
   case 27:
    var $pc_5 = 5384120;
    label = 30;
    break;
   case 28:
    var $pc_5 = 5384100;
    label = 30;
    break;
   case 29:
    var $pc_5 = 5384048;
    label = 30;
    break;
   case 30:
    var $pc_5;
    _lame_msgf($2, 5384008, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $pc_5, tempInt));
    var $61 = $2 + 32 | 0;
    var $62 = HEAP32[$61 >> 2];
    _lame_msgf($2, 5383956, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $62, tempInt));
    var $63 = $2 + 84908 | 0;
    var $64 = HEAPF32[$63 >> 2];
    var $65 = $64;
    _lame_msgf($2, 5383920, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAPF64[tempDoublePtr >> 3] = $65, HEAP32[tempInt >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[tempInt + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2], tempInt));
    var $66 = $2 + 84912 | 0;
    var $67 = HEAPF32[$66 >> 2];
    var $68 = $67;
    _lame_msgf($2, 5383876, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAPF64[tempDoublePtr >> 3] = $68, HEAP32[tempInt >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[tempInt + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2], tempInt));
    var $69 = $2 + 84 | 0;
    var $70 = HEAP32[$69 >> 2];
    _lame_msgf($2, 5383824, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $70, tempInt));
    var $71 = $2 + 88 | 0;
    var $72 = HEAP32[$71 >> 2];
    _lame_msgf($2, 5383780, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $72, tempInt));
    var $73 = $2 + 28 | 0;
    var $74 = HEAP32[$73 >> 2];
    _lame_msgf($2, 5383744, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $74, tempInt));
    var $75 = $2 + 40 | 0;
    var $76 = HEAP32[$75 >> 2];
    _lame_msgf($2, 5383712, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $76, tempInt));
    var $77 = $2 + 44 | 0;
    var $78 = HEAP32[$77 >> 2];
    _lame_msgf($2, 5383684, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $78, tempInt));
    var $79 = $2 + 216 | 0;
    var $80 = HEAP32[$79 >> 2];
    var $81 = ($80 | 0) == 0;
    var $_89 = $81 ? 5383616 : 5383572;
    var $82 = $2 + 212 | 0;
    var $83 = HEAP32[$82 >> 2];
    var $84 = ($83 | 0) == 0;
    var $pc_7 = $84 ? $_89 : 5383524;
    var $85 = $2 + 220 | 0;
    var $86 = HEAP32[$85 >> 2];
    var $87 = ($86 | 0) == 0;
    var $pc_7_ = $87 ? $pc_7 : 5383500;
    _lame_msgf($2, 5383480, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $pc_7_, tempInt));
    var $88 = $2 + 208 | 0;
    var $89 = HEAP32[$88 >> 2];
    _lame_msgf($2, 5383452, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $89, tempInt));
    var $90 = $2 + 204 | 0;
    var $91 = HEAPF32[$90 >> 2];
    var $92 = $91;
    _lame_msgf($2, 5383424, (tempInt = STACKTOP, STACKTOP = STACKTOP + 12 | 0, HEAPF64[tempDoublePtr >> 3] = $92, HEAP32[tempInt >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[tempInt + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2], HEAP32[tempInt + 8 >> 2] = 5383392, tempInt));
    var $93 = $2 + 196 | 0;
    var $94 = HEAPF32[$93 >> 2];
    var $95 = $94;
    _lame_msgf($2, 5383348, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAPF64[tempDoublePtr >> 3] = $95, HEAP32[tempInt >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[tempInt + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2], tempInt));
    var $96 = $2 + 85792 | 0;
    var $97 = HEAP32[$96 >> 2];
    var $98 = $97 | 0;
    var $99 = HEAP32[$98 >> 2];
    _lame_msgf($2, 5383316, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $99, tempInt));
    var $100 = HEAP32[$96 >> 2];
    var $101 = $100 + 4 | 0;
    var $102 = HEAPF32[$101 >> 2];
    var $103 = $102;
    _lame_msgf($2, 5383264, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAPF64[tempDoublePtr >> 3] = $103, HEAP32[tempInt >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[tempInt + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2], tempInt));
    _lame_msgf($2, 5383212, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    var $104 = $2 + 84764 | 0;
    var $105 = HEAPF32[$104 >> 2];
    var $106 = $105;
    var $107 = _log10($106);
    var $108 = $107 * 10;
    var $109 = $2 + 84792 | 0;
    var $110 = HEAPF32[$109 >> 2];
    var $111 = $110;
    var $112 = _log10($111);
    var $113 = $112 * 10;
    var $114 = $2 + 84820 | 0;
    var $115 = HEAPF32[$114 >> 2];
    var $116 = $115;
    var $117 = _log10($116);
    var $118 = $117 * 10;
    var $119 = $2 + 84848 | 0;
    var $120 = HEAPF32[$119 >> 2];
    var $121 = $120;
    var $122 = _log10($121);
    var $123 = $122 * 10;
    _lame_msgf($2, 5383128, (tempInt = STACKTOP, STACKTOP = STACKTOP + 32 | 0, HEAPF64[tempDoublePtr >> 3] = $108, HEAP32[tempInt >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[tempInt + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2], HEAPF64[tempDoublePtr >> 3] = $113, HEAP32[tempInt + 8 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[tempInt + 12 >> 2] = HEAP32[tempDoublePtr + 4 >> 2], HEAPF64[tempDoublePtr >> 3] = $118, HEAP32[tempInt + 16 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[tempInt + 20 >> 2] = HEAP32[tempDoublePtr + 4 >> 2], HEAPF64[tempDoublePtr >> 3] = $123, HEAP32[tempInt + 24 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[tempInt + 28 >> 2] = HEAP32[tempDoublePtr + 4 >> 2], tempInt));
    var $124 = $2 + 92 | 0;
    var $125 = HEAP32[$124 >> 2];
    var $126 = ($125 | 0) != 0;
    var $127 = $126 ? 5383116 : 5383100;
    _lame_msgf($2, 5383052, (tempInt = STACKTOP, STACKTOP = STACKTOP + 4 | 0, HEAP32[tempInt >> 2] = $127, tempInt));
    var $128 = $2 + 188 | 0;
    var $129 = HEAPF32[$128 >> 2];
    var $130 = $129;
    _lame_msgf($2, 5383008, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAPF64[tempDoublePtr >> 3] = $130, HEAP32[tempInt >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[tempInt + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2], tempInt));
    _lame_msgf($2, 5385276, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    _lame_msgf($2, 5382996, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    STACKTOP = __stackBase__;
    return;
  }
}
_lame_print_internals["X"] = 1;
function _lame_encode_buffer($gfp, $pcm_l, $pcm_r, $nsamples, $mp3buf, $mp3buf_size) {
  return _lame_encode_buffer_template($gfp, $pcm_l, $pcm_r, $nsamples, $mp3buf, $mp3buf_size, 0, 1, 1);
}
function _lame_encode_buffer_template($gfp, $buffer_l, $buffer_r, $nsamples, $mp3buf, $mp3buf_size, $pcm_type, $aa, $norm) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = _is_lame_global_flags_valid($gfp);
    var $2 = ($1 | 0) == 0;
    if ($2) {
      var $_0 = -3;
      label = 12;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $4 = $gfp + 288 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = _is_lame_internal_flags_valid($5);
    var $7 = ($6 | 0) == 0;
    if ($7) {
      var $_0 = -3;
      label = 12;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $9 = ($nsamples | 0) == 0;
    if ($9) {
      var $_0 = 0;
      label = 12;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $11 = _update_inbuffer_size($5, $nsamples);
    var $12 = ($11 | 0) == 0;
    if ($12) {
      label = 6;
      break;
    } else {
      var $_0 = -2;
      label = 12;
      break;
    }
   case 6:
    var $14 = $5 + 68 | 0;
    var $15 = HEAP32[$14 >> 2];
    var $16 = ($15 | 0) > 1;
    var $17 = ($buffer_l | 0) == 0;
    if ($16) {
      label = 7;
      break;
    } else {
      label = 9;
      break;
    }
   case 7:
    var $19 = ($buffer_r | 0) == 0;
    var $or_cond = $17 | $19;
    if ($or_cond) {
      var $_0 = 0;
      label = 12;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    _lame_copy_inbuffer($5, $buffer_l, $buffer_r, $nsamples, $pcm_type, $aa, $norm);
    label = 11;
    break;
   case 9:
    if ($17) {
      var $_0 = 0;
      label = 12;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    _lame_copy_inbuffer($5, $buffer_l, $buffer_l, $nsamples, $pcm_type, $aa, $norm);
    label = 11;
    break;
   case 11:
    var $24 = _lame_encode_buffer_sample_t($5, $nsamples, $mp3buf, $mp3buf_size);
    var $_0 = $24;
    label = 12;
    break;
   case 12:
    var $_0;
    return $_0;
  }
}
function _lame_encode_buffer_float($gfp, $pcm_l, $pcm_r, $nsamples, $mp3buf, $mp3buf_size) {
  return _lame_encode_buffer_template($gfp, $pcm_l, $pcm_r, $nsamples, $mp3buf, $mp3buf_size, 3, 1, 1);
}
function _lame_encode_buffer_ieee_float($gfp, $pcm_l, $pcm_r, $nsamples, $mp3buf, $mp3buf_size) {
  return _lame_encode_buffer_template($gfp, $pcm_l, $pcm_r, $nsamples, $mp3buf, $mp3buf_size, 3, 1, 32767);
}
function _lame_encode_buffer_interleaved_ieee_float($gfp, $pcm, $nsamples, $mp3buf, $mp3buf_size) {
  return _lame_encode_buffer_template($gfp, $pcm, $pcm + 4 | 0, $nsamples, $mp3buf, $mp3buf_size, 3, 2, 32767);
}
function _lame_encode_buffer_ieee_double($gfp, $pcm_l, $pcm_r, $nsamples, $mp3buf, $mp3buf_size) {
  return _lame_encode_buffer_template($gfp, $pcm_l, $pcm_r, $nsamples, $mp3buf, $mp3buf_size, 4, 1, 32767);
}
function _lame_encode_buffer_interleaved_ieee_double($gfp, $pcm, $nsamples, $mp3buf, $mp3buf_size) {
  return _lame_encode_buffer_template($gfp, $pcm, $pcm + 8 | 0, $nsamples, $mp3buf, $mp3buf_size, 4, 2, 32767);
}
function _lame_encode_buffer_int($gfp, $pcm_l, $pcm_r, $nsamples, $mp3buf, $mp3buf_size) {
  return _lame_encode_buffer_template($gfp, $pcm_l, $pcm_r, $nsamples, $mp3buf, $mp3buf_size, 1, 1, 152587890625e-16);
}
function _lame_encode_buffer_long2($gfp, $pcm_l, $pcm_r, $nsamples, $mp3buf, $mp3buf_size) {
  return _lame_encode_buffer_template($gfp, $pcm_l, $pcm_r, $nsamples, $mp3buf, $mp3buf_size, 2, 1, 152587890625e-16);
}
function _lame_encode_buffer_long($gfp, $pcm_l, $pcm_r, $nsamples, $mp3buf, $mp3buf_size) {
  return _lame_encode_buffer_template($gfp, $pcm_l, $pcm_r, $nsamples, $mp3buf, $mp3buf_size, 2, 1, 1);
}
function _lame_encode_buffer_interleaved($gfp, $pcm, $nsamples, $mp3buf, $mp3buf_size) {
  return _lame_encode_buffer_template($gfp, $pcm, $pcm + 2 | 0, $nsamples, $mp3buf, $mp3buf_size, 0, 2, 1);
}
function _lame_encode_flush_nogap($gfp, $mp3buffer, $mp3buffer_size) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = _is_lame_global_flags_valid($gfp);
    var $2 = ($1 | 0) == 0;
    if ($2) {
      var $rc_0 = -3;
      label = 5;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $4 = $gfp + 288 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = _is_lame_internal_flags_valid($5);
    var $7 = ($6 | 0) == 0;
    if ($7) {
      var $rc_0 = -3;
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    _flush_bitstream($5);
    var $9 = _copy_buffer($5, $mp3buffer, $mp3buffer_size, 1);
    _save_gain_values($5);
    var $rc_0 = $9;
    label = 5;
    break;
   case 5:
    var $rc_0;
    return $rc_0;
  }
}
function _save_gain_values($gfc) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 85676 | 0;
    var $2 = $gfc + 128 | 0;
    var $3 = HEAP32[$2 >> 2];
    var $4 = ($3 | 0) == 0;
    if ($4) {
      label = 8;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $6 = $gfc + 85672 | 0;
    var $7 = HEAP32[$6 >> 2];
    var $8 = _GetTitleGain($7);
    var $9 = $8;
    var $fabsf = Math.abs($8);
    var $10 = $fabsf > 24601;
    var $11 = $8 + 24601;
    var $fabsf13 = Math.abs($11);
    var $12 = $fabsf13;
    if ($10) {
      label = 4;
      break;
    } else {
      label = 5;
      break;
    }
   case 4:
    var $14 = $fabsf;
    var $15 = $14 * 9.999999974752427e-7;
    var $16 = $12 > $15;
    if ($16) {
      label = 6;
      break;
    } else {
      label = 7;
      break;
    }
   case 5:
    var $18 = $12 > .024600999937888446;
    if ($18) {
      label = 6;
      break;
    } else {
      label = 7;
      break;
    }
   case 6:
    var $20 = $9 * 10;
    var $21 = $20 + .5;
    var $22 = Math.floor($21);
    var $23 = $22 & -1;
    var $24 = $gfc + 85684 | 0;
    HEAP32[$24 >> 2] = $23;
    label = 8;
    break;
   case 7:
    var $26 = $gfc + 85684 | 0;
    HEAP32[$26 >> 2] = 0;
    label = 8;
    break;
   case 8:
    var $28 = $gfc + 132 | 0;
    var $29 = HEAP32[$28 >> 2];
    var $30 = ($29 | 0) == 0;
    if ($30) {
      label = 12;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    var $32 = $gfc + 85680 | 0;
    var $33 = HEAPF32[$32 >> 2];
    var $34 = $33;
    var $35 = $34 / 32767;
    var $36 = _log10($35);
    var $37 = $36 * 20;
    var $38 = $37 * 10;
    var $39 = Math.ceil($38);
    var $40 = $39 & -1;
    var $41 = $gfc + 85688 | 0;
    HEAP32[$41 >> 2] = $40;
    var $42 = ($40 | 0) > 0;
    if ($42) {
      label = 10;
      break;
    } else {
      label = 11;
      break;
    }
   case 10:
    var $44 = HEAPF32[$32 >> 2];
    var $45 = 32767 / $44;
    var $46 = $45 * 100;
    var $floorf = Math.floor($46);
    var $47 = $floorf / 100;
    var $48 = $1 | 0;
    HEAPF32[$48 >> 2] = $47;
    label = 12;
    break;
   case 11:
    var $50 = $1 | 0;
    HEAPF32[$50 >> 2] = -1;
    label = 12;
    break;
   case 12:
    return;
  }
}
_save_gain_values["X"] = 1;
function _lame_encode_flush($gfp, $mp3buffer, $mp3buffer_size) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 4608 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $buffer = __stackBase__;
    var $1 = _is_lame_global_flags_valid($gfp);
    var $2 = ($1 | 0) == 0;
    if ($2) {
      var $_0 = -3;
      label = 15;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $4 = $gfp + 288 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = _is_lame_internal_flags_valid($5);
    var $7 = ($6 | 0) == 0;
    if ($7) {
      var $_0 = -3;
      label = 15;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $9 = $5 + 16 | 0;
    var $10 = $5 + 84028 | 0;
    var $11 = HEAP32[$10 >> 2];
    var $12 = ($11 | 0) < 1;
    if ($12) {
      var $_0 = 0;
      label = 15;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $14 = $5 + 76 | 0;
    var $15 = HEAP32[$14 >> 2];
    var $16 = $15 * 576 & -1;
    var $17 = _calcNeeded($9);
    var $18 = $11 - 1152 | 0;
    var $19 = $buffer;
    _memset($19, 0, 4608);
    var $20 = _isResamplingNecessary($9);
    var $21 = ($20 | 0) == 0;
    if ($21) {
      var $resample_ratio_0 = 1;
      var $samples_to_encode_0 = $18;
      label = 7;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    var $23 = $5 + 60 | 0;
    var $24 = HEAP32[$23 >> 2];
    var $25 = $24 | 0;
    var $26 = $5 + 64 | 0;
    var $27 = HEAP32[$26 >> 2];
    var $28 = $27 | 0;
    var $29 = $25 / $28;
    var $30 = 16 / $29;
    var $31 = $18 | 0;
    var $32 = $31 + $30;
    var $33 = $32 & -1;
    var $resample_ratio_0 = $29;
    var $samples_to_encode_0 = $33;
    label = 7;
    break;
   case 7:
    var $samples_to_encode_0;
    var $resample_ratio_0;
    var $35 = ($samples_to_encode_0 | 0) % ($16 | 0);
    var $36 = $16 - $35 | 0;
    var $37 = ($36 | 0) < 576;
    var $38 = $37 ? $16 : 0;
    var $end_padding_0 = $38 + $36 | 0;
    var $39 = $5 + 84760 | 0;
    HEAP32[$39 >> 2] = $end_padding_0;
    var $40 = $end_padding_0 + $samples_to_encode_0 | 0;
    var $41 = ($40 | 0) / ($16 | 0) & -1;
    var $42 = ($41 | 0) > 0;
    if ($42) {
      label = 9;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    HEAP32[$10 >> 2] = 0;
    var $_063_lcssa75 = $mp3buffer;
    var $mp3count_0_lcssa76 = 0;
    label = 12;
    break;
   case 9:
    var $43 = $5 + 84744 | 0;
    var $44 = $5 + 84032 | 0;
    var $45 = ($mp3buffer_size | 0) == 0;
    var $46 = $buffer | 0;
    var $47 = $buffer + 2304 | 0;
    var $frames_left_068 = $41;
    var $mp3count_069 = 0;
    var $_06370 = $mp3buffer;
    label = 10;
    break;
   case 10:
    var $_06370;
    var $mp3count_069;
    var $frames_left_068;
    var $49 = HEAP32[$43 >> 2];
    var $50 = HEAP32[$44 >> 2];
    var $51 = $17 - $50 | 0;
    var $52 = $51 | 0;
    var $53 = $resample_ratio_0 * $52;
    var $54 = $53 & -1;
    var $55 = ($54 | 0) > 1152;
    var $_ = $55 ? 1152 : $54;
    var $56 = ($_ | 0) < 1;
    var $bunch_1 = $56 ? 1 : $_;
    var $57 = $mp3buffer_size - $mp3count_069 | 0;
    var $_64 = $45 ? 0 : $57;
    var $58 = _lame_encode_buffer($gfp, $46, $47, $bunch_1, $_06370, $_64);
    var $59 = $_06370 + $58 | 0;
    var $60 = $58 + $mp3count_069 | 0;
    var $61 = HEAP32[$43 >> 2];
    var $62 = ($49 | 0) != ($61 | 0);
    var $63 = $62 & 1;
    var $64 = $frames_left_068 - $63 | 0;
    var $65 = ($64 | 0) > 0;
    var $66 = ($58 | 0) > -1;
    var $or_cond = $65 & $66;
    if ($or_cond) {
      var $frames_left_068 = $64;
      var $mp3count_069 = $60;
      var $_06370 = $59;
      label = 10;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    HEAP32[$10 >> 2] = 0;
    var $67 = ($58 | 0) < 0;
    if ($67) {
      var $_0 = $58;
      label = 15;
      break;
    } else {
      var $_063_lcssa75 = $59;
      var $mp3count_0_lcssa76 = $60;
      label = 12;
      break;
    }
   case 12:
    var $mp3count_0_lcssa76;
    var $_063_lcssa75;
    var $69 = $mp3buffer_size - $mp3count_0_lcssa76 | 0;
    var $70 = ($mp3buffer_size | 0) == 0;
    var $_65 = $70 ? 0 : $69;
    _flush_bitstream($5);
    var $71 = _copy_buffer($5, $_063_lcssa75, $_65, 1);
    _save_gain_values($5);
    var $72 = ($71 | 0) < 0;
    if ($72) {
      var $_0 = $71;
      label = 15;
      break;
    } else {
      label = 13;
      break;
    }
   case 13:
    var $74 = $71 + $mp3count_0_lcssa76 | 0;
    var $75 = $gfp + 68 | 0;
    var $76 = HEAP32[$75 >> 2];
    var $77 = ($76 | 0) == 0;
    if ($77) {
      var $_0 = $74;
      label = 15;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    var $79 = $mp3buffer_size - $74 | 0;
    var $_66 = $70 ? 0 : $79;
    var $80 = $_063_lcssa75 + $71 | 0;
    var $81 = _id3tag_write_v1($gfp);
    var $82 = _copy_buffer($5, $80, $_66, 0);
    var $83 = ($82 | 0) < 0;
    var $84 = $83 ? 0 : $74;
    var $_67 = $84 + $82 | 0;
    STACKTOP = __stackBase__;
    return $_67;
   case 15:
    var $_0;
    STACKTOP = __stackBase__;
    return $_0;
  }
}
_lame_encode_flush["X"] = 1;
function _lame_close($gfp) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($gfp | 0) == 0;
    if ($1) {
      var $ret_1 = 0;
      label = 8;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $gfp | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) == -487877;
    if ($5) {
      label = 4;
      break;
    } else {
      var $ret_1 = 0;
      label = 8;
      break;
    }
   case 4:
    var $7 = $gfp + 288 | 0;
    var $8 = HEAP32[$7 >> 2];
    HEAP32[$3 >> 2] = 0;
    var $9 = ($8 | 0) == 0;
    if ($9) {
      var $ret_013 = -3;
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $10 = $8 | 0;
    var $11 = HEAP32[$10 >> 2];
    var $12 = ($11 | 0) == -487877;
    var $_ = $12 ? 0 : -3;
    var $13 = $8 | 0;
    HEAP32[$13 >> 2] = 0;
    _freegfc($8);
    HEAP32[$7 >> 2] = 0;
    var $ret_013 = $_;
    label = 6;
    break;
   case 6:
    var $ret_013;
    var $14 = $gfp + 284 | 0;
    var $15 = HEAP32[$14 >> 2];
    var $16 = ($15 | 0) == 0;
    if ($16) {
      var $ret_1 = $ret_013;
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    HEAP32[$14 >> 2] = 0;
    var $18 = $gfp;
    _free($18);
    var $ret_1 = $ret_013;
    label = 8;
    break;
   case 8:
    var $ret_1;
    return $ret_1;
  }
}
function _lame_encode_finish($gfp, $mp3buffer, $mp3buffer_size) {
  var $1 = _lame_encode_flush($gfp, $mp3buffer, $mp3buffer_size);
  _lame_close($gfp);
  return $1;
}
function _lame_mp3_tags_fid($gfp, $fpStream) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = _is_lame_global_flags_valid($gfp);
    var $2 = ($1 | 0) == 0;
    if ($2) {
      label = 10;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $4 = $gfp + 288 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = _is_lame_internal_flags_valid($5);
    var $7 = ($6 | 0) == 0;
    if ($7) {
      label = 10;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $9 = $5 + 156 | 0;
    var $10 = HEAP32[$9 >> 2];
    var $11 = ($10 | 0) == 0;
    var $12 = ($fpStream | 0) == 0;
    var $or_cond = $11 | $12;
    if ($or_cond) {
      label = 10;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $14 = _fseek($fpStream, 0, 0);
    var $15 = ($14 | 0) == 0;
    if ($15) {
      label = 6;
      break;
    } else {
      label = 10;
      break;
    }
   case 6:
    var $17 = _PutVbrTag($gfp, $fpStream);
    if (($17 | 0) == -1) {
      label = 7;
      break;
    } else if (($17 | 0) == -2) {
      label = 8;
      break;
    } else if (($17 | 0) == -3) {
      label = 9;
      break;
    } else {
      label = 10;
      break;
    }
   case 7:
    _lame_errorf($5, 5382952, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    label = 10;
    break;
   case 8:
    _lame_errorf($5, 5382884, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    label = 10;
    break;
   case 9:
    _lame_errorf($5, 5382792, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    label = 10;
    break;
   case 10:
    STACKTOP = __stackBase__;
    return;
  }
}
function _lame_init() {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    _init_log_table();
    var $1 = _calloc(1, 304);
    var $2 = $1;
    var $3 = ($1 | 0) == 0;
    if ($3) {
      var $_0 = 0;
      label = 6;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $5 = _lame_init_old($2);
    var $6 = ($5 | 0) == 0;
    if ($6) {
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    _free($1);
    var $_0 = 0;
    label = 6;
    break;
   case 5:
    var $9 = $1 + 284 | 0;
    var $10 = $9;
    HEAP32[$10 >> 2] = 1;
    var $_0 = $2;
    label = 6;
    break;
   case 6:
    var $_0;
    return $_0;
  }
}
function _lame_init_old($gfp) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfp;
    for (var $$dest = $1 >> 2, $$stop = $$dest + 76; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $2 = $gfp | 0;
    HEAP32[$2 >> 2] = -487877;
    var $3 = _calloc(1, 85836);
    var $4 = $3;
    var $5 = $gfp + 288 | 0;
    HEAP32[$5 >> 2] = $4;
    var $6 = ($3 | 0) == 0;
    if ($6) {
      var $_0 = -1;
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $8 = $gfp + 124 | 0;
    HEAP32[$8 >> 2] = 2;
    var $9 = $gfp + 48 | 0;
    HEAP32[$9 >> 2] = 4;
    var $10 = $gfp + 108 | 0;
    HEAP32[$10 >> 2] = 1;
    var $11 = $gfp + 12 | 0;
    HEAP32[$11 >> 2] = 44100;
    var $12 = $gfp + 8 | 0;
    HEAP32[$12 >> 2] = 2;
    var $13 = $gfp + 4 | 0;
    HEAP32[$13 >> 2] = -1;
    var $14 = $gfp + 36 | 0;
    HEAP32[$14 >> 2] = 1;
    var $15 = $gfp + 44 | 0;
    HEAP32[$15 >> 2] = -1;
    var $16 = $gfp + 240 | 0;
    HEAP32[$16 >> 2] = -1;
    var $17 = $gfp + 88 | 0;
    HEAP32[$17 >> 2] = -1;
    var $18 = $gfp + 184 | 0;
    HEAP32[$18 >> 2] = 0;
    var $19 = $gfp + 188 | 0;
    HEAP32[$19 >> 2] = 0;
    var $20 = $gfp + 192 | 0;
    HEAP32[$20 >> 2] = -1;
    var $21 = $gfp + 196 | 0;
    HEAP32[$21 >> 2] = -1;
    var $22 = $gfp + 156 | 0;
    HEAP32[$22 >> 2] = 0;
    var $23 = $gfp + 164 | 0;
    HEAP32[$23 >> 2] = 4;
    var $24 = $gfp + 224 | 0;
    HEAPF32[$24 >> 2] = -1;
    var $25 = $gfp + 168 | 0;
    HEAP32[$25 >> 2] = 128;
    var $26 = $gfp + 172 | 0;
    HEAP32[$26 >> 2] = 0;
    var $27 = $gfp + 176 | 0;
    HEAP32[$27 >> 2] = 0;
    var $28 = $gfp + 180 | 0;
    HEAP32[$28 >> 2] = 0;
    var $29 = $3 + 112 | 0;
    var $30 = $29;
    HEAP32[$30 >> 2] = 1;
    var $31 = $3 + 116 | 0;
    var $32 = $31;
    HEAP32[$32 >> 2] = 13;
    var $33 = $gfp + 132 | 0;
    HEAP32[$33 >> 2] = -1;
    var $34 = $gfp + 136 | 0;
    HEAP32[$34 >> 2] = -1;
    var $35 = $gfp + 252 | 0;
    HEAPF32[$35 >> 2] = -1;
    var $36 = $3 + 84916 | 0;
    var $37 = $36;
    HEAP32[$37 >> 2] = 180;
    var $38 = $3 + 84920 | 0;
    var $39 = $38;
    HEAP32[$39 >> 2] = 180;
    var $40 = $3 + 84924 | 0;
    var $41 = $40;
    HEAP32[$41 >> 2] = 4;
    var $42 = $3 + 84928 | 0;
    var $43 = $42;
    HEAP32[$43 >> 2] = 4;
    var $44 = $3 + 84904 | 0;
    var $45 = $44;
    HEAPF32[$45 >> 2] = 1;
    var $46 = $gfp + 264 | 0;
    HEAPF32[$46 >> 2] = -1;
    var $47 = $gfp + 268 | 0;
    HEAPF32[$47 >> 2] = -1;
    var $48 = $gfp + 20 | 0;
    HEAPF32[$48 >> 2] = 1;
    var $49 = $gfp + 24 | 0;
    HEAPF32[$49 >> 2] = 1;
    var $50 = $gfp + 28 | 0;
    HEAPF32[$50 >> 2] = 1;
    var $51 = $gfp + 232 | 0;
    HEAP32[$51 >> 2] = -1;
    var $52 = $gfp + 220 | 0;
    HEAP32[$52 >> 2] = -1;
    var $53 = $gfp + 236 | 0;
    HEAPF32[$53 >> 2] = 0;
    var $54 = $gfp + 244 | 0;
    HEAP32[$54 >> 2] = -1;
    var $55 = $gfp + 248 | 0;
    HEAPF32[$55 >> 2] = -1;
    var $56 = $3 + 84028 | 0;
    var $57 = $56;
    HEAP32[$57 >> 2] = 1728;
    var $58 = $3 + 84760 | 0;
    var $59 = $58;
    HEAP32[$59 >> 2] = 0;
    var $60 = $3 + 84032 | 0;
    var $61 = $60;
    HEAP32[$61 >> 2] = 528;
    var $62 = $gfp + 60 | 0;
    HEAP32[$62 >> 2] = 0;
    var $63 = $gfp + 64 | 0;
    HEAP32[$63 >> 2] = 0;
    var $64 = $3 + 136 | 0;
    var $65 = $64;
    HEAP32[$65 >> 2] = 0;
    var $66 = $3 + 128 | 0;
    var $67 = $66;
    HEAP32[$67 >> 2] = 0;
    var $68 = $3 + 132 | 0;
    var $69 = $68;
    HEAP32[$69 >> 2] = 0;
    var $70 = $3 + 85676 | 0;
    var $71 = $3 + 85684 | 0;
    var $72 = $71;
    HEAP32[$72 >> 2] = 0;
    var $73 = $3 + 85688 | 0;
    var $74 = $73;
    HEAP32[$74 >> 2] = 0;
    var $75 = $70;
    HEAPF32[$75 >> 2] = -1;
    var $76 = $gfp + 292 | 0;
    HEAP32[$76 >> 2] = 1;
    var $77 = $gfp + 296 | 0;
    HEAP32[$77 >> 2] = 1;
    var $78 = $gfp + 300 | 0;
    HEAP32[$78 >> 2] = 1;
    var $79 = $gfp + 152 | 0;
    HEAP32[$79 >> 2] = 0;
    var $80 = $gfp + 68 | 0;
    HEAP32[$80 >> 2] = 1;
    var $81 = $gfp + 276 | 0;
    HEAP32[$81 >> 2] = 52;
    var $82 = $gfp + 280 | 0;
    HEAP32[$82 >> 2] = 52;
    var $83 = $gfp + 272 | 0;
    HEAP32[$83 >> 2] = 52;
    var $_0 = 0;
    label = 4;
    break;
   case 4:
    var $_0;
    return $_0;
  }
}
_lame_init_old["X"] = 1;
function _lame_copy_inbuffer($gfc, $l, $r, $nsamples, $pcm_type, $jump, $s) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 52148 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $gfc + 52152 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = $gfc + 264 | 0;
    var $6 = HEAPF32[$5 >> 2];
    var $7 = $6 * $s;
    var $8 = $gfc + 268 | 0;
    var $9 = HEAPF32[$8 >> 2];
    var $10 = $9 * $s;
    var $11 = $gfc + 272 | 0;
    var $12 = HEAPF32[$11 >> 2];
    var $13 = $12 * $s;
    var $14 = $gfc + 276 | 0;
    var $15 = HEAPF32[$14 >> 2];
    var $16 = $15 * $s;
    if (($pcm_type | 0) == 0) {
      label = 3;
      break;
    } else if (($pcm_type | 0) == 1) {
      label = 6;
      break;
    } else if (($pcm_type | 0) == 2) {
      label = 9;
      break;
    } else if (($pcm_type | 0) == 3) {
      label = 12;
      break;
    } else if (($pcm_type | 0) == 4) {
      label = 15;
      break;
    } else {
      label = 18;
      break;
    }
   case 3:
    var $18 = ($nsamples | 0) > 0;
    if ($18) {
      label = 4;
      break;
    } else {
      label = 18;
      break;
    }
   case 4:
    var $19 = $r;
    var $20 = $l;
    var $i_095 = 0;
    var $br_096 = $19;
    var $bl_097 = $20;
    label = 5;
    break;
   case 5:
    var $bl_097;
    var $br_096;
    var $i_095;
    var $22 = HEAP16[$bl_097 >> 1];
    var $23 = $22 << 16 >> 16;
    var $24 = HEAP16[$br_096 >> 1];
    var $25 = $24 << 16 >> 16;
    var $26 = $7 * $23;
    var $27 = $10 * $25;
    var $28 = $26 + $27;
    var $29 = $13 * $23;
    var $30 = $16 * $25;
    var $31 = $29 + $30;
    var $32 = $2 + ($i_095 << 2) | 0;
    HEAPF32[$32 >> 2] = $28;
    var $33 = $4 + ($i_095 << 2) | 0;
    HEAPF32[$33 >> 2] = $31;
    var $34 = $bl_097 + ($jump << 1) | 0;
    var $35 = $br_096 + ($jump << 1) | 0;
    var $36 = $i_095 + 1 | 0;
    var $exitcond = ($36 | 0) == ($nsamples | 0);
    if ($exitcond) {
      label = 18;
      break;
    } else {
      var $i_095 = $36;
      var $br_096 = $35;
      var $bl_097 = $34;
      label = 5;
      break;
    }
   case 6:
    var $38 = ($nsamples | 0) > 0;
    if ($38) {
      label = 7;
      break;
    } else {
      label = 18;
      break;
    }
   case 7:
    var $39 = $r;
    var $40 = $l;
    var $i3_099 = 0;
    var $br2_0100 = $39;
    var $bl1_0101 = $40;
    label = 8;
    break;
   case 8:
    var $bl1_0101;
    var $br2_0100;
    var $i3_099;
    var $42 = HEAP32[$bl1_0101 >> 2];
    var $43 = $42 | 0;
    var $44 = HEAP32[$br2_0100 >> 2];
    var $45 = $44 | 0;
    var $46 = $7 * $43;
    var $47 = $10 * $45;
    var $48 = $46 + $47;
    var $49 = $13 * $43;
    var $50 = $16 * $45;
    var $51 = $49 + $50;
    var $52 = $2 + ($i3_099 << 2) | 0;
    HEAPF32[$52 >> 2] = $48;
    var $53 = $4 + ($i3_099 << 2) | 0;
    HEAPF32[$53 >> 2] = $51;
    var $54 = $bl1_0101 + ($jump << 2) | 0;
    var $55 = $br2_0100 + ($jump << 2) | 0;
    var $56 = $i3_099 + 1 | 0;
    var $exitcond118 = ($56 | 0) == ($nsamples | 0);
    if ($exitcond118) {
      label = 18;
      break;
    } else {
      var $i3_099 = $56;
      var $br2_0100 = $55;
      var $bl1_0101 = $54;
      label = 8;
      break;
    }
   case 9:
    var $58 = ($nsamples | 0) > 0;
    if ($58) {
      label = 10;
      break;
    } else {
      label = 18;
      break;
    }
   case 10:
    var $59 = $r;
    var $60 = $l;
    var $i10_0104 = 0;
    var $br9_0105 = $59;
    var $bl8_0106 = $60;
    label = 11;
    break;
   case 11:
    var $bl8_0106;
    var $br9_0105;
    var $i10_0104;
    var $62 = HEAP32[$bl8_0106 >> 2];
    var $63 = $62 | 0;
    var $64 = HEAP32[$br9_0105 >> 2];
    var $65 = $64 | 0;
    var $66 = $7 * $63;
    var $67 = $10 * $65;
    var $68 = $66 + $67;
    var $69 = $13 * $63;
    var $70 = $16 * $65;
    var $71 = $69 + $70;
    var $72 = $2 + ($i10_0104 << 2) | 0;
    HEAPF32[$72 >> 2] = $68;
    var $73 = $4 + ($i10_0104 << 2) | 0;
    HEAPF32[$73 >> 2] = $71;
    var $74 = $bl8_0106 + ($jump << 2) | 0;
    var $75 = $br9_0105 + ($jump << 2) | 0;
    var $76 = $i10_0104 + 1 | 0;
    var $exitcond119 = ($76 | 0) == ($nsamples | 0);
    if ($exitcond119) {
      label = 18;
      break;
    } else {
      var $i10_0104 = $76;
      var $br9_0105 = $75;
      var $bl8_0106 = $74;
      label = 11;
      break;
    }
   case 12:
    var $78 = ($nsamples | 0) > 0;
    if ($78) {
      label = 13;
      break;
    } else {
      label = 18;
      break;
    }
   case 13:
    var $79 = $r;
    var $80 = $l;
    var $bl15_0109 = $80;
    var $br16_0110 = $79;
    var $i17_0111 = 0;
    label = 14;
    break;
   case 14:
    var $i17_0111;
    var $br16_0110;
    var $bl15_0109;
    var $82 = HEAPF32[$bl15_0109 >> 2];
    var $83 = HEAPF32[$br16_0110 >> 2];
    var $84 = $7 * $82;
    var $85 = $10 * $83;
    var $86 = $84 + $85;
    var $87 = $13 * $82;
    var $88 = $16 * $83;
    var $89 = $87 + $88;
    var $90 = $2 + ($i17_0111 << 2) | 0;
    HEAPF32[$90 >> 2] = $86;
    var $91 = $4 + ($i17_0111 << 2) | 0;
    HEAPF32[$91 >> 2] = $89;
    var $92 = $bl15_0109 + ($jump << 2) | 0;
    var $93 = $br16_0110 + ($jump << 2) | 0;
    var $94 = $i17_0111 + 1 | 0;
    var $exitcond120 = ($94 | 0) == ($nsamples | 0);
    if ($exitcond120) {
      label = 18;
      break;
    } else {
      var $bl15_0109 = $92;
      var $br16_0110 = $93;
      var $i17_0111 = $94;
      label = 14;
      break;
    }
   case 15:
    var $96 = ($nsamples | 0) > 0;
    if ($96) {
      label = 16;
      break;
    } else {
      label = 18;
      break;
    }
   case 16:
    var $97 = $r;
    var $98 = $l;
    var $bl22_0114 = $98;
    var $br23_0115 = $97;
    var $i24_0116 = 0;
    label = 17;
    break;
   case 17:
    var $i24_0116;
    var $br23_0115;
    var $bl22_0114;
    var $100 = (HEAP32[tempDoublePtr >> 2] = HEAP32[$bl22_0114 >> 2], HEAP32[tempDoublePtr + 4 >> 2] = HEAP32[$bl22_0114 + 4 >> 2], HEAPF64[tempDoublePtr >> 3]);
    var $101 = $100;
    var $102 = (HEAP32[tempDoublePtr >> 2] = HEAP32[$br23_0115 >> 2], HEAP32[tempDoublePtr + 4 >> 2] = HEAP32[$br23_0115 + 4 >> 2], HEAPF64[tempDoublePtr >> 3]);
    var $103 = $102;
    var $104 = $7 * $101;
    var $105 = $10 * $103;
    var $106 = $104 + $105;
    var $107 = $13 * $101;
    var $108 = $16 * $103;
    var $109 = $107 + $108;
    var $110 = $2 + ($i24_0116 << 2) | 0;
    HEAPF32[$110 >> 2] = $106;
    var $111 = $4 + ($i24_0116 << 2) | 0;
    HEAPF32[$111 >> 2] = $109;
    var $112 = $bl22_0114 + ($jump << 3) | 0;
    var $113 = $br23_0115 + ($jump << 3) | 0;
    var $114 = $i24_0116 + 1 | 0;
    var $exitcond121 = ($114 | 0) == ($nsamples | 0);
    if ($exitcond121) {
      label = 18;
      break;
    } else {
      var $bl22_0114 = $112;
      var $br23_0115 = $113;
      var $i24_0116 = $114;
      label = 17;
      break;
    }
   case 18:
    return;
  }
}
_lame_copy_inbuffer["X"] = 1;
function _lame_bitrate_kbps($gfp, $bitrate_kbps) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $bitrate_kbps17 = $bitrate_kbps;
    var $1 = _is_lame_global_flags_valid($gfp);
    var $2 = ($1 | 0) == 0;
    if ($2) {
      label = 7;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $4 = $gfp + 288 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = _is_lame_internal_flags_valid($5);
    var $7 = ($6 | 0) == 0;
    if ($7) {
      label = 7;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $9 = $5 + 152 | 0;
    var $10 = HEAP32[$9 >> 2];
    var $11 = ($10 | 0) == 0;
    if ($11) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    for (var $$dest = $bitrate_kbps17 >> 2, $$stop = $$dest + 14; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = -1;
    }
    var $13 = $5 + 120 | 0;
    var $14 = HEAP32[$13 >> 2];
    HEAP32[$bitrate_kbps >> 2] = $14;
    label = 7;
    break;
   case 6:
    var $15 = $5 + 16 | 0;
    var $16 = HEAP32[$15 >> 2];
    var $17 = 5348688 + ($16 << 6) | 0;
    var $18 = HEAP32[$17 >> 2];
    HEAP32[$bitrate_kbps >> 2] = $18;
    var $19 = HEAP32[$15 >> 2];
    var $20 = 5348692 + ($19 << 6) | 0;
    var $21 = HEAP32[$20 >> 2];
    var $22 = $bitrate_kbps + 4 | 0;
    HEAP32[$22 >> 2] = $21;
    var $23 = HEAP32[$15 >> 2];
    var $24 = 5348696 + ($23 << 6) | 0;
    var $25 = HEAP32[$24 >> 2];
    var $26 = $bitrate_kbps + 8 | 0;
    HEAP32[$26 >> 2] = $25;
    var $27 = HEAP32[$15 >> 2];
    var $28 = 5348700 + ($27 << 6) | 0;
    var $29 = HEAP32[$28 >> 2];
    var $30 = $bitrate_kbps + 12 | 0;
    HEAP32[$30 >> 2] = $29;
    var $31 = HEAP32[$15 >> 2];
    var $32 = 5348704 + ($31 << 6) | 0;
    var $33 = HEAP32[$32 >> 2];
    var $34 = $bitrate_kbps + 16 | 0;
    HEAP32[$34 >> 2] = $33;
    var $35 = HEAP32[$15 >> 2];
    var $36 = 5348708 + ($35 << 6) | 0;
    var $37 = HEAP32[$36 >> 2];
    var $38 = $bitrate_kbps + 20 | 0;
    HEAP32[$38 >> 2] = $37;
    var $39 = HEAP32[$15 >> 2];
    var $40 = 5348712 + ($39 << 6) | 0;
    var $41 = HEAP32[$40 >> 2];
    var $42 = $bitrate_kbps + 24 | 0;
    HEAP32[$42 >> 2] = $41;
    var $43 = HEAP32[$15 >> 2];
    var $44 = 5348716 + ($43 << 6) | 0;
    var $45 = HEAP32[$44 >> 2];
    var $46 = $bitrate_kbps + 28 | 0;
    HEAP32[$46 >> 2] = $45;
    var $47 = HEAP32[$15 >> 2];
    var $48 = 5348720 + ($47 << 6) | 0;
    var $49 = HEAP32[$48 >> 2];
    var $50 = $bitrate_kbps + 32 | 0;
    HEAP32[$50 >> 2] = $49;
    var $51 = HEAP32[$15 >> 2];
    var $52 = 5348724 + ($51 << 6) | 0;
    var $53 = HEAP32[$52 >> 2];
    var $54 = $bitrate_kbps + 36 | 0;
    HEAP32[$54 >> 2] = $53;
    var $55 = HEAP32[$15 >> 2];
    var $56 = 5348728 + ($55 << 6) | 0;
    var $57 = HEAP32[$56 >> 2];
    var $58 = $bitrate_kbps + 40 | 0;
    HEAP32[$58 >> 2] = $57;
    var $59 = HEAP32[$15 >> 2];
    var $60 = 5348732 + ($59 << 6) | 0;
    var $61 = HEAP32[$60 >> 2];
    var $62 = $bitrate_kbps + 44 | 0;
    HEAP32[$62 >> 2] = $61;
    var $63 = HEAP32[$15 >> 2];
    var $64 = 5348736 + ($63 << 6) | 0;
    var $65 = HEAP32[$64 >> 2];
    var $66 = $bitrate_kbps + 48 | 0;
    HEAP32[$66 >> 2] = $65;
    var $67 = HEAP32[$15 >> 2];
    var $68 = 5348740 + ($67 << 6) | 0;
    var $69 = HEAP32[$68 >> 2];
    var $70 = $bitrate_kbps + 52 | 0;
    HEAP32[$70 >> 2] = $69;
    label = 7;
    break;
   case 7:
    return;
  }
}
_lame_bitrate_kbps["X"] = 1;
function _lame_bitrate_hist($gfp, $bitrate_count) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $bitrate_count17 = $bitrate_count;
    var $1 = _is_lame_global_flags_valid($gfp);
    var $2 = ($1 | 0) == 0;
    if ($2) {
      label = 7;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $4 = $gfp + 288 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = _is_lame_internal_flags_valid($5);
    var $7 = ($6 | 0) == 0;
    if ($7) {
      label = 7;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $9 = $5 + 152 | 0;
    var $10 = HEAP32[$9 >> 2];
    var $11 = ($10 | 0) == 0;
    if ($11) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    for (var $$dest = $bitrate_count17 >> 2, $$stop = $$dest + 14; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $13 = $5 + 84052 | 0;
    var $14 = HEAP32[$13 >> 2];
    HEAP32[$bitrate_count >> 2] = $14;
    label = 7;
    break;
   case 6:
    var $15 = $5 + 84072 | 0;
    var $16 = HEAP32[$15 >> 2];
    HEAP32[$bitrate_count >> 2] = $16;
    var $17 = $5 + 84092 | 0;
    var $18 = HEAP32[$17 >> 2];
    var $19 = $bitrate_count + 4 | 0;
    HEAP32[$19 >> 2] = $18;
    var $20 = $5 + 84112 | 0;
    var $21 = HEAP32[$20 >> 2];
    var $22 = $bitrate_count + 8 | 0;
    HEAP32[$22 >> 2] = $21;
    var $23 = $5 + 84132 | 0;
    var $24 = HEAP32[$23 >> 2];
    var $25 = $bitrate_count + 12 | 0;
    HEAP32[$25 >> 2] = $24;
    var $26 = $5 + 84152 | 0;
    var $27 = HEAP32[$26 >> 2];
    var $28 = $bitrate_count + 16 | 0;
    HEAP32[$28 >> 2] = $27;
    var $29 = $5 + 84172 | 0;
    var $30 = HEAP32[$29 >> 2];
    var $31 = $bitrate_count + 20 | 0;
    HEAP32[$31 >> 2] = $30;
    var $32 = $5 + 84192 | 0;
    var $33 = HEAP32[$32 >> 2];
    var $34 = $bitrate_count + 24 | 0;
    HEAP32[$34 >> 2] = $33;
    var $35 = $5 + 84212 | 0;
    var $36 = HEAP32[$35 >> 2];
    var $37 = $bitrate_count + 28 | 0;
    HEAP32[$37 >> 2] = $36;
    var $38 = $5 + 84232 | 0;
    var $39 = HEAP32[$38 >> 2];
    var $40 = $bitrate_count + 32 | 0;
    HEAP32[$40 >> 2] = $39;
    var $41 = $5 + 84252 | 0;
    var $42 = HEAP32[$41 >> 2];
    var $43 = $bitrate_count + 36 | 0;
    HEAP32[$43 >> 2] = $42;
    var $44 = $5 + 84272 | 0;
    var $45 = HEAP32[$44 >> 2];
    var $46 = $bitrate_count + 40 | 0;
    HEAP32[$46 >> 2] = $45;
    var $47 = $5 + 84292 | 0;
    var $48 = HEAP32[$47 >> 2];
    var $49 = $bitrate_count + 44 | 0;
    HEAP32[$49 >> 2] = $48;
    var $50 = $5 + 84312 | 0;
    var $51 = HEAP32[$50 >> 2];
    var $52 = $bitrate_count + 48 | 0;
    HEAP32[$52 >> 2] = $51;
    var $53 = $5 + 84332 | 0;
    var $54 = HEAP32[$53 >> 2];
    var $55 = $bitrate_count + 52 | 0;
    HEAP32[$55 >> 2] = $54;
    label = 7;
    break;
   case 7:
    return;
  }
}
_lame_bitrate_hist["X"] = 1;
function _lame_stereo_mode_hist($gfp, $stmode_count) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = _is_lame_global_flags_valid($gfp);
    var $2 = ($1 | 0) == 0;
    if ($2) {
      label = 5;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $4 = $gfp + 288 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = _is_lame_internal_flags_valid($5);
    var $7 = ($6 | 0) == 0;
    if ($7) {
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $8 = $5 + 84336 | 0;
    var $9 = HEAP32[$8 >> 2];
    HEAP32[$stmode_count >> 2] = $9;
    var $10 = $5 + 84340 | 0;
    var $11 = HEAP32[$10 >> 2];
    var $12 = $stmode_count + 4 | 0;
    HEAP32[$12 >> 2] = $11;
    var $13 = $5 + 84344 | 0;
    var $14 = HEAP32[$13 >> 2];
    var $15 = $stmode_count + 8 | 0;
    HEAP32[$15 >> 2] = $14;
    var $16 = $5 + 84348 | 0;
    var $17 = HEAP32[$16 >> 2];
    var $18 = $stmode_count + 12 | 0;
    HEAP32[$18 >> 2] = $17;
    label = 5;
    break;
   case 5:
    return;
  }
}
function _lame_bitrate_stereo_mode_hist($gfp, $bitrate_stmode_count) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $bitrate_stmode_count41 = $bitrate_stmode_count;
    var $1 = _is_lame_global_flags_valid($gfp);
    var $2 = ($1 | 0) == 0;
    if ($2) {
      label = 7;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $4 = $gfp + 288 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = _is_lame_internal_flags_valid($5);
    var $7 = ($6 | 0) == 0;
    if ($7) {
      label = 7;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $9 = $5 + 152 | 0;
    var $10 = HEAP32[$9 >> 2];
    var $11 = ($10 | 0) == 0;
    if ($11) {
      var $j_127 = 0;
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    for (var $$dest = $bitrate_stmode_count41 >> 2, $$stop = $$dest + 56; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $12 = $5 + 84036 | 0;
    var $13 = HEAP32[$12 >> 2];
    var $14 = $bitrate_stmode_count | 0;
    HEAP32[$14 >> 2] = $13;
    var $15 = $5 + 84040 | 0;
    var $16 = HEAP32[$15 >> 2];
    var $17 = $bitrate_stmode_count + 4 | 0;
    HEAP32[$17 >> 2] = $16;
    var $18 = $5 + 84044 | 0;
    var $19 = HEAP32[$18 >> 2];
    var $20 = $bitrate_stmode_count + 8 | 0;
    HEAP32[$20 >> 2] = $19;
    var $21 = $5 + 84048 | 0;
    var $22 = HEAP32[$21 >> 2];
    var $23 = $bitrate_stmode_count + 12 | 0;
    HEAP32[$23 >> 2] = $22;
    label = 7;
    break;
   case 6:
    var $j_127;
    var $24 = $j_127 + 1 | 0;
    var $25 = $5 + 84036 + $24 * 20 | 0;
    var $26 = HEAP32[$25 >> 2];
    var $27 = $bitrate_stmode_count + ($j_127 << 4) | 0;
    HEAP32[$27 >> 2] = $26;
    var $28 = $5 + 84036 + $24 * 20 + 4 | 0;
    var $29 = HEAP32[$28 >> 2];
    var $30 = $bitrate_stmode_count + ($j_127 << 4) + 4 | 0;
    HEAP32[$30 >> 2] = $29;
    var $31 = $5 + 84036 + $24 * 20 + 8 | 0;
    var $32 = HEAP32[$31 >> 2];
    var $33 = $bitrate_stmode_count + ($j_127 << 4) + 8 | 0;
    HEAP32[$33 >> 2] = $32;
    var $34 = $5 + 84036 + $24 * 20 + 12 | 0;
    var $35 = HEAP32[$34 >> 2];
    var $36 = $bitrate_stmode_count + ($j_127 << 4) + 12 | 0;
    HEAP32[$36 >> 2] = $35;
    var $exitcond = ($24 | 0) == 14;
    if ($exitcond) {
      label = 7;
      break;
    } else {
      var $j_127 = $24;
      label = 6;
      break;
    }
   case 7:
    return;
  }
}
_lame_bitrate_stereo_mode_hist["X"] = 1;
function _lame_block_type_hist($gfp, $btype_count) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = _is_lame_global_flags_valid($gfp);
    var $2 = ($1 | 0) == 0;
    if ($2) {
      label = 5;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $4 = $gfp + 288 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = _is_lame_internal_flags_valid($5);
    var $7 = ($6 | 0) == 0;
    if ($7) {
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $8 = $5 + 84716 | 0;
    var $9 = HEAP32[$8 >> 2];
    HEAP32[$btype_count >> 2] = $9;
    var $10 = $5 + 84720 | 0;
    var $11 = HEAP32[$10 >> 2];
    var $12 = $btype_count + 4 | 0;
    HEAP32[$12 >> 2] = $11;
    var $13 = $5 + 84724 | 0;
    var $14 = HEAP32[$13 >> 2];
    var $15 = $btype_count + 8 | 0;
    HEAP32[$15 >> 2] = $14;
    var $16 = $5 + 84728 | 0;
    var $17 = HEAP32[$16 >> 2];
    var $18 = $btype_count + 12 | 0;
    HEAP32[$18 >> 2] = $17;
    var $19 = $5 + 84732 | 0;
    var $20 = HEAP32[$19 >> 2];
    var $21 = $btype_count + 16 | 0;
    HEAP32[$21 >> 2] = $20;
    var $22 = $5 + 84736 | 0;
    var $23 = HEAP32[$22 >> 2];
    var $24 = $btype_count + 20 | 0;
    HEAP32[$24 >> 2] = $23;
    label = 5;
    break;
   case 5:
    return;
  }
}
function _lame_bitrate_block_type_hist($gfp, $bitrate_btype_count) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $bitrate_btype_count41 = $bitrate_btype_count;
    var $1 = _is_lame_global_flags_valid($gfp);
    var $2 = ($1 | 0) == 0;
    if ($2) {
      label = 7;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $4 = $gfp + 288 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = _is_lame_internal_flags_valid($5);
    var $7 = ($6 | 0) == 0;
    if ($7) {
      label = 7;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $9 = $5 + 152 | 0;
    var $10 = HEAP32[$9 >> 2];
    var $11 = ($10 | 0) == 0;
    if ($11) {
      var $j_127 = 0;
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    for (var $$dest = $bitrate_btype_count41 >> 2, $$stop = $$dest + 84; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $12 = $5 + 84356 | 0;
    var $13 = HEAP32[$12 >> 2];
    var $14 = $bitrate_btype_count | 0;
    HEAP32[$14 >> 2] = $13;
    var $15 = $5 + 84360 | 0;
    var $16 = HEAP32[$15 >> 2];
    var $17 = $bitrate_btype_count + 4 | 0;
    HEAP32[$17 >> 2] = $16;
    var $18 = $5 + 84364 | 0;
    var $19 = HEAP32[$18 >> 2];
    var $20 = $bitrate_btype_count + 8 | 0;
    HEAP32[$20 >> 2] = $19;
    var $21 = $5 + 84368 | 0;
    var $22 = HEAP32[$21 >> 2];
    var $23 = $bitrate_btype_count + 12 | 0;
    HEAP32[$23 >> 2] = $22;
    var $24 = $5 + 84372 | 0;
    var $25 = HEAP32[$24 >> 2];
    var $26 = $bitrate_btype_count + 16 | 0;
    HEAP32[$26 >> 2] = $25;
    var $27 = $5 + 84376 | 0;
    var $28 = HEAP32[$27 >> 2];
    var $29 = $bitrate_btype_count + 20 | 0;
    HEAP32[$29 >> 2] = $28;
    label = 7;
    break;
   case 6:
    var $j_127;
    var $30 = $j_127 + 1 | 0;
    var $31 = $5 + 84356 + $30 * 24 | 0;
    var $32 = HEAP32[$31 >> 2];
    var $33 = $bitrate_btype_count + $j_127 * 24 | 0;
    HEAP32[$33 >> 2] = $32;
    var $34 = $5 + 84356 + $30 * 24 + 4 | 0;
    var $35 = HEAP32[$34 >> 2];
    var $36 = $bitrate_btype_count + $j_127 * 24 + 4 | 0;
    HEAP32[$36 >> 2] = $35;
    var $37 = $5 + 84356 + $30 * 24 + 8 | 0;
    var $38 = HEAP32[$37 >> 2];
    var $39 = $bitrate_btype_count + $j_127 * 24 + 8 | 0;
    HEAP32[$39 >> 2] = $38;
    var $40 = $5 + 84356 + $30 * 24 + 12 | 0;
    var $41 = HEAP32[$40 >> 2];
    var $42 = $bitrate_btype_count + $j_127 * 24 + 12 | 0;
    HEAP32[$42 >> 2] = $41;
    var $43 = $5 + 84356 + $30 * 24 + 16 | 0;
    var $44 = HEAP32[$43 >> 2];
    var $45 = $bitrate_btype_count + $j_127 * 24 + 16 | 0;
    HEAP32[$45 >> 2] = $44;
    var $46 = $5 + 84356 + $30 * 24 + 20 | 0;
    var $47 = HEAP32[$46 >> 2];
    var $48 = $bitrate_btype_count + $j_127 * 24 + 20 | 0;
    HEAP32[$48 >> 2] = $47;
    var $exitcond = ($30 | 0) == 14;
    if ($exitcond) {
      label = 7;
      break;
    } else {
      var $j_127 = $30;
      label = 6;
      break;
    }
   case 7:
    return;
  }
}
_lame_bitrate_block_type_hist["X"] = 1;
function _update_inbuffer_size($gfc, $nsamples) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 52148 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($2 | 0) == 0;
    if ($3) {
      label = 6;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $5 = $gfc + 52144 | 0;
    var $6 = HEAP32[$5 >> 2];
    var $7 = ($6 | 0) < ($nsamples | 0);
    if ($7) {
      label = 4;
      break;
    } else {
      label = 9;
      break;
    }
   case 4:
    var $_pr = HEAP32[$1 >> 2];
    var $9 = ($_pr | 0) == 0;
    if ($9) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $11 = $_pr;
    _free($11);
    label = 6;
    break;
   case 6:
    var $12 = $gfc + 52152 | 0;
    var $13 = HEAP32[$12 >> 2];
    var $14 = ($13 | 0) == 0;
    if ($14) {
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    var $16 = $13;
    _free($16);
    label = 8;
    break;
   case 8:
    var $18 = _calloc($nsamples, 4);
    var $19 = $18;
    HEAP32[$1 >> 2] = $19;
    var $20 = _calloc($nsamples, 4);
    var $21 = $20;
    HEAP32[$12 >> 2] = $21;
    var $22 = $gfc + 52144 | 0;
    HEAP32[$22 >> 2] = $nsamples;
    label = 9;
    break;
   case 9:
    var $24 = HEAP32[$1 >> 2];
    var $25 = ($24 | 0) == 0;
    if ($25) {
      label = 13;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    var $27 = $gfc + 52152 | 0;
    var $28 = HEAP32[$27 >> 2];
    var $29 = ($28 | 0) == 0;
    if ($29) {
      label = 11;
      break;
    } else {
      var $_0 = 0;
      label = 16;
      break;
    }
   case 11:
    var $_pr24 = HEAP32[$1 >> 2];
    var $31 = ($_pr24 | 0) == 0;
    if ($31) {
      label = 13;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    var $33 = $_pr24;
    _free($33);
    label = 13;
    break;
   case 13:
    var $34 = $gfc + 52152 | 0;
    var $35 = HEAP32[$34 >> 2];
    var $36 = ($35 | 0) == 0;
    if ($36) {
      label = 15;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    var $38 = $35;
    _free($38);
    label = 15;
    break;
   case 15:
    HEAP32[$1 >> 2] = 0;
    HEAP32[$34 >> 2] = 0;
    var $40 = $gfc + 52144 | 0;
    HEAP32[$40 >> 2] = 0;
    _lame_errorf($gfc, 5382744, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    var $_0 = -2;
    label = 16;
    break;
   case 16:
    var $_0;
    STACKTOP = __stackBase__;
    return $_0;
  }
}
_update_inbuffer_size["X"] = 1;
function _lame_encode_buffer_sample_t($gfc, $nsamples, $mp3buf, $mp3buf_size) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 24 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $mfbuf = __stackBase__;
    var $in_buffer_ptr = __stackBase__ + 8;
    var $n_in = __stackBase__ + 16;
    var $n_out = __stackBase__ + 20;
    var $1 = $gfc + 16 | 0;
    var $2 = $gfc + 76 | 0;
    var $3 = HEAP32[$2 >> 2];
    var $4 = $3 * 576 & -1;
    var $5 = $gfc | 0;
    var $6 = HEAP32[$5 >> 2];
    var $7 = ($6 | 0) == -487877;
    if ($7) {
      label = 3;
      break;
    } else {
      var $_0 = -3;
      label = 22;
      break;
    }
   case 3:
    var $9 = ($nsamples | 0) == 0;
    if ($9) {
      var $_0 = 0;
      label = 22;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $11 = _copy_buffer($gfc, $mp3buf, $mp3buf_size, 0);
    var $12 = ($11 | 0) < 0;
    if ($12) {
      var $_0 = $11;
      label = 22;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $14 = $mp3buf + $11 | 0;
    var $15 = $gfc + 52148 | 0;
    var $16 = HEAP32[$15 >> 2];
    var $17 = $gfc + 52152 | 0;
    var $18 = HEAP32[$17 >> 2];
    var $19 = _calcNeeded($1);
    var $20 = $gfc + 52156 | 0;
    var $21 = $mfbuf | 0;
    HEAP32[$21 >> 2] = $20;
    var $22 = $gfc + 68092 | 0;
    var $23 = $mfbuf + 4 | 0;
    HEAP32[$23 >> 2] = $22;
    var $24 = $in_buffer_ptr | 0;
    var $25 = $in_buffer_ptr + 4 | 0;
    var $26 = $gfc + 128 | 0;
    var $27 = $gfc + 72 | 0;
    var $28 = $gfc + 84032 | 0;
    var $29 = $gfc + 84028 | 0;
    var $30 = $gfc + 136 | 0;
    var $31 = $gfc + 85672 | 0;
    var $32 = $gfc + 84032 | 0;
    var $33 = $gfc + 72 | 0;
    var $34 = ($mp3buf_size | 0) == 0;
    var $in_buffer_sroa_0_0_ph = $16;
    var $in_buffer_sroa_1_0_ph = $18;
    var $_055_ph = $nsamples;
    var $_056_ph = $14;
    var $mp3size_0_ph = $11;
    label = 6;
    break;
   case 6:
    var $mp3size_0_ph;
    var $_056_ph;
    var $_055_ph;
    var $in_buffer_sroa_1_0_ph;
    var $in_buffer_sroa_0_0_ph;
    var $in_buffer_sroa_0_0 = $in_buffer_sroa_0_0_ph;
    var $in_buffer_sroa_1_0 = $in_buffer_sroa_1_0_ph;
    var $_055 = $_055_ph;
    label = 7;
    break;
   case 7:
    var $_055;
    var $in_buffer_sroa_1_0;
    var $in_buffer_sroa_0_0;
    var $36 = ($_055 | 0) > 0;
    if ($36) {
      label = 8;
      break;
    } else {
      var $_0 = $mp3size_0_ph;
      label = 22;
      break;
    }
   case 8:
    HEAP32[$n_in >> 2] = 0;
    HEAP32[$n_out >> 2] = 0;
    HEAP32[$24 >> 2] = $in_buffer_sroa_0_0;
    HEAP32[$25 >> 2] = $in_buffer_sroa_1_0;
    _fill_buffer($gfc, $21, $24, $_055, $n_in, $n_out);
    var $38 = HEAP32[$26 >> 2];
    var $39 = ($38 | 0) == 0;
    if ($39) {
      label = 11;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    var $41 = HEAP32[$30 >> 2];
    var $42 = ($41 | 0) == 0;
    if ($42) {
      label = 10;
      break;
    } else {
      label = 11;
      break;
    }
   case 10:
    var $44 = HEAP32[$31 >> 2];
    var $45 = HEAP32[$32 >> 2];
    var $46 = HEAP32[$21 >> 2];
    var $47 = $46 + ($45 << 2) | 0;
    var $48 = HEAP32[$23 >> 2];
    var $49 = $48 + ($45 << 2) | 0;
    var $50 = HEAP32[$n_out >> 2];
    var $51 = HEAP32[$33 >> 2];
    var $52 = _AnalyzeSamples($44, $47, $49, $50, $51);
    var $53 = ($52 | 0) == 0;
    if ($53) {
      var $_0 = -6;
      label = 22;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    var $55 = HEAP32[$n_in >> 2];
    var $56 = $_055 - $55 | 0;
    var $57 = $in_buffer_sroa_0_0 + ($55 << 2) | 0;
    var $58 = HEAP32[$27 >> 2];
    var $59 = ($58 | 0) == 2;
    if ($59) {
      label = 12;
      break;
    } else {
      var $in_buffer_sroa_1_1 = $in_buffer_sroa_1_0;
      label = 13;
      break;
    }
   case 12:
    var $61 = $in_buffer_sroa_1_0 + ($55 << 2) | 0;
    var $in_buffer_sroa_1_1 = $61;
    label = 13;
    break;
   case 13:
    var $in_buffer_sroa_1_1;
    var $63 = HEAP32[$n_out >> 2];
    var $64 = HEAP32[$28 >> 2];
    var $65 = $64 + $63 | 0;
    HEAP32[$28 >> 2] = $65;
    var $66 = HEAP32[$29 >> 2];
    var $67 = ($66 | 0) < 1;
    if ($67) {
      label = 14;
      break;
    } else {
      label = 15;
      break;
    }
   case 14:
    HEAP32[$29 >> 2] = 1728;
    label = 15;
    break;
   case 15:
    var $70 = HEAP32[$n_out >> 2];
    var $71 = HEAP32[$29 >> 2];
    var $72 = $71 + $70 | 0;
    HEAP32[$29 >> 2] = $72;
    var $73 = HEAP32[$28 >> 2];
    var $74 = ($73 | 0) < ($19 | 0);
    if ($74) {
      var $in_buffer_sroa_0_0 = $57;
      var $in_buffer_sroa_1_0 = $in_buffer_sroa_1_1;
      var $_055 = $56;
      label = 7;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    var $76 = $mp3buf_size - $mp3size_0_ph | 0;
    var $_ = $34 ? 0 : $76;
    var $77 = HEAP32[$21 >> 2];
    var $78 = HEAP32[$23 >> 2];
    var $79 = _lame_encode_mp3_frame($gfc, $77, $78, $_056_ph, $_);
    var $80 = ($79 | 0) < 0;
    if ($80) {
      var $_0 = $79;
      label = 22;
      break;
    } else {
      label = 17;
      break;
    }
   case 17:
    var $82 = $_056_ph + $79 | 0;
    var $83 = $79 + $mp3size_0_ph | 0;
    var $84 = HEAP32[$28 >> 2];
    var $85 = $84 - $4 | 0;
    HEAP32[$28 >> 2] = $85;
    var $86 = HEAP32[$29 >> 2];
    var $87 = $86 - $4 | 0;
    HEAP32[$29 >> 2] = $87;
    var $88 = HEAP32[$27 >> 2];
    var $89 = ($88 | 0) > 0;
    if ($89) {
      var $ch_058 = 0;
      label = 18;
      break;
    } else {
      var $in_buffer_sroa_0_0_ph = $57;
      var $in_buffer_sroa_1_0_ph = $in_buffer_sroa_1_1;
      var $_055_ph = $56;
      var $_056_ph = $82;
      var $mp3size_0_ph = $83;
      label = 6;
      break;
    }
   case 18:
    var $ch_058;
    var $90 = HEAP32[$28 >> 2];
    var $91 = ($90 | 0) > 0;
    if ($91) {
      label = 19;
      break;
    } else {
      label = 21;
      break;
    }
   case 19:
    var $92 = $mfbuf + ($ch_058 << 2) | 0;
    var $93 = HEAP32[$92 >> 2];
    var $i_057 = 0;
    label = 20;
    break;
   case 20:
    var $i_057;
    var $95 = $i_057 + $4 | 0;
    var $96 = $93 + ($95 << 2) | 0;
    var $97 = HEAPF32[$96 >> 2];
    var $98 = $93 + ($i_057 << 2) | 0;
    HEAPF32[$98 >> 2] = $97;
    var $99 = $i_057 + 1 | 0;
    var $100 = HEAP32[$28 >> 2];
    var $101 = ($99 | 0) < ($100 | 0);
    if ($101) {
      var $i_057 = $99;
      label = 20;
      break;
    } else {
      label = 21;
      break;
    }
   case 21:
    var $102 = $ch_058 + 1 | 0;
    var $103 = HEAP32[$27 >> 2];
    var $104 = ($102 | 0) < ($103 | 0);
    if ($104) {
      var $ch_058 = $102;
      label = 18;
      break;
    } else {
      var $in_buffer_sroa_0_0_ph = $57;
      var $in_buffer_sroa_1_0_ph = $in_buffer_sroa_1_1;
      var $_055_ph = $56;
      var $_056_ph = $82;
      var $mp3size_0_ph = $83;
      label = 6;
      break;
    }
   case 22:
    var $_0;
    STACKTOP = __stackBase__;
    return $_0;
  }
}
_lame_encode_buffer_sample_t["X"] = 1;
function _filter_coef($x) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $x;
    var $2 = $x > 1;
    if ($2) {
      var $_0 = 0;
      label = 5;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $4 = $x > 0;
    if ($4) {
      label = 4;
      break;
    } else {
      var $_0 = 1;
      label = 5;
      break;
    }
   case 4:
    var $6 = $1 * 1.5707963267948966;
    var $7 = Math.cos($6);
    var $8 = $7;
    var $_0 = $8;
    label = 5;
    break;
   case 5:
    var $_0;
    return $_0;
  }
}
function _lame_decode_exit() {
  _ExitMP3(5292272);
  return 0;
}
function _lame_decode_init() {
  _InitMP3(5292272);
  return 0;
}
function _lame_decode1_headersB($buffer, $len, $pcm_l, $pcm_r, $mp3data, $enc_delay, $enc_padding) {
  return _decode1_headersB_clipchoice(5292272, $buffer, $len, $pcm_l, $pcm_r, $mp3data, $enc_delay, $enc_padding, 5317972, 8192, 2, 46);
}
function _hip_set_pinfo($hip, $pinfo) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($hip | 0) == 0;
    if ($1) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $hip + 21984 | 0;
    HEAP32[$3 >> 2] = $pinfo;
    label = 4;
    break;
   case 4:
    return;
  }
}
function _hip_set_errorf($hip, $func) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($hip | 0) == 0;
    if ($1) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $hip + 21996 | 0;
    HEAP32[$3 >> 2] = $func;
    label = 4;
    break;
   case 4:
    return;
  }
}
function _hip_set_debugf($hip, $func) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($hip | 0) == 0;
    if ($1) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $hip + 21992 | 0;
    HEAP32[$3 >> 2] = $func;
    label = 4;
    break;
   case 4:
    return;
  }
}
function _hip_set_msgf($hip, $func) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($hip | 0) == 0;
    if ($1) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $hip + 21988 | 0;
    HEAP32[$3 >> 2] = $func;
    label = 4;
    break;
   case 4:
    return;
  }
}
function _decode1_headersB_clipchoice($pmp, $buffer, $len, $pcm_l_raw, $pcm_r_raw, $mp3data, $enc_delay, $enc_padding, $p, $psize, $decoded_sample_size, $decodeMP3_ptr) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 4 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $processed_bytes = __stackBase__;
    var $1 = $mp3data | 0;
    HEAP32[$1 >> 2] = 0;
    var $2 = FUNCTION_TABLE[$decodeMP3_ptr]($pmp, $buffer, $len, $p, $psize, $processed_bytes);
    var $3 = $pmp + 24 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) == 0;
    if ($5) {
      label = 3;
      break;
    } else {
      label = 5;
      break;
    }
   case 3:
    var $7 = $pmp + 60 | 0;
    var $8 = HEAP32[$7 >> 2];
    var $9 = ($8 | 0) > 0;
    if ($9) {
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $11 = $pmp + 48 | 0;
    var $12 = HEAP32[$11 >> 2];
    var $13 = ($12 | 0) > 0;
    if ($13) {
      label = 5;
      break;
    } else {
      label = 12;
      break;
    }
   case 5:
    HEAP32[$1 >> 2] = 1;
    var $15 = $pmp + 68 | 0;
    var $16 = HEAP32[$15 >> 2];
    var $17 = $mp3data + 4 | 0;
    HEAP32[$17 >> 2] = $16;
    var $18 = $pmp + 100 | 0;
    var $19 = HEAP32[$18 >> 2];
    var $20 = _freqs + ($19 << 2) | 0;
    var $21 = HEAP32[$20 >> 2];
    var $22 = $mp3data + 8 | 0;
    HEAP32[$22 >> 2] = $21;
    var $23 = $pmp + 112 | 0;
    var $24 = HEAP32[$23 >> 2];
    var $25 = $mp3data + 16 | 0;
    HEAP32[$25 >> 2] = $24;
    var $26 = $pmp + 116 | 0;
    var $27 = HEAP32[$26 >> 2];
    var $28 = $mp3data + 20 | 0;
    HEAP32[$28 >> 2] = $27;
    var $29 = $pmp + 88 | 0;
    var $30 = HEAP32[$29 >> 2];
    var $31 = $pmp + 76 | 0;
    var $32 = HEAP32[$31 >> 2];
    var $33 = 5347532 + ($32 << 4) + ($30 << 2) | 0;
    var $34 = HEAP32[$33 >> 2];
    var $35 = $mp3data + 24 | 0;
    HEAP32[$35 >> 2] = $34;
    var $36 = $pmp + 60 | 0;
    var $37 = HEAP32[$36 >> 2];
    var $38 = ($37 | 0) > 0;
    if ($38) {
      label = 6;
      break;
    } else {
      label = 7;
      break;
    }
   case 6:
    var $40 = $37 << 3;
    var $41 = $40 + 32 | 0;
    var $42 = HEAP32[$22 >> 2];
    var $43 = $42 * $41 & -1;
    var $44 = $43 | 0;
    var $45 = $34 | 0;
    var $46 = $45 * 1e3;
    var $47 = $44 / $46;
    var $48 = $47 + .5;
    var $49 = $48 & -1;
    var $50 = $mp3data + 12 | 0;
    HEAP32[$50 >> 2] = $49;
    label = 10;
    break;
   case 7:
    var $52 = $pmp + 48 | 0;
    var $53 = HEAP32[$52 >> 2];
    var $54 = ($53 | 0) > 0;
    if ($54) {
      label = 8;
      break;
    } else {
      label = 9;
      break;
    }
   case 8:
    var $56 = $53 << 3;
    var $57 = $56 + 32 | 0;
    var $58 = HEAP32[$22 >> 2];
    var $59 = $58 * $57 & -1;
    var $60 = $59 | 0;
    var $61 = $34 | 0;
    var $62 = $61 * 1e3;
    var $63 = $60 / $62;
    var $64 = $63 + .5;
    var $65 = $64 & -1;
    var $66 = $mp3data + 12 | 0;
    HEAP32[$66 >> 2] = $65;
    label = 10;
    break;
   case 9:
    var $68 = $pmp + 96 | 0;
    var $69 = HEAP32[$68 >> 2];
    var $70 = HEAP32[$29 >> 2];
    var $71 = $70 - 1 | 0;
    var $72 = HEAP32[$31 >> 2];
    var $73 = _tabsel_123 + $72 * 192 + ($71 << 6) + ($69 << 2) | 0;
    var $74 = HEAP32[$73 >> 2];
    var $75 = $mp3data + 12 | 0;
    HEAP32[$75 >> 2] = $74;
    label = 10;
    break;
   case 10:
    var $77 = $pmp + 12 | 0;
    var $78 = HEAP32[$77 >> 2];
    var $79 = ($78 | 0) > 0;
    if ($79) {
      label = 11;
      break;
    } else {
      label = 12;
      break;
    }
   case 11:
    var $81 = $mp3data + 32 | 0;
    HEAP32[$81 >> 2] = $78;
    var $82 = HEAP32[$35 >> 2];
    var $83 = HEAP32[$77 >> 2];
    var $84 = $83 * $82 & -1;
    var $85 = $mp3data + 28 | 0;
    HEAP32[$85 >> 2] = $84;
    var $86 = $pmp + 16 | 0;
    var $87 = HEAP32[$86 >> 2];
    HEAP32[$enc_delay >> 2] = $87;
    var $88 = $pmp + 20 | 0;
    var $89 = HEAP32[$88 >> 2];
    HEAP32[$enc_padding >> 2] = $89;
    label = 12;
    break;
   case 12:
    if (($2 | 0) == 0) {
      label = 13;
      break;
    } else if (($2 | 0) == -1) {
      label = 28;
      break;
    } else if (($2 | 0) == 1) {
      var $processed_samples_0 = 0;
      label = 30;
      break;
    } else {
      label = 29;
      break;
    }
   case 13:
    var $92 = $pmp + 68 | 0;
    var $93 = HEAP32[$92 >> 2];
    if (($93 | 0) == 1) {
      label = 14;
      break;
    } else if (($93 | 0) == 2) {
      label = 21;
      break;
    } else {
      var $processed_samples_0 = -1;
      label = 30;
      break;
    }
   case 14:
    var $95 = HEAP32[$processed_bytes >> 2];
    var $96 = ($95 | 0) / ($decoded_sample_size | 0) & -1;
    var $97 = ($decoded_sample_size | 0) == 2;
    var $98 = ($96 | 0) > 0;
    if ($97) {
      label = 15;
      break;
    } else {
      label = 18;
      break;
    }
   case 15:
    if ($98) {
      label = 16;
      break;
    } else {
      var $processed_samples_0 = $96;
      label = 30;
      break;
    }
   case 16:
    var $100 = $p;
    var $101 = $pcm_l_raw;
    var $i_070 = 0;
    var $pcm_l_071 = $101;
    var $p_samples_072 = $100;
    label = 17;
    break;
   case 17:
    var $p_samples_072;
    var $pcm_l_071;
    var $i_070;
    var $103 = $p_samples_072 + 2 | 0;
    var $104 = HEAP16[$p_samples_072 >> 1];
    var $105 = $pcm_l_071 + 2 | 0;
    HEAP16[$pcm_l_071 >> 1] = $104;
    var $106 = $i_070 + 1 | 0;
    var $exitcond = ($106 | 0) == ($96 | 0);
    if ($exitcond) {
      var $processed_samples_0 = $96;
      label = 30;
      break;
    } else {
      var $i_070 = $106;
      var $pcm_l_071 = $105;
      var $p_samples_072 = $103;
      label = 17;
      break;
    }
   case 18:
    if ($98) {
      label = 19;
      break;
    } else {
      var $processed_samples_0 = $96;
      label = 30;
      break;
    }
   case 19:
    var $108 = $p;
    var $109 = $pcm_l_raw;
    var $i_174 = 0;
    var $pcm_l1_075 = $109;
    var $p_samples2_076 = $108;
    label = 20;
    break;
   case 20:
    var $p_samples2_076;
    var $pcm_l1_075;
    var $i_174;
    var $111 = $p_samples2_076 + 4 | 0;
    var $112 = HEAPF32[$p_samples2_076 >> 2];
    var $113 = $pcm_l1_075 + 4 | 0;
    HEAPF32[$pcm_l1_075 >> 2] = $112;
    var $114 = $i_174 + 1 | 0;
    var $exitcond90 = ($114 | 0) == ($96 | 0);
    if ($exitcond90) {
      var $processed_samples_0 = $96;
      label = 30;
      break;
    } else {
      var $i_174 = $114;
      var $pcm_l1_075 = $113;
      var $p_samples2_076 = $111;
      label = 20;
      break;
    }
   case 21:
    var $116 = HEAP32[$processed_bytes >> 2];
    var $117 = ($116 | 0) / ($decoded_sample_size | 0) & -1;
    var $118 = $117 >> 1;
    var $119 = ($decoded_sample_size | 0) == 2;
    var $120 = ($118 | 0) > 0;
    if ($119) {
      label = 22;
      break;
    } else {
      label = 25;
      break;
    }
   case 22:
    if ($120) {
      label = 23;
      break;
    } else {
      var $processed_samples_0 = $118;
      label = 30;
      break;
    }
   case 23:
    var $122 = $p;
    var $123 = $pcm_r_raw;
    var $124 = $pcm_l_raw;
    var $i_279 = 0;
    var $pcm_l3_080 = $124;
    var $pcm_r_081 = $123;
    var $p_samples4_082 = $122;
    label = 24;
    break;
   case 24:
    var $p_samples4_082;
    var $pcm_r_081;
    var $pcm_l3_080;
    var $i_279;
    var $126 = $p_samples4_082 + 2 | 0;
    var $127 = HEAP16[$p_samples4_082 >> 1];
    var $128 = $pcm_l3_080 + 2 | 0;
    HEAP16[$pcm_l3_080 >> 1] = $127;
    var $129 = $p_samples4_082 + 4 | 0;
    var $130 = HEAP16[$126 >> 1];
    var $131 = $pcm_r_081 + 2 | 0;
    HEAP16[$pcm_r_081 >> 1] = $130;
    var $132 = $i_279 + 1 | 0;
    var $exitcond91 = ($132 | 0) == ($118 | 0);
    if ($exitcond91) {
      var $processed_samples_0 = $118;
      label = 30;
      break;
    } else {
      var $i_279 = $132;
      var $pcm_l3_080 = $128;
      var $pcm_r_081 = $131;
      var $p_samples4_082 = $129;
      label = 24;
      break;
    }
   case 25:
    if ($120) {
      label = 26;
      break;
    } else {
      var $processed_samples_0 = $118;
      label = 30;
      break;
    }
   case 26:
    var $134 = $p;
    var $135 = $pcm_r_raw;
    var $136 = $pcm_l_raw;
    var $i_385 = 0;
    var $pcm_l5_086 = $136;
    var $pcm_r6_087 = $135;
    var $p_samples7_088 = $134;
    label = 27;
    break;
   case 27:
    var $p_samples7_088;
    var $pcm_r6_087;
    var $pcm_l5_086;
    var $i_385;
    var $138 = $p_samples7_088 + 4 | 0;
    var $139 = HEAPF32[$p_samples7_088 >> 2];
    var $140 = $pcm_l5_086 + 4 | 0;
    HEAPF32[$pcm_l5_086 >> 2] = $139;
    var $141 = $p_samples7_088 + 8 | 0;
    var $142 = HEAPF32[$138 >> 2];
    var $143 = $pcm_r6_087 + 4 | 0;
    HEAPF32[$pcm_r6_087 >> 2] = $142;
    var $144 = $i_385 + 1 | 0;
    var $exitcond92 = ($144 | 0) == ($118 | 0);
    if ($exitcond92) {
      var $processed_samples_0 = $118;
      label = 30;
      break;
    } else {
      var $i_385 = $144;
      var $pcm_l5_086 = $140;
      var $pcm_r6_087 = $143;
      var $p_samples7_088 = $141;
      label = 27;
      break;
    }
   case 28:
    var $processed_samples_0 = -1;
    label = 30;
    break;
   case 29:
    var $processed_samples_0 = -1;
    label = 30;
    break;
   case 30:
    var $processed_samples_0;
    STACKTOP = __stackBase__;
    return $processed_samples_0;
  }
}
_decode1_headersB_clipchoice["X"] = 1;
function _lame_decode1_headers($buffer, $len, $pcm_l, $pcm_r, $mp3data) {
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 8 | 0;
  var $1 = _lame_decode1_headersB($buffer, $len, $pcm_l, $pcm_r, $mp3data, __stackBase__, __stackBase__ + 4);
  STACKTOP = __stackBase__;
  return $1;
}
function _lame_decode1($buffer, $len, $pcm_l, $pcm_r) {
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 40 | 0;
  var $1 = _lame_decode1_headers($buffer, $len, $pcm_l, $pcm_r, __stackBase__);
  STACKTOP = __stackBase__;
  return $1;
}
function _lame_decode_headers($buffer, $len, $pcm_l, $pcm_r, $mp3data) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $totsize_0 = 0;
    var $_010 = $len;
    label = 3;
    break;
   case 3:
    var $_010;
    var $totsize_0;
    var $2 = $pcm_l + ($totsize_0 << 1) | 0;
    var $3 = $pcm_r + ($totsize_0 << 1) | 0;
    var $4 = _lame_decode1_headers($buffer, $_010, $2, $3, $mp3data);
    if (($4 | 0) == -1) {
      label = 5;
      break;
    } else if (($4 | 0) == 0) {
      var $_0 = $totsize_0;
      label = 6;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $6 = $4 + $totsize_0 | 0;
    var $totsize_0 = $6;
    var $_010 = 0;
    label = 3;
    break;
   case 5:
    var $_0 = -1;
    label = 6;
    break;
   case 6:
    var $_0;
    return $_0;
  }
}
function _lame_decode($buffer, $len, $pcm_l, $pcm_r) {
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 40 | 0;
  var $1 = _lame_decode_headers($buffer, $len, $pcm_l, $pcm_r, __stackBase__);
  STACKTOP = __stackBase__;
  return $1;
}
function _hip_decode_init() {
  var $2 = _calloc(1, 22e3);
  _InitMP3($2);
  return $2;
}
function _hip_decode_exit($hip) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($hip | 0) == 0;
    if ($1) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    _ExitMP3($hip);
    var $3 = $hip;
    _free($3);
    label = 4;
    break;
   case 4:
    return 0;
  }
}
function _hip_decode1_unclipped($hip, $buffer, $len, $pcm_l, $pcm_r) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 48 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $mp3data = __stackBase__;
    var $enc_delay = __stackBase__ + 40;
    var $enc_padding = __stackBase__ + 44;
    var $1 = ($hip | 0) == 0;
    if ($1) {
      var $_0 = 0;
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $pcm_l;
    var $4 = $pcm_r;
    var $5 = _decode1_headersB_clipchoice($hip, $buffer, $len, $3, $4, $mp3data, $enc_delay, $enc_padding, 5327800, 9216, 4, 42);
    var $_0 = $5;
    label = 4;
    break;
   case 4:
    var $_0;
    STACKTOP = __stackBase__;
    return $_0;
  }
}
function _hip_decode1_headers($hip, $buffer, $len, $pcm_l, $pcm_r, $mp3data) {
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 8 | 0;
  var $1 = _hip_decode1_headersB($hip, $buffer, $len, $pcm_l, $pcm_r, $mp3data, __stackBase__, __stackBase__ + 4);
  STACKTOP = __stackBase__;
  return $1;
}
function _hip_decode1_headersB($hip, $buffer, $len, $pcm_l, $pcm_r, $mp3data, $enc_delay, $enc_padding) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($hip | 0) == 0;
    if ($1) {
      var $_0 = -1;
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $pcm_l;
    var $4 = $pcm_r;
    var $5 = _decode1_headersB_clipchoice($hip, $buffer, $len, $3, $4, $mp3data, $enc_delay, $enc_padding, 5337016, 8192, 2, 46);
    var $_0 = $5;
    label = 4;
    break;
   case 4:
    var $_0;
    return $_0;
  }
}
function _hip_decode1($hip, $buffer, $len, $pcm_l, $pcm_r) {
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 40 | 0;
  var $1 = _hip_decode1_headers($hip, $buffer, $len, $pcm_l, $pcm_r, __stackBase__);
  STACKTOP = __stackBase__;
  return $1;
}
function _hip_decode_headers($hip, $buffer, $len, $pcm_l, $pcm_r, $mp3data) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $totsize_0 = 0;
    var $_011 = $len;
    label = 3;
    break;
   case 3:
    var $_011;
    var $totsize_0;
    var $2 = $pcm_l + ($totsize_0 << 1) | 0;
    var $3 = $pcm_r + ($totsize_0 << 1) | 0;
    var $4 = _hip_decode1_headers($hip, $buffer, $_011, $2, $3, $mp3data);
    if (($4 | 0) == -1) {
      label = 5;
      break;
    } else if (($4 | 0) == 0) {
      var $_0 = $totsize_0;
      label = 6;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $6 = $4 + $totsize_0 | 0;
    var $totsize_0 = $6;
    var $_011 = 0;
    label = 3;
    break;
   case 5:
    var $_0 = -1;
    label = 6;
    break;
   case 6:
    var $_0;
    return $_0;
  }
}
function _hip_decode($hip, $buffer, $len, $pcm_l, $pcm_r) {
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 40 | 0;
  var $1 = _hip_decode_headers($hip, $buffer, $len, $pcm_l, $pcm_r, __stackBase__);
  STACKTOP = __stackBase__;
  return $1;
}
function _mdct_sub48($gfc, $w0, $w1) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 72 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $work = __stackBase__;
    var $1 = $gfc + 72 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($2 | 0) > 0;
    if ($3) {
      label = 3;
      break;
    } else {
      label = 26;
      break;
    }
   case 3:
    var $4 = $gfc + 76 | 0;
    var $5 = $work | 0;
    var $w0_pn172 = $w0;
    var $ch_0173 = 0;
    label = 4;
    break;
   case 4:
    var $ch_0173;
    var $w0_pn172;
    var $7 = HEAP32[$4 >> 2];
    var $8 = ($7 | 0) > 0;
    if ($8) {
      label = 5;
      break;
    } else {
      label = 25;
      break;
    }
   case 5:
    var $wk_0 = $w0_pn172 + 1144 | 0;
    var $wk_1170 = $wk_0;
    var $gr_0171 = 0;
    label = 6;
    break;
   case 6:
    var $gr_0171;
    var $wk_1170;
    var $10 = 1 - $gr_0171 | 0;
    var $11 = $gfc + 27820 + $ch_0173 * 4608 + $10 * 2304 | 0;
    var $samp_0155 = $11;
    var $wk_2156 = $wk_1170;
    var $k_0157 = 0;
    label = 7;
    break;
   case 7:
    var $k_0157;
    var $wk_2156;
    var $samp_0155;
    _window_subband($wk_2156, $samp_0155);
    var $13 = $wk_2156 + 128 | 0;
    var $14 = $samp_0155 + 128 | 0;
    _window_subband($13, $14);
    var $15 = $samp_0155 + 256 | 0;
    var $16 = $samp_0155 + 132 | 0;
    var $17 = HEAPF32[$16 >> 2];
    var $18 = $17 * -1;
    HEAPF32[$16 >> 2] = $18;
    var $19 = $samp_0155 + 140 | 0;
    var $20 = HEAPF32[$19 >> 2];
    var $21 = $20 * -1;
    HEAPF32[$19 >> 2] = $21;
    var $22 = $samp_0155 + 148 | 0;
    var $23 = HEAPF32[$22 >> 2];
    var $24 = $23 * -1;
    HEAPF32[$22 >> 2] = $24;
    var $25 = $samp_0155 + 156 | 0;
    var $26 = HEAPF32[$25 >> 2];
    var $27 = $26 * -1;
    HEAPF32[$25 >> 2] = $27;
    var $28 = $samp_0155 + 164 | 0;
    var $29 = HEAPF32[$28 >> 2];
    var $30 = $29 * -1;
    HEAPF32[$28 >> 2] = $30;
    var $31 = $samp_0155 + 172 | 0;
    var $32 = HEAPF32[$31 >> 2];
    var $33 = $32 * -1;
    HEAPF32[$31 >> 2] = $33;
    var $34 = $samp_0155 + 180 | 0;
    var $35 = HEAPF32[$34 >> 2];
    var $36 = $35 * -1;
    HEAPF32[$34 >> 2] = $36;
    var $37 = $samp_0155 + 188 | 0;
    var $38 = HEAPF32[$37 >> 2];
    var $39 = $38 * -1;
    HEAPF32[$37 >> 2] = $39;
    var $40 = $samp_0155 + 196 | 0;
    var $41 = HEAPF32[$40 >> 2];
    var $42 = $41 * -1;
    HEAPF32[$40 >> 2] = $42;
    var $43 = $samp_0155 + 204 | 0;
    var $44 = HEAPF32[$43 >> 2];
    var $45 = $44 * -1;
    HEAPF32[$43 >> 2] = $45;
    var $46 = $samp_0155 + 212 | 0;
    var $47 = HEAPF32[$46 >> 2];
    var $48 = $47 * -1;
    HEAPF32[$46 >> 2] = $48;
    var $49 = $samp_0155 + 220 | 0;
    var $50 = HEAPF32[$49 >> 2];
    var $51 = $50 * -1;
    HEAPF32[$49 >> 2] = $51;
    var $52 = $samp_0155 + 228 | 0;
    var $53 = HEAPF32[$52 >> 2];
    var $54 = $53 * -1;
    HEAPF32[$52 >> 2] = $54;
    var $55 = $samp_0155 + 236 | 0;
    var $56 = HEAPF32[$55 >> 2];
    var $57 = $56 * -1;
    HEAPF32[$55 >> 2] = $57;
    var $58 = $samp_0155 + 244 | 0;
    var $59 = HEAPF32[$58 >> 2];
    var $60 = $59 * -1;
    HEAPF32[$58 >> 2] = $60;
    var $61 = $samp_0155 + 252 | 0;
    var $62 = HEAPF32[$61 >> 2];
    var $63 = $62 * -1;
    HEAPF32[$61 >> 2] = $63;
    var $64 = $wk_2156 + 256 | 0;
    var $65 = $k_0157 + 1 | 0;
    var $exitcond = ($65 | 0) == 9;
    if ($exitcond) {
      label = 8;
      break;
    } else {
      var $samp_0155 = $15;
      var $wk_2156 = $64;
      var $k_0157 = $65;
      label = 7;
      break;
    }
   case 8:
    var $66 = $gfc + 304 + $gr_0171 * 10504 + $ch_0173 * 5252 | 0;
    var $67 = $gfc + 304 + $gr_0171 * 10504 + $ch_0173 * 5252 + 4788 | 0;
    var $68 = $gfc + 304 + $gr_0171 * 10504 + $ch_0173 * 5252 + 4792 | 0;
    var $mdct_enc_0167 = $66;
    var $band_1169 = 0;
    label = 9;
    break;
   case 9:
    var $band_1169;
    var $mdct_enc_0167;
    var $70 = HEAP32[$67 >> 2];
    var $71 = 5291564 + ($band_1169 << 2) | 0;
    var $72 = HEAP32[$71 >> 2];
    var $73 = HEAP32[$68 >> 2];
    var $74 = ($73 | 0) != 0;
    var $75 = ($band_1169 | 0) < 2;
    var $or_cond = $74 & $75;
    var $type_0 = $or_cond ? 0 : $70;
    var $76 = $gfc + 37036 + ($band_1169 << 2) | 0;
    var $77 = HEAPF32[$76 >> 2];
    var $78 = $77;
    var $79 = $78 < 1e-12;
    if ($79) {
      label = 10;
      break;
    } else {
      label = 11;
      break;
    }
   case 10:
    var $81 = $mdct_enc_0167;
    for (var $$dest = $81 >> 2, $$stop = $$dest + 18; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    label = 19;
    break;
   case 11:
    var $83 = $77 < 1;
    if ($83) {
      var $k_1159 = 0;
      label = 12;
      break;
    } else {
      label = 13;
      break;
    }
   case 12:
    var $k_1159;
    var $84 = HEAPF32[$76 >> 2];
    var $85 = $k_1159 << 5;
    var $_sum151 = $85 + $72 | 0;
    var $86 = $gfc + 27820 + $ch_0173 * 4608 + $10 * 2304 + ($_sum151 << 2) | 0;
    var $87 = HEAPF32[$86 >> 2];
    var $88 = $84 * $87;
    HEAPF32[$86 >> 2] = $88;
    var $89 = $k_1159 + 1 | 0;
    var $exitcond179 = ($89 | 0) == 18;
    if ($exitcond179) {
      label = 13;
      break;
    } else {
      var $k_1159 = $89;
      label = 12;
      break;
    }
   case 13:
    var $90 = ($type_0 | 0) == 2;
    if ($90) {
      label = 14;
      break;
    } else {
      var $k_3161 = -9;
      label = 17;
      break;
    }
   case 14:
    var $91 = $72 + 288 | 0;
    var $92 = $72 + 480 | 0;
    var $k_2163 = -3;
    label = 15;
    break;
   case 15:
    var $k_2163;
    var $94 = $k_2163 + 3 | 0;
    var $95 = 5247776 + ($94 << 2) | 0;
    var $96 = HEAPF32[$95 >> 2];
    var $97 = $k_2163 << 5;
    var $_sum143 = $91 + $97 | 0;
    var $98 = $gfc + 27820 + $ch_0173 * 4608 + $gr_0171 * 2304 + ($_sum143 << 2) | 0;
    var $99 = HEAPF32[$98 >> 2];
    var $100 = $96 * $99;
    var $101 = 8 - $k_2163 | 0;
    var $102 = $101 << 5;
    var $_sum144 = $102 + $72 | 0;
    var $103 = $gfc + 27820 + $ch_0173 * 4608 + $gr_0171 * 2304 + ($_sum144 << 2) | 0;
    var $104 = HEAPF32[$103 >> 2];
    var $105 = $100 - $104;
    var $106 = $k_2163 * 3 & -1;
    var $107 = $106 + 9 | 0;
    var $108 = $mdct_enc_0167 + ($107 << 2) | 0;
    HEAPF32[$108 >> 2] = $105;
    var $109 = 14 - $k_2163 | 0;
    var $110 = $109 << 5;
    var $_sum145 = $110 + $72 | 0;
    var $111 = $gfc + 27820 + $ch_0173 * 4608 + $gr_0171 * 2304 + ($_sum145 << 2) | 0;
    var $112 = HEAPF32[$111 >> 2];
    var $113 = $96 * $112;
    var $_sum146 = $92 + $97 | 0;
    var $114 = $gfc + 27820 + $ch_0173 * 4608 + $gr_0171 * 2304 + ($_sum146 << 2) | 0;
    var $115 = HEAPF32[$114 >> 2];
    var $116 = $113 + $115;
    var $117 = $106 + 18 | 0;
    var $118 = $mdct_enc_0167 + ($117 << 2) | 0;
    HEAPF32[$118 >> 2] = $116;
    var $119 = HEAPF32[$114 >> 2];
    var $120 = $96 * $119;
    var $121 = HEAPF32[$111 >> 2];
    var $122 = $120 - $121;
    var $123 = $106 + 10 | 0;
    var $124 = $mdct_enc_0167 + ($123 << 2) | 0;
    HEAPF32[$124 >> 2] = $122;
    var $125 = 2 - $k_2163 | 0;
    var $126 = $125 << 5;
    var $_sum147 = $126 + $72 | 0;
    var $127 = $gfc + 27820 + $ch_0173 * 4608 + $10 * 2304 + ($_sum147 << 2) | 0;
    var $128 = HEAPF32[$127 >> 2];
    var $129 = $96 * $128;
    var $130 = $94 << 5;
    var $_sum148 = $130 + $72 | 0;
    var $131 = $gfc + 27820 + $ch_0173 * 4608 + $10 * 2304 + ($_sum148 << 2) | 0;
    var $132 = HEAPF32[$131 >> 2];
    var $133 = $129 + $132;
    var $134 = $106 + 19 | 0;
    var $135 = $mdct_enc_0167 + ($134 << 2) | 0;
    HEAPF32[$135 >> 2] = $133;
    var $136 = HEAPF32[$131 >> 2];
    var $137 = $96 * $136;
    var $138 = HEAPF32[$127 >> 2];
    var $139 = $137 - $138;
    var $140 = $106 + 11 | 0;
    var $141 = $mdct_enc_0167 + ($140 << 2) | 0;
    HEAPF32[$141 >> 2] = $139;
    var $142 = $gfc + 27820 + $ch_0173 * 4608 + $10 * 2304 + ($_sum144 << 2) | 0;
    var $143 = HEAPF32[$142 >> 2];
    var $144 = $96 * $143;
    var $145 = $gfc + 27820 + $ch_0173 * 4608 + $10 * 2304 + ($_sum143 << 2) | 0;
    var $146 = HEAPF32[$145 >> 2];
    var $147 = $144 + $146;
    var $148 = $106 + 20 | 0;
    var $149 = $mdct_enc_0167 + ($148 << 2) | 0;
    HEAPF32[$149 >> 2] = $147;
    var $150 = $k_2163 + 1 | 0;
    var $exitcond181 = ($150 | 0) == 0;
    if ($exitcond181) {
      label = 16;
      break;
    } else {
      var $k_2163 = $150;
      label = 15;
      break;
    }
   case 16:
    _mdct_short($mdct_enc_0167);
    label = 19;
    break;
   case 17:
    var $k_3161;
    var $152 = $k_3161 + 27 | 0;
    var $153 = 5247488 + $type_0 * 144 + ($152 << 2) | 0;
    var $154 = HEAPF32[$153 >> 2];
    var $155 = $k_3161 + 9 | 0;
    var $156 = $155 << 5;
    var $_sum138 = $156 + $72 | 0;
    var $157 = $gfc + 27820 + $ch_0173 * 4608 + $10 * 2304 + ($_sum138 << 2) | 0;
    var $158 = HEAPF32[$157 >> 2];
    var $159 = $154 * $158;
    var $160 = $k_3161 + 36 | 0;
    var $161 = 5247488 + $type_0 * 144 + ($160 << 2) | 0;
    var $162 = HEAPF32[$161 >> 2];
    var $163 = 8 - $k_3161 | 0;
    var $164 = $163 << 5;
    var $_sum139 = $164 + $72 | 0;
    var $165 = $gfc + 27820 + $ch_0173 * 4608 + $10 * 2304 + ($_sum139 << 2) | 0;
    var $166 = HEAPF32[$165 >> 2];
    var $167 = $162 * $166;
    var $168 = $159 + $167;
    var $169 = 5247488 + $type_0 * 144 + ($155 << 2) | 0;
    var $170 = HEAPF32[$169 >> 2];
    var $171 = $gfc + 27820 + $ch_0173 * 4608 + $gr_0171 * 2304 + ($_sum138 << 2) | 0;
    var $172 = HEAPF32[$171 >> 2];
    var $173 = $170 * $172;
    var $174 = $k_3161 + 18 | 0;
    var $175 = 5247488 + $type_0 * 144 + ($174 << 2) | 0;
    var $176 = HEAPF32[$175 >> 2];
    var $177 = $gfc + 27820 + $ch_0173 * 4608 + $gr_0171 * 2304 + ($_sum139 << 2) | 0;
    var $178 = HEAPF32[$177 >> 2];
    var $179 = $176 * $178;
    var $180 = $173 - $179;
    var $_sum142 = $k_3161 + 12 | 0;
    var $181 = 5247776 + ($_sum142 << 2) | 0;
    var $182 = HEAPF32[$181 >> 2];
    var $183 = $182 * $180;
    var $184 = $168 - $183;
    var $185 = $work + ($155 << 2) | 0;
    HEAPF32[$185 >> 2] = $184;
    var $186 = HEAPF32[$181 >> 2];
    var $187 = $168 * $186;
    var $188 = $180 + $187;
    var $189 = $work + ($174 << 2) | 0;
    HEAPF32[$189 >> 2] = $188;
    var $190 = $k_3161 + 1 | 0;
    var $exitcond180 = ($190 | 0) == 0;
    if ($exitcond180) {
      label = 18;
      break;
    } else {
      var $k_3161 = $190;
      label = 17;
      break;
    }
   case 18:
    _mdct_long($mdct_enc_0167, $5);
    label = 19;
    break;
   case 19:
    var $193 = ($type_0 | 0) == 2;
    var $194 = ($band_1169 | 0) == 0;
    var $or_cond153 = $193 | $194;
    if ($or_cond153) {
      label = 21;
      break;
    } else {
      var $k_4166 = 7;
      label = 20;
      break;
    }
   case 20:
    var $k_4166;
    var $195 = $mdct_enc_0167 + ($k_4166 << 2) | 0;
    var $196 = HEAPF32[$195 >> 2];
    var $_sum = $k_4166 + 20 | 0;
    var $197 = 5247776 + ($_sum << 2) | 0;
    var $198 = HEAPF32[$197 >> 2];
    var $199 = $196 * $198;
    var $200 = $k_4166 ^ -1;
    var $201 = $mdct_enc_0167 + ($200 << 2) | 0;
    var $202 = HEAPF32[$201 >> 2];
    var $_sum137 = $k_4166 + 28 | 0;
    var $203 = 5247776 + ($_sum137 << 2) | 0;
    var $204 = HEAPF32[$203 >> 2];
    var $205 = $202 * $204;
    var $206 = $199 + $205;
    var $207 = $196 * $204;
    var $208 = $198 * $202;
    var $209 = $207 - $208;
    HEAPF32[$201 >> 2] = $206;
    HEAPF32[$195 >> 2] = $209;
    var $210 = $k_4166 - 1 | 0;
    var $211 = ($k_4166 | 0) > 0;
    if ($211) {
      var $k_4166 = $210;
      label = 20;
      break;
    } else {
      label = 21;
      break;
    }
   case 21:
    var $212 = $band_1169 + 1 | 0;
    var $213 = $mdct_enc_0167 + 72 | 0;
    var $exitcond182 = ($212 | 0) == 32;
    if ($exitcond182) {
      label = 22;
      break;
    } else {
      var $mdct_enc_0167 = $213;
      var $band_1169 = $212;
      label = 9;
      break;
    }
   case 22:
    var $scevgep = $wk_1170 + 2304 | 0;
    var $215 = $gr_0171 + 1 | 0;
    var $216 = HEAP32[$4 >> 2];
    var $217 = ($215 | 0) < ($216 | 0);
    if ($217) {
      var $wk_1170 = $scevgep;
      var $gr_0171 = $215;
      label = 6;
      break;
    } else {
      label = 23;
      break;
    }
   case 23:
    var $218 = ($216 | 0) == 1;
    if ($218) {
      label = 24;
      break;
    } else {
      label = 25;
      break;
    }
   case 24:
    var $220 = $gfc + 27820 + $ch_0173 * 4608 | 0;
    var $221 = $220;
    var $222 = $gfc + 27820 + $ch_0173 * 4608 + 2304 | 0;
    var $223 = $222;
    for (var $$src = $223 >> 2, $$dest = $221 >> 2, $$stop = $$src + 576; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    label = 25;
    break;
   case 25:
    var $224 = $ch_0173 + 1 | 0;
    var $225 = HEAP32[$1 >> 2];
    var $226 = ($224 | 0) < ($225 | 0);
    if ($226) {
      var $w0_pn172 = $w1;
      var $ch_0173 = $224;
      label = 4;
      break;
    } else {
      label = 26;
      break;
    }
   case 26:
    STACKTOP = __stackBase__;
    return;
  }
}
_mdct_sub48["X"] = 1;
function _window_subband($x1, $a) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $x1 - 248 | 0;
    var $x2_0713 = $1;
    var $wp_0714 = 5346432;
    var $i_0715 = -15;
    var $_0716 = $x1;
    label = 3;
    break;
   case 3:
    var $_0716;
    var $i_0715;
    var $wp_0714;
    var $x2_0713;
    var $3 = $wp_0714 - 40 | 0;
    var $4 = HEAPF32[$3 >> 2];
    var $5 = $x2_0713 - 896 | 0;
    var $6 = HEAPF32[$5 >> 2];
    var $7 = $4 * $6;
    var $8 = $_0716 + 896 | 0;
    var $9 = HEAPF32[$8 >> 2];
    var $10 = $4 * $9;
    var $11 = $wp_0714 - 36 | 0;
    var $12 = HEAPF32[$11 >> 2];
    var $13 = $x2_0713 - 640 | 0;
    var $14 = HEAPF32[$13 >> 2];
    var $15 = $12 * $14;
    var $16 = $7 + $15;
    var $17 = $_0716 + 640 | 0;
    var $18 = HEAPF32[$17 >> 2];
    var $19 = $12 * $18;
    var $20 = $10 + $19;
    var $21 = $wp_0714 - 32 | 0;
    var $22 = HEAPF32[$21 >> 2];
    var $23 = $x2_0713 - 384 | 0;
    var $24 = HEAPF32[$23 >> 2];
    var $25 = $22 * $24;
    var $26 = $16 + $25;
    var $27 = $_0716 + 384 | 0;
    var $28 = HEAPF32[$27 >> 2];
    var $29 = $22 * $28;
    var $30 = $20 + $29;
    var $31 = $wp_0714 - 28 | 0;
    var $32 = HEAPF32[$31 >> 2];
    var $33 = $x2_0713 - 128 | 0;
    var $34 = HEAPF32[$33 >> 2];
    var $35 = $32 * $34;
    var $36 = $26 + $35;
    var $37 = $_0716 + 128 | 0;
    var $38 = HEAPF32[$37 >> 2];
    var $39 = $32 * $38;
    var $40 = $30 + $39;
    var $41 = $wp_0714 - 24 | 0;
    var $42 = HEAPF32[$41 >> 2];
    var $43 = $x2_0713 + 128 | 0;
    var $44 = HEAPF32[$43 >> 2];
    var $45 = $42 * $44;
    var $46 = $36 + $45;
    var $47 = $_0716 - 128 | 0;
    var $48 = HEAPF32[$47 >> 2];
    var $49 = $42 * $48;
    var $50 = $40 + $49;
    var $51 = $wp_0714 - 20 | 0;
    var $52 = HEAPF32[$51 >> 2];
    var $53 = $x2_0713 + 384 | 0;
    var $54 = HEAPF32[$53 >> 2];
    var $55 = $52 * $54;
    var $56 = $46 + $55;
    var $57 = $_0716 - 384 | 0;
    var $58 = HEAPF32[$57 >> 2];
    var $59 = $52 * $58;
    var $60 = $50 + $59;
    var $61 = $wp_0714 - 16 | 0;
    var $62 = HEAPF32[$61 >> 2];
    var $63 = $x2_0713 + 640 | 0;
    var $64 = HEAPF32[$63 >> 2];
    var $65 = $62 * $64;
    var $66 = $56 + $65;
    var $67 = $_0716 - 640 | 0;
    var $68 = HEAPF32[$67 >> 2];
    var $69 = $62 * $68;
    var $70 = $60 + $69;
    var $71 = $wp_0714 - 12 | 0;
    var $72 = HEAPF32[$71 >> 2];
    var $73 = $x2_0713 + 896 | 0;
    var $74 = HEAPF32[$73 >> 2];
    var $75 = $72 * $74;
    var $76 = $66 + $75;
    var $77 = $_0716 - 896 | 0;
    var $78 = HEAPF32[$77 >> 2];
    var $79 = $72 * $78;
    var $80 = $70 + $79;
    var $81 = $wp_0714 - 8 | 0;
    var $82 = HEAPF32[$81 >> 2];
    var $83 = $_0716 - 1024 | 0;
    var $84 = HEAPF32[$83 >> 2];
    var $85 = $82 * $84;
    var $86 = $76 + $85;
    var $87 = $x2_0713 + 1024 | 0;
    var $88 = HEAPF32[$87 >> 2];
    var $89 = $82 * $88;
    var $90 = $80 - $89;
    var $91 = $wp_0714 - 4 | 0;
    var $92 = HEAPF32[$91 >> 2];
    var $93 = $_0716 - 768 | 0;
    var $94 = HEAPF32[$93 >> 2];
    var $95 = $92 * $94;
    var $96 = $86 + $95;
    var $97 = $x2_0713 + 768 | 0;
    var $98 = HEAPF32[$97 >> 2];
    var $99 = $92 * $98;
    var $100 = $90 - $99;
    var $101 = HEAPF32[$wp_0714 >> 2];
    var $102 = $_0716 - 512 | 0;
    var $103 = HEAPF32[$102 >> 2];
    var $104 = $101 * $103;
    var $105 = $96 + $104;
    var $106 = $x2_0713 + 512 | 0;
    var $107 = HEAPF32[$106 >> 2];
    var $108 = $101 * $107;
    var $109 = $100 - $108;
    var $110 = $wp_0714 + 4 | 0;
    var $111 = HEAPF32[$110 >> 2];
    var $112 = $_0716 - 256 | 0;
    var $113 = HEAPF32[$112 >> 2];
    var $114 = $111 * $113;
    var $115 = $105 + $114;
    var $116 = $x2_0713 + 256 | 0;
    var $117 = HEAPF32[$116 >> 2];
    var $118 = $111 * $117;
    var $119 = $109 - $118;
    var $120 = $wp_0714 + 8 | 0;
    var $121 = HEAPF32[$120 >> 2];
    var $122 = HEAPF32[$_0716 >> 2];
    var $123 = $121 * $122;
    var $124 = $115 + $123;
    var $125 = HEAPF32[$x2_0713 >> 2];
    var $126 = $121 * $125;
    var $127 = $119 - $126;
    var $128 = $wp_0714 + 12 | 0;
    var $129 = HEAPF32[$128 >> 2];
    var $130 = $_0716 + 256 | 0;
    var $131 = HEAPF32[$130 >> 2];
    var $132 = $129 * $131;
    var $133 = $124 + $132;
    var $134 = $x2_0713 - 256 | 0;
    var $135 = HEAPF32[$134 >> 2];
    var $136 = $129 * $135;
    var $137 = $127 - $136;
    var $138 = $wp_0714 + 16 | 0;
    var $139 = HEAPF32[$138 >> 2];
    var $140 = $_0716 + 512 | 0;
    var $141 = HEAPF32[$140 >> 2];
    var $142 = $139 * $141;
    var $143 = $133 + $142;
    var $144 = $x2_0713 - 512 | 0;
    var $145 = HEAPF32[$144 >> 2];
    var $146 = $139 * $145;
    var $147 = $137 - $146;
    var $148 = $wp_0714 + 20 | 0;
    var $149 = HEAPF32[$148 >> 2];
    var $150 = $_0716 + 768 | 0;
    var $151 = HEAPF32[$150 >> 2];
    var $152 = $149 * $151;
    var $153 = $143 + $152;
    var $154 = $x2_0713 - 768 | 0;
    var $155 = HEAPF32[$154 >> 2];
    var $156 = $149 * $155;
    var $157 = $147 - $156;
    var $158 = $wp_0714 + 24 | 0;
    var $159 = HEAPF32[$158 >> 2];
    var $160 = $153 * $159;
    var $161 = $157 - $160;
    var $162 = $157 + $160;
    var $163 = $i_0715 << 1;
    var $164 = $163 + 30 | 0;
    var $165 = $a + ($164 << 2) | 0;
    HEAPF32[$165 >> 2] = $162;
    var $166 = $wp_0714 + 28 | 0;
    var $167 = HEAPF32[$166 >> 2];
    var $168 = $167 * $161;
    var $169 = $163 + 31 | 0;
    var $170 = $a + ($169 << 2) | 0;
    HEAPF32[$170 >> 2] = $168;
    var $171 = $wp_0714 + 72 | 0;
    var $172 = $_0716 - 4 | 0;
    var $173 = $x2_0713 + 4 | 0;
    var $174 = $i_0715 + 1 | 0;
    var $exitcond = ($174 | 0) == 0;
    if ($exitcond) {
      label = 4;
      break;
    } else {
      var $x2_0713 = $173;
      var $wp_0714 = $171;
      var $i_0715 = $174;
      var $_0716 = $172;
      label = 3;
      break;
    }
   case 4:
    var $176 = $x1 - 124 | 0;
    var $177 = HEAPF32[$176 >> 2];
    var $178 = $177 * 10612.802734375;
    var $179 = $x1 - 188 | 0;
    var $180 = HEAPF32[$179 >> 2];
    var $181 = $180 * 12804.7978515625;
    var $182 = $x1 - 252 | 0;
    var $183 = HEAPF32[$182 >> 2];
    var $184 = $x1 + 4 | 0;
    var $185 = HEAPF32[$184 >> 2];
    var $186 = $183 - $185;
    var $187 = $186 * 5302.158203125;
    var $188 = $178 + $187;
    var $189 = $x1 - 444 | 0;
    var $190 = HEAPF32[$189 >> 2];
    var $191 = $190 * 1945.5516357421875;
    var $192 = $181 + $191;
    var $193 = $x1 - 380 | 0;
    var $194 = HEAPF32[$193 >> 2];
    var $195 = $x1 + 132 | 0;
    var $196 = HEAPF32[$195 >> 2];
    var $197 = $194 + $196;
    var $198 = $197 * 929.7763061523438;
    var $199 = $188 + $198;
    var $200 = $x1 - 700 | 0;
    var $201 = HEAPF32[$200 >> 2];
    var $202 = $201 * 313.42449951171875;
    var $203 = $192 + $202;
    var $204 = $x1 - 508 | 0;
    var $205 = HEAPF32[$204 >> 2];
    var $206 = $x1 + 260 | 0;
    var $207 = HEAPF32[$206 >> 2];
    var $208 = $205 - $207;
    var $209 = $208 * 728.8010864257812;
    var $210 = $199 + $209;
    var $211 = $x1 - 956 | 0;
    var $212 = HEAPF32[$211 >> 2];
    var $213 = $212 * 20.801593780517578;
    var $214 = $203 + $213;
    var $215 = $x1 - 636 | 0;
    var $216 = HEAPF32[$215 >> 2];
    var $217 = $x1 + 388 | 0;
    var $218 = HEAPF32[$217 >> 2];
    var $219 = $216 + $218;
    var $220 = $219 * 288.09765625;
    var $221 = $210 + $220;
    var $222 = $x1 + 68 | 0;
    var $223 = HEAPF32[$222 >> 2];
    var $224 = $223 * 1995.1556396484375;
    var $225 = $214 - $224;
    var $226 = $x1 - 764 | 0;
    var $227 = HEAPF32[$226 >> 2];
    var $228 = $x1 + 516 | 0;
    var $229 = HEAPF32[$228 >> 2];
    var $230 = $227 - $229;
    var $231 = $230 * 64.91738891601562;
    var $232 = $221 + $231;
    var $233 = $x1 + 324 | 0;
    var $234 = HEAPF32[$233 >> 2];
    var $235 = $234 * 9.000839233398438;
    var $236 = $225 - $235;
    var $237 = $x1 - 892 | 0;
    var $238 = HEAPF32[$237 >> 2];
    var $239 = $x1 + 644 | 0;
    var $240 = HEAPF32[$239 >> 2];
    var $241 = $238 + $240;
    var $242 = $241 * 30.125003814697266;
    var $243 = $232 + $242;
    var $244 = $x1 + 580 | 0;
    var $245 = HEAPF32[$244 >> 2];
    var $246 = $245 * -29.202180862426758;
    var $247 = $236 - $246;
    var $248 = $x1 - 1020 | 0;
    var $249 = HEAPF32[$248 >> 2];
    var $250 = $x1 + 772 | 0;
    var $251 = HEAPF32[$250 >> 2];
    var $252 = $249 - $251;
    var $253 = $252 * 4.101456642150879;
    var $254 = $243 + $253;
    var $255 = $x1 + 836 | 0;
    var $256 = HEAPF32[$255 >> 2];
    var $257 = $247 - $256;
    var $258 = $257 - $254;
    var $259 = $257 + $254;
    var $260 = $a + 56 | 0;
    var $261 = HEAPF32[$260 >> 2];
    var $262 = $a + 60 | 0;
    var $263 = HEAPF32[$262 >> 2];
    var $264 = $263 - $261;
    var $265 = $261 + $259;
    var $266 = $a + 124 | 0;
    HEAPF32[$266 >> 2] = $265;
    var $267 = $258 + $264;
    var $268 = $a + 120 | 0;
    HEAPF32[$268 >> 2] = $267;
    var $269 = $258 - $264;
    HEAPF32[$262 >> 2] = $269;
    var $270 = $259 - $261;
    HEAPF32[$260 >> 2] = $270;
    var $271 = $a + 112 | 0;
    var $272 = HEAPF32[$271 >> 2];
    var $273 = HEAPF32[$a >> 2];
    var $274 = $272 - $273;
    var $275 = $272 + $273;
    HEAPF32[$a >> 2] = $275;
    var $276 = $274 * 1.9615705013275146;
    HEAPF32[$271 >> 2] = $276;
    var $277 = $a + 116 | 0;
    var $278 = HEAPF32[$277 >> 2];
    var $279 = $a + 4 | 0;
    var $280 = HEAPF32[$279 >> 2];
    var $281 = $278 - $280;
    var $282 = $278 + $280;
    HEAPF32[$279 >> 2] = $282;
    var $283 = $281 * 1.9615705013275146;
    HEAPF32[$277 >> 2] = $283;
    var $284 = $a + 104 | 0;
    var $285 = HEAPF32[$284 >> 2];
    var $286 = $a + 8 | 0;
    var $287 = HEAPF32[$286 >> 2];
    var $288 = $285 - $287;
    var $289 = $285 + $287;
    HEAPF32[$286 >> 2] = $289;
    var $290 = $288 * 1.8477590084075928;
    HEAPF32[$284 >> 2] = $290;
    var $291 = $a + 108 | 0;
    var $292 = HEAPF32[$291 >> 2];
    var $293 = $a + 12 | 0;
    var $294 = HEAPF32[$293 >> 2];
    var $295 = $292 - $294;
    var $296 = $292 + $294;
    HEAPF32[$293 >> 2] = $296;
    var $297 = $295 * 1.8477590084075928;
    HEAPF32[$291 >> 2] = $297;
    var $298 = $a + 96 | 0;
    var $299 = HEAPF32[$298 >> 2];
    var $300 = $a + 16 | 0;
    var $301 = HEAPF32[$300 >> 2];
    var $302 = $299 - $301;
    var $303 = $299 + $301;
    HEAPF32[$300 >> 2] = $303;
    var $304 = $302 * 1.662939190864563;
    HEAPF32[$298 >> 2] = $304;
    var $305 = $a + 100 | 0;
    var $306 = HEAPF32[$305 >> 2];
    var $307 = $a + 20 | 0;
    var $308 = HEAPF32[$307 >> 2];
    var $309 = $306 - $308;
    var $310 = $306 + $308;
    HEAPF32[$307 >> 2] = $310;
    var $311 = $309 * 1.662939190864563;
    HEAPF32[$305 >> 2] = $311;
    var $312 = $a + 88 | 0;
    var $313 = HEAPF32[$312 >> 2];
    var $314 = $a + 24 | 0;
    var $315 = HEAPF32[$314 >> 2];
    var $316 = $313 - $315;
    var $317 = $313 + $315;
    HEAPF32[$314 >> 2] = $317;
    var $318 = $316;
    var $319 = $318 * 1.4142135623730951;
    var $320 = $319;
    HEAPF32[$312 >> 2] = $320;
    var $321 = $a + 92 | 0;
    var $322 = HEAPF32[$321 >> 2];
    var $323 = $a + 28 | 0;
    var $324 = HEAPF32[$323 >> 2];
    var $325 = $322 - $324;
    var $326 = $322 + $324;
    HEAPF32[$323 >> 2] = $326;
    var $327 = $325;
    var $328 = $327 * 1.4142135623730951;
    var $329 = $326;
    var $330 = $328 - $329;
    var $331 = $330;
    HEAPF32[$321 >> 2] = $331;
    var $332 = HEAPF32[$314 >> 2];
    var $333 = HEAPF32[$323 >> 2];
    var $334 = $333 - $332;
    HEAPF32[$323 >> 2] = $334;
    var $335 = HEAPF32[$312 >> 2];
    var $336 = $335 - $334;
    HEAPF32[$312 >> 2] = $336;
    var $337 = HEAPF32[$321 >> 2];
    var $338 = $337 - $336;
    HEAPF32[$321 >> 2] = $338;
    var $339 = HEAPF32[$314 >> 2];
    var $340 = HEAPF32[$266 >> 2];
    var $341 = $340 - $339;
    HEAPF32[$314 >> 2] = $341;
    var $342 = HEAPF32[$266 >> 2];
    var $343 = $339 + $342;
    HEAPF32[$266 >> 2] = $343;
    var $344 = HEAPF32[$323 >> 2];
    var $345 = HEAPF32[$268 >> 2];
    var $346 = $345 - $344;
    HEAPF32[$323 >> 2] = $346;
    var $347 = HEAPF32[$268 >> 2];
    var $348 = $344 + $347;
    HEAPF32[$268 >> 2] = $348;
    var $349 = HEAPF32[$312 >> 2];
    var $350 = HEAPF32[$262 >> 2];
    var $351 = $350 - $349;
    HEAPF32[$312 >> 2] = $351;
    var $352 = HEAPF32[$262 >> 2];
    var $353 = $349 + $352;
    HEAPF32[$262 >> 2] = $353;
    var $354 = HEAPF32[$321 >> 2];
    var $355 = HEAPF32[$260 >> 2];
    var $356 = $355 - $354;
    HEAPF32[$321 >> 2] = $356;
    var $357 = HEAPF32[$260 >> 2];
    var $358 = $354 + $357;
    HEAPF32[$260 >> 2] = $358;
    var $359 = $a + 80 | 0;
    var $360 = HEAPF32[$359 >> 2];
    var $361 = $a + 32 | 0;
    var $362 = HEAPF32[$361 >> 2];
    var $363 = $360 - $362;
    var $364 = $360 + $362;
    HEAPF32[$361 >> 2] = $364;
    var $365 = $363 * 1.111140489578247;
    HEAPF32[$359 >> 2] = $365;
    var $366 = $a + 84 | 0;
    var $367 = HEAPF32[$366 >> 2];
    var $368 = $a + 36 | 0;
    var $369 = HEAPF32[$368 >> 2];
    var $370 = $367 - $369;
    var $371 = $367 + $369;
    HEAPF32[$368 >> 2] = $371;
    var $372 = $370 * 1.111140489578247;
    HEAPF32[$366 >> 2] = $372;
    var $373 = $a + 72 | 0;
    var $374 = HEAPF32[$373 >> 2];
    var $375 = $a + 40 | 0;
    var $376 = HEAPF32[$375 >> 2];
    var $377 = $374 - $376;
    var $378 = $374 + $376;
    HEAPF32[$375 >> 2] = $378;
    var $379 = $377 * .7653668522834778;
    HEAPF32[$373 >> 2] = $379;
    var $380 = $a + 76 | 0;
    var $381 = HEAPF32[$380 >> 2];
    var $382 = $a + 44 | 0;
    var $383 = HEAPF32[$382 >> 2];
    var $384 = $381 - $383;
    var $385 = $381 + $383;
    HEAPF32[$382 >> 2] = $385;
    var $386 = $384 * .7653668522834778;
    HEAPF32[$380 >> 2] = $386;
    var $387 = $a + 64 | 0;
    var $388 = HEAPF32[$387 >> 2];
    var $389 = $a + 48 | 0;
    var $390 = HEAPF32[$389 >> 2];
    var $391 = $388 - $390;
    var $392 = $388 + $390;
    HEAPF32[$389 >> 2] = $392;
    var $393 = $391 * .39018064737319946;
    HEAPF32[$387 >> 2] = $393;
    var $394 = $a + 68 | 0;
    var $395 = HEAPF32[$394 >> 2];
    var $396 = $a + 52 | 0;
    var $397 = HEAPF32[$396 >> 2];
    var $398 = $395 - $397;
    var $399 = $395 + $397;
    HEAPF32[$396 >> 2] = $399;
    var $400 = $398 * .39018064737319946;
    HEAPF32[$394 >> 2] = $400;
    var $401 = HEAPF32[$359 >> 2];
    var $402 = HEAPF32[$298 >> 2];
    var $403 = $402 - $401;
    var $404 = $401 + $402;
    HEAPF32[$359 >> 2] = $404;
    var $405 = $403 * .7653668522834778;
    HEAPF32[$298 >> 2] = $405;
    var $406 = HEAPF32[$366 >> 2];
    var $407 = HEAPF32[$305 >> 2];
    var $408 = $407 - $406;
    var $409 = $406 + $407;
    HEAPF32[$366 >> 2] = $409;
    var $410 = $408 * .7653668522834778;
    HEAPF32[$305 >> 2] = $410;
    var $411 = HEAPF32[$300 >> 2];
    var $412 = HEAPF32[$361 >> 2];
    var $413 = $411 - $412;
    var $414 = $411 + $412;
    HEAPF32[$300 >> 2] = $414;
    var $415 = $413 * .7653668522834778;
    HEAPF32[$361 >> 2] = $415;
    var $416 = HEAPF32[$307 >> 2];
    var $417 = HEAPF32[$368 >> 2];
    var $418 = $416 - $417;
    var $419 = $416 + $417;
    HEAPF32[$307 >> 2] = $419;
    var $420 = $418 * .7653668522834778;
    HEAPF32[$368 >> 2] = $420;
    var $421 = HEAPF32[$a >> 2];
    var $422 = HEAPF32[$389 >> 2];
    var $423 = $421 - $422;
    var $424 = $421 + $422;
    HEAPF32[$a >> 2] = $424;
    var $425 = $423 * 1.8477590084075928;
    HEAPF32[$389 >> 2] = $425;
    var $426 = HEAPF32[$279 >> 2];
    var $427 = HEAPF32[$396 >> 2];
    var $428 = $426 - $427;
    var $429 = $426 + $427;
    HEAPF32[$279 >> 2] = $429;
    var $430 = $428 * 1.8477590084075928;
    HEAPF32[$396 >> 2] = $430;
    var $431 = HEAPF32[$387 >> 2];
    var $432 = HEAPF32[$271 >> 2];
    var $433 = $431 - $432;
    var $434 = $431 + $432;
    HEAPF32[$387 >> 2] = $434;
    var $435 = $433 * 1.8477590084075928;
    HEAPF32[$271 >> 2] = $435;
    var $436 = HEAPF32[$394 >> 2];
    var $437 = HEAPF32[$277 >> 2];
    var $438 = $437 - $436;
    var $439 = $436 + $437;
    HEAPF32[$394 >> 2] = $439;
    var $440 = $438 * 1.8477590084075928;
    HEAPF32[$277 >> 2] = $440;
    var $441 = HEAPF32[$286 >> 2];
    var $442 = HEAPF32[$375 >> 2];
    var $443 = $441 - $442;
    var $444 = $443;
    var $445 = $444 * 1.4142135623730951;
    var $446 = $445;
    var $447 = $441 + $442;
    HEAPF32[$286 >> 2] = $447;
    HEAPF32[$375 >> 2] = $446;
    var $448 = HEAPF32[$293 >> 2];
    var $449 = HEAPF32[$382 >> 2];
    var $450 = $448 - $449;
    var $451 = $450;
    var $452 = $451 * 1.4142135623730951;
    var $453 = $452;
    var $454 = $448 + $449;
    HEAPF32[$293 >> 2] = $454;
    HEAPF32[$382 >> 2] = $453;
    var $455 = HEAPF32[$373 >> 2];
    var $456 = HEAPF32[$284 >> 2];
    var $457 = $456 - $455;
    var $458 = $457;
    var $459 = $458 * 1.4142135623730951;
    var $460 = $459;
    var $461 = $455 + $456;
    HEAPF32[$373 >> 2] = $461;
    var $462 = $460 - $461;
    HEAPF32[$284 >> 2] = $462;
    var $463 = HEAPF32[$380 >> 2];
    var $464 = HEAPF32[$291 >> 2];
    var $465 = $464 - $463;
    var $466 = $465;
    var $467 = $466 * 1.4142135623730951;
    var $468 = $467;
    var $469 = $463 + $464;
    HEAPF32[$380 >> 2] = $469;
    var $470 = $468 - $469;
    HEAPF32[$291 >> 2] = $470;
    var $471 = HEAPF32[$286 >> 2];
    var $472 = HEAPF32[$293 >> 2];
    var $473 = HEAPF32[$380 >> 2];
    var $474 = $473 - $472;
    HEAPF32[$380 >> 2] = $474;
    var $475 = HEAPF32[$293 >> 2];
    var $476 = $475 - $471;
    HEAPF32[$293 >> 2] = $476;
    var $477 = HEAPF32[$266 >> 2];
    var $478 = $477 - $471;
    HEAPF32[$286 >> 2] = $478;
    var $479 = HEAPF32[$266 >> 2];
    var $480 = $471 + $479;
    HEAPF32[$266 >> 2] = $480;
    var $481 = HEAPF32[$293 >> 2];
    var $482 = HEAPF32[$380 >> 2];
    var $483 = HEAPF32[$382 >> 2];
    var $484 = $483 - $482;
    HEAPF32[$382 >> 2] = $484;
    var $485 = HEAPF32[$373 >> 2];
    var $486 = $485 - $481;
    HEAPF32[$373 >> 2] = $486;
    var $487 = HEAPF32[$268 >> 2];
    var $488 = $487 - $481;
    HEAPF32[$293 >> 2] = $488;
    var $489 = HEAPF32[$268 >> 2];
    var $490 = $481 + $489;
    HEAPF32[$268 >> 2] = $490;
    var $491 = HEAPF32[$373 >> 2];
    var $492 = HEAPF32[$382 >> 2];
    var $493 = HEAPF32[$291 >> 2];
    var $494 = $493 - $492;
    HEAPF32[$291 >> 2] = $494;
    var $495 = HEAPF32[$380 >> 2];
    var $496 = $495 - $491;
    HEAPF32[$380 >> 2] = $496;
    var $497 = HEAPF32[$262 >> 2];
    var $498 = $497 - $491;
    HEAPF32[$373 >> 2] = $498;
    var $499 = HEAPF32[$262 >> 2];
    var $500 = $491 + $499;
    HEAPF32[$262 >> 2] = $500;
    var $501 = HEAPF32[$380 >> 2];
    var $502 = HEAPF32[$375 >> 2];
    var $503 = $502 - $501;
    HEAPF32[$375 >> 2] = $503;
    var $504 = HEAPF32[$260 >> 2];
    var $505 = $504 - $501;
    HEAPF32[$380 >> 2] = $505;
    var $506 = HEAPF32[$260 >> 2];
    var $507 = $501 + $506;
    HEAPF32[$260 >> 2] = $507;
    var $508 = HEAPF32[$375 >> 2];
    var $509 = HEAPF32[$382 >> 2];
    var $510 = $509 - $508;
    HEAPF32[$382 >> 2] = $510;
    var $511 = HEAPF32[$321 >> 2];
    var $512 = $511 - $508;
    HEAPF32[$375 >> 2] = $512;
    var $513 = HEAPF32[$321 >> 2];
    var $514 = $508 + $513;
    HEAPF32[$321 >> 2] = $514;
    var $515 = HEAPF32[$382 >> 2];
    var $516 = HEAPF32[$284 >> 2];
    var $517 = $516 - $515;
    HEAPF32[$284 >> 2] = $517;
    var $518 = HEAPF32[$312 >> 2];
    var $519 = $518 - $515;
    HEAPF32[$382 >> 2] = $519;
    var $520 = HEAPF32[$312 >> 2];
    var $521 = $515 + $520;
    HEAPF32[$312 >> 2] = $521;
    var $522 = HEAPF32[$284 >> 2];
    var $523 = HEAPF32[$291 >> 2];
    var $524 = $523 - $522;
    HEAPF32[$291 >> 2] = $524;
    var $525 = HEAPF32[$323 >> 2];
    var $526 = $525 - $522;
    HEAPF32[$284 >> 2] = $526;
    var $527 = HEAPF32[$323 >> 2];
    var $528 = $522 + $527;
    HEAPF32[$323 >> 2] = $528;
    var $529 = HEAPF32[$291 >> 2];
    var $530 = HEAPF32[$314 >> 2];
    var $531 = $530 - $529;
    HEAPF32[$291 >> 2] = $531;
    var $532 = HEAPF32[$314 >> 2];
    var $533 = $529 + $532;
    HEAPF32[$314 >> 2] = $533;
    var $534 = HEAPF32[$a >> 2];
    var $535 = HEAPF32[$300 >> 2];
    var $536 = $534 - $535;
    var $537 = $536;
    var $538 = $537 * 1.4142135623730951;
    var $539 = $538;
    var $540 = $534 + $535;
    HEAPF32[$a >> 2] = $540;
    HEAPF32[$300 >> 2] = $539;
    var $541 = HEAPF32[$279 >> 2];
    var $542 = HEAPF32[$307 >> 2];
    var $543 = $541 - $542;
    var $544 = $543;
    var $545 = $544 * 1.4142135623730951;
    var $546 = $545;
    var $547 = $541 + $542;
    HEAPF32[$279 >> 2] = $547;
    HEAPF32[$307 >> 2] = $546;
    var $548 = HEAPF32[$387 >> 2];
    var $549 = HEAPF32[$359 >> 2];
    var $550 = $548 - $549;
    var $551 = $550;
    var $552 = $551 * 1.4142135623730951;
    var $553 = $552;
    var $554 = $548 + $549;
    HEAPF32[$387 >> 2] = $554;
    HEAPF32[$359 >> 2] = $553;
    var $555 = HEAPF32[$394 >> 2];
    var $556 = HEAPF32[$366 >> 2];
    var $557 = $555 - $556;
    var $558 = $557;
    var $559 = $558 * 1.4142135623730951;
    var $560 = $559;
    var $561 = $555 + $556;
    HEAPF32[$394 >> 2] = $561;
    HEAPF32[$366 >> 2] = $560;
    var $562 = HEAPF32[$361 >> 2];
    var $563 = HEAPF32[$389 >> 2];
    var $564 = $562 - $563;
    var $565 = $564;
    var $566 = $565 * -1.4142135623730951;
    var $567 = $566;
    var $568 = $562 + $563;
    HEAPF32[$361 >> 2] = $568;
    var $569 = $567 - $568;
    HEAPF32[$389 >> 2] = $569;
    var $570 = HEAPF32[$368 >> 2];
    var $571 = HEAPF32[$396 >> 2];
    var $572 = $570 - $571;
    var $573 = $572;
    var $574 = $573 * -1.4142135623730951;
    var $575 = $574;
    var $576 = $570 + $571;
    HEAPF32[$368 >> 2] = $576;
    var $577 = $575 - $576;
    HEAPF32[$396 >> 2] = $577;
    var $578 = HEAPF32[$305 >> 2];
    var $579 = HEAPF32[$277 >> 2];
    var $580 = $578 - $579;
    var $581 = $580;
    var $582 = $581 * -1.4142135623730951;
    var $583 = $582;
    var $584 = $578 + $579;
    HEAPF32[$305 >> 2] = $584;
    var $585 = $583 - $584;
    HEAPF32[$277 >> 2] = $585;
    var $586 = HEAPF32[$298 >> 2];
    var $587 = HEAPF32[$271 >> 2];
    var $588 = $586 + $587;
    var $589 = $588;
    var $590 = $589 * -1.4142135623730951;
    var $591 = $590;
    var $592 = $586 - $587;
    HEAPF32[$298 >> 2] = $592;
    var $593 = $591 - $592;
    HEAPF32[$271 >> 2] = $593;
    var $594 = HEAPF32[$298 >> 2];
    var $595 = HEAPF32[$387 >> 2];
    var $596 = $594 - $595;
    HEAPF32[$298 >> 2] = $596;
    var $597 = HEAPF32[$359 >> 2];
    var $598 = $597 - $596;
    HEAPF32[$359 >> 2] = $598;
    var $599 = HEAPF32[$271 >> 2];
    var $600 = $599 - $598;
    HEAPF32[$271 >> 2] = $600;
    var $601 = HEAPF32[$305 >> 2];
    var $602 = HEAPF32[$394 >> 2];
    var $603 = $601 - $602;
    HEAPF32[$305 >> 2] = $603;
    var $604 = HEAPF32[$366 >> 2];
    var $605 = $604 - $603;
    HEAPF32[$366 >> 2] = $605;
    var $606 = HEAPF32[$277 >> 2];
    var $607 = $606 - $605;
    HEAPF32[$277 >> 2] = $607;
    var $608 = HEAPF32[$394 >> 2];
    var $609 = HEAPF32[$279 >> 2];
    var $610 = $608 - $609;
    HEAPF32[$394 >> 2] = $610;
    var $611 = HEAPF32[$368 >> 2];
    var $612 = $611 - $610;
    HEAPF32[$368 >> 2] = $612;
    var $613 = HEAPF32[$305 >> 2];
    var $614 = $613 - $612;
    HEAPF32[$305 >> 2] = $614;
    var $615 = HEAPF32[$307 >> 2];
    var $616 = $615 - $614;
    HEAPF32[$307 >> 2] = $616;
    var $617 = HEAPF32[$366 >> 2];
    var $618 = $617 - $616;
    HEAPF32[$366 >> 2] = $618;
    var $619 = HEAPF32[$396 >> 2];
    var $620 = $619 - $618;
    HEAPF32[$396 >> 2] = $620;
    var $621 = HEAPF32[$277 >> 2];
    var $622 = $621 - $620;
    HEAPF32[$277 >> 2] = $622;
    var $623 = HEAPF32[$279 >> 2];
    var $624 = HEAPF32[$a >> 2];
    var $625 = $623 - $624;
    HEAPF32[$279 >> 2] = $625;
    var $626 = HEAPF32[$387 >> 2];
    var $627 = $626 - $625;
    HEAPF32[$387 >> 2] = $627;
    var $628 = HEAPF32[$394 >> 2];
    var $629 = $628 - $627;
    HEAPF32[$394 >> 2] = $629;
    var $630 = HEAPF32[$361 >> 2];
    var $631 = $630 - $629;
    HEAPF32[$361 >> 2] = $631;
    var $632 = HEAPF32[$368 >> 2];
    var $633 = $632 - $631;
    HEAPF32[$368 >> 2] = $633;
    var $634 = HEAPF32[$298 >> 2];
    var $635 = $634 - $633;
    HEAPF32[$298 >> 2] = $635;
    var $636 = HEAPF32[$305 >> 2];
    var $637 = $636 - $635;
    HEAPF32[$305 >> 2] = $637;
    var $638 = HEAPF32[$300 >> 2];
    var $639 = $638 - $637;
    HEAPF32[$300 >> 2] = $639;
    var $640 = HEAPF32[$307 >> 2];
    var $641 = $640 - $639;
    HEAPF32[$307 >> 2] = $641;
    var $642 = HEAPF32[$359 >> 2];
    var $643 = $642 - $641;
    HEAPF32[$359 >> 2] = $643;
    var $644 = HEAPF32[$366 >> 2];
    var $645 = $644 - $643;
    HEAPF32[$366 >> 2] = $645;
    var $646 = HEAPF32[$389 >> 2];
    var $647 = $646 - $645;
    HEAPF32[$389 >> 2] = $647;
    var $648 = HEAPF32[$396 >> 2];
    var $649 = $648 - $647;
    HEAPF32[$396 >> 2] = $649;
    var $650 = HEAPF32[$271 >> 2];
    var $651 = $650 - $649;
    HEAPF32[$271 >> 2] = $651;
    var $652 = HEAPF32[$277 >> 2];
    var $653 = $652 - $651;
    HEAPF32[$277 >> 2] = $653;
    var $654 = HEAPF32[$a >> 2];
    var $655 = HEAPF32[$266 >> 2];
    var $656 = $654 + $655;
    HEAPF32[$a >> 2] = $656;
    var $657 = HEAPF32[$266 >> 2];
    var $658 = $657 - $654;
    HEAPF32[$266 >> 2] = $658;
    var $659 = HEAPF32[$279 >> 2];
    var $660 = HEAPF32[$268 >> 2];
    var $661 = $659 + $660;
    HEAPF32[$279 >> 2] = $661;
    var $662 = HEAPF32[$268 >> 2];
    var $663 = $662 - $659;
    HEAPF32[$268 >> 2] = $663;
    var $664 = HEAPF32[$387 >> 2];
    var $665 = HEAPF32[$262 >> 2];
    var $666 = $664 + $665;
    HEAPF32[$387 >> 2] = $666;
    var $667 = HEAPF32[$262 >> 2];
    var $668 = $667 - $664;
    HEAPF32[$262 >> 2] = $668;
    var $669 = HEAPF32[$394 >> 2];
    var $670 = HEAPF32[$260 >> 2];
    var $671 = $669 + $670;
    HEAPF32[$394 >> 2] = $671;
    var $672 = HEAPF32[$260 >> 2];
    var $673 = $672 - $669;
    HEAPF32[$260 >> 2] = $673;
    var $674 = HEAPF32[$361 >> 2];
    var $675 = HEAPF32[$321 >> 2];
    var $676 = $674 + $675;
    HEAPF32[$361 >> 2] = $676;
    var $677 = HEAPF32[$321 >> 2];
    var $678 = $677 - $674;
    HEAPF32[$321 >> 2] = $678;
    var $679 = HEAPF32[$368 >> 2];
    var $680 = HEAPF32[$312 >> 2];
    var $681 = $679 + $680;
    HEAPF32[$368 >> 2] = $681;
    var $682 = HEAPF32[$312 >> 2];
    var $683 = $682 - $679;
    HEAPF32[$312 >> 2] = $683;
    var $684 = HEAPF32[$298 >> 2];
    var $685 = HEAPF32[$323 >> 2];
    var $686 = $684 + $685;
    HEAPF32[$298 >> 2] = $686;
    var $687 = HEAPF32[$323 >> 2];
    var $688 = $687 - $684;
    HEAPF32[$323 >> 2] = $688;
    var $689 = HEAPF32[$305 >> 2];
    var $690 = HEAPF32[$314 >> 2];
    var $691 = $689 + $690;
    HEAPF32[$305 >> 2] = $691;
    var $692 = HEAPF32[$314 >> 2];
    var $693 = $692 - $689;
    HEAPF32[$314 >> 2] = $693;
    var $694 = HEAPF32[$300 >> 2];
    var $695 = HEAPF32[$291 >> 2];
    var $696 = $694 + $695;
    HEAPF32[$300 >> 2] = $696;
    var $697 = HEAPF32[$291 >> 2];
    var $698 = $697 - $694;
    HEAPF32[$291 >> 2] = $698;
    var $699 = HEAPF32[$307 >> 2];
    var $700 = HEAPF32[$284 >> 2];
    var $701 = $699 + $700;
    HEAPF32[$307 >> 2] = $701;
    var $702 = HEAPF32[$284 >> 2];
    var $703 = $702 - $699;
    HEAPF32[$284 >> 2] = $703;
    var $704 = HEAPF32[$359 >> 2];
    var $705 = HEAPF32[$382 >> 2];
    var $706 = $704 + $705;
    HEAPF32[$359 >> 2] = $706;
    var $707 = HEAPF32[$382 >> 2];
    var $708 = $707 - $704;
    HEAPF32[$382 >> 2] = $708;
    var $709 = HEAPF32[$366 >> 2];
    var $710 = HEAPF32[$375 >> 2];
    var $711 = $709 + $710;
    HEAPF32[$366 >> 2] = $711;
    var $712 = HEAPF32[$375 >> 2];
    var $713 = $712 - $709;
    HEAPF32[$375 >> 2] = $713;
    var $714 = HEAPF32[$389 >> 2];
    var $715 = HEAPF32[$380 >> 2];
    var $716 = $714 + $715;
    HEAPF32[$389 >> 2] = $716;
    var $717 = HEAPF32[$380 >> 2];
    var $718 = $717 - $714;
    HEAPF32[$380 >> 2] = $718;
    var $719 = HEAPF32[$396 >> 2];
    var $720 = HEAPF32[$373 >> 2];
    var $721 = $719 + $720;
    HEAPF32[$396 >> 2] = $721;
    var $722 = HEAPF32[$373 >> 2];
    var $723 = $722 - $719;
    HEAPF32[$373 >> 2] = $723;
    var $724 = HEAPF32[$271 >> 2];
    var $725 = HEAPF32[$293 >> 2];
    var $726 = $724 + $725;
    HEAPF32[$271 >> 2] = $726;
    var $727 = HEAPF32[$293 >> 2];
    var $728 = $727 - $724;
    HEAPF32[$293 >> 2] = $728;
    var $729 = HEAPF32[$277 >> 2];
    var $730 = HEAPF32[$286 >> 2];
    var $731 = $729 + $730;
    HEAPF32[$277 >> 2] = $731;
    var $732 = HEAPF32[$286 >> 2];
    var $733 = $732 - $729;
    HEAPF32[$286 >> 2] = $733;
    return;
  }
}
_window_subband["X"] = 1;
function _get_vbr_preset($v) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    if (($v | 0) == 4 | ($v | 0) == 1) {
      var $_0 = 5248892;
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $_0 = 5248144;
    label = 4;
    break;
   case 4:
    var $_0;
    return $_0;
  }
}
function _min_int($a) {
  return ($a | 0) < 320 ? $a : 320;
}
function _max_int($a) {
  return ($a | 0) > 8 ? $a : 8;
}
function _mdct_short($inout) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $l_040 = 0;
    var $_041 = $inout;
    label = 3;
    break;
   case 3:
    var $_041;
    var $l_040;
    var $2 = $_041 + 24 | 0;
    var $3 = HEAPF32[$2 >> 2];
    var $4 = $3 * .13165250420570374;
    var $5 = $_041 + 60 | 0;
    var $6 = HEAPF32[$5 >> 2];
    var $7 = $4 - $6;
    var $8 = HEAPF32[$_041 >> 2];
    var $9 = $8 * .7673270106315613;
    var $10 = $_041 + 36 | 0;
    var $11 = HEAPF32[$10 >> 2];
    var $12 = $9 - $11;
    var $13 = $7 + $12;
    var $14 = $7 - $12;
    var $15 = $6 * .13165250420570374;
    var $16 = $3 + $15;
    var $17 = $11 * .7673270106315613;
    var $18 = $8 + $17;
    var $19 = $16 + $18;
    var $20 = $18 - $16;
    var $21 = $_041 + 12 | 0;
    var $22 = HEAPF32[$21 >> 2];
    var $23 = $22 * .4142135679721832;
    var $24 = $_041 + 48 | 0;
    var $25 = HEAPF32[$24 >> 2];
    var $26 = $23 - $25;
    var $27 = $26;
    var $28 = $27 * 2.069978111953089e-11;
    var $29 = $28;
    var $30 = $25 * .4142135679721832;
    var $31 = $22 + $30;
    var $32 = $31;
    var $33 = $32 * 2.069978111953089e-11;
    var $34 = $33;
    var $35 = $13;
    var $36 = $35 * 1.90752519173728e-11;
    var $37 = $29;
    var $38 = $36 + $37;
    var $39 = $38;
    HEAPF32[$_041 >> 2] = $39;
    var $40 = -$19;
    var $41 = $40;
    var $42 = $41 * 1.90752519173728e-11;
    var $43 = $34;
    var $44 = $42 + $43;
    var $45 = $44;
    HEAPF32[$5 >> 2] = $45;
    var $46 = $14;
    var $47 = $46 * .8660254037844387;
    var $48 = $47 * 1.907525191737281e-11;
    var $49 = $48;
    var $50 = $19;
    var $51 = $50 * .5;
    var $52 = $51 * 1.907525191737281e-11;
    var $53 = $52 + $43;
    var $54 = $53;
    var $55 = $49 - $54;
    HEAPF32[$21 >> 2] = $55;
    var $56 = $49 + $54;
    HEAPF32[$2 >> 2] = $56;
    var $57 = $35 * .5;
    var $58 = $57 * 1.907525191737281e-11;
    var $59 = $58 - $37;
    var $60 = $59;
    var $61 = $20;
    var $62 = $61 * .8660254037844387;
    var $63 = $62 * 1.907525191737281e-11;
    var $64 = $63;
    var $65 = $64 + $60;
    HEAPF32[$10 >> 2] = $65;
    var $66 = $60 - $64;
    HEAPF32[$24 >> 2] = $66;
    var $67 = $_041 + 4 | 0;
    var $68 = $l_040 + 1 | 0;
    var $exitcond = ($68 | 0) == 3;
    if ($exitcond) {
      label = 4;
      break;
    } else {
      var $l_040 = $68;
      var $_041 = $67;
      label = 3;
      break;
    }
   case 4:
    return;
  }
}
_mdct_short["X"] = 1;
function _mdct_long($out, $in) {
  var $1 = $in + 68 | 0;
  var $3 = $in + 36 | 0;
  var $5 = HEAPF32[$1 >> 2] - HEAPF32[$3 >> 2];
  var $6 = $in + 60 | 0;
  var $8 = $in + 44 | 0;
  var $10 = HEAPF32[$6 >> 2] - HEAPF32[$8 >> 2];
  var $11 = $in + 56 | 0;
  var $13 = $in + 48 | 0;
  var $15 = HEAPF32[$11 >> 2] - HEAPF32[$13 >> 2];
  var $17 = $in + 32 | 0;
  var $19 = HEAPF32[$in >> 2] + HEAPF32[$17 >> 2];
  var $20 = $in + 4 | 0;
  var $22 = $in + 28 | 0;
  var $24 = HEAPF32[$20 >> 2] + HEAPF32[$22 >> 2];
  var $25 = $in + 8 | 0;
  var $27 = $in + 24 | 0;
  var $29 = HEAPF32[$25 >> 2] + HEAPF32[$27 >> 2];
  var $30 = $in + 12 | 0;
  var $32 = $in + 20 | 0;
  var $34 = HEAPF32[$30 >> 2] + HEAPF32[$32 >> 2];
  var $36 = $19 + $29 - $34;
  var $37 = $in + 16 | 0;
  HEAPF32[$out + 68 >> 2] = $36 - ($24 - HEAPF32[$37 >> 2]);
  var $45 = $36 * .5 + ($24 - HEAPF32[$37 >> 2]);
  var $48 = ($5 - $10 - $15) * .8660253882408142;
  HEAPF32[$out + 20 >> 2] = $48 + $45;
  HEAPF32[$out + 24 >> 2] = $48 - $45;
  var $53 = $in + 64 | 0;
  var $55 = $in + 40 | 0;
  var $58 = (HEAPF32[$53 >> 2] - HEAPF32[$55 >> 2]) * .8660253882408142;
  var $61 = $24 * .5 + HEAPF32[$37 >> 2];
  var $67 = $15 * .3420201539993286 + ($10 * .6427876353263855 + ($5 * .9848077297210693 + $58));
  var $73 = $34 * .9396926164627075 + ($19 * .1736481785774231 + $61 - $29 * -.7660444378852844);
  HEAPF32[$out + 4 >> 2] = $67 + $73;
  HEAPF32[$out + 8 >> 2] = $67 - $73;
  var $83 = $15 * .9848077297210693 + ($5 * .6427876353263855 - $58 - $10 * .3420201539993286);
  var $89 = $34 * -.1736481785774231 + ($19 * .7660444378852844 + $61 - $29 * .9396926164627075);
  HEAPF32[$out + 36 >> 2] = $83 + $89;
  HEAPF32[$out + 40 >> 2] = $83 - $89;
  var $99 = $10 * .9848077297210693 + ($5 * .3420201539993286 - $58) - $15 * .6427876353263855;
  var $105 = $29 * -.1736481785774231 + ($19 * .9396926164627075 - $61) - $34 * -.7660444378852844;
  HEAPF32[$out + 52 >> 2] = $99 + $105;
  HEAPF32[$out + 56 >> 2] = $99 - $105;
  var $112 = HEAPF32[$17 >> 2] - HEAPF32[$in >> 2];
  var $115 = HEAPF32[$27 >> 2] - HEAPF32[$25 >> 2];
  var $118 = HEAPF32[$32 >> 2] - HEAPF32[$30 >> 2];
  var $121 = HEAPF32[$1 >> 2] + HEAPF32[$3 >> 2];
  var $124 = HEAPF32[$53 >> 2] + HEAPF32[$55 >> 2];
  var $127 = HEAPF32[$6 >> 2] + HEAPF32[$8 >> 2];
  var $130 = HEAPF32[$11 >> 2] + HEAPF32[$13 >> 2];
  var $132 = $121 + $127 + $130;
  var $133 = $in + 52 | 0;
  HEAPF32[$out >> 2] = $132 + ($124 + HEAPF32[$133 >> 2]);
  var $140 = $132 * .5 - ($124 + HEAPF32[$133 >> 2]);
  var $143 = ($112 - $115 + $118) * .8660253882408142;
  HEAPF32[$out + 44 >> 2] = $143 + $140;
  HEAPF32[$out + 48 >> 2] = $140 - $143;
  var $151 = (HEAPF32[$22 >> 2] - HEAPF32[$20 >> 2]) * .8660253882408142;
  var $154 = HEAPF32[$133 >> 2] - $124 * .5;
  var $160 = $130 * -.7660444378852844 + ($127 * -.1736481785774231 + ($121 * .9396926164627075 - $154));
  var $166 = $118 * .6427876353263855 + ($115 * .9848077297210693 + ($112 * .3420201539993286 + $151));
  HEAPF32[$out + 12 >> 2] = $160 + $166;
  HEAPF32[$out + 16 >> 2] = $160 - $166;
  var $176 = $121 * .7660444378852844 + $154 - $127 * .9396926164627075 - $130 * -.1736481785774231;
  var $182 = $112 * .6427876353263855 + $151 - $115 * .3420201539993286 - $118 * .9848077297210693;
  HEAPF32[$out + 28 >> 2] = $176 + $182;
  HEAPF32[$out + 32 >> 2] = $176 - $182;
  var $192 = $121 * .1736481785774231 + $154 - $127 * -.7660444378852844 - $130 * .9396926164627075;
  var $198 = $115 * .6427876353263855 + ($112 * .9848077297210693 - $151) - $118 * .3420201539993286;
  HEAPF32[$out + 60 >> 2] = $192 + $198;
  HEAPF32[$out + 64 >> 2] = $192 - $198;
  return;
}
_mdct_long["X"] = 1;
function _apply_preset($gfp, $preset, $enforce) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    if (($preset | 0) == 1e3) {
      label = 3;
      break;
    } else if (($preset | 0) == 1006 | ($preset | 0) == 1007) {
      label = 4;
      break;
    } else if (($preset | 0) == 1001 | ($preset | 0) == 1004) {
      label = 5;
      break;
    } else if (($preset | 0) == 1002 | ($preset | 0) == 1005) {
      label = 6;
      break;
    } else if (($preset | 0) == 1003) {
      label = 7;
      break;
    } else {
      label = 8;
      break;
    }
   case 3:
    var $1 = _lame_set_VBR($gfp, 4);
    var $2 = $gfp + 152 | 0;
    HEAP32[$2 >> 2] = 470;
    label = 15;
    break;
   case 4:
    var $3 = _lame_set_VBR($gfp, 4);
    var $4 = $gfp + 152 | 0;
    HEAP32[$4 >> 2] = 460;
    label = 14;
    break;
   case 5:
    var $5 = _lame_set_VBR($gfp, 4);
    var $6 = $gfp + 152 | 0;
    HEAP32[$6 >> 2] = 480;
    label = 16;
    break;
   case 6:
    var $7 = _lame_set_VBR($gfp, 4);
    var $8 = $gfp + 152 | 0;
    HEAP32[$8 >> 2] = 500;
    label = 18;
    break;
   case 7:
    var $10 = $gfp + 152 | 0;
    HEAP32[$10 >> 2] = 320;
    var $11 = _apply_abr_preset($gfp, 320, $enforce);
    var $12 = _lame_set_VBR($gfp, 0);
    var $_0 = 320;
    label = 22;
    break;
   case 8:
    var $14 = $gfp + 152 | 0;
    HEAP32[$14 >> 2] = $preset;
    if (($preset | 0) == 410) {
      label = 9;
      break;
    } else if (($preset | 0) == 420) {
      label = 10;
      break;
    } else if (($preset | 0) == 430) {
      label = 11;
      break;
    } else if (($preset | 0) == 440) {
      label = 12;
      break;
    } else if (($preset | 0) == 450) {
      label = 13;
      break;
    } else if (($preset | 0) == 460) {
      label = 14;
      break;
    } else if (($preset | 0) == 470) {
      label = 15;
      break;
    } else if (($preset | 0) == 480) {
      label = 16;
      break;
    } else if (($preset | 0) == 490) {
      label = 17;
      break;
    } else if (($preset | 0) == 500) {
      label = 18;
      break;
    } else {
      label = 19;
      break;
    }
   case 9:
    _apply_vbr_preset($gfp, 9, $enforce);
    var $_0 = 410;
    label = 22;
    break;
   case 10:
    _apply_vbr_preset($gfp, 8, $enforce);
    var $_0 = 420;
    label = 22;
    break;
   case 11:
    _apply_vbr_preset($gfp, 7, $enforce);
    var $_0 = 430;
    label = 22;
    break;
   case 12:
    _apply_vbr_preset($gfp, 6, $enforce);
    var $_0 = 440;
    label = 22;
    break;
   case 13:
    _apply_vbr_preset($gfp, 5, $enforce);
    var $_0 = 450;
    label = 22;
    break;
   case 14:
    _apply_vbr_preset($gfp, 4, $enforce);
    var $_0 = 460;
    label = 22;
    break;
   case 15:
    _apply_vbr_preset($gfp, 3, $enforce);
    var $_0 = 470;
    label = 22;
    break;
   case 16:
    _apply_vbr_preset($gfp, 2, $enforce);
    var $_0 = 480;
    label = 22;
    break;
   case 17:
    _apply_vbr_preset($gfp, 1, $enforce);
    var $_0 = 490;
    label = 22;
    break;
   case 18:
    _apply_vbr_preset($gfp, 0, $enforce);
    var $_0 = 500;
    label = 22;
    break;
   case 19:
    var $_053_off = $preset - 8 | 0;
    var $26 = $_053_off >>> 0 < 313;
    if ($26) {
      label = 20;
      break;
    } else {
      label = 21;
      break;
    }
   case 20:
    var $28 = _apply_abr_preset($gfp, $preset, $enforce);
    var $_0 = $28;
    label = 22;
    break;
   case 21:
    HEAP32[$14 >> 2] = 0;
    var $_0 = $preset;
    label = 22;
    break;
   case 22:
    var $_0;
    return $_0;
  }
}
_apply_preset["X"] = 1;
function _apply_abr_preset($gfp, $preset, $enforce) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $preset & 65535;
    var $2 = _nearestBitrateFullIndex($1);
    var $3 = _lame_set_VBR($gfp, 3);
    var $4 = _lame_set_VBR_mean_bitrate_kbps($gfp, $preset);
    var $5 = _lame_get_VBR_mean_bitrate_kbps($gfp);
    var $6 = _min_int($5);
    var $7 = _lame_set_VBR_mean_bitrate_kbps($gfp, $6);
    var $8 = _lame_get_VBR_mean_bitrate_kbps($gfp);
    var $9 = _max_int($8);
    var $10 = _lame_set_VBR_mean_bitrate_kbps($gfp, $9);
    var $11 = _lame_get_VBR_mean_bitrate_kbps($gfp);
    var $12 = _lame_set_brate($gfp, $11);
    var $13 = $2 - 12 | 0;
    var $14 = $13 >>> 0 < 5;
    if ($14) {
      label = 3;
      break;
    } else {
      label = 4;
      break;
    }
   case 3:
    var $16 = _lame_get_exp_nspsytune($gfp);
    var $17 = $16 | 2;
    var $18 = _lame_set_exp_nspsytune($gfp, $17);
    label = 4;
    break;
   case 4:
    var $20 = $2 >>> 0 < 13;
    if ($20) {
      label = 5;
      break;
    } else {
      label = 6;
      break;
    }
   case 5:
    var $22 = _lame_set_sfscale($gfp, 1);
    label = 6;
    break;
   case 6:
    var $24 = ($enforce | 0) != 0;
    if ($24) {
      label = 15;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    var $26 = _lame_get_quant_comp($gfp);
    var $27 = ($26 | 0) == -1;
    if ($27) {
      label = 8;
      break;
    } else {
      label = 9;
      break;
    }
   case 8:
    var $29 = 5348880 + $2 * 52 | 0;
    var $30 = HEAP32[$29 >> 2];
    var $31 = _lame_set_quant_comp($gfp, $30);
    label = 9;
    break;
   case 9:
    var $33 = _lame_get_quant_comp_short($gfp);
    var $34 = ($33 | 0) == -1;
    if ($34) {
      label = 10;
      break;
    } else {
      label = 11;
      break;
    }
   case 10:
    var $36 = 5348884 + $2 * 52 | 0;
    var $37 = HEAP32[$36 >> 2];
    var $38 = _lame_set_quant_comp_short($gfp, $37);
    label = 11;
    break;
   case 11:
    var $40 = _lame_get_msfix($gfp);
    var $41 = $40 + 1;
    var $42 = $41 == 0;
    if ($42) {
      label = 12;
      break;
    } else {
      label = 13;
      break;
    }
   case 12:
    var $44 = 5348892 + $2 * 52 | 0;
    var $45 = HEAPF32[$44 >> 2];
    var $46 = $45;
    _lame_set_msfix($gfp, $46);
    label = 13;
    break;
   case 13:
    var $48 = _lame_get_short_threshold_lrm($gfp);
    var $49 = $48 + 1;
    var $50 = $49 == 0;
    if ($50) {
      label = 14;
      break;
    } else {
      label = 16;
      break;
    }
   case 14:
    var $52 = 5348896 + $2 * 52 | 0;
    var $53 = HEAPF32[$52 >> 2];
    var $54 = _lame_set_short_threshold_lrm($gfp, $53);
    label = 16;
    break;
   case 15:
    var $56 = 5348880 + $2 * 52 | 0;
    var $57 = HEAP32[$56 >> 2];
    var $58 = _lame_set_quant_comp($gfp, $57);
    var $59 = 5348884 + $2 * 52 | 0;
    var $60 = HEAP32[$59 >> 2];
    var $61 = _lame_set_quant_comp_short($gfp, $60);
    var $62 = 5348892 + $2 * 52 | 0;
    var $63 = HEAPF32[$62 >> 2];
    var $64 = $63;
    _lame_set_msfix($gfp, $64);
    var $65 = 5348896 + $2 * 52 | 0;
    var $66 = HEAPF32[$65 >> 2];
    var $67 = _lame_set_short_threshold_lrm($gfp, $66);
    var $68 = 5348900 + $2 * 52 | 0;
    var $69 = HEAPF32[$68 >> 2];
    var $70 = _lame_set_short_threshold_s($gfp, $69);
    label = 18;
    break;
   case 16:
    var $72 = _lame_get_short_threshold_s($gfp);
    var $73 = $72 + 1;
    var $74 = $73 == 0;
    if ($74) {
      label = 17;
      break;
    } else {
      label = 18;
      break;
    }
   case 17:
    var $76 = 5348900 + $2 * 52 | 0;
    var $77 = HEAPF32[$76 >> 2];
    var $78 = _lame_set_short_threshold_s($gfp, $77);
    label = 18;
    break;
   case 18:
    var $80 = _lame_get_scale($gfp);
    var $81 = 5348904 + $2 * 52 | 0;
    var $82 = HEAPF32[$81 >> 2];
    var $83 = $80 * $82;
    var $84 = _lame_set_scale($gfp, $83);
    if ($24) {
      label = 27;
      break;
    } else {
      label = 19;
      break;
    }
   case 19:
    var $86 = _lame_get_maskingadjust($gfp);
    var $87 = $86 == 0;
    if ($87) {
      label = 20;
      break;
    } else {
      label = 21;
      break;
    }
   case 20:
    var $89 = 5348908 + $2 * 52 | 0;
    var $90 = HEAPF32[$89 >> 2];
    var $91 = _lame_set_maskingadjust($gfp, $90);
    label = 21;
    break;
   case 21:
    var $93 = _lame_get_maskingadjust_short($gfp);
    var $94 = $93 == 0;
    if ($94) {
      label = 22;
      break;
    } else {
      label = 23;
      break;
    }
   case 22:
    var $96 = 5348908 + $2 * 52 | 0;
    var $97 = HEAPF32[$96 >> 2];
    var $98 = $97;
    var $99 = $98 * 1.1;
    var $100 = $99;
    var $101 = _lame_set_maskingadjust_short($gfp, $100);
    label = 23;
    break;
   case 23:
    var $103 = _lame_get_ATHlower($gfp);
    var $104 = $103 == 0;
    if ($104) {
      label = 24;
      break;
    } else {
      label = 25;
      break;
    }
   case 24:
    var $106 = 5348912 + $2 * 52 | 0;
    var $107 = HEAPF32[$106 >> 2];
    var $108 = _lame_set_ATHlower($gfp, $107);
    label = 25;
    break;
   case 25:
    var $110 = _lame_get_ATHcurve($gfp);
    var $111 = $110 + 1;
    var $112 = $111 == 0;
    if ($112) {
      label = 26;
      break;
    } else {
      label = 28;
      break;
    }
   case 26:
    var $114 = 5348916 + $2 * 52 | 0;
    var $115 = HEAPF32[$114 >> 2];
    var $116 = _lame_set_ATHcurve($gfp, $115);
    label = 28;
    break;
   case 27:
    var $118 = 5348908 + $2 * 52 | 0;
    var $119 = HEAPF32[$118 >> 2];
    var $120 = _lame_set_maskingadjust($gfp, $119);
    var $121 = 5348908 + $2 * 52 | 0;
    var $122 = HEAPF32[$121 >> 2];
    var $123 = $122;
    var $124 = $123 * 1.1;
    var $125 = $124;
    var $126 = _lame_set_maskingadjust_short($gfp, $125);
    var $127 = 5348912 + $2 * 52 | 0;
    var $128 = HEAPF32[$127 >> 2];
    var $129 = _lame_set_ATHlower($gfp, $128);
    var $130 = 5348916 + $2 * 52 | 0;
    var $131 = HEAPF32[$130 >> 2];
    var $132 = _lame_set_ATHcurve($gfp, $131);
    var $133 = 5348920 + $2 * 52 | 0;
    var $134 = HEAPF32[$133 >> 2];
    var $135 = _lame_set_interChRatio($gfp, $134);
    label = 30;
    break;
   case 28:
    var $137 = _lame_get_interChRatio($gfp);
    var $138 = $137 + 1;
    var $139 = $138 == 0;
    if ($139) {
      label = 29;
      break;
    } else {
      label = 30;
      break;
    }
   case 29:
    var $141 = 5348920 + $2 * 52 | 0;
    var $142 = HEAPF32[$141 >> 2];
    var $143 = _lame_set_interChRatio($gfp, $142);
    label = 30;
    break;
   case 30:
    var $145 = 5348876 + $2 * 52 | 0;
    var $146 = HEAP32[$145 >> 2];
    var $147 = $146 | 0;
    var $148 = $147 / 320;
    var $149 = $148 * 5;
    var $150 = $149;
    var $151 = $gfp + 288 | 0;
    var $152 = HEAP32[$151 >> 2];
    var $153 = $152 + 280 | 0;
    HEAPF32[$153 >> 2] = $150;
    return $preset;
  }
}
_apply_abr_preset["X"] = 1;
function _apply_vbr_preset($gfp, $a, $enforce) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = _lame_get_VBR($gfp);
    var $2 = _get_vbr_preset($1);
    var $3 = $gfp + 160 | 0;
    var $4 = HEAPF32[$3 >> 2];
    var $p_sroa_0_0__idx = $2 + $a * 68 | 0;
    var $p_sroa_0_0_copyload = HEAP32[$p_sroa_0_0__idx >> 2];
    var $p_sroa_1_4__idx112 = $2 + $a * 68 + 4 | 0;
    var $p_sroa_1_4_copyload = HEAP32[$p_sroa_1_4__idx112 >> 2];
    var $p_sroa_2_8__idx115 = $2 + $a * 68 + 8 | 0;
    var $p_sroa_2_8_copyload = HEAP32[$p_sroa_2_8__idx115 >> 2];
    var $p_sroa_3_12__idx118 = $2 + $a * 68 + 12 | 0;
    var $p_sroa_3_12_copyload = HEAP32[$p_sroa_3_12__idx118 >> 2];
    var $p_sroa_4_16__idx122 = $2 + $a * 68 + 16 | 0;
    var $p_sroa_4_16_copyload = HEAPF32[$p_sroa_4_16__idx122 >> 2];
    var $p_sroa_5_20__idx126 = $2 + $a * 68 + 20 | 0;
    var $p_sroa_5_20_copyload = HEAPF32[$p_sroa_5_20__idx126 >> 2];
    var $p_sroa_6_24__idx130 = $2 + $a * 68 + 24 | 0;
    var $p_sroa_6_24_copyload = HEAPF32[$p_sroa_6_24__idx130 >> 2];
    var $p_sroa_7_28__idx134 = $2 + $a * 68 + 28 | 0;
    var $p_sroa_7_28_copyload = HEAPF32[$p_sroa_7_28__idx134 >> 2];
    var $p_sroa_8_32__idx138 = $2 + $a * 68 + 32 | 0;
    var $p_sroa_8_32_copyload = HEAPF32[$p_sroa_8_32__idx138 >> 2];
    var $p_sroa_9_36__idx142 = $2 + $a * 68 + 36 | 0;
    var $p_sroa_9_36_copyload = HEAPF32[$p_sroa_9_36__idx142 >> 2];
    var $p_sroa_10_40__idx146 = $2 + $a * 68 + 40 | 0;
    var $p_sroa_10_40_copyload = HEAPF32[$p_sroa_10_40__idx146 >> 2];
    var $p_sroa_11_44__idx151 = $2 + $a * 68 + 44 | 0;
    var $p_sroa_11_44_copyload = HEAPF32[$p_sroa_11_44__idx151 >> 2];
    var $p_sroa_12_48__idx153 = $2 + $a * 68 + 48 | 0;
    var $p_sroa_12_48_copyload = HEAP32[$p_sroa_12_48__idx153 >> 2];
    var $p_sroa_13_52__idx157 = $2 + $a * 68 + 52 | 0;
    var $p_sroa_13_52_copyload = HEAP32[$p_sroa_13_52__idx157 >> 2];
    var $p_sroa_14_56__idx161 = $2 + $a * 68 + 56 | 0;
    var $p_sroa_14_56_copyload = HEAPF32[$p_sroa_14_56__idx161 >> 2];
    var $p_sroa_15_60__idx164 = $2 + $a * 68 + 60 | 0;
    var $p_sroa_15_60_copyload = HEAPF32[$p_sroa_15_60__idx164 >> 2];
    var $p_sroa_16_64__idx167 = $2 + $a * 68 + 64 | 0;
    var $p_sroa_16_64_copyload = HEAPF32[$p_sroa_16_64__idx167 >> 2];
    var $5 = $a + 1 | 0;
    var $q_sroa_1_16__idx32 = $2 + $5 * 68 + 16 | 0;
    var $q_sroa_1_16_copyload = HEAPF32[$q_sroa_1_16__idx32 >> 2];
    var $q_sroa_2_20__idx33 = $2 + $5 * 68 + 20 | 0;
    var $q_sroa_2_20_copyload = HEAPF32[$q_sroa_2_20__idx33 >> 2];
    var $q_sroa_3_24__idx34 = $2 + $5 * 68 + 24 | 0;
    var $q_sroa_3_24_copyload = HEAPF32[$q_sroa_3_24__idx34 >> 2];
    var $q_sroa_4_28__idx35 = $2 + $5 * 68 + 28 | 0;
    var $q_sroa_4_28_copyload = HEAPF32[$q_sroa_4_28__idx35 >> 2];
    var $q_sroa_5_32__idx36 = $2 + $5 * 68 + 32 | 0;
    var $q_sroa_5_32_copyload = HEAPF32[$q_sroa_5_32__idx36 >> 2];
    var $q_sroa_6_36__idx37 = $2 + $5 * 68 + 36 | 0;
    var $q_sroa_6_36_copyload = HEAPF32[$q_sroa_6_36__idx37 >> 2];
    var $q_sroa_7_40__idx38 = $2 + $5 * 68 + 40 | 0;
    var $q_sroa_7_40_copyload = HEAPF32[$q_sroa_7_40__idx38 >> 2];
    var $q_sroa_8_44__idx39 = $2 + $5 * 68 + 44 | 0;
    var $q_sroa_8_44_copyload = HEAPF32[$q_sroa_8_44__idx39 >> 2];
    var $q_sroa_10_52__idx41 = $2 + $5 * 68 + 52 | 0;
    var $q_sroa_10_52_copyload = HEAP32[$q_sroa_10_52__idx41 >> 2];
    var $q_sroa_11_56__idx42 = $2 + $5 * 68 + 56 | 0;
    var $q_sroa_11_56_copyload = HEAPF32[$q_sroa_11_56__idx42 >> 2];
    var $q_sroa_12_60__idx43 = $2 + $5 * 68 + 60 | 0;
    var $q_sroa_12_60_copyload = HEAPF32[$q_sroa_12_60__idx43 >> 2];
    var $q_sroa_13_64__idx44 = $2 + $5 * 68 + 64 | 0;
    var $q_sroa_13_64_copyload = HEAPF32[$q_sroa_13_64__idx44 >> 2];
    var $6 = $q_sroa_1_16_copyload - $p_sroa_4_16_copyload;
    var $7 = $4 * $6;
    var $8 = $p_sroa_4_16_copyload + $7;
    var $9 = $q_sroa_2_20_copyload - $p_sroa_5_20_copyload;
    var $10 = $4 * $9;
    var $11 = $p_sroa_5_20_copyload + $10;
    var $12 = $q_sroa_3_24_copyload - $p_sroa_6_24_copyload;
    var $13 = $4 * $12;
    var $14 = $p_sroa_6_24_copyload + $13;
    var $15 = $q_sroa_4_28_copyload - $p_sroa_7_28_copyload;
    var $16 = $4 * $15;
    var $17 = $p_sroa_7_28_copyload + $16;
    var $18 = $q_sroa_5_32_copyload - $p_sroa_8_32_copyload;
    var $19 = $4 * $18;
    var $20 = $p_sroa_8_32_copyload + $19;
    var $21 = $q_sroa_6_36_copyload - $p_sroa_9_36_copyload;
    var $22 = $4 * $21;
    var $23 = $p_sroa_9_36_copyload + $22;
    var $24 = $q_sroa_7_40_copyload - $p_sroa_10_40_copyload;
    var $25 = $4 * $24;
    var $26 = $p_sroa_10_40_copyload + $25;
    var $27 = $q_sroa_8_44_copyload - $p_sroa_11_44_copyload;
    var $28 = $4 * $27;
    var $29 = $p_sroa_11_44_copyload + $28;
    var $30 = $p_sroa_13_52_copyload | 0;
    var $31 = $q_sroa_10_52_copyload - $p_sroa_13_52_copyload | 0;
    var $32 = $31 | 0;
    var $33 = $4 * $32;
    var $34 = $30 + $33;
    var $35 = $34 & -1;
    var $36 = $q_sroa_11_56_copyload - $p_sroa_14_56_copyload;
    var $37 = $4 * $36;
    var $38 = $p_sroa_14_56_copyload + $37;
    var $39 = $q_sroa_12_60_copyload - $p_sroa_15_60_copyload;
    var $40 = $4 * $39;
    var $41 = $p_sroa_15_60_copyload + $40;
    var $42 = $q_sroa_13_64_copyload - $p_sroa_16_64_copyload;
    var $43 = $4 * $42;
    var $44 = $p_sroa_16_64_copyload + $43;
    var $45 = _lame_set_VBR_q($gfp, $p_sroa_0_0_copyload);
    var $46 = ($enforce | 0) != 0;
    if ($46) {
      label = 5;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $48 = _lame_get_quant_comp($gfp);
    var $49 = ($48 | 0) == -1;
    if ($49) {
      label = 4;
      break;
    } else {
      label = 6;
      break;
    }
   case 4:
    var $51 = _lame_set_quant_comp($gfp, $p_sroa_1_4_copyload);
    label = 6;
    break;
   case 5:
    var $53 = _lame_set_quant_comp($gfp, $p_sroa_1_4_copyload);
    var $54 = _lame_set_quant_comp_short($gfp, $p_sroa_2_8_copyload);
    label = 8;
    break;
   case 6:
    var $56 = _lame_get_quant_comp_short($gfp);
    var $57 = ($56 | 0) == -1;
    if ($57) {
      label = 7;
      break;
    } else {
      label = 8;
      break;
    }
   case 7:
    var $59 = _lame_set_quant_comp_short($gfp, $p_sroa_2_8_copyload);
    label = 8;
    break;
   case 8:
    var $61 = ($p_sroa_3_12_copyload | 0) == 0;
    if ($61) {
      label = 10;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    var $63 = _lame_set_experimentalY($gfp, $p_sroa_3_12_copyload);
    label = 10;
    break;
   case 10:
    if ($46) {
      label = 17;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    var $66 = _lame_get_short_threshold_lrm($gfp);
    var $67 = $66 + 1;
    var $68 = $67 == 0;
    if ($68) {
      label = 12;
      break;
    } else {
      label = 13;
      break;
    }
   case 12:
    var $70 = _lame_set_short_threshold_lrm($gfp, $8);
    label = 13;
    break;
   case 13:
    var $72 = _lame_get_short_threshold_s($gfp);
    var $73 = $72 + 1;
    var $74 = $73 == 0;
    if ($74) {
      label = 14;
      break;
    } else {
      label = 15;
      break;
    }
   case 14:
    var $76 = _lame_set_short_threshold_s($gfp, $11);
    label = 15;
    break;
   case 15:
    var $78 = _lame_get_maskingadjust($gfp);
    var $79 = $78 == 0;
    if ($79) {
      label = 16;
      break;
    } else {
      label = 18;
      break;
    }
   case 16:
    var $81 = _lame_set_maskingadjust($gfp, $14);
    label = 18;
    break;
   case 17:
    var $83 = _lame_set_short_threshold_lrm($gfp, $8);
    var $84 = _lame_set_short_threshold_s($gfp, $11);
    var $85 = _lame_set_maskingadjust($gfp, $14);
    var $86 = _lame_set_maskingadjust_short($gfp, $17);
    label = 20;
    break;
   case 18:
    var $88 = _lame_get_maskingadjust_short($gfp);
    var $89 = $88 == 0;
    if ($89) {
      label = 19;
      break;
    } else {
      label = 20;
      break;
    }
   case 19:
    var $91 = _lame_set_maskingadjust_short($gfp, $17);
    label = 20;
    break;
   case 20:
    var $93 = _lame_get_VBR($gfp);
    if (($93 | 0) == 1 | ($93 | 0) == 4) {
      label = 21;
      break;
    } else {
      label = 22;
      break;
    }
   case 21:
    var $95 = _lame_set_ATHtype($gfp, 5);
    label = 22;
    break;
   case 22:
    if ($46) {
      label = 27;
      break;
    } else {
      label = 23;
      break;
    }
   case 23:
    var $98 = _lame_get_ATHlower($gfp);
    var $99 = $98 == 0;
    if ($99) {
      label = 24;
      break;
    } else {
      label = 25;
      break;
    }
   case 24:
    var $101 = _lame_set_ATHlower($gfp, $20);
    label = 25;
    break;
   case 25:
    var $103 = _lame_get_ATHcurve($gfp);
    var $104 = $103 + 1;
    var $105 = $104 == 0;
    if ($105) {
      label = 26;
      break;
    } else {
      label = 28;
      break;
    }
   case 26:
    var $107 = _lame_set_ATHcurve($gfp, $23);
    label = 28;
    break;
   case 27:
    var $109 = _lame_set_ATHlower($gfp, $20);
    var $110 = _lame_set_ATHcurve($gfp, $23);
    var $111 = _lame_set_athaa_sensitivity($gfp, $26);
    label = 30;
    break;
   case 28:
    var $113 = _lame_get_athaa_sensitivity($gfp);
    var $114 = $113 == 0;
    if ($114) {
      label = 29;
      break;
    } else {
      label = 30;
      break;
    }
   case 29:
    var $116 = _lame_set_athaa_sensitivity($gfp, $26);
    label = 30;
    break;
   case 30:
    var $118 = $29 > 0;
    if ($118) {
      label = 31;
      break;
    } else {
      label = 35;
      break;
    }
   case 31:
    if ($46) {
      label = 32;
      break;
    } else {
      label = 33;
      break;
    }
   case 32:
    var $121 = _lame_set_interChRatio($gfp, $29);
    label = 35;
    break;
   case 33:
    var $123 = _lame_get_interChRatio($gfp);
    var $124 = $123 + 1;
    var $125 = $124 == 0;
    if ($125) {
      label = 34;
      break;
    } else {
      label = 35;
      break;
    }
   case 34:
    var $127 = _lame_set_interChRatio($gfp, $29);
    label = 35;
    break;
   case 35:
    var $129 = ($p_sroa_12_48_copyload | 0) > 0;
    if ($129) {
      label = 36;
      break;
    } else {
      label = 37;
      break;
    }
   case 36:
    var $131 = _lame_get_exp_nspsytune($gfp);
    var $132 = $131 | 2;
    var $133 = _lame_set_exp_nspsytune($gfp, $132);
    label = 37;
    break;
   case 37:
    var $135 = ($35 | 0) > 0;
    if ($135) {
      label = 38;
      break;
    } else {
      label = 40;
      break;
    }
   case 38:
    var $137 = _lame_get_exp_nspsytune($gfp);
    var $138 = $137 & 66060288;
    var $139 = ($138 | 0) == 0;
    if ($139) {
      label = 39;
      break;
    } else {
      label = 40;
      break;
    }
   case 39:
    var $141 = $35 << 20;
    var $142 = $137 | $141;
    var $143 = _lame_set_exp_nspsytune($gfp, $142);
    label = 40;
    break;
   case 40:
    if ($46) {
      label = 43;
      break;
    } else {
      label = 41;
      break;
    }
   case 41:
    var $146 = _lame_get_msfix($gfp);
    var $147 = $146 + 1;
    var $148 = $147 == 0;
    if ($148) {
      label = 42;
      break;
    } else {
      label = 44;
      break;
    }
   case 42:
    var $150 = $38;
    _lame_set_msfix($gfp, $150);
    label = 44;
    break;
   case 43:
    var $152 = $38;
    _lame_set_msfix($gfp, $152);
    label = 45;
    break;
   case 44:
    var $154 = $gfp + 164 | 0;
    HEAP32[$154 >> 2] = $a;
    HEAPF32[$3 >> 2] = $4;
    label = 45;
    break;
   case 45:
    var $156 = $gfp + 288 | 0;
    var $157 = HEAP32[$156 >> 2];
    var $158 = $157 + 280 | 0;
    HEAPF32[$158 >> 2] = $41;
    var $159 = HEAP32[$156 >> 2];
    var $160 = $159 + 224 | 0;
    HEAPF32[$160 >> 2] = $44;
    return;
  }
}
_apply_vbr_preset["X"] = 1;
function _L3psycho_anal_vbr($gfc, $buffer, $gr_out, $masking_ratio, $masking_MS_ratio, $percep_entropy, $percep_MS_entropy, $energy, $blocktype_d) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 21092 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $last_thm = __stackBase__;
    var $fftenergy = __stackBase__ + 976;
    var $fftenergy_s = __stackBase__ + 3028;
    var $wsamp_L = __stackBase__ + 4576;
    var $wsamp_S = __stackBase__ + 12768;
    var $eb = __stackBase__ + 18912;
    var $thr = __stackBase__ + 19936;
    var $sub_short_factor = __stackBase__ + 20960;
    var $ns_attacks = __stackBase__ + 21008;
    var $uselongblock = __stackBase__ + 21072;
    var $new_thmm = __stackBase__ + 21080;
    var $new_thmm209 = $new_thmm;
    var $1 = $gfc + 16 | 0;
    var $2 = $gfc + 21564 | 0;
    var $3 = $gfc + 85796 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = $gfc + 140 | 0;
    var $6 = HEAP32[$5 >> 2];
    var $7 = ($6 | 0) == 0;
    if ($7) {
      var $12 = 0;
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $9 = $gfc + 85800 | 0;
    var $10 = HEAP32[$9 >> 2];
    var $12 = $10;
    label = 4;
    break;
   case 4:
    var $12;
    var $13 = $gfc + 192 | 0;
    var $14 = HEAPF32[$13 >> 2];
    var $15 = $14 > 0;
    if ($15) {
      label = 5;
      break;
    } else {
      var $25 = 1;
      label = 6;
      break;
    }
   case 5:
    var $17 = $gfc + 200 | 0;
    var $18 = HEAPF32[$17 >> 2];
    var $19 = $gfc + 85792 | 0;
    var $20 = HEAP32[$19 >> 2];
    var $21 = $20 + 8 | 0;
    var $22 = HEAPF32[$21 >> 2];
    var $23 = $18 * $22;
    var $25 = $23;
    label = 6;
    break;
   case 6:
    var $25;
    var $26 = $eb | 0;
    var $27 = $fftenergy_s | 0;
    var $28 = $ns_attacks;
    for (var $$dest = $28 >> 2, $$stop = $$dest + 16; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $29 = $gfc + 180 | 0;
    var $30 = HEAP32[$29 >> 2];
    var $31 = ($30 | 0) == 1;
    if ($31) {
      var $36 = 4;
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    var $33 = $gfc + 72 | 0;
    var $34 = HEAP32[$33 >> 2];
    var $36 = $34;
    label = 8;
    break;
   case 8:
    var $36;
    var $37 = $last_thm;
    var $38 = $gfc + 25660 | 0;
    var $39 = $38;
    for (var $$src = $39 >> 2, $$dest = $37 >> 2, $$stop = $$src + 244; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    var $40 = $sub_short_factor | 0;
    var $41 = $ns_attacks | 0;
    var $42 = $uselongblock | 0;
    _vbrpsy_attack_detection($gfc, $buffer, $gr_out, $masking_ratio, $masking_MS_ratio, $energy, $40, $41, $42);
    _vbrpsy_compute_block_type($1, $42);
    var $43 = ($36 | 0) > 0;
    if ($43) {
      label = 9;
      break;
    } else {
      label = 11;
      break;
    }
   case 9:
    var $44 = $fftenergy | 0;
    var $chn_0201 = 0;
    label = 10;
    break;
   case 10:
    var $chn_0201;
    var $46 = $chn_0201 & 1;
    var $47 = $wsamp_L + ($46 << 12) | 0;
    _vbrpsy_compute_fft_l($gfc, $buffer, $chn_0201, $gr_out, $44, $47);
    _vbrpsy_compute_loudness_approximation_l($gfc, $gr_out, $chn_0201, $44);
    var $48 = $eb + ($chn_0201 << 8) | 0;
    var $49 = $thr + ($chn_0201 << 8) | 0;
    _vbrpsy_compute_masking_l($gfc, $44, $48, $49, $chn_0201);
    var $50 = $chn_0201 + 1 | 0;
    var $exitcond216 = ($50 | 0) == ($36 | 0);
    if ($exitcond216) {
      label = 11;
      break;
    } else {
      var $chn_0201 = $50;
      label = 10;
      break;
    }
   case 11:
    var $51 = HEAP32[$29 >> 2];
    var $52 = ($51 | 0) == 1;
    if ($52) {
      label = 12;
      break;
    } else {
      label = 14;
      break;
    }
   case 12:
    var $54 = HEAP32[$42 >> 2];
    var $55 = $uselongblock + 4 | 0;
    var $56 = HEAP32[$55 >> 2];
    var $57 = $56 + $54 | 0;
    var $58 = ($57 | 0) == 2;
    if ($58) {
      label = 13;
      break;
    } else {
      label = 14;
      break;
    }
   case 13:
    var $60 = $thr | 0;
    var $61 = $4 + 768 | 0;
    var $62 = $gfc + 85792 | 0;
    var $63 = HEAP32[$62 >> 2];
    var $64 = $63 + 212 | 0;
    var $65 = HEAPF32[$13 >> 2];
    var $66 = $4 + 2148 | 0;
    var $67 = HEAP32[$66 >> 2];
    _vbrpsy_compute_MS_thresholds($26, $60, $61, $64, $25, $65, $67);
    label = 14;
    break;
   case 14:
    var $68 = ($36 | 0) > 0;
    if ($68) {
      var $chn_1198 = 0;
      label = 15;
      break;
    } else {
      label = 16;
      break;
    }
   case 15:
    var $chn_1198;
    var $69 = $eb + ($chn_1198 << 8) | 0;
    var $70 = $thr + ($chn_1198 << 8) | 0;
    _convert_partition2scalefac_l($gfc, $69, $70, $chn_1198);
    _convert_partition2scalefac_l_to_s($gfc, $69, $70, $chn_1198);
    var $71 = $chn_1198 + 1 | 0;
    var $exitcond215 = ($71 | 0) == ($36 | 0);
    if ($exitcond215) {
      label = 16;
      break;
    } else {
      var $chn_1198 = $71;
      label = 15;
      break;
    }
   case 16:
    var $72 = HEAP32[$3 >> 2];
    var $73 = $72 + 6500 | 0;
    var $74 = HEAP32[$73 >> 2];
    var $75 = ($36 | 0) > 0;
    var $76 = HEAP32[$42 >> 2];
    var $77 = $uselongblock + 4 | 0;
    var $78 = HEAP32[$77 >> 2];
    var $79 = -$78 | 0;
    var $80 = $thr | 0;
    var $81 = $4 + 2928 | 0;
    var $82 = $gfc + 85792 | 0;
    var $83 = $4 + 4308 | 0;
    var $84 = ($36 | 0) > 0;
    var $85 = ($74 | 0) == 0;
    var $86 = ($74 | 0) == 0;
    var $sblock_0196 = 0;
    label = 17;
    break;
   case 17:
    var $sblock_0196;
    if ($75) {
      var $chn_2189 = 0;
      label = 20;
      break;
    } else {
      label = 24;
      break;
    }
   case 18:
    var $87 = ($36 | 0) > 0;
    if ($87) {
      label = 19;
      break;
    } else {
      label = 54;
      break;
    }
   case 19:
    var $88 = $new_thmm | 0;
    var $chn_4187 = 0;
    label = 31;
    break;
   case 20:
    var $chn_2189;
    var $89 = $chn_2189 & 1;
    var $90 = $uselongblock + ($89 << 2) | 0;
    var $91 = HEAP32[$90 >> 2];
    var $92 = ($91 | 0) != 0;
    var $or_cond = $92 & $86;
    if ($or_cond) {
      label = 21;
      break;
    } else {
      label = 22;
      break;
    }
   case 21:
    _vbrpsy_skip_masking_s($gfc, $chn_2189, $sblock_0196);
    label = 23;
    break;
   case 22:
    var $95 = $wsamp_S + $89 * 3072 | 0;
    _vbrpsy_compute_fft_s($gfc, $buffer, $chn_2189, $sblock_0196, $27, $95);
    var $96 = $eb + ($chn_2189 << 8) | 0;
    var $97 = $thr + ($chn_2189 << 8) | 0;
    _vbrpsy_compute_masking_s($gfc, $27, $96, $97, $chn_2189, $sblock_0196);
    label = 23;
    break;
   case 23:
    var $99 = $chn_2189 + 1 | 0;
    var $exitcond212 = ($99 | 0) == ($36 | 0);
    if ($exitcond212) {
      label = 24;
      break;
    } else {
      var $chn_2189 = $99;
      label = 20;
      break;
    }
   case 24:
    var $100 = HEAP32[$29 >> 2];
    var $_not = ($100 | 0) != 1;
    var $_not217 = ($76 | 0) != ($79 | 0);
    var $brmerge = $_not | $_not217;
    if ($brmerge) {
      label = 26;
      break;
    } else {
      label = 25;
      break;
    }
   case 25:
    var $102 = HEAP32[$82 >> 2];
    var $103 = $102 + 468 | 0;
    var $104 = HEAPF32[$13 >> 2];
    var $105 = HEAP32[$83 >> 2];
    _vbrpsy_compute_MS_thresholds($26, $80, $81, $103, $25, $104, $105);
    label = 26;
    break;
   case 26:
    if ($84) {
      var $chn_3193 = 0;
      label = 27;
      break;
    } else {
      label = 30;
      break;
    }
   case 27:
    var $chn_3193;
    var $106 = $chn_3193 & 1;
    var $107 = $uselongblock + ($106 << 2) | 0;
    var $108 = HEAP32[$107 >> 2];
    var $109 = ($108 | 0) != 0;
    var $or_cond172 = $109 & $85;
    if ($or_cond172) {
      label = 29;
      break;
    } else {
      label = 28;
      break;
    }
   case 28:
    var $111 = $eb + ($chn_3193 << 8) | 0;
    var $112 = $thr + ($chn_3193 << 8) | 0;
    _convert_partition2scalefac_s($gfc, $111, $112, $chn_3193, $sblock_0196);
    label = 29;
    break;
   case 29:
    var $114 = $chn_3193 + 1 | 0;
    var $exitcond213 = ($114 | 0) == ($36 | 0);
    if ($exitcond213) {
      label = 30;
      break;
    } else {
      var $chn_3193 = $114;
      label = 27;
      break;
    }
   case 30:
    var $115 = $sblock_0196 + 1 | 0;
    var $exitcond214 = ($115 | 0) == 3;
    if ($exitcond214) {
      label = 18;
      break;
    } else {
      var $sblock_0196 = $115;
      label = 17;
      break;
    }
   case 31:
    var $chn_4187;
    var $116 = $gfc + 27780 + ($chn_4187 << 2) | 0;
    var $sb_0185 = 0;
    label = 33;
    break;
   case 32:
    var $117 = ($36 | 0) > 0;
    if ($117) {
      var $chn_5175 = 0;
      label = 53;
      break;
    } else {
      label = 54;
      break;
    }
   case 33:
    var $sb_0185;
    var $scevgep = $gfc + 25660 + $chn_4187 * 244 + 88 + $sb_0185 * 12 | 0;
    var $scevgep208 = $scevgep;
    var $118 = $last_thm + $chn_4187 * 244 + 88 + $sb_0185 * 12 + 4 | 0;
    var $119 = $last_thm + $chn_4187 * 244 + 88 + $sb_0185 * 12 + 8 | 0;
    var $120 = $last_thm + $chn_4187 * 244 + 88 + $sb_0185 * 12 + 8 | 0;
    var $sblock_1179 = 0;
    label = 34;
    break;
   case 34:
    var $sblock_1179;
    var $122 = $gfc + 25660 + $chn_4187 * 244 + 88 + $sb_0185 * 12 + ($sblock_1179 << 2) | 0;
    var $123 = HEAPF32[$122 >> 2];
    var $124 = $123;
    var $125 = $124 * .8;
    var $126 = $125;
    var $127 = ($sblock_1179 | 0) > 0;
    if ($127) {
      label = 35;
      break;
    } else {
      var $prev_thm_0_in = $120;
      label = 36;
      break;
    }
   case 35:
    var $129 = $sblock_1179 - 1 | 0;
    var $130 = $new_thmm + ($129 << 2) | 0;
    var $prev_thm_0_in = $130;
    label = 36;
    break;
   case 36:
    var $prev_thm_0_in;
    var $prev_thm_0 = HEAPF32[$prev_thm_0_in >> 2];
    var $132 = $ns_attacks + ($chn_4187 << 4) + ($sblock_1179 << 2) | 0;
    var $133 = HEAP32[$132 >> 2];
    var $134 = ($133 | 0) > 1;
    if ($134) {
      label = 38;
      break;
    } else {
      label = 37;
      break;
    }
   case 37:
    var $136 = $sblock_1179 + 1 | 0;
    var $137 = $ns_attacks + ($chn_4187 << 4) + ($136 << 2) | 0;
    var $138 = HEAP32[$137 >> 2];
    var $139 = ($138 | 0) == 1;
    if ($139) {
      label = 38;
      break;
    } else {
      var $t1_0 = $126;
      label = 39;
      break;
    }
   case 38:
    var $141 = _NS_INTERP($prev_thm_0, $126, .36000001430511475);
    var $t1_0 = $141;
    label = 39;
    break;
   case 39:
    var $t1_0;
    var $143 = $t1_0 < $126;
    var $144 = $143 ? $t1_0 : $126;
    var $145 = HEAP32[$132 >> 2];
    var $146 = ($145 | 0) == 1;
    if ($146) {
      label = 40;
      break;
    } else {
      label = 41;
      break;
    }
   case 40:
    var $148 = _NS_INTERP($prev_thm_0, $144, .18000000715255737);
    var $t2_0 = $148;
    label = 50;
    break;
   case 41:
    var $150 = ($sblock_1179 | 0) == 0;
    if ($150) {
      label = 42;
      break;
    } else {
      label = 43;
      break;
    }
   case 42:
    var $152 = HEAP32[$116 >> 2];
    var $153 = ($152 | 0) == 3;
    if ($153) {
      label = 46;
      break;
    } else {
      label = 43;
      break;
    }
   case 43:
    if ($127) {
      label = 44;
      break;
    } else {
      var $t2_0 = $126;
      label = 50;
      break;
    }
   case 44:
    var $156 = $sblock_1179 - 1 | 0;
    var $157 = $ns_attacks + ($chn_4187 << 4) + ($156 << 2) | 0;
    var $158 = HEAP32[$157 >> 2];
    var $159 = ($158 | 0) == 3;
    if ($159) {
      label = 45;
      break;
    } else {
      var $t2_0 = $126;
      label = 50;
      break;
    }
   case 45:
    if (($sblock_1179 | 0) == 0) {
      label = 46;
      break;
    } else if (($sblock_1179 | 0) == 1) {
      label = 47;
      break;
    } else if (($sblock_1179 | 0) == 2) {
      label = 48;
      break;
    } else {
      var $prev_thm_1 = $prev_thm_0;
      label = 49;
      break;
    }
   case 46:
    var $161 = HEAPF32[$118 >> 2];
    var $prev_thm_1 = $161;
    label = 49;
    break;
   case 47:
    var $163 = HEAPF32[$119 >> 2];
    var $prev_thm_1 = $163;
    label = 49;
    break;
   case 48:
    var $165 = HEAPF32[$88 >> 2];
    var $prev_thm_1 = $165;
    label = 49;
    break;
   case 49:
    var $prev_thm_1;
    var $167 = _NS_INTERP($prev_thm_1, $144, .18000000715255737);
    var $t2_0 = $167;
    label = 50;
    break;
   case 50:
    var $t2_0;
    var $169 = $t2_0 < $144;
    var $170 = $169 ? $t2_0 : $144;
    var $171 = $sub_short_factor + $chn_4187 * 12 + ($sblock_1179 << 2) | 0;
    var $172 = HEAPF32[$171 >> 2];
    var $173 = $172 * $170;
    var $174 = $new_thmm + ($sblock_1179 << 2) | 0;
    HEAPF32[$174 >> 2] = $173;
    var $175 = $sblock_1179 + 1 | 0;
    var $exitcond206 = ($175 | 0) == 3;
    if ($exitcond206) {
      label = 51;
      break;
    } else {
      var $sblock_1179 = $175;
      label = 34;
      break;
    }
   case 51:
    HEAP32[$scevgep208 >> 2] = HEAP32[$new_thmm209 >> 2];
    HEAP32[$scevgep208 + 4 >> 2] = HEAP32[$new_thmm209 + 4 >> 2];
    HEAP32[$scevgep208 + 8 >> 2] = HEAP32[$new_thmm209 + 8 >> 2];
    var $177 = $sb_0185 + 1 | 0;
    var $exitcond210 = ($177 | 0) == 13;
    if ($exitcond210) {
      label = 52;
      break;
    } else {
      var $sb_0185 = $177;
      label = 33;
      break;
    }
   case 52:
    var $179 = $chn_4187 + 1 | 0;
    var $exitcond211 = ($179 | 0) == ($36 | 0);
    if ($exitcond211) {
      label = 32;
      break;
    } else {
      var $chn_4187 = $179;
      label = 31;
      break;
    }
   case 53:
    var $chn_5175;
    var $180 = $ns_attacks + ($chn_5175 << 4) + 8 | 0;
    var $181 = HEAP32[$180 >> 2];
    var $182 = $gfc + 27780 + ($chn_5175 << 2) | 0;
    HEAP32[$182 >> 2] = $181;
    var $183 = $chn_5175 + 1 | 0;
    var $exitcond205 = ($183 | 0) == ($36 | 0);
    if ($exitcond205) {
      label = 54;
      break;
    } else {
      var $chn_5175 = $183;
      label = 53;
      break;
    }
   case 54:
    var $184 = $gfc + 72 | 0;
    var $185 = HEAP32[$184 >> 2];
    _vbrpsy_apply_block_type($2, $185, $42, $blocktype_d);
    var $186 = ($36 | 0) > 0;
    if ($186) {
      label = 55;
      break;
    } else {
      label = 68;
      break;
    }
   case 55:
    var $187 = $percep_MS_entropy - 8 | 0;
    var $188 = $blocktype_d + 4 | 0;
    var $189 = $gfc + 84904 | 0;
    var $190 = ($12 | 0) == 0;
    var $chn_6173 = 0;
    label = 56;
    break;
   case 56:
    var $chn_6173;
    var $192 = ($chn_6173 | 0) > 1;
    if ($192) {
      label = 57;
      break;
    } else {
      label = 61;
      break;
    }
   case 57:
    var $194 = HEAP32[$blocktype_d >> 2];
    var $195 = ($194 | 0) == 2;
    if ($195) {
      label = 59;
      break;
    } else {
      label = 58;
      break;
    }
   case 58:
    var $197 = HEAP32[$188 >> 2];
    var $198 = ($197 | 0) == 2;
    if ($198) {
      label = 59;
      break;
    } else {
      var $type_0 = 0;
      label = 60;
      break;
    }
   case 59:
    var $type_0 = 2;
    label = 60;
    break;
   case 60:
    var $type_0;
    var $201 = $chn_6173 - 2 | 0;
    var $202 = $masking_MS_ratio + $gr_out * 976 + $201 * 488 | 0;
    var $mr_0 = $202;
    var $type_1 = $type_0;
    var $ppe_0 = $187;
    label = 62;
    break;
   case 61:
    var $204 = $blocktype_d + ($chn_6173 << 2) | 0;
    var $205 = HEAP32[$204 >> 2];
    var $206 = $masking_ratio + $gr_out * 976 + $chn_6173 * 488 | 0;
    var $mr_0 = $206;
    var $type_1 = $205;
    var $ppe_0 = $percep_entropy;
    label = 62;
    break;
   case 62:
    var $ppe_0;
    var $type_1;
    var $mr_0;
    var $208 = ($type_1 | 0) == 2;
    var $209 = HEAPF32[$189 >> 2];
    if ($208) {
      label = 63;
      break;
    } else {
      label = 64;
      break;
    }
   case 63:
    var $211 = _pecalc_s($mr_0, $209);
    var $212 = $ppe_0 + ($chn_6173 << 2) | 0;
    HEAPF32[$212 >> 2] = $211;
    label = 65;
    break;
   case 64:
    var $214 = _pecalc_l($mr_0, $209);
    var $215 = $ppe_0 + ($chn_6173 << 2) | 0;
    HEAPF32[$215 >> 2] = $214;
    label = 65;
    break;
   case 65:
    if ($190) {
      label = 67;
      break;
    } else {
      label = 66;
      break;
    }
   case 66:
    var $218 = $ppe_0 + ($chn_6173 << 2) | 0;
    var $219 = HEAPF32[$218 >> 2];
    var $220 = $219;
    var $221 = $12 + 189236 + ($gr_out << 5) + ($chn_6173 << 3) | 0;
    HEAPF64[tempDoublePtr >> 3] = $220, HEAP32[$221 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$221 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    label = 67;
    break;
   case 67:
    var $223 = $chn_6173 + 1 | 0;
    var $exitcond = ($223 | 0) == ($36 | 0);
    if ($exitcond) {
      label = 68;
      break;
    } else {
      var $chn_6173 = $223;
      label = 56;
      break;
    }
   case 68:
    STACKTOP = __stackBase__;
    return 0;
  }
}
_L3psycho_anal_vbr["X"] = 1;
function _vbrpsy_compute_block_type($cfg, $uselongblock) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $cfg + 168 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($2 | 0) == 1;
    if ($3) {
      label = 3;
      break;
    } else {
      label = 6;
      break;
    }
   case 3:
    var $5 = HEAP32[$uselongblock >> 2];
    var $6 = ($5 | 0) == 0;
    if ($6) {
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $8 = $uselongblock + 4 | 0;
    var $9 = HEAP32[$8 >> 2];
    var $10 = ($9 | 0) == 0;
    if ($10) {
      label = 5;
      break;
    } else {
      label = 6;
      break;
    }
   case 5:
    var $12 = $uselongblock + 4 | 0;
    HEAP32[$12 >> 2] = 0;
    HEAP32[$uselongblock >> 2] = 0;
    label = 6;
    break;
   case 6:
    var $13 = $cfg + 56 | 0;
    var $14 = HEAP32[$13 >> 2];
    var $15 = ($14 | 0) > 0;
    if ($15) {
      var $chn_013 = 0;
      label = 7;
      break;
    } else {
      label = 12;
      break;
    }
   case 7:
    var $chn_013;
    var $16 = HEAP32[$1 >> 2];
    var $17 = ($16 | 0) == 2;
    if ($17) {
      label = 8;
      break;
    } else {
      var $21 = $16;
      label = 9;
      break;
    }
   case 8:
    var $19 = $uselongblock + ($chn_013 << 2) | 0;
    HEAP32[$19 >> 2] = 1;
    var $_pr = HEAP32[$1 >> 2];
    var $21 = $_pr;
    label = 9;
    break;
   case 9:
    var $21;
    var $22 = ($21 | 0) == 3;
    if ($22) {
      label = 10;
      break;
    } else {
      label = 11;
      break;
    }
   case 10:
    var $24 = $uselongblock + ($chn_013 << 2) | 0;
    HEAP32[$24 >> 2] = 0;
    label = 11;
    break;
   case 11:
    var $26 = $chn_013 + 1 | 0;
    var $27 = HEAP32[$13 >> 2];
    var $28 = ($26 | 0) < ($27 | 0);
    if ($28) {
      var $chn_013 = $26;
      label = 7;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    return;
  }
}
function _vbrpsy_attack_detection($gfc, $buffer, $gr_out, $masking_ratio, $masking_MS_ratio, $energy, $sub_short_factor, $ns_attacks, $uselongblock) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 4720 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $ns_hpfsmpl = __stackBase__;
    var $attack_intensity = __stackBase__ + 4608;
    var $en_subshort = __stackBase__ + 4656;
    var $en_short = __stackBase__ + 4704;
    var $1 = $gfc + 140 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($2 | 0) == 0;
    if ($3) {
      var $8 = 0;
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $5 = $gfc + 85800 | 0;
    var $6 = HEAP32[$5 >> 2];
    var $8 = $6;
    label = 4;
    break;
   case 4:
    var $8;
    var $9 = $gfc + 72 | 0;
    var $10 = HEAP32[$9 >> 2];
    var $11 = $gfc + 180 | 0;
    var $12 = HEAP32[$11 >> 2];
    var $13 = ($12 | 0) == 1;
    var $14 = $13 ? 4 : $10;
    var $15 = $ns_hpfsmpl;
    for (var $$dest = $15 >> 2, $$stop = $$dest + 1152; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $16 = ($10 | 0) > 0;
    if ($16) {
      label = 5;
      break;
    } else {
      label = 6;
      break;
    }
   case 5:
    var $17 = ($14 | 0) > 2;
    var $chn_0231 = 0;
    label = 8;
    break;
   case 6:
    var $18 = ($14 | 0) > 0;
    if ($18) {
      label = 7;
      break;
    } else {
      label = 55;
      break;
    }
   case 7:
    var $19 = $en_short;
    var $20 = $en_short | 0;
    var $21 = ($8 | 0) == 0;
    var $22 = $gfc + 85796 | 0;
    var $23 = $uselongblock + 4 | 0;
    var $24 = $attack_intensity | 0;
    var $chn_1223 = 0;
    label = 13;
    break;
   case 8:
    var $chn_0231;
    var $26 = $buffer + ($chn_0231 << 2) | 0;
    var $27 = HEAP32[$26 >> 2];
    var $i_0230 = 0;
    label = 9;
    break;
   case 9:
    var $i_0230;
    var $_sum = $i_0230 + 407 | 0;
    var $29 = $27 + ($_sum << 2) | 0;
    var $30 = HEAPF32[$29 >> 2];
    var $_sum198 = $i_0230 + 397 | 0;
    var $31 = $27 + ($_sum198 << 2) | 0;
    var $32 = HEAPF32[$31 >> 2];
    var $_sum199 = $i_0230 + 418 | 0;
    var $33 = $27 + ($_sum199 << 2) | 0;
    var $34 = HEAPF32[$33 >> 2];
    var $35 = $32 + $34;
    var $36 = $35 * -1.7303260184043527e-17;
    var $37 = $30 + $36;
    var $_sum200 = $i_0230 + 398 | 0;
    var $38 = $27 + ($_sum200 << 2) | 0;
    var $39 = HEAPF32[$38 >> 2];
    var $_sum201 = $i_0230 + 417 | 0;
    var $40 = $27 + ($_sum201 << 2) | 0;
    var $41 = HEAPF32[$40 >> 2];
    var $42 = $39 + $41;
    var $43 = $42 * -.017031719908118248;
    var $44 = $43;
    var $_sum198_1 = $i_0230 + 399 | 0;
    var $45 = $27 + ($_sum198_1 << 2) | 0;
    var $46 = HEAPF32[$45 >> 2];
    var $_sum199_1 = $i_0230 + 416 | 0;
    var $47 = $27 + ($_sum199_1 << 2) | 0;
    var $48 = HEAPF32[$47 >> 2];
    var $49 = $46 + $48;
    var $50 = $49 * -1.3495279640235235e-17;
    var $51 = $37 + $50;
    var $_sum200_1 = $i_0230 + 400 | 0;
    var $52 = $27 + ($_sum200_1 << 2) | 0;
    var $53 = HEAPF32[$52 >> 2];
    var $_sum201_1 = $i_0230 + 415 | 0;
    var $54 = $27 + ($_sum201_1 << 2) | 0;
    var $55 = HEAPF32[$54 >> 2];
    var $56 = $53 + $55;
    var $57 = $56 * .04180720075964928;
    var $58 = $44 + $57;
    var $_sum198_2 = $i_0230 + 401 | 0;
    var $59 = $27 + ($_sum198_2 << 2) | 0;
    var $60 = HEAPF32[$59 >> 2];
    var $_sum199_2 = $i_0230 + 414 | 0;
    var $61 = $27 + ($_sum199_2 << 2) | 0;
    var $62 = HEAPF32[$61 >> 2];
    var $63 = $60 + $62;
    var $64 = $63 * -6.732779685849225e-17;
    var $65 = $51 + $64;
    var $_sum200_2 = $i_0230 + 402 | 0;
    var $66 = $27 + ($_sum200_2 << 2) | 0;
    var $67 = HEAPF32[$66 >> 2];
    var $_sum201_2 = $i_0230 + 413 | 0;
    var $68 = $27 + ($_sum201_2 << 2) | 0;
    var $69 = HEAPF32[$68 >> 2];
    var $70 = $67 + $69;
    var $71 = $70 * -.08763240277767181;
    var $72 = $58 + $71;
    var $_sum198_3 = $i_0230 + 403 | 0;
    var $73 = $27 + ($_sum198_3 << 2) | 0;
    var $74 = HEAPF32[$73 >> 2];
    var $_sum199_3 = $i_0230 + 412 | 0;
    var $75 = $27 + ($_sum199_3 << 2) | 0;
    var $76 = HEAPF32[$75 >> 2];
    var $77 = $74 + $76;
    var $78 = $77 * -3.0835000291318875e-17;
    var $79 = $65 + $78;
    var $_sum200_3 = $i_0230 + 404 | 0;
    var $80 = $27 + ($_sum200_3 << 2) | 0;
    var $81 = HEAPF32[$80 >> 2];
    var $_sum201_3 = $i_0230 + 411 | 0;
    var $82 = $27 + ($_sum201_3 << 2) | 0;
    var $83 = HEAPF32[$82 >> 2];
    var $84 = $81 + $83;
    var $85 = $84 * .1863476037979126;
    var $86 = $72 + $85;
    var $_sum198_4 = $i_0230 + 405 | 0;
    var $87 = $27 + ($_sum198_4 << 2) | 0;
    var $88 = HEAPF32[$87 >> 2];
    var $_sum199_4 = $i_0230 + 410 | 0;
    var $89 = $27 + ($_sum199_4 << 2) | 0;
    var $90 = HEAPF32[$89 >> 2];
    var $91 = $88 + $90;
    var $92 = $91 * -1.1044240253100168e-16;
    var $93 = $79 + $92;
    var $_sum200_4 = $i_0230 + 406 | 0;
    var $94 = $27 + ($_sum200_4 << 2) | 0;
    var $95 = HEAPF32[$94 >> 2];
    var $_sum201_4 = $i_0230 + 409 | 0;
    var $96 = $27 + ($_sum201_4 << 2) | 0;
    var $97 = HEAPF32[$96 >> 2];
    var $98 = $95 + $97;
    var $99 = $98 * -.6276379823684692;
    var $100 = $86 + $99;
    var $101 = $100 + $93;
    var $102 = $ns_hpfsmpl + $chn_0231 * 2304 + ($i_0230 << 2) | 0;
    HEAPF32[$102 >> 2] = $101;
    var $103 = $i_0230 + 1 | 0;
    var $exitcond245 = ($103 | 0) == 576;
    if ($exitcond245) {
      label = 10;
      break;
    } else {
      var $i_0230 = $103;
      label = 9;
      break;
    }
   case 10:
    var $105 = $masking_ratio + $gr_out * 976 + $chn_0231 * 488 + 244 | 0;
    var $106 = $gfc + 26636 + $chn_0231 * 244 | 0;
    var $107 = $105;
    var $108 = $106;
    for (var $$src = $108 >> 2, $$dest = $107 >> 2, $$stop = $$src + 61; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    var $109 = $masking_ratio + $gr_out * 976 + $chn_0231 * 488 | 0;
    var $110 = $gfc + 25660 + $chn_0231 * 244 | 0;
    var $111 = $109;
    var $112 = $110;
    for (var $$src = $112 >> 2, $$dest = $111 >> 2, $$stop = $$src + 61; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    if ($17) {
      label = 11;
      break;
    } else {
      label = 12;
      break;
    }
   case 11:
    var $114 = $masking_MS_ratio + $gr_out * 976 + $chn_0231 * 488 + 244 | 0;
    var $115 = $chn_0231 + 2 | 0;
    var $116 = $gfc + 26636 + $115 * 244 | 0;
    var $117 = $114;
    var $118 = $116;
    for (var $$src = $118 >> 2, $$dest = $117 >> 2, $$stop = $$src + 61; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    var $119 = $masking_MS_ratio + $gr_out * 976 + $chn_0231 * 488 | 0;
    var $120 = $gfc + 25660 + $115 * 244 | 0;
    var $121 = $119;
    var $122 = $120;
    for (var $$src = $122 >> 2, $$dest = $121 >> 2, $$stop = $$src + 61; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    label = 12;
    break;
   case 12:
    var $124 = $chn_0231 + 1 | 0;
    var $exitcond246 = ($124 | 0) == ($10 | 0);
    if ($exitcond246) {
      label = 6;
      break;
    } else {
      var $chn_0231 = $124;
      label = 8;
      break;
    }
   case 13:
    var $chn_1223;
    HEAP32[$19 >> 2] = 0;
    HEAP32[$19 + 4 >> 2] = 0;
    HEAP32[$19 + 8 >> 2] = 0;
    HEAP32[$19 + 12 >> 2] = 0;
    var $126 = $chn_1223 & 1;
    var $127 = $ns_hpfsmpl + $126 * 2304 | 0;
    var $128 = ($chn_1223 | 0) == 2;
    if ($128) {
      var $i_1206 = 0;
      label = 14;
      break;
    } else {
      label = 15;
      break;
    }
   case 14:
    var $i_1206;
    var $129 = $ns_hpfsmpl + ($i_1206 << 2) | 0;
    var $130 = HEAPF32[$129 >> 2];
    var $131 = $ns_hpfsmpl + 2304 + ($i_1206 << 2) | 0;
    var $132 = HEAPF32[$131 >> 2];
    var $133 = $130 + $132;
    HEAPF32[$129 >> 2] = $133;
    var $134 = $130 - $132;
    HEAPF32[$131 >> 2] = $134;
    var $135 = $i_1206 + 1 | 0;
    var $exitcond = ($135 | 0) == 576;
    if ($exitcond) {
      label = 15;
      break;
    } else {
      var $i_1206 = $135;
      label = 14;
      break;
    }
   case 15:
    var $_promoted = HEAPF32[$20 >> 2];
    var $136 = $gfc + 27636 + $chn_1223 * 36 + 24 | 0;
    var $137 = HEAPF32[$136 >> 2];
    var $138 = $en_subshort | 0;
    HEAPF32[$138 >> 2] = $137;
    var $139 = $gfc + 27636 + $chn_1223 * 36 + 16 | 0;
    var $140 = HEAPF32[$139 >> 2];
    var $141 = $137 / $140;
    var $142 = $attack_intensity | 0;
    HEAPF32[$142 >> 2] = $141;
    var $143 = HEAPF32[$138 >> 2];
    var $144 = $143 + $_promoted;
    var $145 = $gfc + 27636 + $chn_1223 * 36 + 28 | 0;
    var $146 = HEAPF32[$145 >> 2];
    var $147 = $en_subshort + 4 | 0;
    HEAPF32[$147 >> 2] = $146;
    var $148 = $gfc + 27636 + $chn_1223 * 36 + 20 | 0;
    var $149 = HEAPF32[$148 >> 2];
    var $150 = $146 / $149;
    var $151 = $attack_intensity + 4 | 0;
    HEAPF32[$151 >> 2] = $150;
    var $152 = HEAPF32[$147 >> 2];
    var $153 = $152 + $144;
    var $154 = $gfc + 27636 + $chn_1223 * 36 + 32 | 0;
    var $155 = HEAPF32[$154 >> 2];
    var $156 = $en_subshort + 8 | 0;
    HEAPF32[$156 >> 2] = $155;
    var $157 = $gfc + 27636 + $chn_1223 * 36 + 24 | 0;
    var $158 = HEAPF32[$157 >> 2];
    var $159 = $155 / $158;
    var $160 = $attack_intensity + 8 | 0;
    HEAPF32[$160 >> 2] = $159;
    var $161 = HEAPF32[$156 >> 2];
    var $162 = $161 + $153;
    HEAPF32[$20 >> 2] = $162;
    var $pf_0214 = $127;
    var $i_3215 = 0;
    label = 16;
    break;
   case 16:
    var $i_3215;
    var $pf_0214;
    var $163 = $pf_0214 + 256 | 0;
    var $pf_1210 = $pf_0214;
    var $p_0211 = 1;
    label = 17;
    break;
   case 17:
    var $p_0211;
    var $pf_1210;
    var $165 = HEAPF32[$pf_1210 >> 2];
    var $fabsf = Math.abs($165);
    var $166 = $p_0211 < $fabsf;
    var $p_1 = $166 ? $fabsf : $p_0211;
    var $167 = $pf_1210 + 4 | 0;
    var $168 = $167 >>> 0 < $163 >>> 0;
    if ($168) {
      var $pf_1210 = $167;
      var $p_0211 = $p_1;
      label = 17;
      break;
    } else {
      label = 18;
      break;
    }
   case 18:
    var $169 = $i_3215 + 3 | 0;
    var $170 = $en_subshort + ($169 << 2) | 0;
    HEAPF32[$170 >> 2] = $p_1;
    var $171 = $gfc + 27636 + $chn_1223 * 36 + ($i_3215 << 2) | 0;
    HEAPF32[$171 >> 2] = $p_1;
    var $172 = ($i_3215 | 0) / 3 & -1;
    var $173 = $172 + 1 | 0;
    var $174 = $en_short + ($173 << 2) | 0;
    var $175 = HEAPF32[$174 >> 2];
    var $176 = $p_1 + $175;
    HEAPF32[$174 >> 2] = $176;
    var $177 = $i_3215 + 1 | 0;
    var $178 = $en_subshort + ($177 << 2) | 0;
    var $179 = HEAPF32[$178 >> 2];
    var $180 = $p_1 > $179;
    if ($180) {
      label = 19;
      break;
    } else {
      label = 20;
      break;
    }
   case 19:
    var $182 = $p_1 / $179;
    var $p_2 = $182;
    label = 22;
    break;
   case 20:
    var $184 = $p_1 * 10;
    var $185 = $179 > $184;
    if ($185) {
      label = 21;
      break;
    } else {
      var $p_2 = 0;
      label = 22;
      break;
    }
   case 21:
    var $187 = $179 / $184;
    var $p_2 = $187;
    label = 22;
    break;
   case 22:
    var $p_2;
    var $189 = $attack_intensity + ($169 << 2) | 0;
    HEAPF32[$189 >> 2] = $p_2;
    var $exitcond236 = ($177 | 0) == 9;
    if ($exitcond236) {
      label = 23;
      break;
    } else {
      var $pf_0214 = $167;
      var $i_3215 = $177;
      label = 16;
      break;
    }
   case 23:
    var $190 = $en_subshort + 12 | 0;
    var $191 = HEAPF32[$190 >> 2];
    var $192 = $en_subshort + 16 | 0;
    var $193 = HEAPF32[$192 >> 2];
    var $194 = $191 + $193;
    var $195 = $en_subshort + 20 | 0;
    var $196 = HEAPF32[$195 >> 2];
    var $197 = $194 + $196;
    var $198 = $196 * 6;
    var $199 = $198 < $197;
    if ($199) {
      label = 24;
      break;
    } else {
      var $factor_0 = 1;
      label = 26;
      break;
    }
   case 24:
    var $201 = $193 * 6;
    var $202 = $201 < $197;
    if ($202) {
      label = 25;
      break;
    } else {
      var $factor_0 = .5;
      label = 26;
      break;
    }
   case 25:
    var $factor_0 = .25;
    label = 26;
    break;
   case 26:
    var $factor_0;
    var $205 = $sub_short_factor + $chn_1223 * 12 | 0;
    HEAPF32[$205 >> 2] = $factor_0;
    var $206 = $en_subshort + 24 | 0;
    var $207 = HEAPF32[$206 >> 2];
    var $208 = $en_subshort + 28 | 0;
    var $209 = HEAPF32[$208 >> 2];
    var $210 = $207 + $209;
    var $211 = $en_subshort + 32 | 0;
    var $212 = HEAPF32[$211 >> 2];
    var $213 = $210 + $212;
    var $214 = $212 * 6;
    var $215 = $214 < $213;
    if ($215) {
      label = 56;
      break;
    } else {
      var $factor_0_1 = 1;
      label = 58;
      break;
    }
   case 27:
    var $217 = HEAPF32[$24 >> 2];
    var $218 = $attack_intensity + 4 | 0;
    var $219 = HEAPF32[$218 >> 2];
    var $220 = $217 < $219;
    var $x_1 = $220 ? $219 : $217;
    var $221 = $attack_intensity + 8 | 0;
    var $222 = HEAPF32[$221 >> 2];
    var $223 = $x_1 < $222;
    var $x_1_1 = $223 ? $222 : $x_1;
    var $224 = $attack_intensity + 12 | 0;
    var $225 = HEAPF32[$224 >> 2];
    var $226 = $x_1_1 < $225;
    var $x_1_2 = $226 ? $225 : $x_1_1;
    var $227 = $attack_intensity + 16 | 0;
    var $228 = HEAPF32[$227 >> 2];
    var $229 = $x_1_2 < $228;
    var $x_1_3 = $229 ? $228 : $x_1_2;
    var $230 = $attack_intensity + 20 | 0;
    var $231 = HEAPF32[$230 >> 2];
    var $232 = $x_1_3 < $231;
    var $x_1_4 = $232 ? $231 : $x_1_3;
    var $233 = $attack_intensity + 24 | 0;
    var $234 = HEAPF32[$233 >> 2];
    var $235 = $x_1_4 < $234;
    var $x_1_5 = $235 ? $234 : $x_1_4;
    var $236 = $attack_intensity + 28 | 0;
    var $237 = HEAPF32[$236 >> 2];
    var $238 = $x_1_5 < $237;
    var $x_1_6 = $238 ? $237 : $x_1_5;
    var $239 = $attack_intensity + 32 | 0;
    var $240 = HEAPF32[$239 >> 2];
    var $241 = $x_1_6 < $240;
    var $x_1_7 = $241 ? $240 : $x_1_6;
    var $242 = $attack_intensity + 36 | 0;
    var $243 = HEAPF32[$242 >> 2];
    var $244 = $x_1_7 < $243;
    var $x_1_8 = $244 ? $243 : $x_1_7;
    var $245 = $attack_intensity + 40 | 0;
    var $246 = HEAPF32[$245 >> 2];
    var $247 = $x_1_8 < $246;
    var $x_1_9 = $247 ? $246 : $x_1_8;
    var $248 = $attack_intensity + 44 | 0;
    var $249 = HEAPF32[$248 >> 2];
    var $250 = $x_1_9 < $249;
    var $x_1_10 = $250 ? $249 : $x_1_9;
    var $251 = $8 + 197108 + ($chn_1223 << 3) | 0;
    var $252 = (HEAP32[tempDoublePtr >> 2] = HEAP32[$251 >> 2], HEAP32[tempDoublePtr + 4 >> 2] = HEAP32[$251 + 4 >> 2], HEAPF64[tempDoublePtr >> 3]);
    var $253 = $8 + 197140 + ($gr_out << 5) + ($chn_1223 << 3) | 0;
    HEAPF64[tempDoublePtr >> 3] = $252, HEAP32[$253 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$253 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    var $254 = $x_1_10;
    HEAPF64[tempDoublePtr >> 3] = $254, HEAP32[$251 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$251 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    label = 28;
    break;
   case 28:
    var $256 = HEAP32[$22 >> 2];
    var $257 = $256 + 6480 + ($chn_1223 << 2) | 0;
    var $258 = HEAPF32[$257 >> 2];
    var $i_6220 = 0;
    label = 29;
    break;
   case 29:
    var $i_6220;
    var $260 = ($i_6220 | 0) / 3 & -1;
    var $261 = $ns_attacks + ($chn_1223 << 4) + ($260 << 2) | 0;
    var $262 = HEAP32[$261 >> 2];
    var $263 = ($262 | 0) == 0;
    if ($263) {
      label = 30;
      break;
    } else {
      label = 32;
      break;
    }
   case 30:
    var $265 = $attack_intensity + ($i_6220 << 2) | 0;
    var $266 = HEAPF32[$265 >> 2];
    var $267 = $266 > $258;
    if ($267) {
      label = 31;
      break;
    } else {
      label = 32;
      break;
    }
   case 31:
    var $269 = ($i_6220 | 0) % 3;
    var $270 = $269 + 1 | 0;
    HEAP32[$261 >> 2] = $270;
    label = 32;
    break;
   case 32:
    var $272 = $i_6220 + 1 | 0;
    var $exitcond239 = ($272 | 0) == 12;
    if ($exitcond239) {
      label = 33;
      break;
    } else {
      var $i_6220 = $272;
      label = 29;
      break;
    }
   case 33:
    var $274 = $ns_attacks + ($chn_1223 << 4) | 0;
    var $275 = $en_short | 0;
    var $276 = HEAPF32[$275 >> 2];
    var $277 = $en_short + 4 | 0;
    var $278 = HEAPF32[$277 >> 2];
    var $279 = $276 > $278;
    var $280 = $279 ? $276 : $278;
    var $281 = $280 < 4e4;
    var $282 = $278 * 1.7000000476837158;
    var $283 = $276 < $282;
    var $or_cond = $281 & $283;
    var $284 = $276 * 1.7000000476837158;
    var $285 = $278 < $284;
    var $or_cond204 = $or_cond & $285;
    if ($or_cond204) {
      label = 34;
      break;
    } else {
      label = 37;
      break;
    }
   case 34:
    var $287 = HEAP32[$274 >> 2];
    var $288 = $ns_attacks + ($chn_1223 << 4) + 4 | 0;
    var $289 = HEAP32[$288 >> 2];
    var $290 = ($287 | 0) > ($289 | 0);
    if ($290) {
      label = 36;
      break;
    } else {
      label = 35;
      break;
    }
   case 35:
    HEAP32[$274 >> 2] = 0;
    label = 36;
    break;
   case 36:
    var $293 = $ns_attacks + ($chn_1223 << 4) + 4 | 0;
    HEAP32[$293 >> 2] = 0;
    label = 37;
    break;
   case 37:
    var $295 = $en_short + 4 | 0;
    var $296 = HEAPF32[$295 >> 2];
    var $297 = $en_short + 8 | 0;
    var $298 = HEAPF32[$297 >> 2];
    var $299 = $296 > $298;
    var $300 = $299 ? $296 : $298;
    var $301 = $300 < 4e4;
    var $302 = $298 * 1.7000000476837158;
    var $303 = $296 < $302;
    var $or_cond_1 = $301 & $303;
    var $304 = $296 * 1.7000000476837158;
    var $305 = $298 < $304;
    var $or_cond204_1 = $or_cond_1 & $305;
    if ($or_cond204_1) {
      label = 62;
      break;
    } else {
      label = 63;
      break;
    }
   case 38:
    HEAP32[$397 >> 2] = 0;
    var $_pr = HEAP32[$399 >> 2];
    var $308 = $_pr;
    label = 39;
    break;
   case 39:
    var $308;
    var $309 = ($308 | 0) == 3;
    if ($309) {
      label = 41;
      break;
    } else {
      label = 40;
      break;
    }
   case 40:
    var $311 = HEAP32[$397 >> 2];
    var $312 = $ns_attacks + ($chn_1223 << 4) + 4 | 0;
    var $313 = HEAP32[$312 >> 2];
    var $314 = $313 + $311 | 0;
    var $315 = $ns_attacks + ($chn_1223 << 4) + 8 | 0;
    var $316 = HEAP32[$315 >> 2];
    var $317 = $314 + $316 | 0;
    var $318 = $ns_attacks + ($chn_1223 << 4) + 12 | 0;
    var $319 = HEAP32[$318 >> 2];
    var $320 = -$319 | 0;
    var $321 = ($317 | 0) == ($320 | 0);
    if ($321) {
      var $ns_uselongblock_0 = 1;
      label = 50;
      break;
    } else {
      label = 41;
      break;
    }
   case 41:
    var $323 = $ns_attacks + ($chn_1223 << 4) + 4 | 0;
    var $324 = HEAP32[$323 >> 2];
    var $325 = ($324 | 0) == 0;
    if ($325) {
      label = 44;
      break;
    } else {
      label = 42;
      break;
    }
   case 42:
    var $327 = HEAP32[$397 >> 2];
    var $328 = ($327 | 0) == 0;
    if ($328) {
      label = 44;
      break;
    } else {
      label = 43;
      break;
    }
   case 43:
    HEAP32[$323 >> 2] = 0;
    label = 44;
    break;
   case 44:
    var $331 = $ns_attacks + ($chn_1223 << 4) + 8 | 0;
    var $332 = HEAP32[$331 >> 2];
    var $333 = ($332 | 0) == 0;
    if ($333) {
      label = 47;
      break;
    } else {
      label = 45;
      break;
    }
   case 45:
    var $335 = HEAP32[$323 >> 2];
    var $336 = ($335 | 0) == 0;
    if ($336) {
      label = 47;
      break;
    } else {
      label = 46;
      break;
    }
   case 46:
    HEAP32[$331 >> 2] = 0;
    label = 47;
    break;
   case 47:
    var $339 = $ns_attacks + ($chn_1223 << 4) + 12 | 0;
    var $340 = HEAP32[$339 >> 2];
    var $341 = ($340 | 0) == 0;
    if ($341) {
      var $ns_uselongblock_0 = 0;
      label = 50;
      break;
    } else {
      label = 48;
      break;
    }
   case 48:
    var $343 = HEAP32[$331 >> 2];
    var $344 = ($343 | 0) == 0;
    if ($344) {
      var $ns_uselongblock_0 = 0;
      label = 50;
      break;
    } else {
      label = 49;
      break;
    }
   case 49:
    HEAP32[$339 >> 2] = 0;
    var $ns_uselongblock_0 = 0;
    label = 50;
    break;
   case 50:
    var $ns_uselongblock_0;
    var $347 = ($chn_1223 | 0) < 2;
    if ($347) {
      label = 51;
      break;
    } else {
      label = 52;
      break;
    }
   case 51:
    var $349 = $uselongblock + ($chn_1223 << 2) | 0;
    HEAP32[$349 >> 2] = $ns_uselongblock_0;
    label = 54;
    break;
   case 52:
    var $351 = ($ns_uselongblock_0 | 0) == 0;
    if ($351) {
      label = 53;
      break;
    } else {
      label = 54;
      break;
    }
   case 53:
    HEAP32[$23 >> 2] = 0;
    HEAP32[$uselongblock >> 2] = 0;
    label = 54;
    break;
   case 54:
    var $354 = $gfc + 27620 + ($chn_1223 << 2) | 0;
    var $355 = HEAPF32[$354 >> 2];
    var $356 = $energy + ($chn_1223 << 2) | 0;
    HEAPF32[$356 >> 2] = $355;
    var $357 = $chn_1223 + 1 | 0;
    var $exitcond241 = ($357 | 0) == ($14 | 0);
    if ($exitcond241) {
      label = 55;
      break;
    } else {
      var $chn_1223 = $357;
      label = 13;
      break;
    }
   case 55:
    STACKTOP = __stackBase__;
    return;
   case 56:
    var $359 = $209 * 6;
    var $360 = $359 < $213;
    if ($360) {
      label = 57;
      break;
    } else {
      var $factor_0_1 = .5;
      label = 58;
      break;
    }
   case 57:
    var $factor_0_1 = .25;
    label = 58;
    break;
   case 58:
    var $factor_0_1;
    var $363 = $sub_short_factor + $chn_1223 * 12 + 4 | 0;
    HEAPF32[$363 >> 2] = $factor_0_1;
    var $364 = $en_subshort + 36 | 0;
    var $365 = HEAPF32[$364 >> 2];
    var $366 = $en_subshort + 40 | 0;
    var $367 = HEAPF32[$366 >> 2];
    var $368 = $365 + $367;
    var $369 = $en_subshort + 44 | 0;
    var $370 = HEAPF32[$369 >> 2];
    var $371 = $368 + $370;
    var $372 = $370 * 6;
    var $373 = $372 < $371;
    if ($373) {
      label = 59;
      break;
    } else {
      var $factor_0_2 = 1;
      label = 61;
      break;
    }
   case 59:
    var $375 = $367 * 6;
    var $376 = $375 < $371;
    if ($376) {
      label = 60;
      break;
    } else {
      var $factor_0_2 = .5;
      label = 61;
      break;
    }
   case 60:
    var $factor_0_2 = .25;
    label = 61;
    break;
   case 61:
    var $factor_0_2;
    var $379 = $sub_short_factor + $chn_1223 * 12 + 8 | 0;
    HEAPF32[$379 >> 2] = $factor_0_2;
    if ($21) {
      label = 28;
      break;
    } else {
      label = 27;
      break;
    }
   case 62:
    var $381 = $ns_attacks + ($chn_1223 << 4) + 8 | 0;
    HEAP32[$381 >> 2] = 0;
    label = 63;
    break;
   case 63:
    var $383 = $en_short + 8 | 0;
    var $384 = HEAPF32[$383 >> 2];
    var $385 = $en_short + 12 | 0;
    var $386 = HEAPF32[$385 >> 2];
    var $387 = $384 > $386;
    var $388 = $387 ? $384 : $386;
    var $389 = $388 < 4e4;
    var $390 = $386 * 1.7000000476837158;
    var $391 = $384 < $390;
    var $or_cond_2 = $389 & $391;
    var $392 = $384 * 1.7000000476837158;
    var $393 = $386 < $392;
    var $or_cond204_2 = $or_cond_2 & $393;
    if ($or_cond204_2) {
      label = 64;
      break;
    } else {
      label = 65;
      break;
    }
   case 64:
    var $395 = $ns_attacks + ($chn_1223 << 4) + 12 | 0;
    HEAP32[$395 >> 2] = 0;
    label = 65;
    break;
   case 65:
    var $397 = $ns_attacks + ($chn_1223 << 4) | 0;
    var $398 = HEAP32[$397 >> 2];
    var $399 = $gfc + 27780 + ($chn_1223 << 2) | 0;
    var $400 = HEAP32[$399 >> 2];
    var $401 = ($398 | 0) > ($400 | 0);
    if ($401) {
      var $308 = $400;
      label = 39;
      break;
    } else {
      label = 38;
      break;
    }
  }
}
_vbrpsy_attack_detection["X"] = 1;
function _vbrpsy_compute_fft_l($gfc, $buffer, $chn, $gr_out, $fftenergy, $wsamp_l) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 140 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($2 | 0) == 0;
    if ($3) {
      var $8 = 0;
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $5 = $gfc + 85800 | 0;
    var $6 = HEAP32[$5 >> 2];
    var $8 = $6;
    label = 4;
    break;
   case 4:
    var $8;
    var $9 = ($chn | 0) < 2;
    if ($9) {
      label = 5;
      break;
    } else {
      label = 6;
      break;
    }
   case 5:
    var $11 = $wsamp_l | 0;
    _fft_long($gfc, $11, $chn, $buffer);
    label = 8;
    break;
   case 6:
    var $13 = ($chn | 0) == 2;
    if ($13) {
      var $j_061 = 1023;
      label = 7;
      break;
    } else {
      label = 8;
      break;
    }
   case 7:
    var $j_061;
    var $14 = $wsamp_l + ($j_061 << 2) | 0;
    var $15 = HEAPF32[$14 >> 2];
    var $16 = $wsamp_l + 4096 + ($j_061 << 2) | 0;
    var $17 = HEAPF32[$16 >> 2];
    var $18 = $15 + $17;
    var $19 = $18 * .7071067690849304;
    HEAPF32[$14 >> 2] = $19;
    var $20 = $15 - $17;
    var $21 = $20 * .7071067690849304;
    HEAPF32[$16 >> 2] = $21;
    var $22 = $j_061 - 1 | 0;
    var $23 = ($j_061 | 0) > 0;
    if ($23) {
      var $j_061 = $22;
      label = 7;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    var $24 = $wsamp_l | 0;
    var $25 = HEAPF32[$24 >> 2];
    var $26 = $25 * $25;
    HEAPF32[$fftenergy >> 2] = $26;
    var $j_158 = 511;
    label = 9;
    break;
   case 9:
    var $j_158;
    var $28 = 512 - $j_158 | 0;
    var $29 = $wsamp_l + ($28 << 2) | 0;
    var $30 = HEAPF32[$29 >> 2];
    var $31 = $j_158 + 512 | 0;
    var $32 = $wsamp_l + ($31 << 2) | 0;
    var $33 = HEAPF32[$32 >> 2];
    var $34 = $30 * $30;
    var $35 = $33 * $33;
    var $36 = $34 + $35;
    var $37 = $36 * .5;
    var $38 = $fftenergy + ($28 << 2) | 0;
    HEAPF32[$38 >> 2] = $37;
    var $39 = $j_158 - 1 | 0;
    var $40 = ($j_158 | 0) > 0;
    if ($40) {
      var $j_158 = $39;
      label = 9;
      break;
    } else {
      var $j_256 = 11;
      var $totalenergy_057 = 0;
      label = 10;
      break;
    }
   case 10:
    var $totalenergy_057;
    var $j_256;
    var $41 = $fftenergy + ($j_256 << 2) | 0;
    var $42 = HEAPF32[$41 >> 2];
    var $43 = $totalenergy_057 + $42;
    var $44 = $j_256 + 1 | 0;
    var $exitcond62 = ($44 | 0) == 513;
    if ($exitcond62) {
      label = 11;
      break;
    } else {
      var $j_256 = $44;
      var $totalenergy_057 = $43;
      label = 10;
      break;
    }
   case 11:
    var $46 = $gfc + 27620 + ($chn << 2) | 0;
    HEAPF32[$46 >> 2] = $43;
    var $47 = ($8 | 0) == 0;
    if ($47) {
      label = 13;
      break;
    } else {
      var $j_354 = 0;
      label = 12;
      break;
    }
   case 12:
    var $j_354;
    var $48 = $8 + 90932 + ($chn << 13) + ($j_354 << 3) | 0;
    var $49 = (HEAP32[tempDoublePtr >> 2] = HEAP32[$48 >> 2], HEAP32[tempDoublePtr + 4 >> 2] = HEAP32[$48 + 4 >> 2], HEAPF64[tempDoublePtr >> 3]);
    var $50 = $8 + 123700 + ($gr_out << 15) + ($chn << 13) + ($j_354 << 3) | 0;
    HEAPF64[tempDoublePtr >> 3] = $49, HEAP32[$50 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$50 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    var $51 = $fftenergy + ($j_354 << 2) | 0;
    var $52 = HEAPF32[$51 >> 2];
    var $53 = $52;
    HEAPF64[tempDoublePtr >> 3] = $53, HEAP32[$48 >> 2] = HEAP32[tempDoublePtr >> 2], HEAP32[$48 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    var $54 = $j_354 + 1 | 0;
    var $exitcond = ($54 | 0) == 513;
    if ($exitcond) {
      label = 13;
      break;
    } else {
      var $j_354 = $54;
      label = 12;
      break;
    }
   case 13:
    return;
  }
}
_vbrpsy_compute_fft_l["X"] = 1;
function _vbrpsy_compute_loudness_approximation_l($gfc, $gr_out, $chn, $fftenergy) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($chn | 0) < 2;
    if ($1) {
      label = 3;
      break;
    } else {
      label = 4;
      break;
    }
   case 3:
    var $3 = $gfc + 27612 + ($chn << 2) | 0;
    var $4 = HEAPF32[$3 >> 2];
    var $5 = $gfc + 27804 + ($gr_out << 3) + ($chn << 2) | 0;
    HEAPF32[$5 >> 2] = $4;
    var $6 = $gfc + 85792 | 0;
    var $7 = HEAP32[$6 >> 2];
    var $8 = $7 + 724 | 0;
    var $9 = _psycho_loudness_approx($fftenergy, $8);
    HEAPF32[$3 >> 2] = $9;
    label = 4;
    break;
   case 4:
    return;
  }
}
function _vbrpsy_compute_MS_thresholds($eb, $thr, $cb_mld, $ath_cb, $athlower, $msfix, $n) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $msfix * 2;
    var $2 = ($n | 0) > 0;
    if ($2) {
      label = 3;
      break;
    } else {
      label = 12;
      break;
    }
   case 3:
    var $3 = $msfix > 0;
    var $b_082 = 0;
    label = 4;
    break;
   case 4:
    var $b_082;
    var $5 = $eb + 512 + ($b_082 << 2) | 0;
    var $6 = HEAPF32[$5 >> 2];
    var $7 = $eb + 768 + ($b_082 << 2) | 0;
    var $8 = HEAPF32[$7 >> 2];
    var $9 = $thr + ($b_082 << 2) | 0;
    var $10 = HEAPF32[$9 >> 2];
    var $11 = $thr + 256 + ($b_082 << 2) | 0;
    var $12 = HEAPF32[$11 >> 2];
    var $13 = $thr + 512 + ($b_082 << 2) | 0;
    var $14 = HEAPF32[$13 >> 2];
    var $15 = $thr + 768 + ($b_082 << 2) | 0;
    var $16 = HEAPF32[$15 >> 2];
    var $17 = $12 * 1.5800000429153442;
    var $18 = $10 > $17;
    var $19 = $10 * 1.5800000429153442;
    var $20 = $12 > $19;
    var $or_cond = $18 | $20;
    if ($or_cond) {
      var $rside_0 = $16;
      var $rmid_0 = $14;
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $22 = $cb_mld + ($b_082 << 2) | 0;
    var $23 = HEAPF32[$22 >> 2];
    var $24 = $8 * $23;
    var $25 = $6 * $23;
    var $26 = $16 < $24;
    var $27 = $26 ? $16 : $24;
    var $28 = $14 < $25;
    var $29 = $28 ? $14 : $25;
    var $30 = $14 > $27;
    var $31 = $30 ? $14 : $27;
    var $32 = $16 > $29;
    var $33 = $32 ? $16 : $29;
    var $rside_0 = $33;
    var $rmid_0 = $31;
    label = 6;
    break;
   case 6:
    var $rmid_0;
    var $rside_0;
    if ($3) {
      label = 7;
      break;
    } else {
      var $rside_1 = $rside_0;
      var $rmid_1 = $rmid_0;
      label = 11;
      break;
    }
   case 7:
    var $36 = $ath_cb + ($b_082 << 2) | 0;
    var $37 = HEAPF32[$36 >> 2];
    var $38 = $37 * $athlower;
    var $39 = $10 > $38;
    var $40 = $39 ? $10 : $38;
    var $41 = $12 > $38;
    var $42 = $41 ? $12 : $38;
    var $43 = $rmid_0 > $38;
    var $44 = $43 ? $rmid_0 : $38;
    var $45 = $rside_0 > $38;
    var $46 = $45 ? $rside_0 : $38;
    var $47 = $44 + $46;
    var $48 = $47 > 0;
    if ($48) {
      label = 8;
      break;
    } else {
      var $thmM_0 = $44;
      var $thmS_0 = $46;
      label = 10;
      break;
    }
   case 8:
    var $50 = $40 < $42;
    var $51 = $50 ? $40 : $42;
    var $52 = $1 * $51;
    var $53 = $52 < $47;
    if ($53) {
      label = 9;
      break;
    } else {
      var $thmM_0 = $44;
      var $thmS_0 = $46;
      label = 10;
      break;
    }
   case 9:
    var $55 = $52 / $47;
    var $56 = $44 * $55;
    var $57 = $46 * $55;
    var $thmM_0 = $56;
    var $thmS_0 = $57;
    label = 10;
    break;
   case 10:
    var $thmS_0;
    var $thmM_0;
    var $59 = $thmM_0 < $rmid_0;
    var $60 = $59 ? $thmM_0 : $rmid_0;
    var $61 = $thmS_0 < $rside_0;
    var $62 = $61 ? $thmS_0 : $rside_0;
    var $rside_1 = $62;
    var $rmid_1 = $60;
    label = 11;
    break;
   case 11:
    var $rmid_1;
    var $rside_1;
    var $64 = $rmid_1 > $6;
    var $rmid_2 = $64 ? $6 : $rmid_1;
    var $65 = $rside_1 > $8;
    var $rside_2 = $65 ? $8 : $rside_1;
    HEAPF32[$13 >> 2] = $rmid_2;
    HEAPF32[$15 >> 2] = $rside_2;
    var $66 = $b_082 + 1 | 0;
    var $exitcond = ($66 | 0) == ($n | 0);
    if ($exitcond) {
      label = 12;
      break;
    } else {
      var $b_082 = $66;
      label = 4;
      break;
    }
   case 12:
    return;
  }
}
_vbrpsy_compute_MS_thresholds["X"] = 1;
function _vbrpsy_skip_masking_s($gfc, $chn, $sblock) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($sblock | 0) == 0;
    if ($1) {
      label = 3;
      break;
    } else {
      label = 5;
      break;
    }
   case 3:
    var $3 = $gfc + 85796 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = $4 + 4308 | 0;
    var $6 = HEAP32[$5 >> 2];
    var $7 = ($6 | 0) > 0;
    if ($7) {
      var $b_09 = 0;
      label = 4;
      break;
    } else {
      label = 5;
      break;
    }
   case 4:
    var $b_09;
    var $8 = $gfc + 23612 + ($chn << 8) + ($b_09 << 2) | 0;
    var $9 = HEAPF32[$8 >> 2];
    var $10 = $gfc + 24636 + ($chn << 8) + ($b_09 << 2) | 0;
    HEAPF32[$10 >> 2] = $9;
    var $11 = $b_09 + 1 | 0;
    var $exitcond = ($11 | 0) == ($6 | 0);
    if ($exitcond) {
      label = 5;
      break;
    } else {
      var $b_09 = $11;
      label = 4;
      break;
    }
   case 5:
    return;
  }
}
function _vbrpsy_apply_block_type($psv, $nch, $uselongblock, $blocktype_d) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($nch | 0) > 0;
    if ($1) {
      var $chn_020 = 0;
      label = 3;
      break;
    } else {
      label = 10;
      break;
    }
   case 3:
    var $chn_020;
    var $2 = $uselongblock + ($chn_020 << 2) | 0;
    var $3 = HEAP32[$2 >> 2];
    var $4 = ($3 | 0) == 0;
    var $5 = $psv + 6232 + ($chn_020 << 2) | 0;
    var $6 = HEAP32[$5 >> 2];
    if ($4) {
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $8 = ($6 | 0) == 2;
    var $_ = $8 ? 3 : 0;
    var $blocktype_0 = $_;
    label = 9;
    break;
   case 5:
    var $10 = ($6 | 0) == 0;
    if ($10) {
      label = 6;
      break;
    } else {
      label = 7;
      break;
    }
   case 6:
    HEAP32[$5 >> 2] = 1;
    var $blocktype_0 = 2;
    label = 9;
    break;
   case 7:
    var $_pr = HEAP32[$5 >> 2];
    var $12 = ($_pr | 0) == 3;
    if ($12) {
      label = 8;
      break;
    } else {
      var $blocktype_0 = 2;
      label = 9;
      break;
    }
   case 8:
    HEAP32[$5 >> 2] = 2;
    var $blocktype_0 = 2;
    label = 9;
    break;
   case 9:
    var $blocktype_0;
    var $15 = HEAP32[$5 >> 2];
    var $16 = $blocktype_d + ($chn_020 << 2) | 0;
    HEAP32[$16 >> 2] = $15;
    HEAP32[$5 >> 2] = $blocktype_0;
    var $17 = $chn_020 + 1 | 0;
    var $exitcond = ($17 | 0) == ($nch | 0);
    if ($exitcond) {
      label = 10;
      break;
    } else {
      var $chn_020 = $17;
      label = 3;
      break;
    }
   case 10:
    return;
  }
}
function _vbrpsy_compute_masking_l($gfc, $fftenergy, $eb_l, $thr, $chn) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 580 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $max = __stackBase__;
    var $avg = __stackBase__ + 256;
    var $mask_idx_l = __stackBase__ + 512;
    var $1 = $gfc + 85796 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $2 | 0;
    var $4 = $max | 0;
    var $5 = $avg | 0;
    _calc_energy($3, $fftenergy, $eb_l, $4, $5);
    var $6 = $mask_idx_l | 0;
    _calc_mask_index_l($gfc, $4, $5, $6);
    var $7 = $2 + 2148 | 0;
    var $8 = HEAP32[$7 >> 2];
    var $9 = ($8 | 0) > 0;
    if ($9) {
      label = 3;
      break;
    } else {
      var $b_1113 = 0;
      label = 24;
      break;
    }
   case 3:
    var $10 = $gfc + 84904 | 0;
    var $11 = $2 + 2156 | 0;
    var $12 = $chn & 1;
    var $13 = $gfc + 27796 + ($12 << 2) | 0;
    var $b_0127 = 0;
    var $k_0128 = 0;
    label = 5;
    break;
   case 4:
    var $14 = ($134 | 0) < 64;
    if ($14) {
      var $b_1113 = $134;
      label = 24;
      break;
    } else {
      label = 25;
      break;
    }
   case 5:
    var $k_0128;
    var $b_0127;
    var $16 = $2 + ($b_0127 << 2) | 0;
    var $17 = HEAPF32[$16 >> 2];
    var $18 = HEAPF32[$10 >> 2];
    var $19 = $17 * $18;
    var $20 = $2 + 1204 + ($b_0127 << 3) | 0;
    var $21 = HEAP32[$20 >> 2];
    var $22 = $2 + 1204 + ($b_0127 << 3) + 4 | 0;
    var $23 = HEAP32[$22 >> 2];
    var $24 = $mask_idx_l + $b_0127 | 0;
    var $25 = HEAP8[$24];
    var $26 = $25 & 255;
    var $27 = _mask_add_delta($26);
    var $28 = $mask_idx_l + $21 | 0;
    var $29 = HEAP8[$28];
    var $30 = $29 & 255;
    var $31 = HEAP32[$11 >> 2];
    var $32 = $31 + ($k_0128 << 2) | 0;
    var $33 = HEAPF32[$32 >> 2];
    var $34 = $eb_l + ($21 << 2) | 0;
    var $35 = HEAPF32[$34 >> 2];
    var $36 = $33 * $35;
    var $37 = 5249776 + ($30 << 2) | 0;
    var $38 = HEAPF32[$37 >> 2];
    var $39 = $36 * $38;
    var $k_1114 = $k_0128 + 1 | 0;
    var $kk_0115 = $21 + 1 | 0;
    var $40 = ($kk_0115 | 0) > ($23 | 0);
    if ($40) {
      var $ecb_0_lcssa = $39;
      var $dd_0_lcssa = $30;
      var $dd_n_0_lcssa = 2;
      var $k_1_lcssa = $k_1114;
      label = 8;
      break;
    } else {
      var $ecb_0116 = $39;
      var $dd_0117 = $30;
      var $dd_n_0118 = 1;
      var $k_1119 = $k_1114;
      var $kk_0120 = $kk_0115;
      label = 6;
      break;
    }
   case 6:
    var $kk_0120;
    var $k_1119;
    var $dd_n_0118;
    var $dd_0117;
    var $ecb_0116;
    var $41 = $mask_idx_l + $kk_0120 | 0;
    var $42 = HEAP8[$41];
    var $43 = $42 & 255;
    var $44 = $43 + $dd_0117 | 0;
    var $45 = $dd_n_0118 + 1 | 0;
    var $46 = HEAP32[$11 >> 2];
    var $47 = $46 + ($k_1119 << 2) | 0;
    var $48 = HEAPF32[$47 >> 2];
    var $49 = $eb_l + ($kk_0120 << 2) | 0;
    var $50 = HEAPF32[$49 >> 2];
    var $51 = $48 * $50;
    var $52 = 5249776 + ($43 << 2) | 0;
    var $53 = HEAPF32[$52 >> 2];
    var $54 = $51 * $53;
    var $55 = $kk_0120 - $b_0127 | 0;
    var $56 = _vbrpsy_mask_add($ecb_0116, $54, $55, $27);
    var $k_1 = $k_1119 + 1 | 0;
    var $kk_0 = $kk_0120 + 1 | 0;
    var $57 = ($kk_0 | 0) > ($23 | 0);
    if ($57) {
      label = 7;
      break;
    } else {
      var $ecb_0116 = $56;
      var $dd_0117 = $44;
      var $dd_n_0118 = $45;
      var $k_1119 = $k_1;
      var $kk_0120 = $kk_0;
      label = 6;
      break;
    }
   case 7:
    var $phitmp = $45 << 1;
    var $ecb_0_lcssa = $56;
    var $dd_0_lcssa = $44;
    var $dd_n_0_lcssa = $phitmp;
    var $k_1_lcssa = $k_1;
    label = 8;
    break;
   case 8:
    var $k_1_lcssa;
    var $dd_n_0_lcssa;
    var $dd_0_lcssa;
    var $ecb_0_lcssa;
    var $59 = $dd_0_lcssa << 1;
    var $60 = $59 | 1;
    var $61 = ($60 | 0) / ($dd_n_0_lcssa | 0) & -1;
    var $62 = 5249776 + ($61 << 2) | 0;
    var $63 = HEAPF32[$62 >> 2];
    var $64 = $63 * .5;
    var $65 = $ecb_0_lcssa * $64;
    var $66 = HEAP32[$13 >> 2];
    var $67 = ($66 | 0) == 2;
    if ($67) {
      label = 9;
      break;
    } else {
      label = 12;
      break;
    }
   case 9:
    var $69 = $gfc + 21564 + ($chn << 8) + ($b_0127 << 2) | 0;
    var $70 = HEAPF32[$69 >> 2];
    var $71 = $70 * 2;
    var $72 = $71 > 0;
    if ($72) {
      label = 10;
      break;
    } else {
      label = 11;
      break;
    }
   case 10:
    var $74 = $65 < $71;
    var $75 = $74 ? $65 : $71;
    var $76 = $thr + ($b_0127 << 2) | 0;
    HEAPF32[$76 >> 2] = $75;
    label = 15;
    break;
   case 11:
    var $78 = $65;
    var $79 = $eb_l + ($b_0127 << 2) | 0;
    var $80 = HEAPF32[$79 >> 2];
    var $81 = $80;
    var $82 = $81 * .3;
    var $83 = $78 < $82;
    var $_ = $83 ? $78 : $82;
    var $84 = $_;
    var $85 = $thr + ($b_0127 << 2) | 0;
    HEAPF32[$85 >> 2] = $84;
    label = 15;
    break;
   case 12:
    var $87 = $gfc + 22588 + ($chn << 8) + ($b_0127 << 2) | 0;
    var $88 = HEAPF32[$87 >> 2];
    var $89 = $88 * 16;
    var $90 = $gfc + 21564 + ($chn << 8) + ($b_0127 << 2) | 0;
    var $91 = HEAPF32[$90 >> 2];
    var $92 = $91 * 2;
    var $93 = $89 > 0;
    var $ecb_limit_2_0 = $93 ? $89 : $65;
    var $94 = $92 > 0;
    var $ecb_limit_1_0 = $94 ? $92 : $65;
    var $95 = ($66 | 0) == 0;
    if ($95) {
      label = 13;
      break;
    } else {
      var $ecb_limit1_0 = $ecb_limit_1_0;
      label = 14;
      break;
    }
   case 13:
    var $97 = $ecb_limit_1_0 < $ecb_limit_2_0;
    var $98 = $97 ? $ecb_limit_1_0 : $ecb_limit_2_0;
    var $ecb_limit1_0 = $98;
    label = 14;
    break;
   case 14:
    var $ecb_limit1_0;
    var $100 = $65 < $ecb_limit1_0;
    var $101 = $100 ? $65 : $ecb_limit1_0;
    var $102 = $thr + ($b_0127 << 2) | 0;
    HEAPF32[$102 >> 2] = $101;
    label = 15;
    break;
   case 15:
    var $104 = $gfc + 21564 + ($chn << 8) + ($b_0127 << 2) | 0;
    var $105 = HEAPF32[$104 >> 2];
    var $106 = $gfc + 22588 + ($chn << 8) + ($b_0127 << 2) | 0;
    HEAPF32[$106 >> 2] = $105;
    HEAPF32[$104 >> 2] = $65;
    var $107 = $max + ($b_0127 << 2) | 0;
    var $108 = HEAPF32[$107 >> 2];
    var $109 = $2 + 256 + ($b_0127 << 2) | 0;
    var $110 = HEAPF32[$109 >> 2];
    var $111 = $108 * $110;
    var $112 = $64 * $111;
    var $113 = $thr + ($b_0127 << 2) | 0;
    var $114 = HEAPF32[$113 >> 2];
    var $115 = $114 > $112;
    if ($115) {
      label = 16;
      break;
    } else {
      label = 17;
      break;
    }
   case 16:
    HEAPF32[$113 >> 2] = $112;
    label = 17;
    break;
   case 17:
    var $118 = $19 > 1;
    if ($118) {
      label = 18;
      break;
    } else {
      label = 19;
      break;
    }
   case 18:
    var $120 = HEAPF32[$113 >> 2];
    var $121 = $19 * $120;
    HEAPF32[$113 >> 2] = $121;
    label = 19;
    break;
   case 19:
    var $123 = HEAPF32[$113 >> 2];
    var $124 = $eb_l + ($b_0127 << 2) | 0;
    var $125 = HEAPF32[$124 >> 2];
    var $126 = $123 > $125;
    if ($126) {
      label = 20;
      break;
    } else {
      label = 21;
      break;
    }
   case 20:
    HEAPF32[$113 >> 2] = $125;
    label = 21;
    break;
   case 21:
    var $129 = $19 < 1;
    if ($129) {
      label = 22;
      break;
    } else {
      label = 23;
      break;
    }
   case 22:
    var $131 = HEAPF32[$113 >> 2];
    var $132 = $19 * $131;
    HEAPF32[$113 >> 2] = $132;
    label = 23;
    break;
   case 23:
    var $134 = $b_0127 + 1 | 0;
    var $135 = HEAP32[$7 >> 2];
    var $136 = ($134 | 0) < ($135 | 0);
    if ($136) {
      var $b_0127 = $134;
      var $k_0128 = $k_1_lcssa;
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 24:
    var $b_1113;
    var $137 = $eb_l + ($b_1113 << 2) | 0;
    HEAPF32[$137 >> 2] = 0;
    var $138 = $thr + ($b_1113 << 2) | 0;
    HEAPF32[$138 >> 2] = 0;
    var $139 = $b_1113 + 1 | 0;
    var $exitcond = ($139 | 0) == 64;
    if ($exitcond) {
      label = 25;
      break;
    } else {
      var $b_1113 = $139;
      label = 24;
      break;
    }
   case 25:
    STACKTOP = __stackBase__;
    return;
  }
}
_vbrpsy_compute_masking_l["X"] = 1;
function _convert_partition2scalefac_l($gfc, $eb, $thr, $chn) {
  _convert_partition2scalefac(HEAP32[$gfc + 85796 >> 2] | 0, $eb, $thr, $gfc + 26636 + $chn * 244 | 0, $gfc + 25660 + $chn * 244 | 0);
  return;
}
function _convert_partition2scalefac_l_to_s($gfc, $eb, $thr, $chn) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 104 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $enn = __stackBase__;
    var $thm = __stackBase__ + 52;
    var $1 = $gfc + 85796 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $2 + 4320 | 0;
    var $4 = $enn | 0;
    var $5 = $thm | 0;
    _convert_partition2scalefac($3, $eb, $thr, $4, $5);
    var $sb_016 = 0;
    label = 3;
    break;
   case 3:
    var $sb_016;
    var $7 = $enn + ($sb_016 << 2) | 0;
    var $8 = HEAPF32[$7 >> 2];
    var $9 = $thm + ($sb_016 << 2) | 0;
    var $10 = HEAPF32[$9 >> 2];
    var $11 = $10 * .015625;
    var $12 = $gfc + 26636 + $chn * 244 + 88 + $sb_016 * 12 | 0;
    HEAPF32[$12 >> 2] = $8;
    var $13 = $gfc + 25660 + $chn * 244 + 88 + $sb_016 * 12 | 0;
    HEAPF32[$13 >> 2] = $11;
    var $14 = $gfc + 26636 + $chn * 244 + 88 + $sb_016 * 12 + 4 | 0;
    HEAPF32[$14 >> 2] = $8;
    var $15 = $gfc + 25660 + $chn * 244 + 88 + $sb_016 * 12 + 4 | 0;
    HEAPF32[$15 >> 2] = $11;
    var $16 = $gfc + 26636 + $chn * 244 + 88 + $sb_016 * 12 + 8 | 0;
    HEAPF32[$16 >> 2] = $8;
    var $17 = $gfc + 25660 + $chn * 244 + 88 + $sb_016 * 12 + 8 | 0;
    HEAPF32[$17 >> 2] = $11;
    var $18 = $sb_016 + 1 | 0;
    var $exitcond = ($18 | 0) == 13;
    if ($exitcond) {
      label = 4;
      break;
    } else {
      var $sb_016 = $18;
      label = 3;
      break;
    }
   case 4:
    STACKTOP = __stackBase__;
    return;
  }
}
function _vbrpsy_compute_fft_s($gfc, $buffer, $chn, $sblock, $fftenergy_s, $wsamp_s) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = ($sblock | 0) == 0;
    var $2 = ($chn | 0) < 2;
    var $or_cond = $1 & $2;
    if ($or_cond) {
      label = 3;
      break;
    } else {
      label = 4;
      break;
    }
   case 3:
    var $4 = $wsamp_s | 0;
    _fft_short($gfc, $4, $chn, $buffer);
    label = 4;
    break;
   case 4:
    var $6 = ($chn | 0) == 2;
    if ($6) {
      var $j_044 = 255;
      label = 5;
      break;
    } else {
      label = 6;
      break;
    }
   case 5:
    var $j_044;
    var $7 = $wsamp_s + ($sblock << 10) + ($j_044 << 2) | 0;
    var $8 = HEAPF32[$7 >> 2];
    var $9 = $wsamp_s + 3072 + ($sblock << 10) + ($j_044 << 2) | 0;
    var $10 = HEAPF32[$9 >> 2];
    var $11 = $8 + $10;
    var $12 = $11 * .7071067690849304;
    HEAPF32[$7 >> 2] = $12;
    var $13 = $8 - $10;
    var $14 = $13 * .7071067690849304;
    HEAPF32[$9 >> 2] = $14;
    var $15 = $j_044 - 1 | 0;
    var $16 = ($j_044 | 0) > 0;
    if ($16) {
      var $j_044 = $15;
      label = 5;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    var $17 = $wsamp_s + ($sblock << 10) | 0;
    var $18 = HEAPF32[$17 >> 2];
    var $19 = $fftenergy_s + $sblock * 516 | 0;
    var $20 = $18 * $18;
    HEAPF32[$19 >> 2] = $20;
    var $j_143 = 127;
    label = 7;
    break;
   case 7:
    var $j_143;
    var $22 = 128 - $j_143 | 0;
    var $23 = $wsamp_s + ($sblock << 10) + ($22 << 2) | 0;
    var $24 = HEAPF32[$23 >> 2];
    var $25 = $j_143 + 128 | 0;
    var $26 = $wsamp_s + ($sblock << 10) + ($25 << 2) | 0;
    var $27 = HEAPF32[$26 >> 2];
    var $28 = $24 * $24;
    var $29 = $27 * $27;
    var $30 = $28 + $29;
    var $31 = $30 * .5;
    var $32 = $fftenergy_s + $sblock * 516 + ($22 << 2) | 0;
    HEAPF32[$32 >> 2] = $31;
    var $33 = $j_143 - 1 | 0;
    var $34 = ($j_143 | 0) > 0;
    if ($34) {
      var $j_143 = $33;
      label = 7;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    return;
  }
}
function _vbrpsy_compute_masking_s($gfc, $fftenergy_s, $eb, $thr, $chn, $sblock) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 576 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $max = __stackBase__;
    var $avg = __stackBase__ + 256;
    var $mask_idx_s = __stackBase__ + 512;
    var $1 = $gfc + 85796 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $max;
    for (var $$dest = $3 >> 2, $$stop = $$dest + 64; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $4 = $avg;
    for (var $$dest = $4 >> 2, $$stop = $$dest + 64; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $5 = $2 + 4308 | 0;
    var $6 = HEAP32[$5 >> 2];
    var $7 = ($6 | 0) > 0;
    if ($7) {
      var $b_0128 = 0;
      var $j_0129 = 0;
      label = 3;
      break;
    } else {
      label = 7;
      break;
    }
   case 3:
    var $j_0129;
    var $b_0128;
    var $8 = $2 + 3876 + ($b_0128 << 2) | 0;
    var $9 = HEAP32[$8 >> 2];
    var $10 = ($9 | 0) > 0;
    if ($10) {
      var $m_0118 = 0;
      var $ebb_0119 = 0;
      var $j_1120 = $j_0129;
      var $i_0121 = 0;
      label = 4;
      break;
    } else {
      var $m_0_lcssa = 0;
      var $ebb_0_lcssa = 0;
      var $j_1_lcssa = $j_0129;
      label = 6;
      break;
    }
   case 4:
    var $i_0121;
    var $j_1120;
    var $ebb_0119;
    var $m_0118;
    var $11 = $fftenergy_s + $sblock * 516 + ($j_1120 << 2) | 0;
    var $12 = HEAPF32[$11 >> 2];
    var $13 = $ebb_0119 + $12;
    var $14 = $m_0118 < $12;
    var $m_1 = $14 ? $12 : $m_0118;
    var $15 = $i_0121 + 1 | 0;
    var $16 = $j_1120 + 1 | 0;
    var $exitcond142 = ($15 | 0) == ($9 | 0);
    if ($exitcond142) {
      label = 5;
      break;
    } else {
      var $m_0118 = $m_1;
      var $ebb_0119 = $13;
      var $j_1120 = $16;
      var $i_0121 = $15;
      label = 4;
      break;
    }
   case 5:
    var $17 = $j_0129 + $9 | 0;
    var $m_0_lcssa = $m_1;
    var $ebb_0_lcssa = $13;
    var $j_1_lcssa = $17;
    label = 6;
    break;
   case 6:
    var $j_1_lcssa;
    var $ebb_0_lcssa;
    var $m_0_lcssa;
    var $19 = $eb + ($b_0128 << 2) | 0;
    HEAPF32[$19 >> 2] = $ebb_0_lcssa;
    var $20 = $max + ($b_0128 << 2) | 0;
    HEAPF32[$20 >> 2] = $m_0_lcssa;
    var $21 = $2 + 2672 + ($b_0128 << 2) | 0;
    var $22 = HEAPF32[$21 >> 2];
    var $23 = $ebb_0_lcssa * $22;
    var $24 = $avg + ($b_0128 << 2) | 0;
    HEAPF32[$24 >> 2] = $23;
    var $25 = $b_0128 + 1 | 0;
    var $26 = HEAP32[$5 >> 2];
    var $27 = ($25 | 0) < ($26 | 0);
    if ($27) {
      var $b_0128 = $25;
      var $j_0129 = $j_1_lcssa;
      label = 3;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    var $28 = $max | 0;
    var $29 = $avg | 0;
    var $30 = $mask_idx_s | 0;
    _vbrpsy_calc_mask_index_s($gfc, $28, $29, $30);
    var $31 = HEAP32[$5 >> 2];
    var $32 = ($31 | 0) > 0;
    if ($32) {
      label = 8;
      break;
    } else {
      var $b_299 = 0;
      label = 22;
      break;
    }
   case 8:
    var $33 = $gfc + 84904 | 0;
    var $34 = $2 + 4316 | 0;
    var $b_1113 = 0;
    var $j_2114 = 0;
    label = 10;
    break;
   case 9:
    var $35 = ($117 | 0) < 64;
    if ($35) {
      var $b_299 = $117;
      label = 22;
      break;
    } else {
      label = 23;
      break;
    }
   case 10:
    var $j_2114;
    var $b_1113;
    var $37 = $2 + 3364 + ($b_1113 << 3) | 0;
    var $38 = HEAP32[$37 >> 2];
    var $39 = $2 + 3364 + ($b_1113 << 3) + 4 | 0;
    var $40 = HEAP32[$39 >> 2];
    var $41 = $mask_idx_s + $b_1113 | 0;
    var $42 = HEAP8[$41];
    var $43 = $42 & 255;
    var $44 = _mask_add_delta($43);
    var $45 = $2 + 2160 + ($b_1113 << 2) | 0;
    var $46 = HEAPF32[$45 >> 2];
    var $47 = HEAPF32[$33 >> 2];
    var $48 = $46 * $47;
    var $49 = $mask_idx_s + $38 | 0;
    var $50 = HEAP8[$49];
    var $51 = $50 & 255;
    var $52 = HEAP32[$34 >> 2];
    var $53 = $52 + ($j_2114 << 2) | 0;
    var $54 = HEAPF32[$53 >> 2];
    var $55 = $eb + ($38 << 2) | 0;
    var $56 = HEAPF32[$55 >> 2];
    var $57 = $54 * $56;
    var $58 = 5249776 + ($51 << 2) | 0;
    var $59 = HEAPF32[$58 >> 2];
    var $60 = $57 * $59;
    var $j_3100 = $j_2114 + 1 | 0;
    var $kk_0101 = $38 + 1 | 0;
    var $61 = ($kk_0101 | 0) > ($40 | 0);
    if ($61) {
      var $dd_0_lcssa = $51;
      var $dd_n_0_lcssa = 2;
      var $ecb_0_lcssa = $60;
      var $j_3_lcssa = $j_3100;
      label = 13;
      break;
    } else {
      var $dd_0102 = $51;
      var $dd_n_0103 = 1;
      var $ecb_0104 = $60;
      var $j_3105 = $j_3100;
      var $kk_0106 = $kk_0101;
      label = 11;
      break;
    }
   case 11:
    var $kk_0106;
    var $j_3105;
    var $ecb_0104;
    var $dd_n_0103;
    var $dd_0102;
    var $62 = $mask_idx_s + $kk_0106 | 0;
    var $63 = HEAP8[$62];
    var $64 = $63 & 255;
    var $65 = $64 + $dd_0102 | 0;
    var $66 = $dd_n_0103 + 1 | 0;
    var $67 = HEAP32[$34 >> 2];
    var $68 = $67 + ($j_3105 << 2) | 0;
    var $69 = HEAPF32[$68 >> 2];
    var $70 = $eb + ($kk_0106 << 2) | 0;
    var $71 = HEAPF32[$70 >> 2];
    var $72 = $69 * $71;
    var $73 = 5249776 + ($64 << 2) | 0;
    var $74 = HEAPF32[$73 >> 2];
    var $75 = $72 * $74;
    var $76 = $kk_0106 - $b_1113 | 0;
    var $77 = _vbrpsy_mask_add($ecb_0104, $75, $76, $44);
    var $j_3 = $j_3105 + 1 | 0;
    var $kk_0 = $kk_0106 + 1 | 0;
    var $78 = ($kk_0 | 0) > ($40 | 0);
    if ($78) {
      label = 12;
      break;
    } else {
      var $dd_0102 = $65;
      var $dd_n_0103 = $66;
      var $ecb_0104 = $77;
      var $j_3105 = $j_3;
      var $kk_0106 = $kk_0;
      label = 11;
      break;
    }
   case 12:
    var $phitmp = $66 << 1;
    var $dd_0_lcssa = $65;
    var $dd_n_0_lcssa = $phitmp;
    var $ecb_0_lcssa = $77;
    var $j_3_lcssa = $j_3;
    label = 13;
    break;
   case 13:
    var $j_3_lcssa;
    var $ecb_0_lcssa;
    var $dd_n_0_lcssa;
    var $dd_0_lcssa;
    var $80 = $dd_0_lcssa << 1;
    var $81 = $80 | 1;
    var $82 = ($81 | 0) / ($dd_n_0_lcssa | 0) & -1;
    var $83 = 5249776 + ($82 << 2) | 0;
    var $84 = HEAPF32[$83 >> 2];
    var $85 = $84 * .5;
    var $86 = $ecb_0_lcssa * $85;
    var $87 = $thr + ($b_1113 << 2) | 0;
    HEAPF32[$87 >> 2] = $86;
    var $88 = $gfc + 23612 + ($chn << 8) + ($b_1113 << 2) | 0;
    var $89 = HEAPF32[$88 >> 2];
    var $90 = $gfc + 24636 + ($chn << 8) + ($b_1113 << 2) | 0;
    HEAPF32[$90 >> 2] = $89;
    HEAPF32[$88 >> 2] = $86;
    var $91 = $max + ($b_1113 << 2) | 0;
    var $92 = HEAPF32[$91 >> 2];
    var $93 = $2 + 2416 + ($b_1113 << 2) | 0;
    var $94 = HEAPF32[$93 >> 2];
    var $95 = $92 * $94;
    var $96 = $85 * $95;
    var $97 = HEAPF32[$87 >> 2];
    var $98 = $97 > $96;
    if ($98) {
      label = 14;
      break;
    } else {
      label = 15;
      break;
    }
   case 14:
    HEAPF32[$87 >> 2] = $96;
    label = 15;
    break;
   case 15:
    var $101 = $48 > 1;
    if ($101) {
      label = 16;
      break;
    } else {
      label = 17;
      break;
    }
   case 16:
    var $103 = HEAPF32[$87 >> 2];
    var $104 = $48 * $103;
    HEAPF32[$87 >> 2] = $104;
    label = 17;
    break;
   case 17:
    var $106 = HEAPF32[$87 >> 2];
    var $107 = $eb + ($b_1113 << 2) | 0;
    var $108 = HEAPF32[$107 >> 2];
    var $109 = $106 > $108;
    if ($109) {
      label = 18;
      break;
    } else {
      label = 19;
      break;
    }
   case 18:
    HEAPF32[$87 >> 2] = $108;
    label = 19;
    break;
   case 19:
    var $112 = $48 < 1;
    if ($112) {
      label = 20;
      break;
    } else {
      label = 21;
      break;
    }
   case 20:
    var $114 = HEAPF32[$87 >> 2];
    var $115 = $48 * $114;
    HEAPF32[$87 >> 2] = $115;
    label = 21;
    break;
   case 21:
    var $117 = $b_1113 + 1 | 0;
    var $118 = HEAP32[$5 >> 2];
    var $119 = ($117 | 0) < ($118 | 0);
    if ($119) {
      var $b_1113 = $117;
      var $j_2114 = $j_3_lcssa;
      label = 10;
      break;
    } else {
      label = 9;
      break;
    }
   case 22:
    var $b_299;
    var $120 = $eb + ($b_299 << 2) | 0;
    HEAPF32[$120 >> 2] = 0;
    var $121 = $thr + ($b_299 << 2) | 0;
    HEAPF32[$121 >> 2] = 0;
    var $122 = $b_299 + 1 | 0;
    var $exitcond = ($122 | 0) == 64;
    if ($exitcond) {
      label = 23;
      break;
    } else {
      var $b_299 = $122;
      label = 22;
      break;
    }
   case 23:
    STACKTOP = __stackBase__;
    return;
  }
}
_vbrpsy_compute_masking_s["X"] = 1;
function _convert_partition2scalefac_s($gfc, $eb, $thr, $chn, $sblock) {
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 104 | 0;
  var $enn = __stackBase__;
  var $thm = __stackBase__ + 52;
  _convert_partition2scalefac(HEAP32[$gfc + 85796 >> 2] + 2160 | 0, $eb, $thr, $enn | 0, $thm | 0);
  HEAPF32[$gfc + 26636 + $chn * 244 + 88 + ($sblock << 2) >> 2] = HEAPF32[$enn >> 2];
  HEAPF32[$gfc + 25660 + $chn * 244 + 88 + ($sblock << 2) >> 2] = HEAPF32[$thm >> 2];
  HEAPF32[$gfc + 26636 + $chn * 244 + 100 + ($sblock << 2) >> 2] = HEAPF32[$enn + 4 >> 2];
  HEAPF32[$gfc + 25660 + $chn * 244 + 100 + ($sblock << 2) >> 2] = HEAPF32[$thm + 4 >> 2];
  HEAPF32[$gfc + 26636 + $chn * 244 + 112 + ($sblock << 2) >> 2] = HEAPF32[$enn + 8 >> 2];
  HEAPF32[$gfc + 25660 + $chn * 244 + 112 + ($sblock << 2) >> 2] = HEAPF32[$thm + 8 >> 2];
  HEAPF32[$gfc + 26636 + $chn * 244 + 124 + ($sblock << 2) >> 2] = HEAPF32[$enn + 12 >> 2];
  HEAPF32[$gfc + 25660 + $chn * 244 + 124 + ($sblock << 2) >> 2] = HEAPF32[$thm + 12 >> 2];
  HEAPF32[$gfc + 26636 + $chn * 244 + 136 + ($sblock << 2) >> 2] = HEAPF32[$enn + 16 >> 2];
  HEAPF32[$gfc + 25660 + $chn * 244 + 136 + ($sblock << 2) >> 2] = HEAPF32[$thm + 16 >> 2];
  HEAPF32[$gfc + 26636 + $chn * 244 + 148 + ($sblock << 2) >> 2] = HEAPF32[$enn + 20 >> 2];
  HEAPF32[$gfc + 25660 + $chn * 244 + 148 + ($sblock << 2) >> 2] = HEAPF32[$thm + 20 >> 2];
  HEAPF32[$gfc + 26636 + $chn * 244 + 160 + ($sblock << 2) >> 2] = HEAPF32[$enn + 24 >> 2];
  HEAPF32[$gfc + 25660 + $chn * 244 + 160 + ($sblock << 2) >> 2] = HEAPF32[$thm + 24 >> 2];
  HEAPF32[$gfc + 26636 + $chn * 244 + 172 + ($sblock << 2) >> 2] = HEAPF32[$enn + 28 >> 2];
  HEAPF32[$gfc + 25660 + $chn * 244 + 172 + ($sblock << 2) >> 2] = HEAPF32[$thm + 28 >> 2];
  HEAPF32[$gfc + 26636 + $chn * 244 + 184 + ($sblock << 2) >> 2] = HEAPF32[$enn + 32 >> 2];
  HEAPF32[$gfc + 25660 + $chn * 244 + 184 + ($sblock << 2) >> 2] = HEAPF32[$thm + 32 >> 2];
  HEAPF32[$gfc + 26636 + $chn * 244 + 196 + ($sblock << 2) >> 2] = HEAPF32[$enn + 36 >> 2];
  HEAPF32[$gfc + 25660 + $chn * 244 + 196 + ($sblock << 2) >> 2] = HEAPF32[$thm + 36 >> 2];
  HEAPF32[$gfc + 26636 + $chn * 244 + 208 + ($sblock << 2) >> 2] = HEAPF32[$enn + 40 >> 2];
  HEAPF32[$gfc + 25660 + $chn * 244 + 208 + ($sblock << 2) >> 2] = HEAPF32[$thm + 40 >> 2];
  HEAPF32[$gfc + 26636 + $chn * 244 + 220 + ($sblock << 2) >> 2] = HEAPF32[$enn + 44 >> 2];
  HEAPF32[$gfc + 25660 + $chn * 244 + 220 + ($sblock << 2) >> 2] = HEAPF32[$thm + 44 >> 2];
  HEAPF32[$gfc + 26636 + $chn * 244 + 232 + ($sblock << 2) >> 2] = HEAPF32[$enn + 48 >> 2];
  HEAPF32[$gfc + 25660 + $chn * 244 + 232 + ($sblock << 2) >> 2] = HEAPF32[$thm + 48 >> 2];
  STACKTOP = __stackBase__;
  return;
}
_convert_partition2scalefac_s["X"] = 1;
function _NS_INTERP($x, $y, $r) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $r < 1;
    if ($1) {
      label = 3;
      break;
    } else {
      var $_0 = $x;
      label = 6;
      break;
    }
   case 3:
    var $3 = $r > 0;
    if ($3) {
      label = 4;
      break;
    } else {
      var $_0 = $y;
      label = 6;
      break;
    }
   case 4:
    var $5 = $y > 0;
    if ($5) {
      label = 5;
      break;
    } else {
      var $_0 = 0;
      label = 6;
      break;
    }
   case 5:
    var $7 = $x / $y;
    var $8 = Math.pow($7, $r);
    var $9 = $8 * $y;
    var $_0 = $9;
    label = 6;
    break;
   case 6:
    var $_0;
    return $_0;
  }
}
function _pecalc_s($mr, $masking_lower) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $sb_019 = 0;
    var $pe_s_020 = 309.07000732421875;
    label = 3;
    break;
   case 3:
    var $pe_s_020;
    var $sb_019;
    var $2 = 5291432 + ($sb_019 << 2) | 0;
    var $3 = $mr + 88 + $sb_019 * 12 | 0;
    var $4 = HEAPF32[$3 >> 2];
    var $5 = $4 > 0;
    if ($5) {
      label = 4;
      break;
    } else {
      var $pe_s_2 = $pe_s_020;
      label = 8;
      break;
    }
   case 4:
    var $7 = $4 * $masking_lower;
    var $8 = $mr + 332 + $sb_019 * 12 | 0;
    var $9 = HEAPF32[$8 >> 2];
    var $10 = $9 > $7;
    if ($10) {
      label = 5;
      break;
    } else {
      var $pe_s_2 = $pe_s_020;
      label = 8;
      break;
    }
   case 5:
    var $12 = $7 * 1e10;
    var $13 = $9 > $12;
    var $14 = HEAPF32[$2 >> 2];
    var $15 = $14;
    if ($13) {
      label = 6;
      break;
    } else {
      label = 7;
      break;
    }
   case 6:
    var $17 = $15 * 23.02585092994046;
    var $18 = $pe_s_020;
    var $19 = $18 + $17;
    var $20 = $19;
    var $pe_s_2 = $20;
    label = 8;
    break;
   case 7:
    var $22 = $9 / $7;
    var $23 = _fast_log2($22);
    var $24 = $23;
    var $25 = $24 * .30102999566398114;
    var $26 = $15 * $25;
    var $27 = $pe_s_020;
    var $28 = $27 + $26;
    var $29 = $28;
    var $pe_s_2 = $29;
    label = 8;
    break;
   case 8:
    var $pe_s_2;
    var $31 = $mr + 88 + $sb_019 * 12 + 4 | 0;
    var $32 = HEAPF32[$31 >> 2];
    var $33 = $32 > 0;
    if ($33) {
      label = 10;
      break;
    } else {
      var $pe_s_2_1 = $pe_s_2;
      label = 14;
      break;
    }
   case 9:
    return $pe_s_2_2;
   case 10:
    var $36 = $32 * $masking_lower;
    var $37 = $mr + 332 + $sb_019 * 12 + 4 | 0;
    var $38 = HEAPF32[$37 >> 2];
    var $39 = $38 > $36;
    if ($39) {
      label = 11;
      break;
    } else {
      var $pe_s_2_1 = $pe_s_2;
      label = 14;
      break;
    }
   case 11:
    var $41 = $36 * 1e10;
    var $42 = $38 > $41;
    var $43 = HEAPF32[$2 >> 2];
    var $44 = $43;
    if ($42) {
      label = 13;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    var $46 = $38 / $36;
    var $47 = _fast_log2($46);
    var $48 = $47;
    var $49 = $48 * .30102999566398114;
    var $50 = $44 * $49;
    var $51 = $pe_s_2;
    var $52 = $51 + $50;
    var $53 = $52;
    var $pe_s_2_1 = $53;
    label = 14;
    break;
   case 13:
    var $55 = $44 * 23.02585092994046;
    var $56 = $pe_s_2;
    var $57 = $56 + $55;
    var $58 = $57;
    var $pe_s_2_1 = $58;
    label = 14;
    break;
   case 14:
    var $pe_s_2_1;
    var $60 = $mr + 88 + $sb_019 * 12 + 8 | 0;
    var $61 = HEAPF32[$60 >> 2];
    var $62 = $61 > 0;
    if ($62) {
      label = 15;
      break;
    } else {
      var $pe_s_2_2 = $pe_s_2_1;
      label = 19;
      break;
    }
   case 15:
    var $64 = $61 * $masking_lower;
    var $65 = $mr + 332 + $sb_019 * 12 + 8 | 0;
    var $66 = HEAPF32[$65 >> 2];
    var $67 = $66 > $64;
    if ($67) {
      label = 16;
      break;
    } else {
      var $pe_s_2_2 = $pe_s_2_1;
      label = 19;
      break;
    }
   case 16:
    var $69 = $64 * 1e10;
    var $70 = $66 > $69;
    var $71 = HEAPF32[$2 >> 2];
    var $72 = $71;
    if ($70) {
      label = 18;
      break;
    } else {
      label = 17;
      break;
    }
   case 17:
    var $74 = $66 / $64;
    var $75 = _fast_log2($74);
    var $76 = $75;
    var $77 = $76 * .30102999566398114;
    var $78 = $72 * $77;
    var $79 = $pe_s_2_1;
    var $80 = $79 + $78;
    var $81 = $80;
    var $pe_s_2_2 = $81;
    label = 19;
    break;
   case 18:
    var $83 = $72 * 23.02585092994046;
    var $84 = $pe_s_2_1;
    var $85 = $84 + $83;
    var $86 = $85;
    var $pe_s_2_2 = $86;
    label = 19;
    break;
   case 19:
    var $pe_s_2_2;
    var $88 = $sb_019 + 1 | 0;
    var $exitcond = ($88 | 0) == 12;
    if ($exitcond) {
      label = 9;
      break;
    } else {
      var $sb_019 = $88;
      var $pe_s_020 = $pe_s_2_2;
      label = 3;
      break;
    }
  }
}
_pecalc_s["X"] = 1;
function _pecalc_l($mr, $masking_lower) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $sb_014 = 0;
    var $pe_l_015 = 281.0574951171875;
    label = 3;
    break;
   case 3:
    var $pe_l_015;
    var $sb_014;
    var $2 = $mr + ($sb_014 << 2) | 0;
    var $3 = HEAPF32[$2 >> 2];
    var $4 = $3 > 0;
    if ($4) {
      label = 4;
      break;
    } else {
      var $pe_l_1 = $pe_l_015;
      label = 8;
      break;
    }
   case 4:
    var $6 = $3 * $masking_lower;
    var $7 = $mr + 244 + ($sb_014 << 2) | 0;
    var $8 = HEAPF32[$7 >> 2];
    var $9 = $8 > $6;
    if ($9) {
      label = 5;
      break;
    } else {
      var $pe_l_1 = $pe_l_015;
      label = 8;
      break;
    }
   case 5:
    var $11 = $6 * 1e10;
    var $12 = $8 > $11;
    var $13 = 5291480 + ($sb_014 << 2) | 0;
    var $14 = HEAPF32[$13 >> 2];
    var $15 = $14;
    if ($12) {
      label = 6;
      break;
    } else {
      label = 7;
      break;
    }
   case 6:
    var $17 = $15 * 23.02585092994046;
    var $18 = $pe_l_015;
    var $19 = $18 + $17;
    var $20 = $19;
    var $pe_l_1 = $20;
    label = 8;
    break;
   case 7:
    var $22 = $8 / $6;
    var $23 = _fast_log2($22);
    var $24 = $23;
    var $25 = $24 * .30102999566398114;
    var $26 = $15 * $25;
    var $27 = $pe_l_015;
    var $28 = $27 + $26;
    var $29 = $28;
    var $pe_l_1 = $29;
    label = 8;
    break;
   case 8:
    var $pe_l_1;
    var $31 = $sb_014 + 1 | 0;
    var $exitcond = ($31 | 0) == 21;
    if ($exitcond) {
      label = 9;
      break;
    } else {
      var $sb_014 = $31;
      var $pe_l_015 = $pe_l_1;
      label = 3;
      break;
    }
   case 9:
    return $pe_l_1;
  }
}
function _psymodel_init($gfp) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 768 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $bval = __stackBase__;
    var $bval_width = __stackBase__ + 256;
    var $norm = __stackBase__ + 512;
    var $1 = $gfp + 288 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $2 + 16 | 0;
    var $4 = $2 + 64 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = $5 | 0;
    var $7 = $2 + 280 | 0;
    var $8 = HEAPF32[$7 >> 2];
    var $9 = -$8;
    var $10 = $2 + 85796 | 0;
    var $11 = HEAP32[$10 >> 2];
    var $12 = ($11 | 0) == 0;
    if ($12) {
      label = 3;
      break;
    } else {
      var $_0 = 0;
      label = 62;
      break;
    }
   case 3:
    var $14 = $norm;
    for (var $$dest = $14 >> 2, $$stop = $$dest + 64; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $15 = _calloc(1, 6504);
    var $16 = $15;
    HEAP32[$10 >> 2] = $16;
    var $17 = $gfp + 144 | 0;
    var $18 = HEAP32[$17 >> 2];
    var $19 = $15 + 6500 | 0;
    var $20 = $19;
    HEAP32[$20 >> 2] = $18;
    var $21 = $2 + 27800 | 0;
    HEAP32[$21 >> 2] = 0;
    var $22 = $2 + 27796 | 0;
    HEAP32[$22 >> 2] = 0;
    var $i_0343 = 0;
    label = 4;
    break;
   case 4:
    var $i_0343;
    var $j_0335 = 0;
    label = 5;
    break;
   case 5:
    var $j_0335;
    var $24 = $2 + 21564 + ($i_0343 << 8) + ($j_0335 << 2) | 0;
    HEAPF32[$24 >> 2] = 0x56bc7600000000000;
    var $25 = $2 + 22588 + ($i_0343 << 8) + ($j_0335 << 2) | 0;
    HEAPF32[$25 >> 2] = 0x56bc7600000000000;
    var $26 = $2 + 24636 + ($i_0343 << 8) + ($j_0335 << 2) | 0;
    HEAPF32[$26 >> 2] = 1;
    var $27 = $2 + 23612 + ($i_0343 << 8) + ($j_0335 << 2) | 0;
    HEAPF32[$27 >> 2] = 1;
    var $28 = $j_0335 + 1 | 0;
    var $exitcond356 = ($28 | 0) == 64;
    if ($exitcond356) {
      var $sb_0337 = 0;
      label = 6;
      break;
    } else {
      var $j_0335 = $28;
      label = 5;
      break;
    }
   case 6:
    var $sb_0337;
    var $29 = $2 + 26636 + $i_0343 * 244 + ($sb_0337 << 2) | 0;
    HEAPF32[$29 >> 2] = 0x56bc7600000000000;
    var $30 = $2 + 25660 + $i_0343 * 244 + ($sb_0337 << 2) | 0;
    HEAPF32[$30 >> 2] = 0x56bc7600000000000;
    var $31 = $sb_0337 + 1 | 0;
    var $exitcond357 = ($31 | 0) == 22;
    if ($exitcond357) {
      label = 7;
      break;
    } else {
      var $sb_0337 = $31;
      label = 6;
      break;
    }
   case 7:
    var $32 = $2 + 27780 + ($i_0343 << 2) | 0;
    var $j_1341 = 0;
    label = 8;
    break;
   case 8:
    var $j_1341;
    var $33 = $2 + 26636 + $i_0343 * 244 + 88 + ($j_1341 << 2) | 0;
    HEAPF32[$33 >> 2] = 0x56bc7600000000000;
    var $34 = $2 + 25660 + $i_0343 * 244 + 88 + ($j_1341 << 2) | 0;
    HEAPF32[$34 >> 2] = 0x56bc7600000000000;
    var $35 = $2 + 26636 + $i_0343 * 244 + 100 + ($j_1341 << 2) | 0;
    HEAPF32[$35 >> 2] = 0x56bc7600000000000;
    var $36 = $2 + 25660 + $i_0343 * 244 + 100 + ($j_1341 << 2) | 0;
    HEAPF32[$36 >> 2] = 0x56bc7600000000000;
    var $37 = $2 + 26636 + $i_0343 * 244 + 112 + ($j_1341 << 2) | 0;
    HEAPF32[$37 >> 2] = 0x56bc7600000000000;
    var $38 = $2 + 25660 + $i_0343 * 244 + 112 + ($j_1341 << 2) | 0;
    HEAPF32[$38 >> 2] = 0x56bc7600000000000;
    var $39 = $2 + 26636 + $i_0343 * 244 + 124 + ($j_1341 << 2) | 0;
    HEAPF32[$39 >> 2] = 0x56bc7600000000000;
    var $40 = $2 + 25660 + $i_0343 * 244 + 124 + ($j_1341 << 2) | 0;
    HEAPF32[$40 >> 2] = 0x56bc7600000000000;
    var $41 = $2 + 26636 + $i_0343 * 244 + 136 + ($j_1341 << 2) | 0;
    HEAPF32[$41 >> 2] = 0x56bc7600000000000;
    var $42 = $2 + 25660 + $i_0343 * 244 + 136 + ($j_1341 << 2) | 0;
    HEAPF32[$42 >> 2] = 0x56bc7600000000000;
    var $43 = $2 + 26636 + $i_0343 * 244 + 148 + ($j_1341 << 2) | 0;
    HEAPF32[$43 >> 2] = 0x56bc7600000000000;
    var $44 = $2 + 25660 + $i_0343 * 244 + 148 + ($j_1341 << 2) | 0;
    HEAPF32[$44 >> 2] = 0x56bc7600000000000;
    var $45 = $2 + 26636 + $i_0343 * 244 + 160 + ($j_1341 << 2) | 0;
    HEAPF32[$45 >> 2] = 0x56bc7600000000000;
    var $46 = $2 + 25660 + $i_0343 * 244 + 160 + ($j_1341 << 2) | 0;
    HEAPF32[$46 >> 2] = 0x56bc7600000000000;
    var $47 = $2 + 26636 + $i_0343 * 244 + 172 + ($j_1341 << 2) | 0;
    HEAPF32[$47 >> 2] = 0x56bc7600000000000;
    var $48 = $2 + 25660 + $i_0343 * 244 + 172 + ($j_1341 << 2) | 0;
    HEAPF32[$48 >> 2] = 0x56bc7600000000000;
    var $49 = $2 + 26636 + $i_0343 * 244 + 184 + ($j_1341 << 2) | 0;
    HEAPF32[$49 >> 2] = 0x56bc7600000000000;
    var $50 = $2 + 25660 + $i_0343 * 244 + 184 + ($j_1341 << 2) | 0;
    HEAPF32[$50 >> 2] = 0x56bc7600000000000;
    var $51 = $2 + 26636 + $i_0343 * 244 + 196 + ($j_1341 << 2) | 0;
    HEAPF32[$51 >> 2] = 0x56bc7600000000000;
    var $52 = $2 + 25660 + $i_0343 * 244 + 196 + ($j_1341 << 2) | 0;
    HEAPF32[$52 >> 2] = 0x56bc7600000000000;
    var $53 = $2 + 26636 + $i_0343 * 244 + 208 + ($j_1341 << 2) | 0;
    HEAPF32[$53 >> 2] = 0x56bc7600000000000;
    var $54 = $2 + 25660 + $i_0343 * 244 + 208 + ($j_1341 << 2) | 0;
    HEAPF32[$54 >> 2] = 0x56bc7600000000000;
    var $55 = $2 + 26636 + $i_0343 * 244 + 220 + ($j_1341 << 2) | 0;
    HEAPF32[$55 >> 2] = 0x56bc7600000000000;
    var $56 = $2 + 25660 + $i_0343 * 244 + 220 + ($j_1341 << 2) | 0;
    HEAPF32[$56 >> 2] = 0x56bc7600000000000;
    var $57 = $2 + 26636 + $i_0343 * 244 + 232 + ($j_1341 << 2) | 0;
    HEAPF32[$57 >> 2] = 0x56bc7600000000000;
    var $58 = $2 + 25660 + $i_0343 * 244 + 232 + ($j_1341 << 2) | 0;
    HEAPF32[$58 >> 2] = 0x56bc7600000000000;
    HEAP32[$32 >> 2] = 0;
    var $59 = $j_1341 + 1 | 0;
    var $exitcond359 = ($59 | 0) == 3;
    if ($exitcond359) {
      label = 9;
      break;
    } else {
      var $j_1341 = $59;
      label = 8;
      break;
    }
   case 9:
    var $60 = $2 + 27636 + $i_0343 * 36 | 0;
    HEAPF32[$60 >> 2] = 10;
    var $61 = $2 + 27636 + $i_0343 * 36 + 4 | 0;
    HEAPF32[$61 >> 2] = 10;
    var $62 = $2 + 27636 + $i_0343 * 36 + 8 | 0;
    HEAPF32[$62 >> 2] = 10;
    var $63 = $2 + 27636 + $i_0343 * 36 + 12 | 0;
    HEAPF32[$63 >> 2] = 10;
    var $64 = $2 + 27636 + $i_0343 * 36 + 16 | 0;
    HEAPF32[$64 >> 2] = 10;
    var $65 = $2 + 27636 + $i_0343 * 36 + 20 | 0;
    HEAPF32[$65 >> 2] = 10;
    var $66 = $2 + 27636 + $i_0343 * 36 + 24 | 0;
    HEAPF32[$66 >> 2] = 10;
    var $67 = $2 + 27636 + $i_0343 * 36 + 28 | 0;
    HEAPF32[$67 >> 2] = 10;
    var $68 = $2 + 27636 + $i_0343 * 36 + 32 | 0;
    HEAPF32[$68 >> 2] = 10;
    var $69 = $i_0343 + 1 | 0;
    var $exitcond361 = ($69 | 0) == 4;
    if ($exitcond361) {
      label = 10;
      break;
    } else {
      var $i_0343 = $69;
      label = 4;
      break;
    }
   case 10:
    var $71 = $2 + 27616 | 0;
    HEAPF32[$71 >> 2] = 0;
    var $72 = $2 + 27612 | 0;
    HEAPF32[$72 >> 2] = 0;
    var $73 = $15;
    var $74 = $2 + 21360 | 0;
    _init_numline($73, $6, 1024, 576, 22, $74);
    var $75 = $bval | 0;
    var $76 = $bval_width | 0;
    _compute_bark_values($73, $6, 1024, $75, $76);
    var $77 = $15 + 2148 | 0;
    var $78 = $77;
    var $79 = HEAP32[$78 >> 2];
    var $80 = ($79 | 0) > 0;
    if ($80) {
      label = 11;
      break;
    } else {
      var $_lcssa327 = $79;
      label = 15;
      break;
    }
   case 11:
    var $81 = HEAP32[$78 >> 2];
    var $i_1328 = 0;
    label = 12;
    break;
   case 12:
    var $i_1328;
    var $83 = $bval + ($i_1328 << 2) | 0;
    var $84 = HEAPF32[$83 >> 2];
    var $85 = $84 < 13;
    if ($85) {
      var $snr_0 = 0;
      label = 14;
      break;
    } else {
      label = 13;
      break;
    }
   case 13:
    var $88 = 0;
    var $89 = $88 / 11;
    var $91 = 0;
    var $92 = $91 / 11;
    var $93 = $89 + $92;
    var $94 = $93;
    var $snr_0 = $94;
    label = 14;
    break;
   case 14:
    var $snr_0;
    var $96 = $snr_0 / 10;
    var $97 = Math.pow(10, $96);
    var $98 = $97;
    var $99 = $norm + ($i_1328 << 2) | 0;
    HEAPF32[$99 >> 2] = $98;
    var $100 = $i_1328 + 1 | 0;
    var $101 = ($100 | 0) < ($81 | 0);
    if ($101) {
      var $i_1328 = $100;
      label = 12;
      break;
    } else {
      var $_lcssa327 = $81;
      label = 15;
      break;
    }
   case 15:
    var $_lcssa327;
    var $102 = $15 + 2156 | 0;
    var $103 = $102;
    var $104 = $15 + 1204 | 0;
    var $105 = $104;
    var $106 = $104;
    var $107 = $norm | 0;
    var $108 = _init_s3_values($103, $106, $_lcssa327, $75, $76, $107);
    var $109 = ($108 | 0) == 0;
    if ($109) {
      label = 16;
      break;
    } else {
      var $_0 = $108;
      label = 62;
      break;
    }
   case 16:
    var $110 = HEAP32[$78 >> 2];
    var $111 = ($110 | 0) > 0;
    if ($111) {
      label = 17;
      break;
    } else {
      label = 23;
      break;
    }
   case 17:
    var $112 = $15 + 1716 | 0;
    var $113 = $112;
    var $114 = $2 + 85792 | 0;
    var $115 = $9;
    var $116 = $15 + 256 | 0;
    var $117 = $116;
    var $j_3323 = 0;
    var $i_2324 = 0;
    label = 18;
    break;
   case 18:
    var $i_2324;
    var $j_3323;
    var $118 = $113 + ($i_2324 << 2) | 0;
    var $119 = HEAP32[$118 >> 2];
    var $120 = ($119 | 0) > 0;
    if ($120) {
      label = 19;
      break;
    } else {
      var $x_0_lcssa = 9.999999933815813e+36;
      var $j_4_lcssa = $j_3323;
      label = 22;
      break;
    }
   case 19:
    var $121 = HEAP32[$118 >> 2];
    var $122 = ($121 | 0) > 1;
    var $smax355 = $122 ? $121 : 1;
    var $k_0314 = 0;
    var $x_0315 = 1e+37;
    var $j_4316 = $j_3323;
    var $124 = $119;
    label = 20;
    break;
   case 20:
    var $124;
    var $j_4316;
    var $x_0315;
    var $k_0314;
    var $125 = $j_4316 | 0;
    var $126 = $6 * $125;
    var $127 = $126 / 1024e3;
    var $128 = $127 * 1e3;
    var $129 = _ATHformula($3, $128);
    var $130 = $129 - 20;
    var $131 = $130;
    var $132 = $131 * .1;
    var $133 = Math.pow(10, $132);
    var $134 = $133;
    var $135 = $124 | 0;
    var $136 = $135 * $134;
    var $137 = $136;
    var $138 = $x_0315 > $137;
    var $x_1 = $138 ? $137 : $x_0315;
    var $139 = $k_0314 + 1 | 0;
    var $140 = $j_4316 + 1 | 0;
    var $141 = ($139 | 0) < ($121 | 0);
    if ($141) {
      var $k_0314 = $139;
      var $x_0315 = $x_1;
      var $j_4316 = $140;
      var $124 = $121;
      label = 20;
      break;
    } else {
      label = 21;
      break;
    }
   case 21:
    var $142 = $j_3323 + $smax355 | 0;
    var $phitmp345 = $x_1;
    var $x_0_lcssa = $phitmp345;
    var $j_4_lcssa = $142;
    label = 22;
    break;
   case 22:
    var $j_4_lcssa;
    var $x_0_lcssa;
    var $144 = HEAP32[$114 >> 2];
    var $145 = $144 + 212 + ($i_2324 << 2) | 0;
    HEAPF32[$145 >> 2] = $x_0_lcssa;
    var $146 = $bval + ($i_2324 << 2) | 0;
    var $147 = HEAPF32[$146 >> 2];
    var $148 = $147 / 10;
    var $149 = $148;
    var $150 = $149 - 1;
    var $151 = $150 * 20;
    var $152 = $151 > 6;
    var $x_2 = $152 ? 30 : $151;
    var $153 = $x_2 < $115;
    var $x_3 = $153 ? $115 : $x_2;
    var $154 = HEAP32[$4 >> 2];
    var $155 = ($154 | 0) < 44e3;
    var $_x_3 = $155 ? 30 : $x_3;
    var $156 = $_x_3 - 8;
    var $157 = $156 / 10;
    var $158 = Math.pow(10, $157);
    var $159 = HEAP32[$118 >> 2];
    var $160 = $159 | 0;
    var $161 = $158 * $160;
    var $162 = $161;
    var $163 = $117 + ($i_2324 << 2) | 0;
    HEAPF32[$163 >> 2] = $162;
    var $164 = $i_2324 + 1 | 0;
    var $165 = HEAP32[$78 >> 2];
    var $166 = ($164 | 0) < ($165 | 0);
    if ($166) {
      var $j_3323 = $j_4_lcssa;
      var $i_2324 = $164;
      label = 18;
      break;
    } else {
      label = 23;
      break;
    }
   case 23:
    var $167 = $15 + 2160 | 0;
    var $168 = $167;
    var $169 = $2 + 21452 | 0;
    _init_numline($168, $6, 256, 192, 13, $169);
    _compute_bark_values($168, $6, 256, $75, $76);
    var $170 = $15 + 4308 | 0;
    var $171 = $170;
    var $172 = HEAP32[$171 >> 2];
    var $173 = ($172 | 0) > 0;
    if ($173) {
      label = 24;
      break;
    } else {
      var $_lcssa304 = $172;
      label = 36;
      break;
    }
   case 24:
    var $174 = $15 + 3876 | 0;
    var $175 = $174;
    var $176 = $2 + 85792 | 0;
    var $177 = $9;
    var $178 = $15 + 2416 | 0;
    var $179 = $178;
    var $j_5305 = 0;
    var $i_3306 = 0;
    label = 25;
    break;
   case 25:
    var $i_3306;
    var $j_5305;
    var $181 = $bval + ($i_3306 << 2) | 0;
    var $182 = HEAPF32[$181 >> 2];
    var $183 = $182 < 13;
    if ($183) {
      var $snr2_0 = -8.25;
      label = 27;
      break;
    } else {
      label = 26;
      break;
    }
   case 26:
    var $185 = $182 - 13;
    var $186 = $185 * -4.5;
    var $187 = $186 / 11;
    var $188 = 24 - $182;
    var $189 = $188 * -8.25;
    var $190 = $189 / 11;
    var $191 = $187 + $190;
    var $192 = $191;
    var $snr2_0 = $192;
    label = 27;
    break;
   case 27:
    var $snr2_0;
    var $194 = $snr2_0 / 10;
    var $195 = Math.pow(10, $194);
    var $196 = $195;
    var $197 = $norm + ($i_3306 << 2) | 0;
    HEAPF32[$197 >> 2] = $196;
    var $198 = $175 + ($i_3306 << 2) | 0;
    var $199 = HEAP32[$198 >> 2];
    var $200 = ($199 | 0) > 0;
    if ($200) {
      label = 28;
      break;
    } else {
      var $x1_0_lcssa = 9.999999933815813e+36;
      var $j_6_lcssa = $j_5305;
      label = 31;
      break;
    }
   case 28:
    var $201 = HEAP32[$198 >> 2];
    var $202 = ($201 | 0) > 1;
    var $smax = $202 ? $201 : 1;
    var $k_1294 = 0;
    var $x1_0295 = 1e+37;
    var $j_6296 = $j_5305;
    var $204 = $199;
    label = 29;
    break;
   case 29:
    var $204;
    var $j_6296;
    var $x1_0295;
    var $k_1294;
    var $205 = $j_6296 | 0;
    var $206 = $6 * $205;
    var $207 = $206 / 256e3;
    var $208 = $207 * 1e3;
    var $209 = _ATHformula($3, $208);
    var $210 = $209 - 20;
    var $211 = $210;
    var $212 = $211 * .1;
    var $213 = Math.pow(10, $212);
    var $214 = $213;
    var $215 = $204 | 0;
    var $216 = $215 * $214;
    var $217 = $216;
    var $218 = $x1_0295 > $217;
    var $x1_1 = $218 ? $217 : $x1_0295;
    var $219 = $k_1294 + 1 | 0;
    var $220 = $j_6296 + 1 | 0;
    var $221 = ($219 | 0) < ($201 | 0);
    if ($221) {
      var $k_1294 = $219;
      var $x1_0295 = $x1_1;
      var $j_6296 = $220;
      var $204 = $201;
      label = 29;
      break;
    } else {
      label = 30;
      break;
    }
   case 30:
    var $222 = $j_5305 + $smax | 0;
    var $phitmp344 = $x1_1;
    var $x1_0_lcssa = $phitmp344;
    var $j_6_lcssa = $222;
    label = 31;
    break;
   case 31:
    var $j_6_lcssa;
    var $x1_0_lcssa;
    var $224 = HEAP32[$176 >> 2];
    var $225 = $224 + 468 + ($i_3306 << 2) | 0;
    HEAPF32[$225 >> 2] = $x1_0_lcssa;
    var $226 = HEAPF32[$181 >> 2];
    var $227 = $226 / 12;
    var $228 = $227;
    var $229 = $228 - 1;
    var $230 = $229 * 7;
    var $231 = $226 > 12;
    if ($231) {
      label = 32;
      break;
    } else {
      var $x1_2 = $230;
      label = 33;
      break;
    }
   case 32:
    var $233 = $230 + 1;
    var $234 = Math.log($233);
    var $235 = $234 * 3.1;
    var $236 = $235 + 1;
    var $237 = $230 * $236;
    var $x1_2 = $237;
    label = 33;
    break;
   case 33:
    var $x1_2;
    var $239 = HEAPF32[$181 >> 2];
    var $240 = $239 < 12;
    if ($240) {
      label = 34;
      break;
    } else {
      var $x1_3 = $x1_2;
      label = 35;
      break;
    }
   case 34:
    var $242 = 1 - $x1_2;
    var $243 = Math.log($242);
    var $244 = $243 * 2.3;
    var $245 = $244 + 1;
    var $246 = $x1_2 * $245;
    var $x1_3 = $246;
    label = 35;
    break;
   case 35:
    var $x1_3;
    var $248 = $x1_3 > 6;
    var $x1_4 = $248 ? 30 : $x1_3;
    var $249 = $x1_4 < $177;
    var $x1_5 = $249 ? $177 : $x1_4;
    var $250 = HEAP32[$4 >> 2];
    var $251 = ($250 | 0) < 44e3;
    var $_x1_5 = $251 ? 30 : $x1_5;
    var $252 = $_x1_5 - 8;
    var $253 = $252 / 10;
    var $254 = Math.pow(10, $253);
    var $255 = HEAP32[$198 >> 2];
    var $256 = $255 | 0;
    var $257 = $254 * $256;
    var $258 = $257;
    var $259 = $179 + ($i_3306 << 2) | 0;
    HEAPF32[$259 >> 2] = $258;
    var $260 = $i_3306 + 1 | 0;
    var $261 = HEAP32[$171 >> 2];
    var $262 = ($260 | 0) < ($261 | 0);
    if ($262) {
      var $j_5305 = $j_6_lcssa;
      var $i_3306 = $260;
      label = 25;
      break;
    } else {
      var $_lcssa304 = $261;
      label = 36;
      break;
    }
   case 36:
    var $_lcssa304;
    var $263 = $15 + 4316 | 0;
    var $264 = $263;
    var $265 = $15 + 3364 | 0;
    var $266 = $265;
    var $267 = _init_s3_values($264, $266, $_lcssa304, $75, $76, $107);
    var $268 = ($267 | 0) == 0;
    if ($268) {
      label = 37;
      break;
    } else {
      var $_0 = $267;
      label = 62;
      break;
    }
   case 37:
    _init_mask_add_max_values();
    _init_fft($2);
    var $270 = $6;
    var $271 = $270 * .01;
    var $272 = $271 / 192;
    var $273 = -2.302585092994046 / $272;
    var $274 = Math.exp($273);
    var $275 = $274;
    var $276 = $15 + 6496 | 0;
    var $277 = $276;
    HEAPF32[$277 >> 2] = $275;
    var $278 = $2 + 96 | 0;
    var $279 = HEAP32[$278 >> 2];
    var $280 = ($279 | 0) == 0;
    var $_ = $280 ? 3.5 : 1;
    var $281 = $2 + 192 | 0;
    var $282 = HEAPF32[$281 >> 2];
    var $283 = $282 == 0;
    var $msfix_1 = $283 ? $_ : $282;
    HEAPF32[$281 >> 2] = $msfix_1;
    var $284 = HEAP32[$78 >> 2];
    var $285 = ($284 | 0) > 0;
    if ($285) {
      label = 38;
      break;
    } else {
      label = 42;
      break;
    }
   case 38:
    var $286 = HEAP32[$78 >> 2];
    var $b_0290 = 0;
    var $288 = $284;
    label = 39;
    break;
   case 39:
    var $288;
    var $b_0290;
    var $289 = $105 + ($b_0290 << 3) + 4 | 0;
    var $290 = HEAP32[$289 >> 2];
    var $291 = $288 - 1 | 0;
    var $292 = ($290 | 0) > ($291 | 0);
    if ($292) {
      label = 40;
      break;
    } else {
      label = 41;
      break;
    }
   case 40:
    HEAP32[$289 >> 2] = $291;
    label = 41;
    break;
   case 41:
    var $295 = $b_0290 + 1 | 0;
    var $296 = ($295 | 0) < ($286 | 0);
    if ($296) {
      var $b_0290 = $295;
      var $288 = $286;
      label = 39;
      break;
    } else {
      label = 42;
      break;
    }
   case 42:
    var $297 = $2 + 76 | 0;
    var $298 = HEAP32[$297 >> 2];
    var $299 = $298 | 0;
    var $300 = $299 * 576;
    var $301 = $300 / $270;
    var $302 = $301 * -1.2;
    var $303 = Math.pow(10, $302);
    var $304 = $303;
    var $305 = $2 + 85792 | 0;
    var $306 = HEAP32[$305 >> 2];
    var $307 = $306 + 16 | 0;
    HEAPF32[$307 >> 2] = $304;
    var $308 = HEAP32[$305 >> 2];
    var $309 = $308 + 8 | 0;
    HEAPF32[$309 >> 2] = .009999999776482582;
    var $310 = HEAP32[$305 >> 2];
    var $311 = $310 + 12 | 0;
    HEAPF32[$311 >> 2] = 1;
    var $312 = $2 + 208 | 0;
    var $313 = HEAP32[$312 >> 2];
    var $314 = ($313 | 0) == -1;
    if ($314) {
      label = 47;
      break;
    } else {
      label = 43;
      break;
    }
   case 43:
    var $316 = HEAP32[$4 >> 2];
    var $317 = $316 | 0;
    var $318 = $317 * .0009765625;
    var $freq5_0287 = 0;
    var $eql_balance_0288 = 0;
    var $i_4289 = 0;
    label = 44;
    break;
   case 44:
    var $i_4289;
    var $eql_balance_0288;
    var $freq5_0287;
    var $320 = $318 + $freq5_0287;
    var $321 = _ATHformula($3, $320);
    var $322 = $321 / 10;
    var $323 = $322;
    var $324 = Math.pow(10, $323);
    var $325 = 1 / $324;
    var $326 = $325;
    var $327 = HEAP32[$305 >> 2];
    var $328 = $327 + 724 + ($i_4289 << 2) | 0;
    HEAPF32[$328 >> 2] = $326;
    var $329 = HEAP32[$305 >> 2];
    var $330 = $329 + 724 + ($i_4289 << 2) | 0;
    var $331 = HEAPF32[$330 >> 2];
    var $332 = $eql_balance_0288 + $331;
    var $333 = $i_4289 + 1 | 0;
    var $exitcond351 = ($333 | 0) == 512;
    if ($exitcond351) {
      label = 45;
      break;
    } else {
      var $freq5_0287 = $320;
      var $eql_balance_0288 = $332;
      var $i_4289 = $333;
      label = 44;
      break;
    }
   case 45:
    var $335 = 1 / $332;
    var $i_5286 = 511;
    label = 46;
    break;
   case 46:
    var $i_5286;
    var $337 = HEAP32[$305 >> 2];
    var $338 = $337 + 724 + ($i_5286 << 2) | 0;
    var $339 = HEAPF32[$338 >> 2];
    var $340 = $335 * $339;
    HEAPF32[$338 >> 2] = $340;
    var $phitmp = $i_5286 - 1 | 0;
    var $341 = ($phitmp | 0) > -1;
    if ($341) {
      var $i_5286 = $phitmp;
      label = 46;
      break;
    } else {
      label = 47;
      break;
    }
   case 47:
    var $342 = $gfp + 264 | 0;
    var $343 = HEAPF32[$342 >> 2];
    var $344 = $gfp + 268 | 0;
    var $345 = HEAPF32[$344 >> 2];
    var $346 = $343 < 0;
    var $x6_0 = $346 ? 4.400000095367432 : $343;
    var $347 = $345 < 0;
    var $y_0 = $347 ? 25 : $345;
    var $348 = $15 + 6480 | 0;
    var $349 = $15 + 6488 | 0;
    var $350 = $349;
    HEAPF32[$350 >> 2] = $x6_0;
    var $351 = $15 + 6484 | 0;
    var $352 = $351;
    HEAPF32[$352 >> 2] = $x6_0;
    var $353 = $348;
    HEAPF32[$353 >> 2] = $x6_0;
    var $354 = $15 + 6492 | 0;
    var $355 = $354;
    HEAPF32[$355 >> 2] = $y_0;
    var $356 = $gfp + 164 | 0;
    var $357 = HEAP32[$356 >> 2];
    var $358 = ($357 | 0) < 4;
    if ($358) {
      var $sk_s_0 = -7.400000095367432;
      label = 49;
      break;
    } else {
      label = 48;
      break;
    }
   case 48:
    var $360 = 5256972 + ($357 << 2) | 0;
    var $361 = HEAPF32[$360 >> 2];
    var $362 = $gfp + 160 | 0;
    var $363 = HEAPF32[$362 >> 2];
    var $364 = $357 + 1 | 0;
    var $365 = 5256972 + ($364 << 2) | 0;
    var $366 = HEAPF32[$365 >> 2];
    var $367 = $361 - $366;
    var $368 = $363 * $367;
    var $369 = $361 + $368;
    var $sk_s_0 = $369;
    label = 49;
    break;
   case 49:
    var $sk_s_0;
    var $371 = HEAP32[$171 >> 2];
    var $372 = ($371 | 0) > 0;
    if ($372) {
      label = 50;
      break;
    } else {
      var $b_3_lcssa362 = 0;
      label = 52;
      break;
    }
   case 50:
    var $373 = $167;
    var $b_3263 = 0;
    var $377 = $371;
    label = 53;
    break;
   case 51:
    var $374 = ($386 | 0) < 64;
    if ($374) {
      var $b_3_lcssa362 = $386;
      label = 52;
      break;
    } else {
      label = 54;
      break;
    }
   case 52:
    var $b_3_lcssa362;
    var $375 = $167;
    var $b_4261 = $b_3_lcssa362;
    label = 56;
    break;
   case 53:
    var $377;
    var $b_3263;
    var $378 = $377 - $b_3263 | 0;
    var $379 = $378 | 0;
    var $380 = $377 | 0;
    var $381 = $379 / $380;
    var $382 = $sk_s_0 * $381;
    var $383 = $382 * .10000000149011612;
    var $384 = Math.pow(10, $383);
    var $385 = $373 + ($b_3263 << 2) | 0;
    HEAPF32[$385 >> 2] = $384;
    var $386 = $b_3263 + 1 | 0;
    var $387 = HEAP32[$171 >> 2];
    var $388 = ($386 | 0) < ($387 | 0);
    if ($388) {
      var $b_3263 = $386;
      var $377 = $387;
      label = 53;
      break;
    } else {
      label = 51;
      break;
    }
   case 54:
    var $389 = HEAP32[$78 >> 2];
    var $390 = ($389 | 0) > 0;
    if ($390) {
      label = 55;
      break;
    } else {
      var $b_5_lcssa363 = 0;
      label = 58;
      break;
    }
   case 55:
    var $391 = $15;
    var $b_5258 = 0;
    var $398 = $389;
    label = 59;
    break;
   case 56:
    var $b_4261;
    var $393 = $375 + ($b_4261 << 2) | 0;
    HEAPF32[$393 >> 2] = 1;
    var $394 = $b_4261 + 1 | 0;
    var $exitcond346 = ($394 | 0) == 64;
    if ($exitcond346) {
      label = 54;
      break;
    } else {
      var $b_4261 = $394;
      label = 56;
      break;
    }
   case 57:
    var $395 = ($407 | 0) < 64;
    if ($395) {
      var $b_5_lcssa363 = $407;
      label = 58;
      break;
    } else {
      label = 61;
      break;
    }
   case 58:
    var $b_5_lcssa363;
    var $396 = $15;
    var $b_6256 = $b_5_lcssa363;
    label = 60;
    break;
   case 59:
    var $398;
    var $b_5258;
    var $399 = $398 - $b_5258 | 0;
    var $400 = $399 | 0;
    var $401 = $398 | 0;
    var $402 = $400 / $401;
    var $403 = $sk_s_0 * $402;
    var $404 = $403 * .10000000149011612;
    var $405 = Math.pow(10, $404);
    var $406 = $391 + ($b_5258 << 2) | 0;
    HEAPF32[$406 >> 2] = $405;
    var $407 = $b_5258 + 1 | 0;
    var $408 = HEAP32[$78 >> 2];
    var $409 = ($407 | 0) < ($408 | 0);
    if ($409) {
      var $b_5258 = $407;
      var $398 = $408;
      label = 59;
      break;
    } else {
      label = 57;
      break;
    }
   case 60:
    var $b_6256;
    var $411 = $396 + ($b_6256 << 2) | 0;
    HEAPF32[$411 >> 2] = 1;
    var $412 = $b_6256 + 1 | 0;
    var $exitcond = ($412 | 0) == 64;
    if ($exitcond) {
      label = 61;
      break;
    } else {
      var $b_6256 = $412;
      label = 60;
      break;
    }
   case 61:
    var $413 = $15 + 4320 | 0;
    var $414 = $413;
    for (var $$src = $15 >> 2, $$dest = $413 >> 2, $$stop = $$src + 540; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    _init_numline($414, $6, 1024, 192, 13, $169);
    var $_0 = 0;
    label = 62;
    break;
   case 62:
    var $_0;
    STACKTOP = __stackBase__;
    return $_0;
  }
}
_psymodel_init["X"] = 1;
function _init_mask_add_max_values() {
  HEAPF32[5314460 >> 2] = 3.6517412662506104;
  HEAPF32[5314456 >> 2] = 31.62277603149414;
  return;
}
function _convert_partition2scalefac($gd, $eb, $thr, $enn_out, $thm_out) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gd + 2152 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($2 | 0) > 0;
    if ($3) {
      label = 3;
      break;
    } else {
      var $sb_1_ph = 0;
      label = 4;
      break;
    }
   case 3:
    var $4 = $gd + 2148 | 0;
    var $b_059 = 0;
    var $sb_060 = 0;
    var $thmm_061 = 0;
    var $enn_062 = 0;
    label = 5;
    break;
   case 4:
    var $sb_1_ph;
    var $5 = ($sb_1_ph | 0) < ($2 | 0);
    if ($5) {
      var $sb_149 = $sb_1_ph;
      label = 11;
      break;
    } else {
      label = 12;
      break;
    }
   case 5:
    var $enn_062;
    var $thmm_061;
    var $sb_060;
    var $b_059;
    var $7 = $gd + 2060 + ($sb_060 << 2) | 0;
    var $8 = HEAP32[$7 >> 2];
    var $9 = HEAP32[$4 >> 2];
    var $10 = ($8 | 0) < ($9 | 0);
    var $11 = $10 ? $8 : $9;
    var $12 = ($b_059 | 0) < ($11 | 0);
    if ($12) {
      label = 6;
      break;
    } else {
      var $b_1_lcssa = $b_059;
      var $thmm_1_lcssa = $thmm_061;
      var $enn_1_lcssa = $enn_062;
      label = 8;
      break;
    }
   case 6:
    var $13 = $8 ^ -1;
    var $14 = $9 ^ -1;
    var $15 = ($13 | 0) > ($14 | 0);
    var $smax = $15 ? $13 : $14;
    var $16 = $smax ^ -1;
    var $b_150 = $b_059;
    var $thmm_151 = $thmm_061;
    var $enn_152 = $enn_062;
    label = 7;
    break;
   case 7:
    var $enn_152;
    var $thmm_151;
    var $b_150;
    var $18 = $eb + ($b_150 << 2) | 0;
    var $19 = HEAPF32[$18 >> 2];
    var $20 = $enn_152 + $19;
    var $21 = $thr + ($b_150 << 2) | 0;
    var $22 = HEAPF32[$21 >> 2];
    var $23 = $thmm_151 + $22;
    var $24 = $b_150 + 1 | 0;
    var $exitcond70 = ($24 | 0) == ($16 | 0);
    if ($exitcond70) {
      var $b_1_lcssa = $16;
      var $thmm_1_lcssa = $23;
      var $enn_1_lcssa = $20;
      label = 8;
      break;
    } else {
      var $b_150 = $24;
      var $thmm_151 = $23;
      var $enn_152 = $20;
      label = 7;
      break;
    }
   case 8:
    var $enn_1_lcssa;
    var $thmm_1_lcssa;
    var $b_1_lcssa;
    var $25 = ($b_1_lcssa | 0) < ($9 | 0);
    if ($25) {
      label = 10;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    var $27 = $enn_out + ($sb_060 << 2) | 0;
    HEAPF32[$27 >> 2] = $enn_1_lcssa;
    var $28 = $thm_out + ($sb_060 << 2) | 0;
    HEAPF32[$28 >> 2] = $thmm_1_lcssa;
    var $29 = $sb_060 + 1 | 0;
    var $sb_1_ph = $29;
    label = 4;
    break;
   case 10:
    var $31 = $gd + 1112 + ($sb_060 << 2) | 0;
    var $32 = HEAPF32[$31 >> 2];
    var $33 = 1 - $32;
    var $34 = $eb + ($b_1_lcssa << 2) | 0;
    var $35 = HEAPF32[$34 >> 2];
    var $36 = $32 * $35;
    var $37 = $enn_1_lcssa + $36;
    var $38 = $thr + ($b_1_lcssa << 2) | 0;
    var $39 = HEAPF32[$38 >> 2];
    var $40 = $32 * $39;
    var $41 = $thmm_1_lcssa + $40;
    var $42 = $enn_out + ($sb_060 << 2) | 0;
    HEAPF32[$42 >> 2] = $37;
    var $43 = $thm_out + ($sb_060 << 2) | 0;
    HEAPF32[$43 >> 2] = $41;
    var $44 = HEAPF32[$34 >> 2];
    var $45 = $33 * $44;
    var $46 = HEAPF32[$38 >> 2];
    var $47 = $33 * $46;
    var $48 = $b_1_lcssa + 1 | 0;
    var $49 = $sb_060 + 1 | 0;
    var $50 = ($49 | 0) < ($2 | 0);
    if ($50) {
      var $b_059 = $48;
      var $sb_060 = $49;
      var $thmm_061 = $47;
      var $enn_062 = $45;
      label = 5;
      break;
    } else {
      var $sb_1_ph = $49;
      label = 4;
      break;
    }
   case 11:
    var $sb_149;
    var $51 = $enn_out + ($sb_149 << 2) | 0;
    HEAPF32[$51 >> 2] = 0;
    var $52 = $thm_out + ($sb_149 << 2) | 0;
    HEAPF32[$52 >> 2] = 0;
    var $53 = $sb_149 + 1 | 0;
    var $exitcond = ($53 | 0) == ($2 | 0);
    if ($exitcond) {
      label = 12;
      break;
    } else {
      var $sb_149 = $53;
      label = 11;
      break;
    }
   case 12:
    return;
  }
}
_convert_partition2scalefac["X"] = 1;
function _vbrpsy_calc_mask_index_s($gfc, $max, $avg, $mask_idx) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 85796 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = HEAPF32[$avg >> 2];
    var $4 = $avg + 4 | 0;
    var $5 = HEAPF32[$4 >> 2];
    var $6 = $3 + $5;
    var $7 = $6 > 0;
    if ($7) {
      label = 3;
      break;
    } else {
      var $storemerge = 0;
      label = 4;
      break;
    }
   case 3:
    var $9 = HEAPF32[$max >> 2];
    var $10 = $max + 4 | 0;
    var $11 = HEAPF32[$10 >> 2];
    var $12 = $9 < $11;
    var $m_0 = $12 ? $11 : $9;
    var $13 = $m_0 * 2;
    var $14 = $13 - $6;
    var $15 = $14 * 20;
    var $16 = $2 + 3876 | 0;
    var $17 = HEAP32[$16 >> 2];
    var $18 = $2 + 3880 | 0;
    var $19 = HEAP32[$18 >> 2];
    var $20 = $17 - 1 | 0;
    var $21 = $20 + $19 | 0;
    var $22 = $21 | 0;
    var $23 = $6 * $22;
    var $24 = $15 / $23;
    var $25 = $24 & -1;
    var $26 = ($25 | 0) > 8;
    var $27 = $25 & 255;
    var $28 = $26 ? 8 : $27;
    var $storemerge = $28;
    label = 4;
    break;
   case 4:
    var $storemerge;
    HEAP8[$mask_idx] = $storemerge;
    var $30 = $2 + 4308 | 0;
    var $31 = HEAP32[$30 >> 2];
    var $32 = $31 - 1 | 0;
    var $33 = ($32 | 0) > 1;
    var $34 = HEAPF32[$avg >> 2];
    var $35 = $avg + 4 | 0;
    var $36 = HEAPF32[$35 >> 2];
    var $37 = $34 + $36;
    if ($33) {
      var $b_082 = 1;
      var $39 = 0;
      var $38 = $37;
      label = 5;
      break;
    } else {
      var $b_0_lcssa = 1;
      var $_lcssa = 0;
      var $_lcssa81 = $37;
      label = 9;
      break;
    }
   case 5:
    var $38;
    var $39;
    var $b_082;
    var $40 = $b_082 + 1 | 0;
    var $41 = $avg + ($40 << 2) | 0;
    var $42 = HEAPF32[$41 >> 2];
    var $43 = $38 + $42;
    var $44 = $43 > 0;
    if ($44) {
      label = 6;
      break;
    } else {
      label = 8;
      break;
    }
   case 6:
    var $46 = $max + ($39 << 2) | 0;
    var $47 = HEAPF32[$46 >> 2];
    var $48 = $max + ($b_082 << 2) | 0;
    var $49 = HEAPF32[$48 >> 2];
    var $50 = $47 < $49;
    var $m_1 = $50 ? $49 : $47;
    var $51 = $max + ($40 << 2) | 0;
    var $52 = HEAPF32[$51 >> 2];
    var $53 = $m_1 < $52;
    var $m_2 = $53 ? $52 : $m_1;
    var $54 = $m_2 * 3;
    var $55 = $54 - $43;
    var $56 = $55 * 20;
    var $57 = $2 + 3876 + ($39 << 2) | 0;
    var $58 = HEAP32[$57 >> 2];
    var $59 = $2 + 3876 + ($b_082 << 2) | 0;
    var $60 = HEAP32[$59 >> 2];
    var $61 = $2 + 3876 + ($40 << 2) | 0;
    var $62 = HEAP32[$61 >> 2];
    var $63 = $58 - 1 | 0;
    var $64 = $63 + $60 | 0;
    var $65 = $64 + $62 | 0;
    var $66 = $65 | 0;
    var $67 = $43 * $66;
    var $68 = $56 / $67;
    var $69 = $68 & -1;
    var $70 = ($69 | 0) > 8;
    var $71 = $69 & 255;
    var $72 = $70 ? 8 : $71;
    var $73 = $mask_idx + $b_082 | 0;
    HEAP8[$73] = $72;
    label = 7;
    break;
   case 7:
    var $74 = HEAP32[$30 >> 2];
    var $75 = $74 - 1 | 0;
    var $76 = ($40 | 0) < ($75 | 0);
    var $77 = $avg + ($b_082 << 2) | 0;
    var $78 = HEAPF32[$77 >> 2];
    var $79 = $avg + ($40 << 2) | 0;
    var $80 = HEAPF32[$79 >> 2];
    var $81 = $78 + $80;
    if ($76) {
      var $39 = $b_082;
      var $b_082 = $40;
      var $38 = $81;
      label = 5;
      break;
    } else {
      var $b_0_lcssa = $40;
      var $_lcssa = $b_082;
      var $_lcssa81 = $81;
      label = 9;
      break;
    }
   case 8:
    var $83 = $mask_idx + $b_082 | 0;
    HEAP8[$83] = 0;
    label = 7;
    break;
   case 9:
    var $_lcssa81;
    var $_lcssa;
    var $b_0_lcssa;
    var $84 = $_lcssa81 > 0;
    if ($84) {
      label = 10;
      break;
    } else {
      label = 11;
      break;
    }
   case 10:
    var $86 = $max + ($_lcssa << 2) | 0;
    var $87 = HEAPF32[$86 >> 2];
    var $88 = $max + ($b_0_lcssa << 2) | 0;
    var $89 = HEAPF32[$88 >> 2];
    var $90 = $87 < $89;
    var $m_3 = $90 ? $89 : $87;
    var $91 = $m_3 * 2;
    var $92 = $91 - $_lcssa81;
    var $93 = $92 * 20;
    var $94 = $2 + 3876 + ($_lcssa << 2) | 0;
    var $95 = HEAP32[$94 >> 2];
    var $96 = $2 + 3876 + ($b_0_lcssa << 2) | 0;
    var $97 = HEAP32[$96 >> 2];
    var $98 = $95 - 1 | 0;
    var $99 = $98 + $97 | 0;
    var $100 = $99 | 0;
    var $101 = $_lcssa81 * $100;
    var $102 = $93 / $101;
    var $103 = $102 & -1;
    var $104 = ($103 | 0) > 8;
    var $105 = $103 & 255;
    var $106 = $104 ? 8 : $105;
    var $107 = $mask_idx + $b_0_lcssa | 0;
    HEAP8[$107] = $106;
    label = 12;
    break;
   case 11:
    var $109 = $mask_idx + $b_0_lcssa | 0;
    HEAP8[$109] = 0;
    label = 12;
    break;
   case 12:
    return;
  }
}
_vbrpsy_calc_mask_index_s["X"] = 1;
function _mask_add_delta($i) {
  return HEAP32[5249740 + ($i << 2) >> 2];
}
function _calc_energy($l, $fftenergy, $eb, $max, $avg) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $l + 2148 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($2 | 0) > 0;
    if ($3) {
      var $j_026 = 0;
      var $b_027 = 0;
      label = 3;
      break;
    } else {
      label = 8;
      break;
    }
   case 3:
    var $b_027;
    var $j_026;
    var $4 = $l + 1716 + ($b_027 << 2) | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = ($5 | 0) > 0;
    if ($6) {
      label = 4;
      break;
    } else {
      var $j_1_lcssa = $j_026;
      var $ebb_0_lcssa = 0;
      var $m_0_lcssa = 0;
      label = 7;
      break;
    }
   case 4:
    var $7 = HEAP32[$4 >> 2];
    var $8 = ($7 | 0) > 1;
    var $smax = $8 ? $7 : 1;
    var $j_120 = $j_026;
    var $ebb_021 = 0;
    var $m_022 = 0;
    var $i_023 = 0;
    label = 5;
    break;
   case 5:
    var $i_023;
    var $m_022;
    var $ebb_021;
    var $j_120;
    var $10 = $fftenergy + ($j_120 << 2) | 0;
    var $11 = HEAPF32[$10 >> 2];
    var $12 = $ebb_021 + $11;
    var $13 = $m_022 < $11;
    var $m_1 = $13 ? $11 : $m_022;
    var $14 = $i_023 + 1 | 0;
    var $15 = $j_120 + 1 | 0;
    var $16 = ($14 | 0) < ($7 | 0);
    if ($16) {
      var $j_120 = $15;
      var $ebb_021 = $12;
      var $m_022 = $m_1;
      var $i_023 = $14;
      label = 5;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    var $17 = $j_026 + $smax | 0;
    var $j_1_lcssa = $17;
    var $ebb_0_lcssa = $12;
    var $m_0_lcssa = $m_1;
    label = 7;
    break;
   case 7:
    var $m_0_lcssa;
    var $ebb_0_lcssa;
    var $j_1_lcssa;
    var $19 = $eb + ($b_027 << 2) | 0;
    HEAPF32[$19 >> 2] = $ebb_0_lcssa;
    var $20 = $max + ($b_027 << 2) | 0;
    HEAPF32[$20 >> 2] = $m_0_lcssa;
    var $21 = $l + 512 + ($b_027 << 2) | 0;
    var $22 = HEAPF32[$21 >> 2];
    var $23 = $ebb_0_lcssa * $22;
    var $24 = $avg + ($b_027 << 2) | 0;
    HEAPF32[$24 >> 2] = $23;
    var $25 = $b_027 + 1 | 0;
    var $26 = HEAP32[$1 >> 2];
    var $27 = ($25 | 0) < ($26 | 0);
    if ($27) {
      var $j_026 = $j_1_lcssa;
      var $b_027 = $25;
      label = 3;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    return;
  }
}
function _init_numline($gd, $sfreq, $fft_size, $mdct_size, $sbmax, $scalepos) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 2312 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $b_frq = __stackBase__;
    var $partition = __stackBase__ + 260;
    var $1 = $mdct_size | 0;
    var $2 = $1 * 2;
    var $3 = $sfreq / $2;
    var $4 = $fft_size | 0;
    var $5 = $4 / $2;
    var $6 = $partition;
    for (var $$dest = $6 >> 2, $$stop = $$dest + 513; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $7 = $sfreq / $4;
    var $8 = ($fft_size | 0) / 2 & -1;
    var $9 = ($fft_size | 0) / 2 & -1;
    var $j_0 = 0;
    var $ni_0 = 0;
    label = 3;
    break;
   case 3:
    var $ni_0;
    var $j_0;
    var $11 = ($ni_0 | 0) < 64;
    if ($11) {
      label = 4;
      break;
    } else {
      var $j_2 = $j_0;
      var $ni_1 = $ni_0;
      label = 11;
      break;
    }
   case 4:
    var $13 = $j_0 | 0;
    var $14 = $7 * $13;
    var $15 = _freq2bark($14);
    var $16 = $b_frq + ($ni_0 << 2) | 0;
    HEAPF32[$16 >> 2] = $14;
    var $j2_0 = $j_0;
    label = 5;
    break;
   case 5:
    var $j2_0;
    var $18 = $j2_0 | 0;
    var $19 = $7 * $18;
    var $20 = _freq2bark($19);
    var $21 = $20 - $15;
    var $22 = $21;
    var $23 = $22 >= .34;
    var $24 = ($j2_0 | 0) > ($8 | 0);
    var $or_cond = $23 | $24;
    var $25 = $j2_0 + 1 | 0;
    if ($or_cond) {
      label = 6;
      break;
    } else {
      var $j2_0 = $25;
      label = 5;
      break;
    }
   case 6:
    var $26 = $j2_0 - $j_0 | 0;
    var $27 = $gd + 1716 + ($ni_0 << 2) | 0;
    HEAP32[$27 >> 2] = $26;
    var $28 = ($26 | 0) > 0;
    if ($28) {
      label = 7;
      break;
    } else {
      var $33 = 0;
      label = 8;
      break;
    }
   case 7:
    var $30 = $26 | 0;
    var $31 = 1 / $30;
    var $33 = $31;
    label = 8;
    break;
   case 8:
    var $33;
    var $34 = $gd + 512 + ($ni_0 << 2) | 0;
    HEAPF32[$34 >> 2] = $33;
    var $35 = $ni_0 + 1 | 0;
    var $36 = ($j_0 | 0) < ($j2_0 | 0);
    if ($36) {
      var $j_190 = $j_0;
      label = 9;
      break;
    } else {
      var $j_1_lcssa = $j_0;
      label = 10;
      break;
    }
   case 9:
    var $j_190;
    var $37 = $j_190 + 1 | 0;
    var $38 = $partition + ($j_190 << 2) | 0;
    HEAP32[$38 >> 2] = $ni_0;
    var $exitcond97 = ($37 | 0) == ($j2_0 | 0);
    if ($exitcond97) {
      var $j_1_lcssa = $j2_0;
      label = 10;
      break;
    } else {
      var $j_190 = $37;
      label = 9;
      break;
    }
   case 10:
    var $j_1_lcssa;
    var $39 = ($j_1_lcssa | 0) > ($9 | 0);
    if ($39) {
      var $j_2 = $9;
      var $ni_1 = $35;
      label = 11;
      break;
    } else {
      var $j_0 = $j_1_lcssa;
      var $ni_0 = $35;
      label = 3;
      break;
    }
   case 11:
    var $ni_1;
    var $j_2;
    var $41 = $j_2 | 0;
    var $42 = $7 * $41;
    var $43 = $b_frq + ($ni_1 << 2) | 0;
    HEAPF32[$43 >> 2] = $42;
    var $44 = $gd + 2152 | 0;
    HEAP32[$44 >> 2] = $sbmax;
    var $45 = $gd + 2148 | 0;
    HEAP32[$45 >> 2] = $ni_1;
    var $46 = ($ni_1 | 0) > 0;
    if ($46) {
      var $j_386 = 0;
      var $i_287 = 0;
      label = 13;
      break;
    } else {
      var $i_384 = 0;
      label = 16;
      break;
    }
   case 12:
    var $47 = ($58 | 0) < 64;
    if ($47) {
      var $i_384 = $58;
      label = 16;
      break;
    } else {
      label = 14;
      break;
    }
   case 13:
    var $i_287;
    var $j_386;
    var $48 = $gd + 1716 + ($i_287 << 2) | 0;
    var $49 = HEAP32[$48 >> 2];
    var $50 = ($49 | 0) / 2 & -1;
    var $51 = $50 + $j_386 | 0;
    var $52 = $51 | 0;
    var $53 = $7 * $52;
    var $54 = $53;
    var $55 = _stereo_demask($54);
    var $56 = $gd + 768 + ($i_287 << 2) | 0;
    HEAPF32[$56 >> 2] = $55;
    var $57 = $49 + $j_386 | 0;
    var $58 = $i_287 + 1 | 0;
    var $59 = HEAP32[$45 >> 2];
    var $60 = ($58 | 0) < ($59 | 0);
    if ($60) {
      var $j_386 = $57;
      var $i_287 = $58;
      label = 13;
      break;
    } else {
      label = 12;
      break;
    }
   case 14:
    var $61 = ($sbmax | 0) > 0;
    if ($61) {
      label = 15;
      break;
    } else {
      label = 21;
      break;
    }
   case 15:
    var $62 = $5;
    var $63 = ($fft_size | 0) / 2 & -1;
    var $sfb_082 = 0;
    label = 17;
    break;
   case 16:
    var $i_384;
    var $64 = $gd + 768 + ($i_384 << 2) | 0;
    HEAPF32[$64 >> 2] = 1;
    var $65 = $i_384 + 1 | 0;
    var $exitcond95 = ($65 | 0) == 64;
    if ($exitcond95) {
      label = 14;
      break;
    } else {
      var $i_384 = $65;
      label = 16;
      break;
    }
   case 17:
    var $sfb_082;
    var $67 = $scalepos + ($sfb_082 << 2) | 0;
    var $68 = HEAP32[$67 >> 2];
    var $69 = $sfb_082 + 1 | 0;
    var $70 = $scalepos + ($69 << 2) | 0;
    var $71 = HEAP32[$70 >> 2];
    var $72 = $68 | 0;
    var $73 = $72 - .5;
    var $74 = $62 * $73;
    var $75 = $74 + .5;
    var $76 = Math.floor($75);
    var $77 = $76 & -1;
    var $78 = ($77 | 0) < 0;
    var $_ = $78 ? 0 : $77;
    var $79 = $71 | 0;
    var $80 = $79 - .5;
    var $81 = $62 * $80;
    var $82 = $81 + .5;
    var $83 = Math.floor($82);
    var $84 = $83 & -1;
    var $85 = ($84 | 0) > ($63 | 0);
    var $i2_0 = $85 ? $63 : $84;
    var $86 = $partition + ($i2_0 << 2) | 0;
    var $87 = HEAP32[$86 >> 2];
    var $88 = $partition + ($_ << 2) | 0;
    var $89 = HEAP32[$88 >> 2];
    var $90 = $89 + $87 | 0;
    var $91 = ($90 | 0) / 2 & -1;
    var $92 = $gd + 1972 + ($sfb_082 << 2) | 0;
    HEAP32[$92 >> 2] = $91;
    var $93 = $gd + 2060 + ($sfb_082 << 2) | 0;
    HEAP32[$93 >> 2] = $87;
    var $94 = $71 | 0;
    var $95 = $3 * $94;
    var $96 = $b_frq + ($87 << 2) | 0;
    var $97 = HEAPF32[$96 >> 2];
    var $98 = $95 - $97;
    var $99 = $87 + 1 | 0;
    var $100 = $b_frq + ($99 << 2) | 0;
    var $101 = HEAPF32[$100 >> 2];
    var $102 = $101 - $97;
    var $103 = $98 / $102;
    var $104 = $103 < 0;
    if ($104) {
      var $bo_w_0 = 0;
      label = 20;
      break;
    } else {
      label = 18;
      break;
    }
   case 18:
    var $106 = $103 > 1;
    if ($106) {
      label = 19;
      break;
    } else {
      var $bo_w_0 = $103;
      label = 20;
      break;
    }
   case 19:
    var $bo_w_0 = 1;
    label = 20;
    break;
   case 20:
    var $bo_w_0;
    var $109 = $gd + 1112 + ($sfb_082 << 2) | 0;
    HEAPF32[$109 >> 2] = $bo_w_0;
    var $110 = $68 | 0;
    var $111 = $3 * $110;
    var $112 = $111;
    var $113 = _stereo_demask($112);
    var $114 = $gd + 1024 + ($sfb_082 << 2) | 0;
    HEAPF32[$114 >> 2] = $113;
    var $exitcond = ($69 | 0) == ($sbmax | 0);
    if ($exitcond) {
      label = 21;
      break;
    } else {
      var $sfb_082 = $69;
      label = 17;
      break;
    }
   case 21:
    STACKTOP = __stackBase__;
    return;
  }
}
_init_numline["X"] = 1;
function _compute_bark_values($gd, $sfreq, $fft_size, $bval, $bval_width) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gd + 2148 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $fft_size | 0;
    var $4 = $sfreq / $3;
    var $5 = ($2 | 0) > 0;
    if ($5) {
      label = 3;
      break;
    } else {
      label = 5;
      break;
    }
   case 3:
    var $6 = $4;
    var $j_022 = 0;
    var $k_023 = 0;
    label = 4;
    break;
   case 4:
    var $k_023;
    var $j_022;
    var $8 = $gd + 1716 + ($k_023 << 2) | 0;
    var $9 = HEAP32[$8 >> 2];
    var $10 = $j_022 | 0;
    var $11 = $4 * $10;
    var $12 = _freq2bark($11);
    var $13 = $9 + $j_022 | 0;
    var $14 = $13 - 1 | 0;
    var $15 = $14 | 0;
    var $16 = $4 * $15;
    var $17 = _freq2bark($16);
    var $18 = $12 + $17;
    var $19 = $18 * .5;
    var $20 = $bval + ($k_023 << 2) | 0;
    HEAPF32[$20 >> 2] = $19;
    var $21 = $j_022 | 0;
    var $22 = $21 - .5;
    var $23 = $6 * $22;
    var $24 = $23;
    var $25 = _freq2bark($24);
    var $26 = $13 | 0;
    var $27 = $26 - .5;
    var $28 = $6 * $27;
    var $29 = $28;
    var $30 = _freq2bark($29);
    var $31 = $30 - $25;
    var $32 = $bval_width + ($k_023 << 2) | 0;
    HEAPF32[$32 >> 2] = $31;
    var $33 = $k_023 + 1 | 0;
    var $exitcond = ($33 | 0) == ($2 | 0);
    if ($exitcond) {
      label = 5;
      break;
    } else {
      var $j_022 = $13;
      var $k_023 = $33;
      label = 4;
      break;
    }
   case 5:
    return;
  }
}
function _init_s3_values($p, $s3ind, $npart, $bval, $bval_width, $norm) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 16384 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $s3 = __stackBase__;
    var $1 = $s3;
    for (var $$dest = $1 >> 2, $$stop = $$dest + 4096; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $2 = ($npart | 0) > 0;
    if ($2) {
      var $i_068 = 0;
      label = 3;
      break;
    } else {
      var $numberOfNoneZero_0_lcssa = 0;
      label = 15;
      break;
    }
   case 3:
    var $i_068;
    var $3 = $bval + ($i_068 << 2) | 0;
    var $4 = HEAPF32[$3 >> 2];
    var $5 = $norm + ($i_068 << 2) | 0;
    var $6 = HEAPF32[$5 >> 2];
    var $j_065 = 0;
    label = 5;
    break;
   case 4:
    var $7 = ($npart | 0) > 0;
    if ($7) {
      var $i_160 = 0;
      var $numberOfNoneZero_061 = 0;
      label = 7;
      break;
    } else {
      var $numberOfNoneZero_0_lcssa = 0;
      label = 15;
      break;
    }
   case 5:
    var $j_065;
    var $9 = $bval + ($j_065 << 2) | 0;
    var $10 = HEAPF32[$9 >> 2];
    var $11 = $4 - $10;
    var $12 = _s3_func($11);
    var $13 = $bval_width + ($j_065 << 2) | 0;
    var $14 = HEAPF32[$13 >> 2];
    var $15 = $12 * $14;
    var $16 = $15 * $6;
    var $17 = $s3 + ($i_068 << 8) + ($j_065 << 2) | 0;
    HEAPF32[$17 >> 2] = $16;
    var $18 = $j_065 + 1 | 0;
    var $exitcond72 = ($18 | 0) == ($npart | 0);
    if ($exitcond72) {
      label = 6;
      break;
    } else {
      var $j_065 = $18;
      label = 5;
      break;
    }
   case 6:
    var $19 = $i_068 + 1 | 0;
    var $exitcond73 = ($19 | 0) == ($npart | 0);
    if ($exitcond73) {
      label = 4;
      break;
    } else {
      var $i_068 = $19;
      label = 3;
      break;
    }
   case 7:
    var $numberOfNoneZero_061;
    var $i_160;
    var $j_1 = 0;
    label = 8;
    break;
   case 8:
    var $j_1;
    var $21 = ($j_1 | 0) < ($npart | 0);
    if ($21) {
      label = 9;
      break;
    } else {
      label = 10;
      break;
    }
   case 9:
    var $23 = $s3 + ($i_160 << 8) + ($j_1 << 2) | 0;
    var $24 = HEAPF32[$23 >> 2];
    var $25 = $24 > 0;
    var $26 = $j_1 + 1 | 0;
    if ($25) {
      label = 10;
      break;
    } else {
      var $j_1 = $26;
      label = 8;
      break;
    }
   case 10:
    var $28 = $s3ind + ($i_160 << 3) | 0;
    HEAP32[$28 >> 2] = $j_1;
    var $j_2_in = $npart;
    label = 11;
    break;
   case 11:
    var $j_2_in;
    var $j_2 = $j_2_in - 1 | 0;
    var $30 = ($j_2 | 0) > 0;
    if ($30) {
      label = 12;
      break;
    } else {
      label = 13;
      break;
    }
   case 12:
    var $32 = $s3 + ($i_160 << 8) + ($j_2 << 2) | 0;
    var $33 = HEAPF32[$32 >> 2];
    var $34 = $33 > 0;
    if ($34) {
      label = 13;
      break;
    } else {
      var $j_2_in = $j_2;
      label = 11;
      break;
    }
   case 13:
    var $36 = $s3ind + ($i_160 << 3) + 4 | 0;
    HEAP32[$36 >> 2] = $j_2;
    var $37 = HEAP32[$28 >> 2];
    var $38 = $numberOfNoneZero_061 + $j_2_in | 0;
    var $39 = $38 - $37 | 0;
    var $40 = $i_160 + 1 | 0;
    var $exitcond71 = ($40 | 0) == ($npart | 0);
    if ($exitcond71) {
      label = 14;
      break;
    } else {
      var $i_160 = $40;
      var $numberOfNoneZero_061 = $39;
      label = 7;
      break;
    }
   case 14:
    var $phitmp = $39 << 2;
    var $numberOfNoneZero_0_lcssa = $phitmp;
    label = 15;
    break;
   case 15:
    var $numberOfNoneZero_0_lcssa;
    var $41 = _malloc($numberOfNoneZero_0_lcssa);
    var $42 = $41;
    HEAP32[$p >> 2] = $42;
    var $43 = ($41 | 0) == 0;
    if ($43) {
      var $_0 = -1;
      label = 20;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    var $44 = ($npart | 0) > 0;
    if ($44) {
      var $i_254 = 0;
      var $k_056 = 0;
      label = 17;
      break;
    } else {
      var $_0 = 0;
      label = 20;
      break;
    }
   case 17:
    var $k_056;
    var $i_254;
    var $45 = $s3ind + ($i_254 << 3) | 0;
    var $46 = HEAP32[$45 >> 2];
    var $47 = $s3ind + ($i_254 << 3) + 4 | 0;
    var $48 = HEAP32[$47 >> 2];
    var $49 = ($46 | 0) > ($48 | 0);
    if ($49) {
      var $k_1_lcssa = $k_056;
      label = 19;
      break;
    } else {
      var $j_352 = $46;
      var $k_153 = $k_056;
      label = 18;
      break;
    }
   case 18:
    var $k_153;
    var $j_352;
    var $50 = $s3 + ($i_254 << 8) + ($j_352 << 2) | 0;
    var $51 = HEAPF32[$50 >> 2];
    var $52 = $k_153 + 1 | 0;
    var $53 = HEAP32[$p >> 2];
    var $54 = $53 + ($k_153 << 2) | 0;
    HEAPF32[$54 >> 2] = $51;
    var $55 = $j_352 + 1 | 0;
    var $56 = HEAP32[$47 >> 2];
    var $57 = ($55 | 0) > ($56 | 0);
    if ($57) {
      var $k_1_lcssa = $52;
      label = 19;
      break;
    } else {
      var $j_352 = $55;
      var $k_153 = $52;
      label = 18;
      break;
    }
   case 19:
    var $k_1_lcssa;
    var $58 = $i_254 + 1 | 0;
    var $exitcond = ($58 | 0) == ($npart | 0);
    if ($exitcond) {
      var $_0 = 0;
      label = 20;
      break;
    } else {
      var $i_254 = $58;
      var $k_056 = $k_1_lcssa;
      label = 17;
      break;
    }
   case 20:
    var $_0;
    STACKTOP = __stackBase__;
    return $_0;
  }
}
_init_s3_values["X"] = 1;
function _s3_func($bark) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $bark < 0;
    if ($1) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $3 = $bark * 3;
    var $tempx_0 = $3;
    label = 5;
    break;
   case 4:
    var $5 = $bark * 1.5;
    var $tempx_0 = $5;
    label = 5;
    break;
   case 5:
    var $tempx_0;
    var $7 = $tempx_0;
    var $8 = $tempx_0 < .5;
    var $9 = $tempx_0 > 2.5;
    var $or_cond = $8 | $9;
    if ($or_cond) {
      var $x_0 = 0;
      label = 7;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    var $11 = $tempx_0 - .5;
    var $12 = $11 * $11;
    var $13 = $12;
    var $14 = $11;
    var $15 = $14 * 2;
    var $16 = $13 - $15;
    var $17 = $16 * 8;
    var $18 = $17;
    var $x_0 = $18;
    label = 7;
    break;
   case 7:
    var $x_0;
    var $20 = $7 + .474;
    var $21 = $20;
    var $22 = $21;
    var $23 = $22 * 7.5;
    var $24 = $23 + 15.811389;
    var $25 = $21 * $21;
    var $26 = $25;
    var $27 = $26 + 1;
    var $28 = Math.sqrt($27);
    var $29 = $28 * 17.5;
    var $30 = $24 - $29;
    var $31 = $30;
    var $32 = $31 > -60;
    if ($32) {
      label = 8;
      break;
    } else {
      var $_0 = 0;
      label = 9;
      break;
    }
   case 8:
    var $34 = $x_0 + $31;
    var $35 = $34;
    var $36 = $35 * .23025850929940458;
    var $37 = Math.exp($36);
    var $38 = $37;
    var $39 = $38;
    var $40 = $39 / .6609193;
    var $41 = $40;
    var $_0 = $41;
    label = 9;
    break;
   case 9:
    var $_0;
    return $_0;
  }
}
function _stereo_demask($f) {
  var $2 = _freq2bark($f);
  return Math.pow(10, (1 - Math.cos(($2 < 15.5 ? $2 : 15.5) / 15.5 * 3.141592653589793)) * 1.25 - 2.5);
}
function _vbrpsy_mask_add($m1, $m2, $b, $delta) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $m1 < 0;
    var $_023 = $1 ? 0 : $m1;
    var $2 = $m2 < 0;
    var $_024 = $2 ? 0 : $m2;
    var $3 = $_023 > 0;
    if ($3) {
      label = 3;
      break;
    } else {
      var $_0 = $_024;
      label = 14;
      break;
    }
   case 3:
    var $5 = $_024 > 0;
    if ($5) {
      label = 4;
      break;
    } else {
      var $_0 = $_023;
      label = 14;
      break;
    }
   case 4:
    var $7 = $_024 > $_023;
    if ($7) {
      label = 5;
      break;
    } else {
      label = 6;
      break;
    }
   case 5:
    var $9 = $_024 / $_023;
    var $ratio_0 = $9;
    label = 7;
    break;
   case 6:
    var $11 = $_023 / $_024;
    var $ratio_0 = $11;
    label = 7;
    break;
   case 7:
    var $ratio_0;
    var $ispos = ($b | 0) > -1;
    var $neg = -$b | 0;
    var $13 = $ispos ? $b : $neg;
    var $14 = ($13 | 0) > ($delta | 0);
    if ($14) {
      label = 11;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    var $16 = HEAPF32[5314460 >> 2];
    var $17 = $ratio_0 < $16;
    if ($17) {
      label = 10;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    var $19 = $_023 + $_024;
    var $_0 = $19;
    label = 14;
    break;
   case 10:
    var $21 = _fast_log2($ratio_0);
    var $22 = $21;
    var $23 = $22 * 4.816479930623698;
    var $24 = $23 & -1;
    var $25 = $_023 + $_024;
    var $26 = 5248064 + ($24 << 2) | 0;
    var $27 = HEAPF32[$26 >> 2];
    var $28 = $25 * $27;
    var $_0 = $28;
    label = 14;
    break;
   case 11:
    var $30 = HEAPF32[5314456 >> 2];
    var $31 = $ratio_0 < $30;
    if ($31) {
      label = 12;
      break;
    } else {
      label = 13;
      break;
    }
   case 12:
    var $33 = $_023 + $_024;
    var $_0 = $33;
    label = 14;
    break;
   case 13:
    var $_1 = $7 ? $_024 : $_023;
    var $_0 = $_1;
    label = 14;
    break;
   case 14:
    var $_0;
    return $_0;
  }
}
function _calc_mask_index_l($gfc, $max, $avg, $mask_idx) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 85796 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = HEAPF32[$avg >> 2];
    var $4 = $avg + 4 | 0;
    var $5 = HEAPF32[$4 >> 2];
    var $6 = $3 + $5;
    var $7 = $6 > 0;
    if ($7) {
      label = 3;
      break;
    } else {
      var $storemerge = 0;
      label = 4;
      break;
    }
   case 3:
    var $9 = HEAPF32[$max >> 2];
    var $10 = $max + 4 | 0;
    var $11 = HEAPF32[$10 >> 2];
    var $12 = $9 < $11;
    var $m_0 = $12 ? $11 : $9;
    var $13 = $m_0 * 2;
    var $14 = $13 - $6;
    var $15 = $14 * 20;
    var $16 = $2 + 1716 | 0;
    var $17 = HEAP32[$16 >> 2];
    var $18 = $2 + 1720 | 0;
    var $19 = HEAP32[$18 >> 2];
    var $20 = $17 - 1 | 0;
    var $21 = $20 + $19 | 0;
    var $22 = $21 | 0;
    var $23 = $6 * $22;
    var $24 = $15 / $23;
    var $25 = $24 & -1;
    var $26 = ($25 | 0) > 8;
    var $27 = $25 & 255;
    var $28 = $26 ? 8 : $27;
    var $storemerge = $28;
    label = 4;
    break;
   case 4:
    var $storemerge;
    HEAP8[$mask_idx] = $storemerge;
    var $30 = $2 + 2148 | 0;
    var $31 = HEAP32[$30 >> 2];
    var $32 = $31 - 1 | 0;
    var $33 = ($32 | 0) > 1;
    var $34 = HEAPF32[$avg >> 2];
    var $35 = $avg + 4 | 0;
    var $36 = HEAPF32[$35 >> 2];
    var $37 = $34 + $36;
    if ($33) {
      var $b_082 = 1;
      var $39 = 0;
      var $38 = $37;
      label = 5;
      break;
    } else {
      var $b_0_lcssa = 1;
      var $_lcssa = 0;
      var $_lcssa81 = $37;
      label = 9;
      break;
    }
   case 5:
    var $38;
    var $39;
    var $b_082;
    var $40 = $b_082 + 1 | 0;
    var $41 = $avg + ($40 << 2) | 0;
    var $42 = HEAPF32[$41 >> 2];
    var $43 = $38 + $42;
    var $44 = $43 > 0;
    if ($44) {
      label = 6;
      break;
    } else {
      label = 8;
      break;
    }
   case 6:
    var $46 = $max + ($39 << 2) | 0;
    var $47 = HEAPF32[$46 >> 2];
    var $48 = $max + ($b_082 << 2) | 0;
    var $49 = HEAPF32[$48 >> 2];
    var $50 = $47 < $49;
    var $m_1 = $50 ? $49 : $47;
    var $51 = $max + ($40 << 2) | 0;
    var $52 = HEAPF32[$51 >> 2];
    var $53 = $m_1 < $52;
    var $m_2 = $53 ? $52 : $m_1;
    var $54 = $m_2 * 3;
    var $55 = $54 - $43;
    var $56 = $55 * 20;
    var $57 = $2 + 1716 + ($39 << 2) | 0;
    var $58 = HEAP32[$57 >> 2];
    var $59 = $2 + 1716 + ($b_082 << 2) | 0;
    var $60 = HEAP32[$59 >> 2];
    var $61 = $2 + 1716 + ($40 << 2) | 0;
    var $62 = HEAP32[$61 >> 2];
    var $63 = $58 - 1 | 0;
    var $64 = $63 + $60 | 0;
    var $65 = $64 + $62 | 0;
    var $66 = $65 | 0;
    var $67 = $43 * $66;
    var $68 = $56 / $67;
    var $69 = $68 & -1;
    var $70 = ($69 | 0) > 8;
    var $71 = $69 & 255;
    var $72 = $70 ? 8 : $71;
    var $73 = $mask_idx + $b_082 | 0;
    HEAP8[$73] = $72;
    label = 7;
    break;
   case 7:
    var $74 = HEAP32[$30 >> 2];
    var $75 = $74 - 1 | 0;
    var $76 = ($40 | 0) < ($75 | 0);
    var $77 = $avg + ($b_082 << 2) | 0;
    var $78 = HEAPF32[$77 >> 2];
    var $79 = $avg + ($40 << 2) | 0;
    var $80 = HEAPF32[$79 >> 2];
    var $81 = $78 + $80;
    if ($76) {
      var $39 = $b_082;
      var $b_082 = $40;
      var $38 = $81;
      label = 5;
      break;
    } else {
      var $b_0_lcssa = $40;
      var $_lcssa = $b_082;
      var $_lcssa81 = $81;
      label = 9;
      break;
    }
   case 8:
    var $83 = $mask_idx + $b_082 | 0;
    HEAP8[$83] = 0;
    label = 7;
    break;
   case 9:
    var $_lcssa81;
    var $_lcssa;
    var $b_0_lcssa;
    var $84 = $_lcssa81 > 0;
    if ($84) {
      label = 10;
      break;
    } else {
      label = 11;
      break;
    }
   case 10:
    var $86 = $max + ($_lcssa << 2) | 0;
    var $87 = HEAPF32[$86 >> 2];
    var $88 = $max + ($b_0_lcssa << 2) | 0;
    var $89 = HEAPF32[$88 >> 2];
    var $90 = $87 < $89;
    var $m_3 = $90 ? $89 : $87;
    var $91 = $m_3 * 2;
    var $92 = $91 - $_lcssa81;
    var $93 = $92 * 20;
    var $94 = $2 + 1716 + ($_lcssa << 2) | 0;
    var $95 = HEAP32[$94 >> 2];
    var $96 = $2 + 1716 + ($b_0_lcssa << 2) | 0;
    var $97 = HEAP32[$96 >> 2];
    var $98 = $95 - 1 | 0;
    var $99 = $98 + $97 | 0;
    var $100 = $99 | 0;
    var $101 = $_lcssa81 * $100;
    var $102 = $93 / $101;
    var $103 = $102 & -1;
    var $104 = ($103 | 0) > 8;
    var $105 = $103 & 255;
    var $106 = $104 ? 8 : $105;
    var $107 = $mask_idx + $b_0_lcssa | 0;
    HEAP8[$107] = $106;
    label = 12;
    break;
   case 11:
    var $109 = $mask_idx + $b_0_lcssa | 0;
    HEAP8[$109] = 0;
    label = 12;
    break;
   case 12:
    return;
  }
}
_calc_mask_index_l["X"] = 1;
function _psycho_loudness_approx($energy, $eql_w) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $i_07 = 0;
    var $loudness_power_08 = 0;
    label = 3;
    break;
   case 3:
    var $loudness_power_08;
    var $i_07;
    var $2 = $energy + ($i_07 << 2) | 0;
    var $3 = HEAPF32[$2 >> 2];
    var $4 = $eql_w + ($i_07 << 2) | 0;
    var $5 = HEAPF32[$4 >> 2];
    var $6 = $3 * $5;
    var $7 = $loudness_power_08 + $6;
    var $8 = $i_07 + 1 | 0;
    var $exitcond = ($8 | 0) == 512;
    if ($exitcond) {
      label = 4;
      break;
    } else {
      var $i_07 = $8;
      var $loudness_power_08 = $7;
      label = 3;
      break;
    }
   case 4:
    var $10 = $7;
    var $11 = $10 * 8.974871343596633e-12;
    var $12 = $11;
    return $12;
  }
}
function _init_xrpow_core_init($gfc) {
  HEAP32[$gfc + 85820 >> 2] = 48;
  return;
}
function _init_xrpow_core_c($cod_info, $xrpow, $upper, $sum) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    HEAPF32[$sum >> 2] = 0;
    var $1 = ($upper | 0) < 0;
    if ($1) {
      label = 7;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $2 = $cod_info + 4764 | 0;
    var $3 = $upper + 1 | 0;
    var $i_016 = 0;
    label = 4;
    break;
   case 4:
    var $i_016;
    var $5 = $cod_info + ($i_016 << 2) | 0;
    var $6 = HEAPF32[$5 >> 2];
    var $fabsf = Math.abs($6);
    var $7 = HEAPF32[$sum >> 2];
    var $8 = $fabsf + $7;
    HEAPF32[$sum >> 2] = $8;
    var $9 = $fabsf;
    var $10 = Math.sqrt($9);
    var $11 = $9 * $10;
    var $12 = Math.sqrt($11);
    var $13 = $12;
    var $14 = $xrpow + ($i_016 << 2) | 0;
    HEAPF32[$14 >> 2] = $13;
    var $15 = HEAPF32[$2 >> 2];
    var $16 = $13 > $15;
    if ($16) {
      label = 5;
      break;
    } else {
      label = 6;
      break;
    }
   case 5:
    HEAPF32[$2 >> 2] = $13;
    label = 6;
    break;
   case 6:
    var $19 = $i_016 + 1 | 0;
    var $exitcond = ($19 | 0) == ($3 | 0);
    if ($exitcond) {
      label = 7;
      break;
    } else {
      var $i_016 = $19;
      label = 4;
      break;
    }
   case 7:
    return;
  }
}
function _VBR_old_iteration_loop($gfc, $pe, $ms_ener_ratio, $ratio) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 3040 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $l3_xmin = __stackBase__;
    var $xrpow = __stackBase__ + 624;
    var $bands = __stackBase__ + 2928;
    var $frameBits = __stackBase__ + 2944;
    var $min_bits = __stackBase__ + 3004;
    var $max_bits = __stackBase__ + 3020;
    var $mean_bits = __stackBase__ + 3036;
    var $1 = $l3_xmin | 0;
    var $2 = $frameBits | 0;
    var $3 = $min_bits | 0;
    var $4 = $max_bits | 0;
    var $5 = $bands | 0;
    var $6 = _VBR_old_prepare($gfc, $pe, $ms_ener_ratio, $ratio, $1, $2, $3, $4, $5);
    var $7 = $gfc + 76 | 0;
    var $8 = ($6 | 0) == 0;
    var $9 = $gfc + 112 | 0;
    var $10 = $gfc + 84740 | 0;
    var $11 = $gfc + 124 | 0;
    var $12 = $gfc + 84740 | 0;
    var $13 = $gfc + 84740 | 0;
    var $14 = $gfc + 116 | 0;
    var $15 = $gfc + 72 | 0;
    var $16 = $xrpow | 0;
    var $17 = $gfc + 85092 | 0;
    var $used_bits_0 = 0;
    var $gr_0 = 0;
    label = 3;
    break;
   case 3:
    var $gr_0;
    var $used_bits_0;
    var $18 = HEAP32[$7 >> 2];
    var $19 = ($gr_0 | 0) < ($18 | 0);
    if ($19) {
      label = 4;
      break;
    } else {
      label = 12;
      break;
    }
   case 4:
    var $20 = HEAP32[$15 >> 2];
    var $21 = ($20 | 0) > 0;
    if ($21) {
      var $ch_063 = 0;
      var $used_bits_165 = $used_bits_0;
      label = 5;
      break;
    } else {
      var $used_bits_1_lcssa = $used_bits_0;
      label = 11;
      break;
    }
   case 5:
    var $used_bits_165;
    var $ch_063;
    var $22 = $gfc + 304 + $gr_0 * 10504 + $ch_063 * 5252 | 0;
    var $23 = _init_xrpow($gfc, $22, $16);
    var $24 = ($23 | 0) == 0;
    if ($24) {
      var $used_bits_2 = $used_bits_165;
      label = 10;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    var $26 = $max_bits + ($gr_0 << 3) + ($ch_063 << 2) | 0;
    var $27 = HEAP32[$26 >> 2];
    var $28 = ($27 | 0) == 0;
    if ($28) {
      var $used_bits_2 = $used_bits_165;
      label = 10;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    var $30 = $l3_xmin + $gr_0 * 312 + $ch_063 * 156 | 0;
    var $31 = $min_bits + ($gr_0 << 3) + ($ch_063 << 2) | 0;
    var $32 = HEAP32[$31 >> 2];
    _VBR_encode_granule($gfc, $22, $30, $16, $ch_063, $32, $27);
    var $33 = HEAP32[$17 >> 2];
    var $34 = $33 & 1;
    var $35 = ($34 | 0) == 0;
    if ($35) {
      label = 9;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    _trancate_smallspectrums($gfc, $22, $30, $16);
    label = 9;
    break;
   case 9:
    var $38 = $gfc + 304 + $gr_0 * 10504 + $ch_063 * 5252 + 4768 | 0;
    var $39 = HEAP32[$38 >> 2];
    var $40 = $gfc + 304 + $gr_0 * 10504 + $ch_063 * 5252 + 4844 | 0;
    var $41 = HEAP32[$40 >> 2];
    var $42 = $39 + $used_bits_165 | 0;
    var $43 = $42 + $41 | 0;
    var $used_bits_2 = $43;
    label = 10;
    break;
   case 10:
    var $used_bits_2;
    var $45 = $ch_063 + 1 | 0;
    var $46 = HEAP32[$15 >> 2];
    var $47 = ($45 | 0) < ($46 | 0);
    if ($47) {
      var $ch_063 = $45;
      var $used_bits_165 = $used_bits_2;
      label = 5;
      break;
    } else {
      var $used_bits_1_lcssa = $used_bits_2;
      label = 11;
      break;
    }
   case 11:
    var $used_bits_1_lcssa;
    var $48 = $gr_0 + 1 | 0;
    var $used_bits_0 = $used_bits_1_lcssa;
    var $gr_0 = $48;
    label = 3;
    break;
   case 12:
    if ($8) {
      label = 15;
      break;
    } else {
      label = 13;
      break;
    }
   case 13:
    var $51 = HEAP32[$11 >> 2];
    var $52 = ($51 | 0) == 0;
    if ($52) {
      label = 14;
      break;
    } else {
      label = 15;
      break;
    }
   case 14:
    HEAP32[$12 >> 2] = 1;
    label = 16;
    break;
   case 15:
    var $55 = HEAP32[$9 >> 2];
    HEAP32[$10 >> 2] = $55;
    label = 16;
    break;
   case 16:
    var $56 = HEAP32[$13 >> 2];
    var $57 = HEAP32[$14 >> 2];
    var $58 = ($56 | 0) < ($57 | 0);
    if ($58) {
      var $59 = $56;
      label = 17;
      break;
    } else {
      label = 19;
      break;
    }
   case 17:
    var $59;
    var $60 = $frameBits + ($59 << 2) | 0;
    var $61 = HEAP32[$60 >> 2];
    var $62 = ($used_bits_0 | 0) > ($61 | 0);
    if ($62) {
      label = 18;
      break;
    } else {
      label = 19;
      break;
    }
   case 18:
    var $64 = $59 + 1 | 0;
    HEAP32[$13 >> 2] = $64;
    var $65 = HEAP32[$14 >> 2];
    var $66 = ($64 | 0) < ($65 | 0);
    if ($66) {
      var $59 = $64;
      label = 17;
      break;
    } else {
      label = 19;
      break;
    }
   case 19:
    var $67 = _ResvFrameBegin($gfc, $mean_bits);
    var $68 = ($used_bits_0 | 0) > ($67 | 0);
    if ($68) {
      label = 22;
      break;
    } else {
      label = 20;
      break;
    }
   case 20:
    var $69 = HEAP32[$7 >> 2];
    var $70 = ($69 | 0) > 0;
    if ($70) {
      label = 21;
      break;
    } else {
      label = 26;
      break;
    }
   case 21:
    var $71 = $gfc + 72 | 0;
    var $gr_157 = 0;
    label = 23;
    break;
   case 22:
    _bitpressure_strategy($gfc, $1, $3, $4);
    var $used_bits_0 = 0;
    var $gr_0 = 0;
    label = 3;
    break;
   case 23:
    var $gr_157;
    var $73 = HEAP32[$71 >> 2];
    var $74 = ($73 | 0) > 0;
    if ($74) {
      var $ch_155 = 0;
      label = 24;
      break;
    } else {
      label = 25;
      break;
    }
   case 24:
    var $ch_155;
    _iteration_finish_one($gfc, $gr_157, $ch_155);
    var $75 = $ch_155 + 1 | 0;
    var $76 = HEAP32[$71 >> 2];
    var $77 = ($75 | 0) < ($76 | 0);
    if ($77) {
      var $ch_155 = $75;
      label = 24;
      break;
    } else {
      label = 25;
      break;
    }
   case 25:
    var $78 = $gr_157 + 1 | 0;
    var $79 = HEAP32[$7 >> 2];
    var $80 = ($78 | 0) < ($79 | 0);
    if ($80) {
      var $gr_157 = $78;
      label = 23;
      break;
    } else {
      label = 26;
      break;
    }
   case 26:
    var $81 = HEAP32[$mean_bits >> 2];
    _ResvFrameEnd($gfc, $81);
    STACKTOP = __stackBase__;
    return;
  }
}
_VBR_old_iteration_loop["X"] = 1;
function _VBR_old_prepare($gfc, $pe, $ms_ener_ratio, $ratio, $l3_xmin, $frameBits, $min_bits, $max_bits, $bands) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 4 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $avg = __stackBase__;
    var $1 = $gfc + 116 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $gfc + 84740 | 0;
    HEAP32[$3 >> 2] = $2;
    var $4 = _ResvFrameBegin($gfc, $avg);
    var $5 = $gfc + 76 | 0;
    var $6 = HEAP32[$5 >> 2];
    var $7 = ($4 | 0) / ($6 | 0) & -1;
    HEAP32[$avg >> 2] = $7;
    _get_framebits($gfc, $frameBits);
    var $8 = HEAP32[$5 >> 2];
    var $9 = ($8 | 0) > 0;
    if ($9) {
      label = 3;
      break;
    } else {
      var $analog_silence_0_lcssa106 = 1;
      label = 21;
      break;
    }
   case 3:
    var $10 = HEAP32[$avg >> 2];
    var $11 = $gfc + 84752 | 0;
    var $12 = $gfc + 304 | 0;
    var $13 = $gfc + 72 | 0;
    var $14 = $gfc + 84912 | 0;
    var $15 = $gfc + 84904 | 0;
    var $16 = $gfc + 84908 | 0;
    var $gr_098 = 0;
    var $analog_silence_0100 = 1;
    var $bits_0101 = 0;
    label = 6;
    break;
   case 4:
    var $17 = ($71 | 0) > 0;
    if ($17) {
      label = 5;
      break;
    } else {
      var $analog_silence_0_lcssa106 = $analog_silence_1_lcssa;
      label = 21;
      break;
    }
   case 5:
    var $18 = $gfc + 72 | 0;
    var $19 = ($bits_1_lcssa | 0) > 0;
    var $gr_188 = 0;
    label = 14;
    break;
   case 6:
    var $bits_0101;
    var $analog_silence_0100;
    var $gr_098;
    var $21 = $max_bits + ($gr_098 << 3) | 0;
    var $22 = _on_pe($gfc, $pe, $21, $10, $gr_098, 0);
    var $23 = HEAP32[$11 >> 2];
    var $24 = ($23 | 0) == 2;
    if ($24) {
      label = 7;
      break;
    } else {
      label = 8;
      break;
    }
   case 7:
    _ms_convert($12, $gr_098);
    var $26 = $ms_ener_ratio + ($gr_098 << 2) | 0;
    var $27 = HEAPF32[$26 >> 2];
    _reduce_side($21, $27, $10, $22);
    label = 8;
    break;
   case 8:
    var $28 = HEAP32[$13 >> 2];
    var $29 = ($28 | 0) > 0;
    if ($29) {
      var $ch_092 = 0;
      var $analog_silence_193 = $analog_silence_0100;
      var $bits_194 = $bits_0101;
      label = 9;
      break;
    } else {
      var $analog_silence_1_lcssa = $analog_silence_0100;
      var $bits_1_lcssa = $bits_0101;
      label = 13;
      break;
    }
   case 9:
    var $bits_194;
    var $analog_silence_193;
    var $ch_092;
    var $30 = $gfc + 304 + $gr_098 * 10504 + $ch_092 * 5252 | 0;
    var $31 = $gfc + 304 + $gr_098 * 10504 + $ch_092 * 5252 + 4788 | 0;
    var $32 = HEAP32[$31 >> 2];
    var $33 = ($32 | 0) == 2;
    var $34 = $pe + ($gr_098 << 3) + ($ch_092 << 2) | 0;
    var $35 = HEAPF32[$34 >> 2];
    var $36 = $35;
    var $37 = $36 / 300;
    var $38 = 3.5 - $37;
    var $39 = Math.exp($38);
    var $40 = $39 + 1;
    if ($33) {
      label = 11;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    var $42 = 1.28 / $40;
    var $43 = $42 - .05;
    var $44 = $43;
    var $45 = HEAPF32[$16 >> 2];
    var $46 = $45 - $44;
    var $masking_lower_db_0 = $46;
    label = 12;
    break;
   case 11:
    var $48 = 2.56 / $40;
    var $49 = $48 - .14;
    var $50 = $49;
    var $51 = HEAPF32[$14 >> 2];
    var $52 = $51 - $50;
    var $masking_lower_db_0 = $52;
    label = 12;
    break;
   case 12:
    var $masking_lower_db_0;
    var $54 = $masking_lower_db_0;
    var $55 = $54 * .1;
    var $56 = Math.pow(10, $55);
    var $57 = $56;
    HEAPF32[$15 >> 2] = $57;
    _init_outer_loop($gfc, $30);
    var $58 = $ratio + $gr_098 * 976 + $ch_092 * 488 | 0;
    var $59 = $l3_xmin + $gr_098 * 312 + $ch_092 * 156 | 0;
    var $60 = _calc_xmin($gfc, $58, $30, $59);
    var $61 = $bands + ($gr_098 << 3) + ($ch_092 << 2) | 0;
    HEAP32[$61 >> 2] = $60;
    var $62 = ($60 | 0) == 0;
    var $analog_silence_1_ = $62 ? $analog_silence_193 : 0;
    var $63 = $min_bits + ($gr_098 << 3) + ($ch_092 << 2) | 0;
    HEAP32[$63 >> 2] = 126;
    var $64 = $max_bits + ($gr_098 << 3) + ($ch_092 << 2) | 0;
    var $65 = HEAP32[$64 >> 2];
    var $66 = $65 + $bits_194 | 0;
    var $67 = $ch_092 + 1 | 0;
    var $68 = HEAP32[$13 >> 2];
    var $69 = ($67 | 0) < ($68 | 0);
    if ($69) {
      var $ch_092 = $67;
      var $analog_silence_193 = $analog_silence_1_;
      var $bits_194 = $66;
      label = 9;
      break;
    } else {
      var $analog_silence_1_lcssa = $analog_silence_1_;
      var $bits_1_lcssa = $66;
      label = 13;
      break;
    }
   case 13:
    var $bits_1_lcssa;
    var $analog_silence_1_lcssa;
    var $70 = $gr_098 + 1 | 0;
    var $71 = HEAP32[$5 >> 2];
    var $72 = ($70 | 0) < ($71 | 0);
    if ($72) {
      var $gr_098 = $70;
      var $analog_silence_0100 = $analog_silence_1_lcssa;
      var $bits_0101 = $bits_1_lcssa;
      label = 6;
      break;
    } else {
      label = 4;
      break;
    }
   case 14:
    var $gr_188;
    var $73 = HEAP32[$18 >> 2];
    var $74 = ($73 | 0) > 0;
    if ($74) {
      var $ch_186 = 0;
      label = 15;
      break;
    } else {
      label = 20;
      break;
    }
   case 15:
    var $ch_186;
    var $75 = HEAP32[$1 >> 2];
    var $76 = $frameBits + ($75 << 2) | 0;
    var $77 = HEAP32[$76 >> 2];
    var $78 = ($bits_1_lcssa | 0) > ($77 | 0);
    var $or_cond = $78 & $19;
    if ($or_cond) {
      label = 16;
      break;
    } else {
      label = 17;
      break;
    }
   case 16:
    var $80 = $max_bits + ($gr_188 << 3) + ($ch_186 << 2) | 0;
    var $81 = HEAP32[$80 >> 2];
    var $82 = $81 * $77 & -1;
    var $83 = ($82 | 0) / ($bits_1_lcssa | 0) & -1;
    HEAP32[$80 >> 2] = $83;
    label = 17;
    break;
   case 17:
    var $85 = $min_bits + ($gr_188 << 3) + ($ch_186 << 2) | 0;
    var $86 = HEAP32[$85 >> 2];
    var $87 = $max_bits + ($gr_188 << 3) + ($ch_186 << 2) | 0;
    var $88 = HEAP32[$87 >> 2];
    var $89 = ($86 | 0) > ($88 | 0);
    if ($89) {
      label = 18;
      break;
    } else {
      label = 19;
      break;
    }
   case 18:
    HEAP32[$85 >> 2] = $88;
    label = 19;
    break;
   case 19:
    var $92 = $ch_186 + 1 | 0;
    var $93 = HEAP32[$18 >> 2];
    var $94 = ($92 | 0) < ($93 | 0);
    if ($94) {
      var $ch_186 = $92;
      label = 15;
      break;
    } else {
      label = 20;
      break;
    }
   case 20:
    var $95 = $gr_188 + 1 | 0;
    var $96 = HEAP32[$5 >> 2];
    var $97 = ($95 | 0) < ($96 | 0);
    if ($97) {
      var $gr_188 = $95;
      label = 14;
      break;
    } else {
      var $analog_silence_0_lcssa106 = $analog_silence_1_lcssa;
      label = 21;
      break;
    }
   case 21:
    var $analog_silence_0_lcssa106;
    STACKTOP = __stackBase__;
    return $analog_silence_0_lcssa106;
  }
}
_VBR_old_prepare["X"] = 1;
function _init_xrpow($gfc, $cod_info, $xrpow) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 4 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $sum = __stackBase__;
    HEAPF32[$sum >> 2] = 0;
    var $1 = $cod_info + 5208 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $cod_info + 4764 | 0;
    HEAPF32[$3 >> 2] = 0;
    var $4 = $xrpow + ($2 << 2) | 0;
    var $5 = $4;
    var $6 = 576 - $2 | 0;
    var $7 = $6 << 2;
    _memset($5, 0, $7);
    var $8 = $gfc + 85820 | 0;
    var $9 = HEAP32[$8 >> 2];
    FUNCTION_TABLE[$9]($cod_info, $xrpow, $2, $sum);
    var $10 = HEAPF32[$sum >> 2];
    var $11 = $10 > 9.999999682655225e-21;
    if ($11) {
      label = 3;
      break;
    } else {
      label = 5;
      break;
    }
   case 3:
    var $13 = $gfc + 85092 | 0;
    var $14 = HEAP32[$13 >> 2];
    var $15 = $14 >>> 1;
    var $_lobit = $15 & 1;
    var $16 = $cod_info + 4864 | 0;
    var $17 = HEAP32[$16 >> 2];
    var $18 = ($17 | 0) > 0;
    if ($18) {
      var $i_015 = 0;
      label = 4;
      break;
    } else {
      var $_0 = 1;
      label = 6;
      break;
    }
   case 4:
    var $i_015;
    var $19 = $gfc + 84932 + ($i_015 << 2) | 0;
    HEAP32[$19 >> 2] = $_lobit;
    var $20 = $i_015 + 1 | 0;
    var $21 = HEAP32[$16 >> 2];
    var $22 = ($20 | 0) < ($21 | 0);
    if ($22) {
      var $i_015 = $20;
      label = 4;
      break;
    } else {
      var $_0 = 1;
      label = 6;
      break;
    }
   case 5:
    var $24 = $cod_info + 2304 | 0;
    var $25 = $24;
    for (var $$dest = $25 >> 2, $$stop = $$dest + 576; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $_0 = 0;
    label = 6;
    break;
   case 6:
    var $_0;
    STACKTOP = __stackBase__;
    return $_0;
  }
}
function _VBR_encode_granule($gfc, $cod_info, $l3_xmin, $xrpow, $ch, $min_bits, $max_bits) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 7556 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $bst_cod_info = __stackBase__;
    var $bst_xrpow = __stackBase__ + 5252;
    var $1 = $max_bits + $min_bits | 0;
    var $2 = ($1 | 0) / 2 & -1;
    var $3 = $gfc + 85088 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $bst_cod_info_2304_idx = $bst_cod_info + 2304 | 0;
    var $bst_cod_info_2304_cast = $bst_cod_info_2304_idx;
    for (var $$dest = $bst_cod_info_2304_cast >> 2, $$stop = $$dest + 576; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $5 = $max_bits - 42 | 0;
    var $6 = $cod_info + 4768 | 0;
    var $7 = $bst_cod_info;
    var $8 = $cod_info;
    var $9 = $bst_xrpow;
    var $10 = $xrpow;
    var $11 = $cod_info;
    var $12 = $bst_cod_info;
    var $13 = $xrpow;
    var $14 = $bst_xrpow;
    var $_0 = $min_bits;
    var $found_0 = 0;
    var $_031 = $max_bits;
    var $this_bits_0 = $2;
    label = 3;
    break;
   case 3:
    var $this_bits_0;
    var $_031;
    var $found_0;
    var $_0;
    var $16 = ($this_bits_0 | 0) > ($5 | 0);
    var $_ = $16 ? 0 : $4;
    HEAP32[$3 >> 2] = $_;
    var $17 = _outer_loop($gfc, $cod_info, $l3_xmin, $xrpow, $ch, $this_bits_0);
    var $18 = ($17 | 0) < 1;
    if ($18) {
      label = 4;
      break;
    } else {
      label = 5;
      break;
    }
   case 4:
    var $20 = HEAP32[$6 >> 2];
    for (var $$src = $8 >> 2, $$dest = $7 >> 2, $$stop = $$src + 1313; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    for (var $$src = $10 >> 2, $$dest = $9 >> 2, $$stop = $$src + 576; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    var $21 = $20 - 32 | 0;
    var $22 = $21 - $_0 | 0;
    var $23 = $21 + $_0 | 0;
    var $24 = ($23 | 0) / 2 & -1;
    var $_1 = $_0;
    var $found_1 = 1;
    var $_132 = $21;
    var $dbits_0 = $22;
    var $this_bits_1 = $24;
    label = 7;
    break;
   case 5:
    var $26 = $this_bits_0 + 32 | 0;
    var $27 = $_031 - $26 | 0;
    var $28 = $_031 + $26 | 0;
    var $29 = ($28 | 0) / 2 & -1;
    var $30 = ($found_0 | 0) == 0;
    if ($30) {
      var $_1 = $26;
      var $found_1 = 0;
      var $_132 = $_031;
      var $dbits_0 = $27;
      var $this_bits_1 = $29;
      label = 7;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    for (var $$src = $12 >> 2, $$dest = $11 >> 2, $$stop = $$src + 1313; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    for (var $$src = $14 >> 2, $$dest = $13 >> 2, $$stop = $$src + 576; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    var $_1 = $26;
    var $found_1 = 2;
    var $_132 = $_031;
    var $dbits_0 = $27;
    var $this_bits_1 = $29;
    label = 7;
    break;
   case 7:
    var $this_bits_1;
    var $dbits_0;
    var $_132;
    var $found_1;
    var $_1;
    var $33 = ($dbits_0 | 0) > 12;
    if ($33) {
      var $_0 = $_1;
      var $found_0 = $found_1;
      var $_031 = $_132;
      var $this_bits_0 = $this_bits_1;
      label = 3;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    HEAP32[$3 >> 2] = $4;
    var $35 = ($found_1 | 0) == 2;
    if ($35) {
      label = 9;
      break;
    } else {
      label = 10;
      break;
    }
   case 9:
    var $37 = $cod_info + 2304 | 0;
    var $38 = $37;
    for (var $$src = $bst_cod_info_2304_cast >> 2, $$dest = $38 >> 2, $$stop = $$src + 576; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    label = 10;
    break;
   case 10:
    STACKTOP = __stackBase__;
    return;
  }
}
_VBR_encode_granule["X"] = 1;
function _trancate_smallspectrums($gfc, $gi, $l3_xmin, $work) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 180 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $distort = __stackBase__;
    var $dummy = __stackBase__ + 156;
    var $1 = $gfc + 85092 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $2 & 4;
    var $4 = ($3 | 0) == 0;
    if ($4) {
      label = 3;
      break;
    } else {
      label = 4;
      break;
    }
   case 3:
    var $6 = $gi + 4788 | 0;
    var $7 = HEAP32[$6 >> 2];
    var $8 = ($7 | 0) == 2;
    if ($8) {
      label = 32;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $10 = HEAP32[$1 >> 2];
    var $11 = $10 & 128;
    var $12 = ($11 | 0) == 0;
    if ($12) {
      label = 5;
      break;
    } else {
      label = 32;
      break;
    }
   case 5:
    var $14 = $distort | 0;
    var $15 = _calc_noise($gi, $l3_xmin, $14, $dummy, 0);
    var $j_0108 = 0;
    label = 6;
    break;
   case 6:
    var $j_0108;
    var $17 = $gi + 2304 + ($j_0108 << 2) | 0;
    var $18 = HEAP32[$17 >> 2];
    var $19 = ($18 | 0) == 0;
    if ($19) {
      var $xr_0 = 0;
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    var $21 = $gi + ($j_0108 << 2) | 0;
    var $22 = HEAPF32[$21 >> 2];
    var $fabsf = Math.abs($22);
    var $xr_0 = $fabsf;
    label = 8;
    break;
   case 8:
    var $xr_0;
    var $24 = $work + ($j_0108 << 2) | 0;
    HEAPF32[$24 >> 2] = $xr_0;
    var $25 = $j_0108 + 1 | 0;
    var $exitcond = ($25 | 0) == 576;
    if ($exitcond) {
      label = 9;
      break;
    } else {
      var $j_0108 = $25;
      label = 6;
      break;
    }
   case 9:
    var $27 = $gi + 4788 | 0;
    var $28 = HEAP32[$27 >> 2];
    var $29 = ($28 | 0) == 2;
    var $_ = $29 ? 6 : 8;
    var $30 = $gi + 4864 | 0;
    var $sfb_0 = $_;
    var $j_1 = 0;
    label = 10;
    break;
   case 10:
    var $j_1;
    var $sfb_0;
    var $32 = $gi + 4872 + ($sfb_0 << 2) | 0;
    var $33 = HEAP32[$32 >> 2];
    var $34 = $33 + $j_1 | 0;
    var $35 = $distort + ($sfb_0 << 2) | 0;
    var $36 = HEAPF32[$35 >> 2];
    var $37 = $36 < 1;
    if ($37) {
      label = 11;
      break;
    } else {
      label = 30;
      break;
    }
   case 11:
    var $39 = $work + ($j_1 << 2) | 0;
    var $40 = $39;
    _qsort($40, $33, 4, 18);
    var $41 = $34 - 1 | 0;
    var $42 = $work + ($41 << 2) | 0;
    var $43 = HEAPF32[$42 >> 2];
    var $44 = $43 == 0;
    if ($44) {
      label = 13;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    var $fabsf91 = Math.abs($43);
    var $46 = $fabsf91;
    var $47 = $46 * 9.999999974752427e-7;
    var $48 = $46 > $47;
    if ($48) {
      label = 14;
      break;
    } else {
      label = 30;
      break;
    }
   case 13:
    var $50 = $43 == 0;
    if ($50) {
      label = 30;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    var $52 = HEAPF32[$35 >> 2];
    var $53 = $52;
    var $54 = 1 - $53;
    var $55 = $l3_xmin + ($sfb_0 << 2) | 0;
    var $56 = HEAPF32[$55 >> 2];
    var $57 = $56;
    var $58 = $54 * $57;
    var $59 = $58;
    var $start_0 = 0;
    var $allowedNoise_0 = $59;
    label = 15;
    break;
   case 15:
    var $allowedNoise_0;
    var $start_0;
    var $61 = $start_0 + 1 | 0;
    var $62 = ($61 | 0) < ($33 | 0);
    if ($62) {
      label = 16;
      break;
    } else {
      var $nsame_0_lcssa = 1;
      var $_lcssa = $61;
      var $_lcssa99 = 0;
      label = 21;
      break;
    }
   case 16:
    var $63 = $start_0 + $34 | 0;
    var $64 = $63 - $33 | 0;
    var $65 = $work + ($64 << 2) | 0;
    var $66 = HEAPF32[$65 >> 2];
    var $fabsf92 = Math.abs($66);
    var $67 = $start_0 + $j_1 | 0;
    var $68 = $fabsf92;
    var $69 = $68 * 9.999999974752427e-7;
    var $nsame_0100 = 1;
    var $71 = $61;
    label = 17;
    break;
   case 17:
    var $71;
    var $nsame_0100;
    var $72 = $67 + $nsame_0100 | 0;
    var $73 = $work + ($72 << 2) | 0;
    var $74 = HEAPF32[$73 >> 2];
    var $fabsf93 = Math.abs($74);
    var $75 = $fabsf92 > $fabsf93;
    var $76 = $66 - $74;
    var $fabsf94 = Math.abs($76);
    var $77 = $fabsf94;
    if ($75) {
      label = 18;
      break;
    } else {
      label = 19;
      break;
    }
   case 18:
    var $79 = $77 > $69;
    if ($79) {
      var $nsame_0_lcssa = $nsame_0100;
      var $_lcssa = $71;
      var $_lcssa99 = 1;
      label = 21;
      break;
    } else {
      label = 20;
      break;
    }
   case 19:
    var $81 = $fabsf93;
    var $82 = $81 * 9.999999974752427e-7;
    var $83 = $77 > $82;
    if ($83) {
      var $nsame_0_lcssa = $nsame_0100;
      var $_lcssa = $71;
      var $_lcssa99 = 1;
      label = 21;
      break;
    } else {
      label = 20;
      break;
    }
   case 20:
    var $85 = $nsame_0100 + 1 | 0;
    var $86 = $85 + $start_0 | 0;
    var $87 = ($86 | 0) < ($33 | 0);
    if ($87) {
      var $nsame_0100 = $85;
      var $71 = $86;
      label = 17;
      break;
    } else {
      var $nsame_0_lcssa = $85;
      var $_lcssa = $86;
      var $_lcssa99 = 0;
      label = 21;
      break;
    }
   case 21:
    var $_lcssa99;
    var $_lcssa;
    var $nsame_0_lcssa;
    var $88 = $j_1 + $start_0 | 0;
    var $89 = $work + ($88 << 2) | 0;
    var $90 = HEAPF32[$89 >> 2];
    var $91 = $90 * $90;
    var $92 = $nsame_0_lcssa | 0;
    var $93 = $92 * $91;
    var $94 = $allowedNoise_0 < $93;
    if ($94) {
      label = 22;
      break;
    } else {
      label = 23;
      break;
    }
   case 22:
    var $96 = ($start_0 | 0) == 0;
    if ($96) {
      label = 30;
      break;
    } else {
      label = 24;
      break;
    }
   case 23:
    var $98 = $allowedNoise_0 - $93;
    if ($_lcssa99) {
      var $start_0 = $_lcssa;
      var $allowedNoise_0 = $98;
      label = 15;
      break;
    } else {
      label = 30;
      break;
    }
   case 24:
    var $100 = $88 - 1 | 0;
    var $101 = $work + ($100 << 2) | 0;
    var $102 = HEAPF32[$101 >> 2];
    var $103 = $102 == 0;
    if ($103) {
      label = 26;
      break;
    } else {
      label = 25;
      break;
    }
   case 25:
    var $phitmp = $102;
    var $105 = Math.abs($phitmp);
    var $106 = $105 * 9.999999974752427e-7;
    var $107 = $105 > $106;
    if ($107) {
      var $width_0 = $33;
      label = 27;
      break;
    } else {
      label = 30;
      break;
    }
   case 26:
    var $109 = $102 == 0;
    if ($109) {
      label = 30;
      break;
    } else {
      var $width_0 = $33;
      label = 27;
      break;
    }
   case 27:
    var $width_0;
    var $110 = $34 - $width_0 | 0;
    var $111 = $gi + ($110 << 2) | 0;
    var $112 = HEAPF32[$111 >> 2];
    var $fabsf95 = Math.abs($112);
    var $113 = $fabsf95 > $102;
    if ($113) {
      label = 29;
      break;
    } else {
      label = 28;
      break;
    }
   case 28:
    var $115 = $gi + 2304 + ($110 << 2) | 0;
    HEAP32[$115 >> 2] = 0;
    label = 29;
    break;
   case 29:
    var $117 = $width_0 - 1 | 0;
    var $118 = ($117 | 0) > 0;
    if ($118) {
      var $width_0 = $117;
      label = 27;
      break;
    } else {
      label = 30;
      break;
    }
   case 30:
    var $119 = $sfb_0 + 1 | 0;
    var $120 = HEAP32[$30 >> 2];
    var $121 = ($119 | 0) < ($120 | 0);
    if ($121) {
      var $sfb_0 = $119;
      var $j_1 = $34;
      label = 10;
      break;
    } else {
      label = 31;
      break;
    }
   case 31:
    var $123 = _noquant_count_bits($gfc, $gi, 0);
    var $124 = $gi + 4768 | 0;
    HEAP32[$124 >> 2] = $123;
    label = 32;
    break;
   case 32:
    STACKTOP = __stackBase__;
    return;
  }
}
_trancate_smallspectrums["X"] = 1;
function _bitpressure_strategy($gfc, $l3_xmin, $min_bits, $max_bits) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 76 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($2 | 0) > 0;
    if ($3) {
      label = 3;
      break;
    } else {
      label = 12;
      break;
    }
   case 3:
    var $4 = $gfc + 72 | 0;
    var $gr_048 = 0;
    label = 4;
    break;
   case 4:
    var $gr_048;
    var $5 = HEAP32[$4 >> 2];
    var $6 = ($5 | 0) > 0;
    if ($6) {
      var $ch_045 = 0;
      label = 5;
      break;
    } else {
      label = 11;
      break;
    }
   case 5:
    var $ch_045;
    var $7 = $l3_xmin + $gr_048 * 312 + $ch_045 * 156 | 0;
    var $8 = $gfc + 304 + $gr_048 * 10504 + $ch_045 * 5252 + 4856 | 0;
    var $9 = HEAP32[$8 >> 2];
    var $10 = ($9 | 0) > 0;
    if ($10) {
      var $sfb_039 = 0;
      var $pxmin_040 = $7;
      label = 6;
      break;
    } else {
      var $pxmin_0_lcssa = $7;
      label = 7;
      break;
    }
   case 6:
    var $pxmin_040;
    var $sfb_039;
    var $11 = $sfb_039 | 0;
    var $12 = $11 * .029;
    var $13 = $11 * $12;
    var $14 = $13 / 22;
    var $15 = $14 / 22;
    var $16 = $15 + 1;
    var $17 = $pxmin_040 + 4 | 0;
    var $18 = HEAPF32[$pxmin_040 >> 2];
    var $19 = $18;
    var $20 = $16 * $19;
    var $21 = $20;
    HEAPF32[$pxmin_040 >> 2] = $21;
    var $22 = $sfb_039 + 1 | 0;
    var $23 = HEAP32[$8 >> 2];
    var $24 = ($22 | 0) < ($23 | 0);
    if ($24) {
      var $sfb_039 = $22;
      var $pxmin_040 = $17;
      label = 6;
      break;
    } else {
      var $pxmin_0_lcssa = $17;
      label = 7;
      break;
    }
   case 7:
    var $pxmin_0_lcssa;
    var $25 = $gfc + 304 + $gr_048 * 10504 + $ch_045 * 5252 + 4788 | 0;
    var $26 = HEAP32[$25 >> 2];
    var $27 = ($26 | 0) == 2;
    if ($27) {
      label = 8;
      break;
    } else {
      label = 10;
      break;
    }
   case 8:
    var $29 = $gfc + 304 + $gr_048 * 10504 + $ch_045 * 5252 + 4852 | 0;
    var $30 = HEAP32[$29 >> 2];
    var $31 = ($30 | 0) < 13;
    if ($31) {
      var $sfb_141 = $30;
      var $pxmin_142 = $pxmin_0_lcssa;
      label = 9;
      break;
    } else {
      label = 10;
      break;
    }
   case 9:
    var $pxmin_142;
    var $sfb_141;
    var $32 = $sfb_141 | 0;
    var $33 = $32 * .029;
    var $34 = $32 * $33;
    var $35 = $34 / 13;
    var $36 = $35 / 13;
    var $37 = $36 + 1;
    var $38 = $pxmin_142 + 4 | 0;
    var $39 = HEAPF32[$pxmin_142 >> 2];
    var $40 = $39;
    var $41 = $37 * $40;
    var $42 = $41;
    HEAPF32[$pxmin_142 >> 2] = $42;
    var $43 = $pxmin_142 + 8 | 0;
    var $44 = HEAPF32[$38 >> 2];
    var $45 = $44;
    var $46 = $37 * $45;
    var $47 = $46;
    HEAPF32[$38 >> 2] = $47;
    var $48 = $pxmin_142 + 12 | 0;
    var $49 = HEAPF32[$43 >> 2];
    var $50 = $49;
    var $51 = $37 * $50;
    var $52 = $51;
    HEAPF32[$43 >> 2] = $52;
    var $53 = $sfb_141 + 1 | 0;
    var $exitcond = ($53 | 0) == 13;
    if ($exitcond) {
      label = 10;
      break;
    } else {
      var $sfb_141 = $53;
      var $pxmin_142 = $48;
      label = 9;
      break;
    }
   case 10:
    var $54 = $min_bits + ($gr_048 << 3) + ($ch_045 << 2) | 0;
    var $55 = HEAP32[$54 >> 2];
    var $56 = $55 | 0;
    var $57 = $max_bits + ($gr_048 << 3) + ($ch_045 << 2) | 0;
    var $58 = HEAP32[$57 >> 2];
    var $59 = $58 | 0;
    var $60 = $59 * .9;
    var $61 = $56 > $60;
    var $_ = $61 ? $56 : $60;
    var $62 = $_ & -1;
    HEAP32[$57 >> 2] = $62;
    var $63 = $ch_045 + 1 | 0;
    var $64 = HEAP32[$4 >> 2];
    var $65 = ($63 | 0) < ($64 | 0);
    if ($65) {
      var $ch_045 = $63;
      label = 5;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    var $66 = $gr_048 + 1 | 0;
    var $67 = HEAP32[$1 >> 2];
    var $68 = ($66 | 0) < ($67 | 0);
    if ($68) {
      var $gr_048 = $66;
      label = 4;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    return;
  }
}
_bitpressure_strategy["X"] = 1;
function _ms_convert($l3_side, $gr) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $i_015 = 0;
    label = 3;
    break;
   case 3:
    var $i_015;
    var $2 = $l3_side + $gr * 10504 + ($i_015 << 2) | 0;
    var $3 = HEAPF32[$2 >> 2];
    var $4 = $l3_side + $gr * 10504 + 5252 + ($i_015 << 2) | 0;
    var $5 = HEAPF32[$4 >> 2];
    var $6 = $3 + $5;
    var $7 = $6 * .7071067690849304;
    HEAPF32[$2 >> 2] = $7;
    var $8 = $3 - $5;
    var $9 = $8 * .7071067690849304;
    HEAPF32[$4 >> 2] = $9;
    var $10 = $i_015 + 1 | 0;
    var $exitcond = ($10 | 0) == 576;
    if ($exitcond) {
      label = 4;
      break;
    } else {
      var $i_015 = $10;
      label = 3;
      break;
    }
   case 4:
    return;
  }
}
function _iteration_finish_one($gfc, $gr, $ch) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 304 | 0;
    var $2 = $gfc + 304 + $gr * 10504 + $ch * 5252 | 0;
    _best_scalefac_store($gfc, $gr, $ch, $1);
    var $3 = $gfc + 36 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) == 1;
    if ($5) {
      label = 3;
      break;
    } else {
      label = 4;
      break;
    }
   case 3:
    _best_huffman_divide($gfc, $2);
    label = 4;
    break;
   case 4:
    _ResvAdjust($gfc, $2);
    return;
  }
}
function _VBR_new_prepare($gfc, $pe, $ratio, $l3_xmin, $frameBits, $max_bits, $max_resv) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 4 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $avg = __stackBase__;
    var $1 = $gfc + 152 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($2 | 0) == 0;
    if ($3) {
      label = 3;
      break;
    } else {
      label = 4;
      break;
    }
   case 3:
    var $5 = $gfc + 116 | 0;
    var $6 = HEAP32[$5 >> 2];
    var $7 = $gfc + 84740 | 0;
    HEAP32[$7 >> 2] = $6;
    var $8 = _ResvFrameBegin($gfc, $avg);
    var $9 = $gfc + 52140 | 0;
    var $10 = HEAP32[$9 >> 2];
    HEAP32[$max_resv >> 2] = $10;
    _get_framebits($gfc, $frameBits);
    var $11 = HEAP32[$5 >> 2];
    var $12 = $frameBits + ($11 << 2) | 0;
    var $13 = HEAP32[$12 >> 2];
    var $maximum_framebits_0 = $13;
    label = 5;
    break;
   case 4:
    var $15 = $gfc + 84740 | 0;
    HEAP32[$15 >> 2] = 0;
    var $16 = _ResvFrameBegin($gfc, $avg);
    HEAP32[$frameBits >> 2] = $16;
    var $17 = $gfc + 52140 | 0;
    var $18 = HEAP32[$17 >> 2];
    HEAP32[$max_resv >> 2] = $18;
    var $maximum_framebits_0 = $16;
    label = 5;
    break;
   case 5:
    var $maximum_framebits_0;
    var $20 = $gfc + 76 | 0;
    var $21 = HEAP32[$20 >> 2];
    var $22 = ($21 | 0) > 0;
    if ($22) {
      label = 6;
      break;
    } else {
      var $analog_silence_0_lcssa8586 = 1;
      label = 20;
      break;
    }
   case 6:
    var $23 = HEAP32[$avg >> 2];
    var $24 = $gfc + 84752 | 0;
    var $25 = $gfc + 304 | 0;
    var $26 = $gfc + 72 | 0;
    var $27 = $gfc + 84908 | 0;
    var $28 = $gfc + 84904 | 0;
    var $analog_silence_076 = 1;
    var $bits_077 = 0;
    var $gr_078 = 0;
    label = 9;
    break;
   case 7:
    var $29 = ($58 | 0) > 0;
    if ($29) {
      label = 8;
      break;
    } else {
      label = 19;
      break;
    }
   case 8:
    var $30 = $gfc + 72 | 0;
    var $31 = ($bits_1_lcssa | 0) > ($maximum_framebits_0 | 0);
    var $32 = ($bits_1_lcssa | 0) > 0;
    var $or_cond = $31 & $32;
    var $gr_166 = 0;
    label = 14;
    break;
   case 9:
    var $gr_078;
    var $bits_077;
    var $analog_silence_076;
    var $34 = $max_bits + ($gr_078 << 3) | 0;
    var $35 = _on_pe($gfc, $pe, $34, $23, $gr_078, 0);
    var $36 = HEAP32[$24 >> 2];
    var $37 = ($36 | 0) == 2;
    if ($37) {
      label = 10;
      break;
    } else {
      label = 11;
      break;
    }
   case 10:
    _ms_convert($25, $gr_078);
    label = 11;
    break;
   case 11:
    var $39 = HEAP32[$26 >> 2];
    var $40 = ($39 | 0) > 0;
    if ($40) {
      var $ch_070 = 0;
      var $analog_silence_171 = $analog_silence_076;
      var $bits_172 = $bits_077;
      label = 12;
      break;
    } else {
      var $analog_silence_1_lcssa = $analog_silence_076;
      var $bits_1_lcssa = $bits_077;
      label = 13;
      break;
    }
   case 12:
    var $bits_172;
    var $analog_silence_171;
    var $ch_070;
    var $41 = $gfc + 304 + $gr_078 * 10504 + $ch_070 * 5252 | 0;
    var $42 = HEAPF32[$27 >> 2];
    var $43 = $42;
    var $44 = $43 * .1;
    var $45 = Math.pow(10, $44);
    var $46 = $45;
    HEAPF32[$28 >> 2] = $46;
    _init_outer_loop($gfc, $41);
    var $47 = $ratio + $gr_078 * 976 + $ch_070 * 488 | 0;
    var $48 = $l3_xmin + $gr_078 * 312 + $ch_070 * 156 | 0;
    var $49 = _calc_xmin($gfc, $47, $41, $48);
    var $50 = ($49 | 0) == 0;
    var $analog_silence_1_ = $50 ? $analog_silence_171 : 0;
    var $51 = $max_bits + ($gr_078 << 3) + ($ch_070 << 2) | 0;
    var $52 = HEAP32[$51 >> 2];
    var $53 = $52 + $bits_172 | 0;
    var $54 = $ch_070 + 1 | 0;
    var $55 = HEAP32[$26 >> 2];
    var $56 = ($54 | 0) < ($55 | 0);
    if ($56) {
      var $ch_070 = $54;
      var $analog_silence_171 = $analog_silence_1_;
      var $bits_172 = $53;
      label = 12;
      break;
    } else {
      var $analog_silence_1_lcssa = $analog_silence_1_;
      var $bits_1_lcssa = $53;
      label = 13;
      break;
    }
   case 13:
    var $bits_1_lcssa;
    var $analog_silence_1_lcssa;
    var $57 = $gr_078 + 1 | 0;
    var $58 = HEAP32[$20 >> 2];
    var $59 = ($57 | 0) < ($58 | 0);
    if ($59) {
      var $analog_silence_076 = $analog_silence_1_lcssa;
      var $bits_077 = $bits_1_lcssa;
      var $gr_078 = $57;
      label = 9;
      break;
    } else {
      label = 7;
      break;
    }
   case 14:
    var $gr_166;
    var $60 = HEAP32[$30 >> 2];
    var $61 = ($60 | 0) > 0;
    if ($61) {
      var $ch_164 = 0;
      label = 15;
      break;
    } else {
      label = 18;
      break;
    }
   case 15:
    var $ch_164;
    if ($or_cond) {
      label = 16;
      break;
    } else {
      label = 17;
      break;
    }
   case 16:
    var $63 = $max_bits + ($gr_166 << 3) + ($ch_164 << 2) | 0;
    var $64 = HEAP32[$63 >> 2];
    var $65 = $64 * $maximum_framebits_0 & -1;
    var $66 = ($65 | 0) / ($bits_1_lcssa | 0) & -1;
    HEAP32[$63 >> 2] = $66;
    label = 17;
    break;
   case 17:
    var $68 = $ch_164 + 1 | 0;
    var $69 = HEAP32[$30 >> 2];
    var $70 = ($68 | 0) < ($69 | 0);
    if ($70) {
      var $ch_164 = $68;
      label = 15;
      break;
    } else {
      label = 18;
      break;
    }
   case 18:
    var $71 = $gr_166 + 1 | 0;
    var $72 = HEAP32[$20 >> 2];
    var $73 = ($71 | 0) < ($72 | 0);
    if ($73) {
      var $gr_166 = $71;
      label = 14;
      break;
    } else {
      label = 19;
      break;
    }
   case 19:
    var $74 = ($analog_silence_1_lcssa | 0) == 0;
    if ($74) {
      var $analog_silence_0_lcssa8587 = 0;
      label = 21;
      break;
    } else {
      var $analog_silence_0_lcssa8586 = $analog_silence_1_lcssa;
      label = 20;
      break;
    }
   case 20:
    var $analog_silence_0_lcssa8586;
    HEAP32[$max_resv >> 2] = 0;
    var $analog_silence_0_lcssa8587 = $analog_silence_0_lcssa8586;
    label = 21;
    break;
   case 21:
    var $analog_silence_0_lcssa8587;
    STACKTOP = __stackBase__;
    return $analog_silence_0_lcssa8587;
  }
}
_VBR_new_prepare["X"] = 1;
function _ABR_iteration_loop($gfc, $pe, $ms_ener_ratio, $ratio) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 2488 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $l3_xmin = __stackBase__;
    var $xrpow = __stackBase__ + 156;
    var $targ_bits = __stackBase__ + 2460;
    var $mean_bits = __stackBase__ + 2476;
    var $max_frame_bits = __stackBase__ + 2480;
    var $analog_silence_bits = __stackBase__ + 2484;
    var $1 = $gfc + 304 | 0;
    HEAP32[$mean_bits >> 2] = 0;
    var $2 = $targ_bits | 0;
    _calc_target_bits($gfc, $pe, $ms_ener_ratio, $2, $analog_silence_bits, $max_frame_bits);
    var $3 = $gfc + 76 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) > 0;
    if ($5) {
      label = 3;
      break;
    } else {
      label = 13;
      break;
    }
   case 3:
    var $6 = $gfc + 84752 | 0;
    var $7 = $gfc + 72 | 0;
    var $8 = $gfc + 84908 | 0;
    var $9 = $gfc + 84912 | 0;
    var $10 = $gfc + 84904 | 0;
    var $11 = $xrpow | 0;
    var $12 = $l3_xmin | 0;
    var $13 = HEAP32[$analog_silence_bits >> 2];
    var $gr_046 = 0;
    label = 4;
    break;
   case 4:
    var $gr_046;
    var $15 = HEAP32[$6 >> 2];
    var $16 = ($15 | 0) == 2;
    if ($16) {
      label = 5;
      break;
    } else {
      label = 6;
      break;
    }
   case 5:
    _ms_convert($1, $gr_046);
    label = 6;
    break;
   case 6:
    var $18 = HEAP32[$7 >> 2];
    var $19 = ($18 | 0) > 0;
    if ($19) {
      var $ch_042 = 0;
      label = 7;
      break;
    } else {
      label = 12;
      break;
    }
   case 7:
    var $ch_042;
    var $20 = $gfc + 304 + $gr_046 * 10504 + $ch_042 * 5252 | 0;
    var $21 = $gfc + 304 + $gr_046 * 10504 + $ch_042 * 5252 + 4788 | 0;
    var $22 = HEAP32[$21 >> 2];
    var $23 = ($22 | 0) == 2;
    var $masking_lower_db_0_in = $23 ? $9 : $8;
    var $masking_lower_db_0 = HEAPF32[$masking_lower_db_0_in >> 2];
    var $24 = $masking_lower_db_0;
    var $25 = $24 * .1;
    var $26 = Math.pow(10, $25);
    var $27 = $26;
    HEAPF32[$10 >> 2] = $27;
    _init_outer_loop($gfc, $20);
    var $28 = _init_xrpow($gfc, $20, $11);
    var $29 = ($28 | 0) == 0;
    if ($29) {
      label = 11;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    var $31 = $ratio + $gr_046 * 976 + $ch_042 * 488 | 0;
    var $32 = _calc_xmin($gfc, $31, $20, $12);
    var $33 = ($32 | 0) == 0;
    if ($33) {
      label = 9;
      break;
    } else {
      label = 10;
      break;
    }
   case 9:
    var $35 = $targ_bits + ($gr_046 << 3) + ($ch_042 << 2) | 0;
    HEAP32[$35 >> 2] = $13;
    label = 10;
    break;
   case 10:
    var $37 = $targ_bits + ($gr_046 << 3) + ($ch_042 << 2) | 0;
    var $38 = HEAP32[$37 >> 2];
    var $39 = _outer_loop($gfc, $20, $12, $11, $ch_042, $38);
    label = 11;
    break;
   case 11:
    _iteration_finish_one($gfc, $gr_046, $ch_042);
    var $41 = $ch_042 + 1 | 0;
    var $42 = HEAP32[$7 >> 2];
    var $43 = ($41 | 0) < ($42 | 0);
    if ($43) {
      var $ch_042 = $41;
      label = 7;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    var $44 = $gr_046 + 1 | 0;
    var $45 = HEAP32[$3 >> 2];
    var $46 = ($44 | 0) < ($45 | 0);
    if ($46) {
      var $gr_046 = $44;
      label = 4;
      break;
    } else {
      label = 13;
      break;
    }
   case 13:
    var $47 = $gfc + 112 | 0;
    var $48 = HEAP32[$47 >> 2];
    var $49 = $gfc + 84740 | 0;
    HEAP32[$49 >> 2] = $48;
    var $50 = $gfc + 116 | 0;
    var $51 = HEAP32[$50 >> 2];
    var $52 = ($48 | 0) > ($51 | 0);
    if ($52) {
      label = 16;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    var $53 = _ResvFrameBegin($gfc, $mean_bits);
    var $54 = ($53 | 0) > -1;
    if ($54) {
      label = 16;
      break;
    } else {
      label = 15;
      break;
    }
   case 15:
    var $56 = HEAP32[$49 >> 2];
    var $57 = $56 + 1 | 0;
    HEAP32[$49 >> 2] = $57;
    var $58 = HEAP32[$50 >> 2];
    var $59 = ($57 | 0) > ($58 | 0);
    if ($59) {
      label = 16;
      break;
    } else {
      label = 14;
      break;
    }
   case 16:
    var $60 = HEAP32[$mean_bits >> 2];
    _ResvFrameEnd($gfc, $60);
    STACKTOP = __stackBase__;
    return;
  }
}
_ABR_iteration_loop["X"] = 1;
function _calc_target_bits($gfc, $pe, $ms_ener_ratio, $targ_bits, $analog_silence_bits, $max_frame_bits) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 4 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $mean_bits = __stackBase__;
    var $1 = $gfc + 76 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $gfc + 116 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = $gfc + 84740 | 0;
    HEAP32[$5 >> 2] = $4;
    var $6 = _ResvFrameBegin($gfc, $mean_bits);
    HEAP32[$max_frame_bits >> 2] = $6;
    HEAP32[$5 >> 2] = 1;
    var $7 = _getframebits($gfc);
    var $8 = $gfc + 24 | 0;
    var $9 = HEAP32[$8 >> 2];
    var $10 = $9 << 3;
    var $11 = $7 - $10 | 0;
    var $12 = HEAP32[$1 >> 2];
    var $13 = $gfc + 72 | 0;
    var $14 = HEAP32[$13 >> 2];
    var $15 = $14 * $12 & -1;
    var $16 = ($11 | 0) / ($15 | 0) & -1;
    HEAP32[$analog_silence_bits >> 2] = $16;
    var $17 = $gfc + 108 | 0;
    var $18 = HEAP32[$17 >> 2];
    var $19 = $2 * 576e3 & -1;
    var $20 = $19 * $18 & -1;
    HEAP32[$mean_bits >> 2] = $20;
    var $21 = $gfc + 85092 | 0;
    var $22 = HEAP32[$21 >> 2];
    var $23 = $22 & 1;
    var $24 = ($23 | 0) == 0;
    if ($24) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $26 = $20 | 0;
    var $27 = $26 * 1.09;
    var $28 = $27 & -1;
    HEAP32[$mean_bits >> 2] = $28;
    label = 4;
    break;
   case 4:
    var $30 = $gfc + 64 | 0;
    var $31 = HEAP32[$30 >> 2];
    var $32 = HEAP32[$mean_bits >> 2];
    var $33 = ($32 | 0) / ($31 | 0) & -1;
    var $34 = HEAP32[$8 >> 2];
    var $35 = $34 << 3;
    var $36 = $33 - $35 | 0;
    var $37 = HEAP32[$1 >> 2];
    var $38 = HEAP32[$13 >> 2];
    var $39 = $38 * $37 & -1;
    var $40 = ($36 | 0) / ($39 | 0) & -1;
    HEAP32[$mean_bits >> 2] = $40;
    var $41 = $gfc + 244 | 0;
    var $42 = HEAPF32[$41 >> 2];
    var $43 = $42;
    var $44 = 11 - $43;
    var $45 = $44 * .07;
    var $46 = $45 / 5.5;
    var $47 = $46 + .93;
    var $48 = $47;
    var $49 = $48;
    var $50 = $49 < .9;
    var $res_factor_0 = $50 ? .8999999761581421 : $48;
    var $51 = $res_factor_0 > 1;
    var $res_factor_1 = $51 ? 1 : $res_factor_0;
    var $52 = HEAP32[$1 >> 2];
    var $53 = ($52 | 0) > 0;
    if ($53) {
      label = 5;
      break;
    } else {
      label = 20;
      break;
    }
   case 5:
    var $54 = HEAP32[$mean_bits >> 2];
    var $55 = $54 | 0;
    var $56 = $res_factor_1 * $55;
    var $57 = $56 & -1;
    var $58 = $54 | 0;
    var $59 = $res_factor_1 * $58;
    var $60 = $59 & -1;
    var $61 = HEAP32[$mean_bits >> 2];
    var $62 = ($61 | 0) / 2 & -1;
    var $63 = $61 * 3 & -1;
    var $64 = ($63 | 0) / 2 & -1;
    var $gr_0136 = 0;
    label = 6;
    break;
   case 6:
    var $gr_0136;
    var $65 = HEAP32[$13 >> 2];
    var $66 = ($65 | 0) > 0;
    if ($66) {
      var $ch_0127 = 0;
      var $sum_0128 = 0;
      label = 7;
      break;
    } else {
      label = 19;
      break;
    }
   case 7:
    var $sum_0128;
    var $ch_0127;
    var $67 = $targ_bits + ($gr_0136 << 3) + ($ch_0127 << 2) | 0;
    HEAP32[$67 >> 2] = $57;
    var $68 = $pe + ($gr_0136 << 3) + ($ch_0127 << 2) | 0;
    var $69 = HEAPF32[$68 >> 2];
    var $70 = $69 > 700;
    if ($70) {
      label = 8;
      break;
    } else {
      var $89 = $57;
      label = 13;
      break;
    }
   case 8:
    var $72 = $69 - 700;
    var $73 = $72;
    var $74 = $73 / 1.4;
    var $75 = $74 & -1;
    HEAP32[$67 >> 2] = $60;
    var $76 = $gfc + 304 + $gr_0136 * 10504 + $ch_0127 * 5252 + 4788 | 0;
    var $77 = HEAP32[$76 >> 2];
    var $78 = ($77 | 0) == 2;
    if ($78) {
      label = 9;
      break;
    } else {
      var $add_bits_0 = $75;
      label = 10;
      break;
    }
   case 9:
    var $80 = ($75 | 0) < ($62 | 0);
    var $_ = $80 ? $62 : $75;
    var $add_bits_0 = $_;
    label = 10;
    break;
   case 10:
    var $add_bits_0;
    var $82 = ($add_bits_0 | 0) > ($64 | 0);
    if ($82) {
      var $add_bits_1 = $64;
      label = 12;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    var $84 = ($add_bits_0 | 0) < 0;
    var $_add_bits_0 = $84 ? 0 : $add_bits_0;
    var $add_bits_1 = $_add_bits_0;
    label = 12;
    break;
   case 12:
    var $add_bits_1;
    var $86 = HEAP32[$67 >> 2];
    var $87 = $86 + $add_bits_1 | 0;
    HEAP32[$67 >> 2] = $87;
    var $89 = $87;
    label = 13;
    break;
   case 13:
    var $89;
    var $90 = ($89 | 0) > 4095;
    if ($90) {
      label = 14;
      break;
    } else {
      label = 15;
      break;
    }
   case 14:
    HEAP32[$67 >> 2] = 4095;
    label = 15;
    break;
   case 15:
    var $93 = HEAP32[$67 >> 2];
    var $94 = $93 + $sum_0128 | 0;
    var $95 = $ch_0127 + 1 | 0;
    var $96 = HEAP32[$13 >> 2];
    var $97 = ($95 | 0) < ($96 | 0);
    if ($97) {
      var $ch_0127 = $95;
      var $sum_0128 = $94;
      label = 7;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    var $98 = ($94 | 0) > 7680;
    if ($98) {
      label = 17;
      break;
    } else {
      label = 19;
      break;
    }
   case 17:
    var $99 = HEAP32[$13 >> 2];
    var $100 = ($99 | 0) > 0;
    if ($100) {
      var $ch_1134 = 0;
      label = 18;
      break;
    } else {
      label = 19;
      break;
    }
   case 18:
    var $ch_1134;
    var $101 = $targ_bits + ($gr_0136 << 3) + ($ch_1134 << 2) | 0;
    var $102 = HEAP32[$101 >> 2];
    var $103 = $102 * 7680 & -1;
    var $104 = ($103 | 0) / ($94 | 0) & -1;
    HEAP32[$101 >> 2] = $104;
    var $105 = $ch_1134 + 1 | 0;
    var $106 = HEAP32[$13 >> 2];
    var $107 = ($105 | 0) < ($106 | 0);
    if ($107) {
      var $ch_1134 = $105;
      label = 18;
      break;
    } else {
      label = 19;
      break;
    }
   case 19:
    var $108 = $gr_0136 + 1 | 0;
    var $109 = HEAP32[$1 >> 2];
    var $110 = ($108 | 0) < ($109 | 0);
    if ($110) {
      var $gr_0136 = $108;
      label = 6;
      break;
    } else {
      label = 20;
      break;
    }
   case 20:
    var $111 = $gfc + 84752 | 0;
    var $112 = HEAP32[$111 >> 2];
    var $113 = ($112 | 0) == 2;
    var $114 = HEAP32[$1 >> 2];
    if ($113) {
      label = 21;
      break;
    } else {
      var $117 = $114;
      label = 23;
      break;
    }
   case 21:
    var $115 = ($114 | 0) > 0;
    if ($115) {
      label = 22;
      break;
    } else {
      label = 35;
      break;
    }
   case 22:
    var $116 = HEAP32[$mean_bits >> 2];
    var $gr_1124 = 0;
    label = 24;
    break;
   case 23:
    var $117;
    var $118 = ($117 | 0) > 0;
    if ($118) {
      var $totbits_0118 = 0;
      var $gr_2119 = 0;
      label = 25;
      break;
    } else {
      label = 35;
      break;
    }
   case 24:
    var $gr_1124;
    var $120 = $targ_bits + ($gr_1124 << 3) | 0;
    var $121 = $ms_ener_ratio + ($gr_1124 << 2) | 0;
    var $122 = HEAPF32[$121 >> 2];
    var $123 = HEAP32[$13 >> 2];
    var $124 = $123 * $116 & -1;
    _reduce_side($120, $122, $124, 7680);
    var $125 = $gr_1124 + 1 | 0;
    var $126 = HEAP32[$1 >> 2];
    var $127 = ($125 | 0) < ($126 | 0);
    if ($127) {
      var $gr_1124 = $125;
      label = 24;
      break;
    } else {
      var $117 = $126;
      label = 23;
      break;
    }
   case 25:
    var $gr_2119;
    var $totbits_0118;
    var $128 = HEAP32[$13 >> 2];
    var $129 = ($128 | 0) > 0;
    if ($129) {
      var $ch_2113 = 0;
      var $totbits_1114 = $totbits_0118;
      label = 26;
      break;
    } else {
      var $totbits_1_lcssa = $totbits_0118;
      label = 29;
      break;
    }
   case 26:
    var $totbits_1114;
    var $ch_2113;
    var $130 = $targ_bits + ($gr_2119 << 3) + ($ch_2113 << 2) | 0;
    var $131 = HEAP32[$130 >> 2];
    var $132 = ($131 | 0) > 4095;
    if ($132) {
      label = 27;
      break;
    } else {
      label = 28;
      break;
    }
   case 27:
    HEAP32[$130 >> 2] = 4095;
    label = 28;
    break;
   case 28:
    var $135 = HEAP32[$130 >> 2];
    var $136 = $135 + $totbits_1114 | 0;
    var $137 = $ch_2113 + 1 | 0;
    var $138 = HEAP32[$13 >> 2];
    var $139 = ($137 | 0) < ($138 | 0);
    if ($139) {
      var $ch_2113 = $137;
      var $totbits_1114 = $136;
      label = 26;
      break;
    } else {
      var $totbits_1_lcssa = $136;
      label = 29;
      break;
    }
   case 29:
    var $totbits_1_lcssa;
    var $140 = $gr_2119 + 1 | 0;
    var $141 = HEAP32[$1 >> 2];
    var $142 = ($140 | 0) < ($141 | 0);
    if ($142) {
      var $totbits_0118 = $totbits_1_lcssa;
      var $gr_2119 = $140;
      label = 25;
      break;
    } else {
      label = 30;
      break;
    }
   case 30:
    var $143 = HEAP32[$max_frame_bits >> 2];
    var $144 = ($totbits_1_lcssa | 0) > ($143 | 0);
    var $145 = ($totbits_1_lcssa | 0) > 0;
    var $or_cond = $144 & $145;
    if ($or_cond) {
      label = 31;
      break;
    } else {
      label = 35;
      break;
    }
   case 31:
    var $146 = HEAP32[$1 >> 2];
    var $147 = ($146 | 0) > 0;
    if ($147) {
      var $gr_3110 = 0;
      label = 32;
      break;
    } else {
      label = 35;
      break;
    }
   case 32:
    var $gr_3110;
    var $148 = HEAP32[$13 >> 2];
    var $149 = ($148 | 0) > 0;
    if ($149) {
      var $ch_3108 = 0;
      label = 33;
      break;
    } else {
      label = 34;
      break;
    }
   case 33:
    var $ch_3108;
    var $150 = HEAP32[$max_frame_bits >> 2];
    var $151 = $targ_bits + ($gr_3110 << 3) + ($ch_3108 << 2) | 0;
    var $152 = HEAP32[$151 >> 2];
    var $153 = $152 * $150 & -1;
    var $154 = ($153 | 0) / ($totbits_1_lcssa | 0) & -1;
    HEAP32[$151 >> 2] = $154;
    var $155 = $ch_3108 + 1 | 0;
    var $156 = HEAP32[$13 >> 2];
    var $157 = ($155 | 0) < ($156 | 0);
    if ($157) {
      var $ch_3108 = $155;
      label = 33;
      break;
    } else {
      label = 34;
      break;
    }
   case 34:
    var $158 = $gr_3110 + 1 | 0;
    var $159 = HEAP32[$1 >> 2];
    var $160 = ($158 | 0) < ($159 | 0);
    if ($160) {
      var $gr_3110 = $158;
      label = 32;
      break;
    } else {
      label = 35;
      break;
    }
   case 35:
    STACKTOP = __stackBase__;
    return;
  }
}
_calc_target_bits["X"] = 1;
function _VBR_new_iteration_loop($gfc, $pe, $ms_ener_ratio, $ratio) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 9924 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $l3_xmin = __stackBase__;
    var $xrpow = __stackBase__ + 624;
    var $frameBits = __stackBase__ + 9840;
    var $max_bits = __stackBase__ + 9900;
    var $pad = __stackBase__ + 9916;
    var $mean_bits = __stackBase__ + 9920;
    var $1 = $l3_xmin | 0;
    var $2 = $xrpow | 0;
    var $3 = $max_bits | 0;
    var $4 = $xrpow;
    for (var $$dest = $4 >> 2, $$stop = $$dest + 2304; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $5 = $frameBits | 0;
    var $6 = _VBR_new_prepare($gfc, $pe, $ratio, $1, $5, $3, $pad);
    var $7 = $gfc + 76 | 0;
    var $8 = HEAP32[$7 >> 2];
    var $9 = ($8 | 0) > 0;
    if ($9) {
      label = 3;
      break;
    } else {
      label = 9;
      break;
    }
   case 3:
    var $10 = $gfc + 72 | 0;
    var $gr_061 = 0;
    label = 4;
    break;
   case 4:
    var $gr_061;
    var $11 = HEAP32[$10 >> 2];
    var $12 = ($11 | 0) > 0;
    if ($12) {
      var $ch_057 = 0;
      label = 5;
      break;
    } else {
      label = 8;
      break;
    }
   case 5:
    var $ch_057;
    var $13 = $gfc + 304 + $gr_061 * 10504 + $ch_057 * 5252 | 0;
    var $14 = $xrpow + $gr_061 * 4608 + $ch_057 * 2304 | 0;
    var $15 = _init_xrpow($gfc, $13, $14);
    var $16 = ($15 | 0) == 0;
    if ($16) {
      label = 6;
      break;
    } else {
      label = 7;
      break;
    }
   case 6:
    var $18 = $max_bits + ($gr_061 << 3) + ($ch_057 << 2) | 0;
    HEAP32[$18 >> 2] = 0;
    label = 7;
    break;
   case 7:
    var $20 = $ch_057 + 1 | 0;
    var $21 = HEAP32[$10 >> 2];
    var $22 = ($20 | 0) < ($21 | 0);
    if ($22) {
      var $ch_057 = $20;
      label = 5;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    var $23 = $gr_061 + 1 | 0;
    var $24 = HEAP32[$7 >> 2];
    var $25 = ($23 | 0) < ($24 | 0);
    if ($25) {
      var $gr_061 = $23;
      label = 4;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    var $26 = _VBR_encode_frame($gfc, $2, $1, $3);
    var $27 = $gfc + 152 | 0;
    var $28 = HEAP32[$27 >> 2];
    var $29 = ($28 | 0) == 0;
    if ($29) {
      label = 10;
      break;
    } else {
      label = 22;
      break;
    }
   case 10:
    var $31 = ($6 | 0) == 0;
    if ($31) {
      label = 12;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    var $33 = $gfc + 124 | 0;
    var $34 = HEAP32[$33 >> 2];
    var $35 = ($34 | 0) == 0;
    if ($35) {
      var $i_0_ph = 1;
      label = 13;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    var $37 = $gfc + 112 | 0;
    var $38 = HEAP32[$37 >> 2];
    var $i_0_ph = $38;
    label = 13;
    break;
   case 13:
    var $i_0_ph;
    var $39 = $gfc + 116 | 0;
    var $40 = HEAP32[$39 >> 2];
    var $i_0 = $i_0_ph;
    label = 14;
    break;
   case 14:
    var $i_0;
    var $42 = ($i_0 | 0) < ($40 | 0);
    if ($42) {
      label = 15;
      break;
    } else {
      label = 16;
      break;
    }
   case 15:
    var $44 = $frameBits + ($i_0 << 2) | 0;
    var $45 = HEAP32[$44 >> 2];
    var $46 = ($26 | 0) > ($45 | 0);
    var $47 = $i_0 + 1 | 0;
    if ($46) {
      var $i_0 = $47;
      label = 14;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    var $49 = HEAP32[$39 >> 2];
    var $50 = ($i_0 | 0) > ($49 | 0);
    var $_i_0 = $50 ? $49 : $i_0;
    var $51 = HEAP32[$pad >> 2];
    var $52 = ($51 | 0) > 0;
    if ($52) {
      label = 17;
      break;
    } else {
      label = 21;
      break;
    }
   case 17:
    var $53 = HEAP32[$pad >> 2];
    var $j_0 = $49;
    label = 18;
    break;
   case 18:
    var $j_0;
    var $55 = ($j_0 | 0) > ($_i_0 | 0);
    if ($55) {
      label = 19;
      break;
    } else {
      label = 20;
      break;
    }
   case 19:
    var $57 = $frameBits + ($j_0 << 2) | 0;
    var $58 = HEAP32[$57 >> 2];
    var $59 = $58 - $26 | 0;
    var $60 = ($59 | 0) > ($53 | 0);
    var $61 = $j_0 - 1 | 0;
    if ($60) {
      var $j_0 = $61;
      label = 18;
      break;
    } else {
      label = 20;
      break;
    }
   case 20:
    var $63 = $gfc + 84740 | 0;
    HEAP32[$63 >> 2] = $j_0;
    label = 23;
    break;
   case 21:
    var $65 = $gfc + 84740 | 0;
    HEAP32[$65 >> 2] = $_i_0;
    label = 23;
    break;
   case 22:
    var $67 = $gfc + 84740 | 0;
    HEAP32[$67 >> 2] = 0;
    label = 23;
    break;
   case 23:
    var $69 = $gfc + 84740 | 0;
    var $70 = HEAP32[$69 >> 2];
    var $71 = $frameBits + ($70 << 2) | 0;
    var $72 = HEAP32[$71 >> 2];
    var $73 = ($26 | 0) > ($72 | 0);
    if ($73) {
      label = 30;
      break;
    } else {
      label = 24;
      break;
    }
   case 24:
    var $75 = _ResvFrameBegin($gfc, $mean_bits);
    var $76 = HEAP32[$7 >> 2];
    var $77 = ($76 | 0) > 0;
    if ($77) {
      label = 25;
      break;
    } else {
      label = 29;
      break;
    }
   case 25:
    var $78 = $gfc + 72 | 0;
    var $gr_151 = 0;
    label = 26;
    break;
   case 26:
    var $gr_151;
    var $79 = HEAP32[$78 >> 2];
    var $80 = ($79 | 0) > 0;
    if ($80) {
      var $ch_150 = 0;
      label = 27;
      break;
    } else {
      label = 28;
      break;
    }
   case 27:
    var $ch_150;
    var $81 = $gfc + 304 + $gr_151 * 10504 + $ch_150 * 5252 | 0;
    _ResvAdjust($gfc, $81);
    var $82 = $ch_150 + 1 | 0;
    var $83 = HEAP32[$78 >> 2];
    var $84 = ($82 | 0) < ($83 | 0);
    if ($84) {
      var $ch_150 = $82;
      label = 27;
      break;
    } else {
      label = 28;
      break;
    }
   case 28:
    var $85 = $gr_151 + 1 | 0;
    var $86 = HEAP32[$7 >> 2];
    var $87 = ($85 | 0) < ($86 | 0);
    if ($87) {
      var $gr_151 = $85;
      label = 26;
      break;
    } else {
      label = 29;
      break;
    }
   case 29:
    var $88 = HEAP32[$mean_bits >> 2];
    _ResvFrameEnd($gfc, $88);
    STACKTOP = __stackBase__;
    return;
   case 30:
    _lame_errorf($gfc, 5385448, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 3 >> 2 << 2, HEAP32[tempInt >> 2] = 0, tempInt));
    _exit(-1);
  }
}
_VBR_new_iteration_loop["X"] = 1;
function _init_outer_loop($gfc, $cod_info) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 2304 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $ixwork = __stackBase__;
    var $1 = $cod_info + 4768 | 0;
    HEAP32[$1 >> 2] = 0;
    var $2 = $cod_info + 4772 | 0;
    HEAP32[$2 >> 2] = 0;
    var $3 = $cod_info + 4776 | 0;
    HEAP32[$3 >> 2] = 0;
    var $4 = $cod_info + 4780 | 0;
    HEAP32[$4 >> 2] = 210;
    var $5 = $cod_info + 4784 | 0;
    HEAP32[$5 >> 2] = 0;
    var $6 = $cod_info + 4796 | 0;
    var $7 = $gfc + 64 | 0;
    var $8 = $6;
    for (var $$dest = $8 >> 2, $$stop = $$dest + 13; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $9 = HEAP32[$7 >> 2];
    var $10 = ($9 | 0) < 8001;
    var $11 = $cod_info + 4848 | 0;
    if ($10) {
      label = 3;
      break;
    } else {
      label = 4;
      break;
    }
   case 3:
    HEAP32[$11 >> 2] = 17;
    var $13 = $cod_info + 4852 | 0;
    HEAP32[$13 >> 2] = 9;
    var $14 = $cod_info + 4856 | 0;
    HEAP32[$14 >> 2] = 17;
    label = 5;
    break;
   case 4:
    HEAP32[$11 >> 2] = 21;
    var $16 = $cod_info + 4852 | 0;
    HEAP32[$16 >> 2] = 12;
    var $17 = $gfc + 85088 | 0;
    var $18 = HEAP32[$17 >> 2];
    var $19 = ($18 | 0) != 0;
    var $20 = $19 ? 22 : 21;
    var $21 = $cod_info + 4856 | 0;
    HEAP32[$21 >> 2] = $20;
    label = 5;
    break;
   case 5:
    var $23 = $cod_info + 4856 | 0;
    var $24 = HEAP32[$23 >> 2];
    var $25 = $cod_info + 4864 | 0;
    HEAP32[$25 >> 2] = $24;
    var $26 = HEAP32[$11 >> 2];
    var $27 = $cod_info + 4860 | 0;
    HEAP32[$27 >> 2] = $26;
    var $28 = $cod_info + 4868 | 0;
    HEAP32[$28 >> 2] = 11;
    var $sfb_0125 = 0;
    label = 6;
    break;
   case 6:
    var $sfb_0125;
    var $30 = $sfb_0125 + 1 | 0;
    var $31 = $gfc + 21360 + ($30 << 2) | 0;
    var $32 = HEAP32[$31 >> 2];
    var $33 = $gfc + 21360 + ($sfb_0125 << 2) | 0;
    var $34 = HEAP32[$33 >> 2];
    var $35 = $32 - $34 | 0;
    var $36 = $cod_info + 4872 + ($sfb_0125 << 2) | 0;
    HEAP32[$36 >> 2] = $35;
    var $37 = $cod_info + 5028 + ($sfb_0125 << 2) | 0;
    HEAP32[$37 >> 2] = 3;
    var $exitcond129 = ($30 | 0) == 22;
    if ($exitcond129) {
      label = 7;
      break;
    } else {
      var $sfb_0125 = $30;
      label = 6;
      break;
    }
   case 7:
    var $39 = $cod_info + 4788 | 0;
    var $40 = HEAP32[$39 >> 2];
    var $41 = ($40 | 0) == 2;
    if ($41) {
      label = 8;
      break;
    } else {
      label = 21;
      break;
    }
   case 8:
    var $43 = $cod_info + 4852 | 0;
    HEAP32[$43 >> 2] = 0;
    HEAP32[$11 >> 2] = 0;
    var $44 = $cod_info + 4792 | 0;
    var $45 = HEAP32[$44 >> 2];
    var $46 = ($45 | 0) == 0;
    if ($46) {
      label = 10;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    HEAP32[$43 >> 2] = 3;
    var $48 = $gfc + 76 | 0;
    var $49 = HEAP32[$48 >> 2];
    var $50 = $49 << 1;
    var $51 = $50 + 4 | 0;
    HEAP32[$11 >> 2] = $51;
    label = 10;
    break;
   case 10:
    var $53 = HEAP32[$7 >> 2];
    var $54 = ($53 | 0) < 8001;
    var $55 = HEAP32[$11 >> 2];
    if ($54) {
      label = 11;
      break;
    } else {
      label = 12;
      break;
    }
   case 11:
    var $57 = HEAP32[$43 >> 2];
    var $58 = 9 - $57 | 0;
    var $59 = $58 * 3 & -1;
    var $60 = $59 + $55 | 0;
    HEAP32[$25 >> 2] = $60;
    var $61 = HEAP32[$11 >> 2];
    var $62 = HEAP32[$43 >> 2];
    var $63 = 9 - $62 | 0;
    var $64 = $63 * 3 & -1;
    var $65 = $64 + $61 | 0;
    var $storemerge = $65;
    label = 13;
    break;
   case 12:
    var $67 = $gfc + 85088 | 0;
    var $68 = HEAP32[$67 >> 2];
    var $69 = ($68 | 0) != 0;
    var $70 = $69 ? 13 : 12;
    var $71 = HEAP32[$43 >> 2];
    var $72 = $70 - $71 | 0;
    var $73 = $72 * 3 & -1;
    var $74 = $73 + $55 | 0;
    HEAP32[$25 >> 2] = $74;
    var $75 = HEAP32[$11 >> 2];
    var $76 = HEAP32[$43 >> 2];
    var $77 = 12 - $76 | 0;
    var $78 = $77 * 3 & -1;
    var $79 = $78 + $75 | 0;
    var $storemerge = $79;
    label = 13;
    break;
   case 13:
    var $storemerge;
    HEAP32[$27 >> 2] = $storemerge;
    var $81 = $storemerge - 18 | 0;
    HEAP32[$28 >> 2] = $81;
    var $82 = HEAP32[$11 >> 2];
    HEAP32[$23 >> 2] = $82;
    var $83 = HEAP32[$11 >> 2];
    var $84 = $gfc + 21360 + ($83 << 2) | 0;
    var $85 = HEAP32[$84 >> 2];
    var $86 = $ixwork;
    var $87 = $cod_info;
    for (var $$src = $87 >> 2, $$dest = $86 >> 2, $$stop = $$src + 576; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    var $88 = HEAP32[$43 >> 2];
    var $89 = ($88 | 0) < 13;
    if ($89) {
      label = 14;
      break;
    } else {
      label = 21;
      break;
    }
   case 14:
    var $90 = $cod_info + ($85 << 2) | 0;
    var $ix_0120 = $90;
    var $sfb_1121 = $88;
    label = 15;
    break;
   case 15:
    var $sfb_1121;
    var $ix_0120;
    var $91 = $gfc + 21452 + ($sfb_1121 << 2) | 0;
    var $92 = HEAP32[$91 >> 2];
    var $93 = $sfb_1121 + 1 | 0;
    var $94 = $gfc + 21452 + ($93 << 2) | 0;
    var $95 = HEAP32[$94 >> 2];
    var $96 = ($92 | 0) < ($95 | 0);
    var $97 = $95 - $92 | 0;
    if ($96) {
      var $ix_2114 = $ix_0120;
      var $l_0115 = $92;
      label = 16;
      break;
    } else {
      var $ix_2_lcssa_2 = $ix_0120;
      label = 28;
      break;
    }
   case 16:
    var $l_0115;
    var $ix_2114;
    var $98 = $l_0115 * 3 & -1;
    var $99 = $ixwork + ($98 << 2) | 0;
    var $100 = HEAPF32[$99 >> 2];
    var $101 = $ix_2114 + 4 | 0;
    HEAPF32[$ix_2114 >> 2] = $100;
    var $102 = $l_0115 + 1 | 0;
    var $exitcond126 = ($102 | 0) == ($95 | 0);
    if ($exitcond126) {
      label = 17;
      break;
    } else {
      var $ix_2114 = $101;
      var $l_0115 = $102;
      label = 16;
      break;
    }
   case 17:
    var $scevgep = $ix_0120 + ($97 << 2) | 0;
    if ($96) {
      var $ix_2114_1 = $scevgep;
      var $l_0115_1 = $92;
      label = 24;
      break;
    } else {
      var $ix_2_lcssa_2 = $scevgep;
      label = 28;
      break;
    }
   case 18:
    var $_pr = HEAP32[$43 >> 2];
    var $103 = ($_pr | 0) < 13;
    if ($103) {
      label = 19;
      break;
    } else {
      label = 21;
      break;
    }
   case 19:
    var $104 = HEAP32[$11 >> 2];
    var $j_0112 = $104;
    var $sfb_2113 = $_pr;
    label = 20;
    break;
   case 20:
    var $sfb_2113;
    var $j_0112;
    var $106 = $sfb_2113 + 1 | 0;
    var $107 = $gfc + 21452 + ($106 << 2) | 0;
    var $108 = HEAP32[$107 >> 2];
    var $109 = $gfc + 21452 + ($sfb_2113 << 2) | 0;
    var $110 = HEAP32[$109 >> 2];
    var $111 = $108 - $110 | 0;
    var $112 = $j_0112 + 2 | 0;
    var $113 = $cod_info + 4872 + ($112 << 2) | 0;
    HEAP32[$113 >> 2] = $111;
    var $114 = $j_0112 + 1 | 0;
    var $115 = $cod_info + 4872 + ($114 << 2) | 0;
    HEAP32[$115 >> 2] = $111;
    var $116 = $cod_info + 4872 + ($j_0112 << 2) | 0;
    HEAP32[$116 >> 2] = $111;
    var $117 = $cod_info + 5028 + ($j_0112 << 2) | 0;
    HEAP32[$117 >> 2] = 0;
    var $118 = $cod_info + 5028 + ($114 << 2) | 0;
    HEAP32[$118 >> 2] = 1;
    var $119 = $cod_info + 5028 + ($112 << 2) | 0;
    HEAP32[$119 >> 2] = 2;
    var $120 = $j_0112 + 3 | 0;
    var $exitcond = ($106 | 0) == 13;
    if ($exitcond) {
      label = 21;
      break;
    } else {
      var $j_0112 = $120;
      var $sfb_2113 = $106;
      label = 20;
      break;
    }
   case 21:
    var $121 = $cod_info + 5184 | 0;
    HEAP32[$121 >> 2] = 0;
    var $122 = $cod_info + 5188 | 0;
    HEAP32[$122 >> 2] = 5291828;
    var $123 = $cod_info + 5192 | 0;
    var $124 = $cod_info + 5208 | 0;
    var $125 = $123;
    HEAP32[$125 >> 2] = 0;
    HEAP32[$125 + 4 >> 2] = 0;
    HEAP32[$125 + 8 >> 2] = 0;
    HEAP32[$125 + 12 >> 2] = 0;
    HEAP32[$124 >> 2] = 575;
    var $126 = $cod_info + 4608 | 0;
    var $127 = $126;
    for (var $$dest = $127 >> 2, $$stop = $$dest + 39; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $128 = $gfc + 104 | 0;
    var $129 = HEAP32[$128 >> 2];
    if (($129 | 0) == 1 | ($129 | 0) == 4 | ($129 | 0) == 3 | ($129 | 0) == 0) {
      label = 23;
      break;
    } else {
      label = 22;
      break;
    }
   case 22:
    _psfb21_analogsilence($gfc, $cod_info);
    label = 23;
    break;
   case 23:
    STACKTOP = __stackBase__;
    return;
   case 24:
    var $l_0115_1;
    var $ix_2114_1;
    var $132 = $l_0115_1 * 3 & -1;
    var $133 = $132 + 1 | 0;
    var $134 = $ixwork + ($133 << 2) | 0;
    var $135 = HEAPF32[$134 >> 2];
    var $136 = $ix_2114_1 + 4 | 0;
    HEAPF32[$ix_2114_1 >> 2] = $135;
    var $137 = $l_0115_1 + 1 | 0;
    var $exitcond126_1 = ($137 | 0) == ($95 | 0);
    if ($exitcond126_1) {
      label = 25;
      break;
    } else {
      var $ix_2114_1 = $136;
      var $l_0115_1 = $137;
      label = 24;
      break;
    }
   case 25:
    var $scevgep_sum = $97 << 1;
    var $scevgep_1 = $ix_0120 + ($scevgep_sum << 2) | 0;
    if ($96) {
      var $ix_2114_2 = $scevgep_1;
      var $l_0115_2 = $92;
      label = 26;
      break;
    } else {
      var $ix_2_lcssa_2 = $scevgep_1;
      label = 28;
      break;
    }
   case 26:
    var $l_0115_2;
    var $ix_2114_2;
    var $138 = $l_0115_2 * 3 & -1;
    var $139 = $138 + 2 | 0;
    var $140 = $ixwork + ($139 << 2) | 0;
    var $141 = HEAPF32[$140 >> 2];
    var $142 = $ix_2114_2 + 4 | 0;
    HEAPF32[$ix_2114_2 >> 2] = $141;
    var $143 = $l_0115_2 + 1 | 0;
    var $exitcond126_2 = ($143 | 0) == ($95 | 0);
    if ($exitcond126_2) {
      label = 27;
      break;
    } else {
      var $ix_2114_2 = $142;
      var $l_0115_2 = $143;
      label = 26;
      break;
    }
   case 27:
    var $scevgep_1_sum = $scevgep_sum + $97 | 0;
    var $scevgep_2 = $ix_0120 + ($scevgep_1_sum << 2) | 0;
    var $ix_2_lcssa_2 = $scevgep_2;
    label = 28;
    break;
   case 28:
    var $ix_2_lcssa_2;
    var $exitcond128 = ($93 | 0) == 13;
    if ($exitcond128) {
      label = 18;
      break;
    } else {
      var $ix_0120 = $ix_2_lcssa_2;
      var $sfb_1121 = $93;
      label = 15;
      break;
    }
  }
}
_init_outer_loop["X"] = 1;
function _outer_loop($gfc, $cod_info, $l3_xmin, $xrpow, $ch, $targ_bits) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 8236 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $cod_info_w = __stackBase__;
    var $save_xrpow = __stackBase__ + 5252;
    var $distort = __stackBase__ + 7556;
    var $best_noise_info = __stackBase__ + 7712;
    var $prev_noise = __stackBase__ + 7736;
    var $noise_info = __stackBase__ + 8212;
    _bin_search_StepSize($gfc, $cod_info, $targ_bits, $ch, $xrpow);
    var $1 = $gfc + 28 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($2 | 0) == 0;
    if ($3) {
      var $_0 = 100;
      label = 37;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $4 = $prev_noise;
    for (var $$dest = $4 >> 2, $$stop = $$dest + 119; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $5 = $distort | 0;
    var $6 = _calc_noise($cod_info, $l3_xmin, $5, $best_noise_info, $prev_noise);
    var $7 = $cod_info + 4768 | 0;
    var $8 = HEAP32[$7 >> 2];
    var $9 = $best_noise_info + 20 | 0;
    HEAP32[$9 >> 2] = $8;
    var $10 = $cod_info_w;
    var $11 = $cod_info;
    for (var $$src = $11 >> 2, $$dest = $10 >> 2, $$stop = $$src + 1313; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    var $12 = $save_xrpow;
    var $13 = $xrpow;
    for (var $$src = $13 >> 2, $$dest = $12 >> 2, $$stop = $$src + 576; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    var $14 = $cod_info_w + 4860 | 0;
    var $15 = $cod_info_w + 4836 | 0;
    var $16 = $gfc + 85092 | 0;
    var $17 = $gfc + 85088 | 0;
    var $18 = $cod_info_w + 4844 | 0;
    var $19 = $cod_info_w + 4780 | 0;
    var $20 = $cod_info_w + 4768 | 0;
    var $21 = $cod_info_w + 4780 | 0;
    var $22 = $best_noise_info + 12 | 0;
    var $23 = $noise_info + 20 | 0;
    var $24 = $cod_info + 4788 | 0;
    var $25 = $gfc + 84 | 0;
    var $26 = $gfc + 88 | 0;
    var $27 = $gfc + 48 | 0;
    var $28 = $gfc + 40 | 0;
    var $29 = $best_noise_info;
    var $30 = $noise_info;
    var $31 = $cod_info_w + 4788 | 0;
    var $32 = $gfc + 40 | 0;
    var $33 = $cod_info_w + 4780 | 0;
    var $best_part2_3_length_067 = 9999999;
    var $bRefine_068 = 0;
    var $best_ggain_pass1_069 = 0;
    label = 4;
    break;
   case 4:
    var $best_ggain_pass1_069;
    var $bRefine_068;
    var $best_part2_3_length_067;
    var $34 = ($bRefine_068 | 0) == 0;
    var $best_part2_3_length_1 = $best_part2_3_length_067;
    var $age_1 = 0;
    label = 5;
    break;
   case 5:
    var $age_1;
    var $best_part2_3_length_1;
    var $36 = HEAP32[$16 >> 2];
    var $37 = $36 & 2;
    var $38 = ($37 | 0) == 0;
    var $_ = $38 ? 3 : 20;
    var $39 = HEAP32[$17 >> 2];
    var $40 = ($39 | 0) == 0;
    if ($40) {
      label = 10;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    var $42 = HEAP32[$14 >> 2];
    var $43 = $distort + ($42 << 2) | 0;
    var $44 = HEAPF32[$43 >> 2];
    var $45 = $44 > 1;
    if ($45) {
      var $best_part2_3_length_3 = $best_part2_3_length_1;
      label = 30;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    var $47 = HEAP32[$31 >> 2];
    var $48 = ($47 | 0) == 2;
    if ($48) {
      label = 8;
      break;
    } else {
      label = 10;
      break;
    }
   case 8:
    var $50 = $42 + 1 | 0;
    var $51 = $distort + ($50 << 2) | 0;
    var $52 = HEAPF32[$51 >> 2];
    var $53 = $52 > 1;
    if ($53) {
      var $best_part2_3_length_3 = $best_part2_3_length_1;
      label = 30;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    var $55 = $42 + 2 | 0;
    var $56 = $distort + ($55 << 2) | 0;
    var $57 = HEAPF32[$56 >> 2];
    var $58 = $57 > 1;
    if ($58) {
      var $best_part2_3_length_3 = $best_part2_3_length_1;
      label = 30;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    var $60 = _balance_noise($gfc, $cod_info_w, $5, $xrpow, $bRefine_068);
    var $61 = ($60 | 0) == 0;
    if ($61) {
      var $best_part2_3_length_3 = $best_part2_3_length_1;
      label = 30;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    var $63 = HEAP32[$15 >> 2];
    var $64 = ($63 | 0) == 0;
    var $_51 = $64 ? 255 : 254;
    var $65 = HEAP32[$18 >> 2];
    var $66 = $targ_bits - $65 | 0;
    var $67 = ($66 | 0) < 1;
    if ($67) {
      var $best_part2_3_length_3 = $best_part2_3_length_1;
      label = 30;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    var $68 = _count_bits($gfc, $xrpow, $cod_info_w, $prev_noise);
    HEAP32[$20 >> 2] = $68;
    var $69 = ($68 | 0) > ($66 | 0);
    var $70 = HEAP32[$21 >> 2];
    if ($69) {
      var $71 = $70;
      label = 13;
      break;
    } else {
      var $80 = $21;
      var $79 = $70;
      label = 15;
      break;
    }
   case 13:
    var $71;
    var $72 = ($71 | 0) > ($_51 | 0);
    var $73 = HEAP32[$19 >> 2];
    if ($72) {
      var $80 = $19;
      var $79 = $73;
      label = 15;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    var $75 = $73 + 1 | 0;
    HEAP32[$19 >> 2] = $75;
    var $76 = _count_bits($gfc, $xrpow, $cod_info_w, $prev_noise);
    HEAP32[$20 >> 2] = $76;
    var $77 = ($76 | 0) > ($66 | 0);
    var $78 = HEAP32[$21 >> 2];
    if ($77) {
      var $71 = $78;
      label = 13;
      break;
    } else {
      var $80 = $21;
      var $79 = $78;
      label = 15;
      break;
    }
   case 15:
    var $79;
    var $80;
    var $81 = ($79 | 0) > ($_51 | 0);
    if ($81) {
      var $best_part2_3_length_3 = $best_part2_3_length_1;
      label = 30;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    var $83 = HEAP32[$22 >> 2];
    var $84 = ($83 | 0) == 0;
    if ($84) {
      label = 17;
      break;
    } else {
      label = 21;
      break;
    }
   case 17:
    var $85 = _count_bits($gfc, $xrpow, $cod_info_w, $prev_noise);
    HEAP32[$20 >> 2] = $85;
    var $86 = ($85 | 0) > ($best_part2_3_length_1 | 0);
    var $87 = HEAP32[$80 >> 2];
    if ($86) {
      var $88 = $87;
      label = 18;
      break;
    } else {
      var $96 = $87;
      label = 20;
      break;
    }
   case 18:
    var $88;
    var $89 = ($88 | 0) > ($_51 | 0);
    var $90 = HEAP32[$80 >> 2];
    if ($89) {
      var $96 = $90;
      label = 20;
      break;
    } else {
      label = 19;
      break;
    }
   case 19:
    var $92 = $90 + 1 | 0;
    HEAP32[$80 >> 2] = $92;
    var $93 = _count_bits($gfc, $xrpow, $cod_info_w, $prev_noise);
    HEAP32[$20 >> 2] = $93;
    var $94 = ($93 | 0) > ($best_part2_3_length_1 | 0);
    var $95 = HEAP32[$80 >> 2];
    if ($94) {
      var $88 = $95;
      label = 18;
      break;
    } else {
      var $96 = $95;
      label = 20;
      break;
    }
   case 20:
    var $96;
    var $97 = ($96 | 0) > ($_51 | 0);
    if ($97) {
      var $best_part2_3_length_3 = $best_part2_3_length_1;
      label = 30;
      break;
    } else {
      label = 21;
      break;
    }
   case 21:
    var $99 = _calc_noise($cod_info_w, $l3_xmin, $5, $noise_info, $prev_noise);
    var $100 = HEAP32[$20 >> 2];
    HEAP32[$23 >> 2] = $100;
    var $101 = HEAP32[$24 >> 2];
    var $102 = ($101 | 0) == 2;
    var $better_0_in = $102 ? $26 : $25;
    var $better_0 = HEAP32[$better_0_in >> 2];
    var $103 = _quant_compare($better_0, $best_noise_info, $noise_info, $cod_info_w, $5);
    var $104 = ($103 | 0) == 0;
    if ($104) {
      label = 23;
      break;
    } else {
      label = 22;
      break;
    }
   case 22:
    var $106 = HEAP32[$7 >> 2];
    HEAP32[$29 >> 2] = HEAP32[$30 >> 2];
    HEAP32[$29 + 4 >> 2] = HEAP32[$30 + 4 >> 2];
    HEAP32[$29 + 8 >> 2] = HEAP32[$30 + 8 >> 2];
    HEAP32[$29 + 12 >> 2] = HEAP32[$30 + 12 >> 2];
    HEAP32[$29 + 16 >> 2] = HEAP32[$30 + 16 >> 2];
    HEAP32[$29 + 20 >> 2] = HEAP32[$30 + 20 >> 2];
    for (var $$src = $10 >> 2, $$dest = $11 >> 2, $$stop = $$src + 1313; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    for (var $$src = $13 >> 2, $$dest = $12 >> 2, $$stop = $$src + 576; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    var $best_part2_3_length_2 = $106;
    var $age_2 = 0;
    label = 29;
    break;
   case 23:
    var $108 = HEAP32[$27 >> 2];
    var $109 = ($108 | 0) == 0;
    if ($109) {
      label = 24;
      break;
    } else {
      var $best_part2_3_length_2 = $best_part2_3_length_1;
      var $age_2 = $age_1;
      label = 29;
      break;
    }
   case 24:
    var $111 = $age_1 + 1 | 0;
    var $112 = ($111 | 0) > ($_ | 0);
    if ($112) {
      label = 25;
      break;
    } else {
      label = 26;
      break;
    }
   case 25:
    var $114 = HEAP32[$22 >> 2];
    var $115 = ($114 | 0) == 0;
    if ($115) {
      var $best_part2_3_length_3 = $best_part2_3_length_1;
      label = 30;
      break;
    } else {
      label = 26;
      break;
    }
   case 26:
    var $117 = HEAP32[$28 >> 2];
    var $118 = ($117 | 0) != 3;
    var $or_cond_not_demorgan = $118 | $34;
    var $or_cond_not = $or_cond_not_demorgan ^ 1;
    var $119 = ($111 | 0) > 30;
    var $or_cond52 = $119 & $or_cond_not;
    if ($or_cond52) {
      var $best_part2_3_length_3 = $best_part2_3_length_1;
      label = 30;
      break;
    } else {
      label = 27;
      break;
    }
   case 27:
    var $or_cond = $118 | $34;
    if ($or_cond) {
      var $best_part2_3_length_2 = $best_part2_3_length_1;
      var $age_2 = $111;
      label = 29;
      break;
    } else {
      label = 28;
      break;
    }
   case 28:
    var $122 = HEAP32[$80 >> 2];
    var $123 = $122 - $best_ggain_pass1_069 | 0;
    var $124 = ($123 | 0) > 15;
    if ($124) {
      var $best_part2_3_length_3 = $best_part2_3_length_1;
      label = 30;
      break;
    } else {
      var $best_part2_3_length_2 = $best_part2_3_length_1;
      var $age_2 = $111;
      label = 29;
      break;
    }
   case 29:
    var $age_2;
    var $best_part2_3_length_2;
    var $126 = HEAP32[$80 >> 2];
    var $127 = HEAP32[$15 >> 2];
    var $128 = $127 + $126 | 0;
    var $129 = ($128 | 0) < 255;
    if ($129) {
      var $best_part2_3_length_1 = $best_part2_3_length_2;
      var $age_1 = $age_2;
      label = 5;
      break;
    } else {
      var $best_part2_3_length_3 = $best_part2_3_length_2;
      label = 30;
      break;
    }
   case 30:
    var $best_part2_3_length_3;
    var $131 = HEAP32[$32 >> 2];
    var $132 = ($131 | 0) == 3;
    var $133 = ($bRefine_068 | 0) == 0;
    var $or_cond54 = $132 & $133;
    if ($or_cond54) {
      label = 31;
      break;
    } else {
      label = 32;
      break;
    }
   case 31:
    for (var $$src = $11 >> 2, $$dest = $10 >> 2, $$stop = $$src + 1313; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    for (var $$src = $12 >> 2, $$dest = $13 >> 2, $$stop = $$src + 576; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    var $135 = HEAP32[$33 >> 2];
    var $best_part2_3_length_067 = $best_part2_3_length_3;
    var $bRefine_068 = 1;
    var $best_ggain_pass1_069 = $135;
    label = 4;
    break;
   case 32:
    var $136 = $gfc + 104 | 0;
    var $137 = HEAP32[$136 >> 2];
    if (($137 | 0) == 2 | ($137 | 0) == 4 | ($137 | 0) == 1) {
      label = 33;
      break;
    } else {
      label = 34;
      break;
    }
   case 33:
    for (var $$src = $12 >> 2, $$dest = $13 >> 2, $$stop = $$src + 576; $$src < $$stop; $$src++, $$dest++) {
      HEAP32[$$dest] = HEAP32[$$src];
    }
    label = 36;
    break;
   case 34:
    var $140 = $gfc + 85092 | 0;
    var $141 = HEAP32[$140 >> 2];
    var $142 = $141 & 1;
    var $143 = ($142 | 0) == 0;
    if ($143) {
      label = 36;
      break;
    } else {
      label = 35;
      break;
    }
   case 35:
    _trancate_smallspectrums($gfc, $cod_info, $l3_xmin, $xrpow);
    label = 36;
    break;
   case 36:
    var $146 = $best_noise_info + 12 | 0;
    var $147 = HEAP32[$146 >> 2];
    var $_0 = $147;
    label = 37;
    break;
   case 37:
    var $_0;
    STACKTOP = __stackBase__;
    return $_0;
  }
}
_outer_loop["X"] = 1;
function _CBR_iteration_loop($gfc, $pe, $ms_ener_ratio, $ratio) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 2472 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $l3_xmin = __stackBase__;
    var $xrpow = __stackBase__ + 156;
    var $targ_bits = __stackBase__ + 2460;
    var $mean_bits = __stackBase__ + 2468;
    var $1 = $gfc + 304 | 0;
    var $2 = _ResvFrameBegin($gfc, $mean_bits);
    var $3 = $gfc + 76 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) > 0;
    if ($5) {
      label = 3;
      break;
    } else {
      label = 11;
      break;
    }
   case 3:
    var $6 = $targ_bits | 0;
    var $7 = HEAP32[$mean_bits >> 2];
    var $8 = $gfc + 84752 | 0;
    var $9 = $gfc + 72 | 0;
    var $10 = $gfc + 84908 | 0;
    var $11 = $gfc + 84912 | 0;
    var $12 = $gfc + 84904 | 0;
    var $13 = $xrpow | 0;
    var $14 = $l3_xmin | 0;
    var $gr_037 = 0;
    label = 4;
    break;
   case 4:
    var $gr_037;
    var $16 = _on_pe($gfc, $pe, $6, $7, $gr_037, $gr_037);
    var $17 = HEAP32[$8 >> 2];
    var $18 = ($17 | 0) == 2;
    if ($18) {
      label = 5;
      break;
    } else {
      label = 6;
      break;
    }
   case 5:
    _ms_convert($1, $gr_037);
    var $20 = $ms_ener_ratio + ($gr_037 << 2) | 0;
    var $21 = HEAPF32[$20 >> 2];
    _reduce_side($6, $21, $7, $16);
    label = 6;
    break;
   case 6:
    var $22 = HEAP32[$9 >> 2];
    var $23 = ($22 | 0) > 0;
    if ($23) {
      var $ch_036 = 0;
      label = 7;
      break;
    } else {
      label = 10;
      break;
    }
   case 7:
    var $ch_036;
    var $24 = $gfc + 304 + $gr_037 * 10504 + $ch_036 * 5252 | 0;
    var $25 = $gfc + 304 + $gr_037 * 10504 + $ch_036 * 5252 + 4788 | 0;
    var $26 = HEAP32[$25 >> 2];
    var $27 = ($26 | 0) == 2;
    var $masking_lower_db_0_in = $27 ? $11 : $10;
    var $masking_lower_db_0 = HEAPF32[$masking_lower_db_0_in >> 2];
    var $28 = $masking_lower_db_0;
    var $29 = $28 * .1;
    var $30 = Math.pow(10, $29);
    var $31 = $30;
    HEAPF32[$12 >> 2] = $31;
    _init_outer_loop($gfc, $24);
    var $32 = _init_xrpow($gfc, $24, $13);
    var $33 = ($32 | 0) == 0;
    if ($33) {
      label = 9;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    var $35 = $ratio + $gr_037 * 976 + $ch_036 * 488 | 0;
    var $36 = _calc_xmin($gfc, $35, $24, $14);
    var $37 = $targ_bits + ($ch_036 << 2) | 0;
    var $38 = HEAP32[$37 >> 2];
    var $39 = _outer_loop($gfc, $24, $14, $13, $ch_036, $38);
    label = 9;
    break;
   case 9:
    _iteration_finish_one($gfc, $gr_037, $ch_036);
    var $41 = $ch_036 + 1 | 0;
    var $42 = HEAP32[$9 >> 2];
    var $43 = ($41 | 0) < ($42 | 0);
    if ($43) {
      var $ch_036 = $41;
      label = 7;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    var $44 = $gr_037 + 1 | 0;
    var $45 = HEAP32[$3 >> 2];
    var $46 = ($44 | 0) < ($45 | 0);
    if ($46) {
      var $gr_037 = $44;
      label = 4;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    var $47 = HEAP32[$mean_bits >> 2];
    _ResvFrameEnd($gfc, $47);
    STACKTOP = __stackBase__;
    return;
  }
}
_CBR_iteration_loop["X"] = 1;
function _bin_search_StepSize($gfc, $cod_info, $desired_rate, $ch, $xrpow) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 84924 + ($ch << 2) | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $gfc + 84916 + ($ch << 2) | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = $cod_info + 4780 | 0;
    HEAP32[$5 >> 2] = $4;
    var $6 = $cod_info + 4844 | 0;
    var $7 = HEAP32[$6 >> 2];
    var $8 = $desired_rate - $7 | 0;
    var $9 = _count_bits($gfc, $xrpow, $cod_info, 0);
    var $10 = ($2 | 0) == 1;
    var $11 = ($9 | 0) == ($8 | 0);
    var $or_cond3 = $10 | $11;
    if ($or_cond3) {
      var $_lcssa = $9;
      label = 3;
      break;
    } else {
      var $CurrentStep_04 = $2;
      var $flag_GoneOver_05 = 0;
      var $Direction_06 = 0;
      var $13 = $9;
      label = 4;
      break;
    }
   case 3:
    var $_lcssa;
    var $12 = ($_lcssa | 0) > ($8 | 0);
    if ($12) {
      var $nBits_02 = $_lcssa;
      label = 11;
      break;
    } else {
      var $nBits_0_lcssa = $_lcssa;
      label = 13;
      break;
    }
   case 4:
    var $13;
    var $Direction_06;
    var $flag_GoneOver_05;
    var $CurrentStep_04;
    var $14 = ($13 | 0) > ($8 | 0);
    if ($14) {
      label = 5;
      break;
    } else {
      label = 7;
      break;
    }
   case 5:
    var $16 = ($Direction_06 | 0) == 2;
    var $_flag_GoneOver_0 = $16 ? 1 : $flag_GoneOver_05;
    var $17 = ($_flag_GoneOver_0 | 0) == 0;
    if ($17) {
      var $step_0 = $CurrentStep_04;
      var $Direction_1 = 1;
      var $flag_GoneOver_3 = 0;
      var $CurrentStep_3 = $CurrentStep_04;
      label = 10;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    var $19 = ($CurrentStep_04 | 0) / 2 & -1;
    var $step_0 = $19;
    var $Direction_1 = 1;
    var $flag_GoneOver_3 = $_flag_GoneOver_0;
    var $CurrentStep_3 = $19;
    label = 10;
    break;
   case 7:
    var $21 = ($Direction_06 | 0) == 1;
    var $_flag_GoneOver_01 = $21 ? 1 : $flag_GoneOver_05;
    var $22 = ($_flag_GoneOver_01 | 0) == 0;
    if ($22) {
      var $CurrentStep_2 = $CurrentStep_04;
      label = 9;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    var $24 = ($CurrentStep_04 | 0) / 2 & -1;
    var $CurrentStep_2 = $24;
    label = 9;
    break;
   case 9:
    var $CurrentStep_2;
    var $26 = -$CurrentStep_2 | 0;
    var $step_0 = $26;
    var $Direction_1 = 2;
    var $flag_GoneOver_3 = $_flag_GoneOver_01;
    var $CurrentStep_3 = $CurrentStep_2;
    label = 10;
    break;
   case 10:
    var $CurrentStep_3;
    var $flag_GoneOver_3;
    var $Direction_1;
    var $step_0;
    var $27 = HEAP32[$5 >> 2];
    var $28 = $27 + $step_0 | 0;
    var $29 = ($28 | 0) < 0;
    var $_ = $29 ? 0 : $28;
    var $_flag_GoneOver_3 = $29 ? 1 : $flag_GoneOver_3;
    var $30 = ($_ | 0) > 255;
    var $__ = $30 ? 255 : $_;
    var $__flag_GoneOver_3 = $30 ? 1 : $_flag_GoneOver_3;
    HEAP32[$5 >> 2] = $__;
    var $31 = _count_bits($gfc, $xrpow, $cod_info, 0);
    var $32 = ($CurrentStep_3 | 0) == 1;
    var $33 = ($31 | 0) == ($8 | 0);
    var $or_cond = $32 | $33;
    if ($or_cond) {
      var $_lcssa = $31;
      label = 3;
      break;
    } else {
      var $CurrentStep_04 = $CurrentStep_3;
      var $flag_GoneOver_05 = $__flag_GoneOver_3;
      var $Direction_06 = $Direction_1;
      var $13 = $31;
      label = 4;
      break;
    }
   case 11:
    var $nBits_02;
    var $34 = HEAP32[$5 >> 2];
    var $35 = ($34 | 0) < 255;
    if ($35) {
      label = 12;
      break;
    } else {
      var $nBits_0_lcssa = $nBits_02;
      label = 13;
      break;
    }
   case 12:
    var $37 = $34 + 1 | 0;
    HEAP32[$5 >> 2] = $37;
    var $38 = _count_bits($gfc, $xrpow, $cod_info, 0);
    var $39 = ($38 | 0) > ($8 | 0);
    if ($39) {
      var $nBits_02 = $38;
      label = 11;
      break;
    } else {
      var $nBits_0_lcssa = $38;
      label = 13;
      break;
    }
   case 13:
    var $nBits_0_lcssa;
    var $40 = HEAP32[$5 >> 2];
    var $41 = $4 - $40 | 0;
    var $42 = ($41 | 0) > 3;
    var $43 = $42 ? 4 : 2;
    HEAP32[$1 >> 2] = $43;
    var $44 = HEAP32[$5 >> 2];
    HEAP32[$3 >> 2] = $44;
    var $45 = $cod_info + 4768 | 0;
    HEAP32[$45 >> 2] = $nBits_0_lcssa;
    return;
  }
}
_bin_search_StepSize["X"] = 1;
function _balance_noise($gfc, $cod_info, $distort, $xrpow, $bRefine) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    _amp_scalefac_bands($gfc, $cod_info, $distort, $xrpow, $bRefine);
    var $1 = _loop_break($cod_info);
    var $2 = ($1 | 0) == 0;
    if ($2) {
      label = 3;
      break;
    } else {
      var $_0 = 0;
      label = 15;
      break;
    }
   case 3:
    var $4 = _scale_bitcount($gfc, $cod_info);
    var $5 = ($4 | 0) == 0;
    if ($5) {
      var $_0 = 1;
      label = 15;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $7 = $gfc + 28 | 0;
    var $8 = HEAP32[$7 >> 2];
    var $9 = ($8 | 0) > 1;
    if ($9) {
      label = 5;
      break;
    } else {
      var $status_1 = $4;
      label = 14;
      break;
    }
   case 5:
    var $11 = $gfc + 84932 | 0;
    var $12 = $11;
    for (var $$dest = $12 >> 2, $$stop = $$dest + 39; $$dest < $$stop; $$dest++) {
      HEAP32[$$dest] = 0;
    }
    var $13 = $cod_info + 4836 | 0;
    var $14 = HEAP32[$13 >> 2];
    var $15 = ($14 | 0) == 0;
    if ($15) {
      label = 6;
      break;
    } else {
      label = 7;
      break;
    }
   case 6:
    _inc_scalefac_scale($cod_info, $xrpow);
    label = 13;
    break;
   case 7:
    var $17 = $cod_info + 4788 | 0;
    var $18 = HEAP32[$17 >> 2];
    var $19 = ($18 | 0) == 2;
    if ($19) {
      label = 8;
      break;
    } else {
      var $status_0 = $4;
      label = 12;
      break;
    }
   case 8:
    var $21 = $gfc + 32 | 0;
    var $22 = HEAP32[$21 >> 2];
    var $23 = ($22 | 0) > 0;
    if ($23) {
      label = 9;
      break;
    } else {
      var $status_0 = $4;
      label = 12;
      break;
    }
   case 9:
    var $25 = _inc_subblock_gain($gfc, $cod_info, $xrpow);
    var $26 = ($25 | 0) == 0;
    if ($26) {
      label = 10;
      break;
    } else {
      var $31 = 1;
      label = 11;
      break;
    }
   case 10:
    var $28 = _loop_break($cod_info);
    var $29 = ($28 | 0) != 0;
    var $31 = $29;
    label = 11;
    break;
   case 11:
    var $31;
    var $32 = $31 & 1;
    var $status_0 = $32;
    label = 12;
    break;
   case 12:
    var $status_0;
    var $34 = ($status_0 | 0) == 0;
    if ($34) {
      label = 13;
      break;
    } else {
      var $status_1 = $status_0;
      label = 14;
      break;
    }
   case 13:
    var $36 = _scale_bitcount($gfc, $cod_info);
    var $status_1 = $36;
    label = 14;
    break;
   case 14:
    var $status_1;
    var $37 = ($status_1 | 0) == 0;
    var $38 = $37 & 1;
    var $_0 = $38;
    label = 15;
    break;
   case 15:
    var $_0;
    return $_0;
  }
}
function _loop_break($cod_info) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $cod_info + 4860 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $sfb_0 = 0;
    label = 3;
    break;
   case 3:
    var $sfb_0;
    var $4 = ($sfb_0 | 0) < ($2 | 0);
    if ($4) {
      label = 4;
      break;
    } else {
      var $_0 = 1;
      label = 5;
      break;
    }
   case 4:
    var $6 = $cod_info + 4608 + ($sfb_0 << 2) | 0;
    var $7 = HEAP32[$6 >> 2];
    var $8 = $cod_info + 5028 + ($sfb_0 << 2) | 0;
    var $9 = HEAP32[$8 >> 2];
    var $10 = $cod_info + 4808 + ($9 << 2) | 0;
    var $11 = HEAP32[$10 >> 2];
    var $12 = -$11 | 0;
    var $13 = ($7 | 0) == ($12 | 0);
    var $14 = $sfb_0 + 1 | 0;
    if ($13) {
      var $_0 = 0;
      label = 5;
      break;
    } else {
      var $sfb_0 = $14;
      label = 3;
      break;
    }
   case 5:
    var $_0;
    return $_0;
  }
}
function _inc_scalefac_scale($cod_info, $xrpow) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $cod_info + 4860 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($2 | 0) > 0;
    if ($3) {
      label = 3;
      break;
    } else {
      label = 13;
      break;
    }
   case 3:
    var $4 = $cod_info + 4832 | 0;
    var $5 = $cod_info + 4764 | 0;
    var $sfb_029 = 0;
    var $j_030 = 0;
    label = 4;
    break;
   case 4:
    var $j_030;
    var $sfb_029;
    var $7 = $cod_info + 4872 + ($sfb_029 << 2) | 0;
    var $8 = HEAP32[$7 >> 2];
    var $9 = $cod_info + 4608 + ($sfb_029 << 2) | 0;
    var $10 = HEAP32[$9 >> 2];
    var $11 = HEAP32[$4 >> 2];
    var $12 = ($11 | 0) == 0;
    if ($12) {
      var $s_0 = $10;
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $14 = 5257016 + ($sfb_029 << 2) | 0;
    var $15 = HEAP32[$14 >> 2];
    var $16 = $15 + $10 | 0;
    var $s_0 = $16;
    label = 6;
    break;
   case 6:
    var $s_0;
    var $18 = $8 + $j_030 | 0;
    var $19 = $s_0 & 1;
    var $20 = ($19 | 0) == 0;
    if ($20) {
      var $s_1 = $s_0;
      label = 12;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    var $22 = $s_0 + 1 | 0;
    var $23 = ($8 | 0) > 0;
    if ($23) {
      label = 8;
      break;
    } else {
      var $s_1 = $22;
      label = 12;
      break;
    }
   case 8:
    var $24 = -$8 | 0;
    var $l_028 = $24;
    label = 9;
    break;
   case 9:
    var $l_028;
    var $26 = $l_028 + $18 | 0;
    var $27 = $xrpow + ($26 << 2) | 0;
    var $28 = HEAPF32[$27 >> 2];
    var $29 = $28 * 1.2968395948410034;
    HEAPF32[$27 >> 2] = $29;
    var $30 = HEAPF32[$5 >> 2];
    var $31 = $29 > $30;
    if ($31) {
      label = 10;
      break;
    } else {
      label = 11;
      break;
    }
   case 10:
    HEAPF32[$5 >> 2] = $29;
    label = 11;
    break;
   case 11:
    var $34 = $l_028 + 1 | 0;
    var $35 = ($34 | 0) < 0;
    if ($35) {
      var $l_028 = $34;
      label = 9;
      break;
    } else {
      var $s_1 = $22;
      label = 12;
      break;
    }
   case 12:
    var $s_1;
    var $36 = $s_1 >> 1;
    HEAP32[$9 >> 2] = $36;
    var $37 = $sfb_029 + 1 | 0;
    var $38 = HEAP32[$1 >> 2];
    var $39 = ($37 | 0) < ($38 | 0);
    if ($39) {
      var $sfb_029 = $37;
      var $j_030 = $18;
      label = 4;
      break;
    } else {
      label = 13;
      break;
    }
   case 13:
    var $40 = $cod_info + 4832 | 0;
    HEAP32[$40 >> 2] = 0;
    var $41 = $cod_info + 4836 | 0;
    HEAP32[$41 >> 2] = 1;
    return;
  }
}
_inc_scalefac_scale["X"] = 1;
function _quant_compare($quant_comp, $best, $calc, $gi, $distort) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    if (($quant_comp | 0) == 0) {
      label = 9;
      break;
    } else if (($quant_comp | 0) == 8) {
      label = 18;
      break;
    } else if (($quant_comp | 0) == 1) {
      label = 19;
      break;
    } else if (($quant_comp | 0) == 2) {
      label = 20;
      break;
    } else if (($quant_comp | 0) == 3) {
      label = 21;
      break;
    } else if (($quant_comp | 0) == 4) {
      label = 24;
      break;
    } else if (($quant_comp | 0) == 5) {
      label = 45;
      break;
    } else if (($quant_comp | 0) == 6) {
      label = 51;
      break;
    } else if (($quant_comp | 0) == 7) {
      label = 61;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $2 = $best + 12 | 0;
    var $3 = HEAP32[$2 >> 2];
    var $4 = ($3 | 0) > 0;
    if ($4) {
      label = 4;
      break;
    } else {
      label = 6;
      break;
    }
   case 4:
    var $6 = $calc + 16 | 0;
    var $7 = HEAP32[$6 >> 2];
    var $8 = $best + 16 | 0;
    var $9 = HEAP32[$8 >> 2];
    var $10 = ($7 | 0) <= ($9 | 0);
    var $11 = $10 & 1;
    var $12 = ($7 | 0) == ($9 | 0);
    if ($12) {
      label = 5;
      break;
    } else {
      var $better_0 = $11;
      label = 64;
      break;
    }
   case 5:
    var $14 = $calc + 20 | 0;
    var $15 = HEAP32[$14 >> 2];
    var $16 = $best + 20 | 0;
    var $17 = HEAP32[$16 >> 2];
    var $18 = ($15 | 0) < ($17 | 0);
    var $19 = $18 & 1;
    var $better_0 = $19;
    label = 64;
    break;
   case 6:
    var $21 = $calc + 8 | 0;
    var $22 = HEAPF32[$21 >> 2];
    var $23 = $22 < 0;
    if ($23) {
      label = 7;
      break;
    } else {
      var $39 = 0;
      label = 8;
      break;
    }
   case 7:
    var $25 = $22 * 10;
    var $26 = $calc + 20 | 0;
    var $27 = HEAP32[$26 >> 2];
    var $28 = $27 | 0;
    var $29 = $25 + $28;
    var $30 = $best + 8 | 0;
    var $31 = HEAPF32[$30 >> 2];
    var $32 = $31 * 10;
    var $33 = $best + 20 | 0;
    var $34 = HEAP32[$33 >> 2];
    var $35 = $34 | 0;
    var $36 = $32 + $35;
    var $37 = $29 <= $36;
    var $39 = $37;
    label = 8;
    break;
   case 8:
    var $39;
    var $40 = $39 & 1;
    var $better_0 = $40;
    label = 64;
    break;
   case 9:
    var $42 = $calc + 12 | 0;
    var $43 = HEAP32[$42 >> 2];
    var $44 = $best + 12 | 0;
    var $45 = HEAP32[$44 >> 2];
    var $46 = ($43 | 0) < ($45 | 0);
    if ($46) {
      var $82 = 1;
      label = 17;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    var $48 = ($43 | 0) == ($45 | 0);
    if ($48) {
      label = 11;
      break;
    } else {
      label = 12;
      break;
    }
   case 11:
    var $50 = $calc | 0;
    var $51 = HEAPF32[$50 >> 2];
    var $52 = $best | 0;
    var $53 = HEAPF32[$52 >> 2];
    var $54 = $51 < $53;
    if ($54) {
      var $82 = 1;
      label = 17;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    var $56 = HEAP32[$42 >> 2];
    var $57 = HEAP32[$44 >> 2];
    var $58 = ($56 | 0) == ($57 | 0);
    if ($58) {
      label = 13;
      break;
    } else {
      var $82 = 0;
      label = 17;
      break;
    }
   case 13:
    var $60 = $calc | 0;
    var $61 = HEAPF32[$60 >> 2];
    var $fabsf = Math.abs($61);
    var $62 = $best | 0;
    var $63 = HEAPF32[$62 >> 2];
    var $fabsf108 = Math.abs($63);
    var $64 = $fabsf > $fabsf108;
    var $65 = $61 - $63;
    var $fabsf109 = Math.abs($65);
    var $66 = $fabsf109;
    if ($64) {
      label = 14;
      break;
    } else {
      label = 15;
      break;
    }
   case 14:
    var $68 = $fabsf;
    var $69 = $68 * 9.999999974752427e-7;
    var $70 = $66 > $69;
    if ($70) {
      var $82 = 0;
      label = 17;
      break;
    } else {
      label = 16;
      break;
    }
   case 15:
    var $72 = $fabsf108;
    var $73 = $72 * 9.999999974752427e-7;
    var $74 = $66 > $73;
    if ($74) {
      var $82 = 0;
      label = 17;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    var $76 = $calc + 4 | 0;
    var $77 = HEAPF32[$76 >> 2];
    var $78 = $best + 4 | 0;
    var $79 = HEAPF32[$78 >> 2];
    var $80 = $77 < $79;
    var $82 = $80;
    label = 17;
    break;
   case 17:
    var $82;
    var $83 = $82 & 1;
    var $better_0 = $83;
    label = 64;
    break;
   case 18:
    var $85 = _get_klemm_noise($distort, $gi);
    var $86 = $85;
    var $87 = $calc + 8 | 0;
    HEAPF32[$87 >> 2] = $86;
    label = 19;
    break;
   case 19:
    var $89 = $calc + 8 | 0;
    var $90 = HEAPF32[$89 >> 2];
    var $91 = $best + 8 | 0;
    var $92 = HEAPF32[$91 >> 2];
    var $93 = $90 < $92;
    var $94 = $93 & 1;
    var $better_0 = $94;
    label = 64;
    break;
   case 20:
    var $96 = $calc + 4 | 0;
    var $97 = HEAPF32[$96 >> 2];
    var $98 = $best + 4 | 0;
    var $99 = HEAPF32[$98 >> 2];
    var $100 = $97 < $99;
    var $101 = $100 & 1;
    var $better_0 = $101;
    label = 64;
    break;
   case 21:
    var $103 = $calc + 4 | 0;
    var $104 = HEAPF32[$103 >> 2];
    var $105 = $best + 4 | 0;
    var $106 = HEAPF32[$105 >> 2];
    var $107 = $104 < $106;
    if ($107) {
      label = 22;
      break;
    } else {
      var $115 = 0;
      label = 23;
      break;
    }
   case 22:
    var $109 = $calc + 8 | 0;
    var $110 = HEAPF32[$109 >> 2];
    var $111 = $best + 8 | 0;
    var $112 = HEAPF32[$111 >> 2];
    var $113 = $110 < $112;
    var $115 = $113;
    label = 23;
    break;
   case 23:
    var $115;
    var $116 = $115 & 1;
    var $better_0 = $116;
    label = 64;
    break;
   case 24:
    var $118 = $calc + 8 | 0;
    var $119 = HEAPF32[$118 >> 2];
    var $120 = $119 > 0;
    if ($120) {
      var $127 = $119;
      label = 27;
      break;
    } else {
      label = 25;
      break;
    }
   case 25:
    var $122 = $best + 8 | 0;
    var $123 = HEAPF32[$122 >> 2];
    var $124 = $123;
    var $125 = $124 > .2;
    if ($125) {
      var $216 = 1;
      label = 44;
      break;
    } else {
      label = 26;
      break;
    }
   case 26:
    var $_pr = HEAPF32[$118 >> 2];
    var $127 = $_pr;
    label = 27;
    break;
   case 27:
    var $127;
    var $128 = $127;
    var $129 = $127 > 0;
    if ($129) {
      label = 31;
      break;
    } else {
      label = 28;
      break;
    }
   case 28:
    var $131 = $best + 8 | 0;
    var $132 = HEAPF32[$131 >> 2];
    var $133 = $132 < 0;
    if ($133) {
      label = 29;
      break;
    } else {
      label = 31;
      break;
    }
   case 29:
    var $135 = $132;
    var $136 = $128 - .2;
    var $137 = $135 > $136;
    if ($137) {
      label = 30;
      break;
    } else {
      label = 31;
      break;
    }
   case 30:
    var $139 = $calc + 4 | 0;
    var $140 = HEAPF32[$139 >> 2];
    var $141 = $best + 4 | 0;
    var $142 = HEAPF32[$141 >> 2];
    var $143 = $140 < $142;
    if ($143) {
      var $216 = 1;
      label = 44;
      break;
    } else {
      label = 31;
      break;
    }
   case 31:
    var $145 = HEAPF32[$118 >> 2];
    var $146 = $145;
    var $147 = $145 > 0;
    if ($147) {
      var $166 = $145;
      label = 36;
      break;
    } else {
      label = 32;
      break;
    }
   case 32:
    var $149 = $best + 8 | 0;
    var $150 = HEAPF32[$149 >> 2];
    var $151 = $150 > 0;
    if ($151) {
      label = 33;
      break;
    } else {
      label = 35;
      break;
    }
   case 33:
    var $153 = $150;
    var $154 = $146 - .2;
    var $155 = $153 > $154;
    if ($155) {
      label = 34;
      break;
    } else {
      label = 35;
      break;
    }
   case 34:
    var $157 = $calc + 4 | 0;
    var $158 = HEAPF32[$157 >> 2];
    var $159 = $best + 4 | 0;
    var $160 = HEAPF32[$159 >> 2];
    var $161 = $best | 0;
    var $162 = HEAPF32[$161 >> 2];
    var $163 = $160 + $162;
    var $164 = $158 < $163;
    if ($164) {
      var $216 = 1;
      label = 44;
      break;
    } else {
      label = 35;
      break;
    }
   case 35:
    var $_pr120 = HEAPF32[$118 >> 2];
    var $166 = $_pr120;
    label = 36;
    break;
   case 36:
    var $166;
    var $167 = $166;
    var $168 = $166 > 0;
    if ($168) {
      label = 37;
      break;
    } else {
      label = 40;
      break;
    }
   case 37:
    var $170 = $best + 8 | 0;
    var $171 = HEAPF32[$170 >> 2];
    var $172 = $171;
    var $173 = $172 > -.05;
    if ($173) {
      label = 38;
      break;
    } else {
      label = 40;
      break;
    }
   case 38:
    var $175 = $167 - .1;
    var $176 = $172 > $175;
    if ($176) {
      label = 39;
      break;
    } else {
      label = 40;
      break;
    }
   case 39:
    var $178 = $calc + 4 | 0;
    var $179 = HEAPF32[$178 >> 2];
    var $180 = $calc | 0;
    var $181 = HEAPF32[$180 >> 2];
    var $182 = $179 + $181;
    var $183 = $best + 4 | 0;
    var $184 = HEAPF32[$183 >> 2];
    var $185 = $best | 0;
    var $186 = HEAPF32[$185 >> 2];
    var $187 = $184 + $186;
    var $188 = $182 < $187;
    if ($188) {
      var $216 = 1;
      label = 44;
      break;
    } else {
      label = 40;
      break;
    }
   case 40:
    var $190 = HEAPF32[$118 >> 2];
    var $191 = $190;
    var $192 = $190 > 0;
    if ($192) {
      label = 41;
      break;
    } else {
      var $216 = 0;
      label = 44;
      break;
    }
   case 41:
    var $194 = $best + 8 | 0;
    var $195 = HEAPF32[$194 >> 2];
    var $196 = $195;
    var $197 = $196 > -.1;
    if ($197) {
      label = 42;
      break;
    } else {
      var $216 = 0;
      label = 44;
      break;
    }
   case 42:
    var $199 = $191 - .15;
    var $200 = $196 > $199;
    if ($200) {
      label = 43;
      break;
    } else {
      var $216 = 0;
      label = 44;
      break;
    }
   case 43:
    var $202 = $calc + 4 | 0;
    var $203 = HEAPF32[$202 >> 2];
    var $204 = $calc | 0;
    var $205 = HEAPF32[$204 >> 2];
    var $206 = $203 + $205;
    var $207 = $205 + $206;
    var $208 = $best + 4 | 0;
    var $209 = HEAPF32[$208 >> 2];
    var $210 = $best | 0;
    var $211 = HEAPF32[$210 >> 2];
    var $212 = $209 + $211;
    var $213 = $211 + $212;
    var $214 = $207 < $213;
    var $216 = $214;
    label = 44;
    break;
   case 44:
    var $216;
    var $217 = $216 & 1;
    var $better_0 = $217;
    label = 64;
    break;
   case 45:
    var $219 = $calc | 0;
    var $220 = HEAPF32[$219 >> 2];
    var $221 = $best | 0;
    var $222 = HEAPF32[$221 >> 2];
    var $223 = $220 < $222;
    if ($223) {
      var $243 = 1;
      label = 50;
      break;
    } else {
      label = 46;
      break;
    }
   case 46:
    var $fabsf110 = Math.abs($220);
    var $fabsf111 = Math.abs($222);
    var $225 = $fabsf110 > $fabsf111;
    var $226 = $220 - $222;
    var $fabsf112 = Math.abs($226);
    var $227 = $fabsf112;
    if ($225) {
      label = 47;
      break;
    } else {
      label = 48;
      break;
    }
   case 47:
    var $229 = $fabsf110;
    var $230 = $229 * 9.999999974752427e-7;
    var $231 = $227 > $230;
    if ($231) {
      var $243 = 0;
      label = 50;
      break;
    } else {
      label = 49;
      break;
    }
   case 48:
    var $233 = $fabsf111;
    var $234 = $233 * 9.999999974752427e-7;
    var $235 = $227 > $234;
    if ($235) {
      var $243 = 0;
      label = 50;
      break;
    } else {
      label = 49;
      break;
    }
   case 49:
    var $237 = $calc + 4 | 0;
    var $238 = HEAPF32[$237 >> 2];
    var $239 = $best + 4 | 0;
    var $240 = HEAPF32[$239 >> 2];
    var $241 = $238 < $240;
    var $243 = $241;
    label = 50;
    break;
   case 50:
    var $243;
    var $244 = $243 & 1;
    var $better_0 = $244;
    label = 64;
    break;
   case 51:
    var $246 = $calc | 0;
    var $247 = HEAPF32[$246 >> 2];
    var $248 = $best | 0;
    var $249 = HEAPF32[$248 >> 2];
    var $250 = $247 < $249;
    if ($250) {
      var $288 = 1;
      label = 60;
      break;
    } else {
      label = 52;
      break;
    }
   case 52:
    var $fabsf113 = Math.abs($247);
    var $fabsf114 = Math.abs($249);
    var $252 = $fabsf113 > $fabsf114;
    var $253 = $247 - $249;
    var $fabsf115 = Math.abs($253);
    var $254 = $fabsf115;
    if ($252) {
      label = 53;
      break;
    } else {
      label = 54;
      break;
    }
   case 53:
    var $256 = $fabsf113;
    var $257 = $256 * 9.999999974752427e-7;
    var $258 = $254 > $257;
    if ($258) {
      var $288 = 0;
      label = 60;
      break;
    } else {
      label = 55;
      break;
    }
   case 54:
    var $260 = $fabsf114;
    var $261 = $260 * 9.999999974752427e-7;
    var $262 = $254 > $261;
    if ($262) {
      var $288 = 0;
      label = 60;
      break;
    } else {
      label = 55;
      break;
    }
   case 55:
    var $264 = $calc + 8 | 0;
    var $265 = HEAPF32[$264 >> 2];
    var $266 = $best + 8 | 0;
    var $267 = HEAPF32[$266 >> 2];
    var $268 = $265 < $267;
    if ($268) {
      var $288 = 1;
      label = 60;
      break;
    } else {
      label = 56;
      break;
    }
   case 56:
    var $fabsf116 = Math.abs($265);
    var $fabsf117 = Math.abs($267);
    var $270 = $fabsf116 > $fabsf117;
    var $271 = $265 - $267;
    var $fabsf118 = Math.abs($271);
    var $272 = $fabsf118;
    if ($270) {
      label = 57;
      break;
    } else {
      label = 58;
      break;
    }
   case 57:
    var $274 = $fabsf116;
    var $275 = $274 * 9.999999974752427e-7;
    var $276 = $272 > $275;
    if ($276) {
      var $288 = 0;
      label = 60;
      break;
    } else {
      label = 59;
      break;
    }
   case 58:
    var $278 = $fabsf117;
    var $279 = $278 * 9.999999974752427e-7;
    var $280 = $272 > $279;
    if ($280) {
      var $288 = 0;
      label = 60;
      break;
    } else {
      label = 59;
      break;
    }
   case 59:
    var $282 = $calc + 4 | 0;
    var $283 = HEAPF32[$282 >> 2];
    var $284 = $best + 4 | 0;
    var $285 = HEAPF32[$284 >> 2];
    var $286 = $283 <= $285;
    var $288 = $286;
    label = 60;
    break;
   case 60:
    var $288;
    var $289 = $288 & 1;
    var $better_0 = $289;
    label = 64;
    break;
   case 61:
    var $291 = $calc + 12 | 0;
    var $292 = HEAP32[$291 >> 2];
    var $293 = $best + 12 | 0;
    var $294 = HEAP32[$293 >> 2];
    var $295 = ($292 | 0) < ($294 | 0);
    if ($295) {
      var $303 = 1;
      label = 63;
      break;
    } else {
      label = 62;
      break;
    }
   case 62:
    var $297 = $calc | 0;
    var $298 = HEAPF32[$297 >> 2];
    var $299 = $best | 0;
    var $300 = HEAPF32[$299 >> 2];
    var $301 = $298 < $300;
    var $303 = $301;
    label = 63;
    break;
   case 63:
    var $303;
    var $304 = $303 & 1;
    var $better_0 = $304;
    label = 64;
    break;
   case 64:
    var $better_0;
    var $306 = $best + 12 | 0;
    var $307 = HEAP32[$306 >> 2];
    var $308 = ($307 | 0) == 0;
    if ($308) {
      label = 65;
      break;
    } else {
      var $better_1 = $better_0;
      label = 68;
      break;
    }
   case 65:
    var $310 = ($better_0 | 0) == 0;
    if ($310) {
      var $318 = 0;
      label = 67;
      break;
    } else {
      label = 66;
      break;
    }
   case 66:
    var $312 = $calc + 20 | 0;
    var $313 = HEAP32[$312 >> 2];
    var $314 = $best + 20 | 0;
    var $315 = HEAP32[$314 >> 2];
    var $316 = ($313 | 0) < ($315 | 0);
    var $318 = $316;
    label = 67;
    break;
   case 67:
    var $318;
    var $319 = $318 & 1;
    var $better_1 = $319;
    label = 68;
    break;
   case 68:
    var $better_1;
    return $better_1;
  }
}
_quant_compare["X"] = 1;
function _get_klemm_noise($distort, $gi) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gi + 4864 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($2 | 0) > 0;
    if ($3) {
      label = 3;
      break;
    } else {
      var $klemm_noise_0_lcssa = 1e-37;
      label = 5;
      break;
    }
   case 3:
    var $4 = HEAP32[$1 >> 2];
    var $sfb_06 = 0;
    var $klemm_noise_07 = 1e-37;
    label = 4;
    break;
   case 4:
    var $klemm_noise_07;
    var $sfb_06;
    var $6 = $distort + ($sfb_06 << 2) | 0;
    var $7 = HEAPF32[$6 >> 2];
    var $8 = $7;
    var $9 = _penalties($8);
    var $10 = $klemm_noise_07 + $9;
    var $11 = $sfb_06 + 1 | 0;
    var $12 = ($11 | 0) < ($4 | 0);
    if ($12) {
      var $sfb_06 = $11;
      var $klemm_noise_07 = $10;
      label = 4;
      break;
    } else {
      var $klemm_noise_0_lcssa = $10;
      label = 5;
      break;
    }
   case 5:
    var $klemm_noise_0_lcssa;
    var $13 = $klemm_noise_0_lcssa < 1e-20;
    var $14 = $13 ? 1e-20 : $klemm_noise_0_lcssa;
    return $14;
  }
}
function _penalties($noise) {
  return _fast_log2($noise * .632 * $noise * $noise + .368) * .30102999566398114;
}
function _amp_scalefac_bands($gfc, $cod_info, $distort, $xrpow, $bRefine) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $cod_info + 4836 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($2 | 0) == 0;
    var $_ = $3 ? 1.2968395948410034 : 1.6817928552627563;
    var $4 = $cod_info + 4860 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = ($5 | 0) > 0;
    if ($6) {
      label = 3;
      break;
    } else {
      var $trigger_0_lcssa = 0;
      label = 5;
      break;
    }
   case 3:
    var $7 = HEAP32[$4 >> 2];
    var $sfb_054 = 0;
    var $trigger_055 = 0;
    label = 4;
    break;
   case 4:
    var $trigger_055;
    var $sfb_054;
    var $9 = $distort + ($sfb_054 << 2) | 0;
    var $10 = HEAPF32[$9 >> 2];
    var $11 = $trigger_055 < $10;
    var $trigger_1 = $11 ? $10 : $trigger_055;
    var $12 = $sfb_054 + 1 | 0;
    var $13 = ($12 | 0) < ($7 | 0);
    if ($13) {
      var $sfb_054 = $12;
      var $trigger_055 = $trigger_1;
      label = 4;
      break;
    } else {
      var $trigger_0_lcssa = $trigger_1;
      label = 5;
      break;
    }
   case 5:
    var $trigger_0_lcssa;
    var $14 = $gfc + 40 | 0;
    var $15 = HEAP32[$14 >> 2];
    var $16 = ($15 | 0) == 3;
    if ($16) {
      label = 6;
      break;
    } else {
      var $noise_shaping_amp_0 = $15;
      label = 7;
      break;
    }
   case 6:
    var $18 = ($bRefine | 0) == 1;
    var $_46 = $18 ? 2 : 1;
    var $noise_shaping_amp_0 = $_46;
    label = 7;
    break;
   case 7:
    var $noise_shaping_amp_0;
    if (($noise_shaping_amp_0 | 0) == 1) {
      label = 8;
      break;
    } else if (($noise_shaping_amp_0 | 0) == 2) {
      var $trigger_2 = $trigger_0_lcssa;
      label = 13;
      break;
    } else {
      label = 11;
      break;
    }
   case 8:
    var $21 = $trigger_0_lcssa;
    var $22 = $trigger_0_lcssa > 1;
    if ($22) {
      label = 9;
      break;
    } else {
      label = 10;
      break;
    }
   case 9:
    var $sqrt = Math.sqrt($21);
    var $fabs = Math.abs($sqrt);
    var $24 = $trigger_0_lcssa == -Infinity;
    var $25 = $fabs;
    var $26 = $24 ? Infinity : $25;
    var $trigger_2 = $26;
    label = 13;
    break;
   case 10:
    var $28 = $21 * .95;
    var $29 = $28;
    var $trigger_2 = $29;
    label = 13;
    break;
   case 11:
    var $31 = $trigger_0_lcssa > 1;
    if ($31) {
      var $trigger_2 = 1;
      label = 13;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    var $33 = $trigger_0_lcssa;
    var $34 = $33 * .95;
    var $35 = $34;
    var $trigger_2 = $35;
    label = 13;
    break;
   case 13:
    var $trigger_2;
    var $37 = HEAP32[$4 >> 2];
    var $38 = ($37 | 0) > 0;
    if ($38) {
      label = 14;
      break;
    } else {
      label = 26;
      break;
    }
   case 14:
    var $39 = $gfc + 85092 | 0;
    var $40 = $cod_info + 4764 | 0;
    var $sfb_148 = 0;
    var $j_050 = 0;
    label = 15;
    break;
   case 15:
    var $j_050;
    var $sfb_148;
    var $42 = $cod_info + 4872 + ($sfb_148 << 2) | 0;
    var $43 = HEAP32[$42 >> 2];
    var $44 = $43 + $j_050 | 0;
    var $45 = $distort + ($sfb_148 << 2) | 0;
    var $46 = HEAPF32[$45 >> 2];
    var $47 = $46 < $trigger_2;
    if ($47) {
      label = 25;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    var $49 = HEAP32[$39 >> 2];
    var $50 = $49 & 2;
    var $51 = ($50 | 0) == 0;
    if ($51) {
      label = 19;
      break;
    } else {
      label = 17;
      break;
    }
   case 17:
    var $53 = $gfc + 84932 + ($sfb_148 << 2) | 0;
    var $54 = HEAP32[$53 >> 2];
    var $55 = ($54 | 0) == 0;
    var $56 = $55 & 1;
    HEAP32[$53 >> 2] = $56;
    if ($55) {
      label = 19;
      break;
    } else {
      label = 18;
      break;
    }
   case 18:
    var $58 = HEAP32[$14 >> 2];
    var $59 = ($58 | 0) == 2;
    if ($59) {
      label = 26;
      break;
    } else {
      label = 19;
      break;
    }
   case 19:
    var $61 = $cod_info + 4608 + ($sfb_148 << 2) | 0;
    var $62 = HEAP32[$61 >> 2];
    var $63 = $62 + 1 | 0;
    HEAP32[$61 >> 2] = $63;
    var $64 = ($43 | 0) > 0;
    if ($64) {
      label = 20;
      break;
    } else {
      label = 24;
      break;
    }
   case 20:
    var $65 = -$43 | 0;
    var $l_047 = $65;
    label = 21;
    break;
   case 21:
    var $l_047;
    var $67 = $l_047 + $44 | 0;
    var $68 = $xrpow + ($67 << 2) | 0;
    var $69 = HEAPF32[$68 >> 2];
    var $70 = $_ * $69;
    HEAPF32[$68 >> 2] = $70;
    var $71 = HEAPF32[$40 >> 2];
    var $72 = $70 > $71;
    if ($72) {
      label = 22;
      break;
    } else {
      label = 23;
      break;
    }
   case 22:
    HEAPF32[$40 >> 2] = $70;
    label = 23;
    break;
   case 23:
    var $75 = $l_047 + 1 | 0;
    var $76 = ($75 | 0) < 0;
    if ($76) {
      var $l_047 = $75;
      label = 21;
      break;
    } else {
      label = 24;
      break;
    }
   case 24:
    var $77 = HEAP32[$14 >> 2];
    var $78 = ($77 | 0) == 2;
    if ($78) {
      label = 26;
      break;
    } else {
      label = 25;
      break;
    }
   case 25:
    var $80 = $sfb_148 + 1 | 0;
    var $81 = HEAP32[$4 >> 2];
    var $82 = ($80 | 0) < ($81 | 0);
    if ($82) {
      var $sfb_148 = $80;
      var $j_050 = $44;
      label = 15;
      break;
    } else {
      label = 26;
      break;
    }
   case 26:
    return;
  }
}
_amp_scalefac_bands["X"] = 1;
function _floatcompare($v1, $v2) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $v1;
    var $2 = $v2;
    var $3 = HEAPF32[$1 >> 2];
    var $4 = HEAPF32[$2 >> 2];
    var $5 = $3 > $4;
    if ($5) {
      var $_0 = 1;
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $7 = $3 < $4;
    var $_ = $7 << 31 >> 31;
    var $_0 = $_;
    label = 4;
    break;
   case 4:
    var $_0;
    return $_0;
  }
}
function _inc_subblock_gain($gfc, $cod_info, $xrpow) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $cod_info + 4848 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $sfb_0 = 0;
    label = 3;
    break;
   case 3:
    var $sfb_0;
    var $4 = ($sfb_0 | 0) < ($2 | 0);
    if ($4) {
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    var $5 = $cod_info + 4868 | 0;
    var $6 = $cod_info + 4860 | 0;
    var $7 = $cod_info + 4764 | 0;
    var $8 = $cod_info + 4836 | 0;
    var $9 = $cod_info + 4764 | 0;
    var $window_0110 = 0;
    label = 6;
    break;
   case 5:
    var $11 = $cod_info + 4608 + ($sfb_0 << 2) | 0;
    var $12 = HEAP32[$11 >> 2];
    var $13 = ($12 | 0) > 15;
    var $14 = $sfb_0 + 1 | 0;
    if ($13) {
      var $_0 = 1;
      label = 32;
      break;
    } else {
      var $sfb_0 = $14;
      label = 3;
      break;
    }
   case 6:
    var $window_0110;
    var $16 = HEAP32[$1 >> 2];
    var $17 = $16 + $window_0110 | 0;
    var $18 = HEAP32[$5 >> 2];
    var $19 = ($17 | 0) < ($18 | 0);
    if ($19) {
      label = 7;
      break;
    } else {
      var $s1_0_lcssa = 0;
      var $sfb_1_lcssa = $17;
      label = 9;
      break;
    }
   case 7:
    var $20 = HEAP32[$5 >> 2];
    var $s1_086 = 0;
    var $sfb_187 = $17;
    label = 8;
    break;
   case 8:
    var $sfb_187;
    var $s1_086;
    var $22 = $cod_info + 4608 + ($sfb_187 << 2) | 0;
    var $23 = HEAP32[$22 >> 2];
    var $24 = ($s1_086 | 0) < ($23 | 0);
    var $_s1_0 = $24 ? $23 : $s1_086;
    var $25 = $sfb_187 + 3 | 0;
    var $26 = ($25 | 0) < ($20 | 0);
    if ($26) {
      var $s1_086 = $_s1_0;
      var $sfb_187 = $25;
      label = 8;
      break;
    } else {
      var $s1_0_lcssa = $_s1_0;
      var $sfb_1_lcssa = $25;
      label = 9;
      break;
    }
   case 9:
    var $sfb_1_lcssa;
    var $s1_0_lcssa;
    var $27 = HEAP32[$6 >> 2];
    var $28 = ($sfb_1_lcssa | 0) < ($27 | 0);
    if ($28) {
      label = 10;
      break;
    } else {
      var $s2_0_lcssa = 1;
      label = 13;
      break;
    }
   case 10:
    var $29 = HEAP32[$6 >> 2];
    var $s2_089 = 0;
    var $sfb_290 = $sfb_1_lcssa;
    label = 11;
    break;
   case 11:
    var $sfb_290;
    var $s2_089;
    var $31 = $cod_info + 4608 + ($sfb_290 << 2) | 0;
    var $32 = HEAP32[$31 >> 2];
    var $33 = ($s2_089 | 0) < ($32 | 0);
    var $_s2_0 = $33 ? $32 : $s2_089;
    var $34 = $sfb_290 + 3 | 0;
    var $35 = ($34 | 0) < ($29 | 0);
    if ($35) {
      var $s2_089 = $_s2_0;
      var $sfb_290 = $34;
      label = 11;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    var $phitmp = ($_s2_0 | 0) < 8;
    var $s2_0_lcssa = $phitmp;
    label = 13;
    break;
   case 13:
    var $s2_0_lcssa;
    var $37 = ($s1_0_lcssa | 0) < 16;
    var $or_cond = $37 & $s2_0_lcssa;
    if ($or_cond) {
      label = 31;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    var $39 = $cod_info + 4808 + ($window_0110 << 2) | 0;
    var $40 = HEAP32[$39 >> 2];
    var $41 = ($40 | 0) > 6;
    if ($41) {
      var $_0 = 1;
      label = 32;
      break;
    } else {
      label = 15;
      break;
    }
   case 15:
    var $43 = $40 + 1 | 0;
    HEAP32[$39 >> 2] = $43;
    var $44 = HEAP32[$1 >> 2];
    var $45 = $gfc + 21360 + ($44 << 2) | 0;
    var $46 = HEAP32[$45 >> 2];
    var $47 = $44 + $window_0110 | 0;
    var $48 = HEAP32[$6 >> 2];
    var $49 = ($47 | 0) < ($48 | 0);
    if ($49) {
      label = 16;
      break;
    } else {
      var $j_0_lcssa = $46;
      var $sfb_3_lcssa = $47;
      label = 26;
      break;
    }
   case 16:
    var $50 = $window_0110 + 1 | 0;
    var $51 = 2 - $window_0110 | 0;
    var $j_098 = $46;
    var $sfb_399 = $47;
    label = 17;
    break;
   case 17:
    var $sfb_399;
    var $j_098;
    var $53 = $cod_info + 4872 + ($sfb_399 << 2) | 0;
    var $54 = HEAP32[$53 >> 2];
    var $55 = $cod_info + 4608 + ($sfb_399 << 2) | 0;
    var $56 = HEAP32[$55 >> 2];
    var $57 = HEAP32[$8 >> 2];
    var $58 = 4 >>> ($57 >>> 0);
    var $59 = $56 - $58 | 0;
    var $60 = ($59 | 0) > -1;
    if ($60) {
      label = 18;
      break;
    } else {
      label = 19;
      break;
    }
   case 18:
    HEAP32[$55 >> 2] = $59;
    var $62 = $54 * 3 & -1;
    var $63 = $62 + $j_098 | 0;
    var $j_1 = $63;
    label = 25;
    break;
   case 19:
    HEAP32[$55 >> 2] = 0;
    var $65 = HEAP32[$8 >> 2];
    var $66 = $65 + 1 | 0;
    var $67 = $59 << $66;
    var $68 = $67 + 210 | 0;
    var $69 = 5326164 + ($68 << 2) | 0;
    var $70 = HEAPF32[$69 >> 2];
    var $71 = $54 * $50 & -1;
    var $72 = $71 + $j_098 | 0;
    var $73 = ($54 | 0) > 0;
    if ($73) {
      label = 20;
      break;
    } else {
      label = 24;
      break;
    }
   case 20:
    var $74 = -$54 | 0;
    var $l_094 = $74;
    label = 21;
    break;
   case 21:
    var $l_094;
    var $76 = $l_094 + $72 | 0;
    var $77 = $xrpow + ($76 << 2) | 0;
    var $78 = HEAPF32[$77 >> 2];
    var $79 = $70 * $78;
    HEAPF32[$77 >> 2] = $79;
    var $80 = HEAPF32[$9 >> 2];
    var $81 = $79 > $80;
    if ($81) {
      label = 22;
      break;
    } else {
      label = 23;
      break;
    }
   case 22:
    HEAPF32[$9 >> 2] = $79;
    label = 23;
    break;
   case 23:
    var $84 = $l_094 + 1 | 0;
    var $85 = ($84 | 0) < 0;
    if ($85) {
      var $l_094 = $84;
      label = 21;
      break;
    } else {
      label = 24;
      break;
    }
   case 24:
    var $86 = $54 * $51 & -1;
    var $87 = $72 + $86 | 0;
    var $j_1 = $87;
    label = 25;
    break;
   case 25:
    var $j_1;
    var $89 = $sfb_399 + 3 | 0;
    var $90 = HEAP32[$6 >> 2];
    var $91 = ($89 | 0) < ($90 | 0);
    if ($91) {
      var $j_098 = $j_1;
      var $sfb_399 = $89;
      label = 17;
      break;
    } else {
      var $j_0_lcssa = $j_1;
      var $sfb_3_lcssa = $89;
      label = 26;
      break;
    }
   case 26:
    var $sfb_3_lcssa;
    var $j_0_lcssa;
    var $92 = HEAPF32[5326972 >> 2];
    var $93 = $cod_info + 4872 + ($sfb_3_lcssa << 2) | 0;
    var $94 = HEAP32[$93 >> 2];
    var $95 = $window_0110 + 1 | 0;
    var $96 = $94 * $95 & -1;
    var $97 = $96 + $j_0_lcssa | 0;
    var $98 = ($94 | 0) > 0;
    if ($98) {
      label = 27;
      break;
    } else {
      label = 31;
      break;
    }
   case 27:
    var $99 = -$94 | 0;
    var $l_1106 = $99;
    label = 28;
    break;
   case 28:
    var $l_1106;
    var $101 = $97 + $l_1106 | 0;
    var $102 = $xrpow + ($101 << 2) | 0;
    var $103 = HEAPF32[$102 >> 2];
    var $104 = $92 * $103;
    HEAPF32[$102 >> 2] = $104;
    var $105 = HEAPF32[$7 >> 2];
    var $106 = $104 > $105;
    if ($106) {
      label = 29;
      break;
    } else {
      label = 30;
      break;
    }
   case 29:
    HEAPF32[$7 >> 2] = $104;
    label = 30;
    break;
   case 30:
    var $109 = $l_1106 + 1 | 0;
    var $110 = ($109 | 0) < 0;
    if ($110) {
      var $l_1106 = $109;
      label = 28;
      break;
    } else {
      label = 31;
      break;
    }
   case 31:
    var $111 = $window_0110 + 1 | 0;
    var $112 = ($111 | 0) < 3;
    if ($112) {
      var $window_0110 = $111;
      label = 6;
      break;
    } else {
      var $_0 = 0;
      label = 32;
      break;
    }
   case 32:
    var $_0;
    return $_0;
  }
}
_inc_subblock_gain["X"] = 1;
function _psfb21_analogsilence($gfc, $cod_info) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 85792 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $cod_info + 4788 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) == 2;
    if ($5) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    var $6 = $2 + 8 | 0;
    var $7 = $2 + 20 | 0;
    var $8 = $gfc + 84848 | 0;
    var $gsfb_064 = 5;
    label = 5;
    break;
   case 4:
    var $9 = $gfc + 21500 | 0;
    var $10 = $gfc + 21504 | 0;
    var $11 = $gfc + 21536 | 0;
    var $12 = $2 + 8 | 0;
    var $13 = $2 + 20 | 0;
    var $14 = $gfc + 84900 | 0;
    var $block_053 = 0;
    label = 11;
    break;
   case 5:
    var $gsfb_064;
    var $16 = $gfc + 21508 + ($gsfb_064 << 2) | 0;
    var $17 = HEAP32[$16 >> 2];
    var $18 = $gsfb_064 + 1 | 0;
    var $19 = $gfc + 21508 + ($18 << 2) | 0;
    var $20 = HEAP32[$19 >> 2];
    var $21 = HEAPF32[$6 >> 2];
    var $22 = $2 + 164 + ($gsfb_064 << 2) | 0;
    var $23 = HEAPF32[$22 >> 2];
    var $24 = HEAPF32[$7 >> 2];
    var $25 = _athAdjust($21, $23, $24, 0);
    var $26 = HEAPF32[$8 >> 2];
    var $27 = $26 > 9.999999960041972e-13;
    if ($27) {
      label = 6;
      break;
    } else {
      var $ath21_0 = $25;
      label = 7;
      break;
    }
   case 6:
    var $29 = $25 * $26;
    var $ath21_0 = $29;
    label = 7;
    break;
   case 7:
    var $ath21_0;
    var $j_054 = $20 - 1 | 0;
    var $31 = ($j_054 | 0) < ($17 | 0);
    if ($31) {
      label = 10;
      break;
    } else {
      var $j_055 = $j_054;
      label = 8;
      break;
    }
   case 8:
    var $j_055;
    var $32 = $cod_info + ($j_055 << 2) | 0;
    var $33 = HEAPF32[$32 >> 2];
    var $fabsf = Math.abs($33);
    var $34 = $fabsf < $ath21_0;
    if ($34) {
      label = 9;
      break;
    } else {
      label = 19;
      break;
    }
   case 9:
    HEAPF32[$32 >> 2] = 0;
    var $j_0 = $j_055 - 1 | 0;
    var $36 = ($j_0 | 0) < ($17 | 0);
    if ($36) {
      label = 10;
      break;
    } else {
      var $j_055 = $j_0;
      label = 8;
      break;
    }
   case 10:
    var $37 = $gsfb_064 - 1 | 0;
    var $38 = ($gsfb_064 | 0) > 0;
    if ($38) {
      var $gsfb_064 = $37;
      label = 5;
      break;
    } else {
      label = 19;
      break;
    }
   case 11:
    var $block_053;
    var $gsfb1_050 = 5;
    label = 12;
    break;
   case 12:
    var $gsfb1_050;
    var $40 = HEAP32[$9 >> 2];
    var $41 = $40 * 3 & -1;
    var $42 = HEAP32[$10 >> 2];
    var $43 = $42 - $40 | 0;
    var $44 = $43 * $block_053 & -1;
    var $45 = $44 + $41 | 0;
    var $46 = $gfc + 21536 + ($gsfb1_050 << 2) | 0;
    var $47 = HEAP32[$46 >> 2];
    var $48 = HEAP32[$11 >> 2];
    var $49 = $47 - $48 | 0;
    var $50 = $45 + $49 | 0;
    var $51 = $gsfb1_050 + 1 | 0;
    var $52 = $gfc + 21536 + ($51 << 2) | 0;
    var $53 = HEAP32[$52 >> 2];
    var $54 = $53 - $47 | 0;
    var $55 = $54 + $50 | 0;
    var $56 = HEAPF32[$12 >> 2];
    var $57 = $2 + 188 + ($gsfb1_050 << 2) | 0;
    var $58 = HEAPF32[$57 >> 2];
    var $59 = HEAPF32[$13 >> 2];
    var $60 = _athAdjust($56, $58, $59, 0);
    var $61 = HEAPF32[$14 >> 2];
    var $62 = $61 > 9.999999960041972e-13;
    if ($62) {
      label = 13;
      break;
    } else {
      var $ath12_0 = $60;
      label = 14;
      break;
    }
   case 13:
    var $64 = $60 * $61;
    var $ath12_0 = $64;
    label = 14;
    break;
   case 14:
    var $ath12_0;
    var $j5_047 = $55 - 1 | 0;
    var $66 = ($j5_047 | 0) < ($50 | 0);
    if ($66) {
      label = 17;
      break;
    } else {
      var $j5_048 = $j5_047;
      label = 15;
      break;
    }
   case 15:
    var $j5_048;
    var $67 = $cod_info + ($j5_048 << 2) | 0;
    var $68 = HEAPF32[$67 >> 2];
    var $fabsf46 = Math.abs($68);
    var $69 = $fabsf46 < $ath12_0;
    if ($69) {
      label = 16;
      break;
    } else {
      label = 18;
      break;
    }
   case 16:
    HEAPF32[$67 >> 2] = 0;
    var $j5_0 = $j5_048 - 1 | 0;
    var $71 = ($j5_0 | 0) < ($50 | 0);
    if ($71) {
      label = 17;
      break;
    } else {
      var $j5_048 = $j5_0;
      label = 15;
      break;
    }
   case 17:
    var $72 = $gsfb1_050 - 1 | 0;
    var $73 = ($gsfb1_050 | 0) > 0;
    if ($73) {
      var $gsfb1_050 = $72;
      label = 12;
      break;
    } else {
      label = 18;
      break;
    }
   case 18:
    var $74 = $block_053 + 1 | 0;
    var $exitcond = ($74 | 0) == 3;
    if ($exitcond) {
      label = 19;
      break;
    } else {
      var $block_053 = $74;
      label = 11;
      break;
    }
   case 19:
    return;
  }
}
_psfb21_analogsilence["X"] = 1;
function _get_framebits($gfc, $frameBits) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 4 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $bitsPerFrame = __stackBase__;
    var $1 = $gfc + 84740 | 0;
    HEAP32[$1 >> 2] = 1;
    var $2 = _getframebits($gfc);
    HEAP32[$bitsPerFrame >> 2] = $2;
    var $3 = $gfc + 116 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) < 1;
    if ($5) {
      label = 4;
      break;
    } else {
      var $i_012 = 1;
      label = 3;
      break;
    }
   case 3:
    var $i_012;
    HEAP32[$1 >> 2] = $i_012;
    var $6 = _ResvFrameBegin($gfc, $bitsPerFrame);
    var $7 = $frameBits + ($i_012 << 2) | 0;
    HEAP32[$7 >> 2] = $6;
    var $8 = $i_012 + 1 | 0;
    var $9 = HEAP32[$3 >> 2];
    var $10 = ($8 | 0) > ($9 | 0);
    if ($10) {
      label = 4;
      break;
    } else {
      var $i_012 = $8;
      label = 3;
      break;
    }
   case 4:
    STACKTOP = __stackBase__;
    return;
  }
}
function _iteration_init($gfc) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 8 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = ($2 | 0) == 0;
    if ($3) {
      label = 3;
      break;
    } else {
      label = 14;
      break;
    }
   case 3:
    HEAP32[$1 >> 2] = 1;
    var $5 = $gfc + 21312 | 0;
    HEAP32[$5 >> 2] = 0;
    _compute_ath($gfc);
    HEAPF32[5257104 >> 2] = 0;
    var $i_0113 = 1;
    label = 4;
    break;
   case 4:
    var $i_0113;
    var $7 = $i_0113 | 0;
    var $8 = $7;
    var $9 = Math.pow($8, 1.3333333333333333);
    var $10 = $9;
    var $11 = 5257104 + ($i_0113 << 2) | 0;
    HEAPF32[$11 >> 2] = $10;
    var $12 = $i_0113 + 1 | 0;
    var $exitcond124 = ($12 | 0) == 8208;
    if ($exitcond124) {
      label = 5;
      break;
    } else {
      var $i_0113 = $12;
      label = 4;
      break;
    }
   case 5:
    HEAPF32[5349760 >> 2] = 0;
    var $i_1112 = 1;
    label = 6;
    break;
   case 6:
    var $i_1112;
    var $15 = $i_1112 | 0;
    var $16 = $15 - .5;
    var $17 = $i_1112 - 1 | 0;
    var $18 = 5257104 + ($17 << 2) | 0;
    var $19 = HEAPF32[$18 >> 2];
    var $20 = 5257104 + ($i_1112 << 2) | 0;
    var $21 = HEAPF32[$20 >> 2];
    var $22 = $19 + $21;
    var $23 = $22;
    var $24 = $23 * .5;
    var $25 = Math.pow($24, .75);
    var $26 = $16 - $25;
    var $27 = $26;
    var $28 = 5349760 + ($i_1112 << 2) | 0;
    HEAPF32[$28 >> 2] = $27;
    var $29 = $i_1112 + 1 | 0;
    var $exitcond123 = ($29 | 0) == 8208;
    if ($exitcond123) {
      var $i_2111 = 0;
      label = 7;
      break;
    } else {
      var $i_1112 = $29;
      label = 6;
      break;
    }
   case 7:
    var $i_2111;
    var $30 = $i_2111 - 210 | 0;
    var $31 = $30 | 0;
    var $32 = $31 * -.1875;
    var $exp2 = _exp2($32);
    var $33 = $exp2;
    var $34 = 5326164 + ($i_2111 << 2) | 0;
    HEAPF32[$34 >> 2] = $33;
    var $35 = $i_2111 + 1 | 0;
    var $exitcond122 = ($35 | 0) == 257;
    if ($exitcond122) {
      var $i_3109 = 0;
      label = 8;
      break;
    } else {
      var $i_2111 = $35;
      label = 7;
      break;
    }
   case 8:
    var $i_3109;
    var $36 = $i_3109 - 326 | 0;
    var $37 = $36 | 0;
    var $38 = $37 * .25;
    var $exp284 = _exp2($38);
    var $39 = $exp284;
    var $40 = 5289936 + ($i_3109 << 2) | 0;
    HEAPF32[$40 >> 2] = $39;
    var $41 = $i_3109 + 1 | 0;
    var $exitcond121 = ($41 | 0) == 374;
    if ($exitcond121) {
      label = 9;
      break;
    } else {
      var $i_3109 = $41;
      label = 8;
      break;
    }
   case 9:
    _huffman_init($gfc);
    _init_xrpow_core_init($gfc);
    var $42 = $gfc + 232 | 0;
    var $43 = HEAPF32[$42 >> 2];
    var $44 = $43 - .5;
    var $45 = $44 * .10000000149011612;
    var $46 = Math.pow(10, $45);
    var $47 = $gfc + 84764 | 0;
    HEAPF32[$47 >> 2] = $46;
    var $48 = $gfc + 84768 | 0;
    HEAPF32[$48 >> 2] = $46;
    var $49 = $gfc + 84772 | 0;
    HEAPF32[$49 >> 2] = $46;
    var $50 = $gfc + 84776 | 0;
    HEAPF32[$50 >> 2] = $46;
    var $51 = $gfc + 84780 | 0;
    HEAPF32[$51 >> 2] = $46;
    var $52 = $gfc + 84784 | 0;
    HEAPF32[$52 >> 2] = $46;
    var $53 = $gfc + 84788 | 0;
    HEAPF32[$53 >> 2] = $46;
    var $54 = $gfc + 228 | 0;
    var $55 = HEAPF32[$54 >> 2];
    var $56 = $55 - .25;
    var $57 = $56 * .10000000149011612;
    var $58 = Math.pow(10, $57);
    var $59 = $gfc + 84792 | 0;
    HEAPF32[$59 >> 2] = $58;
    var $60 = $gfc + 84796 | 0;
    HEAPF32[$60 >> 2] = $58;
    var $61 = $gfc + 84800 | 0;
    HEAPF32[$61 >> 2] = $58;
    var $62 = $gfc + 84804 | 0;
    HEAPF32[$62 >> 2] = $58;
    var $63 = $gfc + 84808 | 0;
    HEAPF32[$63 >> 2] = $58;
    var $64 = $gfc + 84812 | 0;
    HEAPF32[$64 >> 2] = $58;
    var $65 = $gfc + 84816 | 0;
    HEAPF32[$65 >> 2] = $58;
    var $66 = $gfc + 236 | 0;
    var $67 = HEAPF32[$66 >> 2];
    var $68 = $67 - .02500000037252903;
    var $69 = $68 * .10000000149011612;
    var $70 = Math.pow(10, $69);
    var $i_698 = 14;
    label = 10;
    break;
   case 10:
    var $i_698;
    var $72 = $gfc + 84764 + ($i_698 << 2) | 0;
    HEAPF32[$72 >> 2] = $70;
    var $73 = $i_698 + 1 | 0;
    var $exitcond118 = ($73 | 0) == 21;
    if ($exitcond118) {
      label = 11;
      break;
    } else {
      var $i_698 = $73;
      label = 10;
      break;
    }
   case 11:
    var $74 = $gfc + 240 | 0;
    var $75 = HEAPF32[$74 >> 2];
    var $76 = $75 + .5;
    var $77 = $76 * .10000000149011612;
    var $78 = Math.pow(10, $77);
    var $79 = $gfc + 84848 | 0;
    HEAPF32[$79 >> 2] = $78;
    var $80 = HEAPF32[$42 >> 2];
    var $81 = $80 - 2;
    var $82 = $81 * .10000000149011612;
    var $83 = Math.pow(10, $82);
    var $84 = $gfc + 84852 | 0;
    HEAPF32[$84 >> 2] = $83;
    var $85 = $gfc + 84856 | 0;
    HEAPF32[$85 >> 2] = $83;
    var $86 = $gfc + 84860 | 0;
    HEAPF32[$86 >> 2] = $83;
    var $87 = HEAPF32[$54 >> 2];
    var $88 = $87 - 1;
    var $89 = $88 * .10000000149011612;
    var $90 = Math.pow(10, $89);
    var $91 = $gfc + 84864 | 0;
    HEAPF32[$91 >> 2] = $90;
    var $92 = $gfc + 84868 | 0;
    HEAPF32[$92 >> 2] = $90;
    var $93 = $gfc + 84872 | 0;
    HEAPF32[$93 >> 2] = $90;
    var $94 = $gfc + 84876 | 0;
    HEAPF32[$94 >> 2] = $90;
    var $95 = HEAPF32[$66 >> 2];
    var $96 = $95 - .05000000074505806;
    var $97 = $96 * .10000000149011612;
    var $98 = Math.pow(10, $97);
    var $i_1086 = 7;
    label = 12;
    break;
   case 12:
    var $i_1086;
    var $100 = $gfc + 84852 + ($i_1086 << 2) | 0;
    HEAPF32[$100 >> 2] = $98;
    var $101 = $i_1086 + 1 | 0;
    var $exitcond114 = ($101 | 0) == 12;
    if ($exitcond114) {
      label = 13;
      break;
    } else {
      var $i_1086 = $101;
      label = 12;
      break;
    }
   case 13:
    var $102 = HEAPF32[$74 >> 2];
    var $103 = $102 + .5;
    var $104 = $103 * .10000000149011612;
    var $105 = Math.pow(10, $104);
    var $106 = $gfc + 84900 | 0;
    HEAPF32[$106 >> 2] = $105;
    label = 14;
    break;
   case 14:
    return;
  }
}
_iteration_init["X"] = 1;
function _compute_ath($gfc) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 16 | 0;
    var $2 = $gfc + 85792 | 0;
    var $3 = HEAP32[$2 >> 2];
    var $4 = $gfc + 64 | 0;
    var $5 = HEAP32[$4 >> 2];
    var $6 = $5 | 0;
    var $sfb_0145 = 0;
    label = 4;
    break;
   case 3:
    var $exitcond152 = ($10 | 0) == 22;
    if ($exitcond152) {
      var $sfb_1140 = 0;
      label = 7;
      break;
    } else {
      var $sfb_0145 = $10;
      label = 4;
      break;
    }
   case 4:
    var $sfb_0145;
    var $8 = $gfc + 21360 + ($sfb_0145 << 2) | 0;
    var $9 = HEAP32[$8 >> 2];
    var $10 = $sfb_0145 + 1 | 0;
    var $11 = $gfc + 21360 + ($10 << 2) | 0;
    var $12 = HEAP32[$11 >> 2];
    var $13 = $3 + 24 + ($sfb_0145 << 2) | 0;
    HEAPF32[$13 >> 2] = 9.999999933815813e+36;
    var $14 = ($9 | 0) < ($12 | 0);
    if ($14) {
      var $i_0142 = $9;
      label = 5;
      break;
    } else {
      label = 3;
      break;
    }
   case 5:
    var $i_0142;
    var $15 = $i_0142 | 0;
    var $16 = $6 * $15;
    var $17 = $16 / 1152;
    var $18 = _ATHmdct($1, $17);
    var $19 = HEAPF32[$13 >> 2];
    var $20 = $19 < $18;
    var $_ = $20 ? $19 : $18;
    HEAPF32[$13 >> 2] = $_;
    var $21 = $i_0142 + 1 | 0;
    var $exitcond151 = ($21 | 0) == ($12 | 0);
    if ($exitcond151) {
      label = 3;
      break;
    } else {
      var $i_0142 = $21;
      label = 5;
      break;
    }
   case 6:
    var $exitcond150 = ($24 | 0) == 6;
    if ($exitcond150) {
      var $sfb_2134 = 0;
      label = 10;
      break;
    } else {
      var $sfb_1140 = $24;
      label = 7;
      break;
    }
   case 7:
    var $sfb_1140;
    var $22 = $gfc + 21508 + ($sfb_1140 << 2) | 0;
    var $23 = HEAP32[$22 >> 2];
    var $24 = $sfb_1140 + 1 | 0;
    var $25 = $gfc + 21508 + ($24 << 2) | 0;
    var $26 = HEAP32[$25 >> 2];
    var $27 = $3 + 164 + ($sfb_1140 << 2) | 0;
    HEAPF32[$27 >> 2] = 9.999999933815813e+36;
    var $28 = ($23 | 0) < ($26 | 0);
    if ($28) {
      var $i_1136 = $23;
      label = 8;
      break;
    } else {
      label = 6;
      break;
    }
   case 8:
    var $i_1136;
    var $29 = $i_1136 | 0;
    var $30 = $6 * $29;
    var $31 = $30 / 1152;
    var $32 = _ATHmdct($1, $31);
    var $33 = HEAPF32[$27 >> 2];
    var $34 = $33 < $32;
    var $_116 = $34 ? $33 : $32;
    HEAPF32[$27 >> 2] = $_116;
    var $35 = $i_1136 + 1 | 0;
    var $exitcond149 = ($35 | 0) == ($26 | 0);
    if ($exitcond149) {
      label = 6;
      break;
    } else {
      var $i_1136 = $35;
      label = 8;
      break;
    }
   case 9:
    var $36 = $gfc + 21504 | 0;
    var $37 = $gfc + 21500 | 0;
    var $sfb_3128 = 0;
    label = 13;
    break;
   case 10:
    var $sfb_2134;
    var $38 = $gfc + 21452 + ($sfb_2134 << 2) | 0;
    var $39 = HEAP32[$38 >> 2];
    var $40 = $sfb_2134 + 1 | 0;
    var $41 = $gfc + 21452 + ($40 << 2) | 0;
    var $42 = HEAP32[$41 >> 2];
    var $43 = $3 + 112 + ($sfb_2134 << 2) | 0;
    HEAPF32[$43 >> 2] = 9.999999933815813e+36;
    var $44 = ($39 | 0) < ($42 | 0);
    if ($44) {
      var $i_2129 = $39;
      label = 11;
      break;
    } else {
      label = 12;
      break;
    }
   case 11:
    var $i_2129;
    var $45 = $i_2129 | 0;
    var $46 = $6 * $45;
    var $47 = $46 / 384;
    var $48 = _ATHmdct($1, $47);
    var $49 = HEAPF32[$43 >> 2];
    var $50 = $49 < $48;
    var $_117 = $50 ? $49 : $48;
    HEAPF32[$43 >> 2] = $_117;
    var $51 = $i_2129 + 1 | 0;
    var $exitcond147 = ($51 | 0) == ($42 | 0);
    if ($exitcond147) {
      label = 12;
      break;
    } else {
      var $i_2129 = $51;
      label = 11;
      break;
    }
   case 12:
    var $52 = HEAP32[$41 >> 2];
    var $53 = HEAP32[$38 >> 2];
    var $54 = $52 - $53 | 0;
    var $55 = $54 | 0;
    var $56 = HEAPF32[$43 >> 2];
    var $57 = $56 * $55;
    HEAPF32[$43 >> 2] = $57;
    var $exitcond148 = ($40 | 0) == 13;
    if ($exitcond148) {
      label = 9;
      break;
    } else {
      var $sfb_2134 = $40;
      label = 10;
      break;
    }
   case 13:
    var $sfb_3128;
    var $59 = $gfc + 21536 + ($sfb_3128 << 2) | 0;
    var $60 = HEAP32[$59 >> 2];
    var $61 = $sfb_3128 + 1 | 0;
    var $62 = $gfc + 21536 + ($61 << 2) | 0;
    var $63 = HEAP32[$62 >> 2];
    var $64 = $3 + 188 + ($sfb_3128 << 2) | 0;
    HEAPF32[$64 >> 2] = 9.999999933815813e+36;
    var $65 = ($60 | 0) < ($63 | 0);
    if ($65) {
      var $i_3126 = $60;
      label = 14;
      break;
    } else {
      label = 15;
      break;
    }
   case 14:
    var $i_3126;
    var $66 = $i_3126 | 0;
    var $67 = $6 * $66;
    var $68 = $67 / 384;
    var $69 = _ATHmdct($1, $68);
    var $70 = HEAPF32[$64 >> 2];
    var $71 = $70 < $69;
    var $_118 = $71 ? $70 : $69;
    HEAPF32[$64 >> 2] = $_118;
    var $72 = $i_3126 + 1 | 0;
    var $exitcond = ($72 | 0) == ($63 | 0);
    if ($exitcond) {
      label = 15;
      break;
    } else {
      var $i_3126 = $72;
      label = 14;
      break;
    }
   case 15:
    var $73 = HEAP32[$36 >> 2];
    var $74 = HEAP32[$37 >> 2];
    var $75 = $73 - $74 | 0;
    var $76 = $75 | 0;
    var $77 = HEAPF32[$64 >> 2];
    var $78 = $77 * $76;
    HEAPF32[$64 >> 2] = $78;
    var $exitcond146 = ($61 | 0) == 6;
    if ($exitcond146) {
      label = 16;
      break;
    } else {
      var $sfb_3128 = $61;
      label = 13;
      break;
    }
   case 16:
    var $80 = $gfc + 220 | 0;
    var $81 = HEAP32[$80 >> 2];
    var $82 = ($81 | 0) == 0;
    if ($82) {
      label = 18;
      break;
    } else {
      label = 17;
      break;
    }
   case 17:
    var $83 = $3 + 24 | 0;
    HEAPF32[$83 >> 2] = 9.999999682655225e-21;
    var $84 = $3 + 28 | 0;
    HEAPF32[$84 >> 2] = 9.999999682655225e-21;
    var $85 = $3 + 32 | 0;
    HEAPF32[$85 >> 2] = 9.999999682655225e-21;
    var $86 = $3 + 36 | 0;
    HEAPF32[$86 >> 2] = 9.999999682655225e-21;
    var $87 = $3 + 40 | 0;
    HEAPF32[$87 >> 2] = 9.999999682655225e-21;
    var $88 = $3 + 44 | 0;
    HEAPF32[$88 >> 2] = 9.999999682655225e-21;
    var $89 = $3 + 48 | 0;
    HEAPF32[$89 >> 2] = 9.999999682655225e-21;
    var $90 = $3 + 52 | 0;
    HEAPF32[$90 >> 2] = 9.999999682655225e-21;
    var $91 = $3 + 56 | 0;
    HEAPF32[$91 >> 2] = 9.999999682655225e-21;
    var $92 = $3 + 60 | 0;
    HEAPF32[$92 >> 2] = 9.999999682655225e-21;
    var $93 = $3 + 64 | 0;
    HEAPF32[$93 >> 2] = 9.999999682655225e-21;
    var $94 = $3 + 68 | 0;
    HEAPF32[$94 >> 2] = 9.999999682655225e-21;
    var $95 = $3 + 72 | 0;
    HEAPF32[$95 >> 2] = 9.999999682655225e-21;
    var $96 = $3 + 76 | 0;
    HEAPF32[$96 >> 2] = 9.999999682655225e-21;
    var $97 = $3 + 80 | 0;
    HEAPF32[$97 >> 2] = 9.999999682655225e-21;
    var $98 = $3 + 84 | 0;
    HEAPF32[$98 >> 2] = 9.999999682655225e-21;
    var $99 = $3 + 88 | 0;
    HEAPF32[$99 >> 2] = 9.999999682655225e-21;
    var $100 = $3 + 92 | 0;
    HEAPF32[$100 >> 2] = 9.999999682655225e-21;
    var $101 = $3 + 96 | 0;
    HEAPF32[$101 >> 2] = 9.999999682655225e-21;
    var $102 = $3 + 100 | 0;
    HEAPF32[$102 >> 2] = 9.999999682655225e-21;
    var $103 = $3 + 104 | 0;
    HEAPF32[$103 >> 2] = 9.999999682655225e-21;
    var $104 = $3 + 108 | 0;
    HEAPF32[$104 >> 2] = 9.999999682655225e-21;
    var $105 = $3 + 164 | 0;
    HEAPF32[$105 >> 2] = 9.999999682655225e-21;
    var $106 = $3 + 168 | 0;
    HEAPF32[$106 >> 2] = 9.999999682655225e-21;
    var $107 = $3 + 172 | 0;
    HEAPF32[$107 >> 2] = 9.999999682655225e-21;
    var $108 = $3 + 176 | 0;
    HEAPF32[$108 >> 2] = 9.999999682655225e-21;
    var $109 = $3 + 180 | 0;
    HEAPF32[$109 >> 2] = 9.999999682655225e-21;
    var $110 = $3 + 184 | 0;
    HEAPF32[$110 >> 2] = 9.999999682655225e-21;
    var $111 = $3 + 112 | 0;
    HEAPF32[$111 >> 2] = 9.999999682655225e-21;
    var $112 = $3 + 116 | 0;
    HEAPF32[$112 >> 2] = 9.999999682655225e-21;
    var $113 = $3 + 120 | 0;
    HEAPF32[$113 >> 2] = 9.999999682655225e-21;
    var $114 = $3 + 124 | 0;
    HEAPF32[$114 >> 2] = 9.999999682655225e-21;
    var $115 = $3 + 128 | 0;
    HEAPF32[$115 >> 2] = 9.999999682655225e-21;
    var $116 = $3 + 132 | 0;
    HEAPF32[$116 >> 2] = 9.999999682655225e-21;
    var $117 = $3 + 136 | 0;
    HEAPF32[$117 >> 2] = 9.999999682655225e-21;
    var $118 = $3 + 140 | 0;
    HEAPF32[$118 >> 2] = 9.999999682655225e-21;
    var $119 = $3 + 144 | 0;
    HEAPF32[$119 >> 2] = 9.999999682655225e-21;
    var $120 = $3 + 148 | 0;
    HEAPF32[$120 >> 2] = 9.999999682655225e-21;
    var $121 = $3 + 152 | 0;
    HEAPF32[$121 >> 2] = 9.999999682655225e-21;
    var $122 = $3 + 156 | 0;
    HEAPF32[$122 >> 2] = 9.999999682655225e-21;
    var $123 = $3 + 160 | 0;
    HEAPF32[$123 >> 2] = 9.999999682655225e-21;
    var $124 = $3 + 188 | 0;
    HEAPF32[$124 >> 2] = 9.999999682655225e-21;
    var $125 = $3 + 192 | 0;
    HEAPF32[$125 >> 2] = 9.999999682655225e-21;
    var $126 = $3 + 196 | 0;
    HEAPF32[$126 >> 2] = 9.999999682655225e-21;
    var $127 = $3 + 200 | 0;
    HEAPF32[$127 >> 2] = 9.999999682655225e-21;
    var $128 = $3 + 204 | 0;
    HEAPF32[$128 >> 2] = 9.999999682655225e-21;
    var $129 = $3 + 208 | 0;
    HEAPF32[$129 >> 2] = 9.999999682655225e-21;
    label = 18;
    break;
   case 18:
    var $131 = _ATHmdct($1, -1);
    var $132 = $131;
    var $133 = _log10($132);
    var $134 = $133 * 10;
    var $135 = $134;
    var $136 = HEAP32[$2 >> 2];
    var $137 = $136 + 20 | 0;
    HEAPF32[$137 >> 2] = $135;
    return;
  }
}
_compute_ath["X"] = 1;
function _reduce_side($targ_bits, $ms_ener_ratio, $mean_bits, $max_bits) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $ms_ener_ratio;
    var $2 = .5 - $1;
    var $3 = $2 * .33;
    var $4 = $3 * 2;
    var $5 = $4;
    var $6 = $5 < 0;
    var $fac_0 = $6 ? 0 : $5;
    var $7 = $fac_0 > .5;
    var $8 = $fac_0;
    var $_op = $8 * .5;
    var $9 = $7 ? .25 : $_op;
    var $10 = HEAP32[$targ_bits >> 2];
    var $11 = $targ_bits + 4 | 0;
    var $12 = HEAP32[$11 >> 2];
    var $13 = $12 + $10 | 0;
    var $14 = $13 | 0;
    var $15 = $9 * $14;
    var $16 = $15 & -1;
    var $17 = 4095 - $10 | 0;
    var $18 = ($16 | 0) > ($17 | 0);
    var $_ = $18 ? $17 : $16;
    var $19 = ($_ | 0) < 0;
    var $move_bits_1 = $19 ? 0 : $_;
    var $20 = ($12 | 0) > 124;
    if ($20) {
      label = 3;
      break;
    } else {
      label = 8;
      break;
    }
   case 3:
    var $22 = $12 - $move_bits_1 | 0;
    var $23 = ($22 | 0) > 125;
    if ($23) {
      label = 4;
      break;
    } else {
      label = 7;
      break;
    }
   case 4:
    var $25 = ($10 | 0) < ($mean_bits | 0);
    if ($25) {
      label = 5;
      break;
    } else {
      label = 6;
      break;
    }
   case 5:
    var $27 = $move_bits_1 + $10 | 0;
    HEAP32[$targ_bits >> 2] = $27;
    label = 6;
    break;
   case 6:
    var $29 = HEAP32[$11 >> 2];
    var $30 = $29 - $move_bits_1 | 0;
    HEAP32[$11 >> 2] = $30;
    label = 8;
    break;
   case 7:
    var $32 = $10 - 125 | 0;
    var $33 = $32 + $12 | 0;
    HEAP32[$targ_bits >> 2] = $33;
    HEAP32[$11 >> 2] = 125;
    label = 8;
    break;
   case 8:
    var $35 = HEAP32[$targ_bits >> 2];
    var $36 = HEAP32[$11 >> 2];
    var $37 = $36 + $35 | 0;
    var $38 = ($37 | 0) > ($max_bits | 0);
    if ($38) {
      label = 9;
      break;
    } else {
      label = 10;
      break;
    }
   case 9:
    var $40 = $35 * $max_bits & -1;
    var $41 = ($40 | 0) / ($37 | 0) & -1;
    HEAP32[$targ_bits >> 2] = $41;
    var $42 = HEAP32[$11 >> 2];
    var $43 = $42 * $max_bits & -1;
    var $44 = ($43 | 0) / ($37 | 0) & -1;
    HEAP32[$11 >> 2] = $44;
    label = 10;
    break;
   case 10:
    return;
  }
}
_reduce_side["X"] = 1;
function _on_pe($gfc, $pe, $targ_bits, $mean_bits, $gr, $cbr) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $extra_bits = __stackBase__;
    var $tbits = __stackBase__ + 4;
    var $add_bits = __stackBase__ + 8;
    HEAP32[$extra_bits >> 2] = 0;
    var $1 = $add_bits;
    var $$etemp$0$0 = 0;
    var $$etemp$0$1 = 0;
    var $st$7$0 = $1 | 0;
    HEAP32[$st$7$0 >> 2] = $$etemp$0$0;
    var $st$7$1 = $1 + 4 | 0;
    HEAP32[$st$7$1 >> 2] = $$etemp$0$1;
    _ResvMaxBits($gfc, $mean_bits, $tbits, $extra_bits, $cbr);
    var $2 = HEAP32[$tbits >> 2];
    var $3 = HEAP32[$extra_bits >> 2];
    var $4 = $3 + $2 | 0;
    var $5 = ($4 | 0) > 7680;
    var $_ = $5 ? 7680 : $4;
    var $6 = $gfc + 72 | 0;
    var $7 = HEAP32[$6 >> 2];
    var $8 = ($7 | 0) > 0;
    if ($8) {
      label = 3;
      break;
    } else {
      label = 20;
      break;
    }
   case 3:
    var $9 = HEAP32[$tbits >> 2];
    var $10 = $mean_bits * 3 & -1;
    var $11 = ($10 | 0) / 4 & -1;
    var $bits_081 = 0;
    var $ch_082 = 0;
    var $13 = $7;
    label = 4;
    break;
   case 4:
    var $13;
    var $ch_082;
    var $bits_081;
    var $14 = ($9 | 0) / ($13 | 0) & -1;
    var $15 = ($14 | 0) > 4095;
    var $_67 = $15 ? 4095 : $14;
    var $16 = $targ_bits + ($ch_082 << 2) | 0;
    HEAP32[$16 >> 2] = $_67;
    var $17 = $_67 | 0;
    var $18 = $pe + ($gr << 3) + ($ch_082 << 2) | 0;
    var $19 = HEAPF32[$18 >> 2];
    var $20 = $19 * $17;
    var $21 = $20;
    var $22 = $21 / 700;
    var $23 = $_67 | 0;
    var $24 = $22 - $23;
    var $25 = $24 & -1;
    var $26 = $add_bits + ($ch_082 << 2) | 0;
    var $27 = ($25 | 0) > ($11 | 0);
    var $storemerge = $27 ? $11 : $25;
    var $28 = ($storemerge | 0) < 0;
    var $_storemerge = $28 ? 0 : $storemerge;
    HEAP32[$26 >> 2] = $_storemerge;
    var $29 = HEAP32[$16 >> 2];
    var $30 = $_storemerge + $29 | 0;
    var $31 = ($30 | 0) > 4095;
    if ($31) {
      label = 5;
      break;
    } else {
      label = 6;
      break;
    }
   case 5:
    var $33 = 4095 - $29 | 0;
    var $34 = ($33 | 0) < 0;
    var $_68 = $34 ? 0 : $33;
    HEAP32[$26 >> 2] = $_68;
    label = 6;
    break;
   case 6:
    var $36 = HEAP32[$26 >> 2];
    var $37 = $36 + $bits_081 | 0;
    var $38 = $ch_082 + 1 | 0;
    var $39 = HEAP32[$6 >> 2];
    var $40 = ($38 | 0) < ($39 | 0);
    if ($40) {
      var $bits_081 = $37;
      var $ch_082 = $38;
      var $13 = $39;
      label = 4;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    var $41 = HEAP32[$extra_bits >> 2];
    var $42 = ($37 | 0) > ($41 | 0);
    var $43 = ($37 | 0) > 0;
    var $or_cond = $42 & $43;
    if ($or_cond) {
      label = 8;
      break;
    } else {
      label = 10;
      break;
    }
   case 8:
    var $44 = HEAP32[$6 >> 2];
    var $45 = ($44 | 0) > 0;
    if ($45) {
      label = 9;
      break;
    } else {
      label = 20;
      break;
    }
   case 9:
    var $46 = HEAP32[$extra_bits >> 2];
    var $47 = HEAP32[$6 >> 2];
    var $ch_178 = 0;
    label = 12;
    break;
   case 10:
    var $_pr_pr = HEAP32[$6 >> 2];
    var $48 = ($_pr_pr | 0) > 0;
    if ($48) {
      label = 11;
      break;
    } else {
      label = 20;
      break;
    }
   case 11:
    var $extra_bits_promoted = HEAP32[$extra_bits >> 2];
    var $ch_275 = 0;
    var $59 = $extra_bits_promoted;
    label = 15;
    break;
   case 12:
    var $ch_178;
    var $50 = $add_bits + ($ch_178 << 2) | 0;
    var $51 = HEAP32[$50 >> 2];
    var $52 = $51 * $46 & -1;
    var $53 = ($52 | 0) / ($37 | 0) & -1;
    HEAP32[$50 >> 2] = $53;
    var $54 = $ch_178 + 1 | 0;
    var $55 = ($54 | 0) < ($47 | 0);
    if ($55) {
      var $ch_178 = $54;
      label = 12;
      break;
    } else {
      label = 10;
      break;
    }
   case 13:
    HEAP32[$extra_bits >> 2] = $66;
    var $_pr91_pr = HEAP32[$6 >> 2];
    var $56 = ($_pr91_pr | 0) > 0;
    if ($56) {
      label = 14;
      break;
    } else {
      label = 20;
      break;
    }
   case 14:
    var $57 = HEAP32[$6 >> 2];
    var $bits_171 = 0;
    var $ch_372 = 0;
    label = 16;
    break;
   case 15:
    var $59;
    var $ch_275;
    var $60 = $add_bits + ($ch_275 << 2) | 0;
    var $61 = HEAP32[$60 >> 2];
    var $62 = $targ_bits + ($ch_275 << 2) | 0;
    var $63 = HEAP32[$62 >> 2];
    var $64 = $63 + $61 | 0;
    HEAP32[$62 >> 2] = $64;
    var $65 = HEAP32[$60 >> 2];
    var $66 = $59 - $65 | 0;
    var $67 = $ch_275 + 1 | 0;
    var $68 = HEAP32[$6 >> 2];
    var $69 = ($67 | 0) < ($68 | 0);
    if ($69) {
      var $ch_275 = $67;
      var $59 = $66;
      label = 15;
      break;
    } else {
      label = 13;
      break;
    }
   case 16:
    var $ch_372;
    var $bits_171;
    var $71 = $targ_bits + ($ch_372 << 2) | 0;
    var $72 = HEAP32[$71 >> 2];
    var $73 = $72 + $bits_171 | 0;
    var $74 = $ch_372 + 1 | 0;
    var $75 = ($74 | 0) < ($57 | 0);
    if ($75) {
      var $bits_171 = $73;
      var $ch_372 = $74;
      label = 16;
      break;
    } else {
      label = 17;
      break;
    }
   case 17:
    var $76 = ($73 | 0) > 7680;
    if ($76) {
      label = 18;
      break;
    } else {
      label = 20;
      break;
    }
   case 18:
    var $77 = HEAP32[$6 >> 2];
    var $78 = ($77 | 0) > 0;
    if ($78) {
      var $ch_469 = 0;
      label = 19;
      break;
    } else {
      label = 20;
      break;
    }
   case 19:
    var $ch_469;
    var $79 = $targ_bits + ($ch_469 << 2) | 0;
    var $80 = HEAP32[$79 >> 2];
    var $81 = $80 * 7680 & -1;
    var $82 = ($81 | 0) / ($73 | 0) & -1;
    HEAP32[$79 >> 2] = $82;
    var $83 = $ch_469 + 1 | 0;
    var $84 = HEAP32[$6 >> 2];
    var $85 = ($83 | 0) < ($84 | 0);
    if ($85) {
      var $ch_469 = $83;
      label = 19;
      break;
    } else {
      label = 20;
      break;
    }
   case 20:
    STACKTOP = __stackBase__;
    return $_;
  }
}
_on_pe["X"] = 1;
function _athAdjust($a, $x, $athFloor, $ATHfixpoint) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $ATHfixpoint < 1;
    var $2 = $1 ? 94.82444763183594 : $ATHfixpoint;
    var $3 = _fast_log2($x);
    var $4 = $3;
    var $5 = $4 * 3.0102999566398116;
    var $6 = $5;
    var $7 = $a * $a;
    var $8 = $6 - $athFloor;
    var $9 = $7 > 9.999999682655225e-21;
    if ($9) {
      label = 3;
      break;
    } else {
      var $w_0 = 0;
      label = 4;
      break;
    }
   case 3:
    var $11 = _fast_log2($7);
    var $12 = $11;
    var $13 = $12 * .03333343265598758;
    var $14 = $13 + 1;
    var $15 = $14;
    var $w_0 = $15;
    label = 4;
    break;
   case 4:
    var $w_0;
    var $17 = $w_0 < 0;
    var $w_1 = $17 ? 0 : $w_0;
    var $18 = $8 * $w_1;
    var $19 = $athFloor + 90.30873107910156;
    var $20 = $19 - $2;
    var $21 = $20 + $18;
    var $22 = $21 * .10000000149011612;
    var $23 = Math.pow(10, $22);
    return $23;
  }
}
function _calc_xmin($gfc, $ratio, $cod_info, $pxmin) {
  var label = 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $1 = $gfc + 85792 | 0;
    var $2 = HEAP32[$1 >> 2];
    var $3 = $cod_info + 4856 | 0;
    var $4 = HEAP32[$3 >> 2];
    var $5 = ($4 | 0) > 0;
    if ($5) {
      label = 3;
      break;
    } else {
      var $ath_over_0_lcssa = 0;
      var $j_0_lcssa = 0;
      var $gsfb_0_lcssa = 0;
      var $_0_lcssa = $pxmin;
      label = 4;
      break;
    }
   case 3:
    var $6 = $2 + 8 | 0;
    var $7 = $2 + 20 | 0;
    var $8 = $gfc + 224 | 0;
    var $ath_over_0162 = 0;
    var $j_0163 = 0;
    var $gsfb_0164 = 0;
    var $_0165 = $pxmin;
    label = 5;
    break;
   case 4:
    var $_0_lcssa;
    var $gsfb_0_lcssa;
    var $j_0_lcssa;
    var $ath_over_0_lcssa;
    var $k_0 = 575;
    label = 14;
    break;
   case 5:
    var $_0165;
    var $gsfb_0164;
    var $j_0163;
    var $ath_over_0162;
    var $10 = HEAPF32[$6 >> 2];
    var $11 = $2 + 24 + ($gsfb_0164 << 2) | 0;
    var $12 = HEAPF32[$11 >> 2];
    var $13 = HEAPF32[$7 >> 2];
    var $14 = HEAPF32[$8 >> 2];
    var $15 = _athAdjust($10, $12, $13, $14);
    var $16 = $gfc + 84764 + ($gsfb_0164 << 2) | 0;
    var $17 = HEAPF32[$16 >> 2];
    var $18 = $15 * $17;
    var $19 = $cod_info + 4872 + ($gsfb_0164 << 2) | 0;
    var $20 = HEAP32[$19 >> 2];
    var $21 = $20 | 0;
    var $22 = $18 / $21;
    var $23 = ($20 | 0) > 0;
    if ($23) {
      var $l_0152 = 0;
      var $rh2_0153 = 2.220446049250313e-16;
      var $en0_0154 = 0;
      var $j_1155 = $j_0163;
      label = 6;
      break;
    } else {
      var $rh2_0_lcssa = 2.220446049250313e-16;
      var $en0_0_lcssa = 0;
      var $j_1_lcssa = $j_0163;
      label = 8;
      break;
    }
   case 6:
    var $j_1155;
    var $en0_0154;
    var $rh2_0153;
    var $l_0152;
    var $24 = $j_1155 + 1 | 0;
    var $25 = $cod_info + ($j_1155 << 2) | 0;
    var $26 = HEAPF32[$25 >> 2];
    var $27 = $26 * $26;
    var $28 = $en0_0154 + $27;
    var $29 = $27 < $22;
    var $30 = $29 ? $27 : $22;
    var $31 = $rh2_0153 + $30;
    var $32 = $l_0152 + 1 | 0;
    var $exitcond179 = ($32 | 0) == ($20 | 0);
    if ($exitcond179) {
      label = 7;
      break;
    } else {
      var $l_0152 = $32;
      var $rh2_0153 = $31;
      var $en0_0154 = $28;
      var $j_1155 = $24;
      label = 6;
      break;
    }
   case 7:
    var $33 = $j_0163 + $20 | 0;
    var $rh2_0_lcssa = $31;
    var $en0_0_lcssa = $28;
    var $j_1_lcssa = $33;
    label = 8;
    break;
   case 8:
    var $j_1_lcssa;
    var $en0_0_lcssa;
    var $rh2_0_lcssa;
    var $35 = $en0_0_lcssa > $18;
    var $36 = $35 & 1;
    var $ath_over_1 = $36 + $ath_over_0162 | 0;
    var $37 = $en0_0_lcssa < $18;
    if ($37) {
      var $rh3_0 = $en0_0_lcssa;
      label = 10;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    var $39 = $rh2_0_lcssa < $18;
    var $_rh2_0 = $39 ? $18 : $rh2_0_lcssa;
    var $rh3_0 = $_rh2_0;
    label = 10;
    break;
   case 10:
    var $rh3_0;
    var $41 = $ratio + 244 + ($gsfb_0164 << 2) | 0;
    var $42 = HEAPF32[$41 >> 2];
    var $43 = $42 > 9.999999960041972e-13;
    if ($43) {
      label = 11;
      break;
    } else {
      var $xmin_0 = $rh3_0;
      label = 13;
      break;
    }
   case 11:
    var $45 = $ratio + ($gsfb_0164 << 2) | 0;
    var $46 = HEAPF32[$45 >> 2];
    var $47 = $en0_0_lcssa * $46;
    var $48 = $47 / $42;
    var $49 = HEAPF32[$16 >> 2];
    var $50 = $48 * $49;
    var $51 = $rh3_0 < $50;
    if ($51) {
      label = 12;
      break;
    } else {
      var $xmin_0 = $rh3_0;
      label = 13;
      break;
    }
   case 12:
    var $xmin_0 = $50;
    label = 13;
    break;
   case 13:
    var $xmin_0;
    var $54 = $xmin_0 > 2.220446049250313e-16;
    var $55 = $54 ? $xmin_0 : 2.220446049250313e-16;
    var $56 = $55 + 9.9999998245167e-15;
    var $57 = $en0_0_lcssa > $56;
    var $58 = $57 & 1;
    var $59 = $gsfb_0164 + ($cod_info + 5212) | 0;
    HEAP8[$59] = $58;
    var $60 = $_0165 + 4 | 0;
    HEAPF32[$_0165 >> 2] = $55;
    var $61 = $gsfb_0164 + 1 | 0;
    var $62 = HEAP32[$3 >> 2];
    var $63 = ($61 | 0) < ($62 | 0);
    if ($63) {
      var $ath_over_0162 = $ath_over_1;
      var $j_0163 = $j_1_lcssa;
      var $gsfb_0164 = $61;
      var $_0165 = $60;
      label = 5;
      break;
    } else {
      var $ath_over_0_lcssa = $ath_over_1;
      var $j_0_lcssa = $j_1_lcssa;
      var $gsfb_0_lcssa = $61;
      var $_0_lcssa = $60;
      label = 4;
      break;
    }
   case 14:
    var $k_0;
    var $65 = ($k_0 | 0) > 0;
    if ($65) {
      label = 15;
      break;
    } else {
      var $max_nonzero_0 = 0;
      label = 16;
      break;
    }
   case 15:
    var $67 = $cod_info + ($k_0 << 2) | 0;
    var $68 = HEAPF32[$67 >> 2];
    var $fabsf = Math.abs($68);
    var $69 = $fabsf > 9.999999960041972e-13;
    var $70 = $k_0 - 1 | 0;
    if ($69) {
      var $max_nonzero_0 = $k_0;
      label = 16;
      break;
    } else {
      var $k_0 = $70;
      label = 14;
      break;
    }
   case 16:
    var $max_nonzero_0;
    var $72 = $cod_info + 4788 | 0;
    var $73 = HEAP32[$72 >> 2];
    var $74 = ($73 | 0) == 2;
    if ($74) {
      label = 18;
      break;
    } else {
      label = 17;
      break;
    }
   case 17:
    var $76 = $max_nonzero_0 | 1;
    var $max_nonzero_1 = $76;
    label = 19;
    break;
   case 18:
    var $78 = ($max_nonzero_0 | 0) % 6;
    var $79 = $max_nonzero_0 + 5 | 0;
    var $80 = $79 - $78 | 0;
    var $max_nonzero_1 = $80;
    label = 19;
    break;
   case 19:
    var $max_nonzero_1;
    var $82 = $gfc + 85088 | 0;
    var $83 = HEAP32[$82 >> 2];
    var $84 = ($83 | 0) == 0;
    if ($84) {
      label = 20;
      break;
    } else {
      var $max_nonzero_2 = $max_nonzero_1;
      label = 25;
      break;
    }
   case 20:
    var $86 = $gfc + 64 | 0;
    var $87 = HEAP32[$86 >> 2];
    var $88 = ($87 | 0) < 44e3;
    if ($88) {
      label = 21;
      break;
    } else {
      var $max_nonzero_2 = $max_nonzero_1;
      label = 25;
      break;
    }
   case 21:
    var $90 = ($87 | 0) < 8001;
    var $91 = HEAP32[$72 >> 2];
    var $92 = ($91 | 0) == 2;
    if ($92) {
      label = 23;
      break;
    } else {
      label = 22;
      break;
    }
   case 22:
    var $94 = $90 ? 17 : 21;
    var $95 = $gfc + 21360 + ($94 << 2) | 0;
    var $96 = HEAP32[$95 >> 2];
    var $limit_0_in = $96;
    label = 24;
    break;
   case 23:
    var $98 = $90 ? 9 : 12;
    var $99 = $gfc + 21452 + ($98 << 2) | 0;
    var $100 = HEAP32[$99 >> 2];
    var $101 = $100 * 3 & -1;
    var $limit_0_in = $101;
    label = 24;
    break;
   case 24:
    var $limit_0_in;
    var $limit_0 = $limit_0_in - 1 | 0;
    var $103 = ($max_nonzero_1 | 0) > ($limit_0 | 0);
    var $limit_0_max_nonzero_1 = $103 ? $limit_0 : $max_nonzero_1;
    var $max_nonzero_2 = $limit_0_max_nonzero_1;
    label = 25;
    break;
   case 25:
    var $max_nonzero_2;
    var $105 = $cod_info + 5208 | 0;
    HEAP32[$105 >> 2] = $max_nonzero_2;
    var $106 = $cod_info + 4864 | 0;
    var $107 = HEAP32[$106 >> 2];
    var $108 = ($gsfb_0_lcssa | 0) < ($107 | 0);
    if ($108) {
      label = 26;
      break;
    } else {
      var $ath_over_2_lcssa = $ath_over_0_lcssa;
      label = 41;
      break;
    }
   case 26:
    var $109 = $cod_info + 4852 | 0;
    var $110 = HEAP32[$109 >> 2];
    var $111 = $2 + 8 | 0;
    var $112 = $2 + 20 | 0;
    var $113 = $gfc + 224 | 0;
    var $114 = $gfc + 92 | 0;
    var $115 = $gfc + 85796 | 0;
    var $116 = $gfc + 85796 | 0;
    var $scevgep174 = $_0_lcssa + 8 | 0;
    var $ath_over_2143 = $ath_over_0_lcssa;
    var $j_2144 = $j_0_lcssa;
    var $gsfb_1145 = $gsfb_0_lcssa;
    var $sfb_0146 = $110;
    var $_1147 = $_0_lcssa;
    var $indvars_iv = $scevgep174;
    label = 27;
    break;
   case 27:
    var $indvars_iv;
    var $_1147;
    var $sfb_0146;
    var $gsfb_1145;
    var $j_2144;
    var $ath_over_2143;
    var $118 = HEAPF32[$111 >> 2];
    var $119 = $2 + 112 + ($sfb_0146 << 2) | 0;
    var $120 = HEAPF32[$119 >> 2];
    var $121 = HEAPF32[$112 >> 2];
    var $122 = HEAPF32[$113 >> 2];
    var $123 = _athAdjust($118, $120, $121, $122);
    var $124 = $gfc + 84852 + ($sfb_0146 << 2) | 0;
    var $125 = HEAPF32[$124 >> 2];
    var $126 = $123 * $125;
    var $127 = $cod_info + 4872 + ($gsfb_1145 << 2) | 0;
    var $128 = HEAP32[$127 >> 2];
    var $129 = $128 | 0;
    var $130 = $126 / $129;
    var $131 = ($128 | 0) > 0;
    if ($131) {
      var $l2_0133 = 0;
      var $en03_0134 = 0;
      var $j_4135 = $j_2144;
      var $rh26_0136 = 2.220446049250313e-16;
      label = 28;
      break;
    } else {
      var $en03_0_lcssa = 0;
      var $j_4_lcssa = $j_2144;
      var $rh26_0_lcssa = 2.220446049250313e-16;
      label = 30;
      break;
    }
   case 28:
    var $rh26_0136;
    var $j_4135;
    var $en03_0134;
    var $l2_0133;
    var $132 = $j_4135 + 1 | 0;
    var $133 = $cod_info + ($j_4135 << 2) | 0;
    var $134 = HEAPF32[$133 >> 2];
    var $135 = $134 * $134;
    var $136 = $en03_0134 + $135;
    var $137 = $135 < $130;
    var $138 = $137 ? $135 : $130;
    var $139 = $rh26_0136 + $138;
    var $140 = $l2_0133 + 1 | 0;
    var $exitcond = ($140 | 0) == ($128 | 0);
    if ($exitcond) {
      label = 29;
      break;
    } else {
      var $l2_0133 = $140;
      var $en03_0134 = $136;
      var $j_4135 = $132;
      var $rh26_0136 = $139;
      label = 28;
      break;
    }
   case 29:
    var $141 = $128 + $j_2144 | 0;
    var $en03_0_lcssa = $136;
    var $j_4_lcssa = $141;
    var $rh26_0_lcssa = $139;
    label = 30;
    break;
   case 30:
    var $rh26_0_lcssa;
    var $j_4_lcssa;
    var $en03_0_lcssa;
    var $143 = $en03_0_lcssa > $126;
    var $144 = $143 & 1;
    var $ath_over_4 = $144 + $ath_over_2143 | 0;
    var $145 = $en03_0_lcssa < $126;
    if ($145) {
      var $rh37_0 = $en03_0_lcssa;
      label = 32;
      break;
    } else {
      label = 31;
      break;
    }
   case 31:
    var $147 = $rh26_0_lcssa < $126;
    var $_rh26_0 = $147 ? $126 : $rh26_0_lcssa;
    var $rh37_0 = $_rh26_0;
    label = 32;
    break;
   case 32:
    var $rh37_0;
    var $149 = $ratio + 332 + $sfb_0146 * 12 | 0;
    var $150 = HEAPF32[$149 >> 2];
    var $151 = $150 > 9.999999960041972e-13;
    if ($151) {
      label = 33;
      break;
    } else {
      var $xmin4_0 = $rh37_0;
      label = 35;
      break;
    }
   case 33:
    var $153 = $ratio + 88 + $sfb_0146 * 12 | 0;
    var $154 = HEAPF32[$153 >> 2];
    var $155 = $en03_0_lcssa * $154;
    var $156 = $155 / $150;
    var $157 = HEAPF32[$124 >> 2];
    var $158 = $156 * $157;
    var $159 = $rh37_0 < $158;
    if ($159) {
      label = 34;
      break;
    } else {
      var $xmin4_0 = $rh37_0;
      label = 35;
      break;
    }
   case 34:
    var $xmin4_0 = $158;
    label = 35;
    break;
   case 35:
    var $xmin4_0;
    var $162 = $xmin4_0 > 2.220446049250313e-16;
    var $163 = $162 ? $xmin4_0 : 2.220446049250313e-16;
    var $164 = $163 + 9.9999998245167e-15;
    var $165 = $en03_0_lcssa > $164;
    var $166 = $165 & 1;
    var $167 = $gsfb_1145 + ($cod_info + 5212) | 0;
    HEAP8[$167] = $166;
    var $168 = $_1147 + 4 | 0;
    HEAPF32[$_1147 >> 2] = $163;
    if ($131) {
      var $l2_0133_1 = 0;
      var $en03_0134_1 = 0;
      var $j_4135_1 = $j_4_lcssa;
      var $rh26_0136_1 = 2.220446049250313e-16;
      label = 42;
      break;
    } else {
      var $en03_0_lcssa_1 = 0;
      var $j_4_lcssa_1 = $j_4_lcssa;
      var $rh26_0_lcssa_1 = 2.220446049250313e-16;
      label = 44;
      break;
    }
   case 36:
    var $170 = $indvars_iv - 8 | 0;
    var $171 = HEAPF32[$170 >> 2];
    var $172 = $indvars_iv - 4 | 0;
    var $173 = HEAPF32[$172 >> 2];
    var $174 = $171 > $173;
    if ($174) {
      label = 37;
      break;
    } else {
      label = 38;
      break;
    }
   case 37:
    var $176 = $171 - $173;
    var $177 = HEAP32[$115 >> 2];
    var $178 = $177 + 6496 | 0;
    var $179 = HEAPF32[$178 >> 2];
    var $180 = $176 * $179;
    var $181 = $173 + $180;
    HEAPF32[$172 >> 2] = $181;
    label = 38;
    break;
   case 38:
    var $183 = HEAPF32[$172 >> 2];
    var $184 = HEAPF32[$indvars_iv >> 2];
    var $185 = $183 > $184;
    if ($185) {
      label = 39;
      break;
    } else {
      label = 40;
      break;
    }
   case 39:
    var $187 = $183 - $184;
    var $188 = HEAP32[$116 >> 2];
    var $189 = $188 + 6496 | 0;
    var $190 = HEAPF32[$189 >> 2];
    var $191 = $187 * $190;
    var $192 = $184 + $191;
    HEAPF32[$indvars_iv >> 2] = $192;
    label = 40;
    break;
   case 40:
    var $194 = $sfb_0146 + 1 | 0;
    var $195 = $gsfb_1145 + 3 | 0;
    var $196 = HEAP32[$106 >> 2];
    var $197 = ($195 | 0) < ($196 | 0);
    var $scevgep175 = $indvars_iv + 12 | 0;
    if ($197) {
      var $ath_over_2143 = $ath_over_4_2;
      var $j_2144 = $j_4_lcssa_2;
      var $gsfb_1145 = $195;
      var $sfb_0146 = $194;
      var $_1147 = $scevgep;
      var $indvars_iv = $scevgep175;
      label = 27;
      break;
    } else {
      var $ath_over_2_lcssa = $ath_over_4_2;
      label = 41;
      break;
    }
   case 41:
    var $ath_over_2_lcssa;
    return $ath_over_2_lcssa;
   case 42:
    var $rh26_0136_1;
    var $j_4135_1;
    var $en03_0134_1;
    var $l2_0133_1;
    var $198 = $j_4135_1 + 1 | 0;
    var $199 = $cod_info + ($j_4135_1 << 2) | 0;
    var $200 = HEAPF32[$199 >> 2];
    var $201 = $200 * $200;
    var $202 = $en03_0134_1 + $201;
    var $203 = $201 < $130;
    var $204 = $203 ? $201 : $130;
    var $205 = $rh26_0136_1 + $204;
    var $206 = $l2_0133_1 + 1 | 0;
    var $exitcond_1 = ($206 | 0) == ($128 | 0);
    if ($exitcond_1) {
      label = 43;
      break;
    } else {
      var $l2_0133_1 = $206;
      var $en03_0134_1 = $202;
      var $j_4135_1 = $198;
      var $rh26_0136_1 = $205;
      label = 42;
      break;
    }
   case 43:
    var $207 = $128 + $j_4_lcssa | 0;
    var $en03_0_lcssa_1 = $202;
    var $j_4_lcssa_1 = $207;
    var $rh26_0_lcssa_1 = $205;
    label = 44;
    break;
   case 44:
    var $rh26_0_lcssa_1;
    var $j_4_lcssa_1;
    var $en03_0_lcssa_1;
    var $209 = $en03_0_lcssa_1 > $126;
    var $210 = $209 & 1;
    var $ath_over_4_1 = $210 + $ath_over_4 | 0;
    var $211 = $en03_0_lcssa_1 < $126;
    if ($211) {
      var $rh37_0_1 = $en03_0_lcssa_1;
      label = 46;
      break;
    } else {
      label = 45;
      break;
    }
   case 45:
    var $213 = $rh26_0_lcssa_1 < $126;
    var $_rh26_0_1 = $213 ? $126 : $rh26_0_lcssa_1;
    var $rh37_0_1 = $_rh26_0_1;
    label = 46;
    break;
   case 46:
    var $rh37_0_1;
    var $215 = $ratio + 332 + $sfb_0146 * 12 + 4 | 0;
    var $216 = HEAPF32[$215 >> 2];
    var $217 = $216 > 9.999999960041972e-13;
    if ($217) {
      label = 47;
      break;
    } else {
      var $xmin4_0_1 = $rh37_0_1;
      label = 49;
      break;
    }
   case 47:
    var $219 = $ratio + 88 + $sfb_0146 * 12 + 4 | 0;
    var $220 = HEAPF32[$219 >> 2];
    var $221 = $en03_0_lcssa_1 * $220;
    var $222 = $221 / $216;
    var $223 = HEAPF32[$124 >> 2];
    var $224 = $222 * $223;
    var $225 = $rh37_0_1 < $224;
    if ($225) {
      label = 48;
      break;
    } else {
      var $xmin4_0_1 = $rh37_0_1;
      label = 49;
      break;
    }
   case 48:
    var $xmin4_0_1 = $224;
    label = 49;
    break;
   case 49:
    var $xmin4_0_1;
    var $228 = $xmin4_0_1 > 2.220446049250313e-16;
    var $229 = $228 ? $xmin4_0_1 : 2.220446049250313e-16;
    var $230 = $229 + 9.9999998245167e-15;
    var $231 = $en03_0_lcssa_1 > $230;
    var $232 = $231 & 1;
    var $233 = $gsfb_1145 + 1 | 0;
    var $234 = $233 + ($cod_info + 5212) | 0;
    HEAP8[$234] = $232;
    var $235 = $_1147 + 8 | 0;
    HEAPF32[$168 >> 2] = $229;
    if ($131) {
      var $l2_0133_2 = 0;
      var $en03_0134_2 = 0;
      var $j_4135_2 = $j_4_lcssa_1;
      var $rh26_0136_2 = 2.220446049250313e-16;
      label = 50;
      break;
    } else {
      var $en03_0_lcssa_2 = 0;
      var $j_4_lcssa_2 = $j_4_lcssa_1;
      var $rh26_0_lcssa_2 = 2.220446049250313e-16;
      label = 52;
      break;
    }
   case 50:
    var $rh26_0136_2;
    var $j_4135_2;
    var $en03_0134_2;
    var $l2_0133_2;
    var $236 = $j_4135_2 + 1 | 0;
    var $237 = $cod_info + ($j_4135_2 << 2) | 0;
    var $238 = HEAPF32[$237 >> 2];
    var $239 = $238 * $238;
    var $240 = $en03_0134_2 + $239;
    var $241 = $239 < $130;
    var $242 = $241 ? $239 : $130;
    var $243 = $rh26_0136_2 + $242;
    var $244 = $l2_0133_2 + 1 | 0;
    var $exitcond_2 = ($244 | 0) == ($128 | 0);
    if ($exitcond_2) {
      label = 51;
      break;
    } else {
      var $l2_0133_2 = $244;
      var $en03_0134_2 = $240;
      var $j_4135_2 = $236;
      var $rh26_0136_2 = $243;
      label = 50;
      break;
    }
   case 51:
    var $245 = $128 + $j_4_lcssa_1 | 0;
    var $en03_0_lcssa_2 = $240;
    var $j_4_lcssa_2 = $245;
    var $rh26_0_lcssa_2 = $243;
    label = 52;
    break;
   case 52:
    var $rh26_0_lcssa_2;
    var $j_4_lcssa_2;
    var $en03_0_lcssa_2;
    var $247 = $en03_0_lcssa_2 > $126;
    var $248 = $247 & 1;
    var $ath_over_4_2 = $248 + $ath_over_4_1 | 0;
    var $249 = $en03_0_lcssa_2 < $126;
    if ($249) {
      var $rh37_0_2 = $en03_0_lcssa_2;
      label = 54;
      break;
    } else {
      label = 53;
      break;
    }
   case 53:
    var $251 = $rh26_0_lcssa_2 < $126;
    var $_rh26_0_2 = $251 ? $126 : $rh26_0_lcssa_2;
    var $rh37_0_2 = $_rh26_0_2;
    label = 54;
    break;
   case 54:
    var $rh37_0_2;
    var $253 = $ratio + 332 + $sfb_0146 * 12 + 8 | 0;
    var $254 = HEAPF32[$253 >> 2];
    var $255 = $254 > 9.999999960041972e-13;
    if ($255) {
      label = 55;
      break;
    } else {
      var $xmin4_0_2 = $rh37_0_2;
      label = 57;
      break;
    }
   case 55:
    var $257 = $ratio + 88 + $sfb_0146 * 12 + 8 | 0;
    var $258 = HEAPF32[$257 >> 2];
    var $259 = $en03_0_lcssa_2 * $258;
    var $260 = $259 / $254;
    var $261 = HEAPF32[$124 >> 2];
    var $262 = $260 * $261;
    var $263 = $rh37_0_2 < $262;
    if ($263) {
      label = 56;
      break;
    } else {
      var $xmin4_0_2 = $rh37_0_2;
      label = 57;
      break;
    }
   case 56:
    var $xmin4_0_2 = $262;
    label = 57;
    break;
   case 57:
    var $xmin4_0_2;
    var $266 = $xmin4_0_2 > 2.220446049250313e-16;
    var $267 = $266 ? $xmin4_0_2 : 2.220446049250313e-16;
    var $268 = $267 + 9.9999998245167e-15;
    var $269 = $en03_0_lcssa_2 > $268;
    var $270 = $269 & 1;
    var $271 = $gsfb_1145 + 2 | 0;
    var $272 = $271 + ($cod_info + 5212) | 0;
    HEAP8[$272] = $270;
    HEAPF32[$235 >> 2] = $267;
    var $scevgep = $_1147 + 12 | 0;
    var $273 = HEAP32[$114 >> 2];
    var $274 = ($273 | 0) == 0;
    if ($274) {
      label = 40;
      break;
    } else {
      label = 36;
      break;
    }
  }
}
_calc_xmin["X"] = 1;
function _calc_noise($cod_info, $l3_xmin, $distort, $res, $prev_noise) {
  var label = 0;
  var __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 4 | 0;
  label = 2;
  while (1) switch (label) {
   case 2:
    var $j = __stackBase__;
    HEAP32[$j >> 2] = 0;
    var $1 = $res + 16 | 0;
    HEAP32[$1 >> 2] = 0;
    var $2 = $cod_info + 4864 | 0;
    var $3 = HEAP32[$2 >> 2];
    var $4 = ($3 | 0) > 0;
    if ($4) {
      label = 3;
      break;
    } else {
      var $over_noise_db_0_lcssa = 0;
      var $tot_noise_db_0_lcssa = 0;
      var $max_noise_0_lcssa = -20;
      var $over_0_lcssa = 0;
      label = 20;
      break;
    }
   case 3:
    var $5 = $cod_info + 4608 | 0;
    var $6 = $cod_info + 4780 | 0;
    var $7 = $cod_info + 4832 | 0;
    var $8 = $cod_info + 4836 | 0;
    var $9 = ($prev_noise | 0) != 0;
    var $10 = $prev_noise | 0;
    var $11 = $cod_info + 5208 | 0;
    var $over_noise_db_071 = 0;
    var $tot_noise_db_072 = 0;
    var $max_noise_073 = -20;
    var $scalefac_074 = $5;
    var $over_075 = 0;
    var $sfb_076 = 0;
    var $_06779 = $distort;
    var $_080 = $l3_xmin;
    label = 4;
    break;
   case 4:
    var $_080;
    var $_06779;
    var $sfb_076;
    var $over_075;
    var $scalefac_074;
    var $max_noise_073;
    var $tot_noise_db_072;
    var $over_noise_db_071;
    var $13 = HEAP32[$6 >> 2];
    var $14 = $scalefac_074 + 4 | 0;
    var $15 = HEAP32[$scalefac_074 >> 2];
    var $16 = HEAP32[$7 >> 2];
    var $17 = ($16 | 0) == 0;
    if ($17) {
      var $22 = 0;
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    var $19 = 5257016 + ($sfb_076 << 2) | 0;
    var $20 = HEAP32[$19 >> 2];
    var $22 = $20;
    label = 6;
    break;
   case 6:
    var $22;
    var $23 = $22 + $15 | 0;
    var $24 = HEAP32[$8 >> 2];
    var $25 = $24 + 1 | 0;
    var $26 = $23 << $25;
    var $27 = $13 - $26 | 0;
    var $28 = $cod_info + 5028 + ($sfb_076 << 2) | 0;
    var $29 = HEAP32[$28 >> 2];
    var $30 = $cod_info + 4808 + ($29 << 2) | 0;
    var $31 = HEAP32[$30 >> 2];
    var $32 = $31 << 3;
    var $33 = $27 - $32 | 0;
    var $34 = $_080 + 4 | 0;
    var $35 = HEAPF32[$_080 >> 2];
    var $36 = 1 / $35;
    if ($9) {
      label = 7;
      break;
    } else {
      label = 9;
      break;
    }
   case 7:
    var $38 = $prev_noise + 8 + ($sfb_0