Unit VSOP87.Saturn;  //----------
 //-----------------//
// VSOP87 = Variations Seculaires des Orbiotes Planetaires 1987
//    by Bretagnon and Francou - Bureau des Longitudes of Paris
//
// calculates planet's ecliptical Lon,Lat and Radius ( R from the Sun )
// This method is described in J.Meeus book "Astronomical Algorithms" - Chapter 32
// used as basis for this code.

Interface

uses  VSOP87.PlanetDef;

const
{Termos de L =========================}
{L0 -------------------------}
NL0=90;
L0:Array[1..NL0]  of TPlanTerm=(
{1} (A:87401354.02900000 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:11107659.78000000 ;B:      3.96205090 ;C:    213.29909544),
{3} (A:1414150.95800000 ;B:      4.58581516 ;C:      7.11354700),
{4} (A: 398379.38600000 ;B:      0.52112026 ;C:    206.18554844),
{5} (A: 350769.22300000 ;B:      3.30329903 ;C:    426.59819088),
{6} (A: 206816.29600000 ;B:      0.24658367 ;C:    103.09277422),
{7} (A:  79271.28800000 ;B:      3.84007079 ;C:    220.41264244),
{8} (A:  23990.33800000 ;B:      4.66976935 ;C:    110.20632122),
{9} (A:  16573.58300000 ;B:      0.43719124 ;C:    419.48464388),
{10} (A:  15820.30000000 ;B:      0.93808954 ;C:    632.78373931),
{11} (A:  15053.50900000 ;B:      2.71670028 ;C:    639.89728631),
{12} (A:  14906.99500000 ;B:      5.76903284 ;C:    316.39186966),
{13} (A:  14609.56200000 ;B:      1.56518574 ;C:      3.93215326),
{14} (A:  13160.30800000 ;B:      4.44891180 ;C:     14.22709400),
{15} (A:  13005.30500000 ;B:      5.98119067 ;C:     11.04570026),
{16} (A:  10725.06600000 ;B:      3.12939596 ;C:    202.25339517),
{17} (A:   6126.30800000 ;B:      1.76328500 ;C:    277.03499374),
{18} (A:   5863.20700000 ;B:      0.23657029 ;C:    529.69096509),
{19} (A:   5227.77100000 ;B:      4.20783162 ;C:      3.18139374),
{20} (A:   5019.65800000 ;B:      3.17787920 ;C:    433.71173788),
{21} (A:   4592.54100000 ;B:      0.61976424 ;C:    199.07200144),
{22} (A:   4005.86200000 ;B:      2.24479894 ;C:     63.73589830),
{23} (A:   3873.69600000 ;B:      3.22282693 ;C:    138.51749687),
{24} (A:   3269.49000000 ;B:      0.77491896 ;C:    949.17560897),
{25} (A:   2953.81500000 ;B:      0.98280385 ;C:     95.97922722),
{26} (A:   2461.17200000 ;B:      2.03163631 ;C:    735.87651353),
{27} (A:   1758.14300000 ;B:      3.26580515 ;C:    522.57741809),
{28} (A:   1640.18300000 ;B:      5.50504966 ;C:    846.08283475),
{29} (A:   1580.64100000 ;B:      4.37266314 ;C:    309.27832266),
{30} (A:   1391.33600000 ;B:      4.02331978 ;C:    323.50541666),
{31} (A:   1123.51500000 ;B:      2.83726794 ;C:    415.55249061),
{32} (A:   1087.23700000 ;B:      4.18343232 ;C:      2.44768055),
{33} (A:   1017.25800000 ;B:      3.71698152 ;C:    227.52618944),
{34} (A:    956.75200000 ;B:      0.50740890 ;C:   1265.56747863),
{35} (A:    852.67700000 ;B:      3.42141351 ;C:    175.16605980),
{36} (A:    848.64300000 ;B:      3.19149826 ;C:    209.36694217),
{37} (A:    789.20500000 ;B:      5.00745123 ;C:      0.96320785),
{38} (A:    748.81100000 ;B:      2.14398149 ;C:    853.19638175),
{39} (A:    743.58400000 ;B:      5.25276955 ;C:    224.34479570),
{40} (A:    686.96500000 ;B:      1.74714408 ;C:   1052.26838319),
{41} (A:    654.47000000 ;B:      1.59889332 ;C:      0.04818411),
{42} (A:    633.98000000 ;B:      2.29889903 ;C:    412.37109687),
{43} (A:    624.90400000 ;B:      0.97046831 ;C:    210.11770170),
{44} (A:    579.85700000 ;B:      3.09259007 ;C:     74.78159857),
{45} (A:    546.35800000 ;B:      2.12678554 ;C:    350.33211960),
{46} (A:    542.64300000 ;B:      1.51824321 ;C:      9.56122756),
{47} (A:    529.86100000 ;B:      4.44938897 ;C:    117.31986822),
{48} (A:    478.05400000 ;B:      2.96488054 ;C:    137.03302416),
{49} (A:    474.27900000 ;B:      5.47527186 ;C:    742.99006053),
{50} (A:    451.82700000 ;B:      1.04436664 ;C:    490.33408918),
{51} (A:    448.54200000 ;B:      1.28990416 ;C:    127.47179661),
{52} (A:    372.30800000 ;B:      2.27819109 ;C:    217.23124870),
{53} (A:    354.94400000 ;B:      3.01286483 ;C:    838.96928775),
{54} (A:    347.41300000 ;B:      1.53928228 ;C:    340.77089204),
{55} (A:    343.47500000 ;B:      0.24604039 ;C:      0.52126486),
{56} (A:    330.19600000 ;B:      0.24715618 ;C:   1581.95934828),
{57} (A:    322.18500000 ;B:      0.96137456 ;C:    203.73786788),
{58} (A:    321.54300000 ;B:      2.57182355 ;C:    647.01083331),
{59} (A:    309.00100000 ;B:      3.49486735 ;C:    216.48048918),
{60} (A:    286.68800000 ;B:      2.37043746 ;C:    351.81659231),
{61} (A:    277.77500000 ;B:      0.40020409 ;C:    211.81462273),
{62} (A:    249.11600000 ;B:      1.47010534 ;C:   1368.66025285),
{63} (A:    226.60900000 ;B:      4.91003163 ;C:     12.53017297),
{64} (A:    220.22500000 ;B:      4.20422425 ;C:    200.76892247),
{65} (A:    208.65500000 ;B:      1.34516255 ;C:    625.67019231),
{66} (A:    207.66300000 ;B:      0.48349820 ;C:   1162.47470441),
{67} (A:    207.65900000 ;B:      1.28302219 ;C:     39.35687592),
{68} (A:    204.50000000 ;B:      6.01082207 ;C:    265.98929348),
{69} (A:    184.69000000 ;B:      3.50344405 ;C:    149.56319713),
{70} (A:    183.51100000 ;B:      0.97254953 ;C:      4.19278569),
{71} (A:    182.45400000 ;B:      5.49122292 ;C:      2.92076131),
{72} (A:    173.91400000 ;B:      1.86305807 ;C:      0.75075953),
{73} (A:    164.54100000 ;B:      0.44005518 ;C:      5.41662597),
{74} (A:    149.29900000 ;B:      5.73594350 ;C:     52.69019804),
{75} (A:    147.52600000 ;B:      1.53529321 ;C:      5.62907429),
{76} (A:    146.06800000 ;B:      6.23102544 ;C:    195.13984817),
{77} (A:    139.66600000 ;B:      4.29450260 ;C:     21.34064100),
{78} (A:    131.28300000 ;B:      4.06828962 ;C:     10.29494074),
{79} (A:    124.96900000 ;B:      6.27737806 ;C:   1898.35121794),
{80} (A:    122.37300000 ;B:      1.97588777 ;C:      4.66586645),
{81} (A:    118.15600000 ;B:      5.34072934 ;C:    554.06998748),
{82} (A:    117.28300000 ;B:      2.67920401 ;C:   1155.36115741),
{83} (A:    113.74700000 ;B:      5.59427545 ;C:   1059.38193019),
{84} (A:    112.43700000 ;B:      1.10502664 ;C:    191.20769491),
{85} (A:    110.39900000 ;B:      0.16604024 ;C:      1.48447271),
{86} (A:    109.27500000 ;B:      3.43812716 ;C:    536.80451210),
{87} (A:    106.57000000 ;B:      4.01156609 ;C:    956.28915597),
{88} (A:    103.95600000 ;B:      2.19210363 ;C:     88.86568022),
{89} (A:    102.70200000 ;B:      1.19748124 ;C:   1685.05212250),
{90} (A:    100.63100000 ;B:      4.96513667 ;C:    269.92144674));
{L1 -------------------------}
NL1=79;
L1:Array[1..NL1]  of TPlanTerm=(
{1} (A:21354295595.98600010 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:1296855.00500000 ;B:      1.82820545 ;C:    213.29909544),
{3} (A: 564347.56600000 ;B:      2.88500136 ;C:      7.11354700),
{4} (A: 107678.77000000 ;B:      2.27769912 ;C:    206.18554844),
{5} (A:  98323.03000000 ;B:      1.08070061 ;C:    426.59819088),
{6} (A:  40254.58600000 ;B:      2.04128257 ;C:    220.41264244),
{7} (A:  19941.73400000 ;B:      1.27954663 ;C:    103.09277422),
{8} (A:  10511.70600000 ;B:      2.74880393 ;C:     14.22709400),
{9} (A:   6939.23300000 ;B:      0.40493080 ;C:    639.89728631),
{10} (A:   4803.32500000 ;B:      2.44194098 ;C:    419.48464388),
{11} (A:   4056.32500000 ;B:      2.92166619 ;C:    110.20632122),
{12} (A:   3768.63000000 ;B:      3.64965631 ;C:      3.93215326),
{13} (A:   3384.68400000 ;B:      2.41694252 ;C:      3.18139374),
{14} (A:   3302.20000000 ;B:      1.26256487 ;C:    433.71173788),
{15} (A:   3071.38200000 ;B:      2.32739318 ;C:    199.07200144),
{16} (A:   1953.03600000 ;B:      3.56394683 ;C:     11.04570026),
{17} (A:   1249.34800000 ;B:      2.62803738 ;C:     95.97922722),
{18} (A:    921.68300000 ;B:      1.96089834 ;C:    227.52618944),
{19} (A:    705.58700000 ;B:      4.41689249 ;C:    529.69096509),
{20} (A:    649.65400000 ;B:      6.17418094 ;C:    202.25339517),
{21} (A:    627.60300000 ;B:      6.11088227 ;C:    309.27832266),
{22} (A:    486.84300000 ;B:      6.03998200 ;C:    853.19638175),
{23} (A:    478.50100000 ;B:      4.98776988 ;C:    522.57741809),
{24} (A:    468.37700000 ;B:      4.61707844 ;C:     63.73589830),
{25} (A:    417.01000000 ;B:      2.11708169 ;C:    323.50541666),
{26} (A:    407.63000000 ;B:      1.29949557 ;C:    209.36694217),
{27} (A:    352.48900000 ;B:      2.31707079 ;C:    632.78373931),
{28} (A:    343.82600000 ;B:      3.95854179 ;C:    412.37109687),
{29} (A:    339.72400000 ;B:      3.63396399 ;C:    316.39186966),
{30} (A:    335.93600000 ;B:      3.77173073 ;C:    735.87651353),
{31} (A:    331.93300000 ;B:      2.86077700 ;C:    210.11770170),
{32} (A:    289.42900000 ;B:      2.73263080 ;C:    117.31986822),
{33} (A:    280.91100000 ;B:      5.74398845 ;C:      2.44768055),
{34} (A:    265.80100000 ;B:      0.54344631 ;C:    647.01083331),
{35} (A:    230.49300000 ;B:      1.64428880 ;C:    216.48048918),
{36} (A:    191.66700000 ;B:      2.96512947 ;C:    224.34479570),
{37} (A:    172.89100000 ;B:      4.07695221 ;C:    846.08283475),
{38} (A:    167.13100000 ;B:      2.59745203 ;C:     21.34064100),
{39} (A:    136.32800000 ;B:      2.28580247 ;C:     10.29494074),
{40} (A:    131.36400000 ;B:      3.44108356 ;C:    742.99006053),
{41} (A:    127.83800000 ;B:      4.09533471 ;C:    217.23124870),
{42} (A:    108.86200000 ;B:      6.16141072 ;C:    415.55249061),
{43} (A:     97.58400000 ;B:      4.72845437 ;C:    838.96928775),
{44} (A:     93.90900000 ;B:      3.48397280 ;C:   1052.26838319),
{45} (A:     92.48200000 ;B:      3.94755500 ;C:     88.86568022),
{46} (A:     86.60000000 ;B:      1.21951325 ;C:    440.82528488),
{47} (A:     83.46300000 ;B:      3.11269505 ;C:    625.67019231),
{48} (A:     77.58800000 ;B:      6.24408939 ;C:    302.16477566),
{49} (A:     67.10600000 ;B:      0.28961739 ;C:      4.66586645),
{50} (A:     65.84300000 ;B:      5.64757043 ;C:      9.56122756),
{51} (A:     61.90000000 ;B:      4.29344363 ;C:    127.47179661),
{52} (A:     61.55700000 ;B:      1.82789613 ;C:    195.13984817),
{53} (A:     57.78000000 ;B:      2.47630552 ;C:    191.95845444),
{54} (A:     56.91900000 ;B:      5.01889578 ;C:    137.03302416),
{55} (A:     54.58500000 ;B:      0.28356341 ;C:     74.78159857),
{56} (A:     54.16000000 ;B:      5.12628572 ;C:    490.33408918),
{57} (A:     51.42500000 ;B:      1.45766406 ;C:    536.80451210),
{58} (A:     46.79900000 ;B:      1.17721211 ;C:    149.56319713),
{59} (A:     46.64900000 ;B:      5.14818327 ;C:    515.46387109),
{60} (A:     45.89100000 ;B:      2.23198879 ;C:    956.28915597),
{61} (A:     44.44400000 ;B:      2.70873628 ;C:      5.41662597),
{62} (A:     40.40000000 ;B:      0.41281520 ;C:    269.92144674),
{63} (A:     40.38000000 ;B:      3.88870106 ;C:    728.76296653),
{64} (A:     37.96900000 ;B:      0.64665967 ;C:    422.66603761),
{65} (A:     37.76800000 ;B:      2.53379014 ;C:     12.53017297),
{66} (A:     37.19100000 ;B:      3.78239026 ;C:      2.92076131),
{67} (A:     35.11600000 ;B:      6.08421794 ;C:      5.62907429),
{68} (A:     33.77800000 ;B:      3.21070688 ;C:   1368.66025285),
{69} (A:     33.21700000 ;B:      4.64063092 ;C:    277.03499374),
{70} (A:     33.05000000 ;B:      5.43038091 ;C:   1066.49547719),
{71} (A:     32.85700000 ;B:      0.30063885 ;C:    351.81659231),
{72} (A:     31.87600000 ;B:      4.38622924 ;C:   1155.36115741),
{73} (A:     31.32900000 ;B:      2.43455856 ;C:     52.69019804),
{74} (A:     30.27600000 ;B:      2.84067005 ;C:    203.00415470),
{75} (A:     30.08900000 ;B:      6.18684614 ;C:    284.14854074),
{76} (A:     29.66700000 ;B:      3.39052569 ;C:   1059.38193019),
{77} (A:     28.91300000 ;B:      2.02614761 ;C:    330.61896366),
{78} (A:     28.26400000 ;B:      2.74178954 ;C:    265.98929348),
{79} (A:     26.49300000 ;B:      4.51214170 ;C:    340.77089204));
{L2 -------------------------}
NL2=63;
L2:Array[1..NL2]  of TPlanTerm=(
{1} (A: 116441.18100000 ;B:      1.17987851 ;C:      7.11354700),
{2} (A:  91920.84400000 ;B:      0.07425261 ;C:    213.29909544),
{3} (A:  90592.25100000 ;B:      0.00000000 ;C:      0.00000000),
{4} (A:  15276.90900000 ;B:      4.06492008 ;C:    206.18554844),
{5} (A:  10631.39600000 ;B:      0.25778277 ;C:    220.41264244),
{6} (A:  10604.97900000 ;B:      5.40963596 ;C:    426.59819088),
{7} (A:   4265.36800000 ;B:      1.04595557 ;C:     14.22709400),
{8} (A:   1215.52700000 ;B:      2.91860042 ;C:    103.09277422),
{9} (A:   1164.68400000 ;B:      4.60942129 ;C:    639.89728631),
{10} (A:   1081.96700000 ;B:      5.69130352 ;C:    433.71173788),
{11} (A:   1044.75400000 ;B:      4.04206454 ;C:    199.07200144),
{12} (A:   1020.07900000 ;B:      0.63369183 ;C:      3.18139374),
{13} (A:    633.58200000 ;B:      4.38825410 ;C:    419.48464388),
{14} (A:    549.32900000 ;B:      5.57303134 ;C:      3.93215326),
{15} (A:    456.91400000 ;B:      1.26840971 ;C:    110.20632122),
{16} (A:    425.10000000 ;B:      0.20935499 ;C:    227.52618944),
{17} (A:    273.73900000 ;B:      4.28841012 ;C:     95.97922722),
{18} (A:    161.57100000 ;B:      1.38139149 ;C:     11.04570026),
{19} (A:    129.49400000 ;B:      1.56586884 ;C:    309.27832266),
{20} (A:    117.00800000 ;B:      3.88120916 ;C:    853.19638175),
{21} (A:    105.41500000 ;B:      4.90003204 ;C:    647.01083331),
{22} (A:    100.96700000 ;B:      0.89270493 ;C:     21.34064100),
{23} (A:     95.65900000 ;B:      2.91093562 ;C:    316.39186966),
{24} (A:     95.22700000 ;B:      5.62561151 ;C:    412.37109687),
{25} (A:     84.86000000 ;B:      5.73472778 ;C:    209.36694217),
{26} (A:     82.72700000 ;B:      6.05030935 ;C:    216.48048918),
{27} (A:     81.94800000 ;B:      1.02477558 ;C:    117.31986822),
{28} (A:     74.85700000 ;B:      4.76178468 ;C:    210.11770170),
{29} (A:     67.18400000 ;B:      0.45648613 ;C:    522.57741809),
{30} (A:     66.45900000 ;B:      0.48297941 ;C:     10.29494074),
{31} (A:     63.69600000 ;B:      0.35179805 ;C:    323.50541666),
{32} (A:     60.64700000 ;B:      4.87517850 ;C:    632.78373931),
{33} (A:     53.28100000 ;B:      2.74730541 ;C:    529.69096509),
{34} (A:     45.82700000 ;B:      5.69296622 ;C:    440.82528488),
{35} (A:     45.29300000 ;B:      1.66856700 ;C:    202.25339517),
{36} (A:     42.33000000 ;B:      5.70768188 ;C:     88.86568022),
{37} (A:     32.14000000 ;B:      0.07050050 ;C:     63.73589830),
{38} (A:     31.57300000 ;B:      1.67190022 ;C:    302.16477566),
{39} (A:     31.15000000 ;B:      4.16379538 ;C:    191.95845444),
{40} (A:     26.55800000 ;B:      0.83256214 ;C:    224.34479570),
{41} (A:     24.63100000 ;B:      5.65564729 ;C:    735.87651353),
{42} (A:     20.10800000 ;B:      5.94364610 ;C:    217.23124870),
{43} (A:     17.51100000 ;B:      4.90014737 ;C:    625.67019231),
{44} (A:     17.13000000 ;B:      1.62593421 ;C:    742.99006053),
{45} (A:     16.04000000 ;B:      0.57886321 ;C:    515.46387109),
{46} (A:     14.06800000 ;B:      0.20675294 ;C:    838.96928775),
{47} (A:     13.74400000 ;B:      3.76497167 ;C:    195.13984817),
{48} (A:     12.23600000 ;B:      4.71789724 ;C:    203.00415470),
{49} (A:     11.94000000 ;B:      0.12620714 ;C:    234.63973644),
{50} (A:     11.71800000 ;B:      3.12098484 ;C:    846.08283475),
{51} (A:     11.15400000 ;B:      5.92216845 ;C:    536.80451210),
{52} (A:     11.01300000 ;B:      5.60207983 ;C:    728.76296653),
{53} (A:     10.60100000 ;B:      3.20327613 ;C:   1066.49547719),
{54} (A:     10.24000000 ;B:      4.98736656 ;C:    422.66603761),
{55} (A:     10.07200000 ;B:      0.25709352 ;C:    330.61896366),
{56} (A:      9.96200000 ;B:      4.15472049 ;C:    860.30992875),
{57} (A:      9.49000000 ;B:      0.46379969 ;C:    956.28915597),
{58} (A:      8.28700000 ;B:      2.13990364 ;C:    269.92144674),
{59} (A:      7.73000000 ;B:      5.24602742 ;C:    429.77958461),
{60} (A:      7.55000000 ;B:      4.03401154 ;C:      9.56122756),
{61} (A:      7.23800000 ;B:      5.39724715 ;C:   1052.26838319),
{62} (A:      6.35300000 ;B:      4.46211131 ;C:    284.14854074),
{63} (A:      6.08200000 ;B:      5.93416925 ;C:    405.25754987));
{L3 -------------------------}
NL3=48;
L3:Array[1..NL3]  of TPlanTerm=(
{1} (A:  16038.73400000 ;B:      5.73945377 ;C:      7.11354700),
{2} (A:   4249.79300000 ;B:      4.58539676 ;C:    213.29909544),
{3} (A:   1906.52400000 ;B:      4.76082050 ;C:    220.41264244),
{4} (A:   1465.68700000 ;B:      5.91326678 ;C:    206.18554844),
{5} (A:   1162.04100000 ;B:      5.61973132 ;C:     14.22709400),
{6} (A:   1066.58100000 ;B:      3.60816533 ;C:    426.59819088),
{7} (A:    239.37700000 ;B:      3.86088273 ;C:    433.71173788),
{8} (A:    236.97500000 ;B:      5.76826451 ;C:    199.07200144),
{9} (A:    165.64100000 ;B:      5.11641150 ;C:      3.18139374),
{10} (A:    151.35200000 ;B:      2.73594642 ;C:    639.89728631),
{11} (A:    131.40900000 ;B:      4.74327545 ;C:    227.52618944),
{12} (A:     63.36500000 ;B:      0.22850089 ;C:    419.48464388),
{13} (A:     61.63000000 ;B:      4.74287052 ;C:    103.09277422),
{14} (A:     40.43700000 ;B:      5.47298059 ;C:     21.34064100),
{15} (A:     40.20500000 ;B:      5.96420267 ;C:     95.97922722),
{16} (A:     38.74600000 ;B:      5.83386200 ;C:    110.20632122),
{17} (A:     28.02500000 ;B:      3.01235312 ;C:    647.01083331),
{18} (A:     25.02900000 ;B:      0.98808171 ;C:      3.93215326),
{19} (A:     19.01400000 ;B:      1.91614237 ;C:    853.19638175),
{20} (A:     18.26200000 ;B:      4.96738416 ;C:     10.29494074),
{21} (A:     18.10100000 ;B:      1.02506397 ;C:    412.37109687),
{22} (A:     17.91900000 ;B:      4.20376505 ;C:    216.48048918),
{23} (A:     17.87900000 ;B:      3.31913419 ;C:    309.27832266),
{24} (A:     16.20800000 ;B:      3.89825273 ;C:    440.82528488),
{25} (A:     15.76300000 ;B:      5.61667810 ;C:    117.31986822),
{26} (A:     12.94700000 ;B:      1.18068954 ;C:     88.86568022),
{27} (A:     11.45300000 ;B:      5.57520615 ;C:     11.04570026),
{28} (A:     10.54800000 ;B:      5.92906266 ;C:    191.95845444),
{29} (A:     10.38900000 ;B:      3.94838737 ;C:    209.36694217),
{30} (A:      8.65000000 ;B:      3.39335370 ;C:    302.16477566),
{31} (A:      7.58000000 ;B:      4.87736913 ;C:    323.50541666),
{32} (A:      6.69700000 ;B:      0.38198726 ;C:    632.78373931),
{33} (A:      6.32700000 ;B:      2.25492723 ;C:    522.57741809),
{34} (A:      5.86400000 ;B:      1.05621158 ;C:    210.11770170),
{35} (A:      5.44900000 ;B:      4.64268475 ;C:    234.63973644),
{36} (A:      3.70100000 ;B:      3.14159265 ;C:      0.00000000),
{37} (A:      3.60200000 ;B:      2.30677011 ;C:    515.46387109),
{38} (A:      3.22900000 ;B:      2.20309400 ;C:    860.30992875),
{39} (A:      2.85000000 ;B:      0.58604395 ;C:    529.69096509),
{40} (A:      2.58300000 ;B:      4.93447677 ;C:    224.34479570),
{41} (A:      2.54300000 ;B:      0.42393884 ;C:    625.67019231),
{42} (A:      2.42100000 ;B:      4.76621392 ;C:    330.61896366),
{43} (A:      2.29600000 ;B:      3.34809166 ;C:    429.77958461),
{44} (A:      2.21300000 ;B:      3.19814958 ;C:    202.25339517),
{45} (A:      2.19400000 ;B:      1.18918501 ;C:   1066.49547719),
{46} (A:      2.15400000 ;B:      1.35488209 ;C:    405.25754987),
{47} (A:      2.09000000 ;B:      4.15631351 ;C:    223.59403618),
{48} (A:      2.01800000 ;B:      3.06693570 ;C:    654.12438032));
{L4 -------------------------}
NL4=27;
L4:Array[1..NL4]  of TPlanTerm=(
{1} (A:   1661.89400000 ;B:      3.99826249 ;C:      7.11354700),
{2} (A:    257.10700000 ;B:      2.98436499 ;C:    220.41264244),
{3} (A:    236.34400000 ;B:      3.90241428 ;C:     14.22709400),
{4} (A:    149.41800000 ;B:      2.74110824 ;C:    213.29909544),
{5} (A:    113.95300000 ;B:      3.14159265 ;C:      0.00000000),
{6} (A:    109.59800000 ;B:      1.51515739 ;C:    206.18554844),
{7} (A:     68.39000000 ;B:      1.72120953 ;C:    426.59819088),
{8} (A:     40.06000000 ;B:      2.04644897 ;C:    433.71173788),
{9} (A:     37.69900000 ;B:      1.23795458 ;C:    199.07200144),
{10} (A:     31.21900000 ;B:      3.01094184 ;C:    227.52618944),
{11} (A:     15.11100000 ;B:      0.82897065 ;C:    639.89728631),
{12} (A:      9.44400000 ;B:      3.71485301 ;C:     21.34064100),
{13} (A:      5.69000000 ;B:      2.41995291 ;C:    419.48464388),
{14} (A:      5.60800000 ;B:      1.15607096 ;C:    647.01083331),
{15} (A:      4.47000000 ;B:      1.45120819 ;C:     95.97922722),
{16} (A:      4.46300000 ;B:      2.11783225 ;C:    440.82528488),
{17} (A:      3.22900000 ;B:      4.09278078 ;C:    110.20632122),
{18} (A:      2.87100000 ;B:      2.77203154 ;C:    412.37109687),
{19} (A:      2.79600000 ;B:      3.00730250 ;C:     88.86568022),
{20} (A:      2.63800000 ;B:      0.00255721 ;C:    853.19638175),
{21} (A:      2.57400000 ;B:      0.39246854 ;C:    103.09277422),
{22} (A:      2.22500000 ;B:      3.77689198 ;C:    117.31986822),
{23} (A:      1.92100000 ;B:      2.82884329 ;C:    234.63973644),
{24} (A:      1.86200000 ;B:      5.07955458 ;C:    309.27832266),
{25} (A:      1.80500000 ;B:      2.23816037 ;C:    216.48048918),
{26} (A:      1.76900000 ;B:      5.19176876 ;C:    302.16477566),
{27} (A:      1.21100000 ;B:      1.54685247 ;C:    191.95845444));
{L5 -------------------------}
NL5=12;
L5:Array[1..NL5]  of TPlanTerm=(
{1} (A:    123.61500000 ;B:      2.25923346 ;C:      7.11354700),
{2} (A:     34.19000000 ;B:      2.16250653 ;C:     14.22709400),
{3} (A:     27.54600000 ;B:      1.19868150 ;C:    220.41264244),
{4} (A:      5.81800000 ;B:      1.21584270 ;C:    227.52618944),
{5} (A:      5.31800000 ;B:      0.23550400 ;C:    433.71173788),
{6} (A:      3.67700000 ;B:      6.22669694 ;C:    426.59819088),
{7} (A:      3.05700000 ;B:      2.97372046 ;C:    199.07200144),
{8} (A:      2.86100000 ;B:      4.28710933 ;C:    206.18554844),
{9} (A:      1.61700000 ;B:      6.25265362 ;C:    213.29909544),
{10} (A:      1.27900000 ;B:      5.27612561 ;C:    639.89728631),
{11} (A:      1.03800000 ;B:      0.23516952 ;C:    440.82528488),
{12} (A:      1.00700000 ;B:      3.14159265 ;C:      0.00000000));
{Termos de B =========================}
{B0 -------------------------}
NB0=34;
B0:Array[1..NB0]  of TPlanTerm=(
{1} (A:4330678.04000000 ;B:      3.60284428 ;C:    213.29909544),
{2} (A: 240348.30300000 ;B:      2.85238489 ;C:    426.59819088),
{3} (A:  84745.93900000 ;B:      0.00000000 ;C:      0.00000000),
{4} (A:  34116.06300000 ;B:      0.57297308 ;C:    206.18554844),
{5} (A:  30863.35700000 ;B:      3.48441504 ;C:    220.41264244),
{6} (A:  14734.07000000 ;B:      2.11846598 ;C:    639.89728631),
{7} (A:   9916.66800000 ;B:      5.79003189 ;C:    419.48464388),
{8} (A:   6993.56400000 ;B:      4.73604689 ;C:      7.11354700),
{9} (A:   4807.58700000 ;B:      5.43305316 ;C:    316.39186966),
{10} (A:   4788.39200000 ;B:      4.96512927 ;C:    110.20632122),
{11} (A:   3432.12500000 ;B:      2.73255752 ;C:    433.71173788),
{12} (A:   1506.12900000 ;B:      6.01304536 ;C:    103.09277422),
{13} (A:   1060.29800000 ;B:      5.63099292 ;C:    529.69096509),
{14} (A:    969.07100000 ;B:      5.20434966 ;C:    632.78373931),
{15} (A:    942.05000000 ;B:      1.39646678 ;C:    853.19638175),
{16} (A:    707.64500000 ;B:      3.80302330 ;C:    323.50541666),
{17} (A:    552.31300000 ;B:      5.13149109 ;C:    202.25339517),
{18} (A:    399.67500000 ;B:      3.35891414 ;C:    227.52618944),
{19} (A:    319.38000000 ;B:      3.62571551 ;C:    209.36694217),
{20} (A:    316.06300000 ;B:      1.99716764 ;C:    647.01083331),
{21} (A:    314.22500000 ;B:      0.46510272 ;C:    217.23124870),
{22} (A:    284.49400000 ;B:      4.88648482 ;C:    224.34479570),
{23} (A:    236.44200000 ;B:      2.13887472 ;C:     11.04570026),
{24} (A:    215.35400000 ;B:      5.94982610 ;C:    846.08283475),
{25} (A:    208.52200000 ;B:      2.12003894 ;C:    415.55249061),
{26} (A:    207.21300000 ;B:      0.73021463 ;C:    199.07200144),
{27} (A:    178.95800000 ;B:      2.95361515 ;C:     63.73589830),
{28} (A:    140.58500000 ;B:      0.64417620 ;C:    490.33408918),
{29} (A:    139.24000000 ;B:      4.59535168 ;C:     14.22709400),
{30} (A:    139.14000000 ;B:      1.99821991 ;C:    735.87651353),
{31} (A:    134.88400000 ;B:      5.24500820 ;C:    742.99006053),
{32} (A:    121.66900000 ;B:      3.11537141 ;C:    522.57741809),
{33} (A:    115.52400000 ;B:      3.10891547 ;C:    216.48048918),
{34} (A:    114.21800000 ;B:      0.96261442 ;C:    210.11770170));
{B1 -------------------------}
NB1=32;
B1:Array[1..NB1]  of TPlanTerm=(
{1} (A: 397554.99800000 ;B:      5.33289993 ;C:    213.29909544),
{2} (A:  49478.64100000 ;B:      3.14159265 ;C:      0.00000000),
{3} (A:  18571.60700000 ;B:      6.09919206 ;C:    426.59819088),
{4} (A:  14800.58700000 ;B:      2.30586061 ;C:    206.18554844),
{5} (A:   9643.98100000 ;B:      1.69674660 ;C:    220.41264244),
{6} (A:   3757.16100000 ;B:      1.25429514 ;C:    419.48464388),
{7} (A:   2716.64700000 ;B:      5.91166665 ;C:    639.89728631),
{8} (A:   1455.30900000 ;B:      0.85161617 ;C:    433.71173788),
{9} (A:   1290.59500000 ;B:      2.91770857 ;C:      7.11354700),
{10} (A:    852.63000000 ;B:      0.43572079 ;C:    316.39186966),
{11} (A:    297.72600000 ;B:      0.91909207 ;C:    632.78373931),
{12} (A:    292.18500000 ;B:      5.31574251 ;C:    853.19638175),
{13} (A:    284.38600000 ;B:      1.61881755 ;C:    227.52618944),
{14} (A:    275.09000000 ;B:      3.88864137 ;C:    103.09277422),
{15} (A:    172.35900000 ;B:      0.05215147 ;C:    647.01083331),
{16} (A:    166.23700000 ;B:      2.44351613 ;C:    199.07200144),
{17} (A:    158.22000000 ;B:      5.20850126 ;C:    110.20632122),
{18} (A:    127.73100000 ;B:      1.20711453 ;C:    529.69096509),
{19} (A:    109.83900000 ;B:      2.45695552 ;C:    217.23124870),
{20} (A:     81.75900000 ;B:      2.75839171 ;C:    210.11770170),
{21} (A:     81.01000000 ;B:      2.86038377 ;C:     14.22709400),
{22} (A:     68.65800000 ;B:      1.65537623 ;C:    202.25339517),
{23} (A:     65.16100000 ;B:      1.25527521 ;C:    216.48048918),
{24} (A:     61.02400000 ;B:      1.25273412 ;C:    209.36694217),
{25} (A:     59.28100000 ;B:      1.82410768 ;C:    323.50541666),
{26} (A:     46.38600000 ;B:      0.81534705 ;C:    440.82528488),
{27} (A:     36.16300000 ;B:      1.81851058 ;C:    224.34479570),
{28} (A:     34.04100000 ;B:      2.83971298 ;C:    117.31986822),
{29} (A:     33.11400000 ;B:      1.30557080 ;C:    412.37109687),
{30} (A:     32.16400000 ;B:      1.18676132 ;C:    846.08283475),
{31} (A:     27.28200000 ;B:      4.64744848 ;C:   1066.49547719),
{32} (A:     27.12800000 ;B:      4.44228739 ;C:     11.04570026));
{B2 -------------------------}
NB2=29;
B2:Array[1..NB2]  of TPlanTerm=(
{1} (A:  20629.97700000 ;B:      0.50482423 ;C:    213.29909544),
{2} (A:   3719.55500000 ;B:      3.99833476 ;C:    206.18554844),
{3} (A:   1627.15800000 ;B:      6.18189940 ;C:    220.41264244),
{4} (A:   1346.06700000 ;B:      0.00000000 ;C:      0.00000000),
{5} (A:    705.84200000 ;B:      3.03914309 ;C:    419.48464388),
{6} (A:    365.04200000 ;B:      5.09928681 ;C:    426.59819088),
{7} (A:    329.63200000 ;B:      5.27899210 ;C:    433.71173788),
{8} (A:    219.33500000 ;B:      3.82841534 ;C:    639.89728631),
{9} (A:    139.39300000 ;B:      1.04272623 ;C:      7.11354700),
{10} (A:    103.98000000 ;B:      6.15730993 ;C:    227.52618944),
{11} (A:     92.96100000 ;B:      1.97994413 ;C:    316.39186966),
{12} (A:     71.24200000 ;B:      4.14754353 ;C:    199.07200144),
{13} (A:     51.92700000 ;B:      2.88364834 ;C:    632.78373931),
{14} (A:     48.96100000 ;B:      4.43390207 ;C:    647.01083331),
{15} (A:     41.37300000 ;B:      3.15927770 ;C:    853.19638175),
{16} (A:     28.60200000 ;B:      4.52978328 ;C:    210.11770170),
{17} (A:     23.96900000 ;B:      1.11595912 ;C:     14.22709400),
{18} (A:     20.51100000 ;B:      4.35095844 ;C:    217.23124870),
{19} (A:     19.53200000 ;B:      5.30779711 ;C:    440.82528488),
{20} (A:     18.26300000 ;B:      0.85391477 ;C:    110.20632122),
{21} (A:     16.84000000 ;B:      5.68112084 ;C:    216.48048918),
{22} (A:     15.74200000 ;B:      4.25767226 ;C:    103.09277422),
{23} (A:     13.61300000 ;B:      2.99904334 ;C:    412.37109687),
{24} (A:     11.56700000 ;B:      2.52679928 ;C:    529.69096509),
{25} (A:      7.96300000 ;B:      3.31512424 ;C:    202.25339517),
{26} (A:      6.64800000 ;B:      5.55714130 ;C:    209.36694217),
{27} (A:      6.59900000 ;B:      0.28766025 ;C:    323.50541666),
{28} (A:      6.31200000 ;B:      1.16121321 ;C:    117.31986822),
{29} (A:      6.19200000 ;B:      3.61231887 ;C:    860.30992875));
{B3 -------------------------}
NB3=21;
B3:Array[1..NB3]  of TPlanTerm=(
{1} (A:    666.25200000 ;B:      1.99006340 ;C:    213.29909544),
{2} (A:    632.35000000 ;B:      5.69778317 ;C:    206.18554844),
{3} (A:    398.05100000 ;B:      0.00000000 ;C:      0.00000000),
{4} (A:    187.83800000 ;B:      4.33779805 ;C:    220.41264244),
{5} (A:     91.88400000 ;B:      4.84104208 ;C:    419.48464388),
{6} (A:     51.54800000 ;B:      3.42149490 ;C:    433.71173788),
{7} (A:     42.36900000 ;B:      2.38073239 ;C:    426.59819088),
{8} (A:     25.66100000 ;B:      4.40167213 ;C:    227.52618944),
{9} (A:     20.55100000 ;B:      5.85313510 ;C:    199.07200144),
{10} (A:     18.08100000 ;B:      1.99321433 ;C:    639.89728631),
{11} (A:     10.87400000 ;B:      5.37344547 ;C:      7.11354700),
{12} (A:      9.59000000 ;B:      2.54901826 ;C:    647.01083331),
{13} (A:      7.08500000 ;B:      3.45518373 ;C:    316.39186966),
{14} (A:      6.00200000 ;B:      4.80055225 ;C:    632.78373931),
{15} (A:      5.77800000 ;B:      0.01680379 ;C:    210.11770170),
{16} (A:      5.54200000 ;B:      3.51756748 ;C:    440.82528488),
{17} (A:      4.88100000 ;B:      5.63719731 ;C:     14.22709400),
{18} (A:      4.50100000 ;B:      1.22424419 ;C:    853.19638175),
{19} (A:      3.54800000 ;B:      4.71299371 ;C:    412.37109687),
{20} (A:      2.85100000 ;B:      0.62679208 ;C:    103.09277422),
{21} (A:      2.17300000 ;B:      3.71982274 ;C:    216.48048918));
{B4 -------------------------}
NB4=12;
B4:Array[1..NB4]  of TPlanTerm=(
{1} (A:     80.38400000 ;B:      1.11918415 ;C:    206.18554844),
{2} (A:     31.66000000 ;B:      3.12218745 ;C:    213.29909544),
{3} (A:     17.14300000 ;B:      2.48073200 ;C:    220.41264244),
{4} (A:     11.84400000 ;B:      3.14159265 ;C:      0.00000000),
{5} (A:      9.00500000 ;B:      0.38441425 ;C:    419.48464388),
{6} (A:      6.16400000 ;B:      1.56186380 ;C:    433.71173788),
{7} (A:      4.77500000 ;B:      2.63498295 ;C:    227.52618944),
{8} (A:      4.66000000 ;B:      1.28235640 ;C:    199.07200144),
{9} (A:      1.48700000 ;B:      1.43096672 ;C:    426.59819088),
{10} (A:      1.42400000 ;B:      0.66988084 ;C:    647.01083331),
{11} (A:      1.14500000 ;B:      1.72041928 ;C:    440.82528488),
{12} (A:      1.07500000 ;B:      6.18092274 ;C:    639.89728631));
{B5 -------------------------}
NB5=2;
B5:Array[1..NB5]  of TPlanTerm=(
{1} (A:      7.89500000 ;B:      2.81927559 ;C:    206.18554844),
{2} (A:      1.01400000 ;B:      0.51187210 ;C:    220.41264244));
{Termos de R =========================}
{R0 -------------------------}
NR0=44;
R0:Array[1..NR0]  of TPlanTerm=(
{1} (A:955758135.80099988 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:52921382.46500000 ;B:      2.39226220 ;C:    213.29909544),
{3} (A:1873679.93400000 ;B:      5.23549605 ;C:    206.18554844),
{4} (A:1464663.95900000 ;B:      1.64763045 ;C:    426.59819088),
{5} (A: 821891.05900000 ;B:      5.93520025 ;C:    316.39186966),
{6} (A: 547506.89900000 ;B:      5.01532628 ;C:    103.09277422),
{7} (A: 371684.44900000 ;B:      2.27114833 ;C:    220.41264244),
{8} (A: 361778.43300000 ;B:      3.13904303 ;C:      7.11354700),
{9} (A: 140617.54800000 ;B:      5.70406653 ;C:    632.78373931),
{10} (A: 108974.73700000 ;B:      3.29313596 ;C:    110.20632122),
{11} (A:  69007.01500000 ;B:      5.94099622 ;C:    419.48464388),
{12} (A:  61053.35000000 ;B:      0.94037761 ;C:    639.89728631),
{13} (A:  48913.04400000 ;B:      1.55733388 ;C:    202.25339517),
{14} (A:  34143.79400000 ;B:      0.19518551 ;C:    277.03499374),
{15} (A:  32401.71800000 ;B:      5.47084607 ;C:    949.17560897),
{16} (A:  20936.57300000 ;B:      0.46349164 ;C:    735.87651353),
{17} (A:  20839.11800000 ;B:      1.52102591 ;C:    433.71173788),
{18} (A:  20746.67800000 ;B:      5.33255668 ;C:    199.07200144),
{19} (A:  15298.45700000 ;B:      3.05943653 ;C:    529.69096509),
{20} (A:  14296.47900000 ;B:      2.60433538 ;C:    323.50541666),
{21} (A:  12884.12800000 ;B:      1.64892310 ;C:    138.51749687),
{22} (A:  11993.31400000 ;B:      5.98051422 ;C:    846.08283475),
{23} (A:  11380.26100000 ;B:      1.73105747 ;C:    522.57741809),
{24} (A:   9796.06100000 ;B:      5.20475864 ;C:   1265.56747863),
{25} (A:   7752.76900000 ;B:      5.85191319 ;C:     95.97922722),
{26} (A:   6770.62100000 ;B:      3.00433479 ;C:     14.22709400),
{27} (A:   6465.96700000 ;B:      0.17733160 ;C:   1052.26838319),
{28} (A:   5850.44300000 ;B:      1.45519636 ;C:    415.55249061),
{29} (A:   5307.48100000 ;B:      0.59737534 ;C:     63.73589830),
{30} (A:   4695.74600000 ;B:      2.14919037 ;C:    227.52618944),
{31} (A:   4043.98800000 ;B:      1.64010324 ;C:    209.36694217),
{32} (A:   3688.13200000 ;B:      0.78016133 ;C:    412.37109687),
{33} (A:   3460.94300000 ;B:      1.85088803 ;C:    175.16605980),
{34} (A:   3419.55100000 ;B:      4.94549149 ;C:   1581.95934828),
{35} (A:   3400.61600000 ;B:      0.55386748 ;C:    350.33211960),
{36} (A:   3376.45700000 ;B:      3.69528479 ;C:    224.34479570),
{37} (A:   2976.03300000 ;B:      5.68467931 ;C:    210.11770170),
{38} (A:   2885.34800000 ;B:      1.38764078 ;C:    838.96928775),
{39} (A:   2881.18100000 ;B:      0.17960758 ;C:    853.19638175),
{40} (A:   2507.63000000 ;B:      3.53851863 ;C:    742.99006053),
{41} (A:   2448.32500000 ;B:      6.18412386 ;C:   1368.66025285),
{42} (A:   2406.13800000 ;B:      2.96559220 ;C:    117.31986822),
{43} (A:   2173.95900000 ;B:      0.01508587 ;C:    340.77089204),
{44} (A:   2024.48300000 ;B:      5.05411271 ;C:     11.04570026));
{R1 -------------------------}
NR1=38;
R1:Array[1..NR1]  of TPlanTerm=(
{1} (A:6182981.28200000 ;B:      0.25843515 ;C:    213.29909544),
{2} (A: 506577.57400000 ;B:      0.71114651 ;C:    206.18554844),
{3} (A: 341394.13600000 ;B:      5.79635774 ;C:    426.59819088),
{4} (A: 188491.37500000 ;B:      0.47215719 ;C:    220.41264244),
{5} (A: 186261.54000000 ;B:      3.14159265 ;C:      0.00000000),
{6} (A: 143891.17600000 ;B:      1.40744864 ;C:      7.11354700),
{7} (A:  49621.11100000 ;B:      6.01744470 ;C:    103.09277422),
{8} (A:  20928.18900000 ;B:      5.09245654 ;C:    639.89728631),
{9} (A:  19952.61200000 ;B:      1.17560125 ;C:    419.48464388),
{10} (A:  18839.63900000 ;B:      1.60819563 ;C:    110.20632122),
{11} (A:  13876.56500000 ;B:      0.75886204 ;C:    199.07200144),
{12} (A:  12892.82700000 ;B:      5.94330258 ;C:    433.71173788),
{13} (A:   5396.69900000 ;B:      1.28852406 ;C:     14.22709400),
{14} (A:   4869.30800000 ;B:      0.86793894 ;C:    323.50541666),
{15} (A:   4247.45500000 ;B:      0.39299385 ;C:    227.52618944),
{16} (A:   3252.08400000 ;B:      1.25853470 ;C:     95.97922722),
{17} (A:   3081.40800000 ;B:      3.43662557 ;C:    522.57741809),
{18} (A:   2909.41100000 ;B:      4.60679155 ;C:    202.25339517),
{19} (A:   2856.00600000 ;B:      2.16731405 ;C:    735.87651353),
{20} (A:   1987.68900000 ;B:      2.45054205 ;C:    412.37109687),
{21} (A:   1941.30900000 ;B:      6.02393385 ;C:    209.36694217),
{22} (A:   1581.44600000 ;B:      1.29191790 ;C:    210.11770170),
{23} (A:   1339.51100000 ;B:      4.30801822 ;C:    853.19638175),
{24} (A:   1315.59000000 ;B:      1.25296446 ;C:    117.31986822),
{25} (A:   1203.08500000 ;B:      1.86654674 ;C:    316.39186966),
{26} (A:   1091.08800000 ;B:      0.07527247 ;C:    216.48048918),
{27} (A:    966.01200000 ;B:      0.47991379 ;C:    632.78373931),
{28} (A:    954.40300000 ;B:      5.15173411 ;C:    647.01083331),
{29} (A:    897.51200000 ;B:      0.98343776 ;C:    529.69096509),
{30} (A:    881.82700000 ;B:      1.88471724 ;C:   1052.26838319),
{31} (A:    874.21500000 ;B:      1.40224684 ;C:    224.34479570),
{32} (A:    784.86600000 ;B:      3.06377517 ;C:    838.96928775),
{33} (A:    739.89200000 ;B:      1.38225357 ;C:    625.67019231),
{34} (A:    658.21000000 ;B:      4.14362931 ;C:    309.27832266),
{35} (A:    649.60000000 ;B:      1.72489486 ;C:    742.99006053),
{36} (A:    612.96100000 ;B:      3.03307307 ;C:     63.73589830),
{37} (A:    599.23600000 ;B:      2.54924175 ;C:    217.23124870),
{38} (A:    502.88600000 ;B:      2.12958819 ;C:      3.93215326));
{R2 -------------------------}
NR2=32;
R2:Array[1..NR2]  of TPlanTerm=(
{1} (A: 436902.46400000 ;B:      4.78671673 ;C:    213.29909544),
{2} (A:  71922.76000000 ;B:      2.50069995 ;C:    206.18554844),
{3} (A:  49766.79200000 ;B:      4.97168151 ;C:    220.41264244),
{4} (A:  43220.89400000 ;B:      3.86940444 ;C:    426.59819088),
{5} (A:  29645.55400000 ;B:      5.96310264 ;C:      7.11354700),
{6} (A:   4720.90900000 ;B:      2.47527992 ;C:    199.07200144),
{7} (A:   4141.65000000 ;B:      4.10670941 ;C:    433.71173788),
{8} (A:   3789.37000000 ;B:      3.09771025 ;C:    639.89728631),
{9} (A:   2963.99000000 ;B:      1.37206249 ;C:    103.09277422),
{10} (A:   2556.36300000 ;B:      2.85065722 ;C:    419.48464388),
{11} (A:   2326.80100000 ;B:      0.00000000 ;C:      0.00000000),
{12} (A:   2208.45700000 ;B:      6.27588859 ;C:    110.20632122),
{13} (A:   2187.62100000 ;B:      5.85545832 ;C:     14.22709400),
{14} (A:   1956.89600000 ;B:      4.92448618 ;C:    227.52618944),
{15} (A:    923.84000000 ;B:      5.46392423 ;C:    323.50541666),
{16} (A:    705.93600000 ;B:      2.97081280 ;C:     95.97922722),
{17} (A:    546.11500000 ;B:      4.12854182 ;C:    412.37109687),
{18} (A:    431.48500000 ;B:      5.17825415 ;C:    522.57741809),
{19} (A:    405.01800000 ;B:      4.17294158 ;C:    209.36694217),
{20} (A:    390.62700000 ;B:      4.48106177 ;C:    216.48048918),
{21} (A:    373.83800000 ;B:      5.83435992 ;C:    117.31986822),
{22} (A:    360.88200000 ;B:      3.27703082 ;C:    647.01083331),
{23} (A:    356.35000000 ;B:      3.19152044 ;C:    210.11770170),
{24} (A:    325.59800000 ;B:      2.26867602 ;C:    853.19638175),
{25} (A:    206.85400000 ;B:      4.02188337 ;C:    735.87651353),
{26} (A:    204.49400000 ;B:      0.08774849 ;C:    202.25339517),
{27} (A:    180.14300000 ;B:      3.59704904 ;C:    632.78373931),
{28} (A:    178.47400000 ;B:      4.09716541 ;C:    440.82528488),
{29} (A:    153.65600000 ;B:      3.13470530 ;C:    625.67019231),
{30} (A:    147.77900000 ;B:      0.13614301 ;C:    302.16477566),
{31} (A:    133.07600000 ;B:      2.59350469 ;C:    191.95845444),
{32} (A:    131.97500000 ;B:      5.93293969 ;C:    309.27832266));
{R3 -------------------------}
NR3=28;
R3:Array[1..NR3]  of TPlanTerm=(
{1} (A:  20315.00500000 ;B:      3.02186626 ;C:    213.29909544),
{2} (A:   8923.58100000 ;B:      3.19144206 ;C:    220.41264244),
{3} (A:   6908.67700000 ;B:      4.35174889 ;C:    206.18554844),
{4} (A:   4087.12900000 ;B:      4.22406927 ;C:      7.11354700),
{5} (A:   3879.04100000 ;B:      2.01056446 ;C:    426.59819088),
{6} (A:   1070.78800000 ;B:      4.20360341 ;C:    199.07200144),
{7} (A:    907.33200000 ;B:      2.28344368 ;C:    433.71173788),
{8} (A:    606.12100000 ;B:      3.17458571 ;C:    227.52618944),
{9} (A:    596.63900000 ;B:      4.13455753 ;C:     14.22709400),
{10} (A:    483.18100000 ;B:      1.17345973 ;C:    639.89728631),
{11} (A:    393.17400000 ;B:      0.00000000 ;C:      0.00000000),
{12} (A:    229.47200000 ;B:      4.69838526 ;C:    419.48464388),
{13} (A:    188.25000000 ;B:      4.59003889 ;C:    110.20632122),
{14} (A:    149.50800000 ;B:      3.20199444 ;C:    103.09277422),
{15} (A:    121.44200000 ;B:      3.76831374 ;C:    323.50541666),
{16} (A:    102.14600000 ;B:      4.70974423 ;C:     95.97922722),
{17} (A:    101.21500000 ;B:      5.81884138 ;C:    412.37109687),
{18} (A:     93.07800000 ;B:      1.43531271 ;C:    647.01083331),
{19} (A:     84.34700000 ;B:      2.63462380 ;C:    216.48048918),
{20} (A:     72.60100000 ;B:      4.15395599 ;C:    117.31986822),
{21} (A:     62.19800000 ;B:      2.31239346 ;C:    440.82528488),
{22} (A:     54.82900000 ;B:      0.30526468 ;C:    853.19638175),
{23} (A:     49.53600000 ;B:      2.38854233 ;C:    209.36694217),
{24} (A:     45.14500000 ;B:      4.37317047 ;C:    191.95845444),
{25} (A:     40.67100000 ;B:      0.68845183 ;C:    522.57741809),
{26} (A:     40.49800000 ;B:      1.83836570 ;C:    302.16477566),
{27} (A:     38.08900000 ;B:      5.94455116 ;C:     88.86568022),
{28} (A:     32.24300000 ;B:      4.01146349 ;C:     21.34064100));
{R4 -------------------------}
NR4=23;
R4:Array[1..NR4]  of TPlanTerm=(
{1} (A:   1202.05000000 ;B:      1.41499446 ;C:    220.41264244),
{2} (A:    707.79600000 ;B:      1.16153570 ;C:    213.29909544),
{3} (A:    516.12100000 ;B:      6.23973568 ;C:    206.18554844),
{4} (A:    426.66400000 ;B:      2.46924890 ;C:      7.11354700),
{5} (A:    267.73600000 ;B:      0.18659207 ;C:    426.59819088),
{6} (A:    170.17100000 ;B:      5.95926972 ;C:    199.07200144),
{7} (A:    150.33900000 ;B:      0.47970167 ;C:    433.71173788),
{8} (A:    145.11300000 ;B:      1.44211060 ;C:    227.52618944),
{9} (A:    121.03300000 ;B:      2.40527321 ;C:     14.22709400),
{10} (A:     47.33200000 ;B:      5.56857489 ;C:    639.89728631),
{11} (A:     18.95400000 ;B:      5.85626429 ;C:    647.01083331),
{12} (A:     16.66800000 ;B:      0.52920774 ;C:    440.82528488),
{13} (A:     15.74500000 ;B:      2.90112466 ;C:    110.20632122),
{14} (A:     14.72400000 ;B:      0.29905317 ;C:    419.48464388),
{15} (A:     14.07400000 ;B:      1.30343551 ;C:    412.37109687),
{16} (A:     12.70800000 ;B:      2.09349306 ;C:    323.50541666),
{17} (A:     11.32000000 ;B:      0.21785507 ;C:     95.97922722),
{18} (A:     11.13300000 ;B:      2.46304826 ;C:    117.31986822),
{19} (A:      9.55200000 ;B:      3.14159265 ;C:      0.00000000),
{20} (A:      9.24600000 ;B:      1.56496313 ;C:     88.86568022),
{21} (A:      9.23300000 ;B:      2.28127318 ;C:     21.34064100),
{22} (A:      8.97000000 ;B:      0.68301278 ;C:    216.48048918),
{23} (A:      8.36000000 ;B:      1.27239488 ;C:    234.63973644));
{R5 -------------------------}
NR5=18;
R5:Array[1..NR5]  of TPlanTerm=(
{1} (A:    128.61200000 ;B:      5.91282565 ;C:    220.41264244),
{2} (A:     32.27300000 ;B:      0.69256229 ;C:      7.11354700),
{3} (A:     26.69800000 ;B:      5.91428529 ;C:    227.52618944),
{4} (A:     20.22300000 ;B:      4.95136802 ;C:    433.71173788),
{5} (A:     19.92300000 ;B:      0.67370653 ;C:     14.22709400),
{6} (A:     14.09700000 ;B:      2.67074280 ;C:    206.18554844),
{7} (A:     13.53700000 ;B:      1.45669521 ;C:    199.07200144),
{8} (A:     13.36400000 ;B:      4.58826996 ;C:    426.59819088),
{9} (A:      7.25700000 ;B:      4.62966127 ;C:    213.29909544),
{10} (A:      4.87600000 ;B:      3.61448275 ;C:    639.89728631),
{11} (A:      3.75900000 ;B:      4.89624165 ;C:    440.82528488),
{12} (A:      3.30300000 ;B:      4.07190860 ;C:    647.01083331),
{13} (A:      3.13600000 ;B:      4.65661022 ;C:    191.95845444),
{14} (A:      2.91700000 ;B:      0.48665273 ;C:    323.50541666),
{15} (A:      2.88300000 ;B:      3.18003019 ;C:    419.48464388),
{16} (A:      2.33800000 ;B:      3.69553554 ;C:     88.86568022),
{17} (A:      2.05200000 ;B:      3.31663577 ;C:     95.97922722),
{18} (A:      2.02800000 ;B:      0.56025553 ;C:    117.31986822));

CSaturn:RPlanConsts=(
  NLTermos:(NL0,NL1,NL2,NL3,NL4,NL5);
  NBTermos:(NB0,NB1,NB2,NB3,NB4,NB5);
  NRTermos:(NR0,NR1,NR2,NR3,NR4,NR5);
  LTermos:(@L0,@L1,@L2,@L3,@L4,@L5);
  BTermos:(@B0,@B1,@B2,@B3,@B4,@B5);
  RTermos:(@R0,@R1,@R2,@R3,@R4,@R5));

implementation

end.
