Unit VSOP87.Venus;  //---------
 //----------------//
// VSOP87 = Variations Seculaires des Orbiotes Planetaires 1987
//    by Bretagnon and Francou - Bureau des Longitudes of Paris
//
// calculates planet's ecliptical Lon,Lat and Radius ( R from the Sun )
// This method is described in J.Meeus book "Astronomical Algorithms" - Chapter 32
// used as basis for this code.

Interface

uses  VSOP87.PlanetDef;
const
{Termos de L =========================}
{L0 -------------------------}
NL0=24;
L0:Array[1..NL0]  of TPlanTerm=(
{1} (A:317614666.77399999 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:1353968.41900000 ;B:      5.59313320 ;C:  10213.28554621),
{3} (A:  89891.64500000 ;B:      5.30650048 ;C:  20426.57109242),
{4} (A:   5477.20100000 ;B:      4.41630653 ;C:   7860.41939244),
{5} (A:   3455.73200000 ;B:      2.69964471 ;C:  11790.62908866),
{6} (A:   2372.06100000 ;B:      2.99377540 ;C:   3930.20969622),
{7} (A:   1664.06900000 ;B:      4.25018935 ;C:   1577.34354245),
{8} (A:   1438.32200000 ;B:      4.15745044 ;C:   9683.59458112),
{9} (A:   1317.10800000 ;B:      5.18668219 ;C:     26.29831980),
{10} (A:   1200.52100000 ;B:      6.15357115 ;C:  30639.85663863),
{11} (A:    769.31400000 ;B:      0.81629616 ;C:   9437.76293489),
{12} (A:    761.38000000 ;B:      1.95014702 ;C:    529.69096509),
{13} (A:    707.67600000 ;B:      1.06466707 ;C:    775.52261132),
{14} (A:    584.83600000 ;B:      3.99839885 ;C:    191.44826611),
{15} (A:    499.91500000 ;B:      4.12340210 ;C:  15720.83878488),
{16} (A:    429.49800000 ;B:      3.58642860 ;C:  19367.18916223),
{17} (A:    326.96700000 ;B:      5.67736584 ;C:   5507.55323867),
{18} (A:    326.22100000 ;B:      4.59056473 ;C:  10404.73381232),
{19} (A:    231.93700000 ;B:      3.16251057 ;C:   9153.90361602),
{20} (A:    179.69500000 ;B:      4.65337916 ;C:   1109.37855209),
{21} (A:    155.46400000 ;B:      5.57043889 ;C:  19651.04848110),
{22} (A:    128.26300000 ;B:      4.22604494 ;C:     20.77539549),
{23} (A:    127.90700000 ;B:      0.96209823 ;C:   5661.33204915),
{24} (A:    105.54700000 ;B:      1.53721191 ;C:    801.82093112));
{L1 -------------------------}
NL1=12;
L1:Array[1..NL1]  of TPlanTerm=(
{1} (A:1021352943052.89807000 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:  95707.71200000 ;B:      2.46424449 ;C:  10213.28554621),
{3} (A:  14444.97700000 ;B:      0.51624565 ;C:  20426.57109242),
{4} (A:    213.37400000 ;B:      1.79547929 ;C:  30639.85663863),
{5} (A:    173.90400000 ;B:      2.65535879 ;C:     26.29831980),
{6} (A:    151.66900000 ;B:      6.10635282 ;C:   1577.34354245),
{7} (A:     82.23300000 ;B:      5.70234134 ;C:    191.44826611),
{8} (A:     69.73400000 ;B:      2.68136035 ;C:   9437.76293489),
{9} (A:     52.40800000 ;B:      3.60013088 ;C:    775.52261132),
{10} (A:     38.31800000 ;B:      1.03379038 ;C:    529.69096509),
{11} (A:     29.63300000 ;B:      1.25056322 ;C:   5507.55323867),
{12} (A:     25.05600000 ;B:      6.10664793 ;C:  10404.73381232));
{L2 -------------------------}
NL2=8;
L2:Array[1..NL2]  of TPlanTerm=(
{1} (A:  54127.07600000 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:   3891.46000000 ;B:      0.34514360 ;C:  10213.28554621),
{3} (A:   1337.88000000 ;B:      2.02011286 ;C:  20426.57109242),
{4} (A:     23.83600000 ;B:      2.04592119 ;C:     26.29831980),
{5} (A:     19.33100000 ;B:      3.53527371 ;C:  30639.85663863),
{6} (A:      9.98400000 ;B:      3.97130221 ;C:    775.52261132),
{7} (A:      7.04600000 ;B:      1.51962593 ;C:   1577.34354245),
{8} (A:      6.01400000 ;B:      0.99926758 ;C:    191.44826611));
{L3 -------------------------}
NL3=3;
L3:Array[1..NL3]  of TPlanTerm=(
{1} (A:    135.74200000 ;B:      4.80389021 ;C:  10213.28554621),
{2} (A:     77.84600000 ;B:      3.66876372 ;C:  20426.57109242),
{3} (A:     26.02300000 ;B:      0.00000000 ;C:      0.00000000));
{L4 -------------------------}
NL4=3;
L4:Array[1..NL4]  of TPlanTerm=(
{1} (A:    114.01600000 ;B:      3.14159265 ;C:      0.00000000),
{2} (A:      3.20900000 ;B:      5.20514170 ;C:  20426.57109242),
{3} (A:      1.71400000 ;B:      2.51099592 ;C:  10213.28554621));
{L5 -------------------------}
NL5=1;
L5:Array[1..NL5]  of TPlanTerm=(
{1} (A:      0.87400000 ;B:      3.14159265 ;C:      0.00000000));
{Termos de B =========================}
{B0 -------------------------}
NB0=9;
B0:Array[1..NB0]  of TPlanTerm=(
{1} (A:5923638.47200000 ;B:      0.26702776 ;C:  10213.28554621),
{2} (A:  40107.97800000 ;B:      1.14737178 ;C:  20426.57109242),
{3} (A:  32814.91800000 ;B:      3.14159265 ;C:      0.00000000),
{4} (A:   1011.39200000 ;B:      1.08946123 ;C:  30639.85663863),
{5} (A:    149.45800000 ;B:      6.25390296 ;C:  18073.70493865),
{6} (A:    137.78800000 ;B:      0.86020147 ;C:   1577.34354245),
{7} (A:    129.97300000 ;B:      3.67152484 ;C:   9437.76293489),
{8} (A:    119.50700000 ;B:      3.70468813 ;C:   2352.86615377),
{9} (A:    107.97100000 ;B:      4.53903678 ;C:  22003.91463487));
{B1 -------------------------}
NB1=4;
B1:Array[1..NB1]  of TPlanTerm=(
{1} (A: 513347.60200000 ;B:      1.80364311 ;C:  10213.28554621),
{2} (A:   4380.10000000 ;B:      3.38615712 ;C:  20426.57109242),
{3} (A:    199.16200000 ;B:      0.00000000 ;C:      0.00000000),
{4} (A:    196.58600000 ;B:      2.53001197 ;C:  30639.85663863));
{B2 -------------------------}
NB2=4;
B2:Array[1..NB2]  of TPlanTerm=(
{1} (A:  22377.66500000 ;B:      3.38509144 ;C:  10213.28554621),
{2} (A:    281.73900000 ;B:      0.00000000 ;C:      0.00000000),
{3} (A:    173.16400000 ;B:      5.25563767 ;C:  20426.57109242),
{4} (A:     26.94500000 ;B:      3.87040892 ;C:  30639.85663863));
{B3 -------------------------}
NB3=4;
B3:Array[1..NB3]  of TPlanTerm=(
{1} (A:    646.67100000 ;B:      4.99166565 ;C:  10213.28554621),
{2} (A:     19.95200000 ;B:      3.14159265 ;C:      0.00000000),
{3} (A:      5.54000000 ;B:      0.77376924 ;C:  20426.57109242),
{4} (A:      2.52600000 ;B:      5.44493763 ;C:  30639.85663863));
{B4 -------------------------}
NB4=1;
B4:Array[1..NB4]  of TPlanTerm=(
{1} (A:     14.10200000 ;B:      0.31537190 ;C:  10213.28554621));
{B5 -------------------------}
NB5=0;
{Termos de R =========================}
{R0 -------------------------}
NR0=12;
R0:Array[1..NR0]  of TPlanTerm=(
{1} (A:72334820.90500000 ;B:      0.00000000 ;C:      0.00000000),
{2} (A: 489824.18500000 ;B:      4.02151832 ;C:  10213.28554621),
{3} (A:   1658.05800000 ;B:      4.90206728 ;C:  20426.57109242),
{4} (A:   1632.09300000 ;B:      2.84548852 ;C:   7860.41939244),
{5} (A:   1378.04800000 ;B:      1.12846591 ;C:  11790.62908866),
{6} (A:    498.39900000 ;B:      2.58682188 ;C:   9683.59458112),
{7} (A:    373.95800000 ;B:      1.42314837 ;C:   3930.20969622),
{8} (A:    263.61600000 ;B:      5.52938186 ;C:   9437.76293489),
{9} (A:    237.45500000 ;B:      2.55135904 ;C:  15720.83878488),
{10} (A:    221.98300000 ;B:      2.01346777 ;C:  19367.18916223),
{11} (A:    125.89600000 ;B:      2.72769834 ;C:   1577.34354245),
{12} (A:    119.46700000 ;B:      3.01975365 ;C:  10404.73381232));
{R1 -------------------------}
NR1=3;
R1:Array[1..NR1]  of TPlanTerm=(
{1} (A:  34551.03900000 ;B:      0.89198711 ;C:  10213.28554621),
{2} (A:    234.20300000 ;B:      1.77224943 ;C:  20426.57109242),
{3} (A:    233.99800000 ;B:      3.14159265 ;C:      0.00000000));
{R2 -------------------------}
NR2=3;
R2:Array[1..NR2]  of TPlanTerm=(
{1} (A:   1406.58700000 ;B:      5.06366395 ;C:  10213.28554621),
{2} (A:     15.52900000 ;B:      5.47321688 ;C:  20426.57109242),
{3} (A:     13.05900000 ;B:      0.00000000 ;C:      0.00000000));
{R3 -------------------------}
NR3=1;
R3:Array[1..NR3]  of TPlanTerm=(
{1} (A:     49.58200000 ;B:      3.22263555 ;C:  10213.28554621));
{R4 -------------------------}
NR4=1;
R4:Array[1..NR4]  of TPlanTerm=(
{1} (A:      0.57300000 ;B:      0.92229698 ;C:  10213.28554621));
{R5 -------------------------}

NR5=0;

CVenus:RPlanConsts=(
  NLTermos:(NL0,NL1,NL2,NL3,NL4,NL5);
  NBTermos:(NB0,NB1,NB2,NB3,NB4,NB5);
  NRTermos:(NR0,NR1,NR2,NR3,NR4,NR5);
  LTermos:(@L0,@L1,@L2,@L3,@L4,@L5);
  BTermos:(@B0,@B1,@B2,@B3,@B4,Nil);
  RTermos:(@R0,@R1,@R2,@R3,@R4,Nil));

implementation

end.
