Unit VSOP87.Uranus; //---------
 //-----------------//
// VSOP87 = Variations Seculaires des Orbiotes Planetaires 1987
//    by Bretagnon and Francou - Bureau des Longitudes of Paris
//
// calculates planet's ecliptical Lon,Lat and Radius ( R from the Sun )
// This method is described in J.Meeus book "Astronomical Algorithms" - Chapter 32
// used as basis for this code.

Interface

uses  VSOP87.PlanetDef;

const
{Termos de L =========================}
{L0 -------------------------}
NL0=91;
L0:Array[1..NL0]  of TPlanTerm=(
{1} (A:548129294.29900003 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:9260408.25200000 ;B:      0.89106422 ;C:     74.78159857),
{3} (A:1504247.82600000 ;B:      3.62719262 ;C:      1.48447271),
{4} (A: 365981.71800000 ;B:      1.89962189 ;C:     73.29712586),
{5} (A: 272328.13200000 ;B:      3.35823711 ;C:    149.56319713),
{6} (A:  70328.49900000 ;B:      5.39254432 ;C:     63.73589830),
{7} (A:  68892.60900000 ;B:      6.09292489 ;C:     76.26607128),
{8} (A:  61998.59200000 ;B:      2.26952040 ;C:      2.96894542),
{9} (A:  61950.71400000 ;B:      2.85098908 ;C:     11.04570026),
{10} (A:  26468.86900000 ;B:      3.14152088 ;C:     71.81265315),
{11} (A:  25710.50500000 ;B:      6.11379843 ;C:    454.90936653),
{12} (A:  21078.89700000 ;B:      4.36059465 ;C:    148.07872443),
{13} (A:  17818.66500000 ;B:      1.74436983 ;C:     36.64856293),
{14} (A:  14613.47100000 ;B:      4.73732048 ;C:      3.93215326),
{15} (A:  11162.53500000 ;B:      5.82681994 ;C:    224.34479570),
{16} (A:  10997.93400000 ;B:      0.48865493 ;C:    138.51749687),
{17} (A:   9527.48700000 ;B:      2.95516893 ;C:     35.16409022),
{18} (A:   7545.54300000 ;B:      5.23626441 ;C:    109.94568879),
{19} (A:   4220.17000000 ;B:      3.23328536 ;C:     70.84944530),
{20} (A:   4051.85000000 ;B:      2.27754159 ;C:    151.04766984),
{21} (A:   3490.35200000 ;B:      5.48305567 ;C:    146.59425172),
{22} (A:   3354.60700000 ;B:      1.06549009 ;C:      4.45341812),
{23} (A:   3144.09300000 ;B:      4.75199308 ;C:     77.75054398),
{24} (A:   2926.67100000 ;B:      4.62903695 ;C:      9.56122756),
{25} (A:   2922.41000000 ;B:      5.35236743 ;C:     85.82729883),
{26} (A:   2272.79000000 ;B:      4.36600803 ;C:     70.32818044),
{27} (A:   2148.59900000 ;B:      0.60745801 ;C:     38.13303564),
{28} (A:   2051.20900000 ;B:      1.51773563 ;C:      0.11187458),
{29} (A:   1991.72600000 ;B:      4.92437291 ;C:    277.03499374),
{30} (A:   1666.91000000 ;B:      3.62744581 ;C:    380.12776796),
{31} (A:   1533.22300000 ;B:      2.58593414 ;C:     52.69019804),
{32} (A:   1376.20800000 ;B:      2.04281409 ;C:     65.22037101),
{33} (A:   1372.10000000 ;B:      4.19641616 ;C:    111.43016150),
{34} (A:   1284.18300000 ;B:      3.11346337 ;C:    202.25339517),
{35} (A:   1281.64100000 ;B:      0.54269870 ;C:    222.86032299),
{36} (A:   1244.34200000 ;B:      0.91612681 ;C:      2.44768055),
{37} (A:   1220.99800000 ;B:      0.19901396 ;C:    108.46121608),
{38} (A:   1150.99300000 ;B:      4.17898207 ;C:     33.67961751),
{39} (A:   1150.41600000 ;B:      0.93344454 ;C:      3.18139374),
{40} (A:   1090.46100000 ;B:      1.77501639 ;C:     12.53017297),
{41} (A:   1072.00800000 ;B:      0.23564503 ;C:     62.25142560),
{42} (A:    946.19500000 ;B:      1.19249463 ;C:    127.47179661),
{43} (A:    707.87500000 ;B:      5.18285227 ;C:    213.29909544),
{44} (A:    653.40100000 ;B:      0.96586909 ;C:     78.71375183),
{45} (A:    627.56200000 ;B:      0.18210182 ;C:    984.60033162),
{46} (A:    606.82700000 ;B:      5.43209729 ;C:    529.69096509),
{47} (A:    559.37000000 ;B:      3.35776738 ;C:      0.52126486),
{48} (A:    524.49500000 ;B:      2.01276707 ;C:    299.12639427),
{49} (A:    483.21900000 ;B:      2.10553990 ;C:      0.96320785),
{50} (A:    471.28800000 ;B:      1.40664336 ;C:    184.72728736),
{51} (A:    467.21100000 ;B:      0.41484069 ;C:    145.10977901),
{52} (A:    433.53200000 ;B:      5.52142978 ;C:    183.24281465),
{53} (A:    404.89100000 ;B:      5.98689011 ;C:      8.07675485),
{54} (A:    398.99600000 ;B:      0.33810765 ;C:    415.55249061),
{55} (A:    395.61400000 ;B:      5.87039581 ;C:    351.81659231),
{56} (A:    378.60900000 ;B:      2.34975805 ;C:     56.62235130),
{57} (A:    309.88500000 ;B:      5.83301305 ;C:    145.63104387),
{58} (A:    300.37900000 ;B:      5.64353974 ;C:     22.09140053),
{59} (A:    294.17200000 ;B:      5.83916826 ;C:     39.61750835),
{60} (A:    251.79200000 ;B:      1.63696776 ;C:    221.37585029),
{61} (A:    249.22900000 ;B:      4.74617121 ;C:    225.82926841),
{62} (A:    239.33400000 ;B:      2.35045875 ;C:    137.03302416),
{63} (A:    224.09700000 ;B:      0.51574863 ;C:     84.34282612),
{64} (A:    222.58800000 ;B:      2.84309380 ;C:      0.26063243),
{65} (A:    219.62100000 ;B:      1.92212988 ;C:     67.66805157),
{66} (A:    216.54900000 ;B:      6.14211863 ;C:      5.93789083),
{67} (A:    216.48000000 ;B:      4.77847481 ;C:    340.77089204),
{68} (A:    207.82800000 ;B:      5.58020570 ;C:     68.84370773),
{69} (A:    201.96300000 ;B:      1.29693041 ;C:      0.04818411),
{70} (A:    199.14600000 ;B:      0.95634155 ;C:    152.53214255),
{71} (A:    193.65200000 ;B:      1.88800123 ;C:    456.39383924),
{72} (A:    192.99800000 ;B:      0.91616059 ;C:    453.42489382),
{73} (A:    187.47400000 ;B:      1.31924326 ;C:      0.16005869),
{74} (A:    181.93400000 ;B:      3.53624029 ;C:     79.23501669),
{75} (A:    173.14500000 ;B:      1.53860728 ;C:    160.60889740),
{76} (A:    171.96800000 ;B:      5.67952686 ;C:    219.89137758),
{77} (A:    170.30000000 ;B:      3.67717521 ;C:      5.41662597),
{78} (A:    168.64800000 ;B:      5.87874001 ;C:     18.15924726),
{79} (A:    164.58800000 ;B:      1.42379715 ;C:    106.97674337),
{80} (A:    162.79200000 ;B:      3.05029378 ;C:    112.91463421),
{81} (A:    158.02800000 ;B:      0.73811997 ;C:     54.17467075),
{82} (A:    146.65300000 ;B:      1.26300172 ;C:     59.80374504),
{83} (A:    143.05800000 ;B:      1.29995488 ;C:     35.42472265),
{84} (A:    139.45300000 ;B:      5.38597723 ;C:     32.19514480),
{85} (A:    138.58500000 ;B:      4.25994787 ;C:    909.81873305),
{86} (A:    123.84000000 ;B:      1.37359990 ;C:      7.11354700),
{87} (A:    110.16300000 ;B:      2.02685779 ;C:    554.06998748),
{88} (A:    109.37600000 ;B:      5.70581833 ;C:     77.96299231),
{89} (A:    104.41400000 ;B:      5.02820889 ;C:      0.75075953),
{90} (A:    103.56200000 ;B:      1.45770270 ;C:     24.37902239),
{91} (A:    103.27700000 ;B:      0.68095301 ;C:     14.97785353));
{L1 -------------------------}
NL1=57;
L1:Array[1..NL1]  of TPlanTerm=(
{1} (A:7502543121.64600086 ;B:      0.00000000 ;C:      0.00000000),
{2} (A: 154458.24400000 ;B:      5.24201658 ;C:     74.78159857),
{3} (A:  24456.41300000 ;B:      1.71255705 ;C:      1.48447271),
{4} (A:   9257.82800000 ;B:      0.42844639 ;C:     11.04570026),
{5} (A:   8265.97700000 ;B:      1.50220035 ;C:     63.73589830),
{6} (A:   7841.71500000 ;B:      1.31983607 ;C:    149.56319713),
{7} (A:   3899.10500000 ;B:      0.46483574 ;C:      3.93215326),
{8} (A:   2283.77700000 ;B:      4.17367534 ;C:     76.26607128),
{9} (A:   1926.60000000 ;B:      0.53013080 ;C:      2.96894542),
{10} (A:   1232.72700000 ;B:      1.58634458 ;C:     70.84944530),
{11} (A:    791.20600000 ;B:      5.43641224 ;C:      3.18139374),
{12} (A:    766.95400000 ;B:      1.99555410 ;C:     73.29712586),
{13} (A:    481.67100000 ;B:      2.98401997 ;C:     85.82729883),
{14} (A:    449.79800000 ;B:      4.13826238 ;C:    138.51749687),
{15} (A:    445.60000000 ;B:      3.72300400 ;C:    224.34479570),
{16} (A:    426.55400000 ;B:      4.73126059 ;C:     71.81265315),
{17} (A:    353.75200000 ;B:      2.58324497 ;C:    148.07872443),
{18} (A:    347.73500000 ;B:      2.45372261 ;C:      9.56122756),
{19} (A:    317.08400000 ;B:      5.57855232 ;C:     52.69019804),
{20} (A:    205.58500000 ;B:      2.36263144 ;C:      2.44768055),
{21} (A:    189.06800000 ;B:      4.20242881 ;C:     56.62235130),
{22} (A:    183.76200000 ;B:      0.28371005 ;C:    151.04766984),
{23} (A:    179.92000000 ;B:      5.68367731 ;C:     12.53017297),
{24} (A:    171.08400000 ;B:      3.00060075 ;C:     78.71375183),
{25} (A:    158.02900000 ;B:      2.90931969 ;C:      0.96320785),
{26} (A:    154.67000000 ;B:      5.59083926 ;C:      4.45341812),
{27} (A:    153.51500000 ;B:      4.65186886 ;C:     35.16409022),
{28} (A:    151.98400000 ;B:      2.94217327 ;C:     77.75054398),
{29} (A:    143.46400000 ;B:      2.59049247 ;C:     62.25142560),
{30} (A:    121.45200000 ;B:      4.14839205 ;C:    127.47179661),
{31} (A:    115.54600000 ;B:      3.73224604 ;C:     65.22037101),
{32} (A:    102.02200000 ;B:      4.18754518 ;C:    145.63104387),
{33} (A:    101.71800000 ;B:      6.03385875 ;C:      0.11187458),
{34} (A:     88.20200000 ;B:      3.99035788 ;C:     18.15924726),
{35} (A:     87.54900000 ;B:      6.15520788 ;C:    202.25339517),
{36} (A:     80.53000000 ;B:      2.64124744 ;C:     22.09140053),
{37} (A:     72.04700000 ;B:      6.04545934 ;C:     70.32818044),
{38} (A:     68.57000000 ;B:      4.05071895 ;C:     77.96299231),
{39} (A:     59.17300000 ;B:      3.70413919 ;C:     67.66805157),
{40} (A:     47.26700000 ;B:      3.54312461 ;C:    351.81659231),
{41} (A:     44.33900000 ;B:      5.90865822 ;C:      7.11354700),
{42} (A:     42.53400000 ;B:      5.72357371 ;C:      5.41662597),
{43} (A:     38.54400000 ;B:      4.91519004 ;C:    222.86032299),
{44} (A:     36.11600000 ;B:      5.89964279 ;C:     33.67961751),
{45} (A:     35.60500000 ;B:      3.29197259 ;C:      8.07675485),
{46} (A:     35.52400000 ;B:      3.32784616 ;C:     71.60020483),
{47} (A:     34.99600000 ;B:      5.08034112 ;C:     38.13303564),
{48} (A:     31.45400000 ;B:      5.62015632 ;C:    984.60033162),
{49} (A:     30.81100000 ;B:      5.49591404 ;C:     59.80374504),
{50} (A:     30.60800000 ;B:      5.46414593 ;C:    160.60889740),
{51} (A:     29.86600000 ;B:      1.65980845 ;C:    447.79581953),
{52} (A:     29.20600000 ;B:      1.14722640 ;C:    462.02291353),
{53} (A:     28.94700000 ;B:      4.51867390 ;C:     84.34282612),
{54} (A:     26.62700000 ;B:      5.54127301 ;C:    131.40394987),
{55} (A:     26.60500000 ;B:      6.14640604 ;C:    299.12639427),
{56} (A:     25.75300000 ;B:      4.99362028 ;C:    137.03302416),
{57} (A:     25.37300000 ;B:      5.73584679 ;C:    380.12776796));
{L2 -------------------------}
NL2=35;
L2:Array[1..NL2]  of TPlanTerm=(
{1} (A:  53033.27700000 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:   2357.63600000 ;B:      2.26014662 ;C:     74.78159857),
{3} (A:    769.12900000 ;B:      4.52561042 ;C:     11.04570026),
{4} (A:    551.53300000 ;B:      3.25814281 ;C:     63.73589830),
{5} (A:    541.53200000 ;B:      2.27573907 ;C:      3.93215326),
{6} (A:    529.47300000 ;B:      4.92348434 ;C:      1.48447271),
{7} (A:    257.52100000 ;B:      3.69059217 ;C:      3.18139374),
{8} (A:    238.83500000 ;B:      5.85806638 ;C:    149.56319713),
{9} (A:    181.90400000 ;B:      6.21763603 ;C:     70.84944530),
{10} (A:     53.50400000 ;B:      1.44225241 ;C:     76.26607128),
{11} (A:     49.40100000 ;B:      6.03101302 ;C:     56.62235130),
{12} (A:     44.75300000 ;B:      3.90904911 ;C:      2.44768055),
{13} (A:     44.53000000 ;B:      0.81152639 ;C:     85.82729883),
{14} (A:     38.22200000 ;B:      1.78467828 ;C:     52.69019804),
{15} (A:     37.40300000 ;B:      4.46228598 ;C:      2.96894542),
{16} (A:     33.02900000 ;B:      0.86388150 ;C:      9.56122756),
{17} (A:     29.42300000 ;B:      5.09818698 ;C:     73.29712586),
{18} (A:     24.29200000 ;B:      2.10702559 ;C:     18.15924726),
{19} (A:     22.49100000 ;B:      5.99320729 ;C:    138.51749687),
{20} (A:     22.13500000 ;B:      4.81730809 ;C:     78.71375183),
{21} (A:     21.39200000 ;B:      2.39880709 ;C:     77.96299231),
{22} (A:     20.57800000 ;B:      2.16918787 ;C:    224.34479570),
{23} (A:     17.22600000 ;B:      2.53537183 ;C:    145.63104387),
{24} (A:     16.77700000 ;B:      3.46631344 ;C:     12.53017297),
{25} (A:     12.01200000 ;B:      0.01941362 ;C:     22.09140053),
{26} (A:     11.01000000 ;B:      0.08496274 ;C:    127.47179661),
{27} (A:     10.47600000 ;B:      5.16453084 ;C:     71.60020483),
{28} (A:     10.46600000 ;B:      4.45556033 ;C:     62.25142560),
{29} (A:      8.66800000 ;B:      4.25550087 ;C:      7.11354700),
{30} (A:      8.38700000 ;B:      5.50115930 ;C:     67.66805157),
{31} (A:      7.16000000 ;B:      1.24903906 ;C:      5.41662597),
{32} (A:      6.10900000 ;B:      3.36320161 ;C:    447.79581953),
{33} (A:      6.08700000 ;B:      5.44611674 ;C:     65.22037101),
{34} (A:      6.01300000 ;B:      4.51836836 ;C:    151.04766984),
{35} (A:      6.00300000 ;B:      5.72500087 ;C:    462.02291353));
{L3 -------------------------}
NL3=18;
L3:Array[1..NL3]  of TPlanTerm=(
{1} (A:    120.93600000 ;B:      0.02418790 ;C:     74.78159857),
{2} (A:     68.06400000 ;B:      4.12084268 ;C:      3.93215326),
{3} (A:     52.82800000 ;B:      2.38964061 ;C:     11.04570026),
{4} (A:     45.80600000 ;B:      0.00000000 ;C:      0.00000000),
{5} (A:     45.30000000 ;B:      2.04423798 ;C:      3.18139374),
{6} (A:     43.75400000 ;B:      2.95965040 ;C:      1.48447271),
{7} (A:     24.96900000 ;B:      4.88741308 ;C:     63.73589830),
{8} (A:     21.06100000 ;B:      4.54511487 ;C:     70.84944530),
{9} (A:     19.89700000 ;B:      2.31320314 ;C:    149.56319713),
{10} (A:      8.90100000 ;B:      1.57548872 ;C:     56.62235130),
{11} (A:      4.27100000 ;B:      0.22777320 ;C:     18.15924726),
{12} (A:      3.61300000 ;B:      5.39244611 ;C:     76.26607128),
{13} (A:      3.57200000 ;B:      0.95052449 ;C:     77.96299231),
{14} (A:      3.48800000 ;B:      4.97622812 ;C:     85.82729883),
{15} (A:      3.47900000 ;B:      4.12969360 ;C:     52.69019804),
{16} (A:      2.69600000 ;B:      0.37287796 ;C:     78.71375183),
{17} (A:      2.32800000 ;B:      0.85770962 ;C:    145.63104387),
{18} (A:      2.15600000 ;B:      5.65647822 ;C:      9.56122756));
{L4 -------------------------}
NL4=4;
L4:Array[1..NL4]  of TPlanTerm=(
{1} (A:    113.85500000 ;B:      3.14159265 ;C:      0.00000000),
{2} (A:      5.59900000 ;B:      4.57882424 ;C:     74.78159857),
{3} (A:      3.20300000 ;B:      0.34623003 ;C:     11.04570026),
{4} (A:      1.21700000 ;B:      3.42199122 ;C:     56.62235130));
{L5 -------------------------}
NL5=0;
{Termos de B =========================}
{B0 -------------------------}
NB0=28;
B0:Array[1..NB0]  of TPlanTerm=(
{1} (A:1346277.63900000 ;B:      2.61877811 ;C:     74.78159857),
{2} (A:  62341.40500000 ;B:      5.08111176 ;C:    149.56319713),
{3} (A:  61601.20300000 ;B:      3.14159265 ;C:      0.00000000),
{4} (A:   9963.74400000 ;B:      1.61603876 ;C:     76.26607128),
{5} (A:   9926.15100000 ;B:      0.57630388 ;C:     73.29712586),
{6} (A:   3259.45500000 ;B:      1.26119386 ;C:    224.34479570),
{7} (A:   2972.31800000 ;B:      2.24367036 ;C:      1.48447271),
{8} (A:   2010.25700000 ;B:      6.05550401 ;C:    148.07872443),
{9} (A:   1522.17200000 ;B:      0.27960386 ;C:     63.73589830),
{10} (A:    924.05500000 ;B:      4.03822928 ;C:    151.04766984),
{11} (A:    760.62400000 ;B:      6.14000432 ;C:     71.81265315),
{12} (A:    522.30900000 ;B:      3.32085195 ;C:    138.51749687),
{13} (A:    462.63000000 ;B:      0.74256728 ;C:     85.82729883),
{14} (A:    436.84300000 ;B:      3.38082524 ;C:    529.69096509),
{15} (A:    434.62500000 ;B:      0.34065282 ;C:     77.75054398),
{16} (A:    430.66800000 ;B:      3.55445035 ;C:    213.29909544),
{17} (A:    420.26500000 ;B:      5.21279985 ;C:     11.04570026),
{18} (A:    244.69800000 ;B:      0.78795150 ;C:      2.96894542),
{19} (A:    232.64900000 ;B:      2.25716421 ;C:    222.86032299),
{20} (A:    215.83800000 ;B:      1.59121705 ;C:     38.13303564),
{21} (A:    179.93500000 ;B:      3.72487953 ;C:    299.12639427),
{22} (A:    174.89500000 ;B:      1.23550262 ;C:    146.59425172),
{23} (A:    173.66700000 ;B:      1.93654269 ;C:    380.12776796),
{24} (A:    160.36800000 ;B:      5.33635436 ;C:    111.43016150),
{25} (A:    144.06400000 ;B:      5.96239326 ;C:     35.16409022),
{26} (A:    116.36300000 ;B:      5.73877190 ;C:     70.84944530),
{27} (A:    106.44100000 ;B:      0.94103113 ;C:     70.32818044),
{28} (A:    102.04900000 ;B:      2.61876257 ;C:     78.71375183));
{B1 -------------------------}
NB1=20;
B1:Array[1..NB1]  of TPlanTerm=(
{1} (A: 206366.16200000 ;B:      4.12394311 ;C:     74.78159857),
{2} (A:   8563.23000000 ;B:      0.33819986 ;C:    149.56319713),
{3} (A:   1725.70300000 ;B:      2.12193160 ;C:     73.29712586),
{4} (A:   1374.44900000 ;B:      0.00000000 ;C:      0.00000000),
{5} (A:   1368.86000000 ;B:      3.06861722 ;C:     76.26607128),
{6} (A:    450.63900000 ;B:      3.77656181 ;C:      1.48447271),
{7} (A:    399.84700000 ;B:      2.84767038 ;C:    224.34479570),
{8} (A:    307.21400000 ;B:      1.25456767 ;C:    148.07872443),
{9} (A:    154.33600000 ;B:      3.78575468 ;C:     63.73589830),
{10} (A:    112.43200000 ;B:      5.57299892 ;C:    151.04766984),
{11} (A:    110.88800000 ;B:      5.32888676 ;C:    138.51749687),
{12} (A:     83.49300000 ;B:      3.59152796 ;C:     71.81265315),
{13} (A:     55.57300000 ;B:      3.40135416 ;C:     85.82729883),
{14} (A:     53.69000000 ;B:      1.70455770 ;C:     77.75054398),
{15} (A:     41.91200000 ;B:      1.21476607 ;C:     11.04570026),
{16} (A:     41.37700000 ;B:      4.45476669 ;C:     78.71375183),
{17} (A:     31.95900000 ;B:      3.77446208 ;C:    222.86032299),
{18} (A:     30.29700000 ;B:      2.56371684 ;C:      2.96894542),
{19} (A:     26.97700000 ;B:      5.33695500 ;C:    213.29909544),
{20} (A:     26.22200000 ;B:      0.41620628 ;C:    380.12776796));
{B2 -------------------------}
NB2=11;
B2:Array[1..NB2]  of TPlanTerm=(
{1} (A:   9211.65600000 ;B:      5.80044306 ;C:     74.78159857),
{2} (A:    556.92600000 ;B:      0.00000000 ;C:      0.00000000),
{3} (A:    286.26500000 ;B:      2.17729776 ;C:    149.56319713),
{4} (A:     94.96900000 ;B:      3.84237570 ;C:     73.29712586),
{5} (A:     45.41900000 ;B:      4.87822046 ;C:     76.26607128),
{6} (A:     20.10700000 ;B:      5.46264485 ;C:      1.48447271),
{7} (A:     14.79300000 ;B:      0.87983716 ;C:    138.51749687),
{8} (A:     14.26100000 ;B:      2.84517743 ;C:    148.07872443),
{9} (A:     13.96300000 ;B:      5.07234044 ;C:     63.73589830),
{10} (A:     10.12200000 ;B:      5.00290895 ;C:    224.34479570),
{11} (A:      8.29900000 ;B:      6.26655615 ;C:     78.71375183));
{B3 -------------------------}
NB3=4;
B3:Array[1..NB3]  of TPlanTerm=(
{1} (A:    267.83200000 ;B:      1.25097888 ;C:     74.78159857),
{2} (A:     11.04800000 ;B:      3.14159265 ;C:      0.00000000),
{3} (A:      6.15400000 ;B:      4.00663614 ;C:    149.56319713),
{4} (A:      3.36100000 ;B:      5.77804695 ;C:     73.29712586));
{B4 -------------------------}
NB4=1;
B4:Array[1..NB4]  of TPlanTerm=(
{1} (A:      5.71900000 ;B:      2.85499529 ;C:     74.78159857));
{B5 -------------------------}
NB5=0;
{Termos de R =========================}
{R0 -------------------------}
NR0=59;
R0:Array[1..NR0]  of TPlanTerm=(
{1} (A:1921264847.88100004 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:88784984.05500001 ;B:      5.60377527 ;C:     74.78159857),
{3} (A:3440835.54500000 ;B:      0.32836099 ;C:     73.29712586),
{4} (A:2055653.49500000 ;B:      1.78295170 ;C:    149.56319713),
{5} (A: 649321.85100000 ;B:      4.52247298 ;C:     76.26607128),
{6} (A: 602248.14400000 ;B:      3.86003820 ;C:     63.73589830),
{7} (A: 496404.17100000 ;B:      1.40139935 ;C:    454.90936653),
{8} (A: 338525.52200000 ;B:      1.58002683 ;C:    138.51749687),
{9} (A: 243508.22200000 ;B:      1.57086595 ;C:     71.81265315),
{10} (A: 190521.91500000 ;B:      1.99809365 ;C:      1.48447271),
{11} (A: 161858.25100000 ;B:      2.79137863 ;C:    148.07872443),
{12} (A: 143705.90200000 ;B:      1.38368574 ;C:     11.04570026),
{13} (A:  93192.35900000 ;B:      0.17437194 ;C:     36.64856293),
{14} (A:  89805.84200000 ;B:      3.66105366 ;C:    109.94568879),
{15} (A:  71424.26500000 ;B:      4.24509327 ;C:    224.34479570),
{16} (A:  46677.32200000 ;B:      1.39976564 ;C:     35.16409022),
{17} (A:  39025.68100000 ;B:      3.36234711 ;C:    277.03499374),
{18} (A:  39009.62400000 ;B:      1.66971129 ;C:     70.84944530),
{19} (A:  36755.16000000 ;B:      3.88648935 ;C:    146.59425172),
{20} (A:  30348.87500000 ;B:      0.70100446 ;C:    151.04766984),
{21} (A:  29156.26400000 ;B:      3.18056175 ;C:     77.75054398),
{22} (A:  25785.80500000 ;B:      3.78537742 ;C:     85.82729883),
{23} (A:  25620.36000000 ;B:      5.25656293 ;C:    380.12776796),
{24} (A:  22637.15200000 ;B:      0.72519138 ;C:    529.69096509),
{25} (A:  20473.16300000 ;B:      2.79639812 ;C:     70.32818044),
{26} (A:  20471.58400000 ;B:      1.55588961 ;C:    202.25339517),
{27} (A:  17900.56100000 ;B:      0.55455489 ;C:      2.96894542),
{28} (A:  15502.80900000 ;B:      5.35405038 ;C:     38.13303564),
{29} (A:  14701.56600000 ;B:      4.90434407 ;C:    108.46121608),
{30} (A:  12896.50700000 ;B:      2.62154018 ;C:    111.43016150),
{31} (A:  12328.15100000 ;B:      5.96039151 ;C:    127.47179661),
{32} (A:  11959.35500000 ;B:      1.75044072 ;C:    984.60033162),
{33} (A:  11852.99600000 ;B:      0.99342815 ;C:     52.69019804),
{34} (A:  11696.08500000 ;B:      3.29825599 ;C:      3.93215326),
{35} (A:  11494.70100000 ;B:      0.43774028 ;C:     65.22037101),
{36} (A:  10792.69900000 ;B:      1.42104858 ;C:    213.29909544),
{37} (A:   9111.44600000 ;B:      4.99638600 ;C:     62.25142560),
{38} (A:   8420.55000000 ;B:      5.25350717 ;C:    222.86032299),
{39} (A:   8402.14700000 ;B:      5.03877516 ;C:    415.55249061),
{40} (A:   7449.12500000 ;B:      0.79491906 ;C:    351.81659231),
{41} (A:   7329.45400000 ;B:      3.97277528 ;C:    183.24281465),
{42} (A:   6046.37000000 ;B:      5.67960948 ;C:     78.71375183),
{43} (A:   5524.13300000 ;B:      3.11499484 ;C:      9.56122756),
{44} (A:   5444.87800000 ;B:      5.10575635 ;C:    145.10977901),
{45} (A:   5238.10300000 ;B:      2.62960142 ;C:     33.67961751),
{46} (A:   4079.16700000 ;B:      3.22064789 ;C:    340.77089204),
{47} (A:   3919.47600000 ;B:      4.25015289 ;C:     39.61750835),
{48} (A:   3801.60600000 ;B:      6.10985559 ;C:    184.72728736),
{49} (A:   3781.21900000 ;B:      3.45840273 ;C:    456.39383924),
{50} (A:   3686.78700000 ;B:      2.48718117 ;C:    453.42489382),
{51} (A:   3101.74300000 ;B:      4.14031064 ;C:    219.89137758),
{52} (A:   2962.64100000 ;B:      0.82977992 ;C:     56.62235130),
{53} (A:   2942.23900000 ;B:      0.42393809 ;C:    299.12639427),
{54} (A:   2940.49200000 ;B:      2.14637460 ;C:    137.03302416),
{55} (A:   2937.79900000 ;B:      3.67657451 ;C:    140.00196958),
{56} (A:   2865.12800000 ;B:      0.30996904 ;C:     12.53017297),
{57} (A:   2538.03200000 ;B:      4.85457832 ;C:    131.40394987),
{58} (A:   2363.55000000 ;B:      0.44253328 ;C:    554.06998748),
{59} (A:   2182.57200000 ;B:      2.94040432 ;C:    305.34616939));
{R1 -------------------------}
NR1=35;
R1:Array[1..NR1]  of TPlanTerm=(
{1} (A:1479896.37000000 ;B:      3.67205705 ;C:     74.78159857),
{2} (A:  71212.08500000 ;B:      6.22601007 ;C:     63.73589830),
{3} (A:  68626.97200000 ;B:      6.13411265 ;C:    149.56319713),
{4} (A:  24059.64900000 ;B:      3.14159265 ;C:      0.00000000),
{5} (A:  21468.15200000 ;B:      2.60176704 ;C:     76.26607128),
{6} (A:  20857.26200000 ;B:      5.24625494 ;C:     11.04570026),
{7} (A:  11405.34600000 ;B:      0.01848462 ;C:     70.84944530),
{8} (A:   7496.77500000 ;B:      0.42360033 ;C:     73.29712586),
{9} (A:   4243.80000000 ;B:      1.41692350 ;C:     85.82729883),
{10} (A:   3926.69400000 ;B:      3.15513991 ;C:     71.81265315),
{11} (A:   3578.44600000 ;B:      2.31160668 ;C:    224.34479570),
{12} (A:   3505.93600000 ;B:      2.58354049 ;C:    138.51749687),
{13} (A:   3228.83500000 ;B:      5.25499603 ;C:      3.93215326),
{14} (A:   3060.01000000 ;B:      0.15321893 ;C:      1.48447271),
{15} (A:   2564.25100000 ;B:      0.98076846 ;C:    148.07872443),
{16} (A:   2429.44500000 ;B:      3.99440122 ;C:     52.69019804),
{17} (A:   1644.71900000 ;B:      2.65349313 ;C:    127.47179661),
{18} (A:   1583.76600000 ;B:      1.43045619 ;C:     78.71375183),
{19} (A:   1508.02800000 ;B:      5.05996325 ;C:    151.04766984),
{20} (A:   1489.52500000 ;B:      2.67559167 ;C:     56.62235130),
{21} (A:   1413.11200000 ;B:      4.57461892 ;C:    202.25339517),
{22} (A:   1403.23700000 ;B:      1.36985350 ;C:     77.75054398),
{23} (A:   1228.22000000 ;B:      1.04703640 ;C:     62.25142560),
{24} (A:   1032.73100000 ;B:      0.26459059 ;C:    131.40394987),
{25} (A:    992.08500000 ;B:      2.17168866 ;C:     65.22037101),
{26} (A:    861.86700000 ;B:      5.05530802 ;C:    351.81659231),
{27} (A:    744.44500000 ;B:      3.07640149 ;C:     35.16409022),
{28} (A:    687.47000000 ;B:      2.49912566 ;C:     77.96299231),
{29} (A:    646.85100000 ;B:      4.47290423 ;C:     70.32818044),
{30} (A:    623.60200000 ;B:      0.86253074 ;C:      9.56122756),
{31} (A:    604.36200000 ;B:      0.90717668 ;C:    984.60033162),
{32} (A:    574.71000000 ;B:      3.23070708 ;C:    447.79581953),
{33} (A:    561.83900000 ;B:      2.71778159 ;C:    462.02291353),
{34} (A:    530.36400000 ;B:      5.91655309 ;C:    213.29909544),
{35} (A:    527.79400000 ;B:      5.15136007 ;C:      2.96894542));
{R2 -------------------------}
NR2=18;
R2:Array[1..NR2]  of TPlanTerm=(
{1} (A:  22439.90400000 ;B:      0.69953119 ;C:     74.78159857),
{2} (A:   4727.03700000 ;B:      1.69901641 ;C:     63.73589830),
{3} (A:   1681.90300000 ;B:      4.64833552 ;C:     70.84944530),
{4} (A:   1649.55900000 ;B:      3.09660079 ;C:     11.04570026),
{5} (A:   1433.75500000 ;B:      3.52119918 ;C:    149.56319713),
{6} (A:    770.18800000 ;B:      0.00000000 ;C:      0.00000000),
{7} (A:    500.42900000 ;B:      6.17229032 ;C:     76.26607128),
{8} (A:    461.00900000 ;B:      0.76676633 ;C:      3.93215326),
{9} (A:    390.37100000 ;B:      4.49605284 ;C:     56.62235130),
{10} (A:    389.94500000 ;B:      5.52673426 ;C:     85.82729883),
{11} (A:    292.09700000 ;B:      0.20389012 ;C:     52.69019804),
{12} (A:    286.57900000 ;B:      3.53357683 ;C:     73.29712586),
{13} (A:    272.89800000 ;B:      3.84707824 ;C:    138.51749687),
{14} (A:    219.67400000 ;B:      1.96418943 ;C:    131.40394987),
{15} (A:    215.78800000 ;B:      0.84812474 ;C:     77.96299231),
{16} (A:    205.44900000 ;B:      3.24758017 ;C:     78.71375183),
{17} (A:    148.55400000 ;B:      4.89840864 ;C:    127.47179661),
{18} (A:    128.83400000 ;B:      2.08146850 ;C:      3.18139374));
{R3 -------------------------}
NR3=10;
R3:Array[1..NR3]  of TPlanTerm=(
{1} (A:   1164.38200000 ;B:      4.73453292 ;C:     74.78159857),
{2} (A:    212.36700000 ;B:      3.34255735 ;C:     63.73589830),
{3} (A:    196.40800000 ;B:      2.98004616 ;C:     70.84944530),
{4} (A:    104.52700000 ;B:      0.95807938 ;C:     11.04570026),
{5} (A:     72.54000000 ;B:      0.99701908 ;C:    149.56319713),
{6} (A:     71.68100000 ;B:      0.02528456 ;C:     56.62235130),
{7} (A:     54.87500000 ;B:      2.59436811 ;C:      3.93215326),
{8} (A:     36.37700000 ;B:      5.65035573 ;C:     77.96299231),
{9} (A:     34.02900000 ;B:      3.81553326 ;C:     76.26607128),
{10} (A:     32.08100000 ;B:      3.59825178 ;C:    131.40394987));
{R4 -------------------------}
NR4=2;
R4:Array[1..NR4]  of TPlanTerm=(
{1} (A:     52.99600000 ;B:      3.00838033 ;C:     74.78159857),
{2} (A:      9.88700000 ;B:      1.91399084 ;C:     56.62235130));
{R5 -------------------------}

NR5=0;

CUranus:RPlanConsts=(
  NLTermos:(NL0,NL1,NL2,NL3,NL4,NL5);
  NBTermos:(NB0,NB1,NB2,NB3,NB4,NB5);
  NRTermos:(NR0,NR1,NR2,NR3,NR4,NR5);
  LTermos:(@L0,@L1,@L2,@L3,@L4,nil);
  BTermos:(@B0,@B1,@B2,@B3,@B4,nil);
  RTermos:(@R0,@R1,@R2,@R3,@R4,nil));

implementation

end.
