Unit VSOP87.Neptune;     //---------
 //---------------------//
// VSOP87 = Variations Seculaires des Orbiotes Planetaires 1987
//    by Bretagnon and Francou - Bureau des Longitudes of Paris
//
// calculates planet's ecliptical Lon,Lat and Radius ( R from the Sun )
// This method is described in J.Meeus book "Astronomical Algorithms" - Chapter 32
// used as basis for this code.

Interface

uses  VSOP87.PlanetDef;

const
{Termos de L =========================}
{L0 -------------------------}
NL0=38;
L0:Array[1..NL0]  of TPlanTerm=(
{1} (A:531188633.04699999 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:1798475.50900000 ;B:      2.90101273 ;C:     38.13303564),
{3} (A:1019727.66200000 ;B:      0.48580924 ;C:      1.48447271),
{4} (A: 124531.84500000 ;B:      4.83008091 ;C:     36.64856293),
{5} (A:  42064.45000000 ;B:      5.41054992 ;C:      2.96894542),
{6} (A:  37714.58900000 ;B:      6.09221835 ;C:     35.16409022),
{7} (A:  33784.73400000 ;B:      1.24488866 ;C:     76.26607128),
{8} (A:  16482.74100000 ;B:      0.00007729 ;C:    491.55792946),
{9} (A:   9198.58200000 ;B:      4.93747060 ;C:     39.61750835),
{10} (A:   8994.24900000 ;B:      0.27462143 ;C:    175.16605980),
{11} (A:   4216.23500000 ;B:      1.98711914 ;C:     73.29712586),
{12} (A:   3364.81800000 ;B:      1.03590122 ;C:     33.67961751),
{13} (A:   2284.80000000 ;B:      4.20606933 ;C:      4.45341812),
{14} (A:   1433.51200000 ;B:      2.78340433 ;C:     74.78159857),
{15} (A:    900.24000000 ;B:      2.07606702 ;C:    109.94568879),
{16} (A:    744.99600000 ;B:      3.19032530 ;C:     71.81265315),
{17} (A:    506.20600000 ;B:      5.74785370 ;C:    114.39910691),
{18} (A:    399.55200000 ;B:      0.34972343 ;C:   1021.24889455),
{19} (A:    345.19500000 ;B:      3.46186210 ;C:     41.10198105),
{20} (A:    340.32300000 ;B:      3.30369900 ;C:     77.75054398),
{21} (A:    323.00400000 ;B:      2.24815189 ;C:     32.19514480),
{22} (A:    306.33800000 ;B:      0.49684040 ;C:      0.52126486),
{23} (A:    287.32200000 ;B:      4.50523446 ;C:      0.04818411),
{24} (A:    282.17000000 ;B:      2.24565580 ;C:    146.59425172),
{25} (A:    266.60500000 ;B:      4.88932609 ;C:      0.96320785),
{26} (A:    251.94100000 ;B:      5.78166597 ;C:    388.46515524),
{27} (A:    244.72200000 ;B:      1.24693338 ;C:      9.56122756),
{28} (A:    232.88700000 ;B:      2.50459795 ;C:    137.03302416),
{29} (A:    227.07900000 ;B:      1.79713055 ;C:    453.42489382),
{30} (A:    170.40400000 ;B:      3.32390631 ;C:    108.46121608),
{31} (A:    151.40100000 ;B:      2.19153094 ;C:     33.94024994),
{32} (A:    150.18000000 ;B:      2.99706110 ;C:      5.93789083),
{33} (A:    148.29500000 ;B:      0.85948986 ;C:    111.43016150),
{34} (A:    118.67200000 ;B:      3.67706204 ;C:      2.44768055),
{35} (A:    109.30000000 ;B:      2.41599378 ;C:    183.24281465),
{36} (A:    103.30500000 ;B:      0.04078967 ;C:      0.26063243),
{37} (A:    103.05400000 ;B:      4.40441222 ;C:     70.32818044),
{38} (A:    101.82100000 ;B:      5.70539237 ;C:      0.11187458));
{L1 -------------------------}
NL1=18;
L1:Array[1..NL1]  of TPlanTerm=(
{1} (A:3837687716.73099995 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:  16604.18700000 ;B:      4.86319130 ;C:      1.48447271),
{3} (A:  15807.14800000 ;B:      2.27923489 ;C:     38.13303564),
{4} (A:   3334.70100000 ;B:      3.68199676 ;C:     76.26607128),
{5} (A:   1305.84000000 ;B:      3.67320813 ;C:      2.96894542),
{6} (A:    604.83200000 ;B:      1.50477748 ;C:     35.16409022),
{7} (A:    178.62300000 ;B:      3.45318524 ;C:     39.61750835),
{8} (A:    106.53700000 ;B:      2.45126138 ;C:      4.45341812),
{9} (A:    105.74700000 ;B:      2.75479327 ;C:     33.67961751),
{10} (A:     72.68400000 ;B:      5.48724733 ;C:     36.64856293),
{11} (A:     57.35500000 ;B:      1.85767603 ;C:    114.39910691),
{12} (A:     57.06900000 ;B:      5.21649805 ;C:      0.52126486),
{13} (A:     35.36800000 ;B:      4.51676828 ;C:     74.78159857),
{14} (A:     32.21600000 ;B:      5.90411490 ;C:     77.75054398),
{15} (A:     29.87100000 ;B:      3.67043294 ;C:    388.46515524),
{16} (A:     28.86600000 ;B:      5.16877529 ;C:      9.56122756),
{17} (A:     28.74200000 ;B:      5.16732589 ;C:      2.44768055),
{18} (A:     25.50700000 ;B:      5.24526282 ;C:    168.05251280));
{L2 -------------------------}
NL2=7;
L2:Array[1..NL2]  of TPlanTerm=(
{1} (A:  53892.64900000 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:    295.69300000 ;B:      1.85520292 ;C:      1.48447271),
{3} (A:    281.25100000 ;B:      1.19084539 ;C:     38.13303564),
{4} (A:    270.19000000 ;B:      5.72143228 ;C:     76.26607128),
{5} (A:     23.02300000 ;B:      1.21035596 ;C:      2.96894542),
{6} (A:      9.05700000 ;B:      4.42544992 ;C:     35.16409022),
{7} (A:      7.33300000 ;B:      0.54033307 ;C:      2.44768055));
{L3 -------------------------}
NL3=4;
L3:Array[1..NL3]  of TPlanTerm=(
{1} (A:     31.25400000 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:     14.54100000 ;B:      1.35337076 ;C:     76.26607128),
{3} (A:     12.46100000 ;B:      6.04431419 ;C:      1.48447271),
{4} (A:     11.54700000 ;B:      6.11257808 ;C:     38.13303564));
{L4 -------------------------}
NL4=1;
L4:Array[1..NL4]  of TPlanTerm=(
{1} (A:    113.99800000 ;B:      3.14159265 ;C:      0.00000000));
{L5 -------------------------}
NL5=0;
{Termos de B =========================}
{B0 -------------------------}
NB0=17;
B0:Array[1..NB0]  of TPlanTerm=(
{1} (A:3088622.93300000 ;B:      1.44104373 ;C:     38.13303564),
{2} (A:  27780.08700000 ;B:      5.91271883 ;C:     76.26607128),
{3} (A:  27623.60900000 ;B:      0.00000000 ;C:      0.00000000),
{4} (A:  15448.13300000 ;B:      3.50877081 ;C:     39.61750835),
{5} (A:  15355.49000000 ;B:      2.52123799 ;C:     36.64856293),
{6} (A:   1999.91900000 ;B:      1.50998670 ;C:     74.78159857),
{7} (A:   1967.54000000 ;B:      4.37778196 ;C:      1.48447271),
{8} (A:   1015.13700000 ;B:      3.21561036 ;C:     35.16409022),
{9} (A:    605.76700000 ;B:      2.80246601 ;C:     73.29712586),
{10} (A:    594.87800000 ;B:      2.12892708 ;C:     41.10198105),
{11} (A:    588.80500000 ;B:      3.18655882 ;C:      2.96894542),
{12} (A:    401.83000000 ;B:      4.16883287 ;C:    114.39910691),
{13} (A:    279.96400000 ;B:      1.68165310 ;C:     77.75054398),
{14} (A:    261.64700000 ;B:      3.76722705 ;C:    213.29909544),
{15} (A:    254.33300000 ;B:      3.27120499 ;C:    453.42489382),
{16} (A:    205.59000000 ;B:      4.25652349 ;C:    529.69096509),
{17} (A:    140.45500000 ;B:      3.52969556 ;C:    137.03302416));
{B1 -------------------------}
NB1=13;
B1:Array[1..NB1]  of TPlanTerm=(
{1} (A: 227279.21400000 ;B:      3.80793090 ;C:     38.13303564),
{2} (A:   1803.12000000 ;B:      1.97576485 ;C:     76.26607128),
{3} (A:   1433.30000000 ;B:      3.14159265 ;C:      0.00000000),
{4} (A:   1385.73300000 ;B:      4.82555548 ;C:     36.64856293),
{5} (A:   1073.29800000 ;B:      6.08054241 ;C:     39.61750835),
{6} (A:    147.90300000 ;B:      3.85766231 ;C:     74.78159857),
{7} (A:    136.44800000 ;B:      0.47764957 ;C:      1.48447271),
{8} (A:     70.28500000 ;B:      6.18782052 ;C:     35.16409022),
{9} (A:     51.89900000 ;B:      5.05221792 ;C:     73.29712586),
{10} (A:     42.56800000 ;B:      0.30721737 ;C:    114.39910691),
{11} (A:     37.27300000 ;B:      4.89476629 ;C:     41.10198105),
{12} (A:     37.10400000 ;B:      5.75999349 ;C:      2.96894542),
{13} (A:     26.39900000 ;B:      5.21566336 ;C:    213.29909544));
{B2 -------------------------}
NB2=6;
B2:Array[1..NB2]  of TPlanTerm=(
{1} (A:   9690.76600000 ;B:      5.57123750 ;C:     38.13303564),
{2} (A:     78.81500000 ;B:      3.62705474 ;C:     76.26607128),
{3} (A:     71.52300000 ;B:      0.45476689 ;C:     36.64856293),
{4} (A:     58.64600000 ;B:      3.14159265 ;C:      0.00000000),
{5} (A:     29.91500000 ;B:      1.60671722 ;C:     39.61750835),
{6} (A:      6.47200000 ;B:      5.60736757 ;C:     74.78159857));
{B3 -------------------------}
NB3=4;
B3:Array[1..NB3]  of TPlanTerm=(
{1} (A:    273.42300000 ;B:      1.01688979 ;C:     38.13303564),
{2} (A:      2.39300000 ;B:      0.00000000 ;C:      0.00000000),
{3} (A:      2.27400000 ;B:      2.36805657 ;C:     36.64856293),
{4} (A:      2.02900000 ;B:      5.33364321 ;C:     76.26607128));
{B4 -------------------------}
NB4=1;
B4:Array[1..NB4]  of TPlanTerm=(
{1} (A:      5.72800000 ;B:      2.66872693 ;C:     38.13303564));
{B5 -------------------------}
NB5=0;
{Termos de R =========================}
{R0 -------------------------}
NR0=32;
R0:Array[1..NR0]  of TPlanTerm=(
{1} (A:3007013206.10200024 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:27062259.49000000 ;B:      1.32999459 ;C:     38.13303564),
{3} (A:1691764.28100000 ;B:      3.25186139 ;C:     36.64856293),
{4} (A: 807830.73700000 ;B:      5.18592836 ;C:      1.48447271),
{5} (A: 537760.61300000 ;B:      4.52113903 ;C:     35.16409022),
{6} (A: 495725.64200000 ;B:      1.57105655 ;C:    491.55792946),
{7} (A: 274571.97000000 ;B:      1.84552257 ;C:    175.16605980),
{8} (A: 135134.09500000 ;B:      3.37220607 ;C:     39.61750835),
{9} (A: 121801.82500000 ;B:      5.79754444 ;C:     76.26607128),
{10} (A: 100895.39700000 ;B:      0.37702749 ;C:     73.29712586),
{11} (A:  69791.72200000 ;B:      3.79617227 ;C:      2.96894542),
{12} (A:  46687.83800000 ;B:      5.74937810 ;C:     33.67961751),
{13} (A:  24593.77800000 ;B:      0.50801728 ;C:    109.94568879),
{14} (A:  16939.24200000 ;B:      1.59422167 ;C:     71.81265315),
{15} (A:  14229.68600000 ;B:      1.07786113 ;C:     74.78159857),
{16} (A:  12011.82500000 ;B:      1.92062132 ;C:   1021.24889455),
{17} (A:   8394.73100000 ;B:      0.67816896 ;C:    146.59425172),
{18} (A:   7571.80000000 ;B:      1.07149263 ;C:    388.46515524),
{19} (A:   5720.85200000 ;B:      2.59059512 ;C:      4.45341812),
{20} (A:   4839.67200000 ;B:      1.90685991 ;C:     41.10198105),
{21} (A:   4483.49200000 ;B:      2.90573458 ;C:    529.69096509),
{22} (A:   4420.80400000 ;B:      1.74993797 ;C:    108.46121608),
{23} (A:   4353.79000000 ;B:      0.67985662 ;C:     32.19514480),
{24} (A:   4270.20200000 ;B:      3.41343866 ;C:    453.42489382),
{25} (A:   3380.93000000 ;B:      0.84810683 ;C:    183.24281465),
{26} (A:   2881.06300000 ;B:      1.98600105 ;C:    137.03302416),
{27} (A:   2878.94200000 ;B:      3.67415902 ;C:    350.33211960),
{28} (A:   2635.53500000 ;B:      3.09755943 ;C:    213.29909544),
{29} (A:   2530.14900000 ;B:      5.79839567 ;C:    490.07345675),
{30} (A:   2523.13200000 ;B:      0.48630800 ;C:    493.04240217),
{31} (A:   2306.29300000 ;B:      2.80962936 ;C:     70.32818044),
{32} (A:   2087.30300000 ;B:      0.61858378 ;C:     33.94024994));
{R1 -------------------------}
NR1=15;
R1:Array[1..NR1]  of TPlanTerm=(
{1} (A: 236338.50200000 ;B:      0.70498011 ;C:     38.13303564),
{2} (A:  13220.27900000 ;B:      3.32015500 ;C:      1.48447271),
{3} (A:   8621.86300000 ;B:      6.21628952 ;C:     35.16409022),
{4} (A:   2701.74000000 ;B:      1.88140667 ;C:     39.61750835),
{5} (A:   2154.73500000 ;B:      2.09431198 ;C:      2.96894542),
{6} (A:   2153.15000000 ;B:      5.16873841 ;C:     76.26607128),
{7} (A:   1603.16500000 ;B:      0.00000000 ;C:      0.00000000),
{8} (A:   1463.92400000 ;B:      1.18417031 ;C:     33.67961751),
{9} (A:   1135.77300000 ;B:      3.91891200 ;C:     36.64856293),
{10} (A:    897.65000000 ;B:      5.24122934 ;C:    388.46515524),
{11} (A:    789.90800000 ;B:      0.53315485 ;C:    168.05251280),
{12} (A:    760.03000000 ;B:      0.02051034 ;C:    182.27960680),
{13} (A:    607.18300000 ;B:      1.07706500 ;C:   1021.24889455),
{14} (A:    571.62200000 ;B:      3.40060785 ;C:    484.44438246),
{15} (A:    560.79000000 ;B:      2.88685816 ;C:    498.67147646));
{R2 -------------------------}
NR2=5;
R2:Array[1..NR2]  of TPlanTerm=(
{1} (A:   4247.41200000 ;B:      5.89910679 ;C:     38.13303564),
{2} (A:    217.57000000 ;B:      0.34581829 ;C:      1.48447271),
{3} (A:    163.02500000 ;B:      2.23872947 ;C:    168.05251280),
{4} (A:    156.28500000 ;B:      4.59414467 ;C:    182.27960680),
{5} (A:    127.14100000 ;B:      2.84786298 ;C:     35.16409022));
{R3 -------------------------}
NR3=1;
R3:Array[1..NR3]  of TPlanTerm=(
{1} (A:    166.29700000 ;B:      4.55243893 ;C:     38.13303564));
{R4 -------------------------}
NR4=0;
{R5 -------------------------}

NR5=0;

CNeptune:RPlanConsts=(
  NLTermos:(NL0,NL1,NL2,NL3,NL4,NL5);
  NBTermos:(NB0,NB1,NB2,NB3,NB4,NB5);
  NRTermos:(NR0,NR1,NR2,NR3,NR4,NR5);
  LTermos:(@L0,@L1,@L2,@L3,@L4,nil);
  BTermos:(@B0,@B1,@B2,@B3,@B4,nil);
  RTermos:(@R0,@R1,@R2,@R3,nil,nil));

implementation

end.
