Unit VSOP87.Mercury; //---------
 //-----------------//
// VSOP87 = Variations Seculaires des Orbiotes Planetaires 1987
//    by Bretagnon and Francou - Bureau des Longitudes of Paris
//
// calculates planet's ecliptical Lon,Lat and Radius ( R from the Sun )
// This method is described in J.Meeus book "Astronomical Algorithms" - Chapter 32
// used as basis for this code.

Interface

uses  VSOP87.PlanetDef;

const
{Termos de L =========================}
{L0 -------------------------}
NL0=38;
L0:Array[1..NL0]  of TPlanTerm=(
{1} (A:440250710.14400005 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:40989414.97600000 ;B:      1.48302034 ;C:  26087.90314157),
{3} (A:5046294.19900000 ;B:      4.47785490 ;C:  52175.80628315),
{4} (A: 855346.84300000 ;B:      1.16520322 ;C:  78263.70942472),
{5} (A: 165590.36200000 ;B:      4.11969163 ;C: 104351.61256630),
{6} (A:  34561.89700000 ;B:      0.77930766 ;C: 130439.51570787),
{7} (A:   7583.47600000 ;B:      3.71348401 ;C: 156527.41884945),
{8} (A:   3559.74000000 ;B:      1.51202669 ;C:   1109.37855209),
{9} (A:   1803.46300000 ;B:      4.10333178 ;C:   5661.33204915),
{10} (A:   1726.01200000 ;B:      0.35832240 ;C: 182615.32199102),
{11} (A:   1589.92300000 ;B:      2.99510418 ;C:  25028.52121138),
{12} (A:   1364.68200000 ;B:      4.59918319 ;C:  27197.28169367),
{13} (A:   1017.33200000 ;B:      0.88031439 ;C:  31749.23519073),
{14} (A:    714.18200000 ;B:      1.54144865 ;C:  24978.52458948),
{15} (A:    643.75900000 ;B:      5.30266111 ;C:  21535.94964452),
{16} (A:    451.13700000 ;B:      6.04989275 ;C:  51116.42435296),
{17} (A:    404.20000000 ;B:      3.28228847 ;C: 208703.22513259),
{18} (A:    352.44100000 ;B:      5.24156297 ;C:  20426.57109242),
{19} (A:    345.21200000 ;B:      2.79211902 ;C:  15874.61759536),
{20} (A:    343.31300000 ;B:      5.76531885 ;C:    955.59974161),
{21} (A:    339.21400000 ;B:      5.86327765 ;C:  25558.21217648),
{22} (A:    325.33500000 ;B:      1.33674335 ;C:  53285.18483524),
{23} (A:    272.94700000 ;B:      2.49451164 ;C:    529.69096509),
{24} (A:    264.33600000 ;B:      3.91705094 ;C:  57837.13833230),
{25} (A:    259.58700000 ;B:      0.98732428 ;C:   4551.95349706),
{26} (A:    238.79300000 ;B:      0.11343953 ;C:   1059.38193019),
{27} (A:    234.83000000 ;B:      0.26672119 ;C:  11322.66409830),
{28} (A:    216.64500000 ;B:      0.65987207 ;C:  13521.75144159),
{29} (A:    208.99500000 ;B:      2.09178234 ;C:  47623.85278609),
{30} (A:    183.35900000 ;B:      2.62878671 ;C:  27043.50288318),
{31} (A:    181.62900000 ;B:      2.43413502 ;C:  25661.30495070),
{32} (A:    175.96500000 ;B:      4.53636830 ;C:  51066.42773106),
{33} (A:    172.64300000 ;B:      2.45200164 ;C:  24498.83024629),
{34} (A:    142.31600000 ;B:      3.36003949 ;C:  37410.56723988),
{35} (A:    137.94200000 ;B:      0.29098448 ;C:  10213.28554621),
{36} (A:    125.21900000 ;B:      3.72079804 ;C:  39609.65458317),
{37} (A:    118.23300000 ;B:      2.78149786 ;C:  77204.32749453),
{38} (A:    106.42200000 ;B:      4.20572116 ;C:  19804.82729158));
{L1 -------------------------}
NL1=16;
L1:Array[1..NL1]  of TPlanTerm=(
{1} (A:2608814706222.74609000 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:1126007.83200000 ;B:      6.21703971 ;C:  26087.90314157),
{3} (A: 303471.39500000 ;B:      3.05565472 ;C:  52175.80628315),
{4} (A:  80538.45200000 ;B:      6.10454743 ;C:  78263.70942472),
{5} (A:  21245.03500000 ;B:      2.83531934 ;C: 104351.61256630),
{6} (A:   5592.09400000 ;B:      5.82675673 ;C: 130439.51570787),
{7} (A:   1472.23300000 ;B:      2.51845458 ;C: 156527.41884945),
{8} (A:    388.31800000 ;B:      5.48039226 ;C: 182615.32199102),
{9} (A:    352.24400000 ;B:      3.05238094 ;C:   1109.37855209),
{10} (A:    102.74300000 ;B:      2.14879174 ;C: 208703.22513259),
{11} (A:     93.54000000 ;B:      6.11791164 ;C:  27197.28169367),
{12} (A:     90.57900000 ;B:      0.00045482 ;C:  24978.52458948),
{13} (A:     51.94100000 ;B:      5.62107554 ;C:   5661.33204915),
{14} (A:     44.37000000 ;B:      4.57348500 ;C:  25028.52121138),
{15} (A:     28.07000000 ;B:      3.04195431 ;C:  51066.42773106),
{16} (A:     27.29500000 ;B:      5.09210139 ;C: 234791.12827417));
{L2 -------------------------}
NL2=10;
L2:Array[1..NL2]  of TPlanTerm=(
{1} (A:  53049.84500000 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:  16903.65800000 ;B:      4.69072301 ;C:  26087.90314157),
{3} (A:   7396.71100000 ;B:      1.34735625 ;C:  52175.80628315),
{4} (A:   3018.29700000 ;B:      4.45643540 ;C:  78263.70942472),
{5} (A:   1107.41900000 ;B:      1.26226538 ;C: 104351.61256630),
{6} (A:    378.17300000 ;B:      4.31998056 ;C: 130439.51570787),
{7} (A:    122.99800000 ;B:      1.06868541 ;C: 156527.41884945),
{8} (A:     38.66300000 ;B:      4.08011610 ;C: 182615.32199102),
{9} (A:     14.89800000 ;B:      4.63343086 ;C:   1109.37855209),
{10} (A:     11.86100000 ;B:      0.79187646 ;C: 208703.22513259));
{L3 -------------------------}
NL3=8;
L3:Array[1..NL3]  of TPlanTerm=(
{1} (A:    188.07700000 ;B:      0.03466830 ;C:  52175.80628315),
{2} (A:    142.15200000 ;B:      3.12505453 ;C:  26087.90314157),
{3} (A:     96.87700000 ;B:      3.00378172 ;C:  78263.70942472),
{4} (A:     43.66900000 ;B:      6.01867966 ;C: 104351.61256630),
{5} (A:     35.39500000 ;B:      0.00000000 ;C:      0.00000000),
{6} (A:     18.04500000 ;B:      2.77538374 ;C: 130439.51570787),
{7} (A:      6.97100000 ;B:      5.81808666 ;C: 156527.41884945),
{8} (A:      2.55600000 ;B:      2.57014364 ;C: 182615.32199102));
{L4 -------------------------}
NL4=6;
L4:Array[1..NL4]  of TPlanTerm=(
{1} (A:    114.07800000 ;B:      3.14159265 ;C:      0.00000000),
{2} (A:      3.24700000 ;B:      2.02848008 ;C:  26087.90314157),
{3} (A:      1.91400000 ;B:      1.41731804 ;C:  78263.70942472),
{4} (A:      1.72700000 ;B:      4.50137644 ;C:  52175.80628315),
{5} (A:      1.23700000 ;B:      4.49970181 ;C: 104351.61256630),
{6} (A:      0.64500000 ;B:      1.26591777 ;C: 130439.51570787));
{L5 -------------------------}
NL5=1;
L5:Array[1..NL5]  of TPlanTerm=(
{1} (A:      0.87700000 ;B:      3.14159265 ;C:      0.00000000));
{Termos de B =========================}
{B0 -------------------------}
NB0=14;
B0:Array[1..NB0]  of TPlanTerm=(
{1} (A:11737528.96200000 ;B:      1.98357499 ;C:  26087.90314157),
{2} (A:2388076.99600000 ;B:      5.03738960 ;C:  52175.80628315),
{3} (A:1222839.53200000 ;B:      3.14159265 ;C:      0.00000000),
{4} (A: 543251.81000000 ;B:      1.79644364 ;C:  78263.70942472),
{5} (A: 129778.77000000 ;B:      4.83232504 ;C: 104351.61256630),
{6} (A:  31866.92700000 ;B:      1.58088496 ;C: 130439.51570787),
{7} (A:   7963.30100000 ;B:      4.60972126 ;C: 156527.41884945),
{8} (A:   2014.18900000 ;B:      1.35324165 ;C: 182615.32199102),
{9} (A:    513.95300000 ;B:      4.37835409 ;C: 208703.22513259),
{10} (A:    208.58400000 ;B:      2.02020294 ;C:  24978.52458948),
{11} (A:    207.67400000 ;B:      4.91772564 ;C:  27197.28169367),
{12} (A:    132.01300000 ;B:      1.11908492 ;C: 234791.12827417),
{13} (A:    121.39500000 ;B:      1.81271752 ;C:  53285.18483524),
{14} (A:    100.45400000 ;B:      5.65684734 ;C:  20426.57109242));
{B1 -------------------------}
NB1=11;
B1:Array[1..NB1]  of TPlanTerm=(
{1} (A: 429151.36200000 ;B:      3.50169780 ;C:  26087.90314157),
{2} (A: 146233.66800000 ;B:      3.14159265 ;C:      0.00000000),
{3} (A:  22675.29500000 ;B:      0.01515367 ;C:  52175.80628315),
{4} (A:  10894.98100000 ;B:      0.48540174 ;C:  78263.70942472),
{5} (A:   6353.46200000 ;B:      3.42943920 ;C: 104351.61256630),
{6} (A:   2495.74300000 ;B:      0.16051211 ;C: 130439.51570787),
{7} (A:    859.58500000 ;B:      3.18452434 ;C: 156527.41884945),
{8} (A:    277.50300000 ;B:      6.21020774 ;C: 182615.32199102),
{9} (A:     86.23300000 ;B:      2.95244392 ;C: 208703.22513259),
{10} (A:     27.69600000 ;B:      0.29068939 ;C:  27197.28169367),
{11} (A:     26.13300000 ;B:      5.97708963 ;C: 234791.12827417));
{B2 -------------------------}
NB2=9;
B2:Array[1..NB2]  of TPlanTerm=(
{1} (A:  11830.93400000 ;B:      4.79065586 ;C:  26087.90314157),
{2} (A:   1913.51600000 ;B:      0.00000000 ;C:      0.00000000),
{3} (A:   1044.80100000 ;B:      1.21216541 ;C:  52175.80628315),
{4} (A:    266.21300000 ;B:      4.43418337 ;C:  78263.70942472),
{5} (A:    170.28000000 ;B:      1.62255639 ;C: 104351.61256630),
{6} (A:     96.30000000 ;B:      4.80023692 ;C: 130439.51570787),
{7} (A:     44.69200000 ;B:      1.60758268 ;C: 156527.41884945),
{8} (A:     18.31600000 ;B:      4.66904655 ;C: 182615.32199102),
{9} (A:      6.92700000 ;B:      1.43404889 ;C: 208703.22513259));
{B3 -------------------------}
NB3=7;
B3:Array[1..NB3]  of TPlanTerm=(
{1} (A:    235.42300000 ;B:      0.35387525 ;C:  26087.90314157),
{2} (A:    160.53700000 ;B:      0.00000000 ;C:      0.00000000),
{3} (A:     18.90400000 ;B:      4.36275460 ;C:  52175.80628315),
{4} (A:      6.37600000 ;B:      2.50715381 ;C:  78263.70942472),
{5} (A:      4.58000000 ;B:      6.14257818 ;C: 104351.61256630),
{6} (A:      3.06100000 ;B:      3.12497553 ;C: 130439.51570787),
{7} (A:      1.73200000 ;B:      6.26642412 ;C: 156527.41884945));
{B4 -------------------------}
NB4=2;
B4:Array[1..NB4]  of TPlanTerm=(
{1} (A:      4.27600000 ;B:      1.74579932 ;C:  26087.90314157),
{2} (A:      1.02300000 ;B:      3.14159265 ;C:      0.00000000));
{B5 -------------------------}
NB5=0;
{Termos de R =========================}
{R0 -------------------------}
NR0=13;
R0:Array[1..NR0]  of TPlanTerm=(
{1} (A:39528271.65200000 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:7834131.81700000 ;B:      6.19233723 ;C:  26087.90314157),
{3} (A: 795525.55700000 ;B:      2.95989690 ;C:  52175.80628315),
{4} (A: 121281.76300000 ;B:      6.01064154 ;C:  78263.70942472),
{5} (A:  21921.96900000 ;B:      2.77820094 ;C: 104351.61256630),
{6} (A:   4354.06500000 ;B:      5.82894543 ;C: 130439.51570787),
{7} (A:    918.22800000 ;B:      2.59650563 ;C: 156527.41884945),
{8} (A:    289.95500000 ;B:      1.42441937 ;C:  25028.52121138),
{9} (A:    260.03300000 ;B:      3.02817753 ;C:  27197.28169367),
{10} (A:    201.85500000 ;B:      5.64725040 ;C: 182615.32199102),
{11} (A:    201.49900000 ;B:      5.59227724 ;C:  31749.23519073),
{12} (A:    141.98000000 ;B:      6.25264203 ;C:  24978.52458948),
{13} (A:    100.14400000 ;B:      3.73435609 ;C:  21535.94964452));
{R1 -------------------------}
NR1=8;
R1:Array[1..NR1]  of TPlanTerm=(
{1} (A: 217347.73900000 ;B:      4.65617159 ;C:  26087.90314157),
{2} (A:  44141.82600000 ;B:      1.42385544 ;C:  52175.80628315),
{3} (A:  10094.47900000 ;B:      4.47466326 ;C:  78263.70942472),
{4} (A:   2432.80400000 ;B:      1.24226083 ;C: 104351.61256630),
{5} (A:   1624.36700000 ;B:      0.00000000 ;C:      0.00000000),
{6} (A:    603.99600000 ;B:      4.29303117 ;C: 130439.51570787),
{7} (A:    152.85100000 ;B:      1.06060780 ;C: 156527.41884945),
{8} (A:     39.20200000 ;B:      4.11136751 ;C: 182615.32199102));
{R2 -------------------------}
NR2=7;
R2:Array[1..NR2]  of TPlanTerm=(
{1} (A:   3117.86700000 ;B:      3.08231840 ;C:  26087.90314157),
{2} (A:   1245.39600000 ;B:      6.15183317 ;C:  52175.80628315),
{3} (A:    424.82200000 ;B:      2.92583353 ;C:  78263.70942472),
{4} (A:    136.13000000 ;B:      5.97983926 ;C: 104351.61256630),
{5} (A:     42.17500000 ;B:      2.74936981 ;C: 130439.51570787),
{6} (A:     21.75900000 ;B:      3.14159265 ;C:      0.00000000),
{7} (A:     12.79300000 ;B:      5.80143162 ;C: 156527.41884945));
{R3 -------------------------}
NR3=5;
R3:Array[1..NR3]  of TPlanTerm=(
{1} (A:     32.67600000 ;B:      1.67971635 ;C:  26087.90314157),
{2} (A:     24.16600000 ;B:      4.63403169 ;C:  52175.80628315),
{3} (A:     12.13300000 ;B:      1.38983782 ;C:  78263.70942472),
{4} (A:      5.14000000 ;B:      4.43915387 ;C: 104351.61256630),
{5} (A:      1.98100000 ;B:      1.20733880 ;C: 130439.51570787));
{R4 -------------------------}
NR4=0;
{R5 -------------------------}

NR5=0;

CMercury:RPlanConsts=(
  NLTermos:(NL0,NL1,NL2,NL3,NL4,NL5);
  NBTermos:(NB0,NB1,NB2,NB3,NB4,NB5);
  NRTermos:(NR0,NR1,NR2,NR3,NR4,NR5);
  LTermos:(@L0,@L1,@L2,@L3,@L4,@L5);
  BTermos:(@B0,@B1,@B2,@B3,@B4,nil);
  RTermos:(@R0,@R1,@R2,@R3,nil,nil));

implementation

end.
