Unit VSOP87.Mars;   //---------------
 //----------------//
// VSOP87 = Variations Seculaires des Orbiotes Planetaires 1987
//    by Bretagnon and Francou - Bureau des Longitudes of Paris
//
// calculates planet's ecliptical Lon,Lat and Radius ( R from the Sun )
// This method is described in J.Meeus book "Astronomical Algorithms" - Chapter 32
// used as basis for this code.

Interface

uses  VSOP87.PlanetDef;

const
{Termos de L =========================}
{L0 -------------------------}
NL0=69;
L0:Array[1..NL0]  of TPlanTerm=(
{1} (A:620347711.58300006 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:18656368.10000000 ;B:      5.05037100 ;C:   3340.61242670),
{3} (A:1108216.79200000 ;B:      5.40099837 ;C:   6681.22485340),
{4} (A:  91798.39400000 ;B:      5.75478745 ;C:  10021.83728010),
{5} (A:  27744.98700000 ;B:      5.97049513 ;C:      3.52311835),
{6} (A:  12315.89700000 ;B:      0.84956081 ;C:   2810.92146161),
{7} (A:  10610.23000000 ;B:      2.93958525 ;C:   2281.23049651),
{8} (A:   8926.77200000 ;B:      4.15697846 ;C:      0.01725365),
{9} (A:   8715.68800000 ;B:      6.11005160 ;C:  13362.44970680),
{10} (A:   7774.86700000 ;B:      3.33968655 ;C:   5621.84292321),
{11} (A:   6797.55200000 ;B:      0.36462244 ;C:    398.14900341),
{12} (A:   4161.10100000 ;B:      0.22814975 ;C:   2942.46342329),
{13} (A:   3575.07900000 ;B:      1.66186540 ;C:   2544.31441988),
{14} (A:   3075.25000000 ;B:      0.85696597 ;C:    191.44826611),
{15} (A:   2937.54300000 ;B:      6.07893711 ;C:      0.06731030),
{16} (A:   2628.12200000 ;B:      0.64806144 ;C:   3337.08930835),
{17} (A:   2579.84200000 ;B:      0.02996706 ;C:   3344.13554505),
{18} (A:   2389.42000000 ;B:      5.03896401 ;C:    796.29800682),
{19} (A:   1798.80800000 ;B:      0.65634027 ;C:    529.69096509),
{20} (A:   1546.40800000 ;B:      2.91579633 ;C:   1751.53953142),
{21} (A:   1528.14000000 ;B:      1.14979306 ;C:   6151.53388830),
{22} (A:   1286.23200000 ;B:      3.06795925 ;C:   2146.16541648),
{23} (A:   1264.35600000 ;B:      3.62275092 ;C:   5092.15195812),
{24} (A:   1024.90700000 ;B:      3.69334294 ;C:   8962.45534991),
{25} (A:    891.56700000 ;B:      0.18293899 ;C:  16703.06213350),
{26} (A:    858.76000000 ;B:      2.40093704 ;C:   2914.01423582),
{27} (A:    832.72400000 ;B:      4.49495753 ;C:   3340.62968035),
{28} (A:    832.71800000 ;B:      2.46418591 ;C:   3340.59517305),
{29} (A:    748.72400000 ;B:      3.82248399 ;C:    155.42039943),
{30} (A:    723.86300000 ;B:      0.67497566 ;C:   3738.76143011),
{31} (A:    712.89900000 ;B:      3.66336015 ;C:   1059.38193019),
{32} (A:    655.16300000 ;B:      0.48864075 ;C:   3127.31333126),
{33} (A:    635.55700000 ;B:      2.92182704 ;C:   8432.76438482),
{34} (A:    552.74600000 ;B:      4.47478863 ;C:   1748.01641307),
{35} (A:    550.47200000 ;B:      3.81001205 ;C:      0.98032107),
{36} (A:    472.16400000 ;B:      3.62547819 ;C:   1194.44701022),
{37} (A:    425.97200000 ;B:      0.55365138 ;C:   6283.07584999),
{38} (A:    415.13200000 ;B:      0.49662315 ;C:    213.29909544),
{39} (A:    312.14100000 ;B:      0.99853323 ;C:   6677.70173505),
{40} (A:    306.55200000 ;B:      0.38052863 ;C:   6684.74797175),
{41} (A:    302.37700000 ;B:      4.48618150 ;C:   3532.06069281),
{42} (A:    299.39600000 ;B:      2.78323706 ;C:   6254.62666252),
{43} (A:    293.19900000 ;B:      4.22131278 ;C:     20.77539549),
{44} (A:    283.60000000 ;B:      5.76885494 ;C:   3149.16416059),
{45} (A:    281.07300000 ;B:      5.88163373 ;C:   1349.86740966),
{46} (A:    274.03500000 ;B:      0.13372501 ;C:   3340.67973700),
{47} (A:    274.02800000 ;B:      0.54222142 ;C:   3340.54511640),
{48} (A:    238.85700000 ;B:      5.37155472 ;C:   4136.91043352),
{49} (A:    236.11400000 ;B:      5.75504516 ;C:   3333.49887970),
{50} (A:    231.18500000 ;B:      1.28240685 ;C:   3870.30339179),
{51} (A:    221.22500000 ;B:      3.50466672 ;C:    382.89653222),
{52} (A:    204.16100000 ;B:      2.82133266 ;C:   1221.84856632),
{53} (A:    193.12600000 ;B:      3.35715138 ;C:      3.59042865),
{54} (A:    188.63900000 ;B:      1.49103016 ;C:   9492.14631500),
{55} (A:    179.19600000 ;B:      1.00561113 ;C:    951.71840625),
{56} (A:    174.06800000 ;B:      2.41360333 ;C:    553.56940284),
{57} (A:    172.11000000 ;B:      0.43943042 ;C:   5486.77784318),
{58} (A:    160.01100000 ;B:      3.94854735 ;C:   4562.46099302),
{59} (A:    144.30500000 ;B:      1.41874193 ;C:    135.06508004),
{60} (A:    139.89700000 ;B:      3.32592516 ;C:   2700.71514039),
{61} (A:    138.24500000 ;B:      4.30145177 ;C:      7.11354700),
{62} (A:    130.99300000 ;B:      4.04491720 ;C:  12303.06777661),
{63} (A:    128.10200000 ;B:      2.20806651 ;C:   1592.59601363),
{64} (A:    128.06200000 ;B:      1.80665643 ;C:   5088.62883977),
{65} (A:    116.94500000 ;B:      3.12805282 ;C:   7903.07341972),
{66} (A:    113.48600000 ;B:      3.70070798 ;C:   1589.07289528),
{67} (A:    110.37500000 ;B:      1.05195080 ;C:    242.72860397),
{68} (A:    104.54100000 ;B:      0.78535382 ;C:   8827.39026987),
{69} (A:    100.09000000 ;B:      3.24343741 ;C:  11773.37681152));
{L1 -------------------------}
NL1=46;
L1:Array[1..NL1]  of TPlanTerm=(
{1} (A:334085627474.34198000 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:1458227.05100000 ;B:      3.60426054 ;C:   3340.61242670),
{3} (A: 164901.34300000 ;B:      3.92631251 ;C:   6681.22485340),
{4} (A:  19963.33800000 ;B:      4.26594061 ;C:  10021.83728010),
{5} (A:   3452.39900000 ;B:      4.73210386 ;C:      3.52311835),
{6} (A:   2485.48000000 ;B:      4.61277567 ;C:  13362.44970680),
{7} (A:    841.55100000 ;B:      4.45858257 ;C:   2281.23049651),
{8} (A:    537.56600000 ;B:      5.01589727 ;C:    398.14900341),
{9} (A:    521.04100000 ;B:      4.99422678 ;C:   3344.13554505),
{10} (A:    432.61400000 ;B:      2.56066403 ;C:    191.44826611),
{11} (A:    429.65600000 ;B:      5.31646162 ;C:    155.42039943),
{12} (A:    381.74700000 ;B:      3.53881289 ;C:    796.29800682),
{13} (A:    314.12900000 ;B:      4.96335266 ;C:  16703.06213350),
{14} (A:    282.80400000 ;B:      3.15967518 ;C:   2544.31441988),
{15} (A:    205.66400000 ;B:      4.56891456 ;C:   2146.16541648),
{16} (A:    168.80500000 ;B:      1.32894813 ;C:   3337.08930835),
{17} (A:    157.58700000 ;B:      4.18501036 ;C:   1751.53953142),
{18} (A:    133.68600000 ;B:      2.23325104 ;C:      0.98032107),
{19} (A:    133.56300000 ;B:      5.97421904 ;C:   1748.01641307),
{20} (A:    117.59100000 ;B:      6.02407214 ;C:   6151.53388830),
{21} (A:    116.56100000 ;B:      2.21347653 ;C:   1059.38193019),
{22} (A:    113.87600000 ;B:      2.12869455 ;C:   1194.44701022),
{23} (A:    113.59500000 ;B:      5.42803224 ;C:   3738.76143011),
{24} (A:     91.09800000 ;B:      1.09627837 ;C:   1349.86740966),
{25} (A:     85.34200000 ;B:      3.90854841 ;C:    553.56940284),
{26} (A:     83.30100000 ;B:      5.29636626 ;C:   6684.74797175),
{27} (A:     80.77600000 ;B:      4.42813406 ;C:    529.69096509),
{28} (A:     79.53100000 ;B:      2.24864266 ;C:   8962.45534991),
{29} (A:     72.94600000 ;B:      2.50189461 ;C:    951.71840625),
{30} (A:     72.50500000 ;B:      5.84208163 ;C:    242.72860397),
{31} (A:     71.48700000 ;B:      3.85636094 ;C:   2914.01423582),
{32} (A:     67.58200000 ;B:      5.02327686 ;C:    382.89653222),
{33} (A:     65.08900000 ;B:      1.01802439 ;C:   3340.59517305),
{34} (A:     65.08900000 ;B:      3.04879604 ;C:   3340.62968035),
{35} (A:     61.50800000 ;B:      4.15183160 ;C:   3149.16416059),
{36} (A:     56.52000000 ;B:      3.88813699 ;C:   4136.91043352),
{37} (A:     48.47700000 ;B:      4.87362122 ;C:    213.29909544),
{38} (A:     47.61300000 ;B:      1.18238046 ;C:   3333.49887970),
{39} (A:     46.58400000 ;B:      1.31452420 ;C:   3185.19202727),
{40} (A:     41.34300000 ;B:      0.71385376 ;C:   1592.59601363),
{41} (A:     40.27200000 ;B:      2.72542481 ;C:      7.11354700),
{42} (A:     40.05500000 ;B:      5.31611875 ;C:  20043.67456020),
{43} (A:     32.88600000 ;B:      5.41067412 ;C:   6283.07584999),
{44} (A:     28.24400000 ;B:      0.04534125 ;C:   9492.14631500),
{45} (A:     26.57900000 ;B:      3.88960725 ;C:   1221.84856632),
{46} (A:     26.55400000 ;B:      5.11271748 ;C:   2700.71514039));
{L2 -------------------------}
NL2=33;
L2:Array[1..NL2]  of TPlanTerm=(
{1} (A:  58015.79100000 ;B:      2.04979463 ;C:   3340.61242670),
{2} (A:  54187.64500000 ;B:      0.00000000 ;C:      0.00000000),
{3} (A:  13908.42600000 ;B:      2.45742360 ;C:   6681.22485340),
{4} (A:   2465.10400000 ;B:      2.80000021 ;C:  10021.83728010),
{5} (A:    398.37900000 ;B:      3.14118428 ;C:  13362.44970680),
{6} (A:    222.02200000 ;B:      3.19436080 ;C:      3.52311835),
{7} (A:    120.95700000 ;B:      0.54325292 ;C:    155.42039943),
{8} (A:     61.51700000 ;B:      3.48529427 ;C:  16703.06213350),
{9} (A:     53.63800000 ;B:      3.54191121 ;C:   3344.13554505),
{10} (A:     34.26800000 ;B:      6.00188499 ;C:   2281.23049651),
{11} (A:     31.66500000 ;B:      4.14015172 ;C:    191.44826611),
{12} (A:     29.83900000 ;B:      1.99870680 ;C:    796.29800682),
{13} (A:     23.16800000 ;B:      4.33403366 ;C:    242.72860397),
{14} (A:     21.65900000 ;B:      3.44532466 ;C:    398.14900341),
{15} (A:     20.37000000 ;B:      5.42191375 ;C:    553.56940284),
{16} (A:     16.22700000 ;B:      0.65678953 ;C:      0.98032107),
{17} (A:     16.04400000 ;B:      6.11000472 ;C:   2146.16541648),
{18} (A:     15.64800000 ;B:      1.22086122 ;C:   1748.01641307),
{19} (A:     14.92700000 ;B:      6.09541784 ;C:   3185.19202727),
{20} (A:     14.41600000 ;B:      4.01923812 ;C:    951.71840625),
{21} (A:     14.31700000 ;B:      2.61851898 ;C:   1349.86740966),
{22} (A:     13.35200000 ;B:      0.60189008 ;C:   1194.44701022),
{23} (A:     11.93400000 ;B:      3.86122163 ;C:   6684.74797175),
{24} (A:     11.26000000 ;B:      4.71822364 ;C:   2544.31441988),
{25} (A:     10.39600000 ;B:      0.25038715 ;C:    382.89653222),
{26} (A:      9.46800000 ;B:      0.68170714 ;C:   1059.38193019),
{27} (A:      9.22900000 ;B:      3.83209092 ;C:  20043.67456020),
{28} (A:      9.00500000 ;B:      3.88271826 ;C:   3738.76143011),
{29} (A:      7.50100000 ;B:      5.46498630 ;C:   1751.53953142),
{30} (A:      6.85900000 ;B:      2.57522504 ;C:   3149.16416059),
{31} (A:      6.68100000 ;B:      2.37843690 ;C:   4136.91043352),
{32} (A:      6.49700000 ;B:      5.47773073 ;C:   1592.59601363),
{33} (A:      6.31100000 ;B:      2.34104794 ;C:   3097.88382273));
{L3 -------------------------}
NL3=12;
L3:Array[1..NL3]  of TPlanTerm=(
{1} (A:   1482.42300000 ;B:      0.44434695 ;C:   3340.61242670),
{2} (A:    662.09500000 ;B:      0.88469179 ;C:   6681.22485340),
{3} (A:    188.26800000 ;B:      1.28799982 ;C:  10021.83728010),
{4} (A:     41.47400000 ;B:      1.64850787 ;C:  13362.44970680),
{5} (A:     25.99400000 ;B:      0.00000000 ;C:      0.00000000),
{6} (A:     22.66100000 ;B:      2.05267665 ;C:    155.42039943),
{7} (A:     10.45400000 ;B:      1.58006906 ;C:      3.52311835),
{8} (A:      8.02400000 ;B:      1.99858758 ;C:  16703.06213350),
{9} (A:      4.90000000 ;B:      2.82452458 ;C:    242.72860397),
{10} (A:      3.78200000 ;B:      2.01914273 ;C:   3344.13554505),
{11} (A:      3.17600000 ;B:      4.59144898 ;C:   3185.19202727),
{12} (A:      3.13400000 ;B:      0.65044714 ;C:    553.56940284));
{L4 -------------------------}
NL4=8;
L4:Array[1..NL4]  of TPlanTerm=(
{1} (A:    113.96900000 ;B:      3.14159265 ;C:      0.00000000),
{2} (A:     28.72500000 ;B:      5.63662412 ;C:   6681.22485340),
{3} (A:     24.44700000 ;B:      5.13868481 ;C:   3340.61242670),
{4} (A:     11.18700000 ;B:      6.03161074 ;C:  10021.83728010),
{5} (A:      3.25200000 ;B:      0.13228351 ;C:  13362.44970680),
{6} (A:      3.19000000 ;B:      3.56267988 ;C:    155.42039943),
{7} (A:      0.78700000 ;B:      0.49340783 ;C:  16703.06213350),
{8} (A:      0.77600000 ;B:      1.31734532 ;C:    242.72860397));
{L5 -------------------------}
NL5=2;
L5:Array[1..NL5]  of TPlanTerm=(
{1} (A:      0.86800000 ;B:      3.14159265 ;C:      0.00000000),
{2} (A:      0.71000000 ;B:      4.04089997 ;C:   6681.22485340));
{Termos de B =========================}
{B0 -------------------------}
NB0=16;
B0:Array[1..NB0]  of TPlanTerm=(
{1} (A:3197134.98600000 ;B:      3.76832042 ;C:   3340.61242670),
{2} (A: 298033.23400000 ;B:      4.10616996 ;C:   6681.22485340),
{3} (A: 289104.74200000 ;B:      0.00000000 ;C:      0.00000000),
{4} (A:  31365.53800000 ;B:      4.44651053 ;C:  10021.83728010),
{5} (A:   3484.10000000 ;B:      4.78812548 ;C:  13362.44970680),
{6} (A:    443.40100000 ;B:      5.02642620 ;C:   3344.13554505),
{7} (A:    442.99900000 ;B:      5.65233016 ;C:   3337.08930835),
{8} (A:    399.10900000 ;B:      5.13056815 ;C:  16703.06213350),
{9} (A:    292.50600000 ;B:      3.79290645 ;C:   2281.23049651),
{10} (A:    181.98200000 ;B:      6.13648012 ;C:   6151.53388830),
{11} (A:    163.15900000 ;B:      4.26399627 ;C:    529.69096509),
{12} (A:    159.67800000 ;B:      2.23194610 ;C:   1059.38193019),
{13} (A:    149.29700000 ;B:      2.16501210 ;C:   5621.84292321),
{14} (A:    142.68600000 ;B:      1.18215016 ;C:   3340.59517305),
{15} (A:    142.68500000 ;B:      3.21292181 ;C:   3340.62968035),
{16} (A:    139.32300000 ;B:      2.41796344 ;C:   8962.45534991));
{B1 -------------------------}
NB1=9;
B1:Array[1..NB1]  of TPlanTerm=(
{1} (A: 350068.84500000 ;B:      5.36847836 ;C:   3340.61242670),
{2} (A:  14116.03000000 ;B:      3.14159265 ;C:      0.00000000),
{3} (A:   9670.75500000 ;B:      5.47877787 ;C:   6681.22485340),
{4} (A:   1471.91800000 ;B:      3.20205767 ;C:  10021.83728010),
{5} (A:    425.86400000 ;B:      3.40843813 ;C:  13362.44970680),
{6} (A:    102.03900000 ;B:      0.77617286 ;C:   3337.08930835),
{7} (A:     78.84800000 ;B:      3.71768294 ;C:  16703.06213350),
{8} (A:     32.70800000 ;B:      3.45803724 ;C:   5621.84292321),
{9} (A:     26.17100000 ;B:      2.48293558 ;C:   2281.23049651));
{B2 -------------------------}
NB2=7;
B2:Array[1..NB2]  of TPlanTerm=(
{1} (A:  16726.69000000 ;B:      0.60221392 ;C:   3340.61242670),
{2} (A:   4986.79900000 ;B:      3.14159265 ;C:      0.00000000),
{3} (A:    302.14100000 ;B:      5.55871276 ;C:   6681.22485340),
{4} (A:     25.76700000 ;B:      1.89662673 ;C:  13362.44970680),
{5} (A:     21.45200000 ;B:      0.91749969 ;C:  10021.83728010),
{6} (A:     11.82000000 ;B:      2.24240739 ;C:   3337.08930835),
{7} (A:      7.98500000 ;B:      2.24892867 ;C:  16703.06213350));
{B3 -------------------------}
NB3=4;
B3:Array[1..NB3]  of TPlanTerm=(
{1} (A:    606.50600000 ;B:      1.98050634 ;C:   3340.61242670),
{2} (A:     42.61100000 ;B:      0.00000000 ;C:      0.00000000),
{3} (A:     13.65200000 ;B:      1.79588229 ;C:   6681.22485340),
{4} (A:      2.73000000 ;B:      3.45377082 ;C:  10021.83728010));
{B4 -------------------------}
NB4=3;
B4:Array[1..NB4]  of TPlanTerm=(
{1} (A:     13.36900000 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:     11.33400000 ;B:      3.45724353 ;C:   3340.61242670),
{3} (A:      0.74400000 ;B:      0.50445805 ;C:   6681.22485340));
{B5 -------------------------}
NB5=0;
{Termos de R =========================}
{R0 -------------------------}
NR0=45;
R0:Array[1..NR0]  of TPlanTerm=(
{1} (A:153033488.27599999 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:14184953.15300000 ;B:      3.47971284 ;C:   3340.61242670),
{3} (A: 660776.35700000 ;B:      3.81783442 ;C:   6681.22485340),
{4} (A:  46179.11700000 ;B:      4.15595316 ;C:  10021.83728010),
{5} (A:   8109.73800000 ;B:      5.55958460 ;C:   2810.92146161),
{6} (A:   7485.31500000 ;B:      1.77238998 ;C:   5621.84292321),
{7} (A:   5523.19300000 ;B:      1.36436319 ;C:   2281.23049651),
{8} (A:   3825.16000000 ;B:      4.49407182 ;C:  13362.44970680),
{9} (A:   2484.38500000 ;B:      4.92545578 ;C:   2942.46342329),
{10} (A:   2306.53900000 ;B:      0.09081742 ;C:   2544.31441988),
{11} (A:   1999.39900000 ;B:      5.36059605 ;C:   3337.08930835),
{12} (A:   1960.19800000 ;B:      4.74249386 ;C:   3344.13554505),
{13} (A:   1167.11500000 ;B:      2.11261501 ;C:   5092.15195812),
{14} (A:   1102.82800000 ;B:      5.00908264 ;C:    398.14900341),
{15} (A:    992.25200000 ;B:      5.83862401 ;C:   6151.53388830),
{16} (A:    899.07700000 ;B:      4.40790434 ;C:    529.69096509),
{17} (A:    807.34800000 ;B:      2.10216647 ;C:   1059.38193019),
{18} (A:    797.91000000 ;B:      3.44839026 ;C:    796.29800682),
{19} (A:    740.98000000 ;B:      1.49906337 ;C:   2146.16541648),
{20} (A:    725.58300000 ;B:      1.24516913 ;C:   8432.76438482),
{21} (A:    692.34000000 ;B:      2.13378815 ;C:   8962.45534991),
{22} (A:    633.14400000 ;B:      0.89353285 ;C:   3340.59517305),
{23} (A:    633.14000000 ;B:      2.92430448 ;C:   3340.62968035),
{24} (A:    629.97600000 ;B:      1.28738136 ;C:   1751.53953142),
{25} (A:    574.35200000 ;B:      0.82896196 ;C:   2914.01423582),
{26} (A:    526.18700000 ;B:      5.38292276 ;C:   3738.76143011),
{27} (A:    472.77600000 ;B:      5.19850458 ;C:   3127.31333126),
{28} (A:    348.09500000 ;B:      4.83219199 ;C:  16703.06213350),
{29} (A:    283.70200000 ;B:      2.90692295 ;C:   3532.06069281),
{30} (A:    279.55200000 ;B:      5.25749248 ;C:   6283.07584999),
{31} (A:    275.50100000 ;B:      1.21767968 ;C:   6254.62666252),
{32} (A:    275.22400000 ;B:      2.90818884 ;C:   1748.01641307),
{33} (A:    269.89100000 ;B:      3.76394729 ;C:   5884.92684658),
{34} (A:    239.13300000 ;B:      2.03669896 ;C:   1194.44701022),
{35} (A:    233.82700000 ;B:      5.10546493 ;C:   5486.77784318),
{36} (A:    228.12800000 ;B:      3.25529021 ;C:   6872.67311951),
{37} (A:    223.19000000 ;B:      4.19861594 ;C:   3149.16416059),
{38} (A:    219.42800000 ;B:      5.58340249 ;C:    191.44826611),
{39} (A:    208.33600000 ;B:      4.84626442 ;C:   3340.67973700),
{40} (A:    208.33300000 ;B:      5.25476081 ;C:   3340.54511640),
{41} (A:    186.21300000 ;B:      5.69871556 ;C:   6677.70173505),
{42} (A:    182.68600000 ;B:      5.08062683 ;C:   6684.74797175),
{43} (A:    178.61300000 ;B:      4.18423026 ;C:   3333.49887970),
{44} (A:    175.99500000 ;B:      5.95341786 ;C:   3870.30339179),
{45} (A:    163.53400000 ;B:      3.79889068 ;C:   4136.91043352));
{R1 -------------------------}
NR1=27;
R1:Array[1..NR1]  of TPlanTerm=(
{1} (A:1107433.34000000 ;B:      2.03250525 ;C:   3340.61242670),
{2} (A: 103175.88600000 ;B:      2.37071846 ;C:   6681.22485340),
{3} (A:  12877.20000000 ;B:      0.00000000 ;C:      0.00000000),
{4} (A:  10815.88000000 ;B:      2.70888094 ;C:  10021.83728010),
{5} (A:   1194.55000000 ;B:      3.04702183 ;C:  13362.44970680),
{6} (A:    438.57900000 ;B:      2.88835073 ;C:   2281.23049651),
{7} (A:    395.69800000 ;B:      3.42324611 ;C:   3344.13554505),
{8} (A:    182.57200000 ;B:      1.58428644 ;C:   2544.31441988),
{9} (A:    135.85000000 ;B:      3.38507018 ;C:  16703.06213350),
{10} (A:    128.36200000 ;B:      6.04343360 ;C:   3337.08930835),
{11} (A:    128.20400000 ;B:      0.62991221 ;C:   1059.38193019),
{12} (A:    127.06800000 ;B:      1.95389776 ;C:    796.29800682),
{13} (A:    118.44300000 ;B:      2.99761345 ;C:   2146.16541648),
{14} (A:     87.53700000 ;B:      3.42052759 ;C:    398.14900341),
{15} (A:     83.02600000 ;B:      3.85574987 ;C:   3738.76143011),
{16} (A:     75.59800000 ;B:      4.45101839 ;C:   6151.53388830),
{17} (A:     71.99900000 ;B:      2.76442181 ;C:    529.69096509),
{18} (A:     66.54200000 ;B:      2.54892603 ;C:   1751.53953142),
{19} (A:     66.43000000 ;B:      4.40597550 ;C:   1748.01641307),
{20} (A:     57.51800000 ;B:      0.54354328 ;C:   1194.44701022),
{21} (A:     54.31400000 ;B:      0.67750943 ;C:   8962.45534991),
{22} (A:     51.03500000 ;B:      3.72585409 ;C:   6684.74797175),
{23} (A:     49.42800000 ;B:      5.72959428 ;C:   3340.59517305),
{24} (A:     49.42400000 ;B:      1.47717922 ;C:   3340.62968035),
{25} (A:     48.31800000 ;B:      2.58061691 ;C:   3149.16416059),
{26} (A:     47.86300000 ;B:      2.28527897 ;C:   2914.01423582),
{27} (A:     38.95300000 ;B:      2.31900091 ;C:   4136.91043352));
{R2 -------------------------}
NR2=11;
R2:Array[1..NR2]  of TPlanTerm=(
{1} (A:  44242.24700000 ;B:      0.47930604 ;C:   3340.61242670),
{2} (A:   8138.04200000 ;B:      0.86998398 ;C:   6681.22485340),
{3} (A:   1274.91500000 ;B:      1.22594051 ;C:  10021.83728010),
{4} (A:    187.38700000 ;B:      1.57298992 ;C:  13362.44970680),
{5} (A:     52.39600000 ;B:      3.14159265 ;C:      0.00000000),
{6} (A:     40.74400000 ;B:      1.97080175 ;C:   3344.13554505),
{7} (A:     26.61600000 ;B:      1.91665616 ;C:  16703.06213350),
{8} (A:     17.82500000 ;B:      4.43499505 ;C:   2281.23049651),
{9} (A:     11.71300000 ;B:      4.52510454 ;C:   3185.19202727),
{10} (A:     10.20900000 ;B:      5.39143470 ;C:   1059.38193019),
{11} (A:      9.95000000 ;B:      0.41870577 ;C:    796.29800682));
{R3 -------------------------}
NR3=6;
R3:Array[1..NR3]  of TPlanTerm=(
{1} (A:   1113.10700000 ;B:      5.14987350 ;C:   3340.61242670),
{2} (A:    424.44600000 ;B:      5.61343766 ;C:   6681.22485340),
{3} (A:    100.04400000 ;B:      5.99726827 ;C:  10021.83728010),
{4} (A:     19.60600000 ;B:      0.07633062 ;C:  13362.44970680),
{5} (A:      4.69300000 ;B:      3.14159265 ;C:      0.00000000),
{6} (A:      3.47700000 ;B:      0.42951908 ;C:  16703.06213350));
{R4 -------------------------}
NR4=4;
R4:Array[1..NR4]  of TPlanTerm=(
{1} (A:     19.55200000 ;B:      3.58211650 ;C:   3340.61242670),
{2} (A:     16.32300000 ;B:      4.05116077 ;C:   6681.22485340),
{3} (A:      5.84800000 ;B:      4.46383962 ;C:  10021.83728010),
{4} (A:      1.53200000 ;B:      4.84374322 ;C:  13362.44970680));
{R5 -------------------------}

NR5=0;

CMars:RPlanConsts=(
  NLTermos:(NL0,NL1,NL2,NL3,NL4,NL5);
  NBTermos:(NB0,NB1,NB2,NB3,NB4,NB5);
  NRTermos:(NR0,NR1,NR2,NR3,NR4,NR5);
  LTermos:(@L0,@L1,@L2,@L3,@L4,@L5);
  BTermos:(@B0,@B1,@B2,@B3,@B4,Nil);
  RTermos:(@R0,@R1,@R2,@R3,@R4,Nil));

implementation

end.
