Unit VSOP87.Jupiter;  //--------------------
 //------------------//
// VSOP87 = Variations Seculaires des Orbiotes Planetaires 1987
//    by Bretagnon and Francou - Bureau des Longitudes of Paris
//
// calculates planet's ecliptical Lon,Lat and Radius ( R from the Sun )
// This method is described in J.Meeus book "Astronomical Algorithms" - Chapter 32
// used as basis for this code.

Interface

uses  VSOP87.PlanetDef;

const
{Termos de L =========================}
{L0 -------------------------}
NL0=64;
L0:Array[1..NL0]  of TPlanTerm=(
{1} (A:59954691.49500000 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:9695898.71100000 ;B:      5.06191793 ;C:    529.69096509),
{3} (A: 573610.14500000 ;B:      1.44406206 ;C:      7.11354700),
{4} (A: 306389.18000000 ;B:      5.41734730 ;C:   1059.38193019),
{5} (A:  97178.28000000 ;B:      4.14264709 ;C:    632.78373931),
{6} (A:  72903.09600000 ;B:      3.64042909 ;C:    522.57741809),
{7} (A:  64263.98600000 ;B:      3.41145185 ;C:    103.09277422),
{8} (A:  39806.05100000 ;B:      2.29376745 ;C:    419.48464388),
{9} (A:  38857.78000000 ;B:      1.27231725 ;C:    316.39186966),
{10} (A:  27964.62200000 ;B:      1.78454589 ;C:    536.80451210),
{11} (A:  13589.73800000 ;B:      5.77481032 ;C:   1589.07289528),
{12} (A:   8768.68600000 ;B:      3.63000324 ;C:    949.17560897),
{13} (A:   8246.36200000 ;B:      3.58227962 ;C:    206.18554844),
{14} (A:   7368.05700000 ;B:      5.08101126 ;C:    735.87651353),
{15} (A:   6263.17100000 ;B:      0.02497644 ;C:    213.29909544),
{16} (A:   6114.05000000 ;B:      4.51319532 ;C:   1162.47470441),
{17} (A:   5305.45700000 ;B:      4.18625053 ;C:   1052.26838319),
{18} (A:   5305.28300000 ;B:      1.30671237 ;C:     14.22709400),
{19} (A:   4905.41900000 ;B:      1.32084632 ;C:    110.20632122),
{20} (A:   4647.24900000 ;B:      4.69958109 ;C:      3.93215326),
{21} (A:   3045.00900000 ;B:      4.31675960 ;C:    426.59819088),
{22} (A:   2610.00100000 ;B:      1.56667595 ;C:    846.08283475),
{23} (A:   2028.19100000 ;B:      1.06376547 ;C:      3.18139374),
{24} (A:   1920.95900000 ;B:      0.97168929 ;C:    639.89728631),
{25} (A:   1764.76800000 ;B:      2.14148078 ;C:   1066.49547719),
{26} (A:   1722.98300000 ;B:      3.88036009 ;C:   1265.56747863),
{27} (A:   1633.21700000 ;B:      3.58201090 ;C:    515.46387109),
{28} (A:   1431.99700000 ;B:      4.29683690 ;C:    625.67019231),
{29} (A:    973.27800000 ;B:      4.09764957 ;C:     95.97922722),
{30} (A:    884.43900000 ;B:      2.43701426 ;C:    412.37109687),
{31} (A:    732.87500000 ;B:      6.08534113 ;C:    838.96928775),
{32} (A:    731.07200000 ;B:      3.80591234 ;C:   1581.95934828),
{33} (A:    709.19000000 ;B:      1.29272574 ;C:    742.99006053),
{34} (A:    691.92800000 ;B:      6.13368223 ;C:   2118.76386038),
{35} (A:    614.46400000 ;B:      4.10853497 ;C:   1478.86657406),
{36} (A:    581.90200000 ;B:      4.53967718 ;C:    309.27832266),
{37} (A:    495.22400000 ;B:      3.75567461 ;C:    323.50541666),
{38} (A:    440.85400000 ;B:      2.95818461 ;C:    454.90936653),
{39} (A:    417.26600000 ;B:      1.03554430 ;C:      2.44768055),
{40} (A:    389.86400000 ;B:      4.89716106 ;C:   1692.16566950),
{41} (A:    375.65700000 ;B:      4.70299125 ;C:   1368.66025285),
{42} (A:    341.00600000 ;B:      5.71452526 ;C:    533.62311836),
{43} (A:    330.45800000 ;B:      4.74049819 ;C:      0.04818411),
{44} (A:    261.54000000 ;B:      1.87652461 ;C:      0.96320785),
{45} (A:    261.00900000 ;B:      0.82047246 ;C:    380.12776796),
{46} (A:    256.56800000 ;B:      3.72410724 ;C:    199.07200144),
{47} (A:    244.17000000 ;B:      5.22020879 ;C:    728.76296653),
{48} (A:    235.14100000 ;B:      1.22693908 ;C:    909.81873305),
{49} (A:    220.38200000 ;B:      1.65115016 ;C:    543.91805910),
{50} (A:    207.32700000 ;B:      1.85461667 ;C:    525.75881183),
{51} (A:    201.99600000 ;B:      1.80684574 ;C:   1375.77379985),
{52} (A:    197.04600000 ;B:      5.29252149 ;C:   1155.36115741),
{53} (A:    175.19100000 ;B:      3.72966555 ;C:    942.06206197),
{54} (A:    175.18400000 ;B:      3.22634903 ;C:   1898.35121794),
{55} (A:    174.80900000 ;B:      5.90973505 ;C:    956.28915597),
{56} (A:    157.90900000 ;B:      4.36483922 ;C:   1795.25844372),
{57} (A:    150.50200000 ;B:      3.90625023 ;C:     74.78159857),
{58} (A:    149.36800000 ;B:      4.37745104 ;C:   1685.05212250),
{59} (A:    141.44500000 ;B:      3.13568358 ;C:    491.55792946),
{60} (A:    137.87100000 ;B:      1.31797921 ;C:   1169.58825141),
{61} (A:    130.53100000 ;B:      4.16867945 ;C:   1045.15483619),
{62} (A:    117.49500000 ;B:      2.50022141 ;C:   1596.18644228),
{63} (A:    116.75700000 ;B:      3.38920921 ;C:      0.52126486),
{64} (A:    105.89500000 ;B:      4.55439798 ;C:    526.50957136));
{L1 -------------------------}
NL1=61;
L1:Array[1..NL1]  of TPlanTerm=(
{1} (A:52993480757.49700160 ;B:      0.00000000 ;C:      0.00000000),
{2} (A: 489741.19400000 ;B:      4.22066690 ;C:    529.69096509),
{3} (A: 228918.53800000 ;B:      6.02647464 ;C:      7.11354700),
{4} (A:  27655.38000000 ;B:      4.57265957 ;C:   1059.38193019),
{5} (A:  20720.94300000 ;B:      5.45938936 ;C:    522.57741809),
{6} (A:  12105.73200000 ;B:      0.16985765 ;C:    536.80451210),
{7} (A:   6068.05100000 ;B:      4.42419502 ;C:    103.09277422),
{8} (A:   5433.92400000 ;B:      3.98478383 ;C:    419.48464388),
{9} (A:   4237.79500000 ;B:      5.89009351 ;C:     14.22709400),
{10} (A:   2211.85400000 ;B:      5.26771447 ;C:    206.18554844),
{11} (A:   1745.91900000 ;B:      4.92669378 ;C:   1589.07289528),
{12} (A:   1295.76900000 ;B:      5.55132765 ;C:      3.18139374),
{13} (A:   1173.12900000 ;B:      5.85647304 ;C:   1052.26838319),
{14} (A:   1163.41100000 ;B:      0.51450895 ;C:      3.93215326),
{15} (A:   1098.73500000 ;B:      5.30704982 ;C:    515.46387109),
{16} (A:   1007.21600000 ;B:      0.46478399 ;C:    735.87651353),
{17} (A:   1003.57400000 ;B:      3.15040302 ;C:    426.59819088),
{18} (A:    847.67800000 ;B:      5.75805850 ;C:    110.20632122),
{19} (A:    827.32900000 ;B:      4.80312016 ;C:    213.29909544),
{20} (A:    816.39700000 ;B:      0.58643055 ;C:   1066.49547719),
{21} (A:    725.44700000 ;B:      5.51827471 ;C:    639.89728631),
{22} (A:    567.84500000 ;B:      5.98867049 ;C:    625.67019231),
{23} (A:    474.18100000 ;B:      4.13245269 ;C:    412.37109687),
{24} (A:    412.93000000 ;B:      5.73652891 ;C:     95.97922722),
{25} (A:    345.24900000 ;B:      4.24159565 ;C:    632.78373931),
{26} (A:    335.81700000 ;B:      3.73248749 ;C:   1162.47470441),
{27} (A:    234.34000000 ;B:      4.03469970 ;C:    949.17560897),
{28} (A:    234.06600000 ;B:      6.24302227 ;C:    309.27832266),
{29} (A:    198.52500000 ;B:      1.50458443 ;C:    838.96928775),
{30} (A:    194.78400000 ;B:      2.21879011 ;C:    323.50541666),
{31} (A:    186.89900000 ;B:      6.08620566 ;C:    742.99006053),
{32} (A:    183.93800000 ;B:      6.27963589 ;C:    543.91805910),
{33} (A:    171.38000000 ;B:      5.41655984 ;C:    199.07200144),
{34} (A:    130.77100000 ;B:      0.62643377 ;C:    728.76296653),
{35} (A:    115.39300000 ;B:      0.68019050 ;C:    846.08283475),
{36} (A:    115.04700000 ;B:      5.28641699 ;C:   2118.76386038),
{37} (A:    107.57500000 ;B:      4.49282760 ;C:    956.28915597),
{38} (A:     79.68600000 ;B:      5.82412400 ;C:   1045.15483619),
{39} (A:     71.64300000 ;B:      5.34162650 ;C:    942.06206197),
{40} (A:     69.61800000 ;B:      5.97263450 ;C:    532.87235883),
{41} (A:     66.82400000 ;B:      5.73365127 ;C:     21.34064100),
{42} (A:     65.63500000 ;B:      0.12924191 ;C:    526.50957136),
{43} (A:     64.85000000 ;B:      6.08803490 ;C:   1581.95934828),
{44} (A:     58.50900000 ;B:      0.58626971 ;C:   1155.36115741),
{45} (A:     57.93900000 ;B:      0.99453087 ;C:   1596.18644228),
{46} (A:     57.36800000 ;B:      5.96851305 ;C:   1169.58825141),
{47} (A:     56.60000000 ;B:      1.41198439 ;C:    533.62311836),
{48} (A:     54.93500000 ;B:      5.42806384 ;C:     10.29494074),
{49} (A:     52.30900000 ;B:      5.72661448 ;C:    117.31986822),
{50} (A:     52.01600000 ;B:      0.22981299 ;C:   1368.66025285),
{51} (A:     50.41800000 ;B:      6.08075148 ;C:    525.75881183),
{52} (A:     47.41800000 ;B:      3.62611843 ;C:   1478.86657406),
{53} (A:     46.67800000 ;B:      0.51144073 ;C:   1265.56747863),
{54} (A:     39.88800000 ;B:      4.16158014 ;C:   1692.16566950),
{55} (A:     33.55800000 ;B:      0.09913905 ;C:    302.16477566),
{56} (A:     32.82700000 ;B:      5.03596689 ;C:    220.41264244),
{57} (A:     32.44900000 ;B:      5.37492531 ;C:    508.35032409),
{58} (A:     29.48300000 ;B:      5.42208897 ;C:   1272.68102563),
{59} (A:     29.37900000 ;B:      3.35927242 ;C:      4.66586645),
{60} (A:     29.30700000 ;B:      0.75907910 ;C:     88.86568022),
{61} (A:     25.19500000 ;B:      1.60723063 ;C:    831.85574075));
{L2 -------------------------}
NL2=57;
L2:Array[1..NL2]  of TPlanTerm=(
{1} (A:  47233.59800000 ;B:      4.32148324 ;C:      7.11354700),
{2} (A:  38965.55000000 ;B:      0.00000000 ;C:      0.00000000),
{3} (A:  30629.05300000 ;B:      2.93021440 ;C:    529.69096509),
{4} (A:   3189.31700000 ;B:      1.05504616 ;C:    522.57741809),
{5} (A:   2729.29200000 ;B:      4.84545481 ;C:    536.80451210),
{6} (A:   2723.35800000 ;B:      3.41411527 ;C:   1059.38193019),
{7} (A:   1721.06900000 ;B:      4.18734385 ;C:     14.22709400),
{8} (A:    383.25800000 ;B:      5.76790714 ;C:    419.48464388),
{9} (A:    377.52400000 ;B:      0.76048965 ;C:    515.46387109),
{10} (A:    367.49800000 ;B:      6.05509120 ;C:    103.09277422),
{11} (A:    337.38600000 ;B:      3.78644384 ;C:      3.18139374),
{12} (A:    308.20000000 ;B:      0.69356654 ;C:    206.18554844),
{13} (A:    218.40800000 ;B:      3.81389191 ;C:   1589.07289528),
{14} (A:    198.88300000 ;B:      5.33996443 ;C:   1066.49547719),
{15} (A:    197.44500000 ;B:      2.48356402 ;C:      3.93215326),
{16} (A:    155.86200000 ;B:      1.40642426 ;C:   1052.26838319),
{17} (A:    146.23000000 ;B:      3.81373197 ;C:    639.89728631),
{18} (A:    141.93200000 ;B:      1.63435169 ;C:    426.59819088),
{19} (A:    129.57000000 ;B:      5.83738873 ;C:    412.37109687),
{20} (A:    117.32700000 ;B:      1.41435463 ;C:    625.67019231),
{21} (A:     96.73300000 ;B:      4.03383428 ;C:    110.20632122),
{22} (A:     90.82300000 ;B:      1.10630629 ;C:     95.97922722),
{23} (A:     87.29200000 ;B:      2.52235175 ;C:    632.78373931),
{24} (A:     78.76900000 ;B:      4.63726131 ;C:    543.91805910),
{25} (A:     72.39200000 ;B:      2.21716670 ;C:    735.87651353),
{26} (A:     58.47500000 ;B:      0.83216317 ;C:    199.07200144),
{27} (A:     56.91000000 ;B:      3.12292060 ;C:    213.29909544),
{28} (A:     48.62200000 ;B:      1.67283792 ;C:    309.27832266),
{29} (A:     40.15000000 ;B:      4.02485445 ;C:     21.34064100),
{30} (A:     39.78400000 ;B:      0.62416946 ;C:    323.50541666),
{31} (A:     35.71800000 ;B:      2.32581247 ;C:    728.76296653),
{32} (A:     29.25500000 ;B:      3.60838328 ;C:     10.29494074),
{33} (A:     27.81400000 ;B:      3.23992014 ;C:    838.96928775),
{34} (A:     25.99300000 ;B:      4.50118298 ;C:    742.99006053),
{35} (A:     25.62000000 ;B:      2.51240624 ;C:   1162.47470441),
{36} (A:     25.19400000 ;B:      1.21868111 ;C:   1045.15483619),
{37} (A:     23.59100000 ;B:      3.00532139 ;C:    956.28915597),
{38} (A:     19.45800000 ;B:      4.29028645 ;C:    532.87235883),
{39} (A:     17.66000000 ;B:      0.80953942 ;C:    508.35032409),
{40} (A:     17.05800000 ;B:      4.20001978 ;C:   2118.76386038),
{41} (A:     17.04000000 ;B:      1.83402147 ;C:    526.50957136),
{42} (A:     15.35500000 ;B:      5.81037987 ;C:   1596.18644228),
{43} (A:     15.29200000 ;B:      0.68174165 ;C:    942.06206197),
{44} (A:     14.66100000 ;B:      3.99989623 ;C:    117.31986822),
{45} (A:     13.92000000 ;B:      5.95169568 ;C:    316.39186966),
{46} (A:     13.63900000 ;B:      1.80336678 ;C:    302.16477566),
{47} (A:     13.23000000 ;B:      2.51856644 ;C:     88.86568022),
{48} (A:     12.75600000 ;B:      4.36856232 ;C:   1169.58825141),
{49} (A:     10.98600000 ;B:      4.43586635 ;C:    525.75881183),
{50} (A:      9.68100000 ;B:      1.71563161 ;C:   1581.95934828),
{51} (A:      9.43700000 ;B:      2.17684563 ;C:   1155.36115741),
{52} (A:      8.81200000 ;B:      3.29452783 ;C:    220.41264244),
{53} (A:      8.69000000 ;B:      3.31924494 ;C:    831.85574075),
{54} (A:      7.82300000 ;B:      5.75672228 ;C:    846.08283475),
{55} (A:      7.54900000 ;B:      2.70955517 ;C:    533.62311836),
{56} (A:      6.68500000 ;B:      2.17560093 ;C:   1265.56747863),
{57} (A:      6.28500000 ;B:      0.49939864 ;C:    949.17560897));
{L3 -------------------------}
NL3=39;
L3:Array[1..NL3]  of TPlanTerm=(
{1} (A:   6501.66500000 ;B:      2.59862880 ;C:      7.11354700),
{2} (A:   1356.52400000 ;B:      1.34635886 ;C:    529.69096509),
{3} (A:    470.71600000 ;B:      2.47503978 ;C:     14.22709400),
{4} (A:    416.96000000 ;B:      3.24451243 ;C:    536.80451210),
{5} (A:    352.85100000 ;B:      2.97360159 ;C:    522.57741809),
{6} (A:    154.88000000 ;B:      2.07565586 ;C:   1059.38193019),
{7} (A:     86.77100000 ;B:      2.51431584 ;C:    515.46387109),
{8} (A:     44.37800000 ;B:      0.00000000 ;C:      0.00000000),
{9} (A:     33.53800000 ;B:      3.82633794 ;C:   1066.49547719),
{10} (A:     28.45700000 ;B:      2.44754756 ;C:    206.18554844),
{11} (A:     23.73700000 ;B:      1.27667172 ;C:    412.37109687),
{12} (A:     22.64400000 ;B:      2.98231327 ;C:    543.91805910),
{13} (A:     19.79800000 ;B:      2.10099934 ;C:    639.89728631),
{14} (A:     19.74000000 ;B:      1.40255939 ;C:    419.48464388),
{15} (A:     18.76800000 ;B:      1.59368404 ;C:    103.09277422),
{16} (A:     17.03300000 ;B:      2.30214681 ;C:     21.34064100),
{17} (A:     16.77400000 ;B:      2.59821461 ;C:   1589.07289528),
{18} (A:     16.21400000 ;B:      3.14521117 ;C:    625.67019231),
{19} (A:     16.05500000 ;B:      3.36030126 ;C:   1052.26838319),
{20} (A:     13.39200000 ;B:      2.75973892 ;C:     95.97922722),
{21} (A:     13.23400000 ;B:      2.53862244 ;C:    199.07200144),
{22} (A:     12.61100000 ;B:      6.26578110 ;C:    426.59819088),
{23} (A:      8.70100000 ;B:      1.76334961 ;C:     10.29494074),
{24} (A:      8.63700000 ;B:      2.26563256 ;C:    110.20632122),
{25} (A:      6.72500000 ;B:      3.42566433 ;C:    309.27832266),
{26} (A:      6.52700000 ;B:      4.03869563 ;C:    728.76296653),
{27} (A:      5.67500000 ;B:      2.52096418 ;C:    508.35032409),
{28} (A:      5.39900000 ;B:      2.91184687 ;C:   1045.15483619),
{29} (A:      5.36800000 ;B:      5.25196154 ;C:    323.50541666),
{30} (A:      3.99600000 ;B:      4.30290261 ;C:     88.86568022),
{31} (A:      3.85700000 ;B:      3.52381362 ;C:    302.16477566),
{32} (A:      3.77400000 ;B:      4.09125315 ;C:    735.87651353),
{33} (A:      3.26900000 ;B:      1.43175991 ;C:    956.28915597),
{34} (A:      2.78300000 ;B:      4.35817508 ;C:   1596.18644228),
{35} (A:      2.66100000 ;B:      1.25276591 ;C:    213.29909544),
{36} (A:      2.65600000 ;B:      5.01505840 ;C:    838.96928775),
{37} (A:      2.55300000 ;B:      2.23785673 ;C:    117.31986822),
{38} (A:      2.37100000 ;B:      2.89662409 ;C:    742.99006053),
{39} (A:      2.27900000 ;B:      2.35581871 ;C:    942.06206197));
{L4 -------------------------}
NL4=19;
L4:Array[1..NL4]  of TPlanTerm=(
{1} (A:    669.48300000 ;B:      0.85282421 ;C:      7.11354700),
{2} (A:    114.01900000 ;B:      3.14159265 ;C:      0.00000000),
{3} (A:     99.96100000 ;B:      0.74258948 ;C:     14.22709400),
{4} (A:     50.02400000 ;B:      1.65346208 ;C:    536.80451210),
{5} (A:     43.58500000 ;B:      5.82026387 ;C:    529.69096509),
{6} (A:     31.81300000 ;B:      4.85829987 ;C:    522.57741809),
{7} (A:     14.74200000 ;B:      4.29061636 ;C:    515.46387109),
{8} (A:      8.89900000 ;B:      0.71478521 ;C:   1059.38193019),
{9} (A:      4.95700000 ;B:      1.29502259 ;C:    543.91805910),
{10} (A:      4.48400000 ;B:      2.31715517 ;C:   1066.49547719),
{11} (A:      4.25100000 ;B:      0.48326798 ;C:     21.34064100),
{12} (A:      3.10000000 ;B:      3.00245543 ;C:    412.37109687),
{13} (A:      2.05500000 ;B:      0.39858940 ;C:    639.89728631),
{14} (A:      1.90200000 ;B:      4.25925620 ;C:    199.07200144),
{15} (A:      1.76200000 ;B:      4.90536207 ;C:    625.67019231),
{16} (A:      1.69500000 ;B:      4.26147581 ;C:    206.18554844),
{17} (A:      1.37500000 ;B:      5.25546956 ;C:   1052.26838319),
{18} (A:      1.20300000 ;B:      4.71614634 ;C:     95.97922722),
{19} (A:      1.08600000 ;B:      1.28604571 ;C:   1589.07289528));
{L5 -------------------------}
NL5=5;
L5:Array[1..NL5]  of TPlanTerm=(
{1} (A:     49.57700000 ;B:      5.25658966 ;C:      7.11354700),
{2} (A:     15.76100000 ;B:      5.25126837 ;C:     14.22709400),
{3} (A:      4.34300000 ;B:      0.01461869 ;C:    536.80451210),
{4} (A:      1.52600000 ;B:      1.09739911 ;C:    522.57741809),
{5} (A:      0.84500000 ;B:      3.14159265 ;C:      0.00000000));
{Termos de B =========================}
{B0 -------------------------}
NB0=26;
B0:Array[1..NB0]  of TPlanTerm=(
{1} (A:2268615.70300000 ;B:      3.55852607 ;C:    529.69096509),
{2} (A: 110090.35800000 ;B:      0.00000000 ;C:      0.00000000),
{3} (A: 109971.63400000 ;B:      3.90809347 ;C:   1059.38193019),
{4} (A:   8101.42700000 ;B:      3.60509573 ;C:    522.57741809),
{5} (A:   6437.78200000 ;B:      0.30627121 ;C:    536.80451210),
{6} (A:   6043.99600000 ;B:      4.25883109 ;C:   1589.07289528),
{7} (A:   1106.88000000 ;B:      2.98534422 ;C:   1162.47470441),
{8} (A:    944.32800000 ;B:      1.67522288 ;C:    426.59819088),
{9} (A:    941.65100000 ;B:      2.93619072 ;C:   1052.26838319),
{10} (A:    894.08800000 ;B:      1.75447430 ;C:      7.11354700),
{11} (A:    835.86100000 ;B:      5.17881973 ;C:    103.09277422),
{12} (A:    767.28000000 ;B:      2.15473594 ;C:    632.78373931),
{13} (A:    684.22000000 ;B:      3.67808770 ;C:    213.29909544),
{14} (A:    629.22300000 ;B:      0.64343282 ;C:   1066.49547719),
{15} (A:    558.52400000 ;B:      0.01354831 ;C:    846.08283475),
{16} (A:    531.67000000 ;B:      2.70305954 ;C:    110.20632122),
{17} (A:    464.44900000 ;B:      1.17337249 ;C:    949.17560897),
{18} (A:    431.07200000 ;B:      2.60825000 ;C:    419.48464388),
{19} (A:    351.43300000 ;B:      4.61062991 ;C:   2118.76386038),
{20} (A:    132.16000000 ;B:      4.77816991 ;C:    742.99006053),
{21} (A:    123.14800000 ;B:      3.34968181 ;C:   1692.16566950),
{22} (A:    116.37900000 ;B:      1.38688232 ;C:    323.50541666),
{23} (A:    115.03800000 ;B:      5.04892295 ;C:    316.39186966),
{24} (A:    103.76200000 ;B:      3.70103838 ;C:    515.46387109),
{25} (A:    103.40200000 ;B:      2.31879000 ;C:   1478.86657406),
{26} (A:    102.42000000 ;B:      3.15293785 ;C:   1581.95934828));
{B1 -------------------------}
NB1=22;
B1:Array[1..NB1]  of TPlanTerm=(
{1} (A: 177351.78700000 ;B:      5.70166488 ;C:    529.69096509),
{2} (A:   3230.17100000 ;B:      5.77941619 ;C:   1059.38193019),
{3} (A:   3081.36400000 ;B:      5.47464297 ;C:    522.57741809),
{4} (A:   2211.91400000 ;B:      4.73477480 ;C:    536.80451210),
{5} (A:   1694.23200000 ;B:      3.14159265 ;C:      0.00000000),
{6} (A:    346.44500000 ;B:      4.74595174 ;C:   1052.26838319),
{7} (A:    234.26400000 ;B:      5.18856100 ;C:   1066.49547719),
{8} (A:    196.15400000 ;B:      6.18554287 ;C:      7.11354700),
{9} (A:    150.46800000 ;B:      3.92721226 ;C:   1589.07289528),
{10} (A:    114.12800000 ;B:      3.43897272 ;C:    632.78373931),
{11} (A:     96.66700000 ;B:      2.91426304 ;C:    949.17560897),
{12} (A:     81.67100000 ;B:      5.07666097 ;C:   1162.47470441),
{13} (A:     76.59900000 ;B:      2.50522189 ;C:    103.09277422),
{14} (A:     76.57200000 ;B:      0.61288981 ;C:    419.48464388),
{15} (A:     73.87500000 ;B:      5.49958292 ;C:    515.46387109),
{16} (A:     60.54400000 ;B:      5.44740084 ;C:    213.29909544),
{17} (A:     49.91500000 ;B:      3.94799617 ;C:    735.87651353),
{18} (A:     46.03200000 ;B:      0.53850361 ;C:    110.20632122),
{19} (A:     45.12300000 ;B:      1.89516645 ;C:    846.08283475),
{20} (A:     36.56100000 ;B:      4.69828393 ;C:    543.91805910),
{21} (A:     36.01900000 ;B:      6.10952579 ;C:    316.39186966),
{22} (A:     31.97500000 ;B:      4.92452715 ;C:   1581.95934828));
{B2 -------------------------}
NB2=14;
B2:Array[1..NB2]  of TPlanTerm=(
{1} (A:   8094.05100000 ;B:      1.46322844 ;C:    529.69096509),
{2} (A:    813.24400000 ;B:      3.14159265 ;C:      0.00000000),
{3} (A:    742.41500000 ;B:      0.95691639 ;C:    522.57741809),
{4} (A:    398.95100000 ;B:      2.89888666 ;C:    536.80451210),
{5} (A:    342.22600000 ;B:      1.44683790 ;C:   1059.38193019),
{6} (A:     73.94800000 ;B:      0.40724676 ;C:   1052.26838319),
{7} (A:     46.15100000 ;B:      3.48036896 ;C:   1066.49547719),
{8} (A:     29.71700000 ;B:      1.92504171 ;C:   1589.07289528),
{9} (A:     29.31400000 ;B:      0.99088832 ;C:    515.46387109),
{10} (A:     22.75300000 ;B:      4.27124052 ;C:      7.11354700),
{11} (A:     13.91600000 ;B:      2.92242387 ;C:    543.91805910),
{12} (A:     12.06700000 ;B:      5.22168932 ;C:    632.78373931),
{13} (A:     10.70300000 ;B:      4.88024222 ;C:    949.17560897),
{14} (A:      6.07800000 ;B:      6.21089108 ;C:   1045.15483619));
{B3 -------------------------}
NB3=9;
B3:Array[1..NB3]  of TPlanTerm=(
{1} (A:    251.62400000 ;B:      3.38087923 ;C:    529.69096509),
{2} (A:    121.73800000 ;B:      2.73311837 ;C:    522.57741809),
{3} (A:     48.69400000 ;B:      1.03689997 ;C:    536.80451210),
{4} (A:     10.98800000 ;B:      2.31463561 ;C:   1052.26838319),
{5} (A:      8.06700000 ;B:      2.76729758 ;C:    515.46387109),
{6} (A:      7.28700000 ;B:      4.25268319 ;C:   1059.38193019),
{7} (A:      6.20500000 ;B:      1.78115827 ;C:   1066.49547719),
{8} (A:      3.62700000 ;B:      1.13028917 ;C:    543.91805910),
{9} (A:      2.79800000 ;B:      3.14159265 ;C:      0.00000000));
{B4 -------------------------}
NB4=6;
B4:Array[1..NB4]  of TPlanTerm=(
{1} (A:     15.05000000 ;B:      4.52957000 ;C:    522.57741809),
{2} (A:      5.37000000 ;B:      4.47427159 ;C:    529.69096509),
{3} (A:      4.45600000 ;B:      5.43908581 ;C:    536.80451210),
{4} (A:      3.42200000 ;B:      0.00000000 ;C:      0.00000000),
{5} (A:      1.83300000 ;B:      4.51807036 ;C:    515.46387109),
{6} (A:      1.32200000 ;B:      4.20117612 ;C:   1052.26838319));
{B5 -------------------------}
NB5=1;
B5:Array[1..NB5]  of TPlanTerm=(
{1} (A:      1.44500000 ;B:      0.09198554 ;C:    522.57741809));
{Termos de R =========================}
{R0 -------------------------}
NR0=46;
R0:Array[1..NR0]  of TPlanTerm=(
{1} (A:520887429.47100002 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:25209327.02000000 ;B:      3.49108640 ;C:    529.69096509),
{3} (A: 610599.90200000 ;B:      3.84115366 ;C:   1059.38193019),
{4} (A: 282029.46500000 ;B:      2.57419880 ;C:    632.78373931),
{5} (A: 187647.39100000 ;B:      2.07590380 ;C:    522.57741809),
{6} (A:  86792.94100000 ;B:      0.71001091 ;C:    419.48464388),
{7} (A:  72062.86900000 ;B:      0.21465695 ;C:    536.80451210),
{8} (A:  65517.22700000 ;B:      5.97995851 ;C:    316.39186966),
{9} (A:  30135.27500000 ;B:      2.16132058 ;C:    949.17560897),
{10} (A:  29134.62000000 ;B:      1.67759244 ;C:    103.09277422),
{11} (A:  23947.34000000 ;B:      0.27457855 ;C:      7.11354700),
{12} (A:  23453.20900000 ;B:      3.54023147 ;C:    735.87651353),
{13} (A:  22283.71000000 ;B:      4.19362774 ;C:   1589.07289528),
{14} (A:  13032.60000000 ;B:      2.96043056 ;C:   1162.47470441),
{15} (A:  12749.00400000 ;B:      2.71550103 ;C:   1052.26838319),
{16} (A:   9703.34600000 ;B:      1.90669572 ;C:    206.18554844),
{17} (A:   9161.43100000 ;B:      4.41352619 ;C:    213.29909544),
{18} (A:   7894.53900000 ;B:      2.47907551 ;C:    426.59819088),
{19} (A:   7057.97800000 ;B:      2.18184753 ;C:   1265.56747863),
{20} (A:   6137.75500000 ;B:      6.26417543 ;C:    846.08283475),
{21} (A:   5477.09300000 ;B:      5.65729325 ;C:    639.89728631),
{22} (A:   4170.01200000 ;B:      2.01605034 ;C:    515.46387109),
{23} (A:   4136.89000000 ;B:      2.72219980 ;C:    625.67019231),
{24} (A:   3502.51900000 ;B:      0.56531297 ;C:   1066.49547719),
{25} (A:   2616.95500000 ;B:      2.00993967 ;C:   1581.95934828),
{26} (A:   2499.96600000 ;B:      4.55182056 ;C:    838.96928775),
{27} (A:   2127.64400000 ;B:      6.12751462 ;C:    742.99006053),
{28} (A:   1911.87600000 ;B:      0.85621927 ;C:    412.37109687),
{29} (A:   1610.54900000 ;B:      3.08867789 ;C:   1368.66025285),
{30} (A:   1479.48400000 ;B:      2.68026191 ;C:   1478.86657406),
{31} (A:   1230.70800000 ;B:      1.89042980 ;C:    323.50541666),
{32} (A:   1216.81000000 ;B:      1.80171561 ;C:    110.20632122),
{33} (A:   1014.95900000 ;B:      1.38673238 ;C:    454.90936653),
{34} (A:    998.57900000 ;B:      2.87208940 ;C:    309.27832266),
{35} (A:    961.07200000 ;B:      4.54876990 ;C:   2118.76386038),
{36} (A:    885.70800000 ;B:      4.14785948 ;C:    533.62311836),
{37} (A:    821.46500000 ;B:      1.59342534 ;C:   1898.35121794),
{38} (A:    812.03600000 ;B:      5.94091899 ;C:    909.81873305),
{39} (A:    776.70000000 ;B:      3.67696955 ;C:    728.76296653),
{40} (A:    727.16200000 ;B:      3.98824686 ;C:   1155.36115741),
{41} (A:    655.28900000 ;B:      2.79065604 ;C:   1685.05212250),
{42} (A:    653.98100000 ;B:      3.38150775 ;C:   1692.16566950),
{43} (A:    620.79800000 ;B:      4.82284339 ;C:    956.28915597),
{44} (A:    614.78400000 ;B:      2.27624916 ;C:    942.06206197),
{45} (A:    562.12000000 ;B:      0.08095987 ;C:    543.91805910),
{46} (A:    542.22100000 ;B:      0.28360266 ;C:    525.75881183));
{R1 -------------------------}
NR1=43;
R1:Array[1..NR1]  of TPlanTerm=(
{1} (A:1271801.59600000 ;B:      2.64937511 ;C:    529.69096509),
{2} (A:  61661.77100000 ;B:      3.00076251 ;C:   1059.38193019),
{3} (A:  53443.59200000 ;B:      3.89717644 ;C:    522.57741809),
{4} (A:  41390.25700000 ;B:      0.00000000 ;C:      0.00000000),
{5} (A:  31185.16700000 ;B:      4.88276664 ;C:    536.80451210),
{6} (A:  11847.19000000 ;B:      2.41329588 ;C:    419.48464388),
{7} (A:   9166.36000000 ;B:      4.75979409 ;C:      7.11354700),
{8} (A:   3403.60500000 ;B:      3.34688538 ;C:   1589.07289528),
{9} (A:   3203.44600000 ;B:      5.21083285 ;C:    735.87651353),
{10} (A:   3175.76300000 ;B:      2.79297987 ;C:    103.09277422),
{11} (A:   2806.06400000 ;B:      3.74223694 ;C:    515.46387109),
{12} (A:   2676.57500000 ;B:      4.33052879 ;C:   1052.26838319),
{13} (A:   2600.00300000 ;B:      3.63435102 ;C:    206.18554844),
{14} (A:   2412.20700000 ;B:      1.46947308 ;C:    426.59819088),
{15} (A:   2100.50700000 ;B:      3.92762682 ;C:    639.89728631),
{16} (A:   1646.18200000 ;B:      5.30953511 ;C:   1066.49547719),
{17} (A:   1641.25700000 ;B:      4.41628670 ;C:    625.67019231),
{18} (A:   1049.86600000 ;B:      3.16113623 ;C:    213.29909544),
{19} (A:   1024.80200000 ;B:      2.55432643 ;C:    412.37109687),
{20} (A:    806.40400000 ;B:      2.67750801 ;C:    632.78373931),
{21} (A:    740.99600000 ;B:      2.17094631 ;C:   1162.47470441),
{22} (A:    676.92800000 ;B:      6.24953480 ;C:    838.96928775),
{23} (A:    567.07600000 ;B:      4.57655415 ;C:    742.99006053),
{24} (A:    484.68900000 ;B:      2.46882793 ;C:    949.17560897),
{25} (A:    468.89500000 ;B:      4.70973463 ;C:    543.91805910),
{26} (A:    444.68300000 ;B:      0.40281181 ;C:    323.50541666),
{27} (A:    415.89400000 ;B:      5.36836018 ;C:    728.76296653),
{28} (A:    401.73800000 ;B:      4.60528842 ;C:    309.27832266),
{29} (A:    347.37800000 ;B:      4.68148809 ;C:     14.22709400),
{30} (A:    337.55500000 ;B:      3.16781951 ;C:    956.28915597),
{31} (A:    260.75300000 ;B:      5.34290306 ;C:    846.08283475),
{32} (A:    246.60300000 ;B:      3.92313824 ;C:    942.06206197),
{33} (A:    220.08400000 ;B:      4.84210965 ;C:   1368.66025285),
{34} (A:    203.21700000 ;B:      5.59995425 ;C:   1155.36115741),
{35} (A:    200.19000000 ;B:      4.43888814 ;C:   1045.15483619),
{36} (A:    197.13400000 ;B:      3.70551461 ;C:   2118.76386038),
{37} (A:    196.00500000 ;B:      3.75877587 ;C:    199.07200144),
{38} (A:    183.50400000 ;B:      4.26526770 ;C:     95.97922722),
{39} (A:    180.13400000 ;B:      4.40165491 ;C:    532.87235883),
{40} (A:    170.22500000 ;B:      4.84647489 ;C:    526.50957136),
{41} (A:    146.33500000 ;B:      6.12958366 ;C:    533.62311836),
{42} (A:    133.48300000 ;B:      1.32245736 ;C:    110.20632122),
{43} (A:    132.07600000 ;B:      4.51187951 ;C:    525.75881183));
{R2 -------------------------}
NR2=36;
R2:Array[1..NR2]  of TPlanTerm=(
{1} (A:  79644.83300000 ;B:      1.35865897 ;C:    529.69096509),
{2} (A:   8251.61800000 ;B:      5.77773935 ;C:    522.57741809),
{3} (A:   7029.86400000 ;B:      3.27476966 ;C:    536.80451210),
{4} (A:   5314.00600000 ;B:      1.83835110 ;C:   1059.38193019),
{5} (A:   1860.83300000 ;B:      2.97682139 ;C:      7.11354700),
{6} (A:    964.46600000 ;B:      5.48031822 ;C:    515.46387109),
{7} (A:    836.26700000 ;B:      4.19889882 ;C:    419.48464388),
{8} (A:    497.92000000 ;B:      3.14159265 ;C:      0.00000000),
{9} (A:    426.57000000 ;B:      2.22753102 ;C:    639.89728631),
{10} (A:    406.45300000 ;B:      3.78250730 ;C:   1066.49547719),
{11} (A:    377.31600000 ;B:      2.24248353 ;C:   1589.07289528),
{12} (A:    362.94300000 ;B:      5.36761847 ;C:    206.18554844),
{13} (A:    342.04800000 ;B:      6.09922969 ;C:   1052.26838319),
{14} (A:    339.04300000 ;B:      6.12690864 ;C:    625.67019231),
{15} (A:    332.57800000 ;B:      0.00328961 ;C:    426.59819088),
{16} (A:    279.92000000 ;B:      4.26162556 ;C:    412.37109687),
{17} (A:    257.29000000 ;B:      0.96295365 ;C:    632.78373931),
{18} (A:    229.77700000 ;B:      0.70530766 ;C:    735.87651353),
{19} (A:    200.78300000 ;B:      3.06850623 ;C:    543.91805910),
{20} (A:    199.80700000 ;B:      4.42884165 ;C:    103.09277422),
{21} (A:    138.60600000 ;B:      2.93235672 ;C:     14.22709400),
{22} (A:    113.53500000 ;B:      0.78713911 ;C:    728.76296653),
{23} (A:     94.56500000 ;B:      1.70498041 ;C:    838.96928775),
{24} (A:     86.02500000 ;B:      5.14434752 ;C:    323.50541666),
{25} (A:     83.46900000 ;B:      0.05834873 ;C:    309.27832266),
{26} (A:     80.32800000 ;B:      2.98122362 ;C:    742.99006053),
{27} (A:     75.19800000 ;B:      1.60495196 ;C:    956.28915597),
{28} (A:     70.45100000 ;B:      1.50988357 ;C:    213.29909544),
{29} (A:     66.57200000 ;B:      5.47307178 ;C:    199.07200144),
{30} (A:     61.64900000 ;B:      6.10137890 ;C:   1045.15483619),
{31} (A:     56.20300000 ;B:      0.95534811 ;C:   1162.47470441),
{32} (A:     51.90400000 ;B:      5.58435626 ;C:    942.06206197),
{33} (A:     50.05700000 ;B:      2.72063162 ;C:    532.87235883),
{34} (A:     44.54800000 ;B:      5.52445621 ;C:    508.35032409),
{35} (A:     44.28200000 ;B:      0.27118153 ;C:    526.50957136),
{36} (A:     39.83300000 ;B:      5.94566506 ;C:     95.97922722));
{R3 -------------------------}
NR3=28;
R3:Array[1..NR3]  of TPlanTerm=(
{1} (A:   3519.25700000 ;B:      6.05800634 ;C:    529.69096509),
{2} (A:   1073.23900000 ;B:      1.67321346 ;C:    536.80451210),
{3} (A:    915.66600000 ;B:      1.41329676 ;C:    522.57741809),
{4} (A:    341.59300000 ;B:      0.52296543 ;C:   1059.38193019),
{5} (A:    254.89300000 ;B:      1.19625474 ;C:      7.11354700),
{6} (A:    221.51200000 ;B:      0.95225226 ;C:    515.46387109),
{7} (A:     89.72900000 ;B:      3.14159265 ;C:      0.00000000),
{8} (A:     69.07800000 ;B:      2.26885282 ;C:   1066.49547719),
{9} (A:     57.82700000 ;B:      1.41389745 ;C:    543.91805910),
{10} (A:     57.65300000 ;B:      0.52580118 ;C:    639.89728631),
{11} (A:     51.07900000 ;B:      5.98016365 ;C:    412.37109687),
{12} (A:     46.93500000 ;B:      1.57864238 ;C:    625.67019231),
{13} (A:     42.82400000 ;B:      6.11689609 ;C:    419.48464388),
{14} (A:     37.47700000 ;B:      1.18262762 ;C:     14.22709400),
{15} (A:     33.81600000 ;B:      1.66671707 ;C:   1052.26838319),
{16} (A:     33.53100000 ;B:      0.84784978 ;C:    206.18554844),
{17} (A:     31.19500000 ;B:      1.04290246 ;C:   1589.07289528),
{18} (A:     30.02300000 ;B:      4.63236245 ;C:    426.59819088),
{19} (A:     20.80400000 ;B:      2.50071244 ;C:    728.76296653),
{20} (A:     15.02300000 ;B:      0.89136998 ;C:    199.07200144),
{21} (A:     14.46600000 ;B:      0.96040197 ;C:    508.35032409),
{22} (A:     12.96900000 ;B:      1.50233789 ;C:   1045.15483619),
{23} (A:     12.31900000 ;B:      2.60952615 ;C:    735.87651353),
{24} (A:     11.65400000 ;B:      3.55513510 ;C:    323.50541666),
{25} (A:     11.16000000 ;B:      1.79041438 ;C:    309.27832266),
{26} (A:     10.55400000 ;B:      6.27845113 ;C:    956.28915597),
{27} (A:      9.81200000 ;B:      6.26016860 ;C:    103.09277422),
{28} (A:      9.30100000 ;B:      3.45126812 ;C:    838.96928775));
{R4 -------------------------}
NR4=15;
R4:Array[1..NR4]  of TPlanTerm=(
{1} (A:    128.62800000 ;B:      0.08419310 ;C:    536.80451210),
{2} (A:    113.45800000 ;B:      4.24858856 ;C:    529.69096509),
{3} (A:     82.65000000 ;B:      3.29754909 ;C:    522.57741809),
{4} (A:     37.88300000 ;B:      2.73326611 ;C:    515.46387109),
{5} (A:     26.69400000 ;B:      5.69142589 ;C:      7.11354700),
{6} (A:     17.65000000 ;B:      5.40012537 ;C:   1059.38193019),
{7} (A:     12.61200000 ;B:      6.01560416 ;C:    543.91805910),
{8} (A:      9.28700000 ;B:      0.76813946 ;C:   1066.49547719),
{9} (A:      8.10700000 ;B:      5.68228066 ;C:     14.22709400),
{10} (A:      6.97800000 ;B:      1.42751292 ;C:    412.37109687),
{11} (A:      6.27100000 ;B:      5.12286933 ;C:    639.89728631),
{12} (A:      5.37700000 ;B:      3.33501947 ;C:    625.67019231),
{13} (A:      2.91100000 ;B:      3.40334805 ;C:   1052.26838319),
{14} (A:      2.59300000 ;B:      4.16090413 ;C:    728.76296653),
{15} (A:      2.56200000 ;B:      2.89802035 ;C:    426.59819088));
{R5 -------------------------}
NR5=7;
R5:Array[1..NR5]  of TPlanTerm=(
{1} (A:     11.18800000 ;B:      4.75249400 ;C:    536.80451210),
{2} (A:      4.25500000 ;B:      5.91516229 ;C:    522.57741809),
{3} (A:      2.07900000 ;B:      5.56781556 ;C:    515.46387109),
{4} (A:      1.90800000 ;B:      4.29659647 ;C:    543.91805910),
{5} (A:      1.87500000 ;B:      3.69357496 ;C:      7.11354700),
{6} (A:      1.61200000 ;B:      4.13222809 ;C:   1059.38193019),
{7} (A:      1.59000000 ;B:      5.49312796 ;C:   1066.49547719));

CJupiter:RPlanConsts=(
  NLTermos:(NL0,NL1,NL2,NL3,NL4,NL5);
  NBTermos:(NB0,NB1,NB2,NB3,NB4,NB5);
  NRTermos:(NR0,NR1,NR2,NR3,NR4,NR5);
  LTermos:(@L0,@L1,@L2,@L3,@L4,@L5);
  BTermos:(@B0,@B1,@B2,@B3,@B4,@B5);
  RTermos:(@R0,@R1,@R2,@R3,@R4,@R5));

implementation

end.
