Unit VSOP87.Earth;  //--------
 //----------------//
// VSOP87 = Variations Seculaires des Orbiotes Planetaires 1987
//    by Bretagnon and Francou - Bureau des Longitudes of Paris
//
// calculates planet's ecliptical Lon,Lat and Radius ( R from the Sun )
// This method is described in J.Meeus book "Astronomical Algorithms" - Chapter 32
// used as basis for this code.

Interface

uses  VSOP87.PlanetDef;

const
{Termos de L =========================}
{L0 -------------------------}
NL0=64;
L0:Array[1..NL0]  of TPlanTerm=(
{1} (A:175347045.67299998 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:3341656.45600000 ;B:      4.66925680 ;C:   6283.07584999),
{3} (A:  34894.27500000 ;B:      4.62610242 ;C:  12566.15169998),
{4} (A:   3497.05600000 ;B:      2.74411801 ;C:   5753.38488490),
{5} (A:   3417.57100000 ;B:      2.82886580 ;C:      3.52311835),
{6} (A:   3135.89600000 ;B:      3.62767042 ;C:  77713.77146812),
{7} (A:   2676.21800000 ;B:      4.41808351 ;C:   7860.41939244),
{8} (A:   2342.68700000 ;B:      6.13516238 ;C:   3930.20969622),
{9} (A:   1324.29200000 ;B:      0.74246356 ;C:  11506.76976979),
{10} (A:   1273.16600000 ;B:      2.03709656 ;C:    529.69096509),
{11} (A:   1199.16700000 ;B:      1.10962944 ;C:   1577.34354245),
{12} (A:    990.25000000 ;B:      5.23268130 ;C:   5884.92684658),
{13} (A:    901.85500000 ;B:      2.04505444 ;C:     26.29831980),
{14} (A:    857.22300000 ;B:      3.50849157 ;C:    398.14900341),
{15} (A:    779.78600000 ;B:      1.17882652 ;C:   5223.69391980),
{16} (A:    753.14100000 ;B:      2.53339054 ;C:   5507.55323867),
{17} (A:    505.26400000 ;B:      4.58292563 ;C:  18849.22754997),
{18} (A:    492.37900000 ;B:      4.20506640 ;C:    775.52261132),
{19} (A:    356.65500000 ;B:      2.91954117 ;C:      0.06731030),
{20} (A:    317.08700000 ;B:      5.84901952 ;C:  11790.62908866),
{21} (A:    284.12500000 ;B:      1.89869034 ;C:    796.29800682),
{22} (A:    271.03900000 ;B:      0.31488608 ;C:  10977.07880470),
{23} (A:    242.81000000 ;B:      0.34481141 ;C:   5486.77784318),
{24} (A:    206.16000000 ;B:      4.80646606 ;C:   2544.31441988),
{25} (A:    205.38500000 ;B:      1.86947814 ;C:   5573.14280143),
{26} (A:    202.26100000 ;B:      2.45767795 ;C:   6069.77675455),
{27} (A:    155.51600000 ;B:      0.83306074 ;C:    213.29909544),
{28} (A:    132.21200000 ;B:      3.41118276 ;C:   2942.46342329),
{29} (A:    126.18400000 ;B:      1.08302630 ;C:     20.77539549),
{30} (A:    115.13200000 ;B:      0.64544912 ;C:      0.98032107),
{31} (A:    102.85100000 ;B:      0.63599847 ;C:   4694.00295471),
{32} (A:    101.89500000 ;B:      0.97569222 ;C:  15720.83878488),
{33} (A:    101.72400000 ;B:      4.26679821 ;C:      7.11354700),
{34} (A:     99.20600000 ;B:      6.20992940 ;C:   2146.16541648),
{35} (A:     97.60700000 ;B:      0.68101272 ;C:    155.42039943),
{36} (A:     85.80300000 ;B:      5.98322631 ;C: 161000.68573767),
{37} (A:     85.12800000 ;B:      1.29870743 ;C:   6275.96230299),
{38} (A:     84.71100000 ;B:      3.67080093 ;C:  71430.69561813),
{39} (A:     79.63700000 ;B:      1.80791331 ;C:  17260.15465469),
{40} (A:     78.75600000 ;B:      3.03698313 ;C:  12036.46073489),
{41} (A:     74.65100000 ;B:      1.75508916 ;C:   5088.62883977),
{42} (A:     73.87400000 ;B:      3.50319443 ;C:   3154.68708490),
{43} (A:     73.54700000 ;B:      4.67926565 ;C:    801.82093112),
{44} (A:     69.62700000 ;B:      0.83297597 ;C:   9437.76293489),
{45} (A:     62.44900000 ;B:      3.97763881 ;C:   8827.39026987),
{46} (A:     61.14800000 ;B:      1.81839811 ;C:   7084.89678112),
{47} (A:     56.96300000 ;B:      2.78430398 ;C:   6286.59896834),
{48} (A:     56.11600000 ;B:      4.38694881 ;C:  14143.49524243),
{49} (A:     55.57700000 ;B:      3.47006009 ;C:   6279.55273164),
{50} (A:     51.99200000 ;B:      0.18914946 ;C:  12139.55350911),
{51} (A:     51.60500000 ;B:      1.33282747 ;C:   1748.01641307),
{52} (A:     51.14500000 ;B:      0.28306865 ;C:   5856.47765912),
{53} (A:     49.00000000 ;B:      0.48735065 ;C:   1194.44701022),
{54} (A:     41.03600000 ;B:      5.36817351 ;C:   8429.24126647),
{55} (A:     40.93800000 ;B:      2.39850882 ;C:  19651.04848110),
{56} (A:     39.20000000 ;B:      6.16832995 ;C:  10447.38783960),
{57} (A:     36.77000000 ;B:      6.04133859 ;C:  10213.28554621),
{58} (A:     36.59600000 ;B:      2.56955239 ;C:   1059.38193019),
{59} (A:     35.95400000 ;B:      1.70876112 ;C:   2352.86615377),
{60} (A:     35.56600000 ;B:      1.77597315 ;C:   6812.76681509),
{61} (A:     33.29100000 ;B:      0.59309499 ;C:  17789.84561978),
{62} (A:     30.41200000 ;B:      0.44294464 ;C:  83996.84731811),
{63} (A:     30.04700000 ;B:      2.73975124 ;C:   1349.86740966),
{64} (A:     25.35200000 ;B:      3.16470953 ;C:   4690.47983636));
{L1 -------------------------}
NL1=34;
L1:Array[1..NL1]  of TPlanTerm=(
{1} (A:628331966747.49096700 ;B:      0.00000000 ;C:      0.00000000),
{2} (A: 206058.86300000 ;B:      2.67823456 ;C:   6283.07584999),
{3} (A:   4303.43000000 ;B:      2.63512650 ;C:  12566.15169998),
{4} (A:    425.26400000 ;B:      1.59046981 ;C:      3.52311835),
{5} (A:    119.26100000 ;B:      5.79557488 ;C:     26.29831980),
{6} (A:    108.97700000 ;B:      2.96618002 ;C:   1577.34354245),
{7} (A:     93.47800000 ;B:      2.59212835 ;C:  18849.22754997),
{8} (A:     72.12200000 ;B:      1.13846158 ;C:    529.69096509),
{9} (A:     67.76800000 ;B:      1.87472305 ;C:    398.14900341),
{10} (A:     67.32700000 ;B:      4.40918235 ;C:   5507.55323867),
{11} (A:     59.02700000 ;B:      2.88797038 ;C:   5223.69391980),
{12} (A:     55.97600000 ;B:      2.17471680 ;C:    155.42039943),
{13} (A:     45.40700000 ;B:      0.39803080 ;C:    796.29800682),
{14} (A:     36.36900000 ;B:      0.46624740 ;C:    775.52261132),
{15} (A:     28.95800000 ;B:      2.64707384 ;C:      7.11354700),
{16} (A:     20.84400000 ;B:      5.34138275 ;C:      0.98032107),
{17} (A:     19.09700000 ;B:      1.84628333 ;C:   5486.77784318),
{18} (A:     18.50800000 ;B:      4.96855125 ;C:    213.29909544),
{19} (A:     17.29300000 ;B:      2.99116865 ;C:   6275.96230299),
{20} (A:     16.23300000 ;B:      0.03216483 ;C:   2544.31441988),
{21} (A:     15.83200000 ;B:      1.43049285 ;C:   2146.16541648),
{22} (A:     14.61500000 ;B:      1.20532366 ;C:  10977.07880470),
{23} (A:     12.46100000 ;B:      2.83432286 ;C:   1748.01641307),
{24} (A:     11.87700000 ;B:      3.25804816 ;C:   5088.62883977),
{25} (A:     11.80800000 ;B:      5.27379790 ;C:   1194.44701022),
{26} (A:     11.51400000 ;B:      2.07502418 ;C:   4694.00295471),
{27} (A:     10.64100000 ;B:      0.76614199 ;C:    553.56940284),
{28} (A:      9.96900000 ;B:      1.30262991 ;C:   6286.59896834),
{29} (A:      9.72100000 ;B:      4.23925472 ;C:   1349.86740966),
{30} (A:      9.45200000 ;B:      2.69957063 ;C:    242.72860397),
{31} (A:      8.57700000 ;B:      5.64475868 ;C:    951.71840625),
{32} (A:      7.57600000 ;B:      5.30062665 ;C:   2352.86615377),
{33} (A:      6.38500000 ;B:      2.65033985 ;C:   9437.76293489),
{34} (A:      6.10100000 ;B:      4.66632584 ;C:   4690.47983636));
{L2 -------------------------}
NL2=20;
L2:Array[1..NL2]  of TPlanTerm=(
{1} (A:  52918.87000000 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:   8719.83700000 ;B:      1.07209665 ;C:   6283.07584999),
{3} (A:    309.12500000 ;B:      0.86728819 ;C:  12566.15169998),
{4} (A:     27.33900000 ;B:      0.05297872 ;C:      3.52311835),
{5} (A:     16.33400000 ;B:      5.18826691 ;C:     26.29831980),
{6} (A:     15.75200000 ;B:      3.68457889 ;C:    155.42039943),
{7} (A:      9.54100000 ;B:      0.75742298 ;C:  18849.22754997),
{8} (A:      8.93700000 ;B:      2.05705419 ;C:  77713.77146812),
{9} (A:      6.95200000 ;B:      0.82673305 ;C:    775.52261132),
{10} (A:      5.06400000 ;B:      4.66284525 ;C:   1577.34354245),
{11} (A:      4.06100000 ;B:      1.03057163 ;C:      7.11354700),
{12} (A:      3.81000000 ;B:      3.44050803 ;C:   5573.14280143),
{13} (A:      3.46300000 ;B:      5.14074633 ;C:    796.29800682),
{14} (A:      3.16900000 ;B:      6.05291851 ;C:   5507.55323867),
{15} (A:      3.02000000 ;B:      1.19246506 ;C:    242.72860397),
{16} (A:      2.88600000 ;B:      6.11652627 ;C:    529.69096509),
{17} (A:      2.71400000 ;B:      0.30637881 ;C:    398.14900341),
{18} (A:      2.53800000 ;B:      2.27992811 ;C:    553.56940284),
{19} (A:      2.37100000 ;B:      4.38118838 ;C:   5223.69391980),
{20} (A:      2.07900000 ;B:      3.75435330 ;C:      0.98032107));
{L3 -------------------------}
NL3=7;
L3:Array[1..NL3]  of TPlanTerm=(
{1} (A:    289.22600000 ;B:      5.84384199 ;C:   6283.07584999),
{2} (A:     34.95500000 ;B:      0.00000000 ;C:      0.00000000),
{3} (A:     16.81900000 ;B:      5.48766912 ;C:  12566.15169998),
{4} (A:      2.96200000 ;B:      5.19577265 ;C:    155.42039943),
{5} (A:      1.28800000 ;B:      4.72200252 ;C:      3.52311835),
{6} (A:      0.71400000 ;B:      5.30045809 ;C:  18849.22754997),
{7} (A:      0.63500000 ;B:      5.96925937 ;C:    242.72860397));
{L4 -------------------------}
NL4=3;
L4:Array[1..NL4]  of TPlanTerm=(
{1} (A:    114.08400000 ;B:      3.14159265 ;C:      0.00000000),
{2} (A:      7.71700000 ;B:      4.13446589 ;C:   6283.07584999),
{3} (A:      0.76500000 ;B:      3.83803776 ;C:  12566.15169998));
{L5 -------------------------}
NL5=1;
L5:Array[1..NL5]  of TPlanTerm=(
{1} (A:      0.87800000 ;B:      3.14159265 ;C:      0.00000000));
{Termos de B =========================}
{B0 -------------------------}
NB0=5;
B0:Array[1..NB0]  of TPlanTerm=(
{1} (A:    279.62000000 ;B:      3.19870156 ;C:  84334.66158131),
{2} (A:    101.64300000 ;B:      5.42248619 ;C:   5507.55323867),
{3} (A:     80.44500000 ;B:      3.88013204 ;C:   5223.69391980),
{4} (A:     43.80600000 ;B:      3.70444690 ;C:   2352.86615377),
{5} (A:     31.93300000 ;B:      4.00026370 ;C:   1577.34354245));
{B1 -------------------------}
NB1=2;
B1:Array[1..NB1]  of TPlanTerm=(
{1} (A:      9.03000000 ;B:      3.89729062 ;C:   5507.55323867),
{2} (A:      6.17700000 ;B:      1.73038850 ;C:   5223.69391980));
{B2 -------------------------}
NB2=0;
{B3 -------------------------}
NB3=0;
{B4 -------------------------}
NB4=0;
{B5 -------------------------}
NB5=0;
{Termos de R =========================}
{R0 -------------------------}
NR0=40;
R0:Array[1..NR0]  of TPlanTerm=(
{1} (A:100013988.79900001 ;B:      0.00000000 ;C:      0.00000000),
{2} (A:1670699.62600000 ;B:      3.09846351 ;C:   6283.07584999),
{3} (A:  13956.02300000 ;B:      3.05524610 ;C:  12566.15169998),
{4} (A:   3083.72000000 ;B:      5.19846674 ;C:  77713.77146812),
{5} (A:   1628.46100000 ;B:      1.17387749 ;C:   5753.38488490),
{6} (A:   1575.56800000 ;B:      2.84685246 ;C:   7860.41939244),
{7} (A:    924.79900000 ;B:      5.45292234 ;C:  11506.76976979),
{8} (A:    542.44400000 ;B:      4.56409150 ;C:   3930.20969622),
{9} (A:    472.11000000 ;B:      3.66100022 ;C:   5884.92684658),
{10} (A:    345.98300000 ;B:      0.96368618 ;C:   5507.55323867),
{11} (A:    328.78000000 ;B:      5.89983646 ;C:   5223.69391980),
{12} (A:    306.78400000 ;B:      0.29867140 ;C:   5573.14280143),
{13} (A:    243.18900000 ;B:      4.27349536 ;C:  11790.62908866),
{14} (A:    211.82900000 ;B:      5.84714540 ;C:   1577.34354245),
{15} (A:    185.75200000 ;B:      5.02194447 ;C:  10977.07880470),
{16} (A:    174.84400000 ;B:      3.01193637 ;C:  18849.22754997),
{17} (A:    109.83500000 ;B:      5.05510636 ;C:   5486.77784318),
{18} (A:     98.31600000 ;B:      0.88681311 ;C:   6069.77675455),
{19} (A:     86.49900000 ;B:      5.68959778 ;C:  15720.83878488),
{20} (A:     85.82500000 ;B:      1.27083733 ;C: 161000.68573767),
{21} (A:     64.90300000 ;B:      0.27250614 ;C:  17260.15465469),
{22} (A:     62.91600000 ;B:      0.92177109 ;C:    529.69096509),
{23} (A:     57.05600000 ;B:      2.01374292 ;C:  83996.84731811),
{24} (A:     55.73600000 ;B:      5.24159799 ;C:  71430.69561813),
{25} (A:     49.38400000 ;B:      3.24501240 ;C:   2544.31441988),
{26} (A:     46.96300000 ;B:      2.57805070 ;C:    775.52261132),
{27} (A:     44.66100000 ;B:      5.53715807 ;C:   9437.76293489),
{28} (A:     42.51500000 ;B:      6.01110242 ;C:   6275.96230299),
{29} (A:     38.96800000 ;B:      5.36071738 ;C:   4694.00295471),
{30} (A:     38.24500000 ;B:      2.39255344 ;C:   8827.39026987),
{31} (A:     37.49000000 ;B:      0.82952922 ;C:  19651.04848110),
{32} (A:     36.95700000 ;B:      4.90107592 ;C:  12139.55350911),
{33} (A:     35.66000000 ;B:      1.67468059 ;C:  12036.46073489),
{34} (A:     34.53700000 ;B:      1.84270693 ;C:   2942.46342329),
{35} (A:     33.19300000 ;B:      0.24370300 ;C:   7084.89678112),
{36} (A:     31.92100000 ;B:      0.18368230 ;C:   5088.62883977),
{37} (A:     31.84600000 ;B:      1.77775642 ;C:    398.14900341),
{38} (A:     28.46400000 ;B:      1.21344868 ;C:   6286.59896834),
{39} (A:     27.79300000 ;B:      1.89934331 ;C:   6279.55273164),
{40} (A:     26.27500000 ;B:      4.58896850 ;C:  10447.38783960));
{R1 -------------------------}
NR1=10;
R1:Array[1..NR1]  of TPlanTerm=(
{1} (A: 103018.60800000 ;B:      1.10748970 ;C:   6283.07584999),
{2} (A:   1721.23800000 ;B:      1.06442301 ;C:  12566.15169998),
{3} (A:    702.21500000 ;B:      3.14159265 ;C:      0.00000000),
{4} (A:     32.34600000 ;B:      1.02169059 ;C:  18849.22754997),
{5} (A:     30.79900000 ;B:      2.84353805 ;C:   5507.55323867),
{6} (A:     24.97100000 ;B:      1.31906709 ;C:   5223.69391980),
{7} (A:     18.48500000 ;B:      1.42429749 ;C:   1577.34354245),
{8} (A:     10.07800000 ;B:      5.91378195 ;C:  10977.07880470),
{9} (A:      8.65400000 ;B:      1.42046854 ;C:   6275.96230299),
{10} (A:      8.63400000 ;B:      0.27146151 ;C:   5486.77784318));
{R2 -------------------------}
NR2=6;
R2:Array[1..NR2]  of TPlanTerm=(
{1} (A:   4359.38500000 ;B:      5.78455134 ;C:   6283.07584999),
{2} (A:    123.63300000 ;B:      5.57934722 ;C:  12566.15169998),
{3} (A:     12.34100000 ;B:      3.14159265 ;C:      0.00000000),
{4} (A:      8.79200000 ;B:      3.62777733 ;C:  77713.77146812),
{5} (A:      5.68900000 ;B:      1.86958905 ;C:   5573.14280143),
{6} (A:      3.30100000 ;B:      5.47027913 ;C:  18849.22754997));
{R3 -------------------------}
NR3=2;
R3:Array[1..NR3]  of TPlanTerm=(
{1} (A:    144.59500000 ;B:      4.27319435 ;C:   6283.07584999),
{2} (A:      6.72900000 ;B:      3.91697609 ;C:  12566.15169998));
{R4 -------------------------}
NR4=1;
R4:Array[1..NR4]  of TPlanTerm=(
{1} (A:      3.85800000 ;B:      2.56384387 ;C:   6283.07584999));
{R5 -------------------------}

NR5=0;

CEarth:RPlanConsts=(
  NLTermos:(NL0,NL1,NL2,NL3,NL4,NL5);
  NBTermos:(NB0,NB1,NB2,NB3,NB4,NB5);
  NRTermos:(NR0,NR1,NR2,NR3,NR4,NR5);
  LTermos:(@L0,@L1,@L2,@L3,@L4,@L5);
  BTermos:(@B0,@B1,Nil,Nil,Nil,Nil);
  RTermos:(@R0,@R1,@R2,@R3,@R4,Nil));

implementation

end.
