Étude stratégique via un sondage d'opinion
==========================================

Ce document explique comment réaliser une étude stratégique
avec un sondage auprès des collaborateurs d'une organisation.

Les étapes d'une étude stratégique :

   1. Réflexions en amont en se basant sur le contexte actuel et les problématiques à résoudre
   1. Définir les questions, mais pas n’importe lesquelles, celles dont l’analyse des réponses permet de trouver des pistes d'améliorations pertinentes
   1. Conception et rédaction du questionnaire
   1. Recueil des réponses
   1. Analyse et restitution des résultats


Enjeux
------

Les résultats d'une étude peuvent remettre en question les décisions de la direction,
le tempérament des managers, la cohésion des équipes, la stratégie RH,
la culture d’organisation, l’état d’esprit, les process, la qualité de nos livrables…

Par conséquent, l'équipe étude (l'équipe interne chargée de gérer les différents aspects de l'étude)
devra trouver un bon équilibre entre désire de transparence et ambiance de travail productive.


Délégation à un institut de sondage
-----------------------------------

La réalisation d'une étude / sondage est un vrai métier qui ne s'improvise pas.
Le coût est le même pour une petite ou une grosse structure quand le sondage est en ligne.
Une structure avec un petit budget aura tendance a tout gérer en interne,
mais il est alors difficile d'obtenir la qualité des résultats d'un institut professionnel.

La réalisation d'une étude peut être menée en interne ou externalisée à un institut de sondage.
Que ce soit en interne ou externe, chaque étape doit être réalisée dans les règles de l'art
afin d'obtenir un questionnaire cohérent et qui produise des résultats pleinement exploitables.

Dans tous les cas, une équipe étude est constitué en interne pour suivre l'avancée de l'étude.
Si l'étude est réalisée en interne, cette équipe étude s'occupe de l'intégralité du processus.
Sinon, cette équipe gère l'appel d'offre, l'externalisation de l'étude et la gestion de sous-traitance.

Si l'organisation n’a pas dans ses effectifs un expert en études stratégiques,
alors mener l'étude en interne pourrait avoir un manque d'impartialité et produire des résultats
peu exploitables et sans offrir de réelles pistes d'amélioration.

Notons que l’analyse des résultats est complexe.
Par exemple, le croisement des réponses négatives nécessitent d’être croisées
afin d’identifier si ce sont les mêmes groupes de répondants.
Un autre exemple de la complexité est de savoir expliquer les pourcentages
entre des réponses Oui, Non et absence de réponse en fonction des autres réponses.

La recommandation est de passer par un institut de sondage avec les avantages suivants :

- Impartialité : regard neutre vis-à-vis des enjeux de l’organisation, questions non orientées, analyse objective
- Expertise : savoir-faire des enquêtes d’opinion, des analyses croisées, des biais dans les réponses
- Outillage : logiciels pour les sondages et méthodes d’analyse des réponses
- Comparatif : les résultats par rapport aux autres organisations
- Anonymat : garanti


Appel d'offre
-------------

Afin de choisir l'institut de sondage qui semble le plus à même de gérer l'étude,
un appel d'offre est envoyé à quelques instituts.
Ce document explique les paragraphes à faire figurer dans cet appel d'offre.


Exemple
-------

Pour illustrer les différentes étapes, ce document donne l'exemple
de l'organisation XXXX qui souhaite réaliser une étude stratégique
via une enquête d'opinion auprès de ses collaborateurs.
L'étude est nommée *"Conjuguer bien être et performance"*.

Dans cet exemple, l'organisation XXXX souhaite pérenniser sa croissance
mais aussi de permettre aux collaborateurs de donner le meilleur d’eux même dans la durée.

Cette organisation XXXX connaît une croissance rapide sur un marché en pleine mutation.
Pour s’adapter à son environnement et innover en permanence,
l'organisation XXXX doit se réinventer en permanence.


Délai
-----

Afin d'obtenir des résultats exploitables,
chacune des étapes ci-dessus a besoin d'être menée sans être bâclée.

Seuls des résultats exploitables apportent une bonne visibilité
et permettent de réfléchir aux changements les plus judicieux.

De plus, en s'y prenant bien, le questionnaire pourra être réutilisé régulièrement
afin d'obtenir un baromètre de suivi de l'évolution des actions mises en place.

Dans le cas de notre exemple, le délai de l'ensemble de ces étapes
peut-être estimée entre deux et cinq mois,
selon la maturité de l'équipe étude,
mais aussi selon la complexité des problématiques abordées.


Budget
------

Dans l'exemple de l'organisation XXXX,
les instituts pourraient facturer entre 20 000 € et 50 000 €.

À ce budget, il convient d'intégrer le temps passé par l’équipe interne (interactions avec l'institut)
et le coût d’un séminaire réunissant tous les collaborateurs.


Contexte
--------

L'appel d'offre présente le contexte de l'organisation,
pour permettent à l'institut de se faire une idée du fonctionnement de l'organisation.

Ce chapitre rappelle l'environnement de l'organisation et ses challenges :
historique, organigramme, marché, financement…


Défis
-----

En plus du contexte, l'appel d'offre peut également préciser les défis de l'organisation.

Voici des exemples de défis :

- Améliorer les fondamentaux pour rassurer les investisseurs de la bonne gestion en vue des prochaines levées de fonds / subventions
- Surveiller sa trésorerie (croissance ne rime pas forcément avec rentrée de cash)
- Impliquer les collaborateurs dans l’optimisation des dépenses
- Donner de la visibilité à moyen et long terme aux investisseurs, collaborateurs et clients
- Recruter de nombreux nouveaux talents, parfois sur des profils très disputés et en pénurie
- Permettre aux collaborateurs de s’épanouir et d’avoir une vie de famille
- Culture d'organisation de respect mutuel entre collègues (pas de politique, pas de peur de s'exprimer)
- Responsabilisation de l’ensemble des collaborateurs
- Développer l’esprit collectif
- Inciter tous les collaborateurs à se concentrer sur le client (les tâches qui valorisent la plus-value pour nos clients)
- Livrables de qualité
- Livraisons sans retard
- Intégrer le client dans la production des livrables
- Mieux former les managers
- Mettre en place un leadership davantage participatif
- Rester attentif aux changements du marché, et adapter le business modèle en conséquence
- Mettre en place un véritable processus d’amélioration continue pour gagner en maturité


Constat
-------

L'appel d'offre pose aussi le constat.
C'est un ensemble de faits vérifiables.
Cette liste est définie par l'équipe étude interne de l'organisation XXXX.

La liste ci-dessous est un exemple de l'organisation XXXX.

- Turnover important
- Cohésion à améliorer entre les différents sites
- Des projets réalisés dans l’urgence sans pouvoir vraiment mutualiser les développements
- Les commerciaux qui ne peuvent pas vendre, car les livrables ne suivent pas
- Peu d’entraide/mutualisation entre des services similaires
- Estimations optimistes des planning et charge de travail
- Tâches non planifiées à réaliser d’urgence au dernier moment
- Des *coups de pression* fréquents à fournir juste avant les livrables pour éviter les retards
- Managers obligés de contrôler sinon ils ne sont pas alertés des difficultés rencontrées (retards)
- Peu de bonnes pratiques partagées
- Peu d’autonomie des collaborateurs pour s’organiser
- L’état d’esprit de telle équipe se désagrège
- Cloisonnement entre les métiers
- Contexte difficile de recrutement
- Équipes en souffrance au regard de leur charge de travail
- Objectifs changeants, souvent imposés qui désorientent les collaborateurs
- Vision et stratégie de l’organisation peu ou mal comprises par les collaborateurs : engagement des collaborateurs moindre
- Commerciaux peu préoccupés par l’enchantement client

L'organisation XXXX est dans une période tendue pour laquelle ses clients,
par les échanges et les livrables, peuvent devenir méfiants envers XXXX.
Livrer de la non-qualité peut discréditer l'organisation XXX, détériorer son image
et à terme lui faire perdre une partie de ses clients.


Problématique
-------------

Après avoir posé le constat, l'appel d'offre s'attaque
à la problématique (le périmètre) pour laquelle l'étude va se concentrer.

L'organisation XXXX a certainement d'autres problématiques,
mais ce serait trop difficile de prendre en considération
des problématiques trop diverses.
Un bon sondage correspond à une problématique bien délimitée.

Attention aux mots utilisés pour les communications internes.
Le mot *"problématique"* incite à chercher les *"problèmes"*,
alors qu'il est souhaitable dans sa communication interne à favoriser la recherche de *"solutions"*.

Par conséquent, en parlant ouvertement de problématiques,
les collaborateurs pourraient avoir le focus sur les problèmes (et souvent à les chercher chez les autres).
Essayons plutôt d'avoir un plan de communication qui mette l'accent sur l'amélioration par des décisions collectives).

Voici notre exemple de l'organisation XXXX qui considère que la qualité de vie au travail est un levier essentiel de la performance.
En effet, le degré d’engagement des collaborateurs a toujours été un facteur essentiel de la performance de l’organisation.
La démobilisation des collaborateurs est souvent invisible auprès des décideurs,
mais représente cependant un coût très important qui met en difficulté une organisation face à des concurrents disruptifs.
Afin de conjuguer bien être des collaborateurs et performance des équipes,
la direction de l'organisation XXXX souhaite donc réaliser un sondage auprès de ses collaborateurs.
La direction souhaite également que la mise en place de cette étude soit valorisée auprès des investisseurs :
la remise en question de l’organisation est un gage de pérennité pouvant rassurer les investisseurs et faciliter les prochaines levées de fonds.
Ce sondage doit pouvoir être réalisé périodiquement afin d’être utilisé comme baromètre et outil de pilotage.


Objectifs
---------

Les objectifs, définis dans l'appel d'offre, permettent à l'institut
de mieux cerner les attentes de l'organisation XXXX.
Cette liste est définie par l'équipe étude interne en adéquation avec les attentes de la direction.

Comme exemple, l'organisation XXXX souhaite que l'étude lui permette de mesurer :

- Perception des collaborateurs sur de grandes thématiques essentielles de l'organisation
- Sentiment d’appartenance à l’organisation
- Niveau d’engagement des collaborateurs
- Perception des collaborateurs sur les différentes composantes de l’organisation (des départements, de la stratégie globale, du management, des orientations…)
- Motifs de satisfaction, d’insatisfaction, et des irritants au quotidien
- Différents leviers d’amélioration
- Acceptation du changement
- Qualité perçue du dialogue social
- Implication des collaborateurs dans le travail
- Conditions matérielles de travail
- Bilan du partage d’informations des nouvelles réunions mensuelles
- Bilan du dernier team-building (séminaire)
- Bilan des team-building par équipe (restaurant)
- Bilan de la nouvelle organisation des équipes
- Décalage entre les valeurs de l’organisation et ce qu’en pensent les collaborateurs


Thématiques
-----------

Les thématiques permettent d'organiser le sondage en abordant différent aspects.
L'institut peut suggérer des thématiques en collaboration avec l'équipe étude.

Exemple de thématiques pour l'organisation XXX :

**Le climat de l'organisation encourage-t-il la collaboration ?**

- Le partage des valeurs communes au sein de l'organisation.
- La clarté des règles qui régissent la vie dans l'organisation.
- L'acceptation des différences qui existent dans l'organisation.
- La qualité du soutien que chacun peut recevoir de l'organisation.

**Le climat de l'organisation encourage-t-il à la bonne réalisation des tâches affectées à chacun ?**

- La clarté des objectifs assignés à chacun.
- La qualité de la planification des tâches de chacun.
- La compréhension des objectifs de l’équipe.
- La qualité des moyens mis à disposition de chacun pour atteindre les objectifs assignés.
- La qualité des informations que chacun peut recevoir en retour du travail effectué.

**Le climat de l'organisation encourage-t-il le renouvellement et la capacité de l'équipe à se développer ?**

- La valorisation de l'innovation et de la créativité au sein de l'organisation.
- La valorisation de la prise d'initiative de chacun dans l'organisation- La prise en compte des différents points de vue pouvant exister au sein de l'organisation.
- La certitude d'avoir le droit à l'erreur qui crée un sentiment de sécurité et encourage la prise d'initiatives.

**Le climat de l'organisation permet-il à chacun de ses membres de s'épanouir et de se développer personnellement ?**

- Le degré d'intérêt de chacun des collaborateurs pour la mission qui lui est confiée.
- Les possibilités pour les collaborateurs d'exploiter leur capacité et leur potentiel au travail.
- La possibilité pour des collaborateurs de se développer dans points de vue personnels.
- La qualité des relations nouées avec les autres membres de l'organisation.


Méthodologie
------------

Par exemple, l'organisation XXXX indique les contraintes suivantes dans son appel d'offre :

- Questionnaire en ligne
- À destination de tous les collaborateurs et ceux ayant quittés l’organisation récemment
- Passation du questionnaire en moins de 10 minutes
- Informer du sondage un lundi pour permettre aux collaborateurs de s’organiser à l’avance
- Ouverture du questionnaire un mardi matin pour obtenir une participation élevée
- Disponibilité du questionnaire réduite à quelques jours seulement pour éviter la procrastination
- Anonymat des répondants (l'organisation XXXX connait seulement le pourcentage de participation)
- Confidentialité des réponses individuelles


Équipe pour mener cette étude
-----------------------------

Dans notre exemple, l'étude de l'organisation XXXX touche à l'organisation du travail, des équipes et aux ressources humaines.

L'organisation XXXX n'ayant pas de spécialistes des études,
une petite équipe est constituée avec une personne proche de la direction,
une personne des ressources humaines, et une personne du métier qui est sensible aux conditions de travail.

La cohésion de l'équipe étude est indispensable, ainsi que la maîtrise de la communication en interne.

Attention, si l’étude est complètement menée en interne, le risque de partialité est important.
Les parties prenantes pourraient avoir un biais dans le choix des questions et orienter les réponses,
ou un biais dans l'interprétation des résultats selon leurs intérêts.

Dans les organisations dans lesquelles les services ont des intérêts divergents (politique),
l’équipe gérant l’étude à intérêt à garder confidentiel les réflexions et le questionnaire
pour éviter toute critique prématurée : sondage mal fait, questions mal formulées…


Planning
--------

Voici un exemple pour l'étude de l'organisation XXXX avec entre parenthèse, le délai estimé.

Lancement :

- Rédiger l’appel d’offre en réfléchissant bien aux problématiques et objectifs (quelques semaines)
- Valider/corriger l’appel d’offre avec les parties prenantes (une semaine)

Si l’étude est menée en interne :

- Réfléchir aux thématiques du questionnaire (deux semaines)
- Concevoir l’architecture du questionnaire réutilisable comme baromètre (une semaine)
- Rédiger le questionnaire final (deux semaines)
- Mettre en ligne le questionnaire et vérifier/corriger les différents parcours (quelques jours)
- Communiquer aux équipes l’objectif du sondage et les inviter à y participer (quelques heures)
- Suivre le taux de participation et relancer si nécessaire (quelques jours)
- Analyser les résultats pour donner un sens aux réponses (deux semaines)
- Rédaction du rapport d’étude avec un format présentation (deux semaines)

Si l’étude est externalisée à un institut de sondage :

- Contacter plusieurs instituts et les inviter à répondre à l’appel d’offre (une semaine)
- Répondre aux questions des instituts et sélectionner le plus pertinent (deux semaines)
- Aider l’institut dans la conception/rédaction du questionnaire (plusieurs semaines)
- Valider/Corriger le questionnaire (quelques jours)
- Lancer l'étude, suivre le taux de participation et relancer si nécessaire (quelques jours)
- Attendre le rapport de l’étude par l’institut (quelques semaines)
- Lire et rectifier le rapport de l’étude avec l’institut (une semaine)

Enfin :

- Présenter le rapport à la direction (quelques heures)
- Amélioration du rapport suite au feedback de la direction (quelques jours)
- Selon les impacts, choisir comment partager les résultats au reste de XXXX (quelques jours)
- Organiser la restitution de l’étude auprès de l’ensemble des collaborateurs (quelques semaines)
- Restituer les résultats avec tous les collaborateurs en mode séminaire et susciter des discussions bienveillantes (quelques heures)
- Proposer aux collaborateurs des ateliers pour aider à se remettre en question, présenter une mini pièce de théâtre ludique pour prendre du recul, organiser des tables rondes pour proposer des axes d’amélioration, permettre la prise de décision collectivement, présenter/tester ses idées aux autres collaborateurs, impliquer les collaborateurs dans les changements… (un ou deux jours)
- Suivi des changements décidés collectivement (quelques mois)

Les restitutions des résultats peuvent être prises en charge par l’institut de sondage.
Attention, à bien présenter les résultats en une seule fois pour tous les collaborateurs, quitte à les faire déplace.
Si, par exemple, l'organisation XXXX a des bureaux dans deux villes, présenter les résultats en deux temps
va certainement provoquer deux réactions différentes, par exemple, en critiquant l’autre site, et cela risque de creuser l’écart entre les deux sites.
La présentation en visio est également déconseillée.


Conclusion
----------

Les résultats de cette étude permettront à l'organisation XXXX de dresser le bilan de son organisation du travail.
Suite à ce bilan, l'organisation XXXX pourra tester de nouvelles orientations afin d'améliorer
le bien-être de ses collaborateurs et la performance de ses équipes.

L’investissement financier et en temps peut paraître important,
mais cette étude va apporter des éclairages pour pérenniser la capacité de l'organisation XXXX à s’adapter rapidement
et à amplifier sa croissance dans le respect de ses collaborateurs.

La direction de XXXX :

- précise ses attentes de l’étude
- choisi si institut extérieur ou équipe interne
- définit un budget (ou plus tard)
- définit un délai (ou plus tard)
- donne son avis sur l'organisation d'un séminaire
- choisit le niveau de transparence/confidentialité avec les collaborateurs
