Definition of Done
------------------

**D**efinition **o**f **D**one --> **DoD**


DoD concerns only ***code for production***
-------------------------------------------

1.  Source code respects Security Rules
2.  Source code respects Coding Rules
    * Run `cpplint` and `kwstyle` for *Naming Rules Compliance*.
3.  Source code respects C++ Core Guidelines
4.  Source code does not throw exception (but uses Tredzone messages)
5.  Doxygen comments are used when relevant (except for setters/getters...)
6.  No remaining FIXME
7.  No compiler warnings
8.  Unit-Tests must respect TDD or GUTS guidelines
9.  All Unit-Tests passed OK
10. Check code coverage by tests (unit tests, integration tests...)
    * No 80% threshold because [*"When a measure becomes a target, it ceases to be a good measure."* (Goodhart's law)](https://en.wikipedia.org/wiki/Goodhart's_law)
    * Read also [Alberto's anecdote about *"How Much Unit Test Coverage Do You Need?"*](http://www.artima.com/forums/flat.jsp?forum=106&thread=204677)
    * And [Jon's anecdote about *"What is a reasonable code coverage % for unit tests?"*](http://stackoverflow.com/a/90089/938111)
    * Check what is not covered/tested (can be code lines, code branches, input data...)
        * If the untested/uncovered part is not relevant => Unit-Test can be considered as OK.
        * But if something is missing => Add tests to cover this part.
11. No dead code
12. Check Valgrind
13. Check CppCheck
14. Check [AddressSanitizer](https://en.wikipedia.org/wiki/AddressSanitizer) using build options `-fsanitize=*` ([clang](http://clang.llvm.org/docs/AddressSanitizer.html) and [gcc](https://gcc.gnu.org/onlinedocs/gcc/Instrumentation-Options.html#index-fsanitize_003daddress-945))
15. Check [clang-check](http://clang.llvm.org/docs/ClangCheck.html) (static code analyzer, detects code patterns that most probably are bugs and inspects control flow graph and do path-based analysis)
16. Check [clang-tidy](http://clang.llvm.org/extra/clang-tidy/) (linter, checks coding style and address readability, and can fix C++ source code)


Code coverage before `git commit`
---------------------------------

Developers can check code coverage on their local environment before pushing to GitLab remote.

### Install at least one coverage repport-maker

1. `gcovr` is one python script presented on http://gcovr.com/
2. `lcov` is more powerfull but more complex (see [website](http://ltp.sourceforge.net/coverage/lcov.php) and [github](https://github.com/linux-test-project/lcov))

### In both cases, the CMake script make easy to produce Coverage report

1. Generate build files for Coverage build type

    ```bash
    # Recommanded way
    $ ./prepare.sh --cov

    # Alternative
    $ ( mkdir build && cd build && cmake -DCMAKE_BUILD_TYPE=Coverage .. )
    ```

2. Build and run your test

    ```bash
    # Recommanded way
    $ ./build-and-test.sh

    # Alternative
    $ make -C build all test
    ```
    
3. Generate coverage report

    ```bash
    # If gcovr is present
    $ make -C build gcovr

    # If lcov and genhtml are present
    $ make -C build lcov
    # Note: lcov removes the *.gcda and *.gcdo files
    #       containing coverage data
    ```

4. Read the generated HTML report  
   Below `<build>` is the folder where CMake has generated build scripts.
    * The HTML report generated by `gcovr` is `<build>/gcovr.html`
    * The HTML report generated by `lcov` has many files, the entry point is `<build>/lcov/index.html`
   
     You can search within the standard output of the build process to find the absolute path of the generated HTML report.
