% Autonomy is the key of team involvement
=========================================


Team ownership
==============

The way to do the job has not be decided at big boss level.
Best is to give the control to all the team members.
Not only to the team gurus and other technical leaders.

More the members have the hands within the source code, tests and documentation, more decision power they should get.
Members should decide only for the parts of the project they know.
Team leader should just indicate their feeling but not ~~decide~~ vote.
Leaders may vote if they get their hands dirty *(s'ils ont les mains dans le cambouis)*.

When the whole team decides together
what task to do, who do it and how to do it,
each member appropriates herself the job.

For each task, the team democratically decides:

* the relevance,
* the priority,
* when to evaluate the results.

Target is to obtain **consensus** not **compromise**/**concession**.

Team leaders must agree with team decision
and be responsible for the practical application.
Other team members must also agree with team decision
and be responsible for the practical application.



Retrospective meetings
======================

Adopt scrum retrospective meetings for continuous improvement.

* Bottom Up decision work-flow (people who does the job decide how to do it)
* Test different frequencies between "once a week" and "once a month"
* "Definition of Done"
* Collect member ideas and select best ones
    * Make process more fluid and predictable
    * Reduce technical debt

Examples:

* Respect the Google Code Style Guide only when it is justified
* Justify rule breaking (many rules are not respected, What is the reason?)
* Break the [File Names rule](https://google.github.io/styleguide/cppguide.html#File_Names) to get more readable filenames (using the CamelCase class name)



Team self-training
==================

Encourage trainings like [Lightning talks](https://en.wikipedia.org/wiki/Lightning_talk) and [Unconferences](https://en.wikipedia.org/wiki/Unconference) in order to share skills and knowledge across team members (and across other project teams). Every body is agree on that point. The question is more about how to **encourage this good practice over time**.

Some subject examples:

* Good Unit Tests
* SOLID principles
* Design Patterns
* Modern CMake and dependency configuration
* Gradle
* [C++ Core Guidelines](https://github.com/isocpp/CppCoreGuidelines)
* Generic programming paradigm
* Meta-programming
* C++17
