#!/bin/sh

DB_SUBQL_NAME=${DB_SUBQL_NAME:-subql}
DB_SUBQL_USER=${DB_SUBQL_USER:-subql}
DB_SUBQL_PASSWORD=${DB_SUBQL_PASSWORD:-subql}

DB_METABASE_NAME=${DB_METABASE_NAME:-metabase}
DB_METABASE_USER=${DB_METABASE_USER:-metabase}
DB_METABASE_PASSWORD=${DB_METABASE_PASSWORD:-metabase}

echo "🔨 Creating databases $DB_SUBQL_NAME $DB_METABASE_NAME"
psql -v ON_ERROR_STOP=1 --username "$POSTGRES_USER" <<EOF
-- Subquery DB
CREATE DATABASE $DB_SUBQL_NAME;
\connect $DB_SUBQL_NAME;
CREATE EXTENSION IF NOT EXISTS btree_gist;

CREATE USER $DB_SUBQL_USER WITH ENCRYPTED PASSWORD '$DB_SUBQL_USER';
GRANT ALL PRIVILEGES ON DATABASE $DB_SUBQL_NAME TO $DB_SUBQL_USER;

-- Metabase DB
CREATE DATABASE $DB_METABASE_NAME;

CREATE USER $DB_METABASE_USER WITH ENCRYPTED PASSWORD '$DB_METABASE_USER';
GRANT ALL PRIVILEGES ON DATABASE $DB_METABASE_NAME TO $DB_METABASE_USER;
EOF
