<h3 align="center">
<img src="https://cdn.rawgit.com/odb/official-bash-logo/master/assets/Logos/Identity/PNG/BASH_logo-transparent-bg-color.png">
</h3>

# Official GNU Bash Logo
Everything you need to start using the official GNU Bash logo.

## Meta
* Client: [Chet Ramey](http://tiswww.case.edu/php/chet/) (Representing GNU/FSF)
* Commissioned by: [MaxCDN](https://www.maxcdn.com)
* Art director: [Justin Dorfman](https://github.com/jdorfman)
* Designed by: [ProspectOne](https://prospectone.io)
* Font: [Roboto Mono](https://github.com/google/roboto/) (Apache License, Version 2.0)
* Logo License: [Free Art License](http://artlibre.org/licence/lal/en/)
* Copyright 2016 [Free Software Foundation](https://www.fsf.org/)

## FAQ
**Yes you can...**
* Can I use this on my website?
* What about in a presentation?
* Any type of print media? (book, magazine, flyer, sticker)
* Promoting a commercial project that uses Bash e.g. _Bash on Windows_?
* Sell merchandise using this artwork? _(please consider giving some proceeds to the FSF)_

**Please do not...**
* Can I change any colors or fonts? _(see bash-style-guide.pdf for acceptable use)_
 * **Note:** any modification(s) must adhere to section `2.3` "FREEDOM TO MODIFY" of the Free Art License (1.3)
* Use the icon for my logo?

**Trivia**
* The logo represents a stylized video terminal like the [VT100](https://en.wikipedia.org/wiki/VT100) displaying a [command prompt](https://en.wikipedia.org/wiki/Command-line_interface#Command_prompt).

If you still have questions or concerns please email [licensing@fsf.org](http://www.fsf.org/about/contact/email)

## Files
```
.
├── CONTRIBUTING.md
├── LICENSE
├── README.md
└── assets
    ├── LICENSE
    ├── Logos
    │   ├── Font
    │   │   └── Roboto_Mono
    │   │       ├── LICENSE.txt
    │   │       ├── RobotoMono-Bold.ttf
    │   │       ├── RobotoMono-BoldItalic.ttf
    │   │       ├── RobotoMono-Italic.ttf
    │   │       ├── RobotoMono-Light.ttf
    │   │       ├── RobotoMono-LightItalic.ttf
    │   │       ├── RobotoMono-Medium.ttf
    │   │       ├── RobotoMono-MediumItalic.ttf
    │   │       ├── RobotoMono-Regular.ttf
    │   │       ├── RobotoMono-Thin.ttf
    │   │       └── RobotoMono-ThinItalic.ttf
    │   ├── Icons
    │   │   ├── PNG
    │   │   │   ├── 128x128.png
    │   │   │   ├── 128x128_white.png
    │   │   │   ├── 16x16.png
    │   │   │   ├── 16x16_white.png
    │   │   │   ├── 24x24.png
    │   │   │   ├── 24x24_white.png
    │   │   │   ├── 256x256.png
    │   │   │   ├── 256x256_white.png
    │   │   │   ├── 32x32.png
    │   │   │   ├── 32x32_white.png
    │   │   │   ├── 48x48.png
    │   │   │   ├── 48x48_white.png
    │   │   │   ├── 512x512.png
    │   │   │   ├── 512x512_white.png
    │   │   │   ├── 64x64.png
    │   │   │   ├── 64x64_white.png
    │   │   │   ├── Favicon-16x16.png
    │   │   │   └── Favicon-16x16_white.png
    │   │   ├── SVG
    │   │   │   ├── 128x128.svg
    │   │   │   ├── 128x128_white.svg
    │   │   │   ├── 16x16.svg
    │   │   │   ├── 16x16_white.svg
    │   │   │   ├── 24x24.svg
    │   │   │   ├── 24x24_white.svg
    │   │   │   ├── 256x256.svg
    │   │   │   ├── 256x256_white.svg
    │   │   │   ├── 32x32.svg
    │   │   │   ├── 32x32_white.svg
    │   │   │   ├── 48x48.svg
    │   │   │   ├── 48x48_white.svg
    │   │   │   ├── 512x512.svg
    │   │   │   ├── 512x512_white.svg
    │   │   │   ├── 64x64.svg
    │   │   │   ├── 64x64_white.svg
    │   │   │   ├── BASH_logo-transparent-bg-bw-02.svg
    │   │   │   ├── Favicon-16x16.svg
    │   │   │   └── Favicon-16x16_white.svg
    │   │   └── Source
    │   │       ├── AI
    │   │       │   └── BASH-icons-RGB-to-WEB.ai
    │   │       ├── EPS
    │   │       │   ├── BASH-icons-RGB-to-WEB-01.eps
    │   │       │   └── BASH-icons-RGB-to-WEB-02.eps
    │   │       └── PDF
    │   │           └── BASH-icons-RGB-to-WEB.pdf
    │   └── Identity
    │       ├── PNG
    │       │   ├── BASH_logo-transparent-bg-bw.png
    │       │   └── BASH_logo-transparent-bg-color.png
    │       ├── SVG
    │       │   ├── BASH_logo-transparent-bg-bw.svg
    │       │   └── BASH_logo-transparent-bg-color.svg
    │       └── Source
    │           ├── AI
    │           │   ├── BASH_logo-transparent-bg-bw.ai
    │           │   └── BASH_logo-transparent-bg-color.ai
    │           └── Style_guide
    │               ├── AI
    │               │   ├── BASH-logo-stickers-for-PRINT-CMYK.ai
    │               │   └── BASH_logo-vs-elements_for-PRINT-CMYK.ai
    │               ├── EPS
    │               │   ├── BASH-logo-stickers-for-PRINT-CMYK.eps
    │               │   ├── BASH_logo-vs-elements_for-PRINT-CMYK-01.eps
    │               │   ├── BASH_logo-vs-elements_for-PRINT-CMYK-02.eps
    │               │   ├── BASH_logo-vs-elements_for-PRINT-CMYK-03.eps
    │               │   ├── BASH_logo-vs-elements_for-PRINT-CMYK-04.eps
    │               │   └── BASH_logo-vs-elements_for-PRINT-CMYK-05.eps
    │               └── PDF
    │                   ├── BASH-logo-stickers-for-PRINT-CMYK.pdf
    │                   └── BASH_logo-vs-elements_for-PRINT-CMYK.pdf
    ├── bash-style-guide.pdf
    └── copyright-agreement.pdf

20 directories, 74 files
```

## Sightings
* [The GNU Bourne-Again SHell website](https://tiswww.case.edu/php/chet/bash/bashtop.html)
* [Wikipedia](https://en.m.wikipedia.org/wiki/Bash_(Unix_shell))
* [OpenSource.com](https://opensource.com/article/16/12/bash-logo-community)
* [Instant Logo Search](http://instantlogosearch.com/?q=bash)
* [Learning bash scripting for beginners](https://www.cyberciti.biz/open-source/learning-bash-scripting-for-beginners/)
* [OS X Password Generator in BASH](https://medium.com/@jdorfman/osx-password-generator-in-bash-48687892c4f3#.31hsjpeac)
* [Howto: Changing Linux Login Shell](https://www.cyberciti.biz/faq/howto-change-linux-unix-freebsd-login-shell/)
* [How to copy a single file to multiple directories in Linux or Unix](https://www.cyberciti.biz/faq/linux-unix-copy-a-file-to-multiple-directories-using-cp-command/)
* [Maximum Character Length of Arguments In a Shell Command](https://www.cyberciti.biz/faq/linux-unix-arg_max-maximum-length-of-arguments/)
* [Shell Scripts Matter](https://dev.to/thiht/shell-scripts-matter)
* [bash-guide - A guide to learn bash](https://github.com/Idnan/bash-guide)
* [Shell scripting (BASH) : How to create temporary random file name](https://www.cyberciti.biz/tips/shell-scripting-bash-how-to-create-temporary-random-file-name.html)
* [Linux / UNIX: Find Out If File Exists With Conditional Expressions in a Bash Shell](https://www.cyberciti.biz/tips/find-out-if-file-exists-with-conditional-expressions.html)
* [How to get domain name from URL in bash shell script](https://www.cyberciti.biz/faq/get-extract-domain-name-from-url-in-linux-unix-bash/)
* [How To Use tar Command Through Network Over SSH Session](https://www.cyberciti.biz/faq/howto-use-tar-command-through-network-over-ssh-session/)
* [How To Find a Directory On Linux Based System](https://www.cyberciti.biz/faq/howto-find-a-directory-linux-command/)
* [Reddit: GNU Bash has a official logo and it looks so beautiful](https://www.reddit.com/r/linux/comments/7dupyf/just_found_out_that_gnu_bash_has_a_official_logo/)
* [Bash Logo Media Assets](https://bashlogo.com/)
* [Developing Console Applications with Bash](https://www.linuxjournal.com/content/developing-console-applications-bash)
* [GitHub Topics > Bash](https://github.com/topics/bash)
* [Pure Bash Bible](https://github.com/dylanaraps/pure-bash-bible)
* [Dribbble](https://dribbble.com/shots/4040291-Bash-Logo)
* [What is your favorite Linux terminal trick?](https://opensource.com/article/18/8/terminal-trick)
* [Changelog Bash topic](https://changelog.com/topic/bash)
* [Bash at DuckDuckGo](https://duckduckgo.com/?q=bash&t=hi&ia=web&natb=v132-1_i)
* [How to enable auto complete for git commands](http://satishgandham.com/2017/11/enable-auto-complete-git-commands-branches-mac-osx-terminal-command-line/)
* [How To Write A BASH 'for' Loop](https://www.lifewire.com/bash-for-loop-examples-2200575)
* [How to Pass Arguments to a Bash-Script](https://www.lifewire.com/pass-arguments-to-bash-script-2200571)
* [How to Write Bash WHILE-Loops](https://www.lifewire.com/write-bash-while-loops-2200576)
* [Unixsticker Promo Tweet](https://twitter.com/unixstickers/status/1036967410098688002)
* [Writing More Compact Bash Code](https://www.linuxjournal.com/content/writing-more-compact-bash-code)
* [How to Create and Use Bash Scripts](https://www.taniarascia.com/how-to-create-and-use-bash-scripts/)
* [How To Use Bash Parameter Substitution Like A Pro](https://www.cyberciti.biz/tips/bash-shell-parameter-substitution-2.html)
* [Newbie at bash scripting? Here's some advice](https://dev.to/pencillr/newbie-at-bash-scripting-heres-some-advice-j1a)
* [CapitalOne's Bash Shell Mock](https://github.com/capitalone/bash_shell_mock)
* [Shop FSF > BASH logo sticker pack](https://shop.fsf.org/stickers/bash-logo-sticker-pack)
* [Bash IDE](https://marketplace.visualstudio.com/items?itemName=mads-hartmann.bash-ide-vscode)

Have you seen the logo around? Make a [Pull Request](https://github.com/odb/official-bash-logo/pulls) with the link.
