# Learn modern PHP

[<img src="assets/images/php-logo.svg" width="250">](https://php.net/)

A curated list of resources for [PHP](https://php.net/)

## Table of Contents

* [Must read](#must-read)
* [Tutorials](#tutorials)
* [Books](#books)
* [Online Course](#online-course)
* [Reference](#reference)
* [The basics](#the-basics)
  * [PHP Basics](#php-basics)
  * [The LAMP stack](#the-lamp-stack)
  * [HTML / HTML 5](#html--html-5)
  * [CSS](#css)
  * [JavaScript](#javascript)
  * [Protocols](#protocols)
* [Local Development Environments](#local-development-environments)
* [Tools](#tools)
* [IDEs](#ides)
* [Frameworks and libraries](#frameworks-and-libraries)
  * [Frameworks](#frameworks)
  * [Micro Frameworks](#micro-frameworks)
  * [Libraries](#libraries)
* [Templates](#templates)
* [OOP](#oop)
  * [Object-oriented programming](#object-oriented-programming)
  * [Design patterns](#design-patterns)
  * [SOLID](#solid)
  * [Dependency injection](#dependency-injection)  
* [Best Practices](#best-practices)
* [Model-View-Controller](#model-view-controller)
* [Database](#database)
  * [Database basics](#database-basics)
  * [Database books](#database-books)
  * [Relational database management system (RDBMS)](#relational-database-management-system-rdbms)
  * [Database normalization](#database-normalization)
  * [Prepared Statements](#prepared-statements)
  * [NoSQL](#nosql)
  * [Database libraries](#database-libraries)
  * [Database tools](#database-tools)
* [Standards](#standards)
* [Errors and exception handling](#errors-and-exception-handling)
* [Debugging](#debugging)
* [Unit testing](#unit-testing)
* [Documentation](#documentation)
* [Sessions](#sessions)
* [Text translations](#text-translations)
* [Regular Expressions](#regular-expressions)
* [XML](#xml)
* [API](#api)
  * [REST](#restful-api)
  * [SOAP](#soap-api)
* [Version control](#version-control)
* [Security](#security)
* [Architecture](#architecture)
* [Domain Driven Design (DDD)](#domain-driven-design-ddd)
* [Hexagonal Architecture](#hexagonal-architecture)
* [Functional Programming](#functional-programming)
* [Continuous integration and Continuous Delivery](#continuous-integration-ci-and-continuous-delivery-cd)
* [Magazines](#magazines)
* [Merchandise](#merchandise)  
* [Community and News](#community--news)


## Must read

* [PHP The Right Way](https://phptherightway.com/)
* [The Web Developer Roadmap](https://github.com/kamranahmedse/developer-roadmap)

## Tutorials

* [Full PHP 8 Tutorial - Learn PHP The Right Way In 2022](https://www.youtube.com/watch?v=sVbEyFZKgqk&list=PLr3d3QYzkw2xabQRUpcZ_IBk9W50M9pe-&index=1&ab_channel=ProgramWithGio)
* [PHP Front To Back](https://www.youtube.com/playlist?list=PLillGF-Rfqbap2IB6ZS4BBBcYPagAjpjn) (Videos)
* [learn-php.org](https://www.learn-php.org/)
* [Learn PHP for experienced developers](https://blog.syntaxseed.com/learn-php-for-experienced-developers/)
* [PHP For Beginners](https://laracasts.com/series/php-for-beginners-2023-edition)
* [PHP Pandas](https://daylerees.com/php-pandas/)
* [Learn PHP in Y minutes](https://learnxinyminutes.com/docs/php/)
* [PHP Apprentice](https://phpapprentice.com/)
* [PHP by Example](https://phpbyexample.dev/)

## Books

* [Advanced Web Application Architecture](https://leanpub.com/web-application-architecture/)
* [Building modern applications with PHP 8](https://front-line-php.com/)
* [Modern PHP: New Features and Good Practices](https://www.amazon.de/gp/product/1491905018/ref=as_li_tl?ie=UTF8&camp=1638&creative=6742&creativeASIN=1491905018&linkCode=as2&tag=28031982-21)
* [Object Design Style Guide](https://www.manning.com/books/object-design-style-guide?a_aid=object-design&a_bid=4e089b42)
* [Learning PHP 7](http://shop.oreilly.com/product/9781785880544.do)
* [PHP 7 Zend Certification Study Guide](https://www.amazon.com/PHP-Zend-Certification-Study-Guide/dp/1484232453/?tag=28031982-21)
* [Learn PHP 8: Using MySQL, JavaScript, CSS3, and HTML5](https://amzn.to/3oyKj2O)
* [PHP 8 Quick Scripting Reference: A Pocket Guide to PHP Web Scripting](https://amzn.to/3bpTpex)
* [Programming PHP](https://www.oreilly.com/library/view/programming-php-4th/9781492054122/) (O'Reilly Media)
* [The Art of Modern PHP 8](https://www.packtpub.com/product/the-art-of-modern-php-8/9781800566156)

## Online Course

* [CodeAcademy - Learn PHP](https://www.codecademy.com/learn/learn-php)
* [Codecourse](https://www.youtube.com/codecourse/videos)  
* [Exercism - PHP](https://exercism.io/tracks/php) (Code practice and mentorship)
* [SymfonyCasts - Build something amazing with PHP](https://symfonycasts.com/tracks/php)
* [Treehouse - Learn PHP](https://teamtreehouse.com/learn-to-code/php)
* [Udemy - PHP](https://www.udemy.com/topic/php/)
* [DevProjects + Codementor](https://www.codementor.io/projects/php) (Free PHP projects and optional paid mentorship)
* [Free PHP courses](https://skillcombo.com/topic/php/free/)

## Reference

* [Language Reference](https://secure.php.net/manual/en/langref.php)
* [Modern PHP Cheat Sheet](https://front-line-php.com/cheat-sheet)
* [PHP Manual](https://secure.php.net/manual/en/index.php)
* [PHP cheatsheet](https://quickref.me/php)

## The basics

### PHP Basics

* [PHP Developer roadmap - How to Become a PHP Developer](https://www.youtube.com/watch?v=r9ndOH0tyfA)
* [Getting Started with PHP](https://www.codecademy.com/learn/learn-php/modules/getting-started-with-php)
* [PHP Data Types](https://www.tutorialrepublic.com/php-tutorial/php-data-types.php)
* [PHP Loops](https://www.tutorialrepublic.com/php-tutorial/php-loops.php)
* [Array basics](https://lukashajdu.com/post/mastering-php-arrays-array-basics/)
* [Working with Arrays](https://www.oreilly.com/library/view/learning-php-5/0596005601/ch04.html)
* [PHP GET and POST](https://www.tutorialrepublic.com/php-tutorial/php-get-and-post.php)
* [PHP for Beginners (2023 Edition)](https://www.youtube.com/playlist?list=PL3VM-unCzF8ipG50KDjnzhugceoSG3RTC)

### The LAMP stack

* The [LAMP](https://en.wikipedia.org/wiki/LAMP_(software_bundle)) (Linux, Apache, MySql, PHP) stack
* [Linux](https://en.wikipedia.org/wiki/Linux)
* [Apache HTTP Server](https://en.wikipedia.org/wiki/Apache_HTTP_Server)
* [MySQL](https://en.wikipedia.org/wiki/MySQL)
* [PHP](https://en.wikipedia.org/wiki/PHP)
* [What is a LAMP Stack?](https://youtu.be/tzBgFog6NmY) (Video)

### HTML / HTML 5

* [HTML](https://en.wikipedia.org/wiki/HTML) and [HTML5](https://en.wikipedia.org/wiki/HTML5)
* [HTML Tutorial](https://www.w3schools.com/html/default.asp)
* [Introduction to HTML](https://developer.mozilla.org/en-US/docs/Learn/HTML/Introduction_to_HTML)
* [A Basic HTML5 Template](https://www.sitepoint.com/a-basic-html5-template/)
* [DOM](https://developer.mozilla.org/en-US/docs/Web/API/Document_Object_Model)
* [Learn HTML](https://www.interviewbit.com/html-interview-questions/)

### CSS

* [Cascading Style Sheets](https://en.wikipedia.org/wiki/Cascading_Style_Sheets)
* [CSS Tutorial](https://www.w3schools.com/css/)
* [Introduction to CSS](https://www.csstutorial.net/css-intro/introductioncss-part1.php)
* [Introduction CSS Selectors](https://www.sitepoint.com/css-selectors/)
* [Learn CSS](https://www.interviewbit.com/css-interview-questions/)

### JavaScript

* [JavaScript](https://en.wikipedia.org/wiki/JavaScript) (aka ECMAScript)
* [Basic JavaScript](http://speakingjs.com/es5/ch01.html)
* [JavaScript Tutorial](https://www.w3schools.com/js/default.asp)
* [Eloquent JavaScript](https://eloquentjavascript.net/)
* [You Don't Know JS (book series)](https://github.com/getify/You-Dont-Know-JS)
* [Awesome JavaScript Learning](https://github.com/micromata/awesome-javascript-learning)
* [Learn JavaScript](https://www.interviewbit.com/javascript-interview-questions/)

### Protocols

* [HTTP](https://en.wikipedia.org/wiki/Hypertext_Transfer_Protocol) and [HTTPS](https://en.wikipedia.org/wiki/Hypertext_Transfer_Protocol_Secure)
* [HTTP Request / Response, GET und POST](https://www.w3schools.com/tags/ref_httpmethods.asp)
* [Introduction to HTTP Basics](https://www3.ntu.edu.sg/home/ehchua/programming/webprogramming/HTTP_Basics.html)
* [FTP](https://en.wikipedia.org/wiki/File_Transfer_Protocol)
* [SSH](https://en.wikipedia.org/wiki/Secure_Shell)
* [SMTP](https://en.wikipedia.org/wiki/Simple_Mail_Transfer_Protocol)
* [POP3](https://en.wikipedia.org/wiki/Post_Office_Protocol)
* [IMAP](https://en.wikipedia.org/wiki/Internet_Message_Access_Protocol)
* [Ajax](https://developer.mozilla.org/en-US/docs/Web/Guide/AJAX)

## Local Development Environments

* [ddev](https://github.com/ddev/ddev)
* [EasyPHP Devserver & Webserver](https://www.easyphp.org/easyphp-devserver.php)
* [Homestead](https://laravel.com/docs/master/homestead)
* [Laragon](https://laragon.org/)
* [MAMP](https://www.mamp.info/)
* [WAMPServer](https://www.wampserver.com/en/)
* [XAMPP](https://www.apachefriends.org/)
  * [XAMPP Tutorial](https://www.bollyinside.com/articles/run-php-file-in-xampp-tips-and-tutorial/)

## Tools

* [Webbrowser (Chrome, Firefox)](https://en.wikipedia.org/wiki/Webbrowser)
* [Composer](https://getcomposer.org/) (dependency management)
* [WinSCP](https://winscp.net) (Free SFTP, SCP and FTP client)
* [Putty](https://www.chiark.greenend.org.uk/~sgtatham/putty/latest.html) (A free SSH and telnet client)
* [PoEdit](https://poedit.net/) (gettext translations editor)
* [Notepad++](https://notepad-plus-plus.org/) (Text editor)
* [7-ZIP](https://www.7-zip.org/) (File archiver)

## IDEs

* [PHPStorm](https://www.jetbrains.com/phpstorm/) ($)
* [Visual Studio Code](https://code.visualstudio.com/docs/languages/php)

## Frameworks and libraries

### Frameworks

* [Laravel](https://laravel.com/) (A very popular framework)
* [Laminas](https://getlaminas.org/)
* [Symfony](https://symfony.com/) (A modular enterprise framework)

### Micro Frameworks

* [Slim Framework](https://www.slimframework.com/) (A PHP micro framework that helps you quickly write simple yet powerful web applications and APIs)
* [Slim Framework 4 - Tutorial](https://odan.github.io/2019/11/05/slim4-tutorial.html)
* [Slim Framework 4 - eBook](https://ko-fi.com/s/5f182b4b22)

### Libraries

* [Awesome PHP libraries](https://github.com/ziadoz/awesome-php)
* [Packagist](https://packagist.org/)

## Templates

* [Plates](https://platesphp.com/) (A native PHP template system)
* [Twig](https://twig.symfony.com/) (The flexible, fast, and secure template engine for PHP)
* [Twig – the Most Popular Stand-Alone PHP Template Engine](https://www.sitepoint.com/twig-popular-stand-alone-php-template-engine/)
* [Twig versus Flat PHP](https://symfony.com/doc/current/introduction/from_flat_php_to_symfony2.html)

## OOP

### Object-oriented programming

> "Write shy code - <br>
> modules that don't reveal anything unnecessary to other <br>
> modules and that don't rely on other modules' implementations."

* [Object-Oriented Principles in PHP](https://laracasts.com/series/object-oriented-principles-in-php)
* [Classes and Objects](https://secure.php.net/manual/en/language.oop5.php)
* [Mastering Object Oriented PHP](http://www.masteringobjectorientedphp.com/) (eBook)
* [Objektorientierte Programmierung](https://www.php-einfach.de/experte/objektorientierte-programmierung-oop/) (german)
* [Object-Oriented Bootcamp](https://laracasts.com/series/object-oriented-bootcamp-in-php)
* [Learning OOP in PHP](https://github.com/marcelgsantos/learning-oop-in-php)

### Design patterns

* [Design Patterns in PHP (Laracasts)](https://laracasts.com/series/design-patterns-in-php)
* [Design Patterns in PHP](https://www.script-tutorials.com/design-patterns-in-php/)
* [Gang of Four Design Patterns](https://www.amazon.com/gp/product/B000SEIBB8?ie=UTF8&tag=28031982-21&camp=1638&linkCode=xm2&creativeASIN=B000SEIBB8) (Book)
* [Design Patterns for Humans™](https://github.com/kamranahmedse/design-patterns-for-humans)
* [DesignPatternsPHP](https://designpatternsphp.readthedocs.io/)
* [Several design patterns in PHP](https://github.com/DesignPatternsPHP/DesignPatternsPHP)
* [Design Patterns in PHP Course](https://www.youtube.com/playlist?list=PLplJltxWVIbLVL3ZX3I6b_uvBsnYVaRJn) (Video)

### SOLID

> SOLID is a mnemonic acronym for five design principles intended
> to make software designs more understandable, flexible and maintainable

* [SOLID](https://en.wikipedia.org/wiki/SOLID_(object-oriented_design))
* [The First 5 Principles of Object Oriented Design](https://www.digitalocean.com/community/conceptual_articles/s-o-l-i-d-the-first-five-principles-of-object-oriented-design)

### Dependency injection

* [An Introduction to Dependency Injection](https://joebubna.github.io/Cora/documentation/v2/dependency-injection/overview/)
* [What is Dependency Injection?](http://fabien.potencier.org/what-is-dependency-injection.html)
* [The Clean Code Talks - Don't Look For Things!](https://www.youtube.com/watch?v=RlfLCWKxHJ0) (Video)
* [PSR-11: Container interface](https://www.php-fig.org/psr/psr-11/)
* [Demystifying Dependency Injection Containers by Kai Sassnowski](https://www.youtube.com/watch?v=y7EbrV4ChJs) (Video)

## Best Practices

### KISS

> Simplicity is prerequisite for reliability.<br>
> — Edsger W. Dijkstra

* [KISS - Keep it simple, stupid](https://en.wikipedia.org/wiki/KISS_principle)
* [KISS principle](https://people.apache.org/~fhanik/kiss.html)

### YAGNI

> You Ain't Gonna Need It

* [YAGNI](https://deviq.com/yagni/)
* [You Arent Gonna Need It](http://c2.com/xp/YouArentGonnaNeedIt.html)
* [KISS and YAGNI](https://blog.codinghorror.com/kiss-and-yagni/)
* [YAGNI, Cargo Cult and Overengineering](https://codeahoy.com/2017/08/19/yagni-cargo-cult-and-overengineering-the-planes-wont-land-just-because-you-built-a-runway-in-your-backyard/)

### DRY

> "DRY ‐ Don't Repeat Yourself<br>
> Every piece of knowledge must have a single, <br>
> unambiguous, authoritative representation within a system."

> DRY is about having one source of truth. It's not about frantically eradicating duplication from your codebase.

* [Don’t repeat yourself (DRY)](https://en.wikipedia.org/wiki/Don't_repeat_yourself)

### Other

* [TheCodingMachine Best Practices](http://bestpractices.thecodingmachine.com/)
* [Return early, return often](https://softwareengineering.stackexchange.com/q/18454)
* [Global Variables Are Bad](https://stackoverflow.com/a/10525602/1461181)
* [Thin controllers and fat models](https://symfony.com/doc/current/best_practices/controllers.html)
* [PHP Dos and Don’ts aka Programmers I Don’t Like](https://blog.radwell.codes/2016/11/php-dos-donts-aka-programmers-dont-like/)
* [Composition over inheritance](https://www.thoughtworks.com/pt/insights/blog/composition-vs-inheritance-how-choose)
* [Clean Code PHP](https://github.com/jupeter/clean-code-php)
* [Object Calisthenics](https://medium.com/web-engineering-vox/improving-code-quality-with-object-calisthenics-aa4ad67a61f1#.ggel1wt46)

## Model-View-Controller

Most frameworks in PHP follow some sort of MVC structure. The theory is simple:

> The user interfaces with the view,
> which passes information to a controller.
> The controller then passes that information to a model (layer),
> and the model passes information back to the controller.
> The controller effectively stands between the view and the model.
> *(Brandon James Savage)*

* [MVC Wikipedia](https://en.wikipedia.org/wiki/Model%E2%80%93view%E2%80%93controller)
* [MVC in simpler terms or the structure of a modern web-application](https://phpdelusions.net/articles/mvc)
* [MVC overview](https://www.reddit.com/r/PHP/comments/5w3k8h/getting_started_with_symfony/de72hg6/)
* [MVC for Noobs](https://code.tutsplus.com/tutorials/mvc-for-noobs--net-10488)
* [A Better Understanding Of MVC](https://www.bennadel.com/blog/2379-a-better-understanding-of-mvc-model-view-controller-thanks-to-steven-neiland.htm)
* [Thin controllers, fat models](https://stackoverflow.com/a/14045514/1461181)
* [MVC for advanced PHP developers](https://stackoverflow.com/questions/16356420/mvc-for-advanced-php-developers/16356866#16356866)
* [A Better Understanding Of MVC](https://www.bennadel.com/blog/2379-a-better-understanding-of-mvc-model-view-controller-thanks-to-steven-neiland.htm)
* [MVC model 2](https://en.wikipedia.org/wiki/JSP_model_2_architecture)
* [Action Domain Responder (ADR)](https://en.wikipedia.org/wiki/Action%E2%80%93domain%E2%80%93responder)

## Database

### Database basics

* [Database](https://en.wikipedia.org/wiki/Database)
* [Database model](https://en.wikipedia.org/wiki/Database_model)
* [Codd's 12 rules](https://en.wikipedia.org/wiki/Codd%27s_12_rules) [*](https://computing.derby.ac.uk/c/codds-twelve-rules/)
* **[The only proper PDO tutorial](https://phpdelusions.net/pdo)**
* [SQL Tutorial](https://www.w3schools.com/sql/default.asp)
* [Datenbank Grundlagen](https://www.datenbank-grundlagen.de/) (german)
* [ERM](https://en.wikipedia.org/wiki/Entity%E2%80%93relationship_model)
* [Datenbank-Grundlagen Tutorial](https://www.youtube.com/watch?v=dLXZYr-o4T4) (german)
* [Datenbank-Grundlagen Tutorial: Primärschlüssel](https://www.youtube.com/watch?v=Mpkg0RnkMkw) (german)

### Relational database management system (RDBMS)

* [MySQL](https://en.wikipedia.org/wiki/MySQL)
  * [MySQL website](https://dev.mysql.com/downloads/mysql/)
* [MariaDB](https://en.wikipedia.org/wiki/MariaDB)
  * [MariaDB website](https://mariadb.org/)
* [Microsoft SQL Server](https://en.wikipedia.org/wiki/Microsoft_SQL_Server)
* [Oracle](https://en.wikipedia.org/wiki/Oracle_Database)
* [SQLite](https://en.wikipedia.org/wiki/SQLite)

### Database books

* [Free MySQL Book](https://books.goalkicker.com/MySQLBook/)
* [High Performance MySQL: Optimization, Backups, and Replication](https://www.amazon.com/High-Performance-MySQL-Optimization-Replication/dp/1449314287/?tag=28031982-21)

### Database normalization

> Bad programmers worry about the code. Good programmers worry about data structures and their relationships.

* [Database normalization](https://en.wikipedia.org/wiki/Database_normalization)
* [First normal form (1NF)](https://en.wikipedia.org/wiki/First_normal_form)
* [Second normal form (2NF)](https://en.wikipedia.org/wiki/Second_normal_form)
* [Third normal form (3NF)](https://en.wikipedia.org/wiki/Third_normal_form)
* [Description of the database normalization basics](https://docs.microsoft.com/en-us/office/troubleshoot/access/database-normalization-description)
* [Der Königsweg: Normalisierung](https://www.hdm-stuttgart.de/~riekert/lehre/db-kelz/chap4.htm) (german)
* [Normalisierung](http://www.datenbanken-verstehen.de/datenbanken/datenmodellierung/normalisierung/) (german)
* [MySQL - Normalisierung](https://www.peterkropff.de/site/mysql/normalisierung.htm) (german)

### Prepared Statements

* [Prepared statement](https://en.wikipedia.org/wiki/Prepared_statement)
* [Prepared statements - Protection from SQL injections](https://phpdelusions.net/pdo#prepared)
* [PHP Prepared Statements](https://www.w3schools.com/php/php_mysql_prepared_statements.asp)

### Database libraries

* [CakePHP QueryBuilder](https://github.com/cakephp/database#query-builder)
* [Illuminate (Laravel) Query Builder](https://github.com/illuminate/database)
* [Laminas DB Query Builder](https://docs.laminas.dev/laminas-db/)
* [Phinx - database migrations](https://phinx.org/)

### Database tools

* [SQLyog Community Edition](https://github.com/webyog/sqlyog-community/wiki/Downloads)
* [SQLyog](https://www.webyog.com/product/sqlyog) - The most complete and easy to use MySQL GUI ($)
* [MySQL Workbench](https://www.mysql.com/products/workbench/)
* [HeidiSQL](https://www.heidisql.com/)
* [SequelPro](https://www.sequelpro.com/)
* [Navicat](https://www.navicat.com/en/products/navicat-for-mysql) ($)
* [DBeaver](https://dbeaver.io/)

### NoSQL

* [NoSQL](https://en.wikipedia.org/wiki/NoSQL)
* [Redis](https://redis.io/) (In-memory data structure store, used as a database, cache and message broker)
* [MongoDB](https://en.wikipedia.org/wiki/MongoDB) (Document-oriented database)

## Standards

Follow common PHP conventions for object-oriented code, and established industry best practices: PSR-1, PSR-12, PSR-4.

* [PHP Framework Interop Group](https://www.php-fig.org/)
* [PSR-1 Basic Coding Standard](https://www.php-fig.org/psr/psr-1/)
* [PSR-12 Coding Style Guide](https://www.php-fig.org/psr/psr-12/)
* [PSR-3 Logger Interface](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-3-logger-interface.md)
* [PSR-4 Autoloader](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-4-autoloader.md)
* [Standard PHP package skeleton](https://github.com/php-pds/skeleton)
* [A skeleton repository for League Packages](https://github.com/thephpleague/skeleton)
* [Semantic Versioning 2.0.0](https://semver.org/)
* [Keep a changelog](https://keepachangelog.com/)

## Errors and exception handling

* [Errors and Exceptions](https://www.phptherightway.com/#errors_and_exceptions)
* [Error Handling PHP Best Practices](http://bestpractices.thecodingmachine.com/php/error_handling.html)
* [Exceptions](https://secure.php.net/manual/en/language.exceptions.php)
* [Predefined Exceptions](https://secure.php.net/manual/en/reserved.exceptions.php)
* [SPL Exceptions](https://secure.php.net/manual/en/spl.exceptions.php)
* [Errors and error handling](https://secure.php.net/manual/en/pdo.error-handling.php)

## Debugging

* [Xdebug](https://xdebug.org/) (Debugger)
* [XAMPP - XDebug Setup for PHP 7](https://gist.github.com/odan/1abe76d373a9cbb15bed)
* [XAMPP - XDebug Setup for PHP 8](https://odan.github.io/2020/12/03/xampp-xdebug-setup-php8.html)

## Unit testing

> “Software testers do not make software; they only make them better.” – Anonymous

* [PHPUnit - testing framework](https://phpunit.de/)
* [Unit test, Integration Test, Smoke test, Regression Test](https://stackoverflow.com/a/520116/1461181)
* [Unit Testing, Integration Testing and Functional Testing](https://codeutopia.net/blog/2015/04/11/what-are-unit-testing-integration-testing-and-functional-testing/)
* [The Test Pyramid](https://martinfowler.com/bliki/TestPyramid.html)
* [The Way of Testivus](http://www.agitar.com/downloads/TheWayOfTestivus.pdf) (pdf)
* [Database Testing](https://phpunit.de/manual/current/en/database.html)
* [Best practices for database testing with PHPUnit](https://stackoverflow.com/a/3817970/1461181)
* [Database Tests With PHPUnit](https://qafoo.com/blog/090_database_tests_with_phpunit.html)
* [Database Fixture Setup in PHPUnit](https://qafoo.com/blog/091_database_fixture_setup_in_phpunit.html)
* [The correct way to use integration tests](https://zeroturnaround.com/rebellabs/the-correct-way-to-use-integration-tests-in-your-build-process/)
* [100% Code Coverage via automated tests in Symfony applications](https://speakerdeck.com/mensemedia/100-percent-code-coverage-via-automated-tests-in-symfony-applications)
* [Building Test-Driven Developers](https://leanpub.com/test-driven) eBook
* [Write tests. Not too many. Mostly integration](https://kentcdodds.com/blog/write-tests)
* [Unit Testing is Overrated](https://tyrrrz.me/blog/unit-testing-is-overrated)

## Documentation

> Not commenting your code when you are a programmer should be illegal - @RiaCorpeno

PHPdoc is intended for documenting your code. The intention is that you always add comments to your parameters and return types in docblocks that describe what they do. There is software that can read in your code and produce documentation in pdf or HTML format that describes all your classes and functions as well as what they do and how to use them. It is a system for inline documentation as the name indicates.

* [Introduction to PhpDoc](https://www.sitepoint.com/introduction-to-phpdoc/)
* [The PHPDoc standard (PSR-5) for comments](https://github.com/phpDocumentor/fig-standards/blob/master/proposed/phpdoc.md)
* [PHPDoc wiki](https://en.wikipedia.org/wiki/PHPDoc)
* [PHPDoc basic syntax](https://www.phpdoc.org/docs/latest/references/phpdoc/basic-syntax.html)
* [Anatomy of a DocBlock](https://phpdoc.org/docs/latest/guides/docblocks.html)
* [Your First Set of Documentation](https://phpdoc.org/docs/latest/getting-started/your-first-set-of-documentation.html)

## Sessions

* [PHP Sessions](https://www.w3schools.com/php/php_sessions.asp)
* [Session Handling](https://secure.php.net/manual/en/book.session.php)
* [Cookie](https://en.wikipedia.org/wiki/HTTP_cookie)
* [Session Management](https://symfony.com/doc/current/components/http_foundation/sessions.html)
* [PHP Sessions in Depth](https://www.phparch.com/2018/01/php-sessions-in-depth/)

## Text translations

* [Internationalization and localization](https://en.wikipedia.org/wiki/Internationalization_and_localization) (i18n)
* [Symfony: The Translation Component](https://symfony.com/doc/current/components/translation.html)
* [PoEdit](https://poedit.net/) Gettext Translations Editor

## Regular Expressions

* [Regular expression](https://en.wikipedia.org/wiki/Regular_expression)
* [PCRE Functions](https://secure.php.net/manual/en/ref.pcre.php)
* [PHP Live Regex](https://www.phpliveregex.com/) (A Live Regular Expression Tester for PHP)
* [PHPrex](https://phphub.net/regex/) (A Visual Regular Expression Tester for PHP)

## XML

* [XML](https://en.wikipedia.org/wiki/XML) (Extensible Markup Language )
* [XSD](https://en.wikipedia.org/wiki/XML_Schema_(W3C)) (XML Schema Definition)

## API

* [REST, SOAP OR GRAPHQL?](https://da-14.com/blog/ultimate-guide-api-architecture-rest-soap-or-graphql)

### RESTful API

* [REST, RESTful, REST-like API Resources](https://odan.github.io/2017/01/30/rest-restful-rest-like-api-resources.html)
* [REST, RESTful API Quick Reference](https://odan.github.io/2017/04/17/rest-restful-api-quick-reference.html)
* [API Guidelines](https://opensource.zalando.com/restful-api-guidelines/index.html#api-naming)
* [7 Rules for REST API URI Design](https://blog.restcase.com/7-rules-for-rest-api-uri-design/)

### SOAP API

* [SOAP](https://en.wikipedia.org/wiki/SOAP) (Simple Object Access Protocol)
* [The SOAP extension](https://secure.php.net/manual/en/book.soap.php) The SOAP extension can be used to write SOAP Servers and Clients.
* [Web service](https://en.wikipedia.org/wiki/Web_service)
* [WSDL](https://en.wikipedia.org/wiki/Web_Services_Description_Language) (Web Services Description Language)
* [Implementing a SOAP API with PHP ](https://odan.github.io/2017/11/20/implementing-a-soap-api-with-php-7.html)

## Version control

* [What is version control](https://www.atlassian.com/git/tutorials/what-is-version-control)
* **[Github](https://github.com)**
* [Resources to learn Git](https://try.github.io/)
* [A tutorial introduction to Git](https://git-scm.com/docs/gittutorial)
* [Git - The simple guide](https://rogerdudler.github.io/git-guide/)
* [The Pro Git book](https://git-scm.com/book/en/v2)

## Security

> A good programmer looks both ways before crossing a one-way street.

* [Web security essentials - A crash course](https://www.sohamkamani.com/blog/2017/01/16/web-security-essentials/)
* [PHP Security Cheat Sheet](https://cheatsheetseries.owasp.org/cheatsheets/PHP_Configuration_Cheat_Sheet.html)
* [PHP The Right Way - Security](https://phptherightway.com/#security)
* [XSS](https://www.sitepoint.com/php-security-cross-site-scripting-attacks-xss/)
* [The latest information about secure PHP software](https://paragonie.com/blog)
* [Security Tips for a PHP Application](https://dev.to/restoreddev/security-tips-for-a-php-application-4e9a)
* [The Ultimate PHP Security Checklist](https://www.sqreen.io/checklists/php-security-checklist)
* [PHP Security Best Practices](https://www.cloudways.com/blog/php-security/)

## Architecture

* [Uncle Bob’s "Clean Architecture"](https://www.amazon.com/gp/product/B075LRM681?tag=28031982-21) (book)
* [The Clean Architecture](https://blog.cleancoder.com/uncle-bob/2012/08/13/the-clean-architecture.html)
* [Patterns of Enterprise Application Architecture - Martin Fowler](https://www.amazon.com/gp/product/B008OHVDFM?tag=28031982-21)
* [The Onion Architecture Part 1](https://jeffreypalermo.com/2008/07/the-onion-architecture-part-1/)
* [A Journey Toward Clean Code and Enjoyment](https://youtu.be/wInd6_aMqvg) - Agility, TDD, OOP Patterns, MVC, Framework De-Coupling

## Domain Driven Design (DDD)

* [DDD for beginners](https://speakerdeck.com/akrabat/ddd-for-beginners)
* [Domain-Driven Design: Tackling Complexity in the Heart of Software](https://www.amazon.com/gp/product/0321125215/ref=as_li_tl?ie=UTF8&tag=28031982-21) (The Blue Book)
* [Implementing Domain-Driven Design](https://www.amazon.com/gp/product/0321834577?tag=28031982-21) (The Red Book)
* [Design a DDD-oriented microservice](https://docs.microsoft.com/en-us/dotnet/architecture/microservices/microservice-ddd-cqrs-patterns/ddd-oriented-microservice)
* [Domain-Driven	Design Reference](https://amzn.to/2Xq4eEH) (A summary of the patterns and definitions of DDD, [PDF](https://domainlanguage.com/wp-content/uploads/2016/05/DDD_Reference_2015-03.pdf))
* [Services in Domain-Driven Design](http://gorodinski.com/blog/2012/04/14/services-in-domain-driven-design-ddd/)
* [Creating services you won’t hate](https://www.brandonsavage.net/creating-services-you-wont-hate/)
* [Domain-Driven Design](https://amzn.to/3cNq2jV) (The blue DDD book)
* [Implementing Domain-Driven Design](https://amzn.to/2zrGrMm) (The red DDD book)

## Hexagonal Architecture

* [Ports & Adapters Architecture](https://herbertograca.com/2017/09/14/ports-adapters-architecture/)
* [Hexagonal Architecture demystified](https://madewithlove.com/blog/software-engineering/hexagonal-architecture-demystified/)
* [Hexagonal Architecture](https://fideloper.com/hexagonal-architecture)
* [Alistair in the "Hexagone"](https://www.youtube.com/watch?v=th4AgBcrEHA)
* [Object Design Style Guide](https://www.manning.com/books/object-design-style-guide)
* [Advanced Web Application Architecture](https://leanpub.com/web-application-architecture)

## Functional Programming

* [Functional architecture - The pits of success - Mark Seemann](https://www.youtube.com/watch?v=US8QG9I1XW0) (Video)

## Continuous integration (CI) and Continuous Delivery (CD)

* [Continuous Delivery](https://www.amazon.com/gp/product/B003YMNVC0/?tag=28031982-21) (Book)
* [Continuously delivering PHP projects](https://www.youtube.com/watch?v=HOwPJg-F4h0) (Video)
* [Continuous Integration vs. Continuous Delivery vs. Continuous Deployment](https://stackoverflow.com/a/28628086/1461181)
* [What’s Continuous Deployment?](https://www.sitepoint.com/whats-continuous-deployment/)
* [PHP and Continuous Integration with Travis CI](https://www.sitepoint.com/php-continuous-integration-travis-ci/)
* [Docker for PHP Developers](https://leanpub.com/dockerfordevs)

## Magazines

* [php architect](https://www.phparch.com/magazine/) (english)
* [PHPmagazin](https://entwickler.de/php-magazin) (german)
* [web & mobile developer](https://shop.nmg.de/webundmobile/) (german)

## Merchandise

* [The Official elephpant Shop - Boutique elePHPant](https://www.vincentpontier.com/elephpant/)
* [PHPUnit Merchandise](https://phpunit.de/merchandise.html)
* [PHP Stickers](https://www.redbubble.com/de/shop/php)

## Community / News

* [@official_php](https://twitter.com/official_php)
* [r/PHP](https://www.reddit.com/r/PHP/)
* [r/PHPhelp](https://www.reddit.com/r/PHPhelp/)
* [PHP on dev.to](https://dev.to/t/php)
* [Hashnode/php](https://hashnode.com/n/php)  
* [Stack Overflow](https://stackoverflow.com/questions/tagged/php)
* [PHP weekly newsletter](http://www.phpweekly.com/)
* [Freek.dev newsletter](https://freek.dev/newsletter)
* [Stitcher Mail](https://stitcher.io/signup)
* [Awesome PHP Newsletter](https://php.libhunt.com/newsletter)
* [JetBrains - PHP Annotated Monthly](https://blog.jetbrains.com/phpstorm/category/php-annotated-monthly/)
* [PHP's internals](https://externals.io/)
* [PHP-Digest by Roman Pronsky](https://habr.com/ru/users/pronskiy/posts/) (russian)
* [List of PHP blogs](https://github.com/simon-schubert/devpunk)
* [PHP Conferences around the world](https://www.php.net/conferences/index.php)
* [PHP chatroom on StackOverflow](https://chat.stackoverflow.com/rooms/11/php)
* [When is the Next PHP Meetup?](https://friendsofphp.org/)
