import "./Navbar.css";
import { Link } from "react-router-dom";
import { useSelector } from 'react-redux';


const Navbar = ({ click }) => {

  const cart = useSelector ((state) => state.cart);
  const {cartItems} = cart;

  const getCartCount = () => {
    return cartItems.reduce((qty, item) => qty + Number(item.qty), 0);//each item qty added to cartCount and return
  };
  
  
  return (
    <nav className="navbar">
      <div className="icon">
      <div className="rotator">
      <Link to="/">
  <img src="https://raw.githubusercontent.com/nxdun/BlaBla/main/2.png"
          alt="logo"
          className="header-img"/>
          </Link>
      </div>
      </div>

      <ul className="navbar__links">
        <li>
          <Link to="/cart" className="cart__link">
            <i className="fas fa-shopping-cart"></i>
            <span>
              Cart <span className="cartlogo__badge">{getCartCount()}</span>
            </span>
          </Link>
        </li>
        <li className="shopnav">
          <Link to="/shop">Shop</Link>
        </li>
      </ul>

      <div className="hamburger__menu" onClick={click}>
        <div></div>
        <div></div>
        <div></div>
      </div>
    </nav>
  );
};

export default Navbar;
