---
title: "Problem Solving Techniques"
date: "2023-01-18T15:18:34+07:00"
tags: ["algorithm", "techniques"]
draft: false
comment: true
---

<div align="center">
    <iframe src="https://giphy.com/embed/777Aby0ZetYE8" width="480" height="259" frameBorder="0" class="giphy-embed" allowFullScreen></iframe><p><a href="https://giphy.com/gifs/cute-think-pooh-777Aby0ZetYE8">via GIPHY</a></p>
    <p>Haven't thought of anything, have you? No, neither have I. Think, think, think</p>
</div>

## The Feynman Algorithm

The [Feynman algorithm](http://wiki.c2.com/?FeynmanAlgorithm) was facetiously suggested by [Murray Gell-Mann](http://en.wikipedia.org/wiki/Murray_Gell-Mann), a colleague of [Richard Feynman](https://en.wikipedia.org/wiki/Richard_Feynman), in a New York Times interview.

It is the combination of three steps:

```
1. Write down the problem.
2. Think real hard.
3. Write down the solution.
```

## Polya's Principles

```
If you can't solve a problem, then there is an easier problem you can
solve: find it.

-- George Poyla --
```

George Polya described in his 1957 book [How to Solve It](https://en.wikipedia.org/wiki/How_to_Solve_It) (HowToSolveIt) a set of heuristics for solving problems. A basic outline of his approach is pretty similar to Feynman's Algorithm:

```
1. First, you have to understand the problem.
2. After understanding, make a plan.
3. Carry out the plan.
4. Look back on your work. How could it be better?
```
