# Orientation

This chapter will explain at a high level what's Frida, what's Radare2, and 
provide pointers and links to learn more about both tools

## Radare

Radare is a portable reversing framework that can...

- Disassemble (and assemble for) many different architectures
- Debug with local native and remote debuggers (gdb, rap, webui, r2pipe, winedbg, windbg)
- Run on Linux, \*BSD, Windows, OSX, Android, iOS, Solaris and Haiku
- Perform forensics on file systems and data carving
- Be scripted in Python, JavaScript, Go and more
- Support collaborative analysis using the embedded webserver
- Visualize data structures of several file types
- Patch programs to uncover new features or fix vulnerabilities
- Use powerful analysis capabilities to speed up reversing
- Aid in software exploitation

## Frida

Inject JavaScript to explore native apps on Windows, macOS, Linux, iOS,
Android, and QNX.


Your own scripts get injected into black box processes to execute custom
debugging logic. Hook any function, spy on crypto APIs or trace private
application code, no source code needed! Stealthy code tracing without relying
on software or hardware breakpoints. Think DTrace in user-space, based on
dynamic recompilation, like DynamoRIO and PIN.

## r2frida

Radare2 and Frida better together.

