#pragma once
#include <Zydis/Register.h>
#include <Zydis/Mnemonic.h>

namespace eagle::codec
{
    // sorry about all this

    using zydis_register_width = ZydisRegisterWidth;

    using zydis_register = ZydisRegister;

    enum reg
    {
        none = ZYDIS_REGISTER_NONE,
        al = ZYDIS_REGISTER_AL,
        cl = ZYDIS_REGISTER_CL,
        dl = ZYDIS_REGISTER_DL,
        bl = ZYDIS_REGISTER_BL,
        ah = ZYDIS_REGISTER_AH,
        ch = ZYDIS_REGISTER_CH,
        dh = ZYDIS_REGISTER_DH,
        bh = ZYDIS_REGISTER_BH,
        spl = ZYDIS_REGISTER_SPL,
        bpl = ZYDIS_REGISTER_BPL,
        sil = ZYDIS_REGISTER_SIL,
        dil = ZYDIS_REGISTER_DIL,
        r8b = ZYDIS_REGISTER_R8B,
        r9b = ZYDIS_REGISTER_R9B,
        r10b = ZYDIS_REGISTER_R10B,
        r11b = ZYDIS_REGISTER_R11B,
        r12b = ZYDIS_REGISTER_R12B,
        r13b = ZYDIS_REGISTER_R13B,
        r14b = ZYDIS_REGISTER_R14B,
        r15b = ZYDIS_REGISTER_R15B,

        ax = ZYDIS_REGISTER_AX,
        cx = ZYDIS_REGISTER_CX,
        dx = ZYDIS_REGISTER_DX,
        bx = ZYDIS_REGISTER_BX,
        sp = ZYDIS_REGISTER_SP,
        bp = ZYDIS_REGISTER_BP,
        si = ZYDIS_REGISTER_SI,
        di = ZYDIS_REGISTER_DI,
        r8w = ZYDIS_REGISTER_R8W,
        r9w = ZYDIS_REGISTER_R9W,
        r10w = ZYDIS_REGISTER_R10W,
        r11w = ZYDIS_REGISTER_R11W,
        r12w = ZYDIS_REGISTER_R12W,
        r13w = ZYDIS_REGISTER_R13W,
        r14w = ZYDIS_REGISTER_R14W,
        r15w = ZYDIS_REGISTER_R15W,

        eax = ZYDIS_REGISTER_EAX,
        ecx = ZYDIS_REGISTER_ECX,
        edx = ZYDIS_REGISTER_EDX,
        ebx = ZYDIS_REGISTER_EBX,
        esp = ZYDIS_REGISTER_ESP,
        ebp = ZYDIS_REGISTER_EBP,
        esi = ZYDIS_REGISTER_ESI,
        edi = ZYDIS_REGISTER_EDI,
        r8d = ZYDIS_REGISTER_R8D,
        r9d = ZYDIS_REGISTER_R9D,
        r10d = ZYDIS_REGISTER_R10D,
        r11d = ZYDIS_REGISTER_R11D,
        r12d = ZYDIS_REGISTER_R12D,
        r13d = ZYDIS_REGISTER_R13D,
        r14d = ZYDIS_REGISTER_R14D,
        r15d = ZYDIS_REGISTER_R15D,

        rax = ZYDIS_REGISTER_RAX,
        rcx = ZYDIS_REGISTER_RCX,
        rdx = ZYDIS_REGISTER_RDX,
        rbx = ZYDIS_REGISTER_RBX,
        rsp = ZYDIS_REGISTER_RSP,
        rbp = ZYDIS_REGISTER_RBP,
        rsi = ZYDIS_REGISTER_RSI,
        rdi = ZYDIS_REGISTER_RDI,
        r8 = ZYDIS_REGISTER_R8,
        r9 = ZYDIS_REGISTER_R9,
        r10 = ZYDIS_REGISTER_R10,
        r11 = ZYDIS_REGISTER_R11,
        r12 = ZYDIS_REGISTER_R12,
        r13 = ZYDIS_REGISTER_R13,
        r14 = ZYDIS_REGISTER_R14,
        r15 = ZYDIS_REGISTER_R15,
        st0 = ZYDIS_REGISTER_ST0,
        st1 = ZYDIS_REGISTER_ST1,
        st2 = ZYDIS_REGISTER_ST2,
        st3 = ZYDIS_REGISTER_ST3,
        st4 = ZYDIS_REGISTER_ST4,
        st5 = ZYDIS_REGISTER_ST5,
        st6 = ZYDIS_REGISTER_ST6,
        st7 = ZYDIS_REGISTER_ST7,

        x87control = ZYDIS_REGISTER_X87CONTROL,
        x87status = ZYDIS_REGISTER_X87STATUS,
        x87tag = ZYDIS_REGISTER_X87TAG,

        mm0 = ZYDIS_REGISTER_MM0,
        mm1 = ZYDIS_REGISTER_MM1,
        mm2 = ZYDIS_REGISTER_MM2,
        mm3 = ZYDIS_REGISTER_MM3,
        mm4 = ZYDIS_REGISTER_MM4,
        mm5 = ZYDIS_REGISTER_MM5,
        mm6 = ZYDIS_REGISTER_MM6,
        mm7 = ZYDIS_REGISTER_MM7,

        xmm0 = ZYDIS_REGISTER_XMM0,
        xmm1 = ZYDIS_REGISTER_XMM1,
        xmm2 = ZYDIS_REGISTER_XMM2,
        xmm3 = ZYDIS_REGISTER_XMM3,
        xmm4 = ZYDIS_REGISTER_XMM4,
        xmm5 = ZYDIS_REGISTER_XMM5,
        xmm6 = ZYDIS_REGISTER_XMM6,
        xmm7 = ZYDIS_REGISTER_XMM7,
        xmm8 = ZYDIS_REGISTER_XMM8,
        xmm9 = ZYDIS_REGISTER_XMM9,
        xmm10 = ZYDIS_REGISTER_XMM10,
        xmm11 = ZYDIS_REGISTER_XMM11,
        xmm12 = ZYDIS_REGISTER_XMM12,
        xmm13 = ZYDIS_REGISTER_XMM13,
        xmm14 = ZYDIS_REGISTER_XMM14,
        xmm15 = ZYDIS_REGISTER_XMM15,
        xmm16 = ZYDIS_REGISTER_XMM16,
        xmm17 = ZYDIS_REGISTER_XMM17,
        xmm18 = ZYDIS_REGISTER_XMM18,
        xmm19 = ZYDIS_REGISTER_XMM19,
        xmm20 = ZYDIS_REGISTER_XMM20,
        xmm21 = ZYDIS_REGISTER_XMM21,
        xmm22 = ZYDIS_REGISTER_XMM22,
        xmm23 = ZYDIS_REGISTER_XMM23,
        xmm24 = ZYDIS_REGISTER_XMM24,
        xmm25 = ZYDIS_REGISTER_XMM25,
        xmm26 = ZYDIS_REGISTER_XMM26,
        xmm27 = ZYDIS_REGISTER_XMM27,
        xmm28 = ZYDIS_REGISTER_XMM28,
        xmm29 = ZYDIS_REGISTER_XMM29,
        xmm30 = ZYDIS_REGISTER_XMM30,
        xmm31 = ZYDIS_REGISTER_XMM31,

        ymm0 = ZYDIS_REGISTER_YMM0,
        ymm1 = ZYDIS_REGISTER_YMM1,
        ymm2 = ZYDIS_REGISTER_YMM2,
        ymm3 = ZYDIS_REGISTER_YMM3,
        ymm4 = ZYDIS_REGISTER_YMM4,
        ymm5 = ZYDIS_REGISTER_YMM5,
        ymm6 = ZYDIS_REGISTER_YMM6,
        ymm7 = ZYDIS_REGISTER_YMM7,
        ymm8 = ZYDIS_REGISTER_YMM8,
        ymm9 = ZYDIS_REGISTER_YMM9,
        ymm10 = ZYDIS_REGISTER_YMM10,
        ymm11 = ZYDIS_REGISTER_YMM11,
        ymm12 = ZYDIS_REGISTER_YMM12,
        ymm13 = ZYDIS_REGISTER_YMM13,
        ymm14 = ZYDIS_REGISTER_YMM14,
        ymm15 = ZYDIS_REGISTER_YMM15,
        ymm16 = ZYDIS_REGISTER_YMM16,
        ymm17 = ZYDIS_REGISTER_YMM17,
        ymm18 = ZYDIS_REGISTER_YMM18,
        ymm19 = ZYDIS_REGISTER_YMM19,
        ymm20 = ZYDIS_REGISTER_YMM20,
        ymm21 = ZYDIS_REGISTER_YMM21,
        ymm22 = ZYDIS_REGISTER_YMM22,
        ymm23 = ZYDIS_REGISTER_YMM23,
        ymm24 = ZYDIS_REGISTER_YMM24,
        ymm25 = ZYDIS_REGISTER_YMM25,
        ymm26 = ZYDIS_REGISTER_YMM26,
        ymm27 = ZYDIS_REGISTER_YMM27,
        ymm28 = ZYDIS_REGISTER_YMM28,
        ymm29 = ZYDIS_REGISTER_YMM29,
        ymm30 = ZYDIS_REGISTER_YMM30,
        ymm31 = ZYDIS_REGISTER_YMM31,

        zmm0 = ZYDIS_REGISTER_ZMM0,
        zmm1 = ZYDIS_REGISTER_ZMM1,
        zmm2 = ZYDIS_REGISTER_ZMM2,
        zmm3 = ZYDIS_REGISTER_ZMM3,
        zmm4 = ZYDIS_REGISTER_ZMM4,
        zmm5 = ZYDIS_REGISTER_ZMM5,
        zmm6 = ZYDIS_REGISTER_ZMM6,
        zmm7 = ZYDIS_REGISTER_ZMM7,
        zmm8 = ZYDIS_REGISTER_ZMM8,
        zmm9 = ZYDIS_REGISTER_ZMM9,
        zmm10 = ZYDIS_REGISTER_ZMM10,
        zmm11 = ZYDIS_REGISTER_ZMM11,
        zmm12 = ZYDIS_REGISTER_ZMM12,
        zmm13 = ZYDIS_REGISTER_ZMM13,
        zmm14 = ZYDIS_REGISTER_ZMM14,
        zmm15 = ZYDIS_REGISTER_ZMM15,
        zmm16 = ZYDIS_REGISTER_ZMM16,
        zmm17 = ZYDIS_REGISTER_ZMM17,
        zmm18 = ZYDIS_REGISTER_ZMM18,
        zmm19 = ZYDIS_REGISTER_ZMM19,
        zmm20 = ZYDIS_REGISTER_ZMM20,
        zmm21 = ZYDIS_REGISTER_ZMM21,
        zmm22 = ZYDIS_REGISTER_ZMM22,
        zmm23 = ZYDIS_REGISTER_ZMM23,
        zmm24 = ZYDIS_REGISTER_ZMM24,
        zmm25 = ZYDIS_REGISTER_ZMM25,
        zmm26 = ZYDIS_REGISTER_ZMM26,
        zmm27 = ZYDIS_REGISTER_ZMM27,
        zmm28 = ZYDIS_REGISTER_ZMM28,
        zmm29 = ZYDIS_REGISTER_ZMM29,
        zmm30 = ZYDIS_REGISTER_ZMM30,
        zmm31 = ZYDIS_REGISTER_ZMM31,

        ip = ZYDIS_REGISTER_IP,
        eip = ZYDIS_REGISTER_EIP,
        rip = ZYDIS_REGISTER_RIP,

        es = ZYDIS_REGISTER_ES,
        cs = ZYDIS_REGISTER_CS,
        ss = ZYDIS_REGISTER_SS,
        ds = ZYDIS_REGISTER_DS,
        fs = ZYDIS_REGISTER_FS,
        gs = ZYDIS_REGISTER_GS,

        flags = ZYDIS_REGISTER_FLAGS,
        eflags = ZYDIS_REGISTER_EFLAGS,
        rflags = ZYDIS_REGISTER_RFLAGS,
    };

    using zyids_mnemonic = ZydisMnemonic;

    enum mnemonic
    {
        m_invalid = ZYDIS_MNEMONIC_INVALID,
        m_aaa = ZYDIS_MNEMONIC_AAA,
        m_aad = ZYDIS_MNEMONIC_AAD,
        m_aadd = ZYDIS_MNEMONIC_AADD,
        m_aam = ZYDIS_MNEMONIC_AAM,
        m_aand = ZYDIS_MNEMONIC_AAND,
        m_aas = ZYDIS_MNEMONIC_AAS,
        m_adc = ZYDIS_MNEMONIC_ADC,
        m_adcx = ZYDIS_MNEMONIC_ADCX,
        m_add = ZYDIS_MNEMONIC_ADD,
        m_addpd = ZYDIS_MNEMONIC_ADDPD,
        m_addps = ZYDIS_MNEMONIC_ADDPS,
        m_addsd = ZYDIS_MNEMONIC_ADDSD,
        m_addss = ZYDIS_MNEMONIC_ADDSS,
        m_addsubpd = ZYDIS_MNEMONIC_ADDSUBPD,
        m_addsubps = ZYDIS_MNEMONIC_ADDSUBPS,
        m_adox = ZYDIS_MNEMONIC_ADOX,
        m_aesdec = ZYDIS_MNEMONIC_AESDEC,
        m_aesdec128kl = ZYDIS_MNEMONIC_AESDEC128KL,
        m_aesdec256kl = ZYDIS_MNEMONIC_AESDEC256KL,
        m_aesdeclast = ZYDIS_MNEMONIC_AESDECLAST,
        m_aesdecwide128kl = ZYDIS_MNEMONIC_AESDECWIDE128KL,
        m_aesdecwide256kl = ZYDIS_MNEMONIC_AESDECWIDE256KL,
        m_aesenc = ZYDIS_MNEMONIC_AESENC,
        m_aesenc128kl = ZYDIS_MNEMONIC_AESENC128KL,
        m_aesenc256kl = ZYDIS_MNEMONIC_AESENC256KL,
        m_aesenclast = ZYDIS_MNEMONIC_AESENCLAST,
        m_aesencwide128kl = ZYDIS_MNEMONIC_AESENCWIDE128KL,
        m_aesencwide256kl = ZYDIS_MNEMONIC_AESENCWIDE256KL,
        m_aesimc = ZYDIS_MNEMONIC_AESIMC,
        m_aeskeygenassist = ZYDIS_MNEMONIC_AESKEYGENASSIST,
        m_and = ZYDIS_MNEMONIC_AND,
        m_andn = ZYDIS_MNEMONIC_ANDN,
        m_andnpd = ZYDIS_MNEMONIC_ANDNPD,
        m_andnps = ZYDIS_MNEMONIC_ANDNPS,
        m_andpd = ZYDIS_MNEMONIC_ANDPD,
        m_andps = ZYDIS_MNEMONIC_ANDPS,
        m_aor = ZYDIS_MNEMONIC_AOR,
        m_arpl = ZYDIS_MNEMONIC_ARPL,
        m_axor = ZYDIS_MNEMONIC_AXOR,
        m_bextr = ZYDIS_MNEMONIC_BEXTR,
        m_blcfill = ZYDIS_MNEMONIC_BLCFILL,
        m_blci = ZYDIS_MNEMONIC_BLCI,
        m_blcic = ZYDIS_MNEMONIC_BLCIC,
        m_blcmsk = ZYDIS_MNEMONIC_BLCMSK,
        m_blcs = ZYDIS_MNEMONIC_BLCS,
        m_blendpd = ZYDIS_MNEMONIC_BLENDPD,
        m_blendps = ZYDIS_MNEMONIC_BLENDPS,
        m_blendvpd = ZYDIS_MNEMONIC_BLENDVPD,
        m_blendvps = ZYDIS_MNEMONIC_BLENDVPS,
        m_blsfill = ZYDIS_MNEMONIC_BLSFILL,
        m_blsi = ZYDIS_MNEMONIC_BLSI,
        m_blsic = ZYDIS_MNEMONIC_BLSIC,
        m_blsmsk = ZYDIS_MNEMONIC_BLSMSK,
        m_blsr = ZYDIS_MNEMONIC_BLSR,
        m_bndcl = ZYDIS_MNEMONIC_BNDCL,
        m_bndcn = ZYDIS_MNEMONIC_BNDCN,
        m_bndcu = ZYDIS_MNEMONIC_BNDCU,
        m_bndldx = ZYDIS_MNEMONIC_BNDLDX,
        m_bndmk = ZYDIS_MNEMONIC_BNDMK,
        m_bndmov = ZYDIS_MNEMONIC_BNDMOV,
        m_bndstx = ZYDIS_MNEMONIC_BNDSTX,
        m_bound = ZYDIS_MNEMONIC_BOUND,
        m_bsf = ZYDIS_MNEMONIC_BSF,
        m_bsr = ZYDIS_MNEMONIC_BSR,
        m_bswap = ZYDIS_MNEMONIC_BSWAP,
        m_bt = ZYDIS_MNEMONIC_BT,
        m_btc = ZYDIS_MNEMONIC_BTC,
        m_btr = ZYDIS_MNEMONIC_BTR,
        m_bts = ZYDIS_MNEMONIC_BTS,
        m_bzhi = ZYDIS_MNEMONIC_BZHI,
        m_call = ZYDIS_MNEMONIC_CALL,
        m_cbw = ZYDIS_MNEMONIC_CBW,
        m_cdq = ZYDIS_MNEMONIC_CDQ,
        m_cdqe = ZYDIS_MNEMONIC_CDQE,
        m_clac = ZYDIS_MNEMONIC_CLAC,
        m_clc = ZYDIS_MNEMONIC_CLC,
        m_cld = ZYDIS_MNEMONIC_CLD,
        m_cldemote = ZYDIS_MNEMONIC_CLDEMOTE,
        m_clevict0 = ZYDIS_MNEMONIC_CLEVICT0,
        m_clevict1 = ZYDIS_MNEMONIC_CLEVICT1,
        m_clflush = ZYDIS_MNEMONIC_CLFLUSH,
        m_clflushopt = ZYDIS_MNEMONIC_CLFLUSHOPT,
        m_clgi = ZYDIS_MNEMONIC_CLGI,
        m_cli = ZYDIS_MNEMONIC_CLI,
        m_clrssbsy = ZYDIS_MNEMONIC_CLRSSBSY,
        m_clts = ZYDIS_MNEMONIC_CLTS,
        m_clui = ZYDIS_MNEMONIC_CLUI,
        m_clwb = ZYDIS_MNEMONIC_CLWB,
        m_clzero = ZYDIS_MNEMONIC_CLZERO,
        m_cmc = ZYDIS_MNEMONIC_CMC,
        m_cmovb = ZYDIS_MNEMONIC_CMOVB,
        m_cmovbe = ZYDIS_MNEMONIC_CMOVBE,
        m_cmovl = ZYDIS_MNEMONIC_CMOVL,
        m_cmovle = ZYDIS_MNEMONIC_CMOVLE,
        m_cmovnb = ZYDIS_MNEMONIC_CMOVNB,
        m_cmovnbe = ZYDIS_MNEMONIC_CMOVNBE,
        m_cmovnl = ZYDIS_MNEMONIC_CMOVNL,
        m_cmovnle = ZYDIS_MNEMONIC_CMOVNLE,
        m_cmovno = ZYDIS_MNEMONIC_CMOVNO,
        m_cmovnp = ZYDIS_MNEMONIC_CMOVNP,
        m_cmovns = ZYDIS_MNEMONIC_CMOVNS,
        m_cmovnz = ZYDIS_MNEMONIC_CMOVNZ,
        m_cmovo = ZYDIS_MNEMONIC_CMOVO,
        m_cmovp = ZYDIS_MNEMONIC_CMOVP,
        m_cmovs = ZYDIS_MNEMONIC_CMOVS,
        m_cmovz = ZYDIS_MNEMONIC_CMOVZ,
        m_cmp = ZYDIS_MNEMONIC_CMP,
        m_cmppd = ZYDIS_MNEMONIC_CMPPD,
        m_cmpps = ZYDIS_MNEMONIC_CMPPS,
        m_cmpsb = ZYDIS_MNEMONIC_CMPSB,
        m_cmpsd = ZYDIS_MNEMONIC_CMPSD,
        m_cmpsq = ZYDIS_MNEMONIC_CMPSQ,
        m_cmpss = ZYDIS_MNEMONIC_CMPSS,
        m_cmpsw = ZYDIS_MNEMONIC_CMPSW,
        m_cmpxchg = ZYDIS_MNEMONIC_CMPXCHG,
        m_cmpxchg16b = ZYDIS_MNEMONIC_CMPXCHG16B,
        m_cmpxchg8b = ZYDIS_MNEMONIC_CMPXCHG8B,
        m_comisd = ZYDIS_MNEMONIC_COMISD,
        m_comiss = ZYDIS_MNEMONIC_COMISS,
        m_cpuid = ZYDIS_MNEMONIC_CPUID,
        m_cqo = ZYDIS_MNEMONIC_CQO,
        m_crc32 = ZYDIS_MNEMONIC_CRC32,
        m_cvtdq2pd = ZYDIS_MNEMONIC_CVTDQ2PD,
        m_cvtdq2ps = ZYDIS_MNEMONIC_CVTDQ2PS,
        m_cvtpd2dq = ZYDIS_MNEMONIC_CVTPD2DQ,
        m_cvtpd2pi = ZYDIS_MNEMONIC_CVTPD2PI,
        m_cvtpd2ps = ZYDIS_MNEMONIC_CVTPD2PS,
        m_cvtpi2pd = ZYDIS_MNEMONIC_CVTPI2PD,
        m_cvtpi2ps = ZYDIS_MNEMONIC_CVTPI2PS,
        m_cvtps2dq = ZYDIS_MNEMONIC_CVTPS2DQ,
        m_cvtps2pd = ZYDIS_MNEMONIC_CVTPS2PD,
        m_cvtps2pi = ZYDIS_MNEMONIC_CVTPS2PI,
        m_cvtsd2si = ZYDIS_MNEMONIC_CVTSD2SI,
        m_cvtsd2ss = ZYDIS_MNEMONIC_CVTSD2SS,
        m_cvtsi2sd = ZYDIS_MNEMONIC_CVTSI2SD,
        m_cvtsi2ss = ZYDIS_MNEMONIC_CVTSI2SS,
        m_cvtss2sd = ZYDIS_MNEMONIC_CVTSS2SD,
        m_cvtss2si = ZYDIS_MNEMONIC_CVTSS2SI,
        m_cvttpd2dq = ZYDIS_MNEMONIC_CVTTPD2DQ,
        m_cvttpd2pi = ZYDIS_MNEMONIC_CVTTPD2PI,
        m_cvttps2dq = ZYDIS_MNEMONIC_CVTTPS2DQ,
        m_cvttps2pi = ZYDIS_MNEMONIC_CVTTPS2PI,
        m_cvttsd2si = ZYDIS_MNEMONIC_CVTTSD2SI,
        m_cvttss2si = ZYDIS_MNEMONIC_CVTTSS2SI,
        m_cwd = ZYDIS_MNEMONIC_CWD,
        m_cwde = ZYDIS_MNEMONIC_CWDE,
        m_daa = ZYDIS_MNEMONIC_DAA,
        m_das = ZYDIS_MNEMONIC_DAS,
        m_dec = ZYDIS_MNEMONIC_DEC,
        m_delay = ZYDIS_MNEMONIC_DELAY,
        m_div = ZYDIS_MNEMONIC_DIV,
        m_divpd = ZYDIS_MNEMONIC_DIVPD,
        m_divps = ZYDIS_MNEMONIC_DIVPS,
        m_divsd = ZYDIS_MNEMONIC_DIVSD,
        m_divss = ZYDIS_MNEMONIC_DIVSS,
        m_dppd = ZYDIS_MNEMONIC_DPPD,
        m_dpps = ZYDIS_MNEMONIC_DPPS,
        m_emms = ZYDIS_MNEMONIC_EMMS,
        m_encls = ZYDIS_MNEMONIC_ENCLS,
        m_enclu = ZYDIS_MNEMONIC_ENCLU,
        m_enclv = ZYDIS_MNEMONIC_ENCLV,
        m_encodekey128 = ZYDIS_MNEMONIC_ENCODEKEY128,
        m_encodekey256 = ZYDIS_MNEMONIC_ENCODEKEY256,
        m_endbr32 = ZYDIS_MNEMONIC_ENDBR32,
        m_endbr64 = ZYDIS_MNEMONIC_ENDBR64,
        m_enqcmd = ZYDIS_MNEMONIC_ENQCMD,
        m_enqcmds = ZYDIS_MNEMONIC_ENQCMDS,
        m_enter = ZYDIS_MNEMONIC_ENTER,
        m_extractps = ZYDIS_MNEMONIC_EXTRACTPS,
        m_extrq = ZYDIS_MNEMONIC_EXTRQ,
        m_f2xm1 = ZYDIS_MNEMONIC_F2XM1,
        m_fabs = ZYDIS_MNEMONIC_FABS,
        m_fadd = ZYDIS_MNEMONIC_FADD,
        m_faddp = ZYDIS_MNEMONIC_FADDP,
        m_fbld = ZYDIS_MNEMONIC_FBLD,
        m_fbstp = ZYDIS_MNEMONIC_FBSTP,
        m_fchs = ZYDIS_MNEMONIC_FCHS,
        m_fcmovb = ZYDIS_MNEMONIC_FCMOVB,
        m_fcmovbe = ZYDIS_MNEMONIC_FCMOVBE,
        m_fcmove = ZYDIS_MNEMONIC_FCMOVE,
        m_fcmovnb = ZYDIS_MNEMONIC_FCMOVNB,
        m_fcmovnbe = ZYDIS_MNEMONIC_FCMOVNBE,
        m_fcmovne = ZYDIS_MNEMONIC_FCMOVNE,
        m_fcmovnu = ZYDIS_MNEMONIC_FCMOVNU,
        m_fcmovu = ZYDIS_MNEMONIC_FCMOVU,
        m_fcom = ZYDIS_MNEMONIC_FCOM,
        m_fcomi = ZYDIS_MNEMONIC_FCOMI,
        m_fcomip = ZYDIS_MNEMONIC_FCOMIP,
        m_fcomp = ZYDIS_MNEMONIC_FCOMP,
        m_fcompp = ZYDIS_MNEMONIC_FCOMPP,
        m_fcos = ZYDIS_MNEMONIC_FCOS,
        m_fdecstp = ZYDIS_MNEMONIC_FDECSTP,
        m_fdisi8087_nop = ZYDIS_MNEMONIC_FDISI8087_NOP,
        m_fdiv = ZYDIS_MNEMONIC_FDIV,
        m_fdivp = ZYDIS_MNEMONIC_FDIVP,
        m_fdivr = ZYDIS_MNEMONIC_FDIVR,
        m_fdivrp = ZYDIS_MNEMONIC_FDIVRP,
        m_femms = ZYDIS_MNEMONIC_FEMMS,
        m_feni8087_nop = ZYDIS_MNEMONIC_FENI8087_NOP,
        m_ffree = ZYDIS_MNEMONIC_FFREE,
        m_ffreep = ZYDIS_MNEMONIC_FFREEP,
        m_fiadd = ZYDIS_MNEMONIC_FIADD,
        m_ficom = ZYDIS_MNEMONIC_FICOM,
        m_ficomp = ZYDIS_MNEMONIC_FICOMP,
        m_fidiv = ZYDIS_MNEMONIC_FIDIV,
        m_fidivr = ZYDIS_MNEMONIC_FIDIVR,
        m_fild = ZYDIS_MNEMONIC_FILD,
        m_fimul = ZYDIS_MNEMONIC_FIMUL,
        m_fincstp = ZYDIS_MNEMONIC_FINCSTP,
        m_fist = ZYDIS_MNEMONIC_FIST,
        m_fistp = ZYDIS_MNEMONIC_FISTP,
        m_fisttp = ZYDIS_MNEMONIC_FISTTP,
        m_fisub = ZYDIS_MNEMONIC_FISUB,
        m_fisubr = ZYDIS_MNEMONIC_FISUBR,
        m_fld = ZYDIS_MNEMONIC_FLD,
        m_fld1 = ZYDIS_MNEMONIC_FLD1,
        m_fldcw = ZYDIS_MNEMONIC_FLDCW,
        m_fldenv = ZYDIS_MNEMONIC_FLDENV,
        m_fldl2e = ZYDIS_MNEMONIC_FLDL2E,
        m_fldl2t = ZYDIS_MNEMONIC_FLDL2T,
        m_fldlg2 = ZYDIS_MNEMONIC_FLDLG2,
        m_fldln2 = ZYDIS_MNEMONIC_FLDLN2,
        m_fldpi = ZYDIS_MNEMONIC_FLDPI,
        m_fldz = ZYDIS_MNEMONIC_FLDZ,
        m_fmul = ZYDIS_MNEMONIC_FMUL,
        m_fmulp = ZYDIS_MNEMONIC_FMULP,
        m_fnclex = ZYDIS_MNEMONIC_FNCLEX,
        m_fninit = ZYDIS_MNEMONIC_FNINIT,
        m_fnop = ZYDIS_MNEMONIC_FNOP,
        m_fnsave = ZYDIS_MNEMONIC_FNSAVE,
        m_fnstcw = ZYDIS_MNEMONIC_FNSTCW,
        m_fnstenv = ZYDIS_MNEMONIC_FNSTENV,
        m_fnstsw = ZYDIS_MNEMONIC_FNSTSW,
        m_fpatan = ZYDIS_MNEMONIC_FPATAN,
        m_fprem = ZYDIS_MNEMONIC_FPREM,
        m_fprem1 = ZYDIS_MNEMONIC_FPREM1,
        m_fptan = ZYDIS_MNEMONIC_FPTAN,
        m_frndint = ZYDIS_MNEMONIC_FRNDINT,
        m_frstor = ZYDIS_MNEMONIC_FRSTOR,
        m_fscale = ZYDIS_MNEMONIC_FSCALE,
        m_fsetpm287_nop = ZYDIS_MNEMONIC_FSETPM287_NOP,
        m_fsin = ZYDIS_MNEMONIC_FSIN,
        m_fsincos = ZYDIS_MNEMONIC_FSINCOS,
        m_fsqrt = ZYDIS_MNEMONIC_FSQRT,
        m_fst = ZYDIS_MNEMONIC_FST,
        m_fstp = ZYDIS_MNEMONIC_FSTP,
        m_fstpnce = ZYDIS_MNEMONIC_FSTPNCE,
        m_fsub = ZYDIS_MNEMONIC_FSUB,
        m_fsubp = ZYDIS_MNEMONIC_FSUBP,
        m_fsubr = ZYDIS_MNEMONIC_FSUBR,
        m_fsubrp = ZYDIS_MNEMONIC_FSUBRP,
        m_ftst = ZYDIS_MNEMONIC_FTST,
        m_fucom = ZYDIS_MNEMONIC_FUCOM,
        m_fucomi = ZYDIS_MNEMONIC_FUCOMI,
        m_fucomip = ZYDIS_MNEMONIC_FUCOMIP,
        m_fucomp = ZYDIS_MNEMONIC_FUCOMP,
        m_fucompp = ZYDIS_MNEMONIC_FUCOMPP,
        m_fwait = ZYDIS_MNEMONIC_FWAIT,
        m_fxam = ZYDIS_MNEMONIC_FXAM,
        m_fxch = ZYDIS_MNEMONIC_FXCH,
        m_fxrstor = ZYDIS_MNEMONIC_FXRSTOR,
        m_fxrstor64 = ZYDIS_MNEMONIC_FXRSTOR64,
        m_fxsave = ZYDIS_MNEMONIC_FXSAVE,
        m_fxsave64 = ZYDIS_MNEMONIC_FXSAVE64,
        m_fxtract = ZYDIS_MNEMONIC_FXTRACT,
        m_fyl2x = ZYDIS_MNEMONIC_FYL2X,
        m_fyl2xp1 = ZYDIS_MNEMONIC_FYL2XP1,
        m_getsec = ZYDIS_MNEMONIC_GETSEC,
        m_gf2p8affineinvqb = ZYDIS_MNEMONIC_GF2P8AFFINEINVQB,
        m_gf2p8affineqb = ZYDIS_MNEMONIC_GF2P8AFFINEQB,
        m_gf2p8mulb = ZYDIS_MNEMONIC_GF2P8MULB,
        m_haddpd = ZYDIS_MNEMONIC_HADDPD,
        m_haddps = ZYDIS_MNEMONIC_HADDPS,
        m_hlt = ZYDIS_MNEMONIC_HLT,
        m_hreset = ZYDIS_MNEMONIC_HRESET,
        m_hsubpd = ZYDIS_MNEMONIC_HSUBPD,
        m_hsubps = ZYDIS_MNEMONIC_HSUBPS,
        m_idiv = ZYDIS_MNEMONIC_IDIV,
        m_imul = ZYDIS_MNEMONIC_IMUL,
        m_in = ZYDIS_MNEMONIC_IN,
        m_inc = ZYDIS_MNEMONIC_INC,
        m_incsspd = ZYDIS_MNEMONIC_INCSSPD,
        m_incsspq = ZYDIS_MNEMONIC_INCSSPQ,
        m_insb = ZYDIS_MNEMONIC_INSB,
        m_insd = ZYDIS_MNEMONIC_INSD,
        m_insertps = ZYDIS_MNEMONIC_INSERTPS,
        m_insertq = ZYDIS_MNEMONIC_INSERTQ,
        m_insw = ZYDIS_MNEMONIC_INSW,
        m_int = ZYDIS_MNEMONIC_INT,
        m_int1 = ZYDIS_MNEMONIC_INT1,
        m_int3 = ZYDIS_MNEMONIC_INT3,
        m_into = ZYDIS_MNEMONIC_INTO,
        m_invd = ZYDIS_MNEMONIC_INVD,
        m_invept = ZYDIS_MNEMONIC_INVEPT,
        m_invlpg = ZYDIS_MNEMONIC_INVLPG,
        m_invlpga = ZYDIS_MNEMONIC_INVLPGA,
        m_invlpgb = ZYDIS_MNEMONIC_INVLPGB,
        m_invpcid = ZYDIS_MNEMONIC_INVPCID,
        m_invvpid = ZYDIS_MNEMONIC_INVVPID,
        m_iret = ZYDIS_MNEMONIC_IRET,
        m_iretd = ZYDIS_MNEMONIC_IRETD,
        m_iretq = ZYDIS_MNEMONIC_IRETQ,
        m_jb = ZYDIS_MNEMONIC_JB,
        m_jbe = ZYDIS_MNEMONIC_JBE,
        m_jcxz = ZYDIS_MNEMONIC_JCXZ,
        m_jecxz = ZYDIS_MNEMONIC_JECXZ,
        m_jknzd = ZYDIS_MNEMONIC_JKNZD,
        m_jkzd = ZYDIS_MNEMONIC_JKZD,
        m_jl = ZYDIS_MNEMONIC_JL,
        m_jle = ZYDIS_MNEMONIC_JLE,
        m_jmp = ZYDIS_MNEMONIC_JMP,
        m_jnb = ZYDIS_MNEMONIC_JNB,
        m_jnbe = ZYDIS_MNEMONIC_JNBE,
        m_jnl = ZYDIS_MNEMONIC_JNL,
        m_jnle = ZYDIS_MNEMONIC_JNLE,
        m_jno = ZYDIS_MNEMONIC_JNO,
        m_jnp = ZYDIS_MNEMONIC_JNP,
        m_jns = ZYDIS_MNEMONIC_JNS,
        m_jnz = ZYDIS_MNEMONIC_JNZ,
        m_jo = ZYDIS_MNEMONIC_JO,
        m_jp = ZYDIS_MNEMONIC_JP,
        m_jrcxz = ZYDIS_MNEMONIC_JRCXZ,
        m_js = ZYDIS_MNEMONIC_JS,
        m_jz = ZYDIS_MNEMONIC_JZ,
        m_kaddb = ZYDIS_MNEMONIC_KADDB,
        m_kaddd = ZYDIS_MNEMONIC_KADDD,
        m_kaddq = ZYDIS_MNEMONIC_KADDQ,
        m_kaddw = ZYDIS_MNEMONIC_KADDW,
        m_kand = ZYDIS_MNEMONIC_KAND,
        m_kandb = ZYDIS_MNEMONIC_KANDB,
        m_kandd = ZYDIS_MNEMONIC_KANDD,
        m_kandn = ZYDIS_MNEMONIC_KANDN,
        m_kandnb = ZYDIS_MNEMONIC_KANDNB,
        m_kandnd = ZYDIS_MNEMONIC_KANDND,
        m_kandnq = ZYDIS_MNEMONIC_KANDNQ,
        m_kandnr = ZYDIS_MNEMONIC_KANDNR,
        m_kandnw = ZYDIS_MNEMONIC_KANDNW,
        m_kandq = ZYDIS_MNEMONIC_KANDQ,
        m_kandw = ZYDIS_MNEMONIC_KANDW,
        m_kconcath = ZYDIS_MNEMONIC_KCONCATH,
        m_kconcatl = ZYDIS_MNEMONIC_KCONCATL,
        m_kextract = ZYDIS_MNEMONIC_KEXTRACT,
        m_kmerge2l1h = ZYDIS_MNEMONIC_KMERGE2L1H,
        m_kmerge2l1l = ZYDIS_MNEMONIC_KMERGE2L1L,
        m_kmov = ZYDIS_MNEMONIC_KMOV,
        m_kmovb = ZYDIS_MNEMONIC_KMOVB,
        m_kmovd = ZYDIS_MNEMONIC_KMOVD,
        m_kmovq = ZYDIS_MNEMONIC_KMOVQ,
        m_kmovw = ZYDIS_MNEMONIC_KMOVW,
        m_knot = ZYDIS_MNEMONIC_KNOT,
        m_knotb = ZYDIS_MNEMONIC_KNOTB,
        m_knotd = ZYDIS_MNEMONIC_KNOTD,
        m_knotq = ZYDIS_MNEMONIC_KNOTQ,
        m_knotw = ZYDIS_MNEMONIC_KNOTW,
        m_kor = ZYDIS_MNEMONIC_KOR,
        m_korb = ZYDIS_MNEMONIC_KORB,
        m_kord = ZYDIS_MNEMONIC_KORD,
        m_korq = ZYDIS_MNEMONIC_KORQ,
        m_kortest = ZYDIS_MNEMONIC_KORTEST,
        m_kortestb = ZYDIS_MNEMONIC_KORTESTB,
        m_kortestd = ZYDIS_MNEMONIC_KORTESTD,
        m_kortestq = ZYDIS_MNEMONIC_KORTESTQ,
        m_kortestw = ZYDIS_MNEMONIC_KORTESTW,
        m_korw = ZYDIS_MNEMONIC_KORW,
        m_kshiftlb = ZYDIS_MNEMONIC_KSHIFTLB,
        m_kshiftld = ZYDIS_MNEMONIC_KSHIFTLD,
        m_kshiftlq = ZYDIS_MNEMONIC_KSHIFTLQ,
        m_kshiftlw = ZYDIS_MNEMONIC_KSHIFTLW,
        m_kshiftrb = ZYDIS_MNEMONIC_KSHIFTRB,
        m_kshiftrd = ZYDIS_MNEMONIC_KSHIFTRD,
        m_kshiftrq = ZYDIS_MNEMONIC_KSHIFTRQ,
        m_kshiftrw = ZYDIS_MNEMONIC_KSHIFTRW,
        m_ktestb = ZYDIS_MNEMONIC_KTESTB,
        m_ktestd = ZYDIS_MNEMONIC_KTESTD,
        m_ktestq = ZYDIS_MNEMONIC_KTESTQ,
        m_ktestw = ZYDIS_MNEMONIC_KTESTW,
        m_kunpckbw = ZYDIS_MNEMONIC_KUNPCKBW,
        m_kunpckdq = ZYDIS_MNEMONIC_KUNPCKDQ,
        m_kunpckwd = ZYDIS_MNEMONIC_KUNPCKWD,
        m_kxnor = ZYDIS_MNEMONIC_KXNOR,
        m_kxnorb = ZYDIS_MNEMONIC_KXNORB,
        m_kxnord = ZYDIS_MNEMONIC_KXNORD,
        m_kxnorq = ZYDIS_MNEMONIC_KXNORQ,
        m_kxnorw = ZYDIS_MNEMONIC_KXNORW,
        m_kxor = ZYDIS_MNEMONIC_KXOR,
        m_kxorb = ZYDIS_MNEMONIC_KXORB,
        m_kxord = ZYDIS_MNEMONIC_KXORD,
        m_kxorq = ZYDIS_MNEMONIC_KXORQ,
        m_kxorw = ZYDIS_MNEMONIC_KXORW,
        m_lahf = ZYDIS_MNEMONIC_LAHF,
        m_lar = ZYDIS_MNEMONIC_LAR,
        m_lddqu = ZYDIS_MNEMONIC_LDDQU,
        m_ldmxcsr = ZYDIS_MNEMONIC_LDMXCSR,
        m_lds = ZYDIS_MNEMONIC_LDS,
        m_ldtilecfg = ZYDIS_MNEMONIC_LDTILECFG,
        m_lea = ZYDIS_MNEMONIC_LEA,
        m_leave = ZYDIS_MNEMONIC_LEAVE,
        m_les = ZYDIS_MNEMONIC_LES,
        m_lfence = ZYDIS_MNEMONIC_LFENCE,
        m_lfs = ZYDIS_MNEMONIC_LFS,
        m_lgdt = ZYDIS_MNEMONIC_LGDT,
        m_lgs = ZYDIS_MNEMONIC_LGS,
        m_lidt = ZYDIS_MNEMONIC_LIDT,
        m_lldt = ZYDIS_MNEMONIC_LLDT,
        m_llwpcb = ZYDIS_MNEMONIC_LLWPCB,
        m_lmsw = ZYDIS_MNEMONIC_LMSW,
        m_loadiwkey = ZYDIS_MNEMONIC_LOADIWKEY,
        m_lodsb = ZYDIS_MNEMONIC_LODSB,
        m_lodsd = ZYDIS_MNEMONIC_LODSD,
        m_lodsq = ZYDIS_MNEMONIC_LODSQ,
        m_lodsw = ZYDIS_MNEMONIC_LODSW,
        m_loop = ZYDIS_MNEMONIC_LOOP,
        m_loope = ZYDIS_MNEMONIC_LOOPE,
        m_loopne = ZYDIS_MNEMONIC_LOOPNE,
        m_lsl = ZYDIS_MNEMONIC_LSL,
        m_lss = ZYDIS_MNEMONIC_LSS,
        m_ltr = ZYDIS_MNEMONIC_LTR,
        m_lwpins = ZYDIS_MNEMONIC_LWPINS,
        m_lwpval = ZYDIS_MNEMONIC_LWPVAL,
        m_lzcnt = ZYDIS_MNEMONIC_LZCNT,
        m_maskmovdqu = ZYDIS_MNEMONIC_MASKMOVDQU,
        m_maskmovq = ZYDIS_MNEMONIC_MASKMOVQ,
        m_maxpd = ZYDIS_MNEMONIC_MAXPD,
        m_maxps = ZYDIS_MNEMONIC_MAXPS,
        m_maxsd = ZYDIS_MNEMONIC_MAXSD,
        m_maxss = ZYDIS_MNEMONIC_MAXSS,
        m_mcommit = ZYDIS_MNEMONIC_MCOMMIT,
        m_mfence = ZYDIS_MNEMONIC_MFENCE,
        m_minpd = ZYDIS_MNEMONIC_MINPD,
        m_minps = ZYDIS_MNEMONIC_MINPS,
        m_minsd = ZYDIS_MNEMONIC_MINSD,
        m_minss = ZYDIS_MNEMONIC_MINSS,
        m_monitor = ZYDIS_MNEMONIC_MONITOR,
        m_monitorx = ZYDIS_MNEMONIC_MONITORX,
        m_montmul = ZYDIS_MNEMONIC_MONTMUL,
        m_mov = ZYDIS_MNEMONIC_MOV,
        m_movapd = ZYDIS_MNEMONIC_MOVAPD,
        m_movaps = ZYDIS_MNEMONIC_MOVAPS,
        m_movbe = ZYDIS_MNEMONIC_MOVBE,
        m_movd = ZYDIS_MNEMONIC_MOVD,
        m_movddup = ZYDIS_MNEMONIC_MOVDDUP,
        m_movdir64b = ZYDIS_MNEMONIC_MOVDIR64B,
        m_movdiri = ZYDIS_MNEMONIC_MOVDIRI,
        m_movdq2q = ZYDIS_MNEMONIC_MOVDQ2Q,
        m_movdqa = ZYDIS_MNEMONIC_MOVDQA,
        m_movdqu = ZYDIS_MNEMONIC_MOVDQU,
        m_movhlps = ZYDIS_MNEMONIC_MOVHLPS,
        m_movhpd = ZYDIS_MNEMONIC_MOVHPD,
        m_movhps = ZYDIS_MNEMONIC_MOVHPS,
        m_movlhps = ZYDIS_MNEMONIC_MOVLHPS,
        m_movlpd = ZYDIS_MNEMONIC_MOVLPD,
        m_movlps = ZYDIS_MNEMONIC_MOVLPS,
        m_movmskpd = ZYDIS_MNEMONIC_MOVMSKPD,
        m_movmskps = ZYDIS_MNEMONIC_MOVMSKPS,
        m_movntdq = ZYDIS_MNEMONIC_MOVNTDQ,
        m_movntdqa = ZYDIS_MNEMONIC_MOVNTDQA,
        m_movnti = ZYDIS_MNEMONIC_MOVNTI,
        m_movntpd = ZYDIS_MNEMONIC_MOVNTPD,
        m_movntps = ZYDIS_MNEMONIC_MOVNTPS,
        m_movntq = ZYDIS_MNEMONIC_MOVNTQ,
        m_movntsd = ZYDIS_MNEMONIC_MOVNTSD,
        m_movntss = ZYDIS_MNEMONIC_MOVNTSS,
        m_movq = ZYDIS_MNEMONIC_MOVQ,
        m_movq2dq = ZYDIS_MNEMONIC_MOVQ2DQ,
        m_movsb = ZYDIS_MNEMONIC_MOVSB,
        m_movsd = ZYDIS_MNEMONIC_MOVSD,
        m_movshdup = ZYDIS_MNEMONIC_MOVSHDUP,
        m_movsldup = ZYDIS_MNEMONIC_MOVSLDUP,
        m_movsq = ZYDIS_MNEMONIC_MOVSQ,
        m_movss = ZYDIS_MNEMONIC_MOVSS,
        m_movsw = ZYDIS_MNEMONIC_MOVSW,
        m_movsx = ZYDIS_MNEMONIC_MOVSX,
        m_movsxd = ZYDIS_MNEMONIC_MOVSXD,
        m_movupd = ZYDIS_MNEMONIC_MOVUPD,
        m_movups = ZYDIS_MNEMONIC_MOVUPS,
        m_movzx = ZYDIS_MNEMONIC_MOVZX,
        m_mpsadbw = ZYDIS_MNEMONIC_MPSADBW,
        m_mul = ZYDIS_MNEMONIC_MUL,
        m_mulpd = ZYDIS_MNEMONIC_MULPD,
        m_mulps = ZYDIS_MNEMONIC_MULPS,
        m_mulsd = ZYDIS_MNEMONIC_MULSD,
        m_mulss = ZYDIS_MNEMONIC_MULSS,
        m_mulx = ZYDIS_MNEMONIC_MULX,
        m_mwait = ZYDIS_MNEMONIC_MWAIT,
        m_mwaitx = ZYDIS_MNEMONIC_MWAITX,
        m_neg = ZYDIS_MNEMONIC_NEG,
        m_nop = ZYDIS_MNEMONIC_NOP,
        m_not = ZYDIS_MNEMONIC_NOT,
        m_or = ZYDIS_MNEMONIC_OR,
        m_orpd = ZYDIS_MNEMONIC_ORPD,
        m_orps = ZYDIS_MNEMONIC_ORPS,
        m_out = ZYDIS_MNEMONIC_OUT,
        m_outsb = ZYDIS_MNEMONIC_OUTSB,
        m_outsd = ZYDIS_MNEMONIC_OUTSD,
        m_outsw = ZYDIS_MNEMONIC_OUTSW,
        m_pabsb = ZYDIS_MNEMONIC_PABSB,
        m_pabsd = ZYDIS_MNEMONIC_PABSD,
        m_pabsw = ZYDIS_MNEMONIC_PABSW,
        m_packssdw = ZYDIS_MNEMONIC_PACKSSDW,
        m_packsswb = ZYDIS_MNEMONIC_PACKSSWB,
        m_packusdw = ZYDIS_MNEMONIC_PACKUSDW,
        m_packuswb = ZYDIS_MNEMONIC_PACKUSWB,
        m_paddb = ZYDIS_MNEMONIC_PADDB,
        m_paddd = ZYDIS_MNEMONIC_PADDD,
        m_paddq = ZYDIS_MNEMONIC_PADDQ,
        m_paddsb = ZYDIS_MNEMONIC_PADDSB,
        m_paddsw = ZYDIS_MNEMONIC_PADDSW,
        m_paddusb = ZYDIS_MNEMONIC_PADDUSB,
        m_paddusw = ZYDIS_MNEMONIC_PADDUSW,
        m_paddw = ZYDIS_MNEMONIC_PADDW,
        m_palignr = ZYDIS_MNEMONIC_PALIGNR,
        m_pand = ZYDIS_MNEMONIC_PAND,
        m_pandn = ZYDIS_MNEMONIC_PANDN,
        m_pause = ZYDIS_MNEMONIC_PAUSE,
        m_pavgb = ZYDIS_MNEMONIC_PAVGB,
        m_pavgusb = ZYDIS_MNEMONIC_PAVGUSB,
        m_pavgw = ZYDIS_MNEMONIC_PAVGW,
        m_pblendvb = ZYDIS_MNEMONIC_PBLENDVB,
        m_pblendw = ZYDIS_MNEMONIC_PBLENDW,
        m_pbndkb = ZYDIS_MNEMONIC_PBNDKB,
        m_pclmulqdq = ZYDIS_MNEMONIC_PCLMULQDQ,
        m_pcmpeqb = ZYDIS_MNEMONIC_PCMPEQB,
        m_pcmpeqd = ZYDIS_MNEMONIC_PCMPEQD,
        m_pcmpeqq = ZYDIS_MNEMONIC_PCMPEQQ,
        m_pcmpeqw = ZYDIS_MNEMONIC_PCMPEQW,
        m_pcmpestri = ZYDIS_MNEMONIC_PCMPESTRI,
        m_pcmpestrm = ZYDIS_MNEMONIC_PCMPESTRM,
        m_pcmpgtb = ZYDIS_MNEMONIC_PCMPGTB,
        m_pcmpgtd = ZYDIS_MNEMONIC_PCMPGTD,
        m_pcmpgtq = ZYDIS_MNEMONIC_PCMPGTQ,
        m_pcmpgtw = ZYDIS_MNEMONIC_PCMPGTW,
        m_pcmpistri = ZYDIS_MNEMONIC_PCMPISTRI,
        m_pcmpistrm = ZYDIS_MNEMONIC_PCMPISTRM,
        m_pcommit = ZYDIS_MNEMONIC_PCOMMIT,
        m_pconfig = ZYDIS_MNEMONIC_PCONFIG,
        m_pdep = ZYDIS_MNEMONIC_PDEP,
        m_pext = ZYDIS_MNEMONIC_PEXT,
        m_pextrb = ZYDIS_MNEMONIC_PEXTRB,
        m_pextrd = ZYDIS_MNEMONIC_PEXTRD,
        m_pextrq = ZYDIS_MNEMONIC_PEXTRQ,
        m_pextrw = ZYDIS_MNEMONIC_PEXTRW,
        m_pf2id = ZYDIS_MNEMONIC_PF2ID,
        m_pf2iw = ZYDIS_MNEMONIC_PF2IW,
        m_pfacc = ZYDIS_MNEMONIC_PFACC,
        m_pfadd = ZYDIS_MNEMONIC_PFADD,
        m_pfcmpeq = ZYDIS_MNEMONIC_PFCMPEQ,
        m_pfcmpge = ZYDIS_MNEMONIC_PFCMPGE,
        m_pfcmpgt = ZYDIS_MNEMONIC_PFCMPGT,
        m_pfcpit1 = ZYDIS_MNEMONIC_PFCPIT1,
        m_pfmax = ZYDIS_MNEMONIC_PFMAX,
        m_pfmin = ZYDIS_MNEMONIC_PFMIN,
        m_pfmul = ZYDIS_MNEMONIC_PFMUL,
        m_pfnacc = ZYDIS_MNEMONIC_PFNACC,
        m_pfpnacc = ZYDIS_MNEMONIC_PFPNACC,
        m_pfrcp = ZYDIS_MNEMONIC_PFRCP,
        m_pfrcpit2 = ZYDIS_MNEMONIC_PFRCPIT2,
        m_pfrsqit1 = ZYDIS_MNEMONIC_PFRSQIT1,
        m_pfsqrt = ZYDIS_MNEMONIC_PFSQRT,
        m_pfsub = ZYDIS_MNEMONIC_PFSUB,
        m_pfsubr = ZYDIS_MNEMONIC_PFSUBR,
        m_phaddd = ZYDIS_MNEMONIC_PHADDD,
        m_phaddsw = ZYDIS_MNEMONIC_PHADDSW,
        m_phaddw = ZYDIS_MNEMONIC_PHADDW,
        m_phminposuw = ZYDIS_MNEMONIC_PHMINPOSUW,
        m_phsubd = ZYDIS_MNEMONIC_PHSUBD,
        m_phsubsw = ZYDIS_MNEMONIC_PHSUBSW,
        m_phsubw = ZYDIS_MNEMONIC_PHSUBW,
        m_pi2fd = ZYDIS_MNEMONIC_PI2FD,
        m_pi2fw = ZYDIS_MNEMONIC_PI2FW,
        m_pinsrb = ZYDIS_MNEMONIC_PINSRB,
        m_pinsrd = ZYDIS_MNEMONIC_PINSRD,
        m_pinsrq = ZYDIS_MNEMONIC_PINSRQ,
        m_pinsrw = ZYDIS_MNEMONIC_PINSRW,
        m_pmaddubsw = ZYDIS_MNEMONIC_PMADDUBSW,
        m_pmaddwd = ZYDIS_MNEMONIC_PMADDWD,
        m_pmaxsb = ZYDIS_MNEMONIC_PMAXSB,
        m_pmaxsd = ZYDIS_MNEMONIC_PMAXSD,
        m_pmaxsw = ZYDIS_MNEMONIC_PMAXSW,
        m_pmaxub = ZYDIS_MNEMONIC_PMAXUB,
        m_pmaxud = ZYDIS_MNEMONIC_PMAXUD,
        m_pmaxuw = ZYDIS_MNEMONIC_PMAXUW,
        m_pminsb = ZYDIS_MNEMONIC_PMINSB,
        m_pminsd = ZYDIS_MNEMONIC_PMINSD,
        m_pminsw = ZYDIS_MNEMONIC_PMINSW,
        m_pminub = ZYDIS_MNEMONIC_PMINUB,
        m_pminud = ZYDIS_MNEMONIC_PMINUD,
        m_pminuw = ZYDIS_MNEMONIC_PMINUW,
        m_pmovmskb = ZYDIS_MNEMONIC_PMOVMSKB,
        m_pmovsxbd = ZYDIS_MNEMONIC_PMOVSXBD,
        m_pmovsxbq = ZYDIS_MNEMONIC_PMOVSXBQ,
        m_pmovsxbw = ZYDIS_MNEMONIC_PMOVSXBW,
        m_pmovsxdq = ZYDIS_MNEMONIC_PMOVSXDQ,
        m_pmovsxwd = ZYDIS_MNEMONIC_PMOVSXWD,
        m_pmovsxwq = ZYDIS_MNEMONIC_PMOVSXWQ,
        m_pmovzxbd = ZYDIS_MNEMONIC_PMOVZXBD,
        m_pmovzxbq = ZYDIS_MNEMONIC_PMOVZXBQ,
        m_pmovzxbw = ZYDIS_MNEMONIC_PMOVZXBW,
        m_pmovzxdq = ZYDIS_MNEMONIC_PMOVZXDQ,
        m_pmovzxwd = ZYDIS_MNEMONIC_PMOVZXWD,
        m_pmovzxwq = ZYDIS_MNEMONIC_PMOVZXWQ,
        m_pmuldq = ZYDIS_MNEMONIC_PMULDQ,
        m_pmulhrsw = ZYDIS_MNEMONIC_PMULHRSW,
        m_pmulhrw = ZYDIS_MNEMONIC_PMULHRW,
        m_pmulhuw = ZYDIS_MNEMONIC_PMULHUW,
        m_pmulhw = ZYDIS_MNEMONIC_PMULHW,
        m_pmulld = ZYDIS_MNEMONIC_PMULLD,
        m_pmullw = ZYDIS_MNEMONIC_PMULLW,
        m_pmuludq = ZYDIS_MNEMONIC_PMULUDQ,
        m_pop = ZYDIS_MNEMONIC_POP,
        m_popa = ZYDIS_MNEMONIC_POPA,
        m_popad = ZYDIS_MNEMONIC_POPAD,
        m_popcnt = ZYDIS_MNEMONIC_POPCNT,
        m_popf = ZYDIS_MNEMONIC_POPF,
        m_popfd = ZYDIS_MNEMONIC_POPFD,
        m_popfq = ZYDIS_MNEMONIC_POPFQ,
        m_por = ZYDIS_MNEMONIC_POR,
        m_prefetch = ZYDIS_MNEMONIC_PREFETCH,
        m_prefetchit0 = ZYDIS_MNEMONIC_PREFETCHIT0,
        m_prefetchit1 = ZYDIS_MNEMONIC_PREFETCHIT1,
        m_prefetchnta = ZYDIS_MNEMONIC_PREFETCHNTA,
        m_prefetcht0 = ZYDIS_MNEMONIC_PREFETCHT0,
        m_prefetcht1 = ZYDIS_MNEMONIC_PREFETCHT1,
        m_prefetcht2 = ZYDIS_MNEMONIC_PREFETCHT2,
        m_prefetchw = ZYDIS_MNEMONIC_PREFETCHW,
        m_prefetchwt1 = ZYDIS_MNEMONIC_PREFETCHWT1,
        m_psadbw = ZYDIS_MNEMONIC_PSADBW,
        m_pshufb = ZYDIS_MNEMONIC_PSHUFB,
        m_pshufd = ZYDIS_MNEMONIC_PSHUFD,
        m_pshufhw = ZYDIS_MNEMONIC_PSHUFHW,
        m_pshuflw = ZYDIS_MNEMONIC_PSHUFLW,
        m_pshufw = ZYDIS_MNEMONIC_PSHUFW,
        m_psignb = ZYDIS_MNEMONIC_PSIGNB,
        m_psignd = ZYDIS_MNEMONIC_PSIGND,
        m_psignw = ZYDIS_MNEMONIC_PSIGNW,
        m_pslld = ZYDIS_MNEMONIC_PSLLD,
        m_pslldq = ZYDIS_MNEMONIC_PSLLDQ,
        m_psllq = ZYDIS_MNEMONIC_PSLLQ,
        m_psllw = ZYDIS_MNEMONIC_PSLLW,
        m_psmash = ZYDIS_MNEMONIC_PSMASH,
        m_psrad = ZYDIS_MNEMONIC_PSRAD,
        m_psraw = ZYDIS_MNEMONIC_PSRAW,
        m_psrld = ZYDIS_MNEMONIC_PSRLD,
        m_psrldq = ZYDIS_MNEMONIC_PSRLDQ,
        m_psrlq = ZYDIS_MNEMONIC_PSRLQ,
        m_psrlw = ZYDIS_MNEMONIC_PSRLW,
        m_psubb = ZYDIS_MNEMONIC_PSUBB,
        m_psubd = ZYDIS_MNEMONIC_PSUBD,
        m_psubq = ZYDIS_MNEMONIC_PSUBQ,
        m_psubsb = ZYDIS_MNEMONIC_PSUBSB,
        m_psubsw = ZYDIS_MNEMONIC_PSUBSW,
        m_psubusb = ZYDIS_MNEMONIC_PSUBUSB,
        m_psubusw = ZYDIS_MNEMONIC_PSUBUSW,
        m_psubw = ZYDIS_MNEMONIC_PSUBW,
        m_pswapd = ZYDIS_MNEMONIC_PSWAPD,
        m_ptest = ZYDIS_MNEMONIC_PTEST,
        m_ptwrite = ZYDIS_MNEMONIC_PTWRITE,
        m_punpckhbw = ZYDIS_MNEMONIC_PUNPCKHBW,
        m_punpckhdq = ZYDIS_MNEMONIC_PUNPCKHDQ,
        m_punpckhqdq = ZYDIS_MNEMONIC_PUNPCKHQDQ,
        m_punpckhwd = ZYDIS_MNEMONIC_PUNPCKHWD,
        m_punpcklbw = ZYDIS_MNEMONIC_PUNPCKLBW,
        m_punpckldq = ZYDIS_MNEMONIC_PUNPCKLDQ,
        m_punpcklqdq = ZYDIS_MNEMONIC_PUNPCKLQDQ,
        m_punpcklwd = ZYDIS_MNEMONIC_PUNPCKLWD,
        m_push = ZYDIS_MNEMONIC_PUSH,
        m_pusha = ZYDIS_MNEMONIC_PUSHA,
        m_pushad = ZYDIS_MNEMONIC_PUSHAD,
        m_pushf = ZYDIS_MNEMONIC_PUSHF,
        m_pushfd = ZYDIS_MNEMONIC_PUSHFD,
        m_pushfq = ZYDIS_MNEMONIC_PUSHFQ,
        m_pvalidate = ZYDIS_MNEMONIC_PVALIDATE,
        m_pxor = ZYDIS_MNEMONIC_PXOR,
        m_rcl = ZYDIS_MNEMONIC_RCL,
        m_rcpps = ZYDIS_MNEMONIC_RCPPS,
        m_rcpss = ZYDIS_MNEMONIC_RCPSS,
        m_rcr = ZYDIS_MNEMONIC_RCR,
        m_rdfsbase = ZYDIS_MNEMONIC_RDFSBASE,
        m_rdgsbase = ZYDIS_MNEMONIC_RDGSBASE,
        m_rdmsr = ZYDIS_MNEMONIC_RDMSR,
        m_rdmsrlist = ZYDIS_MNEMONIC_RDMSRLIST,
        m_rdpid = ZYDIS_MNEMONIC_RDPID,
        m_rdpkru = ZYDIS_MNEMONIC_RDPKRU,
        m_rdpmc = ZYDIS_MNEMONIC_RDPMC,
        m_rdpru = ZYDIS_MNEMONIC_RDPRU,
        m_rdrand = ZYDIS_MNEMONIC_RDRAND,
        m_rdseed = ZYDIS_MNEMONIC_RDSEED,
        m_rdsspd = ZYDIS_MNEMONIC_RDSSPD,
        m_rdsspq = ZYDIS_MNEMONIC_RDSSPQ,
        m_rdtsc = ZYDIS_MNEMONIC_RDTSC,
        m_rdtscp = ZYDIS_MNEMONIC_RDTSCP,
        m_ret = ZYDIS_MNEMONIC_RET,
        m_rmpadjust = ZYDIS_MNEMONIC_RMPADJUST,
        m_rmpupdate = ZYDIS_MNEMONIC_RMPUPDATE,
        m_rol = ZYDIS_MNEMONIC_ROL,
        m_ror = ZYDIS_MNEMONIC_ROR,
        m_rorx = ZYDIS_MNEMONIC_RORX,
        m_roundpd = ZYDIS_MNEMONIC_ROUNDPD,
        m_roundps = ZYDIS_MNEMONIC_ROUNDPS,
        m_roundsd = ZYDIS_MNEMONIC_ROUNDSD,
        m_roundss = ZYDIS_MNEMONIC_ROUNDSS,
        m_rsm = ZYDIS_MNEMONIC_RSM,
        m_rsqrtps = ZYDIS_MNEMONIC_RSQRTPS,
        m_rsqrtss = ZYDIS_MNEMONIC_RSQRTSS,
        m_rstorssp = ZYDIS_MNEMONIC_RSTORSSP,
        m_sahf = ZYDIS_MNEMONIC_SAHF,
        m_salc = ZYDIS_MNEMONIC_SALC,
        m_sar = ZYDIS_MNEMONIC_SAR,
        m_sarx = ZYDIS_MNEMONIC_SARX,
        m_saveprevssp = ZYDIS_MNEMONIC_SAVEPREVSSP,
        m_sbb = ZYDIS_MNEMONIC_SBB,
        m_scasb = ZYDIS_MNEMONIC_SCASB,
        m_scasd = ZYDIS_MNEMONIC_SCASD,
        m_scasq = ZYDIS_MNEMONIC_SCASQ,
        m_scasw = ZYDIS_MNEMONIC_SCASW,
        m_seamcall = ZYDIS_MNEMONIC_SEAMCALL,
        m_seamops = ZYDIS_MNEMONIC_SEAMOPS,
        m_seamret = ZYDIS_MNEMONIC_SEAMRET,
        m_senduipi = ZYDIS_MNEMONIC_SENDUIPI,
        m_serialize = ZYDIS_MNEMONIC_SERIALIZE,
        m_setb = ZYDIS_MNEMONIC_SETB,
        m_setbe = ZYDIS_MNEMONIC_SETBE,
        m_setl = ZYDIS_MNEMONIC_SETL,
        m_setle = ZYDIS_MNEMONIC_SETLE,
        m_setnb = ZYDIS_MNEMONIC_SETNB,
        m_setnbe = ZYDIS_MNEMONIC_SETNBE,
        m_setnl = ZYDIS_MNEMONIC_SETNL,
        m_setnle = ZYDIS_MNEMONIC_SETNLE,
        m_setno = ZYDIS_MNEMONIC_SETNO,
        m_setnp = ZYDIS_MNEMONIC_SETNP,
        m_setns = ZYDIS_MNEMONIC_SETNS,
        m_setnz = ZYDIS_MNEMONIC_SETNZ,
        m_seto = ZYDIS_MNEMONIC_SETO,
        m_setp = ZYDIS_MNEMONIC_SETP,
        m_sets = ZYDIS_MNEMONIC_SETS,
        m_setssbsy = ZYDIS_MNEMONIC_SETSSBSY,
        m_setz = ZYDIS_MNEMONIC_SETZ,
        m_sfence = ZYDIS_MNEMONIC_SFENCE,
        m_sgdt = ZYDIS_MNEMONIC_SGDT,
        m_sha1msg1 = ZYDIS_MNEMONIC_SHA1MSG1,
        m_sha1msg2 = ZYDIS_MNEMONIC_SHA1MSG2,
        m_sha1nexte = ZYDIS_MNEMONIC_SHA1NEXTE,
        m_sha1rnds4 = ZYDIS_MNEMONIC_SHA1RNDS4,
        m_sha256msg1 = ZYDIS_MNEMONIC_SHA256MSG1,
        m_sha256msg2 = ZYDIS_MNEMONIC_SHA256MSG2,
        m_sha256rnds2 = ZYDIS_MNEMONIC_SHA256RNDS2,
        m_shl = ZYDIS_MNEMONIC_SHL,
        m_shld = ZYDIS_MNEMONIC_SHLD,
        m_shlx = ZYDIS_MNEMONIC_SHLX,
        m_shr = ZYDIS_MNEMONIC_SHR,
        m_shrd = ZYDIS_MNEMONIC_SHRD,
        m_shrx = ZYDIS_MNEMONIC_SHRX,
        m_shufpd = ZYDIS_MNEMONIC_SHUFPD,
        m_shufps = ZYDIS_MNEMONIC_SHUFPS,
        m_sidt = ZYDIS_MNEMONIC_SIDT,
        m_skinit = ZYDIS_MNEMONIC_SKINIT,
        m_sldt = ZYDIS_MNEMONIC_SLDT,
        m_slwpcb = ZYDIS_MNEMONIC_SLWPCB,
        m_smsw = ZYDIS_MNEMONIC_SMSW,
        m_spflt = ZYDIS_MNEMONIC_SPFLT,
        m_sqrtpd = ZYDIS_MNEMONIC_SQRTPD,
        m_sqrtps = ZYDIS_MNEMONIC_SQRTPS,
        m_sqrtsd = ZYDIS_MNEMONIC_SQRTSD,
        m_sqrtss = ZYDIS_MNEMONIC_SQRTSS,
        m_stac = ZYDIS_MNEMONIC_STAC,
        m_stc = ZYDIS_MNEMONIC_STC,
        m_std = ZYDIS_MNEMONIC_STD,
        m_stgi = ZYDIS_MNEMONIC_STGI,
        m_sti = ZYDIS_MNEMONIC_STI,
        m_stmxcsr = ZYDIS_MNEMONIC_STMXCSR,
        m_stosb = ZYDIS_MNEMONIC_STOSB,
        m_stosd = ZYDIS_MNEMONIC_STOSD,
        m_stosq = ZYDIS_MNEMONIC_STOSQ,
        m_stosw = ZYDIS_MNEMONIC_STOSW,
        m_str = ZYDIS_MNEMONIC_STR,
        m_sttilecfg = ZYDIS_MNEMONIC_STTILECFG,
        m_stui = ZYDIS_MNEMONIC_STUI,
        m_sub = ZYDIS_MNEMONIC_SUB,
        m_subpd = ZYDIS_MNEMONIC_SUBPD,
        m_subps = ZYDIS_MNEMONIC_SUBPS,
        m_subsd = ZYDIS_MNEMONIC_SUBSD,
        m_subss = ZYDIS_MNEMONIC_SUBSS,
        m_swapgs = ZYDIS_MNEMONIC_SWAPGS,
        m_syscall = ZYDIS_MNEMONIC_SYSCALL,
        m_sysenter = ZYDIS_MNEMONIC_SYSENTER,
        m_sysexit = ZYDIS_MNEMONIC_SYSEXIT,
        m_sysret = ZYDIS_MNEMONIC_SYSRET,
        m_t1mskc = ZYDIS_MNEMONIC_T1MSKC,
        m_tdcall = ZYDIS_MNEMONIC_TDCALL,
        m_tdpbf16ps = ZYDIS_MNEMONIC_TDPBF16PS,
        m_tdpbssd = ZYDIS_MNEMONIC_TDPBSSD,
        m_tdpbsud = ZYDIS_MNEMONIC_TDPBSUD,
        m_tdpbusd = ZYDIS_MNEMONIC_TDPBUSD,
        m_tdpbuud = ZYDIS_MNEMONIC_TDPBUUD,
        m_tdpfp16ps = ZYDIS_MNEMONIC_TDPFP16PS,
        m_test = ZYDIS_MNEMONIC_TEST,
        m_testui = ZYDIS_MNEMONIC_TESTUI,
        m_tileloadd = ZYDIS_MNEMONIC_TILELOADD,
        m_tileloaddt1 = ZYDIS_MNEMONIC_TILELOADDT1,
        m_tilerelease = ZYDIS_MNEMONIC_TILERELEASE,
        m_tilestored = ZYDIS_MNEMONIC_TILESTORED,
        m_tilezero = ZYDIS_MNEMONIC_TILEZERO,
        m_tlbsync = ZYDIS_MNEMONIC_TLBSYNC,
        m_tpause = ZYDIS_MNEMONIC_TPAUSE,
        m_tzcnt = ZYDIS_MNEMONIC_TZCNT,
        m_tzcnti = ZYDIS_MNEMONIC_TZCNTI,
        m_tzmsk = ZYDIS_MNEMONIC_TZMSK,
        m_ucomisd = ZYDIS_MNEMONIC_UCOMISD,
        m_ucomiss = ZYDIS_MNEMONIC_UCOMISS,
        m_ud0 = ZYDIS_MNEMONIC_UD0,
        m_ud1 = ZYDIS_MNEMONIC_UD1,
        m_ud2 = ZYDIS_MNEMONIC_UD2,
        m_uiret = ZYDIS_MNEMONIC_UIRET,
        m_umonitor = ZYDIS_MNEMONIC_UMONITOR,
        m_umwait = ZYDIS_MNEMONIC_UMWAIT,
        m_unpckhpd = ZYDIS_MNEMONIC_UNPCKHPD,
        m_unpckhps = ZYDIS_MNEMONIC_UNPCKHPS,
        m_unpcklpd = ZYDIS_MNEMONIC_UNPCKLPD,
        m_unpcklps = ZYDIS_MNEMONIC_UNPCKLPS,
        m_v4fmaddps = ZYDIS_MNEMONIC_V4FMADDPS,
        m_v4fmaddss = ZYDIS_MNEMONIC_V4FMADDSS,
        m_v4fnmaddps = ZYDIS_MNEMONIC_V4FNMADDPS,
        m_v4fnmaddss = ZYDIS_MNEMONIC_V4FNMADDSS,
        m_vaddnpd = ZYDIS_MNEMONIC_VADDNPD,
        m_vaddnps = ZYDIS_MNEMONIC_VADDNPS,
        m_vaddpd = ZYDIS_MNEMONIC_VADDPD,
        m_vaddph = ZYDIS_MNEMONIC_VADDPH,
        m_vaddps = ZYDIS_MNEMONIC_VADDPS,
        m_vaddsd = ZYDIS_MNEMONIC_VADDSD,
        m_vaddsetsps = ZYDIS_MNEMONIC_VADDSETSPS,
        m_vaddsh = ZYDIS_MNEMONIC_VADDSH,
        m_vaddss = ZYDIS_MNEMONIC_VADDSS,
        m_vaddsubpd = ZYDIS_MNEMONIC_VADDSUBPD,
        m_vaddsubps = ZYDIS_MNEMONIC_VADDSUBPS,
        m_vaesdec = ZYDIS_MNEMONIC_VAESDEC,
        m_vaesdeclast = ZYDIS_MNEMONIC_VAESDECLAST,
        m_vaesenc = ZYDIS_MNEMONIC_VAESENC,
        m_vaesenclast = ZYDIS_MNEMONIC_VAESENCLAST,
        m_vaesimc = ZYDIS_MNEMONIC_VAESIMC,
        m_vaeskeygenassist = ZYDIS_MNEMONIC_VAESKEYGENASSIST,
        m_valignd = ZYDIS_MNEMONIC_VALIGND,
        m_valignq = ZYDIS_MNEMONIC_VALIGNQ,
        m_vandnpd = ZYDIS_MNEMONIC_VANDNPD,
        m_vandnps = ZYDIS_MNEMONIC_VANDNPS,
        m_vandpd = ZYDIS_MNEMONIC_VANDPD,
        m_vandps = ZYDIS_MNEMONIC_VANDPS,
        m_vbcstnebf162ps = ZYDIS_MNEMONIC_VBCSTNEBF162PS,
        m_vbcstnesh2ps = ZYDIS_MNEMONIC_VBCSTNESH2PS,
        m_vblendmpd = ZYDIS_MNEMONIC_VBLENDMPD,
        m_vblendmps = ZYDIS_MNEMONIC_VBLENDMPS,
        m_vblendpd = ZYDIS_MNEMONIC_VBLENDPD,
        m_vblendps = ZYDIS_MNEMONIC_VBLENDPS,
        m_vblendvpd = ZYDIS_MNEMONIC_VBLENDVPD,
        m_vblendvps = ZYDIS_MNEMONIC_VBLENDVPS,
        m_vbroadcastf128 = ZYDIS_MNEMONIC_VBROADCASTF128,
        m_vbroadcastf32x2 = ZYDIS_MNEMONIC_VBROADCASTF32X2,
        m_vbroadcastf32x4 = ZYDIS_MNEMONIC_VBROADCASTF32X4,
        m_vbroadcastf32x8 = ZYDIS_MNEMONIC_VBROADCASTF32X8,
        m_vbroadcastf64x2 = ZYDIS_MNEMONIC_VBROADCASTF64X2,
        m_vbroadcastf64x4 = ZYDIS_MNEMONIC_VBROADCASTF64X4,
        m_vbroadcasti128 = ZYDIS_MNEMONIC_VBROADCASTI128,
        m_vbroadcasti32x2 = ZYDIS_MNEMONIC_VBROADCASTI32X2,
        m_vbroadcasti32x4 = ZYDIS_MNEMONIC_VBROADCASTI32X4,
        m_vbroadcasti32x8 = ZYDIS_MNEMONIC_VBROADCASTI32X8,
        m_vbroadcasti64x2 = ZYDIS_MNEMONIC_VBROADCASTI64X2,
        m_vbroadcasti64x4 = ZYDIS_MNEMONIC_VBROADCASTI64X4,
        m_vbroadcastsd = ZYDIS_MNEMONIC_VBROADCASTSD,
        m_vbroadcastss = ZYDIS_MNEMONIC_VBROADCASTSS,
        m_vcmppd = ZYDIS_MNEMONIC_VCMPPD,
        m_vcmpph = ZYDIS_MNEMONIC_VCMPPH,
        m_vcmpps = ZYDIS_MNEMONIC_VCMPPS,
        m_vcmpsd = ZYDIS_MNEMONIC_VCMPSD,
        m_vcmpsh = ZYDIS_MNEMONIC_VCMPSH,
        m_vcmpss = ZYDIS_MNEMONIC_VCMPSS,
        m_vcomisd = ZYDIS_MNEMONIC_VCOMISD,
        m_vcomish = ZYDIS_MNEMONIC_VCOMISH,
        m_vcomiss = ZYDIS_MNEMONIC_VCOMISS,
        m_vcompresspd = ZYDIS_MNEMONIC_VCOMPRESSPD,
        m_vcompressps = ZYDIS_MNEMONIC_VCOMPRESSPS,
        m_vcvtdq2pd = ZYDIS_MNEMONIC_VCVTDQ2PD,
        m_vcvtdq2ph = ZYDIS_MNEMONIC_VCVTDQ2PH,
        m_vcvtdq2ps = ZYDIS_MNEMONIC_VCVTDQ2PS,
        m_vcvtfxpntdq2ps = ZYDIS_MNEMONIC_VCVTFXPNTDQ2PS,
        m_vcvtfxpntpd2dq = ZYDIS_MNEMONIC_VCVTFXPNTPD2DQ,
        m_vcvtfxpntpd2udq = ZYDIS_MNEMONIC_VCVTFXPNTPD2UDQ,
        m_vcvtfxpntps2dq = ZYDIS_MNEMONIC_VCVTFXPNTPS2DQ,
        m_vcvtfxpntps2udq = ZYDIS_MNEMONIC_VCVTFXPNTPS2UDQ,
        m_vcvtfxpntudq2ps = ZYDIS_MNEMONIC_VCVTFXPNTUDQ2PS,
        m_vcvtne2ps2bf16 = ZYDIS_MNEMONIC_VCVTNE2PS2BF16,
        m_vcvtneebf162ps = ZYDIS_MNEMONIC_VCVTNEEBF162PS,
        m_vcvtneeph2ps = ZYDIS_MNEMONIC_VCVTNEEPH2PS,
        m_vcvtneobf162ps = ZYDIS_MNEMONIC_VCVTNEOBF162PS,
        m_vcvtneoph2ps = ZYDIS_MNEMONIC_VCVTNEOPH2PS,
        m_vcvtneps2bf16 = ZYDIS_MNEMONIC_VCVTNEPS2BF16,
        m_vcvtpd2dq = ZYDIS_MNEMONIC_VCVTPD2DQ,
        m_vcvtpd2ph = ZYDIS_MNEMONIC_VCVTPD2PH,
        m_vcvtpd2ps = ZYDIS_MNEMONIC_VCVTPD2PS,
        m_vcvtpd2qq = ZYDIS_MNEMONIC_VCVTPD2QQ,
        m_vcvtpd2udq = ZYDIS_MNEMONIC_VCVTPD2UDQ,
        m_vcvtpd2uqq = ZYDIS_MNEMONIC_VCVTPD2UQQ,
        m_vcvtph2dq = ZYDIS_MNEMONIC_VCVTPH2DQ,
        m_vcvtph2pd = ZYDIS_MNEMONIC_VCVTPH2PD,
        m_vcvtph2ps = ZYDIS_MNEMONIC_VCVTPH2PS,
        m_vcvtph2psx = ZYDIS_MNEMONIC_VCVTPH2PSX,
        m_vcvtph2qq = ZYDIS_MNEMONIC_VCVTPH2QQ,
        m_vcvtph2udq = ZYDIS_MNEMONIC_VCVTPH2UDQ,
        m_vcvtph2uqq = ZYDIS_MNEMONIC_VCVTPH2UQQ,
        m_vcvtph2uw = ZYDIS_MNEMONIC_VCVTPH2UW,
        m_vcvtph2w = ZYDIS_MNEMONIC_VCVTPH2W,
        m_vcvtps2dq = ZYDIS_MNEMONIC_VCVTPS2DQ,
        m_vcvtps2pd = ZYDIS_MNEMONIC_VCVTPS2PD,
        m_vcvtps2ph = ZYDIS_MNEMONIC_VCVTPS2PH,
        m_vcvtps2phx = ZYDIS_MNEMONIC_VCVTPS2PHX,
        m_vcvtps2qq = ZYDIS_MNEMONIC_VCVTPS2QQ,
        m_vcvtps2udq = ZYDIS_MNEMONIC_VCVTPS2UDQ,
        m_vcvtps2uqq = ZYDIS_MNEMONIC_VCVTPS2UQQ,
        m_vcvtqq2pd = ZYDIS_MNEMONIC_VCVTQQ2PD,
        m_vcvtqq2ph = ZYDIS_MNEMONIC_VCVTQQ2PH,
        m_vcvtqq2ps = ZYDIS_MNEMONIC_VCVTQQ2PS,
        m_vcvtsd2sh = ZYDIS_MNEMONIC_VCVTSD2SH,
        m_vcvtsd2si = ZYDIS_MNEMONIC_VCVTSD2SI,
        m_vcvtsd2ss = ZYDIS_MNEMONIC_VCVTSD2SS,
        m_vcvtsd2usi = ZYDIS_MNEMONIC_VCVTSD2USI,
        m_vcvtsh2sd = ZYDIS_MNEMONIC_VCVTSH2SD,
        m_vcvtsh2si = ZYDIS_MNEMONIC_VCVTSH2SI,
        m_vcvtsh2ss = ZYDIS_MNEMONIC_VCVTSH2SS,
        m_vcvtsh2usi = ZYDIS_MNEMONIC_VCVTSH2USI,
        m_vcvtsi2sd = ZYDIS_MNEMONIC_VCVTSI2SD,
        m_vcvtsi2sh = ZYDIS_MNEMONIC_VCVTSI2SH,
        m_vcvtsi2ss = ZYDIS_MNEMONIC_VCVTSI2SS,
        m_vcvtss2sd = ZYDIS_MNEMONIC_VCVTSS2SD,
        m_vcvtss2sh = ZYDIS_MNEMONIC_VCVTSS2SH,
        m_vcvtss2si = ZYDIS_MNEMONIC_VCVTSS2SI,
        m_vcvtss2usi = ZYDIS_MNEMONIC_VCVTSS2USI,
        m_vcvttpd2dq = ZYDIS_MNEMONIC_VCVTTPD2DQ,
        m_vcvttpd2qq = ZYDIS_MNEMONIC_VCVTTPD2QQ,
        m_vcvttpd2udq = ZYDIS_MNEMONIC_VCVTTPD2UDQ,
        m_vcvttpd2uqq = ZYDIS_MNEMONIC_VCVTTPD2UQQ,
        m_vcvttph2dq = ZYDIS_MNEMONIC_VCVTTPH2DQ,
        m_vcvttph2qq = ZYDIS_MNEMONIC_VCVTTPH2QQ,
        m_vcvttph2udq = ZYDIS_MNEMONIC_VCVTTPH2UDQ,
        m_vcvttph2uqq = ZYDIS_MNEMONIC_VCVTTPH2UQQ,
        m_vcvttph2uw = ZYDIS_MNEMONIC_VCVTTPH2UW,
        m_vcvttph2w = ZYDIS_MNEMONIC_VCVTTPH2W,
        m_vcvttps2dq = ZYDIS_MNEMONIC_VCVTTPS2DQ,
        m_vcvttps2qq = ZYDIS_MNEMONIC_VCVTTPS2QQ,
        m_vcvttps2udq = ZYDIS_MNEMONIC_VCVTTPS2UDQ,
        m_vcvttps2uqq = ZYDIS_MNEMONIC_VCVTTPS2UQQ,
        m_vcvttsd2si = ZYDIS_MNEMONIC_VCVTTSD2SI,
        m_vcvttsd2usi = ZYDIS_MNEMONIC_VCVTTSD2USI,
        m_vcvttsh2si = ZYDIS_MNEMONIC_VCVTTSH2SI,
        m_vcvttsh2usi = ZYDIS_MNEMONIC_VCVTTSH2USI,
        m_vcvttss2si = ZYDIS_MNEMONIC_VCVTTSS2SI,
        m_vcvttss2usi = ZYDIS_MNEMONIC_VCVTTSS2USI,
        m_vcvtudq2pd = ZYDIS_MNEMONIC_VCVTUDQ2PD,
        m_vcvtudq2ph = ZYDIS_MNEMONIC_VCVTUDQ2PH,
        m_vcvtudq2ps = ZYDIS_MNEMONIC_VCVTUDQ2PS,
        m_vcvtuqq2pd = ZYDIS_MNEMONIC_VCVTUQQ2PD,
        m_vcvtuqq2ph = ZYDIS_MNEMONIC_VCVTUQQ2PH,
        m_vcvtuqq2ps = ZYDIS_MNEMONIC_VCVTUQQ2PS,
        m_vcvtusi2sd = ZYDIS_MNEMONIC_VCVTUSI2SD,
        m_vcvtusi2sh = ZYDIS_MNEMONIC_VCVTUSI2SH,
        m_vcvtusi2ss = ZYDIS_MNEMONIC_VCVTUSI2SS,
        m_vcvtuw2ph = ZYDIS_MNEMONIC_VCVTUW2PH,
        m_vcvtw2ph = ZYDIS_MNEMONIC_VCVTW2PH,
        m_vdbpsadbw = ZYDIS_MNEMONIC_VDBPSADBW,
        m_vdivpd = ZYDIS_MNEMONIC_VDIVPD,
        m_vdivph = ZYDIS_MNEMONIC_VDIVPH,
        m_vdivps = ZYDIS_MNEMONIC_VDIVPS,
        m_vdivsd = ZYDIS_MNEMONIC_VDIVSD,
        m_vdivsh = ZYDIS_MNEMONIC_VDIVSH,
        m_vdivss = ZYDIS_MNEMONIC_VDIVSS,
        m_vdpbf16ps = ZYDIS_MNEMONIC_VDPBF16PS,
        m_vdppd = ZYDIS_MNEMONIC_VDPPD,
        m_vdpps = ZYDIS_MNEMONIC_VDPPS,
        m_verr = ZYDIS_MNEMONIC_VERR,
        m_verw = ZYDIS_MNEMONIC_VERW,
        m_vexp223ps = ZYDIS_MNEMONIC_VEXP223PS,
        m_vexp2pd = ZYDIS_MNEMONIC_VEXP2PD,
        m_vexp2ps = ZYDIS_MNEMONIC_VEXP2PS,
        m_vexpandpd = ZYDIS_MNEMONIC_VEXPANDPD,
        m_vexpandps = ZYDIS_MNEMONIC_VEXPANDPS,
        m_vextractf128 = ZYDIS_MNEMONIC_VEXTRACTF128,
        m_vextractf32x4 = ZYDIS_MNEMONIC_VEXTRACTF32X4,
        m_vextractf32x8 = ZYDIS_MNEMONIC_VEXTRACTF32X8,
        m_vextractf64x2 = ZYDIS_MNEMONIC_VEXTRACTF64X2,
        m_vextractf64x4 = ZYDIS_MNEMONIC_VEXTRACTF64X4,
        m_vextracti128 = ZYDIS_MNEMONIC_VEXTRACTI128,
        m_vextracti32x4 = ZYDIS_MNEMONIC_VEXTRACTI32X4,
        m_vextracti32x8 = ZYDIS_MNEMONIC_VEXTRACTI32X8,
        m_vextracti64x2 = ZYDIS_MNEMONIC_VEXTRACTI64X2,
        m_vextracti64x4 = ZYDIS_MNEMONIC_VEXTRACTI64X4,
        m_vextractps = ZYDIS_MNEMONIC_VEXTRACTPS,
        m_vfcmaddcph = ZYDIS_MNEMONIC_VFCMADDCPH,
        m_vfcmaddcsh = ZYDIS_MNEMONIC_VFCMADDCSH,
        m_vfcmulcph = ZYDIS_MNEMONIC_VFCMULCPH,
        m_vfcmulcsh = ZYDIS_MNEMONIC_VFCMULCSH,
        m_vfixupimmpd = ZYDIS_MNEMONIC_VFIXUPIMMPD,
        m_vfixupimmps = ZYDIS_MNEMONIC_VFIXUPIMMPS,
        m_vfixupimmsd = ZYDIS_MNEMONIC_VFIXUPIMMSD,
        m_vfixupimmss = ZYDIS_MNEMONIC_VFIXUPIMMSS,
        m_vfixupnanpd = ZYDIS_MNEMONIC_VFIXUPNANPD,
        m_vfixupnanps = ZYDIS_MNEMONIC_VFIXUPNANPS,
        m_vfmadd132pd = ZYDIS_MNEMONIC_VFMADD132PD,
        m_vfmadd132ph = ZYDIS_MNEMONIC_VFMADD132PH,
        m_vfmadd132ps = ZYDIS_MNEMONIC_VFMADD132PS,
        m_vfmadd132sd = ZYDIS_MNEMONIC_VFMADD132SD,
        m_vfmadd132sh = ZYDIS_MNEMONIC_VFMADD132SH,
        m_vfmadd132ss = ZYDIS_MNEMONIC_VFMADD132SS,
        m_vfmadd213pd = ZYDIS_MNEMONIC_VFMADD213PD,
        m_vfmadd213ph = ZYDIS_MNEMONIC_VFMADD213PH,
        m_vfmadd213ps = ZYDIS_MNEMONIC_VFMADD213PS,
        m_vfmadd213sd = ZYDIS_MNEMONIC_VFMADD213SD,
        m_vfmadd213sh = ZYDIS_MNEMONIC_VFMADD213SH,
        m_vfmadd213ss = ZYDIS_MNEMONIC_VFMADD213SS,
        m_vfmadd231pd = ZYDIS_MNEMONIC_VFMADD231PD,
        m_vfmadd231ph = ZYDIS_MNEMONIC_VFMADD231PH,
        m_vfmadd231ps = ZYDIS_MNEMONIC_VFMADD231PS,
        m_vfmadd231sd = ZYDIS_MNEMONIC_VFMADD231SD,
        m_vfmadd231sh = ZYDIS_MNEMONIC_VFMADD231SH,
        m_vfmadd231ss = ZYDIS_MNEMONIC_VFMADD231SS,
        m_vfmadd233ps = ZYDIS_MNEMONIC_VFMADD233PS,
        m_vfmaddcph = ZYDIS_MNEMONIC_VFMADDCPH,
        m_vfmaddcsh = ZYDIS_MNEMONIC_VFMADDCSH,
        m_vfmaddpd = ZYDIS_MNEMONIC_VFMADDPD,
        m_vfmaddps = ZYDIS_MNEMONIC_VFMADDPS,
        m_vfmaddsd = ZYDIS_MNEMONIC_VFMADDSD,
        m_vfmaddss = ZYDIS_MNEMONIC_VFMADDSS,
        m_vfmaddsub132pd = ZYDIS_MNEMONIC_VFMADDSUB132PD,
        m_vfmaddsub132ph = ZYDIS_MNEMONIC_VFMADDSUB132PH,
        m_vfmaddsub132ps = ZYDIS_MNEMONIC_VFMADDSUB132PS,
        m_vfmaddsub213pd = ZYDIS_MNEMONIC_VFMADDSUB213PD,
        m_vfmaddsub213ph = ZYDIS_MNEMONIC_VFMADDSUB213PH,
        m_vfmaddsub213ps = ZYDIS_MNEMONIC_VFMADDSUB213PS,
        m_vfmaddsub231pd = ZYDIS_MNEMONIC_VFMADDSUB231PD,
        m_vfmaddsub231ph = ZYDIS_MNEMONIC_VFMADDSUB231PH,
        m_vfmaddsub231ps = ZYDIS_MNEMONIC_VFMADDSUB231PS,
        m_vfmaddsubpd = ZYDIS_MNEMONIC_VFMADDSUBPD,
        m_vfmaddsubps = ZYDIS_MNEMONIC_VFMADDSUBPS,
        m_vfmsub132pd = ZYDIS_MNEMONIC_VFMSUB132PD,
        m_vfmsub132ph = ZYDIS_MNEMONIC_VFMSUB132PH,
        m_vfmsub132ps = ZYDIS_MNEMONIC_VFMSUB132PS,
        m_vfmsub132sd = ZYDIS_MNEMONIC_VFMSUB132SD,
        m_vfmsub132sh = ZYDIS_MNEMONIC_VFMSUB132SH,
        m_vfmsub132ss = ZYDIS_MNEMONIC_VFMSUB132SS,
        m_vfmsub213pd = ZYDIS_MNEMONIC_VFMSUB213PD,
        m_vfmsub213ph = ZYDIS_MNEMONIC_VFMSUB213PH,
        m_vfmsub213ps = ZYDIS_MNEMONIC_VFMSUB213PS,
        m_vfmsub213sd = ZYDIS_MNEMONIC_VFMSUB213SD,
        m_vfmsub213sh = ZYDIS_MNEMONIC_VFMSUB213SH,
        m_vfmsub213ss = ZYDIS_MNEMONIC_VFMSUB213SS,
        m_vfmsub231pd = ZYDIS_MNEMONIC_VFMSUB231PD,
        m_vfmsub231ph = ZYDIS_MNEMONIC_VFMSUB231PH,
        m_vfmsub231ps = ZYDIS_MNEMONIC_VFMSUB231PS,
        m_vfmsub231sd = ZYDIS_MNEMONIC_VFMSUB231SD,
        m_vfmsub231sh = ZYDIS_MNEMONIC_VFMSUB231SH,
        m_vfmsub231ss = ZYDIS_MNEMONIC_VFMSUB231SS,
        m_vfmsubadd132pd = ZYDIS_MNEMONIC_VFMSUBADD132PD,
        m_vfmsubadd132ph = ZYDIS_MNEMONIC_VFMSUBADD132PH,
        m_vfmsubadd132ps = ZYDIS_MNEMONIC_VFMSUBADD132PS,
        m_vfmsubadd213pd = ZYDIS_MNEMONIC_VFMSUBADD213PD,
        m_vfmsubadd213ph = ZYDIS_MNEMONIC_VFMSUBADD213PH,
        m_vfmsubadd213ps = ZYDIS_MNEMONIC_VFMSUBADD213PS,
        m_vfmsubadd231pd = ZYDIS_MNEMONIC_VFMSUBADD231PD,
        m_vfmsubadd231ph = ZYDIS_MNEMONIC_VFMSUBADD231PH,
        m_vfmsubadd231ps = ZYDIS_MNEMONIC_VFMSUBADD231PS,
        m_vfmsubaddpd = ZYDIS_MNEMONIC_VFMSUBADDPD,
        m_vfmsubaddps = ZYDIS_MNEMONIC_VFMSUBADDPS,
        m_vfmsubpd = ZYDIS_MNEMONIC_VFMSUBPD,
        m_vfmsubps = ZYDIS_MNEMONIC_VFMSUBPS,
        m_vfmsubsd = ZYDIS_MNEMONIC_VFMSUBSD,
        m_vfmsubss = ZYDIS_MNEMONIC_VFMSUBSS,
        m_vfmulcph = ZYDIS_MNEMONIC_VFMULCPH,
        m_vfmulcsh = ZYDIS_MNEMONIC_VFMULCSH,
        m_vfnmadd132pd = ZYDIS_MNEMONIC_VFNMADD132PD,
        m_vfnmadd132ph = ZYDIS_MNEMONIC_VFNMADD132PH,
        m_vfnmadd132ps = ZYDIS_MNEMONIC_VFNMADD132PS,
        m_vfnmadd132sd = ZYDIS_MNEMONIC_VFNMADD132SD,
        m_vfnmadd132sh = ZYDIS_MNEMONIC_VFNMADD132SH,
        m_vfnmadd132ss = ZYDIS_MNEMONIC_VFNMADD132SS,
        m_vfnmadd213pd = ZYDIS_MNEMONIC_VFNMADD213PD,
        m_vfnmadd213ph = ZYDIS_MNEMONIC_VFNMADD213PH,
        m_vfnmadd213ps = ZYDIS_MNEMONIC_VFNMADD213PS,
        m_vfnmadd213sd = ZYDIS_MNEMONIC_VFNMADD213SD,
        m_vfnmadd213sh = ZYDIS_MNEMONIC_VFNMADD213SH,
        m_vfnmadd213ss = ZYDIS_MNEMONIC_VFNMADD213SS,
        m_vfnmadd231pd = ZYDIS_MNEMONIC_VFNMADD231PD,
        m_vfnmadd231ph = ZYDIS_MNEMONIC_VFNMADD231PH,
        m_vfnmadd231ps = ZYDIS_MNEMONIC_VFNMADD231PS,
        m_vfnmadd231sd = ZYDIS_MNEMONIC_VFNMADD231SD,
        m_vfnmadd231sh = ZYDIS_MNEMONIC_VFNMADD231SH,
        m_vfnmadd231ss = ZYDIS_MNEMONIC_VFNMADD231SS,
        m_vfnmaddpd = ZYDIS_MNEMONIC_VFNMADDPD,
        m_vfnmaddps = ZYDIS_MNEMONIC_VFNMADDPS,
        m_vfnmaddsd = ZYDIS_MNEMONIC_VFNMADDSD,
        m_vfnmaddss = ZYDIS_MNEMONIC_VFNMADDSS,
        m_vfnmsub132pd = ZYDIS_MNEMONIC_VFNMSUB132PD,
        m_vfnmsub132ph = ZYDIS_MNEMONIC_VFNMSUB132PH,
        m_vfnmsub132ps = ZYDIS_MNEMONIC_VFNMSUB132PS,
        m_vfnmsub132sd = ZYDIS_MNEMONIC_VFNMSUB132SD,
        m_vfnmsub132sh = ZYDIS_MNEMONIC_VFNMSUB132SH,
        m_vfnmsub132ss = ZYDIS_MNEMONIC_VFNMSUB132SS,
        m_vfnmsub213pd = ZYDIS_MNEMONIC_VFNMSUB213PD,
        m_vfnmsub213ph = ZYDIS_MNEMONIC_VFNMSUB213PH,
        m_vfnmsub213ps = ZYDIS_MNEMONIC_VFNMSUB213PS,
        m_vfnmsub213sd = ZYDIS_MNEMONIC_VFNMSUB213SD,
        m_vfnmsub213sh = ZYDIS_MNEMONIC_VFNMSUB213SH,
        m_vfnmsub213ss = ZYDIS_MNEMONIC_VFNMSUB213SS,
        m_vfnmsub231pd = ZYDIS_MNEMONIC_VFNMSUB231PD,
        m_vfnmsub231ph = ZYDIS_MNEMONIC_VFNMSUB231PH,
        m_vfnmsub231ps = ZYDIS_MNEMONIC_VFNMSUB231PS,
        m_vfnmsub231sd = ZYDIS_MNEMONIC_VFNMSUB231SD,
        m_vfnmsub231sh = ZYDIS_MNEMONIC_VFNMSUB231SH,
        m_vfnmsub231ss = ZYDIS_MNEMONIC_VFNMSUB231SS,
        m_vfnmsubpd = ZYDIS_MNEMONIC_VFNMSUBPD,
        m_vfnmsubps = ZYDIS_MNEMONIC_VFNMSUBPS,
        m_vfnmsubsd = ZYDIS_MNEMONIC_VFNMSUBSD,
        m_vfnmsubss = ZYDIS_MNEMONIC_VFNMSUBSS,
        m_vfpclasspd = ZYDIS_MNEMONIC_VFPCLASSPD,
        m_vfpclassph = ZYDIS_MNEMONIC_VFPCLASSPH,
        m_vfpclassps = ZYDIS_MNEMONIC_VFPCLASSPS,
        m_vfpclasssd = ZYDIS_MNEMONIC_VFPCLASSSD,
        m_vfpclasssh = ZYDIS_MNEMONIC_VFPCLASSSH,
        m_vfpclassss = ZYDIS_MNEMONIC_VFPCLASSSS,
        m_vfrczpd = ZYDIS_MNEMONIC_VFRCZPD,
        m_vfrczps = ZYDIS_MNEMONIC_VFRCZPS,
        m_vfrczsd = ZYDIS_MNEMONIC_VFRCZSD,
        m_vfrczss = ZYDIS_MNEMONIC_VFRCZSS,
        m_vgatherdpd = ZYDIS_MNEMONIC_VGATHERDPD,
        m_vgatherdps = ZYDIS_MNEMONIC_VGATHERDPS,
        m_vgatherpf0dpd = ZYDIS_MNEMONIC_VGATHERPF0DPD,
        m_vgatherpf0dps = ZYDIS_MNEMONIC_VGATHERPF0DPS,
        m_vgatherpf0hintdpd = ZYDIS_MNEMONIC_VGATHERPF0HINTDPD,
        m_vgatherpf0hintdps = ZYDIS_MNEMONIC_VGATHERPF0HINTDPS,
        m_vgatherpf0qpd = ZYDIS_MNEMONIC_VGATHERPF0QPD,
        m_vgatherpf0qps = ZYDIS_MNEMONIC_VGATHERPF0QPS,
        m_vgatherpf1dpd = ZYDIS_MNEMONIC_VGATHERPF1DPD,
        m_vgatherpf1dps = ZYDIS_MNEMONIC_VGATHERPF1DPS,
        m_vgatherpf1qpd = ZYDIS_MNEMONIC_VGATHERPF1QPD,
        m_vgatherpf1qps = ZYDIS_MNEMONIC_VGATHERPF1QPS,
        m_vgatherqpd = ZYDIS_MNEMONIC_VGATHERQPD,
        m_vgatherqps = ZYDIS_MNEMONIC_VGATHERQPS,
        m_vgetexppd = ZYDIS_MNEMONIC_VGETEXPPD,
        m_vgetexpph = ZYDIS_MNEMONIC_VGETEXPPH,
        m_vgetexpps = ZYDIS_MNEMONIC_VGETEXPPS,
        m_vgetexpsd = ZYDIS_MNEMONIC_VGETEXPSD,
        m_vgetexpsh = ZYDIS_MNEMONIC_VGETEXPSH,
        m_vgetexpss = ZYDIS_MNEMONIC_VGETEXPSS,
        m_vgetmantpd = ZYDIS_MNEMONIC_VGETMANTPD,
        m_vgetmantph = ZYDIS_MNEMONIC_VGETMANTPH,
        m_vgetmantps = ZYDIS_MNEMONIC_VGETMANTPS,
        m_vgetmantsd = ZYDIS_MNEMONIC_VGETMANTSD,
        m_vgetmantsh = ZYDIS_MNEMONIC_VGETMANTSH,
        m_vgetmantss = ZYDIS_MNEMONIC_VGETMANTSS,
        m_vgf2p8affineinvqb = ZYDIS_MNEMONIC_VGF2P8AFFINEINVQB,
        m_vgf2p8affineqb = ZYDIS_MNEMONIC_VGF2P8AFFINEQB,
        m_vgf2p8mulb = ZYDIS_MNEMONIC_VGF2P8MULB,
        m_vgmaxabsps = ZYDIS_MNEMONIC_VGMAXABSPS,
        m_vgmaxpd = ZYDIS_MNEMONIC_VGMAXPD,
        m_vgmaxps = ZYDIS_MNEMONIC_VGMAXPS,
        m_vgminpd = ZYDIS_MNEMONIC_VGMINPD,
        m_vgminps = ZYDIS_MNEMONIC_VGMINPS,
        m_vhaddpd = ZYDIS_MNEMONIC_VHADDPD,
        m_vhaddps = ZYDIS_MNEMONIC_VHADDPS,
        m_vhsubpd = ZYDIS_MNEMONIC_VHSUBPD,
        m_vhsubps = ZYDIS_MNEMONIC_VHSUBPS,
        m_vinsertf128 = ZYDIS_MNEMONIC_VINSERTF128,
        m_vinsertf32x4 = ZYDIS_MNEMONIC_VINSERTF32X4,
        m_vinsertf32x8 = ZYDIS_MNEMONIC_VINSERTF32X8,
        m_vinsertf64x2 = ZYDIS_MNEMONIC_VINSERTF64X2,
        m_vinsertf64x4 = ZYDIS_MNEMONIC_VINSERTF64X4,
        m_vinserti128 = ZYDIS_MNEMONIC_VINSERTI128,
        m_vinserti32x4 = ZYDIS_MNEMONIC_VINSERTI32X4,
        m_vinserti32x8 = ZYDIS_MNEMONIC_VINSERTI32X8,
        m_vinserti64x2 = ZYDIS_MNEMONIC_VINSERTI64X2,
        m_vinserti64x4 = ZYDIS_MNEMONIC_VINSERTI64X4,
        m_vinsertps = ZYDIS_MNEMONIC_VINSERTPS,
        m_vlddqu = ZYDIS_MNEMONIC_VLDDQU,
        m_vldmxcsr = ZYDIS_MNEMONIC_VLDMXCSR,
        m_vloadunpackhd = ZYDIS_MNEMONIC_VLOADUNPACKHD,
        m_vloadunpackhpd = ZYDIS_MNEMONIC_VLOADUNPACKHPD,
        m_vloadunpackhps = ZYDIS_MNEMONIC_VLOADUNPACKHPS,
        m_vloadunpackhq = ZYDIS_MNEMONIC_VLOADUNPACKHQ,
        m_vloadunpackld = ZYDIS_MNEMONIC_VLOADUNPACKLD,
        m_vloadunpacklpd = ZYDIS_MNEMONIC_VLOADUNPACKLPD,
        m_vloadunpacklps = ZYDIS_MNEMONIC_VLOADUNPACKLPS,
        m_vloadunpacklq = ZYDIS_MNEMONIC_VLOADUNPACKLQ,
        m_vlog2ps = ZYDIS_MNEMONIC_VLOG2PS,
        m_vmaskmovdqu = ZYDIS_MNEMONIC_VMASKMOVDQU,
        m_vmaskmovpd = ZYDIS_MNEMONIC_VMASKMOVPD,
        m_vmaskmovps = ZYDIS_MNEMONIC_VMASKMOVPS,
        m_vmaxpd = ZYDIS_MNEMONIC_VMAXPD,
        m_vmaxph = ZYDIS_MNEMONIC_VMAXPH,
        m_vmaxps = ZYDIS_MNEMONIC_VMAXPS,
        m_vmaxsd = ZYDIS_MNEMONIC_VMAXSD,
        m_vmaxsh = ZYDIS_MNEMONIC_VMAXSH,
        m_vmaxss = ZYDIS_MNEMONIC_VMAXSS,
        m_vmcall = ZYDIS_MNEMONIC_VMCALL,
        m_vmclear = ZYDIS_MNEMONIC_VMCLEAR,
        m_vmfunc = ZYDIS_MNEMONIC_VMFUNC,
        m_vminpd = ZYDIS_MNEMONIC_VMINPD,
        m_vminph = ZYDIS_MNEMONIC_VMINPH,
        m_vminps = ZYDIS_MNEMONIC_VMINPS,
        m_vminsd = ZYDIS_MNEMONIC_VMINSD,
        m_vminsh = ZYDIS_MNEMONIC_VMINSH,
        m_vminss = ZYDIS_MNEMONIC_VMINSS,
        m_vmlaunch = ZYDIS_MNEMONIC_VMLAUNCH,
        m_vmload = ZYDIS_MNEMONIC_VMLOAD,
        m_vmmcall = ZYDIS_MNEMONIC_VMMCALL,
        m_vmovapd = ZYDIS_MNEMONIC_VMOVAPD,
        m_vmovaps = ZYDIS_MNEMONIC_VMOVAPS,
        m_vmovd = ZYDIS_MNEMONIC_VMOVD,
        m_vmovddup = ZYDIS_MNEMONIC_VMOVDDUP,
        m_vmovdqa = ZYDIS_MNEMONIC_VMOVDQA,
        m_vmovdqa32 = ZYDIS_MNEMONIC_VMOVDQA32,
        m_vmovdqa64 = ZYDIS_MNEMONIC_VMOVDQA64,
        m_vmovdqu = ZYDIS_MNEMONIC_VMOVDQU,
        m_vmovdqu16 = ZYDIS_MNEMONIC_VMOVDQU16,
        m_vmovdqu32 = ZYDIS_MNEMONIC_VMOVDQU32,
        m_vmovdqu64 = ZYDIS_MNEMONIC_VMOVDQU64,
        m_vmovdqu8 = ZYDIS_MNEMONIC_VMOVDQU8,
        m_vmovhlps = ZYDIS_MNEMONIC_VMOVHLPS,
        m_vmovhpd = ZYDIS_MNEMONIC_VMOVHPD,
        m_vmovhps = ZYDIS_MNEMONIC_VMOVHPS,
        m_vmovlhps = ZYDIS_MNEMONIC_VMOVLHPS,
        m_vmovlpd = ZYDIS_MNEMONIC_VMOVLPD,
        m_vmovlps = ZYDIS_MNEMONIC_VMOVLPS,
        m_vmovmskpd = ZYDIS_MNEMONIC_VMOVMSKPD,
        m_vmovmskps = ZYDIS_MNEMONIC_VMOVMSKPS,
        m_vmovnrapd = ZYDIS_MNEMONIC_VMOVNRAPD,
        m_vmovnraps = ZYDIS_MNEMONIC_VMOVNRAPS,
        m_vmovnrngoapd = ZYDIS_MNEMONIC_VMOVNRNGOAPD,
        m_vmovnrngoaps = ZYDIS_MNEMONIC_VMOVNRNGOAPS,
        m_vmovntdq = ZYDIS_MNEMONIC_VMOVNTDQ,
        m_vmovntdqa = ZYDIS_MNEMONIC_VMOVNTDQA,
        m_vmovntpd = ZYDIS_MNEMONIC_VMOVNTPD,
        m_vmovntps = ZYDIS_MNEMONIC_VMOVNTPS,
        m_vmovq = ZYDIS_MNEMONIC_VMOVQ,
        m_vmovsd = ZYDIS_MNEMONIC_VMOVSD,
        m_vmovsh = ZYDIS_MNEMONIC_VMOVSH,
        m_vmovshdup = ZYDIS_MNEMONIC_VMOVSHDUP,
        m_vmovsldup = ZYDIS_MNEMONIC_VMOVSLDUP,
        m_vmovss = ZYDIS_MNEMONIC_VMOVSS,
        m_vmovupd = ZYDIS_MNEMONIC_VMOVUPD,
        m_vmovups = ZYDIS_MNEMONIC_VMOVUPS,
        m_vmovw = ZYDIS_MNEMONIC_VMOVW,
        m_vmpsadbw = ZYDIS_MNEMONIC_VMPSADBW,
        m_vmptrld = ZYDIS_MNEMONIC_VMPTRLD,
        m_vmptrst = ZYDIS_MNEMONIC_VMPTRST,
        m_vmread = ZYDIS_MNEMONIC_VMREAD,
        m_vmresume = ZYDIS_MNEMONIC_VMRESUME,
        m_vmrun = ZYDIS_MNEMONIC_VMRUN,
        m_vmsave = ZYDIS_MNEMONIC_VMSAVE,
        m_vmulpd = ZYDIS_MNEMONIC_VMULPD,
        m_vmulph = ZYDIS_MNEMONIC_VMULPH,
        m_vmulps = ZYDIS_MNEMONIC_VMULPS,
        m_vmulsd = ZYDIS_MNEMONIC_VMULSD,
        m_vmulsh = ZYDIS_MNEMONIC_VMULSH,
        m_vmulss = ZYDIS_MNEMONIC_VMULSS,
        m_vmwrite = ZYDIS_MNEMONIC_VMWRITE,
        m_vmxoff = ZYDIS_MNEMONIC_VMXOFF,
        m_vmxon = ZYDIS_MNEMONIC_VMXON,
        m_vorpd = ZYDIS_MNEMONIC_VORPD,
        m_vorps = ZYDIS_MNEMONIC_VORPS,
        m_vp2intersectd = ZYDIS_MNEMONIC_VP2INTERSECTD,
        m_vp2intersectq = ZYDIS_MNEMONIC_VP2INTERSECTQ,
        m_vp4dpwssd = ZYDIS_MNEMONIC_VP4DPWSSD,
        m_vp4dpwssds = ZYDIS_MNEMONIC_VP4DPWSSDS,
        m_vpabsb = ZYDIS_MNEMONIC_VPABSB,
        m_vpabsd = ZYDIS_MNEMONIC_VPABSD,
        m_vpabsq = ZYDIS_MNEMONIC_VPABSQ,
        m_vpabsw = ZYDIS_MNEMONIC_VPABSW,
        m_vpackssdw = ZYDIS_MNEMONIC_VPACKSSDW,
        m_vpacksswb = ZYDIS_MNEMONIC_VPACKSSWB,
        m_vpackstorehd = ZYDIS_MNEMONIC_VPACKSTOREHD,
        m_vpackstorehpd = ZYDIS_MNEMONIC_VPACKSTOREHPD,
        m_vpackstorehps = ZYDIS_MNEMONIC_VPACKSTOREHPS,
        m_vpackstorehq = ZYDIS_MNEMONIC_VPACKSTOREHQ,
        m_vpackstoreld = ZYDIS_MNEMONIC_VPACKSTORELD,
        m_vpackstorelpd = ZYDIS_MNEMONIC_VPACKSTORELPD,
        m_vpackstorelps = ZYDIS_MNEMONIC_VPACKSTORELPS,
        m_vpackstorelq = ZYDIS_MNEMONIC_VPACKSTORELQ,
        m_vpackusdw = ZYDIS_MNEMONIC_VPACKUSDW,
        m_vpackuswb = ZYDIS_MNEMONIC_VPACKUSWB,
        m_vpadcd = ZYDIS_MNEMONIC_VPADCD,
        m_vpaddb = ZYDIS_MNEMONIC_VPADDB,
        m_vpaddd = ZYDIS_MNEMONIC_VPADDD,
        m_vpaddq = ZYDIS_MNEMONIC_VPADDQ,
        m_vpaddsb = ZYDIS_MNEMONIC_VPADDSB,
        m_vpaddsetcd = ZYDIS_MNEMONIC_VPADDSETCD,
        m_vpaddsetsd = ZYDIS_MNEMONIC_VPADDSETSD,
        m_vpaddsw = ZYDIS_MNEMONIC_VPADDSW,
        m_vpaddusb = ZYDIS_MNEMONIC_VPADDUSB,
        m_vpaddusw = ZYDIS_MNEMONIC_VPADDUSW,
        m_vpaddw = ZYDIS_MNEMONIC_VPADDW,
        m_vpalignr = ZYDIS_MNEMONIC_VPALIGNR,
        m_vpand = ZYDIS_MNEMONIC_VPAND,
        m_vpandd = ZYDIS_MNEMONIC_VPANDD,
        m_vpandn = ZYDIS_MNEMONIC_VPANDN,
        m_vpandnd = ZYDIS_MNEMONIC_VPANDND,
        m_vpandnq = ZYDIS_MNEMONIC_VPANDNQ,
        m_vpandq = ZYDIS_MNEMONIC_VPANDQ,
        m_vpavgb = ZYDIS_MNEMONIC_VPAVGB,
        m_vpavgw = ZYDIS_MNEMONIC_VPAVGW,
        m_vpblendd = ZYDIS_MNEMONIC_VPBLENDD,
        m_vpblendmb = ZYDIS_MNEMONIC_VPBLENDMB,
        m_vpblendmd = ZYDIS_MNEMONIC_VPBLENDMD,
        m_vpblendmq = ZYDIS_MNEMONIC_VPBLENDMQ,
        m_vpblendmw = ZYDIS_MNEMONIC_VPBLENDMW,
        m_vpblendvb = ZYDIS_MNEMONIC_VPBLENDVB,
        m_vpblendw = ZYDIS_MNEMONIC_VPBLENDW,
        m_vpbroadcastb = ZYDIS_MNEMONIC_VPBROADCASTB,
        m_vpbroadcastd = ZYDIS_MNEMONIC_VPBROADCASTD,
        m_vpbroadcastmb2q = ZYDIS_MNEMONIC_VPBROADCASTMB2Q,
        m_vpbroadcastmw2d = ZYDIS_MNEMONIC_VPBROADCASTMW2D,
        m_vpbroadcastq = ZYDIS_MNEMONIC_VPBROADCASTQ,
        m_vpbroadcastw = ZYDIS_MNEMONIC_VPBROADCASTW,
        m_vpclmulqdq = ZYDIS_MNEMONIC_VPCLMULQDQ,
        m_vpcmov = ZYDIS_MNEMONIC_VPCMOV,
        m_vpcmpb = ZYDIS_MNEMONIC_VPCMPB,
        m_vpcmpd = ZYDIS_MNEMONIC_VPCMPD,
        m_vpcmpeqb = ZYDIS_MNEMONIC_VPCMPEQB,
        m_vpcmpeqd = ZYDIS_MNEMONIC_VPCMPEQD,
        m_vpcmpeqq = ZYDIS_MNEMONIC_VPCMPEQQ,
        m_vpcmpeqw = ZYDIS_MNEMONIC_VPCMPEQW,
        m_vpcmpestri = ZYDIS_MNEMONIC_VPCMPESTRI,
        m_vpcmpestrm = ZYDIS_MNEMONIC_VPCMPESTRM,
        m_vpcmpgtb = ZYDIS_MNEMONIC_VPCMPGTB,
        m_vpcmpgtd = ZYDIS_MNEMONIC_VPCMPGTD,
        m_vpcmpgtq = ZYDIS_MNEMONIC_VPCMPGTQ,
        m_vpcmpgtw = ZYDIS_MNEMONIC_VPCMPGTW,
        m_vpcmpistri = ZYDIS_MNEMONIC_VPCMPISTRI,
        m_vpcmpistrm = ZYDIS_MNEMONIC_VPCMPISTRM,
        m_vpcmpltd = ZYDIS_MNEMONIC_VPCMPLTD,
        m_vpcmpq = ZYDIS_MNEMONIC_VPCMPQ,
        m_vpcmpub = ZYDIS_MNEMONIC_VPCMPUB,
        m_vpcmpud = ZYDIS_MNEMONIC_VPCMPUD,
        m_vpcmpuq = ZYDIS_MNEMONIC_VPCMPUQ,
        m_vpcmpuw = ZYDIS_MNEMONIC_VPCMPUW,
        m_vpcmpw = ZYDIS_MNEMONIC_VPCMPW,
        m_vpcomb = ZYDIS_MNEMONIC_VPCOMB,
        m_vpcomd = ZYDIS_MNEMONIC_VPCOMD,
        m_vpcompressb = ZYDIS_MNEMONIC_VPCOMPRESSB,
        m_vpcompressd = ZYDIS_MNEMONIC_VPCOMPRESSD,
        m_vpcompressq = ZYDIS_MNEMONIC_VPCOMPRESSQ,
        m_vpcompressw = ZYDIS_MNEMONIC_VPCOMPRESSW,
        m_vpcomq = ZYDIS_MNEMONIC_VPCOMQ,
        m_vpcomub = ZYDIS_MNEMONIC_VPCOMUB,
        m_vpcomud = ZYDIS_MNEMONIC_VPCOMUD,
        m_vpcomuq = ZYDIS_MNEMONIC_VPCOMUQ,
        m_vpcomuw = ZYDIS_MNEMONIC_VPCOMUW,
        m_vpcomw = ZYDIS_MNEMONIC_VPCOMW,
        m_vpconflictd = ZYDIS_MNEMONIC_VPCONFLICTD,
        m_vpconflictq = ZYDIS_MNEMONIC_VPCONFLICTQ,
        m_vpdpbssd = ZYDIS_MNEMONIC_VPDPBSSD,
        m_vpdpbssds = ZYDIS_MNEMONIC_VPDPBSSDS,
        m_vpdpbsud = ZYDIS_MNEMONIC_VPDPBSUD,
        m_vpdpbsuds = ZYDIS_MNEMONIC_VPDPBSUDS,
        m_vpdpbusd = ZYDIS_MNEMONIC_VPDPBUSD,
        m_vpdpbusds = ZYDIS_MNEMONIC_VPDPBUSDS,
        m_vpdpbuud = ZYDIS_MNEMONIC_VPDPBUUD,
        m_vpdpbuuds = ZYDIS_MNEMONIC_VPDPBUUDS,
        m_vpdpwssd = ZYDIS_MNEMONIC_VPDPWSSD,
        m_vpdpwssds = ZYDIS_MNEMONIC_VPDPWSSDS,
        m_vpdpwsud = ZYDIS_MNEMONIC_VPDPWSUD,
        m_vpdpwsuds = ZYDIS_MNEMONIC_VPDPWSUDS,
        m_vpdpwusd = ZYDIS_MNEMONIC_VPDPWUSD,
        m_vpdpwusds = ZYDIS_MNEMONIC_VPDPWUSDS,
        m_vpdpwuud = ZYDIS_MNEMONIC_VPDPWUUD,
        m_vpdpwuuds = ZYDIS_MNEMONIC_VPDPWUUDS,
        m_vperm2f128 = ZYDIS_MNEMONIC_VPERM2F128,
        m_vperm2i128 = ZYDIS_MNEMONIC_VPERM2I128,
        m_vpermb = ZYDIS_MNEMONIC_VPERMB,
        m_vpermd = ZYDIS_MNEMONIC_VPERMD,
        m_vpermf32x4 = ZYDIS_MNEMONIC_VPERMF32X4,
        m_vpermi2b = ZYDIS_MNEMONIC_VPERMI2B,
        m_vpermi2d = ZYDIS_MNEMONIC_VPERMI2D,
        m_vpermi2pd = ZYDIS_MNEMONIC_VPERMI2PD,
        m_vpermi2ps = ZYDIS_MNEMONIC_VPERMI2PS,
        m_vpermi2q = ZYDIS_MNEMONIC_VPERMI2Q,
        m_vpermi2w = ZYDIS_MNEMONIC_VPERMI2W,
        m_vpermil2pd = ZYDIS_MNEMONIC_VPERMIL2PD,
        m_vpermil2ps = ZYDIS_MNEMONIC_VPERMIL2PS,
        m_vpermilpd = ZYDIS_MNEMONIC_VPERMILPD,
        m_vpermilps = ZYDIS_MNEMONIC_VPERMILPS,
        m_vpermpd = ZYDIS_MNEMONIC_VPERMPD,
        m_vpermps = ZYDIS_MNEMONIC_VPERMPS,
        m_vpermq = ZYDIS_MNEMONIC_VPERMQ,
        m_vpermt2b = ZYDIS_MNEMONIC_VPERMT2B,
        m_vpermt2d = ZYDIS_MNEMONIC_VPERMT2D,
        m_vpermt2pd = ZYDIS_MNEMONIC_VPERMT2PD,
        m_vpermt2ps = ZYDIS_MNEMONIC_VPERMT2PS,
        m_vpermt2q = ZYDIS_MNEMONIC_VPERMT2Q,
        m_vpermt2w = ZYDIS_MNEMONIC_VPERMT2W,
        m_vpermw = ZYDIS_MNEMONIC_VPERMW,
        m_vpexpandb = ZYDIS_MNEMONIC_VPEXPANDB,
        m_vpexpandd = ZYDIS_MNEMONIC_VPEXPANDD,
        m_vpexpandq = ZYDIS_MNEMONIC_VPEXPANDQ,
        m_vpexpandw = ZYDIS_MNEMONIC_VPEXPANDW,
        m_vpextrb = ZYDIS_MNEMONIC_VPEXTRB,
        m_vpextrd = ZYDIS_MNEMONIC_VPEXTRD,
        m_vpextrq = ZYDIS_MNEMONIC_VPEXTRQ,
        m_vpextrw = ZYDIS_MNEMONIC_VPEXTRW,
        m_vpgatherdd = ZYDIS_MNEMONIC_VPGATHERDD,
        m_vpgatherdq = ZYDIS_MNEMONIC_VPGATHERDQ,
        m_vpgatherqd = ZYDIS_MNEMONIC_VPGATHERQD,
        m_vpgatherqq = ZYDIS_MNEMONIC_VPGATHERQQ,
        m_vphaddbd = ZYDIS_MNEMONIC_VPHADDBD,
        m_vphaddbq = ZYDIS_MNEMONIC_VPHADDBQ,
        m_vphaddbw = ZYDIS_MNEMONIC_VPHADDBW,
        m_vphaddd = ZYDIS_MNEMONIC_VPHADDD,
        m_vphadddq = ZYDIS_MNEMONIC_VPHADDDQ,
        m_vphaddsw = ZYDIS_MNEMONIC_VPHADDSW,
        m_vphaddubd = ZYDIS_MNEMONIC_VPHADDUBD,
        m_vphaddubq = ZYDIS_MNEMONIC_VPHADDUBQ,
        m_vphaddubw = ZYDIS_MNEMONIC_VPHADDUBW,
        m_vphaddudq = ZYDIS_MNEMONIC_VPHADDUDQ,
        m_vphadduwd = ZYDIS_MNEMONIC_VPHADDUWD,
        m_vphadduwq = ZYDIS_MNEMONIC_VPHADDUWQ,
        m_vphaddw = ZYDIS_MNEMONIC_VPHADDW,
        m_vphaddwd = ZYDIS_MNEMONIC_VPHADDWD,
        m_vphaddwq = ZYDIS_MNEMONIC_VPHADDWQ,
        m_vphminposuw = ZYDIS_MNEMONIC_VPHMINPOSUW,
        m_vphsubbw = ZYDIS_MNEMONIC_VPHSUBBW,
        m_vphsubd = ZYDIS_MNEMONIC_VPHSUBD,
        m_vphsubdq = ZYDIS_MNEMONIC_VPHSUBDQ,
        m_vphsubsw = ZYDIS_MNEMONIC_VPHSUBSW,
        m_vphsubw = ZYDIS_MNEMONIC_VPHSUBW,
        m_vphsubwd = ZYDIS_MNEMONIC_VPHSUBWD,
        m_vpinsrb = ZYDIS_MNEMONIC_VPINSRB,
        m_vpinsrd = ZYDIS_MNEMONIC_VPINSRD,
        m_vpinsrq = ZYDIS_MNEMONIC_VPINSRQ,
        m_vpinsrw = ZYDIS_MNEMONIC_VPINSRW,
        m_vplzcntd = ZYDIS_MNEMONIC_VPLZCNTD,
        m_vplzcntq = ZYDIS_MNEMONIC_VPLZCNTQ,
        m_vpmacsdd = ZYDIS_MNEMONIC_VPMACSDD,
        m_vpmacsdqh = ZYDIS_MNEMONIC_VPMACSDQH,
        m_vpmacsdql = ZYDIS_MNEMONIC_VPMACSDQL,
        m_vpmacssdd = ZYDIS_MNEMONIC_VPMACSSDD,
        m_vpmacssdqh = ZYDIS_MNEMONIC_VPMACSSDQH,
        m_vpmacssdql = ZYDIS_MNEMONIC_VPMACSSDQL,
        m_vpmacsswd = ZYDIS_MNEMONIC_VPMACSSWD,
        m_vpmacssww = ZYDIS_MNEMONIC_VPMACSSWW,
        m_vpmacswd = ZYDIS_MNEMONIC_VPMACSWD,
        m_vpmacsww = ZYDIS_MNEMONIC_VPMACSWW,
        m_vpmadcsswd = ZYDIS_MNEMONIC_VPMADCSSWD,
        m_vpmadcswd = ZYDIS_MNEMONIC_VPMADCSWD,
        m_vpmadd231d = ZYDIS_MNEMONIC_VPMADD231D,
        m_vpmadd233d = ZYDIS_MNEMONIC_VPMADD233D,
        m_vpmadd52huq = ZYDIS_MNEMONIC_VPMADD52HUQ,
        m_vpmadd52luq = ZYDIS_MNEMONIC_VPMADD52LUQ,
        m_vpmaddubsw = ZYDIS_MNEMONIC_VPMADDUBSW,
        m_vpmaddwd = ZYDIS_MNEMONIC_VPMADDWD,
        m_vpmaskmovd = ZYDIS_MNEMONIC_VPMASKMOVD,
        m_vpmaskmovq = ZYDIS_MNEMONIC_VPMASKMOVQ,
        m_vpmaxsb = ZYDIS_MNEMONIC_VPMAXSB,
        m_vpmaxsd = ZYDIS_MNEMONIC_VPMAXSD,
        m_vpmaxsq = ZYDIS_MNEMONIC_VPMAXSQ,
        m_vpmaxsw = ZYDIS_MNEMONIC_VPMAXSW,
        m_vpmaxub = ZYDIS_MNEMONIC_VPMAXUB,
        m_vpmaxud = ZYDIS_MNEMONIC_VPMAXUD,
        m_vpmaxuq = ZYDIS_MNEMONIC_VPMAXUQ,
        m_vpmaxuw = ZYDIS_MNEMONIC_VPMAXUW,
        m_vpminsb = ZYDIS_MNEMONIC_VPMINSB,
        m_vpminsd = ZYDIS_MNEMONIC_VPMINSD,
        m_vpminsq = ZYDIS_MNEMONIC_VPMINSQ,
        m_vpminsw = ZYDIS_MNEMONIC_VPMINSW,
        m_vpminub = ZYDIS_MNEMONIC_VPMINUB,
        m_vpminud = ZYDIS_MNEMONIC_VPMINUD,
        m_vpminuq = ZYDIS_MNEMONIC_VPMINUQ,
        m_vpminuw = ZYDIS_MNEMONIC_VPMINUW,
        m_vpmovb2m = ZYDIS_MNEMONIC_VPMOVB2M,
        m_vpmovd2m = ZYDIS_MNEMONIC_VPMOVD2M,
        m_vpmovdb = ZYDIS_MNEMONIC_VPMOVDB,
        m_vpmovdw = ZYDIS_MNEMONIC_VPMOVDW,
        m_vpmovm2b = ZYDIS_MNEMONIC_VPMOVM2B,
        m_vpmovm2d = ZYDIS_MNEMONIC_VPMOVM2D,
        m_vpmovm2q = ZYDIS_MNEMONIC_VPMOVM2Q,
        m_vpmovm2w = ZYDIS_MNEMONIC_VPMOVM2W,
        m_vpmovmskb = ZYDIS_MNEMONIC_VPMOVMSKB,
        m_vpmovq2m = ZYDIS_MNEMONIC_VPMOVQ2M,
        m_vpmovqb = ZYDIS_MNEMONIC_VPMOVQB,
        m_vpmovqd = ZYDIS_MNEMONIC_VPMOVQD,
        m_vpmovqw = ZYDIS_MNEMONIC_VPMOVQW,
        m_vpmovsdb = ZYDIS_MNEMONIC_VPMOVSDB,
        m_vpmovsdw = ZYDIS_MNEMONIC_VPMOVSDW,
        m_vpmovsqb = ZYDIS_MNEMONIC_VPMOVSQB,
        m_vpmovsqd = ZYDIS_MNEMONIC_VPMOVSQD,
        m_vpmovsqw = ZYDIS_MNEMONIC_VPMOVSQW,
        m_vpmovswb = ZYDIS_MNEMONIC_VPMOVSWB,
        m_vpmovsxbd = ZYDIS_MNEMONIC_VPMOVSXBD,
        m_vpmovsxbq = ZYDIS_MNEMONIC_VPMOVSXBQ,
        m_vpmovsxbw = ZYDIS_MNEMONIC_VPMOVSXBW,
        m_vpmovsxdq = ZYDIS_MNEMONIC_VPMOVSXDQ,
        m_vpmovsxwd = ZYDIS_MNEMONIC_VPMOVSXWD,
        m_vpmovsxwq = ZYDIS_MNEMONIC_VPMOVSXWQ,
        m_vpmovusdb = ZYDIS_MNEMONIC_VPMOVUSDB,
        m_vpmovusdw = ZYDIS_MNEMONIC_VPMOVUSDW,
        m_vpmovusqb = ZYDIS_MNEMONIC_VPMOVUSQB,
        m_vpmovusqd = ZYDIS_MNEMONIC_VPMOVUSQD,
        m_vpmovusqw = ZYDIS_MNEMONIC_VPMOVUSQW,
        m_vpmovuswb = ZYDIS_MNEMONIC_VPMOVUSWB,
        m_vpmovw2m = ZYDIS_MNEMONIC_VPMOVW2M,
        m_vpmovwb = ZYDIS_MNEMONIC_VPMOVWB,
        m_vpmovzxbd = ZYDIS_MNEMONIC_VPMOVZXBD,
        m_vpmovzxbq = ZYDIS_MNEMONIC_VPMOVZXBQ,
        m_vpmovzxbw = ZYDIS_MNEMONIC_VPMOVZXBW,
        m_vpmovzxdq = ZYDIS_MNEMONIC_VPMOVZXDQ,
        m_vpmovzxwd = ZYDIS_MNEMONIC_VPMOVZXWD,
        m_vpmovzxwq = ZYDIS_MNEMONIC_VPMOVZXWQ,
        m_vpmuldq = ZYDIS_MNEMONIC_VPMULDQ,
        m_vpmulhd = ZYDIS_MNEMONIC_VPMULHD,
        m_vpmulhrsw = ZYDIS_MNEMONIC_VPMULHRSW,
        m_vpmulhud = ZYDIS_MNEMONIC_VPMULHUD,
        m_vpmulhuw = ZYDIS_MNEMONIC_VPMULHUW,
        m_vpmulhw = ZYDIS_MNEMONIC_VPMULHW,
        m_vpmulld = ZYDIS_MNEMONIC_VPMULLD,
        m_vpmullq = ZYDIS_MNEMONIC_VPMULLQ,
        m_vpmullw = ZYDIS_MNEMONIC_VPMULLW,
        m_vpmultishiftqb = ZYDIS_MNEMONIC_VPMULTISHIFTQB,
        m_vpmuludq = ZYDIS_MNEMONIC_VPMULUDQ,
        m_vpopcntb = ZYDIS_MNEMONIC_VPOPCNTB,
        m_vpopcntd = ZYDIS_MNEMONIC_VPOPCNTD,
        m_vpopcntq = ZYDIS_MNEMONIC_VPOPCNTQ,
        m_vpopcntw = ZYDIS_MNEMONIC_VPOPCNTW,
        m_vpor = ZYDIS_MNEMONIC_VPOR,
        m_vpord = ZYDIS_MNEMONIC_VPORD,
        m_vporq = ZYDIS_MNEMONIC_VPORQ,
        m_vpperm = ZYDIS_MNEMONIC_VPPERM,
        m_vprefetch0 = ZYDIS_MNEMONIC_VPREFETCH0,
        m_vprefetch1 = ZYDIS_MNEMONIC_VPREFETCH1,
        m_vprefetch2 = ZYDIS_MNEMONIC_VPREFETCH2,
        m_vprefetche0 = ZYDIS_MNEMONIC_VPREFETCHE0,
        m_vprefetche1 = ZYDIS_MNEMONIC_VPREFETCHE1,
        m_vprefetche2 = ZYDIS_MNEMONIC_VPREFETCHE2,
        m_vprefetchenta = ZYDIS_MNEMONIC_VPREFETCHENTA,
        m_vprefetchnta = ZYDIS_MNEMONIC_VPREFETCHNTA,
        m_vprold = ZYDIS_MNEMONIC_VPROLD,
        m_vprolq = ZYDIS_MNEMONIC_VPROLQ,
        m_vprolvd = ZYDIS_MNEMONIC_VPROLVD,
        m_vprolvq = ZYDIS_MNEMONIC_VPROLVQ,
        m_vprord = ZYDIS_MNEMONIC_VPRORD,
        m_vprorq = ZYDIS_MNEMONIC_VPRORQ,
        m_vprorvd = ZYDIS_MNEMONIC_VPRORVD,
        m_vprorvq = ZYDIS_MNEMONIC_VPRORVQ,
        m_vprotb = ZYDIS_MNEMONIC_VPROTB,
        m_vprotd = ZYDIS_MNEMONIC_VPROTD,
        m_vprotq = ZYDIS_MNEMONIC_VPROTQ,
        m_vprotw = ZYDIS_MNEMONIC_VPROTW,
        m_vpsadbw = ZYDIS_MNEMONIC_VPSADBW,
        m_vpsbbd = ZYDIS_MNEMONIC_VPSBBD,
        m_vpsbbrd = ZYDIS_MNEMONIC_VPSBBRD,
        m_vpscatterdd = ZYDIS_MNEMONIC_VPSCATTERDD,
        m_vpscatterdq = ZYDIS_MNEMONIC_VPSCATTERDQ,
        m_vpscatterqd = ZYDIS_MNEMONIC_VPSCATTERQD,
        m_vpscatterqq = ZYDIS_MNEMONIC_VPSCATTERQQ,
        m_vpshab = ZYDIS_MNEMONIC_VPSHAB,
        m_vpshad = ZYDIS_MNEMONIC_VPSHAD,
        m_vpshaq = ZYDIS_MNEMONIC_VPSHAQ,
        m_vpshaw = ZYDIS_MNEMONIC_VPSHAW,
        m_vpshlb = ZYDIS_MNEMONIC_VPSHLB,
        m_vpshld = ZYDIS_MNEMONIC_VPSHLD,
        m_vpshldd = ZYDIS_MNEMONIC_VPSHLDD,
        m_vpshldq = ZYDIS_MNEMONIC_VPSHLDQ,
        m_vpshldvd = ZYDIS_MNEMONIC_VPSHLDVD,
        m_vpshldvq = ZYDIS_MNEMONIC_VPSHLDVQ,
        m_vpshldvw = ZYDIS_MNEMONIC_VPSHLDVW,
        m_vpshldw = ZYDIS_MNEMONIC_VPSHLDW,
        m_vpshlq = ZYDIS_MNEMONIC_VPSHLQ,
        m_vpshlw = ZYDIS_MNEMONIC_VPSHLW,
        m_vpshrdd = ZYDIS_MNEMONIC_VPSHRDD,
        m_vpshrdq = ZYDIS_MNEMONIC_VPSHRDQ,
        m_vpshrdvd = ZYDIS_MNEMONIC_VPSHRDVD,
        m_vpshrdvq = ZYDIS_MNEMONIC_VPSHRDVQ,
        m_vpshrdvw = ZYDIS_MNEMONIC_VPSHRDVW,
        m_vpshrdw = ZYDIS_MNEMONIC_VPSHRDW,
        m_vpshufb = ZYDIS_MNEMONIC_VPSHUFB,
        m_vpshufbitqmb = ZYDIS_MNEMONIC_VPSHUFBITQMB,
        m_vpshufd = ZYDIS_MNEMONIC_VPSHUFD,
        m_vpshufhw = ZYDIS_MNEMONIC_VPSHUFHW,
        m_vpshuflw = ZYDIS_MNEMONIC_VPSHUFLW,
        m_vpsignb = ZYDIS_MNEMONIC_VPSIGNB,
        m_vpsignd = ZYDIS_MNEMONIC_VPSIGND,
        m_vpsignw = ZYDIS_MNEMONIC_VPSIGNW,
        m_vpslld = ZYDIS_MNEMONIC_VPSLLD,
        m_vpslldq = ZYDIS_MNEMONIC_VPSLLDQ,
        m_vpsllq = ZYDIS_MNEMONIC_VPSLLQ,
        m_vpsllvd = ZYDIS_MNEMONIC_VPSLLVD,
        m_vpsllvq = ZYDIS_MNEMONIC_VPSLLVQ,
        m_vpsllvw = ZYDIS_MNEMONIC_VPSLLVW,
        m_vpsllw = ZYDIS_MNEMONIC_VPSLLW,
        m_vpsrad = ZYDIS_MNEMONIC_VPSRAD,
        m_vpsraq = ZYDIS_MNEMONIC_VPSRAQ,
        m_vpsravd = ZYDIS_MNEMONIC_VPSRAVD,
        m_vpsravq = ZYDIS_MNEMONIC_VPSRAVQ,
        m_vpsravw = ZYDIS_MNEMONIC_VPSRAVW,
        m_vpsraw = ZYDIS_MNEMONIC_VPSRAW,
        m_vpsrld = ZYDIS_MNEMONIC_VPSRLD,
        m_vpsrldq = ZYDIS_MNEMONIC_VPSRLDQ,
        m_vpsrlq = ZYDIS_MNEMONIC_VPSRLQ,
        m_vpsrlvd = ZYDIS_MNEMONIC_VPSRLVD,
        m_vpsrlvq = ZYDIS_MNEMONIC_VPSRLVQ,
        m_vpsrlvw = ZYDIS_MNEMONIC_VPSRLVW,
        m_vpsrlw = ZYDIS_MNEMONIC_VPSRLW,
        m_vpsubb = ZYDIS_MNEMONIC_VPSUBB,
        m_vpsubd = ZYDIS_MNEMONIC_VPSUBD,
        m_vpsubq = ZYDIS_MNEMONIC_VPSUBQ,
        m_vpsubrd = ZYDIS_MNEMONIC_VPSUBRD,
        m_vpsubrsetbd = ZYDIS_MNEMONIC_VPSUBRSETBD,
        m_vpsubsb = ZYDIS_MNEMONIC_VPSUBSB,
        m_vpsubsetbd = ZYDIS_MNEMONIC_VPSUBSETBD,
        m_vpsubsw = ZYDIS_MNEMONIC_VPSUBSW,
        m_vpsubusb = ZYDIS_MNEMONIC_VPSUBUSB,
        m_vpsubusw = ZYDIS_MNEMONIC_VPSUBUSW,
        m_vpsubw = ZYDIS_MNEMONIC_VPSUBW,
        m_vpternlogd = ZYDIS_MNEMONIC_VPTERNLOGD,
        m_vpternlogq = ZYDIS_MNEMONIC_VPTERNLOGQ,
        m_vptest = ZYDIS_MNEMONIC_VPTEST,
        m_vptestmb = ZYDIS_MNEMONIC_VPTESTMB,
        m_vptestmd = ZYDIS_MNEMONIC_VPTESTMD,
        m_vptestmq = ZYDIS_MNEMONIC_VPTESTMQ,
        m_vptestmw = ZYDIS_MNEMONIC_VPTESTMW,
        m_vptestnmb = ZYDIS_MNEMONIC_VPTESTNMB,
        m_vptestnmd = ZYDIS_MNEMONIC_VPTESTNMD,
        m_vptestnmq = ZYDIS_MNEMONIC_VPTESTNMQ,
        m_vptestnmw = ZYDIS_MNEMONIC_VPTESTNMW,
        m_vpunpckhbw = ZYDIS_MNEMONIC_VPUNPCKHBW,
        m_vpunpckhdq = ZYDIS_MNEMONIC_VPUNPCKHDQ,
        m_vpunpckhqdq = ZYDIS_MNEMONIC_VPUNPCKHQDQ,
        m_vpunpckhwd = ZYDIS_MNEMONIC_VPUNPCKHWD,
        m_vpunpcklbw = ZYDIS_MNEMONIC_VPUNPCKLBW,
        m_vpunpckldq = ZYDIS_MNEMONIC_VPUNPCKLDQ,
        m_vpunpcklqdq = ZYDIS_MNEMONIC_VPUNPCKLQDQ,
        m_vpunpcklwd = ZYDIS_MNEMONIC_VPUNPCKLWD,
        m_vpxor = ZYDIS_MNEMONIC_VPXOR,
        m_vpxord = ZYDIS_MNEMONIC_VPXORD,
        m_vpxorq = ZYDIS_MNEMONIC_VPXORQ,
        m_vrangepd = ZYDIS_MNEMONIC_VRANGEPD,
        m_vrangeps = ZYDIS_MNEMONIC_VRANGEPS,
        m_vrangesd = ZYDIS_MNEMONIC_VRANGESD,
        m_vrangess = ZYDIS_MNEMONIC_VRANGESS,
        m_vrcp14pd = ZYDIS_MNEMONIC_VRCP14PD,
        m_vrcp14ps = ZYDIS_MNEMONIC_VRCP14PS,
        m_vrcp14sd = ZYDIS_MNEMONIC_VRCP14SD,
        m_vrcp14ss = ZYDIS_MNEMONIC_VRCP14SS,
        m_vrcp23ps = ZYDIS_MNEMONIC_VRCP23PS,
        m_vrcp28pd = ZYDIS_MNEMONIC_VRCP28PD,
        m_vrcp28ps = ZYDIS_MNEMONIC_VRCP28PS,
        m_vrcp28sd = ZYDIS_MNEMONIC_VRCP28SD,
        m_vrcp28ss = ZYDIS_MNEMONIC_VRCP28SS,
        m_vrcpph = ZYDIS_MNEMONIC_VRCPPH,
        m_vrcpps = ZYDIS_MNEMONIC_VRCPPS,
        m_vrcpsh = ZYDIS_MNEMONIC_VRCPSH,
        m_vrcpss = ZYDIS_MNEMONIC_VRCPSS,
        m_vreducepd = ZYDIS_MNEMONIC_VREDUCEPD,
        m_vreduceph = ZYDIS_MNEMONIC_VREDUCEPH,
        m_vreduceps = ZYDIS_MNEMONIC_VREDUCEPS,
        m_vreducesd = ZYDIS_MNEMONIC_VREDUCESD,
        m_vreducesh = ZYDIS_MNEMONIC_VREDUCESH,
        m_vreducess = ZYDIS_MNEMONIC_VREDUCESS,
        m_vrndfxpntpd = ZYDIS_MNEMONIC_VRNDFXPNTPD,
        m_vrndfxpntps = ZYDIS_MNEMONIC_VRNDFXPNTPS,
        m_vrndscalepd = ZYDIS_MNEMONIC_VRNDSCALEPD,
        m_vrndscaleph = ZYDIS_MNEMONIC_VRNDSCALEPH,
        m_vrndscaleps = ZYDIS_MNEMONIC_VRNDSCALEPS,
        m_vrndscalesd = ZYDIS_MNEMONIC_VRNDSCALESD,
        m_vrndscalesh = ZYDIS_MNEMONIC_VRNDSCALESH,
        m_vrndscaless = ZYDIS_MNEMONIC_VRNDSCALESS,
        m_vroundpd = ZYDIS_MNEMONIC_VROUNDPD,
        m_vroundps = ZYDIS_MNEMONIC_VROUNDPS,
        m_vroundsd = ZYDIS_MNEMONIC_VROUNDSD,
        m_vroundss = ZYDIS_MNEMONIC_VROUNDSS,
        m_vrsqrt14pd = ZYDIS_MNEMONIC_VRSQRT14PD,
        m_vrsqrt14ps = ZYDIS_MNEMONIC_VRSQRT14PS,
        m_vrsqrt14sd = ZYDIS_MNEMONIC_VRSQRT14SD,
        m_vrsqrt14ss = ZYDIS_MNEMONIC_VRSQRT14SS,
        m_vrsqrt23ps = ZYDIS_MNEMONIC_VRSQRT23PS,
        m_vrsqrt28pd = ZYDIS_MNEMONIC_VRSQRT28PD,
        m_vrsqrt28ps = ZYDIS_MNEMONIC_VRSQRT28PS,
        m_vrsqrt28sd = ZYDIS_MNEMONIC_VRSQRT28SD,
        m_vrsqrt28ss = ZYDIS_MNEMONIC_VRSQRT28SS,
        m_vrsqrtph = ZYDIS_MNEMONIC_VRSQRTPH,
        m_vrsqrtps = ZYDIS_MNEMONIC_VRSQRTPS,
        m_vrsqrtsh = ZYDIS_MNEMONIC_VRSQRTSH,
        m_vrsqrtss = ZYDIS_MNEMONIC_VRSQRTSS,
        m_vscalefpd = ZYDIS_MNEMONIC_VSCALEFPD,
        m_vscalefph = ZYDIS_MNEMONIC_VSCALEFPH,
        m_vscalefps = ZYDIS_MNEMONIC_VSCALEFPS,
        m_vscalefsd = ZYDIS_MNEMONIC_VSCALEFSD,
        m_vscalefsh = ZYDIS_MNEMONIC_VSCALEFSH,
        m_vscalefss = ZYDIS_MNEMONIC_VSCALEFSS,
        m_vscaleps = ZYDIS_MNEMONIC_VSCALEPS,
        m_vscatterdpd = ZYDIS_MNEMONIC_VSCATTERDPD,
        m_vscatterdps = ZYDIS_MNEMONIC_VSCATTERDPS,
        m_vscatterpf0dpd = ZYDIS_MNEMONIC_VSCATTERPF0DPD,
        m_vscatterpf0dps = ZYDIS_MNEMONIC_VSCATTERPF0DPS,
        m_vscatterpf0hintdpd = ZYDIS_MNEMONIC_VSCATTERPF0HINTDPD,
        m_vscatterpf0hintdps = ZYDIS_MNEMONIC_VSCATTERPF0HINTDPS,
        m_vscatterpf0qpd = ZYDIS_MNEMONIC_VSCATTERPF0QPD,
        m_vscatterpf0qps = ZYDIS_MNEMONIC_VSCATTERPF0QPS,
        m_vscatterpf1dpd = ZYDIS_MNEMONIC_VSCATTERPF1DPD,
        m_vscatterpf1dps = ZYDIS_MNEMONIC_VSCATTERPF1DPS,
        m_vscatterpf1qpd = ZYDIS_MNEMONIC_VSCATTERPF1QPD,
        m_vscatterpf1qps = ZYDIS_MNEMONIC_VSCATTERPF1QPS,
        m_vscatterqpd = ZYDIS_MNEMONIC_VSCATTERQPD,
        m_vscatterqps = ZYDIS_MNEMONIC_VSCATTERQPS,
        m_vsha512msg1 = ZYDIS_MNEMONIC_VSHA512MSG1,
        m_vsha512msg2 = ZYDIS_MNEMONIC_VSHA512MSG2,
        m_vsha512rnds2 = ZYDIS_MNEMONIC_VSHA512RNDS2,
        m_vshuff32x4 = ZYDIS_MNEMONIC_VSHUFF32X4,
        m_vshuff64x2 = ZYDIS_MNEMONIC_VSHUFF64X2,
        m_vshufi32x4 = ZYDIS_MNEMONIC_VSHUFI32X4,
        m_vshufi64x2 = ZYDIS_MNEMONIC_VSHUFI64X2,
        m_vshufpd = ZYDIS_MNEMONIC_VSHUFPD,
        m_vshufps = ZYDIS_MNEMONIC_VSHUFPS,
        m_vsm3msg1 = ZYDIS_MNEMONIC_VSM3MSG1,
        m_vsm3msg2 = ZYDIS_MNEMONIC_VSM3MSG2,
        m_vsm3rnds2 = ZYDIS_MNEMONIC_VSM3RNDS2,
        m_vsm4key4 = ZYDIS_MNEMONIC_VSM4KEY4,
        m_vsm4rnds4 = ZYDIS_MNEMONIC_VSM4RNDS4,
        m_vsqrtpd = ZYDIS_MNEMONIC_VSQRTPD,
        m_vsqrtph = ZYDIS_MNEMONIC_VSQRTPH,
        m_vsqrtps = ZYDIS_MNEMONIC_VSQRTPS,
        m_vsqrtsd = ZYDIS_MNEMONIC_VSQRTSD,
        m_vsqrtsh = ZYDIS_MNEMONIC_VSQRTSH,
        m_vsqrtss = ZYDIS_MNEMONIC_VSQRTSS,
        m_vstmxcsr = ZYDIS_MNEMONIC_VSTMXCSR,
        m_vsubpd = ZYDIS_MNEMONIC_VSUBPD,
        m_vsubph = ZYDIS_MNEMONIC_VSUBPH,
        m_vsubps = ZYDIS_MNEMONIC_VSUBPS,
        m_vsubrpd = ZYDIS_MNEMONIC_VSUBRPD,
        m_vsubrps = ZYDIS_MNEMONIC_VSUBRPS,
        m_vsubsd = ZYDIS_MNEMONIC_VSUBSD,
        m_vsubsh = ZYDIS_MNEMONIC_VSUBSH,
        m_vsubss = ZYDIS_MNEMONIC_VSUBSS,
        m_vtestpd = ZYDIS_MNEMONIC_VTESTPD,
        m_vtestps = ZYDIS_MNEMONIC_VTESTPS,
        m_vucomisd = ZYDIS_MNEMONIC_VUCOMISD,
        m_vucomish = ZYDIS_MNEMONIC_VUCOMISH,
        m_vucomiss = ZYDIS_MNEMONIC_VUCOMISS,
        m_vunpckhpd = ZYDIS_MNEMONIC_VUNPCKHPD,
        m_vunpckhps = ZYDIS_MNEMONIC_VUNPCKHPS,
        m_vunpcklpd = ZYDIS_MNEMONIC_VUNPCKLPD,
        m_vunpcklps = ZYDIS_MNEMONIC_VUNPCKLPS,
        m_vxorpd = ZYDIS_MNEMONIC_VXORPD,
        m_vxorps = ZYDIS_MNEMONIC_VXORPS,
        m_vzeroall = ZYDIS_MNEMONIC_VZEROALL,
        m_vzeroupper = ZYDIS_MNEMONIC_VZEROUPPER,
        m_wbinvd = ZYDIS_MNEMONIC_WBINVD,
        m_wrfsbase = ZYDIS_MNEMONIC_WRFSBASE,
        m_wrgsbase = ZYDIS_MNEMONIC_WRGSBASE,
        m_wrmsr = ZYDIS_MNEMONIC_WRMSR,
        m_wrmsrlist = ZYDIS_MNEMONIC_WRMSRLIST,
        m_wrmsrns = ZYDIS_MNEMONIC_WRMSRNS,
        m_wrpkru = ZYDIS_MNEMONIC_WRPKRU,
        m_wrssd = ZYDIS_MNEMONIC_WRSSD,
        m_wrssq = ZYDIS_MNEMONIC_WRSSQ,
        m_wrussd = ZYDIS_MNEMONIC_WRUSSD,
        m_wrussq = ZYDIS_MNEMONIC_WRUSSQ,
        m_xabort = ZYDIS_MNEMONIC_XABORT,
        m_xadd = ZYDIS_MNEMONIC_XADD,
        m_xbegin = ZYDIS_MNEMONIC_XBEGIN,
        m_xchg = ZYDIS_MNEMONIC_XCHG,
        m_xcrypt_cbc = ZYDIS_MNEMONIC_XCRYPT_CBC,
        m_xcrypt_cfb = ZYDIS_MNEMONIC_XCRYPT_CFB,
        m_xcrypt_ctr = ZYDIS_MNEMONIC_XCRYPT_CTR,
        m_xcrypt_ecb = ZYDIS_MNEMONIC_XCRYPT_ECB,
        m_xcrypt_ofb = ZYDIS_MNEMONIC_XCRYPT_OFB,
        m_xend = ZYDIS_MNEMONIC_XEND,
        m_xgetbv = ZYDIS_MNEMONIC_XGETBV,
        m_xlat = ZYDIS_MNEMONIC_XLAT,
        m_xor = ZYDIS_MNEMONIC_XOR,
        m_xorpd = ZYDIS_MNEMONIC_XORPD,
        m_xorps = ZYDIS_MNEMONIC_XORPS,
        m_xresldtrk = ZYDIS_MNEMONIC_XRESLDTRK,
        m_xrstor = ZYDIS_MNEMONIC_XRSTOR,
        m_xrstor64 = ZYDIS_MNEMONIC_XRSTOR64,
        m_xrstors = ZYDIS_MNEMONIC_XRSTORS,
        m_xrstors64 = ZYDIS_MNEMONIC_XRSTORS64,
        m_xsave = ZYDIS_MNEMONIC_XSAVE,
        m_xsave64 = ZYDIS_MNEMONIC_XSAVE64,
        m_xsavec = ZYDIS_MNEMONIC_XSAVEC,
        m_xsavec64 = ZYDIS_MNEMONIC_XSAVEC64,
        m_xsaveopt = ZYDIS_MNEMONIC_XSAVEOPT,
        m_xsaveopt64 = ZYDIS_MNEMONIC_XSAVEOPT64,
        m_xsaves = ZYDIS_MNEMONIC_XSAVES,
        m_xsaves64 = ZYDIS_MNEMONIC_XSAVES64,
        m_xsetbv = ZYDIS_MNEMONIC_XSETBV,
        m_xsha1 = ZYDIS_MNEMONIC_XSHA1,
        m_xsha256 = ZYDIS_MNEMONIC_XSHA256,
        m_xstore = ZYDIS_MNEMONIC_XSTORE,
        m_xsusldtrk = ZYDIS_MNEMONIC_XSUSLDTRK,
        m_xtest = ZYDIS_MNEMONIC_XTEST,
    };

    using zydis_reg_class = ZydisRegisterClass;

    enum reg_class
    {
        invalid = ZYDIS_REGCLASS_INVALID,
        gpr_64 = ZYDIS_REGCLASS_GPR64,
        gpr_32 = ZYDIS_REGCLASS_GPR32,
        gpr_16 = ZYDIS_REGCLASS_GPR16,
        gpr_8 = ZYDIS_REGCLASS_GPR8,
        mmx_64 = ZYDIS_REGCLASS_MMX,
        xmm_128 = ZYDIS_REGCLASS_XMM,
        ymm_256 = ZYDIS_REGCLASS_YMM,
        zmm_512 = ZYDIS_REGCLASS_ZMM,

        class_flags = ZYDIS_REGCLASS_FLAGS,
        class_ip = ZYDIS_REGCLASS_IP,


        seg = ZYDIS_REGCLASS_SEGMENT,
    };

    enum op_type
    {
        op_none = ZYDIS_OPERAND_TYPE_UNUSED,
        op_reg = ZYDIS_OPERAND_TYPE_REGISTER,
        op_mem = ZYDIS_OPERAND_TYPE_MEMORY,
        op_ptr = ZYDIS_OPERAND_TYPE_POINTER,
        op_imm = ZYDIS_OPERAND_TYPE_IMMEDIATE,
    };

    enum reg_size
    {
        empty = 0,
        bit_512 = 512,
        bit_256 = 256,
        bit_128 = 128,
        bit_64 = 64,
        bit_32 = 32,
        bit_16 = 16,
        bit_8 = 8,
    };
}
