---
title: Privacy Policy
description: An explanation of how the notion-enhancer interacts with your data.
order: 5
---

# Privacy Policy

This page describes the policies regarding the notion-enhancer's
use, collection, storage and disclosure of information.

## The notion-enhancer

> This Privacy Policy is effective as of the 19th of
> December, 2021 and applies to users of all versions of the
> notion-enhancer from v0.11.0 onwards until this Policy is
> next updated. Users will be asked to agree to this or
> any following policies whenever installing or updating
> a distribution of the notion-enhancer. Accordingly, updates to
> this Policy (excluding purely grammatical changes) will be made
> alongside notion-enhancer updates.

When the notion-enhancer menu is first opened, users will
be presented with a link to this Privacy Policy and asked
to agree to it to continue. By clicking "Accept & Continue",
users declare that they agree to any potential provision,
usage, collection, storage and disclosure of information
according to the terms below.

### Collection

The notion-enhancer will collect the following data
through its use:

- Configuration data (e.g. mod settings) will be collected when
  configuring the notion-enhancer through its menu
  interface.

- Notion metadata (e.g. block types, locations and IDs) and/or
  customisation values (e.g. titles, states) will be collected
  when using a mod (extension, theme or integration) that
  allows customisation of components of the Notion client.

Unless provided/collected as one of the above, no other data is
collected. Notion content remains safe and encrypted under
[Notion's privacy and security measures](https://www.notion.so/help/security-and-privacy).

### Usage

The notion-enhancer requires access to all collected data
and any/all Notion content the user loads for the following purposes:

- Observing changes to Notion.
- Performing enhancements upon the Notion client.
- Persisting user configuration for persistent enhancements.
- Updating Notion content via integrations.

### Storage

Information held by the notion-enhancer is stored locally
on the user's device in an unencrypted JSON format.

The notion-enhancer browser extension uses the browser-provided
local extension storage API to persist data
([Chromium](https://developer.chrome.com/docs/extensions/reference/storage/),
[Firefox](https://developer.mozilla.org/en-US/docs/Mozilla/Add-ons/WebExtensions/API/storage/local)).

The notion-enhancer desktop application modification saves
data into a hidden (but unprotected) file in the user's home folder:

- Windows: `C:\Users\UserName\.notion-enhancer`
- MacOS/Linux: `~/.notion-enhancer`

Backup, access to or deletion of data is available to the user at any time.

### Transmission

The notion-enhancer does not contain any telemetry features or transmit
any local files or data from the user's device. Certain features of the
notion-enhancer may send network requests to download non-executable assets
from external APIs (e.g. notification broadcasts, images). Basic data required
in order for a network response to be received may be sent within these requests,
e.g. the user's IP address.

## The website

> This Privacy Policy is effective as of the 19th of
> December, 2021 and applies to visitors of the
> notion-enhancer.github.io website. It may be updated
> at any time without notice.

By visiting this website visitors agree to any potential provision,
usage, collection, storage and disclosure of information
according to the terms below:

- Basic, non-personal/non-identifying status and usage data may be saved within
  visitors' browsers (e.g. the theme the website is set to).

- The notion-enhancer website is a static website hosted by the
  [GitHub Pages](https://pages.github.com/) service. [GitHub](https://github.com/)
  may collect visitors' Personal Information, including IP addresses,
  to comply with legal obligations and to maintain the security and integrity
  of the Website and the Service. The notion-enhancer authors do not have
  access to these logs.
